## How to contribute
 
Thank you for considering contributing to this distribution.
I welcome any contribution to DB::Object, including, but not limited to bug reports, feature requests, general comments, and patches.

Feel free to clone it from its gitlab repository at <https://gitlab.com/jackdeguest/DB-Object> and issue a pull request.

I am very flexible to collaboration and always eager to learn from others.

All contributions are assumed to be provided under the terms of [perl5 license](http://dev.perl.org/licenses/).

### Issues

File [an issue on bug tracker](https://gitlab.com/jackdeguest/DB-Object/issues) if you think you've found a bug. Please describe

1. How can it be reproduced

1. What was expected

1. What actually occurred

1. What version of the involved component

## Coding Style

I personally stick to the [Allman](https://en.wikipedia.org/wiki/Indentation_style#Allman_style) coding style. If you want to provide a patch to an existing piece of code, for clarity and consistency, it is best to stick to the existing coding style, whatever that may be. However, if you want to contribute a new module, you should feel free to use your coding style with comments to ensure readability and clarity.

Otherwise, I think it is reasonable to heed to [perl style recommendations](https://metacpan.org/pod/perlstyle).

## Versioning

The versioning style used is dotted decimal, such as `v0.1.1`

Please see [version](https://metacpan.org/pod/version) for more information.

## How to contact the author

You can reach me via e-mail <jdeguest@cpan.org>, or via [Telegram](https://t.me/jackdeguest), or [LinkedIn](https://www.linkedin.com/in/jackdeguest/)

## Issue Tracking

Issues are currently reported using CPAN [bug tracker](https://gitlab.com/jackdeguest/DB-Object/issues)

## More information

Please refer to the [README](https://metacpan.org/source/JDEGUEST/DB-Object-v1.3.0/README.md)

## Author

Jacques Deguest

