#!/usr/bin/perl

package eBay::API::XML::DataType::DomainHistogramType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. DomainHistogramType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 07/07/2008 17:42
# API Release Number: ... 571
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::DomainHistogramType

=head1 DESCRIPTION

Container for a list of Express departments, aisles, and/or products. 
Can contain zero, one, or multiple ExpressHistogramDepartmentType objects.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::DomainHistogramType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::ExpressHistogramDepartmentType;


my @gaProperties = ( [ 'Department', 'ns:ExpressHistogramDepartmentType', '1'
	     ,'eBay::API::XML::DataType::ExpressHistogramDepartmentType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setDepartment()

Contains item and product counts for a department, aisles, and/or Express product types.
Only returned when HistogramDetails is configured to retrieve histogram data.
Multiple Department nodes can be returned.

#    Argument: reference to an array  
                      of 'ns:ExpressHistogramDepartmentType'

=cut

sub setDepartment {
  my $self = shift;
  $self->{'Department'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getDepartment()

  Calls: GetSearchResultsExpress
  Returned: Conditionally

#    Returns: reference to an array  
                      of 'ns:ExpressHistogramDepartmentType'

=cut

sub getDepartment {
  my $self = shift;
  return $self->_getDataTypeArray('Department');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
