/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.spatial;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.TitleProperty;
import org.apache.sis.metadata.iso.spatial.AbstractGeolocationInformation;
import org.opengis.metadata.spatial.GCP;
import org.opengis.metadata.spatial.GCPCollection;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.util.InternationalString;

@TitleProperty(name="collectionName")
@XmlType(name="MI_GCPCollection_Type", propOrder={"collectionIdentification", "collectionName", "coordinateReferenceSystem", "GCPs"})
@XmlRootElement(name="MI_GCPCollection", namespace="http://www.isotc211.org/2005/gmi")
public class DefaultGCPCollection
extends AbstractGeolocationInformation
implements GCPCollection {
    private static final long serialVersionUID = -2757911443659529373L;
    private Integer collectionIdentification;
    private InternationalString collectionName;
    private ReferenceSystem coordinateReferenceSystem;
    private Collection<GCP> GCPs;

    public DefaultGCPCollection() {
    }

    public DefaultGCPCollection(GCPCollection gCPCollection) {
        super(gCPCollection);
        if (gCPCollection != null) {
            this.collectionIdentification = gCPCollection.getCollectionIdentification();
            this.collectionName = gCPCollection.getCollectionName();
            this.coordinateReferenceSystem = gCPCollection.getCoordinateReferenceSystem();
            this.GCPs = this.copyCollection(gCPCollection.getGCPs(), GCP.class);
        }
    }

    public static DefaultGCPCollection castOrCopy(GCPCollection gCPCollection) {
        if (gCPCollection == null || gCPCollection instanceof DefaultGCPCollection) {
            return (DefaultGCPCollection)gCPCollection;
        }
        return new DefaultGCPCollection(gCPCollection);
    }

    @Override
    @XmlElement(name="collectionIdentification", namespace="http://www.isotc211.org/2005/gmi", required=true)
    public Integer getCollectionIdentification() {
        return this.collectionIdentification;
    }

    public void setCollectionIdentification(Integer n) {
        this.checkWritePermission();
        this.collectionIdentification = n;
    }

    @Override
    @XmlElement(name="collectionName", namespace="http://www.isotc211.org/2005/gmi", required=true)
    public InternationalString getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(InternationalString internationalString) {
        this.checkWritePermission();
        this.collectionName = internationalString;
    }

    @Override
    @XmlElement(name="coordinateReferenceSystem", namespace="http://www.isotc211.org/2005/gmi", required=true)
    public ReferenceSystem getCoordinateReferenceSystem() {
        return this.coordinateReferenceSystem;
    }

    public void setCoordinateReferenceSystem(ReferenceSystem referenceSystem) {
        this.checkWritePermission();
        this.coordinateReferenceSystem = referenceSystem;
    }

    @XmlElement(name="gcp", namespace="http://www.isotc211.org/2005/gmi", required=true)
    public Collection<GCP> getGCPs() {
        this.GCPs = this.nonNullCollection(this.GCPs, GCP.class);
        return this.GCPs;
    }

    public void setGCPs(Collection<? extends GCP> collection) {
        this.GCPs = this.writeCollection(collection, this.GCPs, GCP.class);
    }
}

