use strict;
use warnings;

package WebService::Gitter;

use Moo;
use LWP::UserAgent;
use JSON::Tiny;
#ABSTRACT: An interface to Gitter REST API via Perl 5.
our $VERSION = '0.0.1'; # VERSION

has token_pass => (
    is       => 'ro',
    required => 1
);

my $ua = LWP::UserAgent->new;
$ua->timeout(12);
$ua->env_proxy;
my $url_rooms = 'https://api.gitter.im/v1/rooms';
my $url_user  = 'https://api.gitter.im/v1/user';

sub get_user_who {
    my $self = shift;

    my $req = $ua->get(
        'https://api.gitter.im/v1/user/me?access_token=' . $self->token_pass );

    if ( $req->is_success ) {
        print $req->decoded_content . "\n";
    }

    else {
        die $req->status_line;
    }
}

sub get_room_id {

    my ( $self, $uri ) = @_;
    my $req = HTTP::Request->new( POST => $url_rooms );
    $req->header( 'Content-Type'  => 'application/json' );
    $req->header( 'Accept'        => 'application/json' );
    $req->header( 'Authorization' => 'Bearer ' . $self->token_pass );

    my $post_body = JSON::Tiny::encode_json( { uri => $uri } );
    $req->content($post_body);

    my $resp = $ua->request($req);

    if ( $resp->is_success ) {
        my $message = $resp->decoded_content;
        print "Received reply: $message\n";
    }

    else {
        print "Error code: ",    $resp->code,    "\n";
        print "Error message: ", $resp->message, "\n";
    }
}

=pod

=encoding UTF-8

=head1 NAME

WebService::Gitter - An interface to Gitter REST API via Perl 5.

=head1 VERSION

version 0.0.1

=head1 SYNOPSIS

	use WebService::Gitter;

	my $serv = WebService::Gitter->new(token_pass => 'mytoken123');

	# Prints the info about the authenticated user
	$serv->get_user_who;

	# Prints the info about Gitter room ('Room name')
	$serv->get_room_ID('FreeCodeCamp/FreeCodeCamp');

=head1 DESCRIPTION

An interface to Gitter REST API (v1). Currently only supports two method (see SYNOPSIS)

=head1 AUTHOR

faraco <skelic3@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by faraco.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__END__


1;
