#!/usr/bin/perl

package eBay::API::XML::Call::GetProductFinder::GetProductFinderResponseType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetProductFinderResponseType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetProductFinder::GetProductFinderResponseType

=head1 DESCRIPTION

For a category that supports product finders, GetProductFinder returns an XML string
that decribes the attributes a seller can use to form a query when searching for
Pre-filled Item Information, or attributes that can be used to search for listed items.
Specifically, it retrieves data that you use to construct valid "product finder" queries
(queries against multiple attributes).
Use the results in combination with GetProductFinderXSL to render the Product Finder
in a graphical user interface.
See the Developer's Guide for an overview of Pre-filled Item Information and details about
searching for catalog products and for information about searching for listed items.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetProductFinder::GetProductFinderResponseType inherits from the L<eBay::API::XML::ResponseDataType> class

=cut

use eBay::API::XML::ResponseDataType;
our @ISA = ("eBay::API::XML::ResponseDataType");



my @gaProperties = ( [ 'AttributeSystemVersion', 'xs:string', '', '', '' ]
	, [ 'ProductFinderData', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::ResponseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::ResponseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAttributeSystemVersion()

Current version of the product search page data for the site.
This value changes each time changes are made to the search page data.
The current version value is not necessarily greater than the previous
value. Therefore, when comparing versions, only compare whether the
value has changed.

#    Argument: 'xs:string'

=cut

sub setAttributeSystemVersion {
  my $self = shift;
  $self->{'AttributeSystemVersion'} = shift
}

=head2 getAttributeSystemVersion()

  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll
#    Returns: 'xs:string'

=cut

sub getAttributeSystemVersion {
  my $self = shift;
  return $self->{'AttributeSystemVersion'};
}


=head2 setProductFinderData()

A string containing a list of search attributes that can be used in a
"Product Finder" style query, along with related meta-data. The meta-data
specifies possible values of each attribute, the logic for presenting
attributes to a user, and rules for validating the user's selections. For
backward compatibility, this data is in the same XML format that was used
in the Legacy XML API so that you can apply the same Product Finder XSL
stylesheet to it. That is, individual elements are not described using the
new eBay XML schema format. For information about each element in the
ProductFinderData string, see the product finder model documentation in
the eBay Web Services guide (see links below).<br>
<br>
Because this is returned as a string, the XML markup is escaped with
character entity references (e.g., &amp;lt;eBay&amp;gt;&amp;lt;ProductFinders&amp;gt;...).
See the appendices in the eBay Web Services guide for general information about
string data types.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AttrGPF
Title: Retrieving Product Finder Meta-Data
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AttrPFModel
Title: The Product Finder Meta-Data Model
, URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=DataTypes
Title: Data Types


#    Argument: 'xs:string'

=cut

sub setProductFinderData {
  my $self = shift;
  $self->{'ProductFinderData'} = shift
}

=head2 getProductFinderData()

  Returned: Conditionally
  Details: DetailLevel: ReturnAll
#    Returns: 'xs:string'

=cut

sub getProductFinderData {
  my $self = shift;
  return $self->{'ProductFinderData'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
