#!/usr/bin/perl

package eBay::API::XML::DataType::SearchStandingDashboardType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. SearchStandingDashboardType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::SearchStandingDashboardType

=head1 DESCRIPTION

Provides information about the visibility level you've earned for your eBay listings. 
When you have a better search standing, your listings may receive higher 
placement in Best Match search results.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::SearchStandingDashboardType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::Enum::SearchStandingStatusCodeType;


my @gaProperties = ( [ 'Status', 'ns:SearchStandingStatusCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::SearchStandingStatusCodeType', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setStatus()

The search standing that you have earned. 
To qualify for a Standard or Raised search standing, 
make sure your ratings meet or exceed the required minimum levels in 
buyer satisfaction (see BuyerSatisfaction.Status in this call) and 
detailed seller ratings (see GetFeedback).

SeeLink: URL: GetFeedback.html#Response.FeedbackSummary.SellerRatingSummaryArray
Title: (GetFeedback) FeedbackSummary.SellerRatingSummaryArray

#    Argument: 'ns:SearchStandingStatusCodeType'

=cut

sub setStatus {
  my $self = shift;
  $self->{'Status'} = shift
}

=head2 getStatus()

  Calls: GetSellerDashboard
  Returned: Conditionally

#    Returns: 'ns:SearchStandingStatusCodeType'

=cut

sub getStatus {
  my $self = shift;
  return $self->{'Status'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
