use strict;
use warnings;
use Test::More tests => 3;

use HTML::FormFu;
use lib 't/lib';
use DBICTestLib 'new_db';
use MySchema;

new_db();

my $form = HTML::FormFu->new;

$form->load_config_file('t/deprecated-defaults_from_model/belongs_to_lookup_table.yml');

my $schema = MySchema->connect('dbi:SQLite:dbname=t/test.db');

my $rs = $schema->resultset('Master');

# Fake submitted form
$form->process( {
        "id"       => 3,
        "text_col" => 'a',
        'type'     => '1',
        'type2_id' => '1',
    } );

my $master;
{

    # insert some entries we'll ignore, so our rels don't have same ids
    # test id 1
    my $t1 = $rs->create( { text_col => 'xxx' } );

    # test id 2
    my $t2 = $rs->create( { text_col => 'yyy' } );

    # should get master id 3
    $master = $rs->create( { text_col => 'b', type => 2, type2_id => 2 } );

    {
        my $warnings;
        local $SIG{ __WARN__ } = sub { $warnings++ };

        $form->save_to_model($master);
        ok( $warnings, 'warning thrown' );
    }
}

{
    my $row = $rs->find( $master->id );

    is( $row->type->id, '1' );
    is( $row->type2_id, '1' );

}

