#define PERL_constant_NOTFOUND	1
#define PERL_constant_NOTDEF	2
#define PERL_constant_ISIV	3
#define PERL_constant_ISNO	4
#define PERL_constant_ISNV	5
#define PERL_constant_ISPV	6
#define PERL_constant_ISPVN	7
#define PERL_constant_ISSV	8
#define PERL_constant_ISUNDEF	9
#define PERL_constant_ISUV	10
#define PERL_constant_ISYES	11

#ifndef NVTYPE
typedef double NV; /* 5.6 and later define NVTYPE, and typedef NV to it.  */
#endif
#ifndef aTHX_
#define aTHX_ /* 5.6 or later define this for threading support.  */
#endif
#ifndef pTHX_
#define pTHX_ /* 5.6 or later define this for threading support.  */
#endif

static int
constant_4 (pTHX_ const char *name, IV *iv_return) {
  /* When generated this function returned values for the list of names given
     here.  However, subsequent manual editing may have added or removed some.
     GL_Q GL_R GL_S GL_T */
  /* Offset 3 gives the best switch position.  */
  switch (name[3]) {
  case 'Q':
    if (memEQ(name, "GL_", 3)) {
    /*                  Q     */
#ifdef GL_Q
      *iv_return = (IV)GL_Q;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'R':
    if (memEQ(name, "GL_", 3)) {
    /*                  R     */
#ifdef GL_R
      *iv_return = (IV)GL_R;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'S':
    if (memEQ(name, "GL_", 3)) {
    /*                  S     */
#ifdef GL_S
      *iv_return = (IV)GL_S;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'T':
    if (memEQ(name, "GL_", 3)) {
    /*                  T     */
#ifdef GL_T
      *iv_return = (IV)GL_T;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  }
  return PERL_constant_NOTFOUND;
}

static int
constant_5 (pTHX_ const char *name, IV *iv_return) {
  /* When generated this function returned values for the list of names given
     here.  However, subsequent manual editing may have added or removed some.
     GL_2D GL_3D GL_CW GL_OR GL_R8 GL_RG */
  /* Offset 4 gives the best switch position.  */
  switch (name[4]) {
  case '8':
    if (memEQ(name, "GL_R", 4)) {
    /*                   8     */
#ifdef GL_R8
      *iv_return = (IV)GL_R8;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'D':
    if (memEQ(name, "GL_2", 4)) {
    /*                   D     */
#ifdef GL_2D
      *iv_return = (IV)GL_2D;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_3", 4)) {
    /*                   D     */
#ifdef GL_3D
      *iv_return = (IV)GL_3D;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'G':
    if (memEQ(name, "GL_R", 4)) {
    /*                   G     */
#ifdef GL_RG
      *iv_return = (IV)GL_RG;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'R':
    if (memEQ(name, "GL_O", 4)) {
    /*                   R     */
#ifdef GL_OR
      *iv_return = (IV)GL_OR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'W':
    if (memEQ(name, "GL_C", 4)) {
    /*                   W     */
#ifdef GL_CW
      *iv_return = (IV)GL_CW;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  }
  return PERL_constant_NOTFOUND;
}

static int
constant_6 (pTHX_ const char *name, IV *iv_return) {
  /* When generated this function returned values for the list of names given
     here.  However, subsequent manual editing may have added or removed some.
     GL_ADD GL_AND GL_BGR GL_CCW GL_EXP GL_FOG GL_INT GL_MAX GL_MIN GL_NOR
     GL_ONE GL_R16 GL_R8I GL_RED GL_RG8 GL_RGB GL_SET GL_V2F GL_V3F GL_XOR */
  /* Offset 5 gives the best switch position.  */
  switch (name[5]) {
  case '6':
    if (memEQ(name, "GL_R1", 5)) {
    /*                    6     */
#ifdef GL_R16
      *iv_return = (IV)GL_R16;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '8':
    if (memEQ(name, "GL_RG", 5)) {
    /*                    8     */
#ifdef GL_RG8
      *iv_return = (IV)GL_RG8;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'B':
    if (memEQ(name, "GL_RG", 5)) {
    /*                    B     */
#ifdef GL_RGB
      *iv_return = (IV)GL_RGB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'D':
    if (memEQ(name, "GL_AD", 5)) {
    /*                    D     */
#ifdef GL_ADD
      *iv_return = (IV)GL_ADD;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_AN", 5)) {
    /*                    D     */
#ifdef GL_AND
      *iv_return = (IV)GL_AND;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RE", 5)) {
    /*                    D     */
#ifdef GL_RED
      *iv_return = (IV)GL_RED;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'E':
    if (memEQ(name, "GL_ON", 5)) {
    /*                    E     */
#ifdef GL_ONE
      *iv_return = (IV)GL_ONE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'F':
    if (memEQ(name, "GL_V2", 5)) {
    /*                    F     */
#ifdef GL_V2F
      *iv_return = (IV)GL_V2F;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_V3", 5)) {
    /*                    F     */
#ifdef GL_V3F
      *iv_return = (IV)GL_V3F;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'G':
    if (memEQ(name, "GL_FO", 5)) {
    /*                    G     */
#ifdef GL_FOG
      *iv_return = (IV)GL_FOG;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'I':
    if (memEQ(name, "GL_R8", 5)) {
    /*                    I     */
#ifdef GL_R8I
      *iv_return = (IV)GL_R8I;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'N':
    if (memEQ(name, "GL_MI", 5)) {
    /*                    N     */
#ifdef GL_MIN
      *iv_return = (IV)GL_MIN;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'P':
    if (memEQ(name, "GL_EX", 5)) {
    /*                    P     */
#ifdef GL_EXP
      *iv_return = (IV)GL_EXP;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'R':
    if (memEQ(name, "GL_BG", 5)) {
    /*                    R     */
#ifdef GL_BGR
      *iv_return = (IV)GL_BGR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NO", 5)) {
    /*                    R     */
#ifdef GL_NOR
      *iv_return = (IV)GL_NOR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_XO", 5)) {
    /*                    R     */
#ifdef GL_XOR
      *iv_return = (IV)GL_XOR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'T':
    if (memEQ(name, "GL_IN", 5)) {
    /*                    T     */
#ifdef GL_INT
      *iv_return = (IV)GL_INT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SE", 5)) {
    /*                    T     */
#ifdef GL_SET
      *iv_return = (IV)GL_SET;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'W':
    if (memEQ(name, "GL_CC", 5)) {
    /*                    W     */
#ifdef GL_CCW
      *iv_return = (IV)GL_CCW;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'X':
    if (memEQ(name, "GL_MA", 5)) {
    /*                    X     */
#ifdef GL_MAX
      *iv_return = (IV)GL_MAX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  }
  return PERL_constant_NOTFOUND;
}

static int
constant_7 (pTHX_ const char *name, IV *iv_return) {
  /* When generated this function returned values for the list of names given
     here.  However, subsequent manual editing may have added or removed some.
     GLEW_OK GL_AUX0 GL_AUX1 GL_AUX2 GL_AUX3 GL_BACK GL_BGRA GL_BLUE GL_BOOL
     GL_BYTE GL_COPY GL_DECR GL_EXP2 GL_FILL GL_FLAT GL_INCR GL_KEEP GL_LEFT
     GL_LESS GL_LINE GL_LOAD GL_MULT GL_NAND GL_NONE GL_NOOP GL_R16F GL_R16I
     GL_R32F GL_R32I GL_R8UI GL_RG16 GL_RG8I GL_RGB4 GL_RGB5 GL_RGB8 GL_RGBA
     GL_SRGB GL_TRUE GL_TYPE GL_ZERO */
  /* Offset 6 gives the best switch position.  */
  switch (name[6]) {
  case '0':
    if (memEQ(name, "GL_AUX", 6)) {
    /*                     0     */
#ifdef GL_AUX0
      *iv_return = (IV)GL_AUX0;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '1':
    if (memEQ(name, "GL_AUX", 6)) {
    /*                     1     */
#ifdef GL_AUX1
      *iv_return = (IV)GL_AUX1;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '2':
    if (memEQ(name, "GL_AUX", 6)) {
    /*                     2     */
#ifdef GL_AUX2
      *iv_return = (IV)GL_AUX2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXP", 6)) {
    /*                     2     */
#ifdef GL_EXP2
      *iv_return = (IV)GL_EXP2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '3':
    if (memEQ(name, "GL_AUX", 6)) {
    /*                     3     */
#ifdef GL_AUX3
      *iv_return = (IV)GL_AUX3;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '4':
    if (memEQ(name, "GL_RGB", 6)) {
    /*                     4     */
#ifdef GL_RGB4
      *iv_return = (IV)GL_RGB4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '5':
    if (memEQ(name, "GL_RGB", 6)) {
    /*                     5     */
#ifdef GL_RGB5
      *iv_return = (IV)GL_RGB5;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '6':
    if (memEQ(name, "GL_RG1", 6)) {
    /*                     6     */
#ifdef GL_RG16
      *iv_return = (IV)GL_RG16;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '8':
    if (memEQ(name, "GL_RGB", 6)) {
    /*                     8     */
#ifdef GL_RGB8
      *iv_return = (IV)GL_RGB8;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'A':
    if (memEQ(name, "GL_BGR", 6)) {
    /*                     A     */
#ifdef GL_BGRA
      *iv_return = (IV)GL_BGRA;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGB", 6)) {
    /*                     A     */
#ifdef GL_RGBA
      *iv_return = (IV)GL_RGBA;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'B':
    if (memEQ(name, "GL_SRG", 6)) {
    /*                     B     */
#ifdef GL_SRGB
      *iv_return = (IV)GL_SRGB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'D':
    if (memEQ(name, "GL_LOA", 6)) {
    /*                     D     */
#ifdef GL_LOAD
      *iv_return = (IV)GL_LOAD;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NAN", 6)) {
    /*                     D     */
#ifdef GL_NAND
      *iv_return = (IV)GL_NAND;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'E':
    if (memEQ(name, "GL_BLU", 6)) {
    /*                     E     */
#ifdef GL_BLUE
      *iv_return = (IV)GL_BLUE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_BYT", 6)) {
    /*                     E     */
#ifdef GL_BYTE
      *iv_return = (IV)GL_BYTE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LIN", 6)) {
    /*                     E     */
#ifdef GL_LINE
      *iv_return = (IV)GL_LINE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NON", 6)) {
    /*                     E     */
#ifdef GL_NONE
      *iv_return = (IV)GL_NONE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TRU", 6)) {
    /*                     E     */
#ifdef GL_TRUE
      *iv_return = (IV)GL_TRUE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TYP", 6)) {
    /*                     E     */
#ifdef GL_TYPE
      *iv_return = (IV)GL_TYPE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'F':
    if (memEQ(name, "GL_R16", 6)) {
    /*                     F     */
#ifdef GL_R16F
      *iv_return = (IV)GL_R16F;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_R32", 6)) {
    /*                     F     */
#ifdef GL_R32F
      *iv_return = (IV)GL_R32F;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'I':
    if (memEQ(name, "GL_R16", 6)) {
    /*                     I     */
#ifdef GL_R16I
      *iv_return = (IV)GL_R16I;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_R32", 6)) {
    /*                     I     */
#ifdef GL_R32I
      *iv_return = (IV)GL_R32I;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_R8U", 6)) {
    /*                     I     */
#ifdef GL_R8UI
      *iv_return = (IV)GL_R8UI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RG8", 6)) {
    /*                     I     */
#ifdef GL_RG8I
      *iv_return = (IV)GL_RG8I;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'K':
    if (memEQ(name, "GLEW_O", 6)) {
    /*                     K     */
#ifdef GLEW_OK
      *iv_return = (IV)GLEW_OK;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_BAC", 6)) {
    /*                     K     */
#ifdef GL_BACK
      *iv_return = (IV)GL_BACK;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'L':
    if (memEQ(name, "GL_BOO", 6)) {
    /*                     L     */
#ifdef GL_BOOL
      *iv_return = (IV)GL_BOOL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FIL", 6)) {
    /*                     L     */
#ifdef GL_FILL
      *iv_return = (IV)GL_FILL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'O':
    if (memEQ(name, "GL_ZER", 6)) {
    /*                     O     */
#ifdef GL_ZERO
      *iv_return = (IV)GL_ZERO;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'P':
    if (memEQ(name, "GL_KEE", 6)) {
    /*                     P     */
#ifdef GL_KEEP
      *iv_return = (IV)GL_KEEP;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NOO", 6)) {
    /*                     P     */
#ifdef GL_NOOP
      *iv_return = (IV)GL_NOOP;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'R':
    if (memEQ(name, "GL_DEC", 6)) {
    /*                     R     */
#ifdef GL_DECR
      *iv_return = (IV)GL_DECR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INC", 6)) {
    /*                     R     */
#ifdef GL_INCR
      *iv_return = (IV)GL_INCR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'S':
    if (memEQ(name, "GL_LES", 6)) {
    /*                     S     */
#ifdef GL_LESS
      *iv_return = (IV)GL_LESS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'T':
    if (memEQ(name, "GL_FLA", 6)) {
    /*                     T     */
#ifdef GL_FLAT
      *iv_return = (IV)GL_FLAT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LEF", 6)) {
    /*                     T     */
#ifdef GL_LEFT
      *iv_return = (IV)GL_LEFT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MUL", 6)) {
    /*                     T     */
#ifdef GL_MULT
      *iv_return = (IV)GL_MULT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'Y':
    if (memEQ(name, "GL_COP", 6)) {
    /*                     Y     */
#ifdef GL_COPY
      *iv_return = (IV)GL_COPY;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  }
  return PERL_constant_NOTFOUND;
}

static int
constant_8 (pTHX_ const char *name, IV *iv_return) {
  /* When generated this function returned values for the list of names given
     here.  However, subsequent manual editing may have added or removed some.
     GL_ACCUM GL_ALPHA GL_BLEND GL_CLAMP GL_CLEAR GL_COEFF GL_COLOR GL_DECAL
     GL_DEPTH GL_EQUAL GL_EQUIV GL_FALSE GL_FIXED GL_FLOAT GL_FRONT GL_GREEN
     GL_INDEX GL_LINES GL_NEVER GL_ORDER GL_POINT GL_QUADS GL_QUERY GL_R16UI
     GL_R32UI GL_RG16F GL_RG16I GL_RG32F GL_RG32I GL_RG8UI GL_RGB10 GL_RGB12
     GL_RGB16 GL_RGB8I GL_RGBA2 GL_RGBA4 GL_RGBA8 GL_RIGHT GL_SHORT GL_SRGB8
     GL_W_EXT GL_X_EXT GL_Y_EXT GL_Z_EXT */
  /* Offset 7 gives the best switch position.  */
  switch (name[7]) {
  case '0':
    if (memEQ(name, "GL_RGB1", 7)) {
    /*                      0     */
#ifdef GL_RGB10
      *iv_return = (IV)GL_RGB10;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '2':
    if (memEQ(name, "GL_RGB1", 7)) {
    /*                      2     */
#ifdef GL_RGB12
      *iv_return = (IV)GL_RGB12;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGBA", 7)) {
    /*                      2     */
#ifdef GL_RGBA2
      *iv_return = (IV)GL_RGBA2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '4':
    if (memEQ(name, "GL_RGBA", 7)) {
    /*                      4     */
#ifdef GL_RGBA4
      *iv_return = (IV)GL_RGBA4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '6':
    if (memEQ(name, "GL_RGB1", 7)) {
    /*                      6     */
#ifdef GL_RGB16
      *iv_return = (IV)GL_RGB16;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '8':
    if (memEQ(name, "GL_RGBA", 7)) {
    /*                      8     */
#ifdef GL_RGBA8
      *iv_return = (IV)GL_RGBA8;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SRGB", 7)) {
    /*                      8     */
#ifdef GL_SRGB8
      *iv_return = (IV)GL_SRGB8;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'A':
    if (memEQ(name, "GL_ALPH", 7)) {
    /*                      A     */
#ifdef GL_ALPHA
      *iv_return = (IV)GL_ALPHA;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'D':
    if (memEQ(name, "GL_BLEN", 7)) {
    /*                      D     */
#ifdef GL_BLEND
      *iv_return = (IV)GL_BLEND;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FIXE", 7)) {
    /*                      D     */
#ifdef GL_FIXED
      *iv_return = (IV)GL_FIXED;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'E':
    if (memEQ(name, "GL_FALS", 7)) {
    /*                      E     */
#ifdef GL_FALSE
      *iv_return = (IV)GL_FALSE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'F':
    if (memEQ(name, "GL_COEF", 7)) {
    /*                      F     */
#ifdef GL_COEFF
      *iv_return = (IV)GL_COEFF;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RG16", 7)) {
    /*                      F     */
#ifdef GL_RG16F
      *iv_return = (IV)GL_RG16F;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RG32", 7)) {
    /*                      F     */
#ifdef GL_RG32F
      *iv_return = (IV)GL_RG32F;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'H':
    if (memEQ(name, "GL_DEPT", 7)) {
    /*                      H     */
#ifdef GL_DEPTH
      *iv_return = (IV)GL_DEPTH;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'I':
    if (memEQ(name, "GL_R16U", 7)) {
    /*                      I     */
#ifdef GL_R16UI
      *iv_return = (IV)GL_R16UI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_R32U", 7)) {
    /*                      I     */
#ifdef GL_R32UI
      *iv_return = (IV)GL_R32UI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RG16", 7)) {
    /*                      I     */
#ifdef GL_RG16I
      *iv_return = (IV)GL_RG16I;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RG32", 7)) {
    /*                      I     */
#ifdef GL_RG32I
      *iv_return = (IV)GL_RG32I;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RG8U", 7)) {
    /*                      I     */
#ifdef GL_RG8UI
      *iv_return = (IV)GL_RG8UI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGB8", 7)) {
    /*                      I     */
#ifdef GL_RGB8I
      *iv_return = (IV)GL_RGB8I;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'L':
    if (memEQ(name, "GL_DECA", 7)) {
    /*                      L     */
#ifdef GL_DECAL
      *iv_return = (IV)GL_DECAL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EQUA", 7)) {
    /*                      L     */
#ifdef GL_EQUAL
      *iv_return = (IV)GL_EQUAL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'M':
    if (memEQ(name, "GL_ACCU", 7)) {
    /*                      M     */
#ifdef GL_ACCUM
      *iv_return = (IV)GL_ACCUM;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'N':
    if (memEQ(name, "GL_GREE", 7)) {
    /*                      N     */
#ifdef GL_GREEN
      *iv_return = (IV)GL_GREEN;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'P':
    if (memEQ(name, "GL_CLAM", 7)) {
    /*                      P     */
#ifdef GL_CLAMP
      *iv_return = (IV)GL_CLAMP;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'R':
    if (memEQ(name, "GL_CLEA", 7)) {
    /*                      R     */
#ifdef GL_CLEAR
      *iv_return = (IV)GL_CLEAR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLO", 7)) {
    /*                      R     */
#ifdef GL_COLOR
      *iv_return = (IV)GL_COLOR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NEVE", 7)) {
    /*                      R     */
#ifdef GL_NEVER
      *iv_return = (IV)GL_NEVER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ORDE", 7)) {
    /*                      R     */
#ifdef GL_ORDER
      *iv_return = (IV)GL_ORDER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'S':
    if (memEQ(name, "GL_LINE", 7)) {
    /*                      S     */
#ifdef GL_LINES
      *iv_return = (IV)GL_LINES;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_QUAD", 7)) {
    /*                      S     */
#ifdef GL_QUADS
      *iv_return = (IV)GL_QUADS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'T':
    if (memEQ(name, "GL_FLOA", 7)) {
    /*                      T     */
#ifdef GL_FLOAT
      *iv_return = (IV)GL_FLOAT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FRON", 7)) {
    /*                      T     */
#ifdef GL_FRONT
      *iv_return = (IV)GL_FRONT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_POIN", 7)) {
    /*                      T     */
#ifdef GL_POINT
      *iv_return = (IV)GL_POINT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RIGH", 7)) {
    /*                      T     */
#ifdef GL_RIGHT
      *iv_return = (IV)GL_RIGHT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SHOR", 7)) {
    /*                      T     */
#ifdef GL_SHORT
      *iv_return = (IV)GL_SHORT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_W_EX", 7)) {
    /*                      T     */
#ifdef GL_W_EXT
      *iv_return = (IV)GL_W_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_X_EX", 7)) {
    /*                      T     */
#ifdef GL_X_EXT
      *iv_return = (IV)GL_X_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_Y_EX", 7)) {
    /*                      T     */
#ifdef GL_Y_EXT
      *iv_return = (IV)GL_Y_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_Z_EX", 7)) {
    /*                      T     */
#ifdef GL_Z_EXT
      *iv_return = (IV)GL_Z_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'V':
    if (memEQ(name, "GL_EQUI", 7)) {
    /*                      V     */
#ifdef GL_EQUIV
      *iv_return = (IV)GL_EQUIV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'X':
    if (memEQ(name, "GL_INDE", 7)) {
    /*                      X     */
#ifdef GL_INDEX
      *iv_return = (IV)GL_INDEX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'Y':
    if (memEQ(name, "GL_QUER", 7)) {
    /*                      Y     */
#ifdef GL_QUERY
      *iv_return = (IV)GL_QUERY;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  }
  return PERL_constant_NOTFOUND;
}

static int
constant_9 (pTHX_ const char *name, IV *iv_return) {
  /* When generated this function returned values for the list of names given
     here.  However, subsequent manual editing may have added or removed some.
     GL_ALPHA4 GL_ALPHA8 GL_ALWAYS GL_BITMAP GL_BUFFER GL_DITHER GL_DOMAIN
     GL_DOUBLE GL_DST_NV GL_FILTER GL_GEQUAL GL_INVERT GL_LEQUAL GL_LIGHT0
     GL_LIGHT1 GL_LIGHT2 GL_LIGHT3 GL_LIGHT4 GL_LIGHT5 GL_LIGHT6 GL_LIGHT7
     GL_LINEAR GL_MINMAX GL_MIPMAP GL_NICEST GL_OFFSET GL_POINTS GL_REDUCE
     GL_RED_NV GL_RENDER GL_REPEAT GL_RETURN GL_RG16UI GL_RG32UI GL_RGB16F
     GL_RGB16I GL_RGB32F GL_RGB32I GL_RGB565 GL_RGB8UI GL_RGBA12 GL_RGBA16
     GL_RGBA8I GL_SELECT GL_SHADER GL_SMOOTH GL_SRC_NV GL_STEREO GL_VENDOR
     GL_XOR_NV GL_ZOOM_X GL_ZOOM_Y */
  /* Offset 8 gives the best switch position.  */
  switch (name[8]) {
  case '0':
    if (memEQ(name, "GL_LIGHT", 8)) {
    /*                       0     */
#ifdef GL_LIGHT0
      *iv_return = (IV)GL_LIGHT0;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '1':
    if (memEQ(name, "GL_LIGHT", 8)) {
    /*                       1     */
#ifdef GL_LIGHT1
      *iv_return = (IV)GL_LIGHT1;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '2':
    if (memEQ(name, "GL_LIGHT", 8)) {
    /*                       2     */
#ifdef GL_LIGHT2
      *iv_return = (IV)GL_LIGHT2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGBA1", 8)) {
    /*                       2     */
#ifdef GL_RGBA12
      *iv_return = (IV)GL_RGBA12;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '3':
    if (memEQ(name, "GL_LIGHT", 8)) {
    /*                       3     */
#ifdef GL_LIGHT3
      *iv_return = (IV)GL_LIGHT3;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '4':
    if (memEQ(name, "GL_ALPHA", 8)) {
    /*                       4     */
#ifdef GL_ALPHA4
      *iv_return = (IV)GL_ALPHA4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LIGHT", 8)) {
    /*                       4     */
#ifdef GL_LIGHT4
      *iv_return = (IV)GL_LIGHT4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '5':
    if (memEQ(name, "GL_LIGHT", 8)) {
    /*                       5     */
#ifdef GL_LIGHT5
      *iv_return = (IV)GL_LIGHT5;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGB56", 8)) {
    /*                       5     */
#ifdef GL_RGB565
      *iv_return = (IV)GL_RGB565;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '6':
    if (memEQ(name, "GL_LIGHT", 8)) {
    /*                       6     */
#ifdef GL_LIGHT6
      *iv_return = (IV)GL_LIGHT6;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGBA1", 8)) {
    /*                       6     */
#ifdef GL_RGBA16
      *iv_return = (IV)GL_RGBA16;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '7':
    if (memEQ(name, "GL_LIGHT", 8)) {
    /*                       7     */
#ifdef GL_LIGHT7
      *iv_return = (IV)GL_LIGHT7;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '8':
    if (memEQ(name, "GL_ALPHA", 8)) {
    /*                       8     */
#ifdef GL_ALPHA8
      *iv_return = (IV)GL_ALPHA8;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'E':
    if (memEQ(name, "GL_DOUBL", 8)) {
    /*                       E     */
#ifdef GL_DOUBLE
      *iv_return = (IV)GL_DOUBLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_REDUC", 8)) {
    /*                       E     */
#ifdef GL_REDUCE
      *iv_return = (IV)GL_REDUCE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'F':
    if (memEQ(name, "GL_RGB16", 8)) {
    /*                       F     */
#ifdef GL_RGB16F
      *iv_return = (IV)GL_RGB16F;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGB32", 8)) {
    /*                       F     */
#ifdef GL_RGB32F
      *iv_return = (IV)GL_RGB32F;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'H':
    if (memEQ(name, "GL_SMOOT", 8)) {
    /*                       H     */
#ifdef GL_SMOOTH
      *iv_return = (IV)GL_SMOOTH;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'I':
    if (memEQ(name, "GL_RG16U", 8)) {
    /*                       I     */
#ifdef GL_RG16UI
      *iv_return = (IV)GL_RG16UI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RG32U", 8)) {
    /*                       I     */
#ifdef GL_RG32UI
      *iv_return = (IV)GL_RG32UI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGB16", 8)) {
    /*                       I     */
#ifdef GL_RGB16I
      *iv_return = (IV)GL_RGB16I;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGB32", 8)) {
    /*                       I     */
#ifdef GL_RGB32I
      *iv_return = (IV)GL_RGB32I;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGB8U", 8)) {
    /*                       I     */
#ifdef GL_RGB8UI
      *iv_return = (IV)GL_RGB8UI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGBA8", 8)) {
    /*                       I     */
#ifdef GL_RGBA8I
      *iv_return = (IV)GL_RGBA8I;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'L':
    if (memEQ(name, "GL_GEQUA", 8)) {
    /*                       L     */
#ifdef GL_GEQUAL
      *iv_return = (IV)GL_GEQUAL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LEQUA", 8)) {
    /*                       L     */
#ifdef GL_LEQUAL
      *iv_return = (IV)GL_LEQUAL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'N':
    if (memEQ(name, "GL_DOMAI", 8)) {
    /*                       N     */
#ifdef GL_DOMAIN
      *iv_return = (IV)GL_DOMAIN;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RETUR", 8)) {
    /*                       N     */
#ifdef GL_RETURN
      *iv_return = (IV)GL_RETURN;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'O':
    if (memEQ(name, "GL_STERE", 8)) {
    /*                       O     */
#ifdef GL_STEREO
      *iv_return = (IV)GL_STEREO;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'P':
    if (memEQ(name, "GL_BITMA", 8)) {
    /*                       P     */
#ifdef GL_BITMAP
      *iv_return = (IV)GL_BITMAP;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MIPMA", 8)) {
    /*                       P     */
#ifdef GL_MIPMAP
      *iv_return = (IV)GL_MIPMAP;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'R':
    if (memEQ(name, "GL_BUFFE", 8)) {
    /*                       R     */
#ifdef GL_BUFFER
      *iv_return = (IV)GL_BUFFER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DITHE", 8)) {
    /*                       R     */
#ifdef GL_DITHER
      *iv_return = (IV)GL_DITHER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FILTE", 8)) {
    /*                       R     */
#ifdef GL_FILTER
      *iv_return = (IV)GL_FILTER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LINEA", 8)) {
    /*                       R     */
#ifdef GL_LINEAR
      *iv_return = (IV)GL_LINEAR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RENDE", 8)) {
    /*                       R     */
#ifdef GL_RENDER
      *iv_return = (IV)GL_RENDER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SHADE", 8)) {
    /*                       R     */
#ifdef GL_SHADER
      *iv_return = (IV)GL_SHADER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VENDO", 8)) {
    /*                       R     */
#ifdef GL_VENDOR
      *iv_return = (IV)GL_VENDOR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'S':
    if (memEQ(name, "GL_ALWAY", 8)) {
    /*                       S     */
#ifdef GL_ALWAYS
      *iv_return = (IV)GL_ALWAYS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_POINT", 8)) {
    /*                       S     */
#ifdef GL_POINTS
      *iv_return = (IV)GL_POINTS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'T':
    if (memEQ(name, "GL_INVER", 8)) {
    /*                       T     */
#ifdef GL_INVERT
      *iv_return = (IV)GL_INVERT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NICES", 8)) {
    /*                       T     */
#ifdef GL_NICEST
      *iv_return = (IV)GL_NICEST;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OFFSE", 8)) {
    /*                       T     */
#ifdef GL_OFFSET
      *iv_return = (IV)GL_OFFSET;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_REPEA", 8)) {
    /*                       T     */
#ifdef GL_REPEAT
      *iv_return = (IV)GL_REPEAT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SELEC", 8)) {
    /*                       T     */
#ifdef GL_SELECT
      *iv_return = (IV)GL_SELECT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'V':
    if (memEQ(name, "GL_DST_N", 8)) {
    /*                       V     */
#ifdef GL_DST_NV
      *iv_return = (IV)GL_DST_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RED_N", 8)) {
    /*                       V     */
#ifdef GL_RED_NV
      *iv_return = (IV)GL_RED_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SRC_N", 8)) {
    /*                       V     */
#ifdef GL_SRC_NV
      *iv_return = (IV)GL_SRC_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_XOR_N", 8)) {
    /*                       V     */
#ifdef GL_XOR_NV
      *iv_return = (IV)GL_XOR_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'X':
    if (memEQ(name, "GL_MINMA", 8)) {
    /*                       X     */
#ifdef GL_MINMAX
      *iv_return = (IV)GL_MINMAX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ZOOM_", 8)) {
    /*                       X     */
#ifdef GL_ZOOM_X
      *iv_return = (IV)GL_ZOOM_X;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'Y':
    if (memEQ(name, "GL_ZOOM_", 8)) {
    /*                       Y     */
#ifdef GL_ZOOM_Y
      *iv_return = (IV)GL_ZOOM_Y;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  }
  return PERL_constant_NOTFOUND;
}

static int
constant_10 (pTHX_ const char *name, IV *iv_return) {
  /* When generated this function returned values for the list of names given
     here.  However, subsequent manual editing may have added or removed some.
     GL_2_BYTES GL_3_BYTES GL_422_EXT GL_4_BYTES GL_ADD_ATI GL_ALPHA12
     GL_ALPHA16 GL_AMBIENT GL_BGR_EXT GL_BLUE_NV GL_C3F_V3F GL_CND_ATI
     GL_COMBINE GL_COMPILE GL_DIFFUSE GL_DSDT_NV GL_FASTEST GL_FOG_BIT
     GL_FOG_END GL_GREATER GL_HILO_NV GL_INT8_NV GL_LOW_INT GL_MAD_ATI
     GL_MAX_EXT GL_MIN_EXT GL_MOV_ATI GL_MUL_ATI GL_N3F_V3F GL_NEAREST
     GL_ONE_EXT GL_PATCHES GL_PLUS_NV GL_POLYGON GL_PROGRAM GL_RECT_NV
     GL_REPLACE GL_RGB16UI GL_RGB32UI GL_RGB5_A1 GL_RGB9_E5 GL_RGBA16F
     GL_RGBA16I GL_RGBA32F GL_RGBA32I GL_RGBA8UI GL_S3_s3tc GL_SAMPLER
     GL_SAMPLES GL_SET_AMD GL_STENCIL GL_SUB_ATI GL_T2F_V3F GL_T4F_V4F
     GL_TEXTURE GL_UNIFORM GL_UTF8_NV GL_VERSION */
  /* Offset 3 gives the best switch position.  */
  switch (name[3]) {
  case '2':
    if (memEQ(name, "GL_2_BYTES", 10)) {
    /*                  ^             */
#ifdef GL_2_BYTES
      *iv_return = (IV)GL_2_BYTES;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '3':
    if (memEQ(name, "GL_3_BYTES", 10)) {
    /*                  ^             */
#ifdef GL_3_BYTES
      *iv_return = (IV)GL_3_BYTES;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '4':
    if (memEQ(name, "GL_422_EXT", 10)) {
    /*                  ^             */
#ifdef GL_422_EXT
      *iv_return = (IV)GL_422_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_4_BYTES", 10)) {
    /*                  ^             */
#ifdef GL_4_BYTES
      *iv_return = (IV)GL_4_BYTES;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'A':
    if (memEQ(name, "GL_ADD_ATI", 10)) {
    /*                  ^             */
#ifdef GL_ADD_ATI
      *iv_return = (IV)GL_ADD_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ALPHA12", 10)) {
    /*                  ^             */
#ifdef GL_ALPHA12
      *iv_return = (IV)GL_ALPHA12;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ALPHA16", 10)) {
    /*                  ^             */
#ifdef GL_ALPHA16
      *iv_return = (IV)GL_ALPHA16;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_AMBIENT", 10)) {
    /*                  ^             */
#ifdef GL_AMBIENT
      *iv_return = (IV)GL_AMBIENT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'B':
    if (memEQ(name, "GL_BGR_EXT", 10)) {
    /*                  ^             */
#ifdef GL_BGR_EXT
      *iv_return = (IV)GL_BGR_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_BLUE_NV", 10)) {
    /*                  ^             */
#ifdef GL_BLUE_NV
      *iv_return = (IV)GL_BLUE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'C':
    if (memEQ(name, "GL_C3F_V3F", 10)) {
    /*                  ^             */
#ifdef GL_C3F_V3F
      *iv_return = (IV)GL_C3F_V3F;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CND_ATI", 10)) {
    /*                  ^             */
#ifdef GL_CND_ATI
      *iv_return = (IV)GL_CND_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COMBINE", 10)) {
    /*                  ^             */
#ifdef GL_COMBINE
      *iv_return = (IV)GL_COMBINE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COMPILE", 10)) {
    /*                  ^             */
#ifdef GL_COMPILE
      *iv_return = (IV)GL_COMPILE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'D':
    if (memEQ(name, "GL_DIFFUSE", 10)) {
    /*                  ^             */
#ifdef GL_DIFFUSE
      *iv_return = (IV)GL_DIFFUSE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DSDT_NV", 10)) {
    /*                  ^             */
#ifdef GL_DSDT_NV
      *iv_return = (IV)GL_DSDT_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'F':
    if (memEQ(name, "GL_FASTEST", 10)) {
    /*                  ^             */
#ifdef GL_FASTEST
      *iv_return = (IV)GL_FASTEST;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FOG_BIT", 10)) {
    /*                  ^             */
#ifdef GL_FOG_BIT
      *iv_return = (IV)GL_FOG_BIT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FOG_END", 10)) {
    /*                  ^             */
#ifdef GL_FOG_END
      *iv_return = (IV)GL_FOG_END;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'G':
    if (memEQ(name, "GL_GREATER", 10)) {
    /*                  ^             */
#ifdef GL_GREATER
      *iv_return = (IV)GL_GREATER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'H':
    if (memEQ(name, "GL_HILO_NV", 10)) {
    /*                  ^             */
#ifdef GL_HILO_NV
      *iv_return = (IV)GL_HILO_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'I':
    if (memEQ(name, "GL_INT8_NV", 10)) {
    /*                  ^             */
#ifdef GL_INT8_NV
      *iv_return = (IV)GL_INT8_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'L':
    if (memEQ(name, "GL_LOW_INT", 10)) {
    /*                  ^             */
#ifdef GL_LOW_INT
      *iv_return = (IV)GL_LOW_INT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'M':
    if (memEQ(name, "GL_MAD_ATI", 10)) {
    /*                  ^             */
#ifdef GL_MAD_ATI
      *iv_return = (IV)GL_MAD_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_EXT", 10)) {
    /*                  ^             */
#ifdef GL_MAX_EXT
      *iv_return = (IV)GL_MAX_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MIN_EXT", 10)) {
    /*                  ^             */
#ifdef GL_MIN_EXT
      *iv_return = (IV)GL_MIN_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MOV_ATI", 10)) {
    /*                  ^             */
#ifdef GL_MOV_ATI
      *iv_return = (IV)GL_MOV_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MUL_ATI", 10)) {
    /*                  ^             */
#ifdef GL_MUL_ATI
      *iv_return = (IV)GL_MUL_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'N':
    if (memEQ(name, "GL_N3F_V3F", 10)) {
    /*                  ^             */
#ifdef GL_N3F_V3F
      *iv_return = (IV)GL_N3F_V3F;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NEAREST", 10)) {
    /*                  ^             */
#ifdef GL_NEAREST
      *iv_return = (IV)GL_NEAREST;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'O':
    if (memEQ(name, "GL_ONE_EXT", 10)) {
    /*                  ^             */
#ifdef GL_ONE_EXT
      *iv_return = (IV)GL_ONE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'P':
    if (memEQ(name, "GL_PATCHES", 10)) {
    /*                  ^             */
#ifdef GL_PATCHES
      *iv_return = (IV)GL_PATCHES;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PLUS_NV", 10)) {
    /*                  ^             */
#ifdef GL_PLUS_NV
      *iv_return = (IV)GL_PLUS_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_POLYGON", 10)) {
    /*                  ^             */
#ifdef GL_POLYGON
      *iv_return = (IV)GL_POLYGON;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PROGRAM", 10)) {
    /*                  ^             */
#ifdef GL_PROGRAM
      *iv_return = (IV)GL_PROGRAM;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'R':
    if (memEQ(name, "GL_RECT_NV", 10)) {
    /*                  ^             */
#ifdef GL_RECT_NV
      *iv_return = (IV)GL_RECT_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_REPLACE", 10)) {
    /*                  ^             */
#ifdef GL_REPLACE
      *iv_return = (IV)GL_REPLACE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGB16UI", 10)) {
    /*                  ^             */
#ifdef GL_RGB16UI
      *iv_return = (IV)GL_RGB16UI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGB32UI", 10)) {
    /*                  ^             */
#ifdef GL_RGB32UI
      *iv_return = (IV)GL_RGB32UI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGB5_A1", 10)) {
    /*                  ^             */
#ifdef GL_RGB5_A1
      *iv_return = (IV)GL_RGB5_A1;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGB9_E5", 10)) {
    /*                  ^             */
#ifdef GL_RGB9_E5
      *iv_return = (IV)GL_RGB9_E5;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGBA16F", 10)) {
    /*                  ^             */
#ifdef GL_RGBA16F
      *iv_return = (IV)GL_RGBA16F;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGBA16I", 10)) {
    /*                  ^             */
#ifdef GL_RGBA16I
      *iv_return = (IV)GL_RGBA16I;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGBA32F", 10)) {
    /*                  ^             */
#ifdef GL_RGBA32F
      *iv_return = (IV)GL_RGBA32F;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGBA32I", 10)) {
    /*                  ^             */
#ifdef GL_RGBA32I
      *iv_return = (IV)GL_RGBA32I;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGBA8UI", 10)) {
    /*                  ^             */
#ifdef GL_RGBA8UI
      *iv_return = (IV)GL_RGBA8UI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'S':
    if (memEQ(name, "GL_S3_s3tc", 10)) {
    /*                  ^             */
#ifdef GL_S3_s3tc
      *iv_return = (IV)GL_S3_s3tc;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLER", 10)) {
    /*                  ^             */
#ifdef GL_SAMPLER
      *iv_return = (IV)GL_SAMPLER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLES", 10)) {
    /*                  ^             */
#ifdef GL_SAMPLES
      *iv_return = (IV)GL_SAMPLES;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SET_AMD", 10)) {
    /*                  ^             */
#ifdef GL_SET_AMD
      *iv_return = (IV)GL_SET_AMD;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STENCIL", 10)) {
    /*                  ^             */
#ifdef GL_STENCIL
      *iv_return = (IV)GL_STENCIL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SUB_ATI", 10)) {
    /*                  ^             */
#ifdef GL_SUB_ATI
      *iv_return = (IV)GL_SUB_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'T':
    if (memEQ(name, "GL_T2F_V3F", 10)) {
    /*                  ^             */
#ifdef GL_T2F_V3F
      *iv_return = (IV)GL_T2F_V3F;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_T4F_V4F", 10)) {
    /*                  ^             */
#ifdef GL_T4F_V4F
      *iv_return = (IV)GL_T4F_V4F;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE", 10)) {
    /*                  ^             */
#ifdef GL_TEXTURE
      *iv_return = (IV)GL_TEXTURE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'U':
    if (memEQ(name, "GL_UNIFORM", 10)) {
    /*                  ^             */
#ifdef GL_UNIFORM
      *iv_return = (IV)GL_UNIFORM;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UTF8_NV", 10)) {
    /*                  ^             */
#ifdef GL_UTF8_NV
      *iv_return = (IV)GL_UTF8_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'V':
    if (memEQ(name, "GL_VERSION", 10)) {
    /*                  ^             */
#ifdef GL_VERSION
      *iv_return = (IV)GL_VERSION;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  }
  return PERL_constant_NOTFOUND;
}

static int
constant_11 (pTHX_ const char *name, IV *iv_return) {
  /* When generated this function returned values for the list of names given
     here.  However, subsequent manual editing may have added or removed some.
     GL_3D_COLOR GL_ABGR_EXT GL_ARB_sync GL_BEVEL_NV GL_BGRA_EXT GL_BOOL_ARB
     GL_C4UB_V2F GL_C4UB_V3F GL_CMYK_EXT GL_CND0_ATI GL_CONSTANT GL_DOT3_ATI
     GL_DOT3_RGB GL_DOT4_ATI GL_DSDT8_NV GL_DUDV_ATI GL_EMISSION GL_EVAL_BIT
     GL_EXT_abgr GL_EXT_bgra GL_FEEDBACK GL_FOG_HINT GL_FOG_MODE GL_FRAME_NV
     GL_FUNC_ADD GL_GREEN_NV GL_HIGH_INT GL_HILO8_NV GL_HINT_BIT GL_IMAGE_1D
     GL_IMAGE_2D GL_IMAGE_3D GL_INT16_NV GL_INT64_NV GL_INT_VEC2 GL_INT_VEC3
     GL_INT_VEC4 GL_ISOLINES GL_LERP_ATI GL_LIGHTING GL_LINE_BIT GL_LIST_BIT
     GL_LOCATION GL_LOGIC_OP GL_MINUS_NV GL_MODULATE GL_NOTEQUAL GL_NO_ERROR
     GL_NV_fence GL_POSITION GL_PREVIOUS GL_R3_G3_B2 GL_R8_SNORM GL_RED_BIAS
     GL_RED_BITS GL_RENDERER GL_RGB10_A2 GL_RGB2_EXT GL_RGB4_EXT GL_RGB5_EXT
     GL_RGB8_EXT GL_RGBA16UI GL_RGBA32UI GL_RGB_S3TC GL_RG_SNORM GL_ROUND_NV
     GL_SIGNALED GL_SPECULAR GL_SRC0_RGB GL_SRC1_RGB GL_SRC2_RGB GL_SRGB_EXT
     GL_SUBTRACT GL_TEXTURE0 GL_TEXTURE1 GL_TEXTURE2 GL_TEXTURE3 GL_TEXTURE4
     GL_TEXTURE5 GL_TEXTURE6 GL_TEXTURE7 GL_TEXTURE8 GL_TEXTURE9 GL_UTF16_NV
     GL_VIEWPORT GL_ZERO_EXT */
  /* Offset 6 gives the best switch position.  */
  switch (name[6]) {
  case '0':
    if (memEQ(name, "GL_CND0_ATI", 11)) {
    /*                     ^           */
#ifdef GL_CND0_ATI
      *iv_return = (IV)GL_CND0_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SRC0_RGB", 11)) {
    /*                     ^           */
#ifdef GL_SRC0_RGB
      *iv_return = (IV)GL_SRC0_RGB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '1':
    if (memEQ(name, "GL_INT16_NV", 11)) {
    /*                     ^           */
#ifdef GL_INT16_NV
      *iv_return = (IV)GL_INT16_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGB10_A2", 11)) {
    /*                     ^           */
#ifdef GL_RGB10_A2
      *iv_return = (IV)GL_RGB10_A2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SRC1_RGB", 11)) {
    /*                     ^           */
#ifdef GL_SRC1_RGB
      *iv_return = (IV)GL_SRC1_RGB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UTF16_NV", 11)) {
    /*                     ^           */
#ifdef GL_UTF16_NV
      *iv_return = (IV)GL_UTF16_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '2':
    if (memEQ(name, "GL_RGB2_EXT", 11)) {
    /*                     ^           */
#ifdef GL_RGB2_EXT
      *iv_return = (IV)GL_RGB2_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SRC2_RGB", 11)) {
    /*                     ^           */
#ifdef GL_SRC2_RGB
      *iv_return = (IV)GL_SRC2_RGB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '3':
    if (memEQ(name, "GL_DOT3_ATI", 11)) {
    /*                     ^           */
#ifdef GL_DOT3_ATI
      *iv_return = (IV)GL_DOT3_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DOT3_RGB", 11)) {
    /*                     ^           */
#ifdef GL_DOT3_RGB
      *iv_return = (IV)GL_DOT3_RGB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '4':
    if (memEQ(name, "GL_DOT4_ATI", 11)) {
    /*                     ^           */
#ifdef GL_DOT4_ATI
      *iv_return = (IV)GL_DOT4_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGB4_EXT", 11)) {
    /*                     ^           */
#ifdef GL_RGB4_EXT
      *iv_return = (IV)GL_RGB4_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '5':
    if (memEQ(name, "GL_RGB5_EXT", 11)) {
    /*                     ^           */
#ifdef GL_RGB5_EXT
      *iv_return = (IV)GL_RGB5_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '6':
    if (memEQ(name, "GL_INT64_NV", 11)) {
    /*                     ^           */
#ifdef GL_INT64_NV
      *iv_return = (IV)GL_INT64_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '8':
    if (memEQ(name, "GL_RGB8_EXT", 11)) {
    /*                     ^           */
#ifdef GL_RGB8_EXT
      *iv_return = (IV)GL_RGB8_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'A':
    if (memEQ(name, "GL_BGRA_EXT", 11)) {
    /*                     ^           */
#ifdef GL_BGRA_EXT
      *iv_return = (IV)GL_BGRA_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LOCATION", 11)) {
    /*                     ^           */
#ifdef GL_LOCATION
      *iv_return = (IV)GL_LOCATION;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGBA16UI", 11)) {
    /*                     ^           */
#ifdef GL_RGBA16UI
      *iv_return = (IV)GL_RGBA16UI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGBA32UI", 11)) {
    /*                     ^           */
#ifdef GL_RGBA32UI
      *iv_return = (IV)GL_RGBA32UI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'B':
    if (memEQ(name, "GL_C4UB_V2F", 11)) {
    /*                     ^           */
#ifdef GL_C4UB_V2F
      *iv_return = (IV)GL_C4UB_V2F;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_C4UB_V3F", 11)) {
    /*                     ^           */
#ifdef GL_C4UB_V3F
      *iv_return = (IV)GL_C4UB_V3F;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SRGB_EXT", 11)) {
    /*                     ^           */
#ifdef GL_SRGB_EXT
      *iv_return = (IV)GL_SRGB_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'C':
    if (memEQ(name, "GL_3D_COLOR", 11)) {
    /*                     ^           */
#ifdef GL_3D_COLOR
      *iv_return = (IV)GL_3D_COLOR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FUNC_ADD", 11)) {
    /*                     ^           */
#ifdef GL_FUNC_ADD
      *iv_return = (IV)GL_FUNC_ADD;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SPECULAR", 11)) {
    /*                     ^           */
#ifdef GL_SPECULAR
      *iv_return = (IV)GL_SPECULAR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'D':
    if (memEQ(name, "GL_FEEDBACK", 11)) {
    /*                     ^           */
#ifdef GL_FEEDBACK
      *iv_return = (IV)GL_FEEDBACK;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RENDERER", 11)) {
    /*                     ^           */
#ifdef GL_RENDERER
      *iv_return = (IV)GL_RENDERER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'E':
    if (memEQ(name, "GL_BEVEL_NV", 11)) {
    /*                     ^           */
#ifdef GL_BEVEL_NV
      *iv_return = (IV)GL_BEVEL_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_GREEN_NV", 11)) {
    /*                     ^           */
#ifdef GL_GREEN_NV
      *iv_return = (IV)GL_GREEN_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LINE_BIT", 11)) {
    /*                     ^           */
#ifdef GL_LINE_BIT
      *iv_return = (IV)GL_LINE_BIT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NOTEQUAL", 11)) {
    /*                     ^           */
#ifdef GL_NOTEQUAL
      *iv_return = (IV)GL_NOTEQUAL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NO_ERROR", 11)) {
    /*                     ^           */
#ifdef GL_NO_ERROR
      *iv_return = (IV)GL_NO_ERROR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'G':
    if (memEQ(name, "GL_IMAGE_1D", 11)) {
    /*                     ^           */
#ifdef GL_IMAGE_1D
      *iv_return = (IV)GL_IMAGE_1D;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_IMAGE_2D", 11)) {
    /*                     ^           */
#ifdef GL_IMAGE_2D
      *iv_return = (IV)GL_IMAGE_2D;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_IMAGE_3D", 11)) {
    /*                     ^           */
#ifdef GL_IMAGE_3D
      *iv_return = (IV)GL_IMAGE_3D;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_R3_G3_B2", 11)) {
    /*                     ^           */
#ifdef GL_R3_G3_B2
      *iv_return = (IV)GL_R3_G3_B2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'H':
    if (memEQ(name, "GL_HIGH_INT", 11)) {
    /*                     ^           */
#ifdef GL_HIGH_INT
      *iv_return = (IV)GL_HIGH_INT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LIGHTING", 11)) {
    /*                     ^           */
#ifdef GL_LIGHTING
      *iv_return = (IV)GL_LIGHTING;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'I':
    if (memEQ(name, "GL_LOGIC_OP", 11)) {
    /*                     ^           */
#ifdef GL_LOGIC_OP
      *iv_return = (IV)GL_LOGIC_OP;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_POSITION", 11)) {
    /*                     ^           */
#ifdef GL_POSITION
      *iv_return = (IV)GL_POSITION;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'K':
    if (memEQ(name, "GL_CMYK_EXT", 11)) {
    /*                     ^           */
#ifdef GL_CMYK_EXT
      *iv_return = (IV)GL_CMYK_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'L':
    if (memEQ(name, "GL_BOOL_ARB", 11)) {
    /*                     ^           */
#ifdef GL_BOOL_ARB
      *iv_return = (IV)GL_BOOL_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EVAL_BIT", 11)) {
    /*                     ^           */
#ifdef GL_EVAL_BIT
      *iv_return = (IV)GL_EVAL_BIT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ISOLINES", 11)) {
    /*                     ^           */
#ifdef GL_ISOLINES
      *iv_return = (IV)GL_ISOLINES;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'M':
    if (memEQ(name, "GL_FRAME_NV", 11)) {
    /*                     ^           */
#ifdef GL_FRAME_NV
      *iv_return = (IV)GL_FRAME_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'N':
    if (memEQ(name, "GL_ROUND_NV", 11)) {
    /*                     ^           */
#ifdef GL_ROUND_NV
      *iv_return = (IV)GL_ROUND_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SIGNALED", 11)) {
    /*                     ^           */
#ifdef GL_SIGNALED
      *iv_return = (IV)GL_SIGNALED;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'O':
    if (memEQ(name, "GL_HILO8_NV", 11)) {
    /*                     ^           */
#ifdef GL_HILO8_NV
      *iv_return = (IV)GL_HILO8_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ZERO_EXT", 11)) {
    /*                     ^           */
#ifdef GL_ZERO_EXT
      *iv_return = (IV)GL_ZERO_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'P':
    if (memEQ(name, "GL_LERP_ATI", 11)) {
    /*                     ^           */
#ifdef GL_LERP_ATI
      *iv_return = (IV)GL_LERP_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'R':
    if (memEQ(name, "GL_ABGR_EXT", 11)) {
    /*                     ^           */
#ifdef GL_ABGR_EXT
      *iv_return = (IV)GL_ABGR_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'S':
    if (memEQ(name, "GL_CONSTANT", 11)) {
    /*                     ^           */
#ifdef GL_CONSTANT
      *iv_return = (IV)GL_CONSTANT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EMISSION", 11)) {
    /*                     ^           */
#ifdef GL_EMISSION
      *iv_return = (IV)GL_EMISSION;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_R8_SNORM", 11)) {
    /*                     ^           */
#ifdef GL_R8_SNORM
      *iv_return = (IV)GL_R8_SNORM;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RG_SNORM", 11)) {
    /*                     ^           */
#ifdef GL_RG_SNORM
      *iv_return = (IV)GL_RG_SNORM;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'T':
    if (memEQ(name, "GL_DSDT8_NV", 11)) {
    /*                     ^           */
#ifdef GL_DSDT8_NV
      *iv_return = (IV)GL_DSDT8_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_HINT_BIT", 11)) {
    /*                     ^           */
#ifdef GL_HINT_BIT
      *iv_return = (IV)GL_HINT_BIT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LIST_BIT", 11)) {
    /*                     ^           */
#ifdef GL_LIST_BIT
      *iv_return = (IV)GL_LIST_BIT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SUBTRACT", 11)) {
    /*                     ^           */
#ifdef GL_SUBTRACT
      *iv_return = (IV)GL_SUBTRACT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE0", 11)) {
    /*                     ^           */
#ifdef GL_TEXTURE0
      *iv_return = (IV)GL_TEXTURE0;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE1", 11)) {
    /*                     ^           */
#ifdef GL_TEXTURE1
      *iv_return = (IV)GL_TEXTURE1;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE2", 11)) {
    /*                     ^           */
#ifdef GL_TEXTURE2
      *iv_return = (IV)GL_TEXTURE2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE3", 11)) {
    /*                     ^           */
#ifdef GL_TEXTURE3
      *iv_return = (IV)GL_TEXTURE3;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE4", 11)) {
    /*                     ^           */
#ifdef GL_TEXTURE4
      *iv_return = (IV)GL_TEXTURE4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE5", 11)) {
    /*                     ^           */
#ifdef GL_TEXTURE5
      *iv_return = (IV)GL_TEXTURE5;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE6", 11)) {
    /*                     ^           */
#ifdef GL_TEXTURE6
      *iv_return = (IV)GL_TEXTURE6;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE7", 11)) {
    /*                     ^           */
#ifdef GL_TEXTURE7
      *iv_return = (IV)GL_TEXTURE7;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE8", 11)) {
    /*                     ^           */
#ifdef GL_TEXTURE8
      *iv_return = (IV)GL_TEXTURE8;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE9", 11)) {
    /*                     ^           */
#ifdef GL_TEXTURE9
      *iv_return = (IV)GL_TEXTURE9;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'U':
    if (memEQ(name, "GL_MINUS_NV", 11)) {
    /*                     ^           */
#ifdef GL_MINUS_NV
      *iv_return = (IV)GL_MINUS_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MODULATE", 11)) {
    /*                     ^           */
#ifdef GL_MODULATE
      *iv_return = (IV)GL_MODULATE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'V':
    if (memEQ(name, "GL_DUDV_ATI", 11)) {
    /*                     ^           */
#ifdef GL_DUDV_ATI
      *iv_return = (IV)GL_DUDV_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PREVIOUS", 11)) {
    /*                     ^           */
#ifdef GL_PREVIOUS
      *iv_return = (IV)GL_PREVIOUS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'W':
    if (memEQ(name, "GL_VIEWPORT", 11)) {
    /*                     ^           */
#ifdef GL_VIEWPORT
      *iv_return = (IV)GL_VIEWPORT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '_':
    if (memEQ(name, "GL_ARB_sync", 11)) {
    /*                     ^           */
#ifdef GL_ARB_sync
      *iv_return = (IV)GL_ARB_sync;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_abgr", 11)) {
    /*                     ^           */
#ifdef GL_EXT_abgr
      *iv_return = (IV)GL_EXT_abgr;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_bgra", 11)) {
    /*                     ^           */
#ifdef GL_EXT_bgra
      *iv_return = (IV)GL_EXT_bgra;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FOG_HINT", 11)) {
    /*                     ^           */
#ifdef GL_FOG_HINT
      *iv_return = (IV)GL_FOG_HINT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FOG_MODE", 11)) {
    /*                     ^           */
#ifdef GL_FOG_MODE
      *iv_return = (IV)GL_FOG_MODE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INT_VEC2", 11)) {
    /*                     ^           */
#ifdef GL_INT_VEC2
      *iv_return = (IV)GL_INT_VEC2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INT_VEC3", 11)) {
    /*                     ^           */
#ifdef GL_INT_VEC3
      *iv_return = (IV)GL_INT_VEC3;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INT_VEC4", 11)) {
    /*                     ^           */
#ifdef GL_INT_VEC4
      *iv_return = (IV)GL_INT_VEC4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RED_BIAS", 11)) {
    /*                     ^           */
#ifdef GL_RED_BIAS
      *iv_return = (IV)GL_RED_BIAS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RED_BITS", 11)) {
    /*                     ^           */
#ifdef GL_RED_BITS
      *iv_return = (IV)GL_RED_BITS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGB_S3TC", 11)) {
    /*                     ^           */
#ifdef GL_RGB_S3TC
      *iv_return = (IV)GL_RGB_S3TC;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'f':
    if (memEQ(name, "GL_NV_fence", 11)) {
    /*                     ^           */
#ifdef GL_NV_fence
      *iv_return = (IV)GL_NV_fence;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  }
  return PERL_constant_NOTFOUND;
}

static int
constant_12 (pTHX_ const char *name, IV *iv_return) {
  /* When generated this function returned values for the list of names given
     here.  However, subsequent manual editing may have added or removed some.
     GLEW_S3_s3tc GLEW_VERSION GL_1PASS_EXT GL_ARC_TO_NV GL_BACK_LEFT
     GL_BLEND_DST GL_BLEND_SRC GL_BLUE_BIAS GL_BLUE_BITS GL_BOOL_VEC2
     GL_BOOL_VEC3 GL_BOOL_VEC4 GL_CMYKA_EXT GL_COLOR_SUM GL_CON_0_ATI
     GL_CON_1_ATI GL_CON_2_ATI GL_CON_3_ATI GL_CON_4_ATI GL_CON_5_ATI
     GL_CON_6_ATI GL_CON_7_ATI GL_CUBIC_EXT GL_CULL_FACE GL_DARKEN_NV
     GL_DECR_WRAP GL_DONT_CARE GL_DOT3_RGBA GL_DST_ALPHA GL_DST_COLOR
     GL_DST_IN_NV GL_EDGE_FLAG GL_EXT_cmyka GL_EYE_PLANE GL_FIELDS_NV
     GL_FOG_COLOR GL_FOG_COORD GL_FOG_INDEX GL_FOG_START GL_HILO16_NV
     GL_HISTOGRAM GL_INCR_WRAP GL_INT64_ARB GL_INTENSITY GL_KHR_debug
     GL_LINE_LOOP GL_LIST_BASE GL_LIST_MODE GL_LOCAL_EXT GL_LOG_REGAL
     GL_LOW_FLOAT GL_LUMINANCE GL_MAP_COLOR GL_MAX_DEPTH GL_MAX_WIDTH
     GL_MODELVIEW GL_NORMALIZE GL_PHONG_WIN GL_POINT_BIT GL_R16_SNORM
     GL_READ_ONLY GL_RED_SCALE GL_RED_SNORM GL_REGAL_log GL_REG_0_ATI
     GL_REG_1_ATI GL_REG_2_ATI GL_REG_3_ATI GL_REG_4_ATI GL_REG_5_ATI
     GL_RG8_SNORM GL_RGB10_EXT GL_RGB12_EXT GL_RGB16_EXT GL_RGB4_S3TC
     GL_RGB8I_EXT GL_RGBA2_EXT GL_RGBA4_EXT GL_RGBA8_EXT GL_RGBA_MODE
     GL_RGBA_S3TC GL_RGB_SCALE GL_RGB_SNORM GL_SCREEN_NV GL_SHININESS
     GL_SPARE0_NV GL_SPARE1_NV GL_SQUARE_NV GL_SRC_ALPHA GL_SRC_COLOR
     GL_SRC_IN_NV GL_SRGB8_EXT GL_SRGB_READ GL_TEXTURE10 GL_TEXTURE11
     GL_TEXTURE12 GL_TEXTURE13 GL_TEXTURE14 GL_TEXTURE15 GL_TEXTURE16
     GL_TEXTURE17 GL_TEXTURE18 GL_TEXTURE19 GL_TEXTURE20 GL_TEXTURE21
     GL_TEXTURE22 GL_TEXTURE23 GL_TEXTURE24 GL_TEXTURE25 GL_TEXTURE26
     GL_TEXTURE27 GL_TEXTURE28 GL_TEXTURE29 GL_TEXTURE30 GL_TEXTURE31
     GL_TIMESTAMP GL_TRIANGLES */
  /* Offset 11 gives the best switch position.  */
  switch (name[11]) {
  case '0':
    if (memEQ(name, "GL_TEXTURE1", 11)) {
    /*                          0      */
#ifdef GL_TEXTURE10
      *iv_return = (IV)GL_TEXTURE10;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE2", 11)) {
    /*                          0      */
#ifdef GL_TEXTURE20
      *iv_return = (IV)GL_TEXTURE20;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE3", 11)) {
    /*                          0      */
#ifdef GL_TEXTURE30
      *iv_return = (IV)GL_TEXTURE30;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '1':
    if (memEQ(name, "GL_TEXTURE1", 11)) {
    /*                          1      */
#ifdef GL_TEXTURE11
      *iv_return = (IV)GL_TEXTURE11;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE2", 11)) {
    /*                          1      */
#ifdef GL_TEXTURE21
      *iv_return = (IV)GL_TEXTURE21;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE3", 11)) {
    /*                          1      */
#ifdef GL_TEXTURE31
      *iv_return = (IV)GL_TEXTURE31;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '2':
    if (memEQ(name, "GL_BOOL_VEC", 11)) {
    /*                          2      */
#ifdef GL_BOOL_VEC2
      *iv_return = (IV)GL_BOOL_VEC2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE1", 11)) {
    /*                          2      */
#ifdef GL_TEXTURE12
      *iv_return = (IV)GL_TEXTURE12;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE2", 11)) {
    /*                          2      */
#ifdef GL_TEXTURE22
      *iv_return = (IV)GL_TEXTURE22;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '3':
    if (memEQ(name, "GL_BOOL_VEC", 11)) {
    /*                          3      */
#ifdef GL_BOOL_VEC3
      *iv_return = (IV)GL_BOOL_VEC3;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE1", 11)) {
    /*                          3      */
#ifdef GL_TEXTURE13
      *iv_return = (IV)GL_TEXTURE13;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE2", 11)) {
    /*                          3      */
#ifdef GL_TEXTURE23
      *iv_return = (IV)GL_TEXTURE23;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '4':
    if (memEQ(name, "GL_BOOL_VEC", 11)) {
    /*                          4      */
#ifdef GL_BOOL_VEC4
      *iv_return = (IV)GL_BOOL_VEC4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE1", 11)) {
    /*                          4      */
#ifdef GL_TEXTURE14
      *iv_return = (IV)GL_TEXTURE14;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE2", 11)) {
    /*                          4      */
#ifdef GL_TEXTURE24
      *iv_return = (IV)GL_TEXTURE24;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '5':
    if (memEQ(name, "GL_TEXTURE1", 11)) {
    /*                          5      */
#ifdef GL_TEXTURE15
      *iv_return = (IV)GL_TEXTURE15;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE2", 11)) {
    /*                          5      */
#ifdef GL_TEXTURE25
      *iv_return = (IV)GL_TEXTURE25;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '6':
    if (memEQ(name, "GL_TEXTURE1", 11)) {
    /*                          6      */
#ifdef GL_TEXTURE16
      *iv_return = (IV)GL_TEXTURE16;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE2", 11)) {
    /*                          6      */
#ifdef GL_TEXTURE26
      *iv_return = (IV)GL_TEXTURE26;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '7':
    if (memEQ(name, "GL_TEXTURE1", 11)) {
    /*                          7      */
#ifdef GL_TEXTURE17
      *iv_return = (IV)GL_TEXTURE17;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE2", 11)) {
    /*                          7      */
#ifdef GL_TEXTURE27
      *iv_return = (IV)GL_TEXTURE27;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '8':
    if (memEQ(name, "GL_TEXTURE1", 11)) {
    /*                          8      */
#ifdef GL_TEXTURE18
      *iv_return = (IV)GL_TEXTURE18;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE2", 11)) {
    /*                          8      */
#ifdef GL_TEXTURE28
      *iv_return = (IV)GL_TEXTURE28;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '9':
    if (memEQ(name, "GL_TEXTURE1", 11)) {
    /*                          9      */
#ifdef GL_TEXTURE19
      *iv_return = (IV)GL_TEXTURE19;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE2", 11)) {
    /*                          9      */
#ifdef GL_TEXTURE29
      *iv_return = (IV)GL_TEXTURE29;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'A':
    if (memEQ(name, "GL_DOT3_RGB", 11)) {
    /*                          A      */
#ifdef GL_DOT3_RGBA
      *iv_return = (IV)GL_DOT3_RGBA;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DST_ALPH", 11)) {
    /*                          A      */
#ifdef GL_DST_ALPHA
      *iv_return = (IV)GL_DST_ALPHA;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SRC_ALPH", 11)) {
    /*                          A      */
#ifdef GL_SRC_ALPHA
      *iv_return = (IV)GL_SRC_ALPHA;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'B':
    if (memEQ(name, "GL_INT64_AR", 11)) {
    /*                          B      */
#ifdef GL_INT64_ARB
      *iv_return = (IV)GL_INT64_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'C':
    if (memEQ(name, "GL_BLEND_SR", 11)) {
    /*                          C      */
#ifdef GL_BLEND_SRC
      *iv_return = (IV)GL_BLEND_SRC;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGB4_S3T", 11)) {
    /*                          C      */
#ifdef GL_RGB4_S3TC
      *iv_return = (IV)GL_RGB4_S3TC;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGBA_S3T", 11)) {
    /*                          C      */
#ifdef GL_RGBA_S3TC
      *iv_return = (IV)GL_RGBA_S3TC;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'D':
    if (memEQ(name, "GL_FOG_COOR", 11)) {
    /*                          D      */
#ifdef GL_FOG_COORD
      *iv_return = (IV)GL_FOG_COORD;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SRGB_REA", 11)) {
    /*                          D      */
#ifdef GL_SRGB_READ
      *iv_return = (IV)GL_SRGB_READ;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'E':
    if (memEQ(name, "GL_CULL_FAC", 11)) {
    /*                          E      */
#ifdef GL_CULL_FACE
      *iv_return = (IV)GL_CULL_FACE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DONT_CAR", 11)) {
    /*                          E      */
#ifdef GL_DONT_CARE
      *iv_return = (IV)GL_DONT_CARE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EYE_PLAN", 11)) {
    /*                          E      */
#ifdef GL_EYE_PLANE
      *iv_return = (IV)GL_EYE_PLANE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LIST_BAS", 11)) {
    /*                          E      */
#ifdef GL_LIST_BASE
      *iv_return = (IV)GL_LIST_BASE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LIST_MOD", 11)) {
    /*                          E      */
#ifdef GL_LIST_MODE
      *iv_return = (IV)GL_LIST_MODE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LUMINANC", 11)) {
    /*                          E      */
#ifdef GL_LUMINANCE
      *iv_return = (IV)GL_LUMINANCE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NORMALIZ", 11)) {
    /*                          E      */
#ifdef GL_NORMALIZE
      *iv_return = (IV)GL_NORMALIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RED_SCAL", 11)) {
    /*                          E      */
#ifdef GL_RED_SCALE
      *iv_return = (IV)GL_RED_SCALE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGBA_MOD", 11)) {
    /*                          E      */
#ifdef GL_RGBA_MODE
      *iv_return = (IV)GL_RGBA_MODE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGB_SCAL", 11)) {
    /*                          E      */
#ifdef GL_RGB_SCALE
      *iv_return = (IV)GL_RGB_SCALE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'G':
    if (memEQ(name, "GL_EDGE_FLA", 11)) {
    /*                          G      */
#ifdef GL_EDGE_FLAG
      *iv_return = (IV)GL_EDGE_FLAG;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'H':
    if (memEQ(name, "GL_MAX_DEPT", 11)) {
    /*                          H      */
#ifdef GL_MAX_DEPTH
      *iv_return = (IV)GL_MAX_DEPTH;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_WIDT", 11)) {
    /*                          H      */
#ifdef GL_MAX_WIDTH
      *iv_return = (IV)GL_MAX_WIDTH;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'I':
    if (memEQ(name, "GL_CON_0_AT", 11)) {
    /*                          I      */
#ifdef GL_CON_0_ATI
      *iv_return = (IV)GL_CON_0_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CON_1_AT", 11)) {
    /*                          I      */
#ifdef GL_CON_1_ATI
      *iv_return = (IV)GL_CON_1_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CON_2_AT", 11)) {
    /*                          I      */
#ifdef GL_CON_2_ATI
      *iv_return = (IV)GL_CON_2_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CON_3_AT", 11)) {
    /*                          I      */
#ifdef GL_CON_3_ATI
      *iv_return = (IV)GL_CON_3_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CON_4_AT", 11)) {
    /*                          I      */
#ifdef GL_CON_4_ATI
      *iv_return = (IV)GL_CON_4_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CON_5_AT", 11)) {
    /*                          I      */
#ifdef GL_CON_5_ATI
      *iv_return = (IV)GL_CON_5_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CON_6_AT", 11)) {
    /*                          I      */
#ifdef GL_CON_6_ATI
      *iv_return = (IV)GL_CON_6_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CON_7_AT", 11)) {
    /*                          I      */
#ifdef GL_CON_7_ATI
      *iv_return = (IV)GL_CON_7_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_REG_0_AT", 11)) {
    /*                          I      */
#ifdef GL_REG_0_ATI
      *iv_return = (IV)GL_REG_0_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_REG_1_AT", 11)) {
    /*                          I      */
#ifdef GL_REG_1_ATI
      *iv_return = (IV)GL_REG_1_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_REG_2_AT", 11)) {
    /*                          I      */
#ifdef GL_REG_2_ATI
      *iv_return = (IV)GL_REG_2_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_REG_3_AT", 11)) {
    /*                          I      */
#ifdef GL_REG_3_ATI
      *iv_return = (IV)GL_REG_3_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_REG_4_AT", 11)) {
    /*                          I      */
#ifdef GL_REG_4_ATI
      *iv_return = (IV)GL_REG_4_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_REG_5_AT", 11)) {
    /*                          I      */
#ifdef GL_REG_5_ATI
      *iv_return = (IV)GL_REG_5_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'L':
    if (memEQ(name, "GL_LOG_REGA", 11)) {
    /*                          L      */
#ifdef GL_LOG_REGAL
      *iv_return = (IV)GL_LOG_REGAL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'M':
    if (memEQ(name, "GL_COLOR_SU", 11)) {
    /*                          M      */
#ifdef GL_COLOR_SUM
      *iv_return = (IV)GL_COLOR_SUM;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_HISTOGRA", 11)) {
    /*                          M      */
#ifdef GL_HISTOGRAM
      *iv_return = (IV)GL_HISTOGRAM;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_R16_SNOR", 11)) {
    /*                          M      */
#ifdef GL_R16_SNORM
      *iv_return = (IV)GL_R16_SNORM;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RED_SNOR", 11)) {
    /*                          M      */
#ifdef GL_RED_SNORM
      *iv_return = (IV)GL_RED_SNORM;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RG8_SNOR", 11)) {
    /*                          M      */
#ifdef GL_RG8_SNORM
      *iv_return = (IV)GL_RG8_SNORM;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGB_SNOR", 11)) {
    /*                          M      */
#ifdef GL_RGB_SNORM
      *iv_return = (IV)GL_RGB_SNORM;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'N':
    if (memEQ(name, "GLEW_VERSIO", 11)) {
    /*                          N      */
#ifdef GLEW_VERSION
      *iv_return = (IV)GLEW_VERSION;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PHONG_WI", 11)) {
    /*                          N      */
#ifdef GL_PHONG_WIN
      *iv_return = (IV)GL_PHONG_WIN;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'P':
    if (memEQ(name, "GL_DECR_WRA", 11)) {
    /*                          P      */
#ifdef GL_DECR_WRAP
      *iv_return = (IV)GL_DECR_WRAP;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INCR_WRA", 11)) {
    /*                          P      */
#ifdef GL_INCR_WRAP
      *iv_return = (IV)GL_INCR_WRAP;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LINE_LOO", 11)) {
    /*                          P      */
#ifdef GL_LINE_LOOP
      *iv_return = (IV)GL_LINE_LOOP;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TIMESTAM", 11)) {
    /*                          P      */
#ifdef GL_TIMESTAMP
      *iv_return = (IV)GL_TIMESTAMP;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'R':
    if (memEQ(name, "GL_DST_COLO", 11)) {
    /*                          R      */
#ifdef GL_DST_COLOR
      *iv_return = (IV)GL_DST_COLOR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FOG_COLO", 11)) {
    /*                          R      */
#ifdef GL_FOG_COLOR
      *iv_return = (IV)GL_FOG_COLOR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAP_COLO", 11)) {
    /*                          R      */
#ifdef GL_MAP_COLOR
      *iv_return = (IV)GL_MAP_COLOR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SRC_COLO", 11)) {
    /*                          R      */
#ifdef GL_SRC_COLOR
      *iv_return = (IV)GL_SRC_COLOR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'S':
    if (memEQ(name, "GL_BLUE_BIA", 11)) {
    /*                          S      */
#ifdef GL_BLUE_BIAS
      *iv_return = (IV)GL_BLUE_BIAS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_BLUE_BIT", 11)) {
    /*                          S      */
#ifdef GL_BLUE_BITS
      *iv_return = (IV)GL_BLUE_BITS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SHININES", 11)) {
    /*                          S      */
#ifdef GL_SHININESS
      *iv_return = (IV)GL_SHININESS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TRIANGLE", 11)) {
    /*                          S      */
#ifdef GL_TRIANGLES
      *iv_return = (IV)GL_TRIANGLES;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'T':
    if (memEQ(name, "GL_1PASS_EX", 11)) {
    /*                          T      */
#ifdef GL_1PASS_EXT
      *iv_return = (IV)GL_1PASS_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_BACK_LEF", 11)) {
    /*                          T      */
#ifdef GL_BACK_LEFT
      *iv_return = (IV)GL_BACK_LEFT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_BLEND_DS", 11)) {
    /*                          T      */
#ifdef GL_BLEND_DST
      *iv_return = (IV)GL_BLEND_DST;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CMYKA_EX", 11)) {
    /*                          T      */
#ifdef GL_CMYKA_EXT
      *iv_return = (IV)GL_CMYKA_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CUBIC_EX", 11)) {
    /*                          T      */
#ifdef GL_CUBIC_EXT
      *iv_return = (IV)GL_CUBIC_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FOG_STAR", 11)) {
    /*                          T      */
#ifdef GL_FOG_START
      *iv_return = (IV)GL_FOG_START;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LOCAL_EX", 11)) {
    /*                          T      */
#ifdef GL_LOCAL_EXT
      *iv_return = (IV)GL_LOCAL_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LOW_FLOA", 11)) {
    /*                          T      */
#ifdef GL_LOW_FLOAT
      *iv_return = (IV)GL_LOW_FLOAT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_POINT_BI", 11)) {
    /*                          T      */
#ifdef GL_POINT_BIT
      *iv_return = (IV)GL_POINT_BIT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGB10_EX", 11)) {
    /*                          T      */
#ifdef GL_RGB10_EXT
      *iv_return = (IV)GL_RGB10_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGB12_EX", 11)) {
    /*                          T      */
#ifdef GL_RGB12_EXT
      *iv_return = (IV)GL_RGB12_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGB16_EX", 11)) {
    /*                          T      */
#ifdef GL_RGB16_EXT
      *iv_return = (IV)GL_RGB16_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGB8I_EX", 11)) {
    /*                          T      */
#ifdef GL_RGB8I_EXT
      *iv_return = (IV)GL_RGB8I_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGBA2_EX", 11)) {
    /*                          T      */
#ifdef GL_RGBA2_EXT
      *iv_return = (IV)GL_RGBA2_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGBA4_EX", 11)) {
    /*                          T      */
#ifdef GL_RGBA4_EXT
      *iv_return = (IV)GL_RGBA4_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGBA8_EX", 11)) {
    /*                          T      */
#ifdef GL_RGBA8_EXT
      *iv_return = (IV)GL_RGBA8_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SRGB8_EX", 11)) {
    /*                          T      */
#ifdef GL_SRGB8_EXT
      *iv_return = (IV)GL_SRGB8_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'V':
    if (memEQ(name, "GL_ARC_TO_N", 11)) {
    /*                          V      */
#ifdef GL_ARC_TO_NV
      *iv_return = (IV)GL_ARC_TO_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DARKEN_N", 11)) {
    /*                          V      */
#ifdef GL_DARKEN_NV
      *iv_return = (IV)GL_DARKEN_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DST_IN_N", 11)) {
    /*                          V      */
#ifdef GL_DST_IN_NV
      *iv_return = (IV)GL_DST_IN_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FIELDS_N", 11)) {
    /*                          V      */
#ifdef GL_FIELDS_NV
      *iv_return = (IV)GL_FIELDS_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_HILO16_N", 11)) {
    /*                          V      */
#ifdef GL_HILO16_NV
      *iv_return = (IV)GL_HILO16_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SCREEN_N", 11)) {
    /*                          V      */
#ifdef GL_SCREEN_NV
      *iv_return = (IV)GL_SCREEN_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SPARE0_N", 11)) {
    /*                          V      */
#ifdef GL_SPARE0_NV
      *iv_return = (IV)GL_SPARE0_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SPARE1_N", 11)) {
    /*                          V      */
#ifdef GL_SPARE1_NV
      *iv_return = (IV)GL_SPARE1_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SQUARE_N", 11)) {
    /*                          V      */
#ifdef GL_SQUARE_NV
      *iv_return = (IV)GL_SQUARE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SRC_IN_N", 11)) {
    /*                          V      */
#ifdef GL_SRC_IN_NV
      *iv_return = (IV)GL_SRC_IN_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'W':
    if (memEQ(name, "GL_MODELVIE", 11)) {
    /*                          W      */
#ifdef GL_MODELVIEW
      *iv_return = (IV)GL_MODELVIEW;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'X':
    if (memEQ(name, "GL_FOG_INDE", 11)) {
    /*                          X      */
#ifdef GL_FOG_INDEX
      *iv_return = (IV)GL_FOG_INDEX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'Y':
    if (memEQ(name, "GL_INTENSIT", 11)) {
    /*                          Y      */
#ifdef GL_INTENSITY
      *iv_return = (IV)GL_INTENSITY;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_READ_ONL", 11)) {
    /*                          Y      */
#ifdef GL_READ_ONLY
      *iv_return = (IV)GL_READ_ONLY;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'a':
    if (memEQ(name, "GL_EXT_cmyk", 11)) {
    /*                          a      */
#ifdef GL_EXT_cmyka
      *iv_return = (IV)GL_EXT_cmyka;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'c':
    if (memEQ(name, "GLEW_S3_s3t", 11)) {
    /*                          c      */
#ifdef GLEW_S3_s3tc
      *iv_return = (IV)GLEW_S3_s3tc;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'g':
    if (memEQ(name, "GL_KHR_debu", 11)) {
    /*                          g      */
#ifdef GL_KHR_debug
      *iv_return = (IV)GL_KHR_debug;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_REGAL_lo", 11)) {
    /*                          g      */
#ifdef GL_REGAL_log
      *iv_return = (IV)GL_REGAL_log;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  }
  return PERL_constant_NOTFOUND;
}

static int
constant_13 (pTHX_ const char *name, IV *iv_return) {
  /* When generated this function returned values for the list of names given
     here.  However, subsequent manual editing may have added or removed some.
     GLEW_ARB_sync GLEW_EXT_abgr GLEW_EXT_bgra GLEW_NO_ERROR GLEW_NV_fence
     GL_1PASS_SGIS GL_2X_BIT_ATI GL_4X_BIT_ATI GL_8X_BIT_ATI GL_ADD_SIGNED
     GL_ALPHA4_EXT GL_ALPHA8_EXT GL_ALPHA_BIAS GL_ALPHA_BITS GL_ALPHA_TEST
     GL_ARB_shadow GL_ARRAY_SIZE GL_BACK_RIGHT GL_BLUE_SCALE GL_CODE_REGAL
     GL_DARKEN_KHR GL_DECODE_EXT GL_DEPTH_BIAS GL_DEPTH_BITS GL_DEPTH_FUNC
     GL_DEPTH_TEST GL_DISCARD_NV GL_DOUBLE_EXT GL_DST_OUT_NV GL_DS_BIAS_NV
     GL_DT_BIAS_NV GL_DU8DV8_ATI GL_ENABLE_BIT GL_EVAL_2D_NV GL_EXTENSIONS
     GL_EYE_LINEAR GL_FAILURE_NV GL_FIXED_ONLY GL_FLOAT16_NV GL_FLOAT_MAT2
     GL_FLOAT_MAT3 GL_FLOAT_MAT4 GL_FLOAT_R_NV GL_FLOAT_VEC2 GL_FLOAT_VEC3
     GL_FLOAT_VEC4 GL_FRONT_FACE GL_FRONT_LEFT GL_GREEN_BIAS GL_GREEN_BITS
     GL_HALF_APPLE GL_HALF_FLOAT GL_HARDMIX_NV GL_HIGH_FLOAT GL_HI_BIAS_NV
     GL_HSL_HUE_NV GL_IMAGE_CUBE GL_INDEX_BITS GL_INDEX_MODE GL_INTENSITY4
     GL_INTENSITY8 GL_INVERSE_NV GL_LIGHTEN_NV GL_LINE_STRIP GL_LINE_TOKEN
     GL_LINE_TO_NV GL_LINE_WIDTH GL_LIST_INDEX GL_LOWER_LEFT GL_LO_BIAS_NV
     GL_LUMINANCE4 GL_LUMINANCE8 GL_MAP1_INDEX GL_MAP2_INDEX GL_MATRIX0_NV
     GL_MATRIX1_NV GL_MATRIX2_NV GL_MATRIX3_NV GL_MATRIX4_NV GL_MATRIX5_NV
     GL_MATRIX6_NV GL_MATRIX7_NV GL_MATRIX_EXT GL_MAX_HEIGHT GL_MAX_LAYERS
     GL_MAX_LIGHTS GL_MEDIUM_INT GL_MINMAX_EXT GL_MOVE_TO_NV GL_NORMAL_MAP
     GL_OP_ADD_EXT GL_OP_MAX_EXT GL_OP_MIN_EXT GL_OP_MOV_EXT GL_OP_MUL_EXT
     GL_OP_SUB_EXT GL_OR_REVERSE GL_OVERLAY_NV GL_POINT_SIZE GL_PROJECTION
     GL_QUAD_STRIP GL_QUERY_WAIT GL_READ_WRITE GL_REDUCE_EXT GL_RG16_SNORM
     GL_RGB10_A2UI GL_RGB16F_ARB GL_RGB16I_EXT GL_RGB32F_ARB GL_RGB32I_EXT
     GL_RGB8UI_EXT GL_RGB8_SNORM GL_RGBA12_EXT GL_RGBA16_EXT GL_RGBA4_S3TC
     GL_RGBA8I_EXT GL_RGBA_SNORM GL_RG_INTEGER GL_SAMPLER_1D GL_SAMPLER_2D
     GL_SAMPLER_3D GL_SCALAR_EXT GL_SCREEN_KHR GL_SGIX_async GL_SGIX_ycrcb
     GL_SLUMINANCE GL_SPHERE_MAP GL_SRC0_ALPHA GL_SRC1_ALPHA GL_SRC1_COLOR
     GL_SRC2_ALPHA GL_SRC_OUT_NV GL_SRGB_ALPHA GL_SRGB_WRITE GL_STATIC_ATI
     GL_SUCCESS_NV GL_SUN_vertex GL_SYNC_FENCE GL_SYNC_FLAGS GL_TEXTURE_1D
     GL_TEXTURE_2D GL_TEXTURE_3D GL_UNSIGNALED GL_UPPER_LEFT GL_VECTOR_EXT
     GL_WRITE_ONLY GL_YCBCR_MESA */
  /* Offset 6 gives the best switch position.  */
  switch (name[6]) {
  case '0':
    if (memEQ(name, "GL_SRC0_ALPHA", 13)) {
    /*                     ^             */
#ifdef GL_SRC0_ALPHA
      *iv_return = (IV)GL_SRC0_ALPHA;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '1':
    if (memEQ(name, "GL_MAP1_INDEX", 13)) {
    /*                     ^             */
#ifdef GL_MAP1_INDEX
      *iv_return = (IV)GL_MAP1_INDEX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGB10_A2UI", 13)) {
    /*                     ^             */
#ifdef GL_RGB10_A2UI
      *iv_return = (IV)GL_RGB10_A2UI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGB16F_ARB", 13)) {
    /*                     ^             */
#ifdef GL_RGB16F_ARB
      *iv_return = (IV)GL_RGB16F_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGB16I_EXT", 13)) {
    /*                     ^             */
#ifdef GL_RGB16I_EXT
      *iv_return = (IV)GL_RGB16I_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SRC1_ALPHA", 13)) {
    /*                     ^             */
#ifdef GL_SRC1_ALPHA
      *iv_return = (IV)GL_SRC1_ALPHA;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SRC1_COLOR", 13)) {
    /*                     ^             */
#ifdef GL_SRC1_COLOR
      *iv_return = (IV)GL_SRC1_COLOR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '2':
    if (memEQ(name, "GL_MAP2_INDEX", 13)) {
    /*                     ^             */
#ifdef GL_MAP2_INDEX
      *iv_return = (IV)GL_MAP2_INDEX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SRC2_ALPHA", 13)) {
    /*                     ^             */
#ifdef GL_SRC2_ALPHA
      *iv_return = (IV)GL_SRC2_ALPHA;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '3':
    if (memEQ(name, "GL_RGB32F_ARB", 13)) {
    /*                     ^             */
#ifdef GL_RGB32F_ARB
      *iv_return = (IV)GL_RGB32F_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGB32I_EXT", 13)) {
    /*                     ^             */
#ifdef GL_RGB32I_EXT
      *iv_return = (IV)GL_RGB32I_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '6':
    if (memEQ(name, "GL_RG16_SNORM", 13)) {
    /*                     ^             */
#ifdef GL_RG16_SNORM
      *iv_return = (IV)GL_RG16_SNORM;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '8':
    if (memEQ(name, "GL_RGB8UI_EXT", 13)) {
    /*                     ^             */
#ifdef GL_RGB8UI_EXT
      *iv_return = (IV)GL_RGB8UI_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGB8_SNORM", 13)) {
    /*                     ^             */
#ifdef GL_RGB8_SNORM
      *iv_return = (IV)GL_RGB8_SNORM;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'A':
    if (memEQ(name, "GL_ARRAY_SIZE", 13)) {
    /*                     ^             */
#ifdef GL_ARRAY_SIZE
      *iv_return = (IV)GL_ARRAY_SIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FLOAT16_NV", 13)) {
    /*                     ^             */
#ifdef GL_FLOAT16_NV
      *iv_return = (IV)GL_FLOAT16_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FLOAT_MAT2", 13)) {
    /*                     ^             */
#ifdef GL_FLOAT_MAT2
      *iv_return = (IV)GL_FLOAT_MAT2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FLOAT_MAT3", 13)) {
    /*                     ^             */
#ifdef GL_FLOAT_MAT3
      *iv_return = (IV)GL_FLOAT_MAT3;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FLOAT_MAT4", 13)) {
    /*                     ^             */
#ifdef GL_FLOAT_MAT4
      *iv_return = (IV)GL_FLOAT_MAT4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FLOAT_R_NV", 13)) {
    /*                     ^             */
#ifdef GL_FLOAT_R_NV
      *iv_return = (IV)GL_FLOAT_R_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FLOAT_VEC2", 13)) {
    /*                     ^             */
#ifdef GL_FLOAT_VEC2
      *iv_return = (IV)GL_FLOAT_VEC2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FLOAT_VEC3", 13)) {
    /*                     ^             */
#ifdef GL_FLOAT_VEC3
      *iv_return = (IV)GL_FLOAT_VEC3;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FLOAT_VEC4", 13)) {
    /*                     ^             */
#ifdef GL_FLOAT_VEC4
      *iv_return = (IV)GL_FLOAT_VEC4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OP_ADD_EXT", 13)) {
    /*                     ^             */
#ifdef GL_OP_ADD_EXT
      *iv_return = (IV)GL_OP_ADD_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGBA12_EXT", 13)) {
    /*                     ^             */
#ifdef GL_RGBA12_EXT
      *iv_return = (IV)GL_RGBA12_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGBA16_EXT", 13)) {
    /*                     ^             */
#ifdef GL_RGBA16_EXT
      *iv_return = (IV)GL_RGBA16_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGBA4_S3TC", 13)) {
    /*                     ^             */
#ifdef GL_RGBA4_S3TC
      *iv_return = (IV)GL_RGBA4_S3TC;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGBA8I_EXT", 13)) {
    /*                     ^             */
#ifdef GL_RGBA8I_EXT
      *iv_return = (IV)GL_RGBA8I_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGBA_SNORM", 13)) {
    /*                     ^             */
#ifdef GL_RGBA_SNORM
      *iv_return = (IV)GL_RGBA_SNORM;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'B':
    if (memEQ(name, "GL_2X_BIT_ATI", 13)) {
    /*                     ^             */
#ifdef GL_2X_BIT_ATI
      *iv_return = (IV)GL_2X_BIT_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_4X_BIT_ATI", 13)) {
    /*                     ^             */
#ifdef GL_4X_BIT_ATI
      *iv_return = (IV)GL_4X_BIT_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_8X_BIT_ATI", 13)) {
    /*                     ^             */
#ifdef GL_8X_BIT_ATI
      *iv_return = (IV)GL_8X_BIT_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DOUBLE_EXT", 13)) {
    /*                     ^             */
#ifdef GL_DOUBLE_EXT
      *iv_return = (IV)GL_DOUBLE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DS_BIAS_NV", 13)) {
    /*                     ^             */
#ifdef GL_DS_BIAS_NV
      *iv_return = (IV)GL_DS_BIAS_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DT_BIAS_NV", 13)) {
    /*                     ^             */
#ifdef GL_DT_BIAS_NV
      *iv_return = (IV)GL_DT_BIAS_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ENABLE_BIT", 13)) {
    /*                     ^             */
#ifdef GL_ENABLE_BIT
      *iv_return = (IV)GL_ENABLE_BIT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_HI_BIAS_NV", 13)) {
    /*                     ^             */
#ifdef GL_HI_BIAS_NV
      *iv_return = (IV)GL_HI_BIAS_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LO_BIAS_NV", 13)) {
    /*                     ^             */
#ifdef GL_LO_BIAS_NV
      *iv_return = (IV)GL_LO_BIAS_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SRGB_ALPHA", 13)) {
    /*                     ^             */
#ifdef GL_SRGB_ALPHA
      *iv_return = (IV)GL_SRGB_ALPHA;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SRGB_WRITE", 13)) {
    /*                     ^             */
#ifdef GL_SRGB_WRITE
      *iv_return = (IV)GL_SRGB_WRITE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'C':
    if (memEQ(name, "GL_DISCARD_NV", 13)) {
    /*                     ^             */
#ifdef GL_DISCARD_NV
      *iv_return = (IV)GL_DISCARD_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SUCCESS_NV", 13)) {
    /*                     ^             */
#ifdef GL_SUCCESS_NV
      *iv_return = (IV)GL_SUCCESS_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SYNC_FENCE", 13)) {
    /*                     ^             */
#ifdef GL_SYNC_FENCE
      *iv_return = (IV)GL_SYNC_FENCE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SYNC_FLAGS", 13)) {
    /*                     ^             */
#ifdef GL_SYNC_FLAGS
      *iv_return = (IV)GL_SYNC_FLAGS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_YCBCR_MESA", 13)) {
    /*                     ^             */
#ifdef GL_YCBCR_MESA
      *iv_return = (IV)GL_YCBCR_MESA;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'D':
    if (memEQ(name, "GL_DU8DV8_ATI", 13)) {
    /*                     ^             */
#ifdef GL_DU8DV8_ATI
      *iv_return = (IV)GL_DU8DV8_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_HARDMIX_NV", 13)) {
    /*                     ^             */
#ifdef GL_HARDMIX_NV
      *iv_return = (IV)GL_HARDMIX_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_QUAD_STRIP", 13)) {
    /*                     ^             */
#ifdef GL_QUAD_STRIP
      *iv_return = (IV)GL_QUAD_STRIP;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_READ_WRITE", 13)) {
    /*                     ^             */
#ifdef GL_READ_WRITE
      *iv_return = (IV)GL_READ_WRITE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'E':
    if (memEQ(name, "GL_BLUE_SCALE", 13)) {
    /*                     ^             */
#ifdef GL_BLUE_SCALE
      *iv_return = (IV)GL_BLUE_SCALE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CODE_REGAL", 13)) {
    /*                     ^             */
#ifdef GL_CODE_REGAL
      *iv_return = (IV)GL_CODE_REGAL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXTENSIONS", 13)) {
    /*                     ^             */
#ifdef GL_EXTENSIONS
      *iv_return = (IV)GL_EXTENSIONS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FIXED_ONLY", 13)) {
    /*                     ^             */
#ifdef GL_FIXED_ONLY
      *iv_return = (IV)GL_FIXED_ONLY;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_GREEN_BIAS", 13)) {
    /*                     ^             */
#ifdef GL_GREEN_BIAS
      *iv_return = (IV)GL_GREEN_BIAS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_GREEN_BITS", 13)) {
    /*                     ^             */
#ifdef GL_GREEN_BITS
      *iv_return = (IV)GL_GREEN_BITS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INDEX_BITS", 13)) {
    /*                     ^             */
#ifdef GL_INDEX_BITS
      *iv_return = (IV)GL_INDEX_BITS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INDEX_MODE", 13)) {
    /*                     ^             */
#ifdef GL_INDEX_MODE
      *iv_return = (IV)GL_INDEX_MODE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INTENSITY4", 13)) {
    /*                     ^             */
#ifdef GL_INTENSITY4
      *iv_return = (IV)GL_INTENSITY4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INTENSITY8", 13)) {
    /*                     ^             */
#ifdef GL_INTENSITY8
      *iv_return = (IV)GL_INTENSITY8;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INVERSE_NV", 13)) {
    /*                     ^             */
#ifdef GL_INVERSE_NV
      *iv_return = (IV)GL_INVERSE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LINE_STRIP", 13)) {
    /*                     ^             */
#ifdef GL_LINE_STRIP
      *iv_return = (IV)GL_LINE_STRIP;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LINE_TOKEN", 13)) {
    /*                     ^             */
#ifdef GL_LINE_TOKEN
      *iv_return = (IV)GL_LINE_TOKEN;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LINE_TO_NV", 13)) {
    /*                     ^             */
#ifdef GL_LINE_TO_NV
      *iv_return = (IV)GL_LINE_TO_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LINE_WIDTH", 13)) {
    /*                     ^             */
#ifdef GL_LINE_WIDTH
      *iv_return = (IV)GL_LINE_WIDTH;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LOWER_LEFT", 13)) {
    /*                     ^             */
#ifdef GL_LOWER_LEFT
      *iv_return = (IV)GL_LOWER_LEFT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MOVE_TO_NV", 13)) {
    /*                     ^             */
#ifdef GL_MOVE_TO_NV
      *iv_return = (IV)GL_MOVE_TO_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SCREEN_KHR", 13)) {
    /*                     ^             */
#ifdef GL_SCREEN_KHR
      *iv_return = (IV)GL_SCREEN_KHR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SPHERE_MAP", 13)) {
    /*                     ^             */
#ifdef GL_SPHERE_MAP
      *iv_return = (IV)GL_SPHERE_MAP;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UPPER_LEFT", 13)) {
    /*                     ^             */
#ifdef GL_UPPER_LEFT
      *iv_return = (IV)GL_UPPER_LEFT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'F':
    if (memEQ(name, "GL_HALF_APPLE", 13)) {
    /*                     ^             */
#ifdef GL_HALF_APPLE
      *iv_return = (IV)GL_HALF_APPLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_HALF_FLOAT", 13)) {
    /*                     ^             */
#ifdef GL_HALF_FLOAT
      *iv_return = (IV)GL_HALF_FLOAT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'G':
    if (memEQ(name, "GL_IMAGE_CUBE", 13)) {
    /*                     ^             */
#ifdef GL_IMAGE_CUBE
      *iv_return = (IV)GL_IMAGE_CUBE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'H':
    if (memEQ(name, "GL_ALPHA4_EXT", 13)) {
    /*                     ^             */
#ifdef GL_ALPHA4_EXT
      *iv_return = (IV)GL_ALPHA4_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ALPHA8_EXT", 13)) {
    /*                     ^             */
#ifdef GL_ALPHA8_EXT
      *iv_return = (IV)GL_ALPHA8_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ALPHA_BIAS", 13)) {
    /*                     ^             */
#ifdef GL_ALPHA_BIAS
      *iv_return = (IV)GL_ALPHA_BIAS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ALPHA_BITS", 13)) {
    /*                     ^             */
#ifdef GL_ALPHA_BITS
      *iv_return = (IV)GL_ALPHA_BITS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ALPHA_TEST", 13)) {
    /*                     ^             */
#ifdef GL_ALPHA_TEST
      *iv_return = (IV)GL_ALPHA_TEST;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_HIGH_FLOAT", 13)) {
    /*                     ^             */
#ifdef GL_HIGH_FLOAT
      *iv_return = (IV)GL_HIGH_FLOAT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LIGHTEN_NV", 13)) {
    /*                     ^             */
#ifdef GL_LIGHTEN_NV
      *iv_return = (IV)GL_LIGHTEN_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'I':
    if (memEQ(name, "GL_LUMINANCE4", 13)) {
    /*                     ^             */
#ifdef GL_LUMINANCE4
      *iv_return = (IV)GL_LUMINANCE4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LUMINANCE8", 13)) {
    /*                     ^             */
#ifdef GL_LUMINANCE8
      *iv_return = (IV)GL_LUMINANCE8;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MEDIUM_INT", 13)) {
    /*                     ^             */
#ifdef GL_MEDIUM_INT
      *iv_return = (IV)GL_MEDIUM_INT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RG_INTEGER", 13)) {
    /*                     ^             */
#ifdef GL_RG_INTEGER
      *iv_return = (IV)GL_RG_INTEGER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNSIGNALED", 13)) {
    /*                     ^             */
#ifdef GL_UNSIGNALED
      *iv_return = (IV)GL_UNSIGNALED;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'J':
    if (memEQ(name, "GL_PROJECTION", 13)) {
    /*                     ^             */
#ifdef GL_PROJECTION
      *iv_return = (IV)GL_PROJECTION;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'K':
    if (memEQ(name, "GL_BACK_RIGHT", 13)) {
    /*                     ^             */
#ifdef GL_BACK_RIGHT
      *iv_return = (IV)GL_BACK_RIGHT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DARKEN_KHR", 13)) {
    /*                     ^             */
#ifdef GL_DARKEN_KHR
      *iv_return = (IV)GL_DARKEN_KHR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'L':
    if (memEQ(name, "GL_EVAL_2D_NV", 13)) {
    /*                     ^             */
#ifdef GL_EVAL_2D_NV
      *iv_return = (IV)GL_EVAL_2D_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FAILURE_NV", 13)) {
    /*                     ^             */
#ifdef GL_FAILURE_NV
      *iv_return = (IV)GL_FAILURE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SCALAR_EXT", 13)) {
    /*                     ^             */
#ifdef GL_SCALAR_EXT
      *iv_return = (IV)GL_SCALAR_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'M':
    if (memEQ(name, "GL_MINMAX_EXT", 13)) {
    /*                     ^             */
#ifdef GL_MINMAX_EXT
      *iv_return = (IV)GL_MINMAX_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NORMAL_MAP", 13)) {
    /*                     ^             */
#ifdef GL_NORMAL_MAP
      *iv_return = (IV)GL_NORMAL_MAP;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OP_MAX_EXT", 13)) {
    /*                     ^             */
#ifdef GL_OP_MAX_EXT
      *iv_return = (IV)GL_OP_MAX_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OP_MIN_EXT", 13)) {
    /*                     ^             */
#ifdef GL_OP_MIN_EXT
      *iv_return = (IV)GL_OP_MIN_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OP_MOV_EXT", 13)) {
    /*                     ^             */
#ifdef GL_OP_MOV_EXT
      *iv_return = (IV)GL_OP_MOV_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OP_MUL_EXT", 13)) {
    /*                     ^             */
#ifdef GL_OP_MUL_EXT
      *iv_return = (IV)GL_OP_MUL_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SLUMINANCE", 13)) {
    /*                     ^             */
#ifdef GL_SLUMINANCE
      *iv_return = (IV)GL_SLUMINANCE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'N':
    if (memEQ(name, "GL_FRONT_FACE", 13)) {
    /*                     ^             */
#ifdef GL_FRONT_FACE
      *iv_return = (IV)GL_FRONT_FACE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FRONT_LEFT", 13)) {
    /*                     ^             */
#ifdef GL_FRONT_LEFT
      *iv_return = (IV)GL_FRONT_LEFT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_POINT_SIZE", 13)) {
    /*                     ^             */
#ifdef GL_POINT_SIZE
      *iv_return = (IV)GL_POINT_SIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'O':
    if (memEQ(name, "GLEW_NO_ERROR", 13)) {
    /*                     ^             */
#ifdef GLEW_NO_ERROR
      *iv_return = (IV)GLEW_NO_ERROR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DECODE_EXT", 13)) {
    /*                     ^             */
#ifdef GL_DECODE_EXT
      *iv_return = (IV)GL_DECODE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'P':
    if (memEQ(name, "GL_SAMPLER_1D", 13)) {
    /*                     ^             */
#ifdef GL_SAMPLER_1D
      *iv_return = (IV)GL_SAMPLER_1D;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLER_2D", 13)) {
    /*                     ^             */
#ifdef GL_SAMPLER_2D
      *iv_return = (IV)GL_SAMPLER_2D;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLER_3D", 13)) {
    /*                     ^             */
#ifdef GL_SAMPLER_3D
      *iv_return = (IV)GL_SAMPLER_3D;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'R':
    if (memEQ(name, "GLEW_ARB_sync", 13)) {
    /*                     ^             */
#ifdef GLEW_ARB_sync
      *iv_return = (IV)GLEW_ARB_sync;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MATRIX0_NV", 13)) {
    /*                     ^             */
#ifdef GL_MATRIX0_NV
      *iv_return = (IV)GL_MATRIX0_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MATRIX1_NV", 13)) {
    /*                     ^             */
#ifdef GL_MATRIX1_NV
      *iv_return = (IV)GL_MATRIX1_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MATRIX2_NV", 13)) {
    /*                     ^             */
#ifdef GL_MATRIX2_NV
      *iv_return = (IV)GL_MATRIX2_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MATRIX3_NV", 13)) {
    /*                     ^             */
#ifdef GL_MATRIX3_NV
      *iv_return = (IV)GL_MATRIX3_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MATRIX4_NV", 13)) {
    /*                     ^             */
#ifdef GL_MATRIX4_NV
      *iv_return = (IV)GL_MATRIX4_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MATRIX5_NV", 13)) {
    /*                     ^             */
#ifdef GL_MATRIX5_NV
      *iv_return = (IV)GL_MATRIX5_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MATRIX6_NV", 13)) {
    /*                     ^             */
#ifdef GL_MATRIX6_NV
      *iv_return = (IV)GL_MATRIX6_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MATRIX7_NV", 13)) {
    /*                     ^             */
#ifdef GL_MATRIX7_NV
      *iv_return = (IV)GL_MATRIX7_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MATRIX_EXT", 13)) {
    /*                     ^             */
#ifdef GL_MATRIX_EXT
      *iv_return = (IV)GL_MATRIX_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OR_REVERSE", 13)) {
    /*                     ^             */
#ifdef GL_OR_REVERSE
      *iv_return = (IV)GL_OR_REVERSE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OVERLAY_NV", 13)) {
    /*                     ^             */
#ifdef GL_OVERLAY_NV
      *iv_return = (IV)GL_OVERLAY_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_QUERY_WAIT", 13)) {
    /*                     ^             */
#ifdef GL_QUERY_WAIT
      *iv_return = (IV)GL_QUERY_WAIT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'S':
    if (memEQ(name, "GL_1PASS_SGIS", 13)) {
    /*                     ^             */
#ifdef GL_1PASS_SGIS
      *iv_return = (IV)GL_1PASS_SGIS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OP_SUB_EXT", 13)) {
    /*                     ^             */
#ifdef GL_OP_SUB_EXT
      *iv_return = (IV)GL_OP_SUB_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'T':
    if (memEQ(name, "GL_DEPTH_BIAS", 13)) {
    /*                     ^             */
#ifdef GL_DEPTH_BIAS
      *iv_return = (IV)GL_DEPTH_BIAS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEPTH_BITS", 13)) {
    /*                     ^             */
#ifdef GL_DEPTH_BITS
      *iv_return = (IV)GL_DEPTH_BITS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEPTH_FUNC", 13)) {
    /*                     ^             */
#ifdef GL_DEPTH_FUNC
      *iv_return = (IV)GL_DEPTH_FUNC;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEPTH_TEST", 13)) {
    /*                     ^             */
#ifdef GL_DEPTH_TEST
      *iv_return = (IV)GL_DEPTH_TEST;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LIST_INDEX", 13)) {
    /*                     ^             */
#ifdef GL_LIST_INDEX
      *iv_return = (IV)GL_LIST_INDEX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STATIC_ATI", 13)) {
    /*                     ^             */
#ifdef GL_STATIC_ATI
      *iv_return = (IV)GL_STATIC_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_1D", 13)) {
    /*                     ^             */
#ifdef GL_TEXTURE_1D
      *iv_return = (IV)GL_TEXTURE_1D;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_2D", 13)) {
    /*                     ^             */
#ifdef GL_TEXTURE_2D
      *iv_return = (IV)GL_TEXTURE_2D;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_3D", 13)) {
    /*                     ^             */
#ifdef GL_TEXTURE_3D
      *iv_return = (IV)GL_TEXTURE_3D;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VECTOR_EXT", 13)) {
    /*                     ^             */
#ifdef GL_VECTOR_EXT
      *iv_return = (IV)GL_VECTOR_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_WRITE_ONLY", 13)) {
    /*                     ^             */
#ifdef GL_WRITE_ONLY
      *iv_return = (IV)GL_WRITE_ONLY;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'U':
    if (memEQ(name, "GL_REDUCE_EXT", 13)) {
    /*                     ^             */
#ifdef GL_REDUCE_EXT
      *iv_return = (IV)GL_REDUCE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'V':
    if (memEQ(name, "GLEW_NV_fence", 13)) {
    /*                     ^             */
#ifdef GLEW_NV_fence
      *iv_return = (IV)GLEW_NV_fence;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'X':
    if (memEQ(name, "GLEW_EXT_abgr", 13)) {
    /*                     ^             */
#ifdef GLEW_EXT_abgr
      *iv_return = (IV)GLEW_EXT_abgr;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_EXT_bgra", 13)) {
    /*                     ^             */
#ifdef GLEW_EXT_bgra
      *iv_return = (IV)GLEW_EXT_bgra;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SGIX_async", 13)) {
    /*                     ^             */
#ifdef GL_SGIX_async
      *iv_return = (IV)GL_SGIX_async;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SGIX_ycrcb", 13)) {
    /*                     ^             */
#ifdef GL_SGIX_ycrcb
      *iv_return = (IV)GL_SGIX_ycrcb;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '_':
    if (memEQ(name, "GL_ADD_SIGNED", 13)) {
    /*                     ^             */
#ifdef GL_ADD_SIGNED
      *iv_return = (IV)GL_ADD_SIGNED;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_shadow", 13)) {
    /*                     ^             */
#ifdef GL_ARB_shadow
      *iv_return = (IV)GL_ARB_shadow;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DST_OUT_NV", 13)) {
    /*                     ^             */
#ifdef GL_DST_OUT_NV
      *iv_return = (IV)GL_DST_OUT_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EYE_LINEAR", 13)) {
    /*                     ^             */
#ifdef GL_EYE_LINEAR
      *iv_return = (IV)GL_EYE_LINEAR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_HSL_HUE_NV", 13)) {
    /*                     ^             */
#ifdef GL_HSL_HUE_NV
      *iv_return = (IV)GL_HSL_HUE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_HEIGHT", 13)) {
    /*                     ^             */
#ifdef GL_MAX_HEIGHT
      *iv_return = (IV)GL_MAX_HEIGHT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_LAYERS", 13)) {
    /*                     ^             */
#ifdef GL_MAX_LAYERS
      *iv_return = (IV)GL_MAX_LAYERS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_LIGHTS", 13)) {
    /*                     ^             */
#ifdef GL_MAX_LIGHTS
      *iv_return = (IV)GL_MAX_LIGHTS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SRC_OUT_NV", 13)) {
    /*                     ^             */
#ifdef GL_SRC_OUT_NV
      *iv_return = (IV)GL_SRC_OUT_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SUN_vertex", 13)) {
    /*                     ^             */
#ifdef GL_SUN_vertex
      *iv_return = (IV)GL_SUN_vertex;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  }
  return PERL_constant_NOTFOUND;
}

static int
constant_14 (pTHX_ const char *name, IV *iv_return) {
  /* When generated this function returned values for the list of names given
     here.  However, subsequent manual editing may have added or removed some.
     GLEW_EXT_cmyka GLEW_KHR_debug GLEW_REGAL_log GL_2PASS_0_EXT GL_2PASS_1_EXT
     GL_422_REV_EXT GL_4PASS_0_EXT GL_4PASS_1_EXT GL_4PASS_2_EXT GL_4PASS_3_EXT
     GL_ALPHA12_EXT GL_ALPHA16_EXT GL_ALPHA8I_EXT GL_ALPHA_SCALE GL_ALPHA_SNORM
     GL_AND_REVERSE GL_APPLE_fence GL_ARB_imaging GL_ATI_meminfo GL_AUTO_NORMAL
     GL_AUX_BUFFERS GL_AVERAGE_EXT GL_BGR_INTEGER GL_BLEND_COLOR GL_BLOCK_INDEX
     GL_BOLD_BIT_NV GL_BUFFER_SIZE GL_C4F_N3F_V3F GL_CACHE_REGAL GL_CLIP_ORIGIN
     GL_CLIP_PLANE0 GL_CLIP_PLANE1 GL_CLIP_PLANE2 GL_CLIP_PLANE3 GL_CLIP_PLANE4
     GL_CLIP_PLANE5 GL_COLOR_ARRAY GL_COLOR_INDEX GL_COLOR_TABLE GL_COMBINE4_NV
     GL_COMBINE_ARB GL_COMBINE_EXT GL_COMBINE_RGB GL_CONJOINT_NV GL_CONTRAST_NV
     GL_COUNT_UP_NV GL_CURRENT_BIT GL_DEBUG_REGAL GL_DEPTH_CLAMP GL_DEPTH_RANGE
     GL_DEPTH_SCALE GL_DISCARD_ATI GL_DISJOINT_NV GL_DOUBLE_MAT2 GL_DOUBLE_MAT3
     GL_DOUBLE_MAT4 GL_DOUBLE_VEC2 GL_DOUBLE_VEC3 GL_DOUBLE_VEC4 GL_DRAW_BUFFER
     GL_DSDT_MAG_NV GL_DST_ATOP_NV GL_DST_OVER_NV GL_DS_SCALE_NV GL_DT_SCALE_NV
     GL_DYNAMIC_ATI GL_ERROR_REGAL GL_EXT_texture GL_FENCE_APPLE GL_FLOAT_RG_NV
     GL_FOG_DENSITY GL_FRAMEBUFFER GL_FRONT_RIGHT GL_GREEN_SCALE GL_HI_SCALE_NV
     GL_HSL_HUE_KHR GL_IDENTITY_NV GL_INDEX_ARRAY GL_INDEX_SHIFT GL_INTENSITY12
     GL_INTENSITY16 GL_INTERPOLATE GL_LIGHTEN_KHR GL_LINE_SMOOTH GL_LINK_STATUS
     GL_LO_SCALE_NV GL_LUMINANCE12 GL_LUMINANCE16 GL_MAP1_NORMAL GL_MAP2_NORMAL
     GL_MAP_STENCIL GL_MATRIX0_ARB GL_MATRIX1_ARB GL_MATRIX2_ARB GL_MATRIX3_ARB
     GL_MATRIX4_ARB GL_MATRIX5_ARB GL_MATRIX6_ARB GL_MATRIX7_ARB GL_MATRIX8_ARB
     GL_MATRIX9_ARB GL_MATRIX_MODE GL_MAX_SAMPLES GL_MINMAX_SINK GL_MULTIPLY_NV
     GL_MULTISAMPLE GL_NAME_LENGTH GL_OBJECT_TYPE GL_OP_DOT3_EXT GL_OP_DOT4_EXT
     GL_OP_FRAC_EXT GL_OP_MADD_EXT GL_OR_INVERTED GL_OVERLAY_KHR GL_PERTURB_EXT
     GL_PINLIGHT_NV GL_POINT_TOKEN GL_POLYGON_BIT GL_READ_BUFFER GL_READ_PIXELS
     GL_RED_BIT_ATI GL_RED_INTEGER GL_RENDER_MODE GL_REPLACE_EXT GL_RESTART_SUN
     GL_RGB16UI_EXT GL_RGB16_SNORM GL_RGB32UI_EXT GL_RGB5_A1_EXT GL_RGB9_E5_EXT
     GL_RGBA16F_ARB GL_RGBA16I_EXT GL_RGBA32F_ARB GL_RGBA32I_EXT GL_RGBA8UI_EXT
     GL_RGBA8_SNORM GL_RGB_INTEGER GL_SAMPLES_ARB GL_SAMPLES_EXT GL_SAMPLE_MASK
     GL_SCISSOR_BIT GL_SCISSOR_BOX GL_SGIX_shadow GL_SGIX_sprite GL_SHADER_TYPE
     GL_SHADE_MODEL GL_SLUMINANCE8 GL_SM_COUNT_NV GL_SOURCE0_RGB GL_SOURCE1_RGB
     GL_SOURCE2_RGB GL_SPOT_CUTOFF GL_SRC_ATOP_NV GL_SRC_OVER_NV GL_STATIC_COPY
     GL_STATIC_DRAW GL_STATIC_READ GL_STENCIL_REF GL_STREAM_COPY GL_STREAM_DRAW
     GL_STREAM_READ GL_SYNC_STATUS GL_T2F_C3F_V3F GL_T2F_N3F_V3F GL_TEXTURE_BIT
     GL_TEXTURE_ENV GL_TRACE_REGAL GL_VARIANT_EXT GL_VERSION_1_1 GL_VERSION_1_2
     GL_VERSION_1_3 GL_VERSION_1_4 GL_VERSION_1_5 GL_VERSION_2_0 GL_VERSION_2_1
     GL_VERSION_3_0 GL_VERSION_3_1 GL_VERSION_3_2 GL_VERSION_3_3 GL_VERSION_4_0
     GL_VERSION_4_1 GL_VERSION_4_2 GL_VERSION_4_3 GL_VERSION_4_4 GL_VERSION_4_5
     GL_WAIT_FAILED GL_WRAP_BORDER GL_ZERO_TO_ONE */
  /* Offset 9 gives the best switch position.  */
  switch (name[9]) {
  case '0':
    if (memEQ(name, "GL_2PASS_0_EXT", 14)) {
    /*                        ^           */
#ifdef GL_2PASS_0_EXT
      *iv_return = (IV)GL_2PASS_0_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_4PASS_0_EXT", 14)) {
    /*                        ^           */
#ifdef GL_4PASS_0_EXT
      *iv_return = (IV)GL_4PASS_0_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MATRIX0_ARB", 14)) {
    /*                        ^           */
#ifdef GL_MATRIX0_ARB
      *iv_return = (IV)GL_MATRIX0_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SOURCE0_RGB", 14)) {
    /*                        ^           */
#ifdef GL_SOURCE0_RGB
      *iv_return = (IV)GL_SOURCE0_RGB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '1':
    if (memEQ(name, "GL_2PASS_1_EXT", 14)) {
    /*                        ^           */
#ifdef GL_2PASS_1_EXT
      *iv_return = (IV)GL_2PASS_1_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_4PASS_1_EXT", 14)) {
    /*                        ^           */
#ifdef GL_4PASS_1_EXT
      *iv_return = (IV)GL_4PASS_1_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MATRIX1_ARB", 14)) {
    /*                        ^           */
#ifdef GL_MATRIX1_ARB
      *iv_return = (IV)GL_MATRIX1_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGB5_A1_EXT", 14)) {
    /*                        ^           */
#ifdef GL_RGB5_A1_EXT
      *iv_return = (IV)GL_RGB5_A1_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SOURCE1_RGB", 14)) {
    /*                        ^           */
#ifdef GL_SOURCE1_RGB
      *iv_return = (IV)GL_SOURCE1_RGB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '2':
    if (memEQ(name, "GL_4PASS_2_EXT", 14)) {
    /*                        ^           */
#ifdef GL_4PASS_2_EXT
      *iv_return = (IV)GL_4PASS_2_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ALPHA12_EXT", 14)) {
    /*                        ^           */
#ifdef GL_ALPHA12_EXT
      *iv_return = (IV)GL_ALPHA12_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MATRIX2_ARB", 14)) {
    /*                        ^           */
#ifdef GL_MATRIX2_ARB
      *iv_return = (IV)GL_MATRIX2_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SOURCE2_RGB", 14)) {
    /*                        ^           */
#ifdef GL_SOURCE2_RGB
      *iv_return = (IV)GL_SOURCE2_RGB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '3':
    if (memEQ(name, "GL_4PASS_3_EXT", 14)) {
    /*                        ^           */
#ifdef GL_4PASS_3_EXT
      *iv_return = (IV)GL_4PASS_3_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MATRIX3_ARB", 14)) {
    /*                        ^           */
#ifdef GL_MATRIX3_ARB
      *iv_return = (IV)GL_MATRIX3_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OP_DOT3_EXT", 14)) {
    /*                        ^           */
#ifdef GL_OP_DOT3_EXT
      *iv_return = (IV)GL_OP_DOT3_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '4':
    if (memEQ(name, "GL_MATRIX4_ARB", 14)) {
    /*                        ^           */
#ifdef GL_MATRIX4_ARB
      *iv_return = (IV)GL_MATRIX4_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OP_DOT4_EXT", 14)) {
    /*                        ^           */
#ifdef GL_OP_DOT4_EXT
      *iv_return = (IV)GL_OP_DOT4_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '5':
    if (memEQ(name, "GL_MATRIX5_ARB", 14)) {
    /*                        ^           */
#ifdef GL_MATRIX5_ARB
      *iv_return = (IV)GL_MATRIX5_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGB9_E5_EXT", 14)) {
    /*                        ^           */
#ifdef GL_RGB9_E5_EXT
      *iv_return = (IV)GL_RGB9_E5_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '6':
    if (memEQ(name, "GL_ALPHA16_EXT", 14)) {
    /*                        ^           */
#ifdef GL_ALPHA16_EXT
      *iv_return = (IV)GL_ALPHA16_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MATRIX6_ARB", 14)) {
    /*                        ^           */
#ifdef GL_MATRIX6_ARB
      *iv_return = (IV)GL_MATRIX6_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '7':
    if (memEQ(name, "GL_MATRIX7_ARB", 14)) {
    /*                        ^           */
#ifdef GL_MATRIX7_ARB
      *iv_return = (IV)GL_MATRIX7_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '8':
    if (memEQ(name, "GL_MATRIX8_ARB", 14)) {
    /*                        ^           */
#ifdef GL_MATRIX8_ARB
      *iv_return = (IV)GL_MATRIX8_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '9':
    if (memEQ(name, "GL_MATRIX9_ARB", 14)) {
    /*                        ^           */
#ifdef GL_MATRIX9_ARB
      *iv_return = (IV)GL_MATRIX9_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'A':
    if (memEQ(name, "GL_COLOR_ARRAY", 14)) {
    /*                        ^           */
#ifdef GL_COLOR_ARRAY
      *iv_return = (IV)GL_COLOR_ARRAY;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DSDT_MAG_NV", 14)) {
    /*                        ^           */
#ifdef GL_DSDT_MAG_NV
      *iv_return = (IV)GL_DSDT_MAG_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FENCE_APPLE", 14)) {
    /*                        ^           */
#ifdef GL_FENCE_APPLE
      *iv_return = (IV)GL_FENCE_APPLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INDEX_ARRAY", 14)) {
    /*                        ^           */
#ifdef GL_INDEX_ARRAY
      *iv_return = (IV)GL_INDEX_ARRAY;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MULTISAMPLE", 14)) {
    /*                        ^           */
#ifdef GL_MULTISAMPLE
      *iv_return = (IV)GL_MULTISAMPLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SLUMINANCE8", 14)) {
    /*                        ^           */
#ifdef GL_SLUMINANCE8
      *iv_return = (IV)GL_SLUMINANCE8;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_WAIT_FAILED", 14)) {
    /*                        ^           */
#ifdef GL_WAIT_FAILED
      *iv_return = (IV)GL_WAIT_FAILED;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'B':
    if (memEQ(name, "GL_PERTURB_EXT", 14)) {
    /*                        ^           */
#ifdef GL_PERTURB_EXT
      *iv_return = (IV)GL_PERTURB_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'C':
    if (memEQ(name, "GL_BLEND_COLOR", 14)) {
    /*                        ^           */
#ifdef GL_BLEND_COLOR
      *iv_return = (IV)GL_BLEND_COLOR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEPTH_CLAMP", 14)) {
    /*                        ^           */
#ifdef GL_DEPTH_CLAMP
      *iv_return = (IV)GL_DEPTH_CLAMP;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DYNAMIC_ATI", 14)) {
    /*                        ^           */
#ifdef GL_DYNAMIC_ATI
      *iv_return = (IV)GL_DYNAMIC_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OP_FRAC_EXT", 14)) {
    /*                        ^           */
#ifdef GL_OP_FRAC_EXT
      *iv_return = (IV)GL_OP_FRAC_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'D':
    if (memEQ(name, "GL_DISCARD_ATI", 14)) {
    /*                        ^           */
#ifdef GL_DISCARD_ATI
      *iv_return = (IV)GL_DISCARD_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OP_MADD_EXT", 14)) {
    /*                        ^           */
#ifdef GL_OP_MADD_EXT
      *iv_return = (IV)GL_OP_MADD_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'E':
    if (memEQ(name, "GL_AVERAGE_EXT", 14)) {
    /*                        ^           */
#ifdef GL_AVERAGE_EXT
      *iv_return = (IV)GL_AVERAGE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COMBINE4_NV", 14)) {
    /*                        ^           */
#ifdef GL_COMBINE4_NV
      *iv_return = (IV)GL_COMBINE4_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COMBINE_ARB", 14)) {
    /*                        ^           */
#ifdef GL_COMBINE_ARB
      *iv_return = (IV)GL_COMBINE_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COMBINE_EXT", 14)) {
    /*                        ^           */
#ifdef GL_COMBINE_EXT
      *iv_return = (IV)GL_COMBINE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COMBINE_RGB", 14)) {
    /*                        ^           */
#ifdef GL_COMBINE_RGB
      *iv_return = (IV)GL_COMBINE_RGB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DST_OVER_NV", 14)) {
    /*                        ^           */
#ifdef GL_DST_OVER_NV
      *iv_return = (IV)GL_DST_OVER_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_HSL_HUE_KHR", 14)) {
    /*                        ^           */
#ifdef GL_HSL_HUE_KHR
      *iv_return = (IV)GL_HSL_HUE_KHR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAP_STENCIL", 14)) {
    /*                        ^           */
#ifdef GL_MAP_STENCIL
      *iv_return = (IV)GL_MAP_STENCIL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NAME_LENGTH", 14)) {
    /*                        ^           */
#ifdef GL_NAME_LENGTH
      *iv_return = (IV)GL_NAME_LENGTH;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OR_INVERTED", 14)) {
    /*                        ^           */
#ifdef GL_OR_INVERTED
      *iv_return = (IV)GL_OR_INVERTED;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_REPLACE_EXT", 14)) {
    /*                        ^           */
#ifdef GL_REPLACE_EXT
      *iv_return = (IV)GL_REPLACE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SRC_OVER_NV", 14)) {
    /*                        ^           */
#ifdef GL_SRC_OVER_NV
      *iv_return = (IV)GL_SRC_OVER_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_BIT", 14)) {
    /*                        ^           */
#ifdef GL_TEXTURE_BIT
      *iv_return = (IV)GL_TEXTURE_BIT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_ENV", 14)) {
    /*                        ^           */
#ifdef GL_TEXTURE_ENV
      *iv_return = (IV)GL_TEXTURE_ENV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'F':
    if (memEQ(name, "GL_AUX_BUFFERS", 14)) {
    /*                        ^           */
#ifdef GL_AUX_BUFFERS
      *iv_return = (IV)GL_AUX_BUFFERS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_C4F_N3F_V3F", 14)) {
    /*                        ^           */
#ifdef GL_C4F_N3F_V3F
      *iv_return = (IV)GL_C4F_N3F_V3F;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGBA16F_ARB", 14)) {
    /*                        ^           */
#ifdef GL_RGBA16F_ARB
      *iv_return = (IV)GL_RGBA16F_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGBA32F_ARB", 14)) {
    /*                        ^           */
#ifdef GL_RGBA32F_ARB
      *iv_return = (IV)GL_RGBA32F_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_T2F_C3F_V3F", 14)) {
    /*                        ^           */
#ifdef GL_T2F_C3F_V3F
      *iv_return = (IV)GL_T2F_C3F_V3F;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_T2F_N3F_V3F", 14)) {
    /*                        ^           */
#ifdef GL_T2F_N3F_V3F
      *iv_return = (IV)GL_T2F_N3F_V3F;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'H':
    if (memEQ(name, "GL_PINLIGHT_NV", 14)) {
    /*                        ^           */
#ifdef GL_PINLIGHT_NV
      *iv_return = (IV)GL_PINLIGHT_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'I':
    if (memEQ(name, "GL_ALPHA8I_EXT", 14)) {
    /*                        ^           */
#ifdef GL_ALPHA8I_EXT
      *iv_return = (IV)GL_ALPHA8I_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_BLOCK_INDEX", 14)) {
    /*                        ^           */
#ifdef GL_BLOCK_INDEX
      *iv_return = (IV)GL_BLOCK_INDEX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_BOLD_BIT_NV", 14)) {
    /*                        ^           */
#ifdef GL_BOLD_BIT_NV
      *iv_return = (IV)GL_BOLD_BIT_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_INDEX", 14)) {
    /*                        ^           */
#ifdef GL_COLOR_INDEX
      *iv_return = (IV)GL_COLOR_INDEX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INTENSITY12", 14)) {
    /*                        ^           */
#ifdef GL_INTENSITY12
      *iv_return = (IV)GL_INTENSITY12;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INTENSITY16", 14)) {
    /*                        ^           */
#ifdef GL_INTENSITY16
      *iv_return = (IV)GL_INTENSITY16;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_READ_PIXELS", 14)) {
    /*                        ^           */
#ifdef GL_READ_PIXELS
      *iv_return = (IV)GL_READ_PIXELS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGB16UI_EXT", 14)) {
    /*                        ^           */
#ifdef GL_RGB16UI_EXT
      *iv_return = (IV)GL_RGB16UI_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGB32UI_EXT", 14)) {
    /*                        ^           */
#ifdef GL_RGB32UI_EXT
      *iv_return = (IV)GL_RGB32UI_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGBA16I_EXT", 14)) {
    /*                        ^           */
#ifdef GL_RGBA16I_EXT
      *iv_return = (IV)GL_RGBA16I_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGBA32I_EXT", 14)) {
    /*                        ^           */
#ifdef GL_RGBA32I_EXT
      *iv_return = (IV)GL_RGBA32I_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGBA8UI_EXT", 14)) {
    /*                        ^           */
#ifdef GL_RGBA8UI_EXT
      *iv_return = (IV)GL_RGBA8UI_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'L':
    if (memEQ(name, "GLEW_REGAL_log", 14)) {
    /*                        ^           */
#ifdef GLEW_REGAL_log
      *iv_return = (IV)GLEW_REGAL_log;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CLIP_PLANE0", 14)) {
    /*                        ^           */
#ifdef GL_CLIP_PLANE0
      *iv_return = (IV)GL_CLIP_PLANE0;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CLIP_PLANE1", 14)) {
    /*                        ^           */
#ifdef GL_CLIP_PLANE1
      *iv_return = (IV)GL_CLIP_PLANE1;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CLIP_PLANE2", 14)) {
    /*                        ^           */
#ifdef GL_CLIP_PLANE2
      *iv_return = (IV)GL_CLIP_PLANE2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CLIP_PLANE3", 14)) {
    /*                        ^           */
#ifdef GL_CLIP_PLANE3
      *iv_return = (IV)GL_CLIP_PLANE3;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CLIP_PLANE4", 14)) {
    /*                        ^           */
#ifdef GL_CLIP_PLANE4
      *iv_return = (IV)GL_CLIP_PLANE4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CLIP_PLANE5", 14)) {
    /*                        ^           */
#ifdef GL_CLIP_PLANE5
      *iv_return = (IV)GL_CLIP_PLANE5;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DS_SCALE_NV", 14)) {
    /*                        ^           */
#ifdef GL_DS_SCALE_NV
      *iv_return = (IV)GL_DS_SCALE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DT_SCALE_NV", 14)) {
    /*                        ^           */
#ifdef GL_DT_SCALE_NV
      *iv_return = (IV)GL_DT_SCALE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_HI_SCALE_NV", 14)) {
    /*                        ^           */
#ifdef GL_HI_SCALE_NV
      *iv_return = (IV)GL_HI_SCALE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LO_SCALE_NV", 14)) {
    /*                        ^           */
#ifdef GL_LO_SCALE_NV
      *iv_return = (IV)GL_LO_SCALE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MULTIPLY_NV", 14)) {
    /*                        ^           */
#ifdef GL_MULTIPLY_NV
      *iv_return = (IV)GL_MULTIPLY_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STENCIL_REF", 14)) {
    /*                        ^           */
#ifdef GL_STENCIL_REF
      *iv_return = (IV)GL_STENCIL_REF;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'M':
    if (memEQ(name, "GL_LINE_SMOOTH", 14)) {
    /*                        ^           */
#ifdef GL_LINE_SMOOTH
      *iv_return = (IV)GL_LINE_SMOOTH;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_SAMPLES", 14)) {
    /*                        ^           */
#ifdef GL_MAX_SAMPLES
      *iv_return = (IV)GL_MAX_SAMPLES;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SHADE_MODEL", 14)) {
    /*                        ^           */
#ifdef GL_SHADE_MODEL
      *iv_return = (IV)GL_SHADE_MODEL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'N':
    if (memEQ(name, "GL_CONJOINT_NV", 14)) {
    /*                        ^           */
#ifdef GL_CONJOINT_NV
      *iv_return = (IV)GL_CONJOINT_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DISJOINT_NV", 14)) {
    /*                        ^           */
#ifdef GL_DISJOINT_NV
      *iv_return = (IV)GL_DISJOINT_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FOG_DENSITY", 14)) {
    /*                        ^           */
#ifdef GL_FOG_DENSITY
      *iv_return = (IV)GL_FOG_DENSITY;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LIGHTEN_KHR", 14)) {
    /*                        ^           */
#ifdef GL_LIGHTEN_KHR
      *iv_return = (IV)GL_LIGHTEN_KHR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LUMINANCE12", 14)) {
    /*                        ^           */
#ifdef GL_LUMINANCE12
      *iv_return = (IV)GL_LUMINANCE12;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LUMINANCE16", 14)) {
    /*                        ^           */
#ifdef GL_LUMINANCE16
      *iv_return = (IV)GL_LUMINANCE16;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_POLYGON_BIT", 14)) {
    /*                        ^           */
#ifdef GL_POLYGON_BIT
      *iv_return = (IV)GL_POLYGON_BIT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SM_COUNT_NV", 14)) {
    /*                        ^           */
#ifdef GL_SM_COUNT_NV
      *iv_return = (IV)GL_SM_COUNT_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERSION_1_1", 14)) {
    /*                        ^           */
#ifdef GL_VERSION_1_1
      *iv_return = (IV)GL_VERSION_1_1;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERSION_1_2", 14)) {
    /*                        ^           */
#ifdef GL_VERSION_1_2
      *iv_return = (IV)GL_VERSION_1_2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERSION_1_3", 14)) {
    /*                        ^           */
#ifdef GL_VERSION_1_3
      *iv_return = (IV)GL_VERSION_1_3;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERSION_1_4", 14)) {
    /*                        ^           */
#ifdef GL_VERSION_1_4
      *iv_return = (IV)GL_VERSION_1_4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERSION_1_5", 14)) {
    /*                        ^           */
#ifdef GL_VERSION_1_5
      *iv_return = (IV)GL_VERSION_1_5;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERSION_2_0", 14)) {
    /*                        ^           */
#ifdef GL_VERSION_2_0
      *iv_return = (IV)GL_VERSION_2_0;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERSION_2_1", 14)) {
    /*                        ^           */
#ifdef GL_VERSION_2_1
      *iv_return = (IV)GL_VERSION_2_1;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERSION_3_0", 14)) {
    /*                        ^           */
#ifdef GL_VERSION_3_0
      *iv_return = (IV)GL_VERSION_3_0;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERSION_3_1", 14)) {
    /*                        ^           */
#ifdef GL_VERSION_3_1
      *iv_return = (IV)GL_VERSION_3_1;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERSION_3_2", 14)) {
    /*                        ^           */
#ifdef GL_VERSION_3_2
      *iv_return = (IV)GL_VERSION_3_2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERSION_3_3", 14)) {
    /*                        ^           */
#ifdef GL_VERSION_3_3
      *iv_return = (IV)GL_VERSION_3_3;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERSION_4_0", 14)) {
    /*                        ^           */
#ifdef GL_VERSION_4_0
      *iv_return = (IV)GL_VERSION_4_0;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERSION_4_1", 14)) {
    /*                        ^           */
#ifdef GL_VERSION_4_1
      *iv_return = (IV)GL_VERSION_4_1;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERSION_4_2", 14)) {
    /*                        ^           */
#ifdef GL_VERSION_4_2
      *iv_return = (IV)GL_VERSION_4_2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERSION_4_3", 14)) {
    /*                        ^           */
#ifdef GL_VERSION_4_3
      *iv_return = (IV)GL_VERSION_4_3;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERSION_4_4", 14)) {
    /*                        ^           */
#ifdef GL_VERSION_4_4
      *iv_return = (IV)GL_VERSION_4_4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERSION_4_5", 14)) {
    /*                        ^           */
#ifdef GL_VERSION_4_5
      *iv_return = (IV)GL_VERSION_4_5;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'O':
    if (memEQ(name, "GL_AUTO_NORMAL", 14)) {
    /*                        ^           */
#ifdef GL_AUTO_NORMAL
      *iv_return = (IV)GL_AUTO_NORMAL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DST_ATOP_NV", 14)) {
    /*                        ^           */
#ifdef GL_DST_ATOP_NV
      *iv_return = (IV)GL_DST_ATOP_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INTERPOLATE", 14)) {
    /*                        ^           */
#ifdef GL_INTERPOLATE
      *iv_return = (IV)GL_INTERPOLATE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAP1_NORMAL", 14)) {
    /*                        ^           */
#ifdef GL_MAP1_NORMAL
      *iv_return = (IV)GL_MAP1_NORMAL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAP2_NORMAL", 14)) {
    /*                        ^           */
#ifdef GL_MAP2_NORMAL
      *iv_return = (IV)GL_MAP2_NORMAL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SRC_ATOP_NV", 14)) {
    /*                        ^           */
#ifdef GL_SRC_ATOP_NV
      *iv_return = (IV)GL_SRC_ATOP_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_WRAP_BORDER", 14)) {
    /*                        ^           */
#ifdef GL_WRAP_BORDER
      *iv_return = (IV)GL_WRAP_BORDER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ZERO_TO_ONE", 14)) {
    /*                        ^           */
#ifdef GL_ZERO_TO_ONE
      *iv_return = (IV)GL_ZERO_TO_ONE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'R':
    if (memEQ(name, "GL_CACHE_REGAL", 14)) {
    /*                        ^           */
#ifdef GL_CACHE_REGAL
      *iv_return = (IV)GL_CACHE_REGAL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CLIP_ORIGIN", 14)) {
    /*                        ^           */
#ifdef GL_CLIP_ORIGIN
      *iv_return = (IV)GL_CLIP_ORIGIN;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEBUG_REGAL", 14)) {
    /*                        ^           */
#ifdef GL_DEBUG_REGAL
      *iv_return = (IV)GL_DEBUG_REGAL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEPTH_RANGE", 14)) {
    /*                        ^           */
#ifdef GL_DEPTH_RANGE
      *iv_return = (IV)GL_DEPTH_RANGE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ERROR_REGAL", 14)) {
    /*                        ^           */
#ifdef GL_ERROR_REGAL
      *iv_return = (IV)GL_ERROR_REGAL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FLOAT_RG_NV", 14)) {
    /*                        ^           */
#ifdef GL_FLOAT_RG_NV
      *iv_return = (IV)GL_FLOAT_RG_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FRONT_RIGHT", 14)) {
    /*                        ^           */
#ifdef GL_FRONT_RIGHT
      *iv_return = (IV)GL_FRONT_RIGHT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SCISSOR_BIT", 14)) {
    /*                        ^           */
#ifdef GL_SCISSOR_BIT
      *iv_return = (IV)GL_SCISSOR_BIT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SCISSOR_BOX", 14)) {
    /*                        ^           */
#ifdef GL_SCISSOR_BOX
      *iv_return = (IV)GL_SCISSOR_BOX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TRACE_REGAL", 14)) {
    /*                        ^           */
#ifdef GL_TRACE_REGAL
      *iv_return = (IV)GL_TRACE_REGAL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'S':
    if (memEQ(name, "GL_ALPHA_SCALE", 14)) {
    /*                        ^           */
#ifdef GL_ALPHA_SCALE
      *iv_return = (IV)GL_ALPHA_SCALE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ALPHA_SNORM", 14)) {
    /*                        ^           */
#ifdef GL_ALPHA_SNORM
      *iv_return = (IV)GL_ALPHA_SNORM;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CONTRAST_NV", 14)) {
    /*                        ^           */
#ifdef GL_CONTRAST_NV
      *iv_return = (IV)GL_CONTRAST_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEPTH_SCALE", 14)) {
    /*                        ^           */
#ifdef GL_DEPTH_SCALE
      *iv_return = (IV)GL_DEPTH_SCALE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_GREEN_SCALE", 14)) {
    /*                        ^           */
#ifdef GL_GREEN_SCALE
      *iv_return = (IV)GL_GREEN_SCALE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INDEX_SHIFT", 14)) {
    /*                        ^           */
#ifdef GL_INDEX_SHIFT
      *iv_return = (IV)GL_INDEX_SHIFT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGB16_SNORM", 14)) {
    /*                        ^           */
#ifdef GL_RGB16_SNORM
      *iv_return = (IV)GL_RGB16_SNORM;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGBA8_SNORM", 14)) {
    /*                        ^           */
#ifdef GL_RGBA8_SNORM
      *iv_return = (IV)GL_RGBA8_SNORM;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLES_ARB", 14)) {
    /*                        ^           */
#ifdef GL_SAMPLES_ARB
      *iv_return = (IV)GL_SAMPLES_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLES_EXT", 14)) {
    /*                        ^           */
#ifdef GL_SAMPLES_EXT
      *iv_return = (IV)GL_SAMPLES_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'T':
    if (memEQ(name, "GL_BGR_INTEGER", 14)) {
    /*                        ^           */
#ifdef GL_BGR_INTEGER
      *iv_return = (IV)GL_BGR_INTEGER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_TABLE", 14)) {
    /*                        ^           */
#ifdef GL_COLOR_TABLE
      *iv_return = (IV)GL_COLOR_TABLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CURRENT_BIT", 14)) {
    /*                        ^           */
#ifdef GL_CURRENT_BIT
      *iv_return = (IV)GL_CURRENT_BIT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_IDENTITY_NV", 14)) {
    /*                        ^           */
#ifdef GL_IDENTITY_NV
      *iv_return = (IV)GL_IDENTITY_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LINK_STATUS", 14)) {
    /*                        ^           */
#ifdef GL_LINK_STATUS
      *iv_return = (IV)GL_LINK_STATUS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_POINT_TOKEN", 14)) {
    /*                        ^           */
#ifdef GL_POINT_TOKEN
      *iv_return = (IV)GL_POINT_TOKEN;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RED_BIT_ATI", 14)) {
    /*                        ^           */
#ifdef GL_RED_BIT_ATI
      *iv_return = (IV)GL_RED_BIT_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RED_INTEGER", 14)) {
    /*                        ^           */
#ifdef GL_RED_INTEGER
      *iv_return = (IV)GL_RED_INTEGER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RESTART_SUN", 14)) {
    /*                        ^           */
#ifdef GL_RESTART_SUN
      *iv_return = (IV)GL_RESTART_SUN;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGB_INTEGER", 14)) {
    /*                        ^           */
#ifdef GL_RGB_INTEGER
      *iv_return = (IV)GL_RGB_INTEGER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SYNC_STATUS", 14)) {
    /*                        ^           */
#ifdef GL_SYNC_STATUS
      *iv_return = (IV)GL_SYNC_STATUS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VARIANT_EXT", 14)) {
    /*                        ^           */
#ifdef GL_VARIANT_EXT
      *iv_return = (IV)GL_VARIANT_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'U':
    if (memEQ(name, "GL_COUNT_UP_NV", 14)) {
    /*                        ^           */
#ifdef GL_COUNT_UP_NV
      *iv_return = (IV)GL_COUNT_UP_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRAW_BUFFER", 14)) {
    /*                        ^           */
#ifdef GL_DRAW_BUFFER
      *iv_return = (IV)GL_DRAW_BUFFER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FRAMEBUFFER", 14)) {
    /*                        ^           */
#ifdef GL_FRAMEBUFFER
      *iv_return = (IV)GL_FRAMEBUFFER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_READ_BUFFER", 14)) {
    /*                        ^           */
#ifdef GL_READ_BUFFER
      *iv_return = (IV)GL_READ_BUFFER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SPOT_CUTOFF", 14)) {
    /*                        ^           */
#ifdef GL_SPOT_CUTOFF
      *iv_return = (IV)GL_SPOT_CUTOFF;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'V':
    if (memEQ(name, "GL_422_REV_EXT", 14)) {
    /*                        ^           */
#ifdef GL_422_REV_EXT
      *iv_return = (IV)GL_422_REV_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_AND_REVERSE", 14)) {
    /*                        ^           */
#ifdef GL_AND_REVERSE
      *iv_return = (IV)GL_AND_REVERSE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'Y':
    if (memEQ(name, "GL_OVERLAY_KHR", 14)) {
    /*                        ^           */
#ifdef GL_OVERLAY_KHR
      *iv_return = (IV)GL_OVERLAY_KHR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '_':
    if (memEQ(name, "GL_BUFFER_SIZE", 14)) {
    /*                        ^           */
#ifdef GL_BUFFER_SIZE
      *iv_return = (IV)GL_BUFFER_SIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DOUBLE_MAT2", 14)) {
    /*                        ^           */
#ifdef GL_DOUBLE_MAT2
      *iv_return = (IV)GL_DOUBLE_MAT2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DOUBLE_MAT3", 14)) {
    /*                        ^           */
#ifdef GL_DOUBLE_MAT3
      *iv_return = (IV)GL_DOUBLE_MAT3;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DOUBLE_MAT4", 14)) {
    /*                        ^           */
#ifdef GL_DOUBLE_MAT4
      *iv_return = (IV)GL_DOUBLE_MAT4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DOUBLE_VEC2", 14)) {
    /*                        ^           */
#ifdef GL_DOUBLE_VEC2
      *iv_return = (IV)GL_DOUBLE_VEC2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DOUBLE_VEC3", 14)) {
    /*                        ^           */
#ifdef GL_DOUBLE_VEC3
      *iv_return = (IV)GL_DOUBLE_VEC3;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DOUBLE_VEC4", 14)) {
    /*                        ^           */
#ifdef GL_DOUBLE_VEC4
      *iv_return = (IV)GL_DOUBLE_VEC4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MATRIX_MODE", 14)) {
    /*                        ^           */
#ifdef GL_MATRIX_MODE
      *iv_return = (IV)GL_MATRIX_MODE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MINMAX_SINK", 14)) {
    /*                        ^           */
#ifdef GL_MINMAX_SINK
      *iv_return = (IV)GL_MINMAX_SINK;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OBJECT_TYPE", 14)) {
    /*                        ^           */
#ifdef GL_OBJECT_TYPE
      *iv_return = (IV)GL_OBJECT_TYPE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RENDER_MODE", 14)) {
    /*                        ^           */
#ifdef GL_RENDER_MODE
      *iv_return = (IV)GL_RENDER_MODE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLE_MASK", 14)) {
    /*                        ^           */
#ifdef GL_SAMPLE_MASK
      *iv_return = (IV)GL_SAMPLE_MASK;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SHADER_TYPE", 14)) {
    /*                        ^           */
#ifdef GL_SHADER_TYPE
      *iv_return = (IV)GL_SHADER_TYPE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STATIC_COPY", 14)) {
    /*                        ^           */
#ifdef GL_STATIC_COPY
      *iv_return = (IV)GL_STATIC_COPY;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STATIC_DRAW", 14)) {
    /*                        ^           */
#ifdef GL_STATIC_DRAW
      *iv_return = (IV)GL_STATIC_DRAW;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STATIC_READ", 14)) {
    /*                        ^           */
#ifdef GL_STATIC_READ
      *iv_return = (IV)GL_STATIC_READ;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STREAM_COPY", 14)) {
    /*                        ^           */
#ifdef GL_STREAM_COPY
      *iv_return = (IV)GL_STREAM_COPY;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STREAM_DRAW", 14)) {
    /*                        ^           */
#ifdef GL_STREAM_DRAW
      *iv_return = (IV)GL_STREAM_DRAW;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STREAM_READ", 14)) {
    /*                        ^           */
#ifdef GL_STREAM_READ
      *iv_return = (IV)GL_STREAM_READ;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'a':
    if (memEQ(name, "GL_ARB_imaging", 14)) {
    /*                        ^           */
#ifdef GL_ARB_imaging
      *iv_return = (IV)GL_ARB_imaging;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'c':
    if (memEQ(name, "GLEW_EXT_cmyka", 14)) {
    /*                        ^           */
#ifdef GLEW_EXT_cmyka
      *iv_return = (IV)GLEW_EXT_cmyka;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'd':
    if (memEQ(name, "GLEW_KHR_debug", 14)) {
    /*                        ^           */
#ifdef GLEW_KHR_debug
      *iv_return = (IV)GLEW_KHR_debug;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'f':
    if (memEQ(name, "GL_APPLE_fence", 14)) {
    /*                        ^           */
#ifdef GL_APPLE_fence
      *iv_return = (IV)GL_APPLE_fence;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'h':
    if (memEQ(name, "GL_SGIX_shadow", 14)) {
    /*                        ^           */
#ifdef GL_SGIX_shadow
      *iv_return = (IV)GL_SGIX_shadow;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'm':
    if (memEQ(name, "GL_ATI_meminfo", 14)) {
    /*                        ^           */
#ifdef GL_ATI_meminfo
      *iv_return = (IV)GL_ATI_meminfo;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'p':
    if (memEQ(name, "GL_SGIX_sprite", 14)) {
    /*                        ^           */
#ifdef GL_SGIX_sprite
      *iv_return = (IV)GL_SGIX_sprite;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'x':
    if (memEQ(name, "GL_EXT_texture", 14)) {
    /*                        ^           */
#ifdef GL_EXT_texture
      *iv_return = (IV)GL_EXT_texture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  }
  return PERL_constant_NOTFOUND;
}

static int
constant_15 (pTHX_ const char *name, IV *iv_return) {
  /* When generated this function returned values for the list of names given
     here.  However, subsequent manual editing may have added or removed some.
     GLEW_ARB_shadow GLEW_SGIX_async GLEW_SGIX_ycrcb GLEW_SUN_vertex
     GL_2PASS_0_SGIS GL_2PASS_1_SGIS GL_3DFX_tbuffer GL_4PASS_0_SGIS
     GL_4PASS_1_SGIS GL_4PASS_2_SGIS GL_4PASS_3_SGIS GL_AFFINE_2D_NV
     GL_AFFINE_3D_NV GL_ALPHA16F_ARB GL_ALPHA16I_EXT GL_ALPHA32F_ARB
     GL_ALPHA32I_EXT GL_ALPHA8UI_EXT GL_ALPHA8_SNORM GL_AND_INVERTED
     GL_ARB_cl_event GL_ARB_gl_spirv GL_ARRAY_BUFFER GL_ARRAY_STRIDE
     GL_BGRA_INTEGER GL_BIAS_BIT_ATI GL_BITMAP_TOKEN GL_BLUE_BIT_ATI
     GL_BLUE_INTEGER GL_BUFFER_USAGE GL_CLEAR_BUFFER GL_COLORBURN_NV
     GL_COLOR_MATRIX GL_COMBINER0_NV GL_COMBINER1_NV GL_COMBINER2_NV
     GL_COMBINER3_NV GL_COMBINER4_NV GL_COMBINER5_NV GL_COMBINER6_NV
     GL_COMBINER7_NV GL_COMP_BIT_ATI GL_CONSTANT_ARB GL_CONSTANT_EXT
     GL_CONST_EYE_NV GL_CONTEXT_LOST GL_DEBUG_OUTPUT GL_DEPTH_BUFFER
     GL_DISCRETE_AMD GL_DISPLAY_LIST GL_DOT2_ADD_ATI GL_DOT3_RGB_ARB
     GL_DOT3_RGB_EXT GL_DOUBLEBUFFER GL_DRAW_BUFFER0 GL_DRAW_BUFFER1
     GL_DRAW_BUFFER2 GL_DRAW_BUFFER3 GL_DRAW_BUFFER4 GL_DRAW_BUFFER5
     GL_DRAW_BUFFER6 GL_DRAW_BUFFER7 GL_DRAW_BUFFER8 GL_DRAW_BUFFER9
     GL_DRIVER_REGAL GL_DYNAMIC_COPY GL_DYNAMIC_DRAW GL_DYNAMIC_READ
     GL_EXCLUSION_NV GL_E_TIMES_F_NV GL_FILE_NAME_NV GL_FLOAT_MAT2x3
     GL_FLOAT_MAT2x4 GL_FLOAT_MAT3x2 GL_FLOAT_MAT3x4 GL_FLOAT_MAT4x2
     GL_FLOAT_MAT4x3 GL_FLOAT_R16_NV GL_FLOAT_R32_NV GL_FLOAT_RGB_NV
     GL_FULL_SUPPORT GL_FUNC_ADD_EXT GL_HALF_BIT_ATI GL_HARDLIGHT_NV
     GL_HSL_COLOR_NV GL_IMAGE_1D_EXT GL_IMAGE_2D_EXT GL_IMAGE_3D_EXT
     GL_IMAGE_BUFFER GL_INDEX_OFFSET GL_INT8_VEC2_NV GL_INT8_VEC3_NV
     GL_INT8_VEC4_NV GL_INT_IMAGE_1D GL_INT_IMAGE_2D GL_INT_IMAGE_3D
     GL_INT_VEC2_ARB GL_INT_VEC3_ARB GL_INT_VEC4_ARB GL_INVALID_ENUM
     GL_IS_PER_PATCH GL_IS_ROW_MAJOR GL_KHR_no_error GL_KTX_Z_REGION
     GL_LIGHTING_BIT GL_LINE_STIPPLE GL_MAP1_COLOR_4 GL_MAP2_COLOR_4
     GL_MAP_READ_BIT GL_MATRIX10_ARB GL_MATRIX11_ARB GL_MATRIX12_ARB
     GL_MATRIX13_ARB GL_MATRIX14_ARB GL_MATRIX15_ARB GL_MATRIX16_ARB
     GL_MATRIX17_ARB GL_MATRIX18_ARB GL_MATRIX19_ARB GL_MATRIX20_ARB
     GL_MATRIX21_ARB GL_MATRIX22_ARB GL_MATRIX23_ARB GL_MATRIX24_ARB
     GL_MATRIX25_ARB GL_MATRIX26_ARB GL_MATRIX27_ARB GL_MATRIX28_ARB
     GL_MATRIX29_ARB GL_MATRIX30_ARB GL_MATRIX31_ARB GL_MAX_RED_SGIS
     GL_MEDIUM_FLOAT GL_MIN_RED_SGIS GL_MULTIPLY_KHR GL_NORMAL_ARRAY
     GL_OBJECT_PLANE GL_OML_resample GL_OPERAND0_RGB GL_OPERAND1_RGB
     GL_OPERAND2_RGB GL_OP_CLAMP_EXT GL_OP_FLOOR_EXT GL_OP_INDEX_EXT
     GL_OP_POWER_EXT GL_OP_RECIP_EXT GL_OP_ROUND_EXT GL_POINT_SMOOTH
     GL_POINT_SPRITE GL_POLYGON_MODE GL_PRESERVE_ATI GL_PREVIOUS_ARB
     GL_PREVIOUS_EXT GL_QUERY_BUFFER GL_QUERY_RESULT GL_QUERY_TARGET
     GL_R1UI_V3F_SUN GL_REGAL_enable GL_RENDERBUFFER GL_RGB10_A2_EXT
     GL_RGBA16UI_EXT GL_RGBA16_SNORM GL_RGBA32UI_EXT GL_RGBA_INTEGER
     GL_SAMPLER_CUBE GL_SAMPLES_3DFX GL_SAMPLES_SGIS GL_SCISSOR_TEST
     GL_SEPARABLE_2D GL_SGIX_clipmap GL_SINGLE_COLOR GL_SOFTLIGHT_NV
     GL_SRGB8_ALPHA8 GL_STENCIL_BITS GL_STENCIL_FAIL GL_STENCIL_FUNC
     GL_STENCIL_TEST GL_SUBTRACT_ARB GL_T2F_C4UB_V3F GL_TEXTURE0_ARB
     GL_TEXTURE1_ARB GL_TEXTURE2_ARB GL_TEXTURE3_ARB GL_TEXTURE4_ARB
     GL_TEXTURE5_ARB GL_TEXTURE6_ARB GL_TEXTURE7_ARB GL_TEXTURE8_ARB
     GL_TEXTURE9_ARB GL_TEXTURE_VIEW GL_TIME_ELAPSED GL_TRANSPOSE_NV
     GL_TRIANGLE_FAN GL_UNIFORM_SIZE GL_UNIFORM_TYPE GL_UNSIGNED_INT
     GL_VERTEX_ARRAY GL_VERTEX_ID_NV GL_VIEWPORT_BIT GL_WARP_SIZE_NV */
  /* Offset 10 gives the best switch position.  */
  switch (name[10]) {
  case '0':
    if (memEQ(name, "GL_MATRIX10_ARB", 15)) {
    /*                         ^           */
#ifdef GL_MATRIX10_ARB
      *iv_return = (IV)GL_MATRIX10_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MATRIX20_ARB", 15)) {
    /*                         ^           */
#ifdef GL_MATRIX20_ARB
      *iv_return = (IV)GL_MATRIX20_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MATRIX30_ARB", 15)) {
    /*                         ^           */
#ifdef GL_MATRIX30_ARB
      *iv_return = (IV)GL_MATRIX30_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OPERAND0_RGB", 15)) {
    /*                         ^           */
#ifdef GL_OPERAND0_RGB
      *iv_return = (IV)GL_OPERAND0_RGB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE0_ARB", 15)) {
    /*                         ^           */
#ifdef GL_TEXTURE0_ARB
      *iv_return = (IV)GL_TEXTURE0_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '1':
    if (memEQ(name, "GL_FLOAT_R16_NV", 15)) {
    /*                         ^           */
#ifdef GL_FLOAT_R16_NV
      *iv_return = (IV)GL_FLOAT_R16_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MATRIX11_ARB", 15)) {
    /*                         ^           */
#ifdef GL_MATRIX11_ARB
      *iv_return = (IV)GL_MATRIX11_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MATRIX21_ARB", 15)) {
    /*                         ^           */
#ifdef GL_MATRIX21_ARB
      *iv_return = (IV)GL_MATRIX21_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MATRIX31_ARB", 15)) {
    /*                         ^           */
#ifdef GL_MATRIX31_ARB
      *iv_return = (IV)GL_MATRIX31_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OPERAND1_RGB", 15)) {
    /*                         ^           */
#ifdef GL_OPERAND1_RGB
      *iv_return = (IV)GL_OPERAND1_RGB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE1_ARB", 15)) {
    /*                         ^           */
#ifdef GL_TEXTURE1_ARB
      *iv_return = (IV)GL_TEXTURE1_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '2':
    if (memEQ(name, "GL_AFFINE_2D_NV", 15)) {
    /*                         ^           */
#ifdef GL_AFFINE_2D_NV
      *iv_return = (IV)GL_AFFINE_2D_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INT_VEC2_ARB", 15)) {
    /*                         ^           */
#ifdef GL_INT_VEC2_ARB
      *iv_return = (IV)GL_INT_VEC2_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MATRIX12_ARB", 15)) {
    /*                         ^           */
#ifdef GL_MATRIX12_ARB
      *iv_return = (IV)GL_MATRIX12_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MATRIX22_ARB", 15)) {
    /*                         ^           */
#ifdef GL_MATRIX22_ARB
      *iv_return = (IV)GL_MATRIX22_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OPERAND2_RGB", 15)) {
    /*                         ^           */
#ifdef GL_OPERAND2_RGB
      *iv_return = (IV)GL_OPERAND2_RGB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGB10_A2_EXT", 15)) {
    /*                         ^           */
#ifdef GL_RGB10_A2_EXT
      *iv_return = (IV)GL_RGB10_A2_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE2_ARB", 15)) {
    /*                         ^           */
#ifdef GL_TEXTURE2_ARB
      *iv_return = (IV)GL_TEXTURE2_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '3':
    if (memEQ(name, "GL_AFFINE_3D_NV", 15)) {
    /*                         ^           */
#ifdef GL_AFFINE_3D_NV
      *iv_return = (IV)GL_AFFINE_3D_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FLOAT_R32_NV", 15)) {
    /*                         ^           */
#ifdef GL_FLOAT_R32_NV
      *iv_return = (IV)GL_FLOAT_R32_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INT_VEC3_ARB", 15)) {
    /*                         ^           */
#ifdef GL_INT_VEC3_ARB
      *iv_return = (IV)GL_INT_VEC3_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MATRIX13_ARB", 15)) {
    /*                         ^           */
#ifdef GL_MATRIX13_ARB
      *iv_return = (IV)GL_MATRIX13_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MATRIX23_ARB", 15)) {
    /*                         ^           */
#ifdef GL_MATRIX23_ARB
      *iv_return = (IV)GL_MATRIX23_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE3_ARB", 15)) {
    /*                         ^           */
#ifdef GL_TEXTURE3_ARB
      *iv_return = (IV)GL_TEXTURE3_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '4':
    if (memEQ(name, "GL_INT_VEC4_ARB", 15)) {
    /*                         ^           */
#ifdef GL_INT_VEC4_ARB
      *iv_return = (IV)GL_INT_VEC4_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MATRIX14_ARB", 15)) {
    /*                         ^           */
#ifdef GL_MATRIX14_ARB
      *iv_return = (IV)GL_MATRIX14_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MATRIX24_ARB", 15)) {
    /*                         ^           */
#ifdef GL_MATRIX24_ARB
      *iv_return = (IV)GL_MATRIX24_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE4_ARB", 15)) {
    /*                         ^           */
#ifdef GL_TEXTURE4_ARB
      *iv_return = (IV)GL_TEXTURE4_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '5':
    if (memEQ(name, "GL_MATRIX15_ARB", 15)) {
    /*                         ^           */
#ifdef GL_MATRIX15_ARB
      *iv_return = (IV)GL_MATRIX15_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MATRIX25_ARB", 15)) {
    /*                         ^           */
#ifdef GL_MATRIX25_ARB
      *iv_return = (IV)GL_MATRIX25_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE5_ARB", 15)) {
    /*                         ^           */
#ifdef GL_TEXTURE5_ARB
      *iv_return = (IV)GL_TEXTURE5_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '6':
    if (memEQ(name, "GL_MATRIX16_ARB", 15)) {
    /*                         ^           */
#ifdef GL_MATRIX16_ARB
      *iv_return = (IV)GL_MATRIX16_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MATRIX26_ARB", 15)) {
    /*                         ^           */
#ifdef GL_MATRIX26_ARB
      *iv_return = (IV)GL_MATRIX26_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE6_ARB", 15)) {
    /*                         ^           */
#ifdef GL_TEXTURE6_ARB
      *iv_return = (IV)GL_TEXTURE6_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '7':
    if (memEQ(name, "GL_MATRIX17_ARB", 15)) {
    /*                         ^           */
#ifdef GL_MATRIX17_ARB
      *iv_return = (IV)GL_MATRIX17_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MATRIX27_ARB", 15)) {
    /*                         ^           */
#ifdef GL_MATRIX27_ARB
      *iv_return = (IV)GL_MATRIX27_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE7_ARB", 15)) {
    /*                         ^           */
#ifdef GL_TEXTURE7_ARB
      *iv_return = (IV)GL_TEXTURE7_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '8':
    if (memEQ(name, "GL_MATRIX18_ARB", 15)) {
    /*                         ^           */
#ifdef GL_MATRIX18_ARB
      *iv_return = (IV)GL_MATRIX18_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MATRIX28_ARB", 15)) {
    /*                         ^           */
#ifdef GL_MATRIX28_ARB
      *iv_return = (IV)GL_MATRIX28_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE8_ARB", 15)) {
    /*                         ^           */
#ifdef GL_TEXTURE8_ARB
      *iv_return = (IV)GL_TEXTURE8_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '9':
    if (memEQ(name, "GL_MATRIX19_ARB", 15)) {
    /*                         ^           */
#ifdef GL_MATRIX19_ARB
      *iv_return = (IV)GL_MATRIX19_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MATRIX29_ARB", 15)) {
    /*                         ^           */
#ifdef GL_MATRIX29_ARB
      *iv_return = (IV)GL_MATRIX29_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE9_ARB", 15)) {
    /*                         ^           */
#ifdef GL_TEXTURE9_ARB
      *iv_return = (IV)GL_TEXTURE9_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'A':
    if (memEQ(name, "GL_COLOR_MATRIX", 15)) {
    /*                         ^           */
#ifdef GL_COLOR_MATRIX
      *iv_return = (IV)GL_COLOR_MATRIX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FLOAT_MAT2x3", 15)) {
    /*                         ^           */
#ifdef GL_FLOAT_MAT2x3
      *iv_return = (IV)GL_FLOAT_MAT2x3;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FLOAT_MAT2x4", 15)) {
    /*                         ^           */
#ifdef GL_FLOAT_MAT2x4
      *iv_return = (IV)GL_FLOAT_MAT2x4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FLOAT_MAT3x2", 15)) {
    /*                         ^           */
#ifdef GL_FLOAT_MAT3x2
      *iv_return = (IV)GL_FLOAT_MAT3x2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FLOAT_MAT3x4", 15)) {
    /*                         ^           */
#ifdef GL_FLOAT_MAT3x4
      *iv_return = (IV)GL_FLOAT_MAT3x4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FLOAT_MAT4x2", 15)) {
    /*                         ^           */
#ifdef GL_FLOAT_MAT4x2
      *iv_return = (IV)GL_FLOAT_MAT4x2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FLOAT_MAT4x3", 15)) {
    /*                         ^           */
#ifdef GL_FLOAT_MAT4x3
      *iv_return = (IV)GL_FLOAT_MAT4x3;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NORMAL_ARRAY", 15)) {
    /*                         ^           */
#ifdef GL_NORMAL_ARRAY
      *iv_return = (IV)GL_NORMAL_ARRAY;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_QUERY_TARGET", 15)) {
    /*                         ^           */
#ifdef GL_QUERY_TARGET
      *iv_return = (IV)GL_QUERY_TARGET;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TIME_ELAPSED", 15)) {
    /*                         ^           */
#ifdef GL_TIME_ELAPSED
      *iv_return = (IV)GL_TIME_ELAPSED;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERTEX_ARRAY", 15)) {
    /*                         ^           */
#ifdef GL_VERTEX_ARRAY
      *iv_return = (IV)GL_VERTEX_ARRAY;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'B':
    if (memEQ(name, "GL_DOT3_RGB_ARB", 15)) {
    /*                         ^           */
#ifdef GL_DOT3_RGB_ARB
      *iv_return = (IV)GL_DOT3_RGB_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DOT3_RGB_EXT", 15)) {
    /*                         ^           */
#ifdef GL_DOT3_RGB_EXT
      *iv_return = (IV)GL_DOT3_RGB_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_T2F_C4UB_V3F", 15)) {
    /*                         ^           */
#ifdef GL_T2F_C4UB_V3F
      *iv_return = (IV)GL_T2F_C4UB_V3F;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'C':
    if (memEQ(name, "GL_INT8_VEC2_NV", 15)) {
    /*                         ^           */
#ifdef GL_INT8_VEC2_NV
      *iv_return = (IV)GL_INT8_VEC2_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INT8_VEC3_NV", 15)) {
    /*                         ^           */
#ifdef GL_INT8_VEC3_NV
      *iv_return = (IV)GL_INT8_VEC3_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INT8_VEC4_NV", 15)) {
    /*                         ^           */
#ifdef GL_INT8_VEC4_NV
      *iv_return = (IV)GL_INT8_VEC4_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SINGLE_COLOR", 15)) {
    /*                         ^           */
#ifdef GL_SINGLE_COLOR
      *iv_return = (IV)GL_SINGLE_COLOR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'D':
    if (memEQ(name, "GL_DOT2_ADD_ATI", 15)) {
    /*                         ^           */
#ifdef GL_DOT2_ADD_ATI
      *iv_return = (IV)GL_DOT2_ADD_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FUNC_ADD_EXT", 15)) {
    /*                         ^           */
#ifdef GL_FUNC_ADD_EXT
      *iv_return = (IV)GL_FUNC_ADD_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_IMAGE_1D_EXT", 15)) {
    /*                         ^           */
#ifdef GL_IMAGE_1D_EXT
      *iv_return = (IV)GL_IMAGE_1D_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_IMAGE_2D_EXT", 15)) {
    /*                         ^           */
#ifdef GL_IMAGE_2D_EXT
      *iv_return = (IV)GL_IMAGE_2D_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_IMAGE_3D_EXT", 15)) {
    /*                         ^           */
#ifdef GL_IMAGE_3D_EXT
      *iv_return = (IV)GL_IMAGE_3D_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAP_READ_BIT", 15)) {
    /*                         ^           */
#ifdef GL_MAP_READ_BIT
      *iv_return = (IV)GL_MAP_READ_BIT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OP_ROUND_EXT", 15)) {
    /*                         ^           */
#ifdef GL_OP_ROUND_EXT
      *iv_return = (IV)GL_OP_ROUND_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNSIGNED_INT", 15)) {
    /*                         ^           */
#ifdef GL_UNSIGNED_INT
      *iv_return = (IV)GL_UNSIGNED_INT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'E':
    if (memEQ(name, "GL_AND_INVERTED", 15)) {
    /*                         ^           */
#ifdef GL_AND_INVERTED
      *iv_return = (IV)GL_AND_INVERTED;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DISCRETE_AMD", 15)) {
    /*                         ^           */
#ifdef GL_DISCRETE_AMD
      *iv_return = (IV)GL_DISCRETE_AMD;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_KTX_Z_REGION", 15)) {
    /*                         ^           */
#ifdef GL_KTX_Z_REGION
      *iv_return = (IV)GL_KTX_Z_REGION;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PRESERVE_ATI", 15)) {
    /*                         ^           */
#ifdef GL_PRESERVE_ATI
      *iv_return = (IV)GL_PRESERVE_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_QUERY_RESULT", 15)) {
    /*                         ^           */
#ifdef GL_QUERY_RESULT
      *iv_return = (IV)GL_QUERY_RESULT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TRIANGLE_FAN", 15)) {
    /*                         ^           */
#ifdef GL_TRIANGLE_FAN
      *iv_return = (IV)GL_TRIANGLE_FAN;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'F':
    if (memEQ(name, "GL_ALPHA16F_ARB", 15)) {
    /*                         ^           */
#ifdef GL_ALPHA16F_ARB
      *iv_return = (IV)GL_ALPHA16F_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ALPHA32F_ARB", 15)) {
    /*                         ^           */
#ifdef GL_ALPHA32F_ARB
      *iv_return = (IV)GL_ALPHA32F_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRAW_BUFFER0", 15)) {
    /*                         ^           */
#ifdef GL_DRAW_BUFFER0
      *iv_return = (IV)GL_DRAW_BUFFER0;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRAW_BUFFER1", 15)) {
    /*                         ^           */
#ifdef GL_DRAW_BUFFER1
      *iv_return = (IV)GL_DRAW_BUFFER1;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRAW_BUFFER2", 15)) {
    /*                         ^           */
#ifdef GL_DRAW_BUFFER2
      *iv_return = (IV)GL_DRAW_BUFFER2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRAW_BUFFER3", 15)) {
    /*                         ^           */
#ifdef GL_DRAW_BUFFER3
      *iv_return = (IV)GL_DRAW_BUFFER3;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRAW_BUFFER4", 15)) {
    /*                         ^           */
#ifdef GL_DRAW_BUFFER4
      *iv_return = (IV)GL_DRAW_BUFFER4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRAW_BUFFER5", 15)) {
    /*                         ^           */
#ifdef GL_DRAW_BUFFER5
      *iv_return = (IV)GL_DRAW_BUFFER5;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRAW_BUFFER6", 15)) {
    /*                         ^           */
#ifdef GL_DRAW_BUFFER6
      *iv_return = (IV)GL_DRAW_BUFFER6;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRAW_BUFFER7", 15)) {
    /*                         ^           */
#ifdef GL_DRAW_BUFFER7
      *iv_return = (IV)GL_DRAW_BUFFER7;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRAW_BUFFER8", 15)) {
    /*                         ^           */
#ifdef GL_DRAW_BUFFER8
      *iv_return = (IV)GL_DRAW_BUFFER8;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRAW_BUFFER9", 15)) {
    /*                         ^           */
#ifdef GL_DRAW_BUFFER9
      *iv_return = (IV)GL_DRAW_BUFFER9;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INDEX_OFFSET", 15)) {
    /*                         ^           */
#ifdef GL_INDEX_OFFSET
      *iv_return = (IV)GL_INDEX_OFFSET;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MEDIUM_FLOAT", 15)) {
    /*                         ^           */
#ifdef GL_MEDIUM_FLOAT
      *iv_return = (IV)GL_MEDIUM_FLOAT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_R1UI_V3F_SUN", 15)) {
    /*                         ^           */
#ifdef GL_R1UI_V3F_SUN
      *iv_return = (IV)GL_R1UI_V3F_SUN;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'G':
    if (memEQ(name, "GL_FLOAT_RGB_NV", 15)) {
    /*                         ^           */
#ifdef GL_FLOAT_RGB_NV
      *iv_return = (IV)GL_FLOAT_RGB_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INT_IMAGE_1D", 15)) {
    /*                         ^           */
#ifdef GL_INT_IMAGE_1D
      *iv_return = (IV)GL_INT_IMAGE_1D;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INT_IMAGE_2D", 15)) {
    /*                         ^           */
#ifdef GL_INT_IMAGE_2D
      *iv_return = (IV)GL_INT_IMAGE_2D;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INT_IMAGE_3D", 15)) {
    /*                         ^           */
#ifdef GL_INT_IMAGE_3D
      *iv_return = (IV)GL_INT_IMAGE_3D;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LIGHTING_BIT", 15)) {
    /*                         ^           */
#ifdef GL_LIGHTING_BIT
      *iv_return = (IV)GL_LIGHTING_BIT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'H':
    if (memEQ(name, "GL_HARDLIGHT_NV", 15)) {
    /*                         ^           */
#ifdef GL_HARDLIGHT_NV
      *iv_return = (IV)GL_HARDLIGHT_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SOFTLIGHT_NV", 15)) {
    /*                         ^           */
#ifdef GL_SOFTLIGHT_NV
      *iv_return = (IV)GL_SOFTLIGHT_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'I':
    if (memEQ(name, "GL_ALPHA16I_EXT", 15)) {
    /*                         ^           */
#ifdef GL_ALPHA16I_EXT
      *iv_return = (IV)GL_ALPHA16I_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ALPHA32I_EXT", 15)) {
    /*                         ^           */
#ifdef GL_ALPHA32I_EXT
      *iv_return = (IV)GL_ALPHA32I_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ALPHA8UI_EXT", 15)) {
    /*                         ^           */
#ifdef GL_ALPHA8UI_EXT
      *iv_return = (IV)GL_ALPHA8UI_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LINE_STIPPLE", 15)) {
    /*                         ^           */
#ifdef GL_LINE_STIPPLE
      *iv_return = (IV)GL_LINE_STIPPLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGBA16UI_EXT", 15)) {
    /*                         ^           */
#ifdef GL_RGBA16UI_EXT
      *iv_return = (IV)GL_RGBA16UI_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGBA32UI_EXT", 15)) {
    /*                         ^           */
#ifdef GL_RGBA32UI_EXT
      *iv_return = (IV)GL_RGBA32UI_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERTEX_ID_NV", 15)) {
    /*                         ^           */
#ifdef GL_VERTEX_ID_NV
      *iv_return = (IV)GL_VERTEX_ID_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'L':
    if (memEQ(name, "GL_MAP1_COLOR_4", 15)) {
    /*                         ^           */
#ifdef GL_MAP1_COLOR_4
      *iv_return = (IV)GL_MAP1_COLOR_4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAP2_COLOR_4", 15)) {
    /*                         ^           */
#ifdef GL_MAP2_COLOR_4
      *iv_return = (IV)GL_MAP2_COLOR_4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SEPARABLE_2D", 15)) {
    /*                         ^           */
#ifdef GL_SEPARABLE_2D
      *iv_return = (IV)GL_SEPARABLE_2D;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SRGB8_ALPHA8", 15)) {
    /*                         ^           */
#ifdef GL_SRGB8_ALPHA8
      *iv_return = (IV)GL_SRGB8_ALPHA8;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'M':
    if (memEQ(name, "GL_FILE_NAME_NV", 15)) {
    /*                         ^           */
#ifdef GL_FILE_NAME_NV
      *iv_return = (IV)GL_FILE_NAME_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_IS_ROW_MAJOR", 15)) {
    /*                         ^           */
#ifdef GL_IS_ROW_MAJOR
      *iv_return = (IV)GL_IS_ROW_MAJOR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_POINT_SMOOTH", 15)) {
    /*                         ^           */
#ifdef GL_POINT_SMOOTH
      *iv_return = (IV)GL_POINT_SMOOTH;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'O':
    if (memEQ(name, "GL_EXCLUSION_NV", 15)) {
    /*                         ^           */
#ifdef GL_EXCLUSION_NV
      *iv_return = (IV)GL_EXCLUSION_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_HSL_COLOR_NV", 15)) {
    /*                         ^           */
#ifdef GL_HSL_COLOR_NV
      *iv_return = (IV)GL_HSL_COLOR_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'P':
    if (memEQ(name, "GL_FULL_SUPPORT", 15)) {
    /*                         ^           */
#ifdef GL_FULL_SUPPORT
      *iv_return = (IV)GL_FULL_SUPPORT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_IS_PER_PATCH", 15)) {
    /*                         ^           */
#ifdef GL_IS_PER_PATCH
      *iv_return = (IV)GL_IS_PER_PATCH;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OBJECT_PLANE", 15)) {
    /*                         ^           */
#ifdef GL_OBJECT_PLANE
      *iv_return = (IV)GL_OBJECT_PLANE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OP_CLAMP_EXT", 15)) {
    /*                         ^           */
#ifdef GL_OP_CLAMP_EXT
      *iv_return = (IV)GL_OP_CLAMP_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OP_RECIP_EXT", 15)) {
    /*                         ^           */
#ifdef GL_OP_RECIP_EXT
      *iv_return = (IV)GL_OP_RECIP_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_POINT_SPRITE", 15)) {
    /*                         ^           */
#ifdef GL_POINT_SPRITE
      *iv_return = (IV)GL_POINT_SPRITE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'R':
    if (memEQ(name, "GL_COLORBURN_NV", 15)) {
    /*                         ^           */
#ifdef GL_COLORBURN_NV
      *iv_return = (IV)GL_COLORBURN_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COMBINER0_NV", 15)) {
    /*                         ^           */
#ifdef GL_COMBINER0_NV
      *iv_return = (IV)GL_COMBINER0_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COMBINER1_NV", 15)) {
    /*                         ^           */
#ifdef GL_COMBINER1_NV
      *iv_return = (IV)GL_COMBINER1_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COMBINER2_NV", 15)) {
    /*                         ^           */
#ifdef GL_COMBINER2_NV
      *iv_return = (IV)GL_COMBINER2_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COMBINER3_NV", 15)) {
    /*                         ^           */
#ifdef GL_COMBINER3_NV
      *iv_return = (IV)GL_COMBINER3_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COMBINER4_NV", 15)) {
    /*                         ^           */
#ifdef GL_COMBINER4_NV
      *iv_return = (IV)GL_COMBINER4_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COMBINER5_NV", 15)) {
    /*                         ^           */
#ifdef GL_COMBINER5_NV
      *iv_return = (IV)GL_COMBINER5_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COMBINER6_NV", 15)) {
    /*                         ^           */
#ifdef GL_COMBINER6_NV
      *iv_return = (IV)GL_COMBINER6_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COMBINER7_NV", 15)) {
    /*                         ^           */
#ifdef GL_COMBINER7_NV
      *iv_return = (IV)GL_COMBINER7_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRIVER_REGAL", 15)) {
    /*                         ^           */
#ifdef GL_DRIVER_REGAL
      *iv_return = (IV)GL_DRIVER_REGAL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OP_FLOOR_EXT", 15)) {
    /*                         ^           */
#ifdef GL_OP_FLOOR_EXT
      *iv_return = (IV)GL_OP_FLOOR_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OP_POWER_EXT", 15)) {
    /*                         ^           */
#ifdef GL_OP_POWER_EXT
      *iv_return = (IV)GL_OP_POWER_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'S':
    if (memEQ(name, "GL_ALPHA8_SNORM", 15)) {
    /*                         ^           */
#ifdef GL_ALPHA8_SNORM
      *iv_return = (IV)GL_ALPHA8_SNORM;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PREVIOUS_ARB", 15)) {
    /*                         ^           */
#ifdef GL_PREVIOUS_ARB
      *iv_return = (IV)GL_PREVIOUS_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PREVIOUS_EXT", 15)) {
    /*                         ^           */
#ifdef GL_PREVIOUS_EXT
      *iv_return = (IV)GL_PREVIOUS_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGBA16_SNORM", 15)) {
    /*                         ^           */
#ifdef GL_RGBA16_SNORM
      *iv_return = (IV)GL_RGBA16_SNORM;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TRANSPOSE_NV", 15)) {
    /*                         ^           */
#ifdef GL_TRANSPOSE_NV
      *iv_return = (IV)GL_TRANSPOSE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'T':
    if (memEQ(name, "GL_ARRAY_STRIDE", 15)) {
    /*                         ^           */
#ifdef GL_ARRAY_STRIDE
      *iv_return = (IV)GL_ARRAY_STRIDE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_BGRA_INTEGER", 15)) {
    /*                         ^           */
#ifdef GL_BGRA_INTEGER
      *iv_return = (IV)GL_BGRA_INTEGER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_BIAS_BIT_ATI", 15)) {
    /*                         ^           */
#ifdef GL_BIAS_BIT_ATI
      *iv_return = (IV)GL_BIAS_BIT_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_BITMAP_TOKEN", 15)) {
    /*                         ^           */
#ifdef GL_BITMAP_TOKEN
      *iv_return = (IV)GL_BITMAP_TOKEN;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_BLUE_BIT_ATI", 15)) {
    /*                         ^           */
#ifdef GL_BLUE_BIT_ATI
      *iv_return = (IV)GL_BLUE_BIT_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_BLUE_INTEGER", 15)) {
    /*                         ^           */
#ifdef GL_BLUE_INTEGER
      *iv_return = (IV)GL_BLUE_INTEGER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COMP_BIT_ATI", 15)) {
    /*                         ^           */
#ifdef GL_COMP_BIT_ATI
      *iv_return = (IV)GL_COMP_BIT_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CONSTANT_ARB", 15)) {
    /*                         ^           */
#ifdef GL_CONSTANT_ARB
      *iv_return = (IV)GL_CONSTANT_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CONSTANT_EXT", 15)) {
    /*                         ^           */
#ifdef GL_CONSTANT_EXT
      *iv_return = (IV)GL_CONSTANT_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_HALF_BIT_ATI", 15)) {
    /*                         ^           */
#ifdef GL_HALF_BIT_ATI
      *iv_return = (IV)GL_HALF_BIT_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGBA_INTEGER", 15)) {
    /*                         ^           */
#ifdef GL_RGBA_INTEGER
      *iv_return = (IV)GL_RGBA_INTEGER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SUBTRACT_ARB", 15)) {
    /*                         ^           */
#ifdef GL_SUBTRACT_ARB
      *iv_return = (IV)GL_SUBTRACT_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VIEWPORT_BIT", 15)) {
    /*                         ^           */
#ifdef GL_VIEWPORT_BIT
      *iv_return = (IV)GL_VIEWPORT_BIT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'U':
    if (memEQ(name, "GL_ARRAY_BUFFER", 15)) {
    /*                         ^           */
#ifdef GL_ARRAY_BUFFER
      *iv_return = (IV)GL_ARRAY_BUFFER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_BUFFER_USAGE", 15)) {
    /*                         ^           */
#ifdef GL_BUFFER_USAGE
      *iv_return = (IV)GL_BUFFER_USAGE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CLEAR_BUFFER", 15)) {
    /*                         ^           */
#ifdef GL_CLEAR_BUFFER
      *iv_return = (IV)GL_CLEAR_BUFFER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEBUG_OUTPUT", 15)) {
    /*                         ^           */
#ifdef GL_DEBUG_OUTPUT
      *iv_return = (IV)GL_DEBUG_OUTPUT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEPTH_BUFFER", 15)) {
    /*                         ^           */
#ifdef GL_DEPTH_BUFFER
      *iv_return = (IV)GL_DEPTH_BUFFER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DOUBLEBUFFER", 15)) {
    /*                         ^           */
#ifdef GL_DOUBLEBUFFER
      *iv_return = (IV)GL_DOUBLEBUFFER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_IMAGE_BUFFER", 15)) {
    /*                         ^           */
#ifdef GL_IMAGE_BUFFER
      *iv_return = (IV)GL_IMAGE_BUFFER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_QUERY_BUFFER", 15)) {
    /*                         ^           */
#ifdef GL_QUERY_BUFFER
      *iv_return = (IV)GL_QUERY_BUFFER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RENDERBUFFER", 15)) {
    /*                         ^           */
#ifdef GL_RENDERBUFFER
      *iv_return = (IV)GL_RENDERBUFFER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'X':
    if (memEQ(name, "GL_OP_INDEX_EXT", 15)) {
    /*                         ^           */
#ifdef GL_OP_INDEX_EXT
      *iv_return = (IV)GL_OP_INDEX_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'Y':
    if (memEQ(name, "GL_CONST_EYE_NV", 15)) {
    /*                         ^           */
#ifdef GL_CONST_EYE_NV
      *iv_return = (IV)GL_CONST_EYE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MULTIPLY_KHR", 15)) {
    /*                         ^           */
#ifdef GL_MULTIPLY_KHR
      *iv_return = (IV)GL_MULTIPLY_KHR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'Z':
    if (memEQ(name, "GL_WARP_SIZE_NV", 15)) {
    /*                         ^           */
#ifdef GL_WARP_SIZE_NV
      *iv_return = (IV)GL_WARP_SIZE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '_':
    if (memEQ(name, "GL_2PASS_0_SGIS", 15)) {
    /*                         ^           */
#ifdef GL_2PASS_0_SGIS
      *iv_return = (IV)GL_2PASS_0_SGIS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_2PASS_1_SGIS", 15)) {
    /*                         ^           */
#ifdef GL_2PASS_1_SGIS
      *iv_return = (IV)GL_2PASS_1_SGIS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_4PASS_0_SGIS", 15)) {
    /*                         ^           */
#ifdef GL_4PASS_0_SGIS
      *iv_return = (IV)GL_4PASS_0_SGIS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_4PASS_1_SGIS", 15)) {
    /*                         ^           */
#ifdef GL_4PASS_1_SGIS
      *iv_return = (IV)GL_4PASS_1_SGIS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_4PASS_2_SGIS", 15)) {
    /*                         ^           */
#ifdef GL_4PASS_2_SGIS
      *iv_return = (IV)GL_4PASS_2_SGIS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_4PASS_3_SGIS", 15)) {
    /*                         ^           */
#ifdef GL_4PASS_3_SGIS
      *iv_return = (IV)GL_4PASS_3_SGIS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CONTEXT_LOST", 15)) {
    /*                         ^           */
#ifdef GL_CONTEXT_LOST
      *iv_return = (IV)GL_CONTEXT_LOST;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DISPLAY_LIST", 15)) {
    /*                         ^           */
#ifdef GL_DISPLAY_LIST
      *iv_return = (IV)GL_DISPLAY_LIST;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DYNAMIC_COPY", 15)) {
    /*                         ^           */
#ifdef GL_DYNAMIC_COPY
      *iv_return = (IV)GL_DYNAMIC_COPY;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DYNAMIC_DRAW", 15)) {
    /*                         ^           */
#ifdef GL_DYNAMIC_DRAW
      *iv_return = (IV)GL_DYNAMIC_DRAW;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DYNAMIC_READ", 15)) {
    /*                         ^           */
#ifdef GL_DYNAMIC_READ
      *iv_return = (IV)GL_DYNAMIC_READ;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_E_TIMES_F_NV", 15)) {
    /*                         ^           */
#ifdef GL_E_TIMES_F_NV
      *iv_return = (IV)GL_E_TIMES_F_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INVALID_ENUM", 15)) {
    /*                         ^           */
#ifdef GL_INVALID_ENUM
      *iv_return = (IV)GL_INVALID_ENUM;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_RED_SGIS", 15)) {
    /*                         ^           */
#ifdef GL_MAX_RED_SGIS
      *iv_return = (IV)GL_MAX_RED_SGIS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MIN_RED_SGIS", 15)) {
    /*                         ^           */
#ifdef GL_MIN_RED_SGIS
      *iv_return = (IV)GL_MIN_RED_SGIS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_POLYGON_MODE", 15)) {
    /*                         ^           */
#ifdef GL_POLYGON_MODE
      *iv_return = (IV)GL_POLYGON_MODE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLER_CUBE", 15)) {
    /*                         ^           */
#ifdef GL_SAMPLER_CUBE
      *iv_return = (IV)GL_SAMPLER_CUBE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLES_3DFX", 15)) {
    /*                         ^           */
#ifdef GL_SAMPLES_3DFX
      *iv_return = (IV)GL_SAMPLES_3DFX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLES_SGIS", 15)) {
    /*                         ^           */
#ifdef GL_SAMPLES_SGIS
      *iv_return = (IV)GL_SAMPLES_SGIS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SCISSOR_TEST", 15)) {
    /*                         ^           */
#ifdef GL_SCISSOR_TEST
      *iv_return = (IV)GL_SCISSOR_TEST;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STENCIL_BITS", 15)) {
    /*                         ^           */
#ifdef GL_STENCIL_BITS
      *iv_return = (IV)GL_STENCIL_BITS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STENCIL_FAIL", 15)) {
    /*                         ^           */
#ifdef GL_STENCIL_FAIL
      *iv_return = (IV)GL_STENCIL_FAIL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STENCIL_FUNC", 15)) {
    /*                         ^           */
#ifdef GL_STENCIL_FUNC
      *iv_return = (IV)GL_STENCIL_FUNC;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STENCIL_TEST", 15)) {
    /*                         ^           */
#ifdef GL_STENCIL_TEST
      *iv_return = (IV)GL_STENCIL_TEST;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_VIEW", 15)) {
    /*                         ^           */
#ifdef GL_TEXTURE_VIEW
      *iv_return = (IV)GL_TEXTURE_VIEW;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNIFORM_SIZE", 15)) {
    /*                         ^           */
#ifdef GL_UNIFORM_SIZE
      *iv_return = (IV)GL_UNIFORM_SIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNIFORM_TYPE", 15)) {
    /*                         ^           */
#ifdef GL_UNIFORM_TYPE
      *iv_return = (IV)GL_UNIFORM_TYPE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'a':
    if (memEQ(name, "GLEW_SGIX_async", 15)) {
    /*                         ^           */
#ifdef GLEW_SGIX_async
      *iv_return = (IV)GLEW_SGIX_async;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OML_resample", 15)) {
    /*                         ^           */
#ifdef GL_OML_resample
      *iv_return = (IV)GL_OML_resample;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'e':
    if (memEQ(name, "GLEW_SUN_vertex", 15)) {
    /*                         ^           */
#ifdef GLEW_SUN_vertex
      *iv_return = (IV)GLEW_SUN_vertex;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_cl_event", 15)) {
    /*                         ^           */
#ifdef GL_ARB_cl_event
      *iv_return = (IV)GL_ARB_cl_event;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_KHR_no_error", 15)) {
    /*                         ^           */
#ifdef GL_KHR_no_error
      *iv_return = (IV)GL_KHR_no_error;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'h':
    if (memEQ(name, "GLEW_ARB_shadow", 15)) {
    /*                         ^           */
#ifdef GLEW_ARB_shadow
      *iv_return = (IV)GLEW_ARB_shadow;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'i':
    if (memEQ(name, "GL_SGIX_clipmap", 15)) {
    /*                         ^           */
#ifdef GL_SGIX_clipmap
      *iv_return = (IV)GL_SGIX_clipmap;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'n':
    if (memEQ(name, "GL_REGAL_enable", 15)) {
    /*                         ^           */
#ifdef GL_REGAL_enable
      *iv_return = (IV)GL_REGAL_enable;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 's':
    if (memEQ(name, "GL_ARB_gl_spirv", 15)) {
    /*                         ^           */
#ifdef GL_ARB_gl_spirv
      *iv_return = (IV)GL_ARB_gl_spirv;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'u':
    if (memEQ(name, "GL_3DFX_tbuffer", 15)) {
    /*                         ^           */
#ifdef GL_3DFX_tbuffer
      *iv_return = (IV)GL_3DFX_tbuffer;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'y':
    if (memEQ(name, "GLEW_SGIX_ycrcb", 15)) {
    /*                         ^           */
#ifdef GLEW_SGIX_ycrcb
      *iv_return = (IV)GLEW_SGIX_ycrcb;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  }
  return PERL_constant_NOTFOUND;
}

static int
constant_16 (pTHX_ const char *name, IV *iv_return) {
  /* When generated this function returned values for the list of names given
     here.  However, subsequent manual editing may have added or removed some.
     GLEW_APPLE_fence GLEW_ARB_imaging GLEW_ATI_meminfo GLEW_EXT_texture
     GLEW_SGIX_shadow GLEW_SGIX_sprite GLEW_VERSION_1_1 GLEW_VERSION_1_2
     GLEW_VERSION_1_3 GLEW_VERSION_1_4 GLEW_VERSION_1_5 GLEW_VERSION_2_0
     GLEW_VERSION_2_1 GLEW_VERSION_3_0 GLEW_VERSION_3_1 GLEW_VERSION_3_2
     GLEW_VERSION_3_3 GLEW_VERSION_4_0 GLEW_VERSION_4_1 GLEW_VERSION_4_2
     GLEW_VERSION_4_3 GLEW_VERSION_4_4 GLEW_VERSION_4_5 GL_ALPHA16UI_EXT
     GL_ALPHA16_SNORM GL_ALPHA32UI_EXT GL_ALPHA_INTEGER GL_APPLE_rgb_422
     GL_BLEND_DST_RGB GL_BLEND_SRC_RGB GL_BOOL_VEC2_ARB GL_BOOL_VEC3_ARB
     GL_BOOL_VEC4_ARB GL_BUFFER_ACCESS GL_BUFFER_MAPPED GL_CLAMP_TO_EDGE
     GL_CLEAR_TEXTURE GL_CLOSE_PATH_NV GL_COLORBURN_KHR GL_COLORDODGE_NV
     GL_COLOR_INDEXES GL_COLOR_SUM_ARB GL_COLOR_SUM_EXT GL_COMBINE_ALPHA
     GL_COMPRESSED_RG GL_CONFORMANT_NV GL_CONTEXT_FLAGS GL_COORD_REPLACE
     GL_COPY_INVERTED GL_COUNT_DOWN_NV GL_CULL_MODES_NV GL_CURRENT_COLOR
     GL_CURRENT_INDEX GL_CURRENT_QUERY GL_DECR_WRAP_EXT GL_DELETE_STATUS
     GL_DEPTH_STENCIL GL_DIFFERENCE_NV GL_DOT3_RGBA_ARB GL_DOT3_RGBA_EXT
     GL_DOUBLE_MAT2x3 GL_DOUBLE_MAT2x4 GL_DOUBLE_MAT3x2 GL_DOUBLE_MAT3x4
     GL_DOUBLE_MAT4x2 GL_DOUBLE_MAT4x3 GL_DRAW_BUFFER10 GL_DRAW_BUFFER11
     GL_DRAW_BUFFER12 GL_DRAW_BUFFER13 GL_DRAW_BUFFER14 GL_DRAW_BUFFER15
     GL_DSDT8_MAG8_NV GL_EMBOSS_MAP_NV GL_EXCLUSION_KHR GL_EXCLUSIVE_EXT
     GL_EXT_Cg_shader GL_EXT_fog_coord GL_EXT_histogram GL_EXT_texture3D
     GL_EYE_LINE_SGIS GL_EYE_RADIAL_NV GL_FLOAT_RG16_NV GL_FLOAT_RG32_NV
     GL_FLOAT_RGBA_NV GL_FOG_COORD_SRC GL_FUNC_SUBTRACT GL_GREEN_BIT_ATI
     GL_GREEN_INTEGER GL_HALF_FLOAT_NV GL_HARDLIGHT_KHR GL_HISTOGRAM_EXT
     GL_HSL_COLOR_KHR GL_IGNORE_BORDER GL_IMAGE_2D_RECT GL_INCLUSIVE_EXT
     GL_INCR_WRAP_EXT GL_INDEX_BIT_PGI GL_INT16_VEC2_NV GL_INT16_VEC3_NV
     GL_INT16_VEC4_NV GL_INT64_VEC2_NV GL_INT64_VEC3_NV GL_INT64_VEC4_NV
     GL_INTENSITY_EXT GL_INTERLACE_OML GL_INVALID_INDEX GL_INVALID_VALUE
     GL_INVARIANT_EXT GL_INVERT_OVG_NV GL_INVERT_RGB_NV GL_ITALIC_BIT_NV
     GL_LINEARBURN_NV GL_LOGIC_OP_MODE GL_LOG_APP_REGAL GL_MAJOR_VERSION
     GL_MAP1_VERTEX_3 GL_MAP1_VERTEX_4 GL_MAP2_VERTEX_3 GL_MAP2_VERTEX_4
     GL_MAP_WRITE_BIT GL_MATRIX_STRIDE GL_MAX_BLUE_SGIS GL_MAX_VIEWPORTS
     GL_MAX_VIEWS_OVR GL_MINMAX_FORMAT GL_MINOR_VERSION GL_MIN_BLUE_SGIS
     GL_MISSING_REGAL GL_NORMAL_MAP_NV GL_NV_copy_image GL_NV_evaluators
     GL_NV_half_float GL_OBJECT_LINEAR GL_OML_interlace GL_OML_subsample
     GL_OP_NEGATE_EXT GL_OP_SET_GE_EXT GL_OP_SET_LT_EXT GL_OUT_OF_MEMORY
     GL_OVR_multiview GL_POLYGON_TOKEN GL_PRIMARY_COLOR GL_PROGRAM_INPUT
     GL_QUAD_MESH_SUN GL_QUERY_NO_WAIT GL_QUERY_WAIT_NV GL_READ_ONLY_ARB
     GL_RGB_422_APPLE GL_RGB_SCALE_ARB GL_RGB_SCALE_EXT GL_SGIX_resample
     GL_SIGNED_RGB_NV GL_SOFTLIGHT_KHR GL_SOURCE0_ALPHA GL_SOURCE1_ALPHA
     GL_SOURCE2_ALPHA GL_SPOT_EXPONENT GL_STENCIL_INDEX GL_SUBPIXEL_BITS
     GL_TESS_GEN_MODE GL_TEXTURE10_ARB GL_TEXTURE11_ARB GL_TEXTURE12_ARB
     GL_TEXTURE13_ARB GL_TEXTURE14_ARB GL_TEXTURE15_ARB GL_TEXTURE16_ARB
     GL_TEXTURE17_ARB GL_TEXTURE18_ARB GL_TEXTURE19_ARB GL_TEXTURE20_ARB
     GL_TEXTURE21_ARB GL_TEXTURE22_ARB GL_TEXTURE23_ARB GL_TEXTURE24_ARB
     GL_TEXTURE25_ARB GL_TEXTURE26_ARB GL_TEXTURE27_ARB GL_TEXTURE28_ARB
     GL_TEXTURE29_ARB GL_TEXTURE30_ARB GL_TEXTURE31_ARB GL_TEXTURE_DEPTH
     GL_TEXTURE_GEN_Q GL_TEXTURE_GEN_R GL_TEXTURE_GEN_S GL_TEXTURE_GEN_T
     GL_TEXTURE_WIDTH GL_TRANSFORM_BIT GL_TRIANGULAR_NV GL_UNIFORM_BLOCK
     GL_UNSIGNED_BYTE GL_VARIABLE_A_NV GL_VARIABLE_B_NV GL_VARIABLE_C_NV
     GL_VARIABLE_D_NV GL_VARIABLE_E_NV GL_VARIABLE_F_NV GL_VARIABLE_G_NV
     GL_VERSION_1_2_1 GL_VERTEX_SHADER GL_VIVIDLIGHT_NV GL_WIN_swap_hint */
  /* Offset 11 gives the best switch position.  */
  switch (name[11]) {
  case '0':
    if (memEQ(name, "GL_TEXTURE10_ARB", 16)) {
    /*                          ^           */
#ifdef GL_TEXTURE10_ARB
      *iv_return = (IV)GL_TEXTURE10_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE20_ARB", 16)) {
    /*                          ^           */
#ifdef GL_TEXTURE20_ARB
      *iv_return = (IV)GL_TEXTURE20_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE30_ARB", 16)) {
    /*                          ^           */
#ifdef GL_TEXTURE30_ARB
      *iv_return = (IV)GL_TEXTURE30_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '1':
    if (memEQ(name, "GL_FLOAT_RG16_NV", 16)) {
    /*                          ^           */
#ifdef GL_FLOAT_RG16_NV
      *iv_return = (IV)GL_FLOAT_RG16_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE11_ARB", 16)) {
    /*                          ^           */
#ifdef GL_TEXTURE11_ARB
      *iv_return = (IV)GL_TEXTURE11_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE21_ARB", 16)) {
    /*                          ^           */
#ifdef GL_TEXTURE21_ARB
      *iv_return = (IV)GL_TEXTURE21_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE31_ARB", 16)) {
    /*                          ^           */
#ifdef GL_TEXTURE31_ARB
      *iv_return = (IV)GL_TEXTURE31_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERSION_1_2_1", 16)) {
    /*                          ^           */
#ifdef GL_VERSION_1_2_1
      *iv_return = (IV)GL_VERSION_1_2_1;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '2':
    if (memEQ(name, "GL_BOOL_VEC2_ARB", 16)) {
    /*                          ^           */
#ifdef GL_BOOL_VEC2_ARB
      *iv_return = (IV)GL_BOOL_VEC2_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE12_ARB", 16)) {
    /*                          ^           */
#ifdef GL_TEXTURE12_ARB
      *iv_return = (IV)GL_TEXTURE12_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE22_ARB", 16)) {
    /*                          ^           */
#ifdef GL_TEXTURE22_ARB
      *iv_return = (IV)GL_TEXTURE22_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '3':
    if (memEQ(name, "GL_BOOL_VEC3_ARB", 16)) {
    /*                          ^           */
#ifdef GL_BOOL_VEC3_ARB
      *iv_return = (IV)GL_BOOL_VEC3_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FLOAT_RG32_NV", 16)) {
    /*                          ^           */
#ifdef GL_FLOAT_RG32_NV
      *iv_return = (IV)GL_FLOAT_RG32_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE13_ARB", 16)) {
    /*                          ^           */
#ifdef GL_TEXTURE13_ARB
      *iv_return = (IV)GL_TEXTURE13_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE23_ARB", 16)) {
    /*                          ^           */
#ifdef GL_TEXTURE23_ARB
      *iv_return = (IV)GL_TEXTURE23_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '4':
    if (memEQ(name, "GL_BOOL_VEC4_ARB", 16)) {
    /*                          ^           */
#ifdef GL_BOOL_VEC4_ARB
      *iv_return = (IV)GL_BOOL_VEC4_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE14_ARB", 16)) {
    /*                          ^           */
#ifdef GL_TEXTURE14_ARB
      *iv_return = (IV)GL_TEXTURE14_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE24_ARB", 16)) {
    /*                          ^           */
#ifdef GL_TEXTURE24_ARB
      *iv_return = (IV)GL_TEXTURE24_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '5':
    if (memEQ(name, "GL_TEXTURE15_ARB", 16)) {
    /*                          ^           */
#ifdef GL_TEXTURE15_ARB
      *iv_return = (IV)GL_TEXTURE15_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE25_ARB", 16)) {
    /*                          ^           */
#ifdef GL_TEXTURE25_ARB
      *iv_return = (IV)GL_TEXTURE25_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '6':
    if (memEQ(name, "GL_TEXTURE16_ARB", 16)) {
    /*                          ^           */
#ifdef GL_TEXTURE16_ARB
      *iv_return = (IV)GL_TEXTURE16_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE26_ARB", 16)) {
    /*                          ^           */
#ifdef GL_TEXTURE26_ARB
      *iv_return = (IV)GL_TEXTURE26_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '7':
    if (memEQ(name, "GL_TEXTURE17_ARB", 16)) {
    /*                          ^           */
#ifdef GL_TEXTURE17_ARB
      *iv_return = (IV)GL_TEXTURE17_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE27_ARB", 16)) {
    /*                          ^           */
#ifdef GL_TEXTURE27_ARB
      *iv_return = (IV)GL_TEXTURE27_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '8':
    if (memEQ(name, "GL_TEXTURE18_ARB", 16)) {
    /*                          ^           */
#ifdef GL_TEXTURE18_ARB
      *iv_return = (IV)GL_TEXTURE18_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE28_ARB", 16)) {
    /*                          ^           */
#ifdef GL_TEXTURE28_ARB
      *iv_return = (IV)GL_TEXTURE28_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '9':
    if (memEQ(name, "GL_TEXTURE19_ARB", 16)) {
    /*                          ^           */
#ifdef GL_TEXTURE19_ARB
      *iv_return = (IV)GL_TEXTURE19_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE29_ARB", 16)) {
    /*                          ^           */
#ifdef GL_TEXTURE29_ARB
      *iv_return = (IV)GL_TEXTURE29_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'A':
    if (memEQ(name, "GL_BUFFER_MAPPED", 16)) {
    /*                          ^           */
#ifdef GL_BUFFER_MAPPED
      *iv_return = (IV)GL_BUFFER_MAPPED;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COMBINE_ALPHA", 16)) {
    /*                          ^           */
#ifdef GL_COMBINE_ALPHA
      *iv_return = (IV)GL_COMBINE_ALPHA;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DOT3_RGBA_ARB", 16)) {
    /*                          ^           */
#ifdef GL_DOT3_RGBA_ARB
      *iv_return = (IV)GL_DOT3_RGBA_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DOT3_RGBA_EXT", 16)) {
    /*                          ^           */
#ifdef GL_DOT3_RGBA_EXT
      *iv_return = (IV)GL_DOT3_RGBA_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DOUBLE_MAT2x3", 16)) {
    /*                          ^           */
#ifdef GL_DOUBLE_MAT2x3
      *iv_return = (IV)GL_DOUBLE_MAT2x3;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DOUBLE_MAT2x4", 16)) {
    /*                          ^           */
#ifdef GL_DOUBLE_MAT2x4
      *iv_return = (IV)GL_DOUBLE_MAT2x4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DOUBLE_MAT3x2", 16)) {
    /*                          ^           */
#ifdef GL_DOUBLE_MAT3x2
      *iv_return = (IV)GL_DOUBLE_MAT3x2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DOUBLE_MAT3x4", 16)) {
    /*                          ^           */
#ifdef GL_DOUBLE_MAT3x4
      *iv_return = (IV)GL_DOUBLE_MAT3x4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DOUBLE_MAT4x2", 16)) {
    /*                          ^           */
#ifdef GL_DOUBLE_MAT4x2
      *iv_return = (IV)GL_DOUBLE_MAT4x2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DOUBLE_MAT4x3", 16)) {
    /*                          ^           */
#ifdef GL_DOUBLE_MAT4x3
      *iv_return = (IV)GL_DOUBLE_MAT4x3;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EMBOSS_MAP_NV", 16)) {
    /*                          ^           */
#ifdef GL_EMBOSS_MAP_NV
      *iv_return = (IV)GL_EMBOSS_MAP_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EYE_RADIAL_NV", 16)) {
    /*                          ^           */
#ifdef GL_EYE_RADIAL_NV
      *iv_return = (IV)GL_EYE_RADIAL_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_HALF_FLOAT_NV", 16)) {
    /*                          ^           */
#ifdef GL_HALF_FLOAT_NV
      *iv_return = (IV)GL_HALF_FLOAT_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NORMAL_MAP_NV", 16)) {
    /*                          ^           */
#ifdef GL_NORMAL_MAP_NV
      *iv_return = (IV)GL_NORMAL_MAP_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGB_422_APPLE", 16)) {
    /*                          ^           */
#ifdef GL_RGB_422_APPLE
      *iv_return = (IV)GL_RGB_422_APPLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SOURCE0_ALPHA", 16)) {
    /*                          ^           */
#ifdef GL_SOURCE0_ALPHA
      *iv_return = (IV)GL_SOURCE0_ALPHA;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SOURCE1_ALPHA", 16)) {
    /*                          ^           */
#ifdef GL_SOURCE1_ALPHA
      *iv_return = (IV)GL_SOURCE1_ALPHA;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SOURCE2_ALPHA", 16)) {
    /*                          ^           */
#ifdef GL_SOURCE2_ALPHA
      *iv_return = (IV)GL_SOURCE2_ALPHA;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TRIANGULAR_NV", 16)) {
    /*                          ^           */
#ifdef GL_TRIANGULAR_NV
      *iv_return = (IV)GL_TRIANGULAR_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'B':
    if (memEQ(name, "GL_FLOAT_RGBA_NV", 16)) {
    /*                          ^           */
#ifdef GL_FLOAT_RGBA_NV
      *iv_return = (IV)GL_FLOAT_RGBA_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNIFORM_BLOCK", 16)) {
    /*                          ^           */
#ifdef GL_UNIFORM_BLOCK
      *iv_return = (IV)GL_UNIFORM_BLOCK;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'C':
    if (memEQ(name, "GL_BLEND_SRC_RGB", 16)) {
    /*                          ^           */
#ifdef GL_BLEND_SRC_RGB
      *iv_return = (IV)GL_BLEND_SRC_RGB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_BUFFER_ACCESS", 16)) {
    /*                          ^           */
#ifdef GL_BUFFER_ACCESS
      *iv_return = (IV)GL_BUFFER_ACCESS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CURRENT_COLOR", 16)) {
    /*                          ^           */
#ifdef GL_CURRENT_COLOR
      *iv_return = (IV)GL_CURRENT_COLOR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DIFFERENCE_NV", 16)) {
    /*                          ^           */
#ifdef GL_DIFFERENCE_NV
      *iv_return = (IV)GL_DIFFERENCE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INT16_VEC2_NV", 16)) {
    /*                          ^           */
#ifdef GL_INT16_VEC2_NV
      *iv_return = (IV)GL_INT16_VEC2_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INT16_VEC3_NV", 16)) {
    /*                          ^           */
#ifdef GL_INT16_VEC3_NV
      *iv_return = (IV)GL_INT16_VEC3_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INT16_VEC4_NV", 16)) {
    /*                          ^           */
#ifdef GL_INT16_VEC4_NV
      *iv_return = (IV)GL_INT16_VEC4_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INT64_VEC2_NV", 16)) {
    /*                          ^           */
#ifdef GL_INT64_VEC2_NV
      *iv_return = (IV)GL_INT64_VEC2_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INT64_VEC3_NV", 16)) {
    /*                          ^           */
#ifdef GL_INT64_VEC3_NV
      *iv_return = (IV)GL_INT64_VEC3_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INT64_VEC4_NV", 16)) {
    /*                          ^           */
#ifdef GL_INT64_VEC4_NV
      *iv_return = (IV)GL_INT64_VEC4_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PRIMARY_COLOR", 16)) {
    /*                          ^           */
#ifdef GL_PRIMARY_COLOR
      *iv_return = (IV)GL_PRIMARY_COLOR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'D':
    if (memEQ(name, "GL_COLOR_INDEXES", 16)) {
    /*                          ^           */
#ifdef GL_COLOR_INDEXES
      *iv_return = (IV)GL_COLOR_INDEXES;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FOG_COORD_SRC", 16)) {
    /*                          ^           */
#ifdef GL_FOG_COORD_SRC
      *iv_return = (IV)GL_FOG_COORD_SRC;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_DEPTH", 16)) {
    /*                          ^           */
#ifdef GL_TEXTURE_DEPTH
      *iv_return = (IV)GL_TEXTURE_DEPTH;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'E':
    if (memEQ(name, "GL_COMPRESSED_RG", 16)) {
    /*                          ^           */
#ifdef GL_COMPRESSED_RG
      *iv_return = (IV)GL_COMPRESSED_RG;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COPY_INVERTED", 16)) {
    /*                          ^           */
#ifdef GL_COPY_INVERTED
      *iv_return = (IV)GL_COPY_INVERTED;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CULL_MODES_NV", 16)) {
    /*                          ^           */
#ifdef GL_CULL_MODES_NV
      *iv_return = (IV)GL_CULL_MODES_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEPTH_STENCIL", 16)) {
    /*                          ^           */
#ifdef GL_DEPTH_STENCIL
      *iv_return = (IV)GL_DEPTH_STENCIL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXCLUSIVE_EXT", 16)) {
    /*                          ^           */
#ifdef GL_EXCLUSIVE_EXT
      *iv_return = (IV)GL_EXCLUSIVE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INCLUSIVE_EXT", 16)) {
    /*                          ^           */
#ifdef GL_INCLUSIVE_EXT
      *iv_return = (IV)GL_INCLUSIVE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INTERLACE_OML", 16)) {
    /*                          ^           */
#ifdef GL_INTERLACE_OML
      *iv_return = (IV)GL_INTERLACE_OML;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAP_WRITE_BIT", 16)) {
    /*                          ^           */
#ifdef GL_MAP_WRITE_BIT
      *iv_return = (IV)GL_MAP_WRITE_BIT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OP_NEGATE_EXT", 16)) {
    /*                          ^           */
#ifdef GL_OP_NEGATE_EXT
      *iv_return = (IV)GL_OP_NEGATE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OP_SET_GE_EXT", 16)) {
    /*                          ^           */
#ifdef GL_OP_SET_GE_EXT
      *iv_return = (IV)GL_OP_SET_GE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OUT_OF_MEMORY", 16)) {
    /*                          ^           */
#ifdef GL_OUT_OF_MEMORY
      *iv_return = (IV)GL_OUT_OF_MEMORY;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGB_SCALE_ARB", 16)) {
    /*                          ^           */
#ifdef GL_RGB_SCALE_ARB
      *iv_return = (IV)GL_RGB_SCALE_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGB_SCALE_EXT", 16)) {
    /*                          ^           */
#ifdef GL_RGB_SCALE_EXT
      *iv_return = (IV)GL_RGB_SCALE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'F':
    if (memEQ(name, "GL_CONTEXT_FLAGS", 16)) {
    /*                          ^           */
#ifdef GL_CONTEXT_FLAGS
      *iv_return = (IV)GL_CONTEXT_FLAGS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRAW_BUFFER10", 16)) {
    /*                          ^           */
#ifdef GL_DRAW_BUFFER10
      *iv_return = (IV)GL_DRAW_BUFFER10;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRAW_BUFFER11", 16)) {
    /*                          ^           */
#ifdef GL_DRAW_BUFFER11
      *iv_return = (IV)GL_DRAW_BUFFER11;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRAW_BUFFER12", 16)) {
    /*                          ^           */
#ifdef GL_DRAW_BUFFER12
      *iv_return = (IV)GL_DRAW_BUFFER12;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRAW_BUFFER13", 16)) {
    /*                          ^           */
#ifdef GL_DRAW_BUFFER13
      *iv_return = (IV)GL_DRAW_BUFFER13;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRAW_BUFFER14", 16)) {
    /*                          ^           */
#ifdef GL_DRAW_BUFFER14
      *iv_return = (IV)GL_DRAW_BUFFER14;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRAW_BUFFER15", 16)) {
    /*                          ^           */
#ifdef GL_DRAW_BUFFER15
      *iv_return = (IV)GL_DRAW_BUFFER15;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'G':
    if (memEQ(name, "GL_COLORDODGE_NV", 16)) {
    /*                          ^           */
#ifdef GL_COLORDODGE_NV
      *iv_return = (IV)GL_COLORDODGE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DSDT8_MAG8_NV", 16)) {
    /*                          ^           */
#ifdef GL_DSDT8_MAG8_NV
      *iv_return = (IV)GL_DSDT8_MAG8_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INVERT_RGB_NV", 16)) {
    /*                          ^           */
#ifdef GL_INVERT_RGB_NV
      *iv_return = (IV)GL_INVERT_RGB_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SIGNED_RGB_NV", 16)) {
    /*                          ^           */
#ifdef GL_SIGNED_RGB_NV
      *iv_return = (IV)GL_SIGNED_RGB_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_GEN_Q", 16)) {
    /*                          ^           */
#ifdef GL_TEXTURE_GEN_Q
      *iv_return = (IV)GL_TEXTURE_GEN_Q;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_GEN_R", 16)) {
    /*                          ^           */
#ifdef GL_TEXTURE_GEN_R
      *iv_return = (IV)GL_TEXTURE_GEN_R;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_GEN_S", 16)) {
    /*                          ^           */
#ifdef GL_TEXTURE_GEN_S
      *iv_return = (IV)GL_TEXTURE_GEN_S;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_GEN_T", 16)) {
    /*                          ^           */
#ifdef GL_TEXTURE_GEN_T
      *iv_return = (IV)GL_TEXTURE_GEN_T;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'H':
    if (memEQ(name, "GL_QUAD_MESH_SUN", 16)) {
    /*                          ^           */
#ifdef GL_QUAD_MESH_SUN
      *iv_return = (IV)GL_QUAD_MESH_SUN;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERTEX_SHADER", 16)) {
    /*                          ^           */
#ifdef GL_VERTEX_SHADER
      *iv_return = (IV)GL_VERTEX_SHADER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VIVIDLIGHT_NV", 16)) {
    /*                          ^           */
#ifdef GL_VIVIDLIGHT_NV
      *iv_return = (IV)GL_VIVIDLIGHT_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'I':
    if (memEQ(name, "GL_ALPHA16UI_EXT", 16)) {
    /*                          ^           */
#ifdef GL_ALPHA16UI_EXT
      *iv_return = (IV)GL_ALPHA16UI_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ALPHA32UI_EXT", 16)) {
    /*                          ^           */
#ifdef GL_ALPHA32UI_EXT
      *iv_return = (IV)GL_ALPHA32UI_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CURRENT_INDEX", 16)) {
    /*                          ^           */
#ifdef GL_CURRENT_INDEX
      *iv_return = (IV)GL_CURRENT_INDEX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INVALID_INDEX", 16)) {
    /*                          ^           */
#ifdef GL_INVALID_INDEX
      *iv_return = (IV)GL_INVALID_INDEX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ITALIC_BIT_NV", 16)) {
    /*                          ^           */
#ifdef GL_ITALIC_BIT_NV
      *iv_return = (IV)GL_ITALIC_BIT_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OBJECT_LINEAR", 16)) {
    /*                          ^           */
#ifdef GL_OBJECT_LINEAR
      *iv_return = (IV)GL_OBJECT_LINEAR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PROGRAM_INPUT", 16)) {
    /*                          ^           */
#ifdef GL_PROGRAM_INPUT
      *iv_return = (IV)GL_PROGRAM_INPUT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_QUERY_WAIT_NV", 16)) {
    /*                          ^           */
#ifdef GL_QUERY_WAIT_NV
      *iv_return = (IV)GL_QUERY_WAIT_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STENCIL_INDEX", 16)) {
    /*                          ^           */
#ifdef GL_STENCIL_INDEX
      *iv_return = (IV)GL_STENCIL_INDEX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'M':
    if (memEQ(name, "GL_COLOR_SUM_ARB", 16)) {
    /*                          ^           */
#ifdef GL_COLOR_SUM_ARB
      *iv_return = (IV)GL_COLOR_SUM_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_SUM_EXT", 16)) {
    /*                          ^           */
#ifdef GL_COLOR_SUM_EXT
      *iv_return = (IV)GL_COLOR_SUM_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_HISTOGRAM_EXT", 16)) {
    /*                          ^           */
#ifdef GL_HISTOGRAM_EXT
      *iv_return = (IV)GL_HISTOGRAM_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TRANSFORM_BIT", 16)) {
    /*                          ^           */
#ifdef GL_TRANSFORM_BIT
      *iv_return = (IV)GL_TRANSFORM_BIT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'N':
    if (memEQ(name, "GLEW_VERSION_1_1", 16)) {
    /*                          ^           */
#ifdef GLEW_VERSION_1_1
      *iv_return = (IV)GLEW_VERSION_1_1;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_VERSION_1_2", 16)) {
    /*                          ^           */
#ifdef GLEW_VERSION_1_2
      *iv_return = (IV)GLEW_VERSION_1_2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_VERSION_1_3", 16)) {
    /*                          ^           */
#ifdef GLEW_VERSION_1_3
      *iv_return = (IV)GLEW_VERSION_1_3;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_VERSION_1_4", 16)) {
    /*                          ^           */
#ifdef GLEW_VERSION_1_4
      *iv_return = (IV)GLEW_VERSION_1_4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_VERSION_1_5", 16)) {
    /*                          ^           */
#ifdef GLEW_VERSION_1_5
      *iv_return = (IV)GLEW_VERSION_1_5;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_VERSION_2_0", 16)) {
    /*                          ^           */
#ifdef GLEW_VERSION_2_0
      *iv_return = (IV)GLEW_VERSION_2_0;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_VERSION_2_1", 16)) {
    /*                          ^           */
#ifdef GLEW_VERSION_2_1
      *iv_return = (IV)GLEW_VERSION_2_1;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_VERSION_3_0", 16)) {
    /*                          ^           */
#ifdef GLEW_VERSION_3_0
      *iv_return = (IV)GLEW_VERSION_3_0;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_VERSION_3_1", 16)) {
    /*                          ^           */
#ifdef GLEW_VERSION_3_1
      *iv_return = (IV)GLEW_VERSION_3_1;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_VERSION_3_2", 16)) {
    /*                          ^           */
#ifdef GLEW_VERSION_3_2
      *iv_return = (IV)GLEW_VERSION_3_2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_VERSION_3_3", 16)) {
    /*                          ^           */
#ifdef GLEW_VERSION_3_3
      *iv_return = (IV)GLEW_VERSION_3_3;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_VERSION_4_0", 16)) {
    /*                          ^           */
#ifdef GLEW_VERSION_4_0
      *iv_return = (IV)GLEW_VERSION_4_0;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_VERSION_4_1", 16)) {
    /*                          ^           */
#ifdef GLEW_VERSION_4_1
      *iv_return = (IV)GLEW_VERSION_4_1;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_VERSION_4_2", 16)) {
    /*                          ^           */
#ifdef GLEW_VERSION_4_2
      *iv_return = (IV)GLEW_VERSION_4_2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_VERSION_4_3", 16)) {
    /*                          ^           */
#ifdef GLEW_VERSION_4_3
      *iv_return = (IV)GLEW_VERSION_4_3;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_VERSION_4_4", 16)) {
    /*                          ^           */
#ifdef GLEW_VERSION_4_4
      *iv_return = (IV)GLEW_VERSION_4_4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_VERSION_4_5", 16)) {
    /*                          ^           */
#ifdef GLEW_VERSION_4_5
      *iv_return = (IV)GLEW_VERSION_4_5;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLORBURN_KHR", 16)) {
    /*                          ^           */
#ifdef GL_COLORBURN_KHR
      *iv_return = (IV)GL_COLORBURN_KHR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CONFORMANT_NV", 16)) {
    /*                          ^           */
#ifdef GL_CONFORMANT_NV
      *iv_return = (IV)GL_CONFORMANT_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXCLUSION_KHR", 16)) {
    /*                          ^           */
#ifdef GL_EXCLUSION_KHR
      *iv_return = (IV)GL_EXCLUSION_KHR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'O':
    if (memEQ(name, "GL_IGNORE_BORDER", 16)) {
    /*                          ^           */
#ifdef GL_IGNORE_BORDER
      *iv_return = (IV)GL_IGNORE_BORDER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MINMAX_FORMAT", 16)) {
    /*                          ^           */
#ifdef GL_MINMAX_FORMAT
      *iv_return = (IV)GL_MINMAX_FORMAT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SPOT_EXPONENT", 16)) {
    /*                          ^           */
#ifdef GL_SPOT_EXPONENT
      *iv_return = (IV)GL_SPOT_EXPONENT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'P':
    if (memEQ(name, "GL_COORD_REPLACE", 16)) {
    /*                          ^           */
#ifdef GL_COORD_REPLACE
      *iv_return = (IV)GL_COORD_REPLACE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DECR_WRAP_EXT", 16)) {
    /*                          ^           */
#ifdef GL_DECR_WRAP_EXT
      *iv_return = (IV)GL_DECR_WRAP_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INCR_WRAP_EXT", 16)) {
    /*                          ^           */
#ifdef GL_INCR_WRAP_EXT
      *iv_return = (IV)GL_INCR_WRAP_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_VIEWPORTS", 16)) {
    /*                          ^           */
#ifdef GL_MAX_VIEWPORTS
      *iv_return = (IV)GL_MAX_VIEWPORTS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'Q':
    if (memEQ(name, "GL_CURRENT_QUERY", 16)) {
    /*                          ^           */
#ifdef GL_CURRENT_QUERY
      *iv_return = (IV)GL_CURRENT_QUERY;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'R':
    if (memEQ(name, "GL_HSL_COLOR_KHR", 16)) {
    /*                          ^           */
#ifdef GL_HSL_COLOR_KHR
      *iv_return = (IV)GL_HSL_COLOR_KHR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LINEARBURN_NV", 16)) {
    /*                          ^           */
#ifdef GL_LINEARBURN_NV
      *iv_return = (IV)GL_LINEARBURN_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LOG_APP_REGAL", 16)) {
    /*                          ^           */
#ifdef GL_LOG_APP_REGAL
      *iv_return = (IV)GL_LOG_APP_REGAL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAJOR_VERSION", 16)) {
    /*                          ^           */
#ifdef GL_MAJOR_VERSION
      *iv_return = (IV)GL_MAJOR_VERSION;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MINOR_VERSION", 16)) {
    /*                          ^           */
#ifdef GL_MINOR_VERSION
      *iv_return = (IV)GL_MINOR_VERSION;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MISSING_REGAL", 16)) {
    /*                          ^           */
#ifdef GL_MISSING_REGAL
      *iv_return = (IV)GL_MISSING_REGAL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'S':
    if (memEQ(name, "GL_ALPHA16_SNORM", 16)) {
    /*                          ^           */
#ifdef GL_ALPHA16_SNORM
      *iv_return = (IV)GL_ALPHA16_SNORM;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_VIEWS_OVR", 16)) {
    /*                          ^           */
#ifdef GL_MAX_VIEWS_OVR
      *iv_return = (IV)GL_MAX_VIEWS_OVR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'T':
    if (memEQ(name, "GL_ALPHA_INTEGER", 16)) {
    /*                          ^           */
#ifdef GL_ALPHA_INTEGER
      *iv_return = (IV)GL_ALPHA_INTEGER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_BLEND_DST_RGB", 16)) {
    /*                          ^           */
#ifdef GL_BLEND_DST_RGB
      *iv_return = (IV)GL_BLEND_DST_RGB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CLOSE_PATH_NV", 16)) {
    /*                          ^           */
#ifdef GL_CLOSE_PATH_NV
      *iv_return = (IV)GL_CLOSE_PATH_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DELETE_STATUS", 16)) {
    /*                          ^           */
#ifdef GL_DELETE_STATUS
      *iv_return = (IV)GL_DELETE_STATUS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FUNC_SUBTRACT", 16)) {
    /*                          ^           */
#ifdef GL_FUNC_SUBTRACT
      *iv_return = (IV)GL_FUNC_SUBTRACT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_GREEN_BIT_ATI", 16)) {
    /*                          ^           */
#ifdef GL_GREEN_BIT_ATI
      *iv_return = (IV)GL_GREEN_BIT_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_GREEN_INTEGER", 16)) {
    /*                          ^           */
#ifdef GL_GREEN_INTEGER
      *iv_return = (IV)GL_GREEN_INTEGER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_HARDLIGHT_KHR", 16)) {
    /*                          ^           */
#ifdef GL_HARDLIGHT_KHR
      *iv_return = (IV)GL_HARDLIGHT_KHR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INDEX_BIT_PGI", 16)) {
    /*                          ^           */
#ifdef GL_INDEX_BIT_PGI
      *iv_return = (IV)GL_INDEX_BIT_PGI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INVARIANT_EXT", 16)) {
    /*                          ^           */
#ifdef GL_INVARIANT_EXT
      *iv_return = (IV)GL_INVARIANT_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAP1_VERTEX_3", 16)) {
    /*                          ^           */
#ifdef GL_MAP1_VERTEX_3
      *iv_return = (IV)GL_MAP1_VERTEX_3;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAP1_VERTEX_4", 16)) {
    /*                          ^           */
#ifdef GL_MAP1_VERTEX_4
      *iv_return = (IV)GL_MAP1_VERTEX_4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAP2_VERTEX_3", 16)) {
    /*                          ^           */
#ifdef GL_MAP2_VERTEX_3
      *iv_return = (IV)GL_MAP2_VERTEX_3;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAP2_VERTEX_4", 16)) {
    /*                          ^           */
#ifdef GL_MAP2_VERTEX_4
      *iv_return = (IV)GL_MAP2_VERTEX_4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MATRIX_STRIDE", 16)) {
    /*                          ^           */
#ifdef GL_MATRIX_STRIDE
      *iv_return = (IV)GL_MATRIX_STRIDE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OP_SET_LT_EXT", 16)) {
    /*                          ^           */
#ifdef GL_OP_SET_LT_EXT
      *iv_return = (IV)GL_OP_SET_LT_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_POLYGON_TOKEN", 16)) {
    /*                          ^           */
#ifdef GL_POLYGON_TOKEN
      *iv_return = (IV)GL_POLYGON_TOKEN;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SOFTLIGHT_KHR", 16)) {
    /*                          ^           */
#ifdef GL_SOFTLIGHT_KHR
      *iv_return = (IV)GL_SOFTLIGHT_KHR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'V':
    if (memEQ(name, "GL_INVALID_VALUE", 16)) {
    /*                          ^           */
#ifdef GL_INVALID_VALUE
      *iv_return = (IV)GL_INVALID_VALUE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INVERT_OVG_NV", 16)) {
    /*                          ^           */
#ifdef GL_INVERT_OVG_NV
      *iv_return = (IV)GL_INVERT_OVG_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'W':
    if (memEQ(name, "GL_COUNT_DOWN_NV", 16)) {
    /*                          ^           */
#ifdef GL_COUNT_DOWN_NV
      *iv_return = (IV)GL_COUNT_DOWN_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_WIDTH", 16)) {
    /*                          ^           */
#ifdef GL_TEXTURE_WIDTH
      *iv_return = (IV)GL_TEXTURE_WIDTH;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'X':
    if (memEQ(name, "GL_CLEAR_TEXTURE", 16)) {
    /*                          ^           */
#ifdef GL_CLEAR_TEXTURE
      *iv_return = (IV)GL_CLEAR_TEXTURE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'Y':
    if (memEQ(name, "GL_INTENSITY_EXT", 16)) {
    /*                          ^           */
#ifdef GL_INTENSITY_EXT
      *iv_return = (IV)GL_INTENSITY_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_READ_ONLY_ARB", 16)) {
    /*                          ^           */
#ifdef GL_READ_ONLY_ARB
      *iv_return = (IV)GL_READ_ONLY_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '_':
    if (memEQ(name, "GL_CLAMP_TO_EDGE", 16)) {
    /*                          ^           */
#ifdef GL_CLAMP_TO_EDGE
      *iv_return = (IV)GL_CLAMP_TO_EDGE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EYE_LINE_SGIS", 16)) {
    /*                          ^           */
#ifdef GL_EYE_LINE_SGIS
      *iv_return = (IV)GL_EYE_LINE_SGIS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_IMAGE_2D_RECT", 16)) {
    /*                          ^           */
#ifdef GL_IMAGE_2D_RECT
      *iv_return = (IV)GL_IMAGE_2D_RECT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LOGIC_OP_MODE", 16)) {
    /*                          ^           */
#ifdef GL_LOGIC_OP_MODE
      *iv_return = (IV)GL_LOGIC_OP_MODE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_BLUE_SGIS", 16)) {
    /*                          ^           */
#ifdef GL_MAX_BLUE_SGIS
      *iv_return = (IV)GL_MAX_BLUE_SGIS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MIN_BLUE_SGIS", 16)) {
    /*                          ^           */
#ifdef GL_MIN_BLUE_SGIS
      *iv_return = (IV)GL_MIN_BLUE_SGIS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_QUERY_NO_WAIT", 16)) {
    /*                          ^           */
#ifdef GL_QUERY_NO_WAIT
      *iv_return = (IV)GL_QUERY_NO_WAIT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SUBPIXEL_BITS", 16)) {
    /*                          ^           */
#ifdef GL_SUBPIXEL_BITS
      *iv_return = (IV)GL_SUBPIXEL_BITS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TESS_GEN_MODE", 16)) {
    /*                          ^           */
#ifdef GL_TESS_GEN_MODE
      *iv_return = (IV)GL_TESS_GEN_MODE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNSIGNED_BYTE", 16)) {
    /*                          ^           */
#ifdef GL_UNSIGNED_BYTE
      *iv_return = (IV)GL_UNSIGNED_BYTE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VARIABLE_A_NV", 16)) {
    /*                          ^           */
#ifdef GL_VARIABLE_A_NV
      *iv_return = (IV)GL_VARIABLE_A_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VARIABLE_B_NV", 16)) {
    /*                          ^           */
#ifdef GL_VARIABLE_B_NV
      *iv_return = (IV)GL_VARIABLE_B_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VARIABLE_C_NV", 16)) {
    /*                          ^           */
#ifdef GL_VARIABLE_C_NV
      *iv_return = (IV)GL_VARIABLE_C_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VARIABLE_D_NV", 16)) {
    /*                          ^           */
#ifdef GL_VARIABLE_D_NV
      *iv_return = (IV)GL_VARIABLE_D_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VARIABLE_E_NV", 16)) {
    /*                          ^           */
#ifdef GL_VARIABLE_E_NV
      *iv_return = (IV)GL_VARIABLE_E_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VARIABLE_F_NV", 16)) {
    /*                          ^           */
#ifdef GL_VARIABLE_F_NV
      *iv_return = (IV)GL_VARIABLE_F_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VARIABLE_G_NV", 16)) {
    /*                          ^           */
#ifdef GL_VARIABLE_G_NV
      *iv_return = (IV)GL_VARIABLE_G_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_WIN_swap_hint", 16)) {
    /*                          ^           */
#ifdef GL_WIN_swap_hint
      *iv_return = (IV)GL_WIN_swap_hint;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'a':
    if (memEQ(name, "GLEW_ARB_imaging", 16)) {
    /*                          ^           */
#ifdef GLEW_ARB_imaging
      *iv_return = (IV)GLEW_ARB_imaging;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_evaluators", 16)) {
    /*                          ^           */
#ifdef GL_NV_evaluators
      *iv_return = (IV)GL_NV_evaluators;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OML_subsample", 16)) {
    /*                          ^           */
#ifdef GL_OML_subsample
      *iv_return = (IV)GL_OML_subsample;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SGIX_resample", 16)) {
    /*                          ^           */
#ifdef GL_SGIX_resample
      *iv_return = (IV)GL_SGIX_resample;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'b':
    if (memEQ(name, "GL_APPLE_rgb_422", 16)) {
    /*                          ^           */
#ifdef GL_APPLE_rgb_422
      *iv_return = (IV)GL_APPLE_rgb_422;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'c':
    if (memEQ(name, "GL_EXT_fog_coord", 16)) {
    /*                          ^           */
#ifdef GL_EXT_fog_coord
      *iv_return = (IV)GL_EXT_fog_coord;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'f':
    if (memEQ(name, "GLEW_APPLE_fence", 16)) {
    /*                          ^           */
#ifdef GLEW_APPLE_fence
      *iv_return = (IV)GLEW_APPLE_fence;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_half_float", 16)) {
    /*                          ^           */
#ifdef GL_NV_half_float
      *iv_return = (IV)GL_NV_half_float;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'h':
    if (memEQ(name, "GLEW_SGIX_shadow", 16)) {
    /*                          ^           */
#ifdef GLEW_SGIX_shadow
      *iv_return = (IV)GLEW_SGIX_shadow;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_Cg_shader", 16)) {
    /*                          ^           */
#ifdef GL_EXT_Cg_shader
      *iv_return = (IV)GL_EXT_Cg_shader;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'i':
    if (memEQ(name, "GL_NV_copy_image", 16)) {
    /*                          ^           */
#ifdef GL_NV_copy_image
      *iv_return = (IV)GL_NV_copy_image;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OVR_multiview", 16)) {
    /*                          ^           */
#ifdef GL_OVR_multiview
      *iv_return = (IV)GL_OVR_multiview;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'm':
    if (memEQ(name, "GLEW_ATI_meminfo", 16)) {
    /*                          ^           */
#ifdef GLEW_ATI_meminfo
      *iv_return = (IV)GLEW_ATI_meminfo;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'o':
    if (memEQ(name, "GL_EXT_histogram", 16)) {
    /*                          ^           */
#ifdef GL_EXT_histogram
      *iv_return = (IV)GL_EXT_histogram;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'p':
    if (memEQ(name, "GLEW_SGIX_sprite", 16)) {
    /*                          ^           */
#ifdef GLEW_SGIX_sprite
      *iv_return = (IV)GLEW_SGIX_sprite;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'r':
    if (memEQ(name, "GL_OML_interlace", 16)) {
    /*                          ^           */
#ifdef GL_OML_interlace
      *iv_return = (IV)GL_OML_interlace;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'u':
    if (memEQ(name, "GL_EXT_texture3D", 16)) {
    /*                          ^           */
#ifdef GL_EXT_texture3D
      *iv_return = (IV)GL_EXT_texture3D;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'x':
    if (memEQ(name, "GLEW_EXT_texture", 16)) {
    /*                          ^           */
#ifdef GLEW_EXT_texture
      *iv_return = (IV)GLEW_EXT_texture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  }
  return PERL_constant_NOTFOUND;
}

static int
constant_17 (pTHX_ const char *name, IV *iv_return) {
  /* When generated this function returned values for the list of names given
     here.  However, subsequent manual editing may have added or removed some.
     GLEW_3DFX_tbuffer GLEW_ARB_cl_event GLEW_ARB_gl_spirv GLEW_KHR_no_error
     GLEW_OML_resample GLEW_REGAL_enable GLEW_SGIX_clipmap GL_ACCUM_RED_BITS
     GL_ACTIVE_PROGRAM GL_ACTIVE_TEXTURE GL_ADD_SIGNED_ARB GL_ADD_SIGNED_EXT
     GL_ALPHA_MAX_SGIX GL_ALPHA_MIN_SGIX GL_ALPHA_TEST_REF GL_AMD_gcn_shader
     GL_ARB_copy_image GL_ARB_multi_bind GL_ARB_robustness GL_ARB_texture_rg
     GL_ARB_window_pos GL_BLEND_EQUATION GL_BUFFER_BINDING GL_CAVEAT_SUPPORT
     GL_CLIP_DISTANCE0 GL_CLIP_DISTANCE1 GL_CLIP_DISTANCE2 GL_CLIP_DISTANCE3
     GL_CLIP_DISTANCE4 GL_CLIP_DISTANCE5 GL_COLOR3_BIT_PGI GL_COLOR4_BIT_PGI
     GL_COLORDODGE_KHR GL_COLOR_ENCODING GL_COLOR_LOGIC_OP GL_COLOR_MATERIAL
     GL_COMPILE_STATUS GL_COMPRESSED_RED GL_COMPRESSED_RGB GL_COMPUTE_SHADER
     GL_CONSTANT_ALPHA GL_CONSTANT_COLOR GL_CONTINUOUS_AMD GL_CONVEX_HULL_NV
     GL_CONVOLUTION_1D GL_CONVOLUTION_2D GL_CULL_FACE_MODE GL_CURRENT_NORMAL
     GL_DEPTH_CLAMP_NV GL_DIFFERENCE_KHR GL_DOT_PRODUCT_NV GL_EIGHTH_BIT_ATI
     GL_EXT_422_pixels GL_EXT_index_func GL_EXT_subtexture GL_EYE_POINT_SGIS
     GL_FACTOR_MAX_AMD GL_FACTOR_MIN_AMD GL_FIELD_LOWER_NV GL_FIELD_UPPER_NV
     GL_FIXED_ONLY_ARB GL_FLOAT_MAT2_ARB GL_FLOAT_MAT3_ARB GL_FLOAT_MAT4_ARB
     GL_FLOAT_RGB16_NV GL_FLOAT_RGB32_NV GL_FLOAT_VEC2_ARB GL_FLOAT_VEC3_ARB
     GL_FLOAT_VEC4_ARB GL_FOG_COORDINATE GL_FRACTIONAL_ODD GL_FRAGMENT_DEPTH
     GL_FRONT_AND_BACK GL_FULL_RANGE_EXT GL_GPU_ADDRESS_NV GL_HALF_FLOAT_ARB
     GL_HISTOGRAM_SINK GL_IMAGE_1D_ARRAY GL_IMAGE_2D_ARRAY GL_IMAGE_CUBE_EXT
     GL_INDEX_LOGIC_OP GL_INT64_VEC2_ARB GL_INT64_VEC3_ARB GL_INT64_VEC4_ARB
     GL_INTENSITY4_EXT GL_INTENSITY8_EXT GL_INTERLACE_SGIX GL_INT_IMAGE_CUBE
     GL_INT_SAMPLER_1D GL_INT_SAMPLER_2D GL_INT_SAMPLER_3D GL_KHR_robustness
     GL_LINEARDODGE_NV GL_LINEARLIGHT_NV GL_LOCATION_INDEX GL_LOG_HTTP_REGAL
     GL_LOG_INFO_REGAL GL_LUMINANCE4_EXT GL_LUMINANCE8_EXT GL_MAX_ALPHA_SGIS
     GL_MAX_EVAL_ORDER GL_MAX_GREEN_SGIS GL_MIN_ALPHA_SGIS GL_MIN_GREEN_SGIS
     GL_MODELVIEW0_ARB GL_MODELVIEW0_EXT GL_MODELVIEW1_ARB GL_MODELVIEW1_EXT
     GL_MODELVIEW2_ARB GL_MODELVIEW3_ARB GL_MODELVIEW4_ARB GL_MODELVIEW5_ARB
     GL_MODELVIEW6_ARB GL_MODELVIEW7_ARB GL_MODELVIEW8_ARB GL_MODELVIEW9_ARB
     GL_MVP_MATRIX_EXT GL_NEGATE_BIT_ATI GL_NEGATIVE_W_EXT GL_NEGATIVE_X_EXT
     GL_NEGATIVE_Y_EXT GL_NEGATIVE_Z_EXT GL_NOP_COMMAND_NV GL_NORMAL_BIT_PGI
     GL_NORMAL_MAP_ARB GL_NORMAL_MAP_EXT GL_NUM_EXTENSIONS GL_NUM_PASSES_ATI
     GL_NV_depth_clamp GL_NV_gpu_shader5 GL_OPERAND0_ALPHA GL_OPERAND1_ALPHA
     GL_OPERAND2_ALPHA GL_OUTPUT_FOG_EXT GL_OVR_multiview2 GL_PACK_ALIGNMENT
     GL_PACK_LSB_FIRST GL_PACK_SKIP_ROWS GL_PATCH_VERTICES GL_PERCENTAGE_AMD
     GL_PGI_misc_hints GL_PHONG_HINT_WIN GL_PIXEL_COUNT_NV GL_PIXEL_MODE_BIT
     GL_PLUS_DARKER_NV GL_POINT_SIZE_MAX GL_POINT_SIZE_MIN GL_POLYGON_SMOOTH
     GL_PROGRAM_OUTPUT GL_R11F_G11F_B10F GL_READ_WRITE_ARB GL_REFLECTION_MAP
     GL_RELEASED_APPLE GL_RESCALE_NORMAL GL_RETAINED_APPLE GL_RGBA_DXT5_S3TC
     GL_SAMPLER_1D_ARB GL_SAMPLER_2D_ARB GL_SAMPLER_3D_ARB GL_SAMPLER_BUFFER
     GL_SAMPLES_PASSED GL_SAMPLE_BUFFERS GL_SAMPLE_MASK_NV GL_SAMPLE_SHADING
     GL_SGIS_texture4D GL_SGIX_framezoom GL_SGIX_interlace GL_SHARED_EDGE_NV
     GL_SIGNED_HILO_NV GL_SIGNED_RGB8_NV GL_SIGNED_RGBA_NV GL_SLUMINANCE_EXT
     GL_SOURCE3_RGB_NV GL_SPOT_DIRECTION GL_SRGB_ALPHA_EXT GL_STACK_OVERFLOW
     GL_STENCIL_BUFFER GL_STENCIL_INDEX1 GL_STENCIL_INDEX4 GL_STENCIL_INDEX8
     GL_SUN_mesh_array GL_SYNC_CONDITION GL_TEXTURE_3D_EXT GL_TEXTURE_BORDER
     GL_TEXTURE_BUFFER GL_TEXTURE_GATHER GL_TEXTURE_HEIGHT GL_TEXTURE_MATRIX
     GL_TEXTURE_SHADOW GL_TEXTURE_TARGET GL_TEXTURE_WRAP_R GL_TEXTURE_WRAP_S
     GL_TEXTURE_WRAP_T GL_TRANSLATE_X_NV GL_TRANSLATE_Y_NV GL_TRIANGLE_STRIP
     GL_UNIFORM_BUFFER GL_UNIFORM_OFFSET GL_UNSIGNED_SHORT GL_VERTEX_TEXTURE
     GL_VOLATILE_APPLE GL_WRITE_ONLY_ARB GL_YCBYCR8_422_NV */
  /* Offset 12 gives the best switch position.  */
  switch (name[12]) {
  case '0':
    if (memEQ(name, "GL_MODELVIEW0_ARB", 17)) {
    /*                           ^           */
#ifdef GL_MODELVIEW0_ARB
      *iv_return = (IV)GL_MODELVIEW0_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MODELVIEW0_EXT", 17)) {
    /*                           ^           */
#ifdef GL_MODELVIEW0_EXT
      *iv_return = (IV)GL_MODELVIEW0_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '1':
    if (memEQ(name, "GL_FLOAT_RGB16_NV", 17)) {
    /*                           ^           */
#ifdef GL_FLOAT_RGB16_NV
      *iv_return = (IV)GL_FLOAT_RGB16_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MODELVIEW1_ARB", 17)) {
    /*                           ^           */
#ifdef GL_MODELVIEW1_ARB
      *iv_return = (IV)GL_MODELVIEW1_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MODELVIEW1_EXT", 17)) {
    /*                           ^           */
#ifdef GL_MODELVIEW1_EXT
      *iv_return = (IV)GL_MODELVIEW1_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '2':
    if (memEQ(name, "GL_FLOAT_MAT2_ARB", 17)) {
    /*                           ^           */
#ifdef GL_FLOAT_MAT2_ARB
      *iv_return = (IV)GL_FLOAT_MAT2_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FLOAT_VEC2_ARB", 17)) {
    /*                           ^           */
#ifdef GL_FLOAT_VEC2_ARB
      *iv_return = (IV)GL_FLOAT_VEC2_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INT64_VEC2_ARB", 17)) {
    /*                           ^           */
#ifdef GL_INT64_VEC2_ARB
      *iv_return = (IV)GL_INT64_VEC2_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MODELVIEW2_ARB", 17)) {
    /*                           ^           */
#ifdef GL_MODELVIEW2_ARB
      *iv_return = (IV)GL_MODELVIEW2_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_YCBYCR8_422_NV", 17)) {
    /*                           ^           */
#ifdef GL_YCBYCR8_422_NV
      *iv_return = (IV)GL_YCBYCR8_422_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '3':
    if (memEQ(name, "GL_FLOAT_MAT3_ARB", 17)) {
    /*                           ^           */
#ifdef GL_FLOAT_MAT3_ARB
      *iv_return = (IV)GL_FLOAT_MAT3_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FLOAT_RGB32_NV", 17)) {
    /*                           ^           */
#ifdef GL_FLOAT_RGB32_NV
      *iv_return = (IV)GL_FLOAT_RGB32_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FLOAT_VEC3_ARB", 17)) {
    /*                           ^           */
#ifdef GL_FLOAT_VEC3_ARB
      *iv_return = (IV)GL_FLOAT_VEC3_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INT64_VEC3_ARB", 17)) {
    /*                           ^           */
#ifdef GL_INT64_VEC3_ARB
      *iv_return = (IV)GL_INT64_VEC3_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MODELVIEW3_ARB", 17)) {
    /*                           ^           */
#ifdef GL_MODELVIEW3_ARB
      *iv_return = (IV)GL_MODELVIEW3_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '4':
    if (memEQ(name, "GL_FLOAT_MAT4_ARB", 17)) {
    /*                           ^           */
#ifdef GL_FLOAT_MAT4_ARB
      *iv_return = (IV)GL_FLOAT_MAT4_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FLOAT_VEC4_ARB", 17)) {
    /*                           ^           */
#ifdef GL_FLOAT_VEC4_ARB
      *iv_return = (IV)GL_FLOAT_VEC4_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INT64_VEC4_ARB", 17)) {
    /*                           ^           */
#ifdef GL_INT64_VEC4_ARB
      *iv_return = (IV)GL_INT64_VEC4_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INTENSITY4_EXT", 17)) {
    /*                           ^           */
#ifdef GL_INTENSITY4_EXT
      *iv_return = (IV)GL_INTENSITY4_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LUMINANCE4_EXT", 17)) {
    /*                           ^           */
#ifdef GL_LUMINANCE4_EXT
      *iv_return = (IV)GL_LUMINANCE4_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MODELVIEW4_ARB", 17)) {
    /*                           ^           */
#ifdef GL_MODELVIEW4_ARB
      *iv_return = (IV)GL_MODELVIEW4_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '5':
    if (memEQ(name, "GL_MODELVIEW5_ARB", 17)) {
    /*                           ^           */
#ifdef GL_MODELVIEW5_ARB
      *iv_return = (IV)GL_MODELVIEW5_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '6':
    if (memEQ(name, "GL_MODELVIEW6_ARB", 17)) {
    /*                           ^           */
#ifdef GL_MODELVIEW6_ARB
      *iv_return = (IV)GL_MODELVIEW6_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '7':
    if (memEQ(name, "GL_MODELVIEW7_ARB", 17)) {
    /*                           ^           */
#ifdef GL_MODELVIEW7_ARB
      *iv_return = (IV)GL_MODELVIEW7_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '8':
    if (memEQ(name, "GL_INTENSITY8_EXT", 17)) {
    /*                           ^           */
#ifdef GL_INTENSITY8_EXT
      *iv_return = (IV)GL_INTENSITY8_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LUMINANCE8_EXT", 17)) {
    /*                           ^           */
#ifdef GL_LUMINANCE8_EXT
      *iv_return = (IV)GL_LUMINANCE8_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MODELVIEW8_ARB", 17)) {
    /*                           ^           */
#ifdef GL_MODELVIEW8_ARB
      *iv_return = (IV)GL_MODELVIEW8_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '9':
    if (memEQ(name, "GL_MODELVIEW9_ARB", 17)) {
    /*                           ^           */
#ifdef GL_MODELVIEW9_ARB
      *iv_return = (IV)GL_MODELVIEW9_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'A':
    if (memEQ(name, "GL_BLEND_EQUATION", 17)) {
    /*                           ^           */
#ifdef GL_BLEND_EQUATION
      *iv_return = (IV)GL_BLEND_EQUATION;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CLIP_DISTANCE0", 17)) {
    /*                           ^           */
#ifdef GL_CLIP_DISTANCE0
      *iv_return = (IV)GL_CLIP_DISTANCE0;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CLIP_DISTANCE1", 17)) {
    /*                           ^           */
#ifdef GL_CLIP_DISTANCE1
      *iv_return = (IV)GL_CLIP_DISTANCE1;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CLIP_DISTANCE2", 17)) {
    /*                           ^           */
#ifdef GL_CLIP_DISTANCE2
      *iv_return = (IV)GL_CLIP_DISTANCE2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CLIP_DISTANCE3", 17)) {
    /*                           ^           */
#ifdef GL_CLIP_DISTANCE3
      *iv_return = (IV)GL_CLIP_DISTANCE3;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CLIP_DISTANCE4", 17)) {
    /*                           ^           */
#ifdef GL_CLIP_DISTANCE4
      *iv_return = (IV)GL_CLIP_DISTANCE4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CLIP_DISTANCE5", 17)) {
    /*                           ^           */
#ifdef GL_CLIP_DISTANCE5
      *iv_return = (IV)GL_CLIP_DISTANCE5;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CONSTANT_ALPHA", 17)) {
    /*                           ^           */
#ifdef GL_CONSTANT_ALPHA
      *iv_return = (IV)GL_CONSTANT_ALPHA;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_IMAGE_1D_ARRAY", 17)) {
    /*                           ^           */
#ifdef GL_IMAGE_1D_ARRAY
      *iv_return = (IV)GL_IMAGE_1D_ARRAY;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_IMAGE_2D_ARRAY", 17)) {
    /*                           ^           */
#ifdef GL_IMAGE_2D_ARRAY
      *iv_return = (IV)GL_IMAGE_2D_ARRAY;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OPERAND0_ALPHA", 17)) {
    /*                           ^           */
#ifdef GL_OPERAND0_ALPHA
      *iv_return = (IV)GL_OPERAND0_ALPHA;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OPERAND1_ALPHA", 17)) {
    /*                           ^           */
#ifdef GL_OPERAND1_ALPHA
      *iv_return = (IV)GL_OPERAND1_ALPHA;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OPERAND2_ALPHA", 17)) {
    /*                           ^           */
#ifdef GL_OPERAND2_ALPHA
      *iv_return = (IV)GL_OPERAND2_ALPHA;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RELEASED_APPLE", 17)) {
    /*                           ^           */
#ifdef GL_RELEASED_APPLE
      *iv_return = (IV)GL_RELEASED_APPLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RETAINED_APPLE", 17)) {
    /*                           ^           */
#ifdef GL_RETAINED_APPLE
      *iv_return = (IV)GL_RETAINED_APPLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLES_PASSED", 17)) {
    /*                           ^           */
#ifdef GL_SAMPLES_PASSED
      *iv_return = (IV)GL_SAMPLES_PASSED;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLE_SHADING", 17)) {
    /*                           ^           */
#ifdef GL_SAMPLE_SHADING
      *iv_return = (IV)GL_SAMPLE_SHADING;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SRGB_ALPHA_EXT", 17)) {
    /*                           ^           */
#ifdef GL_SRGB_ALPHA_EXT
      *iv_return = (IV)GL_SRGB_ALPHA_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_GATHER", 17)) {
    /*                           ^           */
#ifdef GL_TEXTURE_GATHER
      *iv_return = (IV)GL_TEXTURE_GATHER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_MATRIX", 17)) {
    /*                           ^           */
#ifdef GL_TEXTURE_MATRIX
      *iv_return = (IV)GL_TEXTURE_MATRIX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_TARGET", 17)) {
    /*                           ^           */
#ifdef GL_TEXTURE_TARGET
      *iv_return = (IV)GL_TEXTURE_TARGET;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VOLATILE_APPLE", 17)) {
    /*                           ^           */
#ifdef GL_VOLATILE_APPLE
      *iv_return = (IV)GL_VOLATILE_APPLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'B':
    if (memEQ(name, "GL_SIGNED_RGB8_NV", 17)) {
    /*                           ^           */
#ifdef GL_SIGNED_RGB8_NV
      *iv_return = (IV)GL_SIGNED_RGB8_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SIGNED_RGBA_NV", 17)) {
    /*                           ^           */
#ifdef GL_SIGNED_RGBA_NV
      *iv_return = (IV)GL_SIGNED_RGBA_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'C':
    if (memEQ(name, "GL_CONSTANT_COLOR", 17)) {
    /*                           ^           */
#ifdef GL_CONSTANT_COLOR
      *iv_return = (IV)GL_CONSTANT_COLOR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DOT_PRODUCT_NV", 17)) {
    /*                           ^           */
#ifdef GL_DOT_PRODUCT_NV
      *iv_return = (IV)GL_DOT_PRODUCT_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SPOT_DIRECTION", 17)) {
    /*                           ^           */
#ifdef GL_SPOT_DIRECTION
      *iv_return = (IV)GL_SPOT_DIRECTION;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'D':
    if (memEQ(name, "GL_ADD_SIGNED_ARB", 17)) {
    /*                           ^           */
#ifdef GL_ADD_SIGNED_ARB
      *iv_return = (IV)GL_ADD_SIGNED_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ADD_SIGNED_EXT", 17)) {
    /*                           ^           */
#ifdef GL_ADD_SIGNED_EXT
      *iv_return = (IV)GL_ADD_SIGNED_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COMPRESSED_RED", 17)) {
    /*                           ^           */
#ifdef GL_COMPRESSED_RED
      *iv_return = (IV)GL_COMPRESSED_RED;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COMPRESSED_RGB", 17)) {
    /*                           ^           */
#ifdef GL_COMPRESSED_RGB
      *iv_return = (IV)GL_COMPRESSED_RGB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FRAGMENT_DEPTH", 17)) {
    /*                           ^           */
#ifdef GL_FRAGMENT_DEPTH
      *iv_return = (IV)GL_FRAGMENT_DEPTH;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLER_1D_ARB", 17)) {
    /*                           ^           */
#ifdef GL_SAMPLER_1D_ARB
      *iv_return = (IV)GL_SAMPLER_1D_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLER_2D_ARB", 17)) {
    /*                           ^           */
#ifdef GL_SAMPLER_2D_ARB
      *iv_return = (IV)GL_SAMPLER_2D_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLER_3D_ARB", 17)) {
    /*                           ^           */
#ifdef GL_SAMPLER_3D_ARB
      *iv_return = (IV)GL_SAMPLER_3D_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_3D_EXT", 17)) {
    /*                           ^           */
#ifdef GL_TEXTURE_3D_EXT
      *iv_return = (IV)GL_TEXTURE_3D_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'E':
    if (memEQ(name, "GL_COLORDODGE_KHR", 17)) {
    /*                           ^           */
#ifdef GL_COLORDODGE_KHR
      *iv_return = (IV)GL_COLORDODGE_KHR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_MATERIAL", 17)) {
    /*                           ^           */
#ifdef GL_COLOR_MATERIAL
      *iv_return = (IV)GL_COLOR_MATERIAL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DIFFERENCE_KHR", 17)) {
    /*                           ^           */
#ifdef GL_DIFFERENCE_KHR
      *iv_return = (IV)GL_DIFFERENCE_KHR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FIELD_LOWER_NV", 17)) {
    /*                           ^           */
#ifdef GL_FIELD_LOWER_NV
      *iv_return = (IV)GL_FIELD_LOWER_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FIELD_UPPER_NV", 17)) {
    /*                           ^           */
#ifdef GL_FIELD_UPPER_NV
      *iv_return = (IV)GL_FIELD_UPPER_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FULL_RANGE_EXT", 17)) {
    /*                           ^           */
#ifdef GL_FULL_RANGE_EXT
      *iv_return = (IV)GL_FULL_RANGE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_IMAGE_CUBE_EXT", 17)) {
    /*                           ^           */
#ifdef GL_IMAGE_CUBE_EXT
      *iv_return = (IV)GL_IMAGE_CUBE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INT_SAMPLER_1D", 17)) {
    /*                           ^           */
#ifdef GL_INT_SAMPLER_1D
      *iv_return = (IV)GL_INT_SAMPLER_1D;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INT_SAMPLER_2D", 17)) {
    /*                           ^           */
#ifdef GL_INT_SAMPLER_2D
      *iv_return = (IV)GL_INT_SAMPLER_2D;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INT_SAMPLER_3D", 17)) {
    /*                           ^           */
#ifdef GL_INT_SAMPLER_3D
      *iv_return = (IV)GL_INT_SAMPLER_3D;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PERCENTAGE_AMD", 17)) {
    /*                           ^           */
#ifdef GL_PERCENTAGE_AMD
      *iv_return = (IV)GL_PERCENTAGE_AMD;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PIXEL_MODE_BIT", 17)) {
    /*                           ^           */
#ifdef GL_PIXEL_MODE_BIT
      *iv_return = (IV)GL_PIXEL_MODE_BIT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PLUS_DARKER_NV", 17)) {
    /*                           ^           */
#ifdef GL_PLUS_DARKER_NV
      *iv_return = (IV)GL_PLUS_DARKER_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_POINT_SIZE_MAX", 17)) {
    /*                           ^           */
#ifdef GL_POINT_SIZE_MAX
      *iv_return = (IV)GL_POINT_SIZE_MAX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_POINT_SIZE_MIN", 17)) {
    /*                           ^           */
#ifdef GL_POINT_SIZE_MIN
      *iv_return = (IV)GL_POINT_SIZE_MIN;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_READ_WRITE_ARB", 17)) {
    /*                           ^           */
#ifdef GL_READ_WRITE_ARB
      *iv_return = (IV)GL_READ_WRITE_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SLUMINANCE_EXT", 17)) {
    /*                           ^           */
#ifdef GL_SLUMINANCE_EXT
      *iv_return = (IV)GL_SLUMINANCE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_HEIGHT", 17)) {
    /*                           ^           */
#ifdef GL_TEXTURE_HEIGHT
      *iv_return = (IV)GL_TEXTURE_HEIGHT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'F':
    if (memEQ(name, "GL_PACK_LSB_FIRST", 17)) {
    /*                           ^           */
#ifdef GL_PACK_LSB_FIRST
      *iv_return = (IV)GL_PACK_LSB_FIRST;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLE_BUFFERS", 17)) {
    /*                           ^           */
#ifdef GL_SAMPLE_BUFFERS
      *iv_return = (IV)GL_SAMPLE_BUFFERS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNIFORM_OFFSET", 17)) {
    /*                           ^           */
#ifdef GL_UNIFORM_OFFSET
      *iv_return = (IV)GL_UNIFORM_OFFSET;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'G':
    if (memEQ(name, "GL_LINEARDODGE_NV", 17)) {
    /*                           ^           */
#ifdef GL_LINEARDODGE_NV
      *iv_return = (IV)GL_LINEARDODGE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OUTPUT_FOG_EXT", 17)) {
    /*                           ^           */
#ifdef GL_OUTPUT_FOG_EXT
      *iv_return = (IV)GL_OUTPUT_FOG_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SHARED_EDGE_NV", 17)) {
    /*                           ^           */
#ifdef GL_SHARED_EDGE_NV
      *iv_return = (IV)GL_SHARED_EDGE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SOURCE3_RGB_NV", 17)) {
    /*                           ^           */
#ifdef GL_SOURCE3_RGB_NV
      *iv_return = (IV)GL_SOURCE3_RGB_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'H':
    if (memEQ(name, "GL_COMPUTE_SHADER", 17)) {
    /*                           ^           */
#ifdef GL_COMPUTE_SHADER
      *iv_return = (IV)GL_COMPUTE_SHADER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LINEARLIGHT_NV", 17)) {
    /*                           ^           */
#ifdef GL_LINEARLIGHT_NV
      *iv_return = (IV)GL_LINEARLIGHT_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_SHADOW", 17)) {
    /*                           ^           */
#ifdef GL_TEXTURE_SHADOW
      *iv_return = (IV)GL_TEXTURE_SHADOW;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'I':
    if (memEQ(name, "GL_COLOR_LOGIC_OP", 17)) {
    /*                           ^           */
#ifdef GL_COLOR_LOGIC_OP
      *iv_return = (IV)GL_COLOR_LOGIC_OP;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FOG_COORDINATE", 17)) {
    /*                           ^           */
#ifdef GL_FOG_COORDINATE
      *iv_return = (IV)GL_FOG_COORDINATE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INDEX_LOGIC_OP", 17)) {
    /*                           ^           */
#ifdef GL_INDEX_LOGIC_OP
      *iv_return = (IV)GL_INDEX_LOGIC_OP;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LOCATION_INDEX", 17)) {
    /*                           ^           */
#ifdef GL_LOCATION_INDEX
      *iv_return = (IV)GL_LOCATION_INDEX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SYNC_CONDITION", 17)) {
    /*                           ^           */
#ifdef GL_SYNC_CONDITION
      *iv_return = (IV)GL_SYNC_CONDITION;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'L':
    if (memEQ(name, "GL_CONVEX_HULL_NV", 17)) {
    /*                           ^           */
#ifdef GL_CONVEX_HULL_NV
      *iv_return = (IV)GL_CONVEX_HULL_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FRACTIONAL_ODD", 17)) {
    /*                           ^           */
#ifdef GL_FRACTIONAL_ODD
      *iv_return = (IV)GL_FRACTIONAL_ODD;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SIGNED_HILO_NV", 17)) {
    /*                           ^           */
#ifdef GL_SIGNED_HILO_NV
      *iv_return = (IV)GL_SIGNED_HILO_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'M':
    if (memEQ(name, "GL_DEPTH_CLAMP_NV", 17)) {
    /*                           ^           */
#ifdef GL_DEPTH_CLAMP_NV
      *iv_return = (IV)GL_DEPTH_CLAMP_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_POLYGON_SMOOTH", 17)) {
    /*                           ^           */
#ifdef GL_POLYGON_SMOOTH
      *iv_return = (IV)GL_POLYGON_SMOOTH;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'N':
    if (memEQ(name, "GL_BUFFER_BINDING", 17)) {
    /*                           ^           */
#ifdef GL_BUFFER_BINDING
      *iv_return = (IV)GL_BUFFER_BINDING;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FACTOR_MIN_AMD", 17)) {
    /*                           ^           */
#ifdef GL_FACTOR_MIN_AMD
      *iv_return = (IV)GL_FACTOR_MIN_AMD;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NOP_COMMAND_NV", 17)) {
    /*                           ^           */
#ifdef GL_NOP_COMMAND_NV
      *iv_return = (IV)GL_NOP_COMMAND_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PACK_ALIGNMENT", 17)) {
    /*                           ^           */
#ifdef GL_PACK_ALIGNMENT
      *iv_return = (IV)GL_PACK_ALIGNMENT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PIXEL_COUNT_NV", 17)) {
    /*                           ^           */
#ifdef GL_PIXEL_COUNT_NV
      *iv_return = (IV)GL_PIXEL_COUNT_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_REFLECTION_MAP", 17)) {
    /*                           ^           */
#ifdef GL_REFLECTION_MAP
      *iv_return = (IV)GL_REFLECTION_MAP;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STENCIL_INDEX1", 17)) {
    /*                           ^           */
#ifdef GL_STENCIL_INDEX1
      *iv_return = (IV)GL_STENCIL_INDEX1;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STENCIL_INDEX4", 17)) {
    /*                           ^           */
#ifdef GL_STENCIL_INDEX4
      *iv_return = (IV)GL_STENCIL_INDEX4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STENCIL_INDEX8", 17)) {
    /*                           ^           */
#ifdef GL_STENCIL_INDEX8
      *iv_return = (IV)GL_STENCIL_INDEX8;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'O':
    if (memEQ(name, "GL_ACTIVE_PROGRAM", 17)) {
    /*                           ^           */
#ifdef GL_ACTIVE_PROGRAM
      *iv_return = (IV)GL_ACTIVE_PROGRAM;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_ENCODING", 17)) {
    /*                           ^           */
#ifdef GL_COLOR_ENCODING
      *iv_return = (IV)GL_COLOR_ENCODING;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CONVOLUTION_1D", 17)) {
    /*                           ^           */
#ifdef GL_CONVOLUTION_1D
      *iv_return = (IV)GL_CONVOLUTION_1D;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CONVOLUTION_2D", 17)) {
    /*                           ^           */
#ifdef GL_CONVOLUTION_2D
      *iv_return = (IV)GL_CONVOLUTION_2D;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CURRENT_NORMAL", 17)) {
    /*                           ^           */
#ifdef GL_CURRENT_NORMAL
      *iv_return = (IV)GL_CURRENT_NORMAL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_EVAL_ORDER", 17)) {
    /*                           ^           */
#ifdef GL_MAX_EVAL_ORDER
      *iv_return = (IV)GL_MAX_EVAL_ORDER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RESCALE_NORMAL", 17)) {
    /*                           ^           */
#ifdef GL_RESCALE_NORMAL
      *iv_return = (IV)GL_RESCALE_NORMAL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_BORDER", 17)) {
    /*                           ^           */
#ifdef GL_TEXTURE_BORDER
      *iv_return = (IV)GL_TEXTURE_BORDER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'P':
    if (memEQ(name, "GL_CAVEAT_SUPPORT", 17)) {
    /*                           ^           */
#ifdef GL_CAVEAT_SUPPORT
      *iv_return = (IV)GL_CAVEAT_SUPPORT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NORMAL_MAP_ARB", 17)) {
    /*                           ^           */
#ifdef GL_NORMAL_MAP_ARB
      *iv_return = (IV)GL_NORMAL_MAP_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NORMAL_MAP_EXT", 17)) {
    /*                           ^           */
#ifdef GL_NORMAL_MAP_EXT
      *iv_return = (IV)GL_NORMAL_MAP_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'R':
    if (memEQ(name, "GL_LOG_HTTP_REGAL", 17)) {
    /*                           ^           */
#ifdef GL_LOG_HTTP_REGAL
      *iv_return = (IV)GL_LOG_HTTP_REGAL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LOG_INFO_REGAL", 17)) {
    /*                           ^           */
#ifdef GL_LOG_INFO_REGAL
      *iv_return = (IV)GL_LOG_INFO_REGAL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STACK_OVERFLOW", 17)) {
    /*                           ^           */
#ifdef GL_STACK_OVERFLOW
      *iv_return = (IV)GL_STACK_OVERFLOW;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_WRAP_R", 17)) {
    /*                           ^           */
#ifdef GL_TEXTURE_WRAP_R
      *iv_return = (IV)GL_TEXTURE_WRAP_R;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_WRAP_S", 17)) {
    /*                           ^           */
#ifdef GL_TEXTURE_WRAP_S
      *iv_return = (IV)GL_TEXTURE_WRAP_S;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_WRAP_T", 17)) {
    /*                           ^           */
#ifdef GL_TEXTURE_WRAP_T
      *iv_return = (IV)GL_TEXTURE_WRAP_T;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'S':
    if (memEQ(name, "GL_CONTINUOUS_AMD", 17)) {
    /*                           ^           */
#ifdef GL_CONTINUOUS_AMD
      *iv_return = (IV)GL_CONTINUOUS_AMD;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_GPU_ADDRESS_NV", 17)) {
    /*                           ^           */
#ifdef GL_GPU_ADDRESS_NV
      *iv_return = (IV)GL_GPU_ADDRESS_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NUM_EXTENSIONS", 17)) {
    /*                           ^           */
#ifdef GL_NUM_EXTENSIONS
      *iv_return = (IV)GL_NUM_EXTENSIONS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NUM_PASSES_ATI", 17)) {
    /*                           ^           */
#ifdef GL_NUM_PASSES_ATI
      *iv_return = (IV)GL_NUM_PASSES_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLE_MASK_NV", 17)) {
    /*                           ^           */
#ifdef GL_SAMPLE_MASK_NV
      *iv_return = (IV)GL_SAMPLE_MASK_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TRIANGLE_STRIP", 17)) {
    /*                           ^           */
#ifdef GL_TRIANGLE_STRIP
      *iv_return = (IV)GL_TRIANGLE_STRIP;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNSIGNED_SHORT", 17)) {
    /*                           ^           */
#ifdef GL_UNSIGNED_SHORT
      *iv_return = (IV)GL_UNSIGNED_SHORT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'T':
    if (memEQ(name, "GL_ALPHA_TEST_REF", 17)) {
    /*                           ^           */
#ifdef GL_ALPHA_TEST_REF
      *iv_return = (IV)GL_ALPHA_TEST_REF;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR3_BIT_PGI", 17)) {
    /*                           ^           */
#ifdef GL_COLOR3_BIT_PGI
      *iv_return = (IV)GL_COLOR3_BIT_PGI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR4_BIT_PGI", 17)) {
    /*                           ^           */
#ifdef GL_COLOR4_BIT_PGI
      *iv_return = (IV)GL_COLOR4_BIT_PGI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COMPILE_STATUS", 17)) {
    /*                           ^           */
#ifdef GL_COMPILE_STATUS
      *iv_return = (IV)GL_COMPILE_STATUS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EIGHTH_BIT_ATI", 17)) {
    /*                           ^           */
#ifdef GL_EIGHTH_BIT_ATI
      *iv_return = (IV)GL_EIGHTH_BIT_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_HALF_FLOAT_ARB", 17)) {
    /*                           ^           */
#ifdef GL_HALF_FLOAT_ARB
      *iv_return = (IV)GL_HALF_FLOAT_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NEGATE_BIT_ATI", 17)) {
    /*                           ^           */
#ifdef GL_NEGATE_BIT_ATI
      *iv_return = (IV)GL_NEGATE_BIT_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NORMAL_BIT_PGI", 17)) {
    /*                           ^           */
#ifdef GL_NORMAL_BIT_PGI
      *iv_return = (IV)GL_NORMAL_BIT_PGI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PATCH_VERTICES", 17)) {
    /*                           ^           */
#ifdef GL_PATCH_VERTICES
      *iv_return = (IV)GL_PATCH_VERTICES;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PHONG_HINT_WIN", 17)) {
    /*                           ^           */
#ifdef GL_PHONG_HINT_WIN
      *iv_return = (IV)GL_PHONG_HINT_WIN;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'U':
    if (memEQ(name, "GL_PROGRAM_OUTPUT", 17)) {
    /*                           ^           */
#ifdef GL_PROGRAM_OUTPUT
      *iv_return = (IV)GL_PROGRAM_OUTPUT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLER_BUFFER", 17)) {
    /*                           ^           */
#ifdef GL_SAMPLER_BUFFER
      *iv_return = (IV)GL_SAMPLER_BUFFER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STENCIL_BUFFER", 17)) {
    /*                           ^           */
#ifdef GL_STENCIL_BUFFER
      *iv_return = (IV)GL_STENCIL_BUFFER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_BUFFER", 17)) {
    /*                           ^           */
#ifdef GL_TEXTURE_BUFFER
      *iv_return = (IV)GL_TEXTURE_BUFFER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNIFORM_BUFFER", 17)) {
    /*                           ^           */
#ifdef GL_UNIFORM_BUFFER
      *iv_return = (IV)GL_UNIFORM_BUFFER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'W':
    if (memEQ(name, "GL_NEGATIVE_W_EXT", 17)) {
    /*                           ^           */
#ifdef GL_NEGATIVE_W_EXT
      *iv_return = (IV)GL_NEGATIVE_W_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'X':
    if (memEQ(name, "GL_ACTIVE_TEXTURE", 17)) {
    /*                           ^           */
#ifdef GL_ACTIVE_TEXTURE
      *iv_return = (IV)GL_ACTIVE_TEXTURE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FACTOR_MAX_AMD", 17)) {
    /*                           ^           */
#ifdef GL_FACTOR_MAX_AMD
      *iv_return = (IV)GL_FACTOR_MAX_AMD;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MVP_MATRIX_EXT", 17)) {
    /*                           ^           */
#ifdef GL_MVP_MATRIX_EXT
      *iv_return = (IV)GL_MVP_MATRIX_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NEGATIVE_X_EXT", 17)) {
    /*                           ^           */
#ifdef GL_NEGATIVE_X_EXT
      *iv_return = (IV)GL_NEGATIVE_X_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERTEX_TEXTURE", 17)) {
    /*                           ^           */
#ifdef GL_VERTEX_TEXTURE
      *iv_return = (IV)GL_VERTEX_TEXTURE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'Y':
    if (memEQ(name, "GL_FIXED_ONLY_ARB", 17)) {
    /*                           ^           */
#ifdef GL_FIXED_ONLY_ARB
      *iv_return = (IV)GL_FIXED_ONLY_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NEGATIVE_Y_EXT", 17)) {
    /*                           ^           */
#ifdef GL_NEGATIVE_Y_EXT
      *iv_return = (IV)GL_NEGATIVE_Y_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_WRITE_ONLY_ARB", 17)) {
    /*                           ^           */
#ifdef GL_WRITE_ONLY_ARB
      *iv_return = (IV)GL_WRITE_ONLY_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'Z':
    if (memEQ(name, "GL_NEGATIVE_Z_EXT", 17)) {
    /*                           ^           */
#ifdef GL_NEGATIVE_Z_EXT
      *iv_return = (IV)GL_NEGATIVE_Z_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '_':
    if (memEQ(name, "GL_ACCUM_RED_BITS", 17)) {
    /*                           ^           */
#ifdef GL_ACCUM_RED_BITS
      *iv_return = (IV)GL_ACCUM_RED_BITS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ALPHA_MAX_SGIX", 17)) {
    /*                           ^           */
#ifdef GL_ALPHA_MAX_SGIX
      *iv_return = (IV)GL_ALPHA_MAX_SGIX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ALPHA_MIN_SGIX", 17)) {
    /*                           ^           */
#ifdef GL_ALPHA_MIN_SGIX
      *iv_return = (IV)GL_ALPHA_MIN_SGIX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_multi_bind", 17)) {
    /*                           ^           */
#ifdef GL_ARB_multi_bind
      *iv_return = (IV)GL_ARB_multi_bind;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CULL_FACE_MODE", 17)) {
    /*                           ^           */
#ifdef GL_CULL_FACE_MODE
      *iv_return = (IV)GL_CULL_FACE_MODE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_index_func", 17)) {
    /*                           ^           */
#ifdef GL_EXT_index_func
      *iv_return = (IV)GL_EXT_index_func;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EYE_POINT_SGIS", 17)) {
    /*                           ^           */
#ifdef GL_EYE_POINT_SGIS
      *iv_return = (IV)GL_EYE_POINT_SGIS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FRONT_AND_BACK", 17)) {
    /*                           ^           */
#ifdef GL_FRONT_AND_BACK
      *iv_return = (IV)GL_FRONT_AND_BACK;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_HISTOGRAM_SINK", 17)) {
    /*                           ^           */
#ifdef GL_HISTOGRAM_SINK
      *iv_return = (IV)GL_HISTOGRAM_SINK;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INTERLACE_SGIX", 17)) {
    /*                           ^           */
#ifdef GL_INTERLACE_SGIX
      *iv_return = (IV)GL_INTERLACE_SGIX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INT_IMAGE_CUBE", 17)) {
    /*                           ^           */
#ifdef GL_INT_IMAGE_CUBE
      *iv_return = (IV)GL_INT_IMAGE_CUBE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_ALPHA_SGIS", 17)) {
    /*                           ^           */
#ifdef GL_MAX_ALPHA_SGIS
      *iv_return = (IV)GL_MAX_ALPHA_SGIS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_GREEN_SGIS", 17)) {
    /*                           ^           */
#ifdef GL_MAX_GREEN_SGIS
      *iv_return = (IV)GL_MAX_GREEN_SGIS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MIN_ALPHA_SGIS", 17)) {
    /*                           ^           */
#ifdef GL_MIN_ALPHA_SGIS
      *iv_return = (IV)GL_MIN_ALPHA_SGIS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MIN_GREEN_SGIS", 17)) {
    /*                           ^           */
#ifdef GL_MIN_GREEN_SGIS
      *iv_return = (IV)GL_MIN_GREEN_SGIS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PACK_SKIP_ROWS", 17)) {
    /*                           ^           */
#ifdef GL_PACK_SKIP_ROWS
      *iv_return = (IV)GL_PACK_SKIP_ROWS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_R11F_G11F_B10F", 17)) {
    /*                           ^           */
#ifdef GL_R11F_G11F_B10F
      *iv_return = (IV)GL_R11F_G11F_B10F;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGBA_DXT5_S3TC", 17)) {
    /*                           ^           */
#ifdef GL_RGBA_DXT5_S3TC
      *iv_return = (IV)GL_RGBA_DXT5_S3TC;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TRANSLATE_X_NV", 17)) {
    /*                           ^           */
#ifdef GL_TRANSLATE_X_NV
      *iv_return = (IV)GL_TRANSLATE_X_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TRANSLATE_Y_NV", 17)) {
    /*                           ^           */
#ifdef GL_TRANSLATE_Y_NV
      *iv_return = (IV)GL_TRANSLATE_Y_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'a':
    if (memEQ(name, "GLEW_OML_resample", 17)) {
    /*                           ^           */
#ifdef GLEW_OML_resample
      *iv_return = (IV)GLEW_OML_resample;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_gpu_shader5", 17)) {
    /*                           ^           */
#ifdef GL_NV_gpu_shader5
      *iv_return = (IV)GL_NV_gpu_shader5;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SUN_mesh_array", 17)) {
    /*                           ^           */
#ifdef GL_SUN_mesh_array
      *iv_return = (IV)GL_SUN_mesh_array;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'c':
    if (memEQ(name, "GL_NV_depth_clamp", 17)) {
    /*                           ^           */
#ifdef GL_NV_depth_clamp
      *iv_return = (IV)GL_NV_depth_clamp;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'e':
    if (memEQ(name, "GLEW_ARB_cl_event", 17)) {
    /*                           ^           */
#ifdef GLEW_ARB_cl_event
      *iv_return = (IV)GLEW_ARB_cl_event;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_KHR_no_error", 17)) {
    /*                           ^           */
#ifdef GLEW_KHR_no_error
      *iv_return = (IV)GLEW_KHR_no_error;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SGIX_framezoom", 17)) {
    /*                           ^           */
#ifdef GL_SGIX_framezoom
      *iv_return = (IV)GL_SGIX_framezoom;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'h':
    if (memEQ(name, "GL_AMD_gcn_shader", 17)) {
    /*                           ^           */
#ifdef GL_AMD_gcn_shader
      *iv_return = (IV)GL_AMD_gcn_shader;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PGI_misc_hints", 17)) {
    /*                           ^           */
#ifdef GL_PGI_misc_hints
      *iv_return = (IV)GL_PGI_misc_hints;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'i':
    if (memEQ(name, "GLEW_SGIX_clipmap", 17)) {
    /*                           ^           */
#ifdef GLEW_SGIX_clipmap
      *iv_return = (IV)GLEW_SGIX_clipmap;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_copy_image", 17)) {
    /*                           ^           */
#ifdef GL_ARB_copy_image
      *iv_return = (IV)GL_ARB_copy_image;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_422_pixels", 17)) {
    /*                           ^           */
#ifdef GL_EXT_422_pixels
      *iv_return = (IV)GL_EXT_422_pixels;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'n':
    if (memEQ(name, "GLEW_REGAL_enable", 17)) {
    /*                           ^           */
#ifdef GLEW_REGAL_enable
      *iv_return = (IV)GLEW_REGAL_enable;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'r':
    if (memEQ(name, "GL_ARB_texture_rg", 17)) {
    /*                           ^           */
#ifdef GL_ARB_texture_rg
      *iv_return = (IV)GL_ARB_texture_rg;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SGIX_interlace", 17)) {
    /*                           ^           */
#ifdef GL_SGIX_interlace
      *iv_return = (IV)GL_SGIX_interlace;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 's':
    if (memEQ(name, "GLEW_ARB_gl_spirv", 17)) {
    /*                           ^           */
#ifdef GLEW_ARB_gl_spirv
      *iv_return = (IV)GLEW_ARB_gl_spirv;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 't':
    if (memEQ(name, "GL_ARB_robustness", 17)) {
    /*                           ^           */
#ifdef GL_ARB_robustness
      *iv_return = (IV)GL_ARB_robustness;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_KHR_robustness", 17)) {
    /*                           ^           */
#ifdef GL_KHR_robustness
      *iv_return = (IV)GL_KHR_robustness;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'u':
    if (memEQ(name, "GLEW_3DFX_tbuffer", 17)) {
    /*                           ^           */
#ifdef GLEW_3DFX_tbuffer
      *iv_return = (IV)GLEW_3DFX_tbuffer;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SGIS_texture4D", 17)) {
    /*                           ^           */
#ifdef GL_SGIS_texture4D
      *iv_return = (IV)GL_SGIS_texture4D;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'v':
    if (memEQ(name, "GL_OVR_multiview2", 17)) {
    /*                           ^           */
#ifdef GL_OVR_multiview2
      *iv_return = (IV)GL_OVR_multiview2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'w':
    if (memEQ(name, "GL_ARB_window_pos", 17)) {
    /*                           ^           */
#ifdef GL_ARB_window_pos
      *iv_return = (IV)GL_ARB_window_pos;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'x':
    if (memEQ(name, "GL_EXT_subtexture", 17)) {
    /*                           ^           */
#ifdef GL_EXT_subtexture
      *iv_return = (IV)GL_EXT_subtexture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  }
  return PERL_constant_NOTFOUND;
}

static int
constant_18 (pTHX_ const char *name, IV *iv_return) {
  /* When generated this function returned values for the list of names given
     here.  However, subsequent manual editing may have added or removed some.
     GLEW_APPLE_rgb_422 GLEW_EXT_Cg_shader GLEW_EXT_fog_coord
     GLEW_EXT_histogram GLEW_EXT_texture3D GLEW_NV_copy_image
     GLEW_NV_evaluators GLEW_NV_half_float GLEW_OML_interlace
     GLEW_OML_subsample GLEW_OVR_multiview GLEW_SGIX_resample
     GLEW_VERSION_1_2_1 GLEW_VERSION_MAJOR GLEW_VERSION_MICRO
     GLEW_VERSION_MINOR GLEW_WIN_swap_hint GL_422_AVERAGE_EXT
     GL_ACCUM_BLUE_BITS GL_ACTIVE_UNIFORMS GL_ALL_ATTRIB_BITS
     GL_ALL_SHADER_BITS GL_ALPHA_TEST_FUNC GL_APPLE_row_bytes
     GL_APPLE_ycbcr_422 GL_ARB_copy_buffer GL_ARB_depth_clamp
     GL_ARB_gpu_shader5 GL_ARB_multisample GL_ARB_timer_query
     GL_ATTENUATION_EXT GL_BGR_INTEGER_EXT GL_BLEND_COLOR_EXT
     GL_BLEND_DST_ALPHA GL_BLEND_SRC_ALPHA GL_BOUNDING_BOX_NV
     GL_BUFFER_SIZE_ARB GL_BUFFER_VARIABLE GL_BUMP_ENVMAP_ATI
     GL_BUMP_TARGET_ATI GL_CLAMP_TO_BORDER GL_CLIP_DEPTH_MODE
     GL_COLOR_ARRAY_EXT GL_COLOR_TABLE_SGI GL_COLOR_WRITEMASK
     GL_COMBINE_RGB_ARB GL_COMBINE_RGB_EXT GL_COMPRESSED_RGBA
     GL_COMPRESSED_SRGB GL_COMPUTE_TEXTURE GL_CONSTANT_BORDER
     GL_CULL_VERTEX_EXT GL_CULL_VERTEX_IBM GL_CURRENT_PROGRAM
     GL_CURRENT_TIME_NV GL_DATA_BUFFER_AMD GL_DEPTH_COMPONENT
     GL_DEPTH_WRITEMASK GL_DOUBLE_MAT2_EXT GL_DOUBLE_MAT3_EXT
     GL_DOUBLE_MAT4_EXT GL_DOUBLE_VEC2_EXT GL_DOUBLE_VEC3_EXT
     GL_DOUBLE_VEC4_EXT GL_DSDT_MAG_VIB_NV GL_EDGE_FLAG_ARRAY
     GL_EMBOSS_LIGHT_NV GL_EMULATION_REGAL GL_EXT_blend_color
     GL_EXT_convolution GL_EXT_cull_vertex GL_EXT_debug_label
     GL_EXT_gpu_shader4 GL_EXT_multisample GL_EXT_texture_env
     GL_EXT_timer_query GL_FENCE_STATUS_NV GL_FLOAT16_VEC2_NV
     GL_FLOAT16_VEC3_NV GL_FLOAT16_VEC4_NV GL_FLOAT_RGBA16_NV
     GL_FLOAT_RGBA32_NV GL_FOG_COORD_ARRAY GL_FOG_OFFSET_SGIX
     GL_FRACTIONAL_EVEN GL_FRAGMENT_SHADER GL_FRAMEBUFFER_EXT
     GL_GENERATE_MIPMAP GL_GEOMETRY_SHADER GL_HISTOGRAM_WIDTH
     GL_IBM_cull_vertex GL_IBM_static_data GL_INDEX_ARRAY_EXT
     GL_INDEX_WRITEMASK GL_INFO_LOG_LENGTH GL_INTENSITY12_EXT
     GL_INTENSITY16_EXT GL_INTENSITY8I_EXT GL_INTENSITY_SNORM
     GL_INTERPOLATE_ARB GL_INTERPOLATE_EXT GL_KTX_BACK_REGION
     GL_LINES_ADJACENCY GL_LOG_DEBUG_REGAL GL_LOG_ERROR_REGAL
     GL_LUMINANCE12_EXT GL_LUMINANCE16_EXT GL_LUMINANCE8I_EXT
     GL_LUMINANCE_ALPHA GL_LUMINANCE_SNORM GL_MAX_CLIP_PLANES
     GL_MAX_IMAGE_UNITS GL_MAX_NAME_LENGTH GL_MAX_SAMPLES_EXT
     GL_MAX_SUBROUTINES GL_MESA_window_pos GL_MINMAX_SINK_EXT
     GL_MIRRORED_REPEAT GL_MITER_REVERT_NV GL_MODELVIEW10_ARB
     GL_MODELVIEW11_ARB GL_MODELVIEW12_ARB GL_MODELVIEW13_ARB
     GL_MODELVIEW14_ARB GL_MODELVIEW15_ARB GL_MODELVIEW16_ARB
     GL_MODELVIEW17_ARB GL_MODELVIEW18_ARB GL_MODELVIEW19_ARB
     GL_MODELVIEW20_ARB GL_MODELVIEW21_ARB GL_MODELVIEW22_ARB
     GL_MODELVIEW23_ARB GL_MODELVIEW24_ARB GL_MODELVIEW25_ARB
     GL_MODELVIEW26_ARB GL_MODELVIEW27_ARB GL_MODELVIEW28_ARB
     GL_MODELVIEW29_ARB GL_MODELVIEW30_ARB GL_MODELVIEW31_ARB
     GL_MULTISAMPLES_NV GL_MULTISAMPLE_ARB GL_MULTISAMPLE_BIT
     GL_MULTISAMPLE_EXT GL_NV_blend_square GL_NV_command_list
     GL_NV_draw_texture GL_NV_float_buffer GL_NV_fog_distance
     GL_NV_gpu_program4 GL_NV_gpu_program5 GL_NV_point_sprite
     GL_OBJECT_TYPE_ARB GL_OES_read_format GL_OPERAND3_RGB_NV
     GL_PACK_ROW_LENGTH GL_PACK_SWAP_BYTES GL_PASS_THROUGH_NV
     GL_PLUS_CLAMPED_NV GL_POINT_SPRITE_NV GL_POLYGON_STIPPLE
     GL_PRESENT_TIME_NV GL_PRIMITIVE_ID_NV GL_PROXY_HISTOGRAM
     GL_PURGEABLE_APPLE GL_QUARTER_BIT_ATI GL_QUERY_RESULT_NV
     GL_RED_INTEGER_EXT GL_RESTART_PATH_NV GL_RGBA4_DXT5_S3TC
     GL_RGB_FLOAT16_ATI GL_RGB_FLOAT32_ATI GL_RGB_INTEGER_EXT
     GL_RGB_SIGNED_SGIX GL_ROUNDED_RECT_NV GL_SAMPLER_2D_RECT
     GL_SAMPLER_BINDING GL_SAMPLE_COUNT_NV GL_SAMPLE_COVERAGE
     GL_SAMPLE_MASK_EXT GL_SAMPLE_POSITION GL_SCALE_BY_TWO_NV
     GL_SGIX_fog_offset GL_SGI_color_table GL_SHADER_COMPILER
     GL_SIGNED_ALPHA_NV GL_SIGNED_HILO8_NV GL_SIGNED_RGBA8_NV
     GL_SKIP_DECODE_EXT GL_SLICE_ACCUM_SUN GL_SLUMINANCE8_EXT
     GL_SOURCE0_RGB_ARB GL_SOURCE0_RGB_EXT GL_SOURCE1_RGB_ARB
     GL_SOURCE1_RGB_EXT GL_SOURCE2_RGB_ARB GL_SOURCE2_RGB_EXT
     GL_SRGB_DECODE_ARB GL_STACK_UNDERFLOW GL_STATIC_COPY_ARB
     GL_STATIC_DRAW_ARB GL_STATIC_READ_ARB GL_STENCIL_INDEX16
     GL_STREAM_COPY_ARB GL_STREAM_DRAW_ARB GL_STREAM_READ_ARB
     GL_SUN_slice_accum GL_SWIZZLE_STQ_ATI GL_SWIZZLE_STR_ATI
     GL_T2F_C4F_N3F_V3F GL_T4F_C4F_N3F_V4F GL_TABLE_TOO_LARGE
     GL_TEXTURE_MAX_LOD GL_TEXTURE_MIN_LOD GL_TEXTURE_SAMPLES
     GL_TIMEOUT_EXPIRED GL_TIMEOUT_IGNORED GL_TIMESTAMP_ANGLE
     GL_TRACK_MATRIX_NV GL_TRANSLATE_2D_NV GL_TRANSLATE_3D_NV
     GL_UNCORRELATED_NV GL_UNDEFINED_APPLE GL_VALIDATE_STATUS
     GL_VERTEX4_BIT_PGI GL_VIDEO_BUFFER_NV GL_WARPS_PER_SM_NV
     GL_WRAP_BORDER_SUN GL_YCBCR_422_APPLE */
  /* Offset 13 gives the best switch position.  */
  switch (name[13]) {
  case '0':
    if (memEQ(name, "GL_MODELVIEW10_ARB", 18)) {
    /*                            ^           */
#ifdef GL_MODELVIEW10_ARB
      *iv_return = (IV)GL_MODELVIEW10_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MODELVIEW20_ARB", 18)) {
    /*                            ^           */
#ifdef GL_MODELVIEW20_ARB
      *iv_return = (IV)GL_MODELVIEW20_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MODELVIEW30_ARB", 18)) {
    /*                            ^           */
#ifdef GL_MODELVIEW30_ARB
      *iv_return = (IV)GL_MODELVIEW30_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '1':
    if (memEQ(name, "GLEW_VERSION_1_2_1", 18)) {
    /*                            ^           */
#ifdef GLEW_VERSION_1_2_1
      *iv_return = (IV)GLEW_VERSION_1_2_1;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FLOAT_RGBA16_NV", 18)) {
    /*                            ^           */
#ifdef GL_FLOAT_RGBA16_NV
      *iv_return = (IV)GL_FLOAT_RGBA16_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MODELVIEW11_ARB", 18)) {
    /*                            ^           */
#ifdef GL_MODELVIEW11_ARB
      *iv_return = (IV)GL_MODELVIEW11_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MODELVIEW21_ARB", 18)) {
    /*                            ^           */
#ifdef GL_MODELVIEW21_ARB
      *iv_return = (IV)GL_MODELVIEW21_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MODELVIEW31_ARB", 18)) {
    /*                            ^           */
#ifdef GL_MODELVIEW31_ARB
      *iv_return = (IV)GL_MODELVIEW31_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '2':
    if (memEQ(name, "GL_DOUBLE_MAT2_EXT", 18)) {
    /*                            ^           */
#ifdef GL_DOUBLE_MAT2_EXT
      *iv_return = (IV)GL_DOUBLE_MAT2_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DOUBLE_VEC2_EXT", 18)) {
    /*                            ^           */
#ifdef GL_DOUBLE_VEC2_EXT
      *iv_return = (IV)GL_DOUBLE_VEC2_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INTENSITY12_EXT", 18)) {
    /*                            ^           */
#ifdef GL_INTENSITY12_EXT
      *iv_return = (IV)GL_INTENSITY12_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LUMINANCE12_EXT", 18)) {
    /*                            ^           */
#ifdef GL_LUMINANCE12_EXT
      *iv_return = (IV)GL_LUMINANCE12_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MODELVIEW12_ARB", 18)) {
    /*                            ^           */
#ifdef GL_MODELVIEW12_ARB
      *iv_return = (IV)GL_MODELVIEW12_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MODELVIEW22_ARB", 18)) {
    /*                            ^           */
#ifdef GL_MODELVIEW22_ARB
      *iv_return = (IV)GL_MODELVIEW22_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGB_FLOAT32_ATI", 18)) {
    /*                            ^           */
#ifdef GL_RGB_FLOAT32_ATI
      *iv_return = (IV)GL_RGB_FLOAT32_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TRANSLATE_2D_NV", 18)) {
    /*                            ^           */
#ifdef GL_TRANSLATE_2D_NV
      *iv_return = (IV)GL_TRANSLATE_2D_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '3':
    if (memEQ(name, "GL_DOUBLE_MAT3_EXT", 18)) {
    /*                            ^           */
#ifdef GL_DOUBLE_MAT3_EXT
      *iv_return = (IV)GL_DOUBLE_MAT3_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DOUBLE_VEC3_EXT", 18)) {
    /*                            ^           */
#ifdef GL_DOUBLE_VEC3_EXT
      *iv_return = (IV)GL_DOUBLE_VEC3_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FLOAT_RGBA32_NV", 18)) {
    /*                            ^           */
#ifdef GL_FLOAT_RGBA32_NV
      *iv_return = (IV)GL_FLOAT_RGBA32_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MODELVIEW13_ARB", 18)) {
    /*                            ^           */
#ifdef GL_MODELVIEW13_ARB
      *iv_return = (IV)GL_MODELVIEW13_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MODELVIEW23_ARB", 18)) {
    /*                            ^           */
#ifdef GL_MODELVIEW23_ARB
      *iv_return = (IV)GL_MODELVIEW23_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TRANSLATE_3D_NV", 18)) {
    /*                            ^           */
#ifdef GL_TRANSLATE_3D_NV
      *iv_return = (IV)GL_TRANSLATE_3D_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '4':
    if (memEQ(name, "GL_DOUBLE_MAT4_EXT", 18)) {
    /*                            ^           */
#ifdef GL_DOUBLE_MAT4_EXT
      *iv_return = (IV)GL_DOUBLE_MAT4_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DOUBLE_VEC4_EXT", 18)) {
    /*                            ^           */
#ifdef GL_DOUBLE_VEC4_EXT
      *iv_return = (IV)GL_DOUBLE_VEC4_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MODELVIEW14_ARB", 18)) {
    /*                            ^           */
#ifdef GL_MODELVIEW14_ARB
      *iv_return = (IV)GL_MODELVIEW14_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MODELVIEW24_ARB", 18)) {
    /*                            ^           */
#ifdef GL_MODELVIEW24_ARB
      *iv_return = (IV)GL_MODELVIEW24_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '5':
    if (memEQ(name, "GL_MODELVIEW15_ARB", 18)) {
    /*                            ^           */
#ifdef GL_MODELVIEW15_ARB
      *iv_return = (IV)GL_MODELVIEW15_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MODELVIEW25_ARB", 18)) {
    /*                            ^           */
#ifdef GL_MODELVIEW25_ARB
      *iv_return = (IV)GL_MODELVIEW25_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '6':
    if (memEQ(name, "GL_INTENSITY16_EXT", 18)) {
    /*                            ^           */
#ifdef GL_INTENSITY16_EXT
      *iv_return = (IV)GL_INTENSITY16_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LUMINANCE16_EXT", 18)) {
    /*                            ^           */
#ifdef GL_LUMINANCE16_EXT
      *iv_return = (IV)GL_LUMINANCE16_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MODELVIEW16_ARB", 18)) {
    /*                            ^           */
#ifdef GL_MODELVIEW16_ARB
      *iv_return = (IV)GL_MODELVIEW16_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MODELVIEW26_ARB", 18)) {
    /*                            ^           */
#ifdef GL_MODELVIEW26_ARB
      *iv_return = (IV)GL_MODELVIEW26_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGB_FLOAT16_ATI", 18)) {
    /*                            ^           */
#ifdef GL_RGB_FLOAT16_ATI
      *iv_return = (IV)GL_RGB_FLOAT16_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '7':
    if (memEQ(name, "GL_MODELVIEW17_ARB", 18)) {
    /*                            ^           */
#ifdef GL_MODELVIEW17_ARB
      *iv_return = (IV)GL_MODELVIEW17_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MODELVIEW27_ARB", 18)) {
    /*                            ^           */
#ifdef GL_MODELVIEW27_ARB
      *iv_return = (IV)GL_MODELVIEW27_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '8':
    if (memEQ(name, "GL_MODELVIEW18_ARB", 18)) {
    /*                            ^           */
#ifdef GL_MODELVIEW18_ARB
      *iv_return = (IV)GL_MODELVIEW18_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MODELVIEW28_ARB", 18)) {
    /*                            ^           */
#ifdef GL_MODELVIEW28_ARB
      *iv_return = (IV)GL_MODELVIEW28_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SLUMINANCE8_EXT", 18)) {
    /*                            ^           */
#ifdef GL_SLUMINANCE8_EXT
      *iv_return = (IV)GL_SLUMINANCE8_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '9':
    if (memEQ(name, "GL_MODELVIEW19_ARB", 18)) {
    /*                            ^           */
#ifdef GL_MODELVIEW19_ARB
      *iv_return = (IV)GL_MODELVIEW19_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MODELVIEW29_ARB", 18)) {
    /*                            ^           */
#ifdef GL_MODELVIEW29_ARB
      *iv_return = (IV)GL_MODELVIEW29_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'A':
    if (memEQ(name, "GL_BLEND_DST_ALPHA", 18)) {
    /*                            ^           */
#ifdef GL_BLEND_DST_ALPHA
      *iv_return = (IV)GL_BLEND_DST_ALPHA;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_BLEND_SRC_ALPHA", 18)) {
    /*                            ^           */
#ifdef GL_BLEND_SRC_ALPHA
      *iv_return = (IV)GL_BLEND_SRC_ALPHA;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EDGE_FLAG_ARRAY", 18)) {
    /*                            ^           */
#ifdef GL_EDGE_FLAG_ARRAY
      *iv_return = (IV)GL_EDGE_FLAG_ARRAY;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FOG_COORD_ARRAY", 18)) {
    /*                            ^           */
#ifdef GL_FOG_COORD_ARRAY
      *iv_return = (IV)GL_FOG_COORD_ARRAY;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LUMINANCE_ALPHA", 18)) {
    /*                            ^           */
#ifdef GL_LUMINANCE_ALPHA
      *iv_return = (IV)GL_LUMINANCE_ALPHA;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PURGEABLE_APPLE", 18)) {
    /*                            ^           */
#ifdef GL_PURGEABLE_APPLE
      *iv_return = (IV)GL_PURGEABLE_APPLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SIGNED_RGBA8_NV", 18)) {
    /*                            ^           */
#ifdef GL_SIGNED_RGBA8_NV
      *iv_return = (IV)GL_SIGNED_RGBA8_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TIMESTAMP_ANGLE", 18)) {
    /*                            ^           */
#ifdef GL_TIMESTAMP_ANGLE
      *iv_return = (IV)GL_TIMESTAMP_ANGLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNDEFINED_APPLE", 18)) {
    /*                            ^           */
#ifdef GL_UNDEFINED_APPLE
      *iv_return = (IV)GL_UNDEFINED_APPLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_YCBCR_422_APPLE", 18)) {
    /*                            ^           */
#ifdef GL_YCBCR_422_APPLE
      *iv_return = (IV)GL_YCBCR_422_APPLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'B':
    if (memEQ(name, "GL_COMBINE_RGB_ARB", 18)) {
    /*                            ^           */
#ifdef GL_COMBINE_RGB_ARB
      *iv_return = (IV)GL_COMBINE_RGB_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COMBINE_RGB_EXT", 18)) {
    /*                            ^           */
#ifdef GL_COMBINE_RGB_EXT
      *iv_return = (IV)GL_COMBINE_RGB_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PACK_SWAP_BYTES", 18)) {
    /*                            ^           */
#ifdef GL_PACK_SWAP_BYTES
      *iv_return = (IV)GL_PACK_SWAP_BYTES;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SOURCE0_RGB_ARB", 18)) {
    /*                            ^           */
#ifdef GL_SOURCE0_RGB_ARB
      *iv_return = (IV)GL_SOURCE0_RGB_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SOURCE0_RGB_EXT", 18)) {
    /*                            ^           */
#ifdef GL_SOURCE0_RGB_EXT
      *iv_return = (IV)GL_SOURCE0_RGB_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SOURCE1_RGB_ARB", 18)) {
    /*                            ^           */
#ifdef GL_SOURCE1_RGB_ARB
      *iv_return = (IV)GL_SOURCE1_RGB_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SOURCE1_RGB_EXT", 18)) {
    /*                            ^           */
#ifdef GL_SOURCE1_RGB_EXT
      *iv_return = (IV)GL_SOURCE1_RGB_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SOURCE2_RGB_ARB", 18)) {
    /*                            ^           */
#ifdef GL_SOURCE2_RGB_ARB
      *iv_return = (IV)GL_SOURCE2_RGB_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SOURCE2_RGB_EXT", 18)) {
    /*                            ^           */
#ifdef GL_SOURCE2_RGB_EXT
      *iv_return = (IV)GL_SOURCE2_RGB_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'C':
    if (memEQ(name, "GL_FLOAT16_VEC2_NV", 18)) {
    /*                            ^           */
#ifdef GL_FLOAT16_VEC2_NV
      *iv_return = (IV)GL_FLOAT16_VEC2_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FLOAT16_VEC3_NV", 18)) {
    /*                            ^           */
#ifdef GL_FLOAT16_VEC3_NV
      *iv_return = (IV)GL_FLOAT16_VEC3_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FLOAT16_VEC4_NV", 18)) {
    /*                            ^           */
#ifdef GL_FLOAT16_VEC4_NV
      *iv_return = (IV)GL_FLOAT16_VEC4_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LINES_ADJACENCY", 18)) {
    /*                            ^           */
#ifdef GL_LINES_ADJACENCY
      *iv_return = (IV)GL_LINES_ADJACENCY;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ROUNDED_RECT_NV", 18)) {
    /*                            ^           */
#ifdef GL_ROUNDED_RECT_NV
      *iv_return = (IV)GL_ROUNDED_RECT_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'D':
    if (memEQ(name, "GL_STATIC_READ_ARB", 18)) {
    /*                            ^           */
#ifdef GL_STATIC_READ_ARB
      *iv_return = (IV)GL_STATIC_READ_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STENCIL_INDEX16", 18)) {
    /*                            ^           */
#ifdef GL_STENCIL_INDEX16
      *iv_return = (IV)GL_STENCIL_INDEX16;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STREAM_READ_ARB", 18)) {
    /*                            ^           */
#ifdef GL_STREAM_READ_ARB
      *iv_return = (IV)GL_STREAM_READ_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'E':
    if (memEQ(name, "GL_422_AVERAGE_EXT", 18)) {
    /*                            ^           */
#ifdef GL_422_AVERAGE_EXT
      *iv_return = (IV)GL_422_AVERAGE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_BUFFER_SIZE_ARB", 18)) {
    /*                            ^           */
#ifdef GL_BUFFER_SIZE_ARB
      *iv_return = (IV)GL_BUFFER_SIZE_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_TABLE_SGI", 18)) {
    /*                            ^           */
#ifdef GL_COLOR_TABLE_SGI
      *iv_return = (IV)GL_COLOR_TABLE_SGI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_WRITEMASK", 18)) {
    /*                            ^           */
#ifdef GL_COLOR_WRITEMASK
      *iv_return = (IV)GL_COLOR_WRITEMASK;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEPTH_WRITEMASK", 18)) {
    /*                            ^           */
#ifdef GL_DEPTH_WRITEMASK
      *iv_return = (IV)GL_DEPTH_WRITEMASK;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INDEX_WRITEMASK", 18)) {
    /*                            ^           */
#ifdef GL_INDEX_WRITEMASK
      *iv_return = (IV)GL_INDEX_WRITEMASK;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INFO_LOG_LENGTH", 18)) {
    /*                            ^           */
#ifdef GL_INFO_LOG_LENGTH
      *iv_return = (IV)GL_INFO_LOG_LENGTH;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INTERPOLATE_ARB", 18)) {
    /*                            ^           */
#ifdef GL_INTERPOLATE_ARB
      *iv_return = (IV)GL_INTERPOLATE_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INTERPOLATE_EXT", 18)) {
    /*                            ^           */
#ifdef GL_INTERPOLATE_EXT
      *iv_return = (IV)GL_INTERPOLATE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_KTX_BACK_REGION", 18)) {
    /*                            ^           */
#ifdef GL_KTX_BACK_REGION
      *iv_return = (IV)GL_KTX_BACK_REGION;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_NAME_LENGTH", 18)) {
    /*                            ^           */
#ifdef GL_MAX_NAME_LENGTH
      *iv_return = (IV)GL_MAX_NAME_LENGTH;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MIRRORED_REPEAT", 18)) {
    /*                            ^           */
#ifdef GL_MIRRORED_REPEAT
      *iv_return = (IV)GL_MIRRORED_REPEAT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MULTISAMPLES_NV", 18)) {
    /*                            ^           */
#ifdef GL_MULTISAMPLES_NV
      *iv_return = (IV)GL_MULTISAMPLES_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MULTISAMPLE_ARB", 18)) {
    /*                            ^           */
#ifdef GL_MULTISAMPLE_ARB
      *iv_return = (IV)GL_MULTISAMPLE_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MULTISAMPLE_BIT", 18)) {
    /*                            ^           */
#ifdef GL_MULTISAMPLE_BIT
      *iv_return = (IV)GL_MULTISAMPLE_BIT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MULTISAMPLE_EXT", 18)) {
    /*                            ^           */
#ifdef GL_MULTISAMPLE_EXT
      *iv_return = (IV)GL_MULTISAMPLE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OBJECT_TYPE_ARB", 18)) {
    /*                            ^           */
#ifdef GL_OBJECT_TYPE_ARB
      *iv_return = (IV)GL_OBJECT_TYPE_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PACK_ROW_LENGTH", 18)) {
    /*                            ^           */
#ifdef GL_PACK_ROW_LENGTH
      *iv_return = (IV)GL_PACK_ROW_LENGTH;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PLUS_CLAMPED_NV", 18)) {
    /*                            ^           */
#ifdef GL_PLUS_CLAMPED_NV
      *iv_return = (IV)GL_PLUS_CLAMPED_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLE_COVERAGE", 18)) {
    /*                            ^           */
#ifdef GL_SAMPLE_COVERAGE
      *iv_return = (IV)GL_SAMPLE_COVERAGE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SKIP_DECODE_EXT", 18)) {
    /*                            ^           */
#ifdef GL_SKIP_DECODE_EXT
      *iv_return = (IV)GL_SKIP_DECODE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SRGB_DECODE_ARB", 18)) {
    /*                            ^           */
#ifdef GL_SRGB_DECODE_ARB
      *iv_return = (IV)GL_SRGB_DECODE_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNCORRELATED_NV", 18)) {
    /*                            ^           */
#ifdef GL_UNCORRELATED_NV
      *iv_return = (IV)GL_UNCORRELATED_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VIDEO_BUFFER_NV", 18)) {
    /*                            ^           */
#ifdef GL_VIDEO_BUFFER_NV
      *iv_return = (IV)GL_VIDEO_BUFFER_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'F':
    if (memEQ(name, "GL_ACTIVE_UNIFORMS", 18)) {
    /*                            ^           */
#ifdef GL_ACTIVE_UNIFORMS
      *iv_return = (IV)GL_ACTIVE_UNIFORMS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_T2F_C4F_N3F_V3F", 18)) {
    /*                            ^           */
#ifdef GL_T2F_C4F_N3F_V3F
      *iv_return = (IV)GL_T2F_C4F_N3F_V3F;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_T4F_C4F_N3F_V4F", 18)) {
    /*                            ^           */
#ifdef GL_T4F_C4F_N3F_V4F
      *iv_return = (IV)GL_T4F_C4F_N3F_V4F;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'G':
    if (memEQ(name, "GL_OPERAND3_RGB_NV", 18)) {
    /*                            ^           */
#ifdef GL_OPERAND3_RGB_NV
      *iv_return = (IV)GL_OPERAND3_RGB_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PASS_THROUGH_NV", 18)) {
    /*                            ^           */
#ifdef GL_PASS_THROUGH_NV
      *iv_return = (IV)GL_PASS_THROUGH_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'H':
    if (memEQ(name, "GL_EMBOSS_LIGHT_NV", 18)) {
    /*                            ^           */
#ifdef GL_EMBOSS_LIGHT_NV
      *iv_return = (IV)GL_EMBOSS_LIGHT_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FRAGMENT_SHADER", 18)) {
    /*                            ^           */
#ifdef GL_FRAGMENT_SHADER
      *iv_return = (IV)GL_FRAGMENT_SHADER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_GEOMETRY_SHADER", 18)) {
    /*                            ^           */
#ifdef GL_GEOMETRY_SHADER
      *iv_return = (IV)GL_GEOMETRY_SHADER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SIGNED_ALPHA_NV", 18)) {
    /*                            ^           */
#ifdef GL_SIGNED_ALPHA_NV
      *iv_return = (IV)GL_SIGNED_ALPHA_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'I':
    if (memEQ(name, "GL_BUFFER_VARIABLE", 18)) {
    /*                            ^           */
#ifdef GL_BUFFER_VARIABLE
      *iv_return = (IV)GL_BUFFER_VARIABLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DSDT_MAG_VIB_NV", 18)) {
    /*                            ^           */
#ifdef GL_DSDT_MAG_VIB_NV
      *iv_return = (IV)GL_DSDT_MAG_VIB_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_GENERATE_MIPMAP", 18)) {
    /*                            ^           */
#ifdef GL_GENERATE_MIPMAP
      *iv_return = (IV)GL_GENERATE_MIPMAP;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INTENSITY8I_EXT", 18)) {
    /*                            ^           */
#ifdef GL_INTENSITY8I_EXT
      *iv_return = (IV)GL_INTENSITY8I_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LUMINANCE8I_EXT", 18)) {
    /*                            ^           */
#ifdef GL_LUMINANCE8I_EXT
      *iv_return = (IV)GL_LUMINANCE8I_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_POLYGON_STIPPLE", 18)) {
    /*                            ^           */
#ifdef GL_POLYGON_STIPPLE
      *iv_return = (IV)GL_POLYGON_STIPPLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PRIMITIVE_ID_NV", 18)) {
    /*                            ^           */
#ifdef GL_PRIMITIVE_ID_NV
      *iv_return = (IV)GL_PRIMITIVE_ID_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLE_POSITION", 18)) {
    /*                            ^           */
#ifdef GL_SAMPLE_POSITION
      *iv_return = (IV)GL_SAMPLE_POSITION;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TRACK_MATRIX_NV", 18)) {
    /*                            ^           */
#ifdef GL_TRACK_MATRIX_NV
      *iv_return = (IV)GL_TRACK_MATRIX_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'K':
    if (memEQ(name, "GL_MINMAX_SINK_EXT", 18)) {
    /*                            ^           */
#ifdef GL_MINMAX_SINK_EXT
      *iv_return = (IV)GL_MINMAX_SINK_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLE_MASK_EXT", 18)) {
    /*                            ^           */
#ifdef GL_SAMPLE_MASK_EXT
      *iv_return = (IV)GL_SAMPLE_MASK_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'L':
    if (memEQ(name, "GL_MAX_CLIP_PLANES", 18)) {
    /*                            ^           */
#ifdef GL_MAX_CLIP_PLANES
      *iv_return = (IV)GL_MAX_CLIP_PLANES;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_QUERY_RESULT_NV", 18)) {
    /*                            ^           */
#ifdef GL_QUERY_RESULT_NV
      *iv_return = (IV)GL_QUERY_RESULT_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TABLE_TOO_LARGE", 18)) {
    /*                            ^           */
#ifdef GL_TABLE_TOO_LARGE
      *iv_return = (IV)GL_TABLE_TOO_LARGE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'M':
    if (memEQ(name, "GLEW_VERSION_MAJOR", 18)) {
    /*                            ^           */
#ifdef GLEW_VERSION_MAJOR
      *iv_return = (IV)GLEW_VERSION_MAJOR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_VERSION_MICRO", 18)) {
    /*                            ^           */
#ifdef GLEW_VERSION_MICRO
      *iv_return = (IV)GLEW_VERSION_MICRO;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_VERSION_MINOR", 18)) {
    /*                            ^           */
#ifdef GLEW_VERSION_MINOR
      *iv_return = (IV)GLEW_VERSION_MINOR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CURRENT_TIME_NV", 18)) {
    /*                            ^           */
#ifdef GL_CURRENT_TIME_NV
      *iv_return = (IV)GL_CURRENT_TIME_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PRESENT_TIME_NV", 18)) {
    /*                            ^           */
#ifdef GL_PRESENT_TIME_NV
      *iv_return = (IV)GL_PRESENT_TIME_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SLICE_ACCUM_SUN", 18)) {
    /*                            ^           */
#ifdef GL_SLICE_ACCUM_SUN
      *iv_return = (IV)GL_SLICE_ACCUM_SUN;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_SAMPLES", 18)) {
    /*                            ^           */
#ifdef GL_TEXTURE_SAMPLES
      *iv_return = (IV)GL_TEXTURE_SAMPLES;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'N':
    if (memEQ(name, "GL_ATTENUATION_EXT", 18)) {
    /*                            ^           */
#ifdef GL_ATTENUATION_EXT
      *iv_return = (IV)GL_ATTENUATION_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLER_BINDING", 18)) {
    /*                            ^           */
#ifdef GL_SAMPLER_BINDING
      *iv_return = (IV)GL_SAMPLER_BINDING;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLE_COUNT_NV", 18)) {
    /*                            ^           */
#ifdef GL_SAMPLE_COUNT_NV
      *iv_return = (IV)GL_SAMPLE_COUNT_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_MIN_LOD", 18)) {
    /*                            ^           */
#ifdef GL_TEXTURE_MIN_LOD
      *iv_return = (IV)GL_TEXTURE_MIN_LOD;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TIMEOUT_IGNORED", 18)) {
    /*                            ^           */
#ifdef GL_TIMEOUT_IGNORED
      *iv_return = (IV)GL_TIMEOUT_IGNORED;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'O':
    if (memEQ(name, "GL_BOUNDING_BOX_NV", 18)) {
    /*                            ^           */
#ifdef GL_BOUNDING_BOX_NV
      *iv_return = (IV)GL_BOUNDING_BOX_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CLAMP_TO_BORDER", 18)) {
    /*                            ^           */
#ifdef GL_CLAMP_TO_BORDER
      *iv_return = (IV)GL_CLAMP_TO_BORDER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CONSTANT_BORDER", 18)) {
    /*                            ^           */
#ifdef GL_CONSTANT_BORDER
      *iv_return = (IV)GL_CONSTANT_BORDER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CURRENT_PROGRAM", 18)) {
    /*                            ^           */
#ifdef GL_CURRENT_PROGRAM
      *iv_return = (IV)GL_CURRENT_PROGRAM;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEPTH_COMPONENT", 18)) {
    /*                            ^           */
#ifdef GL_DEPTH_COMPONENT
      *iv_return = (IV)GL_DEPTH_COMPONENT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PROXY_HISTOGRAM", 18)) {
    /*                            ^           */
#ifdef GL_PROXY_HISTOGRAM
      *iv_return = (IV)GL_PROXY_HISTOGRAM;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SIGNED_HILO8_NV", 18)) {
    /*                            ^           */
#ifdef GL_SIGNED_HILO8_NV
      *iv_return = (IV)GL_SIGNED_HILO8_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'P':
    if (memEQ(name, "GL_BUMP_ENVMAP_ATI", 18)) {
    /*                            ^           */
#ifdef GL_BUMP_ENVMAP_ATI
      *iv_return = (IV)GL_BUMP_ENVMAP_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SHADER_COMPILER", 18)) {
    /*                            ^           */
#ifdef GL_SHADER_COMPILER
      *iv_return = (IV)GL_SHADER_COMPILER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TIMEOUT_EXPIRED", 18)) {
    /*                            ^           */
#ifdef GL_TIMEOUT_EXPIRED
      *iv_return = (IV)GL_TIMEOUT_EXPIRED;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'Q':
    if (memEQ(name, "GL_SWIZZLE_STQ_ATI", 18)) {
    /*                            ^           */
#ifdef GL_SWIZZLE_STQ_ATI
      *iv_return = (IV)GL_SWIZZLE_STQ_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'R':
    if (memEQ(name, "GL_BGR_INTEGER_EXT", 18)) {
    /*                            ^           */
#ifdef GL_BGR_INTEGER_EXT
      *iv_return = (IV)GL_BGR_INTEGER_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_BLEND_COLOR_EXT", 18)) {
    /*                            ^           */
#ifdef GL_BLEND_COLOR_EXT
      *iv_return = (IV)GL_BLEND_COLOR_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DATA_BUFFER_AMD", 18)) {
    /*                            ^           */
#ifdef GL_DATA_BUFFER_AMD
      *iv_return = (IV)GL_DATA_BUFFER_AMD;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EMULATION_REGAL", 18)) {
    /*                            ^           */
#ifdef GL_EMULATION_REGAL
      *iv_return = (IV)GL_EMULATION_REGAL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FRAMEBUFFER_EXT", 18)) {
    /*                            ^           */
#ifdef GL_FRAMEBUFFER_EXT
      *iv_return = (IV)GL_FRAMEBUFFER_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LOG_DEBUG_REGAL", 18)) {
    /*                            ^           */
#ifdef GL_LOG_DEBUG_REGAL
      *iv_return = (IV)GL_LOG_DEBUG_REGAL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LOG_ERROR_REGAL", 18)) {
    /*                            ^           */
#ifdef GL_LOG_ERROR_REGAL
      *iv_return = (IV)GL_LOG_ERROR_REGAL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MITER_REVERT_NV", 18)) {
    /*                            ^           */
#ifdef GL_MITER_REVERT_NV
      *iv_return = (IV)GL_MITER_REVERT_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RED_INTEGER_EXT", 18)) {
    /*                            ^           */
#ifdef GL_RED_INTEGER_EXT
      *iv_return = (IV)GL_RED_INTEGER_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGB_INTEGER_EXT", 18)) {
    /*                            ^           */
#ifdef GL_RGB_INTEGER_EXT
      *iv_return = (IV)GL_RGB_INTEGER_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STACK_UNDERFLOW", 18)) {
    /*                            ^           */
#ifdef GL_STACK_UNDERFLOW
      *iv_return = (IV)GL_STACK_UNDERFLOW;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SWIZZLE_STR_ATI", 18)) {
    /*                            ^           */
#ifdef GL_SWIZZLE_STR_ATI
      *iv_return = (IV)GL_SWIZZLE_STR_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_WRAP_BORDER_SUN", 18)) {
    /*                            ^           */
#ifdef GL_WRAP_BORDER_SUN
      *iv_return = (IV)GL_WRAP_BORDER_SUN;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'S':
    if (memEQ(name, "GL_INTENSITY_SNORM", 18)) {
    /*                            ^           */
#ifdef GL_INTENSITY_SNORM
      *iv_return = (IV)GL_INTENSITY_SNORM;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LUMINANCE_SNORM", 18)) {
    /*                            ^           */
#ifdef GL_LUMINANCE_SNORM
      *iv_return = (IV)GL_LUMINANCE_SNORM;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_SAMPLES_EXT", 18)) {
    /*                            ^           */
#ifdef GL_MAX_SAMPLES_EXT
      *iv_return = (IV)GL_MAX_SAMPLES_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_WARPS_PER_SM_NV", 18)) {
    /*                            ^           */
#ifdef GL_WARPS_PER_SM_NV
      *iv_return = (IV)GL_WARPS_PER_SM_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'T':
    if (memEQ(name, "GL_BUMP_TARGET_ATI", 18)) {
    /*                            ^           */
#ifdef GL_BUMP_TARGET_ATI
      *iv_return = (IV)GL_BUMP_TARGET_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_SUBROUTINES", 18)) {
    /*                            ^           */
#ifdef GL_MAX_SUBROUTINES
      *iv_return = (IV)GL_MAX_SUBROUTINES;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_POINT_SPRITE_NV", 18)) {
    /*                            ^           */
#ifdef GL_POINT_SPRITE_NV
      *iv_return = (IV)GL_POINT_SPRITE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_QUARTER_BIT_ATI", 18)) {
    /*                            ^           */
#ifdef GL_QUARTER_BIT_ATI
      *iv_return = (IV)GL_QUARTER_BIT_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RESTART_PATH_NV", 18)) {
    /*                            ^           */
#ifdef GL_RESTART_PATH_NV
      *iv_return = (IV)GL_RESTART_PATH_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VALIDATE_STATUS", 18)) {
    /*                            ^           */
#ifdef GL_VALIDATE_STATUS
      *iv_return = (IV)GL_VALIDATE_STATUS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERTEX4_BIT_PGI", 18)) {
    /*                            ^           */
#ifdef GL_VERTEX4_BIT_PGI
      *iv_return = (IV)GL_VERTEX4_BIT_PGI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'U':
    if (memEQ(name, "GL_FENCE_STATUS_NV", 18)) {
    /*                            ^           */
#ifdef GL_FENCE_STATUS_NV
      *iv_return = (IV)GL_FENCE_STATUS_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_IMAGE_UNITS", 18)) {
    /*                            ^           */
#ifdef GL_MAX_IMAGE_UNITS
      *iv_return = (IV)GL_MAX_IMAGE_UNITS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'W':
    if (memEQ(name, "GL_HISTOGRAM_WIDTH", 18)) {
    /*                            ^           */
#ifdef GL_HISTOGRAM_WIDTH
      *iv_return = (IV)GL_HISTOGRAM_WIDTH;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SCALE_BY_TWO_NV", 18)) {
    /*                            ^           */
#ifdef GL_SCALE_BY_TWO_NV
      *iv_return = (IV)GL_SCALE_BY_TWO_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STATIC_DRAW_ARB", 18)) {
    /*                            ^           */
#ifdef GL_STATIC_DRAW_ARB
      *iv_return = (IV)GL_STATIC_DRAW_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STREAM_DRAW_ARB", 18)) {
    /*                            ^           */
#ifdef GL_STREAM_DRAW_ARB
      *iv_return = (IV)GL_STREAM_DRAW_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'X':
    if (memEQ(name, "GL_COMPUTE_TEXTURE", 18)) {
    /*                            ^           */
#ifdef GL_COMPUTE_TEXTURE
      *iv_return = (IV)GL_COMPUTE_TEXTURE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CULL_VERTEX_EXT", 18)) {
    /*                            ^           */
#ifdef GL_CULL_VERTEX_EXT
      *iv_return = (IV)GL_CULL_VERTEX_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CULL_VERTEX_IBM", 18)) {
    /*                            ^           */
#ifdef GL_CULL_VERTEX_IBM
      *iv_return = (IV)GL_CULL_VERTEX_IBM;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_MAX_LOD", 18)) {
    /*                            ^           */
#ifdef GL_TEXTURE_MAX_LOD
      *iv_return = (IV)GL_TEXTURE_MAX_LOD;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'Y':
    if (memEQ(name, "GL_COLOR_ARRAY_EXT", 18)) {
    /*                            ^           */
#ifdef GL_COLOR_ARRAY_EXT
      *iv_return = (IV)GL_COLOR_ARRAY_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INDEX_ARRAY_EXT", 18)) {
    /*                            ^           */
#ifdef GL_INDEX_ARRAY_EXT
      *iv_return = (IV)GL_INDEX_ARRAY_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STATIC_COPY_ARB", 18)) {
    /*                            ^           */
#ifdef GL_STATIC_COPY_ARB
      *iv_return = (IV)GL_STATIC_COPY_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STREAM_COPY_ARB", 18)) {
    /*                            ^           */
#ifdef GL_STREAM_COPY_ARB
      *iv_return = (IV)GL_STREAM_COPY_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '_':
    if (memEQ(name, "GLEW_WIN_swap_hint", 18)) {
    /*                            ^           */
#ifdef GLEW_WIN_swap_hint
      *iv_return = (IV)GLEW_WIN_swap_hint;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ACCUM_BLUE_BITS", 18)) {
    /*                            ^           */
#ifdef GL_ACCUM_BLUE_BITS
      *iv_return = (IV)GL_ACCUM_BLUE_BITS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ALL_ATTRIB_BITS", 18)) {
    /*                            ^           */
#ifdef GL_ALL_ATTRIB_BITS
      *iv_return = (IV)GL_ALL_ATTRIB_BITS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ALL_SHADER_BITS", 18)) {
    /*                            ^           */
#ifdef GL_ALL_SHADER_BITS
      *iv_return = (IV)GL_ALL_SHADER_BITS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ALPHA_TEST_FUNC", 18)) {
    /*                            ^           */
#ifdef GL_ALPHA_TEST_FUNC
      *iv_return = (IV)GL_ALPHA_TEST_FUNC;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CLIP_DEPTH_MODE", 18)) {
    /*                            ^           */
#ifdef GL_CLIP_DEPTH_MODE
      *iv_return = (IV)GL_CLIP_DEPTH_MODE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COMPRESSED_RGBA", 18)) {
    /*                            ^           */
#ifdef GL_COMPRESSED_RGBA
      *iv_return = (IV)GL_COMPRESSED_RGBA;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COMPRESSED_SRGB", 18)) {
    /*                            ^           */
#ifdef GL_COMPRESSED_SRGB
      *iv_return = (IV)GL_COMPRESSED_SRGB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FOG_OFFSET_SGIX", 18)) {
    /*                            ^           */
#ifdef GL_FOG_OFFSET_SGIX
      *iv_return = (IV)GL_FOG_OFFSET_SGIX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FRACTIONAL_EVEN", 18)) {
    /*                            ^           */
#ifdef GL_FRACTIONAL_EVEN
      *iv_return = (IV)GL_FRACTIONAL_EVEN;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_IBM_static_data", 18)) {
    /*                            ^           */
#ifdef GL_IBM_static_data
      *iv_return = (IV)GL_IBM_static_data;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_command_list", 18)) {
    /*                            ^           */
#ifdef GL_NV_command_list
      *iv_return = (IV)GL_NV_command_list;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGBA4_DXT5_S3TC", 18)) {
    /*                            ^           */
#ifdef GL_RGBA4_DXT5_S3TC
      *iv_return = (IV)GL_RGBA4_DXT5_S3TC;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGB_SIGNED_SGIX", 18)) {
    /*                            ^           */
#ifdef GL_RGB_SIGNED_SGIX
      *iv_return = (IV)GL_RGB_SIGNED_SGIX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLER_2D_RECT", 18)) {
    /*                            ^           */
#ifdef GL_SAMPLER_2D_RECT
      *iv_return = (IV)GL_SAMPLER_2D_RECT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'a':
    if (memEQ(name, "GLEW_NV_evaluators", 18)) {
    /*                            ^           */
#ifdef GLEW_NV_evaluators
      *iv_return = (IV)GLEW_NV_evaluators;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_OML_subsample", 18)) {
    /*                            ^           */
#ifdef GLEW_OML_subsample
      *iv_return = (IV)GLEW_OML_subsample;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_SGIX_resample", 18)) {
    /*                            ^           */
#ifdef GLEW_SGIX_resample
      *iv_return = (IV)GLEW_SGIX_resample;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_gpu_shader5", 18)) {
    /*                            ^           */
#ifdef GL_ARB_gpu_shader5
      *iv_return = (IV)GL_ARB_gpu_shader5;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_multisample", 18)) {
    /*                            ^           */
#ifdef GL_ARB_multisample
      *iv_return = (IV)GL_ARB_multisample;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_gpu_shader4", 18)) {
    /*                            ^           */
#ifdef GL_EXT_gpu_shader4
      *iv_return = (IV)GL_EXT_gpu_shader4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_multisample", 18)) {
    /*                            ^           */
#ifdef GL_EXT_multisample
      *iv_return = (IV)GL_EXT_multisample;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SUN_slice_accum", 18)) {
    /*                            ^           */
#ifdef GL_SUN_slice_accum
      *iv_return = (IV)GL_SUN_slice_accum;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'b':
    if (memEQ(name, "GLEW_APPLE_rgb_422", 18)) {
    /*                            ^           */
#ifdef GLEW_APPLE_rgb_422
      *iv_return = (IV)GLEW_APPLE_rgb_422;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_APPLE_row_bytes", 18)) {
    /*                            ^           */
#ifdef GL_APPLE_row_bytes
      *iv_return = (IV)GL_APPLE_row_bytes;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'c':
    if (memEQ(name, "GLEW_EXT_fog_coord", 18)) {
    /*                            ^           */
#ifdef GLEW_EXT_fog_coord
      *iv_return = (IV)GLEW_EXT_fog_coord;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_depth_clamp", 18)) {
    /*                            ^           */
#ifdef GL_ARB_depth_clamp
      *iv_return = (IV)GL_ARB_depth_clamp;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_blend_color", 18)) {
    /*                            ^           */
#ifdef GL_EXT_blend_color
      *iv_return = (IV)GL_EXT_blend_color;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'e':
    if (memEQ(name, "GL_EXT_cull_vertex", 18)) {
    /*                            ^           */
#ifdef GL_EXT_cull_vertex
      *iv_return = (IV)GL_EXT_cull_vertex;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_texture_env", 18)) {
    /*                            ^           */
#ifdef GL_EXT_texture_env
      *iv_return = (IV)GL_EXT_texture_env;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_IBM_cull_vertex", 18)) {
    /*                            ^           */
#ifdef GL_IBM_cull_vertex
      *iv_return = (IV)GL_IBM_cull_vertex;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'f':
    if (memEQ(name, "GLEW_NV_half_float", 18)) {
    /*                            ^           */
#ifdef GLEW_NV_half_float
      *iv_return = (IV)GLEW_NV_half_float;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SGIX_fog_offset", 18)) {
    /*                            ^           */
#ifdef GL_SGIX_fog_offset
      *iv_return = (IV)GL_SGIX_fog_offset;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'g':
    if (memEQ(name, "GL_NV_gpu_program4", 18)) {
    /*                            ^           */
#ifdef GL_NV_gpu_program4
      *iv_return = (IV)GL_NV_gpu_program4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_gpu_program5", 18)) {
    /*                            ^           */
#ifdef GL_NV_gpu_program5
      *iv_return = (IV)GL_NV_gpu_program5;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'h':
    if (memEQ(name, "GLEW_EXT_Cg_shader", 18)) {
    /*                            ^           */
#ifdef GLEW_EXT_Cg_shader
      *iv_return = (IV)GLEW_EXT_Cg_shader;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'i':
    if (memEQ(name, "GLEW_NV_copy_image", 18)) {
    /*                            ^           */
#ifdef GLEW_NV_copy_image
      *iv_return = (IV)GLEW_NV_copy_image;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_OVR_multiview", 18)) {
    /*                            ^           */
#ifdef GLEW_OVR_multiview
      *iv_return = (IV)GLEW_OVR_multiview;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'l':
    if (memEQ(name, "GL_EXT_debug_label", 18)) {
    /*                            ^           */
#ifdef GL_EXT_debug_label
      *iv_return = (IV)GL_EXT_debug_label;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'o':
    if (memEQ(name, "GLEW_EXT_histogram", 18)) {
    /*                            ^           */
#ifdef GLEW_EXT_histogram
      *iv_return = (IV)GLEW_EXT_histogram;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OES_read_format", 18)) {
    /*                            ^           */
#ifdef GL_OES_read_format
      *iv_return = (IV)GL_OES_read_format;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'p':
    if (memEQ(name, "GL_NV_point_sprite", 18)) {
    /*                            ^           */
#ifdef GL_NV_point_sprite
      *iv_return = (IV)GL_NV_point_sprite;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'q':
    if (memEQ(name, "GL_ARB_timer_query", 18)) {
    /*                            ^           */
#ifdef GL_ARB_timer_query
      *iv_return = (IV)GL_ARB_timer_query;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_timer_query", 18)) {
    /*                            ^           */
#ifdef GL_EXT_timer_query
      *iv_return = (IV)GL_EXT_timer_query;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_blend_square", 18)) {
    /*                            ^           */
#ifdef GL_NV_blend_square
      *iv_return = (IV)GL_NV_blend_square;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'r':
    if (memEQ(name, "GLEW_OML_interlace", 18)) {
    /*                            ^           */
#ifdef GLEW_OML_interlace
      *iv_return = (IV)GLEW_OML_interlace;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_APPLE_ycbcr_422", 18)) {
    /*                            ^           */
#ifdef GL_APPLE_ycbcr_422
      *iv_return = (IV)GL_APPLE_ycbcr_422;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 't':
    if (memEQ(name, "GL_NV_fog_distance", 18)) {
    /*                            ^           */
#ifdef GL_NV_fog_distance
      *iv_return = (IV)GL_NV_fog_distance;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SGI_color_table", 18)) {
    /*                            ^           */
#ifdef GL_SGI_color_table
      *iv_return = (IV)GL_SGI_color_table;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'u':
    if (memEQ(name, "GLEW_EXT_texture3D", 18)) {
    /*                            ^           */
#ifdef GLEW_EXT_texture3D
      *iv_return = (IV)GLEW_EXT_texture3D;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_copy_buffer", 18)) {
    /*                            ^           */
#ifdef GL_ARB_copy_buffer
      *iv_return = (IV)GL_ARB_copy_buffer;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_convolution", 18)) {
    /*                            ^           */
#ifdef GL_EXT_convolution
      *iv_return = (IV)GL_EXT_convolution;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_float_buffer", 18)) {
    /*                            ^           */
#ifdef GL_NV_float_buffer
      *iv_return = (IV)GL_NV_float_buffer;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'w':
    if (memEQ(name, "GL_MESA_window_pos", 18)) {
    /*                            ^           */
#ifdef GL_MESA_window_pos
      *iv_return = (IV)GL_MESA_window_pos;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'x':
    if (memEQ(name, "GL_NV_draw_texture", 18)) {
    /*                            ^           */
#ifdef GL_NV_draw_texture
      *iv_return = (IV)GL_NV_draw_texture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  }
  return PERL_constant_NOTFOUND;
}

static int
constant_19 (pTHX_ const char *name, IV *iv_return) {
  /* When generated this function returned values for the list of names given
     here.  However, subsequent manual editing may have added or removed some.
     GLEW_AMD_gcn_shader GLEW_ARB_copy_image GLEW_ARB_multi_bind
     GLEW_ARB_robustness GLEW_ARB_texture_rg GLEW_ARB_window_pos
     GLEW_EXT_422_pixels GLEW_EXT_index_func GLEW_EXT_subtexture
     GLEW_KHR_robustness GLEW_NV_depth_clamp GLEW_NV_gpu_shader5
     GLEW_OVR_multiview2 GLEW_PGI_misc_hints GLEW_SGIS_texture4D
     GLEW_SGIX_framezoom GLEW_SGIX_interlace GLEW_SUN_mesh_array
     GL_3DFX_multisample GL_3D_COLOR_TEXTURE GL_4D_COLOR_TEXTURE
     GL_ACCUM_ALPHA_BITS GL_ACCUM_BUFFER_BIT GL_ACCUM_GREEN_BITS
     GL_ACTIVE_RESOURCES GL_ACTIVE_VARIABLES GL_ALL_BARRIER_BITS
     GL_ALL_COMPLETED_NV GL_ALREADY_SIGNALED GL_AMD_debug_output
     GL_ARB_clip_control GL_ARB_debug_output GL_ARB_draw_buffers
     GL_ARB_multitexture GL_ARB_point_sprite GL_ARB_shader_clock
     GL_ARB_texture_view GL_ARB_vertex_blend GL_ARRAY_BUFFER_ARB
     GL_ATI_draw_buffers GL_ATI_pn_triangles GL_ATTACHED_SHADERS
     GL_BGRA_INTEGER_EXT GL_BLEND_OVERLAP_NV GL_BLUE_INTEGER_EXT
     GL_BUFFER_DATA_SIZE GL_BUFFER_USAGE_ARB GL_CLAMP_READ_COLOR
     GL_CLIP_DISTANCE_NV GL_COLOR_ARRAY_SIZE GL_COLOR_ARRAY_TYPE
     GL_COLOR_BUFFER_BIT GL_COLOR_COMPONENTS GL_COLOR_INDEX1_EXT
     GL_COLOR_INDEX2_EXT GL_COLOR_INDEX4_EXT GL_COLOR_INDEX8_EXT
     GL_COLOR_MATRIX_SGI GL_COLOR_RENDERABLE GL_COLOR_SAMPLES_NV
     GL_COLOR_TABLE_BIAS GL_COMBINER_BIAS_NV GL_COMPRESSED_ALPHA
     GL_COORD_REPLACE_NV GL_COPY_PIXEL_TOKEN GL_COPY_READ_BUFFER
     GL_COUNTER_TYPE_AMD GL_CULL_FRAGMENT_NV GL_DEBUG_SOURCE_API
     GL_DEBUG_TYPE_ERROR GL_DEBUG_TYPE_OTHER GL_DEPTH24_STENCIL8
     GL_DEPTH_ATTACHMENT GL_DEPTH_BOUNDS_EXT GL_DEPTH_BUFFER_BIT
     GL_DEPTH_COMPONENTS GL_DEPTH_RENDERABLE GL_DEPTH_SAMPLES_NV
     GL_DEPTH_STENCIL_NV GL_DRAW_BUFFER0_ARB GL_DRAW_BUFFER0_ATI
     GL_DRAW_BUFFER1_ARB GL_DRAW_BUFFER1_ATI GL_DRAW_BUFFER2_ARB
     GL_DRAW_BUFFER2_ATI GL_DRAW_BUFFER3_ARB GL_DRAW_BUFFER3_ATI
     GL_DRAW_BUFFER4_ARB GL_DRAW_BUFFER4_ATI GL_DRAW_BUFFER5_ARB
     GL_DRAW_BUFFER5_ATI GL_DRAW_BUFFER6_ARB GL_DRAW_BUFFER6_ATI
     GL_DRAW_BUFFER7_ARB GL_DRAW_BUFFER7_ATI GL_DRAW_BUFFER8_ARB
     GL_DRAW_BUFFER8_ATI GL_DRAW_BUFFER9_ARB GL_DRAW_BUFFER9_ATI
     GL_DRAW_FRAMEBUFFER GL_DRAW_PIXEL_TOKEN GL_DYNAMIC_COPY_ARB
     GL_DYNAMIC_DRAW_ARB GL_DYNAMIC_READ_ARB GL_EDGEFLAG_BIT_PGI
     GL_EXPAND_NEGATE_NV GL_EXPAND_NORMAL_NV GL_EXT_blend_minmax
     GL_EXT_copy_texture GL_EXT_debug_marker GL_EXT_packed_float
     GL_EXT_scene_marker GL_EXT_shadow_funcs GL_EXT_stencil_wrap
     GL_EXT_texture_sRGB GL_EXT_vertex_array GL_FIRST_TO_REST_NV
     GL_FRAGMENT_TEXTURE GL_FRAMEBUFFER_SRGB GL_GEOMETRY_TEXTURE
     GL_GLOBAL_ALPHA_SUN GL_HISTOGRAM_FORMAT GL_IMAGE_BUFFER_EXT
     GL_IMAGE_PIXEL_TYPE GL_IMAGE_TEXEL_SIZE GL_INDEX_ARRAY_TYPE
     GL_INGR_color_clamp GL_INTENSITY16F_ARB GL_INTENSITY16I_EXT
     GL_INTENSITY32F_ARB GL_INTENSITY32I_EXT GL_INTENSITY8UI_EXT
     GL_INTENSITY8_SNORM GL_INT_IMAGE_1D_EXT GL_INT_IMAGE_2D_EXT
     GL_INT_IMAGE_3D_EXT GL_INT_IMAGE_BUFFER GL_INT_SAMPLER_CUBE
     GL_KTX_FRONT_REGION GL_LINE_RESET_TOKEN GL_LINE_SMOOTH_HINT
     GL_LINE_WIDTH_RANGE GL_LOG_DRIVER_REGAL GL_LOG_STATUS_REGAL
     GL_LUMINANCE16F_ARB GL_LUMINANCE16I_EXT GL_LUMINANCE32F_ARB
     GL_LUMINANCE32I_EXT GL_LUMINANCE8UI_EXT GL_LUMINANCE8_SNORM
     GL_MAP1_GRID_DOMAIN GL_MAP1_TANGENT_EXT GL_MAP2_GRID_DOMAIN
     GL_MAP2_TANGENT_EXT GL_MAP_COHERENT_BIT GL_MAX_DRAW_BUFFERS
     GL_MAX_LABEL_LENGTH GL_MAX_LIST_NESTING GL_MAX_SHININESS_NV
     GL_MAX_TEXTURE_SIZE GL_MESA_pack_invert GL_MINUS_CLAMPED_NV
     GL_MIRROR_CLAMP_ATI GL_MIRROR_CLAMP_EXT GL_MODELVIEW_MATRIX
     GL_MODULATE_ADD_ATI GL_MULTISAMPLE_3DFX GL_MULTISAMPLE_SGIS
     GL_NAME_STACK_DEPTH GL_NEGATIVE_ONE_EXT GL_NORMAL_ARRAY_EXT
     GL_NV_gpu_multicast GL_NV_present_video GL_NV_texgen_emboss
     GL_NV_vdpau_interop GL_NV_video_capture GL_OBJECT_LINE_SGIS
     GL_OPERAND0_RGB_ARB GL_OPERAND0_RGB_EXT GL_OPERAND1_RGB_ARB
     GL_OPERAND1_RGB_EXT GL_OPERAND2_RGB_ARB GL_OPERAND2_RGB_EXT
     GL_PACK_INVERT_MESA GL_PACK_SKIP_IMAGES GL_PACK_SKIP_PIXELS
     GL_PATH_END_CAPS_NV GL_PATH_GEN_MODE_NV GL_PGI_vertex_hints
     GL_PIXEL_MAP_A_TO_A GL_PIXEL_MAP_B_TO_B GL_PIXEL_MAP_G_TO_G
     GL_PIXEL_MAP_I_TO_A GL_PIXEL_MAP_I_TO_B GL_PIXEL_MAP_I_TO_G
     GL_PIXEL_MAP_I_TO_I GL_PIXEL_MAP_I_TO_R GL_PIXEL_MAP_R_TO_R
     GL_PIXEL_MAP_S_TO_S GL_PN_TRIANGLES_ATI GL_POINT_SIZE_RANGE
     GL_POINT_SPRITE_ARB GL_PRIMARY_COLOR_NV GL_PROGRAM_PIPELINE
     GL_PROVOKING_VERTEX GL_PROXY_TEXTURE_1D GL_PROXY_TEXTURE_2D
     GL_PROXY_TEXTURE_3D GL_QUERY_BUFFER_AMD GL_QUERY_NO_WAIT_NV
     GL_QUERY_OBJECT_AMD GL_QUERY_OBJECT_EXT GL_QUERY_RESULT_ARB
     GL_R1UI_C3F_V3F_SUN GL_R1UI_N3F_V3F_SUN GL_R1UI_T2F_V3F_SUN
     GL_READ_FRAMEBUFFER GL_READ_PIXELS_TYPE GL_RELATIVE_RECT_NV
     GL_RENDERBUFFER_EXT GL_REPLICATE_BORDER GL_RGBA_FLOAT16_ATI
     GL_RGBA_FLOAT32_ATI GL_RGBA_INTEGER_EXT GL_RGBA_SIGNED_SGIX
     GL_ROUNDED_RECT2_NV GL_ROUNDED_RECT4_NV GL_ROUNDED_RECT8_NV
     GL_SAMPLER_1D_ARRAY GL_SAMPLER_2D_ARRAY GL_SAMPLER_CUBE_ARB
     GL_SAMPLE_MASK_SGIS GL_SATURATE_BIT_ATI GL_SCALE_BY_FOUR_NV
     GL_SEPARABLE_2D_EXT GL_SEPARATE_ATTRIBS GL_SGIS_color_range
     GL_SGIS_multisample GL_SGIS_texture_lod GL_SGIX_async_pixel
     GL_SGIX_fog_texture GL_SGI_color_matrix GL_SIGNED_ALPHA8_NV
     GL_SIGNED_HILO16_NV GL_SIGNED_NEGATE_NV GL_SINGLE_COLOR_EXT
     GL_SLUMINANCE_ALPHA GL_SOURCE3_ALPHA_NV GL_SRGB8_ALPHA8_EXT
     GL_STATISTICS_REGAL GL_STENCIL_BACK_REF GL_SUN_global_alpha
     GL_SURFACE_STATE_NV GL_SWIZZLE_STRQ_ATI GL_TESS_GEN_SPACING
     GL_TEXTURE_1D_ARRAY GL_TEXTURE_2D_ARRAY GL_TEXTURE_COORD_NV
     GL_TEXTURE_CUBE_MAP GL_TEXTURE_ENV_MODE GL_TEXTURE_GEN_MODE
     GL_TEXTURE_LOD_BIAS GL_TEXTURE_PRIORITY GL_TEXTURE_RED_SIZE
     GL_TEXTURE_RED_TYPE GL_TEXTURE_RESIDENT GL_TIME_ELAPSED_EXT
     GL_UNDEFINED_VERTEX GL_UNPACK_ALIGNMENT GL_UNPACK_LSB_FIRST
     GL_UNPACK_SKIP_ROWS GL_UNSIGNED_INT8_NV GL_VERTEX23_BIT_PGI
     GL_VERTEX_ARRAY_EXT GL_VERTEX_BLEND_ARB GL_VIBRANCE_BIAS_NV
     GL_WEIGHT_ARRAY_ARB GL_WIN_specular_fog GL_WRITE_DISCARD_NV */
  /* Offset 14 gives the best switch position.  */
  switch (name[14]) {
  case '0':
    if (memEQ(name, "GL_DRAW_BUFFER0_ARB", 19)) {
    /*                             ^           */
#ifdef GL_DRAW_BUFFER0_ARB
      *iv_return = (IV)GL_DRAW_BUFFER0_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRAW_BUFFER0_ATI", 19)) {
    /*                             ^           */
#ifdef GL_DRAW_BUFFER0_ATI
      *iv_return = (IV)GL_DRAW_BUFFER0_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '1':
    if (memEQ(name, "GL_COLOR_INDEX1_EXT", 19)) {
    /*                             ^           */
#ifdef GL_COLOR_INDEX1_EXT
      *iv_return = (IV)GL_COLOR_INDEX1_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRAW_BUFFER1_ARB", 19)) {
    /*                             ^           */
#ifdef GL_DRAW_BUFFER1_ARB
      *iv_return = (IV)GL_DRAW_BUFFER1_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRAW_BUFFER1_ATI", 19)) {
    /*                             ^           */
#ifdef GL_DRAW_BUFFER1_ATI
      *iv_return = (IV)GL_DRAW_BUFFER1_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SIGNED_HILO16_NV", 19)) {
    /*                             ^           */
#ifdef GL_SIGNED_HILO16_NV
      *iv_return = (IV)GL_SIGNED_HILO16_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '2':
    if (memEQ(name, "GL_COLOR_INDEX2_EXT", 19)) {
    /*                             ^           */
#ifdef GL_COLOR_INDEX2_EXT
      *iv_return = (IV)GL_COLOR_INDEX2_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRAW_BUFFER2_ARB", 19)) {
    /*                             ^           */
#ifdef GL_DRAW_BUFFER2_ARB
      *iv_return = (IV)GL_DRAW_BUFFER2_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRAW_BUFFER2_ATI", 19)) {
    /*                             ^           */
#ifdef GL_DRAW_BUFFER2_ATI
      *iv_return = (IV)GL_DRAW_BUFFER2_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGBA_FLOAT32_ATI", 19)) {
    /*                             ^           */
#ifdef GL_RGBA_FLOAT32_ATI
      *iv_return = (IV)GL_RGBA_FLOAT32_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '3':
    if (memEQ(name, "GL_DRAW_BUFFER3_ARB", 19)) {
    /*                             ^           */
#ifdef GL_DRAW_BUFFER3_ARB
      *iv_return = (IV)GL_DRAW_BUFFER3_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRAW_BUFFER3_ATI", 19)) {
    /*                             ^           */
#ifdef GL_DRAW_BUFFER3_ATI
      *iv_return = (IV)GL_DRAW_BUFFER3_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '4':
    if (memEQ(name, "GL_COLOR_INDEX4_EXT", 19)) {
    /*                             ^           */
#ifdef GL_COLOR_INDEX4_EXT
      *iv_return = (IV)GL_COLOR_INDEX4_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRAW_BUFFER4_ARB", 19)) {
    /*                             ^           */
#ifdef GL_DRAW_BUFFER4_ARB
      *iv_return = (IV)GL_DRAW_BUFFER4_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRAW_BUFFER4_ATI", 19)) {
    /*                             ^           */
#ifdef GL_DRAW_BUFFER4_ATI
      *iv_return = (IV)GL_DRAW_BUFFER4_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '5':
    if (memEQ(name, "GL_DRAW_BUFFER5_ARB", 19)) {
    /*                             ^           */
#ifdef GL_DRAW_BUFFER5_ARB
      *iv_return = (IV)GL_DRAW_BUFFER5_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRAW_BUFFER5_ATI", 19)) {
    /*                             ^           */
#ifdef GL_DRAW_BUFFER5_ATI
      *iv_return = (IV)GL_DRAW_BUFFER5_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '6':
    if (memEQ(name, "GL_DRAW_BUFFER6_ARB", 19)) {
    /*                             ^           */
#ifdef GL_DRAW_BUFFER6_ARB
      *iv_return = (IV)GL_DRAW_BUFFER6_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRAW_BUFFER6_ATI", 19)) {
    /*                             ^           */
#ifdef GL_DRAW_BUFFER6_ATI
      *iv_return = (IV)GL_DRAW_BUFFER6_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGBA_FLOAT16_ATI", 19)) {
    /*                             ^           */
#ifdef GL_RGBA_FLOAT16_ATI
      *iv_return = (IV)GL_RGBA_FLOAT16_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '7':
    if (memEQ(name, "GL_DRAW_BUFFER7_ARB", 19)) {
    /*                             ^           */
#ifdef GL_DRAW_BUFFER7_ARB
      *iv_return = (IV)GL_DRAW_BUFFER7_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRAW_BUFFER7_ATI", 19)) {
    /*                             ^           */
#ifdef GL_DRAW_BUFFER7_ATI
      *iv_return = (IV)GL_DRAW_BUFFER7_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '8':
    if (memEQ(name, "GL_COLOR_INDEX8_EXT", 19)) {
    /*                             ^           */
#ifdef GL_COLOR_INDEX8_EXT
      *iv_return = (IV)GL_COLOR_INDEX8_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRAW_BUFFER8_ARB", 19)) {
    /*                             ^           */
#ifdef GL_DRAW_BUFFER8_ARB
      *iv_return = (IV)GL_DRAW_BUFFER8_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRAW_BUFFER8_ATI", 19)) {
    /*                             ^           */
#ifdef GL_DRAW_BUFFER8_ATI
      *iv_return = (IV)GL_DRAW_BUFFER8_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SRGB8_ALPHA8_EXT", 19)) {
    /*                             ^           */
#ifdef GL_SRGB8_ALPHA8_EXT
      *iv_return = (IV)GL_SRGB8_ALPHA8_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '9':
    if (memEQ(name, "GL_DRAW_BUFFER9_ARB", 19)) {
    /*                             ^           */
#ifdef GL_DRAW_BUFFER9_ARB
      *iv_return = (IV)GL_DRAW_BUFFER9_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRAW_BUFFER9_ATI", 19)) {
    /*                             ^           */
#ifdef GL_DRAW_BUFFER9_ATI
      *iv_return = (IV)GL_DRAW_BUFFER9_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'A':
    if (memEQ(name, "GL_ACTIVE_VARIABLES", 19)) {
    /*                             ^           */
#ifdef GL_ACTIVE_VARIABLES
      *iv_return = (IV)GL_ACTIVE_VARIABLES;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ATTACHED_SHADERS", 19)) {
    /*                             ^           */
#ifdef GL_ATTACHED_SHADERS
      *iv_return = (IV)GL_ATTACHED_SHADERS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_BLEND_OVERLAP_NV", 19)) {
    /*                             ^           */
#ifdef GL_BLEND_OVERLAP_NV
      *iv_return = (IV)GL_BLEND_OVERLAP_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COMBINER_BIAS_NV", 19)) {
    /*                             ^           */
#ifdef GL_COMBINER_BIAS_NV
      *iv_return = (IV)GL_COMBINER_BIAS_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COMPRESSED_ALPHA", 19)) {
    /*                             ^           */
#ifdef GL_COMPRESSED_ALPHA
      *iv_return = (IV)GL_COMPRESSED_ALPHA;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXPAND_NORMAL_NV", 19)) {
    /*                             ^           */
#ifdef GL_EXPAND_NORMAL_NV
      *iv_return = (IV)GL_EXPAND_NORMAL_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_GLOBAL_ALPHA_SUN", 19)) {
    /*                             ^           */
#ifdef GL_GLOBAL_ALPHA_SUN
      *iv_return = (IV)GL_GLOBAL_ALPHA_SUN;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MODELVIEW_MATRIX", 19)) {
    /*                             ^           */
#ifdef GL_MODELVIEW_MATRIX
      *iv_return = (IV)GL_MODELVIEW_MATRIX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLER_1D_ARRAY", 19)) {
    /*                             ^           */
#ifdef GL_SAMPLER_1D_ARRAY
      *iv_return = (IV)GL_SAMPLER_1D_ARRAY;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLER_2D_ARRAY", 19)) {
    /*                             ^           */
#ifdef GL_SAMPLER_2D_ARRAY
      *iv_return = (IV)GL_SAMPLER_2D_ARRAY;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SIGNED_ALPHA8_NV", 19)) {
    /*                             ^           */
#ifdef GL_SIGNED_ALPHA8_NV
      *iv_return = (IV)GL_SIGNED_ALPHA8_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SLUMINANCE_ALPHA", 19)) {
    /*                             ^           */
#ifdef GL_SLUMINANCE_ALPHA
      *iv_return = (IV)GL_SLUMINANCE_ALPHA;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TESS_GEN_SPACING", 19)) {
    /*                             ^           */
#ifdef GL_TESS_GEN_SPACING
      *iv_return = (IV)GL_TESS_GEN_SPACING;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_1D_ARRAY", 19)) {
    /*                             ^           */
#ifdef GL_TEXTURE_1D_ARRAY
      *iv_return = (IV)GL_TEXTURE_1D_ARRAY;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_2D_ARRAY", 19)) {
    /*                             ^           */
#ifdef GL_TEXTURE_2D_ARRAY
      *iv_return = (IV)GL_TEXTURE_2D_ARRAY;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VIBRANCE_BIAS_NV", 19)) {
    /*                             ^           */
#ifdef GL_VIBRANCE_BIAS_NV
      *iv_return = (IV)GL_VIBRANCE_BIAS_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'B':
    if (memEQ(name, "GL_OPERAND0_RGB_ARB", 19)) {
    /*                             ^           */
#ifdef GL_OPERAND0_RGB_ARB
      *iv_return = (IV)GL_OPERAND0_RGB_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OPERAND0_RGB_EXT", 19)) {
    /*                             ^           */
#ifdef GL_OPERAND0_RGB_EXT
      *iv_return = (IV)GL_OPERAND0_RGB_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OPERAND1_RGB_ARB", 19)) {
    /*                             ^           */
#ifdef GL_OPERAND1_RGB_ARB
      *iv_return = (IV)GL_OPERAND1_RGB_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OPERAND1_RGB_EXT", 19)) {
    /*                             ^           */
#ifdef GL_OPERAND1_RGB_EXT
      *iv_return = (IV)GL_OPERAND1_RGB_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OPERAND2_RGB_ARB", 19)) {
    /*                             ^           */
#ifdef GL_OPERAND2_RGB_ARB
      *iv_return = (IV)GL_OPERAND2_RGB_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OPERAND2_RGB_EXT", 19)) {
    /*                             ^           */
#ifdef GL_OPERAND2_RGB_EXT
      *iv_return = (IV)GL_OPERAND2_RGB_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'C':
    if (memEQ(name, "GL_CLAMP_READ_COLOR", 19)) {
    /*                             ^           */
#ifdef GL_CLAMP_READ_COLOR
      *iv_return = (IV)GL_CLAMP_READ_COLOR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CLIP_DISTANCE_NV", 19)) {
    /*                             ^           */
#ifdef GL_CLIP_DISTANCE_NV
      *iv_return = (IV)GL_CLIP_DISTANCE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COORD_REPLACE_NV", 19)) {
    /*                             ^           */
#ifdef GL_COORD_REPLACE_NV
      *iv_return = (IV)GL_COORD_REPLACE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RELATIVE_RECT_NV", 19)) {
    /*                             ^           */
#ifdef GL_RELATIVE_RECT_NV
      *iv_return = (IV)GL_RELATIVE_RECT_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'D':
    if (memEQ(name, "GL_DYNAMIC_READ_ARB", 19)) {
    /*                             ^           */
#ifdef GL_DYNAMIC_READ_ARB
      *iv_return = (IV)GL_DYNAMIC_READ_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INT_IMAGE_1D_EXT", 19)) {
    /*                             ^           */
#ifdef GL_INT_IMAGE_1D_EXT
      *iv_return = (IV)GL_INT_IMAGE_1D_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INT_IMAGE_2D_EXT", 19)) {
    /*                             ^           */
#ifdef GL_INT_IMAGE_2D_EXT
      *iv_return = (IV)GL_INT_IMAGE_2D_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INT_IMAGE_3D_EXT", 19)) {
    /*                             ^           */
#ifdef GL_INT_IMAGE_3D_EXT
      *iv_return = (IV)GL_INT_IMAGE_3D_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MODULATE_ADD_ATI", 19)) {
    /*                             ^           */
#ifdef GL_MODULATE_ADD_ATI
      *iv_return = (IV)GL_MODULATE_ADD_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NAME_STACK_DEPTH", 19)) {
    /*                             ^           */
#ifdef GL_NAME_STACK_DEPTH
      *iv_return = (IV)GL_NAME_STACK_DEPTH;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PATH_GEN_MODE_NV", 19)) {
    /*                             ^           */
#ifdef GL_PATH_GEN_MODE_NV
      *iv_return = (IV)GL_PATH_GEN_MODE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SEPARABLE_2D_EXT", 19)) {
    /*                             ^           */
#ifdef GL_SEPARABLE_2D_EXT
      *iv_return = (IV)GL_SEPARABLE_2D_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TIME_ELAPSED_EXT", 19)) {
    /*                             ^           */
#ifdef GL_TIME_ELAPSED_EXT
      *iv_return = (IV)GL_TIME_ELAPSED_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERTEX_BLEND_ARB", 19)) {
    /*                             ^           */
#ifdef GL_VERTEX_BLEND_ARB
      *iv_return = (IV)GL_VERTEX_BLEND_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'E':
    if (memEQ(name, "GL_ALL_COMPLETED_NV", 19)) {
    /*                             ^           */
#ifdef GL_ALL_COMPLETED_NV
      *iv_return = (IV)GL_ALL_COMPLETED_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_BUFFER_USAGE_ARB", 19)) {
    /*                             ^           */
#ifdef GL_BUFFER_USAGE_ARB
      *iv_return = (IV)GL_BUFFER_USAGE_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_SAMPLES_NV", 19)) {
    /*                             ^           */
#ifdef GL_COLOR_SAMPLES_NV
      *iv_return = (IV)GL_COLOR_SAMPLES_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COUNTER_TYPE_AMD", 19)) {
    /*                             ^           */
#ifdef GL_COUNTER_TYPE_AMD
      *iv_return = (IV)GL_COUNTER_TYPE_AMD;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEBUG_SOURCE_API", 19)) {
    /*                             ^           */
#ifdef GL_DEBUG_SOURCE_API
      *iv_return = (IV)GL_DEBUG_SOURCE_API;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEBUG_TYPE_ERROR", 19)) {
    /*                             ^           */
#ifdef GL_DEBUG_TYPE_ERROR
      *iv_return = (IV)GL_DEBUG_TYPE_ERROR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEPTH_SAMPLES_NV", 19)) {
    /*                             ^           */
#ifdef GL_DEPTH_SAMPLES_NV
      *iv_return = (IV)GL_DEPTH_SAMPLES_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_KTX_FRONT_REGION", 19)) {
    /*                             ^           */
#ifdef GL_KTX_FRONT_REGION
      *iv_return = (IV)GL_KTX_FRONT_REGION;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_LABEL_LENGTH", 19)) {
    /*                             ^           */
#ifdef GL_MAX_LABEL_LENGTH
      *iv_return = (IV)GL_MAX_LABEL_LENGTH;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MINUS_CLAMPED_NV", 19)) {
    /*                             ^           */
#ifdef GL_MINUS_CLAMPED_NV
      *iv_return = (IV)GL_MINUS_CLAMPED_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NEGATIVE_ONE_EXT", 19)) {
    /*                             ^           */
#ifdef GL_NEGATIVE_ONE_EXT
      *iv_return = (IV)GL_NEGATIVE_ONE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_POINT_SPRITE_ARB", 19)) {
    /*                             ^           */
#ifdef GL_POINT_SPRITE_ARB
      *iv_return = (IV)GL_POINT_SPRITE_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PROGRAM_PIPELINE", 19)) {
    /*                             ^           */
#ifdef GL_PROGRAM_PIPELINE
      *iv_return = (IV)GL_PROGRAM_PIPELINE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PROVOKING_VERTEX", 19)) {
    /*                             ^           */
#ifdef GL_PROVOKING_VERTEX
      *iv_return = (IV)GL_PROVOKING_VERTEX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLER_CUBE_ARB", 19)) {
    /*                             ^           */
#ifdef GL_SAMPLER_CUBE_ARB
      *iv_return = (IV)GL_SAMPLER_CUBE_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_CUBE_MAP", 19)) {
    /*                             ^           */
#ifdef GL_TEXTURE_CUBE_MAP
      *iv_return = (IV)GL_TEXTURE_CUBE_MAP;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNDEFINED_VERTEX", 19)) {
    /*                             ^           */
#ifdef GL_UNDEFINED_VERTEX
      *iv_return = (IV)GL_UNDEFINED_VERTEX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'F':
    if (memEQ(name, "GL_INTENSITY16F_ARB", 19)) {
    /*                             ^           */
#ifdef GL_INTENSITY16F_ARB
      *iv_return = (IV)GL_INTENSITY16F_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INTENSITY32F_ARB", 19)) {
    /*                             ^           */
#ifdef GL_INTENSITY32F_ARB
      *iv_return = (IV)GL_INTENSITY32F_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LUMINANCE16F_ARB", 19)) {
    /*                             ^           */
#ifdef GL_LUMINANCE16F_ARB
      *iv_return = (IV)GL_LUMINANCE16F_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LUMINANCE32F_ARB", 19)) {
    /*                             ^           */
#ifdef GL_LUMINANCE32F_ARB
      *iv_return = (IV)GL_LUMINANCE32F_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_DRAW_BUFFERS", 19)) {
    /*                             ^           */
#ifdef GL_MAX_DRAW_BUFFERS
      *iv_return = (IV)GL_MAX_DRAW_BUFFERS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_R1UI_C3F_V3F_SUN", 19)) {
    /*                             ^           */
#ifdef GL_R1UI_C3F_V3F_SUN
      *iv_return = (IV)GL_R1UI_C3F_V3F_SUN;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_R1UI_N3F_V3F_SUN", 19)) {
    /*                             ^           */
#ifdef GL_R1UI_N3F_V3F_SUN
      *iv_return = (IV)GL_R1UI_N3F_V3F_SUN;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_R1UI_T2F_V3F_SUN", 19)) {
    /*                             ^           */
#ifdef GL_R1UI_T2F_V3F_SUN
      *iv_return = (IV)GL_R1UI_T2F_V3F_SUN;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNPACK_LSB_FIRST", 19)) {
    /*                             ^           */
#ifdef GL_UNPACK_LSB_FIRST
      *iv_return = (IV)GL_UNPACK_LSB_FIRST;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'H':
    if (memEQ(name, "GL_DEPTH_ATTACHMENT", 19)) {
    /*                             ^           */
#ifdef GL_DEPTH_ATTACHMENT
      *iv_return = (IV)GL_DEPTH_ATTACHMENT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SOURCE3_ALPHA_NV", 19)) {
    /*                             ^           */
#ifdef GL_SOURCE3_ALPHA_NV
      *iv_return = (IV)GL_SOURCE3_ALPHA_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'I':
    if (memEQ(name, "GL_DEPTH_STENCIL_NV", 19)) {
    /*                             ^           */
#ifdef GL_DEPTH_STENCIL_NV
      *iv_return = (IV)GL_DEPTH_STENCIL_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INTENSITY16I_EXT", 19)) {
    /*                             ^           */
#ifdef GL_INTENSITY16I_EXT
      *iv_return = (IV)GL_INTENSITY16I_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INTENSITY32I_EXT", 19)) {
    /*                             ^           */
#ifdef GL_INTENSITY32I_EXT
      *iv_return = (IV)GL_INTENSITY32I_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INTENSITY8UI_EXT", 19)) {
    /*                             ^           */
#ifdef GL_INTENSITY8UI_EXT
      *iv_return = (IV)GL_INTENSITY8UI_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LUMINANCE16I_EXT", 19)) {
    /*                             ^           */
#ifdef GL_LUMINANCE16I_EXT
      *iv_return = (IV)GL_LUMINANCE16I_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LUMINANCE32I_EXT", 19)) {
    /*                             ^           */
#ifdef GL_LUMINANCE32I_EXT
      *iv_return = (IV)GL_LUMINANCE32I_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LUMINANCE8UI_EXT", 19)) {
    /*                             ^           */
#ifdef GL_LUMINANCE8UI_EXT
      *iv_return = (IV)GL_LUMINANCE8UI_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PACK_SKIP_PIXELS", 19)) {
    /*                             ^           */
#ifdef GL_PACK_SKIP_PIXELS
      *iv_return = (IV)GL_PACK_SKIP_PIXELS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_QUERY_NO_WAIT_NV", 19)) {
    /*                             ^           */
#ifdef GL_QUERY_NO_WAIT_NV
      *iv_return = (IV)GL_QUERY_NO_WAIT_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_RESIDENT", 19)) {
    /*                             ^           */
#ifdef GL_TEXTURE_RESIDENT
      *iv_return = (IV)GL_TEXTURE_RESIDENT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'K':
    if (memEQ(name, "GL_STENCIL_BACK_REF", 19)) {
    /*                             ^           */
#ifdef GL_STENCIL_BACK_REF
      *iv_return = (IV)GL_STENCIL_BACK_REF;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'M':
    if (memEQ(name, "GL_PACK_SKIP_IMAGES", 19)) {
    /*                             ^           */
#ifdef GL_PACK_SKIP_IMAGES
      *iv_return = (IV)GL_PACK_SKIP_IMAGES;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'N':
    if (memEQ(name, "GL_ALREADY_SIGNALED", 19)) {
    /*                             ^           */
#ifdef GL_ALREADY_SIGNALED
      *iv_return = (IV)GL_ALREADY_SIGNALED;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_COMPONENTS", 19)) {
    /*                             ^           */
#ifdef GL_COLOR_COMPONENTS
      *iv_return = (IV)GL_COLOR_COMPONENTS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CULL_FRAGMENT_NV", 19)) {
    /*                             ^           */
#ifdef GL_CULL_FRAGMENT_NV
      *iv_return = (IV)GL_CULL_FRAGMENT_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEPTH24_STENCIL8", 19)) {
    /*                             ^           */
#ifdef GL_DEPTH24_STENCIL8
      *iv_return = (IV)GL_DEPTH24_STENCIL8;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEPTH_COMPONENTS", 19)) {
    /*                             ^           */
#ifdef GL_DEPTH_COMPONENTS
      *iv_return = (IV)GL_DEPTH_COMPONENTS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNPACK_ALIGNMENT", 19)) {
    /*                             ^           */
#ifdef GL_UNPACK_ALIGNMENT
      *iv_return = (IV)GL_UNPACK_ALIGNMENT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'O':
    if (memEQ(name, "GL_DEBUG_TYPE_OTHER", 19)) {
    /*                             ^           */
#ifdef GL_DEBUG_TYPE_OTHER
      *iv_return = (IV)GL_DEBUG_TYPE_OTHER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_HISTOGRAM_FORMAT", 19)) {
    /*                             ^           */
#ifdef GL_HISTOGRAM_FORMAT
      *iv_return = (IV)GL_HISTOGRAM_FORMAT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAP1_GRID_DOMAIN", 19)) {
    /*                             ^           */
#ifdef GL_MAP1_GRID_DOMAIN
      *iv_return = (IV)GL_MAP1_GRID_DOMAIN;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAP2_GRID_DOMAIN", 19)) {
    /*                             ^           */
#ifdef GL_MAP2_GRID_DOMAIN
      *iv_return = (IV)GL_MAP2_GRID_DOMAIN;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PRIMARY_COLOR_NV", 19)) {
    /*                             ^           */
#ifdef GL_PRIMARY_COLOR_NV
      *iv_return = (IV)GL_PRIMARY_COLOR_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_REPLICATE_BORDER", 19)) {
    /*                             ^           */
#ifdef GL_REPLICATE_BORDER
      *iv_return = (IV)GL_REPLICATE_BORDER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_PRIORITY", 19)) {
    /*                             ^           */
#ifdef GL_TEXTURE_PRIORITY
      *iv_return = (IV)GL_TEXTURE_PRIORITY;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'P':
    if (memEQ(name, "GL_MIRROR_CLAMP_ATI", 19)) {
    /*                             ^           */
#ifdef GL_MIRROR_CLAMP_ATI
      *iv_return = (IV)GL_MIRROR_CLAMP_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MIRROR_CLAMP_EXT", 19)) {
    /*                             ^           */
#ifdef GL_MIRROR_CLAMP_EXT
      *iv_return = (IV)GL_MIRROR_CLAMP_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PATH_END_CAPS_NV", 19)) {
    /*                             ^           */
#ifdef GL_PATH_END_CAPS_NV
      *iv_return = (IV)GL_PATH_END_CAPS_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'Q':
    if (memEQ(name, "GL_SWIZZLE_STRQ_ATI", 19)) {
    /*                             ^           */
#ifdef GL_SWIZZLE_STRQ_ATI
      *iv_return = (IV)GL_SWIZZLE_STRQ_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'R':
    if (memEQ(name, "GL_ACCUM_BUFFER_BIT", 19)) {
    /*                             ^           */
#ifdef GL_ACCUM_BUFFER_BIT
      *iv_return = (IV)GL_ACCUM_BUFFER_BIT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARRAY_BUFFER_ARB", 19)) {
    /*                             ^           */
#ifdef GL_ARRAY_BUFFER_ARB
      *iv_return = (IV)GL_ARRAY_BUFFER_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_BGRA_INTEGER_EXT", 19)) {
    /*                             ^           */
#ifdef GL_BGRA_INTEGER_EXT
      *iv_return = (IV)GL_BGRA_INTEGER_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_BLUE_INTEGER_EXT", 19)) {
    /*                             ^           */
#ifdef GL_BLUE_INTEGER_EXT
      *iv_return = (IV)GL_BLUE_INTEGER_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_BUFFER_BIT", 19)) {
    /*                             ^           */
#ifdef GL_COLOR_BUFFER_BIT
      *iv_return = (IV)GL_COLOR_BUFFER_BIT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_RENDERABLE", 19)) {
    /*                             ^           */
#ifdef GL_COLOR_RENDERABLE
      *iv_return = (IV)GL_COLOR_RENDERABLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEPTH_BUFFER_BIT", 19)) {
    /*                             ^           */
#ifdef GL_DEPTH_BUFFER_BIT
      *iv_return = (IV)GL_DEPTH_BUFFER_BIT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEPTH_RENDERABLE", 19)) {
    /*                             ^           */
#ifdef GL_DEPTH_RENDERABLE
      *iv_return = (IV)GL_DEPTH_RENDERABLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_IMAGE_BUFFER_EXT", 19)) {
    /*                             ^           */
#ifdef GL_IMAGE_BUFFER_EXT
      *iv_return = (IV)GL_IMAGE_BUFFER_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LINE_WIDTH_RANGE", 19)) {
    /*                             ^           */
#ifdef GL_LINE_WIDTH_RANGE
      *iv_return = (IV)GL_LINE_WIDTH_RANGE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LOG_DRIVER_REGAL", 19)) {
    /*                             ^           */
#ifdef GL_LOG_DRIVER_REGAL
      *iv_return = (IV)GL_LOG_DRIVER_REGAL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LOG_STATUS_REGAL", 19)) {
    /*                             ^           */
#ifdef GL_LOG_STATUS_REGAL
      *iv_return = (IV)GL_LOG_STATUS_REGAL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_POINT_SIZE_RANGE", 19)) {
    /*                             ^           */
#ifdef GL_POINT_SIZE_RANGE
      *iv_return = (IV)GL_POINT_SIZE_RANGE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PROXY_TEXTURE_1D", 19)) {
    /*                             ^           */
#ifdef GL_PROXY_TEXTURE_1D
      *iv_return = (IV)GL_PROXY_TEXTURE_1D;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PROXY_TEXTURE_2D", 19)) {
    /*                             ^           */
#ifdef GL_PROXY_TEXTURE_2D
      *iv_return = (IV)GL_PROXY_TEXTURE_2D;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PROXY_TEXTURE_3D", 19)) {
    /*                             ^           */
#ifdef GL_PROXY_TEXTURE_3D
      *iv_return = (IV)GL_PROXY_TEXTURE_3D;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_QUERY_BUFFER_AMD", 19)) {
    /*                             ^           */
#ifdef GL_QUERY_BUFFER_AMD
      *iv_return = (IV)GL_QUERY_BUFFER_AMD;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RENDERBUFFER_EXT", 19)) {
    /*                             ^           */
#ifdef GL_RENDERBUFFER_EXT
      *iv_return = (IV)GL_RENDERBUFFER_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGBA_INTEGER_EXT", 19)) {
    /*                             ^           */
#ifdef GL_RGBA_INTEGER_EXT
      *iv_return = (IV)GL_RGBA_INTEGER_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SINGLE_COLOR_EXT", 19)) {
    /*                             ^           */
#ifdef GL_SINGLE_COLOR_EXT
      *iv_return = (IV)GL_SINGLE_COLOR_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STATISTICS_REGAL", 19)) {
    /*                             ^           */
#ifdef GL_STATISTICS_REGAL
      *iv_return = (IV)GL_STATISTICS_REGAL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_COORD_NV", 19)) {
    /*                             ^           */
#ifdef GL_TEXTURE_COORD_NV
      *iv_return = (IV)GL_TEXTURE_COORD_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_WRITE_DISCARD_NV", 19)) {
    /*                             ^           */
#ifdef GL_WRITE_DISCARD_NV
      *iv_return = (IV)GL_WRITE_DISCARD_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'S':
    if (memEQ(name, "GL_DEPTH_BOUNDS_EXT", 19)) {
    /*                             ^           */
#ifdef GL_DEPTH_BOUNDS_EXT
      *iv_return = (IV)GL_DEPTH_BOUNDS_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FIRST_TO_REST_NV", 19)) {
    /*                             ^           */
#ifdef GL_FIRST_TO_REST_NV
      *iv_return = (IV)GL_FIRST_TO_REST_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INTENSITY8_SNORM", 19)) {
    /*                             ^           */
#ifdef GL_INTENSITY8_SNORM
      *iv_return = (IV)GL_INTENSITY8_SNORM;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LUMINANCE8_SNORM", 19)) {
    /*                             ^           */
#ifdef GL_LUMINANCE8_SNORM
      *iv_return = (IV)GL_LUMINANCE8_SNORM;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_LIST_NESTING", 19)) {
    /*                             ^           */
#ifdef GL_MAX_LIST_NESTING
      *iv_return = (IV)GL_MAX_LIST_NESTING;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_SHININESS_NV", 19)) {
    /*                             ^           */
#ifdef GL_MAX_SHININESS_NV
      *iv_return = (IV)GL_MAX_SHININESS_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PN_TRIANGLES_ATI", 19)) {
    /*                             ^           */
#ifdef GL_PN_TRIANGLES_ATI
      *iv_return = (IV)GL_PN_TRIANGLES_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'T':
    if (memEQ(name, "GL_COPY_PIXEL_TOKEN", 19)) {
    /*                             ^           */
#ifdef GL_COPY_PIXEL_TOKEN
      *iv_return = (IV)GL_COPY_PIXEL_TOKEN;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRAW_PIXEL_TOKEN", 19)) {
    /*                             ^           */
#ifdef GL_DRAW_PIXEL_TOKEN
      *iv_return = (IV)GL_DRAW_PIXEL_TOKEN;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EDGEFLAG_BIT_PGI", 19)) {
    /*                             ^           */
#ifdef GL_EDGEFLAG_BIT_PGI
      *iv_return = (IV)GL_EDGEFLAG_BIT_PGI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXPAND_NEGATE_NV", 19)) {
    /*                             ^           */
#ifdef GL_EXPAND_NEGATE_NV
      *iv_return = (IV)GL_EXPAND_NEGATE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LINE_RESET_TOKEN", 19)) {
    /*                             ^           */
#ifdef GL_LINE_RESET_TOKEN
      *iv_return = (IV)GL_LINE_RESET_TOKEN;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAP1_TANGENT_EXT", 19)) {
    /*                             ^           */
#ifdef GL_MAP1_TANGENT_EXT
      *iv_return = (IV)GL_MAP1_TANGENT_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAP2_TANGENT_EXT", 19)) {
    /*                             ^           */
#ifdef GL_MAP2_TANGENT_EXT
      *iv_return = (IV)GL_MAP2_TANGENT_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAP_COHERENT_BIT", 19)) {
    /*                             ^           */
#ifdef GL_MAP_COHERENT_BIT
      *iv_return = (IV)GL_MAP_COHERENT_BIT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_QUERY_OBJECT_AMD", 19)) {
    /*                             ^           */
#ifdef GL_QUERY_OBJECT_AMD
      *iv_return = (IV)GL_QUERY_OBJECT_AMD;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_QUERY_OBJECT_EXT", 19)) {
    /*                             ^           */
#ifdef GL_QUERY_OBJECT_EXT
      *iv_return = (IV)GL_QUERY_OBJECT_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_QUERY_RESULT_ARB", 19)) {
    /*                             ^           */
#ifdef GL_QUERY_RESULT_ARB
      *iv_return = (IV)GL_QUERY_RESULT_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ROUNDED_RECT2_NV", 19)) {
    /*                             ^           */
#ifdef GL_ROUNDED_RECT2_NV
      *iv_return = (IV)GL_ROUNDED_RECT2_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ROUNDED_RECT4_NV", 19)) {
    /*                             ^           */
#ifdef GL_ROUNDED_RECT4_NV
      *iv_return = (IV)GL_ROUNDED_RECT4_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ROUNDED_RECT8_NV", 19)) {
    /*                             ^           */
#ifdef GL_ROUNDED_RECT8_NV
      *iv_return = (IV)GL_ROUNDED_RECT8_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SATURATE_BIT_ATI", 19)) {
    /*                             ^           */
#ifdef GL_SATURATE_BIT_ATI
      *iv_return = (IV)GL_SATURATE_BIT_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SEPARATE_ATTRIBS", 19)) {
    /*                             ^           */
#ifdef GL_SEPARATE_ATTRIBS
      *iv_return = (IV)GL_SEPARATE_ATTRIBS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SIGNED_NEGATE_NV", 19)) {
    /*                             ^           */
#ifdef GL_SIGNED_NEGATE_NV
      *iv_return = (IV)GL_SIGNED_NEGATE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SURFACE_STATE_NV", 19)) {
    /*                             ^           */
#ifdef GL_SURFACE_STATE_NV
      *iv_return = (IV)GL_SURFACE_STATE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNSIGNED_INT8_NV", 19)) {
    /*                             ^           */
#ifdef GL_UNSIGNED_INT8_NV
      *iv_return = (IV)GL_UNSIGNED_INT8_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERTEX23_BIT_PGI", 19)) {
    /*                             ^           */
#ifdef GL_VERTEX23_BIT_PGI
      *iv_return = (IV)GL_VERTEX23_BIT_PGI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'U':
    if (memEQ(name, "GL_ACTIVE_RESOURCES", 19)) {
    /*                             ^           */
#ifdef GL_ACTIVE_RESOURCES
      *iv_return = (IV)GL_ACTIVE_RESOURCES;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COPY_READ_BUFFER", 19)) {
    /*                             ^           */
#ifdef GL_COPY_READ_BUFFER
      *iv_return = (IV)GL_COPY_READ_BUFFER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRAW_FRAMEBUFFER", 19)) {
    /*                             ^           */
#ifdef GL_DRAW_FRAMEBUFFER
      *iv_return = (IV)GL_DRAW_FRAMEBUFFER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INT_IMAGE_BUFFER", 19)) {
    /*                             ^           */
#ifdef GL_INT_IMAGE_BUFFER
      *iv_return = (IV)GL_INT_IMAGE_BUFFER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_READ_FRAMEBUFFER", 19)) {
    /*                             ^           */
#ifdef GL_READ_FRAMEBUFFER
      *iv_return = (IV)GL_READ_FRAMEBUFFER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SCALE_BY_FOUR_NV", 19)) {
    /*                             ^           */
#ifdef GL_SCALE_BY_FOUR_NV
      *iv_return = (IV)GL_SCALE_BY_FOUR_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'W':
    if (memEQ(name, "GL_DYNAMIC_DRAW_ARB", 19)) {
    /*                             ^           */
#ifdef GL_DYNAMIC_DRAW_ARB
      *iv_return = (IV)GL_DYNAMIC_DRAW_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'X':
    if (memEQ(name, "GL_3D_COLOR_TEXTURE", 19)) {
    /*                             ^           */
#ifdef GL_3D_COLOR_TEXTURE
      *iv_return = (IV)GL_3D_COLOR_TEXTURE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_4D_COLOR_TEXTURE", 19)) {
    /*                             ^           */
#ifdef GL_4D_COLOR_TEXTURE
      *iv_return = (IV)GL_4D_COLOR_TEXTURE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_MATRIX_SGI", 19)) {
    /*                             ^           */
#ifdef GL_COLOR_MATRIX_SGI
      *iv_return = (IV)GL_COLOR_MATRIX_SGI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FRAGMENT_TEXTURE", 19)) {
    /*                             ^           */
#ifdef GL_FRAGMENT_TEXTURE
      *iv_return = (IV)GL_FRAGMENT_TEXTURE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_GEOMETRY_TEXTURE", 19)) {
    /*                             ^           */
#ifdef GL_GEOMETRY_TEXTURE
      *iv_return = (IV)GL_GEOMETRY_TEXTURE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'Y':
    if (memEQ(name, "GL_DYNAMIC_COPY_ARB", 19)) {
    /*                             ^           */
#ifdef GL_DYNAMIC_COPY_ARB
      *iv_return = (IV)GL_DYNAMIC_COPY_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NORMAL_ARRAY_EXT", 19)) {
    /*                             ^           */
#ifdef GL_NORMAL_ARRAY_EXT
      *iv_return = (IV)GL_NORMAL_ARRAY_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERTEX_ARRAY_EXT", 19)) {
    /*                             ^           */
#ifdef GL_VERTEX_ARRAY_EXT
      *iv_return = (IV)GL_VERTEX_ARRAY_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_WEIGHT_ARRAY_ARB", 19)) {
    /*                             ^           */
#ifdef GL_WEIGHT_ARRAY_ARB
      *iv_return = (IV)GL_WEIGHT_ARRAY_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '_':
    if (memEQ(name, "GLEW_ARB_multi_bind", 19)) {
    /*                             ^           */
#ifdef GLEW_ARB_multi_bind
      *iv_return = (IV)GLEW_ARB_multi_bind;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_EXT_index_func", 19)) {
    /*                             ^           */
#ifdef GLEW_EXT_index_func
      *iv_return = (IV)GLEW_EXT_index_func;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ACCUM_ALPHA_BITS", 19)) {
    /*                             ^           */
#ifdef GL_ACCUM_ALPHA_BITS
      *iv_return = (IV)GL_ACCUM_ALPHA_BITS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ACCUM_GREEN_BITS", 19)) {
    /*                             ^           */
#ifdef GL_ACCUM_GREEN_BITS
      *iv_return = (IV)GL_ACCUM_GREEN_BITS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ALL_BARRIER_BITS", 19)) {
    /*                             ^           */
#ifdef GL_ALL_BARRIER_BITS
      *iv_return = (IV)GL_ALL_BARRIER_BITS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_texture_view", 19)) {
    /*                             ^           */
#ifdef GL_ARB_texture_view
      *iv_return = (IV)GL_ARB_texture_view;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_BUFFER_DATA_SIZE", 19)) {
    /*                             ^           */
#ifdef GL_BUFFER_DATA_SIZE
      *iv_return = (IV)GL_BUFFER_DATA_SIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_ARRAY_SIZE", 19)) {
    /*                             ^           */
#ifdef GL_COLOR_ARRAY_SIZE
      *iv_return = (IV)GL_COLOR_ARRAY_SIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_ARRAY_TYPE", 19)) {
    /*                             ^           */
#ifdef GL_COLOR_ARRAY_TYPE
      *iv_return = (IV)GL_COLOR_ARRAY_TYPE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_TABLE_BIAS", 19)) {
    /*                             ^           */
#ifdef GL_COLOR_TABLE_BIAS
      *iv_return = (IV)GL_COLOR_TABLE_BIAS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_stencil_wrap", 19)) {
    /*                             ^           */
#ifdef GL_EXT_stencil_wrap
      *iv_return = (IV)GL_EXT_stencil_wrap;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_texture_sRGB", 19)) {
    /*                             ^           */
#ifdef GL_EXT_texture_sRGB
      *iv_return = (IV)GL_EXT_texture_sRGB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FRAMEBUFFER_SRGB", 19)) {
    /*                             ^           */
#ifdef GL_FRAMEBUFFER_SRGB
      *iv_return = (IV)GL_FRAMEBUFFER_SRGB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_IMAGE_PIXEL_TYPE", 19)) {
    /*                             ^           */
#ifdef GL_IMAGE_PIXEL_TYPE
      *iv_return = (IV)GL_IMAGE_PIXEL_TYPE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_IMAGE_TEXEL_SIZE", 19)) {
    /*                             ^           */
#ifdef GL_IMAGE_TEXEL_SIZE
      *iv_return = (IV)GL_IMAGE_TEXEL_SIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INDEX_ARRAY_TYPE", 19)) {
    /*                             ^           */
#ifdef GL_INDEX_ARRAY_TYPE
      *iv_return = (IV)GL_INDEX_ARRAY_TYPE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INT_SAMPLER_CUBE", 19)) {
    /*                             ^           */
#ifdef GL_INT_SAMPLER_CUBE
      *iv_return = (IV)GL_INT_SAMPLER_CUBE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LINE_SMOOTH_HINT", 19)) {
    /*                             ^           */
#ifdef GL_LINE_SMOOTH_HINT
      *iv_return = (IV)GL_LINE_SMOOTH_HINT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_TEXTURE_SIZE", 19)) {
    /*                             ^           */
#ifdef GL_MAX_TEXTURE_SIZE
      *iv_return = (IV)GL_MAX_TEXTURE_SIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MULTISAMPLE_3DFX", 19)) {
    /*                             ^           */
#ifdef GL_MULTISAMPLE_3DFX
      *iv_return = (IV)GL_MULTISAMPLE_3DFX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MULTISAMPLE_SGIS", 19)) {
    /*                             ^           */
#ifdef GL_MULTISAMPLE_SGIS
      *iv_return = (IV)GL_MULTISAMPLE_SGIS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OBJECT_LINE_SGIS", 19)) {
    /*                             ^           */
#ifdef GL_OBJECT_LINE_SGIS
      *iv_return = (IV)GL_OBJECT_LINE_SGIS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PACK_INVERT_MESA", 19)) {
    /*                             ^           */
#ifdef GL_PACK_INVERT_MESA
      *iv_return = (IV)GL_PACK_INVERT_MESA;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PIXEL_MAP_A_TO_A", 19)) {
    /*                             ^           */
#ifdef GL_PIXEL_MAP_A_TO_A
      *iv_return = (IV)GL_PIXEL_MAP_A_TO_A;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PIXEL_MAP_B_TO_B", 19)) {
    /*                             ^           */
#ifdef GL_PIXEL_MAP_B_TO_B
      *iv_return = (IV)GL_PIXEL_MAP_B_TO_B;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PIXEL_MAP_G_TO_G", 19)) {
    /*                             ^           */
#ifdef GL_PIXEL_MAP_G_TO_G
      *iv_return = (IV)GL_PIXEL_MAP_G_TO_G;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PIXEL_MAP_I_TO_A", 19)) {
    /*                             ^           */
#ifdef GL_PIXEL_MAP_I_TO_A
      *iv_return = (IV)GL_PIXEL_MAP_I_TO_A;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PIXEL_MAP_I_TO_B", 19)) {
    /*                             ^           */
#ifdef GL_PIXEL_MAP_I_TO_B
      *iv_return = (IV)GL_PIXEL_MAP_I_TO_B;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PIXEL_MAP_I_TO_G", 19)) {
    /*                             ^           */
#ifdef GL_PIXEL_MAP_I_TO_G
      *iv_return = (IV)GL_PIXEL_MAP_I_TO_G;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PIXEL_MAP_I_TO_I", 19)) {
    /*                             ^           */
#ifdef GL_PIXEL_MAP_I_TO_I
      *iv_return = (IV)GL_PIXEL_MAP_I_TO_I;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PIXEL_MAP_I_TO_R", 19)) {
    /*                             ^           */
#ifdef GL_PIXEL_MAP_I_TO_R
      *iv_return = (IV)GL_PIXEL_MAP_I_TO_R;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PIXEL_MAP_R_TO_R", 19)) {
    /*                             ^           */
#ifdef GL_PIXEL_MAP_R_TO_R
      *iv_return = (IV)GL_PIXEL_MAP_R_TO_R;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PIXEL_MAP_S_TO_S", 19)) {
    /*                             ^           */
#ifdef GL_PIXEL_MAP_S_TO_S
      *iv_return = (IV)GL_PIXEL_MAP_S_TO_S;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_READ_PIXELS_TYPE", 19)) {
    /*                             ^           */
#ifdef GL_READ_PIXELS_TYPE
      *iv_return = (IV)GL_READ_PIXELS_TYPE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGBA_SIGNED_SGIX", 19)) {
    /*                             ^           */
#ifdef GL_RGBA_SIGNED_SGIX
      *iv_return = (IV)GL_RGBA_SIGNED_SGIX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLE_MASK_SGIS", 19)) {
    /*                             ^           */
#ifdef GL_SAMPLE_MASK_SGIS
      *iv_return = (IV)GL_SAMPLE_MASK_SGIS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_ENV_MODE", 19)) {
    /*                             ^           */
#ifdef GL_TEXTURE_ENV_MODE
      *iv_return = (IV)GL_TEXTURE_ENV_MODE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_GEN_MODE", 19)) {
    /*                             ^           */
#ifdef GL_TEXTURE_GEN_MODE
      *iv_return = (IV)GL_TEXTURE_GEN_MODE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_LOD_BIAS", 19)) {
    /*                             ^           */
#ifdef GL_TEXTURE_LOD_BIAS
      *iv_return = (IV)GL_TEXTURE_LOD_BIAS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_RED_SIZE", 19)) {
    /*                             ^           */
#ifdef GL_TEXTURE_RED_SIZE
      *iv_return = (IV)GL_TEXTURE_RED_SIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_RED_TYPE", 19)) {
    /*                             ^           */
#ifdef GL_TEXTURE_RED_TYPE
      *iv_return = (IV)GL_TEXTURE_RED_TYPE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNPACK_SKIP_ROWS", 19)) {
    /*                             ^           */
#ifdef GL_UNPACK_SKIP_ROWS
      *iv_return = (IV)GL_UNPACK_SKIP_ROWS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'a':
    if (memEQ(name, "GLEW_NV_gpu_shader5", 19)) {
    /*                             ^           */
#ifdef GLEW_NV_gpu_shader5
      *iv_return = (IV)GLEW_NV_gpu_shader5;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_SUN_mesh_array", 19)) {
    /*                             ^           */
#ifdef GLEW_SUN_mesh_array
      *iv_return = (IV)GLEW_SUN_mesh_array;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_3DFX_multisample", 19)) {
    /*                             ^           */
#ifdef GL_3DFX_multisample
      *iv_return = (IV)GL_3DFX_multisample;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_debug_marker", 19)) {
    /*                             ^           */
#ifdef GL_EXT_debug_marker
      *iv_return = (IV)GL_EXT_debug_marker;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_scene_marker", 19)) {
    /*                             ^           */
#ifdef GL_EXT_scene_marker
      *iv_return = (IV)GL_EXT_scene_marker;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_vertex_array", 19)) {
    /*                             ^           */
#ifdef GL_EXT_vertex_array
      *iv_return = (IV)GL_EXT_vertex_array;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SGIS_multisample", 19)) {
    /*                             ^           */
#ifdef GL_SGIS_multisample
      *iv_return = (IV)GL_SGIS_multisample;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SGI_color_matrix", 19)) {
    /*                             ^           */
#ifdef GL_SGI_color_matrix
      *iv_return = (IV)GL_SGI_color_matrix;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SUN_global_alpha", 19)) {
    /*                             ^           */
#ifdef GL_SUN_global_alpha
      *iv_return = (IV)GL_SUN_global_alpha;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'b':
    if (memEQ(name, "GL_ARB_vertex_blend", 19)) {
    /*                             ^           */
#ifdef GL_ARB_vertex_blend
      *iv_return = (IV)GL_ARB_vertex_blend;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'c':
    if (memEQ(name, "GLEW_NV_depth_clamp", 19)) {
    /*                             ^           */
#ifdef GLEW_NV_depth_clamp
      *iv_return = (IV)GLEW_NV_depth_clamp;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_shader_clock", 19)) {
    /*                             ^           */
#ifdef GL_ARB_shader_clock
      *iv_return = (IV)GL_ARB_shader_clock;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INGR_color_clamp", 19)) {
    /*                             ^           */
#ifdef GL_INGR_color_clamp
      *iv_return = (IV)GL_INGR_color_clamp;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'e':
    if (memEQ(name, "GLEW_SGIX_framezoom", 19)) {
    /*                             ^           */
#ifdef GLEW_SGIX_framezoom
      *iv_return = (IV)GLEW_SGIX_framezoom;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SGIS_texture_lod", 19)) {
    /*                             ^           */
#ifdef GL_SGIS_texture_lod
      *iv_return = (IV)GL_SGIS_texture_lod;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'f':
    if (memEQ(name, "GL_ARB_draw_buffers", 19)) {
    /*                             ^           */
#ifdef GL_ARB_draw_buffers
      *iv_return = (IV)GL_ARB_draw_buffers;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ATI_draw_buffers", 19)) {
    /*                             ^           */
#ifdef GL_ATI_draw_buffers
      *iv_return = (IV)GL_ATI_draw_buffers;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_packed_float", 19)) {
    /*                             ^           */
#ifdef GL_EXT_packed_float
      *iv_return = (IV)GL_EXT_packed_float;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_shadow_funcs", 19)) {
    /*                             ^           */
#ifdef GL_EXT_shadow_funcs
      *iv_return = (IV)GL_EXT_shadow_funcs;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'h':
    if (memEQ(name, "GLEW_AMD_gcn_shader", 19)) {
    /*                             ^           */
#ifdef GLEW_AMD_gcn_shader
      *iv_return = (IV)GLEW_AMD_gcn_shader;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_PGI_misc_hints", 19)) {
    /*                             ^           */
#ifdef GLEW_PGI_misc_hints
      *iv_return = (IV)GLEW_PGI_misc_hints;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PGI_vertex_hints", 19)) {
    /*                             ^           */
#ifdef GL_PGI_vertex_hints
      *iv_return = (IV)GL_PGI_vertex_hints;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'i':
    if (memEQ(name, "GLEW_ARB_copy_image", 19)) {
    /*                             ^           */
#ifdef GLEW_ARB_copy_image
      *iv_return = (IV)GLEW_ARB_copy_image;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_EXT_422_pixels", 19)) {
    /*                             ^           */
#ifdef GLEW_EXT_422_pixels
      *iv_return = (IV)GLEW_EXT_422_pixels;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_blend_minmax", 19)) {
    /*                             ^           */
#ifdef GL_EXT_blend_minmax
      *iv_return = (IV)GL_EXT_blend_minmax;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_gpu_multicast", 19)) {
    /*                             ^           */
#ifdef GL_NV_gpu_multicast
      *iv_return = (IV)GL_NV_gpu_multicast;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'm':
    if (memEQ(name, "GL_NV_texgen_emboss", 19)) {
    /*                             ^           */
#ifdef GL_NV_texgen_emboss
      *iv_return = (IV)GL_NV_texgen_emboss;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'n':
    if (memEQ(name, "GL_ARB_clip_control", 19)) {
    /*                             ^           */
#ifdef GL_ARB_clip_control
      *iv_return = (IV)GL_ARB_clip_control;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ATI_pn_triangles", 19)) {
    /*                             ^           */
#ifdef GL_ATI_pn_triangles
      *iv_return = (IV)GL_ATI_pn_triangles;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MESA_pack_invert", 19)) {
    /*                             ^           */
#ifdef GL_MESA_pack_invert
      *iv_return = (IV)GL_MESA_pack_invert;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'p':
    if (memEQ(name, "GL_ARB_point_sprite", 19)) {
    /*                             ^           */
#ifdef GL_ARB_point_sprite
      *iv_return = (IV)GL_ARB_point_sprite;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_video_capture", 19)) {
    /*                             ^           */
#ifdef GL_NV_video_capture
      *iv_return = (IV)GL_NV_video_capture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SGIX_async_pixel", 19)) {
    /*                             ^           */
#ifdef GL_SGIX_async_pixel
      *iv_return = (IV)GL_SGIX_async_pixel;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'r':
    if (memEQ(name, "GLEW_ARB_texture_rg", 19)) {
    /*                             ^           */
#ifdef GLEW_ARB_texture_rg
      *iv_return = (IV)GLEW_ARB_texture_rg;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_SGIX_interlace", 19)) {
    /*                             ^           */
#ifdef GLEW_SGIX_interlace
      *iv_return = (IV)GLEW_SGIX_interlace;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SGIS_color_range", 19)) {
    /*                             ^           */
#ifdef GL_SGIS_color_range
      *iv_return = (IV)GL_SGIS_color_range;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_WIN_specular_fog", 19)) {
    /*                             ^           */
#ifdef GL_WIN_specular_fog
      *iv_return = (IV)GL_WIN_specular_fog;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 't':
    if (memEQ(name, "GLEW_ARB_robustness", 19)) {
    /*                             ^           */
#ifdef GLEW_ARB_robustness
      *iv_return = (IV)GLEW_ARB_robustness;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_KHR_robustness", 19)) {
    /*                             ^           */
#ifdef GLEW_KHR_robustness
      *iv_return = (IV)GLEW_KHR_robustness;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_vdpau_interop", 19)) {
    /*                             ^           */
#ifdef GL_NV_vdpau_interop
      *iv_return = (IV)GL_NV_vdpau_interop;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'u':
    if (memEQ(name, "GLEW_SGIS_texture4D", 19)) {
    /*                             ^           */
#ifdef GLEW_SGIS_texture4D
      *iv_return = (IV)GLEW_SGIS_texture4D;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_AMD_debug_output", 19)) {
    /*                             ^           */
#ifdef GL_AMD_debug_output
      *iv_return = (IV)GL_AMD_debug_output;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_debug_output", 19)) {
    /*                             ^           */
#ifdef GL_ARB_debug_output
      *iv_return = (IV)GL_ARB_debug_output;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'v':
    if (memEQ(name, "GLEW_OVR_multiview2", 19)) {
    /*                             ^           */
#ifdef GLEW_OVR_multiview2
      *iv_return = (IV)GLEW_OVR_multiview2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_present_video", 19)) {
    /*                             ^           */
#ifdef GL_NV_present_video
      *iv_return = (IV)GL_NV_present_video;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'w':
    if (memEQ(name, "GLEW_ARB_window_pos", 19)) {
    /*                             ^           */
#ifdef GLEW_ARB_window_pos
      *iv_return = (IV)GLEW_ARB_window_pos;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'x':
    if (memEQ(name, "GLEW_EXT_subtexture", 19)) {
    /*                             ^           */
#ifdef GLEW_EXT_subtexture
      *iv_return = (IV)GLEW_EXT_subtexture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_multitexture", 19)) {
    /*                             ^           */
#ifdef GL_ARB_multitexture
      *iv_return = (IV)GL_ARB_multitexture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_copy_texture", 19)) {
    /*                             ^           */
#ifdef GL_EXT_copy_texture
      *iv_return = (IV)GL_EXT_copy_texture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SGIX_fog_texture", 19)) {
    /*                             ^           */
#ifdef GL_SGIX_fog_texture
      *iv_return = (IV)GL_SGIX_fog_texture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  }
  return PERL_constant_NOTFOUND;
}

static int
constant_20 (pTHX_ const char *name, IV *iv_return) {
  /* When generated this function returned values for the list of names given
     here.  However, subsequent manual editing may have added or removed some.
     GLEW_APPLE_row_bytes GLEW_APPLE_ycbcr_422 GLEW_ARB_copy_buffer
     GLEW_ARB_depth_clamp GLEW_ARB_gpu_shader5 GLEW_ARB_multisample
     GLEW_ARB_timer_query GLEW_EXT_blend_color GLEW_EXT_convolution
     GLEW_EXT_cull_vertex GLEW_EXT_debug_label GLEW_EXT_gpu_shader4
     GLEW_EXT_multisample GLEW_EXT_texture_env GLEW_EXT_timer_query
     GLEW_IBM_cull_vertex GLEW_IBM_static_data GLEW_MESA_window_pos
     GLEW_NV_blend_square GLEW_NV_command_list GLEW_NV_draw_texture
     GLEW_NV_float_buffer GLEW_NV_fog_distance GLEW_NV_gpu_program4
     GLEW_NV_gpu_program5 GLEW_NV_point_sprite GLEW_OES_read_format
     GLEW_SGIX_fog_offset GLEW_SGI_color_table GLEW_SUN_slice_accum
     GL_ACCUM_CLEAR_VALUE GL_ACTIVE_ATTRIBUTES GL_ADJACENT_PAIRS_NV
     GL_ALPHA_FLOAT16_ATI GL_ALPHA_FLOAT32_ATI GL_ALPHA_INTEGER_EXT
     GL_ALPHA_SIGNED_SGIX GL_AMD_pinned_memory GL_ANGLE_timer_query
     GL_ARB_base_instance GL_ARB_clear_texture GL_ARB_compatibility
     GL_ARB_cull_distance GL_ARB_depth_texture GL_ARB_draw_indirect
     GL_ARB_shader_ballot GL_ARB_sparse_buffer GL_ARB_texture_float
     GL_ARB_vertex_shader GL_ASYNC_MARKER_SGIX GL_ATI_element_array
     GL_ATI_texture_float GL_BLEND_DST_RGB_EXT GL_BLEND_SRC_RGB_EXT
     GL_BUFFER_ACCESS_ARB GL_BUFFER_MAPPED_ARB GL_BUFFER_MAP_LENGTH
     GL_BUFFER_MAP_OFFSET GL_BUFFER_OBJECT_EXT GL_CLAMP_TO_EDGE_EXT
     GL_CLIP_FAR_HINT_PGI GL_COLOR_ATTACHMENT0 GL_COLOR_ATTACHMENT1
     GL_COLOR_ATTACHMENT2 GL_COLOR_ATTACHMENT3 GL_COLOR_ATTACHMENT4
     GL_COLOR_ATTACHMENT5 GL_COLOR_ATTACHMENT6 GL_COLOR_ATTACHMENT7
     GL_COLOR_ATTACHMENT8 GL_COLOR_ATTACHMENT9 GL_COLOR_CLEAR_VALUE
     GL_COLOR_FLOAT_APPLE GL_COLOR_INDEX12_EXT GL_COLOR_INDEX16_EXT
     GL_COLOR_TABLE_SCALE GL_COLOR_TABLE_WIDTH GL_COMBINER_INPUT_NV
     GL_COMBINER_SCALE_NV GL_COMBINE_ALPHA_ARB GL_COMBINE_ALPHA_EXT
     GL_CONIC_CURVE_TO_NV GL_CONVOLUTION_WIDTH GL_COORD_REPLACE_ARB
     GL_COPY_WRITE_BUFFER GL_COUNTER_RANGE_AMD GL_CUBIC_CURVE_TO_NV
     GL_CURRENT_ATTRIB_NV GL_CURRENT_FOG_COORD GL_CURRENT_MATRIX_NV
     GL_CURRENT_QUERY_ARB GL_DEBUG_TYPE_MARKER GL_DEPTH32F_STENCIL8
     GL_DEPTH_CLEAR_VALUE GL_DEPTH_COMPONENT16 GL_DEPTH_COMPONENT24
     GL_DEPTH_COMPONENT32 GL_DEPTH_STENCIL_EXT GL_DOUBLE_MAT2x3_EXT
     GL_DOUBLE_MAT2x4_EXT GL_DOUBLE_MAT3x2_EXT GL_DOUBLE_MAT3x4_EXT
     GL_DOUBLE_MAT4x2_EXT GL_DOUBLE_MAT4x3_EXT GL_DRAW_BUFFER10_ARB
     GL_DRAW_BUFFER10_ATI GL_DRAW_BUFFER11_ARB GL_DRAW_BUFFER11_ATI
     GL_DRAW_BUFFER12_ARB GL_DRAW_BUFFER12_ATI GL_DRAW_BUFFER13_ARB
     GL_DRAW_BUFFER13_ATI GL_DRAW_BUFFER14_ARB GL_DRAW_BUFFER14_ATI
     GL_DRAW_BUFFER15_ARB GL_DRAW_BUFFER15_ATI GL_DRAW_PIXELS_APPLE
     GL_ELEMENT_ARRAY_ATI GL_EXT_draw_buffers2 GL_EXT_index_texture
     GL_EXT_light_texture GL_EXT_packed_pixels GL_EXT_texture_array
     GL_EXT_texture_snorm GL_EXT_vertex_shader GL_FILL_RECTANGLE_NV
     GL_FRAGMENT_INPUT_NV GL_FRAMEBUFFER_BLEND GL_FUNC_SUBTRACT_EXT
     GL_GENERIC_ATTRIB_NV GL_GREEN_INTEGER_EXT GL_HP_occlusion_test
     GL_HSL_LUMINOSITY_NV GL_HSL_SATURATION_NV GL_IMAGE_2D_RECT_EXT
     GL_IMAGE_CLASS_1_X_8 GL_IMAGE_CLASS_2_X_8 GL_IMAGE_CLASS_4_X_8
     GL_INDEX_CLEAR_VALUE GL_INTEL_map_texture GL_INTENSITY16UI_EXT
     GL_INTENSITY16_SNORM GL_INTENSITY32UI_EXT GL_INT_IMAGE_2D_RECT
     GL_INVALID_OPERATION GL_KTX_buffer_region GL_LOG_WARNING_REGAL
     GL_LUMINANCE16UI_EXT GL_LUMINANCE16_SNORM GL_LUMINANCE32UI_EXT
     GL_LUMINANCE4_ALPHA4 GL_LUMINANCE6_ALPHA2 GL_LUMINANCE8_ALPHA8
     GL_MAGNITUDE_BIAS_NV GL_MAP1_BINORMAL_EXT GL_MAP2_BINORMAL_EXT
     GL_MAX_ELEMENT_INDEX GL_MAX_IMAGE_SAMPLES GL_MAX_LGPU_GPUS_NVX
     GL_MAX_SAMPLES_ANGLE GL_MAX_TEXTURE_UNITS GL_MAX_VIEWPORT_DIMS
     GL_MINMAX_FORMAT_EXT GL_MITER_TRUNCATE_NV GL_MODULATE_ADD_ATIX
     GL_MOVE_TO_RESETS_NV GL_MULTICAST_GPUS_NV GL_NORMAL_ARRAY_TYPE
     GL_NUM_SAMPLE_COUNTS GL_NV_deep_texture3D GL_NV_fill_rectangle
     GL_NV_path_rendering GL_NV_texture_shader GL_NV_vertex_program
     GL_OBJECT_POINT_SGIS GL_OPERAND3_ALPHA_NV GL_OP_EXP_BASE_2_EXT
     GL_OP_LOG_BASE_2_EXT GL_OP_RECIP_SQRT_EXT GL_OUTPUT_COLOR0_EXT
     GL_OUTPUT_COLOR1_EXT GL_OUTPUT_VERTEX_EXT GL_PACK_IMAGE_HEIGHT
     GL_PACK_RESAMPLE_OML GL_PALETTE4_RGB8_OES GL_PALETTE8_RGB8_OES
     GL_PATH_DASH_CAPS_NV GL_PATH_FILL_MASK_NV GL_PATH_FILL_MODE_NV
     GL_PATH_FORMAT_PS_NV GL_PATH_GEN_COEFF_NV GL_PIXEL_PACK_BUFFER
     GL_POINT_SMOOTH_HINT GL_PRIMARY_COLOR_ARB GL_PRIMARY_COLOR_EXT
     GL_PRIMITIVE_RESTART GL_PROGRAM_LENGTH_NV GL_PROGRAM_SEPARABLE
     GL_PROGRAM_STRING_NV GL_PROGRAM_TARGET_NV GL_PROJECTION_MATRIX
     GL_PROXY_COLOR_TABLE GL_R1UI_C4UB_V3F_SUN GL_REFLECTION_MAP_NV
     GL_REPLACE_VALUE_AMD GL_RGB16_SIGNED_SGIX GL_RGB_FLOAT16_APPLE
     GL_RGB_FLOAT32_APPLE GL_RGB_RAW_422_APPLE GL_SAMPLER_1D_SHADOW
     GL_SAMPLER_2D_SHADOW GL_SAMPLE_MASK_VALUE GL_SGIS_fog_function
     GL_SGIX_flush_raster GL_SHADER_IMAGE_LOAD GL_SHADER_OBJECT_ARB
     GL_SHADER_OBJECT_EXT GL_SIGNED_NORMALIZED GL_SOURCE0_ALPHA_ARB
     GL_SOURCE0_ALPHA_EXT GL_SOURCE1_ALPHA_ARB GL_SOURCE1_ALPHA_EXT
     GL_SOURCE2_ALPHA_ARB GL_SOURCE2_ALPHA_EXT GL_SPIR_V_BINARY_ARB
     GL_STENCIL_BACK_FAIL GL_STENCIL_BACK_FUNC GL_STENCIL_WRITEMASK
     GL_SUN_triangle_list GL_SURFACE_MAPPED_NV GL_SYNC_CL_EVENT_ARB
     GL_TANGENT_ARRAY_EXT GL_TEXCOORD1_BIT_PGI GL_TEXCOORD2_BIT_PGI
     GL_TEXCOORD3_BIT_PGI GL_TEXCOORD4_BIT_PGI GL_TEXTURE_BLUE_SIZE
     GL_TEXTURE_BLUE_TYPE GL_TEXTURE_DEPTH_EXT GL_TEXTURE_ENV_COLOR
     GL_TEXTURE_LIGHT_EXT GL_TEXTURE_MAX_LEVEL GL_TEXTURE_RECTANGLE
     GL_TEXTURE_SHADER_NV GL_TEXTURE_SWIZZLE_A GL_TEXTURE_SWIZZLE_B
     GL_TEXTURE_SWIZZLE_G GL_TEXTURE_SWIZZLE_R GL_TRIANGLE_LIST_SUN
     GL_TRIANGLE_MESH_SUN GL_UNPACK_ROW_LENGTH GL_UNPACK_SWAP_BYTES
     GL_UNSIGNED_INT16_NV GL_UNSIGNED_INT64_NV GL_UNSIGNED_INT_24_8
     GL_UNSIGNED_INT_VEC2 GL_UNSIGNED_INT_VEC3 GL_UNSIGNED_INT_VEC4
     GL_VARIANT_ARRAY_EXT GL_VARIANT_VALUE_EXT GL_VERTEX_ARRAY_SIZE
     GL_VERTEX_ARRAY_TYPE GL_VERTEX_PROGRAM_NV GL_VERTEX_SHADER_ARB
     GL_VERTEX_SHADER_BIT GL_VERTEX_SHADER_EXT GL_VERTEX_SOURCE_ATI
     GL_VERTEX_SUBROUTINE GL_VIBRANCE_SCALE_NV GL_VIEW_CLASS_8_BITS
     GL_WIN_phong_shading GL_YCBAYCR8A_4224_NV */
  /* Offset 15 gives the best switch position.  */
  switch (name[15]) {
  case '0':
    if (memEQ(name, "GL_DRAW_BUFFER10_ARB", 20)) {
    /*                              ^           */
#ifdef GL_DRAW_BUFFER10_ARB
      *iv_return = (IV)GL_DRAW_BUFFER10_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRAW_BUFFER10_ATI", 20)) {
    /*                              ^           */
#ifdef GL_DRAW_BUFFER10_ATI
      *iv_return = (IV)GL_DRAW_BUFFER10_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OUTPUT_COLOR0_EXT", 20)) {
    /*                              ^           */
#ifdef GL_OUTPUT_COLOR0_EXT
      *iv_return = (IV)GL_OUTPUT_COLOR0_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '1':
    if (memEQ(name, "GL_DRAW_BUFFER11_ARB", 20)) {
    /*                              ^           */
#ifdef GL_DRAW_BUFFER11_ARB
      *iv_return = (IV)GL_DRAW_BUFFER11_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRAW_BUFFER11_ATI", 20)) {
    /*                              ^           */
#ifdef GL_DRAW_BUFFER11_ATI
      *iv_return = (IV)GL_DRAW_BUFFER11_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_IMAGE_CLASS_1_X_8", 20)) {
    /*                              ^           */
#ifdef GL_IMAGE_CLASS_1_X_8
      *iv_return = (IV)GL_IMAGE_CLASS_1_X_8;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OUTPUT_COLOR1_EXT", 20)) {
    /*                              ^           */
#ifdef GL_OUTPUT_COLOR1_EXT
      *iv_return = (IV)GL_OUTPUT_COLOR1_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNSIGNED_INT16_NV", 20)) {
    /*                              ^           */
#ifdef GL_UNSIGNED_INT16_NV
      *iv_return = (IV)GL_UNSIGNED_INT16_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '2':
    if (memEQ(name, "GL_ALPHA_FLOAT32_ATI", 20)) {
    /*                              ^           */
#ifdef GL_ALPHA_FLOAT32_ATI
      *iv_return = (IV)GL_ALPHA_FLOAT32_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_INDEX12_EXT", 20)) {
    /*                              ^           */
#ifdef GL_COLOR_INDEX12_EXT
      *iv_return = (IV)GL_COLOR_INDEX12_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DOUBLE_MAT3x2_EXT", 20)) {
    /*                              ^           */
#ifdef GL_DOUBLE_MAT3x2_EXT
      *iv_return = (IV)GL_DOUBLE_MAT3x2_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DOUBLE_MAT4x2_EXT", 20)) {
    /*                              ^           */
#ifdef GL_DOUBLE_MAT4x2_EXT
      *iv_return = (IV)GL_DOUBLE_MAT4x2_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRAW_BUFFER12_ARB", 20)) {
    /*                              ^           */
#ifdef GL_DRAW_BUFFER12_ARB
      *iv_return = (IV)GL_DRAW_BUFFER12_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRAW_BUFFER12_ATI", 20)) {
    /*                              ^           */
#ifdef GL_DRAW_BUFFER12_ATI
      *iv_return = (IV)GL_DRAW_BUFFER12_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_IMAGE_CLASS_2_X_8", 20)) {
    /*                              ^           */
#ifdef GL_IMAGE_CLASS_2_X_8
      *iv_return = (IV)GL_IMAGE_CLASS_2_X_8;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OP_EXP_BASE_2_EXT", 20)) {
    /*                              ^           */
#ifdef GL_OP_EXP_BASE_2_EXT
      *iv_return = (IV)GL_OP_EXP_BASE_2_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OP_LOG_BASE_2_EXT", 20)) {
    /*                              ^           */
#ifdef GL_OP_LOG_BASE_2_EXT
      *iv_return = (IV)GL_OP_LOG_BASE_2_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_YCBAYCR8A_4224_NV", 20)) {
    /*                              ^           */
#ifdef GL_YCBAYCR8A_4224_NV
      *iv_return = (IV)GL_YCBAYCR8A_4224_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '3':
    if (memEQ(name, "GL_DOUBLE_MAT2x3_EXT", 20)) {
    /*                              ^           */
#ifdef GL_DOUBLE_MAT2x3_EXT
      *iv_return = (IV)GL_DOUBLE_MAT2x3_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DOUBLE_MAT4x3_EXT", 20)) {
    /*                              ^           */
#ifdef GL_DOUBLE_MAT4x3_EXT
      *iv_return = (IV)GL_DOUBLE_MAT4x3_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRAW_BUFFER13_ARB", 20)) {
    /*                              ^           */
#ifdef GL_DRAW_BUFFER13_ARB
      *iv_return = (IV)GL_DRAW_BUFFER13_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRAW_BUFFER13_ATI", 20)) {
    /*                              ^           */
#ifdef GL_DRAW_BUFFER13_ATI
      *iv_return = (IV)GL_DRAW_BUFFER13_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '4':
    if (memEQ(name, "GL_DOUBLE_MAT2x4_EXT", 20)) {
    /*                              ^           */
#ifdef GL_DOUBLE_MAT2x4_EXT
      *iv_return = (IV)GL_DOUBLE_MAT2x4_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DOUBLE_MAT3x4_EXT", 20)) {
    /*                              ^           */
#ifdef GL_DOUBLE_MAT3x4_EXT
      *iv_return = (IV)GL_DOUBLE_MAT3x4_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRAW_BUFFER14_ARB", 20)) {
    /*                              ^           */
#ifdef GL_DRAW_BUFFER14_ARB
      *iv_return = (IV)GL_DRAW_BUFFER14_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRAW_BUFFER14_ATI", 20)) {
    /*                              ^           */
#ifdef GL_DRAW_BUFFER14_ATI
      *iv_return = (IV)GL_DRAW_BUFFER14_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_IMAGE_CLASS_4_X_8", 20)) {
    /*                              ^           */
#ifdef GL_IMAGE_CLASS_4_X_8
      *iv_return = (IV)GL_IMAGE_CLASS_4_X_8;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '5':
    if (memEQ(name, "GL_DRAW_BUFFER15_ARB", 20)) {
    /*                              ^           */
#ifdef GL_DRAW_BUFFER15_ARB
      *iv_return = (IV)GL_DRAW_BUFFER15_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRAW_BUFFER15_ATI", 20)) {
    /*                              ^           */
#ifdef GL_DRAW_BUFFER15_ATI
      *iv_return = (IV)GL_DRAW_BUFFER15_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '6':
    if (memEQ(name, "GL_ALPHA_FLOAT16_ATI", 20)) {
    /*                              ^           */
#ifdef GL_ALPHA_FLOAT16_ATI
      *iv_return = (IV)GL_ALPHA_FLOAT16_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_INDEX16_EXT", 20)) {
    /*                              ^           */
#ifdef GL_COLOR_INDEX16_EXT
      *iv_return = (IV)GL_COLOR_INDEX16_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNSIGNED_INT64_NV", 20)) {
    /*                              ^           */
#ifdef GL_UNSIGNED_INT64_NV
      *iv_return = (IV)GL_UNSIGNED_INT64_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '8':
    if (memEQ(name, "GL_PALETTE4_RGB8_OES", 20)) {
    /*                              ^           */
#ifdef GL_PALETTE4_RGB8_OES
      *iv_return = (IV)GL_PALETTE4_RGB8_OES;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PALETTE8_RGB8_OES", 20)) {
    /*                              ^           */
#ifdef GL_PALETTE8_RGB8_OES
      *iv_return = (IV)GL_PALETTE8_RGB8_OES;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'A':
    if (memEQ(name, "GL_COLOR_FLOAT_APPLE", 20)) {
    /*                              ^           */
#ifdef GL_COLOR_FLOAT_APPLE
      *iv_return = (IV)GL_COLOR_FLOAT_APPLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COMBINE_ALPHA_ARB", 20)) {
    /*                              ^           */
#ifdef GL_COMBINE_ALPHA_ARB
      *iv_return = (IV)GL_COMBINE_ALPHA_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COMBINE_ALPHA_EXT", 20)) {
    /*                              ^           */
#ifdef GL_COMBINE_ALPHA_EXT
      *iv_return = (IV)GL_COMBINE_ALPHA_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEBUG_TYPE_MARKER", 20)) {
    /*                              ^           */
#ifdef GL_DEBUG_TYPE_MARKER
      *iv_return = (IV)GL_DEBUG_TYPE_MARKER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRAW_PIXELS_APPLE", 20)) {
    /*                              ^           */
#ifdef GL_DRAW_PIXELS_APPLE
      *iv_return = (IV)GL_DRAW_PIXELS_APPLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INVALID_OPERATION", 20)) {
    /*                              ^           */
#ifdef GL_INVALID_OPERATION
      *iv_return = (IV)GL_INVALID_OPERATION;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAGNITUDE_BIAS_NV", 20)) {
    /*                              ^           */
#ifdef GL_MAGNITUDE_BIAS_NV
      *iv_return = (IV)GL_MAGNITUDE_BIAS_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_SAMPLES_ANGLE", 20)) {
    /*                              ^           */
#ifdef GL_MAX_SAMPLES_ANGLE
      *iv_return = (IV)GL_MAX_SAMPLES_ANGLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PROJECTION_MATRIX", 20)) {
    /*                              ^           */
#ifdef GL_PROJECTION_MATRIX
      *iv_return = (IV)GL_PROJECTION_MATRIX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_REFLECTION_MAP_NV", 20)) {
    /*                              ^           */
#ifdef GL_REFLECTION_MAP_NV
      *iv_return = (IV)GL_REFLECTION_MAP_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGB_FLOAT16_APPLE", 20)) {
    /*                              ^           */
#ifdef GL_RGB_FLOAT16_APPLE
      *iv_return = (IV)GL_RGB_FLOAT16_APPLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGB_FLOAT32_APPLE", 20)) {
    /*                              ^           */
#ifdef GL_RGB_FLOAT32_APPLE
      *iv_return = (IV)GL_RGB_FLOAT32_APPLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGB_RAW_422_APPLE", 20)) {
    /*                              ^           */
#ifdef GL_RGB_RAW_422_APPLE
      *iv_return = (IV)GL_RGB_RAW_422_APPLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SOURCE0_ALPHA_ARB", 20)) {
    /*                              ^           */
#ifdef GL_SOURCE0_ALPHA_ARB
      *iv_return = (IV)GL_SOURCE0_ALPHA_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SOURCE0_ALPHA_EXT", 20)) {
    /*                              ^           */
#ifdef GL_SOURCE0_ALPHA_EXT
      *iv_return = (IV)GL_SOURCE0_ALPHA_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SOURCE1_ALPHA_ARB", 20)) {
    /*                              ^           */
#ifdef GL_SOURCE1_ALPHA_ARB
      *iv_return = (IV)GL_SOURCE1_ALPHA_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SOURCE1_ALPHA_EXT", 20)) {
    /*                              ^           */
#ifdef GL_SOURCE1_ALPHA_EXT
      *iv_return = (IV)GL_SOURCE1_ALPHA_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SOURCE2_ALPHA_ARB", 20)) {
    /*                              ^           */
#ifdef GL_SOURCE2_ALPHA_ARB
      *iv_return = (IV)GL_SOURCE2_ALPHA_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SOURCE2_ALPHA_EXT", 20)) {
    /*                              ^           */
#ifdef GL_SOURCE2_ALPHA_EXT
      *iv_return = (IV)GL_SOURCE2_ALPHA_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_RECTANGLE", 20)) {
    /*                              ^           */
#ifdef GL_TEXTURE_RECTANGLE
      *iv_return = (IV)GL_TEXTURE_RECTANGLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERTEX_PROGRAM_NV", 20)) {
    /*                              ^           */
#ifdef GL_VERTEX_PROGRAM_NV
      *iv_return = (IV)GL_VERTEX_PROGRAM_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'B':
    if (memEQ(name, "GL_ACTIVE_ATTRIBUTES", 20)) {
    /*                              ^           */
#ifdef GL_ACTIVE_ATTRIBUTES
      *iv_return = (IV)GL_ACTIVE_ATTRIBUTES;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_BLEND_DST_RGB_EXT", 20)) {
    /*                              ^           */
#ifdef GL_BLEND_DST_RGB_EXT
      *iv_return = (IV)GL_BLEND_DST_RGB_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_BLEND_SRC_RGB_EXT", 20)) {
    /*                              ^           */
#ifdef GL_BLEND_SRC_RGB_EXT
      *iv_return = (IV)GL_BLEND_SRC_RGB_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FRAMEBUFFER_BLEND", 20)) {
    /*                              ^           */
#ifdef GL_FRAMEBUFFER_BLEND
      *iv_return = (IV)GL_FRAMEBUFFER_BLEND;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNPACK_SWAP_BYTES", 20)) {
    /*                              ^           */
#ifdef GL_UNPACK_SWAP_BYTES
      *iv_return = (IV)GL_UNPACK_SWAP_BYTES;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'C':
    if (memEQ(name, "GL_CURRENT_FOG_COORD", 20)) {
    /*                              ^           */
#ifdef GL_CURRENT_FOG_COORD
      *iv_return = (IV)GL_CURRENT_FOG_COORD;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_ENV_COLOR", 20)) {
    /*                              ^           */
#ifdef GL_TEXTURE_ENV_COLOR
      *iv_return = (IV)GL_TEXTURE_ENV_COLOR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'D':
    if (memEQ(name, "GL_BUFFER_MAPPED_ARB", 20)) {
    /*                              ^           */
#ifdef GL_BUFFER_MAPPED_ARB
      *iv_return = (IV)GL_BUFFER_MAPPED_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PATH_FILL_MODE_NV", 20)) {
    /*                              ^           */
#ifdef GL_PATH_FILL_MODE_NV
      *iv_return = (IV)GL_PATH_FILL_MODE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'E':
    if (memEQ(name, "GL_BUFFER_MAP_LENGTH", 20)) {
    /*                              ^           */
#ifdef GL_BUFFER_MAP_LENGTH
      *iv_return = (IV)GL_BUFFER_MAP_LENGTH;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CLAMP_TO_EDGE_EXT", 20)) {
    /*                              ^           */
#ifdef GL_CLAMP_TO_EDGE_EXT
      *iv_return = (IV)GL_CLAMP_TO_EDGE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COORD_REPLACE_ARB", 20)) {
    /*                              ^           */
#ifdef GL_COORD_REPLACE_ARB
      *iv_return = (IV)GL_COORD_REPLACE_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COUNTER_RANGE_AMD", 20)) {
    /*                              ^           */
#ifdef GL_COUNTER_RANGE_AMD
      *iv_return = (IV)GL_COUNTER_RANGE_AMD;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEPTH_COMPONENT16", 20)) {
    /*                              ^           */
#ifdef GL_DEPTH_COMPONENT16
      *iv_return = (IV)GL_DEPTH_COMPONENT16;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEPTH_COMPONENT24", 20)) {
    /*                              ^           */
#ifdef GL_DEPTH_COMPONENT24
      *iv_return = (IV)GL_DEPTH_COMPONENT24;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEPTH_COMPONENT32", 20)) {
    /*                              ^           */
#ifdef GL_DEPTH_COMPONENT32
      *iv_return = (IV)GL_DEPTH_COMPONENT32;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PACK_IMAGE_HEIGHT", 20)) {
    /*                              ^           */
#ifdef GL_PACK_IMAGE_HEIGHT
      *iv_return = (IV)GL_PACK_IMAGE_HEIGHT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PACK_RESAMPLE_OML", 20)) {
    /*                              ^           */
#ifdef GL_PACK_RESAMPLE_OML
      *iv_return = (IV)GL_PACK_RESAMPLE_OML;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PROGRAM_TARGET_NV", 20)) {
    /*                              ^           */
#ifdef GL_PROGRAM_TARGET_NV
      *iv_return = (IV)GL_PROGRAM_TARGET_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_REPLACE_VALUE_AMD", 20)) {
    /*                              ^           */
#ifdef GL_REPLACE_VALUE_AMD
      *iv_return = (IV)GL_REPLACE_VALUE_AMD;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STENCIL_WRITEMASK", 20)) {
    /*                              ^           */
#ifdef GL_STENCIL_WRITEMASK
      *iv_return = (IV)GL_STENCIL_WRITEMASK;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SURFACE_MAPPED_NV", 20)) {
    /*                              ^           */
#ifdef GL_SURFACE_MAPPED_NV
      *iv_return = (IV)GL_SURFACE_MAPPED_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_SHADER_NV", 20)) {
    /*                              ^           */
#ifdef GL_TEXTURE_SHADER_NV
      *iv_return = (IV)GL_TEXTURE_SHADER_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNPACK_ROW_LENGTH", 20)) {
    /*                              ^           */
#ifdef GL_UNPACK_ROW_LENGTH
      *iv_return = (IV)GL_UNPACK_ROW_LENGTH;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VARIANT_VALUE_EXT", 20)) {
    /*                              ^           */
#ifdef GL_VARIANT_VALUE_EXT
      *iv_return = (IV)GL_VARIANT_VALUE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERTEX_SOURCE_ATI", 20)) {
    /*                              ^           */
#ifdef GL_VERTEX_SOURCE_ATI
      *iv_return = (IV)GL_VERTEX_SOURCE_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'F':
    if (memEQ(name, "GL_BUFFER_MAP_OFFSET", 20)) {
    /*                              ^           */
#ifdef GL_BUFFER_MAP_OFFSET
      *iv_return = (IV)GL_BUFFER_MAP_OFFSET;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PATH_GEN_COEFF_NV", 20)) {
    /*                              ^           */
#ifdef GL_PATH_GEN_COEFF_NV
      *iv_return = (IV)GL_PATH_GEN_COEFF_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_R1UI_C4UB_V3F_SUN", 20)) {
    /*                              ^           */
#ifdef GL_R1UI_C4UB_V3F_SUN
      *iv_return = (IV)GL_R1UI_C4UB_V3F_SUN;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'H':
    if (memEQ(name, "GL_OPERAND3_ALPHA_NV", 20)) {
    /*                              ^           */
#ifdef GL_OPERAND3_ALPHA_NV
      *iv_return = (IV)GL_OPERAND3_ALPHA_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLER_1D_SHADOW", 20)) {
    /*                              ^           */
#ifdef GL_SAMPLER_1D_SHADOW
      *iv_return = (IV)GL_SAMPLER_1D_SHADOW;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLER_2D_SHADOW", 20)) {
    /*                              ^           */
#ifdef GL_SAMPLER_2D_SHADOW
      *iv_return = (IV)GL_SAMPLER_2D_SHADOW;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_DEPTH_EXT", 20)) {
    /*                              ^           */
#ifdef GL_TEXTURE_DEPTH_EXT
      *iv_return = (IV)GL_TEXTURE_DEPTH_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TRIANGLE_MESH_SUN", 20)) {
    /*                              ^           */
#ifdef GL_TRIANGLE_MESH_SUN
      *iv_return = (IV)GL_TRIANGLE_MESH_SUN;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'I':
    if (memEQ(name, "GL_CURRENT_ATTRIB_NV", 20)) {
    /*                              ^           */
#ifdef GL_CURRENT_ATTRIB_NV
      *iv_return = (IV)GL_CURRENT_ATTRIB_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CURRENT_MATRIX_NV", 20)) {
    /*                              ^           */
#ifdef GL_CURRENT_MATRIX_NV
      *iv_return = (IV)GL_CURRENT_MATRIX_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_GENERIC_ATTRIB_NV", 20)) {
    /*                              ^           */
#ifdef GL_GENERIC_ATTRIB_NV
      *iv_return = (IV)GL_GENERIC_ATTRIB_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INTENSITY16UI_EXT", 20)) {
    /*                              ^           */
#ifdef GL_INTENSITY16UI_EXT
      *iv_return = (IV)GL_INTENSITY16UI_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INTENSITY32UI_EXT", 20)) {
    /*                              ^           */
#ifdef GL_INTENSITY32UI_EXT
      *iv_return = (IV)GL_INTENSITY32UI_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LUMINANCE16UI_EXT", 20)) {
    /*                              ^           */
#ifdef GL_LUMINANCE16UI_EXT
      *iv_return = (IV)GL_LUMINANCE16UI_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LUMINANCE32UI_EXT", 20)) {
    /*                              ^           */
#ifdef GL_LUMINANCE32UI_EXT
      *iv_return = (IV)GL_LUMINANCE32UI_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_ELEMENT_INDEX", 20)) {
    /*                              ^           */
#ifdef GL_MAX_ELEMENT_INDEX
      *iv_return = (IV)GL_MAX_ELEMENT_INDEX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'L':
    if (memEQ(name, "GL_COMBINER_SCALE_NV", 20)) {
    /*                              ^           */
#ifdef GL_COMBINER_SCALE_NV
      *iv_return = (IV)GL_COMBINER_SCALE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEPTH_STENCIL_EXT", 20)) {
    /*                              ^           */
#ifdef GL_DEPTH_STENCIL_EXT
      *iv_return = (IV)GL_DEPTH_STENCIL_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FILL_RECTANGLE_NV", 20)) {
    /*                              ^           */
#ifdef GL_FILL_RECTANGLE_NV
      *iv_return = (IV)GL_FILL_RECTANGLE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LUMINANCE4_ALPHA4", 20)) {
    /*                              ^           */
#ifdef GL_LUMINANCE4_ALPHA4
      *iv_return = (IV)GL_LUMINANCE4_ALPHA4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LUMINANCE6_ALPHA2", 20)) {
    /*                              ^           */
#ifdef GL_LUMINANCE6_ALPHA2
      *iv_return = (IV)GL_LUMINANCE6_ALPHA2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LUMINANCE8_ALPHA8", 20)) {
    /*                              ^           */
#ifdef GL_LUMINANCE8_ALPHA8
      *iv_return = (IV)GL_LUMINANCE8_ALPHA8;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAP1_BINORMAL_EXT", 20)) {
    /*                              ^           */
#ifdef GL_MAP1_BINORMAL_EXT
      *iv_return = (IV)GL_MAP1_BINORMAL_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAP2_BINORMAL_EXT", 20)) {
    /*                              ^           */
#ifdef GL_MAP2_BINORMAL_EXT
      *iv_return = (IV)GL_MAP2_BINORMAL_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SIGNED_NORMALIZED", 20)) {
    /*                              ^           */
#ifdef GL_SIGNED_NORMALIZED
      *iv_return = (IV)GL_SIGNED_NORMALIZED;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_MAX_LEVEL", 20)) {
    /*                              ^           */
#ifdef GL_TEXTURE_MAX_LEVEL
      *iv_return = (IV)GL_TEXTURE_MAX_LEVEL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VIBRANCE_SCALE_NV", 20)) {
    /*                              ^           */
#ifdef GL_VIBRANCE_SCALE_NV
      *iv_return = (IV)GL_VIBRANCE_SCALE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'M':
    if (memEQ(name, "GL_COLOR_ATTACHMENT0", 20)) {
    /*                              ^           */
#ifdef GL_COLOR_ATTACHMENT0
      *iv_return = (IV)GL_COLOR_ATTACHMENT0;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_ATTACHMENT1", 20)) {
    /*                              ^           */
#ifdef GL_COLOR_ATTACHMENT1
      *iv_return = (IV)GL_COLOR_ATTACHMENT1;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_ATTACHMENT2", 20)) {
    /*                              ^           */
#ifdef GL_COLOR_ATTACHMENT2
      *iv_return = (IV)GL_COLOR_ATTACHMENT2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_ATTACHMENT3", 20)) {
    /*                              ^           */
#ifdef GL_COLOR_ATTACHMENT3
      *iv_return = (IV)GL_COLOR_ATTACHMENT3;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_ATTACHMENT4", 20)) {
    /*                              ^           */
#ifdef GL_COLOR_ATTACHMENT4
      *iv_return = (IV)GL_COLOR_ATTACHMENT4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_ATTACHMENT5", 20)) {
    /*                              ^           */
#ifdef GL_COLOR_ATTACHMENT5
      *iv_return = (IV)GL_COLOR_ATTACHMENT5;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_ATTACHMENT6", 20)) {
    /*                              ^           */
#ifdef GL_COLOR_ATTACHMENT6
      *iv_return = (IV)GL_COLOR_ATTACHMENT6;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_ATTACHMENT7", 20)) {
    /*                              ^           */
#ifdef GL_COLOR_ATTACHMENT7
      *iv_return = (IV)GL_COLOR_ATTACHMENT7;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_ATTACHMENT8", 20)) {
    /*                              ^           */
#ifdef GL_COLOR_ATTACHMENT8
      *iv_return = (IV)GL_COLOR_ATTACHMENT8;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_ATTACHMENT9", 20)) {
    /*                              ^           */
#ifdef GL_COLOR_ATTACHMENT9
      *iv_return = (IV)GL_COLOR_ATTACHMENT9;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_IMAGE_SAMPLES", 20)) {
    /*                              ^           */
#ifdef GL_MAX_IMAGE_SAMPLES
      *iv_return = (IV)GL_MAX_IMAGE_SAMPLES;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'N':
    if (memEQ(name, "GL_DEPTH32F_STENCIL8", 20)) {
    /*                              ^           */
#ifdef GL_DEPTH32F_STENCIL8
      *iv_return = (IV)GL_DEPTH32F_STENCIL8;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PROGRAM_STRING_NV", 20)) {
    /*                              ^           */
#ifdef GL_PROGRAM_STRING_NV
      *iv_return = (IV)GL_PROGRAM_STRING_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'O':
    if (memEQ(name, "GL_HSL_SATURATION_NV", 20)) {
    /*                              ^           */
#ifdef GL_HSL_SATURATION_NV
      *iv_return = (IV)GL_HSL_SATURATION_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NUM_SAMPLE_COUNTS", 20)) {
    /*                              ^           */
#ifdef GL_NUM_SAMPLE_COUNTS
      *iv_return = (IV)GL_NUM_SAMPLE_COUNTS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'P':
    if (memEQ(name, "GL_PATH_DASH_CAPS_NV", 20)) {
    /*                              ^           */
#ifdef GL_PATH_DASH_CAPS_NV
      *iv_return = (IV)GL_PATH_DASH_CAPS_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PATH_FORMAT_PS_NV", 20)) {
    /*                              ^           */
#ifdef GL_PATH_FORMAT_PS_NV
      *iv_return = (IV)GL_PATH_FORMAT_PS_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'R':
    if (memEQ(name, "GL_ADJACENT_PAIRS_NV", 20)) {
    /*                              ^           */
#ifdef GL_ADJACENT_PAIRS_NV
      *iv_return = (IV)GL_ADJACENT_PAIRS_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ALPHA_INTEGER_EXT", 20)) {
    /*                              ^           */
#ifdef GL_ALPHA_INTEGER_EXT
      *iv_return = (IV)GL_ALPHA_INTEGER_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_GREEN_INTEGER_EXT", 20)) {
    /*                              ^           */
#ifdef GL_GREEN_INTEGER_EXT
      *iv_return = (IV)GL_GREEN_INTEGER_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LOG_WARNING_REGAL", 20)) {
    /*                              ^           */
#ifdef GL_LOG_WARNING_REGAL
      *iv_return = (IV)GL_LOG_WARNING_REGAL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PRIMARY_COLOR_ARB", 20)) {
    /*                              ^           */
#ifdef GL_PRIMARY_COLOR_ARB
      *iv_return = (IV)GL_PRIMARY_COLOR_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PRIMARY_COLOR_EXT", 20)) {
    /*                              ^           */
#ifdef GL_PRIMARY_COLOR_EXT
      *iv_return = (IV)GL_PRIMARY_COLOR_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PROGRAM_SEPARABLE", 20)) {
    /*                              ^           */
#ifdef GL_PROGRAM_SEPARABLE
      *iv_return = (IV)GL_PROGRAM_SEPARABLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERTEX_SHADER_ARB", 20)) {
    /*                              ^           */
#ifdef GL_VERTEX_SHADER_ARB
      *iv_return = (IV)GL_VERTEX_SHADER_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERTEX_SHADER_BIT", 20)) {
    /*                              ^           */
#ifdef GL_VERTEX_SHADER_BIT
      *iv_return = (IV)GL_VERTEX_SHADER_BIT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERTEX_SHADER_EXT", 20)) {
    /*                              ^           */
#ifdef GL_VERTEX_SHADER_EXT
      *iv_return = (IV)GL_VERTEX_SHADER_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'S':
    if (memEQ(name, "GL_BUFFER_ACCESS_ARB", 20)) {
    /*                              ^           */
#ifdef GL_BUFFER_ACCESS_ARB
      *iv_return = (IV)GL_BUFFER_ACCESS_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_TABLE_SCALE", 20)) {
    /*                              ^           */
#ifdef GL_COLOR_TABLE_SCALE
      *iv_return = (IV)GL_COLOR_TABLE_SCALE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INTENSITY16_SNORM", 20)) {
    /*                              ^           */
#ifdef GL_INTENSITY16_SNORM
      *iv_return = (IV)GL_INTENSITY16_SNORM;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LUMINANCE16_SNORM", 20)) {
    /*                              ^           */
#ifdef GL_LUMINANCE16_SNORM
      *iv_return = (IV)GL_LUMINANCE16_SNORM;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_LGPU_GPUS_NVX", 20)) {
    /*                              ^           */
#ifdef GL_MAX_LGPU_GPUS_NVX
      *iv_return = (IV)GL_MAX_LGPU_GPUS_NVX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PATH_FILL_MASK_NV", 20)) {
    /*                              ^           */
#ifdef GL_PATH_FILL_MASK_NV
      *iv_return = (IV)GL_PATH_FILL_MASK_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PRIMITIVE_RESTART", 20)) {
    /*                              ^           */
#ifdef GL_PRIMITIVE_RESTART
      *iv_return = (IV)GL_PRIMITIVE_RESTART;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'T':
    if (memEQ(name, "GL_BUFFER_OBJECT_EXT", 20)) {
    /*                              ^           */
#ifdef GL_BUFFER_OBJECT_EXT
      *iv_return = (IV)GL_BUFFER_OBJECT_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CLIP_FAR_HINT_PGI", 20)) {
    /*                              ^           */
#ifdef GL_CLIP_FAR_HINT_PGI
      *iv_return = (IV)GL_CLIP_FAR_HINT_PGI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CONIC_CURVE_TO_NV", 20)) {
    /*                              ^           */
#ifdef GL_CONIC_CURVE_TO_NV
      *iv_return = (IV)GL_CONIC_CURVE_TO_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CUBIC_CURVE_TO_NV", 20)) {
    /*                              ^           */
#ifdef GL_CUBIC_CURVE_TO_NV
      *iv_return = (IV)GL_CUBIC_CURVE_TO_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FUNC_SUBTRACT_EXT", 20)) {
    /*                              ^           */
#ifdef GL_FUNC_SUBTRACT_EXT
      *iv_return = (IV)GL_FUNC_SUBTRACT_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_HSL_LUMINOSITY_NV", 20)) {
    /*                              ^           */
#ifdef GL_HSL_LUMINOSITY_NV
      *iv_return = (IV)GL_HSL_LUMINOSITY_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_IMAGE_2D_RECT_EXT", 20)) {
    /*                              ^           */
#ifdef GL_IMAGE_2D_RECT_EXT
      *iv_return = (IV)GL_IMAGE_2D_RECT_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MINMAX_FORMAT_EXT", 20)) {
    /*                              ^           */
#ifdef GL_MINMAX_FORMAT_EXT
      *iv_return = (IV)GL_MINMAX_FORMAT_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MITER_TRUNCATE_NV", 20)) {
    /*                              ^           */
#ifdef GL_MITER_TRUNCATE_NV
      *iv_return = (IV)GL_MITER_TRUNCATE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MOVE_TO_RESETS_NV", 20)) {
    /*                              ^           */
#ifdef GL_MOVE_TO_RESETS_NV
      *iv_return = (IV)GL_MOVE_TO_RESETS_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OP_RECIP_SQRT_EXT", 20)) {
    /*                              ^           */
#ifdef GL_OP_RECIP_SQRT_EXT
      *iv_return = (IV)GL_OP_RECIP_SQRT_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PROGRAM_LENGTH_NV", 20)) {
    /*                              ^           */
#ifdef GL_PROGRAM_LENGTH_NV
      *iv_return = (IV)GL_PROGRAM_LENGTH_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PROXY_COLOR_TABLE", 20)) {
    /*                              ^           */
#ifdef GL_PROXY_COLOR_TABLE
      *iv_return = (IV)GL_PROXY_COLOR_TABLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SHADER_OBJECT_ARB", 20)) {
    /*                              ^           */
#ifdef GL_SHADER_OBJECT_ARB
      *iv_return = (IV)GL_SHADER_OBJECT_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SHADER_OBJECT_EXT", 20)) {
    /*                              ^           */
#ifdef GL_SHADER_OBJECT_EXT
      *iv_return = (IV)GL_SHADER_OBJECT_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SYNC_CL_EVENT_ARB", 20)) {
    /*                              ^           */
#ifdef GL_SYNC_CL_EVENT_ARB
      *iv_return = (IV)GL_SYNC_CL_EVENT_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXCOORD1_BIT_PGI", 20)) {
    /*                              ^           */
#ifdef GL_TEXCOORD1_BIT_PGI
      *iv_return = (IV)GL_TEXCOORD1_BIT_PGI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXCOORD2_BIT_PGI", 20)) {
    /*                              ^           */
#ifdef GL_TEXCOORD2_BIT_PGI
      *iv_return = (IV)GL_TEXCOORD2_BIT_PGI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXCOORD3_BIT_PGI", 20)) {
    /*                              ^           */
#ifdef GL_TEXCOORD3_BIT_PGI
      *iv_return = (IV)GL_TEXCOORD3_BIT_PGI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXCOORD4_BIT_PGI", 20)) {
    /*                              ^           */
#ifdef GL_TEXCOORD4_BIT_PGI
      *iv_return = (IV)GL_TEXCOORD4_BIT_PGI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_LIGHT_EXT", 20)) {
    /*                              ^           */
#ifdef GL_TEXTURE_LIGHT_EXT
      *iv_return = (IV)GL_TEXTURE_LIGHT_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TRIANGLE_LIST_SUN", 20)) {
    /*                              ^           */
#ifdef GL_TRIANGLE_LIST_SUN
      *iv_return = (IV)GL_TRIANGLE_LIST_SUN;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'U':
    if (memEQ(name, "GL_COMBINER_INPUT_NV", 20)) {
    /*                              ^           */
#ifdef GL_COMBINER_INPUT_NV
      *iv_return = (IV)GL_COMBINER_INPUT_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COPY_WRITE_BUFFER", 20)) {
    /*                              ^           */
#ifdef GL_COPY_WRITE_BUFFER
      *iv_return = (IV)GL_COPY_WRITE_BUFFER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FRAGMENT_INPUT_NV", 20)) {
    /*                              ^           */
#ifdef GL_FRAGMENT_INPUT_NV
      *iv_return = (IV)GL_FRAGMENT_INPUT_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_TEXTURE_UNITS", 20)) {
    /*                              ^           */
#ifdef GL_MAX_TEXTURE_UNITS
      *iv_return = (IV)GL_MAX_TEXTURE_UNITS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MULTICAST_GPUS_NV", 20)) {
    /*                              ^           */
#ifdef GL_MULTICAST_GPUS_NV
      *iv_return = (IV)GL_MULTICAST_GPUS_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PIXEL_PACK_BUFFER", 20)) {
    /*                              ^           */
#ifdef GL_PIXEL_PACK_BUFFER
      *iv_return = (IV)GL_PIXEL_PACK_BUFFER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERTEX_SUBROUTINE", 20)) {
    /*                              ^           */
#ifdef GL_VERTEX_SUBROUTINE
      *iv_return = (IV)GL_VERTEX_SUBROUTINE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'V':
    if (memEQ(name, "GL_ACCUM_CLEAR_VALUE", 20)) {
    /*                              ^           */
#ifdef GL_ACCUM_CLEAR_VALUE
      *iv_return = (IV)GL_ACCUM_CLEAR_VALUE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_CLEAR_VALUE", 20)) {
    /*                              ^           */
#ifdef GL_COLOR_CLEAR_VALUE
      *iv_return = (IV)GL_COLOR_CLEAR_VALUE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEPTH_CLEAR_VALUE", 20)) {
    /*                              ^           */
#ifdef GL_DEPTH_CLEAR_VALUE
      *iv_return = (IV)GL_DEPTH_CLEAR_VALUE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INDEX_CLEAR_VALUE", 20)) {
    /*                              ^           */
#ifdef GL_INDEX_CLEAR_VALUE
      *iv_return = (IV)GL_INDEX_CLEAR_VALUE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLE_MASK_VALUE", 20)) {
    /*                              ^           */
#ifdef GL_SAMPLE_MASK_VALUE
      *iv_return = (IV)GL_SAMPLE_MASK_VALUE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'W':
    if (memEQ(name, "GL_COLOR_TABLE_WIDTH", 20)) {
    /*                              ^           */
#ifdef GL_COLOR_TABLE_WIDTH
      *iv_return = (IV)GL_COLOR_TABLE_WIDTH;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CONVOLUTION_WIDTH", 20)) {
    /*                              ^           */
#ifdef GL_CONVOLUTION_WIDTH
      *iv_return = (IV)GL_CONVOLUTION_WIDTH;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'X':
    if (memEQ(name, "GL_OUTPUT_VERTEX_EXT", 20)) {
    /*                              ^           */
#ifdef GL_OUTPUT_VERTEX_EXT
      *iv_return = (IV)GL_OUTPUT_VERTEX_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'Y':
    if (memEQ(name, "GL_CURRENT_QUERY_ARB", 20)) {
    /*                              ^           */
#ifdef GL_CURRENT_QUERY_ARB
      *iv_return = (IV)GL_CURRENT_QUERY_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ELEMENT_ARRAY_ATI", 20)) {
    /*                              ^           */
#ifdef GL_ELEMENT_ARRAY_ATI
      *iv_return = (IV)GL_ELEMENT_ARRAY_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SPIR_V_BINARY_ARB", 20)) {
    /*                              ^           */
#ifdef GL_SPIR_V_BINARY_ARB
      *iv_return = (IV)GL_SPIR_V_BINARY_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TANGENT_ARRAY_EXT", 20)) {
    /*                              ^           */
#ifdef GL_TANGENT_ARRAY_EXT
      *iv_return = (IV)GL_TANGENT_ARRAY_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VARIANT_ARRAY_EXT", 20)) {
    /*                              ^           */
#ifdef GL_VARIANT_ARRAY_EXT
      *iv_return = (IV)GL_VARIANT_ARRAY_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'Z':
    if (memEQ(name, "GL_TEXTURE_SWIZZLE_A", 20)) {
    /*                              ^           */
#ifdef GL_TEXTURE_SWIZZLE_A
      *iv_return = (IV)GL_TEXTURE_SWIZZLE_A;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_SWIZZLE_B", 20)) {
    /*                              ^           */
#ifdef GL_TEXTURE_SWIZZLE_B
      *iv_return = (IV)GL_TEXTURE_SWIZZLE_B;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_SWIZZLE_G", 20)) {
    /*                              ^           */
#ifdef GL_TEXTURE_SWIZZLE_G
      *iv_return = (IV)GL_TEXTURE_SWIZZLE_G;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_SWIZZLE_R", 20)) {
    /*                              ^           */
#ifdef GL_TEXTURE_SWIZZLE_R
      *iv_return = (IV)GL_TEXTURE_SWIZZLE_R;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '_':
    if (memEQ(name, "GLEW_IBM_static_data", 20)) {
    /*                              ^           */
#ifdef GLEW_IBM_static_data
      *iv_return = (IV)GLEW_IBM_static_data;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_NV_command_list", 20)) {
    /*                              ^           */
#ifdef GLEW_NV_command_list
      *iv_return = (IV)GLEW_NV_command_list;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ALPHA_SIGNED_SGIX", 20)) {
    /*                              ^           */
#ifdef GL_ALPHA_SIGNED_SGIX
      *iv_return = (IV)GL_ALPHA_SIGNED_SGIX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ASYNC_MARKER_SGIX", 20)) {
    /*                              ^           */
#ifdef GL_ASYNC_MARKER_SGIX
      *iv_return = (IV)GL_ASYNC_MARKER_SGIX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_HP_occlusion_test", 20)) {
    /*                              ^           */
#ifdef GL_HP_occlusion_test
      *iv_return = (IV)GL_HP_occlusion_test;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INT_IMAGE_2D_RECT", 20)) {
    /*                              ^           */
#ifdef GL_INT_IMAGE_2D_RECT
      *iv_return = (IV)GL_INT_IMAGE_2D_RECT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_VIEWPORT_DIMS", 20)) {
    /*                              ^           */
#ifdef GL_MAX_VIEWPORT_DIMS
      *iv_return = (IV)GL_MAX_VIEWPORT_DIMS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MODULATE_ADD_ATIX", 20)) {
    /*                              ^           */
#ifdef GL_MODULATE_ADD_ATIX
      *iv_return = (IV)GL_MODULATE_ADD_ATIX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NORMAL_ARRAY_TYPE", 20)) {
    /*                              ^           */
#ifdef GL_NORMAL_ARRAY_TYPE
      *iv_return = (IV)GL_NORMAL_ARRAY_TYPE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OBJECT_POINT_SGIS", 20)) {
    /*                              ^           */
#ifdef GL_OBJECT_POINT_SGIS
      *iv_return = (IV)GL_OBJECT_POINT_SGIS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_POINT_SMOOTH_HINT", 20)) {
    /*                              ^           */
#ifdef GL_POINT_SMOOTH_HINT
      *iv_return = (IV)GL_POINT_SMOOTH_HINT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGB16_SIGNED_SGIX", 20)) {
    /*                              ^           */
#ifdef GL_RGB16_SIGNED_SGIX
      *iv_return = (IV)GL_RGB16_SIGNED_SGIX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SHADER_IMAGE_LOAD", 20)) {
    /*                              ^           */
#ifdef GL_SHADER_IMAGE_LOAD
      *iv_return = (IV)GL_SHADER_IMAGE_LOAD;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STENCIL_BACK_FAIL", 20)) {
    /*                              ^           */
#ifdef GL_STENCIL_BACK_FAIL
      *iv_return = (IV)GL_STENCIL_BACK_FAIL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STENCIL_BACK_FUNC", 20)) {
    /*                              ^           */
#ifdef GL_STENCIL_BACK_FUNC
      *iv_return = (IV)GL_STENCIL_BACK_FUNC;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SUN_triangle_list", 20)) {
    /*                              ^           */
#ifdef GL_SUN_triangle_list
      *iv_return = (IV)GL_SUN_triangle_list;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_BLUE_SIZE", 20)) {
    /*                              ^           */
#ifdef GL_TEXTURE_BLUE_SIZE
      *iv_return = (IV)GL_TEXTURE_BLUE_SIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_BLUE_TYPE", 20)) {
    /*                              ^           */
#ifdef GL_TEXTURE_BLUE_TYPE
      *iv_return = (IV)GL_TEXTURE_BLUE_TYPE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNSIGNED_INT_24_8", 20)) {
    /*                              ^           */
#ifdef GL_UNSIGNED_INT_24_8
      *iv_return = (IV)GL_UNSIGNED_INT_24_8;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNSIGNED_INT_VEC2", 20)) {
    /*                              ^           */
#ifdef GL_UNSIGNED_INT_VEC2
      *iv_return = (IV)GL_UNSIGNED_INT_VEC2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNSIGNED_INT_VEC3", 20)) {
    /*                              ^           */
#ifdef GL_UNSIGNED_INT_VEC3
      *iv_return = (IV)GL_UNSIGNED_INT_VEC3;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNSIGNED_INT_VEC4", 20)) {
    /*                              ^           */
#ifdef GL_UNSIGNED_INT_VEC4
      *iv_return = (IV)GL_UNSIGNED_INT_VEC4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERTEX_ARRAY_SIZE", 20)) {
    /*                              ^           */
#ifdef GL_VERTEX_ARRAY_SIZE
      *iv_return = (IV)GL_VERTEX_ARRAY_SIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERTEX_ARRAY_TYPE", 20)) {
    /*                              ^           */
#ifdef GL_VERTEX_ARRAY_TYPE
      *iv_return = (IV)GL_VERTEX_ARRAY_TYPE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VIEW_CLASS_8_BITS", 20)) {
    /*                              ^           */
#ifdef GL_VIEW_CLASS_8_BITS
      *iv_return = (IV)GL_VIEW_CLASS_8_BITS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'a':
    if (memEQ(name, "GLEW_ARB_gpu_shader5", 20)) {
    /*                              ^           */
#ifdef GLEW_ARB_gpu_shader5
      *iv_return = (IV)GLEW_ARB_gpu_shader5;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_ARB_multisample", 20)) {
    /*                              ^           */
#ifdef GLEW_ARB_multisample
      *iv_return = (IV)GLEW_ARB_multisample;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_EXT_gpu_shader4", 20)) {
    /*                              ^           */
#ifdef GLEW_EXT_gpu_shader4
      *iv_return = (IV)GLEW_EXT_gpu_shader4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_EXT_multisample", 20)) {
    /*                              ^           */
#ifdef GLEW_EXT_multisample
      *iv_return = (IV)GLEW_EXT_multisample;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_SUN_slice_accum", 20)) {
    /*                              ^           */
#ifdef GLEW_SUN_slice_accum
      *iv_return = (IV)GLEW_SUN_slice_accum;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_shader_ballot", 20)) {
    /*                              ^           */
#ifdef GL_ARB_shader_ballot
      *iv_return = (IV)GL_ARB_shader_ballot;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ATI_element_array", 20)) {
    /*                              ^           */
#ifdef GL_ATI_element_array
      *iv_return = (IV)GL_ATI_element_array;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_texture_array", 20)) {
    /*                              ^           */
#ifdef GL_EXT_texture_array
      *iv_return = (IV)GL_EXT_texture_array;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_fill_rectangle", 20)) {
    /*                              ^           */
#ifdef GL_NV_fill_rectangle
      *iv_return = (IV)GL_NV_fill_rectangle;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SGIX_flush_raster", 20)) {
    /*                              ^           */
#ifdef GL_SGIX_flush_raster
      *iv_return = (IV)GL_SGIX_flush_raster;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_WIN_phong_shading", 20)) {
    /*                              ^           */
#ifdef GL_WIN_phong_shading
      *iv_return = (IV)GL_WIN_phong_shading;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'b':
    if (memEQ(name, "GLEW_APPLE_row_bytes", 20)) {
    /*                              ^           */
#ifdef GLEW_APPLE_row_bytes
      *iv_return = (IV)GLEW_APPLE_row_bytes;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'c':
    if (memEQ(name, "GLEW_ARB_depth_clamp", 20)) {
    /*                              ^           */
#ifdef GLEW_ARB_depth_clamp
      *iv_return = (IV)GLEW_ARB_depth_clamp;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_EXT_blend_color", 20)) {
    /*                              ^           */
#ifdef GLEW_EXT_blend_color
      *iv_return = (IV)GLEW_EXT_blend_color;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SGIS_fog_function", 20)) {
    /*                              ^           */
#ifdef GL_SGIS_fog_function
      *iv_return = (IV)GL_SGIS_fog_function;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'e':
    if (memEQ(name, "GLEW_EXT_cull_vertex", 20)) {
    /*                              ^           */
#ifdef GLEW_EXT_cull_vertex
      *iv_return = (IV)GLEW_EXT_cull_vertex;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_EXT_texture_env", 20)) {
    /*                              ^           */
#ifdef GLEW_EXT_texture_env
      *iv_return = (IV)GLEW_EXT_texture_env;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_IBM_cull_vertex", 20)) {
    /*                              ^           */
#ifdef GLEW_IBM_cull_vertex
      *iv_return = (IV)GLEW_IBM_cull_vertex;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_AMD_pinned_memory", 20)) {
    /*                              ^           */
#ifdef GL_AMD_pinned_memory
      *iv_return = (IV)GL_AMD_pinned_memory;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_KTX_buffer_region", 20)) {
    /*                              ^           */
#ifdef GL_KTX_buffer_region
      *iv_return = (IV)GL_KTX_buffer_region;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_path_rendering", 20)) {
    /*                              ^           */
#ifdef GL_NV_path_rendering
      *iv_return = (IV)GL_NV_path_rendering;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'f':
    if (memEQ(name, "GLEW_SGIX_fog_offset", 20)) {
    /*                              ^           */
#ifdef GLEW_SGIX_fog_offset
      *iv_return = (IV)GLEW_SGIX_fog_offset;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_texture_float", 20)) {
    /*                              ^           */
#ifdef GL_ARB_texture_float
      *iv_return = (IV)GL_ARB_texture_float;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ATI_texture_float", 20)) {
    /*                              ^           */
#ifdef GL_ATI_texture_float
      *iv_return = (IV)GL_ATI_texture_float;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_draw_buffers2", 20)) {
    /*                              ^           */
#ifdef GL_EXT_draw_buffers2
      *iv_return = (IV)GL_EXT_draw_buffers2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'g':
    if (memEQ(name, "GLEW_NV_gpu_program4", 20)) {
    /*                              ^           */
#ifdef GLEW_NV_gpu_program4
      *iv_return = (IV)GLEW_NV_gpu_program4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_NV_gpu_program5", 20)) {
    /*                              ^           */
#ifdef GLEW_NV_gpu_program5
      *iv_return = (IV)GLEW_NV_gpu_program5;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'h':
    if (memEQ(name, "GL_ARB_vertex_shader", 20)) {
    /*                              ^           */
#ifdef GL_ARB_vertex_shader
      *iv_return = (IV)GL_ARB_vertex_shader;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_vertex_shader", 20)) {
    /*                              ^           */
#ifdef GL_EXT_vertex_shader
      *iv_return = (IV)GL_EXT_vertex_shader;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_texture_shader", 20)) {
    /*                              ^           */
#ifdef GL_NV_texture_shader
      *iv_return = (IV)GL_NV_texture_shader;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'i':
    if (memEQ(name, "GL_ARB_compatibility", 20)) {
    /*                              ^           */
#ifdef GL_ARB_compatibility
      *iv_return = (IV)GL_ARB_compatibility;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_draw_indirect", 20)) {
    /*                              ^           */
#ifdef GL_ARB_draw_indirect
      *iv_return = (IV)GL_ARB_draw_indirect;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_packed_pixels", 20)) {
    /*                              ^           */
#ifdef GL_EXT_packed_pixels
      *iv_return = (IV)GL_EXT_packed_pixels;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'l':
    if (memEQ(name, "GLEW_EXT_debug_label", 20)) {
    /*                              ^           */
#ifdef GLEW_EXT_debug_label
      *iv_return = (IV)GLEW_EXT_debug_label;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'o':
    if (memEQ(name, "GLEW_OES_read_format", 20)) {
    /*                              ^           */
#ifdef GLEW_OES_read_format
      *iv_return = (IV)GLEW_OES_read_format;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_vertex_program", 20)) {
    /*                              ^           */
#ifdef GL_NV_vertex_program
      *iv_return = (IV)GL_NV_vertex_program;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'p':
    if (memEQ(name, "GLEW_NV_point_sprite", 20)) {
    /*                              ^           */
#ifdef GLEW_NV_point_sprite
      *iv_return = (IV)GLEW_NV_point_sprite;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'q':
    if (memEQ(name, "GLEW_ARB_timer_query", 20)) {
    /*                              ^           */
#ifdef GLEW_ARB_timer_query
      *iv_return = (IV)GLEW_ARB_timer_query;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_EXT_timer_query", 20)) {
    /*                              ^           */
#ifdef GLEW_EXT_timer_query
      *iv_return = (IV)GLEW_EXT_timer_query;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_NV_blend_square", 20)) {
    /*                              ^           */
#ifdef GLEW_NV_blend_square
      *iv_return = (IV)GLEW_NV_blend_square;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ANGLE_timer_query", 20)) {
    /*                              ^           */
#ifdef GL_ANGLE_timer_query
      *iv_return = (IV)GL_ANGLE_timer_query;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'r':
    if (memEQ(name, "GLEW_APPLE_ycbcr_422", 20)) {
    /*                              ^           */
#ifdef GLEW_APPLE_ycbcr_422
      *iv_return = (IV)GLEW_APPLE_ycbcr_422;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 's':
    if (memEQ(name, "GL_EXT_texture_snorm", 20)) {
    /*                              ^           */
#ifdef GL_EXT_texture_snorm
      *iv_return = (IV)GL_EXT_texture_snorm;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 't':
    if (memEQ(name, "GLEW_NV_fog_distance", 20)) {
    /*                              ^           */
#ifdef GLEW_NV_fog_distance
      *iv_return = (IV)GLEW_NV_fog_distance;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_SGI_color_table", 20)) {
    /*                              ^           */
#ifdef GLEW_SGI_color_table
      *iv_return = (IV)GLEW_SGI_color_table;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_base_instance", 20)) {
    /*                              ^           */
#ifdef GL_ARB_base_instance
      *iv_return = (IV)GL_ARB_base_instance;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_cull_distance", 20)) {
    /*                              ^           */
#ifdef GL_ARB_cull_distance
      *iv_return = (IV)GL_ARB_cull_distance;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'u':
    if (memEQ(name, "GLEW_ARB_copy_buffer", 20)) {
    /*                              ^           */
#ifdef GLEW_ARB_copy_buffer
      *iv_return = (IV)GLEW_ARB_copy_buffer;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_EXT_convolution", 20)) {
    /*                              ^           */
#ifdef GLEW_EXT_convolution
      *iv_return = (IV)GLEW_EXT_convolution;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_NV_float_buffer", 20)) {
    /*                              ^           */
#ifdef GLEW_NV_float_buffer
      *iv_return = (IV)GLEW_NV_float_buffer;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_sparse_buffer", 20)) {
    /*                              ^           */
#ifdef GL_ARB_sparse_buffer
      *iv_return = (IV)GL_ARB_sparse_buffer;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_deep_texture3D", 20)) {
    /*                              ^           */
#ifdef GL_NV_deep_texture3D
      *iv_return = (IV)GL_NV_deep_texture3D;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'w':
    if (memEQ(name, "GLEW_MESA_window_pos", 20)) {
    /*                              ^           */
#ifdef GLEW_MESA_window_pos
      *iv_return = (IV)GLEW_MESA_window_pos;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'x':
    if (memEQ(name, "GLEW_NV_draw_texture", 20)) {
    /*                              ^           */
#ifdef GLEW_NV_draw_texture
      *iv_return = (IV)GLEW_NV_draw_texture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_clear_texture", 20)) {
    /*                              ^           */
#ifdef GL_ARB_clear_texture
      *iv_return = (IV)GL_ARB_clear_texture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_depth_texture", 20)) {
    /*                              ^           */
#ifdef GL_ARB_depth_texture
      *iv_return = (IV)GL_ARB_depth_texture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_index_texture", 20)) {
    /*                              ^           */
#ifdef GL_EXT_index_texture
      *iv_return = (IV)GL_EXT_index_texture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_light_texture", 20)) {
    /*                              ^           */
#ifdef GL_EXT_light_texture
      *iv_return = (IV)GL_EXT_light_texture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INTEL_map_texture", 20)) {
    /*                              ^           */
#ifdef GL_INTEL_map_texture
      *iv_return = (IV)GL_INTEL_map_texture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  }
  return PERL_constant_NOTFOUND;
}

static int
constant_21 (pTHX_ const char *name, IV *iv_return) {
  /* When generated this function returned values for the list of names given
     here.  However, subsequent manual editing may have added or removed some.
     GLEW_3DFX_multisample GLEW_AMD_debug_output GLEW_ARB_clip_control
     GLEW_ARB_debug_output GLEW_ARB_draw_buffers GLEW_ARB_multitexture
     GLEW_ARB_point_sprite GLEW_ARB_shader_clock GLEW_ARB_texture_view
     GLEW_ARB_vertex_blend GLEW_ATI_draw_buffers GLEW_ATI_pn_triangles
     GLEW_EXT_blend_minmax GLEW_EXT_copy_texture GLEW_EXT_debug_marker
     GLEW_EXT_packed_float GLEW_EXT_scene_marker GLEW_EXT_shadow_funcs
     GLEW_EXT_stencil_wrap GLEW_EXT_texture_sRGB GLEW_EXT_vertex_array
     GLEW_INGR_color_clamp GLEW_MESA_pack_invert GLEW_NV_gpu_multicast
     GLEW_NV_present_video GLEW_NV_texgen_emboss GLEW_NV_vdpau_interop
     GLEW_NV_video_capture GLEW_PGI_vertex_hints GLEW_SGIS_color_range
     GLEW_SGIS_multisample GLEW_SGIS_texture_lod GLEW_SGIX_async_pixel
     GLEW_SGIX_fog_texture GLEW_SGI_color_matrix GLEW_SUN_global_alpha
     GLEW_WIN_specular_fog GL_ACTIVE_PROGRAM_EXT GL_ACTIVE_SUBROUTINES
     GL_ACTIVE_TEXTURE_ARB GL_ACTIVE_VARYINGS_NV GL_AMD_sparse_texture
     GL_ANY_SAMPLES_PASSED GL_APPLE_float_pixels GL_APPLE_pixel_buffer
     GL_ARB_buffer_storage GL_ARB_compute_shader GL_ARB_draw_instanced
     GL_ARB_matrix_palette GL_ARB_sample_shading GL_ARB_shader_objects
     GL_ARB_shadow_ambient GL_ARB_sparse_texture GL_ARB_texture_gather
     GL_ARB_vertex_program GL_ARB_viewport_array GL_ATIX_point_sprites
     GL_ATI_envmap_bumpmap GL_ATI_vertex_streams GL_ATTRIB_STACK_DEPTH
     GL_BINORMAL_ARRAY_EXT GL_BLEND_EQUATION_EXT GL_BLEND_EQUATION_RGB
     GL_BUFFER_MAP_POINTER GL_BUMP_TEX_UNITS_ATI GL_CLAMP_TO_EDGE_SGIS
     GL_CLAMP_VERTEX_COLOR GL_CLIENT_STORAGE_BIT GL_CLIP_NEAR_HINT_PGI
     GL_COLOR_ARRAY_STRIDE GL_COLOR_ATTACHMENT10 GL_COLOR_ATTACHMENT11
     GL_COLOR_ATTACHMENT12 GL_COLOR_ATTACHMENT13 GL_COLOR_ATTACHMENT14
     GL_COLOR_ATTACHMENT15 GL_COLOR_SUM_CLAMP_NV GL_COLOR_TABLE_FORMAT
     GL_COMPRESSED_R11_EAC GL_COMPRESSED_RGB_ARB GL_COMPUTE_PROGRAM_NV
     GL_COMPUTE_SHADER_BIT GL_COMPUTE_SUBROUTINE GL_CONSTANT_ALPHA_EXT
     GL_CONSTANT_COLOR0_NV GL_CONSTANT_COLOR1_NV GL_CONSTANT_COLOR_EXT
     GL_CONVOLUTION_1D_EXT GL_CONVOLUTION_2D_EXT GL_CONVOLUTION_FORMAT
     GL_CONVOLUTION_HEIGHT GL_CURRENT_MATRIX_ARB GL_CURRENT_VERTEX_EXT
     GL_CURRENT_WEIGHT_ARB GL_DEBUG_SEVERITY_LOW GL_DEBUG_SOURCE_OTHER
     GL_DEPTH_COMPONENT32F GL_DEPTH_TEXTURE_MODE GL_EMBOSS_CONSTANT_NV
     GL_EXT_blend_logic_op GL_EXT_blend_subtract GL_EXT_color_subtable
     GL_EXT_draw_instanced GL_EXT_index_material GL_EXT_misc_attribute
     GL_EXT_polygon_offset GL_EXT_rescale_normal GL_EXT_texture_object
     GL_FENCE_CONDITION_NV GL_FLOAT_RGBA_MODE_NV GL_FOG_COORDINATE_EXT
     GL_FONT_HEIGHT_BIT_NV GL_FRAGMENT_COLOR_EXT GL_FRAGMENT_DEPTH_EXT
     GL_GLYPH_WIDTH_BIT_NV GL_HISTOGRAM_RED_SIZE GL_HISTOGRAM_SINK_EXT
     GL_HP_image_transform GL_HSL_LUMINOSITY_KHR GL_HSL_SATURATION_KHR
     GL_IBM_rasterpos_clip GL_IMAGE_1D_ARRAY_EXT GL_IMAGE_2D_ARRAY_EXT
     GL_IMAGE_BINDING_NAME GL_IMAGE_CLASS_1_X_16 GL_IMAGE_CLASS_1_X_32
     GL_IMAGE_CLASS_2_X_16 GL_IMAGE_CLASS_2_X_32 GL_IMAGE_CLASS_4_X_16
     GL_IMAGE_CLASS_4_X_32 GL_IMAGE_PIXEL_FORMAT GL_INDEX_ARRAY_STRIDE
     GL_INTERLACE_READ_OML GL_INT_2_10_10_10_REV GL_INT_IMAGE_1D_ARRAY
     GL_INT_IMAGE_2D_ARRAY GL_INT_IMAGE_CUBE_EXT GL_INT_SAMPLER_1D_EXT
     GL_INT_SAMPLER_2D_EXT GL_INT_SAMPLER_3D_EXT GL_INT_SAMPLER_BUFFER
     GL_KTX_STENCIL_REGION GL_LARGE_CW_ARC_TO_NV GL_LIGHT_ENV_MODE_EXT
     GL_LINEAR_ATTENUATION GL_LOCAL_CONSTANT_EXT GL_LOCATION_COMPONENT
     GL_LOG_INTERNAL_REGAL GL_LUMINANCE12_ALPHA4 GL_MAGNITUDE_SCALE_NV
     GL_MAP1_GRID_SEGMENTS GL_MAP2_GRID_SEGMENTS GL_MAP_PERSISTENT_BIT
     GL_MATRIX_PALETTE_ARB GL_MAX_CLIP_DISTANCES GL_MAX_CULL_DISTANCES
     GL_MAX_INTENSITY_SGIS GL_MAX_LUMINANCE_SGIS GL_MAX_PATCH_VERTICES
     GL_MAX_TESS_GEN_LEVEL GL_MAX_TEXTURE_COORDS GL_MAX_VARYING_FLOATS
     GL_MAX_VERTEX_ATTRIBS GL_MAX_VERTEX_STREAMS GL_MESA_ycbcr_texture
     GL_MIN_INTENSITY_SGIS GL_MIN_LUMINANCE_SGIS GL_NV_occlusion_query
     GL_NV_texture_barrier GL_NV_texture_shader2 GL_NV_texture_shader3
     GL_NV_vertex_program2 GL_NV_vertex_program3 GL_NV_vertex_program4
     GL_NV_viewport_array2 GL_OBJECT_SUBTYPE_ARB GL_OPERAND0_ALPHA_ARB
     GL_OPERAND0_ALPHA_EXT GL_OPERAND1_ALPHA_ARB GL_OPERAND1_ALPHA_EXT
     GL_OPERAND2_ALPHA_ARB GL_OPERAND2_ALPHA_EXT GL_PACK_CMYK_HINT_EXT
     GL_PACK_RESAMPLE_SGIX GL_PALETTE4_RGBA4_OES GL_PALETTE4_RGBA8_OES
     GL_PALETTE8_RGBA4_OES GL_PALETTE8_RGBA8_OES GL_PARTIAL_SUCCESS_NV
     GL_PASS_THROUGH_TOKEN GL_PATH_FORMAT_SVG_NV GL_PATH_JOIN_STYLE_NV
     GL_PERFMON_RESULT_AMD GL_PER_GPU_STORAGE_NV GL_POINT_SIZE_MAX_ARB
     GL_POINT_SIZE_MAX_EXT GL_POINT_SIZE_MIN_ARB GL_POINT_SIZE_MIN_EXT
     GL_POLYGON_OFFSET_EXT GL_PROGRAM_FORMAT_ARB GL_PROGRAM_LENGTH_ARB
     GL_PROGRAM_MATRIX_EXT GL_PROGRAM_OBJECT_ARB GL_PROGRAM_OBJECT_EXT
     GL_PROGRAM_POINT_SIZE GL_PROGRAM_STRING_ARB GL_QUERY_COUNTER_BITS
     GL_QUERY_RESULT_ANGLE GL_R11F_G11F_B10F_EXT GL_RASTERIZER_DISCARD
     GL_RASTER_SAMPLES_EXT GL_READ_PIXELS_FORMAT GL_RED_MAX_CLAMP_INGR
     GL_RED_MIN_CLAMP_INGR GL_REFLECTION_MAP_ARB GL_REFLECTION_MAP_EXT
     GL_REGAL_error_string GL_REGAL_proc_address GL_RELATIVE_ARC_TO_NV
     GL_RENDERBUFFER_WIDTH GL_RENDER_GPU_MASK_NV GL_REPLACE_MIDDLE_SUN
     GL_REPLACE_OLDEST_SUN GL_RESCALE_NORMAL_EXT GL_RGBA16_SIGNED_SGIX
     GL_RGBA_FLOAT16_APPLE GL_RGBA_FLOAT32_APPLE GL_SAMPLER_BUFFER_AMD
     GL_SAMPLER_BUFFER_EXT GL_SAMPLER_OBJECT_AMD GL_SAMPLES_PASSED_ARB
     GL_SAMPLE_BUFFERS_ARB GL_SAMPLE_BUFFERS_EXT GL_SAMPLE_LOCATION_NV
     GL_SAMPLE_PATTERN_EXT GL_SAMPLE_POSITION_NV GL_SAMPLE_SHADING_ARB
     GL_SCISSOR_COMMAND_NV GL_SECONDARY_COLOR_NV GL_SGIS_pixel_texture
     GL_SGIX_depth_texture GL_SGIX_list_priority GL_SGIX_pixel_texture
     GL_SGIX_texture_range GL_SHADER_IMAGE_STORE GL_SHADER_INCLUDE_ARB
     GL_SIGNED_IDENTITY_NV GL_SLUMINANCE8_ALPHA8 GL_SMALL_CW_ARC_TO_NV
     GL_SRC_ALPHA_SATURATE GL_STENCIL_ATTACHMENT GL_STENCIL_BUFFER_BIT
     GL_STENCIL_COMPONENTS GL_STENCIL_INDEX1_EXT GL_STENCIL_INDEX4_EXT
     GL_STENCIL_INDEX8_EXT GL_STENCIL_RENDERABLE GL_STENCIL_SAMPLES_NV
     GL_STENCIL_VALUE_MASK GL_SUNX_constant_data GL_SWIZZLE_STQ_DQ_ATI
     GL_SWIZZLE_STR_DR_ATI GL_SYNC_X11_FENCE_EXT GL_TEXTURE_ALPHA_SIZE
     GL_TEXTURE_ALPHA_TYPE GL_TEXTURE_BASE_LEVEL GL_TEXTURE_BINDING_1D
     GL_TEXTURE_BINDING_2D GL_TEXTURE_BINDING_3D GL_TEXTURE_BUFFER_ARB
     GL_TEXTURE_BUFFER_EXT GL_TEXTURE_COMPONENTS GL_TEXTURE_COMPRESSED
     GL_TEXTURE_DEPTH_SIZE GL_TEXTURE_DEPTH_TYPE GL_TEXTURE_DS_SIZE_NV
     GL_TEXTURE_DT_SIZE_NV GL_TEXTURE_GREEN_SIZE GL_TEXTURE_GREEN_TYPE
     GL_TEXTURE_HI_SIZE_NV GL_TEXTURE_IMAGE_TYPE GL_TEXTURE_LO_SIZE_NV
     GL_TEXTURE_MAG_FILTER GL_TEXTURE_MIN_FILTER GL_TEXTURE_NORMAL_EXT
     GL_TEXTURE_SPARSE_ARB GL_TEXTURE_WRAP_R_EXT GL_TIME_ELAPSED_ANGLE
     GL_TRANSFORM_FEEDBACK GL_UNIFORM_BUFFER_EXT GL_UNPACK_SKIP_IMAGES
     GL_UNPACK_SKIP_PIXELS GL_UNSIGNED_INT64_AMD GL_UNSIGNED_INT64_ARB
     GL_UNSIGNED_INVERT_NV GL_VERTEX_PROGRAM_ARB GL_VERTEX_STREAM0_ATI
     GL_VERTEX_STREAM1_ATI GL_VERTEX_STREAM2_ATI GL_VERTEX_STREAM3_ATI
     GL_VERTEX_STREAM4_ATI GL_VERTEX_STREAM5_ATI GL_VERTEX_STREAM6_ATI
     GL_VERTEX_STREAM7_ATI GL_VIEW_CLASS_16_BITS GL_VIEW_CLASS_24_BITS
     GL_VIEW_CLASS_32_BITS GL_VIEW_CLASS_48_BITS GL_VIEW_CLASS_64_BITS
     GL_VIEW_CLASS_96_BITS GL_WIDE_LINE_HINT_PGI */
  /* Offset 16 gives the best switch position.  */
  switch (name[16]) {
  case '0':
    if (memEQ(name, "GL_INT_2_10_10_10_REV", 21)) {
    /*                               ^           */
#ifdef GL_INT_2_10_10_10_REV
      *iv_return = (IV)GL_INT_2_10_10_10_REV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERTEX_STREAM0_ATI", 21)) {
    /*                               ^           */
#ifdef GL_VERTEX_STREAM0_ATI
      *iv_return = (IV)GL_VERTEX_STREAM0_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '1':
    if (memEQ(name, "GL_COMPRESSED_R11_EAC", 21)) {
    /*                               ^           */
#ifdef GL_COMPRESSED_R11_EAC
      *iv_return = (IV)GL_COMPRESSED_R11_EAC;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STENCIL_INDEX1_EXT", 21)) {
    /*                               ^           */
#ifdef GL_STENCIL_INDEX1_EXT
      *iv_return = (IV)GL_STENCIL_INDEX1_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERTEX_STREAM1_ATI", 21)) {
    /*                               ^           */
#ifdef GL_VERTEX_STREAM1_ATI
      *iv_return = (IV)GL_VERTEX_STREAM1_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '2':
    if (memEQ(name, "GL_VERTEX_STREAM2_ATI", 21)) {
    /*                               ^           */
#ifdef GL_VERTEX_STREAM2_ATI
      *iv_return = (IV)GL_VERTEX_STREAM2_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '3':
    if (memEQ(name, "GL_VERTEX_STREAM3_ATI", 21)) {
    /*                               ^           */
#ifdef GL_VERTEX_STREAM3_ATI
      *iv_return = (IV)GL_VERTEX_STREAM3_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '4':
    if (memEQ(name, "GL_PALETTE4_RGBA4_OES", 21)) {
    /*                               ^           */
#ifdef GL_PALETTE4_RGBA4_OES
      *iv_return = (IV)GL_PALETTE4_RGBA4_OES;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PALETTE8_RGBA4_OES", 21)) {
    /*                               ^           */
#ifdef GL_PALETTE8_RGBA4_OES
      *iv_return = (IV)GL_PALETTE8_RGBA4_OES;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STENCIL_INDEX4_EXT", 21)) {
    /*                               ^           */
#ifdef GL_STENCIL_INDEX4_EXT
      *iv_return = (IV)GL_STENCIL_INDEX4_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNSIGNED_INT64_AMD", 21)) {
    /*                               ^           */
#ifdef GL_UNSIGNED_INT64_AMD
      *iv_return = (IV)GL_UNSIGNED_INT64_AMD;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNSIGNED_INT64_ARB", 21)) {
    /*                               ^           */
#ifdef GL_UNSIGNED_INT64_ARB
      *iv_return = (IV)GL_UNSIGNED_INT64_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERTEX_STREAM4_ATI", 21)) {
    /*                               ^           */
#ifdef GL_VERTEX_STREAM4_ATI
      *iv_return = (IV)GL_VERTEX_STREAM4_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '5':
    if (memEQ(name, "GL_VERTEX_STREAM5_ATI", 21)) {
    /*                               ^           */
#ifdef GL_VERTEX_STREAM5_ATI
      *iv_return = (IV)GL_VERTEX_STREAM5_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '6':
    if (memEQ(name, "GL_VERTEX_STREAM6_ATI", 21)) {
    /*                               ^           */
#ifdef GL_VERTEX_STREAM6_ATI
      *iv_return = (IV)GL_VERTEX_STREAM6_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '7':
    if (memEQ(name, "GL_VERTEX_STREAM7_ATI", 21)) {
    /*                               ^           */
#ifdef GL_VERTEX_STREAM7_ATI
      *iv_return = (IV)GL_VERTEX_STREAM7_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '8':
    if (memEQ(name, "GL_PALETTE4_RGBA8_OES", 21)) {
    /*                               ^           */
#ifdef GL_PALETTE4_RGBA8_OES
      *iv_return = (IV)GL_PALETTE4_RGBA8_OES;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PALETTE8_RGBA8_OES", 21)) {
    /*                               ^           */
#ifdef GL_PALETTE8_RGBA8_OES
      *iv_return = (IV)GL_PALETTE8_RGBA8_OES;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STENCIL_INDEX8_EXT", 21)) {
    /*                               ^           */
#ifdef GL_STENCIL_INDEX8_EXT
      *iv_return = (IV)GL_STENCIL_INDEX8_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'A':
    if (memEQ(name, "GL_ANY_SAMPLES_PASSED", 21)) {
    /*                               ^           */
#ifdef GL_ANY_SAMPLES_PASSED
      *iv_return = (IV)GL_ANY_SAMPLES_PASSED;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COMPUTE_PROGRAM_NV", 21)) {
    /*                               ^           */
#ifdef GL_COMPUTE_PROGRAM_NV
      *iv_return = (IV)GL_COMPUTE_PROGRAM_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CONSTANT_ALPHA_EXT", 21)) {
    /*                               ^           */
#ifdef GL_CONSTANT_ALPHA_EXT
      *iv_return = (IV)GL_CONSTANT_ALPHA_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INT_IMAGE_1D_ARRAY", 21)) {
    /*                               ^           */
#ifdef GL_INT_IMAGE_1D_ARRAY
      *iv_return = (IV)GL_INT_IMAGE_1D_ARRAY;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INT_IMAGE_2D_ARRAY", 21)) {
    /*                               ^           */
#ifdef GL_INT_IMAGE_2D_ARRAY
      *iv_return = (IV)GL_INT_IMAGE_2D_ARRAY;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LINEAR_ATTENUATION", 21)) {
    /*                               ^           */
#ifdef GL_LINEAR_ATTENUATION
      *iv_return = (IV)GL_LINEAR_ATTENUATION;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_CLIP_DISTANCES", 21)) {
    /*                               ^           */
#ifdef GL_MAX_CLIP_DISTANCES
      *iv_return = (IV)GL_MAX_CLIP_DISTANCES;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_CULL_DISTANCES", 21)) {
    /*                               ^           */
#ifdef GL_MAX_CULL_DISTANCES
      *iv_return = (IV)GL_MAX_CULL_DISTANCES;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OPERAND0_ALPHA_ARB", 21)) {
    /*                               ^           */
#ifdef GL_OPERAND0_ALPHA_ARB
      *iv_return = (IV)GL_OPERAND0_ALPHA_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OPERAND0_ALPHA_EXT", 21)) {
    /*                               ^           */
#ifdef GL_OPERAND0_ALPHA_EXT
      *iv_return = (IV)GL_OPERAND0_ALPHA_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OPERAND1_ALPHA_ARB", 21)) {
    /*                               ^           */
#ifdef GL_OPERAND1_ALPHA_ARB
      *iv_return = (IV)GL_OPERAND1_ALPHA_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OPERAND1_ALPHA_EXT", 21)) {
    /*                               ^           */
#ifdef GL_OPERAND1_ALPHA_EXT
      *iv_return = (IV)GL_OPERAND1_ALPHA_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OPERAND2_ALPHA_ARB", 21)) {
    /*                               ^           */
#ifdef GL_OPERAND2_ALPHA_ARB
      *iv_return = (IV)GL_OPERAND2_ALPHA_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OPERAND2_ALPHA_EXT", 21)) {
    /*                               ^           */
#ifdef GL_OPERAND2_ALPHA_EXT
      *iv_return = (IV)GL_OPERAND2_ALPHA_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_QUERY_RESULT_ANGLE", 21)) {
    /*                               ^           */
#ifdef GL_QUERY_RESULT_ANGLE
      *iv_return = (IV)GL_QUERY_RESULT_ANGLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGBA_FLOAT16_APPLE", 21)) {
    /*                               ^           */
#ifdef GL_RGBA_FLOAT16_APPLE
      *iv_return = (IV)GL_RGBA_FLOAT16_APPLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGBA_FLOAT32_APPLE", 21)) {
    /*                               ^           */
#ifdef GL_RGBA_FLOAT32_APPLE
      *iv_return = (IV)GL_RGBA_FLOAT32_APPLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TIME_ELAPSED_ANGLE", 21)) {
    /*                               ^           */
#ifdef GL_TIME_ELAPSED_ANGLE
      *iv_return = (IV)GL_TIME_ELAPSED_ANGLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'B':
    if (memEQ(name, "GL_COMPRESSED_RGB_ARB", 21)) {
    /*                               ^           */
#ifdef GL_COMPRESSED_RGB_ARB
      *iv_return = (IV)GL_COMPRESSED_RGB_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'C':
    if (memEQ(name, "GL_CLAMP_VERTEX_COLOR", 21)) {
    /*                               ^           */
#ifdef GL_CLAMP_VERTEX_COLOR
      *iv_return = (IV)GL_CLAMP_VERTEX_COLOR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'D':
    if (memEQ(name, "GL_ATTRIB_STACK_DEPTH", 21)) {
    /*                               ^           */
#ifdef GL_ATTRIB_STACK_DEPTH
      *iv_return = (IV)GL_ATTRIB_STACK_DEPTH;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CONVOLUTION_1D_EXT", 21)) {
    /*                               ^           */
#ifdef GL_CONVOLUTION_1D_EXT
      *iv_return = (IV)GL_CONVOLUTION_1D_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CONVOLUTION_2D_EXT", 21)) {
    /*                               ^           */
#ifdef GL_CONVOLUTION_2D_EXT
      *iv_return = (IV)GL_CONVOLUTION_2D_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FLOAT_RGBA_MODE_NV", 21)) {
    /*                               ^           */
#ifdef GL_FLOAT_RGBA_MODE_NV
      *iv_return = (IV)GL_FLOAT_RGBA_MODE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INTERLACE_READ_OML", 21)) {
    /*                               ^           */
#ifdef GL_INTERLACE_READ_OML
      *iv_return = (IV)GL_INTERLACE_READ_OML;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INT_SAMPLER_1D_EXT", 21)) {
    /*                               ^           */
#ifdef GL_INT_SAMPLER_1D_EXT
      *iv_return = (IV)GL_INT_SAMPLER_1D_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INT_SAMPLER_2D_EXT", 21)) {
    /*                               ^           */
#ifdef GL_INT_SAMPLER_2D_EXT
      *iv_return = (IV)GL_INT_SAMPLER_2D_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INT_SAMPLER_3D_EXT", 21)) {
    /*                               ^           */
#ifdef GL_INT_SAMPLER_3D_EXT
      *iv_return = (IV)GL_INT_SAMPLER_3D_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLES_PASSED_ARB", 21)) {
    /*                               ^           */
#ifdef GL_SAMPLES_PASSED_ARB
      *iv_return = (IV)GL_SAMPLES_PASSED_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TRANSFORM_FEEDBACK", 21)) {
    /*                               ^           */
#ifdef GL_TRANSFORM_FEEDBACK
      *iv_return = (IV)GL_TRANSFORM_FEEDBACK;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'E':
    if (memEQ(name, "GL_ACTIVE_TEXTURE_ARB", 21)) {
    /*                               ^           */
#ifdef GL_ACTIVE_TEXTURE_ARB
      *iv_return = (IV)GL_ACTIVE_TEXTURE_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CLIENT_STORAGE_BIT", 21)) {
    /*                               ^           */
#ifdef GL_CLIENT_STORAGE_BIT
      *iv_return = (IV)GL_CLIENT_STORAGE_BIT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_ATTACHMENT10", 21)) {
    /*                               ^           */
#ifdef GL_COLOR_ATTACHMENT10
      *iv_return = (IV)GL_COLOR_ATTACHMENT10;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_ATTACHMENT11", 21)) {
    /*                               ^           */
#ifdef GL_COLOR_ATTACHMENT11
      *iv_return = (IV)GL_COLOR_ATTACHMENT11;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_ATTACHMENT12", 21)) {
    /*                               ^           */
#ifdef GL_COLOR_ATTACHMENT12
      *iv_return = (IV)GL_COLOR_ATTACHMENT12;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_ATTACHMENT13", 21)) {
    /*                               ^           */
#ifdef GL_COLOR_ATTACHMENT13
      *iv_return = (IV)GL_COLOR_ATTACHMENT13;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_ATTACHMENT14", 21)) {
    /*                               ^           */
#ifdef GL_COLOR_ATTACHMENT14
      *iv_return = (IV)GL_COLOR_ATTACHMENT14;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_ATTACHMENT15", 21)) {
    /*                               ^           */
#ifdef GL_COLOR_ATTACHMENT15
      *iv_return = (IV)GL_COLOR_ATTACHMENT15;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CONVOLUTION_HEIGHT", 21)) {
    /*                               ^           */
#ifdef GL_CONVOLUTION_HEIGHT
      *iv_return = (IV)GL_CONVOLUTION_HEIGHT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FOG_COORDINATE_EXT", 21)) {
    /*                               ^           */
#ifdef GL_FOG_COORDINATE_EXT
      *iv_return = (IV)GL_FOG_COORDINATE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INT_IMAGE_CUBE_EXT", 21)) {
    /*                               ^           */
#ifdef GL_INT_IMAGE_CUBE_EXT
      *iv_return = (IV)GL_INT_IMAGE_CUBE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_KTX_STENCIL_REGION", 21)) {
    /*                               ^           */
#ifdef GL_KTX_STENCIL_REGION
      *iv_return = (IV)GL_KTX_STENCIL_REGION;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LIGHT_ENV_MODE_EXT", 21)) {
    /*                               ^           */
#ifdef GL_LIGHT_ENV_MODE_EXT
      *iv_return = (IV)GL_LIGHT_ENV_MODE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MATRIX_PALETTE_ARB", 21)) {
    /*                               ^           */
#ifdef GL_MATRIX_PALETTE_ARB
      *iv_return = (IV)GL_MATRIX_PALETTE_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OBJECT_SUBTYPE_ARB", 21)) {
    /*                               ^           */
#ifdef GL_OBJECT_SUBTYPE_ARB
      *iv_return = (IV)GL_OBJECT_SUBTYPE_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_REPLACE_MIDDLE_SUN", 21)) {
    /*                               ^           */
#ifdef GL_REPLACE_MIDDLE_SUN
      *iv_return = (IV)GL_REPLACE_MIDDLE_SUN;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SHADER_INCLUDE_ARB", 21)) {
    /*                               ^           */
#ifdef GL_SHADER_INCLUDE_ARB
      *iv_return = (IV)GL_SHADER_INCLUDE_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STENCIL_SAMPLES_NV", 21)) {
    /*                               ^           */
#ifdef GL_STENCIL_SAMPLES_NV
      *iv_return = (IV)GL_STENCIL_SAMPLES_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SYNC_X11_FENCE_EXT", 21)) {
    /*                               ^           */
#ifdef GL_SYNC_X11_FENCE_EXT
      *iv_return = (IV)GL_SYNC_X11_FENCE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_COMPRESSED", 21)) {
    /*                               ^           */
#ifdef GL_TEXTURE_COMPRESSED
      *iv_return = (IV)GL_TEXTURE_COMPRESSED;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_SPARSE_ARB", 21)) {
    /*                               ^           */
#ifdef GL_TEXTURE_SPARSE_ARB
      *iv_return = (IV)GL_TEXTURE_SPARSE_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'F':
    if (memEQ(name, "GL_R11F_G11F_B10F_EXT", 21)) {
    /*                               ^           */
#ifdef GL_R11F_G11F_B10F_EXT
      *iv_return = (IV)GL_R11F_G11F_B10F_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'G':
    if (memEQ(name, "GL_ACTIVE_VARYINGS_NV", 21)) {
    /*                               ^           */
#ifdef GL_ACTIVE_VARYINGS_NV
      *iv_return = (IV)GL_ACTIVE_VARYINGS_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PER_GPU_STORAGE_NV", 21)) {
    /*                               ^           */
#ifdef GL_PER_GPU_STORAGE_NV
      *iv_return = (IV)GL_PER_GPU_STORAGE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PROGRAM_STRING_ARB", 21)) {
    /*                               ^           */
#ifdef GL_PROGRAM_STRING_ARB
      *iv_return = (IV)GL_PROGRAM_STRING_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLE_SHADING_ARB", 21)) {
    /*                               ^           */
#ifdef GL_SAMPLE_SHADING_ARB
      *iv_return = (IV)GL_SAMPLE_SHADING_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'H':
    if (memEQ(name, "GL_FRAGMENT_DEPTH_EXT", 21)) {
    /*                               ^           */
#ifdef GL_FRAGMENT_DEPTH_EXT
      *iv_return = (IV)GL_FRAGMENT_DEPTH_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PROGRAM_LENGTH_ARB", 21)) {
    /*                               ^           */
#ifdef GL_PROGRAM_LENGTH_ARB
      *iv_return = (IV)GL_PROGRAM_LENGTH_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STENCIL_ATTACHMENT", 21)) {
    /*                               ^           */
#ifdef GL_STENCIL_ATTACHMENT
      *iv_return = (IV)GL_STENCIL_ATTACHMENT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'I':
    if (memEQ(name, "GL_BUFFER_MAP_POINTER", 21)) {
    /*                               ^           */
#ifdef GL_BUFFER_MAP_POINTER
      *iv_return = (IV)GL_BUFFER_MAP_POINTER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FONT_HEIGHT_BIT_NV", 21)) {
    /*                               ^           */
#ifdef GL_FONT_HEIGHT_BIT_NV
      *iv_return = (IV)GL_FONT_HEIGHT_BIT_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_GLYPH_WIDTH_BIT_NV", 21)) {
    /*                               ^           */
#ifdef GL_GLYPH_WIDTH_BIT_NV
      *iv_return = (IV)GL_GLYPH_WIDTH_BIT_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_MAG_FILTER", 21)) {
    /*                               ^           */
#ifdef GL_TEXTURE_MAG_FILTER
      *iv_return = (IV)GL_TEXTURE_MAG_FILTER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_MIN_FILTER", 21)) {
    /*                               ^           */
#ifdef GL_TEXTURE_MIN_FILTER
      *iv_return = (IV)GL_TEXTURE_MIN_FILTER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNPACK_SKIP_PIXELS", 21)) {
    /*                               ^           */
#ifdef GL_UNPACK_SKIP_PIXELS
      *iv_return = (IV)GL_UNPACK_SKIP_PIXELS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'K':
    if (memEQ(name, "GL_HISTOGRAM_SINK_EXT", 21)) {
    /*                               ^           */
#ifdef GL_HISTOGRAM_SINK_EXT
      *iv_return = (IV)GL_HISTOGRAM_SINK_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'L':
    if (memEQ(name, "GL_LUMINANCE12_ALPHA4", 21)) {
    /*                               ^           */
#ifdef GL_LUMINANCE12_ALPHA4
      *iv_return = (IV)GL_LUMINANCE12_ALPHA4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAGNITUDE_SCALE_NV", 21)) {
    /*                               ^           */
#ifdef GL_MAGNITUDE_SCALE_NV
      *iv_return = (IV)GL_MAGNITUDE_SCALE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_TESS_GEN_LEVEL", 21)) {
    /*                               ^           */
#ifdef GL_MAX_TESS_GEN_LEVEL
      *iv_return = (IV)GL_MAX_TESS_GEN_LEVEL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_VARYING_FLOATS", 21)) {
    /*                               ^           */
#ifdef GL_MAX_VARYING_FLOATS
      *iv_return = (IV)GL_MAX_VARYING_FLOATS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PATH_JOIN_STYLE_NV", 21)) {
    /*                               ^           */
#ifdef GL_PATH_JOIN_STYLE_NV
      *iv_return = (IV)GL_PATH_JOIN_STYLE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RESCALE_NORMAL_EXT", 21)) {
    /*                               ^           */
#ifdef GL_RESCALE_NORMAL_EXT
      *iv_return = (IV)GL_RESCALE_NORMAL_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SLUMINANCE8_ALPHA8", 21)) {
    /*                               ^           */
#ifdef GL_SLUMINANCE8_ALPHA8
      *iv_return = (IV)GL_SLUMINANCE8_ALPHA8;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_BASE_LEVEL", 21)) {
    /*                               ^           */
#ifdef GL_TEXTURE_BASE_LEVEL
      *iv_return = (IV)GL_TEXTURE_BASE_LEVEL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_NORMAL_EXT", 21)) {
    /*                               ^           */
#ifdef GL_TEXTURE_NORMAL_EXT
      *iv_return = (IV)GL_TEXTURE_NORMAL_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'M':
    if (memEQ(name, "GL_ACTIVE_PROGRAM_EXT", 21)) {
    /*                               ^           */
#ifdef GL_ACTIVE_PROGRAM_EXT
      *iv_return = (IV)GL_ACTIVE_PROGRAM_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_SUM_CLAMP_NV", 21)) {
    /*                               ^           */
#ifdef GL_COLOR_SUM_CLAMP_NV
      *iv_return = (IV)GL_COLOR_SUM_CLAMP_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAP1_GRID_SEGMENTS", 21)) {
    /*                               ^           */
#ifdef GL_MAP1_GRID_SEGMENTS
      *iv_return = (IV)GL_MAP1_GRID_SEGMENTS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAP2_GRID_SEGMENTS", 21)) {
    /*                               ^           */
#ifdef GL_MAP2_GRID_SEGMENTS
      *iv_return = (IV)GL_MAP2_GRID_SEGMENTS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNPACK_SKIP_IMAGES", 21)) {
    /*                               ^           */
#ifdef GL_UNPACK_SKIP_IMAGES
      *iv_return = (IV)GL_UNPACK_SKIP_IMAGES;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERTEX_PROGRAM_ARB", 21)) {
    /*                               ^           */
#ifdef GL_VERTEX_PROGRAM_ARB
      *iv_return = (IV)GL_VERTEX_PROGRAM_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'N':
    if (memEQ(name, "GL_BLEND_EQUATION_EXT", 21)) {
    /*                               ^           */
#ifdef GL_BLEND_EQUATION_EXT
      *iv_return = (IV)GL_BLEND_EQUATION_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_BLEND_EQUATION_RGB", 21)) {
    /*                               ^           */
#ifdef GL_BLEND_EQUATION_RGB
      *iv_return = (IV)GL_BLEND_EQUATION_RGB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEPTH_COMPONENT32F", 21)) {
    /*                               ^           */
#ifdef GL_DEPTH_COMPONENT32F
      *iv_return = (IV)GL_DEPTH_COMPONENT32F;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EMBOSS_CONSTANT_NV", 21)) {
    /*                               ^           */
#ifdef GL_EMBOSS_CONSTANT_NV
      *iv_return = (IV)GL_EMBOSS_CONSTANT_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_HSL_SATURATION_KHR", 21)) {
    /*                               ^           */
#ifdef GL_HSL_SATURATION_KHR
      *iv_return = (IV)GL_HSL_SATURATION_KHR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_POINT_SIZE_MIN_ARB", 21)) {
    /*                               ^           */
#ifdef GL_POINT_SIZE_MIN_ARB
      *iv_return = (IV)GL_POINT_SIZE_MIN_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_POINT_SIZE_MIN_EXT", 21)) {
    /*                               ^           */
#ifdef GL_POINT_SIZE_MIN_EXT
      *iv_return = (IV)GL_POINT_SIZE_MIN_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLE_PATTERN_EXT", 21)) {
    /*                               ^           */
#ifdef GL_SAMPLE_PATTERN_EXT
      *iv_return = (IV)GL_SAMPLE_PATTERN_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SCISSOR_COMMAND_NV", 21)) {
    /*                               ^           */
#ifdef GL_SCISSOR_COMMAND_NV
      *iv_return = (IV)GL_SCISSOR_COMMAND_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STENCIL_COMPONENTS", 21)) {
    /*                               ^           */
#ifdef GL_STENCIL_COMPONENTS
      *iv_return = (IV)GL_STENCIL_COMPONENTS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_BINDING_1D", 21)) {
    /*                               ^           */
#ifdef GL_TEXTURE_BINDING_1D
      *iv_return = (IV)GL_TEXTURE_BINDING_1D;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_BINDING_2D", 21)) {
    /*                               ^           */
#ifdef GL_TEXTURE_BINDING_2D
      *iv_return = (IV)GL_TEXTURE_BINDING_2D;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_BINDING_3D", 21)) {
    /*                               ^           */
#ifdef GL_TEXTURE_BINDING_3D
      *iv_return = (IV)GL_TEXTURE_BINDING_3D;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_COMPONENTS", 21)) {
    /*                               ^           */
#ifdef GL_TEXTURE_COMPONENTS
      *iv_return = (IV)GL_TEXTURE_COMPONENTS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'O':
    if (memEQ(name, "GL_COLOR_TABLE_FORMAT", 21)) {
    /*                               ^           */
#ifdef GL_COLOR_TABLE_FORMAT
      *iv_return = (IV)GL_COLOR_TABLE_FORMAT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CONVOLUTION_FORMAT", 21)) {
    /*                               ^           */
#ifdef GL_CONVOLUTION_FORMAT
      *iv_return = (IV)GL_CONVOLUTION_FORMAT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEBUG_SOURCE_OTHER", 21)) {
    /*                               ^           */
#ifdef GL_DEBUG_SOURCE_OTHER
      *iv_return = (IV)GL_DEBUG_SOURCE_OTHER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FENCE_CONDITION_NV", 21)) {
    /*                               ^           */
#ifdef GL_FENCE_CONDITION_NV
      *iv_return = (IV)GL_FENCE_CONDITION_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_IMAGE_PIXEL_FORMAT", 21)) {
    /*                               ^           */
#ifdef GL_IMAGE_PIXEL_FORMAT
      *iv_return = (IV)GL_IMAGE_PIXEL_FORMAT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LOCATION_COMPONENT", 21)) {
    /*                               ^           */
#ifdef GL_LOCATION_COMPONENT
      *iv_return = (IV)GL_LOCATION_COMPONENT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_TEXTURE_COORDS", 21)) {
    /*                               ^           */
#ifdef GL_MAX_TEXTURE_COORDS
      *iv_return = (IV)GL_MAX_TEXTURE_COORDS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_READ_PIXELS_FORMAT", 21)) {
    /*                               ^           */
#ifdef GL_READ_PIXELS_FORMAT
      *iv_return = (IV)GL_READ_PIXELS_FORMAT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLE_LOCATION_NV", 21)) {
    /*                               ^           */
#ifdef GL_SAMPLE_LOCATION_NV
      *iv_return = (IV)GL_SAMPLE_LOCATION_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLE_POSITION_NV", 21)) {
    /*                               ^           */
#ifdef GL_SAMPLE_POSITION_NV
      *iv_return = (IV)GL_SAMPLE_POSITION_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SECONDARY_COLOR_NV", 21)) {
    /*                               ^           */
#ifdef GL_SECONDARY_COLOR_NV
      *iv_return = (IV)GL_SECONDARY_COLOR_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'P':
    if (memEQ(name, "GL_REFLECTION_MAP_ARB", 21)) {
    /*                               ^           */
#ifdef GL_REFLECTION_MAP_ARB
      *iv_return = (IV)GL_REFLECTION_MAP_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_REFLECTION_MAP_EXT", 21)) {
    /*                               ^           */
#ifdef GL_REFLECTION_MAP_EXT
      *iv_return = (IV)GL_REFLECTION_MAP_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'Q':
    if (memEQ(name, "GL_SWIZZLE_STQ_DQ_ATI", 21)) {
    /*                               ^           */
#ifdef GL_SWIZZLE_STQ_DQ_ATI
      *iv_return = (IV)GL_SWIZZLE_STQ_DQ_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'R':
    if (memEQ(name, "GL_COMPUTE_SHADER_BIT", 21)) {
    /*                               ^           */
#ifdef GL_COMPUTE_SHADER_BIT
      *iv_return = (IV)GL_COMPUTE_SHADER_BIT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CONSTANT_COLOR0_NV", 21)) {
    /*                               ^           */
#ifdef GL_CONSTANT_COLOR0_NV
      *iv_return = (IV)GL_CONSTANT_COLOR0_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CONSTANT_COLOR1_NV", 21)) {
    /*                               ^           */
#ifdef GL_CONSTANT_COLOR1_NV
      *iv_return = (IV)GL_CONSTANT_COLOR1_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CONSTANT_COLOR_EXT", 21)) {
    /*                               ^           */
#ifdef GL_CONSTANT_COLOR_EXT
      *iv_return = (IV)GL_CONSTANT_COLOR_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FRAGMENT_COLOR_EXT", 21)) {
    /*                               ^           */
#ifdef GL_FRAGMENT_COLOR_EXT
      *iv_return = (IV)GL_FRAGMENT_COLOR_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LOG_INTERNAL_REGAL", 21)) {
    /*                               ^           */
#ifdef GL_LOG_INTERNAL_REGAL
      *iv_return = (IV)GL_LOG_INTERNAL_REGAL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_VERTEX_STREAMS", 21)) {
    /*                               ^           */
#ifdef GL_MAX_VERTEX_STREAMS
      *iv_return = (IV)GL_MAX_VERTEX_STREAMS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLER_BUFFER_AMD", 21)) {
    /*                               ^           */
#ifdef GL_SAMPLER_BUFFER_AMD
      *iv_return = (IV)GL_SAMPLER_BUFFER_AMD;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLER_BUFFER_EXT", 21)) {
    /*                               ^           */
#ifdef GL_SAMPLER_BUFFER_EXT
      *iv_return = (IV)GL_SAMPLER_BUFFER_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STENCIL_BUFFER_BIT", 21)) {
    /*                               ^           */
#ifdef GL_STENCIL_BUFFER_BIT
      *iv_return = (IV)GL_STENCIL_BUFFER_BIT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STENCIL_RENDERABLE", 21)) {
    /*                               ^           */
#ifdef GL_STENCIL_RENDERABLE
      *iv_return = (IV)GL_STENCIL_RENDERABLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SWIZZLE_STR_DR_ATI", 21)) {
    /*                               ^           */
#ifdef GL_SWIZZLE_STR_DR_ATI
      *iv_return = (IV)GL_SWIZZLE_STR_DR_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_BUFFER_ARB", 21)) {
    /*                               ^           */
#ifdef GL_TEXTURE_BUFFER_ARB
      *iv_return = (IV)GL_TEXTURE_BUFFER_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_BUFFER_EXT", 21)) {
    /*                               ^           */
#ifdef GL_TEXTURE_BUFFER_EXT
      *iv_return = (IV)GL_TEXTURE_BUFFER_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_WRAP_R_EXT", 21)) {
    /*                               ^           */
#ifdef GL_TEXTURE_WRAP_R_EXT
      *iv_return = (IV)GL_TEXTURE_WRAP_R_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNIFORM_BUFFER_EXT", 21)) {
    /*                               ^           */
#ifdef GL_UNIFORM_BUFFER_EXT
      *iv_return = (IV)GL_UNIFORM_BUFFER_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNSIGNED_INVERT_NV", 21)) {
    /*                               ^           */
#ifdef GL_UNSIGNED_INVERT_NV
      *iv_return = (IV)GL_UNSIGNED_INVERT_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'S':
    if (memEQ(name, "GL_BUMP_TEX_UNITS_ATI", 21)) {
    /*                               ^           */
#ifdef GL_BUMP_TEX_UNITS_ATI
      *iv_return = (IV)GL_BUMP_TEX_UNITS_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PARTIAL_SUCCESS_NV", 21)) {
    /*                               ^           */
#ifdef GL_PARTIAL_SUCCESS_NV
      *iv_return = (IV)GL_PARTIAL_SUCCESS_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RASTERIZER_DISCARD", 21)) {
    /*                               ^           */
#ifdef GL_RASTERIZER_DISCARD
      *iv_return = (IV)GL_RASTERIZER_DISCARD;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RASTER_SAMPLES_EXT", 21)) {
    /*                               ^           */
#ifdef GL_RASTER_SAMPLES_EXT
      *iv_return = (IV)GL_RASTER_SAMPLES_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RENDER_GPU_MASK_NV", 21)) {
    /*                               ^           */
#ifdef GL_RENDER_GPU_MASK_NV
      *iv_return = (IV)GL_RENDER_GPU_MASK_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLE_BUFFERS_ARB", 21)) {
    /*                               ^           */
#ifdef GL_SAMPLE_BUFFERS_ARB
      *iv_return = (IV)GL_SAMPLE_BUFFERS_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLE_BUFFERS_EXT", 21)) {
    /*                               ^           */
#ifdef GL_SAMPLE_BUFFERS_EXT
      *iv_return = (IV)GL_SAMPLE_BUFFERS_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SHADER_IMAGE_STORE", 21)) {
    /*                               ^           */
#ifdef GL_SHADER_IMAGE_STORE
      *iv_return = (IV)GL_SHADER_IMAGE_STORE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'T':
    if (memEQ(name, "GL_ACTIVE_SUBROUTINES", 21)) {
    /*                               ^           */
#ifdef GL_ACTIVE_SUBROUTINES
      *iv_return = (IV)GL_ACTIVE_SUBROUTINES;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CLIP_NEAR_HINT_PGI", 21)) {
    /*                               ^           */
#ifdef GL_CLIP_NEAR_HINT_PGI
      *iv_return = (IV)GL_CLIP_NEAR_HINT_PGI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_ARRAY_STRIDE", 21)) {
    /*                               ^           */
#ifdef GL_COLOR_ARRAY_STRIDE
      *iv_return = (IV)GL_COLOR_ARRAY_STRIDE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CURRENT_WEIGHT_ARB", 21)) {
    /*                               ^           */
#ifdef GL_CURRENT_WEIGHT_ARB
      *iv_return = (IV)GL_CURRENT_WEIGHT_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INDEX_ARRAY_STRIDE", 21)) {
    /*                               ^           */
#ifdef GL_INDEX_ARRAY_STRIDE
      *iv_return = (IV)GL_INDEX_ARRAY_STRIDE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LARGE_CW_ARC_TO_NV", 21)) {
    /*                               ^           */
#ifdef GL_LARGE_CW_ARC_TO_NV
      *iv_return = (IV)GL_LARGE_CW_ARC_TO_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LOCAL_CONSTANT_EXT", 21)) {
    /*                               ^           */
#ifdef GL_LOCAL_CONSTANT_EXT
      *iv_return = (IV)GL_LOCAL_CONSTANT_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAP_PERSISTENT_BIT", 21)) {
    /*                               ^           */
#ifdef GL_MAP_PERSISTENT_BIT
      *iv_return = (IV)GL_MAP_PERSISTENT_BIT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_PATCH_VERTICES", 21)) {
    /*                               ^           */
#ifdef GL_MAX_PATCH_VERTICES
      *iv_return = (IV)GL_MAX_PATCH_VERTICES;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_VERTEX_ATTRIBS", 21)) {
    /*                               ^           */
#ifdef GL_MAX_VERTEX_ATTRIBS
      *iv_return = (IV)GL_MAX_VERTEX_ATTRIBS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PACK_CMYK_HINT_EXT", 21)) {
    /*                               ^           */
#ifdef GL_PACK_CMYK_HINT_EXT
      *iv_return = (IV)GL_PACK_CMYK_HINT_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PASS_THROUGH_TOKEN", 21)) {
    /*                               ^           */
#ifdef GL_PASS_THROUGH_TOKEN
      *iv_return = (IV)GL_PASS_THROUGH_TOKEN;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PERFMON_RESULT_AMD", 21)) {
    /*                               ^           */
#ifdef GL_PERFMON_RESULT_AMD
      *iv_return = (IV)GL_PERFMON_RESULT_AMD;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_POLYGON_OFFSET_EXT", 21)) {
    /*                               ^           */
#ifdef GL_POLYGON_OFFSET_EXT
      *iv_return = (IV)GL_POLYGON_OFFSET_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PROGRAM_FORMAT_ARB", 21)) {
    /*                               ^           */
#ifdef GL_PROGRAM_FORMAT_ARB
      *iv_return = (IV)GL_PROGRAM_FORMAT_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PROGRAM_OBJECT_ARB", 21)) {
    /*                               ^           */
#ifdef GL_PROGRAM_OBJECT_ARB
      *iv_return = (IV)GL_PROGRAM_OBJECT_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PROGRAM_OBJECT_EXT", 21)) {
    /*                               ^           */
#ifdef GL_PROGRAM_OBJECT_EXT
      *iv_return = (IV)GL_PROGRAM_OBJECT_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RELATIVE_ARC_TO_NV", 21)) {
    /*                               ^           */
#ifdef GL_RELATIVE_ARC_TO_NV
      *iv_return = (IV)GL_RELATIVE_ARC_TO_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_REPLACE_OLDEST_SUN", 21)) {
    /*                               ^           */
#ifdef GL_REPLACE_OLDEST_SUN
      *iv_return = (IV)GL_REPLACE_OLDEST_SUN;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLER_OBJECT_AMD", 21)) {
    /*                               ^           */
#ifdef GL_SAMPLER_OBJECT_AMD
      *iv_return = (IV)GL_SAMPLER_OBJECT_AMD;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SIGNED_IDENTITY_NV", 21)) {
    /*                               ^           */
#ifdef GL_SIGNED_IDENTITY_NV
      *iv_return = (IV)GL_SIGNED_IDENTITY_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SMALL_CW_ARC_TO_NV", 21)) {
    /*                               ^           */
#ifdef GL_SMALL_CW_ARC_TO_NV
      *iv_return = (IV)GL_SMALL_CW_ARC_TO_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_WIDE_LINE_HINT_PGI", 21)) {
    /*                               ^           */
#ifdef GL_WIDE_LINE_HINT_PGI
      *iv_return = (IV)GL_WIDE_LINE_HINT_PGI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'U':
    if (memEQ(name, "GL_COMPUTE_SUBROUTINE", 21)) {
    /*                               ^           */
#ifdef GL_COMPUTE_SUBROUTINE
      *iv_return = (IV)GL_COMPUTE_SUBROUTINE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INT_SAMPLER_BUFFER", 21)) {
    /*                               ^           */
#ifdef GL_INT_SAMPLER_BUFFER
      *iv_return = (IV)GL_INT_SAMPLER_BUFFER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SRC_ALPHA_SATURATE", 21)) {
    /*                               ^           */
#ifdef GL_SRC_ALPHA_SATURATE
      *iv_return = (IV)GL_SRC_ALPHA_SATURATE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'V':
    if (memEQ(name, "GL_PATH_FORMAT_SVG_NV", 21)) {
    /*                               ^           */
#ifdef GL_PATH_FORMAT_SVG_NV
      *iv_return = (IV)GL_PATH_FORMAT_SVG_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'W':
    if (memEQ(name, "GL_RENDERBUFFER_WIDTH", 21)) {
    /*                               ^           */
#ifdef GL_RENDERBUFFER_WIDTH
      *iv_return = (IV)GL_RENDERBUFFER_WIDTH;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'X':
    if (memEQ(name, "GL_CURRENT_MATRIX_ARB", 21)) {
    /*                               ^           */
#ifdef GL_CURRENT_MATRIX_ARB
      *iv_return = (IV)GL_CURRENT_MATRIX_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CURRENT_VERTEX_EXT", 21)) {
    /*                               ^           */
#ifdef GL_CURRENT_VERTEX_EXT
      *iv_return = (IV)GL_CURRENT_VERTEX_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_POINT_SIZE_MAX_ARB", 21)) {
    /*                               ^           */
#ifdef GL_POINT_SIZE_MAX_ARB
      *iv_return = (IV)GL_POINT_SIZE_MAX_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_POINT_SIZE_MAX_EXT", 21)) {
    /*                               ^           */
#ifdef GL_POINT_SIZE_MAX_EXT
      *iv_return = (IV)GL_POINT_SIZE_MAX_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PROGRAM_MATRIX_EXT", 21)) {
    /*                               ^           */
#ifdef GL_PROGRAM_MATRIX_EXT
      *iv_return = (IV)GL_PROGRAM_MATRIX_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'Y':
    if (memEQ(name, "GL_BINORMAL_ARRAY_EXT", 21)) {
    /*                               ^           */
#ifdef GL_BINORMAL_ARRAY_EXT
      *iv_return = (IV)GL_BINORMAL_ARRAY_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEBUG_SEVERITY_LOW", 21)) {
    /*                               ^           */
#ifdef GL_DEBUG_SEVERITY_LOW
      *iv_return = (IV)GL_DEBUG_SEVERITY_LOW;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_HSL_LUMINOSITY_KHR", 21)) {
    /*                               ^           */
#ifdef GL_HSL_LUMINOSITY_KHR
      *iv_return = (IV)GL_HSL_LUMINOSITY_KHR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_IMAGE_1D_ARRAY_EXT", 21)) {
    /*                               ^           */
#ifdef GL_IMAGE_1D_ARRAY_EXT
      *iv_return = (IV)GL_IMAGE_1D_ARRAY_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_IMAGE_2D_ARRAY_EXT", 21)) {
    /*                               ^           */
#ifdef GL_IMAGE_2D_ARRAY_EXT
      *iv_return = (IV)GL_IMAGE_2D_ARRAY_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'Z':
    if (memEQ(name, "GL_TEXTURE_DS_SIZE_NV", 21)) {
    /*                               ^           */
#ifdef GL_TEXTURE_DS_SIZE_NV
      *iv_return = (IV)GL_TEXTURE_DS_SIZE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_DT_SIZE_NV", 21)) {
    /*                               ^           */
#ifdef GL_TEXTURE_DT_SIZE_NV
      *iv_return = (IV)GL_TEXTURE_DT_SIZE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_HI_SIZE_NV", 21)) {
    /*                               ^           */
#ifdef GL_TEXTURE_HI_SIZE_NV
      *iv_return = (IV)GL_TEXTURE_HI_SIZE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_LO_SIZE_NV", 21)) {
    /*                               ^           */
#ifdef GL_TEXTURE_LO_SIZE_NV
      *iv_return = (IV)GL_TEXTURE_LO_SIZE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '_':
    if (memEQ(name, "GLEW_ARB_texture_view", 21)) {
    /*                               ^           */
#ifdef GLEW_ARB_texture_view
      *iv_return = (IV)GLEW_ARB_texture_view;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_EXT_stencil_wrap", 21)) {
    /*                               ^           */
#ifdef GLEW_EXT_stencil_wrap
      *iv_return = (IV)GLEW_EXT_stencil_wrap;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_EXT_texture_sRGB", 21)) {
    /*                               ^           */
#ifdef GLEW_EXT_texture_sRGB
      *iv_return = (IV)GLEW_EXT_texture_sRGB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CLAMP_TO_EDGE_SGIS", 21)) {
    /*                               ^           */
#ifdef GL_CLAMP_TO_EDGE_SGIS
      *iv_return = (IV)GL_CLAMP_TO_EDGE_SGIS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEPTH_TEXTURE_MODE", 21)) {
    /*                               ^           */
#ifdef GL_DEPTH_TEXTURE_MODE
      *iv_return = (IV)GL_DEPTH_TEXTURE_MODE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_HISTOGRAM_RED_SIZE", 21)) {
    /*                               ^           */
#ifdef GL_HISTOGRAM_RED_SIZE
      *iv_return = (IV)GL_HISTOGRAM_RED_SIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_IBM_rasterpos_clip", 21)) {
    /*                               ^           */
#ifdef GL_IBM_rasterpos_clip
      *iv_return = (IV)GL_IBM_rasterpos_clip;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_IMAGE_BINDING_NAME", 21)) {
    /*                               ^           */
#ifdef GL_IMAGE_BINDING_NAME
      *iv_return = (IV)GL_IMAGE_BINDING_NAME;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_IMAGE_CLASS_1_X_16", 21)) {
    /*                               ^           */
#ifdef GL_IMAGE_CLASS_1_X_16
      *iv_return = (IV)GL_IMAGE_CLASS_1_X_16;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_IMAGE_CLASS_1_X_32", 21)) {
    /*                               ^           */
#ifdef GL_IMAGE_CLASS_1_X_32
      *iv_return = (IV)GL_IMAGE_CLASS_1_X_32;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_IMAGE_CLASS_2_X_16", 21)) {
    /*                               ^           */
#ifdef GL_IMAGE_CLASS_2_X_16
      *iv_return = (IV)GL_IMAGE_CLASS_2_X_16;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_IMAGE_CLASS_2_X_32", 21)) {
    /*                               ^           */
#ifdef GL_IMAGE_CLASS_2_X_32
      *iv_return = (IV)GL_IMAGE_CLASS_2_X_32;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_IMAGE_CLASS_4_X_16", 21)) {
    /*                               ^           */
#ifdef GL_IMAGE_CLASS_4_X_16
      *iv_return = (IV)GL_IMAGE_CLASS_4_X_16;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_IMAGE_CLASS_4_X_32", 21)) {
    /*                               ^           */
#ifdef GL_IMAGE_CLASS_4_X_32
      *iv_return = (IV)GL_IMAGE_CLASS_4_X_32;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_INTENSITY_SGIS", 21)) {
    /*                               ^           */
#ifdef GL_MAX_INTENSITY_SGIS
      *iv_return = (IV)GL_MAX_INTENSITY_SGIS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_LUMINANCE_SGIS", 21)) {
    /*                               ^           */
#ifdef GL_MAX_LUMINANCE_SGIS
      *iv_return = (IV)GL_MAX_LUMINANCE_SGIS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MIN_INTENSITY_SGIS", 21)) {
    /*                               ^           */
#ifdef GL_MIN_INTENSITY_SGIS
      *iv_return = (IV)GL_MIN_INTENSITY_SGIS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MIN_LUMINANCE_SGIS", 21)) {
    /*                               ^           */
#ifdef GL_MIN_LUMINANCE_SGIS
      *iv_return = (IV)GL_MIN_LUMINANCE_SGIS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PACK_RESAMPLE_SGIX", 21)) {
    /*                               ^           */
#ifdef GL_PACK_RESAMPLE_SGIX
      *iv_return = (IV)GL_PACK_RESAMPLE_SGIX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PROGRAM_POINT_SIZE", 21)) {
    /*                               ^           */
#ifdef GL_PROGRAM_POINT_SIZE
      *iv_return = (IV)GL_PROGRAM_POINT_SIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_QUERY_COUNTER_BITS", 21)) {
    /*                               ^           */
#ifdef GL_QUERY_COUNTER_BITS
      *iv_return = (IV)GL_QUERY_COUNTER_BITS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RED_MAX_CLAMP_INGR", 21)) {
    /*                               ^           */
#ifdef GL_RED_MAX_CLAMP_INGR
      *iv_return = (IV)GL_RED_MAX_CLAMP_INGR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RED_MIN_CLAMP_INGR", 21)) {
    /*                               ^           */
#ifdef GL_RED_MIN_CLAMP_INGR
      *iv_return = (IV)GL_RED_MIN_CLAMP_INGR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGBA16_SIGNED_SGIX", 21)) {
    /*                               ^           */
#ifdef GL_RGBA16_SIGNED_SGIX
      *iv_return = (IV)GL_RGBA16_SIGNED_SGIX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STENCIL_VALUE_MASK", 21)) {
    /*                               ^           */
#ifdef GL_STENCIL_VALUE_MASK
      *iv_return = (IV)GL_STENCIL_VALUE_MASK;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SUNX_constant_data", 21)) {
    /*                               ^           */
#ifdef GL_SUNX_constant_data
      *iv_return = (IV)GL_SUNX_constant_data;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_ALPHA_SIZE", 21)) {
    /*                               ^           */
#ifdef GL_TEXTURE_ALPHA_SIZE
      *iv_return = (IV)GL_TEXTURE_ALPHA_SIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_ALPHA_TYPE", 21)) {
    /*                               ^           */
#ifdef GL_TEXTURE_ALPHA_TYPE
      *iv_return = (IV)GL_TEXTURE_ALPHA_TYPE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_DEPTH_SIZE", 21)) {
    /*                               ^           */
#ifdef GL_TEXTURE_DEPTH_SIZE
      *iv_return = (IV)GL_TEXTURE_DEPTH_SIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_DEPTH_TYPE", 21)) {
    /*                               ^           */
#ifdef GL_TEXTURE_DEPTH_TYPE
      *iv_return = (IV)GL_TEXTURE_DEPTH_TYPE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_GREEN_SIZE", 21)) {
    /*                               ^           */
#ifdef GL_TEXTURE_GREEN_SIZE
      *iv_return = (IV)GL_TEXTURE_GREEN_SIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_GREEN_TYPE", 21)) {
    /*                               ^           */
#ifdef GL_TEXTURE_GREEN_TYPE
      *iv_return = (IV)GL_TEXTURE_GREEN_TYPE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_IMAGE_TYPE", 21)) {
    /*                               ^           */
#ifdef GL_TEXTURE_IMAGE_TYPE
      *iv_return = (IV)GL_TEXTURE_IMAGE_TYPE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VIEW_CLASS_16_BITS", 21)) {
    /*                               ^           */
#ifdef GL_VIEW_CLASS_16_BITS
      *iv_return = (IV)GL_VIEW_CLASS_16_BITS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VIEW_CLASS_24_BITS", 21)) {
    /*                               ^           */
#ifdef GL_VIEW_CLASS_24_BITS
      *iv_return = (IV)GL_VIEW_CLASS_24_BITS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VIEW_CLASS_32_BITS", 21)) {
    /*                               ^           */
#ifdef GL_VIEW_CLASS_32_BITS
      *iv_return = (IV)GL_VIEW_CLASS_32_BITS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VIEW_CLASS_48_BITS", 21)) {
    /*                               ^           */
#ifdef GL_VIEW_CLASS_48_BITS
      *iv_return = (IV)GL_VIEW_CLASS_48_BITS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VIEW_CLASS_64_BITS", 21)) {
    /*                               ^           */
#ifdef GL_VIEW_CLASS_64_BITS
      *iv_return = (IV)GL_VIEW_CLASS_64_BITS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VIEW_CLASS_96_BITS", 21)) {
    /*                               ^           */
#ifdef GL_VIEW_CLASS_96_BITS
      *iv_return = (IV)GL_VIEW_CLASS_96_BITS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'a':
    if (memEQ(name, "GLEW_3DFX_multisample", 21)) {
    /*                               ^           */
#ifdef GLEW_3DFX_multisample
      *iv_return = (IV)GLEW_3DFX_multisample;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_EXT_debug_marker", 21)) {
    /*                               ^           */
#ifdef GLEW_EXT_debug_marker
      *iv_return = (IV)GLEW_EXT_debug_marker;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_EXT_scene_marker", 21)) {
    /*                               ^           */
#ifdef GLEW_EXT_scene_marker
      *iv_return = (IV)GLEW_EXT_scene_marker;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_EXT_vertex_array", 21)) {
    /*                               ^           */
#ifdef GLEW_EXT_vertex_array
      *iv_return = (IV)GLEW_EXT_vertex_array;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_SGIS_multisample", 21)) {
    /*                               ^           */
#ifdef GLEW_SGIS_multisample
      *iv_return = (IV)GLEW_SGIS_multisample;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_SGI_color_matrix", 21)) {
    /*                               ^           */
#ifdef GLEW_SGI_color_matrix
      *iv_return = (IV)GLEW_SGI_color_matrix;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_SUN_global_alpha", 21)) {
    /*                               ^           */
#ifdef GLEW_SUN_global_alpha
      *iv_return = (IV)GLEW_SUN_global_alpha;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_draw_instanced", 21)) {
    /*                               ^           */
#ifdef GL_ARB_draw_instanced
      *iv_return = (IV)GL_ARB_draw_instanced;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_sample_shading", 21)) {
    /*                               ^           */
#ifdef GL_ARB_sample_shading
      *iv_return = (IV)GL_ARB_sample_shading;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_texture_gather", 21)) {
    /*                               ^           */
#ifdef GL_ARB_texture_gather
      *iv_return = (IV)GL_ARB_texture_gather;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_viewport_array", 21)) {
    /*                               ^           */
#ifdef GL_ARB_viewport_array
      *iv_return = (IV)GL_ARB_viewport_array;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_draw_instanced", 21)) {
    /*                               ^           */
#ifdef GL_EXT_draw_instanced
      *iv_return = (IV)GL_EXT_draw_instanced;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_texture_shader2", 21)) {
    /*                               ^           */
#ifdef GL_NV_texture_shader2
      *iv_return = (IV)GL_NV_texture_shader2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_texture_shader3", 21)) {
    /*                               ^           */
#ifdef GL_NV_texture_shader3
      *iv_return = (IV)GL_NV_texture_shader3;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'b':
    if (memEQ(name, "GLEW_ARB_vertex_blend", 21)) {
    /*                               ^           */
#ifdef GLEW_ARB_vertex_blend
      *iv_return = (IV)GLEW_ARB_vertex_blend;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_shadow_ambient", 21)) {
    /*                               ^           */
#ifdef GL_ARB_shadow_ambient
      *iv_return = (IV)GL_ARB_shadow_ambient;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_texture_object", 21)) {
    /*                               ^           */
#ifdef GL_EXT_texture_object
      *iv_return = (IV)GL_EXT_texture_object;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'c':
    if (memEQ(name, "GLEW_ARB_shader_clock", 21)) {
    /*                               ^           */
#ifdef GLEW_ARB_shader_clock
      *iv_return = (IV)GLEW_ARB_shader_clock;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_INGR_color_clamp", 21)) {
    /*                               ^           */
#ifdef GLEW_INGR_color_clamp
      *iv_return = (IV)GLEW_INGR_color_clamp;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'd':
    if (memEQ(name, "GL_REGAL_proc_address", 21)) {
    /*                               ^           */
#ifdef GL_REGAL_proc_address
      *iv_return = (IV)GL_REGAL_proc_address;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'e':
    if (memEQ(name, "GLEW_SGIS_texture_lod", 21)) {
    /*                               ^           */
#ifdef GLEW_SGIS_texture_lod
      *iv_return = (IV)GLEW_SGIS_texture_lod;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_index_material", 21)) {
    /*                               ^           */
#ifdef GL_EXT_index_material
      *iv_return = (IV)GL_EXT_index_material;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'f':
    if (memEQ(name, "GLEW_ARB_draw_buffers", 21)) {
    /*                               ^           */
#ifdef GLEW_ARB_draw_buffers
      *iv_return = (IV)GLEW_ARB_draw_buffers;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_ATI_draw_buffers", 21)) {
    /*                               ^           */
#ifdef GLEW_ATI_draw_buffers
      *iv_return = (IV)GLEW_ATI_draw_buffers;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_EXT_packed_float", 21)) {
    /*                               ^           */
#ifdef GLEW_EXT_packed_float
      *iv_return = (IV)GLEW_EXT_packed_float;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_EXT_shadow_funcs", 21)) {
    /*                               ^           */
#ifdef GLEW_EXT_shadow_funcs
      *iv_return = (IV)GLEW_EXT_shadow_funcs;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_polygon_offset", 21)) {
    /*                               ^           */
#ifdef GL_EXT_polygon_offset
      *iv_return = (IV)GL_EXT_polygon_offset;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'g':
    if (memEQ(name, "GL_NV_vertex_program2", 21)) {
    /*                               ^           */
#ifdef GL_NV_vertex_program2
      *iv_return = (IV)GL_NV_vertex_program2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_vertex_program3", 21)) {
    /*                               ^           */
#ifdef GL_NV_vertex_program3
      *iv_return = (IV)GL_NV_vertex_program3;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_vertex_program4", 21)) {
    /*                               ^           */
#ifdef GL_NV_vertex_program4
      *iv_return = (IV)GL_NV_vertex_program4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'h':
    if (memEQ(name, "GLEW_PGI_vertex_hints", 21)) {
    /*                               ^           */
#ifdef GLEW_PGI_vertex_hints
      *iv_return = (IV)GLEW_PGI_vertex_hints;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_compute_shader", 21)) {
    /*                               ^           */
#ifdef GL_ARB_compute_shader
      *iv_return = (IV)GL_ARB_compute_shader;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'i':
    if (memEQ(name, "GLEW_EXT_blend_minmax", 21)) {
    /*                               ^           */
#ifdef GLEW_EXT_blend_minmax
      *iv_return = (IV)GLEW_EXT_blend_minmax;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_NV_gpu_multicast", 21)) {
    /*                               ^           */
#ifdef GLEW_NV_gpu_multicast
      *iv_return = (IV)GLEW_NV_gpu_multicast;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_APPLE_float_pixels", 21)) {
    /*                               ^           */
#ifdef GL_APPLE_float_pixels
      *iv_return = (IV)GL_APPLE_float_pixels;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_blend_logic_op", 21)) {
    /*                               ^           */
#ifdef GL_EXT_blend_logic_op
      *iv_return = (IV)GL_EXT_blend_logic_op;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_misc_attribute", 21)) {
    /*                               ^           */
#ifdef GL_EXT_misc_attribute
      *iv_return = (IV)GL_EXT_misc_attribute;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'j':
    if (memEQ(name, "GL_ARB_shader_objects", 21)) {
    /*                               ^           */
#ifdef GL_ARB_shader_objects
      *iv_return = (IV)GL_ARB_shader_objects;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'l':
    if (memEQ(name, "GL_ARB_matrix_palette", 21)) {
    /*                               ^           */
#ifdef GL_ARB_matrix_palette
      *iv_return = (IV)GL_ARB_matrix_palette;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'm':
    if (memEQ(name, "GLEW_NV_texgen_emboss", 21)) {
    /*                               ^           */
#ifdef GLEW_NV_texgen_emboss
      *iv_return = (IV)GLEW_NV_texgen_emboss;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ATI_envmap_bumpmap", 21)) {
    /*                               ^           */
#ifdef GL_ATI_envmap_bumpmap
      *iv_return = (IV)GL_ATI_envmap_bumpmap;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'n':
    if (memEQ(name, "GLEW_ARB_clip_control", 21)) {
    /*                               ^           */
#ifdef GLEW_ARB_clip_control
      *iv_return = (IV)GLEW_ARB_clip_control;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_ATI_pn_triangles", 21)) {
    /*                               ^           */
#ifdef GLEW_ATI_pn_triangles
      *iv_return = (IV)GLEW_ATI_pn_triangles;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_MESA_pack_invert", 21)) {
    /*                               ^           */
#ifdef GLEW_MESA_pack_invert
      *iv_return = (IV)GLEW_MESA_pack_invert;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'o':
    if (memEQ(name, "GL_ARB_buffer_storage", 21)) {
    /*                               ^           */
#ifdef GL_ARB_buffer_storage
      *iv_return = (IV)GL_ARB_buffer_storage;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_vertex_program", 21)) {
    /*                               ^           */
#ifdef GL_ARB_vertex_program
      *iv_return = (IV)GL_ARB_vertex_program;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_rescale_normal", 21)) {
    /*                               ^           */
#ifdef GL_EXT_rescale_normal
      *iv_return = (IV)GL_EXT_rescale_normal;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SGIX_list_priority", 21)) {
    /*                               ^           */
#ifdef GL_SGIX_list_priority
      *iv_return = (IV)GL_SGIX_list_priority;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'p':
    if (memEQ(name, "GLEW_ARB_point_sprite", 21)) {
    /*                               ^           */
#ifdef GLEW_ARB_point_sprite
      *iv_return = (IV)GLEW_ARB_point_sprite;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_NV_video_capture", 21)) {
    /*                               ^           */
#ifdef GLEW_NV_video_capture
      *iv_return = (IV)GLEW_NV_video_capture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_SGIX_async_pixel", 21)) {
    /*                               ^           */
#ifdef GLEW_SGIX_async_pixel
      *iv_return = (IV)GLEW_SGIX_async_pixel;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'q':
    if (memEQ(name, "GL_NV_occlusion_query", 21)) {
    /*                               ^           */
#ifdef GL_NV_occlusion_query
      *iv_return = (IV)GL_NV_occlusion_query;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'r':
    if (memEQ(name, "GLEW_SGIS_color_range", 21)) {
    /*                               ^           */
#ifdef GLEW_SGIS_color_range
      *iv_return = (IV)GLEW_SGIS_color_range;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_WIN_specular_fog", 21)) {
    /*                               ^           */
#ifdef GLEW_WIN_specular_fog
      *iv_return = (IV)GLEW_WIN_specular_fog;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ATIX_point_sprites", 21)) {
    /*                               ^           */
#ifdef GL_ATIX_point_sprites
      *iv_return = (IV)GL_ATIX_point_sprites;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ATI_vertex_streams", 21)) {
    /*                               ^           */
#ifdef GL_ATI_vertex_streams
      *iv_return = (IV)GL_ATI_vertex_streams;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_texture_barrier", 21)) {
    /*                               ^           */
#ifdef GL_NV_texture_barrier
      *iv_return = (IV)GL_NV_texture_barrier;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_viewport_array2", 21)) {
    /*                               ^           */
#ifdef GL_NV_viewport_array2
      *iv_return = (IV)GL_NV_viewport_array2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SGIX_texture_range", 21)) {
    /*                               ^           */
#ifdef GL_SGIX_texture_range
      *iv_return = (IV)GL_SGIX_texture_range;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 's':
    if (memEQ(name, "GL_HP_image_transform", 21)) {
    /*                               ^           */
#ifdef GL_HP_image_transform
      *iv_return = (IV)GL_HP_image_transform;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 't':
    if (memEQ(name, "GLEW_NV_vdpau_interop", 21)) {
    /*                               ^           */
#ifdef GLEW_NV_vdpau_interop
      *iv_return = (IV)GLEW_NV_vdpau_interop;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_blend_subtract", 21)) {
    /*                               ^           */
#ifdef GL_EXT_blend_subtract
      *iv_return = (IV)GL_EXT_blend_subtract;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_color_subtable", 21)) {
    /*                               ^           */
#ifdef GL_EXT_color_subtable
      *iv_return = (IV)GL_EXT_color_subtable;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_REGAL_error_string", 21)) {
    /*                               ^           */
#ifdef GL_REGAL_error_string
      *iv_return = (IV)GL_REGAL_error_string;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'u':
    if (memEQ(name, "GLEW_AMD_debug_output", 21)) {
    /*                               ^           */
#ifdef GLEW_AMD_debug_output
      *iv_return = (IV)GLEW_AMD_debug_output;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_ARB_debug_output", 21)) {
    /*                               ^           */
#ifdef GLEW_ARB_debug_output
      *iv_return = (IV)GLEW_ARB_debug_output;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_APPLE_pixel_buffer", 21)) {
    /*                               ^           */
#ifdef GL_APPLE_pixel_buffer
      *iv_return = (IV)GL_APPLE_pixel_buffer;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'v':
    if (memEQ(name, "GLEW_NV_present_video", 21)) {
    /*                               ^           */
#ifdef GLEW_NV_present_video
      *iv_return = (IV)GLEW_NV_present_video;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'x':
    if (memEQ(name, "GLEW_ARB_multitexture", 21)) {
    /*                               ^           */
#ifdef GLEW_ARB_multitexture
      *iv_return = (IV)GLEW_ARB_multitexture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_EXT_copy_texture", 21)) {
    /*                               ^           */
#ifdef GLEW_EXT_copy_texture
      *iv_return = (IV)GLEW_EXT_copy_texture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_SGIX_fog_texture", 21)) {
    /*                               ^           */
#ifdef GLEW_SGIX_fog_texture
      *iv_return = (IV)GLEW_SGIX_fog_texture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_AMD_sparse_texture", 21)) {
    /*                               ^           */
#ifdef GL_AMD_sparse_texture
      *iv_return = (IV)GL_AMD_sparse_texture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_sparse_texture", 21)) {
    /*                               ^           */
#ifdef GL_ARB_sparse_texture
      *iv_return = (IV)GL_ARB_sparse_texture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MESA_ycbcr_texture", 21)) {
    /*                               ^           */
#ifdef GL_MESA_ycbcr_texture
      *iv_return = (IV)GL_MESA_ycbcr_texture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SGIS_pixel_texture", 21)) {
    /*                               ^           */
#ifdef GL_SGIS_pixel_texture
      *iv_return = (IV)GL_SGIS_pixel_texture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SGIX_depth_texture", 21)) {
    /*                               ^           */
#ifdef GL_SGIX_depth_texture
      *iv_return = (IV)GL_SGIX_depth_texture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SGIX_pixel_texture", 21)) {
    /*                               ^           */
#ifdef GL_SGIX_pixel_texture
      *iv_return = (IV)GL_SGIX_pixel_texture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  }
  return PERL_constant_NOTFOUND;
}

static int
constant_22 (pTHX_ const char *name, IV *iv_return) {
  /* When generated this function returned values for the list of names given
     here.  However, subsequent manual editing may have added or removed some.
     GLEW_AMD_pinned_memory GLEW_ANGLE_timer_query GLEW_ARB_base_instance
     GLEW_ARB_clear_texture GLEW_ARB_compatibility GLEW_ARB_cull_distance
     GLEW_ARB_depth_texture GLEW_ARB_draw_indirect GLEW_ARB_shader_ballot
     GLEW_ARB_sparse_buffer GLEW_ARB_texture_float GLEW_ARB_vertex_shader
     GLEW_ATI_element_array GLEW_ATI_texture_float GLEW_EXT_draw_buffers2
     GLEW_EXT_index_texture GLEW_EXT_light_texture GLEW_EXT_packed_pixels
     GLEW_EXT_texture_array GLEW_EXT_texture_snorm GLEW_EXT_vertex_shader
     GLEW_HP_occlusion_test GLEW_INTEL_map_texture GLEW_KTX_buffer_region
     GLEW_NV_deep_texture3D GLEW_NV_fill_rectangle GLEW_NV_path_rendering
     GLEW_NV_texture_shader GLEW_NV_vertex_program GLEW_SGIS_fog_function
     GLEW_SGIX_flush_raster GLEW_SUN_triangle_list GLEW_WIN_phong_shading
     GL_422_REV_AVERAGE_EXT GL_ALL_STATIC_DATA_IBM GL_ALPHA16_SIGNED_SGIX
     GL_ALPHA_FLOAT16_APPLE GL_ALPHA_FLOAT32_APPLE GL_AMBIENT_AND_DIFFUSE
     GL_AMD_name_gen_delete GL_ANGLE_depth_texture GL_ANGLE_texture_usage
     GL_APPLE_element_array GL_APPLE_texture_range GL_ARB_fragment_shader
     GL_ARB_gpu_shader_fp64 GL_ARB_occlusion_query GL_ARB_sampler_objects
     GL_ARB_sparse_texture2 GL_ARB_texture_barrier GL_ARB_texture_env_add
     GL_ARB_texture_storage GL_ARB_texture_swizzle GL_ATI_fragment_shader
     GL_BLEND_DST_ALPHA_EXT GL_BLEND_SRC_ALPHA_EXT GL_BLUE_MAX_CLAMP_INGR
     GL_BLUE_MIN_CLAMP_INGR GL_BUFFER_ACCESS_FLAGS GL_BUFFER_OBJECT_APPLE
     GL_BUMP_ROT_MATRIX_ATI GL_CLAMP_TO_BORDER_ARB GL_COLOR_ARRAY_POINTER
     GL_COLOR_MATERIAL_FACE GL_COMBINER_MAPPING_NV GL_COMBINER_MUX_SUM_NV
     GL_COMMAND_BARRIER_BIT GL_COMPILE_AND_EXECUTE GL_COMPRESSED_RG11_EAC
     GL_COMPRESSED_RGBA_ARB GL_COMPRESSED_RG_RGTC2 GL_COMPRESSED_SRGB_EXT
     GL_CONDITION_SATISFIED GL_CURRENT_QUERY_ANGLE GL_CURRENT_TANGENT_EXT
     GL_DEBUG_SEVERITY_HIGH GL_DEPTH_CLAMP_FAR_AMD GL_DYNAMIC_STORAGE_BIT
     GL_EDGE_FLAG_ARRAY_EXT GL_ELEMENT_ARRAY_APPLE GL_EXTENDED_RANGE_SGIS
     GL_EXT_pixel_transform GL_EXT_secondary_color GL_EXT_sparse_texture2
     GL_EXT_texture_env_add GL_EXT_texture_integer GL_EXT_texture_swizzle
     GL_EXT_x11_sync_object GL_FONT_UNAVAILABLE_NV GL_FRAGMENT_LIGHT0_EXT
     GL_FRAGMENT_LIGHT7_EXT GL_FRAGMENT_NORMAL_EXT GL_FRAGMENT_PROGRAM_NV
     GL_FRAGMENT_SHADER_ARB GL_FRAGMENT_SHADER_ATI GL_FRAGMENT_SHADER_BIT
     GL_FRAGMENT_SUBROUTINE GL_FRAMEBUFFER_BINDING GL_FRAMEBUFFER_DEFAULT
     GL_GEOMETRY_INPUT_TYPE GL_GEOMETRY_PROGRAM_NV GL_GEOMETRY_SHADER_ARB
     GL_GEOMETRY_SHADER_BIT GL_GEOMETRY_SHADER_EXT GL_GEOMETRY_SUBROUTINE
     GL_GLYPH_HEIGHT_BIT_NV GL_HALF_BIAS_NEGATE_NV GL_HALF_BIAS_NORMAL_NV
     GL_HISTOGRAM_BLUE_SIZE GL_HISTOGRAM_WIDTH_EXT GL_HP_texture_lighting
     GL_IMAGE_BINDING_LAYER GL_IMAGE_BINDING_LEVEL GL_INDEX_ARRAY_POINTER
     GL_INGR_interlace_read GL_INTERLACE_READ_INGR GL_INTERLEAVED_ATTRIBS
     GL_INT_SAMPLER_2D_RECT GL_INVARIANT_VALUE_EXT GL_LARGE_CCW_ARC_TO_NV
     GL_LAYOUT_LINEAR_INTEL GL_LIGHT_MODEL_AMBIENT GL_LINES_ADJACENCY_ARB
     GL_LINES_ADJACENCY_EXT GL_LINE_STIPPLE_REPEAT GL_LUMINANCE12_ALPHA12
     GL_LUMINANCE16_ALPHA16 GL_MAP_TESSELLATION_NV GL_MAT_AMBIENT_BIT_PGI
     GL_MAT_DIFFUSE_BIT_PGI GL_MAX_3D_TEXTURE_SIZE GL_MAX_IMAGE_UNITS_EXT
     GL_MAX_INTEGER_SAMPLES GL_MAX_PIXEL_MAP_TABLE GL_MAX_VARYING_VECTORS
     GL_MAX_VERTEX_HINT_PGI GL_MESAX_texture_stack GL_MESA_resize_buffers
     GL_MIN_LOD_WARNING_AMD GL_MIRRORED_REPEAT_ARB GL_MIRRORED_REPEAT_IBM
     GL_MULTISAMPLE_BIT_ARB GL_MULTISAMPLE_BIT_EXT GL_NEGATIVE_ONE_TO_ONE
     GL_NORMAL_ARRAY_STRIDE GL_NUM_FILL_STREAMS_NV GL_NVX_gpu_memory_info
     GL_NV_bindless_texture GL_NV_compute_program5 GL_NV_fragment_program
     GL_NV_geometry_shader4 GL_NV_gpu_program_fp64 GL_NV_pixel_data_range
     GL_NV_sample_locations GL_NV_viewport_swizzle GL_ONE_MINUS_DST_ALPHA
     GL_ONE_MINUS_DST_COLOR GL_ONE_MINUS_SRC_ALPHA GL_ONE_MINUS_SRC_COLOR
     GL_PATH_COORD_COUNT_NV GL_PATH_DASH_OFFSET_NV GL_PATH_MITER_LIMIT_NV
     GL_PATH_STENCIL_REF_NV GL_PATH_STROKE_MASK_NV GL_PIXEL_UNPACK_BUFFER
     GL_POLYGON_OFFSET_FILL GL_POLYGON_OFFSET_LINE GL_POLYGON_SMOOTH_HINT
     GL_POLYGON_STIPPLE_BIT GL_PRESENT_DURATION_NV GL_PROGRAM_ATTRIBS_ARB
     GL_PROGRAM_BINDING_ARB GL_PROGRAM_RESIDENT_NV GL_PROXY_HISTOGRAM_EXT
     GL_QUERY_WAIT_INVERTED GL_RELATIVE_LINE_TO_NV GL_RELATIVE_MOVE_TO_NV
     GL_RENDERBUFFER_HEIGHT GL_RGBA_FLOAT_MODE_ARB GL_SAMPLER_2D_RECT_ARB
     GL_SAMPLER_CUBE_SHADOW GL_SAMPLE_ALPHA_TO_ONE GL_SAMPLE_BUFFERS_3DFX
     GL_SAMPLE_BUFFERS_SGIS GL_SAMPLE_COVERAGE_ARB GL_SAMPLE_LOCATION_ARB
     GL_SAMPLE_PATTERN_SGIS GL_SEPARATE_ATTRIBS_NV GL_SGIS_detail_texture
     GL_SGIS_texture_select GL_SGIX_ir_instrument1 GL_SGIX_shadow_ambient
     GL_SGIX_vertex_preclip GL_SHADER_IMAGE_ATOMIC GL_SHADER_OPERATION_NV
     GL_SHADOW_AMBIENT_SGIX GL_SIGNED_INTENSITY_NV GL_SIGNED_LUMINANCE_NV
     GL_SMALL_CCW_ARC_TO_NV GL_STENCIL_CLEAR_VALUE GL_STENCIL_INDEX16_EXT
     GL_SWIZZLE_STRQ_DQ_ATI GL_SYSTEM_FONT_NAME_NV GL_TESS_CONTROL_SHADER
     GL_TESS_GEN_POINT_MODE GL_TEXTURE_BUFFER_SIZE GL_TEXTURE_COORD_ARRAY
     GL_TEXTURE_MAG_SIZE_NV GL_TEXTURE_SHARED_SIZE GL_TEXTURE_STACK_DEPTH
     GL_TEXTURE_USAGE_ANGLE GL_TRIANGLES_ADJACENCY GL_UNIFORM_BARRIER_BIT
     GL_UNIFORM_BLOCK_INDEX GL_UNIFORM_BUFFER_SIZE GL_UNIFORM_NAME_LENGTH
     GL_UNPACK_IMAGE_HEIGHT GL_UNPACK_RESAMPLE_OML GL_UNSIGNED_BYTE_3_3_2
     GL_UNSIGNED_NORMALIZED GL_VBO_FREE_MEMORY_ATI GL_VERTEX_ARRAY_STRIDE
     GL_VERTEX_PRECLIP_SGIX GL_VERTICAL_LINE_TO_NV GL_VIEWPORT_COMMAND_NV
     GL_VIEW_CLASS_128_BITS GL_VIEW_CLASS_RGTC2_RG */
  /* Offset 12 gives the best switch position.  */
  switch (name[12]) {
  case '1':
    if (memEQ(name, "GL_LUMINANCE12_ALPHA12", 22)) {
    /*                           ^                */
#ifdef GL_LUMINANCE12_ALPHA12
      *iv_return = (IV)GL_LUMINANCE12_ALPHA12;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LUMINANCE16_ALPHA16", 22)) {
    /*                           ^                */
#ifdef GL_LUMINANCE16_ALPHA16
      *iv_return = (IV)GL_LUMINANCE16_ALPHA16;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'A':
    if (memEQ(name, "GL_ALPHA_FLOAT16_APPLE", 22)) {
    /*                           ^                */
#ifdef GL_ALPHA_FLOAT16_APPLE
      *iv_return = (IV)GL_ALPHA_FLOAT16_APPLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ALPHA_FLOAT32_APPLE", 22)) {
    /*                           ^                */
#ifdef GL_ALPHA_FLOAT32_APPLE
      *iv_return = (IV)GL_ALPHA_FLOAT32_APPLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_ARRAY_POINTER", 22)) {
    /*                           ^                */
#ifdef GL_COLOR_ARRAY_POINTER
      *iv_return = (IV)GL_COLOR_ARRAY_POINTER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COMMAND_BARRIER_BIT", 22)) {
    /*                           ^                */
#ifdef GL_COMMAND_BARRIER_BIT
      *iv_return = (IV)GL_COMMAND_BARRIER_BIT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CURRENT_TANGENT_EXT", 22)) {
    /*                           ^                */
#ifdef GL_CURRENT_TANGENT_EXT
      *iv_return = (IV)GL_CURRENT_TANGENT_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FONT_UNAVAILABLE_NV", 22)) {
    /*                           ^                */
#ifdef GL_FONT_UNAVAILABLE_NV
      *iv_return = (IV)GL_FONT_UNAVAILABLE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INDEX_ARRAY_POINTER", 22)) {
    /*                           ^                */
#ifdef GL_INDEX_ARRAY_POINTER
      *iv_return = (IV)GL_INDEX_ARRAY_POINTER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LINES_ADJACENCY_ARB", 22)) {
    /*                           ^                */
#ifdef GL_LINES_ADJACENCY_ARB
      *iv_return = (IV)GL_LINES_ADJACENCY_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LINES_ADJACENCY_EXT", 22)) {
    /*                           ^                */
#ifdef GL_LINES_ADJACENCY_EXT
      *iv_return = (IV)GL_LINES_ADJACENCY_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MIN_LOD_WARNING_AMD", 22)) {
    /*                           ^                */
#ifdef GL_MIN_LOD_WARNING_AMD
      *iv_return = (IV)GL_MIN_LOD_WARNING_AMD;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PIXEL_UNPACK_BUFFER", 22)) {
    /*                           ^                */
#ifdef GL_PIXEL_UNPACK_BUFFER
      *iv_return = (IV)GL_PIXEL_UNPACK_BUFFER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SEPARATE_ATTRIBS_NV", 22)) {
    /*                           ^                */
#ifdef GL_SEPARATE_ATTRIBS_NV
      *iv_return = (IV)GL_SEPARATE_ATTRIBS_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SHADER_IMAGE_ATOMIC", 22)) {
    /*                           ^                */
#ifdef GL_SHADER_IMAGE_ATOMIC
      *iv_return = (IV)GL_SHADER_IMAGE_ATOMIC;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_MAG_SIZE_NV", 22)) {
    /*                           ^                */
#ifdef GL_TEXTURE_MAG_SIZE_NV
      *iv_return = (IV)GL_TEXTURE_MAG_SIZE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNIFORM_BARRIER_BIT", 22)) {
    /*                           ^                */
#ifdef GL_UNIFORM_BARRIER_BIT
      *iv_return = (IV)GL_UNIFORM_BARRIER_BIT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNIFORM_NAME_LENGTH", 22)) {
    /*                           ^                */
#ifdef GL_UNIFORM_NAME_LENGTH
      *iv_return = (IV)GL_UNIFORM_NAME_LENGTH;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNPACK_IMAGE_HEIGHT", 22)) {
    /*                           ^                */
#ifdef GL_UNPACK_IMAGE_HEIGHT
      *iv_return = (IV)GL_UNPACK_IMAGE_HEIGHT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'B':
    if (memEQ(name, "GL_CLAMP_TO_BORDER_ARB", 22)) {
    /*                           ^                */
#ifdef GL_CLAMP_TO_BORDER_ARB
      *iv_return = (IV)GL_CLAMP_TO_BORDER_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SHADOW_AMBIENT_SGIX", 22)) {
    /*                           ^                */
#ifdef GL_SHADOW_AMBIENT_SGIX
      *iv_return = (IV)GL_SHADOW_AMBIENT_SGIX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNSIGNED_BYTE_3_3_2", 22)) {
    /*                           ^                */
#ifdef GL_UNSIGNED_BYTE_3_3_2
      *iv_return = (IV)GL_UNSIGNED_BYTE_3_3_2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'C':
    if (memEQ(name, "GL_ALL_STATIC_DATA_IBM", 22)) {
    /*                           ^                */
#ifdef GL_ALL_STATIC_DATA_IBM
      *iv_return = (IV)GL_ALL_STATIC_DATA_IBM;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_BLUE_MAX_CLAMP_INGR", 22)) {
    /*                           ^                */
#ifdef GL_BLUE_MAX_CLAMP_INGR
      *iv_return = (IV)GL_BLUE_MAX_CLAMP_INGR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_BLUE_MIN_CLAMP_INGR", 22)) {
    /*                           ^                */
#ifdef GL_BLUE_MIN_CLAMP_INGR
      *iv_return = (IV)GL_BLUE_MIN_CLAMP_INGR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_BUFFER_ACCESS_FLAGS", 22)) {
    /*                           ^                */
#ifdef GL_BUFFER_ACCESS_FLAGS
      *iv_return = (IV)GL_BUFFER_ACCESS_FLAGS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PATH_STENCIL_REF_NV", 22)) {
    /*                           ^                */
#ifdef GL_PATH_STENCIL_REF_NV
      *iv_return = (IV)GL_PATH_STENCIL_REF_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLE_LOCATION_ARB", 22)) {
    /*                           ^                */
#ifdef GL_SAMPLE_LOCATION_ARB
      *iv_return = (IV)GL_SAMPLE_LOCATION_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VIEWPORT_COMMAND_NV", 22)) {
    /*                           ^                */
#ifdef GL_VIEWPORT_COMMAND_NV
      *iv_return = (IV)GL_VIEWPORT_COMMAND_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'D':
    if (memEQ(name, "GL_COMPRESSED_RG11_EAC", 22)) {
    /*                           ^                */
#ifdef GL_COMPRESSED_RG11_EAC
      *iv_return = (IV)GL_COMPRESSED_RG11_EAC;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COMPRESSED_RGBA_ARB", 22)) {
    /*                           ^                */
#ifdef GL_COMPRESSED_RGBA_ARB
      *iv_return = (IV)GL_COMPRESSED_RGBA_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COMPRESSED_RG_RGTC2", 22)) {
    /*                           ^                */
#ifdef GL_COMPRESSED_RG_RGTC2
      *iv_return = (IV)GL_COMPRESSED_RG_RGTC2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COMPRESSED_SRGB_EXT", 22)) {
    /*                           ^                */
#ifdef GL_COMPRESSED_SRGB_EXT
      *iv_return = (IV)GL_COMPRESSED_SRGB_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_IMAGE_BINDING_LAYER", 22)) {
    /*                           ^                */
#ifdef GL_IMAGE_BINDING_LAYER
      *iv_return = (IV)GL_IMAGE_BINDING_LAYER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_IMAGE_BINDING_LEVEL", 22)) {
    /*                           ^                */
#ifdef GL_IMAGE_BINDING_LEVEL
      *iv_return = (IV)GL_IMAGE_BINDING_LEVEL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PATH_COORD_COUNT_NV", 22)) {
    /*                           ^                */
#ifdef GL_PATH_COORD_COUNT_NV
      *iv_return = (IV)GL_PATH_COORD_COUNT_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLER_2D_RECT_ARB", 22)) {
    /*                           ^                */
#ifdef GL_SAMPLER_2D_RECT_ARB
      *iv_return = (IV)GL_SAMPLER_2D_RECT_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'E':
    if (memEQ(name, "GL_COLOR_MATERIAL_FACE", 22)) {
    /*                           ^                */
#ifdef GL_COLOR_MATERIAL_FACE
      *iv_return = (IV)GL_COLOR_MATERIAL_FACE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEBUG_SEVERITY_HIGH", 22)) {
    /*                           ^                */
#ifdef GL_DEBUG_SEVERITY_HIGH
      *iv_return = (IV)GL_DEBUG_SEVERITY_HIGH;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FRAMEBUFFER_BINDING", 22)) {
    /*                           ^                */
#ifdef GL_FRAMEBUFFER_BINDING
      *iv_return = (IV)GL_FRAMEBUFFER_BINDING;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FRAMEBUFFER_DEFAULT", 22)) {
    /*                           ^                */
#ifdef GL_FRAMEBUFFER_DEFAULT
      *iv_return = (IV)GL_FRAMEBUFFER_DEFAULT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INTERLEAVED_ATTRIBS", 22)) {
    /*                           ^                */
#ifdef GL_INTERLEAVED_ATTRIBS
      *iv_return = (IV)GL_INTERLEAVED_ATTRIBS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INT_SAMPLER_2D_RECT", 22)) {
    /*                           ^                */
#ifdef GL_INT_SAMPLER_2D_RECT
      *iv_return = (IV)GL_INT_SAMPLER_2D_RECT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LIGHT_MODEL_AMBIENT", 22)) {
    /*                           ^                */
#ifdef GL_LIGHT_MODEL_AMBIENT
      *iv_return = (IV)GL_LIGHT_MODEL_AMBIENT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_INTEGER_SAMPLES", 22)) {
    /*                           ^                */
#ifdef GL_MAX_INTEGER_SAMPLES
      *iv_return = (IV)GL_MAX_INTEGER_SAMPLES;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PROGRAM_RESIDENT_NV", 22)) {
    /*                           ^                */
#ifdef GL_PROGRAM_RESIDENT_NV
      *iv_return = (IV)GL_PROGRAM_RESIDENT_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SHADER_OPERATION_NV", 22)) {
    /*                           ^                */
#ifdef GL_SHADER_OPERATION_NV
      *iv_return = (IV)GL_SHADER_OPERATION_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERTEX_PRECLIP_SGIX", 22)) {
    /*                           ^                */
#ifdef GL_VERTEX_PRECLIP_SGIX
      *iv_return = (IV)GL_VERTEX_PRECLIP_SGIX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'F':
    if (memEQ(name, "GL_POLYGON_OFFSET_FILL", 22)) {
    /*                           ^                */
#ifdef GL_POLYGON_OFFSET_FILL
      *iv_return = (IV)GL_POLYGON_OFFSET_FILL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_POLYGON_OFFSET_LINE", 22)) {
    /*                           ^                */
#ifdef GL_POLYGON_OFFSET_LINE
      *iv_return = (IV)GL_POLYGON_OFFSET_LINE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RENDERBUFFER_HEIGHT", 22)) {
    /*                           ^                */
#ifdef GL_RENDERBUFFER_HEIGHT
      *iv_return = (IV)GL_RENDERBUFFER_HEIGHT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLE_BUFFERS_3DFX", 22)) {
    /*                           ^                */
#ifdef GL_SAMPLE_BUFFERS_3DFX
      *iv_return = (IV)GL_SAMPLE_BUFFERS_3DFX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLE_BUFFERS_SGIS", 22)) {
    /*                           ^                */
#ifdef GL_SAMPLE_BUFFERS_SGIS
      *iv_return = (IV)GL_SAMPLE_BUFFERS_SGIS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'G':
    if (memEQ(name, "GL_GLYPH_HEIGHT_BIT_NV", 22)) {
    /*                           ^                */
#ifdef GL_GLYPH_HEIGHT_BIT_NV
      *iv_return = (IV)GL_GLYPH_HEIGHT_BIT_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'H':
    if (memEQ(name, "GL_TEXTURE_SHARED_SIZE", 22)) {
    /*                           ^                */
#ifdef GL_TEXTURE_SHARED_SIZE
      *iv_return = (IV)GL_TEXTURE_SHARED_SIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'I':
    if (memEQ(name, "GL_ALPHA16_SIGNED_SGIX", 22)) {
    /*                           ^                */
#ifdef GL_ALPHA16_SIGNED_SGIX
      *iv_return = (IV)GL_ALPHA16_SIGNED_SGIX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_GEOMETRY_INPUT_TYPE", 22)) {
    /*                           ^                */
#ifdef GL_GEOMETRY_INPUT_TYPE
      *iv_return = (IV)GL_GEOMETRY_INPUT_TYPE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PROGRAM_BINDING_ARB", 22)) {
    /*                           ^                */
#ifdef GL_PROGRAM_BINDING_ARB
      *iv_return = (IV)GL_PROGRAM_BINDING_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'J':
    if (memEQ(name, "GL_BUFFER_OBJECT_APPLE", 22)) {
    /*                           ^                */
#ifdef GL_BUFFER_OBJECT_APPLE
      *iv_return = (IV)GL_BUFFER_OBJECT_APPLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'K':
    if (memEQ(name, "GL_PATH_STROKE_MASK_NV", 22)) {
    /*                           ^                */
#ifdef GL_PATH_STROKE_MASK_NV
      *iv_return = (IV)GL_PATH_STROKE_MASK_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'L':
    if (memEQ(name, "GL_FRAGMENT_LIGHT0_EXT", 22)) {
    /*                           ^                */
#ifdef GL_FRAGMENT_LIGHT0_EXT
      *iv_return = (IV)GL_FRAGMENT_LIGHT0_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FRAGMENT_LIGHT7_EXT", 22)) {
    /*                           ^                */
#ifdef GL_FRAGMENT_LIGHT7_EXT
      *iv_return = (IV)GL_FRAGMENT_LIGHT7_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAP_TESSELLATION_NV", 22)) {
    /*                           ^                */
#ifdef GL_MAP_TESSELLATION_NV
      *iv_return = (IV)GL_MAP_TESSELLATION_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MULTISAMPLE_BIT_ARB", 22)) {
    /*                           ^                */
#ifdef GL_MULTISAMPLE_BIT_ARB
      *iv_return = (IV)GL_MULTISAMPLE_BIT_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MULTISAMPLE_BIT_EXT", 22)) {
    /*                           ^                */
#ifdef GL_MULTISAMPLE_BIT_EXT
      *iv_return = (IV)GL_MULTISAMPLE_BIT_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RELATIVE_LINE_TO_NV", 22)) {
    /*                           ^                */
#ifdef GL_RELATIVE_LINE_TO_NV
      *iv_return = (IV)GL_RELATIVE_LINE_TO_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STENCIL_CLEAR_VALUE", 22)) {
    /*                           ^                */
#ifdef GL_STENCIL_CLEAR_VALUE
      *iv_return = (IV)GL_STENCIL_CLEAR_VALUE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNIFORM_BLOCK_INDEX", 22)) {
    /*                           ^                */
#ifdef GL_UNIFORM_BLOCK_INDEX
      *iv_return = (IV)GL_UNIFORM_BLOCK_INDEX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERTICAL_LINE_TO_NV", 22)) {
    /*                           ^                */
#ifdef GL_VERTICAL_LINE_TO_NV
      *iv_return = (IV)GL_VERTICAL_LINE_TO_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'M':
    if (memEQ(name, "GL_BUMP_ROT_MATRIX_ATI", 22)) {
    /*                           ^                */
#ifdef GL_BUMP_ROT_MATRIX_ATI
      *iv_return = (IV)GL_BUMP_ROT_MATRIX_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COMBINER_MAPPING_NV", 22)) {
    /*                           ^                */
#ifdef GL_COMBINER_MAPPING_NV
      *iv_return = (IV)GL_COMBINER_MAPPING_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COMBINER_MUX_SUM_NV", 22)) {
    /*                           ^                */
#ifdef GL_COMBINER_MUX_SUM_NV
      *iv_return = (IV)GL_COMBINER_MUX_SUM_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEPTH_CLAMP_FAR_AMD", 22)) {
    /*                           ^                */
#ifdef GL_DEPTH_CLAMP_FAR_AMD
      *iv_return = (IV)GL_DEPTH_CLAMP_FAR_AMD;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_POLYGON_SMOOTH_HINT", 22)) {
    /*                           ^                */
#ifdef GL_POLYGON_SMOOTH_HINT
      *iv_return = (IV)GL_POLYGON_SMOOTH_HINT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RELATIVE_MOVE_TO_NV", 22)) {
    /*                           ^                */
#ifdef GL_RELATIVE_MOVE_TO_NV
      *iv_return = (IV)GL_RELATIVE_MOVE_TO_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SIGNED_LUMINANCE_NV", 22)) {
    /*                           ^                */
#ifdef GL_SIGNED_LUMINANCE_NV
      *iv_return = (IV)GL_SIGNED_LUMINANCE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VBO_FREE_MEMORY_ATI", 22)) {
    /*                           ^                */
#ifdef GL_VBO_FREE_MEMORY_ATI
      *iv_return = (IV)GL_VBO_FREE_MEMORY_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'N':
    if (memEQ(name, "GL_AMBIENT_AND_DIFFUSE", 22)) {
    /*                           ^                */
#ifdef GL_AMBIENT_AND_DIFFUSE
      *iv_return = (IV)GL_AMBIENT_AND_DIFFUSE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COMPILE_AND_EXECUTE", 22)) {
    /*                           ^                */
#ifdef GL_COMPILE_AND_EXECUTE
      *iv_return = (IV)GL_COMPILE_AND_EXECUTE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FRAGMENT_NORMAL_EXT", 22)) {
    /*                           ^                */
#ifdef GL_FRAGMENT_NORMAL_EXT
      *iv_return = (IV)GL_FRAGMENT_NORMAL_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LAYOUT_LINEAR_INTEL", 22)) {
    /*                           ^                */
#ifdef GL_LAYOUT_LINEAR_INTEL
      *iv_return = (IV)GL_LAYOUT_LINEAR_INTEL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAT_AMBIENT_BIT_PGI", 22)) {
    /*                           ^                */
#ifdef GL_MAT_AMBIENT_BIT_PGI
      *iv_return = (IV)GL_MAT_AMBIENT_BIT_PGI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_VARYING_VECTORS", 22)) {
    /*                           ^                */
#ifdef GL_MAX_VARYING_VECTORS
      *iv_return = (IV)GL_MAX_VARYING_VECTORS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STENCIL_INDEX16_EXT", 22)) {
    /*                           ^                */
#ifdef GL_STENCIL_INDEX16_EXT
      *iv_return = (IV)GL_STENCIL_INDEX16_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SYSTEM_FONT_NAME_NV", 22)) {
    /*                           ^                */
#ifdef GL_SYSTEM_FONT_NAME_NV
      *iv_return = (IV)GL_SYSTEM_FONT_NAME_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNSIGNED_NORMALIZED", 22)) {
    /*                           ^                */
#ifdef GL_UNSIGNED_NORMALIZED
      *iv_return = (IV)GL_UNSIGNED_NORMALIZED;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'O':
    if (memEQ(name, "GL_NEGATIVE_ONE_TO_ONE", 22)) {
    /*                           ^                */
#ifdef GL_NEGATIVE_ONE_TO_ONE
      *iv_return = (IV)GL_NEGATIVE_ONE_TO_ONE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_COORD_ARRAY", 22)) {
    /*                           ^                */
#ifdef GL_TEXTURE_COORD_ARRAY
      *iv_return = (IV)GL_TEXTURE_COORD_ARRAY;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'P':
    if (memEQ(name, "GL_FRAGMENT_PROGRAM_NV", 22)) {
    /*                           ^                */
#ifdef GL_FRAGMENT_PROGRAM_NV
      *iv_return = (IV)GL_FRAGMENT_PROGRAM_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_GEOMETRY_PROGRAM_NV", 22)) {
    /*                           ^                */
#ifdef GL_GEOMETRY_PROGRAM_NV
      *iv_return = (IV)GL_GEOMETRY_PROGRAM_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LINE_STIPPLE_REPEAT", 22)) {
    /*                           ^                */
#ifdef GL_LINE_STIPPLE_REPEAT
      *iv_return = (IV)GL_LINE_STIPPLE_REPEAT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLE_ALPHA_TO_ONE", 22)) {
    /*                           ^                */
#ifdef GL_SAMPLE_ALPHA_TO_ONE
      *iv_return = (IV)GL_SAMPLE_ALPHA_TO_ONE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TESS_GEN_POINT_MODE", 22)) {
    /*                           ^                */
#ifdef GL_TESS_GEN_POINT_MODE
      *iv_return = (IV)GL_TESS_GEN_POINT_MODE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'R':
    if (memEQ(name, "GL_ELEMENT_ARRAY_APPLE", 22)) {
    /*                           ^                */
#ifdef GL_ELEMENT_ARRAY_APPLE
      *iv_return = (IV)GL_ELEMENT_ARRAY_APPLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXTENDED_RANGE_SGIS", 22)) {
    /*                           ^                */
#ifdef GL_EXTENDED_RANGE_SGIS
      *iv_return = (IV)GL_EXTENDED_RANGE_SGIS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MIRRORED_REPEAT_ARB", 22)) {
    /*                           ^                */
#ifdef GL_MIRRORED_REPEAT_ARB
      *iv_return = (IV)GL_MIRRORED_REPEAT_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MIRRORED_REPEAT_IBM", 22)) {
    /*                           ^                */
#ifdef GL_MIRRORED_REPEAT_IBM
      *iv_return = (IV)GL_MIRRORED_REPEAT_IBM;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NORMAL_ARRAY_STRIDE", 22)) {
    /*                           ^                */
#ifdef GL_NORMAL_ARRAY_STRIDE
      *iv_return = (IV)GL_NORMAL_ARRAY_STRIDE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PATH_MITER_LIMIT_NV", 22)) {
    /*                           ^                */
#ifdef GL_PATH_MITER_LIMIT_NV
      *iv_return = (IV)GL_PATH_MITER_LIMIT_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TESS_CONTROL_SHADER", 22)) {
    /*                           ^                */
#ifdef GL_TESS_CONTROL_SHADER
      *iv_return = (IV)GL_TESS_CONTROL_SHADER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERTEX_ARRAY_STRIDE", 22)) {
    /*                           ^                */
#ifdef GL_VERTEX_ARRAY_STRIDE
      *iv_return = (IV)GL_VERTEX_ARRAY_STRIDE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'S':
    if (memEQ(name, "GL_FRAGMENT_SHADER_ARB", 22)) {
    /*                           ^                */
#ifdef GL_FRAGMENT_SHADER_ARB
      *iv_return = (IV)GL_FRAGMENT_SHADER_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FRAGMENT_SHADER_ATI", 22)) {
    /*                           ^                */
#ifdef GL_FRAGMENT_SHADER_ATI
      *iv_return = (IV)GL_FRAGMENT_SHADER_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FRAGMENT_SHADER_BIT", 22)) {
    /*                           ^                */
#ifdef GL_FRAGMENT_SHADER_BIT
      *iv_return = (IV)GL_FRAGMENT_SHADER_BIT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FRAGMENT_SUBROUTINE", 22)) {
    /*                           ^                */
#ifdef GL_FRAGMENT_SUBROUTINE
      *iv_return = (IV)GL_FRAGMENT_SUBROUTINE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_GEOMETRY_SHADER_ARB", 22)) {
    /*                           ^                */
#ifdef GL_GEOMETRY_SHADER_ARB
      *iv_return = (IV)GL_GEOMETRY_SHADER_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_GEOMETRY_SHADER_BIT", 22)) {
    /*                           ^                */
#ifdef GL_GEOMETRY_SHADER_BIT
      *iv_return = (IV)GL_GEOMETRY_SHADER_BIT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_GEOMETRY_SHADER_EXT", 22)) {
    /*                           ^                */
#ifdef GL_GEOMETRY_SHADER_EXT
      *iv_return = (IV)GL_GEOMETRY_SHADER_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_GEOMETRY_SUBROUTINE", 22)) {
    /*                           ^                */
#ifdef GL_GEOMETRY_SUBROUTINE
      *iv_return = (IV)GL_GEOMETRY_SUBROUTINE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAT_DIFFUSE_BIT_PGI", 22)) {
    /*                           ^                */
#ifdef GL_MAT_DIFFUSE_BIT_PGI
      *iv_return = (IV)GL_MAT_DIFFUSE_BIT_PGI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NUM_FILL_STREAMS_NV", 22)) {
    /*                           ^                */
#ifdef GL_NUM_FILL_STREAMS_NV
      *iv_return = (IV)GL_NUM_FILL_STREAMS_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_USAGE_ANGLE", 22)) {
    /*                           ^                */
#ifdef GL_TEXTURE_USAGE_ANGLE
      *iv_return = (IV)GL_TEXTURE_USAGE_ANGLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNPACK_RESAMPLE_OML", 22)) {
    /*                           ^                */
#ifdef GL_UNPACK_RESAMPLE_OML
      *iv_return = (IV)GL_UNPACK_RESAMPLE_OML;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VIEW_CLASS_128_BITS", 22)) {
    /*                           ^                */
#ifdef GL_VIEW_CLASS_128_BITS
      *iv_return = (IV)GL_VIEW_CLASS_128_BITS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VIEW_CLASS_RGTC2_RG", 22)) {
    /*                           ^                */
#ifdef GL_VIEW_CLASS_RGTC2_RG
      *iv_return = (IV)GL_VIEW_CLASS_RGTC2_RG;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'T':
    if (memEQ(name, "GL_DYNAMIC_STORAGE_BIT", 22)) {
    /*                           ^                */
#ifdef GL_DYNAMIC_STORAGE_BIT
      *iv_return = (IV)GL_DYNAMIC_STORAGE_BIT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_POLYGON_STIPPLE_BIT", 22)) {
    /*                           ^                */
#ifdef GL_POLYGON_STIPPLE_BIT
      *iv_return = (IV)GL_POLYGON_STIPPLE_BIT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PROGRAM_ATTRIBS_ARB", 22)) {
    /*                           ^                */
#ifdef GL_PROGRAM_ATTRIBS_ARB
      *iv_return = (IV)GL_PROGRAM_ATTRIBS_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PROXY_HISTOGRAM_EXT", 22)) {
    /*                           ^                */
#ifdef GL_PROXY_HISTOGRAM_EXT
      *iv_return = (IV)GL_PROXY_HISTOGRAM_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_QUERY_WAIT_INVERTED", 22)) {
    /*                           ^                */
#ifdef GL_QUERY_WAIT_INVERTED
      *iv_return = (IV)GL_QUERY_WAIT_INVERTED;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGBA_FLOAT_MODE_ARB", 22)) {
    /*                           ^                */
#ifdef GL_RGBA_FLOAT_MODE_ARB
      *iv_return = (IV)GL_RGBA_FLOAT_MODE_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLE_PATTERN_SGIS", 22)) {
    /*                           ^                */
#ifdef GL_SAMPLE_PATTERN_SGIS
      *iv_return = (IV)GL_SAMPLE_PATTERN_SGIS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SIGNED_INTENSITY_NV", 22)) {
    /*                           ^                */
#ifdef GL_SIGNED_INTENSITY_NV
      *iv_return = (IV)GL_SIGNED_INTENSITY_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SWIZZLE_STRQ_DQ_ATI", 22)) {
    /*                           ^                */
#ifdef GL_SWIZZLE_STRQ_DQ_ATI
      *iv_return = (IV)GL_SWIZZLE_STRQ_DQ_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_STACK_DEPTH", 22)) {
    /*                           ^                */
#ifdef GL_TEXTURE_STACK_DEPTH
      *iv_return = (IV)GL_TEXTURE_STACK_DEPTH;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'U':
    if (memEQ(name, "GL_CURRENT_QUERY_ANGLE", 22)) {
    /*                           ^                */
#ifdef GL_CURRENT_QUERY_ANGLE
      *iv_return = (IV)GL_CURRENT_QUERY_ANGLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PRESENT_DURATION_NV", 22)) {
    /*                           ^                */
#ifdef GL_PRESENT_DURATION_NV
      *iv_return = (IV)GL_PRESENT_DURATION_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLER_CUBE_SHADOW", 22)) {
    /*                           ^                */
#ifdef GL_SAMPLER_CUBE_SHADOW
      *iv_return = (IV)GL_SAMPLER_CUBE_SHADOW;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_BUFFER_SIZE", 22)) {
    /*                           ^                */
#ifdef GL_TEXTURE_BUFFER_SIZE
      *iv_return = (IV)GL_TEXTURE_BUFFER_SIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNIFORM_BUFFER_SIZE", 22)) {
    /*                           ^                */
#ifdef GL_UNIFORM_BUFFER_SIZE
      *iv_return = (IV)GL_UNIFORM_BUFFER_SIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'V':
    if (memEQ(name, "GL_422_REV_AVERAGE_EXT", 22)) {
    /*                           ^                */
#ifdef GL_422_REV_AVERAGE_EXT
      *iv_return = (IV)GL_422_REV_AVERAGE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLE_COVERAGE_ARB", 22)) {
    /*                           ^                */
#ifdef GL_SAMPLE_COVERAGE_ARB
      *iv_return = (IV)GL_SAMPLE_COVERAGE_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'X':
    if (memEQ(name, "GL_MAX_3D_TEXTURE_SIZE", 22)) {
    /*                           ^                */
#ifdef GL_MAX_3D_TEXTURE_SIZE
      *iv_return = (IV)GL_MAX_3D_TEXTURE_SIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_VERTEX_HINT_PGI", 22)) {
    /*                           ^                */
#ifdef GL_MAX_VERTEX_HINT_PGI
      *iv_return = (IV)GL_MAX_VERTEX_HINT_PGI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '_':
    if (memEQ(name, "GLEW_NV_deep_texture3D", 22)) {
    /*                           ^                */
#ifdef GLEW_NV_deep_texture3D
      *iv_return = (IV)GLEW_NV_deep_texture3D;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_NV_fill_rectangle", 22)) {
    /*                           ^                */
#ifdef GLEW_NV_fill_rectangle
      *iv_return = (IV)GLEW_NV_fill_rectangle;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_NV_path_rendering", 22)) {
    /*                           ^                */
#ifdef GLEW_NV_path_rendering
      *iv_return = (IV)GLEW_NV_path_rendering;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_BLEND_DST_ALPHA_EXT", 22)) {
    /*                           ^                */
#ifdef GL_BLEND_DST_ALPHA_EXT
      *iv_return = (IV)GL_BLEND_DST_ALPHA_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_BLEND_SRC_ALPHA_EXT", 22)) {
    /*                           ^                */
#ifdef GL_BLEND_SRC_ALPHA_EXT
      *iv_return = (IV)GL_BLEND_SRC_ALPHA_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CONDITION_SATISFIED", 22)) {
    /*                           ^                */
#ifdef GL_CONDITION_SATISFIED
      *iv_return = (IV)GL_CONDITION_SATISFIED;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EDGE_FLAG_ARRAY_EXT", 22)) {
    /*                           ^                */
#ifdef GL_EDGE_FLAG_ARRAY_EXT
      *iv_return = (IV)GL_EDGE_FLAG_ARRAY_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_pixel_transform", 22)) {
    /*                           ^                */
#ifdef GL_EXT_pixel_transform
      *iv_return = (IV)GL_EXT_pixel_transform;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_HALF_BIAS_NEGATE_NV", 22)) {
    /*                           ^                */
#ifdef GL_HALF_BIAS_NEGATE_NV
      *iv_return = (IV)GL_HALF_BIAS_NEGATE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_HALF_BIAS_NORMAL_NV", 22)) {
    /*                           ^                */
#ifdef GL_HALF_BIAS_NORMAL_NV
      *iv_return = (IV)GL_HALF_BIAS_NORMAL_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_HISTOGRAM_BLUE_SIZE", 22)) {
    /*                           ^                */
#ifdef GL_HISTOGRAM_BLUE_SIZE
      *iv_return = (IV)GL_HISTOGRAM_BLUE_SIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_HISTOGRAM_WIDTH_EXT", 22)) {
    /*                           ^                */
#ifdef GL_HISTOGRAM_WIDTH_EXT
      *iv_return = (IV)GL_HISTOGRAM_WIDTH_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INTERLACE_READ_INGR", 22)) {
    /*                           ^                */
#ifdef GL_INTERLACE_READ_INGR
      *iv_return = (IV)GL_INTERLACE_READ_INGR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INVARIANT_VALUE_EXT", 22)) {
    /*                           ^                */
#ifdef GL_INVARIANT_VALUE_EXT
      *iv_return = (IV)GL_INVARIANT_VALUE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LARGE_CCW_ARC_TO_NV", 22)) {
    /*                           ^                */
#ifdef GL_LARGE_CCW_ARC_TO_NV
      *iv_return = (IV)GL_LARGE_CCW_ARC_TO_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_IMAGE_UNITS_EXT", 22)) {
    /*                           ^                */
#ifdef GL_MAX_IMAGE_UNITS_EXT
      *iv_return = (IV)GL_MAX_IMAGE_UNITS_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_PIXEL_MAP_TABLE", 22)) {
    /*                           ^                */
#ifdef GL_MAX_PIXEL_MAP_TABLE
      *iv_return = (IV)GL_MAX_PIXEL_MAP_TABLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_sample_locations", 22)) {
    /*                           ^                */
#ifdef GL_NV_sample_locations
      *iv_return = (IV)GL_NV_sample_locations;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ONE_MINUS_DST_ALPHA", 22)) {
    /*                           ^                */
#ifdef GL_ONE_MINUS_DST_ALPHA
      *iv_return = (IV)GL_ONE_MINUS_DST_ALPHA;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ONE_MINUS_DST_COLOR", 22)) {
    /*                           ^                */
#ifdef GL_ONE_MINUS_DST_COLOR
      *iv_return = (IV)GL_ONE_MINUS_DST_COLOR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ONE_MINUS_SRC_ALPHA", 22)) {
    /*                           ^                */
#ifdef GL_ONE_MINUS_SRC_ALPHA
      *iv_return = (IV)GL_ONE_MINUS_SRC_ALPHA;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ONE_MINUS_SRC_COLOR", 22)) {
    /*                           ^                */
#ifdef GL_ONE_MINUS_SRC_COLOR
      *iv_return = (IV)GL_ONE_MINUS_SRC_COLOR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PATH_DASH_OFFSET_NV", 22)) {
    /*                           ^                */
#ifdef GL_PATH_DASH_OFFSET_NV
      *iv_return = (IV)GL_PATH_DASH_OFFSET_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SMALL_CCW_ARC_TO_NV", 22)) {
    /*                           ^                */
#ifdef GL_SMALL_CCW_ARC_TO_NV
      *iv_return = (IV)GL_SMALL_CCW_ARC_TO_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TRIANGLES_ADJACENCY", 22)) {
    /*                           ^                */
#ifdef GL_TRIANGLES_ADJACENCY
      *iv_return = (IV)GL_TRIANGLES_ADJACENCY;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'a':
    if (memEQ(name, "GLEW_ARB_clear_texture", 22)) {
    /*                           ^                */
#ifdef GLEW_ARB_clear_texture
      *iv_return = (IV)GLEW_ARB_clear_texture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_INTEL_map_texture", 22)) {
    /*                           ^                */
#ifdef GLEW_INTEL_map_texture
      *iv_return = (IV)GLEW_INTEL_map_texture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_SUN_triangle_list", 22)) {
    /*                           ^                */
#ifdef GLEW_SUN_triangle_list
      *iv_return = (IV)GLEW_SUN_triangle_list;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'd':
    if (memEQ(name, "GLEW_ARB_shader_ballot", 22)) {
    /*                           ^                */
#ifdef GLEW_ARB_shader_ballot
      *iv_return = (IV)GLEW_ARB_shader_ballot;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_secondary_color", 22)) {
    /*                           ^                */
#ifdef GL_EXT_secondary_color
      *iv_return = (IV)GL_EXT_secondary_color;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_pixel_data_range", 22)) {
    /*                           ^                */
#ifdef GL_NV_pixel_data_range
      *iv_return = (IV)GL_NV_pixel_data_range;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'e':
    if (memEQ(name, "GLEW_ARB_base_instance", 22)) {
    /*                           ^                */
#ifdef GLEW_ARB_base_instance
      *iv_return = (IV)GLEW_ARB_base_instance;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_EXT_index_texture", 22)) {
    /*                           ^                */
#ifdef GLEW_EXT_index_texture
      *iv_return = (IV)GLEW_EXT_index_texture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_NV_vertex_program", 22)) {
    /*                           ^                */
#ifdef GLEW_NV_vertex_program
      *iv_return = (IV)GLEW_NV_vertex_program;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_fragment_shader", 22)) {
    /*                           ^                */
#ifdef GL_ARB_fragment_shader
      *iv_return = (IV)GL_ARB_fragment_shader;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_sampler_objects", 22)) {
    /*                           ^                */
#ifdef GL_ARB_sampler_objects
      *iv_return = (IV)GL_ARB_sampler_objects;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_sparse_texture2", 22)) {
    /*                           ^                */
#ifdef GL_ARB_sparse_texture2
      *iv_return = (IV)GL_ARB_sparse_texture2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ATI_fragment_shader", 22)) {
    /*                           ^                */
#ifdef GL_ATI_fragment_shader
      *iv_return = (IV)GL_ATI_fragment_shader;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_sparse_texture2", 22)) {
    /*                           ^                */
#ifdef GL_EXT_sparse_texture2
      *iv_return = (IV)GL_EXT_sparse_texture2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_HP_texture_lighting", 22)) {
    /*                           ^                */
#ifdef GL_HP_texture_lighting
      *iv_return = (IV)GL_HP_texture_lighting;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NVX_gpu_memory_info", 22)) {
    /*                           ^                */
#ifdef GL_NVX_gpu_memory_info
      *iv_return = (IV)GL_NVX_gpu_memory_info;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_compute_program5", 22)) {
    /*                           ^                */
#ifdef GL_NV_compute_program5
      *iv_return = (IV)GL_NV_compute_program5;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SGIX_vertex_preclip", 22)) {
    /*                           ^                */
#ifdef GL_SGIX_vertex_preclip
      *iv_return = (IV)GL_SGIX_vertex_preclip;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'f':
    if (memEQ(name, "GLEW_KTX_buffer_region", 22)) {
    /*                           ^                */
#ifdef GLEW_KTX_buffer_region
      *iv_return = (IV)GLEW_KTX_buffer_region;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'g':
    if (memEQ(name, "GLEW_SGIS_fog_function", 22)) {
    /*                           ^                */
#ifdef GLEW_SGIS_fog_function
      *iv_return = (IV)GLEW_SGIS_fog_function;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_AMD_name_gen_delete", 22)) {
    /*                           ^                */
#ifdef GL_AMD_name_gen_delete
      *iv_return = (IV)GL_AMD_name_gen_delete;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'h':
    if (memEQ(name, "GLEW_EXT_light_texture", 22)) {
    /*                           ^                */
#ifdef GLEW_EXT_light_texture
      *iv_return = (IV)GLEW_EXT_light_texture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_gpu_shader_fp64", 22)) {
    /*                           ^                */
#ifdef GL_ARB_gpu_shader_fp64
      *iv_return = (IV)GL_ARB_gpu_shader_fp64;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'i':
    if (memEQ(name, "GLEW_ANGLE_timer_query", 22)) {
    /*                           ^                */
#ifdef GLEW_ANGLE_timer_query
      *iv_return = (IV)GLEW_ANGLE_timer_query;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SGIS_detail_texture", 22)) {
    /*                           ^                */
#ifdef GL_SGIS_detail_texture
      *iv_return = (IV)GL_SGIS_detail_texture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'k':
    if (memEQ(name, "GLEW_EXT_packed_pixels", 22)) {
    /*                           ^                */
#ifdef GLEW_EXT_packed_pixels
      *iv_return = (IV)GLEW_EXT_packed_pixels;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'l':
    if (memEQ(name, "GLEW_ARB_cull_distance", 22)) {
    /*                           ^                */
#ifdef GLEW_ARB_cull_distance
      *iv_return = (IV)GLEW_ARB_cull_distance;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'm':
    if (memEQ(name, "GLEW_ATI_element_array", 22)) {
    /*                           ^                */
#ifdef GLEW_ATI_element_array
      *iv_return = (IV)GLEW_ATI_element_array;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_APPLE_element_array", 22)) {
    /*                           ^                */
#ifdef GL_APPLE_element_array
      *iv_return = (IV)GL_APPLE_element_array;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'n':
    if (memEQ(name, "GLEW_AMD_pinned_memory", 22)) {
    /*                           ^                */
#ifdef GLEW_AMD_pinned_memory
      *iv_return = (IV)GLEW_AMD_pinned_memory;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_WIN_phong_shading", 22)) {
    /*                           ^                */
#ifdef GLEW_WIN_phong_shading
      *iv_return = (IV)GLEW_WIN_phong_shading;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_fragment_program", 22)) {
    /*                           ^                */
#ifdef GL_NV_fragment_program
      *iv_return = (IV)GL_NV_fragment_program;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SGIX_ir_instrument1", 22)) {
    /*                           ^                */
#ifdef GL_SGIX_ir_instrument1
      *iv_return = (IV)GL_SGIX_ir_instrument1;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'o':
    if (memEQ(name, "GL_NV_gpu_program_fp64", 22)) {
    /*                           ^                */
#ifdef GL_NV_gpu_program_fp64
      *iv_return = (IV)GL_NV_gpu_program_fp64;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SGIX_shadow_ambient", 22)) {
    /*                           ^                */
#ifdef GL_SGIX_shadow_ambient
      *iv_return = (IV)GL_SGIX_shadow_ambient;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'p':
    if (memEQ(name, "GLEW_ARB_compatibility", 22)) {
    /*                           ^                */
#ifdef GLEW_ARB_compatibility
      *iv_return = (IV)GLEW_ARB_compatibility;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'r':
    if (memEQ(name, "GLEW_ARB_sparse_buffer", 22)) {
    /*                           ^                */
#ifdef GLEW_ARB_sparse_buffer
      *iv_return = (IV)GLEW_ARB_sparse_buffer;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_texture_barrier", 22)) {
    /*                           ^                */
#ifdef GL_ARB_texture_barrier
      *iv_return = (IV)GL_ARB_texture_barrier;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_texture_env_add", 22)) {
    /*                           ^                */
#ifdef GL_ARB_texture_env_add
      *iv_return = (IV)GL_ARB_texture_env_add;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_texture_storage", 22)) {
    /*                           ^                */
#ifdef GL_ARB_texture_storage
      *iv_return = (IV)GL_ARB_texture_storage;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_texture_swizzle", 22)) {
    /*                           ^                */
#ifdef GL_ARB_texture_swizzle
      *iv_return = (IV)GL_ARB_texture_swizzle;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_texture_env_add", 22)) {
    /*                           ^                */
#ifdef GL_EXT_texture_env_add
      *iv_return = (IV)GL_EXT_texture_env_add;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_texture_integer", 22)) {
    /*                           ^                */
#ifdef GL_EXT_texture_integer
      *iv_return = (IV)GL_EXT_texture_integer;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_texture_swizzle", 22)) {
    /*                           ^                */
#ifdef GL_EXT_texture_swizzle
      *iv_return = (IV)GL_EXT_texture_swizzle;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INGR_interlace_read", 22)) {
    /*                           ^                */
#ifdef GL_INGR_interlace_read
      *iv_return = (IV)GL_INGR_interlace_read;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_geometry_shader4", 22)) {
    /*                           ^                */
#ifdef GL_NV_geometry_shader4
      *iv_return = (IV)GL_NV_geometry_shader4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_viewport_swizzle", 22)) {
    /*                           ^                */
#ifdef GL_NV_viewport_swizzle
      *iv_return = (IV)GL_NV_viewport_swizzle;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 's':
    if (memEQ(name, "GL_ARB_occlusion_query", 22)) {
    /*                           ^                */
#ifdef GL_ARB_occlusion_query
      *iv_return = (IV)GL_ARB_occlusion_query;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_bindless_texture", 22)) {
    /*                           ^                */
#ifdef GL_NV_bindless_texture
      *iv_return = (IV)GL_NV_bindless_texture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 't':
    if (memEQ(name, "GLEW_ARB_depth_texture", 22)) {
    /*                           ^                */
#ifdef GLEW_ARB_depth_texture
      *iv_return = (IV)GLEW_ARB_depth_texture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_ARB_texture_float", 22)) {
    /*                           ^                */
#ifdef GLEW_ARB_texture_float
      *iv_return = (IV)GLEW_ARB_texture_float;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_ARB_vertex_shader", 22)) {
    /*                           ^                */
#ifdef GLEW_ARB_vertex_shader
      *iv_return = (IV)GLEW_ARB_vertex_shader;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_ATI_texture_float", 22)) {
    /*                           ^                */
#ifdef GLEW_ATI_texture_float
      *iv_return = (IV)GLEW_ATI_texture_float;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_EXT_texture_array", 22)) {
    /*                           ^                */
#ifdef GLEW_EXT_texture_array
      *iv_return = (IV)GLEW_EXT_texture_array;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_EXT_texture_snorm", 22)) {
    /*                           ^                */
#ifdef GLEW_EXT_texture_snorm
      *iv_return = (IV)GLEW_EXT_texture_snorm;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_EXT_vertex_shader", 22)) {
    /*                           ^                */
#ifdef GLEW_EXT_vertex_shader
      *iv_return = (IV)GLEW_EXT_vertex_shader;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ANGLE_depth_texture", 22)) {
    /*                           ^                */
#ifdef GL_ANGLE_depth_texture
      *iv_return = (IV)GL_ANGLE_depth_texture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ANGLE_texture_usage", 22)) {
    /*                           ^                */
#ifdef GL_ANGLE_texture_usage
      *iv_return = (IV)GL_ANGLE_texture_usage;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_APPLE_texture_range", 22)) {
    /*                           ^                */
#ifdef GL_APPLE_texture_range
      *iv_return = (IV)GL_APPLE_texture_range;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MESAX_texture_stack", 22)) {
    /*                           ^                */
#ifdef GL_MESAX_texture_stack
      *iv_return = (IV)GL_MESAX_texture_stack;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'u':
    if (memEQ(name, "GLEW_HP_occlusion_test", 22)) {
    /*                           ^                */
#ifdef GLEW_HP_occlusion_test
      *iv_return = (IV)GLEW_HP_occlusion_test;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_NV_texture_shader", 22)) {
    /*                           ^                */
#ifdef GLEW_NV_texture_shader
      *iv_return = (IV)GLEW_NV_texture_shader;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_SGIX_flush_raster", 22)) {
    /*                           ^                */
#ifdef GLEW_SGIX_flush_raster
      *iv_return = (IV)GLEW_SGIX_flush_raster;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SGIS_texture_select", 22)) {
    /*                           ^                */
#ifdef GL_SGIS_texture_select
      *iv_return = (IV)GL_SGIS_texture_select;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'w':
    if (memEQ(name, "GLEW_ARB_draw_indirect", 22)) {
    /*                           ^                */
#ifdef GLEW_ARB_draw_indirect
      *iv_return = (IV)GLEW_ARB_draw_indirect;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_EXT_draw_buffers2", 22)) {
    /*                           ^                */
#ifdef GLEW_EXT_draw_buffers2
      *iv_return = (IV)GLEW_EXT_draw_buffers2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'y':
    if (memEQ(name, "GL_EXT_x11_sync_object", 22)) {
    /*                           ^                */
#ifdef GL_EXT_x11_sync_object
      *iv_return = (IV)GL_EXT_x11_sync_object;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'z':
    if (memEQ(name, "GL_MESA_resize_buffers", 22)) {
    /*                           ^                */
#ifdef GL_MESA_resize_buffers
      *iv_return = (IV)GL_MESA_resize_buffers;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  }
  return PERL_constant_NOTFOUND;
}

static int
constant_23 (pTHX_ const char *name, IV *iv_return) {
  /* When generated this function returned values for the list of names given
     here.  However, subsequent manual editing may have added or removed some.
     GLEW_AMD_sparse_texture GLEW_APPLE_float_pixels GLEW_APPLE_pixel_buffer
     GLEW_ARB_buffer_storage GLEW_ARB_compute_shader GLEW_ARB_draw_instanced
     GLEW_ARB_matrix_palette GLEW_ARB_sample_shading GLEW_ARB_shader_objects
     GLEW_ARB_shadow_ambient GLEW_ARB_sparse_texture GLEW_ARB_texture_gather
     GLEW_ARB_vertex_program GLEW_ARB_viewport_array GLEW_ATIX_point_sprites
     GLEW_ATI_envmap_bumpmap GLEW_ATI_vertex_streams GLEW_EXT_blend_logic_op
     GLEW_EXT_blend_subtract GLEW_EXT_color_subtable GLEW_EXT_draw_instanced
     GLEW_EXT_index_material GLEW_EXT_misc_attribute GLEW_EXT_polygon_offset
     GLEW_EXT_rescale_normal GLEW_EXT_texture_object GLEW_HP_image_transform
     GLEW_IBM_rasterpos_clip GLEW_MESA_ycbcr_texture GLEW_NV_occlusion_query
     GLEW_NV_texture_barrier GLEW_NV_texture_shader2 GLEW_NV_texture_shader3
     GLEW_NV_vertex_program2 GLEW_NV_vertex_program3 GLEW_NV_vertex_program4
     GLEW_NV_viewport_array2 GLEW_REGAL_error_string GLEW_REGAL_proc_address
     GLEW_SGIS_pixel_texture GLEW_SGIX_depth_texture GLEW_SGIX_list_priority
     GLEW_SGIX_pixel_texture GLEW_SGIX_texture_range GLEW_SUNX_constant_data
     GL_ALL_BARRIER_BITS_EXT GL_ALPHA_MAX_CLAMP_INGR GL_ALPHA_MIN_CLAMP_INGR
     GL_ALPHA_REF_COMMAND_NV GL_ALWAYS_FAST_HINT_PGI GL_ALWAYS_SOFT_HINT_PGI
     GL_AMD_gpu_shader_int64 GL_AMD_sample_positions GL_AMD_texture_texture4
     GL_ANGLE_program_binary GL_APPLE_client_storage GL_APPLE_transform_hint
     GL_ARB_arrays_of_arrays GL_ARB_bindless_texture GL_ARB_enhanced_layouts
     GL_ARB_fragment_program GL_ARB_framebuffer_sRGB GL_ARB_geometry_shader4
     GL_ARB_gpu_shader_int64 GL_ARB_half_float_pixel GL_ARB_instanced_arrays
     GL_ARB_map_buffer_range GL_ARB_occlusion_query2 GL_ARB_point_parameters
     GL_ARB_provoking_vertex GL_ARB_sample_locations GL_ARB_shader_precision
     GL_ARB_texture_cube_map GL_ARB_texture_env_dot3 GL_ARB_texture_stencil8
     GL_ARB_transpose_matrix GL_ARRAY_BUFFER_BINDING GL_ASYNC_HISTOGRAM_SGIX
     GL_ASYNC_TEX_IMAGE_SGIX GL_ATI_separate_stencil GL_ATTRIB_ARRAY_SIZE_NV
     GL_ATTRIB_ARRAY_TYPE_NV GL_AUTO_GENERATE_MIPMAP GL_BLEND_EQUATION_ALPHA
     GL_BUFFER_STORAGE_FLAGS GL_CG_VERTEX_SHADER_EXT GL_CLAMP_FRAGMENT_COLOR
     GL_CLAMP_READ_COLOR_ARB GL_CLAMP_TO_BORDER_SGIS GL_COLOR_ARRAY_LIST_IBM
     GL_COLOR_ARRAY_SIZE_EXT GL_COLOR_ARRAY_TYPE_EXT GL_COLOR_TABLE_BIAS_SGI
     GL_COLOR_TABLE_RED_SIZE GL_COMPARE_R_TO_TEXTURE GL_COMPRESSED_ALPHA_ARB
     GL_COMPRESSED_INTENSITY GL_COMPRESSED_LUMINANCE GL_COMPRESSED_RED_RGTC1
     GL_COMPRESSED_RGB8_ETC2 GL_CONSTANT_ATTENUATION GL_CONTEXT_PROFILE_MASK
     GL_CURRENT_BINORMAL_EXT GL_CURRENT_RASTER_COLOR GL_CURRENT_RASTER_INDEX
     GL_DEBUG_SOURCE_API_ARB GL_DEBUG_TYPE_ERROR_ARB GL_DEBUG_TYPE_OTHER_ARB
     GL_DEBUG_TYPE_POP_GROUP GL_DEPTH24_STENCIL8_EXT GL_DEPTH32F_STENCIL8_NV
     GL_DEPTH_ATTACHMENT_EXT GL_DEPTH_CLAMP_NEAR_AMD GL_DRAW_FRAMEBUFFER_EXT
     GL_DRAW_INDIRECT_BUFFER GL_ELEMENT_ARRAY_BUFFER GL_EXT_bindable_uniform
     GL_EXT_clip_volume_hint GL_EXT_coordinate_frame GL_EXT_framebuffer_blit
     GL_EXT_framebuffer_sRGB GL_EXT_geometry_shader4 GL_EXT_paletted_texture
     GL_EXT_point_parameters GL_EXT_provoking_vertex GL_EXT_stencil_two_side
     GL_EXT_texture_cube_map GL_EXT_texture_env_dot3 GL_EXT_texture_lod_bias
     GL_EXT_vertex_weighting GL_FEEDBACK_BUFFER_SIZE GL_FEEDBACK_BUFFER_TYPE
     GL_FOG_COORDINATE_ARRAY GL_FOG_COORD_ARRAY_TYPE GL_FOG_DISTANCE_MODE_NV
     GL_FONT_ASCENDER_BIT_NV GL_FORCE_BLUE_TO_ONE_NV GL_FRAGMENT_PROGRAM_ARB
     GL_FRAMEBUFFER_COMPLETE GL_FRAMEBUFFER_SRGB_EXT GL_GENERATE_MIPMAP_HINT
     GL_GENERATE_MIPMAP_SGIS GL_GEOMETRY_OUTPUT_TYPE GL_GREEN_MAX_CLAMP_INGR
     GL_GREEN_MIN_CLAMP_INGR GL_GUILTY_CONTEXT_RESET GL_HISTOGRAM_ALPHA_SIZE
     GL_HISTOGRAM_FORMAT_EXT GL_HISTOGRAM_GREEN_SIZE GL_IMAGE_2D_MULTISAMPLE
     GL_IMAGE_BINDING_ACCESS GL_IMAGE_BINDING_FORMAT GL_IMAGE_CLASS_11_11_10
     GL_IMAGE_CUBE_MAP_ARRAY GL_INDEX_ARRAY_LIST_IBM GL_INDEX_ARRAY_TYPE_EXT
     GL_INT_IMAGE_BUFFER_EXT GL_INT_SAMPLER_1D_ARRAY GL_INT_SAMPLER_2D_ARRAY
     GL_INT_SAMPLER_CUBE_EXT GL_INVERSE_TRANSPOSE_NV GL_LAYOUT_DEFAULT_INTEL
     GL_LIGHT_MODEL_TWO_SIDE GL_LINEAR_MIPMAP_LINEAR GL_LINE_STIPPLE_PATTERN
     GL_LINE_STRIP_ADJACENCY GL_MAP1_TEXTURE_COORD_1 GL_MAP1_TEXTURE_COORD_2
     GL_MAP1_TEXTURE_COORD_3 GL_MAP1_TEXTURE_COORD_4 GL_MAP2_TEXTURE_COORD_1
     GL_MAP2_TEXTURE_COORD_2 GL_MAP2_TEXTURE_COORD_3 GL_MAP2_TEXTURE_COORD_4
     GL_MAT_EMISSION_BIT_PGI GL_MAT_SPECULAR_BIT_PGI GL_MAX_DRAW_BUFFERS_ARB
     GL_MAX_DRAW_BUFFERS_ATI GL_MAX_ELEMENTS_INDICES GL_MAX_NAME_STACK_DEPTH
     GL_MAX_SPOT_EXPONENT_NV GL_MAX_TEXTURE_LOD_BIAS GL_MAX_VERTEX_UNITS_ARB
     GL_MIN_SPARSE_LEVEL_AMD GL_MIRROR_CLAMP_TO_EDGE GL_MOVE_TO_CONTINUES_NV
     GL_MULTISAMPLE_BIT_3DFX GL_NORMALIZED_RANGE_EXT GL_NORMAL_ARRAY_POINTER
     GL_NUM_ACTIVE_VARIABLES GL_NV_draw_vulkan_image GL_NV_fragment_program2
     GL_NV_fragment_program4 GL_NV_geometry_program4 GL_NV_primitive_restart
     GL_NV_texgen_reflection GL_NV_texture_rectangle GL_NV_vertex_program1_1
     GL_OES_byte_coordinates GL_OES_single_precision GL_OFFSET_TEXTURE_2D_NV
     GL_ONE_MINUS_SRC1_ALPHA GL_ONE_MINUS_SRC1_COLOR GL_OP_CROSS_PRODUCT_EXT
     GL_PACK_ROW_BYTES_APPLE GL_PACK_SKIP_IMAGES_EXT GL_PALETTE4_RGB5_A1_OES
     GL_PALETTE8_RGB5_A1_OES GL_PARAMETER_BUFFER_ARB GL_PATH_FOG_GEN_MODE_NV
     GL_PATH_STENCIL_FUNC_NV GL_PATH_STROKE_BOUND_NV GL_PATH_STROKE_WIDTH_NV
     GL_PERFQUERY_WAIT_INTEL GL_PIXEL_MAG_FILTER_EXT GL_PIXEL_MIN_FILTER_EXT
     GL_POLYGON_OFFSET_POINT GL_POLYGON_OFFSET_UNITS GL_PRIMITIVES_GENERATED
     GL_PRIMITIVE_RESTART_NV GL_PROGRAM_BINARY_ANGLE GL_PROGRAM_PARAMETER_NV
     GL_PROVOKING_VERTEX_EXT GL_PROXY_TEXTURE_1D_EXT GL_PROXY_TEXTURE_2D_EXT
     GL_PROXY_TEXTURE_3D_EXT GL_QUERY_BUFFER_BINDING GL_QUERY_BY_REGION_WAIT
     GL_QUERY_RESULT_NO_WAIT GL_R1UI_C4F_N3F_V3F_SUN GL_R1UI_T2F_N3F_V3F_SUN
     GL_READ_FRAMEBUFFER_EXT GL_RENDERBUFFER_BINDING GL_RENDERBUFFER_SAMPLES
     GL_REPLACEMENT_CODE_SUN GL_RESAMPLE_AVERAGE_OML GL_SAMPLER_1D_ARRAY_EXT
     GL_SAMPLER_2D_ARRAY_EXT GL_SAMPLE_COUNT_BITS_NV GL_SAMPLE_MASK_VALUE_NV
     GL_SCALE_BY_ONE_HALF_NV GL_SECONDARY_COLOR_ATIX GL_SEPARATE_ATTRIBS_EXT
     GL_SGIS_generate_mipmap GL_SGIS_sharpen_texture GL_SGIS_texture_filter4
     GL_SGIX_async_histogram GL_SGIX_reference_plane GL_SGIX_texture_add_env
     GL_SHADER_CONSISTENT_NV GL_SHADER_SOURCE_LENGTH GL_SHADER_STORAGE_BLOCK
     GL_SIGNED_INTENSITY8_NV GL_SIGNED_LUMINANCE8_NV GL_SLUMINANCE_ALPHA_EXT
     GL_STENCIL_OP_VALUE_AMD GL_STENCIL_TAG_BITS_EXT GL_STORAGE_CACHED_APPLE
     GL_STORAGE_CLIENT_APPLE GL_STORAGE_SHARED_APPLE GL_TESS_CONTROL_TEXTURE
     GL_TEXTURE_1D_ARRAY_EXT GL_TEXTURE_2D_ARRAY_EXT GL_TEXTURE_BORDER_COLOR
     GL_TEXTURE_COMPARE_FUNC GL_TEXTURE_COMPARE_MODE GL_TEXTURE_COMPARE_SGIX
     GL_TEXTURE_CUBE_MAP_ARB GL_TEXTURE_CUBE_MAP_EXT GL_TEXTURE_IMAGE_FORMAT
     GL_TEXTURE_LOD_BIAS_EXT GL_TEXTURE_MAX_LOD_SGIS GL_TEXTURE_MIN_LOD_SGIS
     GL_TEXTURE_PRIORITY_EXT GL_TEXTURE_RECTANGLE_NV GL_TEXTURE_RED_SIZE_EXT
     GL_TEXTURE_RED_TYPE_ARB GL_TEXTURE_RESIDENT_EXT GL_TEXTURE_STENCIL_SIZE
     GL_TEXTURE_SWIZZLE_RGBA GL_TOP_LEVEL_ARRAY_SIZE GL_TRANSFORM_HINT_APPLE
     GL_UNIFORM_ARRAY_STRIDE GL_UNIFORM_BUFFER_START GL_UNIFORM_IS_ROW_MAJOR
     GL_UNPACK_CMYK_HINT_EXT GL_UNPACK_RESAMPLE_SGIX GL_UNSIGNED_IDENTITY_NV
     GL_UNSIGNED_INT_24_8_NV GL_UNSIGNED_INT_8_8_8_8 GL_UNSIGNED_SHORT_5_6_5
     GL_USE_MISSING_GLYPH_NV GL_VARIANT_DATATYPE_EXT GL_VERTEX_ARRAY_BINDING
     GL_VERTEX_ARRAY_POINTER GL_VERTEX_DATA_HINT_PGI GL_VERTEX_WEIGHTING_EXT
     GL_VIEW_CLASS_RGTC1_RED GL_WEIGHTED_AVERAGE_ARB GL_WEIGHTED_AVERAGE_EXT
     GL_WEIGHT_SUM_UNITY_ARB GL_WINDOW_RECTANGLE_EXT */
  /* Offset 12 gives the best switch position.  */
  switch (name[12]) {
  case 'A':
    if (memEQ(name, "GL_BLEND_EQUATION_ALPHA", 23)) {
    /*                           ^                 */
#ifdef GL_BLEND_EQUATION_ALPHA
      *iv_return = (IV)GL_BLEND_EQUATION_ALPHA;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_ARRAY_LIST_IBM", 23)) {
    /*                           ^                 */
#ifdef GL_COLOR_ARRAY_LIST_IBM
      *iv_return = (IV)GL_COLOR_ARRAY_LIST_IBM;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_ARRAY_SIZE_EXT", 23)) {
    /*                           ^                 */
#ifdef GL_COLOR_ARRAY_SIZE_EXT
      *iv_return = (IV)GL_COLOR_ARRAY_SIZE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_ARRAY_TYPE_EXT", 23)) {
    /*                           ^                 */
#ifdef GL_COLOR_ARRAY_TYPE_EXT
      *iv_return = (IV)GL_COLOR_ARRAY_TYPE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CONSTANT_ATTENUATION", 23)) {
    /*                           ^                 */
#ifdef GL_CONSTANT_ATTENUATION
      *iv_return = (IV)GL_CONSTANT_ATTENUATION;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CURRENT_RASTER_COLOR", 23)) {
    /*                           ^                 */
#ifdef GL_CURRENT_RASTER_COLOR
      *iv_return = (IV)GL_CURRENT_RASTER_COLOR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CURRENT_RASTER_INDEX", 23)) {
    /*                           ^                 */
#ifdef GL_CURRENT_RASTER_INDEX
      *iv_return = (IV)GL_CURRENT_RASTER_INDEX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEPTH_ATTACHMENT_EXT", 23)) {
    /*                           ^                 */
#ifdef GL_DEPTH_ATTACHMENT_EXT
      *iv_return = (IV)GL_DEPTH_ATTACHMENT_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INDEX_ARRAY_LIST_IBM", 23)) {
    /*                           ^                 */
#ifdef GL_INDEX_ARRAY_LIST_IBM
      *iv_return = (IV)GL_INDEX_ARRAY_LIST_IBM;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INDEX_ARRAY_TYPE_EXT", 23)) {
    /*                           ^                 */
#ifdef GL_INDEX_ARRAY_TYPE_EXT
      *iv_return = (IV)GL_INDEX_ARRAY_TYPE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MIRROR_CLAMP_TO_EDGE", 23)) {
    /*                           ^                 */
#ifdef GL_MIRROR_CLAMP_TO_EDGE
      *iv_return = (IV)GL_MIRROR_CLAMP_TO_EDGE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PROGRAM_PARAMETER_NV", 23)) {
    /*                           ^                 */
#ifdef GL_PROGRAM_PARAMETER_NV
      *iv_return = (IV)GL_PROGRAM_PARAMETER_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RESAMPLE_AVERAGE_OML", 23)) {
    /*                           ^                 */
#ifdef GL_RESAMPLE_AVERAGE_OML
      *iv_return = (IV)GL_RESAMPLE_AVERAGE_OML;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SEPARATE_ATTRIBS_EXT", 23)) {
    /*                           ^                 */
#ifdef GL_SEPARATE_ATTRIBS_EXT
      *iv_return = (IV)GL_SEPARATE_ATTRIBS_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STENCIL_TAG_BITS_EXT", 23)) {
    /*                           ^                 */
#ifdef GL_STENCIL_TAG_BITS_EXT
      *iv_return = (IV)GL_STENCIL_TAG_BITS_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STORAGE_CACHED_APPLE", 23)) {
    /*                           ^                 */
#ifdef GL_STORAGE_CACHED_APPLE
      *iv_return = (IV)GL_STORAGE_CACHED_APPLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_MAX_LOD_SGIS", 23)) {
    /*                           ^                 */
#ifdef GL_TEXTURE_MAX_LOD_SGIS
      *iv_return = (IV)GL_TEXTURE_MAX_LOD_SGIS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VARIANT_DATATYPE_EXT", 23)) {
    /*                           ^                 */
#ifdef GL_VARIANT_DATATYPE_EXT
      *iv_return = (IV)GL_VARIANT_DATATYPE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_WEIGHTED_AVERAGE_ARB", 23)) {
    /*                           ^                 */
#ifdef GL_WEIGHTED_AVERAGE_ARB
      *iv_return = (IV)GL_WEIGHTED_AVERAGE_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_WEIGHTED_AVERAGE_EXT", 23)) {
    /*                           ^                 */
#ifdef GL_WEIGHTED_AVERAGE_EXT
      *iv_return = (IV)GL_WEIGHTED_AVERAGE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'B':
    if (memEQ(name, "GL_CLAMP_TO_BORDER_SGIS", 23)) {
    /*                           ^                 */
#ifdef GL_CLAMP_TO_BORDER_SGIS
      *iv_return = (IV)GL_CLAMP_TO_BORDER_SGIS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FEEDBACK_BUFFER_SIZE", 23)) {
    /*                           ^                 */
#ifdef GL_FEEDBACK_BUFFER_SIZE
      *iv_return = (IV)GL_FEEDBACK_BUFFER_SIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FEEDBACK_BUFFER_TYPE", 23)) {
    /*                           ^                 */
#ifdef GL_FEEDBACK_BUFFER_TYPE
      *iv_return = (IV)GL_FEEDBACK_BUFFER_TYPE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_DRAW_BUFFERS_ARB", 23)) {
    /*                           ^                 */
#ifdef GL_MAX_DRAW_BUFFERS_ARB
      *iv_return = (IV)GL_MAX_DRAW_BUFFERS_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_DRAW_BUFFERS_ATI", 23)) {
    /*                           ^                 */
#ifdef GL_MAX_DRAW_BUFFERS_ATI
      *iv_return = (IV)GL_MAX_DRAW_BUFFERS_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PACK_ROW_BYTES_APPLE", 23)) {
    /*                           ^                 */
#ifdef GL_PACK_ROW_BYTES_APPLE
      *iv_return = (IV)GL_PACK_ROW_BYTES_APPLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'C':
    if (memEQ(name, "GL_PATH_STENCIL_FUNC_NV", 23)) {
    /*                           ^                 */
#ifdef GL_PATH_STENCIL_FUNC_NV
      *iv_return = (IV)GL_PATH_STENCIL_FUNC_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_WINDOW_RECTANGLE_EXT", 23)) {
    /*                           ^                 */
#ifdef GL_WINDOW_RECTANGLE_EXT
      *iv_return = (IV)GL_WINDOW_RECTANGLE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'D':
    if (memEQ(name, "GL_CLAMP_READ_COLOR_ARB", 23)) {
    /*                           ^                 */
#ifdef GL_CLAMP_READ_COLOR_ARB
      *iv_return = (IV)GL_CLAMP_READ_COLOR_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COMPRESSED_ALPHA_ARB", 23)) {
    /*                           ^                 */
#ifdef GL_COMPRESSED_ALPHA_ARB
      *iv_return = (IV)GL_COMPRESSED_ALPHA_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COMPRESSED_INTENSITY", 23)) {
    /*                           ^                 */
#ifdef GL_COMPRESSED_INTENSITY
      *iv_return = (IV)GL_COMPRESSED_INTENSITY;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COMPRESSED_LUMINANCE", 23)) {
    /*                           ^                 */
#ifdef GL_COMPRESSED_LUMINANCE
      *iv_return = (IV)GL_COMPRESSED_LUMINANCE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COMPRESSED_RED_RGTC1", 23)) {
    /*                           ^                 */
#ifdef GL_COMPRESSED_RED_RGTC1
      *iv_return = (IV)GL_COMPRESSED_RED_RGTC1;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COMPRESSED_RGB8_ETC2", 23)) {
    /*                           ^                 */
#ifdef GL_COMPRESSED_RGB8_ETC2
      *iv_return = (IV)GL_COMPRESSED_RGB8_ETC2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_IMAGE_BINDING_ACCESS", 23)) {
    /*                           ^                 */
#ifdef GL_IMAGE_BINDING_ACCESS
      *iv_return = (IV)GL_IMAGE_BINDING_ACCESS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_IMAGE_BINDING_FORMAT", 23)) {
    /*                           ^                 */
#ifdef GL_IMAGE_BINDING_FORMAT
      *iv_return = (IV)GL_IMAGE_BINDING_FORMAT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NORMALIZED_RANGE_EXT", 23)) {
    /*                           ^                 */
#ifdef GL_NORMALIZED_RANGE_EXT
      *iv_return = (IV)GL_NORMALIZED_RANGE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLER_1D_ARRAY_EXT", 23)) {
    /*                           ^                 */
#ifdef GL_SAMPLER_1D_ARRAY_EXT
      *iv_return = (IV)GL_SAMPLER_1D_ARRAY_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLER_2D_ARRAY_EXT", 23)) {
    /*                           ^                 */
#ifdef GL_SAMPLER_2D_ARRAY_EXT
      *iv_return = (IV)GL_SAMPLER_2D_ARRAY_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_1D_ARRAY_EXT", 23)) {
    /*                           ^                 */
#ifdef GL_TEXTURE_1D_ARRAY_EXT
      *iv_return = (IV)GL_TEXTURE_1D_ARRAY_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_2D_ARRAY_EXT", 23)) {
    /*                           ^                 */
#ifdef GL_TEXTURE_2D_ARRAY_EXT
      *iv_return = (IV)GL_TEXTURE_2D_ARRAY_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'E':
    if (memEQ(name, "GL_ALL_BARRIER_BITS_EXT", 23)) {
    /*                           ^                 */
#ifdef GL_ALL_BARRIER_BITS_EXT
      *iv_return = (IV)GL_ALL_BARRIER_BITS_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEBUG_TYPE_ERROR_ARB", 23)) {
    /*                           ^                 */
#ifdef GL_DEBUG_TYPE_ERROR_ARB
      *iv_return = (IV)GL_DEBUG_TYPE_ERROR_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEBUG_TYPE_OTHER_ARB", 23)) {
    /*                           ^                 */
#ifdef GL_DEBUG_TYPE_OTHER_ARB
      *iv_return = (IV)GL_DEBUG_TYPE_OTHER_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEBUG_TYPE_POP_GROUP", 23)) {
    /*                           ^                 */
#ifdef GL_DEBUG_TYPE_POP_GROUP
      *iv_return = (IV)GL_DEBUG_TYPE_POP_GROUP;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRAW_FRAMEBUFFER_EXT", 23)) {
    /*                           ^                 */
#ifdef GL_DRAW_FRAMEBUFFER_EXT
      *iv_return = (IV)GL_DRAW_FRAMEBUFFER_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FORCE_BLUE_TO_ONE_NV", 23)) {
    /*                           ^                 */
#ifdef GL_FORCE_BLUE_TO_ONE_NV
      *iv_return = (IV)GL_FORCE_BLUE_TO_ONE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FRAMEBUFFER_COMPLETE", 23)) {
    /*                           ^                 */
#ifdef GL_FRAMEBUFFER_COMPLETE
      *iv_return = (IV)GL_FRAMEBUFFER_COMPLETE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FRAMEBUFFER_SRGB_EXT", 23)) {
    /*                           ^                 */
#ifdef GL_FRAMEBUFFER_SRGB_EXT
      *iv_return = (IV)GL_FRAMEBUFFER_SRGB_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_IMAGE_CUBE_MAP_ARRAY", 23)) {
    /*                           ^                 */
#ifdef GL_IMAGE_CUBE_MAP_ARRAY
      *iv_return = (IV)GL_IMAGE_CUBE_MAP_ARRAY;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INT_SAMPLER_1D_ARRAY", 23)) {
    /*                           ^                 */
#ifdef GL_INT_SAMPLER_1D_ARRAY
      *iv_return = (IV)GL_INT_SAMPLER_1D_ARRAY;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INT_SAMPLER_2D_ARRAY", 23)) {
    /*                           ^                 */
#ifdef GL_INT_SAMPLER_2D_ARRAY
      *iv_return = (IV)GL_INT_SAMPLER_2D_ARRAY;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INT_SAMPLER_CUBE_EXT", 23)) {
    /*                           ^                 */
#ifdef GL_INT_SAMPLER_CUBE_EXT
      *iv_return = (IV)GL_INT_SAMPLER_CUBE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LIGHT_MODEL_TWO_SIDE", 23)) {
    /*                           ^                 */
#ifdef GL_LIGHT_MODEL_TWO_SIDE
      *iv_return = (IV)GL_LIGHT_MODEL_TWO_SIDE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_SPOT_EXPONENT_NV", 23)) {
    /*                           ^                 */
#ifdef GL_MAX_SPOT_EXPONENT_NV
      *iv_return = (IV)GL_MAX_SPOT_EXPONENT_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MIN_SPARSE_LEVEL_AMD", 23)) {
    /*                           ^                 */
#ifdef GL_MIN_SPARSE_LEVEL_AMD
      *iv_return = (IV)GL_MIN_SPARSE_LEVEL_AMD;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NUM_ACTIVE_VARIABLES", 23)) {
    /*                           ^                 */
#ifdef GL_NUM_ACTIVE_VARIABLES
      *iv_return = (IV)GL_NUM_ACTIVE_VARIABLES;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_READ_FRAMEBUFFER_EXT", 23)) {
    /*                           ^                 */
#ifdef GL_READ_FRAMEBUFFER_EXT
      *iv_return = (IV)GL_READ_FRAMEBUFFER_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SLUMINANCE_ALPHA_EXT", 23)) {
    /*                           ^                 */
#ifdef GL_SLUMINANCE_ALPHA_EXT
      *iv_return = (IV)GL_SLUMINANCE_ALPHA_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_RECTANGLE_NV", 23)) {
    /*                           ^                 */
#ifdef GL_TEXTURE_RECTANGLE_NV
      *iv_return = (IV)GL_TEXTURE_RECTANGLE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_RED_SIZE_EXT", 23)) {
    /*                           ^                 */
#ifdef GL_TEXTURE_RED_SIZE_EXT
      *iv_return = (IV)GL_TEXTURE_RED_SIZE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_RED_TYPE_ARB", 23)) {
    /*                           ^                 */
#ifdef GL_TEXTURE_RED_TYPE_ARB
      *iv_return = (IV)GL_TEXTURE_RED_TYPE_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_RESIDENT_EXT", 23)) {
    /*                           ^                 */
#ifdef GL_TEXTURE_RESIDENT_EXT
      *iv_return = (IV)GL_TEXTURE_RESIDENT_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'F':
    if (memEQ(name, "GL_ALWAYS_SOFT_HINT_PGI", 23)) {
    /*                           ^                 */
#ifdef GL_ALWAYS_SOFT_HINT_PGI
      *iv_return = (IV)GL_ALWAYS_SOFT_HINT_PGI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARRAY_BUFFER_BINDING", 23)) {
    /*                           ^                 */
#ifdef GL_ARRAY_BUFFER_BINDING
      *iv_return = (IV)GL_ARRAY_BUFFER_BINDING;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LAYOUT_DEFAULT_INTEL", 23)) {
    /*                           ^                 */
#ifdef GL_LAYOUT_DEFAULT_INTEL
      *iv_return = (IV)GL_LAYOUT_DEFAULT_INTEL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_POLYGON_OFFSET_POINT", 23)) {
    /*                           ^                 */
#ifdef GL_POLYGON_OFFSET_POINT
      *iv_return = (IV)GL_POLYGON_OFFSET_POINT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_POLYGON_OFFSET_UNITS", 23)) {
    /*                           ^                 */
#ifdef GL_POLYGON_OFFSET_UNITS
      *iv_return = (IV)GL_POLYGON_OFFSET_UNITS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_QUERY_BUFFER_BINDING", 23)) {
    /*                           ^                 */
#ifdef GL_QUERY_BUFFER_BINDING
      *iv_return = (IV)GL_QUERY_BUFFER_BINDING;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RENDERBUFFER_BINDING", 23)) {
    /*                           ^                 */
#ifdef GL_RENDERBUFFER_BINDING
      *iv_return = (IV)GL_RENDERBUFFER_BINDING;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RENDERBUFFER_SAMPLES", 23)) {
    /*                           ^                 */
#ifdef GL_RENDERBUFFER_SAMPLES
      *iv_return = (IV)GL_RENDERBUFFER_SAMPLES;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'G':
    if (memEQ(name, "GL_CLAMP_FRAGMENT_COLOR", 23)) {
    /*                           ^                 */
#ifdef GL_CLAMP_FRAGMENT_COLOR
      *iv_return = (IV)GL_CLAMP_FRAGMENT_COLOR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PATH_FOG_GEN_MODE_NV", 23)) {
    /*                           ^                 */
#ifdef GL_PATH_FOG_GEN_MODE_NV
      *iv_return = (IV)GL_PATH_FOG_GEN_MODE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'H':
    if (memEQ(name, "GL_STORAGE_SHARED_APPLE", 23)) {
    /*                           ^                 */
#ifdef GL_STORAGE_SHARED_APPLE
      *iv_return = (IV)GL_STORAGE_SHARED_APPLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'I':
    if (memEQ(name, "GL_CURRENT_BINORMAL_EXT", 23)) {
    /*                           ^                 */
#ifdef GL_CURRENT_BINORMAL_EXT
      *iv_return = (IV)GL_CURRENT_BINORMAL_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FOG_COORDINATE_ARRAY", 23)) {
    /*                           ^                 */
#ifdef GL_FOG_COORDINATE_ARRAY
      *iv_return = (IV)GL_FOG_COORDINATE_ARRAY;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAT_EMISSION_BIT_PGI", 23)) {
    /*                           ^                 */
#ifdef GL_MAT_EMISSION_BIT_PGI
      *iv_return = (IV)GL_MAT_EMISSION_BIT_PGI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PROGRAM_BINARY_ANGLE", 23)) {
    /*                           ^                 */
#ifdef GL_PROGRAM_BINARY_ANGLE
      *iv_return = (IV)GL_PROGRAM_BINARY_ANGLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_MIN_LOD_SGIS", 23)) {
    /*                           ^                 */
#ifdef GL_TEXTURE_MIN_LOD_SGIS
      *iv_return = (IV)GL_TEXTURE_MIN_LOD_SGIS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNSIGNED_IDENTITY_NV", 23)) {
    /*                           ^                 */
#ifdef GL_UNSIGNED_IDENTITY_NV
      *iv_return = (IV)GL_UNSIGNED_IDENTITY_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNSIGNED_INT_24_8_NV", 23)) {
    /*                           ^                 */
#ifdef GL_UNSIGNED_INT_24_8_NV
      *iv_return = (IV)GL_UNSIGNED_INT_24_8_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNSIGNED_INT_8_8_8_8", 23)) {
    /*                           ^                 */
#ifdef GL_UNSIGNED_INT_8_8_8_8
      *iv_return = (IV)GL_UNSIGNED_INT_8_8_8_8;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERTEX_WEIGHTING_EXT", 23)) {
    /*                           ^                 */
#ifdef GL_VERTEX_WEIGHTING_EXT
      *iv_return = (IV)GL_VERTEX_WEIGHTING_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'K':
    if (memEQ(name, "GL_PATH_STROKE_BOUND_NV", 23)) {
    /*                           ^                 */
#ifdef GL_PATH_STROKE_BOUND_NV
      *iv_return = (IV)GL_PATH_STROKE_BOUND_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PATH_STROKE_WIDTH_NV", 23)) {
    /*                           ^                 */
#ifdef GL_PATH_STROKE_WIDTH_NV
      *iv_return = (IV)GL_PATH_STROKE_WIDTH_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'L':
    if (memEQ(name, "GL_COLOR_TABLE_BIAS_SGI", 23)) {
    /*                           ^                 */
#ifdef GL_COLOR_TABLE_BIAS_SGI
      *iv_return = (IV)GL_COLOR_TABLE_BIAS_SGI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_TABLE_RED_SIZE", 23)) {
    /*                           ^                 */
#ifdef GL_COLOR_TABLE_RED_SIZE
      *iv_return = (IV)GL_COLOR_TABLE_RED_SIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAT_SPECULAR_BIT_PGI", 23)) {
    /*                           ^                 */
#ifdef GL_MAT_SPECULAR_BIT_PGI
      *iv_return = (IV)GL_MAT_SPECULAR_BIT_PGI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MULTISAMPLE_BIT_3DFX", 23)) {
    /*                           ^                 */
#ifdef GL_MULTISAMPLE_BIT_3DFX
      *iv_return = (IV)GL_MULTISAMPLE_BIT_3DFX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STORAGE_CLIENT_APPLE", 23)) {
    /*                           ^                 */
#ifdef GL_STORAGE_CLIENT_APPLE
      *iv_return = (IV)GL_STORAGE_CLIENT_APPLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'M':
    if (memEQ(name, "GL_DEPTH_CLAMP_NEAR_AMD", 23)) {
    /*                           ^                 */
#ifdef GL_DEPTH_CLAMP_NEAR_AMD
      *iv_return = (IV)GL_DEPTH_CLAMP_NEAR_AMD;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_GENERATE_MIPMAP_HINT", 23)) {
    /*                           ^                 */
#ifdef GL_GENERATE_MIPMAP_HINT
      *iv_return = (IV)GL_GENERATE_MIPMAP_HINT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_GENERATE_MIPMAP_SGIS", 23)) {
    /*                           ^                 */
#ifdef GL_GENERATE_MIPMAP_SGIS
      *iv_return = (IV)GL_GENERATE_MIPMAP_SGIS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_IMAGE_2D_MULTISAMPLE", 23)) {
    /*                           ^                 */
#ifdef GL_IMAGE_2D_MULTISAMPLE
      *iv_return = (IV)GL_IMAGE_2D_MULTISAMPLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SIGNED_LUMINANCE8_NV", 23)) {
    /*                           ^                 */
#ifdef GL_SIGNED_LUMINANCE8_NV
      *iv_return = (IV)GL_SIGNED_LUMINANCE8_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_IMAGE_FORMAT", 23)) {
    /*                           ^                 */
#ifdef GL_TEXTURE_IMAGE_FORMAT
      *iv_return = (IV)GL_TEXTURE_IMAGE_FORMAT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_WEIGHT_SUM_UNITY_ARB", 23)) {
    /*                           ^                 */
#ifdef GL_WEIGHT_SUM_UNITY_ARB
      *iv_return = (IV)GL_WEIGHT_SUM_UNITY_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'N':
    if (memEQ(name, "GL_FOG_DISTANCE_MODE_NV", 23)) {
    /*                           ^                 */
#ifdef GL_FOG_DISTANCE_MODE_NV
      *iv_return = (IV)GL_FOG_DISTANCE_MODE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FONT_ASCENDER_BIT_NV", 23)) {
    /*                           ^                 */
#ifdef GL_FONT_ASCENDER_BIT_NV
      *iv_return = (IV)GL_FONT_ASCENDER_BIT_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_GUILTY_CONTEXT_RESET", 23)) {
    /*                           ^                 */
#ifdef GL_GUILTY_CONTEXT_RESET
      *iv_return = (IV)GL_GUILTY_CONTEXT_RESET;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_ELEMENTS_INDICES", 23)) {
    /*                           ^                 */
#ifdef GL_MAX_ELEMENTS_INDICES
      *iv_return = (IV)GL_MAX_ELEMENTS_INDICES;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_R1UI_C4F_N3F_V3F_SUN", 23)) {
    /*                           ^                 */
#ifdef GL_R1UI_C4F_N3F_V3F_SUN
      *iv_return = (IV)GL_R1UI_C4F_N3F_V3F_SUN;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_R1UI_T2F_N3F_V3F_SUN", 23)) {
    /*                           ^                 */
#ifdef GL_R1UI_T2F_N3F_V3F_SUN
      *iv_return = (IV)GL_R1UI_T2F_N3F_V3F_SUN;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_REPLACEMENT_CODE_SUN", 23)) {
    /*                           ^                 */
#ifdef GL_REPLACEMENT_CODE_SUN
      *iv_return = (IV)GL_REPLACEMENT_CODE_SUN;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SHADER_CONSISTENT_NV", 23)) {
    /*                           ^                 */
#ifdef GL_SHADER_CONSISTENT_NV
      *iv_return = (IV)GL_SHADER_CONSISTENT_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_USE_MISSING_GLYPH_NV", 23)) {
    /*                           ^                 */
#ifdef GL_USE_MISSING_GLYPH_NV
      *iv_return = (IV)GL_USE_MISSING_GLYPH_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'O':
    if (memEQ(name, "GL_BUFFER_STORAGE_FLAGS", 23)) {
    /*                           ^                 */
#ifdef GL_BUFFER_STORAGE_FLAGS
      *iv_return = (IV)GL_BUFFER_STORAGE_FLAGS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_GEOMETRY_OUTPUT_TYPE", 23)) {
    /*                           ^                 */
#ifdef GL_GEOMETRY_OUTPUT_TYPE
      *iv_return = (IV)GL_GEOMETRY_OUTPUT_TYPE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MOVE_TO_CONTINUES_NV", 23)) {
    /*                           ^                 */
#ifdef GL_MOVE_TO_CONTINUES_NV
      *iv_return = (IV)GL_MOVE_TO_CONTINUES_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SCALE_BY_ONE_HALF_NV", 23)) {
    /*                           ^                 */
#ifdef GL_SCALE_BY_ONE_HALF_NV
      *iv_return = (IV)GL_SCALE_BY_ONE_HALF_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SHADER_STORAGE_BLOCK", 23)) {
    /*                           ^                 */
#ifdef GL_SHADER_STORAGE_BLOCK
      *iv_return = (IV)GL_SHADER_STORAGE_BLOCK;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_BORDER_COLOR", 23)) {
    /*                           ^                 */
#ifdef GL_TEXTURE_BORDER_COLOR
      *iv_return = (IV)GL_TEXTURE_BORDER_COLOR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_COMPARE_FUNC", 23)) {
    /*                           ^                 */
#ifdef GL_TEXTURE_COMPARE_FUNC
      *iv_return = (IV)GL_TEXTURE_COMPARE_FUNC;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_COMPARE_MODE", 23)) {
    /*                           ^                 */
#ifdef GL_TEXTURE_COMPARE_MODE
      *iv_return = (IV)GL_TEXTURE_COMPARE_MODE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_COMPARE_SGIX", 23)) {
    /*                           ^                 */
#ifdef GL_TEXTURE_COMPARE_SGIX
      *iv_return = (IV)GL_TEXTURE_COMPARE_SGIX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_LOD_BIAS_EXT", 23)) {
    /*                           ^                 */
#ifdef GL_TEXTURE_LOD_BIAS_EXT
      *iv_return = (IV)GL_TEXTURE_LOD_BIAS_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'P':
    if (memEQ(name, "GL_FRAGMENT_PROGRAM_ARB", 23)) {
    /*                           ^                 */
#ifdef GL_FRAGMENT_PROGRAM_ARB
      *iv_return = (IV)GL_FRAGMENT_PROGRAM_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LINEAR_MIPMAP_LINEAR", 23)) {
    /*                           ^                 */
#ifdef GL_LINEAR_MIPMAP_LINEAR
      *iv_return = (IV)GL_LINEAR_MIPMAP_LINEAR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LINE_STIPPLE_PATTERN", 23)) {
    /*                           ^                 */
#ifdef GL_LINE_STIPPLE_PATTERN
      *iv_return = (IV)GL_LINE_STIPPLE_PATTERN;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LINE_STRIP_ADJACENCY", 23)) {
    /*                           ^                 */
#ifdef GL_LINE_STRIP_ADJACENCY
      *iv_return = (IV)GL_LINE_STRIP_ADJACENCY;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OP_CROSS_PRODUCT_EXT", 23)) {
    /*                           ^                 */
#ifdef GL_OP_CROSS_PRODUCT_EXT
      *iv_return = (IV)GL_OP_CROSS_PRODUCT_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STENCIL_OP_VALUE_AMD", 23)) {
    /*                           ^                 */
#ifdef GL_STENCIL_OP_VALUE_AMD
      *iv_return = (IV)GL_STENCIL_OP_VALUE_AMD;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'R':
    if (memEQ(name, "GL_ATTRIB_ARRAY_SIZE_NV", 23)) {
    /*                           ^                 */
#ifdef GL_ATTRIB_ARRAY_SIZE_NV
      *iv_return = (IV)GL_ATTRIB_ARRAY_SIZE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ATTRIB_ARRAY_TYPE_NV", 23)) {
    /*                           ^                 */
#ifdef GL_ATTRIB_ARRAY_TYPE_NV
      *iv_return = (IV)GL_ATTRIB_ARRAY_TYPE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_AUTO_GENERATE_MIPMAP", 23)) {
    /*                           ^                 */
#ifdef GL_AUTO_GENERATE_MIPMAP
      *iv_return = (IV)GL_AUTO_GENERATE_MIPMAP;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CONTEXT_PROFILE_MASK", 23)) {
    /*                           ^                 */
#ifdef GL_CONTEXT_PROFILE_MASK
      *iv_return = (IV)GL_CONTEXT_PROFILE_MASK;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEBUG_SOURCE_API_ARB", 23)) {
    /*                           ^                 */
#ifdef GL_DEBUG_SOURCE_API_ARB
      *iv_return = (IV)GL_DEBUG_SOURCE_API_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRAW_INDIRECT_BUFFER", 23)) {
    /*                           ^                 */
#ifdef GL_DRAW_INDIRECT_BUFFER
      *iv_return = (IV)GL_DRAW_INDIRECT_BUFFER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ELEMENT_ARRAY_BUFFER", 23)) {
    /*                           ^                 */
#ifdef GL_ELEMENT_ARRAY_BUFFER
      *iv_return = (IV)GL_ELEMENT_ARRAY_BUFFER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INVERSE_TRANSPOSE_NV", 23)) {
    /*                           ^                 */
#ifdef GL_INVERSE_TRANSPOSE_NV
      *iv_return = (IV)GL_INVERSE_TRANSPOSE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_TEXTURE_LOD_BIAS", 23)) {
    /*                           ^                 */
#ifdef GL_MAX_TEXTURE_LOD_BIAS
      *iv_return = (IV)GL_MAX_TEXTURE_LOD_BIAS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NORMAL_ARRAY_POINTER", 23)) {
    /*                           ^                 */
#ifdef GL_NORMAL_ARRAY_POINTER
      *iv_return = (IV)GL_NORMAL_ARRAY_POINTER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PALETTE4_RGB5_A1_OES", 23)) {
    /*                           ^                 */
#ifdef GL_PALETTE4_RGB5_A1_OES
      *iv_return = (IV)GL_PALETTE4_RGB5_A1_OES;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PALETTE8_RGB5_A1_OES", 23)) {
    /*                           ^                 */
#ifdef GL_PALETTE8_RGB5_A1_OES
      *iv_return = (IV)GL_PALETTE8_RGB5_A1_OES;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_QUERY_BY_REGION_WAIT", 23)) {
    /*                           ^                 */
#ifdef GL_QUERY_BY_REGION_WAIT
      *iv_return = (IV)GL_QUERY_BY_REGION_WAIT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TESS_CONTROL_TEXTURE", 23)) {
    /*                           ^                 */
#ifdef GL_TESS_CONTROL_TEXTURE
      *iv_return = (IV)GL_TESS_CONTROL_TEXTURE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_PRIORITY_EXT", 23)) {
    /*                           ^                 */
#ifdef GL_TEXTURE_PRIORITY_EXT
      *iv_return = (IV)GL_TEXTURE_PRIORITY_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNIFORM_ARRAY_STRIDE", 23)) {
    /*                           ^                 */
#ifdef GL_UNIFORM_ARRAY_STRIDE
      *iv_return = (IV)GL_UNIFORM_ARRAY_STRIDE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERTEX_ARRAY_BINDING", 23)) {
    /*                           ^                 */
#ifdef GL_VERTEX_ARRAY_BINDING
      *iv_return = (IV)GL_VERTEX_ARRAY_BINDING;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERTEX_ARRAY_POINTER", 23)) {
    /*                           ^                 */
#ifdef GL_VERTEX_ARRAY_POINTER
      *iv_return = (IV)GL_VERTEX_ARRAY_POINTER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'S':
    if (memEQ(name, "GL_ALWAYS_FAST_HINT_PGI", 23)) {
    /*                           ^                 */
#ifdef GL_ALWAYS_FAST_HINT_PGI
      *iv_return = (IV)GL_ALWAYS_FAST_HINT_PGI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEPTH32F_STENCIL8_NV", 23)) {
    /*                           ^                 */
#ifdef GL_DEPTH32F_STENCIL8_NV
      *iv_return = (IV)GL_DEPTH32F_STENCIL8_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_IMAGE_CLASS_11_11_10", 23)) {
    /*                           ^                 */
#ifdef GL_IMAGE_CLASS_11_11_10
      *iv_return = (IV)GL_IMAGE_CLASS_11_11_10;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_NAME_STACK_DEPTH", 23)) {
    /*                           ^                 */
#ifdef GL_MAX_NAME_STACK_DEPTH
      *iv_return = (IV)GL_MAX_NAME_STACK_DEPTH;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PRIMITIVES_GENERATED", 23)) {
    /*                           ^                 */
#ifdef GL_PRIMITIVES_GENERATED
      *iv_return = (IV)GL_PRIMITIVES_GENERATED;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLE_MASK_VALUE_NV", 23)) {
    /*                           ^                 */
#ifdef GL_SAMPLE_MASK_VALUE_NV
      *iv_return = (IV)GL_SAMPLE_MASK_VALUE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNIFORM_IS_ROW_MAJOR", 23)) {
    /*                           ^                 */
#ifdef GL_UNIFORM_IS_ROW_MAJOR
      *iv_return = (IV)GL_UNIFORM_IS_ROW_MAJOR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNPACK_RESAMPLE_SGIX", 23)) {
    /*                           ^                 */
#ifdef GL_UNPACK_RESAMPLE_SGIX
      *iv_return = (IV)GL_UNPACK_RESAMPLE_SGIX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNSIGNED_SHORT_5_6_5", 23)) {
    /*                           ^                 */
#ifdef GL_UNSIGNED_SHORT_5_6_5
      *iv_return = (IV)GL_UNSIGNED_SHORT_5_6_5;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VIEW_CLASS_RGTC1_RED", 23)) {
    /*                           ^                 */
#ifdef GL_VIEW_CLASS_RGTC1_RED
      *iv_return = (IV)GL_VIEW_CLASS_RGTC1_RED;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'T':
    if (memEQ(name, "GL_ASYNC_HISTOGRAM_SGIX", 23)) {
    /*                           ^                 */
#ifdef GL_ASYNC_HISTOGRAM_SGIX
      *iv_return = (IV)GL_ASYNC_HISTOGRAM_SGIX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEPTH24_STENCIL8_EXT", 23)) {
    /*                           ^                 */
#ifdef GL_DEPTH24_STENCIL8_EXT
      *iv_return = (IV)GL_DEPTH24_STENCIL8_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PROXY_TEXTURE_1D_EXT", 23)) {
    /*                           ^                 */
#ifdef GL_PROXY_TEXTURE_1D_EXT
      *iv_return = (IV)GL_PROXY_TEXTURE_1D_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PROXY_TEXTURE_2D_EXT", 23)) {
    /*                           ^                 */
#ifdef GL_PROXY_TEXTURE_2D_EXT
      *iv_return = (IV)GL_PROXY_TEXTURE_2D_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PROXY_TEXTURE_3D_EXT", 23)) {
    /*                           ^                 */
#ifdef GL_PROXY_TEXTURE_3D_EXT
      *iv_return = (IV)GL_PROXY_TEXTURE_3D_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SIGNED_INTENSITY8_NV", 23)) {
    /*                           ^                 */
#ifdef GL_SIGNED_INTENSITY8_NV
      *iv_return = (IV)GL_SIGNED_INTENSITY8_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_STENCIL_SIZE", 23)) {
    /*                           ^                 */
#ifdef GL_TEXTURE_STENCIL_SIZE
      *iv_return = (IV)GL_TEXTURE_STENCIL_SIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERTEX_DATA_HINT_PGI", 23)) {
    /*                           ^                 */
#ifdef GL_VERTEX_DATA_HINT_PGI
      *iv_return = (IV)GL_VERTEX_DATA_HINT_PGI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'U':
    if (memEQ(name, "GL_MAP1_TEXTURE_COORD_1", 23)) {
    /*                           ^                 */
#ifdef GL_MAP1_TEXTURE_COORD_1
      *iv_return = (IV)GL_MAP1_TEXTURE_COORD_1;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAP1_TEXTURE_COORD_2", 23)) {
    /*                           ^                 */
#ifdef GL_MAP1_TEXTURE_COORD_2
      *iv_return = (IV)GL_MAP1_TEXTURE_COORD_2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAP1_TEXTURE_COORD_3", 23)) {
    /*                           ^                 */
#ifdef GL_MAP1_TEXTURE_COORD_3
      *iv_return = (IV)GL_MAP1_TEXTURE_COORD_3;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAP1_TEXTURE_COORD_4", 23)) {
    /*                           ^                 */
#ifdef GL_MAP1_TEXTURE_COORD_4
      *iv_return = (IV)GL_MAP1_TEXTURE_COORD_4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAP2_TEXTURE_COORD_1", 23)) {
    /*                           ^                 */
#ifdef GL_MAP2_TEXTURE_COORD_1
      *iv_return = (IV)GL_MAP2_TEXTURE_COORD_1;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAP2_TEXTURE_COORD_2", 23)) {
    /*                           ^                 */
#ifdef GL_MAP2_TEXTURE_COORD_2
      *iv_return = (IV)GL_MAP2_TEXTURE_COORD_2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAP2_TEXTURE_COORD_3", 23)) {
    /*                           ^                 */
#ifdef GL_MAP2_TEXTURE_COORD_3
      *iv_return = (IV)GL_MAP2_TEXTURE_COORD_3;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAP2_TEXTURE_COORD_4", 23)) {
    /*                           ^                 */
#ifdef GL_MAP2_TEXTURE_COORD_4
      *iv_return = (IV)GL_MAP2_TEXTURE_COORD_4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_QUERY_RESULT_NO_WAIT", 23)) {
    /*                           ^                 */
#ifdef GL_QUERY_RESULT_NO_WAIT
      *iv_return = (IV)GL_QUERY_RESULT_NO_WAIT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLE_COUNT_BITS_NV", 23)) {
    /*                           ^                 */
#ifdef GL_SAMPLE_COUNT_BITS_NV
      *iv_return = (IV)GL_SAMPLE_COUNT_BITS_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SHADER_SOURCE_LENGTH", 23)) {
    /*                           ^                 */
#ifdef GL_SHADER_SOURCE_LENGTH
      *iv_return = (IV)GL_SHADER_SOURCE_LENGTH;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_CUBE_MAP_ARB", 23)) {
    /*                           ^                 */
#ifdef GL_TEXTURE_CUBE_MAP_ARB
      *iv_return = (IV)GL_TEXTURE_CUBE_MAP_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_CUBE_MAP_EXT", 23)) {
    /*                           ^                 */
#ifdef GL_TEXTURE_CUBE_MAP_EXT
      *iv_return = (IV)GL_TEXTURE_CUBE_MAP_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNIFORM_BUFFER_START", 23)) {
    /*                           ^                 */
#ifdef GL_UNIFORM_BUFFER_START
      *iv_return = (IV)GL_UNIFORM_BUFFER_START;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'W':
    if (memEQ(name, "GL_TEXTURE_SWIZZLE_RGBA", 23)) {
    /*                           ^                 */
#ifdef GL_TEXTURE_SWIZZLE_RGBA
      *iv_return = (IV)GL_TEXTURE_SWIZZLE_RGBA;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'X':
    if (memEQ(name, "GL_MAX_VERTEX_UNITS_ARB", 23)) {
    /*                           ^                 */
#ifdef GL_MAX_VERTEX_UNITS_ARB
      *iv_return = (IV)GL_MAX_VERTEX_UNITS_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OFFSET_TEXTURE_2D_NV", 23)) {
    /*                           ^                 */
#ifdef GL_OFFSET_TEXTURE_2D_NV
      *iv_return = (IV)GL_OFFSET_TEXTURE_2D_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'Y':
    if (memEQ(name, "GL_UNPACK_CMYK_HINT_EXT", 23)) {
    /*                           ^                 */
#ifdef GL_UNPACK_CMYK_HINT_EXT
      *iv_return = (IV)GL_UNPACK_CMYK_HINT_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '_':
    if (memEQ(name, "GL_ALPHA_MAX_CLAMP_INGR", 23)) {
    /*                           ^                 */
#ifdef GL_ALPHA_MAX_CLAMP_INGR
      *iv_return = (IV)GL_ALPHA_MAX_CLAMP_INGR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ALPHA_MIN_CLAMP_INGR", 23)) {
    /*                           ^                 */
#ifdef GL_ALPHA_MIN_CLAMP_INGR
      *iv_return = (IV)GL_ALPHA_MIN_CLAMP_INGR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ALPHA_REF_COMMAND_NV", 23)) {
    /*                           ^                 */
#ifdef GL_ALPHA_REF_COMMAND_NV
      *iv_return = (IV)GL_ALPHA_REF_COMMAND_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_point_parameters", 23)) {
    /*                           ^                 */
#ifdef GL_ARB_point_parameters
      *iv_return = (IV)GL_ARB_point_parameters;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ASYNC_TEX_IMAGE_SGIX", 23)) {
    /*                           ^                 */
#ifdef GL_ASYNC_TEX_IMAGE_SGIX
      *iv_return = (IV)GL_ASYNC_TEX_IMAGE_SGIX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CG_VERTEX_SHADER_EXT", 23)) {
    /*                           ^                 */
#ifdef GL_CG_VERTEX_SHADER_EXT
      *iv_return = (IV)GL_CG_VERTEX_SHADER_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COMPARE_R_TO_TEXTURE", 23)) {
    /*                           ^                 */
#ifdef GL_COMPARE_R_TO_TEXTURE
      *iv_return = (IV)GL_COMPARE_R_TO_TEXTURE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_point_parameters", 23)) {
    /*                           ^                 */
#ifdef GL_EXT_point_parameters
      *iv_return = (IV)GL_EXT_point_parameters;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FOG_COORD_ARRAY_TYPE", 23)) {
    /*                           ^                 */
#ifdef GL_FOG_COORD_ARRAY_TYPE
      *iv_return = (IV)GL_FOG_COORD_ARRAY_TYPE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_GREEN_MAX_CLAMP_INGR", 23)) {
    /*                           ^                 */
#ifdef GL_GREEN_MAX_CLAMP_INGR
      *iv_return = (IV)GL_GREEN_MAX_CLAMP_INGR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_GREEN_MIN_CLAMP_INGR", 23)) {
    /*                           ^                 */
#ifdef GL_GREEN_MIN_CLAMP_INGR
      *iv_return = (IV)GL_GREEN_MIN_CLAMP_INGR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_HISTOGRAM_ALPHA_SIZE", 23)) {
    /*                           ^                 */
#ifdef GL_HISTOGRAM_ALPHA_SIZE
      *iv_return = (IV)GL_HISTOGRAM_ALPHA_SIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_HISTOGRAM_FORMAT_EXT", 23)) {
    /*                           ^                 */
#ifdef GL_HISTOGRAM_FORMAT_EXT
      *iv_return = (IV)GL_HISTOGRAM_FORMAT_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_HISTOGRAM_GREEN_SIZE", 23)) {
    /*                           ^                 */
#ifdef GL_HISTOGRAM_GREEN_SIZE
      *iv_return = (IV)GL_HISTOGRAM_GREEN_SIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INT_IMAGE_BUFFER_EXT", 23)) {
    /*                           ^                 */
#ifdef GL_INT_IMAGE_BUFFER_EXT
      *iv_return = (IV)GL_INT_IMAGE_BUFFER_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_texgen_reflection", 23)) {
    /*                           ^                 */
#ifdef GL_NV_texgen_reflection
      *iv_return = (IV)GL_NV_texgen_reflection;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_vertex_program1_1", 23)) {
    /*                           ^                 */
#ifdef GL_NV_vertex_program1_1
      *iv_return = (IV)GL_NV_vertex_program1_1;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ONE_MINUS_SRC1_ALPHA", 23)) {
    /*                           ^                 */
#ifdef GL_ONE_MINUS_SRC1_ALPHA
      *iv_return = (IV)GL_ONE_MINUS_SRC1_ALPHA;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ONE_MINUS_SRC1_COLOR", 23)) {
    /*                           ^                 */
#ifdef GL_ONE_MINUS_SRC1_COLOR
      *iv_return = (IV)GL_ONE_MINUS_SRC1_COLOR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PACK_SKIP_IMAGES_EXT", 23)) {
    /*                           ^                 */
#ifdef GL_PACK_SKIP_IMAGES_EXT
      *iv_return = (IV)GL_PACK_SKIP_IMAGES_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PARAMETER_BUFFER_ARB", 23)) {
    /*                           ^                 */
#ifdef GL_PARAMETER_BUFFER_ARB
      *iv_return = (IV)GL_PARAMETER_BUFFER_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PERFQUERY_WAIT_INTEL", 23)) {
    /*                           ^                 */
#ifdef GL_PERFQUERY_WAIT_INTEL
      *iv_return = (IV)GL_PERFQUERY_WAIT_INTEL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PIXEL_MAG_FILTER_EXT", 23)) {
    /*                           ^                 */
#ifdef GL_PIXEL_MAG_FILTER_EXT
      *iv_return = (IV)GL_PIXEL_MAG_FILTER_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PIXEL_MIN_FILTER_EXT", 23)) {
    /*                           ^                 */
#ifdef GL_PIXEL_MIN_FILTER_EXT
      *iv_return = (IV)GL_PIXEL_MIN_FILTER_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PRIMITIVE_RESTART_NV", 23)) {
    /*                           ^                 */
#ifdef GL_PRIMITIVE_RESTART_NV
      *iv_return = (IV)GL_PRIMITIVE_RESTART_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PROVOKING_VERTEX_EXT", 23)) {
    /*                           ^                 */
#ifdef GL_PROVOKING_VERTEX_EXT
      *iv_return = (IV)GL_PROVOKING_VERTEX_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SECONDARY_COLOR_ATIX", 23)) {
    /*                           ^                 */
#ifdef GL_SECONDARY_COLOR_ATIX
      *iv_return = (IV)GL_SECONDARY_COLOR_ATIX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TOP_LEVEL_ARRAY_SIZE", 23)) {
    /*                           ^                 */
#ifdef GL_TOP_LEVEL_ARRAY_SIZE
      *iv_return = (IV)GL_TOP_LEVEL_ARRAY_SIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TRANSFORM_HINT_APPLE", 23)) {
    /*                           ^                 */
#ifdef GL_TRANSFORM_HINT_APPLE
      *iv_return = (IV)GL_TRANSFORM_HINT_APPLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'a':
    if (memEQ(name, "GL_ATI_separate_stencil", 23)) {
    /*                           ^                 */
#ifdef GL_ATI_separate_stencil
      *iv_return = (IV)GL_ATI_separate_stencil;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'b':
    if (memEQ(name, "GLEW_MESA_ycbcr_texture", 23)) {
    /*                           ^                 */
#ifdef GLEW_MESA_ycbcr_texture
      *iv_return = (IV)GLEW_MESA_ycbcr_texture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_framebuffer_sRGB", 23)) {
    /*                           ^                 */
#ifdef GL_ARB_framebuffer_sRGB
      *iv_return = (IV)GL_ARB_framebuffer_sRGB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_bindable_uniform", 23)) {
    /*                           ^                 */
#ifdef GL_EXT_bindable_uniform
      *iv_return = (IV)GL_EXT_bindable_uniform;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_framebuffer_blit", 23)) {
    /*                           ^                 */
#ifdef GL_EXT_framebuffer_blit
      *iv_return = (IV)GL_EXT_framebuffer_blit;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_framebuffer_sRGB", 23)) {
    /*                           ^                 */
#ifdef GL_EXT_framebuffer_sRGB
      *iv_return = (IV)GL_EXT_framebuffer_sRGB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'c':
    if (memEQ(name, "GLEW_EXT_misc_attribute", 23)) {
    /*                           ^                 */
#ifdef GLEW_EXT_misc_attribute
      *iv_return = (IV)GLEW_EXT_misc_attribute;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_EXT_rescale_normal", 23)) {
    /*                           ^                 */
#ifdef GLEW_EXT_rescale_normal
      *iv_return = (IV)GLEW_EXT_rescale_normal;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_enhanced_layouts", 23)) {
    /*                           ^                 */
#ifdef GL_ARB_enhanced_layouts
      *iv_return = (IV)GL_ARB_enhanced_layouts;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OES_byte_coordinates", 23)) {
    /*                           ^                 */
#ifdef GL_OES_byte_coordinates
      *iv_return = (IV)GL_OES_byte_coordinates;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SGIX_async_histogram", 23)) {
    /*                           ^                 */
#ifdef GL_SGIX_async_histogram
      *iv_return = (IV)GL_SGIX_async_histogram;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'd':
    if (memEQ(name, "GLEW_ARB_shader_objects", 23)) {
    /*                           ^                 */
#ifdef GLEW_ARB_shader_objects
      *iv_return = (IV)GLEW_ARB_shader_objects;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_ARB_shadow_ambient", 23)) {
    /*                           ^                 */
#ifdef GLEW_ARB_shadow_ambient
      *iv_return = (IV)GLEW_ARB_shadow_ambient;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'e':
    if (memEQ(name, "GLEW_EXT_index_material", 23)) {
    /*                           ^                 */
#ifdef GLEW_EXT_index_material
      *iv_return = (IV)GLEW_EXT_index_material;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_HP_image_transform", 23)) {
    /*                           ^                 */
#ifdef GLEW_HP_image_transform
      *iv_return = (IV)GLEW_HP_image_transform;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_NV_vertex_program2", 23)) {
    /*                           ^                 */
#ifdef GLEW_NV_vertex_program2
      *iv_return = (IV)GLEW_NV_vertex_program2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_NV_vertex_program3", 23)) {
    /*                           ^                 */
#ifdef GLEW_NV_vertex_program3
      *iv_return = (IV)GLEW_NV_vertex_program3;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_NV_vertex_program4", 23)) {
    /*                           ^                 */
#ifdef GLEW_NV_vertex_program4
      *iv_return = (IV)GLEW_NV_vertex_program4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_AMD_sample_positions", 23)) {
    /*                           ^                 */
#ifdef GL_AMD_sample_positions
      *iv_return = (IV)GL_AMD_sample_positions;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_APPLE_client_storage", 23)) {
    /*                           ^                 */
#ifdef GL_APPLE_client_storage
      *iv_return = (IV)GL_APPLE_client_storage;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_bindless_texture", 23)) {
    /*                           ^                 */
#ifdef GL_ARB_bindless_texture
      *iv_return = (IV)GL_ARB_bindless_texture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_fragment_program", 23)) {
    /*                           ^                 */
#ifdef GL_ARB_fragment_program
      *iv_return = (IV)GL_ARB_fragment_program;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_sample_locations", 23)) {
    /*                           ^                 */
#ifdef GL_ARB_sample_locations
      *iv_return = (IV)GL_ARB_sample_locations;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_texture_rectangle", 23)) {
    /*                           ^                 */
#ifdef GL_NV_texture_rectangle
      *iv_return = (IV)GL_NV_texture_rectangle;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OES_single_precision", 23)) {
    /*                           ^                 */
#ifdef GL_OES_single_precision
      *iv_return = (IV)GL_OES_single_precision;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'f':
    if (memEQ(name, "GLEW_ARB_buffer_storage", 23)) {
    /*                           ^                 */
#ifdef GLEW_ARB_buffer_storage
      *iv_return = (IV)GLEW_ARB_buffer_storage;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_half_float_pixel", 23)) {
    /*                           ^                 */
#ifdef GL_ARB_half_float_pixel
      *iv_return = (IV)GL_ARB_half_float_pixel;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'g':
    if (memEQ(name, "GL_ANGLE_program_binary", 23)) {
    /*                           ^                 */
#ifdef GL_ANGLE_program_binary
      *iv_return = (IV)GL_ANGLE_program_binary;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'h':
    if (memEQ(name, "GL_AMD_gpu_shader_int64", 23)) {
    /*                           ^                 */
#ifdef GL_AMD_gpu_shader_int64
      *iv_return = (IV)GL_AMD_gpu_shader_int64;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_gpu_shader_int64", 23)) {
    /*                           ^                 */
#ifdef GL_ARB_gpu_shader_int64
      *iv_return = (IV)GL_ARB_gpu_shader_int64;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'i':
    if (memEQ(name, "GLEW_APPLE_pixel_buffer", 23)) {
    /*                           ^                 */
#ifdef GLEW_APPLE_pixel_buffer
      *iv_return = (IV)GLEW_APPLE_pixel_buffer;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_ATIX_point_sprites", 23)) {
    /*                           ^                 */
#ifdef GLEW_ATIX_point_sprites
      *iv_return = (IV)GLEW_ATIX_point_sprites;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_coordinate_frame", 23)) {
    /*                           ^                 */
#ifdef GL_EXT_coordinate_frame
      *iv_return = (IV)GL_EXT_coordinate_frame;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_stencil_two_side", 23)) {
    /*                           ^                 */
#ifdef GL_EXT_stencil_two_side
      *iv_return = (IV)GL_EXT_stencil_two_side;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_primitive_restart", 23)) {
    /*                           ^                 */
#ifdef GL_NV_primitive_restart
      *iv_return = (IV)GL_NV_primitive_restart;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'k':
    if (memEQ(name, "GL_ARB_provoking_vertex", 23)) {
    /*                           ^                 */
#ifdef GL_ARB_provoking_vertex
      *iv_return = (IV)GL_ARB_provoking_vertex;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_provoking_vertex", 23)) {
    /*                           ^                 */
#ifdef GL_EXT_provoking_vertex
      *iv_return = (IV)GL_EXT_provoking_vertex;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'l':
    if (memEQ(name, "GLEW_APPLE_float_pixels", 23)) {
    /*                           ^                 */
#ifdef GLEW_APPLE_float_pixels
      *iv_return = (IV)GLEW_APPLE_float_pixels;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'm':
    if (memEQ(name, "GLEW_ATI_envmap_bumpmap", 23)) {
    /*                           ^                 */
#ifdef GLEW_ATI_envmap_bumpmap
      *iv_return = (IV)GLEW_ATI_envmap_bumpmap;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'n':
    if (memEQ(name, "GLEW_EXT_blend_logic_op", 23)) {
    /*                           ^                 */
#ifdef GLEW_EXT_blend_logic_op
      *iv_return = (IV)GLEW_EXT_blend_logic_op;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_EXT_blend_subtract", 23)) {
    /*                           ^                 */
#ifdef GLEW_EXT_blend_subtract
      *iv_return = (IV)GLEW_EXT_blend_subtract;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_SUNX_constant_data", 23)) {
    /*                           ^                 */
#ifdef GLEW_SUNX_constant_data
      *iv_return = (IV)GLEW_SUNX_constant_data;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_APPLE_transform_hint", 23)) {
    /*                           ^                 */
#ifdef GL_APPLE_transform_hint
      *iv_return = (IV)GL_APPLE_transform_hint;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_instanced_arrays", 23)) {
    /*                           ^                 */
#ifdef GL_ARB_instanced_arrays
      *iv_return = (IV)GL_ARB_instanced_arrays;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_fragment_program2", 23)) {
    /*                           ^                 */
#ifdef GL_NV_fragment_program2
      *iv_return = (IV)GL_NV_fragment_program2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_fragment_program4", 23)) {
    /*                           ^                 */
#ifdef GL_NV_fragment_program4
      *iv_return = (IV)GL_NV_fragment_program4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'o':
    if (memEQ(name, "GLEW_EXT_color_subtable", 23)) {
    /*                           ^                 */
#ifdef GLEW_EXT_color_subtable
      *iv_return = (IV)GLEW_EXT_color_subtable;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'p':
    if (memEQ(name, "GLEW_ARB_compute_shader", 23)) {
    /*                           ^                 */
#ifdef GLEW_ARB_compute_shader
      *iv_return = (IV)GLEW_ARB_compute_shader;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_ARB_sample_shading", 23)) {
    /*                           ^                 */
#ifdef GLEW_ARB_sample_shading
      *iv_return = (IV)GLEW_ARB_sample_shading;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_NV_viewport_array2", 23)) {
    /*                           ^                 */
#ifdef GLEW_NV_viewport_array2
      *iv_return = (IV)GLEW_NV_viewport_array2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_SGIX_depth_texture", 23)) {
    /*                           ^                 */
#ifdef GLEW_SGIX_depth_texture
      *iv_return = (IV)GLEW_SGIX_depth_texture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_transpose_matrix", 23)) {
    /*                           ^                 */
#ifdef GL_ARB_transpose_matrix
      *iv_return = (IV)GL_ARB_transpose_matrix;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SGIS_sharpen_texture", 23)) {
    /*                           ^                 */
#ifdef GL_SGIS_sharpen_texture
      *iv_return = (IV)GL_SGIS_sharpen_texture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'r':
    if (memEQ(name, "GLEW_AMD_sparse_texture", 23)) {
    /*                           ^                 */
#ifdef GLEW_AMD_sparse_texture
      *iv_return = (IV)GLEW_AMD_sparse_texture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_ARB_matrix_palette", 23)) {
    /*                           ^                 */
#ifdef GLEW_ARB_matrix_palette
      *iv_return = (IV)GLEW_ARB_matrix_palette;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_ARB_sparse_texture", 23)) {
    /*                           ^                 */
#ifdef GLEW_ARB_sparse_texture
      *iv_return = (IV)GLEW_ARB_sparse_texture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_REGAL_error_string", 23)) {
    /*                           ^                 */
#ifdef GLEW_REGAL_error_string
      *iv_return = (IV)GLEW_REGAL_error_string;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_REGAL_proc_address", 23)) {
    /*                           ^                 */
#ifdef GLEW_REGAL_proc_address
      *iv_return = (IV)GLEW_REGAL_proc_address;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_AMD_texture_texture4", 23)) {
    /*                           ^                 */
#ifdef GL_AMD_texture_texture4
      *iv_return = (IV)GL_AMD_texture_texture4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_shader_precision", 23)) {
    /*                           ^                 */
#ifdef GL_ARB_shader_precision
      *iv_return = (IV)GL_ARB_shader_precision;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_texture_cube_map", 23)) {
    /*                           ^                 */
#ifdef GL_ARB_texture_cube_map
      *iv_return = (IV)GL_ARB_texture_cube_map;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_texture_env_dot3", 23)) {
    /*                           ^                 */
#ifdef GL_ARB_texture_env_dot3
      *iv_return = (IV)GL_ARB_texture_env_dot3;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_texture_stencil8", 23)) {
    /*                           ^                 */
#ifdef GL_ARB_texture_stencil8
      *iv_return = (IV)GL_ARB_texture_stencil8;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_texture_cube_map", 23)) {
    /*                           ^                 */
#ifdef GL_EXT_texture_cube_map
      *iv_return = (IV)GL_EXT_texture_cube_map;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_texture_env_dot3", 23)) {
    /*                           ^                 */
#ifdef GL_EXT_texture_env_dot3
      *iv_return = (IV)GL_EXT_texture_env_dot3;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_texture_lod_bias", 23)) {
    /*                           ^                 */
#ifdef GL_EXT_texture_lod_bias
      *iv_return = (IV)GL_EXT_texture_lod_bias;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_geometry_program4", 23)) {
    /*                           ^                 */
#ifdef GL_NV_geometry_program4
      *iv_return = (IV)GL_NV_geometry_program4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SGIS_generate_mipmap", 23)) {
    /*                           ^                 */
#ifdef GL_SGIS_generate_mipmap
      *iv_return = (IV)GL_SGIS_generate_mipmap;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SGIX_reference_plane", 23)) {
    /*                           ^                 */
#ifdef GL_SGIX_reference_plane
      *iv_return = (IV)GL_SGIX_reference_plane;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 's':
    if (memEQ(name, "GLEW_SGIX_list_priority", 23)) {
    /*                           ^                 */
#ifdef GLEW_SGIX_list_priority
      *iv_return = (IV)GLEW_SGIX_list_priority;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_arrays_of_arrays", 23)) {
    /*                           ^                 */
#ifdef GL_ARB_arrays_of_arrays
      *iv_return = (IV)GL_ARB_arrays_of_arrays;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_occlusion_query2", 23)) {
    /*                           ^                 */
#ifdef GL_ARB_occlusion_query2
      *iv_return = (IV)GL_ARB_occlusion_query2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 't':
    if (memEQ(name, "GLEW_ARB_texture_gather", 23)) {
    /*                           ^                 */
#ifdef GLEW_ARB_texture_gather
      *iv_return = (IV)GLEW_ARB_texture_gather;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_ARB_vertex_program", 23)) {
    /*                           ^                 */
#ifdef GLEW_ARB_vertex_program
      *iv_return = (IV)GLEW_ARB_vertex_program;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_ATI_vertex_streams", 23)) {
    /*                           ^                 */
#ifdef GLEW_ATI_vertex_streams
      *iv_return = (IV)GLEW_ATI_vertex_streams;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_EXT_texture_object", 23)) {
    /*                           ^                 */
#ifdef GLEW_EXT_texture_object
      *iv_return = (IV)GLEW_EXT_texture_object;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_IBM_rasterpos_clip", 23)) {
    /*                           ^                 */
#ifdef GLEW_IBM_rasterpos_clip
      *iv_return = (IV)GLEW_IBM_rasterpos_clip;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_geometry_shader4", 23)) {
    /*                           ^                 */
#ifdef GL_ARB_geometry_shader4
      *iv_return = (IV)GL_ARB_geometry_shader4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_geometry_shader4", 23)) {
    /*                           ^                 */
#ifdef GL_EXT_geometry_shader4
      *iv_return = (IV)GL_EXT_geometry_shader4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_paletted_texture", 23)) {
    /*                           ^                 */
#ifdef GL_EXT_paletted_texture
      *iv_return = (IV)GL_EXT_paletted_texture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'u':
    if (memEQ(name, "GLEW_NV_occlusion_query", 23)) {
    /*                           ^                 */
#ifdef GLEW_NV_occlusion_query
      *iv_return = (IV)GLEW_NV_occlusion_query;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_NV_texture_barrier", 23)) {
    /*                           ^                 */
#ifdef GLEW_NV_texture_barrier
      *iv_return = (IV)GLEW_NV_texture_barrier;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_NV_texture_shader2", 23)) {
    /*                           ^                 */
#ifdef GLEW_NV_texture_shader2
      *iv_return = (IV)GLEW_NV_texture_shader2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_NV_texture_shader3", 23)) {
    /*                           ^                 */
#ifdef GLEW_NV_texture_shader3
      *iv_return = (IV)GLEW_NV_texture_shader3;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_map_buffer_range", 23)) {
    /*                           ^                 */
#ifdef GL_ARB_map_buffer_range
      *iv_return = (IV)GL_ARB_map_buffer_range;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_draw_vulkan_image", 23)) {
    /*                           ^                 */
#ifdef GL_NV_draw_vulkan_image
      *iv_return = (IV)GL_NV_draw_vulkan_image;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SGIS_texture_filter4", 23)) {
    /*                           ^                 */
#ifdef GL_SGIS_texture_filter4
      *iv_return = (IV)GL_SGIS_texture_filter4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SGIX_texture_add_env", 23)) {
    /*                           ^                 */
#ifdef GL_SGIX_texture_add_env
      *iv_return = (IV)GL_SGIX_texture_add_env;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'v':
    if (memEQ(name, "GL_EXT_clip_volume_hint", 23)) {
    /*                           ^                 */
#ifdef GL_EXT_clip_volume_hint
      *iv_return = (IV)GL_EXT_clip_volume_hint;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'w':
    if (memEQ(name, "GLEW_ARB_draw_instanced", 23)) {
    /*                           ^                 */
#ifdef GLEW_ARB_draw_instanced
      *iv_return = (IV)GLEW_ARB_draw_instanced;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_ARB_viewport_array", 23)) {
    /*                           ^                 */
#ifdef GLEW_ARB_viewport_array
      *iv_return = (IV)GLEW_ARB_viewport_array;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_EXT_draw_instanced", 23)) {
    /*                           ^                 */
#ifdef GLEW_EXT_draw_instanced
      *iv_return = (IV)GLEW_EXT_draw_instanced;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'x':
    if (memEQ(name, "GLEW_SGIS_pixel_texture", 23)) {
    /*                           ^                 */
#ifdef GLEW_SGIS_pixel_texture
      *iv_return = (IV)GLEW_SGIS_pixel_texture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_SGIX_pixel_texture", 23)) {
    /*                           ^                 */
#ifdef GLEW_SGIX_pixel_texture
      *iv_return = (IV)GLEW_SGIX_pixel_texture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_SGIX_texture_range", 23)) {
    /*                           ^                 */
#ifdef GLEW_SGIX_texture_range
      *iv_return = (IV)GLEW_SGIX_texture_range;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_vertex_weighting", 23)) {
    /*                           ^                 */
#ifdef GL_EXT_vertex_weighting
      *iv_return = (IV)GL_EXT_vertex_weighting;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'y':
    if (memEQ(name, "GLEW_EXT_polygon_offset", 23)) {
    /*                           ^                 */
#ifdef GLEW_EXT_polygon_offset
      *iv_return = (IV)GLEW_EXT_polygon_offset;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  }
  return PERL_constant_NOTFOUND;
}

static int
constant_24 (pTHX_ const char *name, IV *iv_return) {
  /* When generated this function returned values for the list of names given
     here.  However, subsequent manual editing may have added or removed some.
     GLEW_AMD_name_gen_delete GLEW_ANGLE_depth_texture GLEW_ANGLE_texture_usage
     GLEW_APPLE_element_array GLEW_APPLE_texture_range GLEW_ARB_fragment_shader
     GLEW_ARB_gpu_shader_fp64 GLEW_ARB_occlusion_query GLEW_ARB_sampler_objects
     GLEW_ARB_sparse_texture2 GLEW_ARB_texture_barrier GLEW_ARB_texture_env_add
     GLEW_ARB_texture_storage GLEW_ARB_texture_swizzle GLEW_ATI_fragment_shader
     GLEW_ERROR_NO_GL_VERSION GLEW_EXT_pixel_transform GLEW_EXT_secondary_color
     GLEW_EXT_sparse_texture2 GLEW_EXT_texture_env_add GLEW_EXT_texture_integer
     GLEW_EXT_texture_swizzle GLEW_EXT_x11_sync_object GLEW_HP_texture_lighting
     GLEW_INGR_interlace_read GLEW_MESAX_texture_stack GLEW_MESA_resize_buffers
     GLEW_NVX_gpu_memory_info GLEW_NV_bindless_texture GLEW_NV_compute_program5
     GLEW_NV_fragment_program GLEW_NV_geometry_shader4 GLEW_NV_gpu_program_fp64
     GLEW_NV_pixel_data_range GLEW_NV_sample_locations GLEW_NV_viewport_swizzle
     GLEW_SGIS_detail_texture GLEW_SGIS_texture_select GLEW_SGIX_ir_instrument1
     GLEW_SGIX_shadow_ambient GLEW_SGIX_vertex_preclip GL_ACTIVE_UNIFORM_BLOCKS
     GL_APPLE_specular_vector GL_ARB_ES2_compatibility GL_ARB_ES3_compatibility
     GL_ARB_half_float_vertex GL_ARB_seamless_cube_map GL_ARB_shader_group_vote
     GL_ARB_shader_image_size GL_ARB_shader_subroutine GL_ARB_stencil_texturing
     GL_ARB_texture_query_lod GL_ARB_texture_rectangle GL_ARB_vertex_array_bgra
     GL_ATI_map_object_buffer GL_ATOMIC_COUNTER_BUFFER GL_BACK_NORMALS_HINT_PGI
     GL_BACK_PRIMARY_COLOR_NV GL_BUFFER_GPU_ADDRESS_NV GL_CIRCULAR_CW_ARC_TO_NV
     GL_CLIENT_ACTIVE_TEXTURE GL_COLOR_ARRAY_COUNT_EXT GL_COLOR_ARRAY_LENGTH_NV
     GL_COLOR_ATTACHMENT0_EXT GL_COLOR_ATTACHMENT1_EXT GL_COLOR_ATTACHMENT2_EXT
     GL_COLOR_ATTACHMENT3_EXT GL_COLOR_ATTACHMENT4_EXT GL_COLOR_ATTACHMENT5_EXT
     GL_COLOR_ATTACHMENT6_EXT GL_COLOR_ATTACHMENT7_EXT GL_COLOR_ATTACHMENT8_EXT
     GL_COLOR_ATTACHMENT9_EXT GL_COLOR_TABLE_BLUE_SIZE GL_COLOR_TABLE_SCALE_SGI
     GL_COLOR_TABLE_WIDTH_EXT GL_COLOR_TABLE_WIDTH_SGI GL_COMBINER_AB_OUTPUT_NV
     GL_COMBINER_CD_OUTPUT_NV GL_COMPLETION_STATUS_ARB GL_COMPRESSED_SLUMINANCE
     GL_COMPRESSED_SRGB8_ETC2 GL_COMPRESSED_SRGB_ALPHA GL_CONTEXT_ROBUST_ACCESS
     GL_CONVOLUTION_HINT_SGIX GL_CONVOLUTION_WIDTH_EXT GL_CURRENT_VERTEX_ATTRIB
     GL_DEBUG_LOGGED_MESSAGES GL_DEBUG_SEVERITY_MEDIUM GL_DEBUG_TYPE_PUSH_GROUP
     GL_DEPTH_BOUNDS_TEST_EXT GL_DEPTH_COMPONENT16_ARB GL_DEPTH_COMPONENT24_ARB
     GL_DEPTH_COMPONENT32F_NV GL_DEPTH_COMPONENT32_ARB GL_DSDT_MAG_INTENSITY_NV
     GL_EVAL_TRIANGULAR_2D_NV GL_EXT_depth_bounds_test GL_EXT_fragment_lighting
     GL_EXT_multi_draw_arrays GL_EXT_stencil_clear_tag GL_EXT_texture_rectangle
     GL_EXT_vertex_array_bgra GL_EXT_window_rectangles GL_EYE_PLANE_ABSOLUTE_NV
     GL_FOG_COORDINATE_SOURCE GL_FOG_OFFSET_VALUE_SGIX GL_FONT_DESCENDER_BIT_NV
     GL_FRAGMENT_LIGHTING_EXT GL_FRAGMENT_MATERIAL_EXT GL_FRAMEBUFFER_UNDEFINED
     GL_FRONT_FACE_COMMAND_NV GL_FULL_STIPPLE_HINT_PGI GL_FUNC_REVERSE_SUBTRACT
     GL_GEOMETRY_VERTICES_OUT GL_GREMEDY_string_marker GL_HORIZONTAL_LINE_TO_NV
     GL_IMAGE_BINDING_LAYERED GL_INDEX_ARRAY_COUNT_EXT GL_INDEX_ARRAY_LENGTH_NV
     GL_INTEL_parallel_arrays GL_INTEL_texture_scissor GL_INTENSITY_FLOAT16_ATI
     GL_INTENSITY_FLOAT32_ATI GL_INTENSITY_SIGNED_SGIX GL_INT_IMAGE_2D_RECT_EXT
     GL_LINEAR_MIPMAP_NEAREST GL_LINE_WIDTH_COMMAND_NV GL_LOSE_CONTEXT_ON_RESET
     GL_LUMINANCE4_ALPHA4_EXT GL_LUMINANCE6_ALPHA2_EXT GL_LUMINANCE8_ALPHA8_EXT
     GL_LUMINANCE_ALPHA8I_EXT GL_LUMINANCE_ALPHA_SNORM GL_LUMINANCE_FLOAT16_ATI
     GL_LUMINANCE_FLOAT32_ATI GL_LUMINANCE_INTEGER_EXT GL_LUMINANCE_SIGNED_SGIX
     GL_MAP_ATTRIB_U_ORDER_NV GL_MAP_ATTRIB_V_ORDER_NV GL_MAT_SHININESS_BIT_PGI
     GL_MAX_ACTIVE_LIGHTS_EXT GL_MAX_COLOR_ATTACHMENTS GL_MAX_CONVOLUTION_WIDTH
     GL_MAX_ELEMENTS_VERTICES GL_MAX_FRAMEBUFFER_WIDTH GL_MAX_IMAGE_SAMPLES_EXT
     GL_MAX_RENDERBUFFER_SIZE GL_MAX_SAMPLE_MASK_WORDS GL_MAX_TEXTURE_COORDS_NV
     GL_MAX_TEXTURE_UNITS_ARB GL_MAX_TRACK_MATRICES_NV GL_MAX_UNIFORM_LOCATIONS
     GL_MODELVIEW0_MATRIX_EXT GL_MODELVIEW1_MATRIX_EXT GL_MODELVIEW_STACK_DEPTH
     GL_MODULATE_SUBTRACT_ATI GL_NAMED_STRING_TYPE_ARB GL_NEAREST_MIPMAP_LINEAR
     GL_NORMAL_ARRAY_LIST_IBM GL_NORMAL_ARRAY_TYPE_EXT GL_NO_RESET_NOTIFICATION
     GL_NUM_SPARSE_LEVELS_ARB GL_NV_conditional_render GL_NV_depth_buffer_float
     GL_NV_light_max_exponent GL_NV_register_combiners GL_NV_shader_buffer_load
     GL_NV_transform_feedback GL_NV_vertex_array_range GL_PACK_IMAGE_HEIGHT_EXT
     GL_PALETTE4_R5_G6_B5_OES GL_PALETTE8_R5_G6_B5_OES GL_PARALLEL_ARRAYS_INTEL
     GL_PATH_CLIENT_LENGTH_NV GL_PATH_COMMAND_COUNT_NV GL_PERFQUERY_FLUSH_INTEL
     GL_PIXEL_COUNTER_BITS_NV GL_PIXEL_MAP_A_TO_A_SIZE GL_PIXEL_MAP_B_TO_B_SIZE
     GL_PIXEL_MAP_G_TO_G_SIZE GL_PIXEL_MAP_I_TO_A_SIZE GL_PIXEL_MAP_I_TO_B_SIZE
     GL_PIXEL_MAP_I_TO_G_SIZE GL_PIXEL_MAP_I_TO_I_SIZE GL_PIXEL_MAP_I_TO_R_SIZE
     GL_PIXEL_MAP_R_TO_R_SIZE GL_PIXEL_MAP_S_TO_S_SIZE GL_PIXEL_PACK_BUFFER_ARB
     GL_PIXEL_PACK_BUFFER_EXT GL_PLUS_CLAMPED_ALPHA_NV GL_POLYGON_OFFSET_FACTOR
     GL_PROGRAM_BINARY_LENGTH GL_PROXY_COLOR_TABLE_SGI GL_QUADRATIC_ATTENUATION
     GL_QUADRATIC_CURVE_TO_NV GL_RASTERIZER_DISCARD_NV GL_REGAL_extension_query
     GL_REGISTER_COMBINERS_NV GL_RENDERBUFFER_RED_SIZE GL_RESAMPLE_DECIMATE_OML
     GL_RGBA_INTEGER_MODE_EXT GL_SAMPLER_1D_SHADOW_ARB GL_SAMPLER_2D_SHADOW_ARB
     GL_SAMPLE_COVERAGE_VALUE GL_SAMPLE_MASK_VALUE_EXT GL_SECONDARY_COLOR_ARRAY
     GL_SELECTION_BUFFER_SIZE GL_SGIX_texture_lod_bias GL_SHADER_BINARY_FORMATS
     GL_SHADER_STORAGE_BUFFER GL_SKIP_MISSING_GLYPH_NV GL_STANDARD_FONT_NAME_NV
     GL_STENCIL_BACK_FAIL_ATI GL_STENCIL_BACK_FUNC_ATI GL_STORAGE_PRIVATE_APPLE
     GL_SUN_read_video_pixels GL_SURFACE_REGISTERED_NV GL_TESSELLATION_MODE_AMD
     GL_TESS_GEN_VERTEX_ORDER GL_TEXTURE_BLUE_SIZE_EXT GL_TEXTURE_BLUE_TYPE_ARB
     GL_TEXTURE_BUFFER_FORMAT GL_TEXTURE_BUFFER_OFFSET GL_TEXTURE_GATHER_SHADOW
     GL_TEXTURE_GEQUAL_R_SGIX GL_TEXTURE_LEQUAL_R_SGIX GL_TEXTURE_RECTANGLE_ARB
     GL_TEXTURE_RECTANGLE_EXT GL_TEXTURE_SWIZZLE_A_EXT GL_TEXTURE_SWIZZLE_B_EXT
     GL_TEXTURE_SWIZZLE_G_EXT GL_TEXTURE_SWIZZLE_R_EXT GL_TRANSFORM_FEEDBACK_NV
     GL_UNIFORM_BLOCK_BINDING GL_UNIFORM_MATRIX_STRIDE GL_UNKNOWN_CONTEXT_RESET
     GL_UNSIGNED_INT8_VEC2_NV GL_UNSIGNED_INT8_VEC3_NV GL_UNSIGNED_INT8_VEC4_NV
     GL_UNSIGNED_INT_24_8_EXT GL_UNSIGNED_INT_IMAGE_1D GL_UNSIGNED_INT_IMAGE_2D
     GL_UNSIGNED_INT_IMAGE_3D GL_UNSIGNED_INT_VEC2_EXT GL_UNSIGNED_INT_VEC3_EXT
     GL_UNSIGNED_INT_VEC4_EXT GL_VERTEX_ARRAY_LIST_IBM GL_VERTEX_ARRAY_RANGE_NV
     GL_VERTEX_ARRAY_SIZE_EXT GL_VERTEX_ARRAY_TYPE_EXT GL_VERTEX_ATTRIB_BINDING
     GL_VERTEX_BINDING_BUFFER GL_VERTEX_BINDING_OFFSET GL_VERTEX_BINDING_STRIDE
     GL_VERTEX_ID_SWIZZLE_AMD GL_VIDEO_BUFFER_PITCH_NV GL_VIEWPORT_BOUNDS_RANGE
     GL_VIEWPORT_SWIZZLE_W_NV GL_VIEWPORT_SWIZZLE_X_NV GL_VIEWPORT_SWIZZLE_Y_NV
     GL_VIEWPORT_SWIZZLE_Z_NV GL_VIEW_CLASS_BPTC_FLOAT GL_VIEW_CLASS_BPTC_UNORM
     GL_WEIGHT_ARRAY_SIZE_ARB GL_WEIGHT_ARRAY_TYPE_ARB */
  /* Offset 19 gives the best switch position.  */
  switch (name[19]) {
  case '0':
    if (memEQ(name, "GL_COLOR_ATTACHMENT0_EXT", 24)) {
    /*                                  ^           */
#ifdef GL_COLOR_ATTACHMENT0_EXT
      *iv_return = (IV)GL_COLOR_ATTACHMENT0_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '1':
    if (memEQ(name, "GL_COLOR_ATTACHMENT1_EXT", 24)) {
    /*                                  ^           */
#ifdef GL_COLOR_ATTACHMENT1_EXT
      *iv_return = (IV)GL_COLOR_ATTACHMENT1_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '2':
    if (memEQ(name, "GL_COLOR_ATTACHMENT2_EXT", 24)) {
    /*                                  ^           */
#ifdef GL_COLOR_ATTACHMENT2_EXT
      *iv_return = (IV)GL_COLOR_ATTACHMENT2_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEPTH_COMPONENT32F_NV", 24)) {
    /*                                  ^           */
#ifdef GL_DEPTH_COMPONENT32F_NV
      *iv_return = (IV)GL_DEPTH_COMPONENT32F_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEPTH_COMPONENT32_ARB", 24)) {
    /*                                  ^           */
#ifdef GL_DEPTH_COMPONENT32_ARB
      *iv_return = (IV)GL_DEPTH_COMPONENT32_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EVAL_TRIANGULAR_2D_NV", 24)) {
    /*                                  ^           */
#ifdef GL_EVAL_TRIANGULAR_2D_NV
      *iv_return = (IV)GL_EVAL_TRIANGULAR_2D_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INTENSITY_FLOAT32_ATI", 24)) {
    /*                                  ^           */
#ifdef GL_INTENSITY_FLOAT32_ATI
      *iv_return = (IV)GL_INTENSITY_FLOAT32_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LUMINANCE6_ALPHA2_EXT", 24)) {
    /*                                  ^           */
#ifdef GL_LUMINANCE6_ALPHA2_EXT
      *iv_return = (IV)GL_LUMINANCE6_ALPHA2_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LUMINANCE_FLOAT32_ATI", 24)) {
    /*                                  ^           */
#ifdef GL_LUMINANCE_FLOAT32_ATI
      *iv_return = (IV)GL_LUMINANCE_FLOAT32_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNSIGNED_INT_VEC2_EXT", 24)) {
    /*                                  ^           */
#ifdef GL_UNSIGNED_INT_VEC2_EXT
      *iv_return = (IV)GL_UNSIGNED_INT_VEC2_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '3':
    if (memEQ(name, "GL_COLOR_ATTACHMENT3_EXT", 24)) {
    /*                                  ^           */
#ifdef GL_COLOR_ATTACHMENT3_EXT
      *iv_return = (IV)GL_COLOR_ATTACHMENT3_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNSIGNED_INT_VEC3_EXT", 24)) {
    /*                                  ^           */
#ifdef GL_UNSIGNED_INT_VEC3_EXT
      *iv_return = (IV)GL_UNSIGNED_INT_VEC3_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '4':
    if (memEQ(name, "GL_COLOR_ATTACHMENT4_EXT", 24)) {
    /*                                  ^           */
#ifdef GL_COLOR_ATTACHMENT4_EXT
      *iv_return = (IV)GL_COLOR_ATTACHMENT4_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEPTH_COMPONENT24_ARB", 24)) {
    /*                                  ^           */
#ifdef GL_DEPTH_COMPONENT24_ARB
      *iv_return = (IV)GL_DEPTH_COMPONENT24_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LUMINANCE4_ALPHA4_EXT", 24)) {
    /*                                  ^           */
#ifdef GL_LUMINANCE4_ALPHA4_EXT
      *iv_return = (IV)GL_LUMINANCE4_ALPHA4_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNSIGNED_INT_VEC4_EXT", 24)) {
    /*                                  ^           */
#ifdef GL_UNSIGNED_INT_VEC4_EXT
      *iv_return = (IV)GL_UNSIGNED_INT_VEC4_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '5':
    if (memEQ(name, "GL_COLOR_ATTACHMENT5_EXT", 24)) {
    /*                                  ^           */
#ifdef GL_COLOR_ATTACHMENT5_EXT
      *iv_return = (IV)GL_COLOR_ATTACHMENT5_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PALETTE4_R5_G6_B5_OES", 24)) {
    /*                                  ^           */
#ifdef GL_PALETTE4_R5_G6_B5_OES
      *iv_return = (IV)GL_PALETTE4_R5_G6_B5_OES;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PALETTE8_R5_G6_B5_OES", 24)) {
    /*                                  ^           */
#ifdef GL_PALETTE8_R5_G6_B5_OES
      *iv_return = (IV)GL_PALETTE8_R5_G6_B5_OES;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '6':
    if (memEQ(name, "GL_COLOR_ATTACHMENT6_EXT", 24)) {
    /*                                  ^           */
#ifdef GL_COLOR_ATTACHMENT6_EXT
      *iv_return = (IV)GL_COLOR_ATTACHMENT6_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEPTH_COMPONENT16_ARB", 24)) {
    /*                                  ^           */
#ifdef GL_DEPTH_COMPONENT16_ARB
      *iv_return = (IV)GL_DEPTH_COMPONENT16_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INTENSITY_FLOAT16_ATI", 24)) {
    /*                                  ^           */
#ifdef GL_INTENSITY_FLOAT16_ATI
      *iv_return = (IV)GL_INTENSITY_FLOAT16_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LUMINANCE_FLOAT16_ATI", 24)) {
    /*                                  ^           */
#ifdef GL_LUMINANCE_FLOAT16_ATI
      *iv_return = (IV)GL_LUMINANCE_FLOAT16_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '7':
    if (memEQ(name, "GL_COLOR_ATTACHMENT7_EXT", 24)) {
    /*                                  ^           */
#ifdef GL_COLOR_ATTACHMENT7_EXT
      *iv_return = (IV)GL_COLOR_ATTACHMENT7_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '8':
    if (memEQ(name, "GL_COLOR_ATTACHMENT8_EXT", 24)) {
    /*                                  ^           */
#ifdef GL_COLOR_ATTACHMENT8_EXT
      *iv_return = (IV)GL_COLOR_ATTACHMENT8_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LUMINANCE8_ALPHA8_EXT", 24)) {
    /*                                  ^           */
#ifdef GL_LUMINANCE8_ALPHA8_EXT
      *iv_return = (IV)GL_LUMINANCE8_ALPHA8_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNSIGNED_INT_24_8_EXT", 24)) {
    /*                                  ^           */
#ifdef GL_UNSIGNED_INT_24_8_EXT
      *iv_return = (IV)GL_UNSIGNED_INT_24_8_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '9':
    if (memEQ(name, "GL_COLOR_ATTACHMENT9_EXT", 24)) {
    /*                                  ^           */
#ifdef GL_COLOR_ATTACHMENT9_EXT
      *iv_return = (IV)GL_COLOR_ATTACHMENT9_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'A':
    if (memEQ(name, "GL_COMPRESSED_SRGB_ALPHA", 24)) {
    /*                                  ^           */
#ifdef GL_COMPRESSED_SRGB_ALPHA
      *iv_return = (IV)GL_COMPRESSED_SRGB_ALPHA;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LINEAR_MIPMAP_NEAREST", 24)) {
    /*                                  ^           */
#ifdef GL_LINEAR_MIPMAP_NEAREST
      *iv_return = (IV)GL_LINEAR_MIPMAP_NEAREST;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NO_RESET_NOTIFICATION", 24)) {
    /*                                  ^           */
#ifdef GL_NO_RESET_NOTIFICATION
      *iv_return = (IV)GL_NO_RESET_NOTIFICATION;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_POLYGON_OFFSET_FACTOR", 24)) {
    /*                                  ^           */
#ifdef GL_POLYGON_OFFSET_FACTOR
      *iv_return = (IV)GL_POLYGON_OFFSET_FACTOR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_QUADRATIC_ATTENUATION", 24)) {
    /*                                  ^           */
#ifdef GL_QUADRATIC_ATTENUATION
      *iv_return = (IV)GL_QUADRATIC_ATTENUATION;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SECONDARY_COLOR_ARRAY", 24)) {
    /*                                  ^           */
#ifdef GL_SECONDARY_COLOR_ARRAY
      *iv_return = (IV)GL_SECONDARY_COLOR_ARRAY;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STORAGE_PRIVATE_APPLE", 24)) {
    /*                                  ^           */
#ifdef GL_STORAGE_PRIVATE_APPLE
      *iv_return = (IV)GL_STORAGE_PRIVATE_APPLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_SWIZZLE_A_EXT", 24)) {
    /*                                  ^           */
#ifdef GL_TEXTURE_SWIZZLE_A_EXT
      *iv_return = (IV)GL_TEXTURE_SWIZZLE_A_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'B':
    if (memEQ(name, "GL_TEXTURE_SWIZZLE_B_EXT", 24)) {
    /*                                  ^           */
#ifdef GL_TEXTURE_SWIZZLE_B_EXT
      *iv_return = (IV)GL_TEXTURE_SWIZZLE_B_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'C':
    if (memEQ(name, "GL_CONTEXT_ROBUST_ACCESS", 24)) {
    /*                                  ^           */
#ifdef GL_CONTEXT_ROBUST_ACCESS
      *iv_return = (IV)GL_CONTEXT_ROBUST_ACCESS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STENCIL_BACK_FUNC_ATI", 24)) {
    /*                                  ^           */
#ifdef GL_STENCIL_BACK_FUNC_ATI
      *iv_return = (IV)GL_STENCIL_BACK_FUNC_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TRANSFORM_FEEDBACK_NV", 24)) {
    /*                                  ^           */
#ifdef GL_TRANSFORM_FEEDBACK_NV
      *iv_return = (IV)GL_TRANSFORM_FEEDBACK_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNSIGNED_INT8_VEC2_NV", 24)) {
    /*                                  ^           */
#ifdef GL_UNSIGNED_INT8_VEC2_NV
      *iv_return = (IV)GL_UNSIGNED_INT8_VEC2_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNSIGNED_INT8_VEC3_NV", 24)) {
    /*                                  ^           */
#ifdef GL_UNSIGNED_INT8_VEC3_NV
      *iv_return = (IV)GL_UNSIGNED_INT8_VEC3_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNSIGNED_INT8_VEC4_NV", 24)) {
    /*                                  ^           */
#ifdef GL_UNSIGNED_INT8_VEC4_NV
      *iv_return = (IV)GL_UNSIGNED_INT8_VEC4_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VIDEO_BUFFER_PITCH_NV", 24)) {
    /*                                  ^           */
#ifdef GL_VIDEO_BUFFER_PITCH_NV
      *iv_return = (IV)GL_VIDEO_BUFFER_PITCH_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'D':
    if (memEQ(name, "GL_MAX_TEXTURE_COORDS_NV", 24)) {
    /*                                  ^           */
#ifdef GL_MAX_TEXTURE_COORDS_NV
      *iv_return = (IV)GL_MAX_TEXTURE_COORDS_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MODELVIEW_STACK_DEPTH", 24)) {
    /*                                  ^           */
#ifdef GL_MODELVIEW_STACK_DEPTH
      *iv_return = (IV)GL_MODELVIEW_STACK_DEPTH;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'E':
    if (memEQ(name, "GL_COLOR_TABLE_SCALE_SGI", 24)) {
    /*                                  ^           */
#ifdef GL_COLOR_TABLE_SCALE_SGI
      *iv_return = (IV)GL_COLOR_TABLE_SCALE_SGI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEBUG_SEVERITY_MEDIUM", 24)) {
    /*                                  ^           */
#ifdef GL_DEBUG_SEVERITY_MEDIUM
      *iv_return = (IV)GL_DEBUG_SEVERITY_MEDIUM;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAP_ATTRIB_U_ORDER_NV", 24)) {
    /*                                  ^           */
#ifdef GL_MAP_ATTRIB_U_ORDER_NV
      *iv_return = (IV)GL_MAP_ATTRIB_U_ORDER_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAP_ATTRIB_V_ORDER_NV", 24)) {
    /*                                  ^           */
#ifdef GL_MAP_ATTRIB_V_ORDER_NV
      *iv_return = (IV)GL_MAP_ATTRIB_V_ORDER_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_TRACK_MATRICES_NV", 24)) {
    /*                                  ^           */
#ifdef GL_MAX_TRACK_MATRICES_NV
      *iv_return = (IV)GL_MAX_TRACK_MATRICES_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NAMED_STRING_TYPE_ARB", 24)) {
    /*                                  ^           */
#ifdef GL_NAMED_STRING_TYPE_ARB
      *iv_return = (IV)GL_NAMED_STRING_TYPE_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NORMAL_ARRAY_TYPE_EXT", 24)) {
    /*                                  ^           */
#ifdef GL_NORMAL_ARRAY_TYPE_EXT
      *iv_return = (IV)GL_NORMAL_ARRAY_TYPE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PROGRAM_BINARY_LENGTH", 24)) {
    /*                                  ^           */
#ifdef GL_PROGRAM_BINARY_LENGTH
      *iv_return = (IV)GL_PROGRAM_BINARY_LENGTH;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PROXY_COLOR_TABLE_SGI", 24)) {
    /*                                  ^           */
#ifdef GL_PROXY_COLOR_TABLE_SGI
      *iv_return = (IV)GL_PROXY_COLOR_TABLE_SGI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RESAMPLE_DECIMATE_OML", 24)) {
    /*                                  ^           */
#ifdef GL_RESAMPLE_DECIMATE_OML
      *iv_return = (IV)GL_RESAMPLE_DECIMATE_OML;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RGBA_INTEGER_MODE_EXT", 24)) {
    /*                                  ^           */
#ifdef GL_RGBA_INTEGER_MODE_EXT
      *iv_return = (IV)GL_RGBA_INTEGER_MODE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLE_MASK_VALUE_EXT", 24)) {
    /*                                  ^           */
#ifdef GL_SAMPLE_MASK_VALUE_EXT
      *iv_return = (IV)GL_SAMPLE_MASK_VALUE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SURFACE_REGISTERED_NV", 24)) {
    /*                                  ^           */
#ifdef GL_SURFACE_REGISTERED_NV
      *iv_return = (IV)GL_SURFACE_REGISTERED_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TESSELLATION_MODE_AMD", 24)) {
    /*                                  ^           */
#ifdef GL_TESSELLATION_MODE_AMD
      *iv_return = (IV)GL_TESSELLATION_MODE_AMD;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_BLUE_SIZE_EXT", 24)) {
    /*                                  ^           */
#ifdef GL_TEXTURE_BLUE_SIZE_EXT
      *iv_return = (IV)GL_TEXTURE_BLUE_SIZE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_BLUE_TYPE_ARB", 24)) {
    /*                                  ^           */
#ifdef GL_TEXTURE_BLUE_TYPE_ARB
      *iv_return = (IV)GL_TEXTURE_BLUE_TYPE_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_RECTANGLE_ARB", 24)) {
    /*                                  ^           */
#ifdef GL_TEXTURE_RECTANGLE_ARB
      *iv_return = (IV)GL_TEXTURE_RECTANGLE_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_RECTANGLE_EXT", 24)) {
    /*                                  ^           */
#ifdef GL_TEXTURE_RECTANGLE_EXT
      *iv_return = (IV)GL_TEXTURE_RECTANGLE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERTEX_ARRAY_SIZE_EXT", 24)) {
    /*                                  ^           */
#ifdef GL_VERTEX_ARRAY_SIZE_EXT
      *iv_return = (IV)GL_VERTEX_ARRAY_SIZE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERTEX_ARRAY_TYPE_EXT", 24)) {
    /*                                  ^           */
#ifdef GL_VERTEX_ARRAY_TYPE_EXT
      *iv_return = (IV)GL_VERTEX_ARRAY_TYPE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERTEX_ID_SWIZZLE_AMD", 24)) {
    /*                                  ^           */
#ifdef GL_VERTEX_ID_SWIZZLE_AMD
      *iv_return = (IV)GL_VERTEX_ID_SWIZZLE_AMD;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_WEIGHT_ARRAY_SIZE_ARB", 24)) {
    /*                                  ^           */
#ifdef GL_WEIGHT_ARRAY_SIZE_ARB
      *iv_return = (IV)GL_WEIGHT_ARRAY_SIZE_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_WEIGHT_ARRAY_TYPE_ARB", 24)) {
    /*                                  ^           */
#ifdef GL_WEIGHT_ARRAY_TYPE_ARB
      *iv_return = (IV)GL_WEIGHT_ARRAY_TYPE_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'F':
    if (memEQ(name, "GL_FRAMEBUFFER_UNDEFINED", 24)) {
    /*                                  ^           */
#ifdef GL_FRAMEBUFFER_UNDEFINED
      *iv_return = (IV)GL_FRAMEBUFFER_UNDEFINED;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_BUFFER_OFFSET", 24)) {
    /*                                  ^           */
#ifdef GL_TEXTURE_BUFFER_OFFSET
      *iv_return = (IV)GL_TEXTURE_BUFFER_OFFSET;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERTEX_BINDING_OFFSET", 24)) {
    /*                                  ^           */
#ifdef GL_VERTEX_BINDING_OFFSET
      *iv_return = (IV)GL_VERTEX_BINDING_OFFSET;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VIEW_CLASS_BPTC_FLOAT", 24)) {
    /*                                  ^           */
#ifdef GL_VIEW_CLASS_BPTC_FLOAT
      *iv_return = (IV)GL_VIEW_CLASS_BPTC_FLOAT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'G':
    if (memEQ(name, "GL_DEBUG_TYPE_PUSH_GROUP", 24)) {
    /*                                  ^           */
#ifdef GL_DEBUG_TYPE_PUSH_GROUP
      *iv_return = (IV)GL_DEBUG_TYPE_PUSH_GROUP;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FRAGMENT_LIGHTING_EXT", 24)) {
    /*                                  ^           */
#ifdef GL_FRAGMENT_LIGHTING_EXT
      *iv_return = (IV)GL_FRAGMENT_LIGHTING_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_SWIZZLE_G_EXT", 24)) {
    /*                                  ^           */
#ifdef GL_TEXTURE_SWIZZLE_G_EXT
      *iv_return = (IV)GL_TEXTURE_SWIZZLE_G_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNSIGNED_INT_IMAGE_1D", 24)) {
    /*                                  ^           */
#ifdef GL_UNSIGNED_INT_IMAGE_1D
      *iv_return = (IV)GL_UNSIGNED_INT_IMAGE_1D;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNSIGNED_INT_IMAGE_2D", 24)) {
    /*                                  ^           */
#ifdef GL_UNSIGNED_INT_IMAGE_2D
      *iv_return = (IV)GL_UNSIGNED_INT_IMAGE_2D;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNSIGNED_INT_IMAGE_3D", 24)) {
    /*                                  ^           */
#ifdef GL_UNSIGNED_INT_IMAGE_3D
      *iv_return = (IV)GL_UNSIGNED_INT_IMAGE_3D;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERTEX_ARRAY_RANGE_NV", 24)) {
    /*                                  ^           */
#ifdef GL_VERTEX_ARRAY_RANGE_NV
      *iv_return = (IV)GL_VERTEX_ARRAY_RANGE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'H':
    if (memEQ(name, "GL_COLOR_TABLE_WIDTH_EXT", 24)) {
    /*                                  ^           */
#ifdef GL_COLOR_TABLE_WIDTH_EXT
      *iv_return = (IV)GL_COLOR_TABLE_WIDTH_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_TABLE_WIDTH_SGI", 24)) {
    /*                                  ^           */
#ifdef GL_COLOR_TABLE_WIDTH_SGI
      *iv_return = (IV)GL_COLOR_TABLE_WIDTH_SGI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CONVOLUTION_WIDTH_EXT", 24)) {
    /*                                  ^           */
#ifdef GL_CONVOLUTION_WIDTH_EXT
      *iv_return = (IV)GL_CONVOLUTION_WIDTH_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PLUS_CLAMPED_ALPHA_NV", 24)) {
    /*                                  ^           */
#ifdef GL_PLUS_CLAMPED_ALPHA_NV
      *iv_return = (IV)GL_PLUS_CLAMPED_ALPHA_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_GATHER_SHADOW", 24)) {
    /*                                  ^           */
#ifdef GL_TEXTURE_GATHER_SHADOW
      *iv_return = (IV)GL_TEXTURE_GATHER_SHADOW;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'I':
    if (memEQ(name, "GL_FONT_DESCENDER_BIT_NV", 24)) {
    /*                                  ^           */
#ifdef GL_FONT_DESCENDER_BIT_NV
      *iv_return = (IV)GL_FONT_DESCENDER_BIT_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LUMINANCE_ALPHA8I_EXT", 24)) {
    /*                                  ^           */
#ifdef GL_LUMINANCE_ALPHA8I_EXT
      *iv_return = (IV)GL_LUMINANCE_ALPHA8I_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NEAREST_MIPMAP_LINEAR", 24)) {
    /*                                  ^           */
#ifdef GL_NEAREST_MIPMAP_LINEAR
      *iv_return = (IV)GL_NEAREST_MIPMAP_LINEAR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PARALLEL_ARRAYS_INTEL", 24)) {
    /*                                  ^           */
#ifdef GL_PARALLEL_ARRAYS_INTEL
      *iv_return = (IV)GL_PARALLEL_ARRAYS_INTEL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PERFQUERY_FLUSH_INTEL", 24)) {
    /*                                  ^           */
#ifdef GL_PERFQUERY_FLUSH_INTEL
      *iv_return = (IV)GL_PERFQUERY_FLUSH_INTEL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'L':
    if (memEQ(name, "GL_ACTIVE_UNIFORM_BLOCKS", 24)) {
    /*                                  ^           */
#ifdef GL_ACTIVE_UNIFORM_BLOCKS
      *iv_return = (IV)GL_ACTIVE_UNIFORM_BLOCKS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FRAGMENT_MATERIAL_EXT", 24)) {
    /*                                  ^           */
#ifdef GL_FRAGMENT_MATERIAL_EXT
      *iv_return = (IV)GL_FRAGMENT_MATERIAL_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STENCIL_BACK_FAIL_ATI", 24)) {
    /*                                  ^           */
#ifdef GL_STENCIL_BACK_FAIL_ATI
      *iv_return = (IV)GL_STENCIL_BACK_FAIL_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'M':
    if (memEQ(name, "GL_MAX_COLOR_ATTACHMENTS", 24)) {
    /*                                  ^           */
#ifdef GL_MAX_COLOR_ATTACHMENTS
      *iv_return = (IV)GL_MAX_COLOR_ATTACHMENTS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STANDARD_FONT_NAME_NV", 24)) {
    /*                                  ^           */
#ifdef GL_STANDARD_FONT_NAME_NV
      *iv_return = (IV)GL_STANDARD_FONT_NAME_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'N':
    if (memEQ(name, "GL_COMPRESSED_SLUMINANCE", 24)) {
    /*                                  ^           */
#ifdef GL_COMPRESSED_SLUMINANCE
      *iv_return = (IV)GL_COMPRESSED_SLUMINANCE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FRONT_FACE_COMMAND_NV", 24)) {
    /*                                  ^           */
#ifdef GL_FRONT_FACE_COMMAND_NV
      *iv_return = (IV)GL_FRONT_FACE_COMMAND_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LINE_WIDTH_COMMAND_NV", 24)) {
    /*                                  ^           */
#ifdef GL_LINE_WIDTH_COMMAND_NV
      *iv_return = (IV)GL_LINE_WIDTH_COMMAND_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PATH_COMMAND_COUNT_NV", 24)) {
    /*                                  ^           */
#ifdef GL_PATH_COMMAND_COUNT_NV
      *iv_return = (IV)GL_PATH_COMMAND_COUNT_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNIFORM_BLOCK_BINDING", 24)) {
    /*                                  ^           */
#ifdef GL_UNIFORM_BLOCK_BINDING
      *iv_return = (IV)GL_UNIFORM_BLOCK_BINDING;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERTEX_ATTRIB_BINDING", 24)) {
    /*                                  ^           */
#ifdef GL_VERTEX_ATTRIB_BINDING
      *iv_return = (IV)GL_VERTEX_ATTRIB_BINDING;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'O':
    if (memEQ(name, "GL_BACK_PRIMARY_COLOR_NV", 24)) {
    /*                                  ^           */
#ifdef GL_BACK_PRIMARY_COLOR_NV
      *iv_return = (IV)GL_BACK_PRIMARY_COLOR_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FOG_COORDINATE_SOURCE", 24)) {
    /*                                  ^           */
#ifdef GL_FOG_COORDINATE_SOURCE
      *iv_return = (IV)GL_FOG_COORDINATE_SOURCE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TESS_GEN_VERTEX_ORDER", 24)) {
    /*                                  ^           */
#ifdef GL_TESS_GEN_VERTEX_ORDER
      *iv_return = (IV)GL_TESS_GEN_VERTEX_ORDER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_BUFFER_FORMAT", 24)) {
    /*                                  ^           */
#ifdef GL_TEXTURE_BUFFER_FORMAT
      *iv_return = (IV)GL_TEXTURE_BUFFER_FORMAT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'P':
    if (memEQ(name, "GL_SKIP_MISSING_GLYPH_NV", 24)) {
    /*                                  ^           */
#ifdef GL_SKIP_MISSING_GLYPH_NV
      *iv_return = (IV)GL_SKIP_MISSING_GLYPH_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'R':
    if (memEQ(name, "GLEW_ERROR_NO_GL_VERSION", 24)) {
    /*                                  ^           */
#ifdef GLEW_ERROR_NO_GL_VERSION
      *iv_return = (IV)GLEW_ERROR_NO_GL_VERSION;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LOSE_CONTEXT_ON_RESET", 24)) {
    /*                                  ^           */
#ifdef GL_LOSE_CONTEXT_ON_RESET
      *iv_return = (IV)GL_LOSE_CONTEXT_ON_RESET;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LUMINANCE_INTEGER_EXT", 24)) {
    /*                                  ^           */
#ifdef GL_LUMINANCE_INTEGER_EXT
      *iv_return = (IV)GL_LUMINANCE_INTEGER_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PIXEL_PACK_BUFFER_ARB", 24)) {
    /*                                  ^           */
#ifdef GL_PIXEL_PACK_BUFFER_ARB
      *iv_return = (IV)GL_PIXEL_PACK_BUFFER_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PIXEL_PACK_BUFFER_EXT", 24)) {
    /*                                  ^           */
#ifdef GL_PIXEL_PACK_BUFFER_EXT
      *iv_return = (IV)GL_PIXEL_PACK_BUFFER_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RASTERIZER_DISCARD_NV", 24)) {
    /*                                  ^           */
#ifdef GL_RASTERIZER_DISCARD_NV
      *iv_return = (IV)GL_RASTERIZER_DISCARD_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_REGISTER_COMBINERS_NV", 24)) {
    /*                                  ^           */
#ifdef GL_REGISTER_COMBINERS_NV
      *iv_return = (IV)GL_REGISTER_COMBINERS_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SHADER_BINARY_FORMATS", 24)) {
    /*                                  ^           */
#ifdef GL_SHADER_BINARY_FORMATS
      *iv_return = (IV)GL_SHADER_BINARY_FORMATS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_SWIZZLE_R_EXT", 24)) {
    /*                                  ^           */
#ifdef GL_TEXTURE_SWIZZLE_R_EXT
      *iv_return = (IV)GL_TEXTURE_SWIZZLE_R_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNKNOWN_CONTEXT_RESET", 24)) {
    /*                                  ^           */
#ifdef GL_UNKNOWN_CONTEXT_RESET
      *iv_return = (IV)GL_UNKNOWN_CONTEXT_RESET;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VIEWPORT_BOUNDS_RANGE", 24)) {
    /*                                  ^           */
#ifdef GL_VIEWPORT_BOUNDS_RANGE
      *iv_return = (IV)GL_VIEWPORT_BOUNDS_RANGE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'S':
    if (memEQ(name, "GL_BUFFER_GPU_ADDRESS_NV", 24)) {
    /*                                  ^           */
#ifdef GL_BUFFER_GPU_ADDRESS_NV
      *iv_return = (IV)GL_BUFFER_GPU_ADDRESS_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COMPLETION_STATUS_ARB", 24)) {
    /*                                  ^           */
#ifdef GL_COMPLETION_STATUS_ARB
      *iv_return = (IV)GL_COMPLETION_STATUS_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEBUG_LOGGED_MESSAGES", 24)) {
    /*                                  ^           */
#ifdef GL_DEBUG_LOGGED_MESSAGES
      *iv_return = (IV)GL_DEBUG_LOGGED_MESSAGES;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_GEOMETRY_VERTICES_OUT", 24)) {
    /*                                  ^           */
#ifdef GL_GEOMETRY_VERTICES_OUT
      *iv_return = (IV)GL_GEOMETRY_VERTICES_OUT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LUMINANCE_ALPHA_SNORM", 24)) {
    /*                                  ^           */
#ifdef GL_LUMINANCE_ALPHA_SNORM
      *iv_return = (IV)GL_LUMINANCE_ALPHA_SNORM;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_ACTIVE_LIGHTS_EXT", 24)) {
    /*                                  ^           */
#ifdef GL_MAX_ACTIVE_LIGHTS_EXT
      *iv_return = (IV)GL_MAX_ACTIVE_LIGHTS_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_IMAGE_SAMPLES_EXT", 24)) {
    /*                                  ^           */
#ifdef GL_MAX_IMAGE_SAMPLES_EXT
      *iv_return = (IV)GL_MAX_IMAGE_SAMPLES_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_TEXTURE_UNITS_ARB", 24)) {
    /*                                  ^           */
#ifdef GL_MAX_TEXTURE_UNITS_ARB
      *iv_return = (IV)GL_MAX_TEXTURE_UNITS_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NUM_SPARSE_LEVELS_ARB", 24)) {
    /*                                  ^           */
#ifdef GL_NUM_SPARSE_LEVELS_ARB
      *iv_return = (IV)GL_NUM_SPARSE_LEVELS_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'T':
    if (memEQ(name, "GL_BACK_NORMALS_HINT_PGI", 24)) {
    /*                                  ^           */
#ifdef GL_BACK_NORMALS_HINT_PGI
      *iv_return = (IV)GL_BACK_NORMALS_HINT_PGI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CIRCULAR_CW_ARC_TO_NV", 24)) {
    /*                                  ^           */
#ifdef GL_CIRCULAR_CW_ARC_TO_NV
      *iv_return = (IV)GL_CIRCULAR_CW_ARC_TO_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_ARRAY_COUNT_EXT", 24)) {
    /*                                  ^           */
#ifdef GL_COLOR_ARRAY_COUNT_EXT
      *iv_return = (IV)GL_COLOR_ARRAY_COUNT_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_ARRAY_LENGTH_NV", 24)) {
    /*                                  ^           */
#ifdef GL_COLOR_ARRAY_LENGTH_NV
      *iv_return = (IV)GL_COLOR_ARRAY_LENGTH_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CURRENT_VERTEX_ATTRIB", 24)) {
    /*                                  ^           */
#ifdef GL_CURRENT_VERTEX_ATTRIB
      *iv_return = (IV)GL_CURRENT_VERTEX_ATTRIB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEPTH_BOUNDS_TEST_EXT", 24)) {
    /*                                  ^           */
#ifdef GL_DEPTH_BOUNDS_TEST_EXT
      *iv_return = (IV)GL_DEPTH_BOUNDS_TEST_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DSDT_MAG_INTENSITY_NV", 24)) {
    /*                                  ^           */
#ifdef GL_DSDT_MAG_INTENSITY_NV
      *iv_return = (IV)GL_DSDT_MAG_INTENSITY_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EYE_PLANE_ABSOLUTE_NV", 24)) {
    /*                                  ^           */
#ifdef GL_EYE_PLANE_ABSOLUTE_NV
      *iv_return = (IV)GL_EYE_PLANE_ABSOLUTE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FULL_STIPPLE_HINT_PGI", 24)) {
    /*                                  ^           */
#ifdef GL_FULL_STIPPLE_HINT_PGI
      *iv_return = (IV)GL_FULL_STIPPLE_HINT_PGI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FUNC_REVERSE_SUBTRACT", 24)) {
    /*                                  ^           */
#ifdef GL_FUNC_REVERSE_SUBTRACT
      *iv_return = (IV)GL_FUNC_REVERSE_SUBTRACT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_HORIZONTAL_LINE_TO_NV", 24)) {
    /*                                  ^           */
#ifdef GL_HORIZONTAL_LINE_TO_NV
      *iv_return = (IV)GL_HORIZONTAL_LINE_TO_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INDEX_ARRAY_COUNT_EXT", 24)) {
    /*                                  ^           */
#ifdef GL_INDEX_ARRAY_COUNT_EXT
      *iv_return = (IV)GL_INDEX_ARRAY_COUNT_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INDEX_ARRAY_LENGTH_NV", 24)) {
    /*                                  ^           */
#ifdef GL_INDEX_ARRAY_LENGTH_NV
      *iv_return = (IV)GL_INDEX_ARRAY_LENGTH_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INT_IMAGE_2D_RECT_EXT", 24)) {
    /*                                  ^           */
#ifdef GL_INT_IMAGE_2D_RECT_EXT
      *iv_return = (IV)GL_INT_IMAGE_2D_RECT_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAT_SHININESS_BIT_PGI", 24)) {
    /*                                  ^           */
#ifdef GL_MAT_SHININESS_BIT_PGI
      *iv_return = (IV)GL_MAT_SHININESS_BIT_PGI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_ELEMENTS_VERTICES", 24)) {
    /*                                  ^           */
#ifdef GL_MAX_ELEMENTS_VERTICES
      *iv_return = (IV)GL_MAX_ELEMENTS_VERTICES;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_UNIFORM_LOCATIONS", 24)) {
    /*                                  ^           */
#ifdef GL_MAX_UNIFORM_LOCATIONS
      *iv_return = (IV)GL_MAX_UNIFORM_LOCATIONS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MODULATE_SUBTRACT_ATI", 24)) {
    /*                                  ^           */
#ifdef GL_MODULATE_SUBTRACT_ATI
      *iv_return = (IV)GL_MODULATE_SUBTRACT_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NORMAL_ARRAY_LIST_IBM", 24)) {
    /*                                  ^           */
#ifdef GL_NORMAL_ARRAY_LIST_IBM
      *iv_return = (IV)GL_NORMAL_ARRAY_LIST_IBM;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PACK_IMAGE_HEIGHT_EXT", 24)) {
    /*                                  ^           */
#ifdef GL_PACK_IMAGE_HEIGHT_EXT
      *iv_return = (IV)GL_PACK_IMAGE_HEIGHT_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PATH_CLIENT_LENGTH_NV", 24)) {
    /*                                  ^           */
#ifdef GL_PATH_CLIENT_LENGTH_NV
      *iv_return = (IV)GL_PATH_CLIENT_LENGTH_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PIXEL_COUNTER_BITS_NV", 24)) {
    /*                                  ^           */
#ifdef GL_PIXEL_COUNTER_BITS_NV
      *iv_return = (IV)GL_PIXEL_COUNTER_BITS_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_QUADRATIC_CURVE_TO_NV", 24)) {
    /*                                  ^           */
#ifdef GL_QUADRATIC_CURVE_TO_NV
      *iv_return = (IV)GL_QUADRATIC_CURVE_TO_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNIFORM_MATRIX_STRIDE", 24)) {
    /*                                  ^           */
#ifdef GL_UNIFORM_MATRIX_STRIDE
      *iv_return = (IV)GL_UNIFORM_MATRIX_STRIDE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERTEX_ARRAY_LIST_IBM", 24)) {
    /*                                  ^           */
#ifdef GL_VERTEX_ARRAY_LIST_IBM
      *iv_return = (IV)GL_VERTEX_ARRAY_LIST_IBM;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERTEX_BINDING_STRIDE", 24)) {
    /*                                  ^           */
#ifdef GL_VERTEX_BINDING_STRIDE
      *iv_return = (IV)GL_VERTEX_BINDING_STRIDE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'U':
    if (memEQ(name, "GL_ATOMIC_COUNTER_BUFFER", 24)) {
    /*                                  ^           */
#ifdef GL_ATOMIC_COUNTER_BUFFER
      *iv_return = (IV)GL_ATOMIC_COUNTER_BUFFER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COMBINER_AB_OUTPUT_NV", 24)) {
    /*                                  ^           */
#ifdef GL_COMBINER_AB_OUTPUT_NV
      *iv_return = (IV)GL_COMBINER_AB_OUTPUT_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COMBINER_CD_OUTPUT_NV", 24)) {
    /*                                  ^           */
#ifdef GL_COMBINER_CD_OUTPUT_NV
      *iv_return = (IV)GL_COMBINER_CD_OUTPUT_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SHADER_STORAGE_BUFFER", 24)) {
    /*                                  ^           */
#ifdef GL_SHADER_STORAGE_BUFFER
      *iv_return = (IV)GL_SHADER_STORAGE_BUFFER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERTEX_BINDING_BUFFER", 24)) {
    /*                                  ^           */
#ifdef GL_VERTEX_BINDING_BUFFER
      *iv_return = (IV)GL_VERTEX_BINDING_BUFFER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VIEW_CLASS_BPTC_UNORM", 24)) {
    /*                                  ^           */
#ifdef GL_VIEW_CLASS_BPTC_UNORM
      *iv_return = (IV)GL_VIEW_CLASS_BPTC_UNORM;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'V':
    if (memEQ(name, "GL_SAMPLE_COVERAGE_VALUE", 24)) {
    /*                                  ^           */
#ifdef GL_SAMPLE_COVERAGE_VALUE
      *iv_return = (IV)GL_SAMPLE_COVERAGE_VALUE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'W':
    if (memEQ(name, "GL_MAX_CONVOLUTION_WIDTH", 24)) {
    /*                                  ^           */
#ifdef GL_MAX_CONVOLUTION_WIDTH
      *iv_return = (IV)GL_MAX_CONVOLUTION_WIDTH;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_FRAMEBUFFER_WIDTH", 24)) {
    /*                                  ^           */
#ifdef GL_MAX_FRAMEBUFFER_WIDTH
      *iv_return = (IV)GL_MAX_FRAMEBUFFER_WIDTH;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_SAMPLE_MASK_WORDS", 24)) {
    /*                                  ^           */
#ifdef GL_MAX_SAMPLE_MASK_WORDS
      *iv_return = (IV)GL_MAX_SAMPLE_MASK_WORDS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLER_1D_SHADOW_ARB", 24)) {
    /*                                  ^           */
#ifdef GL_SAMPLER_1D_SHADOW_ARB
      *iv_return = (IV)GL_SAMPLER_1D_SHADOW_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLER_2D_SHADOW_ARB", 24)) {
    /*                                  ^           */
#ifdef GL_SAMPLER_2D_SHADOW_ARB
      *iv_return = (IV)GL_SAMPLER_2D_SHADOW_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'X':
    if (memEQ(name, "GL_CLIENT_ACTIVE_TEXTURE", 24)) {
    /*                                  ^           */
#ifdef GL_CLIENT_ACTIVE_TEXTURE
      *iv_return = (IV)GL_CLIENT_ACTIVE_TEXTURE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MODELVIEW0_MATRIX_EXT", 24)) {
    /*                                  ^           */
#ifdef GL_MODELVIEW0_MATRIX_EXT
      *iv_return = (IV)GL_MODELVIEW0_MATRIX_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MODELVIEW1_MATRIX_EXT", 24)) {
    /*                                  ^           */
#ifdef GL_MODELVIEW1_MATRIX_EXT
      *iv_return = (IV)GL_MODELVIEW1_MATRIX_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'Y':
    if (memEQ(name, "GL_IMAGE_BINDING_LAYERED", 24)) {
    /*                                  ^           */
#ifdef GL_IMAGE_BINDING_LAYERED
      *iv_return = (IV)GL_IMAGE_BINDING_LAYERED;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '_':
    if (memEQ(name, "GLEW_ARB_gpu_shader_fp64", 24)) {
    /*                                  ^           */
#ifdef GLEW_ARB_gpu_shader_fp64
      *iv_return = (IV)GLEW_ARB_gpu_shader_fp64;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_INGR_interlace_read", 24)) {
    /*                                  ^           */
#ifdef GLEW_INGR_interlace_read
      *iv_return = (IV)GLEW_INGR_interlace_read;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_NVX_gpu_memory_info", 24)) {
    /*                                  ^           */
#ifdef GLEW_NVX_gpu_memory_info
      *iv_return = (IV)GLEW_NVX_gpu_memory_info;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_NV_gpu_program_fp64", 24)) {
    /*                                  ^           */
#ifdef GLEW_NV_gpu_program_fp64
      *iv_return = (IV)GLEW_NV_gpu_program_fp64;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_shader_group_vote", 24)) {
    /*                                  ^           */
#ifdef GL_ARB_shader_group_vote
      *iv_return = (IV)GL_ARB_shader_group_vote;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_shader_image_size", 24)) {
    /*                                  ^           */
#ifdef GL_ARB_shader_image_size
      *iv_return = (IV)GL_ARB_shader_image_size;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_vertex_array_bgra", 24)) {
    /*                                  ^           */
#ifdef GL_ARB_vertex_array_bgra
      *iv_return = (IV)GL_ARB_vertex_array_bgra;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_TABLE_BLUE_SIZE", 24)) {
    /*                                  ^           */
#ifdef GL_COLOR_TABLE_BLUE_SIZE
      *iv_return = (IV)GL_COLOR_TABLE_BLUE_SIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COMPRESSED_SRGB8_ETC2", 24)) {
    /*                                  ^           */
#ifdef GL_COMPRESSED_SRGB8_ETC2
      *iv_return = (IV)GL_COMPRESSED_SRGB8_ETC2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CONVOLUTION_HINT_SGIX", 24)) {
    /*                                  ^           */
#ifdef GL_CONVOLUTION_HINT_SGIX
      *iv_return = (IV)GL_CONVOLUTION_HINT_SGIX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_depth_bounds_test", 24)) {
    /*                                  ^           */
#ifdef GL_EXT_depth_bounds_test
      *iv_return = (IV)GL_EXT_depth_bounds_test;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_vertex_array_bgra", 24)) {
    /*                                  ^           */
#ifdef GL_EXT_vertex_array_bgra
      *iv_return = (IV)GL_EXT_vertex_array_bgra;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FOG_OFFSET_VALUE_SGIX", 24)) {
    /*                                  ^           */
#ifdef GL_FOG_OFFSET_VALUE_SGIX
      *iv_return = (IV)GL_FOG_OFFSET_VALUE_SGIX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INTENSITY_SIGNED_SGIX", 24)) {
    /*                                  ^           */
#ifdef GL_INTENSITY_SIGNED_SGIX
      *iv_return = (IV)GL_INTENSITY_SIGNED_SGIX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LUMINANCE_SIGNED_SGIX", 24)) {
    /*                                  ^           */
#ifdef GL_LUMINANCE_SIGNED_SGIX
      *iv_return = (IV)GL_LUMINANCE_SIGNED_SGIX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_RENDERBUFFER_SIZE", 24)) {
    /*                                  ^           */
#ifdef GL_MAX_RENDERBUFFER_SIZE
      *iv_return = (IV)GL_MAX_RENDERBUFFER_SIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_shader_buffer_load", 24)) {
    /*                                  ^           */
#ifdef GL_NV_shader_buffer_load
      *iv_return = (IV)GL_NV_shader_buffer_load;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PIXEL_MAP_A_TO_A_SIZE", 24)) {
    /*                                  ^           */
#ifdef GL_PIXEL_MAP_A_TO_A_SIZE
      *iv_return = (IV)GL_PIXEL_MAP_A_TO_A_SIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PIXEL_MAP_B_TO_B_SIZE", 24)) {
    /*                                  ^           */
#ifdef GL_PIXEL_MAP_B_TO_B_SIZE
      *iv_return = (IV)GL_PIXEL_MAP_B_TO_B_SIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PIXEL_MAP_G_TO_G_SIZE", 24)) {
    /*                                  ^           */
#ifdef GL_PIXEL_MAP_G_TO_G_SIZE
      *iv_return = (IV)GL_PIXEL_MAP_G_TO_G_SIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PIXEL_MAP_I_TO_A_SIZE", 24)) {
    /*                                  ^           */
#ifdef GL_PIXEL_MAP_I_TO_A_SIZE
      *iv_return = (IV)GL_PIXEL_MAP_I_TO_A_SIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PIXEL_MAP_I_TO_B_SIZE", 24)) {
    /*                                  ^           */
#ifdef GL_PIXEL_MAP_I_TO_B_SIZE
      *iv_return = (IV)GL_PIXEL_MAP_I_TO_B_SIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PIXEL_MAP_I_TO_G_SIZE", 24)) {
    /*                                  ^           */
#ifdef GL_PIXEL_MAP_I_TO_G_SIZE
      *iv_return = (IV)GL_PIXEL_MAP_I_TO_G_SIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PIXEL_MAP_I_TO_I_SIZE", 24)) {
    /*                                  ^           */
#ifdef GL_PIXEL_MAP_I_TO_I_SIZE
      *iv_return = (IV)GL_PIXEL_MAP_I_TO_I_SIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PIXEL_MAP_I_TO_R_SIZE", 24)) {
    /*                                  ^           */
#ifdef GL_PIXEL_MAP_I_TO_R_SIZE
      *iv_return = (IV)GL_PIXEL_MAP_I_TO_R_SIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PIXEL_MAP_R_TO_R_SIZE", 24)) {
    /*                                  ^           */
#ifdef GL_PIXEL_MAP_R_TO_R_SIZE
      *iv_return = (IV)GL_PIXEL_MAP_R_TO_R_SIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PIXEL_MAP_S_TO_S_SIZE", 24)) {
    /*                                  ^           */
#ifdef GL_PIXEL_MAP_S_TO_S_SIZE
      *iv_return = (IV)GL_PIXEL_MAP_S_TO_S_SIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RENDERBUFFER_RED_SIZE", 24)) {
    /*                                  ^           */
#ifdef GL_RENDERBUFFER_RED_SIZE
      *iv_return = (IV)GL_RENDERBUFFER_RED_SIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SELECTION_BUFFER_SIZE", 24)) {
    /*                                  ^           */
#ifdef GL_SELECTION_BUFFER_SIZE
      *iv_return = (IV)GL_SELECTION_BUFFER_SIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SGIX_texture_lod_bias", 24)) {
    /*                                  ^           */
#ifdef GL_SGIX_texture_lod_bias
      *iv_return = (IV)GL_SGIX_texture_lod_bias;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_GEQUAL_R_SGIX", 24)) {
    /*                                  ^           */
#ifdef GL_TEXTURE_GEQUAL_R_SGIX
      *iv_return = (IV)GL_TEXTURE_GEQUAL_R_SGIX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_LEQUAL_R_SGIX", 24)) {
    /*                                  ^           */
#ifdef GL_TEXTURE_LEQUAL_R_SGIX
      *iv_return = (IV)GL_TEXTURE_LEQUAL_R_SGIX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VIEWPORT_SWIZZLE_W_NV", 24)) {
    /*                                  ^           */
#ifdef GL_VIEWPORT_SWIZZLE_W_NV
      *iv_return = (IV)GL_VIEWPORT_SWIZZLE_W_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VIEWPORT_SWIZZLE_X_NV", 24)) {
    /*                                  ^           */
#ifdef GL_VIEWPORT_SWIZZLE_X_NV
      *iv_return = (IV)GL_VIEWPORT_SWIZZLE_X_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VIEWPORT_SWIZZLE_Y_NV", 24)) {
    /*                                  ^           */
#ifdef GL_VIEWPORT_SWIZZLE_Y_NV
      *iv_return = (IV)GL_VIEWPORT_SWIZZLE_Y_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VIEWPORT_SWIZZLE_Z_NV", 24)) {
    /*                                  ^           */
#ifdef GL_VIEWPORT_SWIZZLE_Z_NV
      *iv_return = (IV)GL_VIEWPORT_SWIZZLE_Z_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'a':
    if (memEQ(name, "GLEW_APPLE_element_array", 24)) {
    /*                                  ^           */
#ifdef GLEW_APPLE_element_array
      *iv_return = (IV)GLEW_APPLE_element_array;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_NV_geometry_shader4", 24)) {
    /*                                  ^           */
#ifdef GLEW_NV_geometry_shader4
      *iv_return = (IV)GLEW_NV_geometry_shader4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_texture_rectangle", 24)) {
    /*                                  ^           */
#ifdef GL_ARB_texture_rectangle
      *iv_return = (IV)GL_ARB_texture_rectangle;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_texture_rectangle", 24)) {
    /*                                  ^           */
#ifdef GL_EXT_texture_rectangle
      *iv_return = (IV)GL_EXT_texture_rectangle;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_GREMEDY_string_marker", 24)) {
    /*                                  ^           */
#ifdef GL_GREMEDY_string_marker
      *iv_return = (IV)GL_GREMEDY_string_marker;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'b':
    if (memEQ(name, "GLEW_EXT_x11_sync_object", 24)) {
    /*                                  ^           */
#ifdef GLEW_EXT_x11_sync_object
      *iv_return = (IV)GLEW_EXT_x11_sync_object;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_SGIX_shadow_ambient", 24)) {
    /*                                  ^           */
#ifdef GLEW_SGIX_shadow_ambient
      *iv_return = (IV)GLEW_SGIX_shadow_ambient;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'c':
    if (memEQ(name, "GLEW_EXT_secondary_color", 24)) {
    /*                                  ^           */
#ifdef GLEW_EXT_secondary_color
      *iv_return = (IV)GLEW_EXT_secondary_color;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'd':
    if (memEQ(name, "GL_NV_transform_feedback", 24)) {
    /*                                  ^           */
#ifdef GL_NV_transform_feedback
      *iv_return = (IV)GL_NV_transform_feedback;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'e':
    if (memEQ(name, "GLEW_AMD_name_gen_delete", 24)) {
    /*                                  ^           */
#ifdef GLEW_AMD_name_gen_delete
      *iv_return = (IV)GLEW_AMD_name_gen_delete;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_SGIS_texture_select", 24)) {
    /*                                  ^           */
#ifdef GLEW_SGIS_texture_select
      *iv_return = (IV)GLEW_SGIS_texture_select;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_SGIX_vertex_preclip", 24)) {
    /*                                  ^           */
#ifdef GLEW_SGIX_vertex_preclip
      *iv_return = (IV)GLEW_SGIX_vertex_preclip;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_APPLE_specular_vector", 24)) {
    /*                                  ^           */
#ifdef GL_APPLE_specular_vector
      *iv_return = (IV)GL_APPLE_specular_vector;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_half_float_vertex", 24)) {
    /*                                  ^           */
#ifdef GL_ARB_half_float_vertex
      *iv_return = (IV)GL_ARB_half_float_vertex;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_seamless_cube_map", 24)) {
    /*                                  ^           */
#ifdef GL_ARB_seamless_cube_map
      *iv_return = (IV)GL_ARB_seamless_cube_map;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_conditional_render", 24)) {
    /*                                  ^           */
#ifdef GL_NV_conditional_render
      *iv_return = (IV)GL_NV_conditional_render;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'f':
    if (memEQ(name, "GLEW_MESA_resize_buffers", 24)) {
    /*                                  ^           */
#ifdef GLEW_MESA_resize_buffers
      *iv_return = (IV)GLEW_MESA_resize_buffers;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_depth_buffer_float", 24)) {
    /*                                  ^           */
#ifdef GL_NV_depth_buffer_float
      *iv_return = (IV)GL_NV_depth_buffer_float;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'g':
    if (memEQ(name, "GLEW_NV_compute_program5", 24)) {
    /*                                  ^           */
#ifdef GLEW_NV_compute_program5
      *iv_return = (IV)GLEW_NV_compute_program5;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'h':
    if (memEQ(name, "GLEW_ARB_fragment_shader", 24)) {
    /*                                  ^           */
#ifdef GLEW_ARB_fragment_shader
      *iv_return = (IV)GLEW_ARB_fragment_shader;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_ATI_fragment_shader", 24)) {
    /*                                  ^           */
#ifdef GLEW_ATI_fragment_shader
      *iv_return = (IV)GLEW_ATI_fragment_shader;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_HP_texture_lighting", 24)) {
    /*                                  ^           */
#ifdef GLEW_HP_texture_lighting
      *iv_return = (IV)GLEW_HP_texture_lighting;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_fragment_lighting", 24)) {
    /*                                  ^           */
#ifdef GL_EXT_fragment_lighting
      *iv_return = (IV)GL_EXT_fragment_lighting;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'i':
    if (memEQ(name, "GLEW_ARB_texture_swizzle", 24)) {
    /*                                  ^           */
#ifdef GLEW_ARB_texture_swizzle
      *iv_return = (IV)GLEW_ARB_texture_swizzle;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_EXT_texture_swizzle", 24)) {
    /*                                  ^           */
#ifdef GLEW_EXT_texture_swizzle
      *iv_return = (IV)GLEW_EXT_texture_swizzle;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_NV_viewport_swizzle", 24)) {
    /*                                  ^           */
#ifdef GLEW_NV_viewport_swizzle
      *iv_return = (IV)GLEW_NV_viewport_swizzle;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_ES2_compatibility", 24)) {
    /*                                  ^           */
#ifdef GL_ARB_ES2_compatibility
      *iv_return = (IV)GL_ARB_ES2_compatibility;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_ES3_compatibility", 24)) {
    /*                                  ^           */
#ifdef GL_ARB_ES3_compatibility
      *iv_return = (IV)GL_ARB_ES3_compatibility;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INTEL_texture_scissor", 24)) {
    /*                                  ^           */
#ifdef GL_INTEL_texture_scissor
      *iv_return = (IV)GL_INTEL_texture_scissor;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_register_combiners", 24)) {
    /*                                  ^           */
#ifdef GL_NV_register_combiners
      *iv_return = (IV)GL_NV_register_combiners;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SUN_read_video_pixels", 24)) {
    /*                                  ^           */
#ifdef GL_SUN_read_video_pixels
      *iv_return = (IV)GL_SUN_read_video_pixels;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'j':
    if (memEQ(name, "GLEW_ARB_sampler_objects", 24)) {
    /*                                  ^           */
#ifdef GLEW_ARB_sampler_objects
      *iv_return = (IV)GLEW_ARB_sampler_objects;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'm':
    if (memEQ(name, "GLEW_SGIX_ir_instrument1", 24)) {
    /*                                  ^           */
#ifdef GLEW_SGIX_ir_instrument1
      *iv_return = (IV)GLEW_SGIX_ir_instrument1;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'n':
    if (memEQ(name, "GL_EXT_window_rectangles", 24)) {
    /*                                  ^           */
#ifdef GL_EXT_window_rectangles
      *iv_return = (IV)GL_EXT_window_rectangles;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'o':
    if (memEQ(name, "GLEW_ARB_texture_storage", 24)) {
    /*                                  ^           */
#ifdef GLEW_ARB_texture_storage
      *iv_return = (IV)GLEW_ARB_texture_storage;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_NV_fragment_program", 24)) {
    /*                                  ^           */
#ifdef GLEW_NV_fragment_program
      *iv_return = (IV)GLEW_NV_fragment_program;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_light_max_exponent", 24)) {
    /*                                  ^           */
#ifdef GL_NV_light_max_exponent
      *iv_return = (IV)GL_NV_light_max_exponent;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'q':
    if (memEQ(name, "GLEW_ARB_occlusion_query", 24)) {
    /*                                  ^           */
#ifdef GLEW_ARB_occlusion_query
      *iv_return = (IV)GLEW_ARB_occlusion_query;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_REGAL_extension_query", 24)) {
    /*                                  ^           */
#ifdef GL_REGAL_extension_query
      *iv_return = (IV)GL_REGAL_extension_query;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'r':
    if (memEQ(name, "GLEW_APPLE_texture_range", 24)) {
    /*                                  ^           */
#ifdef GLEW_APPLE_texture_range
      *iv_return = (IV)GLEW_APPLE_texture_range;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_ARB_texture_barrier", 24)) {
    /*                                  ^           */
#ifdef GLEW_ARB_texture_barrier
      *iv_return = (IV)GLEW_ARB_texture_barrier;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_NV_pixel_data_range", 24)) {
    /*                                  ^           */
#ifdef GLEW_NV_pixel_data_range
      *iv_return = (IV)GLEW_NV_pixel_data_range;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_multi_draw_arrays", 24)) {
    /*                                  ^           */
#ifdef GL_EXT_multi_draw_arrays
      *iv_return = (IV)GL_EXT_multi_draw_arrays;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_stencil_clear_tag", 24)) {
    /*                                  ^           */
#ifdef GL_EXT_stencil_clear_tag
      *iv_return = (IV)GL_EXT_stencil_clear_tag;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INTEL_parallel_arrays", 24)) {
    /*                                  ^           */
#ifdef GL_INTEL_parallel_arrays
      *iv_return = (IV)GL_INTEL_parallel_arrays;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_vertex_array_range", 24)) {
    /*                                  ^           */
#ifdef GL_NV_vertex_array_range
      *iv_return = (IV)GL_NV_vertex_array_range;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 's':
    if (memEQ(name, "GLEW_EXT_pixel_transform", 24)) {
    /*                                  ^           */
#ifdef GLEW_EXT_pixel_transform
      *iv_return = (IV)GLEW_EXT_pixel_transform;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_MESAX_texture_stack", 24)) {
    /*                                  ^           */
#ifdef GLEW_MESAX_texture_stack
      *iv_return = (IV)GLEW_MESAX_texture_stack;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 't':
    if (memEQ(name, "GLEW_ARB_sparse_texture2", 24)) {
    /*                                  ^           */
#ifdef GLEW_ARB_sparse_texture2
      *iv_return = (IV)GLEW_ARB_sparse_texture2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_EXT_sparse_texture2", 24)) {
    /*                                  ^           */
#ifdef GLEW_EXT_sparse_texture2
      *iv_return = (IV)GLEW_EXT_sparse_texture2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_EXT_texture_integer", 24)) {
    /*                                  ^           */
#ifdef GLEW_EXT_texture_integer
      *iv_return = (IV)GLEW_EXT_texture_integer;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_NV_sample_locations", 24)) {
    /*                                  ^           */
#ifdef GLEW_NV_sample_locations
      *iv_return = (IV)GLEW_NV_sample_locations;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'u':
    if (memEQ(name, "GLEW_ANGLE_texture_usage", 24)) {
    /*                                  ^           */
#ifdef GLEW_ANGLE_texture_usage
      *iv_return = (IV)GLEW_ANGLE_texture_usage;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_shader_subroutine", 24)) {
    /*                                  ^           */
#ifdef GL_ARB_shader_subroutine
      *iv_return = (IV)GL_ARB_shader_subroutine;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_stencil_texturing", 24)) {
    /*                                  ^           */
#ifdef GL_ARB_stencil_texturing
      *iv_return = (IV)GL_ARB_stencil_texturing;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ATI_map_object_buffer", 24)) {
    /*                                  ^           */
#ifdef GL_ATI_map_object_buffer
      *iv_return = (IV)GL_ATI_map_object_buffer;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'v':
    if (memEQ(name, "GLEW_ARB_texture_env_add", 24)) {
    /*                                  ^           */
#ifdef GLEW_ARB_texture_env_add
      *iv_return = (IV)GLEW_ARB_texture_env_add;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_EXT_texture_env_add", 24)) {
    /*                                  ^           */
#ifdef GLEW_EXT_texture_env_add
      *iv_return = (IV)GLEW_EXT_texture_env_add;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'x':
    if (memEQ(name, "GLEW_ANGLE_depth_texture", 24)) {
    /*                                  ^           */
#ifdef GLEW_ANGLE_depth_texture
      *iv_return = (IV)GLEW_ANGLE_depth_texture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_NV_bindless_texture", 24)) {
    /*                                  ^           */
#ifdef GLEW_NV_bindless_texture
      *iv_return = (IV)GLEW_NV_bindless_texture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_SGIS_detail_texture", 24)) {
    /*                                  ^           */
#ifdef GLEW_SGIS_detail_texture
      *iv_return = (IV)GLEW_SGIS_detail_texture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'y':
    if (memEQ(name, "GL_ARB_texture_query_lod", 24)) {
    /*                                  ^           */
#ifdef GL_ARB_texture_query_lod
      *iv_return = (IV)GL_ARB_texture_query_lod;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  }
  return PERL_constant_NOTFOUND;
}

static int
constant_25 (pTHX_ const char *name, IV *iv_return) {
  /* When generated this function returned values for the list of names given
     here.  However, subsequent manual editing may have added or removed some.
     GLEW_AMD_gpu_shader_int64 GLEW_AMD_sample_positions
     GLEW_AMD_texture_texture4 GLEW_ANGLE_program_binary
     GLEW_APPLE_client_storage GLEW_APPLE_transform_hint
     GLEW_ARB_arrays_of_arrays GLEW_ARB_bindless_texture
     GLEW_ARB_enhanced_layouts GLEW_ARB_fragment_program
     GLEW_ARB_framebuffer_sRGB GLEW_ARB_geometry_shader4
     GLEW_ARB_gpu_shader_int64 GLEW_ARB_half_float_pixel
     GLEW_ARB_instanced_arrays GLEW_ARB_map_buffer_range
     GLEW_ARB_occlusion_query2 GLEW_ARB_point_parameters
     GLEW_ARB_provoking_vertex GLEW_ARB_sample_locations
     GLEW_ARB_shader_precision GLEW_ARB_texture_cube_map
     GLEW_ARB_texture_env_dot3 GLEW_ARB_texture_stencil8
     GLEW_ARB_transpose_matrix GLEW_ATI_separate_stencil
     GLEW_EXT_bindable_uniform GLEW_EXT_clip_volume_hint
     GLEW_EXT_coordinate_frame GLEW_EXT_framebuffer_blit
     GLEW_EXT_framebuffer_sRGB GLEW_EXT_geometry_shader4
     GLEW_EXT_paletted_texture GLEW_EXT_point_parameters
     GLEW_EXT_provoking_vertex GLEW_EXT_stencil_two_side
     GLEW_EXT_texture_cube_map GLEW_EXT_texture_env_dot3
     GLEW_EXT_texture_lod_bias GLEW_EXT_vertex_weighting
     GLEW_NV_draw_vulkan_image GLEW_NV_fragment_program2
     GLEW_NV_fragment_program4 GLEW_NV_geometry_program4
     GLEW_NV_primitive_restart GLEW_NV_texgen_reflection
     GLEW_NV_texture_rectangle GLEW_NV_vertex_program1_1
     GLEW_OES_byte_coordinates GLEW_OES_single_precision
     GLEW_SGIS_generate_mipmap GLEW_SGIS_sharpen_texture
     GLEW_SGIS_texture_filter4 GLEW_SGIX_async_histogram
     GLEW_SGIX_reference_plane GLEW_SGIX_texture_add_env
     GL_AMD_conservative_depth GL_AMD_draw_buffers_blend
     GL_ANGLE_framebuffer_blit GL_ANGLE_instanced_arrays
     GL_APPLE_object_purgeable GL_ARB_color_buffer_float
     GL_ARB_conservative_depth GL_ARB_depth_buffer_float
     GL_ARB_derivative_control GL_ARB_draw_buffers_blend
     GL_ARB_framebuffer_object GL_ARB_get_program_binary
     GL_ARB_invalidate_subdata GL_ARB_shader_texture_lod
     GL_ARB_texture_rgb10_a2ui GL_ASYNC_DRAW_PIXELS_SGIX
     GL_ASYNC_READ_PIXELS_SGIX GL_ATIX_texture_env_route
     GL_ATI_shader_texture_lod GL_ATTRIB_ARRAY_STRIDE_NV
     GL_BLEND_COLOR_COMMAND_NV GL_BLEND_EQUATION_RGB_EXT
     GL_BUFFER_MAP_POINTER_ARB GL_BUMP_NUM_TEX_UNITS_ATI
     GL_CG_FRAGMENT_SHADER_EXT GL_CIRCULAR_CCW_ARC_TO_NV
     GL_CLAMP_VERTEX_COLOR_ARB GL_CLIENT_ALL_ATTRIB_BITS
     GL_CLIENT_PIXEL_STORE_BIT GL_COLOR_ARRAY_ADDRESS_NV
     GL_COLOR_ARRAY_STRIDE_EXT GL_COLOR_ATTACHMENT10_EXT
     GL_COLOR_ATTACHMENT11_EXT GL_COLOR_ATTACHMENT12_EXT
     GL_COLOR_ATTACHMENT13_EXT GL_COLOR_ATTACHMENT14_EXT
     GL_COLOR_ATTACHMENT15_EXT GL_COLOR_TABLE_ALPHA_SIZE
     GL_COLOR_TABLE_FORMAT_EXT GL_COLOR_TABLE_FORMAT_SGI
     GL_COLOR_TABLE_GREEN_SIZE GL_COMBINER_SUM_OUTPUT_NV
     GL_COMPARE_REF_TO_TEXTURE GL_COMPATIBLE_SUBROUTINES
     GL_CONTEXT_FLAG_DEBUG_BIT GL_CONVOLUTION_FORMAT_EXT
     GL_CONVOLUTION_HEIGHT_EXT GL_COVERAGE_MODULATION_NV
     GL_CURRENT_FOG_COORDINATE GL_CURRENT_TEXTURE_COORDS
     GL_DEBUG_SEVERITY_LOW_AMD GL_DEBUG_SEVERITY_LOW_ARB
     GL_DEBUG_SOURCE_OTHER_ARB GL_DEBUG_TYPE_PERFORMANCE
     GL_DEBUG_TYPE_PORTABILITY GL_DEPTH_COMPONENT16_SGIX
     GL_DEPTH_COMPONENT24_SGIX GL_DEPTH_COMPONENT32_SGIX
     GL_DEPTH_TEXTURE_MODE_ARB GL_DRAW_ARRAYS_COMMAND_NV
     GL_DRAW_FRAMEBUFFER_ANGLE GL_EDGE_FLAG_ARRAY_STRIDE
     GL_ELEMENT_ARRAY_TYPE_ATI GL_EVAL_VERTEX_ATTRIB0_NV
     GL_EVAL_VERTEX_ATTRIB1_NV GL_EVAL_VERTEX_ATTRIB2_NV
     GL_EVAL_VERTEX_ATTRIB3_NV GL_EVAL_VERTEX_ATTRIB4_NV
     GL_EVAL_VERTEX_ATTRIB5_NV GL_EVAL_VERTEX_ATTRIB6_NV
     GL_EVAL_VERTEX_ATTRIB7_NV GL_EVAL_VERTEX_ATTRIB8_NV
     GL_EVAL_VERTEX_ATTRIB9_NV GL_EXT_framebuffer_object
     GL_EXT_raster_multisample GL_EXT_shader_integer_mix
     GL_EXT_texture_edge_clamp GL_EXT_transform_feedback
     GL_FOG_COORD_ARRAY_STRIDE GL_FONT_UNINTELLIGIBLE_NV
     GL_FRAMEBUFFER_RENDERABLE GL_GET_TEXTURE_IMAGE_TYPE
     GL_HISTOGRAM_RED_SIZE_EXT GL_IBM_vertex_array_lists
     GL_IMAGE_BINDING_NAME_EXT GL_IMAGE_CLASS_10_10_10_2
     GL_INDEX_ARRAY_ADDRESS_NV GL_INDEX_ARRAY_STRIDE_EXT
     GL_INNOCENT_CONTEXT_RESET GL_INTEL_framebuffer_CMAA
     GL_INTERLEAVED_ATTRIBS_NV GL_INT_IMAGE_1D_ARRAY_EXT
     GL_INT_IMAGE_2D_ARRAY_EXT GL_INT_SAMPLER_BUFFER_AMD
     GL_INT_SAMPLER_BUFFER_EXT GL_INVARIANT_DATATYPE_EXT
     GL_INVERTED_SCREEN_W_REND GL_LAST_VERTEX_CONVENTION
     GL_LAYER_PROVOKING_VERTEX GL_LINE_WIDTH_GRANULARITY
     GL_LUMINANCE12_ALPHA4_EXT GL_LUMINANCE_ALPHA16F_ARB
     GL_LUMINANCE_ALPHA16I_EXT GL_LUMINANCE_ALPHA32F_ARB
     GL_LUMINANCE_ALPHA32I_EXT GL_LUMINANCE_ALPHA8UI_EXT
     GL_MANUAL_GENERATE_MIPMAP GL_MAP_FLUSH_EXPLICIT_BIT
     GL_MAP_UNSYNCHRONIZED_BIT GL_MATERIAL_SIDE_HINT_PGI
     GL_MATRIX_INDEX_ARRAY_ARB GL_MAX_ATTRIB_STACK_DEPTH
     GL_MAX_CONVOLUTION_HEIGHT GL_MAX_FRAMEBUFFER_HEIGHT
     GL_MAX_FRAMEBUFFER_LAYERS GL_MAX_RASTER_SAMPLES_EXT
     GL_MAX_TEXTURE_COORDS_ARB GL_MAX_UNIFORM_BLOCK_SIZE
     GL_MAX_VARYING_COMPONENTS GL_MAX_VARYING_FLOATS_ARB
     GL_MAX_VERTEX_ATTRIBS_ARB GL_MAX_VERTEX_STREAMS_ATI
     GL_MODULATE_SUBTRACT_ATIX GL_NEAREST_MIPMAP_NEAREST
     GL_NORMAL_ARRAY_COUNT_EXT GL_NORMAL_ARRAY_LENGTH_NV
     GL_NVX_conditional_render GL_NV_conservative_raster
     GL_NV_copy_depth_to_color GL_NV_register_combiners2
     GL_NV_shader_atomic_float GL_NV_shader_atomic_int64
     GL_NV_shader_thread_group GL_NV_texture_multisample
     GL_NV_transform_feedback2 GL_NV_vertex_array_range2
     GL_OBJECT_BUFFER_SIZE_ATI GL_OBJECT_LINK_STATUS_ARB
     GL_OFFSET_TEXTURE_BIAS_NV GL_OP_MULTIPLY_MATRIX_EXT
     GL_OUTPUT_POINT_SIZE_ATIX GL_PATH_ERROR_POSITION_NV
     GL_PATH_GEN_COMPONENTS_NV GL_PER_GPU_STORAGE_BIT_NV
     GL_PER_STAGE_CONSTANTS_NV GL_PIXEL_CUBIC_WEIGHT_EXT
     GL_PIXEL_TRANSFORM_2D_EXT GL_POINT_SIZE_GRANULARITY
     GL_POINT_SPRITE_R_MODE_NV GL_PROGRAM_BINARY_FORMATS
     GL_PROGRAM_PARAMETERS_ARB GL_PROGRAM_POINT_SIZE_ARB
     GL_PROGRAM_POINT_SIZE_EXT GL_PROJECTION_STACK_DEPTH
     GL_PROXY_TEXTURE_1D_ARRAY GL_PROXY_TEXTURE_2D_ARRAY
     GL_PROXY_TEXTURE_CUBE_MAP GL_QUERY_COUNTER_BITS_ARB
     GL_QUERY_NO_WAIT_INVERTED GL_QUERY_RESULT_AVAILABLE
     GL_RASTERIZER_DISCARD_EXT GL_RASTER_MULTISAMPLE_EXT
     GL_READ_FRAMEBUFFER_ANGLE GL_RENDERBUFFER_BLUE_SIZE
     GL_RENDERBUFFER_WIDTH_EXT GL_RESAMPLE_DECIMATE_SGIX
     GL_RESAMPLE_REPLICATE_OML GL_RESAMPLE_ZERO_FILL_OML
     GL_SAMPLER_2D_MULTISAMPLE GL_SAMPLER_2D_RECT_SHADOW
     GL_SAMPLER_CUBE_MAP_ARRAY GL_SAMPLE_COVERAGE_INVERT
     GL_SAMPLE_MASK_INVERT_EXT GL_SAMPLE_MASK_VALUE_SGIS
     GL_SGIS_point_line_texgen GL_SGIX_tag_sample_buffer
     GL_SHADOW_ATTENUATION_EXT GL_SLUMINANCE8_ALPHA8_EXT
     GL_SPARSE_STORAGE_BIT_ARB GL_STENCIL_ATTACHMENT_EXT
     GL_STENCIL_BACK_WRITEMASK GL_STENCIL_REF_COMMAND_NV
     GL_SUBSAMPLE_DISTANCE_AMD GL_SUPERSAMPLE_SCALE_X_NV
     GL_SUPERSAMPLE_SCALE_Y_NV GL_TANGENT_ARRAY_TYPE_EXT
     GL_TESS_EVALUATION_SHADER GL_TEXTURE_1D_BINDING_EXT
     GL_TEXTURE_1D_STACK_MESAX GL_TEXTURE_2D_BINDING_EXT
     GL_TEXTURE_2D_MULTISAMPLE GL_TEXTURE_2D_STACK_MESAX
     GL_TEXTURE_3D_BINDING_EXT GL_TEXTURE_ALPHA_SIZE_EXT
     GL_TEXTURE_ALPHA_TYPE_ARB GL_TEXTURE_BINDING_BUFFER
     GL_TEXTURE_BUFFER_BINDING GL_TEXTURE_COMPRESSED_ARB
     GL_TEXTURE_CUBE_MAP_ARRAY GL_TEXTURE_DEPTH_SIZE_ARB
     GL_TEXTURE_DEPTH_TYPE_ARB GL_TEXTURE_FILTER_CONTROL
     GL_TEXTURE_GREEN_SIZE_EXT GL_TEXTURE_GREEN_TYPE_ARB
     GL_TEXTURE_INDEX_SIZE_EXT GL_TEXTURE_INTENSITY_SIZE
     GL_TEXTURE_INTENSITY_TYPE GL_TEXTURE_LUMINANCE_SIZE
     GL_TEXTURE_LUMINANCE_TYPE GL_TEXTURE_MAX_LEVEL_SGIS
     GL_TEXTURE_VIEW_MIN_LAYER GL_TEXTURE_VIEW_MIN_LEVEL
     GL_TOP_LEVEL_ARRAY_STRIDE GL_TRANSPOSE_AFFINE_2D_NV
     GL_TRANSPOSE_AFFINE_3D_NV GL_TRANSPOSE_COLOR_MATRIX
     GL_UNIFORM_BUFFER_BINDING GL_UNPACK_ROW_BYTES_APPLE
     GL_UNPACK_SKIP_IMAGES_EXT GL_UNSIGNED_INT16_VEC2_NV
     GL_UNSIGNED_INT16_VEC3_NV GL_UNSIGNED_INT16_VEC4_NV
     GL_UNSIGNED_INT64_VEC2_NV GL_UNSIGNED_INT64_VEC3_NV
     GL_UNSIGNED_INT64_VEC4_NV GL_UNSIGNED_SHORT_4_4_4_4
     GL_UNSIGNED_SHORT_5_5_5_1 GL_VARIANT_ARRAY_TYPE_EXT
     GL_VERTEX_ARRAY_COUNT_EXT GL_VERTEX_ARRAY_LENGTH_NV
     GL_VERTEX_BINDING_DIVISOR GL_VERTICES_SUBMITTED_ARB
     GL_VIEWPORT_SUBPIXEL_BITS */
  /* Offset 11 gives the best switch position.  */
  switch (name[11]) {
  case '1':
    if (memEQ(name, "GL_TEXTURE_1D_BINDING_EXT", 25)) {
    /*                          ^                    */
#ifdef GL_TEXTURE_1D_BINDING_EXT
      *iv_return = (IV)GL_TEXTURE_1D_BINDING_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_1D_STACK_MESAX", 25)) {
    /*                          ^                    */
#ifdef GL_TEXTURE_1D_STACK_MESAX
      *iv_return = (IV)GL_TEXTURE_1D_STACK_MESAX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '2':
    if (memEQ(name, "GL_SAMPLER_2D_MULTISAMPLE", 25)) {
    /*                          ^                    */
#ifdef GL_SAMPLER_2D_MULTISAMPLE
      *iv_return = (IV)GL_SAMPLER_2D_MULTISAMPLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLER_2D_RECT_SHADOW", 25)) {
    /*                          ^                    */
#ifdef GL_SAMPLER_2D_RECT_SHADOW
      *iv_return = (IV)GL_SAMPLER_2D_RECT_SHADOW;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_2D_BINDING_EXT", 25)) {
    /*                          ^                    */
#ifdef GL_TEXTURE_2D_BINDING_EXT
      *iv_return = (IV)GL_TEXTURE_2D_BINDING_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_2D_MULTISAMPLE", 25)) {
    /*                          ^                    */
#ifdef GL_TEXTURE_2D_MULTISAMPLE
      *iv_return = (IV)GL_TEXTURE_2D_MULTISAMPLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_2D_STACK_MESAX", 25)) {
    /*                          ^                    */
#ifdef GL_TEXTURE_2D_STACK_MESAX
      *iv_return = (IV)GL_TEXTURE_2D_STACK_MESAX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '3':
    if (memEQ(name, "GL_TEXTURE_3D_BINDING_EXT", 25)) {
    /*                          ^                    */
#ifdef GL_TEXTURE_3D_BINDING_EXT
      *iv_return = (IV)GL_TEXTURE_3D_BINDING_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'A':
    if (memEQ(name, "GL_ASYNC_DRAW_PIXELS_SGIX", 25)) {
    /*                          ^                    */
#ifdef GL_ASYNC_DRAW_PIXELS_SGIX
      *iv_return = (IV)GL_ASYNC_DRAW_PIXELS_SGIX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ASYNC_READ_PIXELS_SGIX", 25)) {
    /*                          ^                    */
#ifdef GL_ASYNC_READ_PIXELS_SGIX
      *iv_return = (IV)GL_ASYNC_READ_PIXELS_SGIX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_BUFFER_MAP_POINTER_ARB", 25)) {
    /*                          ^                    */
#ifdef GL_BUFFER_MAP_POINTER_ARB
      *iv_return = (IV)GL_BUFFER_MAP_POINTER_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRAW_ARRAYS_COMMAND_NV", 25)) {
    /*                          ^                    */
#ifdef GL_DRAW_ARRAYS_COMMAND_NV
      *iv_return = (IV)GL_DRAW_ARRAYS_COMMAND_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ELEMENT_ARRAY_TYPE_ATI", 25)) {
    /*                          ^                    */
#ifdef GL_ELEMENT_ARRAY_TYPE_ATI
      *iv_return = (IV)GL_ELEMENT_ARRAY_TYPE_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_IMAGE_CLASS_10_10_10_2", 25)) {
    /*                          ^                    */
#ifdef GL_IMAGE_CLASS_10_10_10_2
      *iv_return = (IV)GL_IMAGE_CLASS_10_10_10_2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PIXEL_TRANSFORM_2D_EXT", 25)) {
    /*                          ^                    */
#ifdef GL_PIXEL_TRANSFORM_2D_EXT
      *iv_return = (IV)GL_PIXEL_TRANSFORM_2D_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLE_MASK_INVERT_EXT", 25)) {
    /*                          ^                    */
#ifdef GL_SAMPLE_MASK_INVERT_EXT
      *iv_return = (IV)GL_SAMPLE_MASK_INVERT_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLE_MASK_VALUE_SGIS", 25)) {
    /*                          ^                    */
#ifdef GL_SAMPLE_MASK_VALUE_SGIS
      *iv_return = (IV)GL_SAMPLE_MASK_VALUE_SGIS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STENCIL_ATTACHMENT_EXT", 25)) {
    /*                          ^                    */
#ifdef GL_STENCIL_ATTACHMENT_EXT
      *iv_return = (IV)GL_STENCIL_ATTACHMENT_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TANGENT_ARRAY_TYPE_EXT", 25)) {
    /*                          ^                    */
#ifdef GL_TANGENT_ARRAY_TYPE_EXT
      *iv_return = (IV)GL_TANGENT_ARRAY_TYPE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_ALPHA_SIZE_EXT", 25)) {
    /*                          ^                    */
#ifdef GL_TEXTURE_ALPHA_SIZE_EXT
      *iv_return = (IV)GL_TEXTURE_ALPHA_SIZE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_ALPHA_TYPE_ARB", 25)) {
    /*                          ^                    */
#ifdef GL_TEXTURE_ALPHA_TYPE_ARB
      *iv_return = (IV)GL_TEXTURE_ALPHA_TYPE_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VARIANT_ARRAY_TYPE_EXT", 25)) {
    /*                          ^                    */
#ifdef GL_VARIANT_ARRAY_TYPE_EXT
      *iv_return = (IV)GL_VARIANT_ARRAY_TYPE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'B':
    if (memEQ(name, "GL_COLOR_TABLE_ALPHA_SIZE", 25)) {
    /*                          ^                    */
#ifdef GL_COLOR_TABLE_ALPHA_SIZE
      *iv_return = (IV)GL_COLOR_TABLE_ALPHA_SIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_TABLE_FORMAT_EXT", 25)) {
    /*                          ^                    */
#ifdef GL_COLOR_TABLE_FORMAT_EXT
      *iv_return = (IV)GL_COLOR_TABLE_FORMAT_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_TABLE_FORMAT_SGI", 25)) {
    /*                          ^                    */
#ifdef GL_COLOR_TABLE_FORMAT_SGI
      *iv_return = (IV)GL_COLOR_TABLE_FORMAT_SGI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_TABLE_GREEN_SIZE", 25)) {
    /*                          ^                    */
#ifdef GL_COLOR_TABLE_GREEN_SIZE
      *iv_return = (IV)GL_COLOR_TABLE_GREEN_SIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PIXEL_CUBIC_WEIGHT_EXT", 25)) {
    /*                          ^                    */
#ifdef GL_PIXEL_CUBIC_WEIGHT_EXT
      *iv_return = (IV)GL_PIXEL_CUBIC_WEIGHT_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PROGRAM_BINARY_FORMATS", 25)) {
    /*                          ^                    */
#ifdef GL_PROGRAM_BINARY_FORMATS
      *iv_return = (IV)GL_PROGRAM_BINARY_FORMATS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STENCIL_BACK_WRITEMASK", 25)) {
    /*                          ^                    */
#ifdef GL_STENCIL_BACK_WRITEMASK
      *iv_return = (IV)GL_STENCIL_BACK_WRITEMASK;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_BINDING_BUFFER", 25)) {
    /*                          ^                    */
#ifdef GL_TEXTURE_BINDING_BUFFER
      *iv_return = (IV)GL_TEXTURE_BINDING_BUFFER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_BUFFER_BINDING", 25)) {
    /*                          ^                    */
#ifdef GL_TEXTURE_BUFFER_BINDING
      *iv_return = (IV)GL_TEXTURE_BUFFER_BINDING;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNIFORM_BUFFER_BINDING", 25)) {
    /*                          ^                    */
#ifdef GL_UNIFORM_BUFFER_BINDING
      *iv_return = (IV)GL_UNIFORM_BUFFER_BINDING;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'C':
    if (memEQ(name, "GL_SAMPLER_CUBE_MAP_ARRAY", 25)) {
    /*                          ^                    */
#ifdef GL_SAMPLER_CUBE_MAP_ARRAY
      *iv_return = (IV)GL_SAMPLER_CUBE_MAP_ARRAY;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SLUMINANCE8_ALPHA8_EXT", 25)) {
    /*                          ^                    */
#ifdef GL_SLUMINANCE8_ALPHA8_EXT
      *iv_return = (IV)GL_SLUMINANCE8_ALPHA8_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_COMPRESSED_ARB", 25)) {
    /*                          ^                    */
#ifdef GL_TEXTURE_COMPRESSED_ARB
      *iv_return = (IV)GL_TEXTURE_COMPRESSED_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_CUBE_MAP_ARRAY", 25)) {
    /*                          ^                    */
#ifdef GL_TEXTURE_CUBE_MAP_ARRAY
      *iv_return = (IV)GL_TEXTURE_CUBE_MAP_ARRAY;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'D':
    if (memEQ(name, "GL_FOG_COORD_ARRAY_STRIDE", 25)) {
    /*                          ^                    */
#ifdef GL_FOG_COORD_ARRAY_STRIDE
      *iv_return = (IV)GL_FOG_COORD_ARRAY_STRIDE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_DEPTH_SIZE_ARB", 25)) {
    /*                          ^                    */
#ifdef GL_TEXTURE_DEPTH_SIZE_ARB
      *iv_return = (IV)GL_TEXTURE_DEPTH_SIZE_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_DEPTH_TYPE_ARB", 25)) {
    /*                          ^                    */
#ifdef GL_TEXTURE_DEPTH_TYPE_ARB
      *iv_return = (IV)GL_TEXTURE_DEPTH_TYPE_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'E':
    if (memEQ(name, "GL_CG_FRAGMENT_SHADER_EXT", 25)) {
    /*                          ^                    */
#ifdef GL_CG_FRAGMENT_SHADER_EXT
      *iv_return = (IV)GL_CG_FRAGMENT_SHADER_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INT_IMAGE_1D_ARRAY_EXT", 25)) {
    /*                          ^                    */
#ifdef GL_INT_IMAGE_1D_ARRAY_EXT
      *iv_return = (IV)GL_INT_IMAGE_1D_ARRAY_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INT_IMAGE_2D_ARRAY_EXT", 25)) {
    /*                          ^                    */
#ifdef GL_INT_IMAGE_2D_ARRAY_EXT
      *iv_return = (IV)GL_INT_IMAGE_2D_ARRAY_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LUMINANCE12_ALPHA4_EXT", 25)) {
    /*                          ^                    */
#ifdef GL_LUMINANCE12_ALPHA4_EXT
      *iv_return = (IV)GL_LUMINANCE12_ALPHA4_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LUMINANCE_ALPHA16F_ARB", 25)) {
    /*                          ^                    */
#ifdef GL_LUMINANCE_ALPHA16F_ARB
      *iv_return = (IV)GL_LUMINANCE_ALPHA16F_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LUMINANCE_ALPHA16I_EXT", 25)) {
    /*                          ^                    */
#ifdef GL_LUMINANCE_ALPHA16I_EXT
      *iv_return = (IV)GL_LUMINANCE_ALPHA16I_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LUMINANCE_ALPHA32F_ARB", 25)) {
    /*                          ^                    */
#ifdef GL_LUMINANCE_ALPHA32F_ARB
      *iv_return = (IV)GL_LUMINANCE_ALPHA32F_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LUMINANCE_ALPHA32I_EXT", 25)) {
    /*                          ^                    */
#ifdef GL_LUMINANCE_ALPHA32I_EXT
      *iv_return = (IV)GL_LUMINANCE_ALPHA32I_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LUMINANCE_ALPHA8UI_EXT", 25)) {
    /*                          ^                    */
#ifdef GL_LUMINANCE_ALPHA8UI_EXT
      *iv_return = (IV)GL_LUMINANCE_ALPHA8UI_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MANUAL_GENERATE_MIPMAP", 25)) {
    /*                          ^                    */
#ifdef GL_MANUAL_GENERATE_MIPMAP
      *iv_return = (IV)GL_MANUAL_GENERATE_MIPMAP;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_FRAMEBUFFER_HEIGHT", 25)) {
    /*                          ^                    */
#ifdef GL_MAX_FRAMEBUFFER_HEIGHT
      *iv_return = (IV)GL_MAX_FRAMEBUFFER_HEIGHT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_FRAMEBUFFER_LAYERS", 25)) {
    /*                          ^                    */
#ifdef GL_MAX_FRAMEBUFFER_LAYERS
      *iv_return = (IV)GL_MAX_FRAMEBUFFER_LAYERS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_RASTER_SAMPLES_EXT", 25)) {
    /*                          ^                    */
#ifdef GL_MAX_RASTER_SAMPLES_EXT
      *iv_return = (IV)GL_MAX_RASTER_SAMPLES_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_VERTEX_ATTRIBS_ARB", 25)) {
    /*                          ^                    */
#ifdef GL_MAX_VERTEX_ATTRIBS_ARB
      *iv_return = (IV)GL_MAX_VERTEX_ATTRIBS_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_VERTEX_STREAMS_ATI", 25)) {
    /*                          ^                    */
#ifdef GL_MAX_VERTEX_STREAMS_ATI
      *iv_return = (IV)GL_MAX_VERTEX_STREAMS_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OFFSET_TEXTURE_BIAS_NV", 25)) {
    /*                          ^                    */
#ifdef GL_OFFSET_TEXTURE_BIAS_NV
      *iv_return = (IV)GL_OFFSET_TEXTURE_BIAS_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PER_STAGE_CONSTANTS_NV", 25)) {
    /*                          ^                    */
#ifdef GL_PER_STAGE_CONSTANTS_NV
      *iv_return = (IV)GL_PER_STAGE_CONSTANTS_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RASTERIZER_DISCARD_EXT", 25)) {
    /*                          ^                    */
#ifdef GL_RASTERIZER_DISCARD_EXT
      *iv_return = (IV)GL_RASTERIZER_DISCARD_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SUBSAMPLE_DISTANCE_AMD", 25)) {
    /*                          ^                    */
#ifdef GL_SUBSAMPLE_DISTANCE_AMD
      *iv_return = (IV)GL_SUBSAMPLE_DISTANCE_AMD;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TRANSPOSE_AFFINE_2D_NV", 25)) {
    /*                          ^                    */
#ifdef GL_TRANSPOSE_AFFINE_2D_NV
      *iv_return = (IV)GL_TRANSPOSE_AFFINE_2D_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TRANSPOSE_AFFINE_3D_NV", 25)) {
    /*                          ^                    */
#ifdef GL_TRANSPOSE_AFFINE_3D_NV
      *iv_return = (IV)GL_TRANSPOSE_AFFINE_3D_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TRANSPOSE_COLOR_MATRIX", 25)) {
    /*                          ^                    */
#ifdef GL_TRANSPOSE_COLOR_MATRIX
      *iv_return = (IV)GL_TRANSPOSE_COLOR_MATRIX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'F':
    if (memEQ(name, "GL_CONTEXT_FLAG_DEBUG_BIT", 25)) {
    /*                          ^                    */
#ifdef GL_CONTEXT_FLAG_DEBUG_BIT
      *iv_return = (IV)GL_CONTEXT_FLAG_DEBUG_BIT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CURRENT_FOG_COORDINATE", 25)) {
    /*                          ^                    */
#ifdef GL_CURRENT_FOG_COORDINATE
      *iv_return = (IV)GL_CURRENT_FOG_COORDINATE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_FRAMEBUFFER_RENDERABLE", 25)) {
    /*                          ^                    */
#ifdef GL_FRAMEBUFFER_RENDERABLE
      *iv_return = (IV)GL_FRAMEBUFFER_RENDERABLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RENDERBUFFER_BLUE_SIZE", 25)) {
    /*                          ^                    */
#ifdef GL_RENDERBUFFER_BLUE_SIZE
      *iv_return = (IV)GL_RENDERBUFFER_BLUE_SIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RENDERBUFFER_WIDTH_EXT", 25)) {
    /*                          ^                    */
#ifdef GL_RENDERBUFFER_WIDTH_EXT
      *iv_return = (IV)GL_RENDERBUFFER_WIDTH_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_FILTER_CONTROL", 25)) {
    /*                          ^                    */
#ifdef GL_TEXTURE_FILTER_CONTROL
      *iv_return = (IV)GL_TEXTURE_FILTER_CONTROL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'G':
    if (memEQ(name, "GL_EDGE_FLAG_ARRAY_STRIDE", 25)) {
    /*                          ^                    */
#ifdef GL_EDGE_FLAG_ARRAY_STRIDE
      *iv_return = (IV)GL_EDGE_FLAG_ARRAY_STRIDE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_GREEN_SIZE_EXT", 25)) {
    /*                          ^                    */
#ifdef GL_TEXTURE_GREEN_SIZE_EXT
      *iv_return = (IV)GL_TEXTURE_GREEN_SIZE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_GREEN_TYPE_ARB", 25)) {
    /*                          ^                    */
#ifdef GL_TEXTURE_GREEN_TYPE_ARB
      *iv_return = (IV)GL_TEXTURE_GREEN_TYPE_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'H':
    if (memEQ(name, "GL_MAP_FLUSH_EXPLICIT_BIT", 25)) {
    /*                          ^                    */
#ifdef GL_MAP_FLUSH_EXPLICIT_BIT
      *iv_return = (IV)GL_MAP_FLUSH_EXPLICIT_BIT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'I':
    if (memEQ(name, "GL_CLIENT_PIXEL_STORE_BIT", 25)) {
    /*                          ^                    */
#ifdef GL_CLIENT_PIXEL_STORE_BIT
      *iv_return = (IV)GL_CLIENT_PIXEL_STORE_BIT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CONVOLUTION_FORMAT_EXT", 25)) {
    /*                          ^                    */
#ifdef GL_CONVOLUTION_FORMAT_EXT
      *iv_return = (IV)GL_CONVOLUTION_FORMAT_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CONVOLUTION_HEIGHT_EXT", 25)) {
    /*                          ^                    */
#ifdef GL_CONVOLUTION_HEIGHT_EXT
      *iv_return = (IV)GL_CONVOLUTION_HEIGHT_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_ATTRIB_STACK_DEPTH", 25)) {
    /*                          ^                    */
#ifdef GL_MAX_ATTRIB_STACK_DEPTH
      *iv_return = (IV)GL_MAX_ATTRIB_STACK_DEPTH;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_VARYING_COMPONENTS", 25)) {
    /*                          ^                    */
#ifdef GL_MAX_VARYING_COMPONENTS
      *iv_return = (IV)GL_MAX_VARYING_COMPONENTS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_VARYING_FLOATS_ARB", 25)) {
    /*                          ^                    */
#ifdef GL_MAX_VARYING_FLOATS_ARB
      *iv_return = (IV)GL_MAX_VARYING_FLOATS_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OBJECT_LINK_STATUS_ARB", 25)) {
    /*                          ^                    */
#ifdef GL_OBJECT_LINK_STATUS_ARB
      *iv_return = (IV)GL_OBJECT_LINK_STATUS_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_INDEX_SIZE_EXT", 25)) {
    /*                          ^                    */
#ifdef GL_TEXTURE_INDEX_SIZE_EXT
      *iv_return = (IV)GL_TEXTURE_INDEX_SIZE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_INTENSITY_SIZE", 25)) {
    /*                          ^                    */
#ifdef GL_TEXTURE_INTENSITY_SIZE
      *iv_return = (IV)GL_TEXTURE_INTENSITY_SIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_INTENSITY_TYPE", 25)) {
    /*                          ^                    */
#ifdef GL_TEXTURE_INTENSITY_TYPE
      *iv_return = (IV)GL_TEXTURE_INTENSITY_TYPE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERTEX_BINDING_DIVISOR", 25)) {
    /*                          ^                    */
#ifdef GL_VERTEX_BINDING_DIVISOR
      *iv_return = (IV)GL_VERTEX_BINDING_DIVISOR;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'K':
    if (memEQ(name, "GL_UNPACK_SKIP_IMAGES_EXT", 25)) {
    /*                          ^                    */
#ifdef GL_UNPACK_SKIP_IMAGES_EXT
      *iv_return = (IV)GL_UNPACK_SKIP_IMAGES_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'L':
    if (memEQ(name, "GL_BLEND_COLOR_COMMAND_NV", 25)) {
    /*                          ^                    */
#ifdef GL_BLEND_COLOR_COMMAND_NV
      *iv_return = (IV)GL_BLEND_COLOR_COMMAND_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CLIENT_ALL_ATTRIB_BITS", 25)) {
    /*                          ^                    */
#ifdef GL_CLIENT_ALL_ATTRIB_BITS
      *iv_return = (IV)GL_CLIENT_ALL_ATTRIB_BITS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COMPATIBLE_SUBROUTINES", 25)) {
    /*                          ^                    */
#ifdef GL_COMPATIBLE_SUBROUTINES
      *iv_return = (IV)GL_COMPATIBLE_SUBROUTINES;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INT_SAMPLER_BUFFER_AMD", 25)) {
    /*                          ^                    */
#ifdef GL_INT_SAMPLER_BUFFER_AMD
      *iv_return = (IV)GL_INT_SAMPLER_BUFFER_AMD;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INT_SAMPLER_BUFFER_EXT", 25)) {
    /*                          ^                    */
#ifdef GL_INT_SAMPLER_BUFFER_EXT
      *iv_return = (IV)GL_INT_SAMPLER_BUFFER_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TESS_EVALUATION_SHADER", 25)) {
    /*                          ^                    */
#ifdef GL_TESS_EVALUATION_SHADER
      *iv_return = (IV)GL_TESS_EVALUATION_SHADER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_LUMINANCE_SIZE", 25)) {
    /*                          ^                    */
#ifdef GL_TEXTURE_LUMINANCE_SIZE
      *iv_return = (IV)GL_TEXTURE_LUMINANCE_SIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_LUMINANCE_TYPE", 25)) {
    /*                          ^                    */
#ifdef GL_TEXTURE_LUMINANCE_TYPE
      *iv_return = (IV)GL_TEXTURE_LUMINANCE_TYPE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TOP_LEVEL_ARRAY_STRIDE", 25)) {
    /*                          ^                    */
#ifdef GL_TOP_LEVEL_ARRAY_STRIDE
      *iv_return = (IV)GL_TOP_LEVEL_ARRAY_STRIDE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'M':
    if (memEQ(name, "GL_DEPTH_COMPONENT16_SGIX", 25)) {
    /*                          ^                    */
#ifdef GL_DEPTH_COMPONENT16_SGIX
      *iv_return = (IV)GL_DEPTH_COMPONENT16_SGIX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEPTH_COMPONENT24_SGIX", 25)) {
    /*                          ^                    */
#ifdef GL_DEPTH_COMPONENT24_SGIX
      *iv_return = (IV)GL_DEPTH_COMPONENT24_SGIX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEPTH_COMPONENT32_SGIX", 25)) {
    /*                          ^                    */
#ifdef GL_DEPTH_COMPONENT32_SGIX
      *iv_return = (IV)GL_DEPTH_COMPONENT32_SGIX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DRAW_FRAMEBUFFER_ANGLE", 25)) {
    /*                          ^                    */
#ifdef GL_DRAW_FRAMEBUFFER_ANGLE
      *iv_return = (IV)GL_DRAW_FRAMEBUFFER_ANGLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_HISTOGRAM_RED_SIZE_EXT", 25)) {
    /*                          ^                    */
#ifdef GL_HISTOGRAM_RED_SIZE_EXT
      *iv_return = (IV)GL_HISTOGRAM_RED_SIZE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NEAREST_MIPMAP_NEAREST", 25)) {
    /*                          ^                    */
#ifdef GL_NEAREST_MIPMAP_NEAREST
      *iv_return = (IV)GL_NEAREST_MIPMAP_NEAREST;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_READ_FRAMEBUFFER_ANGLE", 25)) {
    /*                          ^                    */
#ifdef GL_READ_FRAMEBUFFER_ANGLE
      *iv_return = (IV)GL_READ_FRAMEBUFFER_ANGLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_MAX_LEVEL_SGIS", 25)) {
    /*                          ^                    */
#ifdef GL_TEXTURE_MAX_LEVEL_SGIS
      *iv_return = (IV)GL_TEXTURE_MAX_LEVEL_SGIS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'N':
    if (memEQ(name, "GL_FONT_UNINTELLIGIBLE_NV", 25)) {
    /*                          ^                    */
#ifdef GL_FONT_UNINTELLIGIBLE_NV
      *iv_return = (IV)GL_FONT_UNINTELLIGIBLE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_IMAGE_BINDING_NAME_EXT", 25)) {
    /*                          ^                    */
#ifdef GL_IMAGE_BINDING_NAME_EXT
      *iv_return = (IV)GL_IMAGE_BINDING_NAME_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAP_UNSYNCHRONIZED_BIT", 25)) {
    /*                          ^                    */
#ifdef GL_MAP_UNSYNCHRONIZED_BIT
      *iv_return = (IV)GL_MAP_UNSYNCHRONIZED_BIT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MATRIX_INDEX_ARRAY_ARB", 25)) {
    /*                          ^                    */
#ifdef GL_MATRIX_INDEX_ARRAY_ARB
      *iv_return = (IV)GL_MATRIX_INDEX_ARRAY_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'O':
    if (memEQ(name, "GL_LAYER_PROVOKING_VERTEX", 25)) {
    /*                          ^                    */
#ifdef GL_LAYER_PROVOKING_VERTEX
      *iv_return = (IV)GL_LAYER_PROVOKING_VERTEX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_CONVOLUTION_HEIGHT", 25)) {
    /*                          ^                    */
#ifdef GL_MAX_CONVOLUTION_HEIGHT
      *iv_return = (IV)GL_MAX_CONVOLUTION_HEIGHT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_UNIFORM_BLOCK_SIZE", 25)) {
    /*                          ^                    */
#ifdef GL_MAX_UNIFORM_BLOCK_SIZE
      *iv_return = (IV)GL_MAX_UNIFORM_BLOCK_SIZE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OUTPUT_POINT_SIZE_ATIX", 25)) {
    /*                          ^                    */
#ifdef GL_OUTPUT_POINT_SIZE_ATIX
      *iv_return = (IV)GL_OUTPUT_POINT_SIZE_ATIX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PATH_ERROR_POSITION_NV", 25)) {
    /*                          ^                    */
#ifdef GL_PATH_ERROR_POSITION_NV
      *iv_return = (IV)GL_PATH_ERROR_POSITION_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PROJECTION_STACK_DEPTH", 25)) {
    /*                          ^                    */
#ifdef GL_PROJECTION_STACK_DEPTH
      *iv_return = (IV)GL_PROJECTION_STACK_DEPTH;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SAMPLE_COVERAGE_INVERT", 25)) {
    /*                          ^                    */
#ifdef GL_SAMPLE_COVERAGE_INVERT
      *iv_return = (IV)GL_SAMPLE_COVERAGE_INVERT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNPACK_ROW_BYTES_APPLE", 25)) {
    /*                          ^                    */
#ifdef GL_UNPACK_ROW_BYTES_APPLE
      *iv_return = (IV)GL_UNPACK_ROW_BYTES_APPLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'P':
    if (memEQ(name, "GL_DEBUG_TYPE_PERFORMANCE", 25)) {
    /*                          ^                    */
#ifdef GL_DEBUG_TYPE_PERFORMANCE
      *iv_return = (IV)GL_DEBUG_TYPE_PERFORMANCE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEBUG_TYPE_PORTABILITY", 25)) {
    /*                          ^                    */
#ifdef GL_DEBUG_TYPE_PORTABILITY
      *iv_return = (IV)GL_DEBUG_TYPE_PORTABILITY;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OP_MULTIPLY_MATRIX_EXT", 25)) {
    /*                          ^                    */
#ifdef GL_OP_MULTIPLY_MATRIX_EXT
      *iv_return = (IV)GL_OP_MULTIPLY_MATRIX_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PROGRAM_PARAMETERS_ARB", 25)) {
    /*                          ^                    */
#ifdef GL_PROGRAM_PARAMETERS_ARB
      *iv_return = (IV)GL_PROGRAM_PARAMETERS_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PROGRAM_POINT_SIZE_ARB", 25)) {
    /*                          ^                    */
#ifdef GL_PROGRAM_POINT_SIZE_ARB
      *iv_return = (IV)GL_PROGRAM_POINT_SIZE_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PROGRAM_POINT_SIZE_EXT", 25)) {
    /*                          ^                    */
#ifdef GL_PROGRAM_POINT_SIZE_EXT
      *iv_return = (IV)GL_PROGRAM_POINT_SIZE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SUPERSAMPLE_SCALE_X_NV", 25)) {
    /*                          ^                    */
#ifdef GL_SUPERSAMPLE_SCALE_X_NV
      *iv_return = (IV)GL_SUPERSAMPLE_SCALE_X_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SUPERSAMPLE_SCALE_Y_NV", 25)) {
    /*                          ^                    */
#ifdef GL_SUPERSAMPLE_SCALE_Y_NV
      *iv_return = (IV)GL_SUPERSAMPLE_SCALE_Y_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'R':
    if (memEQ(name, "GL_ATTRIB_ARRAY_STRIDE_NV", 25)) {
    /*                          ^                    */
#ifdef GL_ATTRIB_ARRAY_STRIDE_NV
      *iv_return = (IV)GL_ATTRIB_ARRAY_STRIDE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CLAMP_VERTEX_COLOR_ARB", 25)) {
    /*                          ^                    */
#ifdef GL_CLAMP_VERTEX_COLOR_ARB
      *iv_return = (IV)GL_CLAMP_VERTEX_COLOR_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_ARRAY_ADDRESS_NV", 25)) {
    /*                          ^                    */
#ifdef GL_COLOR_ARRAY_ADDRESS_NV
      *iv_return = (IV)GL_COLOR_ARRAY_ADDRESS_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_ARRAY_STRIDE_EXT", 25)) {
    /*                          ^                    */
#ifdef GL_COLOR_ARRAY_STRIDE_EXT
      *iv_return = (IV)GL_COLOR_ARRAY_STRIDE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COMPARE_REF_TO_TEXTURE", 25)) {
    /*                          ^                    */
#ifdef GL_COMPARE_REF_TO_TEXTURE
      *iv_return = (IV)GL_COMPARE_REF_TO_TEXTURE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INDEX_ARRAY_ADDRESS_NV", 25)) {
    /*                          ^                    */
#ifdef GL_INDEX_ARRAY_ADDRESS_NV
      *iv_return = (IV)GL_INDEX_ARRAY_ADDRESS_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INDEX_ARRAY_STRIDE_EXT", 25)) {
    /*                          ^                    */
#ifdef GL_INDEX_ARRAY_STRIDE_EXT
      *iv_return = (IV)GL_INDEX_ARRAY_STRIDE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NORMAL_ARRAY_COUNT_EXT", 25)) {
    /*                          ^                    */
#ifdef GL_NORMAL_ARRAY_COUNT_EXT
      *iv_return = (IV)GL_NORMAL_ARRAY_COUNT_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NORMAL_ARRAY_LENGTH_NV", 25)) {
    /*                          ^                    */
#ifdef GL_NORMAL_ARRAY_LENGTH_NV
      *iv_return = (IV)GL_NORMAL_ARRAY_LENGTH_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_POINT_SPRITE_R_MODE_NV", 25)) {
    /*                          ^                    */
#ifdef GL_POINT_SPRITE_R_MODE_NV
      *iv_return = (IV)GL_POINT_SPRITE_R_MODE_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_STENCIL_REF_COMMAND_NV", 25)) {
    /*                          ^                    */
#ifdef GL_STENCIL_REF_COMMAND_NV
      *iv_return = (IV)GL_STENCIL_REF_COMMAND_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERTEX_ARRAY_COUNT_EXT", 25)) {
    /*                          ^                    */
#ifdef GL_VERTEX_ARRAY_COUNT_EXT
      *iv_return = (IV)GL_VERTEX_ARRAY_COUNT_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERTEX_ARRAY_LENGTH_NV", 25)) {
    /*                          ^                    */
#ifdef GL_VERTEX_ARRAY_LENGTH_NV
      *iv_return = (IV)GL_VERTEX_ARRAY_LENGTH_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'S':
    if (memEQ(name, "GL_PER_GPU_STORAGE_BIT_NV", 25)) {
    /*                          ^                    */
#ifdef GL_PER_GPU_STORAGE_BIT_NV
      *iv_return = (IV)GL_PER_GPU_STORAGE_BIT_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_QUERY_RESULT_AVAILABLE", 25)) {
    /*                          ^                    */
#ifdef GL_QUERY_RESULT_AVAILABLE
      *iv_return = (IV)GL_QUERY_RESULT_AVAILABLE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'T':
    if (memEQ(name, "GL_COLOR_ATTACHMENT10_EXT", 25)) {
    /*                          ^                    */
#ifdef GL_COLOR_ATTACHMENT10_EXT
      *iv_return = (IV)GL_COLOR_ATTACHMENT10_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_ATTACHMENT11_EXT", 25)) {
    /*                          ^                    */
#ifdef GL_COLOR_ATTACHMENT11_EXT
      *iv_return = (IV)GL_COLOR_ATTACHMENT11_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_ATTACHMENT12_EXT", 25)) {
    /*                          ^                    */
#ifdef GL_COLOR_ATTACHMENT12_EXT
      *iv_return = (IV)GL_COLOR_ATTACHMENT12_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_ATTACHMENT13_EXT", 25)) {
    /*                          ^                    */
#ifdef GL_COLOR_ATTACHMENT13_EXT
      *iv_return = (IV)GL_COLOR_ATTACHMENT13_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_ATTACHMENT14_EXT", 25)) {
    /*                          ^                    */
#ifdef GL_COLOR_ATTACHMENT14_EXT
      *iv_return = (IV)GL_COLOR_ATTACHMENT14_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COLOR_ATTACHMENT15_EXT", 25)) {
    /*                          ^                    */
#ifdef GL_COLOR_ATTACHMENT15_EXT
      *iv_return = (IV)GL_COLOR_ATTACHMENT15_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CURRENT_TEXTURE_COORDS", 25)) {
    /*                          ^                    */
#ifdef GL_CURRENT_TEXTURE_COORDS
      *iv_return = (IV)GL_CURRENT_TEXTURE_COORDS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EVAL_VERTEX_ATTRIB0_NV", 25)) {
    /*                          ^                    */
#ifdef GL_EVAL_VERTEX_ATTRIB0_NV
      *iv_return = (IV)GL_EVAL_VERTEX_ATTRIB0_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EVAL_VERTEX_ATTRIB1_NV", 25)) {
    /*                          ^                    */
#ifdef GL_EVAL_VERTEX_ATTRIB1_NV
      *iv_return = (IV)GL_EVAL_VERTEX_ATTRIB1_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EVAL_VERTEX_ATTRIB2_NV", 25)) {
    /*                          ^                    */
#ifdef GL_EVAL_VERTEX_ATTRIB2_NV
      *iv_return = (IV)GL_EVAL_VERTEX_ATTRIB2_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EVAL_VERTEX_ATTRIB3_NV", 25)) {
    /*                          ^                    */
#ifdef GL_EVAL_VERTEX_ATTRIB3_NV
      *iv_return = (IV)GL_EVAL_VERTEX_ATTRIB3_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EVAL_VERTEX_ATTRIB4_NV", 25)) {
    /*                          ^                    */
#ifdef GL_EVAL_VERTEX_ATTRIB4_NV
      *iv_return = (IV)GL_EVAL_VERTEX_ATTRIB4_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EVAL_VERTEX_ATTRIB5_NV", 25)) {
    /*                          ^                    */
#ifdef GL_EVAL_VERTEX_ATTRIB5_NV
      *iv_return = (IV)GL_EVAL_VERTEX_ATTRIB5_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EVAL_VERTEX_ATTRIB6_NV", 25)) {
    /*                          ^                    */
#ifdef GL_EVAL_VERTEX_ATTRIB6_NV
      *iv_return = (IV)GL_EVAL_VERTEX_ATTRIB6_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EVAL_VERTEX_ATTRIB7_NV", 25)) {
    /*                          ^                    */
#ifdef GL_EVAL_VERTEX_ATTRIB7_NV
      *iv_return = (IV)GL_EVAL_VERTEX_ATTRIB7_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EVAL_VERTEX_ATTRIB8_NV", 25)) {
    /*                          ^                    */
#ifdef GL_EVAL_VERTEX_ATTRIB8_NV
      *iv_return = (IV)GL_EVAL_VERTEX_ATTRIB8_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EVAL_VERTEX_ATTRIB9_NV", 25)) {
    /*                          ^                    */
#ifdef GL_EVAL_VERTEX_ATTRIB9_NV
      *iv_return = (IV)GL_EVAL_VERTEX_ATTRIB9_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INVARIANT_DATATYPE_EXT", 25)) {
    /*                          ^                    */
#ifdef GL_INVARIANT_DATATYPE_EXT
      *iv_return = (IV)GL_INVARIANT_DATATYPE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LAST_VERTEX_CONVENTION", 25)) {
    /*                          ^                    */
#ifdef GL_LAST_VERTEX_CONVENTION
      *iv_return = (IV)GL_LAST_VERTEX_CONVENTION;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_LINE_WIDTH_GRANULARITY", 25)) {
    /*                          ^                    */
#ifdef GL_LINE_WIDTH_GRANULARITY
      *iv_return = (IV)GL_LINE_WIDTH_GRANULARITY;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SHADOW_ATTENUATION_EXT", 25)) {
    /*                          ^                    */
#ifdef GL_SHADOW_ATTENUATION_EXT
      *iv_return = (IV)GL_SHADOW_ATTENUATION_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SPARSE_STORAGE_BIT_ARB", 25)) {
    /*                          ^                    */
#ifdef GL_SPARSE_STORAGE_BIT_ARB
      *iv_return = (IV)GL_SPARSE_STORAGE_BIT_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'U':
    if (memEQ(name, "GL_BLEND_EQUATION_RGB_EXT", 25)) {
    /*                          ^                    */
#ifdef GL_BLEND_EQUATION_RGB_EXT
      *iv_return = (IV)GL_BLEND_EQUATION_RGB_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEBUG_SOURCE_OTHER_ARB", 25)) {
    /*                          ^                    */
#ifdef GL_DEBUG_SOURCE_OTHER_ARB
      *iv_return = (IV)GL_DEBUG_SOURCE_OTHER_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_GET_TEXTURE_IMAGE_TYPE", 25)) {
    /*                          ^                    */
#ifdef GL_GET_TEXTURE_IMAGE_TYPE
      *iv_return = (IV)GL_GET_TEXTURE_IMAGE_TYPE;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MAX_TEXTURE_COORDS_ARB", 25)) {
    /*                          ^                    */
#ifdef GL_MAX_TEXTURE_COORDS_ARB
      *iv_return = (IV)GL_MAX_TEXTURE_COORDS_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_OBJECT_BUFFER_SIZE_ATI", 25)) {
    /*                          ^                    */
#ifdef GL_OBJECT_BUFFER_SIZE_ATI
      *iv_return = (IV)GL_OBJECT_BUFFER_SIZE_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_QUERY_COUNTER_BITS_ARB", 25)) {
    /*                          ^                    */
#ifdef GL_QUERY_COUNTER_BITS_ARB
      *iv_return = (IV)GL_QUERY_COUNTER_BITS_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RASTER_MULTISAMPLE_EXT", 25)) {
    /*                          ^                    */
#ifdef GL_RASTER_MULTISAMPLE_EXT
      *iv_return = (IV)GL_RASTER_MULTISAMPLE_EXT;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'V':
    if (memEQ(name, "GL_DEBUG_SEVERITY_LOW_AMD", 25)) {
    /*                          ^                    */
#ifdef GL_DEBUG_SEVERITY_LOW_AMD
      *iv_return = (IV)GL_DEBUG_SEVERITY_LOW_AMD;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_DEBUG_SEVERITY_LOW_ARB", 25)) {
    /*                          ^                    */
#ifdef GL_DEBUG_SEVERITY_LOW_ARB
      *iv_return = (IV)GL_DEBUG_SEVERITY_LOW_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INTERLEAVED_ATTRIBS_NV", 25)) {
    /*                          ^                    */
#ifdef GL_INTERLEAVED_ATTRIBS_NV
      *iv_return = (IV)GL_INTERLEAVED_ATTRIBS_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_VIEW_MIN_LAYER", 25)) {
    /*                          ^                    */
#ifdef GL_TEXTURE_VIEW_MIN_LAYER
      *iv_return = (IV)GL_TEXTURE_VIEW_MIN_LAYER;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_TEXTURE_VIEW_MIN_LEVEL", 25)) {
    /*                          ^                    */
#ifdef GL_TEXTURE_VIEW_MIN_LEVEL
      *iv_return = (IV)GL_TEXTURE_VIEW_MIN_LEVEL;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'X':
    if (memEQ(name, "GL_DEPTH_TEXTURE_MODE_ARB", 25)) {
    /*                          ^                    */
#ifdef GL_DEPTH_TEXTURE_MODE_ARB
      *iv_return = (IV)GL_DEPTH_TEXTURE_MODE_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PROXY_TEXTURE_1D_ARRAY", 25)) {
    /*                          ^                    */
#ifdef GL_PROXY_TEXTURE_1D_ARRAY
      *iv_return = (IV)GL_PROXY_TEXTURE_1D_ARRAY;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PROXY_TEXTURE_2D_ARRAY", 25)) {
    /*                          ^                    */
#ifdef GL_PROXY_TEXTURE_2D_ARRAY
      *iv_return = (IV)GL_PROXY_TEXTURE_2D_ARRAY;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PROXY_TEXTURE_CUBE_MAP", 25)) {
    /*                          ^                    */
#ifdef GL_PROXY_TEXTURE_CUBE_MAP
      *iv_return = (IV)GL_PROXY_TEXTURE_CUBE_MAP;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'Z':
    if (memEQ(name, "GL_POINT_SIZE_GRANULARITY", 25)) {
    /*                          ^                    */
#ifdef GL_POINT_SIZE_GRANULARITY
      *iv_return = (IV)GL_POINT_SIZE_GRANULARITY;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case '_':
    if (memEQ(name, "GL_AMD_draw_buffers_blend", 25)) {
    /*                          ^                    */
#ifdef GL_AMD_draw_buffers_blend
      *iv_return = (IV)GL_AMD_draw_buffers_blend;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_draw_buffers_blend", 25)) {
    /*                          ^                    */
#ifdef GL_ARB_draw_buffers_blend
      *iv_return = (IV)GL_ARB_draw_buffers_blend;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_BUMP_NUM_TEX_UNITS_ATI", 25)) {
    /*                          ^                    */
#ifdef GL_BUMP_NUM_TEX_UNITS_ATI
      *iv_return = (IV)GL_BUMP_NUM_TEX_UNITS_ATI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_CIRCULAR_CCW_ARC_TO_NV", 25)) {
    /*                          ^                    */
#ifdef GL_CIRCULAR_CCW_ARC_TO_NV
      *iv_return = (IV)GL_CIRCULAR_CCW_ARC_TO_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COMBINER_SUM_OUTPUT_NV", 25)) {
    /*                          ^                    */
#ifdef GL_COMBINER_SUM_OUTPUT_NV
      *iv_return = (IV)GL_COMBINER_SUM_OUTPUT_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_COVERAGE_MODULATION_NV", 25)) {
    /*                          ^                    */
#ifdef GL_COVERAGE_MODULATION_NV
      *iv_return = (IV)GL_COVERAGE_MODULATION_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INNOCENT_CONTEXT_RESET", 25)) {
    /*                          ^                    */
#ifdef GL_INNOCENT_CONTEXT_RESET
      *iv_return = (IV)GL_INNOCENT_CONTEXT_RESET;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INVERTED_SCREEN_W_REND", 25)) {
    /*                          ^                    */
#ifdef GL_INVERTED_SCREEN_W_REND
      *iv_return = (IV)GL_INVERTED_SCREEN_W_REND;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MATERIAL_SIDE_HINT_PGI", 25)) {
    /*                          ^                    */
#ifdef GL_MATERIAL_SIDE_HINT_PGI
      *iv_return = (IV)GL_MATERIAL_SIDE_HINT_PGI;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_MODULATE_SUBTRACT_ATIX", 25)) {
    /*                          ^                    */
#ifdef GL_MODULATE_SUBTRACT_ATIX
      *iv_return = (IV)GL_MODULATE_SUBTRACT_ATIX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_PATH_GEN_COMPONENTS_NV", 25)) {
    /*                          ^                    */
#ifdef GL_PATH_GEN_COMPONENTS_NV
      *iv_return = (IV)GL_PATH_GEN_COMPONENTS_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_QUERY_NO_WAIT_INVERTED", 25)) {
    /*                          ^                    */
#ifdef GL_QUERY_NO_WAIT_INVERTED
      *iv_return = (IV)GL_QUERY_NO_WAIT_INVERTED;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RESAMPLE_DECIMATE_SGIX", 25)) {
    /*                          ^                    */
#ifdef GL_RESAMPLE_DECIMATE_SGIX
      *iv_return = (IV)GL_RESAMPLE_DECIMATE_SGIX;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RESAMPLE_REPLICATE_OML", 25)) {
    /*                          ^                    */
#ifdef GL_RESAMPLE_REPLICATE_OML
      *iv_return = (IV)GL_RESAMPLE_REPLICATE_OML;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_RESAMPLE_ZERO_FILL_OML", 25)) {
    /*                          ^                    */
#ifdef GL_RESAMPLE_ZERO_FILL_OML
      *iv_return = (IV)GL_RESAMPLE_ZERO_FILL_OML;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SGIX_tag_sample_buffer", 25)) {
    /*                          ^                    */
#ifdef GL_SGIX_tag_sample_buffer
      *iv_return = (IV)GL_SGIX_tag_sample_buffer;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNSIGNED_INT16_VEC2_NV", 25)) {
    /*                          ^                    */
#ifdef GL_UNSIGNED_INT16_VEC2_NV
      *iv_return = (IV)GL_UNSIGNED_INT16_VEC2_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNSIGNED_INT16_VEC3_NV", 25)) {
    /*                          ^                    */
#ifdef GL_UNSIGNED_INT16_VEC3_NV
      *iv_return = (IV)GL_UNSIGNED_INT16_VEC3_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNSIGNED_INT16_VEC4_NV", 25)) {
    /*                          ^                    */
#ifdef GL_UNSIGNED_INT16_VEC4_NV
      *iv_return = (IV)GL_UNSIGNED_INT16_VEC4_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNSIGNED_INT64_VEC2_NV", 25)) {
    /*                          ^                    */
#ifdef GL_UNSIGNED_INT64_VEC2_NV
      *iv_return = (IV)GL_UNSIGNED_INT64_VEC2_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNSIGNED_INT64_VEC3_NV", 25)) {
    /*                          ^                    */
#ifdef GL_UNSIGNED_INT64_VEC3_NV
      *iv_return = (IV)GL_UNSIGNED_INT64_VEC3_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNSIGNED_INT64_VEC4_NV", 25)) {
    /*                          ^                    */
#ifdef GL_UNSIGNED_INT64_VEC4_NV
      *iv_return = (IV)GL_UNSIGNED_INT64_VEC4_NV;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNSIGNED_SHORT_4_4_4_4", 25)) {
    /*                          ^                    */
#ifdef GL_UNSIGNED_SHORT_4_4_4_4
      *iv_return = (IV)GL_UNSIGNED_SHORT_4_4_4_4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_UNSIGNED_SHORT_5_5_5_1", 25)) {
    /*                          ^                    */
#ifdef GL_UNSIGNED_SHORT_5_5_5_1
      *iv_return = (IV)GL_UNSIGNED_SHORT_5_5_5_1;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VERTICES_SUBMITTED_ARB", 25)) {
    /*                          ^                    */
#ifdef GL_VERTICES_SUBMITTED_ARB
      *iv_return = (IV)GL_VERTICES_SUBMITTED_ARB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_VIEWPORT_SUBPIXEL_BITS", 25)) {
    /*                          ^                    */
#ifdef GL_VIEWPORT_SUBPIXEL_BITS
      *iv_return = (IV)GL_VIEWPORT_SUBPIXEL_BITS;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'a':
    if (memEQ(name, "GLEW_ARB_fragment_program", 25)) {
    /*                          ^                    */
#ifdef GLEW_ARB_fragment_program
      *iv_return = (IV)GLEW_ARB_fragment_program;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_ARB_framebuffer_sRGB", 25)) {
    /*                          ^                    */
#ifdef GLEW_ARB_framebuffer_sRGB
      *iv_return = (IV)GLEW_ARB_framebuffer_sRGB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_ARB_shader_precision", 25)) {
    /*                          ^                    */
#ifdef GLEW_ARB_shader_precision
      *iv_return = (IV)GLEW_ARB_shader_precision;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_ARB_transpose_matrix", 25)) {
    /*                          ^                    */
#ifdef GLEW_ARB_transpose_matrix
      *iv_return = (IV)GLEW_ARB_transpose_matrix;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_EXT_framebuffer_blit", 25)) {
    /*                          ^                    */
#ifdef GLEW_EXT_framebuffer_blit
      *iv_return = (IV)GLEW_EXT_framebuffer_blit;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_EXT_framebuffer_sRGB", 25)) {
    /*                          ^                    */
#ifdef GLEW_EXT_framebuffer_sRGB
      *iv_return = (IV)GLEW_EXT_framebuffer_sRGB;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ANGLE_framebuffer_blit", 25)) {
    /*                          ^                    */
#ifdef GL_ANGLE_framebuffer_blit
      *iv_return = (IV)GL_ANGLE_framebuffer_blit;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_INTEL_framebuffer_CMAA", 25)) {
    /*                          ^                    */
#ifdef GL_INTEL_framebuffer_CMAA
      *iv_return = (IV)GL_INTEL_framebuffer_CMAA;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'c':
    if (memEQ(name, "GLEW_APPLE_client_storage", 25)) {
    /*                          ^                    */
#ifdef GLEW_APPLE_client_storage
      *iv_return = (IV)GLEW_APPLE_client_storage;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_ARB_occlusion_query2", 25)) {
    /*                          ^                    */
#ifdef GLEW_ARB_occlusion_query2
      *iv_return = (IV)GLEW_ARB_occlusion_query2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'd':
    if (memEQ(name, "GL_NV_copy_depth_to_color", 25)) {
    /*                          ^                    */
#ifdef GL_NV_copy_depth_to_color
      *iv_return = (IV)GL_NV_copy_depth_to_color;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'e':
    if (memEQ(name, "GLEW_EXT_stencil_two_side", 25)) {
    /*                          ^                    */
#ifdef GLEW_EXT_stencil_two_side
      *iv_return = (IV)GLEW_EXT_stencil_two_side;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_SGIS_generate_mipmap", 25)) {
    /*                          ^                    */
#ifdef GLEW_SGIS_generate_mipmap
      *iv_return = (IV)GLEW_SGIS_generate_mipmap;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_SGIS_texture_filter4", 25)) {
    /*                          ^                    */
#ifdef GLEW_SGIS_texture_filter4
      *iv_return = (IV)GLEW_SGIS_texture_filter4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_SGIX_reference_plane", 25)) {
    /*                          ^                    */
#ifdef GLEW_SGIX_reference_plane
      *iv_return = (IV)GLEW_SGIX_reference_plane;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_SGIX_texture_add_env", 25)) {
    /*                          ^                    */
#ifdef GLEW_SGIX_texture_add_env
      *iv_return = (IV)GLEW_SGIX_texture_add_env;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_AMD_conservative_depth", 25)) {
    /*                          ^                    */
#ifdef GL_AMD_conservative_depth
      *iv_return = (IV)GL_AMD_conservative_depth;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_conservative_depth", 25)) {
    /*                          ^                    */
#ifdef GL_ARB_conservative_depth
      *iv_return = (IV)GL_ARB_conservative_depth;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_framebuffer_object", 25)) {
    /*                          ^                    */
#ifdef GL_ARB_framebuffer_object
      *iv_return = (IV)GL_ARB_framebuffer_object;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_shader_texture_lod", 25)) {
    /*                          ^                    */
#ifdef GL_ARB_shader_texture_lod
      *iv_return = (IV)GL_ARB_shader_texture_lod;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ATI_shader_texture_lod", 25)) {
    /*                          ^                    */
#ifdef GL_ATI_shader_texture_lod
      *iv_return = (IV)GL_ATI_shader_texture_lod;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_framebuffer_object", 25)) {
    /*                          ^                    */
#ifdef GL_EXT_framebuffer_object
      *iv_return = (IV)GL_EXT_framebuffer_object;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_raster_multisample", 25)) {
    /*                          ^                    */
#ifdef GL_EXT_raster_multisample
      *iv_return = (IV)GL_EXT_raster_multisample;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_shader_integer_mix", 25)) {
    /*                          ^                    */
#ifdef GL_EXT_shader_integer_mix
      *iv_return = (IV)GL_EXT_shader_integer_mix;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_IBM_vertex_array_lists", 25)) {
    /*                          ^                    */
#ifdef GL_IBM_vertex_array_lists
      *iv_return = (IV)GL_IBM_vertex_array_lists;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'f':
    if (memEQ(name, "GL_NV_transform_feedback2", 25)) {
    /*                          ^                    */
#ifdef GL_NV_transform_feedback2
      *iv_return = (IV)GL_NV_transform_feedback2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'g':
    if (memEQ(name, "GLEW_NV_fragment_program2", 25)) {
    /*                          ^                    */
#ifdef GLEW_NV_fragment_program2
      *iv_return = (IV)GLEW_NV_fragment_program2;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_NV_fragment_program4", 25)) {
    /*                          ^                    */
#ifdef GLEW_NV_fragment_program4
      *iv_return = (IV)GLEW_NV_fragment_program4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_NV_texgen_reflection", 25)) {
    /*                          ^                    */
#ifdef GLEW_NV_texgen_reflection
      *iv_return = (IV)GLEW_NV_texgen_reflection;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'h':
    if (memEQ(name, "GLEW_ARB_enhanced_layouts", 25)) {
    /*                          ^                    */
#ifdef GLEW_ARB_enhanced_layouts
      *iv_return = (IV)GLEW_ARB_enhanced_layouts;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_SGIS_sharpen_texture", 25)) {
    /*                          ^                    */
#ifdef GLEW_SGIS_sharpen_texture
      *iv_return = (IV)GLEW_SGIS_sharpen_texture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_depth_buffer_float", 25)) {
    /*                          ^                    */
#ifdef GL_ARB_depth_buffer_float
      *iv_return = (IV)GL_ARB_depth_buffer_float;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'i':
    if (memEQ(name, "GLEW_ARB_point_parameters", 25)) {
    /*                          ^                    */
#ifdef GLEW_ARB_point_parameters
      *iv_return = (IV)GLEW_ARB_point_parameters;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_EXT_clip_volume_hint", 25)) {
    /*                          ^                    */
#ifdef GLEW_EXT_clip_volume_hint
      *iv_return = (IV)GLEW_EXT_clip_volume_hint;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_EXT_point_parameters", 25)) {
    /*                          ^                    */
#ifdef GLEW_EXT_point_parameters
      *iv_return = (IV)GLEW_EXT_point_parameters;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NVX_conditional_render", 25)) {
    /*                          ^                    */
#ifdef GL_NVX_conditional_render
      *iv_return = (IV)GL_NVX_conditional_render;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'j':
    if (memEQ(name, "GL_APPLE_object_purgeable", 25)) {
    /*                          ^                    */
#ifdef GL_APPLE_object_purgeable
      *iv_return = (IV)GL_APPLE_object_purgeable;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'l':
    if (memEQ(name, "GLEW_ARB_half_float_pixel", 25)) {
    /*                          ^                    */
#ifdef GLEW_ARB_half_float_pixel
      *iv_return = (IV)GLEW_ARB_half_float_pixel;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_EXT_paletted_texture", 25)) {
    /*                          ^                    */
#ifdef GLEW_EXT_paletted_texture
      *iv_return = (IV)GLEW_EXT_paletted_texture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_invalidate_subdata", 25)) {
    /*                          ^                    */
#ifdef GL_ARB_invalidate_subdata
      *iv_return = (IV)GL_ARB_invalidate_subdata;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'm':
    if (memEQ(name, "GLEW_AMD_sample_positions", 25)) {
    /*                          ^                    */
#ifdef GLEW_AMD_sample_positions
      *iv_return = (IV)GLEW_AMD_sample_positions;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_ARB_sample_locations", 25)) {
    /*                          ^                    */
#ifdef GLEW_ARB_sample_locations
      *iv_return = (IV)GLEW_ARB_sample_locations;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_NV_geometry_program4", 25)) {
    /*                          ^                    */
#ifdef GLEW_NV_geometry_program4
      *iv_return = (IV)GLEW_NV_geometry_program4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_NV_primitive_restart", 25)) {
    /*                          ^                    */
#ifdef GLEW_NV_primitive_restart
      *iv_return = (IV)GLEW_NV_primitive_restart;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'n':
    if (memEQ(name, "GLEW_ARB_bindless_texture", 25)) {
    /*                          ^                    */
#ifdef GLEW_ARB_bindless_texture
      *iv_return = (IV)GLEW_ARB_bindless_texture;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_EXT_bindable_uniform", 25)) {
    /*                          ^                    */
#ifdef GLEW_EXT_bindable_uniform
      *iv_return = (IV)GLEW_EXT_bindable_uniform;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_OES_single_precision", 25)) {
    /*                          ^                    */
#ifdef GLEW_OES_single_precision
      *iv_return = (IV)GLEW_OES_single_precision;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_SGIS_point_line_texgen", 25)) {
    /*                          ^                    */
#ifdef GL_SGIS_point_line_texgen
      *iv_return = (IV)GL_SGIS_point_line_texgen;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'o':
    if (memEQ(name, "GLEW_ARB_geometry_shader4", 25)) {
    /*                          ^                    */
#ifdef GLEW_ARB_geometry_shader4
      *iv_return = (IV)GLEW_ARB_geometry_shader4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_ARB_provoking_vertex", 25)) {
    /*                          ^                    */
#ifdef GLEW_ARB_provoking_vertex
      *iv_return = (IV)GLEW_ARB_provoking_vertex;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_EXT_coordinate_frame", 25)) {
    /*                          ^                    */
#ifdef GLEW_EXT_coordinate_frame
      *iv_return = (IV)GLEW_EXT_coordinate_frame;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_EXT_geometry_shader4", 25)) {
    /*                          ^                    */
#ifdef GLEW_EXT_geometry_shader4
      *iv_return = (IV)GLEW_EXT_geometry_shader4;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_EXT_provoking_vertex", 25)) {
    /*                          ^                    */
#ifdef GLEW_EXT_provoking_vertex
      *iv_return = (IV)GLEW_EXT_provoking_vertex;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'p':
    if (memEQ(name, "GLEW_ANGLE_program_binary", 25)) {
    /*                          ^                    */
#ifdef GLEW_ANGLE_program_binary
      *iv_return = (IV)GLEW_ANGLE_program_binary;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_ARB_map_buffer_range", 25)) {
    /*                          ^                    */
#ifdef GLEW_ARB_map_buffer_range
      *iv_return = (IV)GLEW_ARB_map_buffer_range;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_ATI_separate_stencil", 25)) {
    /*                          ^                    */
#ifdef GLEW_ATI_separate_stencil
      *iv_return = (IV)GLEW_ATI_separate_stencil;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_get_program_binary", 25)) {
    /*                          ^                    */
#ifdef GL_ARB_get_program_binary
      *iv_return = (IV)GL_ARB_get_program_binary;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 'r':
    if (memEQ(name, "GLEW_ARB_arrays_of_arrays", 25)) {
    /*                          ^                    */
#ifdef GLEW_ARB_arrays_of_arrays
      *iv_return = (IV)GLEW_ARB_arrays_of_arrays;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_EXT_vertex_weighting", 25)) {
    /*                          ^                    */
#ifdef GLEW_EXT_vertex_weighting
      *iv_return = (IV)GLEW_EXT_vertex_weighting;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ARB_color_buffer_float", 25)) {
    /*                          ^                    */
#ifdef GL_ARB_color_buffer_float
      *iv_return = (IV)GL_ARB_color_buffer_float;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_conservative_raster", 25)) {
    /*                          ^                    */
#ifdef GL_NV_conservative_raster
      *iv_return = (IV)GL_NV_conservative_raster;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_shader_atomic_float", 25)) {
    /*                          ^                    */
#ifdef GL_NV_shader_atomic_float
      *iv_return = (IV)GL_NV_shader_atomic_float;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_shader_atomic_int64", 25)) {
    /*                          ^                    */
#ifdef GL_NV_shader_atomic_int64
      *iv_return = (IV)GL_NV_shader_atomic_int64;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_shader_thread_group", 25)) {
    /*                          ^                    */
#ifdef GL_NV_shader_thread_group
      *iv_return = (IV)GL_NV_shader_thread_group;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_NV_texture_multisample", 25)) {
    /*                          ^                    */
#ifdef GL_NV_texture_multisample
      *iv_return = (IV)GL_NV_texture_multisample;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    break;
  case 's':
    if (memEQ(name, "GLEW_ARB_instanced_arrays", 25)) {
    /*                          ^                    */
#ifdef GLEW_ARB_instanced_arrays
      *iv_return = (IV)GLEW_ARB_instanced_arrays;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GLEW_SGIX_async_histogram", 25)) {
    /*                          ^                    */
#ifdef GLEW_SGIX_async_histogram
      *iv_return = (IV)GLEW_SGIX_async_histogram;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_ANGLE_instanced_arrays", 25)) {
    /*                          ^                    */
#ifdef GL_ANGLE_instanced_arrays
      *iv_return = (IV)GL_ANGLE_instanced_arrays;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOTDEF;
#endif
    }
    if (memEQ(name, "GL_EXT_transform_feedback", 25)) {
    /*                          ^                    */
#ifdef GL_EXT_transform_feedback
      *iv_return = (IV)GL_EXT_transform_feedback;
      return PERL_constant_ISUV;
#else
      return PERL_constant_NOT