#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#include "ppport.h"

#ifdef newXS
	#undef newXS
	#define newXS ;
#endif

MODULE = P5NCI  PACKAGE = P5NCI

void *
nci_pp( c_func, p0 )
	SV* c_func
	void * p0
PREINIT:
	void *(*func)(void *);
CODE:
	func   = INT2PTR(void *(*)(void *), SvIV(c_func) );
	RETVAL = (*func)(p0);
OUTPUT:
	RETVAL

void
nci_vp( c_func, p0 )
	SV* c_func
	void * p0
PREINIT:
	void(*func)(void *);
CODE:
	func   = INT2PTR(void(*)(void *), SvIV(c_func) );
	(*func)(p0);

double
nci_dp( c_func, p0 )
	SV* c_func
	void * p0
PREINIT:
	double(*func)(void *);
CODE:
	func   = INT2PTR(double(*)(void *), SvIV(c_func) );
	RETVAL = (*func)(p0);
OUTPUT:
	RETVAL

short
nci_sp( c_func, p0 )
	SV* c_func
	void * p0
PREINIT:
	short(*func)(void *);
CODE:
	func   = INT2PTR(short(*)(void *), SvIV(c_func) );
	RETVAL = (*func)(p0);
OUTPUT:
	RETVAL

float
nci_fp( c_func, p0 )
	SV* c_func
	void * p0
PREINIT:
	float(*func)(void *);
CODE:
	func   = INT2PTR(float(*)(void *), SvIV(c_func) );
	RETVAL = (*func)(p0);
OUTPUT:
	RETVAL

char *
nci_tp( c_func, p0 )
	SV* c_func
	void * p0
PREINIT:
	char *(*func)(void *);
CODE:
	func   = INT2PTR(char *(*)(void *), SvIV(c_func) );
	RETVAL = (*func)(p0);
OUTPUT:
	RETVAL

int
nci_ip( c_func, p0 )
	SV* c_func
	void * p0
PREINIT:
	int(*func)(void *);
CODE:
	func   = INT2PTR(int(*)(void *), SvIV(c_func) );
	RETVAL = (*func)(p0);
OUTPUT:
	RETVAL

void *
nci_pv( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vv( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dv( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_sv( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fv( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tv( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_iv( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pd( c_func, d0 )
	SV* c_func
	double d0
PREINIT:
	void *(*func)(double);
CODE:
	func   = INT2PTR(void *(*)(double), SvIV(c_func) );
	RETVAL = (*func)(d0);
OUTPUT:
	RETVAL

void
nci_vd( c_func, d0 )
	SV* c_func
	double d0
PREINIT:
	void(*func)(double);
CODE:
	func   = INT2PTR(void(*)(double), SvIV(c_func) );
	(*func)(d0);

double
nci_dd( c_func, d0 )
	SV* c_func
	double d0
PREINIT:
	double(*func)(double);
CODE:
	func   = INT2PTR(double(*)(double), SvIV(c_func) );
	RETVAL = (*func)(d0);
OUTPUT:
	RETVAL

short
nci_sd( c_func, d0 )
	SV* c_func
	double d0
PREINIT:
	short(*func)(double);
CODE:
	func   = INT2PTR(short(*)(double), SvIV(c_func) );
	RETVAL = (*func)(d0);
OUTPUT:
	RETVAL

float
nci_fd( c_func, d0 )
	SV* c_func
	double d0
PREINIT:
	float(*func)(double);
CODE:
	func   = INT2PTR(float(*)(double), SvIV(c_func) );
	RETVAL = (*func)(d0);
OUTPUT:
	RETVAL

char *
nci_td( c_func, d0 )
	SV* c_func
	double d0
PREINIT:
	char *(*func)(double);
CODE:
	func   = INT2PTR(char *(*)(double), SvIV(c_func) );
	RETVAL = (*func)(d0);
OUTPUT:
	RETVAL

int
nci_id( c_func, d0 )
	SV* c_func
	double d0
PREINIT:
	int(*func)(double);
CODE:
	func   = INT2PTR(int(*)(double), SvIV(c_func) );
	RETVAL = (*func)(d0);
OUTPUT:
	RETVAL

void *
nci_ps( c_func, s0 )
	SV* c_func
	short s0
PREINIT:
	void *(*func)(short);
CODE:
	func   = INT2PTR(void *(*)(short), SvIV(c_func) );
	RETVAL = (*func)(s0);
OUTPUT:
	RETVAL

void
nci_vs( c_func, s0 )
	SV* c_func
	short s0
PREINIT:
	void(*func)(short);
CODE:
	func   = INT2PTR(void(*)(short), SvIV(c_func) );
	(*func)(s0);

double
nci_ds( c_func, s0 )
	SV* c_func
	short s0
PREINIT:
	double(*func)(short);
CODE:
	func   = INT2PTR(double(*)(short), SvIV(c_func) );
	RETVAL = (*func)(s0);
OUTPUT:
	RETVAL

short
nci_ss( c_func, s0 )
	SV* c_func
	short s0
PREINIT:
	short(*func)(short);
CODE:
	func   = INT2PTR(short(*)(short), SvIV(c_func) );
	RETVAL = (*func)(s0);
OUTPUT:
	RETVAL

float
nci_fs( c_func, s0 )
	SV* c_func
	short s0
PREINIT:
	float(*func)(short);
CODE:
	func   = INT2PTR(float(*)(short), SvIV(c_func) );
	RETVAL = (*func)(s0);
OUTPUT:
	RETVAL

char *
nci_ts( c_func, s0 )
	SV* c_func
	short s0
PREINIT:
	char *(*func)(short);
CODE:
	func   = INT2PTR(char *(*)(short), SvIV(c_func) );
	RETVAL = (*func)(s0);
OUTPUT:
	RETVAL

int
nci_is( c_func, s0 )
	SV* c_func
	short s0
PREINIT:
	int(*func)(short);
CODE:
	func   = INT2PTR(int(*)(short), SvIV(c_func) );
	RETVAL = (*func)(s0);
OUTPUT:
	RETVAL

void *
nci_pf( c_func, f0 )
	SV* c_func
	float f0
PREINIT:
	void *(*func)(float);
CODE:
	func   = INT2PTR(void *(*)(float), SvIV(c_func) );
	RETVAL = (*func)(f0);
OUTPUT:
	RETVAL

void
nci_vf( c_func, f0 )
	SV* c_func
	float f0
PREINIT:
	void(*func)(float);
CODE:
	func   = INT2PTR(void(*)(float), SvIV(c_func) );
	(*func)(f0);

double
nci_df( c_func, f0 )
	SV* c_func
	float f0
PREINIT:
	double(*func)(float);
CODE:
	func   = INT2PTR(double(*)(float), SvIV(c_func) );
	RETVAL = (*func)(f0);
OUTPUT:
	RETVAL

short
nci_sf( c_func, f0 )
	SV* c_func
	float f0
PREINIT:
	short(*func)(float);
CODE:
	func   = INT2PTR(short(*)(float), SvIV(c_func) );
	RETVAL = (*func)(f0);
OUTPUT:
	RETVAL

float
nci_ff( c_func, f0 )
	SV* c_func
	float f0
PREINIT:
	float(*func)(float);
CODE:
	func   = INT2PTR(float(*)(float), SvIV(c_func) );
	RETVAL = (*func)(f0);
OUTPUT:
	RETVAL

char *
nci_tf( c_func, f0 )
	SV* c_func
	float f0
PREINIT:
	char *(*func)(float);
CODE:
	func   = INT2PTR(char *(*)(float), SvIV(c_func) );
	RETVAL = (*func)(f0);
OUTPUT:
	RETVAL

int
nci_if( c_func, f0 )
	SV* c_func
	float f0
PREINIT:
	int(*func)(float);
CODE:
	func   = INT2PTR(int(*)(float), SvIV(c_func) );
	RETVAL = (*func)(f0);
OUTPUT:
	RETVAL

void *
nci_pt( c_func, t0 )
	SV* c_func
	char * t0
PREINIT:
	void *(*func)(char *);
CODE:
	func   = INT2PTR(void *(*)(char *), SvIV(c_func) );
	RETVAL = (*func)(t0);
OUTPUT:
	RETVAL

void
nci_vt( c_func, t0 )
	SV* c_func
	char * t0
PREINIT:
	void(*func)(char *);
CODE:
	func   = INT2PTR(void(*)(char *), SvIV(c_func) );
	(*func)(t0);

double
nci_dt( c_func, t0 )
	SV* c_func
	char * t0
PREINIT:
	double(*func)(char *);
CODE:
	func   = INT2PTR(double(*)(char *), SvIV(c_func) );
	RETVAL = (*func)(t0);
OUTPUT:
	RETVAL

short
nci_st( c_func, t0 )
	SV* c_func
	char * t0
PREINIT:
	short(*func)(char *);
CODE:
	func   = INT2PTR(short(*)(char *), SvIV(c_func) );
	RETVAL = (*func)(t0);
OUTPUT:
	RETVAL

float
nci_ft( c_func, t0 )
	SV* c_func
	char * t0
PREINIT:
	float(*func)(char *);
CODE:
	func   = INT2PTR(float(*)(char *), SvIV(c_func) );
	RETVAL = (*func)(t0);
OUTPUT:
	RETVAL

char *
nci_tt( c_func, t0 )
	SV* c_func
	char * t0
PREINIT:
	char *(*func)(char *);
CODE:
	func   = INT2PTR(char *(*)(char *), SvIV(c_func) );
	RETVAL = (*func)(t0);
OUTPUT:
	RETVAL

int
nci_it( c_func, t0 )
	SV* c_func
	char * t0
PREINIT:
	int(*func)(char *);
CODE:
	func   = INT2PTR(int(*)(char *), SvIV(c_func) );
	RETVAL = (*func)(t0);
OUTPUT:
	RETVAL

void *
nci_pi( c_func, i0 )
	SV* c_func
	int i0
PREINIT:
	void *(*func)(int);
CODE:
	func   = INT2PTR(void *(*)(int), SvIV(c_func) );
	RETVAL = (*func)(i0);
OUTPUT:
	RETVAL

void
nci_vi( c_func, i0 )
	SV* c_func
	int i0
PREINIT:
	void(*func)(int);
CODE:
	func   = INT2PTR(void(*)(int), SvIV(c_func) );
	(*func)(i0);

double
nci_di( c_func, i0 )
	SV* c_func
	int i0
PREINIT:
	double(*func)(int);
CODE:
	func   = INT2PTR(double(*)(int), SvIV(c_func) );
	RETVAL = (*func)(i0);
OUTPUT:
	RETVAL

short
nci_si( c_func, i0 )
	SV* c_func
	int i0
PREINIT:
	short(*func)(int);
CODE:
	func   = INT2PTR(short(*)(int), SvIV(c_func) );
	RETVAL = (*func)(i0);
OUTPUT:
	RETVAL

float
nci_fi( c_func, i0 )
	SV* c_func
	int i0
PREINIT:
	float(*func)(int);
CODE:
	func   = INT2PTR(float(*)(int), SvIV(c_func) );
	RETVAL = (*func)(i0);
OUTPUT:
	RETVAL

char *
nci_ti( c_func, i0 )
	SV* c_func
	int i0
PREINIT:
	char *(*func)(int);
CODE:
	func   = INT2PTR(char *(*)(int), SvIV(c_func) );
	RETVAL = (*func)(i0);
OUTPUT:
	RETVAL

int
nci_ii( c_func, i0 )
	SV* c_func
	int i0
PREINIT:
	int(*func)(int);
CODE:
	func   = INT2PTR(int(*)(int), SvIV(c_func) );
	RETVAL = (*func)(i0);
OUTPUT:
	RETVAL

void *
nci_ppp( c_func, p0, p1 )
	SV* c_func
	void * p0
	void * p1
PREINIT:
	void *(*func)(void *, void *);
CODE:
	func   = INT2PTR(void *(*)(void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1);
OUTPUT:
	RETVAL

void
nci_vpp( c_func, p0, p1 )
	SV* c_func
	void * p0
	void * p1
PREINIT:
	void(*func)(void *, void *);
CODE:
	func   = INT2PTR(void(*)(void *, void *), SvIV(c_func) );
	(*func)(p0, p1);

double
nci_dpp( c_func, p0, p1 )
	SV* c_func
	void * p0
	void * p1
PREINIT:
	double(*func)(void *, void *);
CODE:
	func   = INT2PTR(double(*)(void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1);
OUTPUT:
	RETVAL

short
nci_spp( c_func, p0, p1 )
	SV* c_func
	void * p0
	void * p1
PREINIT:
	short(*func)(void *, void *);
CODE:
	func   = INT2PTR(short(*)(void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1);
OUTPUT:
	RETVAL

float
nci_fpp( c_func, p0, p1 )
	SV* c_func
	void * p0
	void * p1
PREINIT:
	float(*func)(void *, void *);
CODE:
	func   = INT2PTR(float(*)(void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1);
OUTPUT:
	RETVAL

char *
nci_tpp( c_func, p0, p1 )
	SV* c_func
	void * p0
	void * p1
PREINIT:
	char *(*func)(void *, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1);
OUTPUT:
	RETVAL

int
nci_ipp( c_func, p0, p1 )
	SV* c_func
	void * p0
	void * p1
PREINIT:
	int(*func)(void *, void *);
CODE:
	func   = INT2PTR(int(*)(void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1);
OUTPUT:
	RETVAL

void *
nci_pvp( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvp( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvp( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svp( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvp( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvp( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivp( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdp( c_func, d0, p1 )
	SV* c_func
	double d0
	void * p1
PREINIT:
	void *(*func)(double, void *);
CODE:
	func   = INT2PTR(void *(*)(double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1);
OUTPUT:
	RETVAL

void
nci_vdp( c_func, d0, p1 )
	SV* c_func
	double d0
	void * p1
PREINIT:
	void(*func)(double, void *);
CODE:
	func   = INT2PTR(void(*)(double, void *), SvIV(c_func) );
	(*func)(d0, p1);

double
nci_ddp( c_func, d0, p1 )
	SV* c_func
	double d0
	void * p1
PREINIT:
	double(*func)(double, void *);
CODE:
	func   = INT2PTR(double(*)(double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1);
OUTPUT:
	RETVAL

short
nci_sdp( c_func, d0, p1 )
	SV* c_func
	double d0
	void * p1
PREINIT:
	short(*func)(double, void *);
CODE:
	func   = INT2PTR(short(*)(double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1);
OUTPUT:
	RETVAL

float
nci_fdp( c_func, d0, p1 )
	SV* c_func
	double d0
	void * p1
PREINIT:
	float(*func)(double, void *);
CODE:
	func   = INT2PTR(float(*)(double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1);
OUTPUT:
	RETVAL

char *
nci_tdp( c_func, d0, p1 )
	SV* c_func
	double d0
	void * p1
PREINIT:
	char *(*func)(double, void *);
CODE:
	func   = INT2PTR(char *(*)(double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1);
OUTPUT:
	RETVAL

int
nci_idp( c_func, d0, p1 )
	SV* c_func
	double d0
	void * p1
PREINIT:
	int(*func)(double, void *);
CODE:
	func   = INT2PTR(int(*)(double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1);
OUTPUT:
	RETVAL

void *
nci_psp( c_func, s0, p1 )
	SV* c_func
	short s0
	void * p1
PREINIT:
	void *(*func)(short, void *);
CODE:
	func   = INT2PTR(void *(*)(short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1);
OUTPUT:
	RETVAL

void
nci_vsp( c_func, s0, p1 )
	SV* c_func
	short s0
	void * p1
PREINIT:
	void(*func)(short, void *);
CODE:
	func   = INT2PTR(void(*)(short, void *), SvIV(c_func) );
	(*func)(s0, p1);

double
nci_dsp( c_func, s0, p1 )
	SV* c_func
	short s0
	void * p1
PREINIT:
	double(*func)(short, void *);
CODE:
	func   = INT2PTR(double(*)(short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1);
OUTPUT:
	RETVAL

short
nci_ssp( c_func, s0, p1 )
	SV* c_func
	short s0
	void * p1
PREINIT:
	short(*func)(short, void *);
CODE:
	func   = INT2PTR(short(*)(short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1);
OUTPUT:
	RETVAL

float
nci_fsp( c_func, s0, p1 )
	SV* c_func
	short s0
	void * p1
PREINIT:
	float(*func)(short, void *);
CODE:
	func   = INT2PTR(float(*)(short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1);
OUTPUT:
	RETVAL

char *
nci_tsp( c_func, s0, p1 )
	SV* c_func
	short s0
	void * p1
PREINIT:
	char *(*func)(short, void *);
CODE:
	func   = INT2PTR(char *(*)(short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1);
OUTPUT:
	RETVAL

int
nci_isp( c_func, s0, p1 )
	SV* c_func
	short s0
	void * p1
PREINIT:
	int(*func)(short, void *);
CODE:
	func   = INT2PTR(int(*)(short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1);
OUTPUT:
	RETVAL

void *
nci_pfp( c_func, f0, p1 )
	SV* c_func
	float f0
	void * p1
PREINIT:
	void *(*func)(float, void *);
CODE:
	func   = INT2PTR(void *(*)(float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1);
OUTPUT:
	RETVAL

void
nci_vfp( c_func, f0, p1 )
	SV* c_func
	float f0
	void * p1
PREINIT:
	void(*func)(float, void *);
CODE:
	func   = INT2PTR(void(*)(float, void *), SvIV(c_func) );
	(*func)(f0, p1);

double
nci_dfp( c_func, f0, p1 )
	SV* c_func
	float f0
	void * p1
PREINIT:
	double(*func)(float, void *);
CODE:
	func   = INT2PTR(double(*)(float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1);
OUTPUT:
	RETVAL

short
nci_sfp( c_func, f0, p1 )
	SV* c_func
	float f0
	void * p1
PREINIT:
	short(*func)(float, void *);
CODE:
	func   = INT2PTR(short(*)(float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1);
OUTPUT:
	RETVAL

float
nci_ffp( c_func, f0, p1 )
	SV* c_func
	float f0
	void * p1
PREINIT:
	float(*func)(float, void *);
CODE:
	func   = INT2PTR(float(*)(float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1);
OUTPUT:
	RETVAL

char *
nci_tfp( c_func, f0, p1 )
	SV* c_func
	float f0
	void * p1
PREINIT:
	char *(*func)(float, void *);
CODE:
	func   = INT2PTR(char *(*)(float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1);
OUTPUT:
	RETVAL

int
nci_ifp( c_func, f0, p1 )
	SV* c_func
	float f0
	void * p1
PREINIT:
	int(*func)(float, void *);
CODE:
	func   = INT2PTR(int(*)(float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1);
OUTPUT:
	RETVAL

void *
nci_ptp( c_func, t0, p1 )
	SV* c_func
	char * t0
	void * p1
PREINIT:
	void *(*func)(char *, void *);
CODE:
	func   = INT2PTR(void *(*)(char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1);
OUTPUT:
	RETVAL

void
nci_vtp( c_func, t0, p1 )
	SV* c_func
	char * t0
	void * p1
PREINIT:
	void(*func)(char *, void *);
CODE:
	func   = INT2PTR(void(*)(char *, void *), SvIV(c_func) );
	(*func)(t0, p1);

double
nci_dtp( c_func, t0, p1 )
	SV* c_func
	char * t0
	void * p1
PREINIT:
	double(*func)(char *, void *);
CODE:
	func   = INT2PTR(double(*)(char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1);
OUTPUT:
	RETVAL

short
nci_stp( c_func, t0, p1 )
	SV* c_func
	char * t0
	void * p1
PREINIT:
	short(*func)(char *, void *);
CODE:
	func   = INT2PTR(short(*)(char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1);
OUTPUT:
	RETVAL

float
nci_ftp( c_func, t0, p1 )
	SV* c_func
	char * t0
	void * p1
PREINIT:
	float(*func)(char *, void *);
CODE:
	func   = INT2PTR(float(*)(char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1);
OUTPUT:
	RETVAL

char *
nci_ttp( c_func, t0, p1 )
	SV* c_func
	char * t0
	void * p1
PREINIT:
	char *(*func)(char *, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1);
OUTPUT:
	RETVAL

int
nci_itp( c_func, t0, p1 )
	SV* c_func
	char * t0
	void * p1
PREINIT:
	int(*func)(char *, void *);
CODE:
	func   = INT2PTR(int(*)(char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1);
OUTPUT:
	RETVAL

void *
nci_pip( c_func, i0, p1 )
	SV* c_func
	int i0
	void * p1
PREINIT:
	void *(*func)(int, void *);
CODE:
	func   = INT2PTR(void *(*)(int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1);
OUTPUT:
	RETVAL

void
nci_vip( c_func, i0, p1 )
	SV* c_func
	int i0
	void * p1
PREINIT:
	void(*func)(int, void *);
CODE:
	func   = INT2PTR(void(*)(int, void *), SvIV(c_func) );
	(*func)(i0, p1);

double
nci_dip( c_func, i0, p1 )
	SV* c_func
	int i0
	void * p1
PREINIT:
	double(*func)(int, void *);
CODE:
	func   = INT2PTR(double(*)(int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1);
OUTPUT:
	RETVAL

short
nci_sip( c_func, i0, p1 )
	SV* c_func
	int i0
	void * p1
PREINIT:
	short(*func)(int, void *);
CODE:
	func   = INT2PTR(short(*)(int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1);
OUTPUT:
	RETVAL

float
nci_fip( c_func, i0, p1 )
	SV* c_func
	int i0
	void * p1
PREINIT:
	float(*func)(int, void *);
CODE:
	func   = INT2PTR(float(*)(int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1);
OUTPUT:
	RETVAL

char *
nci_tip( c_func, i0, p1 )
	SV* c_func
	int i0
	void * p1
PREINIT:
	char *(*func)(int, void *);
CODE:
	func   = INT2PTR(char *(*)(int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1);
OUTPUT:
	RETVAL

int
nci_iip( c_func, i0, p1 )
	SV* c_func
	int i0
	void * p1
PREINIT:
	int(*func)(int, void *);
CODE:
	func   = INT2PTR(int(*)(int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1);
OUTPUT:
	RETVAL

void *
nci_ppd( c_func, p0, d1 )
	SV* c_func
	void * p0
	double d1
PREINIT:
	void *(*func)(void *, double);
CODE:
	func   = INT2PTR(void *(*)(void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, d1);
OUTPUT:
	RETVAL

void
nci_vpd( c_func, p0, d1 )
	SV* c_func
	void * p0
	double d1
PREINIT:
	void(*func)(void *, double);
CODE:
	func   = INT2PTR(void(*)(void *, double), SvIV(c_func) );
	(*func)(p0, d1);

double
nci_dpd( c_func, p0, d1 )
	SV* c_func
	void * p0
	double d1
PREINIT:
	double(*func)(void *, double);
CODE:
	func   = INT2PTR(double(*)(void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, d1);
OUTPUT:
	RETVAL

short
nci_spd( c_func, p0, d1 )
	SV* c_func
	void * p0
	double d1
PREINIT:
	short(*func)(void *, double);
CODE:
	func   = INT2PTR(short(*)(void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, d1);
OUTPUT:
	RETVAL

float
nci_fpd( c_func, p0, d1 )
	SV* c_func
	void * p0
	double d1
PREINIT:
	float(*func)(void *, double);
CODE:
	func   = INT2PTR(float(*)(void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, d1);
OUTPUT:
	RETVAL

char *
nci_tpd( c_func, p0, d1 )
	SV* c_func
	void * p0
	double d1
PREINIT:
	char *(*func)(void *, double);
CODE:
	func   = INT2PTR(char *(*)(void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, d1);
OUTPUT:
	RETVAL

int
nci_ipd( c_func, p0, d1 )
	SV* c_func
	void * p0
	double d1
PREINIT:
	int(*func)(void *, double);
CODE:
	func   = INT2PTR(int(*)(void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, d1);
OUTPUT:
	RETVAL

void *
nci_pvd( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvd( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvd( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svd( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvd( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvd( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivd( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdd( c_func, d0, d1 )
	SV* c_func
	double d0
	double d1
PREINIT:
	void *(*func)(double, double);
CODE:
	func   = INT2PTR(void *(*)(double, double), SvIV(c_func) );
	RETVAL = (*func)(d0, d1);
OUTPUT:
	RETVAL

void
nci_vdd( c_func, d0, d1 )
	SV* c_func
	double d0
	double d1
PREINIT:
	void(*func)(double, double);
CODE:
	func   = INT2PTR(void(*)(double, double), SvIV(c_func) );
	(*func)(d0, d1);

double
nci_ddd( c_func, d0, d1 )
	SV* c_func
	double d0
	double d1
PREINIT:
	double(*func)(double, double);
CODE:
	func   = INT2PTR(double(*)(double, double), SvIV(c_func) );
	RETVAL = (*func)(d0, d1);
OUTPUT:
	RETVAL

short
nci_sdd( c_func, d0, d1 )
	SV* c_func
	double d0
	double d1
PREINIT:
	short(*func)(double, double);
CODE:
	func   = INT2PTR(short(*)(double, double), SvIV(c_func) );
	RETVAL = (*func)(d0, d1);
OUTPUT:
	RETVAL

float
nci_fdd( c_func, d0, d1 )
	SV* c_func
	double d0
	double d1
PREINIT:
	float(*func)(double, double);
CODE:
	func   = INT2PTR(float(*)(double, double), SvIV(c_func) );
	RETVAL = (*func)(d0, d1);
OUTPUT:
	RETVAL

char *
nci_tdd( c_func, d0, d1 )
	SV* c_func
	double d0
	double d1
PREINIT:
	char *(*func)(double, double);
CODE:
	func   = INT2PTR(char *(*)(double, double), SvIV(c_func) );
	RETVAL = (*func)(d0, d1);
OUTPUT:
	RETVAL

int
nci_idd( c_func, d0, d1 )
	SV* c_func
	double d0
	double d1
PREINIT:
	int(*func)(double, double);
CODE:
	func   = INT2PTR(int(*)(double, double), SvIV(c_func) );
	RETVAL = (*func)(d0, d1);
OUTPUT:
	RETVAL

void *
nci_psd( c_func, s0, d1 )
	SV* c_func
	short s0
	double d1
PREINIT:
	void *(*func)(short, double);
CODE:
	func   = INT2PTR(void *(*)(short, double), SvIV(c_func) );
	RETVAL = (*func)(s0, d1);
OUTPUT:
	RETVAL

void
nci_vsd( c_func, s0, d1 )
	SV* c_func
	short s0
	double d1
PREINIT:
	void(*func)(short, double);
CODE:
	func   = INT2PTR(void(*)(short, double), SvIV(c_func) );
	(*func)(s0, d1);

double
nci_dsd( c_func, s0, d1 )
	SV* c_func
	short s0
	double d1
PREINIT:
	double(*func)(short, double);
CODE:
	func   = INT2PTR(double(*)(short, double), SvIV(c_func) );
	RETVAL = (*func)(s0, d1);
OUTPUT:
	RETVAL

short
nci_ssd( c_func, s0, d1 )
	SV* c_func
	short s0
	double d1
PREINIT:
	short(*func)(short, double);
CODE:
	func   = INT2PTR(short(*)(short, double), SvIV(c_func) );
	RETVAL = (*func)(s0, d1);
OUTPUT:
	RETVAL

float
nci_fsd( c_func, s0, d1 )
	SV* c_func
	short s0
	double d1
PREINIT:
	float(*func)(short, double);
CODE:
	func   = INT2PTR(float(*)(short, double), SvIV(c_func) );
	RETVAL = (*func)(s0, d1);
OUTPUT:
	RETVAL

char *
nci_tsd( c_func, s0, d1 )
	SV* c_func
	short s0
	double d1
PREINIT:
	char *(*func)(short, double);
CODE:
	func   = INT2PTR(char *(*)(short, double), SvIV(c_func) );
	RETVAL = (*func)(s0, d1);
OUTPUT:
	RETVAL

int
nci_isd( c_func, s0, d1 )
	SV* c_func
	short s0
	double d1
PREINIT:
	int(*func)(short, double);
CODE:
	func   = INT2PTR(int(*)(short, double), SvIV(c_func) );
	RETVAL = (*func)(s0, d1);
OUTPUT:
	RETVAL

void *
nci_pfd( c_func, f0, d1 )
	SV* c_func
	float f0
	double d1
PREINIT:
	void *(*func)(float, double);
CODE:
	func   = INT2PTR(void *(*)(float, double), SvIV(c_func) );
	RETVAL = (*func)(f0, d1);
OUTPUT:
	RETVAL

void
nci_vfd( c_func, f0, d1 )
	SV* c_func
	float f0
	double d1
PREINIT:
	void(*func)(float, double);
CODE:
	func   = INT2PTR(void(*)(float, double), SvIV(c_func) );
	(*func)(f0, d1);

double
nci_dfd( c_func, f0, d1 )
	SV* c_func
	float f0
	double d1
PREINIT:
	double(*func)(float, double);
CODE:
	func   = INT2PTR(double(*)(float, double), SvIV(c_func) );
	RETVAL = (*func)(f0, d1);
OUTPUT:
	RETVAL

short
nci_sfd( c_func, f0, d1 )
	SV* c_func
	float f0
	double d1
PREINIT:
	short(*func)(float, double);
CODE:
	func   = INT2PTR(short(*)(float, double), SvIV(c_func) );
	RETVAL = (*func)(f0, d1);
OUTPUT:
	RETVAL

float
nci_ffd( c_func, f0, d1 )
	SV* c_func
	float f0
	double d1
PREINIT:
	float(*func)(float, double);
CODE:
	func   = INT2PTR(float(*)(float, double), SvIV(c_func) );
	RETVAL = (*func)(f0, d1);
OUTPUT:
	RETVAL

char *
nci_tfd( c_func, f0, d1 )
	SV* c_func
	float f0
	double d1
PREINIT:
	char *(*func)(float, double);
CODE:
	func   = INT2PTR(char *(*)(float, double), SvIV(c_func) );
	RETVAL = (*func)(f0, d1);
OUTPUT:
	RETVAL

int
nci_ifd( c_func, f0, d1 )
	SV* c_func
	float f0
	double d1
PREINIT:
	int(*func)(float, double);
CODE:
	func   = INT2PTR(int(*)(float, double), SvIV(c_func) );
	RETVAL = (*func)(f0, d1);
OUTPUT:
	RETVAL

void *
nci_ptd( c_func, t0, d1 )
	SV* c_func
	char * t0
	double d1
PREINIT:
	void *(*func)(char *, double);
CODE:
	func   = INT2PTR(void *(*)(char *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, d1);
OUTPUT:
	RETVAL

void
nci_vtd( c_func, t0, d1 )
	SV* c_func
	char * t0
	double d1
PREINIT:
	void(*func)(char *, double);
CODE:
	func   = INT2PTR(void(*)(char *, double), SvIV(c_func) );
	(*func)(t0, d1);

double
nci_dtd( c_func, t0, d1 )
	SV* c_func
	char * t0
	double d1
PREINIT:
	double(*func)(char *, double);
CODE:
	func   = INT2PTR(double(*)(char *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, d1);
OUTPUT:
	RETVAL

short
nci_std( c_func, t0, d1 )
	SV* c_func
	char * t0
	double d1
PREINIT:
	short(*func)(char *, double);
CODE:
	func   = INT2PTR(short(*)(char *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, d1);
OUTPUT:
	RETVAL

float
nci_ftd( c_func, t0, d1 )
	SV* c_func
	char * t0
	double d1
PREINIT:
	float(*func)(char *, double);
CODE:
	func   = INT2PTR(float(*)(char *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, d1);
OUTPUT:
	RETVAL

char *
nci_ttd( c_func, t0, d1 )
	SV* c_func
	char * t0
	double d1
PREINIT:
	char *(*func)(char *, double);
CODE:
	func   = INT2PTR(char *(*)(char *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, d1);
OUTPUT:
	RETVAL

int
nci_itd( c_func, t0, d1 )
	SV* c_func
	char * t0
	double d1
PREINIT:
	int(*func)(char *, double);
CODE:
	func   = INT2PTR(int(*)(char *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, d1);
OUTPUT:
	RETVAL

void *
nci_pid( c_func, i0, d1 )
	SV* c_func
	int i0
	double d1
PREINIT:
	void *(*func)(int, double);
CODE:
	func   = INT2PTR(void *(*)(int, double), SvIV(c_func) );
	RETVAL = (*func)(i0, d1);
OUTPUT:
	RETVAL

void
nci_vid( c_func, i0, d1 )
	SV* c_func
	int i0
	double d1
PREINIT:
	void(*func)(int, double);
CODE:
	func   = INT2PTR(void(*)(int, double), SvIV(c_func) );
	(*func)(i0, d1);

double
nci_did( c_func, i0, d1 )
	SV* c_func
	int i0
	double d1
PREINIT:
	double(*func)(int, double);
CODE:
	func   = INT2PTR(double(*)(int, double), SvIV(c_func) );
	RETVAL = (*func)(i0, d1);
OUTPUT:
	RETVAL

short
nci_sid( c_func, i0, d1 )
	SV* c_func
	int i0
	double d1
PREINIT:
	short(*func)(int, double);
CODE:
	func   = INT2PTR(short(*)(int, double), SvIV(c_func) );
	RETVAL = (*func)(i0, d1);
OUTPUT:
	RETVAL

float
nci_fid( c_func, i0, d1 )
	SV* c_func
	int i0
	double d1
PREINIT:
	float(*func)(int, double);
CODE:
	func   = INT2PTR(float(*)(int, double), SvIV(c_func) );
	RETVAL = (*func)(i0, d1);
OUTPUT:
	RETVAL

char *
nci_tid( c_func, i0, d1 )
	SV* c_func
	int i0
	double d1
PREINIT:
	char *(*func)(int, double);
CODE:
	func   = INT2PTR(char *(*)(int, double), SvIV(c_func) );
	RETVAL = (*func)(i0, d1);
OUTPUT:
	RETVAL

int
nci_iid( c_func, i0, d1 )
	SV* c_func
	int i0
	double d1
PREINIT:
	int(*func)(int, double);
CODE:
	func   = INT2PTR(int(*)(int, double), SvIV(c_func) );
	RETVAL = (*func)(i0, d1);
OUTPUT:
	RETVAL

void *
nci_pps( c_func, p0, s1 )
	SV* c_func
	void * p0
	short s1
PREINIT:
	void *(*func)(void *, short);
CODE:
	func   = INT2PTR(void *(*)(void *, short), SvIV(c_func) );
	RETVAL = (*func)(p0, s1);
OUTPUT:
	RETVAL

void
nci_vps( c_func, p0, s1 )
	SV* c_func
	void * p0
	short s1
PREINIT:
	void(*func)(void *, short);
CODE:
	func   = INT2PTR(void(*)(void *, short), SvIV(c_func) );
	(*func)(p0, s1);

double
nci_dps( c_func, p0, s1 )
	SV* c_func
	void * p0
	short s1
PREINIT:
	double(*func)(void *, short);
CODE:
	func   = INT2PTR(double(*)(void *, short), SvIV(c_func) );
	RETVAL = (*func)(p0, s1);
OUTPUT:
	RETVAL

short
nci_sps( c_func, p0, s1 )
	SV* c_func
	void * p0
	short s1
PREINIT:
	short(*func)(void *, short);
CODE:
	func   = INT2PTR(short(*)(void *, short), SvIV(c_func) );
	RETVAL = (*func)(p0, s1);
OUTPUT:
	RETVAL

float
nci_fps( c_func, p0, s1 )
	SV* c_func
	void * p0
	short s1
PREINIT:
	float(*func)(void *, short);
CODE:
	func   = INT2PTR(float(*)(void *, short), SvIV(c_func) );
	RETVAL = (*func)(p0, s1);
OUTPUT:
	RETVAL

char *
nci_tps( c_func, p0, s1 )
	SV* c_func
	void * p0
	short s1
PREINIT:
	char *(*func)(void *, short);
CODE:
	func   = INT2PTR(char *(*)(void *, short), SvIV(c_func) );
	RETVAL = (*func)(p0, s1);
OUTPUT:
	RETVAL

int
nci_ips( c_func, p0, s1 )
	SV* c_func
	void * p0
	short s1
PREINIT:
	int(*func)(void *, short);
CODE:
	func   = INT2PTR(int(*)(void *, short), SvIV(c_func) );
	RETVAL = (*func)(p0, s1);
OUTPUT:
	RETVAL

void *
nci_pvs( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvs( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvs( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svs( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvs( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvs( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivs( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pds( c_func, d0, s1 )
	SV* c_func
	double d0
	short s1
PREINIT:
	void *(*func)(double, short);
CODE:
	func   = INT2PTR(void *(*)(double, short), SvIV(c_func) );
	RETVAL = (*func)(d0, s1);
OUTPUT:
	RETVAL

void
nci_vds( c_func, d0, s1 )
	SV* c_func
	double d0
	short s1
PREINIT:
	void(*func)(double, short);
CODE:
	func   = INT2PTR(void(*)(double, short), SvIV(c_func) );
	(*func)(d0, s1);

double
nci_dds( c_func, d0, s1 )
	SV* c_func
	double d0
	short s1
PREINIT:
	double(*func)(double, short);
CODE:
	func   = INT2PTR(double(*)(double, short), SvIV(c_func) );
	RETVAL = (*func)(d0, s1);
OUTPUT:
	RETVAL

short
nci_sds( c_func, d0, s1 )
	SV* c_func
	double d0
	short s1
PREINIT:
	short(*func)(double, short);
CODE:
	func   = INT2PTR(short(*)(double, short), SvIV(c_func) );
	RETVAL = (*func)(d0, s1);
OUTPUT:
	RETVAL

float
nci_fds( c_func, d0, s1 )
	SV* c_func
	double d0
	short s1
PREINIT:
	float(*func)(double, short);
CODE:
	func   = INT2PTR(float(*)(double, short), SvIV(c_func) );
	RETVAL = (*func)(d0, s1);
OUTPUT:
	RETVAL

char *
nci_tds( c_func, d0, s1 )
	SV* c_func
	double d0
	short s1
PREINIT:
	char *(*func)(double, short);
CODE:
	func   = INT2PTR(char *(*)(double, short), SvIV(c_func) );
	RETVAL = (*func)(d0, s1);
OUTPUT:
	RETVAL

int
nci_ids( c_func, d0, s1 )
	SV* c_func
	double d0
	short s1
PREINIT:
	int(*func)(double, short);
CODE:
	func   = INT2PTR(int(*)(double, short), SvIV(c_func) );
	RETVAL = (*func)(d0, s1);
OUTPUT:
	RETVAL

void *
nci_pss( c_func, s0, s1 )
	SV* c_func
	short s0
	short s1
PREINIT:
	void *(*func)(short, short);
CODE:
	func   = INT2PTR(void *(*)(short, short), SvIV(c_func) );
	RETVAL = (*func)(s0, s1);
OUTPUT:
	RETVAL

void
nci_vss( c_func, s0, s1 )
	SV* c_func
	short s0
	short s1
PREINIT:
	void(*func)(short, short);
CODE:
	func   = INT2PTR(void(*)(short, short), SvIV(c_func) );
	(*func)(s0, s1);

double
nci_dss( c_func, s0, s1 )
	SV* c_func
	short s0
	short s1
PREINIT:
	double(*func)(short, short);
CODE:
	func   = INT2PTR(double(*)(short, short), SvIV(c_func) );
	RETVAL = (*func)(s0, s1);
OUTPUT:
	RETVAL

short
nci_sss( c_func, s0, s1 )
	SV* c_func
	short s0
	short s1
PREINIT:
	short(*func)(short, short);
CODE:
	func   = INT2PTR(short(*)(short, short), SvIV(c_func) );
	RETVAL = (*func)(s0, s1);
OUTPUT:
	RETVAL

float
nci_fss( c_func, s0, s1 )
	SV* c_func
	short s0
	short s1
PREINIT:
	float(*func)(short, short);
CODE:
	func   = INT2PTR(float(*)(short, short), SvIV(c_func) );
	RETVAL = (*func)(s0, s1);
OUTPUT:
	RETVAL

char *
nci_tss( c_func, s0, s1 )
	SV* c_func
	short s0
	short s1
PREINIT:
	char *(*func)(short, short);
CODE:
	func   = INT2PTR(char *(*)(short, short), SvIV(c_func) );
	RETVAL = (*func)(s0, s1);
OUTPUT:
	RETVAL

int
nci_iss( c_func, s0, s1 )
	SV* c_func
	short s0
	short s1
PREINIT:
	int(*func)(short, short);
CODE:
	func   = INT2PTR(int(*)(short, short), SvIV(c_func) );
	RETVAL = (*func)(s0, s1);
OUTPUT:
	RETVAL

void *
nci_pfs( c_func, f0, s1 )
	SV* c_func
	float f0
	short s1
PREINIT:
	void *(*func)(float, short);
CODE:
	func   = INT2PTR(void *(*)(float, short), SvIV(c_func) );
	RETVAL = (*func)(f0, s1);
OUTPUT:
	RETVAL

void
nci_vfs( c_func, f0, s1 )
	SV* c_func
	float f0
	short s1
PREINIT:
	void(*func)(float, short);
CODE:
	func   = INT2PTR(void(*)(float, short), SvIV(c_func) );
	(*func)(f0, s1);

double
nci_dfs( c_func, f0, s1 )
	SV* c_func
	float f0
	short s1
PREINIT:
	double(*func)(float, short);
CODE:
	func   = INT2PTR(double(*)(float, short), SvIV(c_func) );
	RETVAL = (*func)(f0, s1);
OUTPUT:
	RETVAL

short
nci_sfs( c_func, f0, s1 )
	SV* c_func
	float f0
	short s1
PREINIT:
	short(*func)(float, short);
CODE:
	func   = INT2PTR(short(*)(float, short), SvIV(c_func) );
	RETVAL = (*func)(f0, s1);
OUTPUT:
	RETVAL

float
nci_ffs( c_func, f0, s1 )
	SV* c_func
	float f0
	short s1
PREINIT:
	float(*func)(float, short);
CODE:
	func   = INT2PTR(float(*)(float, short), SvIV(c_func) );
	RETVAL = (*func)(f0, s1);
OUTPUT:
	RETVAL

char *
nci_tfs( c_func, f0, s1 )
	SV* c_func
	float f0
	short s1
PREINIT:
	char *(*func)(float, short);
CODE:
	func   = INT2PTR(char *(*)(float, short), SvIV(c_func) );
	RETVAL = (*func)(f0, s1);
OUTPUT:
	RETVAL

int
nci_ifs( c_func, f0, s1 )
	SV* c_func
	float f0
	short s1
PREINIT:
	int(*func)(float, short);
CODE:
	func   = INT2PTR(int(*)(float, short), SvIV(c_func) );
	RETVAL = (*func)(f0, s1);
OUTPUT:
	RETVAL

void *
nci_pts( c_func, t0, s1 )
	SV* c_func
	char * t0
	short s1
PREINIT:
	void *(*func)(char *, short);
CODE:
	func   = INT2PTR(void *(*)(char *, short), SvIV(c_func) );
	RETVAL = (*func)(t0, s1);
OUTPUT:
	RETVAL

void
nci_vts( c_func, t0, s1 )
	SV* c_func
	char * t0
	short s1
PREINIT:
	void(*func)(char *, short);
CODE:
	func   = INT2PTR(void(*)(char *, short), SvIV(c_func) );
	(*func)(t0, s1);

double
nci_dts( c_func, t0, s1 )
	SV* c_func
	char * t0
	short s1
PREINIT:
	double(*func)(char *, short);
CODE:
	func   = INT2PTR(double(*)(char *, short), SvIV(c_func) );
	RETVAL = (*func)(t0, s1);
OUTPUT:
	RETVAL

short
nci_sts( c_func, t0, s1 )
	SV* c_func
	char * t0
	short s1
PREINIT:
	short(*func)(char *, short);
CODE:
	func   = INT2PTR(short(*)(char *, short), SvIV(c_func) );
	RETVAL = (*func)(t0, s1);
OUTPUT:
	RETVAL

float
nci_fts( c_func, t0, s1 )
	SV* c_func
	char * t0
	short s1
PREINIT:
	float(*func)(char *, short);
CODE:
	func   = INT2PTR(float(*)(char *, short), SvIV(c_func) );
	RETVAL = (*func)(t0, s1);
OUTPUT:
	RETVAL

char *
nci_tts( c_func, t0, s1 )
	SV* c_func
	char * t0
	short s1
PREINIT:
	char *(*func)(char *, short);
CODE:
	func   = INT2PTR(char *(*)(char *, short), SvIV(c_func) );
	RETVAL = (*func)(t0, s1);
OUTPUT:
	RETVAL

int
nci_its( c_func, t0, s1 )
	SV* c_func
	char * t0
	short s1
PREINIT:
	int(*func)(char *, short);
CODE:
	func   = INT2PTR(int(*)(char *, short), SvIV(c_func) );
	RETVAL = (*func)(t0, s1);
OUTPUT:
	RETVAL

void *
nci_pis( c_func, i0, s1 )
	SV* c_func
	int i0
	short s1
PREINIT:
	void *(*func)(int, short);
CODE:
	func   = INT2PTR(void *(*)(int, short), SvIV(c_func) );
	RETVAL = (*func)(i0, s1);
OUTPUT:
	RETVAL

void
nci_vis( c_func, i0, s1 )
	SV* c_func
	int i0
	short s1
PREINIT:
	void(*func)(int, short);
CODE:
	func   = INT2PTR(void(*)(int, short), SvIV(c_func) );
	(*func)(i0, s1);

double
nci_dis( c_func, i0, s1 )
	SV* c_func
	int i0
	short s1
PREINIT:
	double(*func)(int, short);
CODE:
	func   = INT2PTR(double(*)(int, short), SvIV(c_func) );
	RETVAL = (*func)(i0, s1);
OUTPUT:
	RETVAL

short
nci_sis( c_func, i0, s1 )
	SV* c_func
	int i0
	short s1
PREINIT:
	short(*func)(int, short);
CODE:
	func   = INT2PTR(short(*)(int, short), SvIV(c_func) );
	RETVAL = (*func)(i0, s1);
OUTPUT:
	RETVAL

float
nci_fis( c_func, i0, s1 )
	SV* c_func
	int i0
	short s1
PREINIT:
	float(*func)(int, short);
CODE:
	func   = INT2PTR(float(*)(int, short), SvIV(c_func) );
	RETVAL = (*func)(i0, s1);
OUTPUT:
	RETVAL

char *
nci_tis( c_func, i0, s1 )
	SV* c_func
	int i0
	short s1
PREINIT:
	char *(*func)(int, short);
CODE:
	func   = INT2PTR(char *(*)(int, short), SvIV(c_func) );
	RETVAL = (*func)(i0, s1);
OUTPUT:
	RETVAL

int
nci_iis( c_func, i0, s1 )
	SV* c_func
	int i0
	short s1
PREINIT:
	int(*func)(int, short);
CODE:
	func   = INT2PTR(int(*)(int, short), SvIV(c_func) );
	RETVAL = (*func)(i0, s1);
OUTPUT:
	RETVAL

void *
nci_ppf( c_func, p0, f1 )
	SV* c_func
	void * p0
	float f1
PREINIT:
	void *(*func)(void *, float);
CODE:
	func   = INT2PTR(void *(*)(void *, float), SvIV(c_func) );
	RETVAL = (*func)(p0, f1);
OUTPUT:
	RETVAL

void
nci_vpf( c_func, p0, f1 )
	SV* c_func
	void * p0
	float f1
PREINIT:
	void(*func)(void *, float);
CODE:
	func   = INT2PTR(void(*)(void *, float), SvIV(c_func) );
	(*func)(p0, f1);

double
nci_dpf( c_func, p0, f1 )
	SV* c_func
	void * p0
	float f1
PREINIT:
	double(*func)(void *, float);
CODE:
	func   = INT2PTR(double(*)(void *, float), SvIV(c_func) );
	RETVAL = (*func)(p0, f1);
OUTPUT:
	RETVAL

short
nci_spf( c_func, p0, f1 )
	SV* c_func
	void * p0
	float f1
PREINIT:
	short(*func)(void *, float);
CODE:
	func   = INT2PTR(short(*)(void *, float), SvIV(c_func) );
	RETVAL = (*func)(p0, f1);
OUTPUT:
	RETVAL

float
nci_fpf( c_func, p0, f1 )
	SV* c_func
	void * p0
	float f1
PREINIT:
	float(*func)(void *, float);
CODE:
	func   = INT2PTR(float(*)(void *, float), SvIV(c_func) );
	RETVAL = (*func)(p0, f1);
OUTPUT:
	RETVAL

char *
nci_tpf( c_func, p0, f1 )
	SV* c_func
	void * p0
	float f1
PREINIT:
	char *(*func)(void *, float);
CODE:
	func   = INT2PTR(char *(*)(void *, float), SvIV(c_func) );
	RETVAL = (*func)(p0, f1);
OUTPUT:
	RETVAL

int
nci_ipf( c_func, p0, f1 )
	SV* c_func
	void * p0
	float f1
PREINIT:
	int(*func)(void *, float);
CODE:
	func   = INT2PTR(int(*)(void *, float), SvIV(c_func) );
	RETVAL = (*func)(p0, f1);
OUTPUT:
	RETVAL

void *
nci_pvf( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvf( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvf( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svf( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvf( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvf( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivf( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdf( c_func, d0, f1 )
	SV* c_func
	double d0
	float f1
PREINIT:
	void *(*func)(double, float);
CODE:
	func   = INT2PTR(void *(*)(double, float), SvIV(c_func) );
	RETVAL = (*func)(d0, f1);
OUTPUT:
	RETVAL

void
nci_vdf( c_func, d0, f1 )
	SV* c_func
	double d0
	float f1
PREINIT:
	void(*func)(double, float);
CODE:
	func   = INT2PTR(void(*)(double, float), SvIV(c_func) );
	(*func)(d0, f1);

double
nci_ddf( c_func, d0, f1 )
	SV* c_func
	double d0
	float f1
PREINIT:
	double(*func)(double, float);
CODE:
	func   = INT2PTR(double(*)(double, float), SvIV(c_func) );
	RETVAL = (*func)(d0, f1);
OUTPUT:
	RETVAL

short
nci_sdf( c_func, d0, f1 )
	SV* c_func
	double d0
	float f1
PREINIT:
	short(*func)(double, float);
CODE:
	func   = INT2PTR(short(*)(double, float), SvIV(c_func) );
	RETVAL = (*func)(d0, f1);
OUTPUT:
	RETVAL

float
nci_fdf( c_func, d0, f1 )
	SV* c_func
	double d0
	float f1
PREINIT:
	float(*func)(double, float);
CODE:
	func   = INT2PTR(float(*)(double, float), SvIV(c_func) );
	RETVAL = (*func)(d0, f1);
OUTPUT:
	RETVAL

char *
nci_tdf( c_func, d0, f1 )
	SV* c_func
	double d0
	float f1
PREINIT:
	char *(*func)(double, float);
CODE:
	func   = INT2PTR(char *(*)(double, float), SvIV(c_func) );
	RETVAL = (*func)(d0, f1);
OUTPUT:
	RETVAL

int
nci_idf( c_func, d0, f1 )
	SV* c_func
	double d0
	float f1
PREINIT:
	int(*func)(double, float);
CODE:
	func   = INT2PTR(int(*)(double, float), SvIV(c_func) );
	RETVAL = (*func)(d0, f1);
OUTPUT:
	RETVAL

void *
nci_psf( c_func, s0, f1 )
	SV* c_func
	short s0
	float f1
PREINIT:
	void *(*func)(short, float);
CODE:
	func   = INT2PTR(void *(*)(short, float), SvIV(c_func) );
	RETVAL = (*func)(s0, f1);
OUTPUT:
	RETVAL

void
nci_vsf( c_func, s0, f1 )
	SV* c_func
	short s0
	float f1
PREINIT:
	void(*func)(short, float);
CODE:
	func   = INT2PTR(void(*)(short, float), SvIV(c_func) );
	(*func)(s0, f1);

double
nci_dsf( c_func, s0, f1 )
	SV* c_func
	short s0
	float f1
PREINIT:
	double(*func)(short, float);
CODE:
	func   = INT2PTR(double(*)(short, float), SvIV(c_func) );
	RETVAL = (*func)(s0, f1);
OUTPUT:
	RETVAL

short
nci_ssf( c_func, s0, f1 )
	SV* c_func
	short s0
	float f1
PREINIT:
	short(*func)(short, float);
CODE:
	func   = INT2PTR(short(*)(short, float), SvIV(c_func) );
	RETVAL = (*func)(s0, f1);
OUTPUT:
	RETVAL

float
nci_fsf( c_func, s0, f1 )
	SV* c_func
	short s0
	float f1
PREINIT:
	float(*func)(short, float);
CODE:
	func   = INT2PTR(float(*)(short, float), SvIV(c_func) );
	RETVAL = (*func)(s0, f1);
OUTPUT:
	RETVAL

char *
nci_tsf( c_func, s0, f1 )
	SV* c_func
	short s0
	float f1
PREINIT:
	char *(*func)(short, float);
CODE:
	func   = INT2PTR(char *(*)(short, float), SvIV(c_func) );
	RETVAL = (*func)(s0, f1);
OUTPUT:
	RETVAL

int
nci_isf( c_func, s0, f1 )
	SV* c_func
	short s0
	float f1
PREINIT:
	int(*func)(short, float);
CODE:
	func   = INT2PTR(int(*)(short, float), SvIV(c_func) );
	RETVAL = (*func)(s0, f1);
OUTPUT:
	RETVAL

void *
nci_pff( c_func, f0, f1 )
	SV* c_func
	float f0
	float f1
PREINIT:
	void *(*func)(float, float);
CODE:
	func   = INT2PTR(void *(*)(float, float), SvIV(c_func) );
	RETVAL = (*func)(f0, f1);
OUTPUT:
	RETVAL

void
nci_vff( c_func, f0, f1 )
	SV* c_func
	float f0
	float f1
PREINIT:
	void(*func)(float, float);
CODE:
	func   = INT2PTR(void(*)(float, float), SvIV(c_func) );
	(*func)(f0, f1);

double
nci_dff( c_func, f0, f1 )
	SV* c_func
	float f0
	float f1
PREINIT:
	double(*func)(float, float);
CODE:
	func   = INT2PTR(double(*)(float, float), SvIV(c_func) );
	RETVAL = (*func)(f0, f1);
OUTPUT:
	RETVAL

short
nci_sff( c_func, f0, f1 )
	SV* c_func
	float f0
	float f1
PREINIT:
	short(*func)(float, float);
CODE:
	func   = INT2PTR(short(*)(float, float), SvIV(c_func) );
	RETVAL = (*func)(f0, f1);
OUTPUT:
	RETVAL

float
nci_fff( c_func, f0, f1 )
	SV* c_func
	float f0
	float f1
PREINIT:
	float(*func)(float, float);
CODE:
	func   = INT2PTR(float(*)(float, float), SvIV(c_func) );
	RETVAL = (*func)(f0, f1);
OUTPUT:
	RETVAL

char *
nci_tff( c_func, f0, f1 )
	SV* c_func
	float f0
	float f1
PREINIT:
	char *(*func)(float, float);
CODE:
	func   = INT2PTR(char *(*)(float, float), SvIV(c_func) );
	RETVAL = (*func)(f0, f1);
OUTPUT:
	RETVAL

int
nci_iff( c_func, f0, f1 )
	SV* c_func
	float f0
	float f1
PREINIT:
	int(*func)(float, float);
CODE:
	func   = INT2PTR(int(*)(float, float), SvIV(c_func) );
	RETVAL = (*func)(f0, f1);
OUTPUT:
	RETVAL

void *
nci_ptf( c_func, t0, f1 )
	SV* c_func
	char * t0
	float f1
PREINIT:
	void *(*func)(char *, float);
CODE:
	func   = INT2PTR(void *(*)(char *, float), SvIV(c_func) );
	RETVAL = (*func)(t0, f1);
OUTPUT:
	RETVAL

void
nci_vtf( c_func, t0, f1 )
	SV* c_func
	char * t0
	float f1
PREINIT:
	void(*func)(char *, float);
CODE:
	func   = INT2PTR(void(*)(char *, float), SvIV(c_func) );
	(*func)(t0, f1);

double
nci_dtf( c_func, t0, f1 )
	SV* c_func
	char * t0
	float f1
PREINIT:
	double(*func)(char *, float);
CODE:
	func   = INT2PTR(double(*)(char *, float), SvIV(c_func) );
	RETVAL = (*func)(t0, f1);
OUTPUT:
	RETVAL

short
nci_stf( c_func, t0, f1 )
	SV* c_func
	char * t0
	float f1
PREINIT:
	short(*func)(char *, float);
CODE:
	func   = INT2PTR(short(*)(char *, float), SvIV(c_func) );
	RETVAL = (*func)(t0, f1);
OUTPUT:
	RETVAL

float
nci_ftf( c_func, t0, f1 )
	SV* c_func
	char * t0
	float f1
PREINIT:
	float(*func)(char *, float);
CODE:
	func   = INT2PTR(float(*)(char *, float), SvIV(c_func) );
	RETVAL = (*func)(t0, f1);
OUTPUT:
	RETVAL

char *
nci_ttf( c_func, t0, f1 )
	SV* c_func
	char * t0
	float f1
PREINIT:
	char *(*func)(char *, float);
CODE:
	func   = INT2PTR(char *(*)(char *, float), SvIV(c_func) );
	RETVAL = (*func)(t0, f1);
OUTPUT:
	RETVAL

int
nci_itf( c_func, t0, f1 )
	SV* c_func
	char * t0
	float f1
PREINIT:
	int(*func)(char *, float);
CODE:
	func   = INT2PTR(int(*)(char *, float), SvIV(c_func) );
	RETVAL = (*func)(t0, f1);
OUTPUT:
	RETVAL

void *
nci_pif( c_func, i0, f1 )
	SV* c_func
	int i0
	float f1
PREINIT:
	void *(*func)(int, float);
CODE:
	func   = INT2PTR(void *(*)(int, float), SvIV(c_func) );
	RETVAL = (*func)(i0, f1);
OUTPUT:
	RETVAL

void
nci_vif( c_func, i0, f1 )
	SV* c_func
	int i0
	float f1
PREINIT:
	void(*func)(int, float);
CODE:
	func   = INT2PTR(void(*)(int, float), SvIV(c_func) );
	(*func)(i0, f1);

double
nci_dif( c_func, i0, f1 )
	SV* c_func
	int i0
	float f1
PREINIT:
	double(*func)(int, float);
CODE:
	func   = INT2PTR(double(*)(int, float), SvIV(c_func) );
	RETVAL = (*func)(i0, f1);
OUTPUT:
	RETVAL

short
nci_sif( c_func, i0, f1 )
	SV* c_func
	int i0
	float f1
PREINIT:
	short(*func)(int, float);
CODE:
	func   = INT2PTR(short(*)(int, float), SvIV(c_func) );
	RETVAL = (*func)(i0, f1);
OUTPUT:
	RETVAL

float
nci_fif( c_func, i0, f1 )
	SV* c_func
	int i0
	float f1
PREINIT:
	float(*func)(int, float);
CODE:
	func   = INT2PTR(float(*)(int, float), SvIV(c_func) );
	RETVAL = (*func)(i0, f1);
OUTPUT:
	RETVAL

char *
nci_tif( c_func, i0, f1 )
	SV* c_func
	int i0
	float f1
PREINIT:
	char *(*func)(int, float);
CODE:
	func   = INT2PTR(char *(*)(int, float), SvIV(c_func) );
	RETVAL = (*func)(i0, f1);
OUTPUT:
	RETVAL

int
nci_iif( c_func, i0, f1 )
	SV* c_func
	int i0
	float f1
PREINIT:
	int(*func)(int, float);
CODE:
	func   = INT2PTR(int(*)(int, float), SvIV(c_func) );
	RETVAL = (*func)(i0, f1);
OUTPUT:
	RETVAL

void *
nci_ppt( c_func, p0, t1 )
	SV* c_func
	void * p0
	char * t1
PREINIT:
	void *(*func)(void *, char *);
CODE:
	func   = INT2PTR(void *(*)(void *, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1);
OUTPUT:
	RETVAL

void
nci_vpt( c_func, p0, t1 )
	SV* c_func
	void * p0
	char * t1
PREINIT:
	void(*func)(void *, char *);
CODE:
	func   = INT2PTR(void(*)(void *, char *), SvIV(c_func) );
	(*func)(p0, t1);

double
nci_dpt( c_func, p0, t1 )
	SV* c_func
	void * p0
	char * t1
PREINIT:
	double(*func)(void *, char *);
CODE:
	func   = INT2PTR(double(*)(void *, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1);
OUTPUT:
	RETVAL

short
nci_spt( c_func, p0, t1 )
	SV* c_func
	void * p0
	char * t1
PREINIT:
	short(*func)(void *, char *);
CODE:
	func   = INT2PTR(short(*)(void *, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1);
OUTPUT:
	RETVAL

float
nci_fpt( c_func, p0, t1 )
	SV* c_func
	void * p0
	char * t1
PREINIT:
	float(*func)(void *, char *);
CODE:
	func   = INT2PTR(float(*)(void *, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1);
OUTPUT:
	RETVAL

char *
nci_tpt( c_func, p0, t1 )
	SV* c_func
	void * p0
	char * t1
PREINIT:
	char *(*func)(void *, char *);
CODE:
	func   = INT2PTR(char *(*)(void *, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1);
OUTPUT:
	RETVAL

int
nci_ipt( c_func, p0, t1 )
	SV* c_func
	void * p0
	char * t1
PREINIT:
	int(*func)(void *, char *);
CODE:
	func   = INT2PTR(int(*)(void *, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1);
OUTPUT:
	RETVAL

void *
nci_pvt( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvt( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvt( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svt( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvt( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvt( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivt( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdt( c_func, d0, t1 )
	SV* c_func
	double d0
	char * t1
PREINIT:
	void *(*func)(double, char *);
CODE:
	func   = INT2PTR(void *(*)(double, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1);
OUTPUT:
	RETVAL

void
nci_vdt( c_func, d0, t1 )
	SV* c_func
	double d0
	char * t1
PREINIT:
	void(*func)(double, char *);
CODE:
	func   = INT2PTR(void(*)(double, char *), SvIV(c_func) );
	(*func)(d0, t1);

double
nci_ddt( c_func, d0, t1 )
	SV* c_func
	double d0
	char * t1
PREINIT:
	double(*func)(double, char *);
CODE:
	func   = INT2PTR(double(*)(double, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1);
OUTPUT:
	RETVAL

short
nci_sdt( c_func, d0, t1 )
	SV* c_func
	double d0
	char * t1
PREINIT:
	short(*func)(double, char *);
CODE:
	func   = INT2PTR(short(*)(double, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1);
OUTPUT:
	RETVAL

float
nci_fdt( c_func, d0, t1 )
	SV* c_func
	double d0
	char * t1
PREINIT:
	float(*func)(double, char *);
CODE:
	func   = INT2PTR(float(*)(double, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1);
OUTPUT:
	RETVAL

char *
nci_tdt( c_func, d0, t1 )
	SV* c_func
	double d0
	char * t1
PREINIT:
	char *(*func)(double, char *);
CODE:
	func   = INT2PTR(char *(*)(double, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1);
OUTPUT:
	RETVAL

int
nci_idt( c_func, d0, t1 )
	SV* c_func
	double d0
	char * t1
PREINIT:
	int(*func)(double, char *);
CODE:
	func   = INT2PTR(int(*)(double, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1);
OUTPUT:
	RETVAL

void *
nci_pst( c_func, s0, t1 )
	SV* c_func
	short s0
	char * t1
PREINIT:
	void *(*func)(short, char *);
CODE:
	func   = INT2PTR(void *(*)(short, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1);
OUTPUT:
	RETVAL

void
nci_vst( c_func, s0, t1 )
	SV* c_func
	short s0
	char * t1
PREINIT:
	void(*func)(short, char *);
CODE:
	func   = INT2PTR(void(*)(short, char *), SvIV(c_func) );
	(*func)(s0, t1);

double
nci_dst( c_func, s0, t1 )
	SV* c_func
	short s0
	char * t1
PREINIT:
	double(*func)(short, char *);
CODE:
	func   = INT2PTR(double(*)(short, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1);
OUTPUT:
	RETVAL

short
nci_sst( c_func, s0, t1 )
	SV* c_func
	short s0
	char * t1
PREINIT:
	short(*func)(short, char *);
CODE:
	func   = INT2PTR(short(*)(short, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1);
OUTPUT:
	RETVAL

float
nci_fst( c_func, s0, t1 )
	SV* c_func
	short s0
	char * t1
PREINIT:
	float(*func)(short, char *);
CODE:
	func   = INT2PTR(float(*)(short, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1);
OUTPUT:
	RETVAL

char *
nci_tst( c_func, s0, t1 )
	SV* c_func
	short s0
	char * t1
PREINIT:
	char *(*func)(short, char *);
CODE:
	func   = INT2PTR(char *(*)(short, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1);
OUTPUT:
	RETVAL

int
nci_ist( c_func, s0, t1 )
	SV* c_func
	short s0
	char * t1
PREINIT:
	int(*func)(short, char *);
CODE:
	func   = INT2PTR(int(*)(short, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1);
OUTPUT:
	RETVAL

void *
nci_pft( c_func, f0, t1 )
	SV* c_func
	float f0
	char * t1
PREINIT:
	void *(*func)(float, char *);
CODE:
	func   = INT2PTR(void *(*)(float, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1);
OUTPUT:
	RETVAL

void
nci_vft( c_func, f0, t1 )
	SV* c_func
	float f0
	char * t1
PREINIT:
	void(*func)(float, char *);
CODE:
	func   = INT2PTR(void(*)(float, char *), SvIV(c_func) );
	(*func)(f0, t1);

double
nci_dft( c_func, f0, t1 )
	SV* c_func
	float f0
	char * t1
PREINIT:
	double(*func)(float, char *);
CODE:
	func   = INT2PTR(double(*)(float, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1);
OUTPUT:
	RETVAL

short
nci_sft( c_func, f0, t1 )
	SV* c_func
	float f0
	char * t1
PREINIT:
	short(*func)(float, char *);
CODE:
	func   = INT2PTR(short(*)(float, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1);
OUTPUT:
	RETVAL

float
nci_fft( c_func, f0, t1 )
	SV* c_func
	float f0
	char * t1
PREINIT:
	float(*func)(float, char *);
CODE:
	func   = INT2PTR(float(*)(float, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1);
OUTPUT:
	RETVAL

char *
nci_tft( c_func, f0, t1 )
	SV* c_func
	float f0
	char * t1
PREINIT:
	char *(*func)(float, char *);
CODE:
	func   = INT2PTR(char *(*)(float, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1);
OUTPUT:
	RETVAL

int
nci_ift( c_func, f0, t1 )
	SV* c_func
	float f0
	char * t1
PREINIT:
	int(*func)(float, char *);
CODE:
	func   = INT2PTR(int(*)(float, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1);
OUTPUT:
	RETVAL

void *
nci_ptt( c_func, t0, t1 )
	SV* c_func
	char * t0
	char * t1
PREINIT:
	void *(*func)(char *, char *);
CODE:
	func   = INT2PTR(void *(*)(char *, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1);
OUTPUT:
	RETVAL

void
nci_vtt( c_func, t0, t1 )
	SV* c_func
	char * t0
	char * t1
PREINIT:
	void(*func)(char *, char *);
CODE:
	func   = INT2PTR(void(*)(char *, char *), SvIV(c_func) );
	(*func)(t0, t1);

double
nci_dtt( c_func, t0, t1 )
	SV* c_func
	char * t0
	char * t1
PREINIT:
	double(*func)(char *, char *);
CODE:
	func   = INT2PTR(double(*)(char *, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1);
OUTPUT:
	RETVAL

short
nci_stt( c_func, t0, t1 )
	SV* c_func
	char * t0
	char * t1
PREINIT:
	short(*func)(char *, char *);
CODE:
	func   = INT2PTR(short(*)(char *, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1);
OUTPUT:
	RETVAL

float
nci_ftt( c_func, t0, t1 )
	SV* c_func
	char * t0
	char * t1
PREINIT:
	float(*func)(char *, char *);
CODE:
	func   = INT2PTR(float(*)(char *, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1);
OUTPUT:
	RETVAL

char *
nci_ttt( c_func, t0, t1 )
	SV* c_func
	char * t0
	char * t1
PREINIT:
	char *(*func)(char *, char *);
CODE:
	func   = INT2PTR(char *(*)(char *, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1);
OUTPUT:
	RETVAL

int
nci_itt( c_func, t0, t1 )
	SV* c_func
	char * t0
	char * t1
PREINIT:
	int(*func)(char *, char *);
CODE:
	func   = INT2PTR(int(*)(char *, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1);
OUTPUT:
	RETVAL

void *
nci_pit( c_func, i0, t1 )
	SV* c_func
	int i0
	char * t1
PREINIT:
	void *(*func)(int, char *);
CODE:
	func   = INT2PTR(void *(*)(int, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1);
OUTPUT:
	RETVAL

void
nci_vit( c_func, i0, t1 )
	SV* c_func
	int i0
	char * t1
PREINIT:
	void(*func)(int, char *);
CODE:
	func   = INT2PTR(void(*)(int, char *), SvIV(c_func) );
	(*func)(i0, t1);

double
nci_dit( c_func, i0, t1 )
	SV* c_func
	int i0
	char * t1
PREINIT:
	double(*func)(int, char *);
CODE:
	func   = INT2PTR(double(*)(int, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1);
OUTPUT:
	RETVAL

short
nci_sit( c_func, i0, t1 )
	SV* c_func
	int i0
	char * t1
PREINIT:
	short(*func)(int, char *);
CODE:
	func   = INT2PTR(short(*)(int, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1);
OUTPUT:
	RETVAL

float
nci_fit( c_func, i0, t1 )
	SV* c_func
	int i0
	char * t1
PREINIT:
	float(*func)(int, char *);
CODE:
	func   = INT2PTR(float(*)(int, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1);
OUTPUT:
	RETVAL

char *
nci_tit( c_func, i0, t1 )
	SV* c_func
	int i0
	char * t1
PREINIT:
	char *(*func)(int, char *);
CODE:
	func   = INT2PTR(char *(*)(int, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1);
OUTPUT:
	RETVAL

int
nci_iit( c_func, i0, t1 )
	SV* c_func
	int i0
	char * t1
PREINIT:
	int(*func)(int, char *);
CODE:
	func   = INT2PTR(int(*)(int, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1);
OUTPUT:
	RETVAL

void *
nci_ppi( c_func, p0, i1 )
	SV* c_func
	void * p0
	int i1
PREINIT:
	void *(*func)(void *, int);
CODE:
	func   = INT2PTR(void *(*)(void *, int), SvIV(c_func) );
	RETVAL = (*func)(p0, i1);
OUTPUT:
	RETVAL

void
nci_vpi( c_func, p0, i1 )
	SV* c_func
	void * p0
	int i1
PREINIT:
	void(*func)(void *, int);
CODE:
	func   = INT2PTR(void(*)(void *, int), SvIV(c_func) );
	(*func)(p0, i1);

double
nci_dpi( c_func, p0, i1 )
	SV* c_func
	void * p0
	int i1
PREINIT:
	double(*func)(void *, int);
CODE:
	func   = INT2PTR(double(*)(void *, int), SvIV(c_func) );
	RETVAL = (*func)(p0, i1);
OUTPUT:
	RETVAL

short
nci_spi( c_func, p0, i1 )
	SV* c_func
	void * p0
	int i1
PREINIT:
	short(*func)(void *, int);
CODE:
	func   = INT2PTR(short(*)(void *, int), SvIV(c_func) );
	RETVAL = (*func)(p0, i1);
OUTPUT:
	RETVAL

float
nci_fpi( c_func, p0, i1 )
	SV* c_func
	void * p0
	int i1
PREINIT:
	float(*func)(void *, int);
CODE:
	func   = INT2PTR(float(*)(void *, int), SvIV(c_func) );
	RETVAL = (*func)(p0, i1);
OUTPUT:
	RETVAL

char *
nci_tpi( c_func, p0, i1 )
	SV* c_func
	void * p0
	int i1
PREINIT:
	char *(*func)(void *, int);
CODE:
	func   = INT2PTR(char *(*)(void *, int), SvIV(c_func) );
	RETVAL = (*func)(p0, i1);
OUTPUT:
	RETVAL

int
nci_ipi( c_func, p0, i1 )
	SV* c_func
	void * p0
	int i1
PREINIT:
	int(*func)(void *, int);
CODE:
	func   = INT2PTR(int(*)(void *, int), SvIV(c_func) );
	RETVAL = (*func)(p0, i1);
OUTPUT:
	RETVAL

void *
nci_pvi( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvi( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvi( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svi( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvi( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvi( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivi( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdi( c_func, d0, i1 )
	SV* c_func
	double d0
	int i1
PREINIT:
	void *(*func)(double, int);
CODE:
	func   = INT2PTR(void *(*)(double, int), SvIV(c_func) );
	RETVAL = (*func)(d0, i1);
OUTPUT:
	RETVAL

void
nci_vdi( c_func, d0, i1 )
	SV* c_func
	double d0
	int i1
PREINIT:
	void(*func)(double, int);
CODE:
	func   = INT2PTR(void(*)(double, int), SvIV(c_func) );
	(*func)(d0, i1);

double
nci_ddi( c_func, d0, i1 )
	SV* c_func
	double d0
	int i1
PREINIT:
	double(*func)(double, int);
CODE:
	func   = INT2PTR(double(*)(double, int), SvIV(c_func) );
	RETVAL = (*func)(d0, i1);
OUTPUT:
	RETVAL

short
nci_sdi( c_func, d0, i1 )
	SV* c_func
	double d0
	int i1
PREINIT:
	short(*func)(double, int);
CODE:
	func   = INT2PTR(short(*)(double, int), SvIV(c_func) );
	RETVAL = (*func)(d0, i1);
OUTPUT:
	RETVAL

float
nci_fdi( c_func, d0, i1 )
	SV* c_func
	double d0
	int i1
PREINIT:
	float(*func)(double, int);
CODE:
	func   = INT2PTR(float(*)(double, int), SvIV(c_func) );
	RETVAL = (*func)(d0, i1);
OUTPUT:
	RETVAL

char *
nci_tdi( c_func, d0, i1 )
	SV* c_func
	double d0
	int i1
PREINIT:
	char *(*func)(double, int);
CODE:
	func   = INT2PTR(char *(*)(double, int), SvIV(c_func) );
	RETVAL = (*func)(d0, i1);
OUTPUT:
	RETVAL

int
nci_idi( c_func, d0, i1 )
	SV* c_func
	double d0
	int i1
PREINIT:
	int(*func)(double, int);
CODE:
	func   = INT2PTR(int(*)(double, int), SvIV(c_func) );
	RETVAL = (*func)(d0, i1);
OUTPUT:
	RETVAL

void *
nci_psi( c_func, s0, i1 )
	SV* c_func
	short s0
	int i1
PREINIT:
	void *(*func)(short, int);
CODE:
	func   = INT2PTR(void *(*)(short, int), SvIV(c_func) );
	RETVAL = (*func)(s0, i1);
OUTPUT:
	RETVAL

void
nci_vsi( c_func, s0, i1 )
	SV* c_func
	short s0
	int i1
PREINIT:
	void(*func)(short, int);
CODE:
	func   = INT2PTR(void(*)(short, int), SvIV(c_func) );
	(*func)(s0, i1);

double
nci_dsi( c_func, s0, i1 )
	SV* c_func
	short s0
	int i1
PREINIT:
	double(*func)(short, int);
CODE:
	func   = INT2PTR(double(*)(short, int), SvIV(c_func) );
	RETVAL = (*func)(s0, i1);
OUTPUT:
	RETVAL

short
nci_ssi( c_func, s0, i1 )
	SV* c_func
	short s0
	int i1
PREINIT:
	short(*func)(short, int);
CODE:
	func   = INT2PTR(short(*)(short, int), SvIV(c_func) );
	RETVAL = (*func)(s0, i1);
OUTPUT:
	RETVAL

float
nci_fsi( c_func, s0, i1 )
	SV* c_func
	short s0
	int i1
PREINIT:
	float(*func)(short, int);
CODE:
	func   = INT2PTR(float(*)(short, int), SvIV(c_func) );
	RETVAL = (*func)(s0, i1);
OUTPUT:
	RETVAL

char *
nci_tsi( c_func, s0, i1 )
	SV* c_func
	short s0
	int i1
PREINIT:
	char *(*func)(short, int);
CODE:
	func   = INT2PTR(char *(*)(short, int), SvIV(c_func) );
	RETVAL = (*func)(s0, i1);
OUTPUT:
	RETVAL

int
nci_isi( c_func, s0, i1 )
	SV* c_func
	short s0
	int i1
PREINIT:
	int(*func)(short, int);
CODE:
	func   = INT2PTR(int(*)(short, int), SvIV(c_func) );
	RETVAL = (*func)(s0, i1);
OUTPUT:
	RETVAL

void *
nci_pfi( c_func, f0, i1 )
	SV* c_func
	float f0
	int i1
PREINIT:
	void *(*func)(float, int);
CODE:
	func   = INT2PTR(void *(*)(float, int), SvIV(c_func) );
	RETVAL = (*func)(f0, i1);
OUTPUT:
	RETVAL

void
nci_vfi( c_func, f0, i1 )
	SV* c_func
	float f0
	int i1
PREINIT:
	void(*func)(float, int);
CODE:
	func   = INT2PTR(void(*)(float, int), SvIV(c_func) );
	(*func)(f0, i1);

double
nci_dfi( c_func, f0, i1 )
	SV* c_func
	float f0
	int i1
PREINIT:
	double(*func)(float, int);
CODE:
	func   = INT2PTR(double(*)(float, int), SvIV(c_func) );
	RETVAL = (*func)(f0, i1);
OUTPUT:
	RETVAL

short
nci_sfi( c_func, f0, i1 )
	SV* c_func
	float f0
	int i1
PREINIT:
	short(*func)(float, int);
CODE:
	func   = INT2PTR(short(*)(float, int), SvIV(c_func) );
	RETVAL = (*func)(f0, i1);
OUTPUT:
	RETVAL

float
nci_ffi( c_func, f0, i1 )
	SV* c_func
	float f0
	int i1
PREINIT:
	float(*func)(float, int);
CODE:
	func   = INT2PTR(float(*)(float, int), SvIV(c_func) );
	RETVAL = (*func)(f0, i1);
OUTPUT:
	RETVAL

char *
nci_tfi( c_func, f0, i1 )
	SV* c_func
	float f0
	int i1
PREINIT:
	char *(*func)(float, int);
CODE:
	func   = INT2PTR(char *(*)(float, int), SvIV(c_func) );
	RETVAL = (*func)(f0, i1);
OUTPUT:
	RETVAL

int
nci_ifi( c_func, f0, i1 )
	SV* c_func
	float f0
	int i1
PREINIT:
	int(*func)(float, int);
CODE:
	func   = INT2PTR(int(*)(float, int), SvIV(c_func) );
	RETVAL = (*func)(f0, i1);
OUTPUT:
	RETVAL

void *
nci_pti( c_func, t0, i1 )
	SV* c_func
	char * t0
	int i1
PREINIT:
	void *(*func)(char *, int);
CODE:
	func   = INT2PTR(void *(*)(char *, int), SvIV(c_func) );
	RETVAL = (*func)(t0, i1);
OUTPUT:
	RETVAL

void
nci_vti( c_func, t0, i1 )
	SV* c_func
	char * t0
	int i1
PREINIT:
	void(*func)(char *, int);
CODE:
	func   = INT2PTR(void(*)(char *, int), SvIV(c_func) );
	(*func)(t0, i1);

double
nci_dti( c_func, t0, i1 )
	SV* c_func
	char * t0
	int i1
PREINIT:
	double(*func)(char *, int);
CODE:
	func   = INT2PTR(double(*)(char *, int), SvIV(c_func) );
	RETVAL = (*func)(t0, i1);
OUTPUT:
	RETVAL

short
nci_sti( c_func, t0, i1 )
	SV* c_func
	char * t0
	int i1
PREINIT:
	short(*func)(char *, int);
CODE:
	func   = INT2PTR(short(*)(char *, int), SvIV(c_func) );
	RETVAL = (*func)(t0, i1);
OUTPUT:
	RETVAL

float
nci_fti( c_func, t0, i1 )
	SV* c_func
	char * t0
	int i1
PREINIT:
	float(*func)(char *, int);
CODE:
	func   = INT2PTR(float(*)(char *, int), SvIV(c_func) );
	RETVAL = (*func)(t0, i1);
OUTPUT:
	RETVAL

char *
nci_tti( c_func, t0, i1 )
	SV* c_func
	char * t0
	int i1
PREINIT:
	char *(*func)(char *, int);
CODE:
	func   = INT2PTR(char *(*)(char *, int), SvIV(c_func) );
	RETVAL = (*func)(t0, i1);
OUTPUT:
	RETVAL

int
nci_iti( c_func, t0, i1 )
	SV* c_func
	char * t0
	int i1
PREINIT:
	int(*func)(char *, int);
CODE:
	func   = INT2PTR(int(*)(char *, int), SvIV(c_func) );
	RETVAL = (*func)(t0, i1);
OUTPUT:
	RETVAL

void *
nci_pii( c_func, i0, i1 )
	SV* c_func
	int i0
	int i1
PREINIT:
	void *(*func)(int, int);
CODE:
	func   = INT2PTR(void *(*)(int, int), SvIV(c_func) );
	RETVAL = (*func)(i0, i1);
OUTPUT:
	RETVAL

void
nci_vii( c_func, i0, i1 )
	SV* c_func
	int i0
	int i1
PREINIT:
	void(*func)(int, int);
CODE:
	func   = INT2PTR(void(*)(int, int), SvIV(c_func) );
	(*func)(i0, i1);

double
nci_dii( c_func, i0, i1 )
	SV* c_func
	int i0
	int i1
PREINIT:
	double(*func)(int, int);
CODE:
	func   = INT2PTR(double(*)(int, int), SvIV(c_func) );
	RETVAL = (*func)(i0, i1);
OUTPUT:
	RETVAL

short
nci_sii( c_func, i0, i1 )
	SV* c_func
	int i0
	int i1
PREINIT:
	short(*func)(int, int);
CODE:
	func   = INT2PTR(short(*)(int, int), SvIV(c_func) );
	RETVAL = (*func)(i0, i1);
OUTPUT:
	RETVAL

float
nci_fii( c_func, i0, i1 )
	SV* c_func
	int i0
	int i1
PREINIT:
	float(*func)(int, int);
CODE:
	func   = INT2PTR(float(*)(int, int), SvIV(c_func) );
	RETVAL = (*func)(i0, i1);
OUTPUT:
	RETVAL

char *
nci_tii( c_func, i0, i1 )
	SV* c_func
	int i0
	int i1
PREINIT:
	char *(*func)(int, int);
CODE:
	func   = INT2PTR(char *(*)(int, int), SvIV(c_func) );
	RETVAL = (*func)(i0, i1);
OUTPUT:
	RETVAL

int
nci_iii( c_func, i0, i1 )
	SV* c_func
	int i0
	int i1
PREINIT:
	int(*func)(int, int);
CODE:
	func   = INT2PTR(int(*)(int, int), SvIV(c_func) );
	RETVAL = (*func)(i0, i1);
OUTPUT:
	RETVAL

void *
nci_pppp( c_func, p0, p1, p2 )
	SV* c_func
	void * p0
	void * p1
	void * p2
PREINIT:
	void *(*func)(void *, void *, void *);
CODE:
	func   = INT2PTR(void *(*)(void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, p2);
OUTPUT:
	RETVAL

void
nci_vppp( c_func, p0, p1, p2 )
	SV* c_func
	void * p0
	void * p1
	void * p2
PREINIT:
	void(*func)(void *, void *, void *);
CODE:
	func   = INT2PTR(void(*)(void *, void *, void *), SvIV(c_func) );
	(*func)(p0, p1, p2);

double
nci_dppp( c_func, p0, p1, p2 )
	SV* c_func
	void * p0
	void * p1
	void * p2
PREINIT:
	double(*func)(void *, void *, void *);
CODE:
	func   = INT2PTR(double(*)(void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, p2);
OUTPUT:
	RETVAL

short
nci_sppp( c_func, p0, p1, p2 )
	SV* c_func
	void * p0
	void * p1
	void * p2
PREINIT:
	short(*func)(void *, void *, void *);
CODE:
	func   = INT2PTR(short(*)(void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, p2);
OUTPUT:
	RETVAL

float
nci_fppp( c_func, p0, p1, p2 )
	SV* c_func
	void * p0
	void * p1
	void * p2
PREINIT:
	float(*func)(void *, void *, void *);
CODE:
	func   = INT2PTR(float(*)(void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, p2);
OUTPUT:
	RETVAL

char *
nci_tppp( c_func, p0, p1, p2 )
	SV* c_func
	void * p0
	void * p1
	void * p2
PREINIT:
	char *(*func)(void *, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, p2);
OUTPUT:
	RETVAL

int
nci_ippp( c_func, p0, p1, p2 )
	SV* c_func
	void * p0
	void * p1
	void * p2
PREINIT:
	int(*func)(void *, void *, void *);
CODE:
	func   = INT2PTR(int(*)(void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, p2);
OUTPUT:
	RETVAL

void *
nci_pvpp( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvpp( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvpp( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svpp( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvpp( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvpp( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivpp( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdpp( c_func, d0, p1, p2 )
	SV* c_func
	double d0
	void * p1
	void * p2
PREINIT:
	void *(*func)(double, void *, void *);
CODE:
	func   = INT2PTR(void *(*)(double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, p2);
OUTPUT:
	RETVAL

void
nci_vdpp( c_func, d0, p1, p2 )
	SV* c_func
	double d0
	void * p1
	void * p2
PREINIT:
	void(*func)(double, void *, void *);
CODE:
	func   = INT2PTR(void(*)(double, void *, void *), SvIV(c_func) );
	(*func)(d0, p1, p2);

double
nci_ddpp( c_func, d0, p1, p2 )
	SV* c_func
	double d0
	void * p1
	void * p2
PREINIT:
	double(*func)(double, void *, void *);
CODE:
	func   = INT2PTR(double(*)(double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, p2);
OUTPUT:
	RETVAL

short
nci_sdpp( c_func, d0, p1, p2 )
	SV* c_func
	double d0
	void * p1
	void * p2
PREINIT:
	short(*func)(double, void *, void *);
CODE:
	func   = INT2PTR(short(*)(double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, p2);
OUTPUT:
	RETVAL

float
nci_fdpp( c_func, d0, p1, p2 )
	SV* c_func
	double d0
	void * p1
	void * p2
PREINIT:
	float(*func)(double, void *, void *);
CODE:
	func   = INT2PTR(float(*)(double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, p2);
OUTPUT:
	RETVAL

char *
nci_tdpp( c_func, d0, p1, p2 )
	SV* c_func
	double d0
	void * p1
	void * p2
PREINIT:
	char *(*func)(double, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, p2);
OUTPUT:
	RETVAL

int
nci_idpp( c_func, d0, p1, p2 )
	SV* c_func
	double d0
	void * p1
	void * p2
PREINIT:
	int(*func)(double, void *, void *);
CODE:
	func   = INT2PTR(int(*)(double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, p2);
OUTPUT:
	RETVAL

void *
nci_pspp( c_func, s0, p1, p2 )
	SV* c_func
	short s0
	void * p1
	void * p2
PREINIT:
	void *(*func)(short, void *, void *);
CODE:
	func   = INT2PTR(void *(*)(short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, p2);
OUTPUT:
	RETVAL

void
nci_vspp( c_func, s0, p1, p2 )
	SV* c_func
	short s0
	void * p1
	void * p2
PREINIT:
	void(*func)(short, void *, void *);
CODE:
	func   = INT2PTR(void(*)(short, void *, void *), SvIV(c_func) );
	(*func)(s0, p1, p2);

double
nci_dspp( c_func, s0, p1, p2 )
	SV* c_func
	short s0
	void * p1
	void * p2
PREINIT:
	double(*func)(short, void *, void *);
CODE:
	func   = INT2PTR(double(*)(short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, p2);
OUTPUT:
	RETVAL

short
nci_sspp( c_func, s0, p1, p2 )
	SV* c_func
	short s0
	void * p1
	void * p2
PREINIT:
	short(*func)(short, void *, void *);
CODE:
	func   = INT2PTR(short(*)(short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, p2);
OUTPUT:
	RETVAL

float
nci_fspp( c_func, s0, p1, p2 )
	SV* c_func
	short s0
	void * p1
	void * p2
PREINIT:
	float(*func)(short, void *, void *);
CODE:
	func   = INT2PTR(float(*)(short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, p2);
OUTPUT:
	RETVAL

char *
nci_tspp( c_func, s0, p1, p2 )
	SV* c_func
	short s0
	void * p1
	void * p2
PREINIT:
	char *(*func)(short, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, p2);
OUTPUT:
	RETVAL

int
nci_ispp( c_func, s0, p1, p2 )
	SV* c_func
	short s0
	void * p1
	void * p2
PREINIT:
	int(*func)(short, void *, void *);
CODE:
	func   = INT2PTR(int(*)(short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, p2);
OUTPUT:
	RETVAL

void *
nci_pfpp( c_func, f0, p1, p2 )
	SV* c_func
	float f0
	void * p1
	void * p2
PREINIT:
	void *(*func)(float, void *, void *);
CODE:
	func   = INT2PTR(void *(*)(float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, p2);
OUTPUT:
	RETVAL

void
nci_vfpp( c_func, f0, p1, p2 )
	SV* c_func
	float f0
	void * p1
	void * p2
PREINIT:
	void(*func)(float, void *, void *);
CODE:
	func   = INT2PTR(void(*)(float, void *, void *), SvIV(c_func) );
	(*func)(f0, p1, p2);

double
nci_dfpp( c_func, f0, p1, p2 )
	SV* c_func
	float f0
	void * p1
	void * p2
PREINIT:
	double(*func)(float, void *, void *);
CODE:
	func   = INT2PTR(double(*)(float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, p2);
OUTPUT:
	RETVAL

short
nci_sfpp( c_func, f0, p1, p2 )
	SV* c_func
	float f0
	void * p1
	void * p2
PREINIT:
	short(*func)(float, void *, void *);
CODE:
	func   = INT2PTR(short(*)(float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, p2);
OUTPUT:
	RETVAL

float
nci_ffpp( c_func, f0, p1, p2 )
	SV* c_func
	float f0
	void * p1
	void * p2
PREINIT:
	float(*func)(float, void *, void *);
CODE:
	func   = INT2PTR(float(*)(float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, p2);
OUTPUT:
	RETVAL

char *
nci_tfpp( c_func, f0, p1, p2 )
	SV* c_func
	float f0
	void * p1
	void * p2
PREINIT:
	char *(*func)(float, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, p2);
OUTPUT:
	RETVAL

int
nci_ifpp( c_func, f0, p1, p2 )
	SV* c_func
	float f0
	void * p1
	void * p2
PREINIT:
	int(*func)(float, void *, void *);
CODE:
	func   = INT2PTR(int(*)(float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, p2);
OUTPUT:
	RETVAL

void *
nci_ptpp( c_func, t0, p1, p2 )
	SV* c_func
	char * t0
	void * p1
	void * p2
PREINIT:
	void *(*func)(char *, void *, void *);
CODE:
	func   = INT2PTR(void *(*)(char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, p2);
OUTPUT:
	RETVAL

void
nci_vtpp( c_func, t0, p1, p2 )
	SV* c_func
	char * t0
	void * p1
	void * p2
PREINIT:
	void(*func)(char *, void *, void *);
CODE:
	func   = INT2PTR(void(*)(char *, void *, void *), SvIV(c_func) );
	(*func)(t0, p1, p2);

double
nci_dtpp( c_func, t0, p1, p2 )
	SV* c_func
	char * t0
	void * p1
	void * p2
PREINIT:
	double(*func)(char *, void *, void *);
CODE:
	func   = INT2PTR(double(*)(char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, p2);
OUTPUT:
	RETVAL

short
nci_stpp( c_func, t0, p1, p2 )
	SV* c_func
	char * t0
	void * p1
	void * p2
PREINIT:
	short(*func)(char *, void *, void *);
CODE:
	func   = INT2PTR(short(*)(char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, p2);
OUTPUT:
	RETVAL

float
nci_ftpp( c_func, t0, p1, p2 )
	SV* c_func
	char * t0
	void * p1
	void * p2
PREINIT:
	float(*func)(char *, void *, void *);
CODE:
	func   = INT2PTR(float(*)(char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, p2);
OUTPUT:
	RETVAL

char *
nci_ttpp( c_func, t0, p1, p2 )
	SV* c_func
	char * t0
	void * p1
	void * p2
PREINIT:
	char *(*func)(char *, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, p2);
OUTPUT:
	RETVAL

int
nci_itpp( c_func, t0, p1, p2 )
	SV* c_func
	char * t0
	void * p1
	void * p2
PREINIT:
	int(*func)(char *, void *, void *);
CODE:
	func   = INT2PTR(int(*)(char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, p2);
OUTPUT:
	RETVAL

void *
nci_pipp( c_func, i0, p1, p2 )
	SV* c_func
	int i0
	void * p1
	void * p2
PREINIT:
	void *(*func)(int, void *, void *);
CODE:
	func   = INT2PTR(void *(*)(int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, p2);
OUTPUT:
	RETVAL

void
nci_vipp( c_func, i0, p1, p2 )
	SV* c_func
	int i0
	void * p1
	void * p2
PREINIT:
	void(*func)(int, void *, void *);
CODE:
	func   = INT2PTR(void(*)(int, void *, void *), SvIV(c_func) );
	(*func)(i0, p1, p2);

double
nci_dipp( c_func, i0, p1, p2 )
	SV* c_func
	int i0
	void * p1
	void * p2
PREINIT:
	double(*func)(int, void *, void *);
CODE:
	func   = INT2PTR(double(*)(int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, p2);
OUTPUT:
	RETVAL

short
nci_sipp( c_func, i0, p1, p2 )
	SV* c_func
	int i0
	void * p1
	void * p2
PREINIT:
	short(*func)(int, void *, void *);
CODE:
	func   = INT2PTR(short(*)(int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, p2);
OUTPUT:
	RETVAL

float
nci_fipp( c_func, i0, p1, p2 )
	SV* c_func
	int i0
	void * p1
	void * p2
PREINIT:
	float(*func)(int, void *, void *);
CODE:
	func   = INT2PTR(float(*)(int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, p2);
OUTPUT:
	RETVAL

char *
nci_tipp( c_func, i0, p1, p2 )
	SV* c_func
	int i0
	void * p1
	void * p2
PREINIT:
	char *(*func)(int, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, p2);
OUTPUT:
	RETVAL

int
nci_iipp( c_func, i0, p1, p2 )
	SV* c_func
	int i0
	void * p1
	void * p2
PREINIT:
	int(*func)(int, void *, void *);
CODE:
	func   = INT2PTR(int(*)(int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, p2);
OUTPUT:
	RETVAL

void *
nci_ppdp( c_func, p0, d1, p2 )
	SV* c_func
	void * p0
	double d1
	void * p2
PREINIT:
	void *(*func)(void *, double, void *);
CODE:
	func   = INT2PTR(void *(*)(void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, p2);
OUTPUT:
	RETVAL

void
nci_vpdp( c_func, p0, d1, p2 )
	SV* c_func
	void * p0
	double d1
	void * p2
PREINIT:
	void(*func)(void *, double, void *);
CODE:
	func   = INT2PTR(void(*)(void *, double, void *), SvIV(c_func) );
	(*func)(p0, d1, p2);

double
nci_dpdp( c_func, p0, d1, p2 )
	SV* c_func
	void * p0
	double d1
	void * p2
PREINIT:
	double(*func)(void *, double, void *);
CODE:
	func   = INT2PTR(double(*)(void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, p2);
OUTPUT:
	RETVAL

short
nci_spdp( c_func, p0, d1, p2 )
	SV* c_func
	void * p0
	double d1
	void * p2
PREINIT:
	short(*func)(void *, double, void *);
CODE:
	func   = INT2PTR(short(*)(void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, p2);
OUTPUT:
	RETVAL

float
nci_fpdp( c_func, p0, d1, p2 )
	SV* c_func
	void * p0
	double d1
	void * p2
PREINIT:
	float(*func)(void *, double, void *);
CODE:
	func   = INT2PTR(float(*)(void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, p2);
OUTPUT:
	RETVAL

char *
nci_tpdp( c_func, p0, d1, p2 )
	SV* c_func
	void * p0
	double d1
	void * p2
PREINIT:
	char *(*func)(void *, double, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, p2);
OUTPUT:
	RETVAL

int
nci_ipdp( c_func, p0, d1, p2 )
	SV* c_func
	void * p0
	double d1
	void * p2
PREINIT:
	int(*func)(void *, double, void *);
CODE:
	func   = INT2PTR(int(*)(void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, p2);
OUTPUT:
	RETVAL

void *
nci_pvdp( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvdp( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvdp( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svdp( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvdp( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvdp( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivdp( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pddp( c_func, d0, d1, p2 )
	SV* c_func
	double d0
	double d1
	void * p2
PREINIT:
	void *(*func)(double, double, void *);
CODE:
	func   = INT2PTR(void *(*)(double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, p2);
OUTPUT:
	RETVAL

void
nci_vddp( c_func, d0, d1, p2 )
	SV* c_func
	double d0
	double d1
	void * p2
PREINIT:
	void(*func)(double, double, void *);
CODE:
	func   = INT2PTR(void(*)(double, double, void *), SvIV(c_func) );
	(*func)(d0, d1, p2);

double
nci_dddp( c_func, d0, d1, p2 )
	SV* c_func
	double d0
	double d1
	void * p2
PREINIT:
	double(*func)(double, double, void *);
CODE:
	func   = INT2PTR(double(*)(double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, p2);
OUTPUT:
	RETVAL

short
nci_sddp( c_func, d0, d1, p2 )
	SV* c_func
	double d0
	double d1
	void * p2
PREINIT:
	short(*func)(double, double, void *);
CODE:
	func   = INT2PTR(short(*)(double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, p2);
OUTPUT:
	RETVAL

float
nci_fddp( c_func, d0, d1, p2 )
	SV* c_func
	double d0
	double d1
	void * p2
PREINIT:
	float(*func)(double, double, void *);
CODE:
	func   = INT2PTR(float(*)(double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, p2);
OUTPUT:
	RETVAL

char *
nci_tddp( c_func, d0, d1, p2 )
	SV* c_func
	double d0
	double d1
	void * p2
PREINIT:
	char *(*func)(double, double, void *);
CODE:
	func   = INT2PTR(char *(*)(double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, p2);
OUTPUT:
	RETVAL

int
nci_iddp( c_func, d0, d1, p2 )
	SV* c_func
	double d0
	double d1
	void * p2
PREINIT:
	int(*func)(double, double, void *);
CODE:
	func   = INT2PTR(int(*)(double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, p2);
OUTPUT:
	RETVAL

void *
nci_psdp( c_func, s0, d1, p2 )
	SV* c_func
	short s0
	double d1
	void * p2
PREINIT:
	void *(*func)(short, double, void *);
CODE:
	func   = INT2PTR(void *(*)(short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, p2);
OUTPUT:
	RETVAL

void
nci_vsdp( c_func, s0, d1, p2 )
	SV* c_func
	short s0
	double d1
	void * p2
PREINIT:
	void(*func)(short, double, void *);
CODE:
	func   = INT2PTR(void(*)(short, double, void *), SvIV(c_func) );
	(*func)(s0, d1, p2);

double
nci_dsdp( c_func, s0, d1, p2 )
	SV* c_func
	short s0
	double d1
	void * p2
PREINIT:
	double(*func)(short, double, void *);
CODE:
	func   = INT2PTR(double(*)(short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, p2);
OUTPUT:
	RETVAL

short
nci_ssdp( c_func, s0, d1, p2 )
	SV* c_func
	short s0
	double d1
	void * p2
PREINIT:
	short(*func)(short, double, void *);
CODE:
	func   = INT2PTR(short(*)(short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, p2);
OUTPUT:
	RETVAL

float
nci_fsdp( c_func, s0, d1, p2 )
	SV* c_func
	short s0
	double d1
	void * p2
PREINIT:
	float(*func)(short, double, void *);
CODE:
	func   = INT2PTR(float(*)(short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, p2);
OUTPUT:
	RETVAL

char *
nci_tsdp( c_func, s0, d1, p2 )
	SV* c_func
	short s0
	double d1
	void * p2
PREINIT:
	char *(*func)(short, double, void *);
CODE:
	func   = INT2PTR(char *(*)(short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, p2);
OUTPUT:
	RETVAL

int
nci_isdp( c_func, s0, d1, p2 )
	SV* c_func
	short s0
	double d1
	void * p2
PREINIT:
	int(*func)(short, double, void *);
CODE:
	func   = INT2PTR(int(*)(short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, p2);
OUTPUT:
	RETVAL

void *
nci_pfdp( c_func, f0, d1, p2 )
	SV* c_func
	float f0
	double d1
	void * p2
PREINIT:
	void *(*func)(float, double, void *);
CODE:
	func   = INT2PTR(void *(*)(float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, p2);
OUTPUT:
	RETVAL

void
nci_vfdp( c_func, f0, d1, p2 )
	SV* c_func
	float f0
	double d1
	void * p2
PREINIT:
	void(*func)(float, double, void *);
CODE:
	func   = INT2PTR(void(*)(float, double, void *), SvIV(c_func) );
	(*func)(f0, d1, p2);

double
nci_dfdp( c_func, f0, d1, p2 )
	SV* c_func
	float f0
	double d1
	void * p2
PREINIT:
	double(*func)(float, double, void *);
CODE:
	func   = INT2PTR(double(*)(float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, p2);
OUTPUT:
	RETVAL

short
nci_sfdp( c_func, f0, d1, p2 )
	SV* c_func
	float f0
	double d1
	void * p2
PREINIT:
	short(*func)(float, double, void *);
CODE:
	func   = INT2PTR(short(*)(float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, p2);
OUTPUT:
	RETVAL

float
nci_ffdp( c_func, f0, d1, p2 )
	SV* c_func
	float f0
	double d1
	void * p2
PREINIT:
	float(*func)(float, double, void *);
CODE:
	func   = INT2PTR(float(*)(float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, p2);
OUTPUT:
	RETVAL

char *
nci_tfdp( c_func, f0, d1, p2 )
	SV* c_func
	float f0
	double d1
	void * p2
PREINIT:
	char *(*func)(float, double, void *);
CODE:
	func   = INT2PTR(char *(*)(float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, p2);
OUTPUT:
	RETVAL

int
nci_ifdp( c_func, f0, d1, p2 )
	SV* c_func
	float f0
	double d1
	void * p2
PREINIT:
	int(*func)(float, double, void *);
CODE:
	func   = INT2PTR(int(*)(float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, p2);
OUTPUT:
	RETVAL

void *
nci_ptdp( c_func, t0, d1, p2 )
	SV* c_func
	char * t0
	double d1
	void * p2
PREINIT:
	void *(*func)(char *, double, void *);
CODE:
	func   = INT2PTR(void *(*)(char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, p2);
OUTPUT:
	RETVAL

void
nci_vtdp( c_func, t0, d1, p2 )
	SV* c_func
	char * t0
	double d1
	void * p2
PREINIT:
	void(*func)(char *, double, void *);
CODE:
	func   = INT2PTR(void(*)(char *, double, void *), SvIV(c_func) );
	(*func)(t0, d1, p2);

double
nci_dtdp( c_func, t0, d1, p2 )
	SV* c_func
	char * t0
	double d1
	void * p2
PREINIT:
	double(*func)(char *, double, void *);
CODE:
	func   = INT2PTR(double(*)(char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, p2);
OUTPUT:
	RETVAL

short
nci_stdp( c_func, t0, d1, p2 )
	SV* c_func
	char * t0
	double d1
	void * p2
PREINIT:
	short(*func)(char *, double, void *);
CODE:
	func   = INT2PTR(short(*)(char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, p2);
OUTPUT:
	RETVAL

float
nci_ftdp( c_func, t0, d1, p2 )
	SV* c_func
	char * t0
	double d1
	void * p2
PREINIT:
	float(*func)(char *, double, void *);
CODE:
	func   = INT2PTR(float(*)(char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, p2);
OUTPUT:
	RETVAL

char *
nci_ttdp( c_func, t0, d1, p2 )
	SV* c_func
	char * t0
	double d1
	void * p2
PREINIT:
	char *(*func)(char *, double, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, p2);
OUTPUT:
	RETVAL

int
nci_itdp( c_func, t0, d1, p2 )
	SV* c_func
	char * t0
	double d1
	void * p2
PREINIT:
	int(*func)(char *, double, void *);
CODE:
	func   = INT2PTR(int(*)(char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, p2);
OUTPUT:
	RETVAL

void *
nci_pidp( c_func, i0, d1, p2 )
	SV* c_func
	int i0
	double d1
	void * p2
PREINIT:
	void *(*func)(int, double, void *);
CODE:
	func   = INT2PTR(void *(*)(int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, p2);
OUTPUT:
	RETVAL

void
nci_vidp( c_func, i0, d1, p2 )
	SV* c_func
	int i0
	double d1
	void * p2
PREINIT:
	void(*func)(int, double, void *);
CODE:
	func   = INT2PTR(void(*)(int, double, void *), SvIV(c_func) );
	(*func)(i0, d1, p2);

double
nci_didp( c_func, i0, d1, p2 )
	SV* c_func
	int i0
	double d1
	void * p2
PREINIT:
	double(*func)(int, double, void *);
CODE:
	func   = INT2PTR(double(*)(int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, p2);
OUTPUT:
	RETVAL

short
nci_sidp( c_func, i0, d1, p2 )
	SV* c_func
	int i0
	double d1
	void * p2
PREINIT:
	short(*func)(int, double, void *);
CODE:
	func   = INT2PTR(short(*)(int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, p2);
OUTPUT:
	RETVAL

float
nci_fidp( c_func, i0, d1, p2 )
	SV* c_func
	int i0
	double d1
	void * p2
PREINIT:
	float(*func)(int, double, void *);
CODE:
	func   = INT2PTR(float(*)(int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, p2);
OUTPUT:
	RETVAL

char *
nci_tidp( c_func, i0, d1, p2 )
	SV* c_func
	int i0
	double d1
	void * p2
PREINIT:
	char *(*func)(int, double, void *);
CODE:
	func   = INT2PTR(char *(*)(int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, p2);
OUTPUT:
	RETVAL

int
nci_iidp( c_func, i0, d1, p2 )
	SV* c_func
	int i0
	double d1
	void * p2
PREINIT:
	int(*func)(int, double, void *);
CODE:
	func   = INT2PTR(int(*)(int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, p2);
OUTPUT:
	RETVAL

void *
nci_ppsp( c_func, p0, s1, p2 )
	SV* c_func
	void * p0
	short s1
	void * p2
PREINIT:
	void *(*func)(void *, short, void *);
CODE:
	func   = INT2PTR(void *(*)(void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, p2);
OUTPUT:
	RETVAL

void
nci_vpsp( c_func, p0, s1, p2 )
	SV* c_func
	void * p0
	short s1
	void * p2
PREINIT:
	void(*func)(void *, short, void *);
CODE:
	func   = INT2PTR(void(*)(void *, short, void *), SvIV(c_func) );
	(*func)(p0, s1, p2);

double
nci_dpsp( c_func, p0, s1, p2 )
	SV* c_func
	void * p0
	short s1
	void * p2
PREINIT:
	double(*func)(void *, short, void *);
CODE:
	func   = INT2PTR(double(*)(void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, p2);
OUTPUT:
	RETVAL

short
nci_spsp( c_func, p0, s1, p2 )
	SV* c_func
	void * p0
	short s1
	void * p2
PREINIT:
	short(*func)(void *, short, void *);
CODE:
	func   = INT2PTR(short(*)(void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, p2);
OUTPUT:
	RETVAL

float
nci_fpsp( c_func, p0, s1, p2 )
	SV* c_func
	void * p0
	short s1
	void * p2
PREINIT:
	float(*func)(void *, short, void *);
CODE:
	func   = INT2PTR(float(*)(void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, p2);
OUTPUT:
	RETVAL

char *
nci_tpsp( c_func, p0, s1, p2 )
	SV* c_func
	void * p0
	short s1
	void * p2
PREINIT:
	char *(*func)(void *, short, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, p2);
OUTPUT:
	RETVAL

int
nci_ipsp( c_func, p0, s1, p2 )
	SV* c_func
	void * p0
	short s1
	void * p2
PREINIT:
	int(*func)(void *, short, void *);
CODE:
	func   = INT2PTR(int(*)(void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, p2);
OUTPUT:
	RETVAL

void *
nci_pvsp( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvsp( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvsp( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svsp( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvsp( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvsp( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivsp( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdsp( c_func, d0, s1, p2 )
	SV* c_func
	double d0
	short s1
	void * p2
PREINIT:
	void *(*func)(double, short, void *);
CODE:
	func   = INT2PTR(void *(*)(double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, p2);
OUTPUT:
	RETVAL

void
nci_vdsp( c_func, d0, s1, p2 )
	SV* c_func
	double d0
	short s1
	void * p2
PREINIT:
	void(*func)(double, short, void *);
CODE:
	func   = INT2PTR(void(*)(double, short, void *), SvIV(c_func) );
	(*func)(d0, s1, p2);

double
nci_ddsp( c_func, d0, s1, p2 )
	SV* c_func
	double d0
	short s1
	void * p2
PREINIT:
	double(*func)(double, short, void *);
CODE:
	func   = INT2PTR(double(*)(double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, p2);
OUTPUT:
	RETVAL

short
nci_sdsp( c_func, d0, s1, p2 )
	SV* c_func
	double d0
	short s1
	void * p2
PREINIT:
	short(*func)(double, short, void *);
CODE:
	func   = INT2PTR(short(*)(double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, p2);
OUTPUT:
	RETVAL

float
nci_fdsp( c_func, d0, s1, p2 )
	SV* c_func
	double d0
	short s1
	void * p2
PREINIT:
	float(*func)(double, short, void *);
CODE:
	func   = INT2PTR(float(*)(double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, p2);
OUTPUT:
	RETVAL

char *
nci_tdsp( c_func, d0, s1, p2 )
	SV* c_func
	double d0
	short s1
	void * p2
PREINIT:
	char *(*func)(double, short, void *);
CODE:
	func   = INT2PTR(char *(*)(double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, p2);
OUTPUT:
	RETVAL

int
nci_idsp( c_func, d0, s1, p2 )
	SV* c_func
	double d0
	short s1
	void * p2
PREINIT:
	int(*func)(double, short, void *);
CODE:
	func   = INT2PTR(int(*)(double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, p2);
OUTPUT:
	RETVAL

void *
nci_pssp( c_func, s0, s1, p2 )
	SV* c_func
	short s0
	short s1
	void * p2
PREINIT:
	void *(*func)(short, short, void *);
CODE:
	func   = INT2PTR(void *(*)(short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, p2);
OUTPUT:
	RETVAL

void
nci_vssp( c_func, s0, s1, p2 )
	SV* c_func
	short s0
	short s1
	void * p2
PREINIT:
	void(*func)(short, short, void *);
CODE:
	func   = INT2PTR(void(*)(short, short, void *), SvIV(c_func) );
	(*func)(s0, s1, p2);

double
nci_dssp( c_func, s0, s1, p2 )
	SV* c_func
	short s0
	short s1
	void * p2
PREINIT:
	double(*func)(short, short, void *);
CODE:
	func   = INT2PTR(double(*)(short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, p2);
OUTPUT:
	RETVAL

short
nci_sssp( c_func, s0, s1, p2 )
	SV* c_func
	short s0
	short s1
	void * p2
PREINIT:
	short(*func)(short, short, void *);
CODE:
	func   = INT2PTR(short(*)(short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, p2);
OUTPUT:
	RETVAL

float
nci_fssp( c_func, s0, s1, p2 )
	SV* c_func
	short s0
	short s1
	void * p2
PREINIT:
	float(*func)(short, short, void *);
CODE:
	func   = INT2PTR(float(*)(short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, p2);
OUTPUT:
	RETVAL

char *
nci_tssp( c_func, s0, s1, p2 )
	SV* c_func
	short s0
	short s1
	void * p2
PREINIT:
	char *(*func)(short, short, void *);
CODE:
	func   = INT2PTR(char *(*)(short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, p2);
OUTPUT:
	RETVAL

int
nci_issp( c_func, s0, s1, p2 )
	SV* c_func
	short s0
	short s1
	void * p2
PREINIT:
	int(*func)(short, short, void *);
CODE:
	func   = INT2PTR(int(*)(short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, p2);
OUTPUT:
	RETVAL

void *
nci_pfsp( c_func, f0, s1, p2 )
	SV* c_func
	float f0
	short s1
	void * p2
PREINIT:
	void *(*func)(float, short, void *);
CODE:
	func   = INT2PTR(void *(*)(float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, p2);
OUTPUT:
	RETVAL

void
nci_vfsp( c_func, f0, s1, p2 )
	SV* c_func
	float f0
	short s1
	void * p2
PREINIT:
	void(*func)(float, short, void *);
CODE:
	func   = INT2PTR(void(*)(float, short, void *), SvIV(c_func) );
	(*func)(f0, s1, p2);

double
nci_dfsp( c_func, f0, s1, p2 )
	SV* c_func
	float f0
	short s1
	void * p2
PREINIT:
	double(*func)(float, short, void *);
CODE:
	func   = INT2PTR(double(*)(float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, p2);
OUTPUT:
	RETVAL

short
nci_sfsp( c_func, f0, s1, p2 )
	SV* c_func
	float f0
	short s1
	void * p2
PREINIT:
	short(*func)(float, short, void *);
CODE:
	func   = INT2PTR(short(*)(float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, p2);
OUTPUT:
	RETVAL

float
nci_ffsp( c_func, f0, s1, p2 )
	SV* c_func
	float f0
	short s1
	void * p2
PREINIT:
	float(*func)(float, short, void *);
CODE:
	func   = INT2PTR(float(*)(float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, p2);
OUTPUT:
	RETVAL

char *
nci_tfsp( c_func, f0, s1, p2 )
	SV* c_func
	float f0
	short s1
	void * p2
PREINIT:
	char *(*func)(float, short, void *);
CODE:
	func   = INT2PTR(char *(*)(float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, p2);
OUTPUT:
	RETVAL

int
nci_ifsp( c_func, f0, s1, p2 )
	SV* c_func
	float f0
	short s1
	void * p2
PREINIT:
	int(*func)(float, short, void *);
CODE:
	func   = INT2PTR(int(*)(float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, p2);
OUTPUT:
	RETVAL

void *
nci_ptsp( c_func, t0, s1, p2 )
	SV* c_func
	char * t0
	short s1
	void * p2
PREINIT:
	void *(*func)(char *, short, void *);
CODE:
	func   = INT2PTR(void *(*)(char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, p2);
OUTPUT:
	RETVAL

void
nci_vtsp( c_func, t0, s1, p2 )
	SV* c_func
	char * t0
	short s1
	void * p2
PREINIT:
	void(*func)(char *, short, void *);
CODE:
	func   = INT2PTR(void(*)(char *, short, void *), SvIV(c_func) );
	(*func)(t0, s1, p2);

double
nci_dtsp( c_func, t0, s1, p2 )
	SV* c_func
	char * t0
	short s1
	void * p2
PREINIT:
	double(*func)(char *, short, void *);
CODE:
	func   = INT2PTR(double(*)(char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, p2);
OUTPUT:
	RETVAL

short
nci_stsp( c_func, t0, s1, p2 )
	SV* c_func
	char * t0
	short s1
	void * p2
PREINIT:
	short(*func)(char *, short, void *);
CODE:
	func   = INT2PTR(short(*)(char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, p2);
OUTPUT:
	RETVAL

float
nci_ftsp( c_func, t0, s1, p2 )
	SV* c_func
	char * t0
	short s1
	void * p2
PREINIT:
	float(*func)(char *, short, void *);
CODE:
	func   = INT2PTR(float(*)(char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, p2);
OUTPUT:
	RETVAL

char *
nci_ttsp( c_func, t0, s1, p2 )
	SV* c_func
	char * t0
	short s1
	void * p2
PREINIT:
	char *(*func)(char *, short, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, p2);
OUTPUT:
	RETVAL

int
nci_itsp( c_func, t0, s1, p2 )
	SV* c_func
	char * t0
	short s1
	void * p2
PREINIT:
	int(*func)(char *, short, void *);
CODE:
	func   = INT2PTR(int(*)(char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, p2);
OUTPUT:
	RETVAL

void *
nci_pisp( c_func, i0, s1, p2 )
	SV* c_func
	int i0
	short s1
	void * p2
PREINIT:
	void *(*func)(int, short, void *);
CODE:
	func   = INT2PTR(void *(*)(int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, p2);
OUTPUT:
	RETVAL

void
nci_visp( c_func, i0, s1, p2 )
	SV* c_func
	int i0
	short s1
	void * p2
PREINIT:
	void(*func)(int, short, void *);
CODE:
	func   = INT2PTR(void(*)(int, short, void *), SvIV(c_func) );
	(*func)(i0, s1, p2);

double
nci_disp( c_func, i0, s1, p2 )
	SV* c_func
	int i0
	short s1
	void * p2
PREINIT:
	double(*func)(int, short, void *);
CODE:
	func   = INT2PTR(double(*)(int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, p2);
OUTPUT:
	RETVAL

short
nci_sisp( c_func, i0, s1, p2 )
	SV* c_func
	int i0
	short s1
	void * p2
PREINIT:
	short(*func)(int, short, void *);
CODE:
	func   = INT2PTR(short(*)(int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, p2);
OUTPUT:
	RETVAL

float
nci_fisp( c_func, i0, s1, p2 )
	SV* c_func
	int i0
	short s1
	void * p2
PREINIT:
	float(*func)(int, short, void *);
CODE:
	func   = INT2PTR(float(*)(int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, p2);
OUTPUT:
	RETVAL

char *
nci_tisp( c_func, i0, s1, p2 )
	SV* c_func
	int i0
	short s1
	void * p2
PREINIT:
	char *(*func)(int, short, void *);
CODE:
	func   = INT2PTR(char *(*)(int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, p2);
OUTPUT:
	RETVAL

int
nci_iisp( c_func, i0, s1, p2 )
	SV* c_func
	int i0
	short s1
	void * p2
PREINIT:
	int(*func)(int, short, void *);
CODE:
	func   = INT2PTR(int(*)(int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, p2);
OUTPUT:
	RETVAL

void *
nci_ppfp( c_func, p0, f1, p2 )
	SV* c_func
	void * p0
	float f1
	void * p2
PREINIT:
	void *(*func)(void *, float, void *);
CODE:
	func   = INT2PTR(void *(*)(void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, p2);
OUTPUT:
	RETVAL

void
nci_vpfp( c_func, p0, f1, p2 )
	SV* c_func
	void * p0
	float f1
	void * p2
PREINIT:
	void(*func)(void *, float, void *);
CODE:
	func   = INT2PTR(void(*)(void *, float, void *), SvIV(c_func) );
	(*func)(p0, f1, p2);

double
nci_dpfp( c_func, p0, f1, p2 )
	SV* c_func
	void * p0
	float f1
	void * p2
PREINIT:
	double(*func)(void *, float, void *);
CODE:
	func   = INT2PTR(double(*)(void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, p2);
OUTPUT:
	RETVAL

short
nci_spfp( c_func, p0, f1, p2 )
	SV* c_func
	void * p0
	float f1
	void * p2
PREINIT:
	short(*func)(void *, float, void *);
CODE:
	func   = INT2PTR(short(*)(void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, p2);
OUTPUT:
	RETVAL

float
nci_fpfp( c_func, p0, f1, p2 )
	SV* c_func
	void * p0
	float f1
	void * p2
PREINIT:
	float(*func)(void *, float, void *);
CODE:
	func   = INT2PTR(float(*)(void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, p2);
OUTPUT:
	RETVAL

char *
nci_tpfp( c_func, p0, f1, p2 )
	SV* c_func
	void * p0
	float f1
	void * p2
PREINIT:
	char *(*func)(void *, float, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, p2);
OUTPUT:
	RETVAL

int
nci_ipfp( c_func, p0, f1, p2 )
	SV* c_func
	void * p0
	float f1
	void * p2
PREINIT:
	int(*func)(void *, float, void *);
CODE:
	func   = INT2PTR(int(*)(void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, p2);
OUTPUT:
	RETVAL

void *
nci_pvfp( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvfp( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvfp( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svfp( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvfp( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvfp( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivfp( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdfp( c_func, d0, f1, p2 )
	SV* c_func
	double d0
	float f1
	void * p2
PREINIT:
	void *(*func)(double, float, void *);
CODE:
	func   = INT2PTR(void *(*)(double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, p2);
OUTPUT:
	RETVAL

void
nci_vdfp( c_func, d0, f1, p2 )
	SV* c_func
	double d0
	float f1
	void * p2
PREINIT:
	void(*func)(double, float, void *);
CODE:
	func   = INT2PTR(void(*)(double, float, void *), SvIV(c_func) );
	(*func)(d0, f1, p2);

double
nci_ddfp( c_func, d0, f1, p2 )
	SV* c_func
	double d0
	float f1
	void * p2
PREINIT:
	double(*func)(double, float, void *);
CODE:
	func   = INT2PTR(double(*)(double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, p2);
OUTPUT:
	RETVAL

short
nci_sdfp( c_func, d0, f1, p2 )
	SV* c_func
	double d0
	float f1
	void * p2
PREINIT:
	short(*func)(double, float, void *);
CODE:
	func   = INT2PTR(short(*)(double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, p2);
OUTPUT:
	RETVAL

float
nci_fdfp( c_func, d0, f1, p2 )
	SV* c_func
	double d0
	float f1
	void * p2
PREINIT:
	float(*func)(double, float, void *);
CODE:
	func   = INT2PTR(float(*)(double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, p2);
OUTPUT:
	RETVAL

char *
nci_tdfp( c_func, d0, f1, p2 )
	SV* c_func
	double d0
	float f1
	void * p2
PREINIT:
	char *(*func)(double, float, void *);
CODE:
	func   = INT2PTR(char *(*)(double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, p2);
OUTPUT:
	RETVAL

int
nci_idfp( c_func, d0, f1, p2 )
	SV* c_func
	double d0
	float f1
	void * p2
PREINIT:
	int(*func)(double, float, void *);
CODE:
	func   = INT2PTR(int(*)(double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, p2);
OUTPUT:
	RETVAL

void *
nci_psfp( c_func, s0, f1, p2 )
	SV* c_func
	short s0
	float f1
	void * p2
PREINIT:
	void *(*func)(short, float, void *);
CODE:
	func   = INT2PTR(void *(*)(short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, p2);
OUTPUT:
	RETVAL

void
nci_vsfp( c_func, s0, f1, p2 )
	SV* c_func
	short s0
	float f1
	void * p2
PREINIT:
	void(*func)(short, float, void *);
CODE:
	func   = INT2PTR(void(*)(short, float, void *), SvIV(c_func) );
	(*func)(s0, f1, p2);

double
nci_dsfp( c_func, s0, f1, p2 )
	SV* c_func
	short s0
	float f1
	void * p2
PREINIT:
	double(*func)(short, float, void *);
CODE:
	func   = INT2PTR(double(*)(short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, p2);
OUTPUT:
	RETVAL

short
nci_ssfp( c_func, s0, f1, p2 )
	SV* c_func
	short s0
	float f1
	void * p2
PREINIT:
	short(*func)(short, float, void *);
CODE:
	func   = INT2PTR(short(*)(short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, p2);
OUTPUT:
	RETVAL

float
nci_fsfp( c_func, s0, f1, p2 )
	SV* c_func
	short s0
	float f1
	void * p2
PREINIT:
	float(*func)(short, float, void *);
CODE:
	func   = INT2PTR(float(*)(short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, p2);
OUTPUT:
	RETVAL

char *
nci_tsfp( c_func, s0, f1, p2 )
	SV* c_func
	short s0
	float f1
	void * p2
PREINIT:
	char *(*func)(short, float, void *);
CODE:
	func   = INT2PTR(char *(*)(short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, p2);
OUTPUT:
	RETVAL

int
nci_isfp( c_func, s0, f1, p2 )
	SV* c_func
	short s0
	float f1
	void * p2
PREINIT:
	int(*func)(short, float, void *);
CODE:
	func   = INT2PTR(int(*)(short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, p2);
OUTPUT:
	RETVAL

void *
nci_pffp( c_func, f0, f1, p2 )
	SV* c_func
	float f0
	float f1
	void * p2
PREINIT:
	void *(*func)(float, float, void *);
CODE:
	func   = INT2PTR(void *(*)(float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, p2);
OUTPUT:
	RETVAL

void
nci_vffp( c_func, f0, f1, p2 )
	SV* c_func
	float f0
	float f1
	void * p2
PREINIT:
	void(*func)(float, float, void *);
CODE:
	func   = INT2PTR(void(*)(float, float, void *), SvIV(c_func) );
	(*func)(f0, f1, p2);

double
nci_dffp( c_func, f0, f1, p2 )
	SV* c_func
	float f0
	float f1
	void * p2
PREINIT:
	double(*func)(float, float, void *);
CODE:
	func   = INT2PTR(double(*)(float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, p2);
OUTPUT:
	RETVAL

short
nci_sffp( c_func, f0, f1, p2 )
	SV* c_func
	float f0
	float f1
	void * p2
PREINIT:
	short(*func)(float, float, void *);
CODE:
	func   = INT2PTR(short(*)(float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, p2);
OUTPUT:
	RETVAL

float
nci_fffp( c_func, f0, f1, p2 )
	SV* c_func
	float f0
	float f1
	void * p2
PREINIT:
	float(*func)(float, float, void *);
CODE:
	func   = INT2PTR(float(*)(float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, p2);
OUTPUT:
	RETVAL

char *
nci_tffp( c_func, f0, f1, p2 )
	SV* c_func
	float f0
	float f1
	void * p2
PREINIT:
	char *(*func)(float, float, void *);
CODE:
	func   = INT2PTR(char *(*)(float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, p2);
OUTPUT:
	RETVAL

int
nci_iffp( c_func, f0, f1, p2 )
	SV* c_func
	float f0
	float f1
	void * p2
PREINIT:
	int(*func)(float, float, void *);
CODE:
	func   = INT2PTR(int(*)(float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, p2);
OUTPUT:
	RETVAL

void *
nci_ptfp( c_func, t0, f1, p2 )
	SV* c_func
	char * t0
	float f1
	void * p2
PREINIT:
	void *(*func)(char *, float, void *);
CODE:
	func   = INT2PTR(void *(*)(char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, p2);
OUTPUT:
	RETVAL

void
nci_vtfp( c_func, t0, f1, p2 )
	SV* c_func
	char * t0
	float f1
	void * p2
PREINIT:
	void(*func)(char *, float, void *);
CODE:
	func   = INT2PTR(void(*)(char *, float, void *), SvIV(c_func) );
	(*func)(t0, f1, p2);

double
nci_dtfp( c_func, t0, f1, p2 )
	SV* c_func
	char * t0
	float f1
	void * p2
PREINIT:
	double(*func)(char *, float, void *);
CODE:
	func   = INT2PTR(double(*)(char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, p2);
OUTPUT:
	RETVAL

short
nci_stfp( c_func, t0, f1, p2 )
	SV* c_func
	char * t0
	float f1
	void * p2
PREINIT:
	short(*func)(char *, float, void *);
CODE:
	func   = INT2PTR(short(*)(char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, p2);
OUTPUT:
	RETVAL

float
nci_ftfp( c_func, t0, f1, p2 )
	SV* c_func
	char * t0
	float f1
	void * p2
PREINIT:
	float(*func)(char *, float, void *);
CODE:
	func   = INT2PTR(float(*)(char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, p2);
OUTPUT:
	RETVAL

char *
nci_ttfp( c_func, t0, f1, p2 )
	SV* c_func
	char * t0
	float f1
	void * p2
PREINIT:
	char *(*func)(char *, float, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, p2);
OUTPUT:
	RETVAL

int
nci_itfp( c_func, t0, f1, p2 )
	SV* c_func
	char * t0
	float f1
	void * p2
PREINIT:
	int(*func)(char *, float, void *);
CODE:
	func   = INT2PTR(int(*)(char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, p2);
OUTPUT:
	RETVAL

void *
nci_pifp( c_func, i0, f1, p2 )
	SV* c_func
	int i0
	float f1
	void * p2
PREINIT:
	void *(*func)(int, float, void *);
CODE:
	func   = INT2PTR(void *(*)(int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, p2);
OUTPUT:
	RETVAL

void
nci_vifp( c_func, i0, f1, p2 )
	SV* c_func
	int i0
	float f1
	void * p2
PREINIT:
	void(*func)(int, float, void *);
CODE:
	func   = INT2PTR(void(*)(int, float, void *), SvIV(c_func) );
	(*func)(i0, f1, p2);

double
nci_difp( c_func, i0, f1, p2 )
	SV* c_func
	int i0
	float f1
	void * p2
PREINIT:
	double(*func)(int, float, void *);
CODE:
	func   = INT2PTR(double(*)(int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, p2);
OUTPUT:
	RETVAL

short
nci_sifp( c_func, i0, f1, p2 )
	SV* c_func
	int i0
	float f1
	void * p2
PREINIT:
	short(*func)(int, float, void *);
CODE:
	func   = INT2PTR(short(*)(int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, p2);
OUTPUT:
	RETVAL

float
nci_fifp( c_func, i0, f1, p2 )
	SV* c_func
	int i0
	float f1
	void * p2
PREINIT:
	float(*func)(int, float, void *);
CODE:
	func   = INT2PTR(float(*)(int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, p2);
OUTPUT:
	RETVAL

char *
nci_tifp( c_func, i0, f1, p2 )
	SV* c_func
	int i0
	float f1
	void * p2
PREINIT:
	char *(*func)(int, float, void *);
CODE:
	func   = INT2PTR(char *(*)(int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, p2);
OUTPUT:
	RETVAL

int
nci_iifp( c_func, i0, f1, p2 )
	SV* c_func
	int i0
	float f1
	void * p2
PREINIT:
	int(*func)(int, float, void *);
CODE:
	func   = INT2PTR(int(*)(int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, p2);
OUTPUT:
	RETVAL

void *
nci_pptp( c_func, p0, t1, p2 )
	SV* c_func
	void * p0
	char * t1
	void * p2
PREINIT:
	void *(*func)(void *, char *, void *);
CODE:
	func   = INT2PTR(void *(*)(void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, p2);
OUTPUT:
	RETVAL

void
nci_vptp( c_func, p0, t1, p2 )
	SV* c_func
	void * p0
	char * t1
	void * p2
PREINIT:
	void(*func)(void *, char *, void *);
CODE:
	func   = INT2PTR(void(*)(void *, char *, void *), SvIV(c_func) );
	(*func)(p0, t1, p2);

double
nci_dptp( c_func, p0, t1, p2 )
	SV* c_func
	void * p0
	char * t1
	void * p2
PREINIT:
	double(*func)(void *, char *, void *);
CODE:
	func   = INT2PTR(double(*)(void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, p2);
OUTPUT:
	RETVAL

short
nci_sptp( c_func, p0, t1, p2 )
	SV* c_func
	void * p0
	char * t1
	void * p2
PREINIT:
	short(*func)(void *, char *, void *);
CODE:
	func   = INT2PTR(short(*)(void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, p2);
OUTPUT:
	RETVAL

float
nci_fptp( c_func, p0, t1, p2 )
	SV* c_func
	void * p0
	char * t1
	void * p2
PREINIT:
	float(*func)(void *, char *, void *);
CODE:
	func   = INT2PTR(float(*)(void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, p2);
OUTPUT:
	RETVAL

char *
nci_tptp( c_func, p0, t1, p2 )
	SV* c_func
	void * p0
	char * t1
	void * p2
PREINIT:
	char *(*func)(void *, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, p2);
OUTPUT:
	RETVAL

int
nci_iptp( c_func, p0, t1, p2 )
	SV* c_func
	void * p0
	char * t1
	void * p2
PREINIT:
	int(*func)(void *, char *, void *);
CODE:
	func   = INT2PTR(int(*)(void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, p2);
OUTPUT:
	RETVAL

void *
nci_pvtp( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvtp( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvtp( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svtp( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvtp( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvtp( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivtp( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdtp( c_func, d0, t1, p2 )
	SV* c_func
	double d0
	char * t1
	void * p2
PREINIT:
	void *(*func)(double, char *, void *);
CODE:
	func   = INT2PTR(void *(*)(double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, p2);
OUTPUT:
	RETVAL

void
nci_vdtp( c_func, d0, t1, p2 )
	SV* c_func
	double d0
	char * t1
	void * p2
PREINIT:
	void(*func)(double, char *, void *);
CODE:
	func   = INT2PTR(void(*)(double, char *, void *), SvIV(c_func) );
	(*func)(d0, t1, p2);

double
nci_ddtp( c_func, d0, t1, p2 )
	SV* c_func
	double d0
	char * t1
	void * p2
PREINIT:
	double(*func)(double, char *, void *);
CODE:
	func   = INT2PTR(double(*)(double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, p2);
OUTPUT:
	RETVAL

short
nci_sdtp( c_func, d0, t1, p2 )
	SV* c_func
	double d0
	char * t1
	void * p2
PREINIT:
	short(*func)(double, char *, void *);
CODE:
	func   = INT2PTR(short(*)(double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, p2);
OUTPUT:
	RETVAL

float
nci_fdtp( c_func, d0, t1, p2 )
	SV* c_func
	double d0
	char * t1
	void * p2
PREINIT:
	float(*func)(double, char *, void *);
CODE:
	func   = INT2PTR(float(*)(double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, p2);
OUTPUT:
	RETVAL

char *
nci_tdtp( c_func, d0, t1, p2 )
	SV* c_func
	double d0
	char * t1
	void * p2
PREINIT:
	char *(*func)(double, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, p2);
OUTPUT:
	RETVAL

int
nci_idtp( c_func, d0, t1, p2 )
	SV* c_func
	double d0
	char * t1
	void * p2
PREINIT:
	int(*func)(double, char *, void *);
CODE:
	func   = INT2PTR(int(*)(double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, p2);
OUTPUT:
	RETVAL

void *
nci_pstp( c_func, s0, t1, p2 )
	SV* c_func
	short s0
	char * t1
	void * p2
PREINIT:
	void *(*func)(short, char *, void *);
CODE:
	func   = INT2PTR(void *(*)(short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, p2);
OUTPUT:
	RETVAL

void
nci_vstp( c_func, s0, t1, p2 )
	SV* c_func
	short s0
	char * t1
	void * p2
PREINIT:
	void(*func)(short, char *, void *);
CODE:
	func   = INT2PTR(void(*)(short, char *, void *), SvIV(c_func) );
	(*func)(s0, t1, p2);

double
nci_dstp( c_func, s0, t1, p2 )
	SV* c_func
	short s0
	char * t1
	void * p2
PREINIT:
	double(*func)(short, char *, void *);
CODE:
	func   = INT2PTR(double(*)(short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, p2);
OUTPUT:
	RETVAL

short
nci_sstp( c_func, s0, t1, p2 )
	SV* c_func
	short s0
	char * t1
	void * p2
PREINIT:
	short(*func)(short, char *, void *);
CODE:
	func   = INT2PTR(short(*)(short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, p2);
OUTPUT:
	RETVAL

float
nci_fstp( c_func, s0, t1, p2 )
	SV* c_func
	short s0
	char * t1
	void * p2
PREINIT:
	float(*func)(short, char *, void *);
CODE:
	func   = INT2PTR(float(*)(short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, p2);
OUTPUT:
	RETVAL

char *
nci_tstp( c_func, s0, t1, p2 )
	SV* c_func
	short s0
	char * t1
	void * p2
PREINIT:
	char *(*func)(short, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, p2);
OUTPUT:
	RETVAL

int
nci_istp( c_func, s0, t1, p2 )
	SV* c_func
	short s0
	char * t1
	void * p2
PREINIT:
	int(*func)(short, char *, void *);
CODE:
	func   = INT2PTR(int(*)(short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, p2);
OUTPUT:
	RETVAL

void *
nci_pftp( c_func, f0, t1, p2 )
	SV* c_func
	float f0
	char * t1
	void * p2
PREINIT:
	void *(*func)(float, char *, void *);
CODE:
	func   = INT2PTR(void *(*)(float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, p2);
OUTPUT:
	RETVAL

void
nci_vftp( c_func, f0, t1, p2 )
	SV* c_func
	float f0
	char * t1
	void * p2
PREINIT:
	void(*func)(float, char *, void *);
CODE:
	func   = INT2PTR(void(*)(float, char *, void *), SvIV(c_func) );
	(*func)(f0, t1, p2);

double
nci_dftp( c_func, f0, t1, p2 )
	SV* c_func
	float f0
	char * t1
	void * p2
PREINIT:
	double(*func)(float, char *, void *);
CODE:
	func   = INT2PTR(double(*)(float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, p2);
OUTPUT:
	RETVAL

short
nci_sftp( c_func, f0, t1, p2 )
	SV* c_func
	float f0
	char * t1
	void * p2
PREINIT:
	short(*func)(float, char *, void *);
CODE:
	func   = INT2PTR(short(*)(float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, p2);
OUTPUT:
	RETVAL

float
nci_fftp( c_func, f0, t1, p2 )
	SV* c_func
	float f0
	char * t1
	void * p2
PREINIT:
	float(*func)(float, char *, void *);
CODE:
	func   = INT2PTR(float(*)(float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, p2);
OUTPUT:
	RETVAL

char *
nci_tftp( c_func, f0, t1, p2 )
	SV* c_func
	float f0
	char * t1
	void * p2
PREINIT:
	char *(*func)(float, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, p2);
OUTPUT:
	RETVAL

int
nci_iftp( c_func, f0, t1, p2 )
	SV* c_func
	float f0
	char * t1
	void * p2
PREINIT:
	int(*func)(float, char *, void *);
CODE:
	func   = INT2PTR(int(*)(float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, p2);
OUTPUT:
	RETVAL

void *
nci_pttp( c_func, t0, t1, p2 )
	SV* c_func
	char * t0
	char * t1
	void * p2
PREINIT:
	void *(*func)(char *, char *, void *);
CODE:
	func   = INT2PTR(void *(*)(char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, p2);
OUTPUT:
	RETVAL

void
nci_vttp( c_func, t0, t1, p2 )
	SV* c_func
	char * t0
	char * t1
	void * p2
PREINIT:
	void(*func)(char *, char *, void *);
CODE:
	func   = INT2PTR(void(*)(char *, char *, void *), SvIV(c_func) );
	(*func)(t0, t1, p2);

double
nci_dttp( c_func, t0, t1, p2 )
	SV* c_func
	char * t0
	char * t1
	void * p2
PREINIT:
	double(*func)(char *, char *, void *);
CODE:
	func   = INT2PTR(double(*)(char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, p2);
OUTPUT:
	RETVAL

short
nci_sttp( c_func, t0, t1, p2 )
	SV* c_func
	char * t0
	char * t1
	void * p2
PREINIT:
	short(*func)(char *, char *, void *);
CODE:
	func   = INT2PTR(short(*)(char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, p2);
OUTPUT:
	RETVAL

float
nci_fttp( c_func, t0, t1, p2 )
	SV* c_func
	char * t0
	char * t1
	void * p2
PREINIT:
	float(*func)(char *, char *, void *);
CODE:
	func   = INT2PTR(float(*)(char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, p2);
OUTPUT:
	RETVAL

char *
nci_tttp( c_func, t0, t1, p2 )
	SV* c_func
	char * t0
	char * t1
	void * p2
PREINIT:
	char *(*func)(char *, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, p2);
OUTPUT:
	RETVAL

int
nci_ittp( c_func, t0, t1, p2 )
	SV* c_func
	char * t0
	char * t1
	void * p2
PREINIT:
	int(*func)(char *, char *, void *);
CODE:
	func   = INT2PTR(int(*)(char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, p2);
OUTPUT:
	RETVAL

void *
nci_pitp( c_func, i0, t1, p2 )
	SV* c_func
	int i0
	char * t1
	void * p2
PREINIT:
	void *(*func)(int, char *, void *);
CODE:
	func   = INT2PTR(void *(*)(int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, p2);
OUTPUT:
	RETVAL

void
nci_vitp( c_func, i0, t1, p2 )
	SV* c_func
	int i0
	char * t1
	void * p2
PREINIT:
	void(*func)(int, char *, void *);
CODE:
	func   = INT2PTR(void(*)(int, char *, void *), SvIV(c_func) );
	(*func)(i0, t1, p2);

double
nci_ditp( c_func, i0, t1, p2 )
	SV* c_func
	int i0
	char * t1
	void * p2
PREINIT:
	double(*func)(int, char *, void *);
CODE:
	func   = INT2PTR(double(*)(int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, p2);
OUTPUT:
	RETVAL

short
nci_sitp( c_func, i0, t1, p2 )
	SV* c_func
	int i0
	char * t1
	void * p2
PREINIT:
	short(*func)(int, char *, void *);
CODE:
	func   = INT2PTR(short(*)(int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, p2);
OUTPUT:
	RETVAL

float
nci_fitp( c_func, i0, t1, p2 )
	SV* c_func
	int i0
	char * t1
	void * p2
PREINIT:
	float(*func)(int, char *, void *);
CODE:
	func   = INT2PTR(float(*)(int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, p2);
OUTPUT:
	RETVAL

char *
nci_titp( c_func, i0, t1, p2 )
	SV* c_func
	int i0
	char * t1
	void * p2
PREINIT:
	char *(*func)(int, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, p2);
OUTPUT:
	RETVAL

int
nci_iitp( c_func, i0, t1, p2 )
	SV* c_func
	int i0
	char * t1
	void * p2
PREINIT:
	int(*func)(int, char *, void *);
CODE:
	func   = INT2PTR(int(*)(int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, p2);
OUTPUT:
	RETVAL

void *
nci_ppip( c_func, p0, i1, p2 )
	SV* c_func
	void * p0
	int i1
	void * p2
PREINIT:
	void *(*func)(void *, int, void *);
CODE:
	func   = INT2PTR(void *(*)(void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, p2);
OUTPUT:
	RETVAL

void
nci_vpip( c_func, p0, i1, p2 )
	SV* c_func
	void * p0
	int i1
	void * p2
PREINIT:
	void(*func)(void *, int, void *);
CODE:
	func   = INT2PTR(void(*)(void *, int, void *), SvIV(c_func) );
	(*func)(p0, i1, p2);

double
nci_dpip( c_func, p0, i1, p2 )
	SV* c_func
	void * p0
	int i1
	void * p2
PREINIT:
	double(*func)(void *, int, void *);
CODE:
	func   = INT2PTR(double(*)(void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, p2);
OUTPUT:
	RETVAL

short
nci_spip( c_func, p0, i1, p2 )
	SV* c_func
	void * p0
	int i1
	void * p2
PREINIT:
	short(*func)(void *, int, void *);
CODE:
	func   = INT2PTR(short(*)(void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, p2);
OUTPUT:
	RETVAL

float
nci_fpip( c_func, p0, i1, p2 )
	SV* c_func
	void * p0
	int i1
	void * p2
PREINIT:
	float(*func)(void *, int, void *);
CODE:
	func   = INT2PTR(float(*)(void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, p2);
OUTPUT:
	RETVAL

char *
nci_tpip( c_func, p0, i1, p2 )
	SV* c_func
	void * p0
	int i1
	void * p2
PREINIT:
	char *(*func)(void *, int, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, p2);
OUTPUT:
	RETVAL

int
nci_ipip( c_func, p0, i1, p2 )
	SV* c_func
	void * p0
	int i1
	void * p2
PREINIT:
	int(*func)(void *, int, void *);
CODE:
	func   = INT2PTR(int(*)(void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, p2);
OUTPUT:
	RETVAL

void *
nci_pvip( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvip( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvip( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svip( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvip( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvip( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivip( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdip( c_func, d0, i1, p2 )
	SV* c_func
	double d0
	int i1
	void * p2
PREINIT:
	void *(*func)(double, int, void *);
CODE:
	func   = INT2PTR(void *(*)(double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, p2);
OUTPUT:
	RETVAL

void
nci_vdip( c_func, d0, i1, p2 )
	SV* c_func
	double d0
	int i1
	void * p2
PREINIT:
	void(*func)(double, int, void *);
CODE:
	func   = INT2PTR(void(*)(double, int, void *), SvIV(c_func) );
	(*func)(d0, i1, p2);

double
nci_ddip( c_func, d0, i1, p2 )
	SV* c_func
	double d0
	int i1
	void * p2
PREINIT:
	double(*func)(double, int, void *);
CODE:
	func   = INT2PTR(double(*)(double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, p2);
OUTPUT:
	RETVAL

short
nci_sdip( c_func, d0, i1, p2 )
	SV* c_func
	double d0
	int i1
	void * p2
PREINIT:
	short(*func)(double, int, void *);
CODE:
	func   = INT2PTR(short(*)(double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, p2);
OUTPUT:
	RETVAL

float
nci_fdip( c_func, d0, i1, p2 )
	SV* c_func
	double d0
	int i1
	void * p2
PREINIT:
	float(*func)(double, int, void *);
CODE:
	func   = INT2PTR(float(*)(double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, p2);
OUTPUT:
	RETVAL

char *
nci_tdip( c_func, d0, i1, p2 )
	SV* c_func
	double d0
	int i1
	void * p2
PREINIT:
	char *(*func)(double, int, void *);
CODE:
	func   = INT2PTR(char *(*)(double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, p2);
OUTPUT:
	RETVAL

int
nci_idip( c_func, d0, i1, p2 )
	SV* c_func
	double d0
	int i1
	void * p2
PREINIT:
	int(*func)(double, int, void *);
CODE:
	func   = INT2PTR(int(*)(double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, p2);
OUTPUT:
	RETVAL

void *
nci_psip( c_func, s0, i1, p2 )
	SV* c_func
	short s0
	int i1
	void * p2
PREINIT:
	void *(*func)(short, int, void *);
CODE:
	func   = INT2PTR(void *(*)(short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, p2);
OUTPUT:
	RETVAL

void
nci_vsip( c_func, s0, i1, p2 )
	SV* c_func
	short s0
	int i1
	void * p2
PREINIT:
	void(*func)(short, int, void *);
CODE:
	func   = INT2PTR(void(*)(short, int, void *), SvIV(c_func) );
	(*func)(s0, i1, p2);

double
nci_dsip( c_func, s0, i1, p2 )
	SV* c_func
	short s0
	int i1
	void * p2
PREINIT:
	double(*func)(short, int, void *);
CODE:
	func   = INT2PTR(double(*)(short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, p2);
OUTPUT:
	RETVAL

short
nci_ssip( c_func, s0, i1, p2 )
	SV* c_func
	short s0
	int i1
	void * p2
PREINIT:
	short(*func)(short, int, void *);
CODE:
	func   = INT2PTR(short(*)(short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, p2);
OUTPUT:
	RETVAL

float
nci_fsip( c_func, s0, i1, p2 )
	SV* c_func
	short s0
	int i1
	void * p2
PREINIT:
	float(*func)(short, int, void *);
CODE:
	func   = INT2PTR(float(*)(short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, p2);
OUTPUT:
	RETVAL

char *
nci_tsip( c_func, s0, i1, p2 )
	SV* c_func
	short s0
	int i1
	void * p2
PREINIT:
	char *(*func)(short, int, void *);
CODE:
	func   = INT2PTR(char *(*)(short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, p2);
OUTPUT:
	RETVAL

int
nci_isip( c_func, s0, i1, p2 )
	SV* c_func
	short s0
	int i1
	void * p2
PREINIT:
	int(*func)(short, int, void *);
CODE:
	func   = INT2PTR(int(*)(short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, p2);
OUTPUT:
	RETVAL

void *
nci_pfip( c_func, f0, i1, p2 )
	SV* c_func
	float f0
	int i1
	void * p2
PREINIT:
	void *(*func)(float, int, void *);
CODE:
	func   = INT2PTR(void *(*)(float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, p2);
OUTPUT:
	RETVAL

void
nci_vfip( c_func, f0, i1, p2 )
	SV* c_func
	float f0
	int i1
	void * p2
PREINIT:
	void(*func)(float, int, void *);
CODE:
	func   = INT2PTR(void(*)(float, int, void *), SvIV(c_func) );
	(*func)(f0, i1, p2);

double
nci_dfip( c_func, f0, i1, p2 )
	SV* c_func
	float f0
	int i1
	void * p2
PREINIT:
	double(*func)(float, int, void *);
CODE:
	func   = INT2PTR(double(*)(float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, p2);
OUTPUT:
	RETVAL

short
nci_sfip( c_func, f0, i1, p2 )
	SV* c_func
	float f0
	int i1
	void * p2
PREINIT:
	short(*func)(float, int, void *);
CODE:
	func   = INT2PTR(short(*)(float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, p2);
OUTPUT:
	RETVAL

float
nci_ffip( c_func, f0, i1, p2 )
	SV* c_func
	float f0
	int i1
	void * p2
PREINIT:
	float(*func)(float, int, void *);
CODE:
	func   = INT2PTR(float(*)(float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, p2);
OUTPUT:
	RETVAL

char *
nci_tfip( c_func, f0, i1, p2 )
	SV* c_func
	float f0
	int i1
	void * p2
PREINIT:
	char *(*func)(float, int, void *);
CODE:
	func   = INT2PTR(char *(*)(float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, p2);
OUTPUT:
	RETVAL

int
nci_ifip( c_func, f0, i1, p2 )
	SV* c_func
	float f0
	int i1
	void * p2
PREINIT:
	int(*func)(float, int, void *);
CODE:
	func   = INT2PTR(int(*)(float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, p2);
OUTPUT:
	RETVAL

void *
nci_ptip( c_func, t0, i1, p2 )
	SV* c_func
	char * t0
	int i1
	void * p2
PREINIT:
	void *(*func)(char *, int, void *);
CODE:
	func   = INT2PTR(void *(*)(char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, p2);
OUTPUT:
	RETVAL

void
nci_vtip( c_func, t0, i1, p2 )
	SV* c_func
	char * t0
	int i1
	void * p2
PREINIT:
	void(*func)(char *, int, void *);
CODE:
	func   = INT2PTR(void(*)(char *, int, void *), SvIV(c_func) );
	(*func)(t0, i1, p2);

double
nci_dtip( c_func, t0, i1, p2 )
	SV* c_func
	char * t0
	int i1
	void * p2
PREINIT:
	double(*func)(char *, int, void *);
CODE:
	func   = INT2PTR(double(*)(char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, p2);
OUTPUT:
	RETVAL

short
nci_stip( c_func, t0, i1, p2 )
	SV* c_func
	char * t0
	int i1
	void * p2
PREINIT:
	short(*func)(char *, int, void *);
CODE:
	func   = INT2PTR(short(*)(char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, p2);
OUTPUT:
	RETVAL

float
nci_ftip( c_func, t0, i1, p2 )
	SV* c_func
	char * t0
	int i1
	void * p2
PREINIT:
	float(*func)(char *, int, void *);
CODE:
	func   = INT2PTR(float(*)(char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, p2);
OUTPUT:
	RETVAL

char *
nci_ttip( c_func, t0, i1, p2 )
	SV* c_func
	char * t0
	int i1
	void * p2
PREINIT:
	char *(*func)(char *, int, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, p2);
OUTPUT:
	RETVAL

int
nci_itip( c_func, t0, i1, p2 )
	SV* c_func
	char * t0
	int i1
	void * p2
PREINIT:
	int(*func)(char *, int, void *);
CODE:
	func   = INT2PTR(int(*)(char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, p2);
OUTPUT:
	RETVAL

void *
nci_piip( c_func, i0, i1, p2 )
	SV* c_func
	int i0
	int i1
	void * p2
PREINIT:
	void *(*func)(int, int, void *);
CODE:
	func   = INT2PTR(void *(*)(int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, p2);
OUTPUT:
	RETVAL

void
nci_viip( c_func, i0, i1, p2 )
	SV* c_func
	int i0
	int i1
	void * p2
PREINIT:
	void(*func)(int, int, void *);
CODE:
	func   = INT2PTR(void(*)(int, int, void *), SvIV(c_func) );
	(*func)(i0, i1, p2);

double
nci_diip( c_func, i0, i1, p2 )
	SV* c_func
	int i0
	int i1
	void * p2
PREINIT:
	double(*func)(int, int, void *);
CODE:
	func   = INT2PTR(double(*)(int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, p2);
OUTPUT:
	RETVAL

short
nci_siip( c_func, i0, i1, p2 )
	SV* c_func
	int i0
	int i1
	void * p2
PREINIT:
	short(*func)(int, int, void *);
CODE:
	func   = INT2PTR(short(*)(int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, p2);
OUTPUT:
	RETVAL

float
nci_fiip( c_func, i0, i1, p2 )
	SV* c_func
	int i0
	int i1
	void * p2
PREINIT:
	float(*func)(int, int, void *);
CODE:
	func   = INT2PTR(float(*)(int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, p2);
OUTPUT:
	RETVAL

char *
nci_tiip( c_func, i0, i1, p2 )
	SV* c_func
	int i0
	int i1
	void * p2
PREINIT:
	char *(*func)(int, int, void *);
CODE:
	func   = INT2PTR(char *(*)(int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, p2);
OUTPUT:
	RETVAL

int
nci_iiip( c_func, i0, i1, p2 )
	SV* c_func
	int i0
	int i1
	void * p2
PREINIT:
	int(*func)(int, int, void *);
CODE:
	func   = INT2PTR(int(*)(int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, p2);
OUTPUT:
	RETVAL

void *
nci_pppd( c_func, p0, p1, d2 )
	SV* c_func
	void * p0
	void * p1
	double d2
PREINIT:
	void *(*func)(void *, void *, double);
CODE:
	func   = INT2PTR(void *(*)(void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, d2);
OUTPUT:
	RETVAL

void
nci_vppd( c_func, p0, p1, d2 )
	SV* c_func
	void * p0
	void * p1
	double d2
PREINIT:
	void(*func)(void *, void *, double);
CODE:
	func   = INT2PTR(void(*)(void *, void *, double), SvIV(c_func) );
	(*func)(p0, p1, d2);

double
nci_dppd( c_func, p0, p1, d2 )
	SV* c_func
	void * p0
	void * p1
	double d2
PREINIT:
	double(*func)(void *, void *, double);
CODE:
	func   = INT2PTR(double(*)(void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, d2);
OUTPUT:
	RETVAL

short
nci_sppd( c_func, p0, p1, d2 )
	SV* c_func
	void * p0
	void * p1
	double d2
PREINIT:
	short(*func)(void *, void *, double);
CODE:
	func   = INT2PTR(short(*)(void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, d2);
OUTPUT:
	RETVAL

float
nci_fppd( c_func, p0, p1, d2 )
	SV* c_func
	void * p0
	void * p1
	double d2
PREINIT:
	float(*func)(void *, void *, double);
CODE:
	func   = INT2PTR(float(*)(void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, d2);
OUTPUT:
	RETVAL

char *
nci_tppd( c_func, p0, p1, d2 )
	SV* c_func
	void * p0
	void * p1
	double d2
PREINIT:
	char *(*func)(void *, void *, double);
CODE:
	func   = INT2PTR(char *(*)(void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, d2);
OUTPUT:
	RETVAL

int
nci_ippd( c_func, p0, p1, d2 )
	SV* c_func
	void * p0
	void * p1
	double d2
PREINIT:
	int(*func)(void *, void *, double);
CODE:
	func   = INT2PTR(int(*)(void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, d2);
OUTPUT:
	RETVAL

void *
nci_pvpd( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvpd( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvpd( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svpd( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvpd( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvpd( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivpd( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdpd( c_func, d0, p1, d2 )
	SV* c_func
	double d0
	void * p1
	double d2
PREINIT:
	void *(*func)(double, void *, double);
CODE:
	func   = INT2PTR(void *(*)(double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, d2);
OUTPUT:
	RETVAL

void
nci_vdpd( c_func, d0, p1, d2 )
	SV* c_func
	double d0
	void * p1
	double d2
PREINIT:
	void(*func)(double, void *, double);
CODE:
	func   = INT2PTR(void(*)(double, void *, double), SvIV(c_func) );
	(*func)(d0, p1, d2);

double
nci_ddpd( c_func, d0, p1, d2 )
	SV* c_func
	double d0
	void * p1
	double d2
PREINIT:
	double(*func)(double, void *, double);
CODE:
	func   = INT2PTR(double(*)(double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, d2);
OUTPUT:
	RETVAL

short
nci_sdpd( c_func, d0, p1, d2 )
	SV* c_func
	double d0
	void * p1
	double d2
PREINIT:
	short(*func)(double, void *, double);
CODE:
	func   = INT2PTR(short(*)(double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, d2);
OUTPUT:
	RETVAL

float
nci_fdpd( c_func, d0, p1, d2 )
	SV* c_func
	double d0
	void * p1
	double d2
PREINIT:
	float(*func)(double, void *, double);
CODE:
	func   = INT2PTR(float(*)(double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, d2);
OUTPUT:
	RETVAL

char *
nci_tdpd( c_func, d0, p1, d2 )
	SV* c_func
	double d0
	void * p1
	double d2
PREINIT:
	char *(*func)(double, void *, double);
CODE:
	func   = INT2PTR(char *(*)(double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, d2);
OUTPUT:
	RETVAL

int
nci_idpd( c_func, d0, p1, d2 )
	SV* c_func
	double d0
	void * p1
	double d2
PREINIT:
	int(*func)(double, void *, double);
CODE:
	func   = INT2PTR(int(*)(double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, d2);
OUTPUT:
	RETVAL

void *
nci_pspd( c_func, s0, p1, d2 )
	SV* c_func
	short s0
	void * p1
	double d2
PREINIT:
	void *(*func)(short, void *, double);
CODE:
	func   = INT2PTR(void *(*)(short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, d2);
OUTPUT:
	RETVAL

void
nci_vspd( c_func, s0, p1, d2 )
	SV* c_func
	short s0
	void * p1
	double d2
PREINIT:
	void(*func)(short, void *, double);
CODE:
	func   = INT2PTR(void(*)(short, void *, double), SvIV(c_func) );
	(*func)(s0, p1, d2);

double
nci_dspd( c_func, s0, p1, d2 )
	SV* c_func
	short s0
	void * p1
	double d2
PREINIT:
	double(*func)(short, void *, double);
CODE:
	func   = INT2PTR(double(*)(short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, d2);
OUTPUT:
	RETVAL

short
nci_sspd( c_func, s0, p1, d2 )
	SV* c_func
	short s0
	void * p1
	double d2
PREINIT:
	short(*func)(short, void *, double);
CODE:
	func   = INT2PTR(short(*)(short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, d2);
OUTPUT:
	RETVAL

float
nci_fspd( c_func, s0, p1, d2 )
	SV* c_func
	short s0
	void * p1
	double d2
PREINIT:
	float(*func)(short, void *, double);
CODE:
	func   = INT2PTR(float(*)(short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, d2);
OUTPUT:
	RETVAL

char *
nci_tspd( c_func, s0, p1, d2 )
	SV* c_func
	short s0
	void * p1
	double d2
PREINIT:
	char *(*func)(short, void *, double);
CODE:
	func   = INT2PTR(char *(*)(short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, d2);
OUTPUT:
	RETVAL

int
nci_ispd( c_func, s0, p1, d2 )
	SV* c_func
	short s0
	void * p1
	double d2
PREINIT:
	int(*func)(short, void *, double);
CODE:
	func   = INT2PTR(int(*)(short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, d2);
OUTPUT:
	RETVAL

void *
nci_pfpd( c_func, f0, p1, d2 )
	SV* c_func
	float f0
	void * p1
	double d2
PREINIT:
	void *(*func)(float, void *, double);
CODE:
	func   = INT2PTR(void *(*)(float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, d2);
OUTPUT:
	RETVAL

void
nci_vfpd( c_func, f0, p1, d2 )
	SV* c_func
	float f0
	void * p1
	double d2
PREINIT:
	void(*func)(float, void *, double);
CODE:
	func   = INT2PTR(void(*)(float, void *, double), SvIV(c_func) );
	(*func)(f0, p1, d2);

double
nci_dfpd( c_func, f0, p1, d2 )
	SV* c_func
	float f0
	void * p1
	double d2
PREINIT:
	double(*func)(float, void *, double);
CODE:
	func   = INT2PTR(double(*)(float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, d2);
OUTPUT:
	RETVAL

short
nci_sfpd( c_func, f0, p1, d2 )
	SV* c_func
	float f0
	void * p1
	double d2
PREINIT:
	short(*func)(float, void *, double);
CODE:
	func   = INT2PTR(short(*)(float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, d2);
OUTPUT:
	RETVAL

float
nci_ffpd( c_func, f0, p1, d2 )
	SV* c_func
	float f0
	void * p1
	double d2
PREINIT:
	float(*func)(float, void *, double);
CODE:
	func   = INT2PTR(float(*)(float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, d2);
OUTPUT:
	RETVAL

char *
nci_tfpd( c_func, f0, p1, d2 )
	SV* c_func
	float f0
	void * p1
	double d2
PREINIT:
	char *(*func)(float, void *, double);
CODE:
	func   = INT2PTR(char *(*)(float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, d2);
OUTPUT:
	RETVAL

int
nci_ifpd( c_func, f0, p1, d2 )
	SV* c_func
	float f0
	void * p1
	double d2
PREINIT:
	int(*func)(float, void *, double);
CODE:
	func   = INT2PTR(int(*)(float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, d2);
OUTPUT:
	RETVAL

void *
nci_ptpd( c_func, t0, p1, d2 )
	SV* c_func
	char * t0
	void * p1
	double d2
PREINIT:
	void *(*func)(char *, void *, double);
CODE:
	func   = INT2PTR(void *(*)(char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, d2);
OUTPUT:
	RETVAL

void
nci_vtpd( c_func, t0, p1, d2 )
	SV* c_func
	char * t0
	void * p1
	double d2
PREINIT:
	void(*func)(char *, void *, double);
CODE:
	func   = INT2PTR(void(*)(char *, void *, double), SvIV(c_func) );
	(*func)(t0, p1, d2);

double
nci_dtpd( c_func, t0, p1, d2 )
	SV* c_func
	char * t0
	void * p1
	double d2
PREINIT:
	double(*func)(char *, void *, double);
CODE:
	func   = INT2PTR(double(*)(char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, d2);
OUTPUT:
	RETVAL

short
nci_stpd( c_func, t0, p1, d2 )
	SV* c_func
	char * t0
	void * p1
	double d2
PREINIT:
	short(*func)(char *, void *, double);
CODE:
	func   = INT2PTR(short(*)(char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, d2);
OUTPUT:
	RETVAL

float
nci_ftpd( c_func, t0, p1, d2 )
	SV* c_func
	char * t0
	void * p1
	double d2
PREINIT:
	float(*func)(char *, void *, double);
CODE:
	func   = INT2PTR(float(*)(char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, d2);
OUTPUT:
	RETVAL

char *
nci_ttpd( c_func, t0, p1, d2 )
	SV* c_func
	char * t0
	void * p1
	double d2
PREINIT:
	char *(*func)(char *, void *, double);
CODE:
	func   = INT2PTR(char *(*)(char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, d2);
OUTPUT:
	RETVAL

int
nci_itpd( c_func, t0, p1, d2 )
	SV* c_func
	char * t0
	void * p1
	double d2
PREINIT:
	int(*func)(char *, void *, double);
CODE:
	func   = INT2PTR(int(*)(char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, d2);
OUTPUT:
	RETVAL

void *
nci_pipd( c_func, i0, p1, d2 )
	SV* c_func
	int i0
	void * p1
	double d2
PREINIT:
	void *(*func)(int, void *, double);
CODE:
	func   = INT2PTR(void *(*)(int, void *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, d2);
OUTPUT:
	RETVAL

void
nci_vipd( c_func, i0, p1, d2 )
	SV* c_func
	int i0
	void * p1
	double d2
PREINIT:
	void(*func)(int, void *, double);
CODE:
	func   = INT2PTR(void(*)(int, void *, double), SvIV(c_func) );
	(*func)(i0, p1, d2);

double
nci_dipd( c_func, i0, p1, d2 )
	SV* c_func
	int i0
	void * p1
	double d2
PREINIT:
	double(*func)(int, void *, double);
CODE:
	func   = INT2PTR(double(*)(int, void *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, d2);
OUTPUT:
	RETVAL

short
nci_sipd( c_func, i0, p1, d2 )
	SV* c_func
	int i0
	void * p1
	double d2
PREINIT:
	short(*func)(int, void *, double);
CODE:
	func   = INT2PTR(short(*)(int, void *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, d2);
OUTPUT:
	RETVAL

float
nci_fipd( c_func, i0, p1, d2 )
	SV* c_func
	int i0
	void * p1
	double d2
PREINIT:
	float(*func)(int, void *, double);
CODE:
	func   = INT2PTR(float(*)(int, void *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, d2);
OUTPUT:
	RETVAL

char *
nci_tipd( c_func, i0, p1, d2 )
	SV* c_func
	int i0
	void * p1
	double d2
PREINIT:
	char *(*func)(int, void *, double);
CODE:
	func   = INT2PTR(char *(*)(int, void *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, d2);
OUTPUT:
	RETVAL

int
nci_iipd( c_func, i0, p1, d2 )
	SV* c_func
	int i0
	void * p1
	double d2
PREINIT:
	int(*func)(int, void *, double);
CODE:
	func   = INT2PTR(int(*)(int, void *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, d2);
OUTPUT:
	RETVAL

void *
nci_ppdd( c_func, p0, d1, d2 )
	SV* c_func
	void * p0
	double d1
	double d2
PREINIT:
	void *(*func)(void *, double, double);
CODE:
	func   = INT2PTR(void *(*)(void *, double, double), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, d2);
OUTPUT:
	RETVAL

void
nci_vpdd( c_func, p0, d1, d2 )
	SV* c_func
	void * p0
	double d1
	double d2
PREINIT:
	void(*func)(void *, double, double);
CODE:
	func   = INT2PTR(void(*)(void *, double, double), SvIV(c_func) );
	(*func)(p0, d1, d2);

double
nci_dpdd( c_func, p0, d1, d2 )
	SV* c_func
	void * p0
	double d1
	double d2
PREINIT:
	double(*func)(void *, double, double);
CODE:
	func   = INT2PTR(double(*)(void *, double, double), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, d2);
OUTPUT:
	RETVAL

short
nci_spdd( c_func, p0, d1, d2 )
	SV* c_func
	void * p0
	double d1
	double d2
PREINIT:
	short(*func)(void *, double, double);
CODE:
	func   = INT2PTR(short(*)(void *, double, double), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, d2);
OUTPUT:
	RETVAL

float
nci_fpdd( c_func, p0, d1, d2 )
	SV* c_func
	void * p0
	double d1
	double d2
PREINIT:
	float(*func)(void *, double, double);
CODE:
	func   = INT2PTR(float(*)(void *, double, double), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, d2);
OUTPUT:
	RETVAL

char *
nci_tpdd( c_func, p0, d1, d2 )
	SV* c_func
	void * p0
	double d1
	double d2
PREINIT:
	char *(*func)(void *, double, double);
CODE:
	func   = INT2PTR(char *(*)(void *, double, double), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, d2);
OUTPUT:
	RETVAL

int
nci_ipdd( c_func, p0, d1, d2 )
	SV* c_func
	void * p0
	double d1
	double d2
PREINIT:
	int(*func)(void *, double, double);
CODE:
	func   = INT2PTR(int(*)(void *, double, double), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, d2);
OUTPUT:
	RETVAL

void *
nci_pvdd( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvdd( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvdd( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svdd( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvdd( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvdd( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivdd( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pddd( c_func, d0, d1, d2 )
	SV* c_func
	double d0
	double d1
	double d2
PREINIT:
	void *(*func)(double, double, double);
CODE:
	func   = INT2PTR(void *(*)(double, double, double), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, d2);
OUTPUT:
	RETVAL

void
nci_vddd( c_func, d0, d1, d2 )
	SV* c_func
	double d0
	double d1
	double d2
PREINIT:
	void(*func)(double, double, double);
CODE:
	func   = INT2PTR(void(*)(double, double, double), SvIV(c_func) );
	(*func)(d0, d1, d2);

double
nci_dddd( c_func, d0, d1, d2 )
	SV* c_func
	double d0
	double d1
	double d2
PREINIT:
	double(*func)(double, double, double);
CODE:
	func   = INT2PTR(double(*)(double, double, double), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, d2);
OUTPUT:
	RETVAL

short
nci_sddd( c_func, d0, d1, d2 )
	SV* c_func
	double d0
	double d1
	double d2
PREINIT:
	short(*func)(double, double, double);
CODE:
	func   = INT2PTR(short(*)(double, double, double), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, d2);
OUTPUT:
	RETVAL

float
nci_fddd( c_func, d0, d1, d2 )
	SV* c_func
	double d0
	double d1
	double d2
PREINIT:
	float(*func)(double, double, double);
CODE:
	func   = INT2PTR(float(*)(double, double, double), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, d2);
OUTPUT:
	RETVAL

char *
nci_tddd( c_func, d0, d1, d2 )
	SV* c_func
	double d0
	double d1
	double d2
PREINIT:
	char *(*func)(double, double, double);
CODE:
	func   = INT2PTR(char *(*)(double, double, double), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, d2);
OUTPUT:
	RETVAL

int
nci_iddd( c_func, d0, d1, d2 )
	SV* c_func
	double d0
	double d1
	double d2
PREINIT:
	int(*func)(double, double, double);
CODE:
	func   = INT2PTR(int(*)(double, double, double), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, d2);
OUTPUT:
	RETVAL

void *
nci_psdd( c_func, s0, d1, d2 )
	SV* c_func
	short s0
	double d1
	double d2
PREINIT:
	void *(*func)(short, double, double);
CODE:
	func   = INT2PTR(void *(*)(short, double, double), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, d2);
OUTPUT:
	RETVAL

void
nci_vsdd( c_func, s0, d1, d2 )
	SV* c_func
	short s0
	double d1
	double d2
PREINIT:
	void(*func)(short, double, double);
CODE:
	func   = INT2PTR(void(*)(short, double, double), SvIV(c_func) );
	(*func)(s0, d1, d2);

double
nci_dsdd( c_func, s0, d1, d2 )
	SV* c_func
	short s0
	double d1
	double d2
PREINIT:
	double(*func)(short, double, double);
CODE:
	func   = INT2PTR(double(*)(short, double, double), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, d2);
OUTPUT:
	RETVAL

short
nci_ssdd( c_func, s0, d1, d2 )
	SV* c_func
	short s0
	double d1
	double d2
PREINIT:
	short(*func)(short, double, double);
CODE:
	func   = INT2PTR(short(*)(short, double, double), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, d2);
OUTPUT:
	RETVAL

float
nci_fsdd( c_func, s0, d1, d2 )
	SV* c_func
	short s0
	double d1
	double d2
PREINIT:
	float(*func)(short, double, double);
CODE:
	func   = INT2PTR(float(*)(short, double, double), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, d2);
OUTPUT:
	RETVAL

char *
nci_tsdd( c_func, s0, d1, d2 )
	SV* c_func
	short s0
	double d1
	double d2
PREINIT:
	char *(*func)(short, double, double);
CODE:
	func   = INT2PTR(char *(*)(short, double, double), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, d2);
OUTPUT:
	RETVAL

int
nci_isdd( c_func, s0, d1, d2 )
	SV* c_func
	short s0
	double d1
	double d2
PREINIT:
	int(*func)(short, double, double);
CODE:
	func   = INT2PTR(int(*)(short, double, double), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, d2);
OUTPUT:
	RETVAL

void *
nci_pfdd( c_func, f0, d1, d2 )
	SV* c_func
	float f0
	double d1
	double d2
PREINIT:
	void *(*func)(float, double, double);
CODE:
	func   = INT2PTR(void *(*)(float, double, double), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, d2);
OUTPUT:
	RETVAL

void
nci_vfdd( c_func, f0, d1, d2 )
	SV* c_func
	float f0
	double d1
	double d2
PREINIT:
	void(*func)(float, double, double);
CODE:
	func   = INT2PTR(void(*)(float, double, double), SvIV(c_func) );
	(*func)(f0, d1, d2);

double
nci_dfdd( c_func, f0, d1, d2 )
	SV* c_func
	float f0
	double d1
	double d2
PREINIT:
	double(*func)(float, double, double);
CODE:
	func   = INT2PTR(double(*)(float, double, double), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, d2);
OUTPUT:
	RETVAL

short
nci_sfdd( c_func, f0, d1, d2 )
	SV* c_func
	float f0
	double d1
	double d2
PREINIT:
	short(*func)(float, double, double);
CODE:
	func   = INT2PTR(short(*)(float, double, double), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, d2);
OUTPUT:
	RETVAL

float
nci_ffdd( c_func, f0, d1, d2 )
	SV* c_func
	float f0
	double d1
	double d2
PREINIT:
	float(*func)(float, double, double);
CODE:
	func   = INT2PTR(float(*)(float, double, double), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, d2);
OUTPUT:
	RETVAL

char *
nci_tfdd( c_func, f0, d1, d2 )
	SV* c_func
	float f0
	double d1
	double d2
PREINIT:
	char *(*func)(float, double, double);
CODE:
	func   = INT2PTR(char *(*)(float, double, double), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, d2);
OUTPUT:
	RETVAL

int
nci_ifdd( c_func, f0, d1, d2 )
	SV* c_func
	float f0
	double d1
	double d2
PREINIT:
	int(*func)(float, double, double);
CODE:
	func   = INT2PTR(int(*)(float, double, double), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, d2);
OUTPUT:
	RETVAL

void *
nci_ptdd( c_func, t0, d1, d2 )
	SV* c_func
	char * t0
	double d1
	double d2
PREINIT:
	void *(*func)(char *, double, double);
CODE:
	func   = INT2PTR(void *(*)(char *, double, double), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, d2);
OUTPUT:
	RETVAL

void
nci_vtdd( c_func, t0, d1, d2 )
	SV* c_func
	char * t0
	double d1
	double d2
PREINIT:
	void(*func)(char *, double, double);
CODE:
	func   = INT2PTR(void(*)(char *, double, double), SvIV(c_func) );
	(*func)(t0, d1, d2);

double
nci_dtdd( c_func, t0, d1, d2 )
	SV* c_func
	char * t0
	double d1
	double d2
PREINIT:
	double(*func)(char *, double, double);
CODE:
	func   = INT2PTR(double(*)(char *, double, double), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, d2);
OUTPUT:
	RETVAL

short
nci_stdd( c_func, t0, d1, d2 )
	SV* c_func
	char * t0
	double d1
	double d2
PREINIT:
	short(*func)(char *, double, double);
CODE:
	func   = INT2PTR(short(*)(char *, double, double), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, d2);
OUTPUT:
	RETVAL

float
nci_ftdd( c_func, t0, d1, d2 )
	SV* c_func
	char * t0
	double d1
	double d2
PREINIT:
	float(*func)(char *, double, double);
CODE:
	func   = INT2PTR(float(*)(char *, double, double), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, d2);
OUTPUT:
	RETVAL

char *
nci_ttdd( c_func, t0, d1, d2 )
	SV* c_func
	char * t0
	double d1
	double d2
PREINIT:
	char *(*func)(char *, double, double);
CODE:
	func   = INT2PTR(char *(*)(char *, double, double), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, d2);
OUTPUT:
	RETVAL

int
nci_itdd( c_func, t0, d1, d2 )
	SV* c_func
	char * t0
	double d1
	double d2
PREINIT:
	int(*func)(char *, double, double);
CODE:
	func   = INT2PTR(int(*)(char *, double, double), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, d2);
OUTPUT:
	RETVAL

void *
nci_pidd( c_func, i0, d1, d2 )
	SV* c_func
	int i0
	double d1
	double d2
PREINIT:
	void *(*func)(int, double, double);
CODE:
	func   = INT2PTR(void *(*)(int, double, double), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, d2);
OUTPUT:
	RETVAL

void
nci_vidd( c_func, i0, d1, d2 )
	SV* c_func
	int i0
	double d1
	double d2
PREINIT:
	void(*func)(int, double, double);
CODE:
	func   = INT2PTR(void(*)(int, double, double), SvIV(c_func) );
	(*func)(i0, d1, d2);

double
nci_didd( c_func, i0, d1, d2 )
	SV* c_func
	int i0
	double d1
	double d2
PREINIT:
	double(*func)(int, double, double);
CODE:
	func   = INT2PTR(double(*)(int, double, double), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, d2);
OUTPUT:
	RETVAL

short
nci_sidd( c_func, i0, d1, d2 )
	SV* c_func
	int i0
	double d1
	double d2
PREINIT:
	short(*func)(int, double, double);
CODE:
	func   = INT2PTR(short(*)(int, double, double), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, d2);
OUTPUT:
	RETVAL

float
nci_fidd( c_func, i0, d1, d2 )
	SV* c_func
	int i0
	double d1
	double d2
PREINIT:
	float(*func)(int, double, double);
CODE:
	func   = INT2PTR(float(*)(int, double, double), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, d2);
OUTPUT:
	RETVAL

char *
nci_tidd( c_func, i0, d1, d2 )
	SV* c_func
	int i0
	double d1
	double d2
PREINIT:
	char *(*func)(int, double, double);
CODE:
	func   = INT2PTR(char *(*)(int, double, double), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, d2);
OUTPUT:
	RETVAL

int
nci_iidd( c_func, i0, d1, d2 )
	SV* c_func
	int i0
	double d1
	double d2
PREINIT:
	int(*func)(int, double, double);
CODE:
	func   = INT2PTR(int(*)(int, double, double), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, d2);
OUTPUT:
	RETVAL

void *
nci_ppsd( c_func, p0, s1, d2 )
	SV* c_func
	void * p0
	short s1
	double d2
PREINIT:
	void *(*func)(void *, short, double);
CODE:
	func   = INT2PTR(void *(*)(void *, short, double), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, d2);
OUTPUT:
	RETVAL

void
nci_vpsd( c_func, p0, s1, d2 )
	SV* c_func
	void * p0
	short s1
	double d2
PREINIT:
	void(*func)(void *, short, double);
CODE:
	func   = INT2PTR(void(*)(void *, short, double), SvIV(c_func) );
	(*func)(p0, s1, d2);

double
nci_dpsd( c_func, p0, s1, d2 )
	SV* c_func
	void * p0
	short s1
	double d2
PREINIT:
	double(*func)(void *, short, double);
CODE:
	func   = INT2PTR(double(*)(void *, short, double), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, d2);
OUTPUT:
	RETVAL

short
nci_spsd( c_func, p0, s1, d2 )
	SV* c_func
	void * p0
	short s1
	double d2
PREINIT:
	short(*func)(void *, short, double);
CODE:
	func   = INT2PTR(short(*)(void *, short, double), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, d2);
OUTPUT:
	RETVAL

float
nci_fpsd( c_func, p0, s1, d2 )
	SV* c_func
	void * p0
	short s1
	double d2
PREINIT:
	float(*func)(void *, short, double);
CODE:
	func   = INT2PTR(float(*)(void *, short, double), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, d2);
OUTPUT:
	RETVAL

char *
nci_tpsd( c_func, p0, s1, d2 )
	SV* c_func
	void * p0
	short s1
	double d2
PREINIT:
	char *(*func)(void *, short, double);
CODE:
	func   = INT2PTR(char *(*)(void *, short, double), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, d2);
OUTPUT:
	RETVAL

int
nci_ipsd( c_func, p0, s1, d2 )
	SV* c_func
	void * p0
	short s1
	double d2
PREINIT:
	int(*func)(void *, short, double);
CODE:
	func   = INT2PTR(int(*)(void *, short, double), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, d2);
OUTPUT:
	RETVAL

void *
nci_pvsd( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvsd( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvsd( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svsd( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvsd( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvsd( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivsd( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdsd( c_func, d0, s1, d2 )
	SV* c_func
	double d0
	short s1
	double d2
PREINIT:
	void *(*func)(double, short, double);
CODE:
	func   = INT2PTR(void *(*)(double, short, double), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, d2);
OUTPUT:
	RETVAL

void
nci_vdsd( c_func, d0, s1, d2 )
	SV* c_func
	double d0
	short s1
	double d2
PREINIT:
	void(*func)(double, short, double);
CODE:
	func   = INT2PTR(void(*)(double, short, double), SvIV(c_func) );
	(*func)(d0, s1, d2);

double
nci_ddsd( c_func, d0, s1, d2 )
	SV* c_func
	double d0
	short s1
	double d2
PREINIT:
	double(*func)(double, short, double);
CODE:
	func   = INT2PTR(double(*)(double, short, double), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, d2);
OUTPUT:
	RETVAL

short
nci_sdsd( c_func, d0, s1, d2 )
	SV* c_func
	double d0
	short s1
	double d2
PREINIT:
	short(*func)(double, short, double);
CODE:
	func   = INT2PTR(short(*)(double, short, double), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, d2);
OUTPUT:
	RETVAL

float
nci_fdsd( c_func, d0, s1, d2 )
	SV* c_func
	double d0
	short s1
	double d2
PREINIT:
	float(*func)(double, short, double);
CODE:
	func   = INT2PTR(float(*)(double, short, double), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, d2);
OUTPUT:
	RETVAL

char *
nci_tdsd( c_func, d0, s1, d2 )
	SV* c_func
	double d0
	short s1
	double d2
PREINIT:
	char *(*func)(double, short, double);
CODE:
	func   = INT2PTR(char *(*)(double, short, double), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, d2);
OUTPUT:
	RETVAL

int
nci_idsd( c_func, d0, s1, d2 )
	SV* c_func
	double d0
	short s1
	double d2
PREINIT:
	int(*func)(double, short, double);
CODE:
	func   = INT2PTR(int(*)(double, short, double), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, d2);
OUTPUT:
	RETVAL

void *
nci_pssd( c_func, s0, s1, d2 )
	SV* c_func
	short s0
	short s1
	double d2
PREINIT:
	void *(*func)(short, short, double);
CODE:
	func   = INT2PTR(void *(*)(short, short, double), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, d2);
OUTPUT:
	RETVAL

void
nci_vssd( c_func, s0, s1, d2 )
	SV* c_func
	short s0
	short s1
	double d2
PREINIT:
	void(*func)(short, short, double);
CODE:
	func   = INT2PTR(void(*)(short, short, double), SvIV(c_func) );
	(*func)(s0, s1, d2);

double
nci_dssd( c_func, s0, s1, d2 )
	SV* c_func
	short s0
	short s1
	double d2
PREINIT:
	double(*func)(short, short, double);
CODE:
	func   = INT2PTR(double(*)(short, short, double), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, d2);
OUTPUT:
	RETVAL

short
nci_sssd( c_func, s0, s1, d2 )
	SV* c_func
	short s0
	short s1
	double d2
PREINIT:
	short(*func)(short, short, double);
CODE:
	func   = INT2PTR(short(*)(short, short, double), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, d2);
OUTPUT:
	RETVAL

float
nci_fssd( c_func, s0, s1, d2 )
	SV* c_func
	short s0
	short s1
	double d2
PREINIT:
	float(*func)(short, short, double);
CODE:
	func   = INT2PTR(float(*)(short, short, double), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, d2);
OUTPUT:
	RETVAL

char *
nci_tssd( c_func, s0, s1, d2 )
	SV* c_func
	short s0
	short s1
	double d2
PREINIT:
	char *(*func)(short, short, double);
CODE:
	func   = INT2PTR(char *(*)(short, short, double), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, d2);
OUTPUT:
	RETVAL

int
nci_issd( c_func, s0, s1, d2 )
	SV* c_func
	short s0
	short s1
	double d2
PREINIT:
	int(*func)(short, short, double);
CODE:
	func   = INT2PTR(int(*)(short, short, double), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, d2);
OUTPUT:
	RETVAL

void *
nci_pfsd( c_func, f0, s1, d2 )
	SV* c_func
	float f0
	short s1
	double d2
PREINIT:
	void *(*func)(float, short, double);
CODE:
	func   = INT2PTR(void *(*)(float, short, double), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, d2);
OUTPUT:
	RETVAL

void
nci_vfsd( c_func, f0, s1, d2 )
	SV* c_func
	float f0
	short s1
	double d2
PREINIT:
	void(*func)(float, short, double);
CODE:
	func   = INT2PTR(void(*)(float, short, double), SvIV(c_func) );
	(*func)(f0, s1, d2);

double
nci_dfsd( c_func, f0, s1, d2 )
	SV* c_func
	float f0
	short s1
	double d2
PREINIT:
	double(*func)(float, short, double);
CODE:
	func   = INT2PTR(double(*)(float, short, double), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, d2);
OUTPUT:
	RETVAL

short
nci_sfsd( c_func, f0, s1, d2 )
	SV* c_func
	float f0
	short s1
	double d2
PREINIT:
	short(*func)(float, short, double);
CODE:
	func   = INT2PTR(short(*)(float, short, double), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, d2);
OUTPUT:
	RETVAL

float
nci_ffsd( c_func, f0, s1, d2 )
	SV* c_func
	float f0
	short s1
	double d2
PREINIT:
	float(*func)(float, short, double);
CODE:
	func   = INT2PTR(float(*)(float, short, double), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, d2);
OUTPUT:
	RETVAL

char *
nci_tfsd( c_func, f0, s1, d2 )
	SV* c_func
	float f0
	short s1
	double d2
PREINIT:
	char *(*func)(float, short, double);
CODE:
	func   = INT2PTR(char *(*)(float, short, double), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, d2);
OUTPUT:
	RETVAL

int
nci_ifsd( c_func, f0, s1, d2 )
	SV* c_func
	float f0
	short s1
	double d2
PREINIT:
	int(*func)(float, short, double);
CODE:
	func   = INT2PTR(int(*)(float, short, double), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, d2);
OUTPUT:
	RETVAL

void *
nci_ptsd( c_func, t0, s1, d2 )
	SV* c_func
	char * t0
	short s1
	double d2
PREINIT:
	void *(*func)(char *, short, double);
CODE:
	func   = INT2PTR(void *(*)(char *, short, double), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, d2);
OUTPUT:
	RETVAL

void
nci_vtsd( c_func, t0, s1, d2 )
	SV* c_func
	char * t0
	short s1
	double d2
PREINIT:
	void(*func)(char *, short, double);
CODE:
	func   = INT2PTR(void(*)(char *, short, double), SvIV(c_func) );
	(*func)(t0, s1, d2);

double
nci_dtsd( c_func, t0, s1, d2 )
	SV* c_func
	char * t0
	short s1
	double d2
PREINIT:
	double(*func)(char *, short, double);
CODE:
	func   = INT2PTR(double(*)(char *, short, double), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, d2);
OUTPUT:
	RETVAL

short
nci_stsd( c_func, t0, s1, d2 )
	SV* c_func
	char * t0
	short s1
	double d2
PREINIT:
	short(*func)(char *, short, double);
CODE:
	func   = INT2PTR(short(*)(char *, short, double), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, d2);
OUTPUT:
	RETVAL

float
nci_ftsd( c_func, t0, s1, d2 )
	SV* c_func
	char * t0
	short s1
	double d2
PREINIT:
	float(*func)(char *, short, double);
CODE:
	func   = INT2PTR(float(*)(char *, short, double), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, d2);
OUTPUT:
	RETVAL

char *
nci_ttsd( c_func, t0, s1, d2 )
	SV* c_func
	char * t0
	short s1
	double d2
PREINIT:
	char *(*func)(char *, short, double);
CODE:
	func   = INT2PTR(char *(*)(char *, short, double), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, d2);
OUTPUT:
	RETVAL

int
nci_itsd( c_func, t0, s1, d2 )
	SV* c_func
	char * t0
	short s1
	double d2
PREINIT:
	int(*func)(char *, short, double);
CODE:
	func   = INT2PTR(int(*)(char *, short, double), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, d2);
OUTPUT:
	RETVAL

void *
nci_pisd( c_func, i0, s1, d2 )
	SV* c_func
	int i0
	short s1
	double d2
PREINIT:
	void *(*func)(int, short, double);
CODE:
	func   = INT2PTR(void *(*)(int, short, double), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, d2);
OUTPUT:
	RETVAL

void
nci_visd( c_func, i0, s1, d2 )
	SV* c_func
	int i0
	short s1
	double d2
PREINIT:
	void(*func)(int, short, double);
CODE:
	func   = INT2PTR(void(*)(int, short, double), SvIV(c_func) );
	(*func)(i0, s1, d2);

double
nci_disd( c_func, i0, s1, d2 )
	SV* c_func
	int i0
	short s1
	double d2
PREINIT:
	double(*func)(int, short, double);
CODE:
	func   = INT2PTR(double(*)(int, short, double), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, d2);
OUTPUT:
	RETVAL

short
nci_sisd( c_func, i0, s1, d2 )
	SV* c_func
	int i0
	short s1
	double d2
PREINIT:
	short(*func)(int, short, double);
CODE:
	func   = INT2PTR(short(*)(int, short, double), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, d2);
OUTPUT:
	RETVAL

float
nci_fisd( c_func, i0, s1, d2 )
	SV* c_func
	int i0
	short s1
	double d2
PREINIT:
	float(*func)(int, short, double);
CODE:
	func   = INT2PTR(float(*)(int, short, double), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, d2);
OUTPUT:
	RETVAL

char *
nci_tisd( c_func, i0, s1, d2 )
	SV* c_func
	int i0
	short s1
	double d2
PREINIT:
	char *(*func)(int, short, double);
CODE:
	func   = INT2PTR(char *(*)(int, short, double), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, d2);
OUTPUT:
	RETVAL

int
nci_iisd( c_func, i0, s1, d2 )
	SV* c_func
	int i0
	short s1
	double d2
PREINIT:
	int(*func)(int, short, double);
CODE:
	func   = INT2PTR(int(*)(int, short, double), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, d2);
OUTPUT:
	RETVAL

void *
nci_ppfd( c_func, p0, f1, d2 )
	SV* c_func
	void * p0
	float f1
	double d2
PREINIT:
	void *(*func)(void *, float, double);
CODE:
	func   = INT2PTR(void *(*)(void *, float, double), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, d2);
OUTPUT:
	RETVAL

void
nci_vpfd( c_func, p0, f1, d2 )
	SV* c_func
	void * p0
	float f1
	double d2
PREINIT:
	void(*func)(void *, float, double);
CODE:
	func   = INT2PTR(void(*)(void *, float, double), SvIV(c_func) );
	(*func)(p0, f1, d2);

double
nci_dpfd( c_func, p0, f1, d2 )
	SV* c_func
	void * p0
	float f1
	double d2
PREINIT:
	double(*func)(void *, float, double);
CODE:
	func   = INT2PTR(double(*)(void *, float, double), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, d2);
OUTPUT:
	RETVAL

short
nci_spfd( c_func, p0, f1, d2 )
	SV* c_func
	void * p0
	float f1
	double d2
PREINIT:
	short(*func)(void *, float, double);
CODE:
	func   = INT2PTR(short(*)(void *, float, double), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, d2);
OUTPUT:
	RETVAL

float
nci_fpfd( c_func, p0, f1, d2 )
	SV* c_func
	void * p0
	float f1
	double d2
PREINIT:
	float(*func)(void *, float, double);
CODE:
	func   = INT2PTR(float(*)(void *, float, double), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, d2);
OUTPUT:
	RETVAL

char *
nci_tpfd( c_func, p0, f1, d2 )
	SV* c_func
	void * p0
	float f1
	double d2
PREINIT:
	char *(*func)(void *, float, double);
CODE:
	func   = INT2PTR(char *(*)(void *, float, double), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, d2);
OUTPUT:
	RETVAL

int
nci_ipfd( c_func, p0, f1, d2 )
	SV* c_func
	void * p0
	float f1
	double d2
PREINIT:
	int(*func)(void *, float, double);
CODE:
	func   = INT2PTR(int(*)(void *, float, double), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, d2);
OUTPUT:
	RETVAL

void *
nci_pvfd( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvfd( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvfd( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svfd( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvfd( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvfd( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivfd( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdfd( c_func, d0, f1, d2 )
	SV* c_func
	double d0
	float f1
	double d2
PREINIT:
	void *(*func)(double, float, double);
CODE:
	func   = INT2PTR(void *(*)(double, float, double), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, d2);
OUTPUT:
	RETVAL

void
nci_vdfd( c_func, d0, f1, d2 )
	SV* c_func
	double d0
	float f1
	double d2
PREINIT:
	void(*func)(double, float, double);
CODE:
	func   = INT2PTR(void(*)(double, float, double), SvIV(c_func) );
	(*func)(d0, f1, d2);

double
nci_ddfd( c_func, d0, f1, d2 )
	SV* c_func
	double d0
	float f1
	double d2
PREINIT:
	double(*func)(double, float, double);
CODE:
	func   = INT2PTR(double(*)(double, float, double), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, d2);
OUTPUT:
	RETVAL

short
nci_sdfd( c_func, d0, f1, d2 )
	SV* c_func
	double d0
	float f1
	double d2
PREINIT:
	short(*func)(double, float, double);
CODE:
	func   = INT2PTR(short(*)(double, float, double), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, d2);
OUTPUT:
	RETVAL

float
nci_fdfd( c_func, d0, f1, d2 )
	SV* c_func
	double d0
	float f1
	double d2
PREINIT:
	float(*func)(double, float, double);
CODE:
	func   = INT2PTR(float(*)(double, float, double), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, d2);
OUTPUT:
	RETVAL

char *
nci_tdfd( c_func, d0, f1, d2 )
	SV* c_func
	double d0
	float f1
	double d2
PREINIT:
	char *(*func)(double, float, double);
CODE:
	func   = INT2PTR(char *(*)(double, float, double), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, d2);
OUTPUT:
	RETVAL

int
nci_idfd( c_func, d0, f1, d2 )
	SV* c_func
	double d0
	float f1
	double d2
PREINIT:
	int(*func)(double, float, double);
CODE:
	func   = INT2PTR(int(*)(double, float, double), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, d2);
OUTPUT:
	RETVAL

void *
nci_psfd( c_func, s0, f1, d2 )
	SV* c_func
	short s0
	float f1
	double d2
PREINIT:
	void *(*func)(short, float, double);
CODE:
	func   = INT2PTR(void *(*)(short, float, double), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, d2);
OUTPUT:
	RETVAL

void
nci_vsfd( c_func, s0, f1, d2 )
	SV* c_func
	short s0
	float f1
	double d2
PREINIT:
	void(*func)(short, float, double);
CODE:
	func   = INT2PTR(void(*)(short, float, double), SvIV(c_func) );
	(*func)(s0, f1, d2);

double
nci_dsfd( c_func, s0, f1, d2 )
	SV* c_func
	short s0
	float f1
	double d2
PREINIT:
	double(*func)(short, float, double);
CODE:
	func   = INT2PTR(double(*)(short, float, double), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, d2);
OUTPUT:
	RETVAL

short
nci_ssfd( c_func, s0, f1, d2 )
	SV* c_func
	short s0
	float f1
	double d2
PREINIT:
	short(*func)(short, float, double);
CODE:
	func   = INT2PTR(short(*)(short, float, double), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, d2);
OUTPUT:
	RETVAL

float
nci_fsfd( c_func, s0, f1, d2 )
	SV* c_func
	short s0
	float f1
	double d2
PREINIT:
	float(*func)(short, float, double);
CODE:
	func   = INT2PTR(float(*)(short, float, double), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, d2);
OUTPUT:
	RETVAL

char *
nci_tsfd( c_func, s0, f1, d2 )
	SV* c_func
	short s0
	float f1
	double d2
PREINIT:
	char *(*func)(short, float, double);
CODE:
	func   = INT2PTR(char *(*)(short, float, double), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, d2);
OUTPUT:
	RETVAL

int
nci_isfd( c_func, s0, f1, d2 )
	SV* c_func
	short s0
	float f1
	double d2
PREINIT:
	int(*func)(short, float, double);
CODE:
	func   = INT2PTR(int(*)(short, float, double), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, d2);
OUTPUT:
	RETVAL

void *
nci_pffd( c_func, f0, f1, d2 )
	SV* c_func
	float f0
	float f1
	double d2
PREINIT:
	void *(*func)(float, float, double);
CODE:
	func   = INT2PTR(void *(*)(float, float, double), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, d2);
OUTPUT:
	RETVAL

void
nci_vffd( c_func, f0, f1, d2 )
	SV* c_func
	float f0
	float f1
	double d2
PREINIT:
	void(*func)(float, float, double);
CODE:
	func   = INT2PTR(void(*)(float, float, double), SvIV(c_func) );
	(*func)(f0, f1, d2);

double
nci_dffd( c_func, f0, f1, d2 )
	SV* c_func
	float f0
	float f1
	double d2
PREINIT:
	double(*func)(float, float, double);
CODE:
	func   = INT2PTR(double(*)(float, float, double), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, d2);
OUTPUT:
	RETVAL

short
nci_sffd( c_func, f0, f1, d2 )
	SV* c_func
	float f0
	float f1
	double d2
PREINIT:
	short(*func)(float, float, double);
CODE:
	func   = INT2PTR(short(*)(float, float, double), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, d2);
OUTPUT:
	RETVAL

float
nci_fffd( c_func, f0, f1, d2 )
	SV* c_func
	float f0
	float f1
	double d2
PREINIT:
	float(*func)(float, float, double);
CODE:
	func   = INT2PTR(float(*)(float, float, double), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, d2);
OUTPUT:
	RETVAL

char *
nci_tffd( c_func, f0, f1, d2 )
	SV* c_func
	float f0
	float f1
	double d2
PREINIT:
	char *(*func)(float, float, double);
CODE:
	func   = INT2PTR(char *(*)(float, float, double), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, d2);
OUTPUT:
	RETVAL

int
nci_iffd( c_func, f0, f1, d2 )
	SV* c_func
	float f0
	float f1
	double d2
PREINIT:
	int(*func)(float, float, double);
CODE:
	func   = INT2PTR(int(*)(float, float, double), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, d2);
OUTPUT:
	RETVAL

void *
nci_ptfd( c_func, t0, f1, d2 )
	SV* c_func
	char * t0
	float f1
	double d2
PREINIT:
	void *(*func)(char *, float, double);
CODE:
	func   = INT2PTR(void *(*)(char *, float, double), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, d2);
OUTPUT:
	RETVAL

void
nci_vtfd( c_func, t0, f1, d2 )
	SV* c_func
	char * t0
	float f1
	double d2
PREINIT:
	void(*func)(char *, float, double);
CODE:
	func   = INT2PTR(void(*)(char *, float, double), SvIV(c_func) );
	(*func)(t0, f1, d2);

double
nci_dtfd( c_func, t0, f1, d2 )
	SV* c_func
	char * t0
	float f1
	double d2
PREINIT:
	double(*func)(char *, float, double);
CODE:
	func   = INT2PTR(double(*)(char *, float, double), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, d2);
OUTPUT:
	RETVAL

short
nci_stfd( c_func, t0, f1, d2 )
	SV* c_func
	char * t0
	float f1
	double d2
PREINIT:
	short(*func)(char *, float, double);
CODE:
	func   = INT2PTR(short(*)(char *, float, double), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, d2);
OUTPUT:
	RETVAL

float
nci_ftfd( c_func, t0, f1, d2 )
	SV* c_func
	char * t0
	float f1
	double d2
PREINIT:
	float(*func)(char *, float, double);
CODE:
	func   = INT2PTR(float(*)(char *, float, double), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, d2);
OUTPUT:
	RETVAL

char *
nci_ttfd( c_func, t0, f1, d2 )
	SV* c_func
	char * t0
	float f1
	double d2
PREINIT:
	char *(*func)(char *, float, double);
CODE:
	func   = INT2PTR(char *(*)(char *, float, double), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, d2);
OUTPUT:
	RETVAL

int
nci_itfd( c_func, t0, f1, d2 )
	SV* c_func
	char * t0
	float f1
	double d2
PREINIT:
	int(*func)(char *, float, double);
CODE:
	func   = INT2PTR(int(*)(char *, float, double), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, d2);
OUTPUT:
	RETVAL

void *
nci_pifd( c_func, i0, f1, d2 )
	SV* c_func
	int i0
	float f1
	double d2
PREINIT:
	void *(*func)(int, float, double);
CODE:
	func   = INT2PTR(void *(*)(int, float, double), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, d2);
OUTPUT:
	RETVAL

void
nci_vifd( c_func, i0, f1, d2 )
	SV* c_func
	int i0
	float f1
	double d2
PREINIT:
	void(*func)(int, float, double);
CODE:
	func   = INT2PTR(void(*)(int, float, double), SvIV(c_func) );
	(*func)(i0, f1, d2);

double
nci_difd( c_func, i0, f1, d2 )
	SV* c_func
	int i0
	float f1
	double d2
PREINIT:
	double(*func)(int, float, double);
CODE:
	func   = INT2PTR(double(*)(int, float, double), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, d2);
OUTPUT:
	RETVAL

short
nci_sifd( c_func, i0, f1, d2 )
	SV* c_func
	int i0
	float f1
	double d2
PREINIT:
	short(*func)(int, float, double);
CODE:
	func   = INT2PTR(short(*)(int, float, double), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, d2);
OUTPUT:
	RETVAL

float
nci_fifd( c_func, i0, f1, d2 )
	SV* c_func
	int i0
	float f1
	double d2
PREINIT:
	float(*func)(int, float, double);
CODE:
	func   = INT2PTR(float(*)(int, float, double), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, d2);
OUTPUT:
	RETVAL

char *
nci_tifd( c_func, i0, f1, d2 )
	SV* c_func
	int i0
	float f1
	double d2
PREINIT:
	char *(*func)(int, float, double);
CODE:
	func   = INT2PTR(char *(*)(int, float, double), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, d2);
OUTPUT:
	RETVAL

int
nci_iifd( c_func, i0, f1, d2 )
	SV* c_func
	int i0
	float f1
	double d2
PREINIT:
	int(*func)(int, float, double);
CODE:
	func   = INT2PTR(int(*)(int, float, double), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, d2);
OUTPUT:
	RETVAL

void *
nci_pptd( c_func, p0, t1, d2 )
	SV* c_func
	void * p0
	char * t1
	double d2
PREINIT:
	void *(*func)(void *, char *, double);
CODE:
	func   = INT2PTR(void *(*)(void *, char *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, d2);
OUTPUT:
	RETVAL

void
nci_vptd( c_func, p0, t1, d2 )
	SV* c_func
	void * p0
	char * t1
	double d2
PREINIT:
	void(*func)(void *, char *, double);
CODE:
	func   = INT2PTR(void(*)(void *, char *, double), SvIV(c_func) );
	(*func)(p0, t1, d2);

double
nci_dptd( c_func, p0, t1, d2 )
	SV* c_func
	void * p0
	char * t1
	double d2
PREINIT:
	double(*func)(void *, char *, double);
CODE:
	func   = INT2PTR(double(*)(void *, char *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, d2);
OUTPUT:
	RETVAL

short
nci_sptd( c_func, p0, t1, d2 )
	SV* c_func
	void * p0
	char * t1
	double d2
PREINIT:
	short(*func)(void *, char *, double);
CODE:
	func   = INT2PTR(short(*)(void *, char *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, d2);
OUTPUT:
	RETVAL

float
nci_fptd( c_func, p0, t1, d2 )
	SV* c_func
	void * p0
	char * t1
	double d2
PREINIT:
	float(*func)(void *, char *, double);
CODE:
	func   = INT2PTR(float(*)(void *, char *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, d2);
OUTPUT:
	RETVAL

char *
nci_tptd( c_func, p0, t1, d2 )
	SV* c_func
	void * p0
	char * t1
	double d2
PREINIT:
	char *(*func)(void *, char *, double);
CODE:
	func   = INT2PTR(char *(*)(void *, char *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, d2);
OUTPUT:
	RETVAL

int
nci_iptd( c_func, p0, t1, d2 )
	SV* c_func
	void * p0
	char * t1
	double d2
PREINIT:
	int(*func)(void *, char *, double);
CODE:
	func   = INT2PTR(int(*)(void *, char *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, d2);
OUTPUT:
	RETVAL

void *
nci_pvtd( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvtd( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvtd( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svtd( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvtd( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvtd( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivtd( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdtd( c_func, d0, t1, d2 )
	SV* c_func
	double d0
	char * t1
	double d2
PREINIT:
	void *(*func)(double, char *, double);
CODE:
	func   = INT2PTR(void *(*)(double, char *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, d2);
OUTPUT:
	RETVAL

void
nci_vdtd( c_func, d0, t1, d2 )
	SV* c_func
	double d0
	char * t1
	double d2
PREINIT:
	void(*func)(double, char *, double);
CODE:
	func   = INT2PTR(void(*)(double, char *, double), SvIV(c_func) );
	(*func)(d0, t1, d2);

double
nci_ddtd( c_func, d0, t1, d2 )
	SV* c_func
	double d0
	char * t1
	double d2
PREINIT:
	double(*func)(double, char *, double);
CODE:
	func   = INT2PTR(double(*)(double, char *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, d2);
OUTPUT:
	RETVAL

short
nci_sdtd( c_func, d0, t1, d2 )
	SV* c_func
	double d0
	char * t1
	double d2
PREINIT:
	short(*func)(double, char *, double);
CODE:
	func   = INT2PTR(short(*)(double, char *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, d2);
OUTPUT:
	RETVAL

float
nci_fdtd( c_func, d0, t1, d2 )
	SV* c_func
	double d0
	char * t1
	double d2
PREINIT:
	float(*func)(double, char *, double);
CODE:
	func   = INT2PTR(float(*)(double, char *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, d2);
OUTPUT:
	RETVAL

char *
nci_tdtd( c_func, d0, t1, d2 )
	SV* c_func
	double d0
	char * t1
	double d2
PREINIT:
	char *(*func)(double, char *, double);
CODE:
	func   = INT2PTR(char *(*)(double, char *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, d2);
OUTPUT:
	RETVAL

int
nci_idtd( c_func, d0, t1, d2 )
	SV* c_func
	double d0
	char * t1
	double d2
PREINIT:
	int(*func)(double, char *, double);
CODE:
	func   = INT2PTR(int(*)(double, char *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, d2);
OUTPUT:
	RETVAL

void *
nci_pstd( c_func, s0, t1, d2 )
	SV* c_func
	short s0
	char * t1
	double d2
PREINIT:
	void *(*func)(short, char *, double);
CODE:
	func   = INT2PTR(void *(*)(short, char *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, d2);
OUTPUT:
	RETVAL

void
nci_vstd( c_func, s0, t1, d2 )
	SV* c_func
	short s0
	char * t1
	double d2
PREINIT:
	void(*func)(short, char *, double);
CODE:
	func   = INT2PTR(void(*)(short, char *, double), SvIV(c_func) );
	(*func)(s0, t1, d2);

double
nci_dstd( c_func, s0, t1, d2 )
	SV* c_func
	short s0
	char * t1
	double d2
PREINIT:
	double(*func)(short, char *, double);
CODE:
	func   = INT2PTR(double(*)(short, char *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, d2);
OUTPUT:
	RETVAL

short
nci_sstd( c_func, s0, t1, d2 )
	SV* c_func
	short s0
	char * t1
	double d2
PREINIT:
	short(*func)(short, char *, double);
CODE:
	func   = INT2PTR(short(*)(short, char *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, d2);
OUTPUT:
	RETVAL

float
nci_fstd( c_func, s0, t1, d2 )
	SV* c_func
	short s0
	char * t1
	double d2
PREINIT:
	float(*func)(short, char *, double);
CODE:
	func   = INT2PTR(float(*)(short, char *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, d2);
OUTPUT:
	RETVAL

char *
nci_tstd( c_func, s0, t1, d2 )
	SV* c_func
	short s0
	char * t1
	double d2
PREINIT:
	char *(*func)(short, char *, double);
CODE:
	func   = INT2PTR(char *(*)(short, char *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, d2);
OUTPUT:
	RETVAL

int
nci_istd( c_func, s0, t1, d2 )
	SV* c_func
	short s0
	char * t1
	double d2
PREINIT:
	int(*func)(short, char *, double);
CODE:
	func   = INT2PTR(int(*)(short, char *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, d2);
OUTPUT:
	RETVAL

void *
nci_pftd( c_func, f0, t1, d2 )
	SV* c_func
	float f0
	char * t1
	double d2
PREINIT:
	void *(*func)(float, char *, double);
CODE:
	func   = INT2PTR(void *(*)(float, char *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, d2);
OUTPUT:
	RETVAL

void
nci_vftd( c_func, f0, t1, d2 )
	SV* c_func
	float f0
	char * t1
	double d2
PREINIT:
	void(*func)(float, char *, double);
CODE:
	func   = INT2PTR(void(*)(float, char *, double), SvIV(c_func) );
	(*func)(f0, t1, d2);

double
nci_dftd( c_func, f0, t1, d2 )
	SV* c_func
	float f0
	char * t1
	double d2
PREINIT:
	double(*func)(float, char *, double);
CODE:
	func   = INT2PTR(double(*)(float, char *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, d2);
OUTPUT:
	RETVAL

short
nci_sftd( c_func, f0, t1, d2 )
	SV* c_func
	float f0
	char * t1
	double d2
PREINIT:
	short(*func)(float, char *, double);
CODE:
	func   = INT2PTR(short(*)(float, char *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, d2);
OUTPUT:
	RETVAL

float
nci_fftd( c_func, f0, t1, d2 )
	SV* c_func
	float f0
	char * t1
	double d2
PREINIT:
	float(*func)(float, char *, double);
CODE:
	func   = INT2PTR(float(*)(float, char *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, d2);
OUTPUT:
	RETVAL

char *
nci_tftd( c_func, f0, t1, d2 )
	SV* c_func
	float f0
	char * t1
	double d2
PREINIT:
	char *(*func)(float, char *, double);
CODE:
	func   = INT2PTR(char *(*)(float, char *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, d2);
OUTPUT:
	RETVAL

int
nci_iftd( c_func, f0, t1, d2 )
	SV* c_func
	float f0
	char * t1
	double d2
PREINIT:
	int(*func)(float, char *, double);
CODE:
	func   = INT2PTR(int(*)(float, char *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, d2);
OUTPUT:
	RETVAL

void *
nci_pttd( c_func, t0, t1, d2 )
	SV* c_func
	char * t0
	char * t1
	double d2
PREINIT:
	void *(*func)(char *, char *, double);
CODE:
	func   = INT2PTR(void *(*)(char *, char *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, d2);
OUTPUT:
	RETVAL

void
nci_vttd( c_func, t0, t1, d2 )
	SV* c_func
	char * t0
	char * t1
	double d2
PREINIT:
	void(*func)(char *, char *, double);
CODE:
	func   = INT2PTR(void(*)(char *, char *, double), SvIV(c_func) );
	(*func)(t0, t1, d2);

double
nci_dttd( c_func, t0, t1, d2 )
	SV* c_func
	char * t0
	char * t1
	double d2
PREINIT:
	double(*func)(char *, char *, double);
CODE:
	func   = INT2PTR(double(*)(char *, char *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, d2);
OUTPUT:
	RETVAL

short
nci_sttd( c_func, t0, t1, d2 )
	SV* c_func
	char * t0
	char * t1
	double d2
PREINIT:
	short(*func)(char *, char *, double);
CODE:
	func   = INT2PTR(short(*)(char *, char *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, d2);
OUTPUT:
	RETVAL

float
nci_fttd( c_func, t0, t1, d2 )
	SV* c_func
	char * t0
	char * t1
	double d2
PREINIT:
	float(*func)(char *, char *, double);
CODE:
	func   = INT2PTR(float(*)(char *, char *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, d2);
OUTPUT:
	RETVAL

char *
nci_tttd( c_func, t0, t1, d2 )
	SV* c_func
	char * t0
	char * t1
	double d2
PREINIT:
	char *(*func)(char *, char *, double);
CODE:
	func   = INT2PTR(char *(*)(char *, char *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, d2);
OUTPUT:
	RETVAL

int
nci_ittd( c_func, t0, t1, d2 )
	SV* c_func
	char * t0
	char * t1
	double d2
PREINIT:
	int(*func)(char *, char *, double);
CODE:
	func   = INT2PTR(int(*)(char *, char *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, d2);
OUTPUT:
	RETVAL

void *
nci_pitd( c_func, i0, t1, d2 )
	SV* c_func
	int i0
	char * t1
	double d2
PREINIT:
	void *(*func)(int, char *, double);
CODE:
	func   = INT2PTR(void *(*)(int, char *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, d2);
OUTPUT:
	RETVAL

void
nci_vitd( c_func, i0, t1, d2 )
	SV* c_func
	int i0
	char * t1
	double d2
PREINIT:
	void(*func)(int, char *, double);
CODE:
	func   = INT2PTR(void(*)(int, char *, double), SvIV(c_func) );
	(*func)(i0, t1, d2);

double
nci_ditd( c_func, i0, t1, d2 )
	SV* c_func
	int i0
	char * t1
	double d2
PREINIT:
	double(*func)(int, char *, double);
CODE:
	func   = INT2PTR(double(*)(int, char *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, d2);
OUTPUT:
	RETVAL

short
nci_sitd( c_func, i0, t1, d2 )
	SV* c_func
	int i0
	char * t1
	double d2
PREINIT:
	short(*func)(int, char *, double);
CODE:
	func   = INT2PTR(short(*)(int, char *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, d2);
OUTPUT:
	RETVAL

float
nci_fitd( c_func, i0, t1, d2 )
	SV* c_func
	int i0
	char * t1
	double d2
PREINIT:
	float(*func)(int, char *, double);
CODE:
	func   = INT2PTR(float(*)(int, char *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, d2);
OUTPUT:
	RETVAL

char *
nci_titd( c_func, i0, t1, d2 )
	SV* c_func
	int i0
	char * t1
	double d2
PREINIT:
	char *(*func)(int, char *, double);
CODE:
	func   = INT2PTR(char *(*)(int, char *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, d2);
OUTPUT:
	RETVAL

int
nci_iitd( c_func, i0, t1, d2 )
	SV* c_func
	int i0
	char * t1
	double d2
PREINIT:
	int(*func)(int, char *, double);
CODE:
	func   = INT2PTR(int(*)(int, char *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, d2);
OUTPUT:
	RETVAL

void *
nci_ppid( c_func, p0, i1, d2 )
	SV* c_func
	void * p0
	int i1
	double d2
PREINIT:
	void *(*func)(void *, int, double);
CODE:
	func   = INT2PTR(void *(*)(void *, int, double), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, d2);
OUTPUT:
	RETVAL

void
nci_vpid( c_func, p0, i1, d2 )
	SV* c_func
	void * p0
	int i1
	double d2
PREINIT:
	void(*func)(void *, int, double);
CODE:
	func   = INT2PTR(void(*)(void *, int, double), SvIV(c_func) );
	(*func)(p0, i1, d2);

double
nci_dpid( c_func, p0, i1, d2 )
	SV* c_func
	void * p0
	int i1
	double d2
PREINIT:
	double(*func)(void *, int, double);
CODE:
	func   = INT2PTR(double(*)(void *, int, double), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, d2);
OUTPUT:
	RETVAL

short
nci_spid( c_func, p0, i1, d2 )
	SV* c_func
	void * p0
	int i1
	double d2
PREINIT:
	short(*func)(void *, int, double);
CODE:
	func   = INT2PTR(short(*)(void *, int, double), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, d2);
OUTPUT:
	RETVAL

float
nci_fpid( c_func, p0, i1, d2 )
	SV* c_func
	void * p0
	int i1
	double d2
PREINIT:
	float(*func)(void *, int, double);
CODE:
	func   = INT2PTR(float(*)(void *, int, double), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, d2);
OUTPUT:
	RETVAL

char *
nci_tpid( c_func, p0, i1, d2 )
	SV* c_func
	void * p0
	int i1
	double d2
PREINIT:
	char *(*func)(void *, int, double);
CODE:
	func   = INT2PTR(char *(*)(void *, int, double), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, d2);
OUTPUT:
	RETVAL

int
nci_ipid( c_func, p0, i1, d2 )
	SV* c_func
	void * p0
	int i1
	double d2
PREINIT:
	int(*func)(void *, int, double);
CODE:
	func   = INT2PTR(int(*)(void *, int, double), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, d2);
OUTPUT:
	RETVAL

void *
nci_pvid( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvid( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvid( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svid( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvid( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvid( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivid( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdid( c_func, d0, i1, d2 )
	SV* c_func
	double d0
	int i1
	double d2
PREINIT:
	void *(*func)(double, int, double);
CODE:
	func   = INT2PTR(void *(*)(double, int, double), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, d2);
OUTPUT:
	RETVAL

void
nci_vdid( c_func, d0, i1, d2 )
	SV* c_func
	double d0
	int i1
	double d2
PREINIT:
	void(*func)(double, int, double);
CODE:
	func   = INT2PTR(void(*)(double, int, double), SvIV(c_func) );
	(*func)(d0, i1, d2);

double
nci_ddid( c_func, d0, i1, d2 )
	SV* c_func
	double d0
	int i1
	double d2
PREINIT:
	double(*func)(double, int, double);
CODE:
	func   = INT2PTR(double(*)(double, int, double), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, d2);
OUTPUT:
	RETVAL

short
nci_sdid( c_func, d0, i1, d2 )
	SV* c_func
	double d0
	int i1
	double d2
PREINIT:
	short(*func)(double, int, double);
CODE:
	func   = INT2PTR(short(*)(double, int, double), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, d2);
OUTPUT:
	RETVAL

float
nci_fdid( c_func, d0, i1, d2 )
	SV* c_func
	double d0
	int i1
	double d2
PREINIT:
	float(*func)(double, int, double);
CODE:
	func   = INT2PTR(float(*)(double, int, double), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, d2);
OUTPUT:
	RETVAL

char *
nci_tdid( c_func, d0, i1, d2 )
	SV* c_func
	double d0
	int i1
	double d2
PREINIT:
	char *(*func)(double, int, double);
CODE:
	func   = INT2PTR(char *(*)(double, int, double), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, d2);
OUTPUT:
	RETVAL

int
nci_idid( c_func, d0, i1, d2 )
	SV* c_func
	double d0
	int i1
	double d2
PREINIT:
	int(*func)(double, int, double);
CODE:
	func   = INT2PTR(int(*)(double, int, double), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, d2);
OUTPUT:
	RETVAL

void *
nci_psid( c_func, s0, i1, d2 )
	SV* c_func
	short s0
	int i1
	double d2
PREINIT:
	void *(*func)(short, int, double);
CODE:
	func   = INT2PTR(void *(*)(short, int, double), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, d2);
OUTPUT:
	RETVAL

void
nci_vsid( c_func, s0, i1, d2 )
	SV* c_func
	short s0
	int i1
	double d2
PREINIT:
	void(*func)(short, int, double);
CODE:
	func   = INT2PTR(void(*)(short, int, double), SvIV(c_func) );
	(*func)(s0, i1, d2);

double
nci_dsid( c_func, s0, i1, d2 )
	SV* c_func
	short s0
	int i1
	double d2
PREINIT:
	double(*func)(short, int, double);
CODE:
	func   = INT2PTR(double(*)(short, int, double), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, d2);
OUTPUT:
	RETVAL

short
nci_ssid( c_func, s0, i1, d2 )
	SV* c_func
	short s0
	int i1
	double d2
PREINIT:
	short(*func)(short, int, double);
CODE:
	func   = INT2PTR(short(*)(short, int, double), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, d2);
OUTPUT:
	RETVAL

float
nci_fsid( c_func, s0, i1, d2 )
	SV* c_func
	short s0
	int i1
	double d2
PREINIT:
	float(*func)(short, int, double);
CODE:
	func   = INT2PTR(float(*)(short, int, double), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, d2);
OUTPUT:
	RETVAL

char *
nci_tsid( c_func, s0, i1, d2 )
	SV* c_func
	short s0
	int i1
	double d2
PREINIT:
	char *(*func)(short, int, double);
CODE:
	func   = INT2PTR(char *(*)(short, int, double), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, d2);
OUTPUT:
	RETVAL

int
nci_isid( c_func, s0, i1, d2 )
	SV* c_func
	short s0
	int i1
	double d2
PREINIT:
	int(*func)(short, int, double);
CODE:
	func   = INT2PTR(int(*)(short, int, double), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, d2);
OUTPUT:
	RETVAL

void *
nci_pfid( c_func, f0, i1, d2 )
	SV* c_func
	float f0
	int i1
	double d2
PREINIT:
	void *(*func)(float, int, double);
CODE:
	func   = INT2PTR(void *(*)(float, int, double), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, d2);
OUTPUT:
	RETVAL

void
nci_vfid( c_func, f0, i1, d2 )
	SV* c_func
	float f0
	int i1
	double d2
PREINIT:
	void(*func)(float, int, double);
CODE:
	func   = INT2PTR(void(*)(float, int, double), SvIV(c_func) );
	(*func)(f0, i1, d2);

double
nci_dfid( c_func, f0, i1, d2 )
	SV* c_func
	float f0
	int i1
	double d2
PREINIT:
	double(*func)(float, int, double);
CODE:
	func   = INT2PTR(double(*)(float, int, double), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, d2);
OUTPUT:
	RETVAL

short
nci_sfid( c_func, f0, i1, d2 )
	SV* c_func
	float f0
	int i1
	double d2
PREINIT:
	short(*func)(float, int, double);
CODE:
	func   = INT2PTR(short(*)(float, int, double), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, d2);
OUTPUT:
	RETVAL

float
nci_ffid( c_func, f0, i1, d2 )
	SV* c_func
	float f0
	int i1
	double d2
PREINIT:
	float(*func)(float, int, double);
CODE:
	func   = INT2PTR(float(*)(float, int, double), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, d2);
OUTPUT:
	RETVAL

char *
nci_tfid( c_func, f0, i1, d2 )
	SV* c_func
	float f0
	int i1
	double d2
PREINIT:
	char *(*func)(float, int, double);
CODE:
	func   = INT2PTR(char *(*)(float, int, double), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, d2);
OUTPUT:
	RETVAL

int
nci_ifid( c_func, f0, i1, d2 )
	SV* c_func
	float f0
	int i1
	double d2
PREINIT:
	int(*func)(float, int, double);
CODE:
	func   = INT2PTR(int(*)(float, int, double), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, d2);
OUTPUT:
	RETVAL

void *
nci_ptid( c_func, t0, i1, d2 )
	SV* c_func
	char * t0
	int i1
	double d2
PREINIT:
	void *(*func)(char *, int, double);
CODE:
	func   = INT2PTR(void *(*)(char *, int, double), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, d2);
OUTPUT:
	RETVAL

void
nci_vtid( c_func, t0, i1, d2 )
	SV* c_func
	char * t0
	int i1
	double d2
PREINIT:
	void(*func)(char *, int, double);
CODE:
	func   = INT2PTR(void(*)(char *, int, double), SvIV(c_func) );
	(*func)(t0, i1, d2);

double
nci_dtid( c_func, t0, i1, d2 )
	SV* c_func
	char * t0
	int i1
	double d2
PREINIT:
	double(*func)(char *, int, double);
CODE:
	func   = INT2PTR(double(*)(char *, int, double), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, d2);
OUTPUT:
	RETVAL

short
nci_stid( c_func, t0, i1, d2 )
	SV* c_func
	char * t0
	int i1
	double d2
PREINIT:
	short(*func)(char *, int, double);
CODE:
	func   = INT2PTR(short(*)(char *, int, double), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, d2);
OUTPUT:
	RETVAL

float
nci_ftid( c_func, t0, i1, d2 )
	SV* c_func
	char * t0
	int i1
	double d2
PREINIT:
	float(*func)(char *, int, double);
CODE:
	func   = INT2PTR(float(*)(char *, int, double), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, d2);
OUTPUT:
	RETVAL

char *
nci_ttid( c_func, t0, i1, d2 )
	SV* c_func
	char * t0
	int i1
	double d2
PREINIT:
	char *(*func)(char *, int, double);
CODE:
	func   = INT2PTR(char *(*)(char *, int, double), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, d2);
OUTPUT:
	RETVAL

int
nci_itid( c_func, t0, i1, d2 )
	SV* c_func
	char * t0
	int i1
	double d2
PREINIT:
	int(*func)(char *, int, double);
CODE:
	func   = INT2PTR(int(*)(char *, int, double), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, d2);
OUTPUT:
	RETVAL

void *
nci_piid( c_func, i0, i1, d2 )
	SV* c_func
	int i0
	int i1
	double d2
PREINIT:
	void *(*func)(int, int, double);
CODE:
	func   = INT2PTR(void *(*)(int, int, double), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, d2);
OUTPUT:
	RETVAL

void
nci_viid( c_func, i0, i1, d2 )
	SV* c_func
	int i0
	int i1
	double d2
PREINIT:
	void(*func)(int, int, double);
CODE:
	func   = INT2PTR(void(*)(int, int, double), SvIV(c_func) );
	(*func)(i0, i1, d2);

double
nci_diid( c_func, i0, i1, d2 )
	SV* c_func
	int i0
	int i1
	double d2
PREINIT:
	double(*func)(int, int, double);
CODE:
	func   = INT2PTR(double(*)(int, int, double), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, d2);
OUTPUT:
	RETVAL

short
nci_siid( c_func, i0, i1, d2 )
	SV* c_func
	int i0
	int i1
	double d2
PREINIT:
	short(*func)(int, int, double);
CODE:
	func   = INT2PTR(short(*)(int, int, double), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, d2);
OUTPUT:
	RETVAL

float
nci_fiid( c_func, i0, i1, d2 )
	SV* c_func
	int i0
	int i1
	double d2
PREINIT:
	float(*func)(int, int, double);
CODE:
	func   = INT2PTR(float(*)(int, int, double), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, d2);
OUTPUT:
	RETVAL

char *
nci_tiid( c_func, i0, i1, d2 )
	SV* c_func
	int i0
	int i1
	double d2
PREINIT:
	char *(*func)(int, int, double);
CODE:
	func   = INT2PTR(char *(*)(int, int, double), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, d2);
OUTPUT:
	RETVAL

int
nci_iiid( c_func, i0, i1, d2 )
	SV* c_func
	int i0
	int i1
	double d2
PREINIT:
	int(*func)(int, int, double);
CODE:
	func   = INT2PTR(int(*)(int, int, double), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, d2);
OUTPUT:
	RETVAL

void *
nci_ppps( c_func, p0, p1, s2 )
	SV* c_func
	void * p0
	void * p1
	short s2
PREINIT:
	void *(*func)(void *, void *, short);
CODE:
	func   = INT2PTR(void *(*)(void *, void *, short), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, s2);
OUTPUT:
	RETVAL

void
nci_vpps( c_func, p0, p1, s2 )
	SV* c_func
	void * p0
	void * p1
	short s2
PREINIT:
	void(*func)(void *, void *, short);
CODE:
	func   = INT2PTR(void(*)(void *, void *, short), SvIV(c_func) );
	(*func)(p0, p1, s2);

double
nci_dpps( c_func, p0, p1, s2 )
	SV* c_func
	void * p0
	void * p1
	short s2
PREINIT:
	double(*func)(void *, void *, short);
CODE:
	func   = INT2PTR(double(*)(void *, void *, short), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, s2);
OUTPUT:
	RETVAL

short
nci_spps( c_func, p0, p1, s2 )
	SV* c_func
	void * p0
	void * p1
	short s2
PREINIT:
	short(*func)(void *, void *, short);
CODE:
	func   = INT2PTR(short(*)(void *, void *, short), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, s2);
OUTPUT:
	RETVAL

float
nci_fpps( c_func, p0, p1, s2 )
	SV* c_func
	void * p0
	void * p1
	short s2
PREINIT:
	float(*func)(void *, void *, short);
CODE:
	func   = INT2PTR(float(*)(void *, void *, short), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, s2);
OUTPUT:
	RETVAL

char *
nci_tpps( c_func, p0, p1, s2 )
	SV* c_func
	void * p0
	void * p1
	short s2
PREINIT:
	char *(*func)(void *, void *, short);
CODE:
	func   = INT2PTR(char *(*)(void *, void *, short), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, s2);
OUTPUT:
	RETVAL

int
nci_ipps( c_func, p0, p1, s2 )
	SV* c_func
	void * p0
	void * p1
	short s2
PREINIT:
	int(*func)(void *, void *, short);
CODE:
	func   = INT2PTR(int(*)(void *, void *, short), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, s2);
OUTPUT:
	RETVAL

void *
nci_pvps( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvps( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvps( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svps( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvps( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvps( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivps( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdps( c_func, d0, p1, s2 )
	SV* c_func
	double d0
	void * p1
	short s2
PREINIT:
	void *(*func)(double, void *, short);
CODE:
	func   = INT2PTR(void *(*)(double, void *, short), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, s2);
OUTPUT:
	RETVAL

void
nci_vdps( c_func, d0, p1, s2 )
	SV* c_func
	double d0
	void * p1
	short s2
PREINIT:
	void(*func)(double, void *, short);
CODE:
	func   = INT2PTR(void(*)(double, void *, short), SvIV(c_func) );
	(*func)(d0, p1, s2);

double
nci_ddps( c_func, d0, p1, s2 )
	SV* c_func
	double d0
	void * p1
	short s2
PREINIT:
	double(*func)(double, void *, short);
CODE:
	func   = INT2PTR(double(*)(double, void *, short), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, s2);
OUTPUT:
	RETVAL

short
nci_sdps( c_func, d0, p1, s2 )
	SV* c_func
	double d0
	void * p1
	short s2
PREINIT:
	short(*func)(double, void *, short);
CODE:
	func   = INT2PTR(short(*)(double, void *, short), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, s2);
OUTPUT:
	RETVAL

float
nci_fdps( c_func, d0, p1, s2 )
	SV* c_func
	double d0
	void * p1
	short s2
PREINIT:
	float(*func)(double, void *, short);
CODE:
	func   = INT2PTR(float(*)(double, void *, short), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, s2);
OUTPUT:
	RETVAL

char *
nci_tdps( c_func, d0, p1, s2 )
	SV* c_func
	double d0
	void * p1
	short s2
PREINIT:
	char *(*func)(double, void *, short);
CODE:
	func   = INT2PTR(char *(*)(double, void *, short), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, s2);
OUTPUT:
	RETVAL

int
nci_idps( c_func, d0, p1, s2 )
	SV* c_func
	double d0
	void * p1
	short s2
PREINIT:
	int(*func)(double, void *, short);
CODE:
	func   = INT2PTR(int(*)(double, void *, short), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, s2);
OUTPUT:
	RETVAL

void *
nci_psps( c_func, s0, p1, s2 )
	SV* c_func
	short s0
	void * p1
	short s2
PREINIT:
	void *(*func)(short, void *, short);
CODE:
	func   = INT2PTR(void *(*)(short, void *, short), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, s2);
OUTPUT:
	RETVAL

void
nci_vsps( c_func, s0, p1, s2 )
	SV* c_func
	short s0
	void * p1
	short s2
PREINIT:
	void(*func)(short, void *, short);
CODE:
	func   = INT2PTR(void(*)(short, void *, short), SvIV(c_func) );
	(*func)(s0, p1, s2);

double
nci_dsps( c_func, s0, p1, s2 )
	SV* c_func
	short s0
	void * p1
	short s2
PREINIT:
	double(*func)(short, void *, short);
CODE:
	func   = INT2PTR(double(*)(short, void *, short), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, s2);
OUTPUT:
	RETVAL

short
nci_ssps( c_func, s0, p1, s2 )
	SV* c_func
	short s0
	void * p1
	short s2
PREINIT:
	short(*func)(short, void *, short);
CODE:
	func   = INT2PTR(short(*)(short, void *, short), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, s2);
OUTPUT:
	RETVAL

float
nci_fsps( c_func, s0, p1, s2 )
	SV* c_func
	short s0
	void * p1
	short s2
PREINIT:
	float(*func)(short, void *, short);
CODE:
	func   = INT2PTR(float(*)(short, void *, short), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, s2);
OUTPUT:
	RETVAL

char *
nci_tsps( c_func, s0, p1, s2 )
	SV* c_func
	short s0
	void * p1
	short s2
PREINIT:
	char *(*func)(short, void *, short);
CODE:
	func   = INT2PTR(char *(*)(short, void *, short), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, s2);
OUTPUT:
	RETVAL

int
nci_isps( c_func, s0, p1, s2 )
	SV* c_func
	short s0
	void * p1
	short s2
PREINIT:
	int(*func)(short, void *, short);
CODE:
	func   = INT2PTR(int(*)(short, void *, short), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, s2);
OUTPUT:
	RETVAL

void *
nci_pfps( c_func, f0, p1, s2 )
	SV* c_func
	float f0
	void * p1
	short s2
PREINIT:
	void *(*func)(float, void *, short);
CODE:
	func   = INT2PTR(void *(*)(float, void *, short), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, s2);
OUTPUT:
	RETVAL

void
nci_vfps( c_func, f0, p1, s2 )
	SV* c_func
	float f0
	void * p1
	short s2
PREINIT:
	void(*func)(float, void *, short);
CODE:
	func   = INT2PTR(void(*)(float, void *, short), SvIV(c_func) );
	(*func)(f0, p1, s2);

double
nci_dfps( c_func, f0, p1, s2 )
	SV* c_func
	float f0
	void * p1
	short s2
PREINIT:
	double(*func)(float, void *, short);
CODE:
	func   = INT2PTR(double(*)(float, void *, short), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, s2);
OUTPUT:
	RETVAL

short
nci_sfps( c_func, f0, p1, s2 )
	SV* c_func
	float f0
	void * p1
	short s2
PREINIT:
	short(*func)(float, void *, short);
CODE:
	func   = INT2PTR(short(*)(float, void *, short), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, s2);
OUTPUT:
	RETVAL

float
nci_ffps( c_func, f0, p1, s2 )
	SV* c_func
	float f0
	void * p1
	short s2
PREINIT:
	float(*func)(float, void *, short);
CODE:
	func   = INT2PTR(float(*)(float, void *, short), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, s2);
OUTPUT:
	RETVAL

char *
nci_tfps( c_func, f0, p1, s2 )
	SV* c_func
	float f0
	void * p1
	short s2
PREINIT:
	char *(*func)(float, void *, short);
CODE:
	func   = INT2PTR(char *(*)(float, void *, short), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, s2);
OUTPUT:
	RETVAL

int
nci_ifps( c_func, f0, p1, s2 )
	SV* c_func
	float f0
	void * p1
	short s2
PREINIT:
	int(*func)(float, void *, short);
CODE:
	func   = INT2PTR(int(*)(float, void *, short), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, s2);
OUTPUT:
	RETVAL

void *
nci_ptps( c_func, t0, p1, s2 )
	SV* c_func
	char * t0
	void * p1
	short s2
PREINIT:
	void *(*func)(char *, void *, short);
CODE:
	func   = INT2PTR(void *(*)(char *, void *, short), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, s2);
OUTPUT:
	RETVAL

void
nci_vtps( c_func, t0, p1, s2 )
	SV* c_func
	char * t0
	void * p1
	short s2
PREINIT:
	void(*func)(char *, void *, short);
CODE:
	func   = INT2PTR(void(*)(char *, void *, short), SvIV(c_func) );
	(*func)(t0, p1, s2);

double
nci_dtps( c_func, t0, p1, s2 )
	SV* c_func
	char * t0
	void * p1
	short s2
PREINIT:
	double(*func)(char *, void *, short);
CODE:
	func   = INT2PTR(double(*)(char *, void *, short), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, s2);
OUTPUT:
	RETVAL

short
nci_stps( c_func, t0, p1, s2 )
	SV* c_func
	char * t0
	void * p1
	short s2
PREINIT:
	short(*func)(char *, void *, short);
CODE:
	func   = INT2PTR(short(*)(char *, void *, short), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, s2);
OUTPUT:
	RETVAL

float
nci_ftps( c_func, t0, p1, s2 )
	SV* c_func
	char * t0
	void * p1
	short s2
PREINIT:
	float(*func)(char *, void *, short);
CODE:
	func   = INT2PTR(float(*)(char *, void *, short), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, s2);
OUTPUT:
	RETVAL

char *
nci_ttps( c_func, t0, p1, s2 )
	SV* c_func
	char * t0
	void * p1
	short s2
PREINIT:
	char *(*func)(char *, void *, short);
CODE:
	func   = INT2PTR(char *(*)(char *, void *, short), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, s2);
OUTPUT:
	RETVAL

int
nci_itps( c_func, t0, p1, s2 )
	SV* c_func
	char * t0
	void * p1
	short s2
PREINIT:
	int(*func)(char *, void *, short);
CODE:
	func   = INT2PTR(int(*)(char *, void *, short), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, s2);
OUTPUT:
	RETVAL

void *
nci_pips( c_func, i0, p1, s2 )
	SV* c_func
	int i0
	void * p1
	short s2
PREINIT:
	void *(*func)(int, void *, short);
CODE:
	func   = INT2PTR(void *(*)(int, void *, short), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, s2);
OUTPUT:
	RETVAL

void
nci_vips( c_func, i0, p1, s2 )
	SV* c_func
	int i0
	void * p1
	short s2
PREINIT:
	void(*func)(int, void *, short);
CODE:
	func   = INT2PTR(void(*)(int, void *, short), SvIV(c_func) );
	(*func)(i0, p1, s2);

double
nci_dips( c_func, i0, p1, s2 )
	SV* c_func
	int i0
	void * p1
	short s2
PREINIT:
	double(*func)(int, void *, short);
CODE:
	func   = INT2PTR(double(*)(int, void *, short), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, s2);
OUTPUT:
	RETVAL

short
nci_sips( c_func, i0, p1, s2 )
	SV* c_func
	int i0
	void * p1
	short s2
PREINIT:
	short(*func)(int, void *, short);
CODE:
	func   = INT2PTR(short(*)(int, void *, short), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, s2);
OUTPUT:
	RETVAL

float
nci_fips( c_func, i0, p1, s2 )
	SV* c_func
	int i0
	void * p1
	short s2
PREINIT:
	float(*func)(int, void *, short);
CODE:
	func   = INT2PTR(float(*)(int, void *, short), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, s2);
OUTPUT:
	RETVAL

char *
nci_tips( c_func, i0, p1, s2 )
	SV* c_func
	int i0
	void * p1
	short s2
PREINIT:
	char *(*func)(int, void *, short);
CODE:
	func   = INT2PTR(char *(*)(int, void *, short), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, s2);
OUTPUT:
	RETVAL

int
nci_iips( c_func, i0, p1, s2 )
	SV* c_func
	int i0
	void * p1
	short s2
PREINIT:
	int(*func)(int, void *, short);
CODE:
	func   = INT2PTR(int(*)(int, void *, short), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, s2);
OUTPUT:
	RETVAL

void *
nci_ppds( c_func, p0, d1, s2 )
	SV* c_func
	void * p0
	double d1
	short s2
PREINIT:
	void *(*func)(void *, double, short);
CODE:
	func   = INT2PTR(void *(*)(void *, double, short), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, s2);
OUTPUT:
	RETVAL

void
nci_vpds( c_func, p0, d1, s2 )
	SV* c_func
	void * p0
	double d1
	short s2
PREINIT:
	void(*func)(void *, double, short);
CODE:
	func   = INT2PTR(void(*)(void *, double, short), SvIV(c_func) );
	(*func)(p0, d1, s2);

double
nci_dpds( c_func, p0, d1, s2 )
	SV* c_func
	void * p0
	double d1
	short s2
PREINIT:
	double(*func)(void *, double, short);
CODE:
	func   = INT2PTR(double(*)(void *, double, short), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, s2);
OUTPUT:
	RETVAL

short
nci_spds( c_func, p0, d1, s2 )
	SV* c_func
	void * p0
	double d1
	short s2
PREINIT:
	short(*func)(void *, double, short);
CODE:
	func   = INT2PTR(short(*)(void *, double, short), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, s2);
OUTPUT:
	RETVAL

float
nci_fpds( c_func, p0, d1, s2 )
	SV* c_func
	void * p0
	double d1
	short s2
PREINIT:
	float(*func)(void *, double, short);
CODE:
	func   = INT2PTR(float(*)(void *, double, short), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, s2);
OUTPUT:
	RETVAL

char *
nci_tpds( c_func, p0, d1, s2 )
	SV* c_func
	void * p0
	double d1
	short s2
PREINIT:
	char *(*func)(void *, double, short);
CODE:
	func   = INT2PTR(char *(*)(void *, double, short), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, s2);
OUTPUT:
	RETVAL

int
nci_ipds( c_func, p0, d1, s2 )
	SV* c_func
	void * p0
	double d1
	short s2
PREINIT:
	int(*func)(void *, double, short);
CODE:
	func   = INT2PTR(int(*)(void *, double, short), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, s2);
OUTPUT:
	RETVAL

void *
nci_pvds( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvds( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvds( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svds( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvds( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvds( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivds( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdds( c_func, d0, d1, s2 )
	SV* c_func
	double d0
	double d1
	short s2
PREINIT:
	void *(*func)(double, double, short);
CODE:
	func   = INT2PTR(void *(*)(double, double, short), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, s2);
OUTPUT:
	RETVAL

void
nci_vdds( c_func, d0, d1, s2 )
	SV* c_func
	double d0
	double d1
	short s2
PREINIT:
	void(*func)(double, double, short);
CODE:
	func   = INT2PTR(void(*)(double, double, short), SvIV(c_func) );
	(*func)(d0, d1, s2);

double
nci_ddds( c_func, d0, d1, s2 )
	SV* c_func
	double d0
	double d1
	short s2
PREINIT:
	double(*func)(double, double, short);
CODE:
	func   = INT2PTR(double(*)(double, double, short), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, s2);
OUTPUT:
	RETVAL

short
nci_sdds( c_func, d0, d1, s2 )
	SV* c_func
	double d0
	double d1
	short s2
PREINIT:
	short(*func)(double, double, short);
CODE:
	func   = INT2PTR(short(*)(double, double, short), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, s2);
OUTPUT:
	RETVAL

float
nci_fdds( c_func, d0, d1, s2 )
	SV* c_func
	double d0
	double d1
	short s2
PREINIT:
	float(*func)(double, double, short);
CODE:
	func   = INT2PTR(float(*)(double, double, short), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, s2);
OUTPUT:
	RETVAL

char *
nci_tdds( c_func, d0, d1, s2 )
	SV* c_func
	double d0
	double d1
	short s2
PREINIT:
	char *(*func)(double, double, short);
CODE:
	func   = INT2PTR(char *(*)(double, double, short), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, s2);
OUTPUT:
	RETVAL

int
nci_idds( c_func, d0, d1, s2 )
	SV* c_func
	double d0
	double d1
	short s2
PREINIT:
	int(*func)(double, double, short);
CODE:
	func   = INT2PTR(int(*)(double, double, short), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, s2);
OUTPUT:
	RETVAL

void *
nci_psds( c_func, s0, d1, s2 )
	SV* c_func
	short s0
	double d1
	short s2
PREINIT:
	void *(*func)(short, double, short);
CODE:
	func   = INT2PTR(void *(*)(short, double, short), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, s2);
OUTPUT:
	RETVAL

void
nci_vsds( c_func, s0, d1, s2 )
	SV* c_func
	short s0
	double d1
	short s2
PREINIT:
	void(*func)(short, double, short);
CODE:
	func   = INT2PTR(void(*)(short, double, short), SvIV(c_func) );
	(*func)(s0, d1, s2);

double
nci_dsds( c_func, s0, d1, s2 )
	SV* c_func
	short s0
	double d1
	short s2
PREINIT:
	double(*func)(short, double, short);
CODE:
	func   = INT2PTR(double(*)(short, double, short), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, s2);
OUTPUT:
	RETVAL

short
nci_ssds( c_func, s0, d1, s2 )
	SV* c_func
	short s0
	double d1
	short s2
PREINIT:
	short(*func)(short, double, short);
CODE:
	func   = INT2PTR(short(*)(short, double, short), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, s2);
OUTPUT:
	RETVAL

float
nci_fsds( c_func, s0, d1, s2 )
	SV* c_func
	short s0
	double d1
	short s2
PREINIT:
	float(*func)(short, double, short);
CODE:
	func   = INT2PTR(float(*)(short, double, short), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, s2);
OUTPUT:
	RETVAL

char *
nci_tsds( c_func, s0, d1, s2 )
	SV* c_func
	short s0
	double d1
	short s2
PREINIT:
	char *(*func)(short, double, short);
CODE:
	func   = INT2PTR(char *(*)(short, double, short), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, s2);
OUTPUT:
	RETVAL

int
nci_isds( c_func, s0, d1, s2 )
	SV* c_func
	short s0
	double d1
	short s2
PREINIT:
	int(*func)(short, double, short);
CODE:
	func   = INT2PTR(int(*)(short, double, short), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, s2);
OUTPUT:
	RETVAL

void *
nci_pfds( c_func, f0, d1, s2 )
	SV* c_func
	float f0
	double d1
	short s2
PREINIT:
	void *(*func)(float, double, short);
CODE:
	func   = INT2PTR(void *(*)(float, double, short), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, s2);
OUTPUT:
	RETVAL

void
nci_vfds( c_func, f0, d1, s2 )
	SV* c_func
	float f0
	double d1
	short s2
PREINIT:
	void(*func)(float, double, short);
CODE:
	func   = INT2PTR(void(*)(float, double, short), SvIV(c_func) );
	(*func)(f0, d1, s2);

double
nci_dfds( c_func, f0, d1, s2 )
	SV* c_func
	float f0
	double d1
	short s2
PREINIT:
	double(*func)(float, double, short);
CODE:
	func   = INT2PTR(double(*)(float, double, short), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, s2);
OUTPUT:
	RETVAL

short
nci_sfds( c_func, f0, d1, s2 )
	SV* c_func
	float f0
	double d1
	short s2
PREINIT:
	short(*func)(float, double, short);
CODE:
	func   = INT2PTR(short(*)(float, double, short), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, s2);
OUTPUT:
	RETVAL

float
nci_ffds( c_func, f0, d1, s2 )
	SV* c_func
	float f0
	double d1
	short s2
PREINIT:
	float(*func)(float, double, short);
CODE:
	func   = INT2PTR(float(*)(float, double, short), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, s2);
OUTPUT:
	RETVAL

char *
nci_tfds( c_func, f0, d1, s2 )
	SV* c_func
	float f0
	double d1
	short s2
PREINIT:
	char *(*func)(float, double, short);
CODE:
	func   = INT2PTR(char *(*)(float, double, short), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, s2);
OUTPUT:
	RETVAL

int
nci_ifds( c_func, f0, d1, s2 )
	SV* c_func
	float f0
	double d1
	short s2
PREINIT:
	int(*func)(float, double, short);
CODE:
	func   = INT2PTR(int(*)(float, double, short), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, s2);
OUTPUT:
	RETVAL

void *
nci_ptds( c_func, t0, d1, s2 )
	SV* c_func
	char * t0
	double d1
	short s2
PREINIT:
	void *(*func)(char *, double, short);
CODE:
	func   = INT2PTR(void *(*)(char *, double, short), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, s2);
OUTPUT:
	RETVAL

void
nci_vtds( c_func, t0, d1, s2 )
	SV* c_func
	char * t0
	double d1
	short s2
PREINIT:
	void(*func)(char *, double, short);
CODE:
	func   = INT2PTR(void(*)(char *, double, short), SvIV(c_func) );
	(*func)(t0, d1, s2);

double
nci_dtds( c_func, t0, d1, s2 )
	SV* c_func
	char * t0
	double d1
	short s2
PREINIT:
	double(*func)(char *, double, short);
CODE:
	func   = INT2PTR(double(*)(char *, double, short), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, s2);
OUTPUT:
	RETVAL

short
nci_stds( c_func, t0, d1, s2 )
	SV* c_func
	char * t0
	double d1
	short s2
PREINIT:
	short(*func)(char *, double, short);
CODE:
	func   = INT2PTR(short(*)(char *, double, short), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, s2);
OUTPUT:
	RETVAL

float
nci_ftds( c_func, t0, d1, s2 )
	SV* c_func
	char * t0
	double d1
	short s2
PREINIT:
	float(*func)(char *, double, short);
CODE:
	func   = INT2PTR(float(*)(char *, double, short), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, s2);
OUTPUT:
	RETVAL

char *
nci_ttds( c_func, t0, d1, s2 )
	SV* c_func
	char * t0
	double d1
	short s2
PREINIT:
	char *(*func)(char *, double, short);
CODE:
	func   = INT2PTR(char *(*)(char *, double, short), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, s2);
OUTPUT:
	RETVAL

int
nci_itds( c_func, t0, d1, s2 )
	SV* c_func
	char * t0
	double d1
	short s2
PREINIT:
	int(*func)(char *, double, short);
CODE:
	func   = INT2PTR(int(*)(char *, double, short), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, s2);
OUTPUT:
	RETVAL

void *
nci_pids( c_func, i0, d1, s2 )
	SV* c_func
	int i0
	double d1
	short s2
PREINIT:
	void *(*func)(int, double, short);
CODE:
	func   = INT2PTR(void *(*)(int, double, short), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, s2);
OUTPUT:
	RETVAL

void
nci_vids( c_func, i0, d1, s2 )
	SV* c_func
	int i0
	double d1
	short s2
PREINIT:
	void(*func)(int, double, short);
CODE:
	func   = INT2PTR(void(*)(int, double, short), SvIV(c_func) );
	(*func)(i0, d1, s2);

double
nci_dids( c_func, i0, d1, s2 )
	SV* c_func
	int i0
	double d1
	short s2
PREINIT:
	double(*func)(int, double, short);
CODE:
	func   = INT2PTR(double(*)(int, double, short), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, s2);
OUTPUT:
	RETVAL

short
nci_sids( c_func, i0, d1, s2 )
	SV* c_func
	int i0
	double d1
	short s2
PREINIT:
	short(*func)(int, double, short);
CODE:
	func   = INT2PTR(short(*)(int, double, short), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, s2);
OUTPUT:
	RETVAL

float
nci_fids( c_func, i0, d1, s2 )
	SV* c_func
	int i0
	double d1
	short s2
PREINIT:
	float(*func)(int, double, short);
CODE:
	func   = INT2PTR(float(*)(int, double, short), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, s2);
OUTPUT:
	RETVAL

char *
nci_tids( c_func, i0, d1, s2 )
	SV* c_func
	int i0
	double d1
	short s2
PREINIT:
	char *(*func)(int, double, short);
CODE:
	func   = INT2PTR(char *(*)(int, double, short), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, s2);
OUTPUT:
	RETVAL

int
nci_iids( c_func, i0, d1, s2 )
	SV* c_func
	int i0
	double d1
	short s2
PREINIT:
	int(*func)(int, double, short);
CODE:
	func   = INT2PTR(int(*)(int, double, short), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, s2);
OUTPUT:
	RETVAL

void *
nci_ppss( c_func, p0, s1, s2 )
	SV* c_func
	void * p0
	short s1
	short s2
PREINIT:
	void *(*func)(void *, short, short);
CODE:
	func   = INT2PTR(void *(*)(void *, short, short), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, s2);
OUTPUT:
	RETVAL

void
nci_vpss( c_func, p0, s1, s2 )
	SV* c_func
	void * p0
	short s1
	short s2
PREINIT:
	void(*func)(void *, short, short);
CODE:
	func   = INT2PTR(void(*)(void *, short, short), SvIV(c_func) );
	(*func)(p0, s1, s2);

double
nci_dpss( c_func, p0, s1, s2 )
	SV* c_func
	void * p0
	short s1
	short s2
PREINIT:
	double(*func)(void *, short, short);
CODE:
	func   = INT2PTR(double(*)(void *, short, short), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, s2);
OUTPUT:
	RETVAL

short
nci_spss( c_func, p0, s1, s2 )
	SV* c_func
	void * p0
	short s1
	short s2
PREINIT:
	short(*func)(void *, short, short);
CODE:
	func   = INT2PTR(short(*)(void *, short, short), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, s2);
OUTPUT:
	RETVAL

float
nci_fpss( c_func, p0, s1, s2 )
	SV* c_func
	void * p0
	short s1
	short s2
PREINIT:
	float(*func)(void *, short, short);
CODE:
	func   = INT2PTR(float(*)(void *, short, short), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, s2);
OUTPUT:
	RETVAL

char *
nci_tpss( c_func, p0, s1, s2 )
	SV* c_func
	void * p0
	short s1
	short s2
PREINIT:
	char *(*func)(void *, short, short);
CODE:
	func   = INT2PTR(char *(*)(void *, short, short), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, s2);
OUTPUT:
	RETVAL

int
nci_ipss( c_func, p0, s1, s2 )
	SV* c_func
	void * p0
	short s1
	short s2
PREINIT:
	int(*func)(void *, short, short);
CODE:
	func   = INT2PTR(int(*)(void *, short, short), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, s2);
OUTPUT:
	RETVAL

void *
nci_pvss( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvss( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvss( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svss( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvss( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvss( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivss( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdss( c_func, d0, s1, s2 )
	SV* c_func
	double d0
	short s1
	short s2
PREINIT:
	void *(*func)(double, short, short);
CODE:
	func   = INT2PTR(void *(*)(double, short, short), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, s2);
OUTPUT:
	RETVAL

void
nci_vdss( c_func, d0, s1, s2 )
	SV* c_func
	double d0
	short s1
	short s2
PREINIT:
	void(*func)(double, short, short);
CODE:
	func   = INT2PTR(void(*)(double, short, short), SvIV(c_func) );
	(*func)(d0, s1, s2);

double
nci_ddss( c_func, d0, s1, s2 )
	SV* c_func
	double d0
	short s1
	short s2
PREINIT:
	double(*func)(double, short, short);
CODE:
	func   = INT2PTR(double(*)(double, short, short), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, s2);
OUTPUT:
	RETVAL

short
nci_sdss( c_func, d0, s1, s2 )
	SV* c_func
	double d0
	short s1
	short s2
PREINIT:
	short(*func)(double, short, short);
CODE:
	func   = INT2PTR(short(*)(double, short, short), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, s2);
OUTPUT:
	RETVAL

float
nci_fdss( c_func, d0, s1, s2 )
	SV* c_func
	double d0
	short s1
	short s2
PREINIT:
	float(*func)(double, short, short);
CODE:
	func   = INT2PTR(float(*)(double, short, short), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, s2);
OUTPUT:
	RETVAL

char *
nci_tdss( c_func, d0, s1, s2 )
	SV* c_func
	double d0
	short s1
	short s2
PREINIT:
	char *(*func)(double, short, short);
CODE:
	func   = INT2PTR(char *(*)(double, short, short), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, s2);
OUTPUT:
	RETVAL

int
nci_idss( c_func, d0, s1, s2 )
	SV* c_func
	double d0
	short s1
	short s2
PREINIT:
	int(*func)(double, short, short);
CODE:
	func   = INT2PTR(int(*)(double, short, short), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, s2);
OUTPUT:
	RETVAL

void *
nci_psss( c_func, s0, s1, s2 )
	SV* c_func
	short s0
	short s1
	short s2
PREINIT:
	void *(*func)(short, short, short);
CODE:
	func   = INT2PTR(void *(*)(short, short, short), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, s2);
OUTPUT:
	RETVAL

void
nci_vsss( c_func, s0, s1, s2 )
	SV* c_func
	short s0
	short s1
	short s2
PREINIT:
	void(*func)(short, short, short);
CODE:
	func   = INT2PTR(void(*)(short, short, short), SvIV(c_func) );
	(*func)(s0, s1, s2);

double
nci_dsss( c_func, s0, s1, s2 )
	SV* c_func
	short s0
	short s1
	short s2
PREINIT:
	double(*func)(short, short, short);
CODE:
	func   = INT2PTR(double(*)(short, short, short), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, s2);
OUTPUT:
	RETVAL

short
nci_ssss( c_func, s0, s1, s2 )
	SV* c_func
	short s0
	short s1
	short s2
PREINIT:
	short(*func)(short, short, short);
CODE:
	func   = INT2PTR(short(*)(short, short, short), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, s2);
OUTPUT:
	RETVAL

float
nci_fsss( c_func, s0, s1, s2 )
	SV* c_func
	short s0
	short s1
	short s2
PREINIT:
	float(*func)(short, short, short);
CODE:
	func   = INT2PTR(float(*)(short, short, short), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, s2);
OUTPUT:
	RETVAL

char *
nci_tsss( c_func, s0, s1, s2 )
	SV* c_func
	short s0
	short s1
	short s2
PREINIT:
	char *(*func)(short, short, short);
CODE:
	func   = INT2PTR(char *(*)(short, short, short), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, s2);
OUTPUT:
	RETVAL

int
nci_isss( c_func, s0, s1, s2 )
	SV* c_func
	short s0
	short s1
	short s2
PREINIT:
	int(*func)(short, short, short);
CODE:
	func   = INT2PTR(int(*)(short, short, short), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, s2);
OUTPUT:
	RETVAL

void *
nci_pfss( c_func, f0, s1, s2 )
	SV* c_func
	float f0
	short s1
	short s2
PREINIT:
	void *(*func)(float, short, short);
CODE:
	func   = INT2PTR(void *(*)(float, short, short), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, s2);
OUTPUT:
	RETVAL

void
nci_vfss( c_func, f0, s1, s2 )
	SV* c_func
	float f0
	short s1
	short s2
PREINIT:
	void(*func)(float, short, short);
CODE:
	func   = INT2PTR(void(*)(float, short, short), SvIV(c_func) );
	(*func)(f0, s1, s2);

double
nci_dfss( c_func, f0, s1, s2 )
	SV* c_func
	float f0
	short s1
	short s2
PREINIT:
	double(*func)(float, short, short);
CODE:
	func   = INT2PTR(double(*)(float, short, short), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, s2);
OUTPUT:
	RETVAL

short
nci_sfss( c_func, f0, s1, s2 )
	SV* c_func
	float f0
	short s1
	short s2
PREINIT:
	short(*func)(float, short, short);
CODE:
	func   = INT2PTR(short(*)(float, short, short), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, s2);
OUTPUT:
	RETVAL

float
nci_ffss( c_func, f0, s1, s2 )
	SV* c_func
	float f0
	short s1
	short s2
PREINIT:
	float(*func)(float, short, short);
CODE:
	func   = INT2PTR(float(*)(float, short, short), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, s2);
OUTPUT:
	RETVAL

char *
nci_tfss( c_func, f0, s1, s2 )
	SV* c_func
	float f0
	short s1
	short s2
PREINIT:
	char *(*func)(float, short, short);
CODE:
	func   = INT2PTR(char *(*)(float, short, short), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, s2);
OUTPUT:
	RETVAL

int
nci_ifss( c_func, f0, s1, s2 )
	SV* c_func
	float f0
	short s1
	short s2
PREINIT:
	int(*func)(float, short, short);
CODE:
	func   = INT2PTR(int(*)(float, short, short), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, s2);
OUTPUT:
	RETVAL

void *
nci_ptss( c_func, t0, s1, s2 )
	SV* c_func
	char * t0
	short s1
	short s2
PREINIT:
	void *(*func)(char *, short, short);
CODE:
	func   = INT2PTR(void *(*)(char *, short, short), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, s2);
OUTPUT:
	RETVAL

void
nci_vtss( c_func, t0, s1, s2 )
	SV* c_func
	char * t0
	short s1
	short s2
PREINIT:
	void(*func)(char *, short, short);
CODE:
	func   = INT2PTR(void(*)(char *, short, short), SvIV(c_func) );
	(*func)(t0, s1, s2);

double
nci_dtss( c_func, t0, s1, s2 )
	SV* c_func
	char * t0
	short s1
	short s2
PREINIT:
	double(*func)(char *, short, short);
CODE:
	func   = INT2PTR(double(*)(char *, short, short), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, s2);
OUTPUT:
	RETVAL

short
nci_stss( c_func, t0, s1, s2 )
	SV* c_func
	char * t0
	short s1
	short s2
PREINIT:
	short(*func)(char *, short, short);
CODE:
	func   = INT2PTR(short(*)(char *, short, short), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, s2);
OUTPUT:
	RETVAL

float
nci_ftss( c_func, t0, s1, s2 )
	SV* c_func
	char * t0
	short s1
	short s2
PREINIT:
	float(*func)(char *, short, short);
CODE:
	func   = INT2PTR(float(*)(char *, short, short), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, s2);
OUTPUT:
	RETVAL

char *
nci_ttss( c_func, t0, s1, s2 )
	SV* c_func
	char * t0
	short s1
	short s2
PREINIT:
	char *(*func)(char *, short, short);
CODE:
	func   = INT2PTR(char *(*)(char *, short, short), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, s2);
OUTPUT:
	RETVAL

int
nci_itss( c_func, t0, s1, s2 )
	SV* c_func
	char * t0
	short s1
	short s2
PREINIT:
	int(*func)(char *, short, short);
CODE:
	func   = INT2PTR(int(*)(char *, short, short), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, s2);
OUTPUT:
	RETVAL

void *
nci_piss( c_func, i0, s1, s2 )
	SV* c_func
	int i0
	short s1
	short s2
PREINIT:
	void *(*func)(int, short, short);
CODE:
	func   = INT2PTR(void *(*)(int, short, short), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, s2);
OUTPUT:
	RETVAL

void
nci_viss( c_func, i0, s1, s2 )
	SV* c_func
	int i0
	short s1
	short s2
PREINIT:
	void(*func)(int, short, short);
CODE:
	func   = INT2PTR(void(*)(int, short, short), SvIV(c_func) );
	(*func)(i0, s1, s2);

double
nci_diss( c_func, i0, s1, s2 )
	SV* c_func
	int i0
	short s1
	short s2
PREINIT:
	double(*func)(int, short, short);
CODE:
	func   = INT2PTR(double(*)(int, short, short), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, s2);
OUTPUT:
	RETVAL

short
nci_siss( c_func, i0, s1, s2 )
	SV* c_func
	int i0
	short s1
	short s2
PREINIT:
	short(*func)(int, short, short);
CODE:
	func   = INT2PTR(short(*)(int, short, short), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, s2);
OUTPUT:
	RETVAL

float
nci_fiss( c_func, i0, s1, s2 )
	SV* c_func
	int i0
	short s1
	short s2
PREINIT:
	float(*func)(int, short, short);
CODE:
	func   = INT2PTR(float(*)(int, short, short), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, s2);
OUTPUT:
	RETVAL

char *
nci_tiss( c_func, i0, s1, s2 )
	SV* c_func
	int i0
	short s1
	short s2
PREINIT:
	char *(*func)(int, short, short);
CODE:
	func   = INT2PTR(char *(*)(int, short, short), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, s2);
OUTPUT:
	RETVAL

int
nci_iiss( c_func, i0, s1, s2 )
	SV* c_func
	int i0
	short s1
	short s2
PREINIT:
	int(*func)(int, short, short);
CODE:
	func   = INT2PTR(int(*)(int, short, short), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, s2);
OUTPUT:
	RETVAL

void *
nci_ppfs( c_func, p0, f1, s2 )
	SV* c_func
	void * p0
	float f1
	short s2
PREINIT:
	void *(*func)(void *, float, short);
CODE:
	func   = INT2PTR(void *(*)(void *, float, short), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, s2);
OUTPUT:
	RETVAL

void
nci_vpfs( c_func, p0, f1, s2 )
	SV* c_func
	void * p0
	float f1
	short s2
PREINIT:
	void(*func)(void *, float, short);
CODE:
	func   = INT2PTR(void(*)(void *, float, short), SvIV(c_func) );
	(*func)(p0, f1, s2);

double
nci_dpfs( c_func, p0, f1, s2 )
	SV* c_func
	void * p0
	float f1
	short s2
PREINIT:
	double(*func)(void *, float, short);
CODE:
	func   = INT2PTR(double(*)(void *, float, short), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, s2);
OUTPUT:
	RETVAL

short
nci_spfs( c_func, p0, f1, s2 )
	SV* c_func
	void * p0
	float f1
	short s2
PREINIT:
	short(*func)(void *, float, short);
CODE:
	func   = INT2PTR(short(*)(void *, float, short), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, s2);
OUTPUT:
	RETVAL

float
nci_fpfs( c_func, p0, f1, s2 )
	SV* c_func
	void * p0
	float f1
	short s2
PREINIT:
	float(*func)(void *, float, short);
CODE:
	func   = INT2PTR(float(*)(void *, float, short), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, s2);
OUTPUT:
	RETVAL

char *
nci_tpfs( c_func, p0, f1, s2 )
	SV* c_func
	void * p0
	float f1
	short s2
PREINIT:
	char *(*func)(void *, float, short);
CODE:
	func   = INT2PTR(char *(*)(void *, float, short), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, s2);
OUTPUT:
	RETVAL

int
nci_ipfs( c_func, p0, f1, s2 )
	SV* c_func
	void * p0
	float f1
	short s2
PREINIT:
	int(*func)(void *, float, short);
CODE:
	func   = INT2PTR(int(*)(void *, float, short), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, s2);
OUTPUT:
	RETVAL

void *
nci_pvfs( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvfs( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvfs( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svfs( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvfs( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvfs( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivfs( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdfs( c_func, d0, f1, s2 )
	SV* c_func
	double d0
	float f1
	short s2
PREINIT:
	void *(*func)(double, float, short);
CODE:
	func   = INT2PTR(void *(*)(double, float, short), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, s2);
OUTPUT:
	RETVAL

void
nci_vdfs( c_func, d0, f1, s2 )
	SV* c_func
	double d0
	float f1
	short s2
PREINIT:
	void(*func)(double, float, short);
CODE:
	func   = INT2PTR(void(*)(double, float, short), SvIV(c_func) );
	(*func)(d0, f1, s2);

double
nci_ddfs( c_func, d0, f1, s2 )
	SV* c_func
	double d0
	float f1
	short s2
PREINIT:
	double(*func)(double, float, short);
CODE:
	func   = INT2PTR(double(*)(double, float, short), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, s2);
OUTPUT:
	RETVAL

short
nci_sdfs( c_func, d0, f1, s2 )
	SV* c_func
	double d0
	float f1
	short s2
PREINIT:
	short(*func)(double, float, short);
CODE:
	func   = INT2PTR(short(*)(double, float, short), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, s2);
OUTPUT:
	RETVAL

float
nci_fdfs( c_func, d0, f1, s2 )
	SV* c_func
	double d0
	float f1
	short s2
PREINIT:
	float(*func)(double, float, short);
CODE:
	func   = INT2PTR(float(*)(double, float, short), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, s2);
OUTPUT:
	RETVAL

char *
nci_tdfs( c_func, d0, f1, s2 )
	SV* c_func
	double d0
	float f1
	short s2
PREINIT:
	char *(*func)(double, float, short);
CODE:
	func   = INT2PTR(char *(*)(double, float, short), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, s2);
OUTPUT:
	RETVAL

int
nci_idfs( c_func, d0, f1, s2 )
	SV* c_func
	double d0
	float f1
	short s2
PREINIT:
	int(*func)(double, float, short);
CODE:
	func   = INT2PTR(int(*)(double, float, short), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, s2);
OUTPUT:
	RETVAL

void *
nci_psfs( c_func, s0, f1, s2 )
	SV* c_func
	short s0
	float f1
	short s2
PREINIT:
	void *(*func)(short, float, short);
CODE:
	func   = INT2PTR(void *(*)(short, float, short), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, s2);
OUTPUT:
	RETVAL

void
nci_vsfs( c_func, s0, f1, s2 )
	SV* c_func
	short s0
	float f1
	short s2
PREINIT:
	void(*func)(short, float, short);
CODE:
	func   = INT2PTR(void(*)(short, float, short), SvIV(c_func) );
	(*func)(s0, f1, s2);

double
nci_dsfs( c_func, s0, f1, s2 )
	SV* c_func
	short s0
	float f1
	short s2
PREINIT:
	double(*func)(short, float, short);
CODE:
	func   = INT2PTR(double(*)(short, float, short), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, s2);
OUTPUT:
	RETVAL

short
nci_ssfs( c_func, s0, f1, s2 )
	SV* c_func
	short s0
	float f1
	short s2
PREINIT:
	short(*func)(short, float, short);
CODE:
	func   = INT2PTR(short(*)(short, float, short), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, s2);
OUTPUT:
	RETVAL

float
nci_fsfs( c_func, s0, f1, s2 )
	SV* c_func
	short s0
	float f1
	short s2
PREINIT:
	float(*func)(short, float, short);
CODE:
	func   = INT2PTR(float(*)(short, float, short), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, s2);
OUTPUT:
	RETVAL

char *
nci_tsfs( c_func, s0, f1, s2 )
	SV* c_func
	short s0
	float f1
	short s2
PREINIT:
	char *(*func)(short, float, short);
CODE:
	func   = INT2PTR(char *(*)(short, float, short), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, s2);
OUTPUT:
	RETVAL

int
nci_isfs( c_func, s0, f1, s2 )
	SV* c_func
	short s0
	float f1
	short s2
PREINIT:
	int(*func)(short, float, short);
CODE:
	func   = INT2PTR(int(*)(short, float, short), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, s2);
OUTPUT:
	RETVAL

void *
nci_pffs( c_func, f0, f1, s2 )
	SV* c_func
	float f0
	float f1
	short s2
PREINIT:
	void *(*func)(float, float, short);
CODE:
	func   = INT2PTR(void *(*)(float, float, short), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, s2);
OUTPUT:
	RETVAL

void
nci_vffs( c_func, f0, f1, s2 )
	SV* c_func
	float f0
	float f1
	short s2
PREINIT:
	void(*func)(float, float, short);
CODE:
	func   = INT2PTR(void(*)(float, float, short), SvIV(c_func) );
	(*func)(f0, f1, s2);

double
nci_dffs( c_func, f0, f1, s2 )
	SV* c_func
	float f0
	float f1
	short s2
PREINIT:
	double(*func)(float, float, short);
CODE:
	func   = INT2PTR(double(*)(float, float, short), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, s2);
OUTPUT:
	RETVAL

short
nci_sffs( c_func, f0, f1, s2 )
	SV* c_func
	float f0
	float f1
	short s2
PREINIT:
	short(*func)(float, float, short);
CODE:
	func   = INT2PTR(short(*)(float, float, short), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, s2);
OUTPUT:
	RETVAL

float
nci_fffs( c_func, f0, f1, s2 )
	SV* c_func
	float f0
	float f1
	short s2
PREINIT:
	float(*func)(float, float, short);
CODE:
	func   = INT2PTR(float(*)(float, float, short), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, s2);
OUTPUT:
	RETVAL

char *
nci_tffs( c_func, f0, f1, s2 )
	SV* c_func
	float f0
	float f1
	short s2
PREINIT:
	char *(*func)(float, float, short);
CODE:
	func   = INT2PTR(char *(*)(float, float, short), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, s2);
OUTPUT:
	RETVAL

int
nci_iffs( c_func, f0, f1, s2 )
	SV* c_func
	float f0
	float f1
	short s2
PREINIT:
	int(*func)(float, float, short);
CODE:
	func   = INT2PTR(int(*)(float, float, short), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, s2);
OUTPUT:
	RETVAL

void *
nci_ptfs( c_func, t0, f1, s2 )
	SV* c_func
	char * t0
	float f1
	short s2
PREINIT:
	void *(*func)(char *, float, short);
CODE:
	func   = INT2PTR(void *(*)(char *, float, short), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, s2);
OUTPUT:
	RETVAL

void
nci_vtfs( c_func, t0, f1, s2 )
	SV* c_func
	char * t0
	float f1
	short s2
PREINIT:
	void(*func)(char *, float, short);
CODE:
	func   = INT2PTR(void(*)(char *, float, short), SvIV(c_func) );
	(*func)(t0, f1, s2);

double
nci_dtfs( c_func, t0, f1, s2 )
	SV* c_func
	char * t0
	float f1
	short s2
PREINIT:
	double(*func)(char *, float, short);
CODE:
	func   = INT2PTR(double(*)(char *, float, short), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, s2);
OUTPUT:
	RETVAL

short
nci_stfs( c_func, t0, f1, s2 )
	SV* c_func
	char * t0
	float f1
	short s2
PREINIT:
	short(*func)(char *, float, short);
CODE:
	func   = INT2PTR(short(*)(char *, float, short), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, s2);
OUTPUT:
	RETVAL

float
nci_ftfs( c_func, t0, f1, s2 )
	SV* c_func
	char * t0
	float f1
	short s2
PREINIT:
	float(*func)(char *, float, short);
CODE:
	func   = INT2PTR(float(*)(char *, float, short), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, s2);
OUTPUT:
	RETVAL

char *
nci_ttfs( c_func, t0, f1, s2 )
	SV* c_func
	char * t0
	float f1
	short s2
PREINIT:
	char *(*func)(char *, float, short);
CODE:
	func   = INT2PTR(char *(*)(char *, float, short), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, s2);
OUTPUT:
	RETVAL

int
nci_itfs( c_func, t0, f1, s2 )
	SV* c_func
	char * t0
	float f1
	short s2
PREINIT:
	int(*func)(char *, float, short);
CODE:
	func   = INT2PTR(int(*)(char *, float, short), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, s2);
OUTPUT:
	RETVAL

void *
nci_pifs( c_func, i0, f1, s2 )
	SV* c_func
	int i0
	float f1
	short s2
PREINIT:
	void *(*func)(int, float, short);
CODE:
	func   = INT2PTR(void *(*)(int, float, short), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, s2);
OUTPUT:
	RETVAL

void
nci_vifs( c_func, i0, f1, s2 )
	SV* c_func
	int i0
	float f1
	short s2
PREINIT:
	void(*func)(int, float, short);
CODE:
	func   = INT2PTR(void(*)(int, float, short), SvIV(c_func) );
	(*func)(i0, f1, s2);

double
nci_difs( c_func, i0, f1, s2 )
	SV* c_func
	int i0
	float f1
	short s2
PREINIT:
	double(*func)(int, float, short);
CODE:
	func   = INT2PTR(double(*)(int, float, short), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, s2);
OUTPUT:
	RETVAL

short
nci_sifs( c_func, i0, f1, s2 )
	SV* c_func
	int i0
	float f1
	short s2
PREINIT:
	short(*func)(int, float, short);
CODE:
	func   = INT2PTR(short(*)(int, float, short), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, s2);
OUTPUT:
	RETVAL

float
nci_fifs( c_func, i0, f1, s2 )
	SV* c_func
	int i0
	float f1
	short s2
PREINIT:
	float(*func)(int, float, short);
CODE:
	func   = INT2PTR(float(*)(int, float, short), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, s2);
OUTPUT:
	RETVAL

char *
nci_tifs( c_func, i0, f1, s2 )
	SV* c_func
	int i0
	float f1
	short s2
PREINIT:
	char *(*func)(int, float, short);
CODE:
	func   = INT2PTR(char *(*)(int, float, short), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, s2);
OUTPUT:
	RETVAL

int
nci_iifs( c_func, i0, f1, s2 )
	SV* c_func
	int i0
	float f1
	short s2
PREINIT:
	int(*func)(int, float, short);
CODE:
	func   = INT2PTR(int(*)(int, float, short), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, s2);
OUTPUT:
	RETVAL

void *
nci_ppts( c_func, p0, t1, s2 )
	SV* c_func
	void * p0
	char * t1
	short s2
PREINIT:
	void *(*func)(void *, char *, short);
CODE:
	func   = INT2PTR(void *(*)(void *, char *, short), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, s2);
OUTPUT:
	RETVAL

void
nci_vpts( c_func, p0, t1, s2 )
	SV* c_func
	void * p0
	char * t1
	short s2
PREINIT:
	void(*func)(void *, char *, short);
CODE:
	func   = INT2PTR(void(*)(void *, char *, short), SvIV(c_func) );
	(*func)(p0, t1, s2);

double
nci_dpts( c_func, p0, t1, s2 )
	SV* c_func
	void * p0
	char * t1
	short s2
PREINIT:
	double(*func)(void *, char *, short);
CODE:
	func   = INT2PTR(double(*)(void *, char *, short), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, s2);
OUTPUT:
	RETVAL

short
nci_spts( c_func, p0, t1, s2 )
	SV* c_func
	void * p0
	char * t1
	short s2
PREINIT:
	short(*func)(void *, char *, short);
CODE:
	func   = INT2PTR(short(*)(void *, char *, short), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, s2);
OUTPUT:
	RETVAL

float
nci_fpts( c_func, p0, t1, s2 )
	SV* c_func
	void * p0
	char * t1
	short s2
PREINIT:
	float(*func)(void *, char *, short);
CODE:
	func   = INT2PTR(float(*)(void *, char *, short), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, s2);
OUTPUT:
	RETVAL

char *
nci_tpts( c_func, p0, t1, s2 )
	SV* c_func
	void * p0
	char * t1
	short s2
PREINIT:
	char *(*func)(void *, char *, short);
CODE:
	func   = INT2PTR(char *(*)(void *, char *, short), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, s2);
OUTPUT:
	RETVAL

int
nci_ipts( c_func, p0, t1, s2 )
	SV* c_func
	void * p0
	char * t1
	short s2
PREINIT:
	int(*func)(void *, char *, short);
CODE:
	func   = INT2PTR(int(*)(void *, char *, short), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, s2);
OUTPUT:
	RETVAL

void *
nci_pvts( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvts( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvts( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svts( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvts( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvts( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivts( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdts( c_func, d0, t1, s2 )
	SV* c_func
	double d0
	char * t1
	short s2
PREINIT:
	void *(*func)(double, char *, short);
CODE:
	func   = INT2PTR(void *(*)(double, char *, short), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, s2);
OUTPUT:
	RETVAL

void
nci_vdts( c_func, d0, t1, s2 )
	SV* c_func
	double d0
	char * t1
	short s2
PREINIT:
	void(*func)(double, char *, short);
CODE:
	func   = INT2PTR(void(*)(double, char *, short), SvIV(c_func) );
	(*func)(d0, t1, s2);

double
nci_ddts( c_func, d0, t1, s2 )
	SV* c_func
	double d0
	char * t1
	short s2
PREINIT:
	double(*func)(double, char *, short);
CODE:
	func   = INT2PTR(double(*)(double, char *, short), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, s2);
OUTPUT:
	RETVAL

short
nci_sdts( c_func, d0, t1, s2 )
	SV* c_func
	double d0
	char * t1
	short s2
PREINIT:
	short(*func)(double, char *, short);
CODE:
	func   = INT2PTR(short(*)(double, char *, short), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, s2);
OUTPUT:
	RETVAL

float
nci_fdts( c_func, d0, t1, s2 )
	SV* c_func
	double d0
	char * t1
	short s2
PREINIT:
	float(*func)(double, char *, short);
CODE:
	func   = INT2PTR(float(*)(double, char *, short), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, s2);
OUTPUT:
	RETVAL

char *
nci_tdts( c_func, d0, t1, s2 )
	SV* c_func
	double d0
	char * t1
	short s2
PREINIT:
	char *(*func)(double, char *, short);
CODE:
	func   = INT2PTR(char *(*)(double, char *, short), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, s2);
OUTPUT:
	RETVAL

int
nci_idts( c_func, d0, t1, s2 )
	SV* c_func
	double d0
	char * t1
	short s2
PREINIT:
	int(*func)(double, char *, short);
CODE:
	func   = INT2PTR(int(*)(double, char *, short), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, s2);
OUTPUT:
	RETVAL

void *
nci_psts( c_func, s0, t1, s2 )
	SV* c_func
	short s0
	char * t1
	short s2
PREINIT:
	void *(*func)(short, char *, short);
CODE:
	func   = INT2PTR(void *(*)(short, char *, short), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, s2);
OUTPUT:
	RETVAL

void
nci_vsts( c_func, s0, t1, s2 )
	SV* c_func
	short s0
	char * t1
	short s2
PREINIT:
	void(*func)(short, char *, short);
CODE:
	func   = INT2PTR(void(*)(short, char *, short), SvIV(c_func) );
	(*func)(s0, t1, s2);

double
nci_dsts( c_func, s0, t1, s2 )
	SV* c_func
	short s0
	char * t1
	short s2
PREINIT:
	double(*func)(short, char *, short);
CODE:
	func   = INT2PTR(double(*)(short, char *, short), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, s2);
OUTPUT:
	RETVAL

short
nci_ssts( c_func, s0, t1, s2 )
	SV* c_func
	short s0
	char * t1
	short s2
PREINIT:
	short(*func)(short, char *, short);
CODE:
	func   = INT2PTR(short(*)(short, char *, short), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, s2);
OUTPUT:
	RETVAL

float
nci_fsts( c_func, s0, t1, s2 )
	SV* c_func
	short s0
	char * t1
	short s2
PREINIT:
	float(*func)(short, char *, short);
CODE:
	func   = INT2PTR(float(*)(short, char *, short), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, s2);
OUTPUT:
	RETVAL

char *
nci_tsts( c_func, s0, t1, s2 )
	SV* c_func
	short s0
	char * t1
	short s2
PREINIT:
	char *(*func)(short, char *, short);
CODE:
	func   = INT2PTR(char *(*)(short, char *, short), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, s2);
OUTPUT:
	RETVAL

int
nci_ists( c_func, s0, t1, s2 )
	SV* c_func
	short s0
	char * t1
	short s2
PREINIT:
	int(*func)(short, char *, short);
CODE:
	func   = INT2PTR(int(*)(short, char *, short), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, s2);
OUTPUT:
	RETVAL

void *
nci_pfts( c_func, f0, t1, s2 )
	SV* c_func
	float f0
	char * t1
	short s2
PREINIT:
	void *(*func)(float, char *, short);
CODE:
	func   = INT2PTR(void *(*)(float, char *, short), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, s2);
OUTPUT:
	RETVAL

void
nci_vfts( c_func, f0, t1, s2 )
	SV* c_func
	float f0
	char * t1
	short s2
PREINIT:
	void(*func)(float, char *, short);
CODE:
	func   = INT2PTR(void(*)(float, char *, short), SvIV(c_func) );
	(*func)(f0, t1, s2);

double
nci_dfts( c_func, f0, t1, s2 )
	SV* c_func
	float f0
	char * t1
	short s2
PREINIT:
	double(*func)(float, char *, short);
CODE:
	func   = INT2PTR(double(*)(float, char *, short), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, s2);
OUTPUT:
	RETVAL

short
nci_sfts( c_func, f0, t1, s2 )
	SV* c_func
	float f0
	char * t1
	short s2
PREINIT:
	short(*func)(float, char *, short);
CODE:
	func   = INT2PTR(short(*)(float, char *, short), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, s2);
OUTPUT:
	RETVAL

float
nci_ffts( c_func, f0, t1, s2 )
	SV* c_func
	float f0
	char * t1
	short s2
PREINIT:
	float(*func)(float, char *, short);
CODE:
	func   = INT2PTR(float(*)(float, char *, short), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, s2);
OUTPUT:
	RETVAL

char *
nci_tfts( c_func, f0, t1, s2 )
	SV* c_func
	float f0
	char * t1
	short s2
PREINIT:
	char *(*func)(float, char *, short);
CODE:
	func   = INT2PTR(char *(*)(float, char *, short), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, s2);
OUTPUT:
	RETVAL

int
nci_ifts( c_func, f0, t1, s2 )
	SV* c_func
	float f0
	char * t1
	short s2
PREINIT:
	int(*func)(float, char *, short);
CODE:
	func   = INT2PTR(int(*)(float, char *, short), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, s2);
OUTPUT:
	RETVAL

void *
nci_ptts( c_func, t0, t1, s2 )
	SV* c_func
	char * t0
	char * t1
	short s2
PREINIT:
	void *(*func)(char *, char *, short);
CODE:
	func   = INT2PTR(void *(*)(char *, char *, short), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, s2);
OUTPUT:
	RETVAL

void
nci_vtts( c_func, t0, t1, s2 )
	SV* c_func
	char * t0
	char * t1
	short s2
PREINIT:
	void(*func)(char *, char *, short);
CODE:
	func   = INT2PTR(void(*)(char *, char *, short), SvIV(c_func) );
	(*func)(t0, t1, s2);

double
nci_dtts( c_func, t0, t1, s2 )
	SV* c_func
	char * t0
	char * t1
	short s2
PREINIT:
	double(*func)(char *, char *, short);
CODE:
	func   = INT2PTR(double(*)(char *, char *, short), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, s2);
OUTPUT:
	RETVAL

short
nci_stts( c_func, t0, t1, s2 )
	SV* c_func
	char * t0
	char * t1
	short s2
PREINIT:
	short(*func)(char *, char *, short);
CODE:
	func   = INT2PTR(short(*)(char *, char *, short), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, s2);
OUTPUT:
	RETVAL

float
nci_ftts( c_func, t0, t1, s2 )
	SV* c_func
	char * t0
	char * t1
	short s2
PREINIT:
	float(*func)(char *, char *, short);
CODE:
	func   = INT2PTR(float(*)(char *, char *, short), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, s2);
OUTPUT:
	RETVAL

char *
nci_ttts( c_func, t0, t1, s2 )
	SV* c_func
	char * t0
	char * t1
	short s2
PREINIT:
	char *(*func)(char *, char *, short);
CODE:
	func   = INT2PTR(char *(*)(char *, char *, short), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, s2);
OUTPUT:
	RETVAL

int
nci_itts( c_func, t0, t1, s2 )
	SV* c_func
	char * t0
	char * t1
	short s2
PREINIT:
	int(*func)(char *, char *, short);
CODE:
	func   = INT2PTR(int(*)(char *, char *, short), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, s2);
OUTPUT:
	RETVAL

void *
nci_pits( c_func, i0, t1, s2 )
	SV* c_func
	int i0
	char * t1
	short s2
PREINIT:
	void *(*func)(int, char *, short);
CODE:
	func   = INT2PTR(void *(*)(int, char *, short), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, s2);
OUTPUT:
	RETVAL

void
nci_vits( c_func, i0, t1, s2 )
	SV* c_func
	int i0
	char * t1
	short s2
PREINIT:
	void(*func)(int, char *, short);
CODE:
	func   = INT2PTR(void(*)(int, char *, short), SvIV(c_func) );
	(*func)(i0, t1, s2);

double
nci_dits( c_func, i0, t1, s2 )
	SV* c_func
	int i0
	char * t1
	short s2
PREINIT:
	double(*func)(int, char *, short);
CODE:
	func   = INT2PTR(double(*)(int, char *, short), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, s2);
OUTPUT:
	RETVAL

short
nci_sits( c_func, i0, t1, s2 )
	SV* c_func
	int i0
	char * t1
	short s2
PREINIT:
	short(*func)(int, char *, short);
CODE:
	func   = INT2PTR(short(*)(int, char *, short), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, s2);
OUTPUT:
	RETVAL

float
nci_fits( c_func, i0, t1, s2 )
	SV* c_func
	int i0
	char * t1
	short s2
PREINIT:
	float(*func)(int, char *, short);
CODE:
	func   = INT2PTR(float(*)(int, char *, short), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, s2);
OUTPUT:
	RETVAL

char *
nci_tits( c_func, i0, t1, s2 )
	SV* c_func
	int i0
	char * t1
	short s2
PREINIT:
	char *(*func)(int, char *, short);
CODE:
	func   = INT2PTR(char *(*)(int, char *, short), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, s2);
OUTPUT:
	RETVAL

int
nci_iits( c_func, i0, t1, s2 )
	SV* c_func
	int i0
	char * t1
	short s2
PREINIT:
	int(*func)(int, char *, short);
CODE:
	func   = INT2PTR(int(*)(int, char *, short), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, s2);
OUTPUT:
	RETVAL

void *
nci_ppis( c_func, p0, i1, s2 )
	SV* c_func
	void * p0
	int i1
	short s2
PREINIT:
	void *(*func)(void *, int, short);
CODE:
	func   = INT2PTR(void *(*)(void *, int, short), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, s2);
OUTPUT:
	RETVAL

void
nci_vpis( c_func, p0, i1, s2 )
	SV* c_func
	void * p0
	int i1
	short s2
PREINIT:
	void(*func)(void *, int, short);
CODE:
	func   = INT2PTR(void(*)(void *, int, short), SvIV(c_func) );
	(*func)(p0, i1, s2);

double
nci_dpis( c_func, p0, i1, s2 )
	SV* c_func
	void * p0
	int i1
	short s2
PREINIT:
	double(*func)(void *, int, short);
CODE:
	func   = INT2PTR(double(*)(void *, int, short), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, s2);
OUTPUT:
	RETVAL

short
nci_spis( c_func, p0, i1, s2 )
	SV* c_func
	void * p0
	int i1
	short s2
PREINIT:
	short(*func)(void *, int, short);
CODE:
	func   = INT2PTR(short(*)(void *, int, short), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, s2);
OUTPUT:
	RETVAL

float
nci_fpis( c_func, p0, i1, s2 )
	SV* c_func
	void * p0
	int i1
	short s2
PREINIT:
	float(*func)(void *, int, short);
CODE:
	func   = INT2PTR(float(*)(void *, int, short), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, s2);
OUTPUT:
	RETVAL

char *
nci_tpis( c_func, p0, i1, s2 )
	SV* c_func
	void * p0
	int i1
	short s2
PREINIT:
	char *(*func)(void *, int, short);
CODE:
	func   = INT2PTR(char *(*)(void *, int, short), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, s2);
OUTPUT:
	RETVAL

int
nci_ipis( c_func, p0, i1, s2 )
	SV* c_func
	void * p0
	int i1
	short s2
PREINIT:
	int(*func)(void *, int, short);
CODE:
	func   = INT2PTR(int(*)(void *, int, short), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, s2);
OUTPUT:
	RETVAL

void *
nci_pvis( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvis( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvis( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svis( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvis( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvis( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivis( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdis( c_func, d0, i1, s2 )
	SV* c_func
	double d0
	int i1
	short s2
PREINIT:
	void *(*func)(double, int, short);
CODE:
	func   = INT2PTR(void *(*)(double, int, short), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, s2);
OUTPUT:
	RETVAL

void
nci_vdis( c_func, d0, i1, s2 )
	SV* c_func
	double d0
	int i1
	short s2
PREINIT:
	void(*func)(double, int, short);
CODE:
	func   = INT2PTR(void(*)(double, int, short), SvIV(c_func) );
	(*func)(d0, i1, s2);

double
nci_ddis( c_func, d0, i1, s2 )
	SV* c_func
	double d0
	int i1
	short s2
PREINIT:
	double(*func)(double, int, short);
CODE:
	func   = INT2PTR(double(*)(double, int, short), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, s2);
OUTPUT:
	RETVAL

short
nci_sdis( c_func, d0, i1, s2 )
	SV* c_func
	double d0
	int i1
	short s2
PREINIT:
	short(*func)(double, int, short);
CODE:
	func   = INT2PTR(short(*)(double, int, short), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, s2);
OUTPUT:
	RETVAL

float
nci_fdis( c_func, d0, i1, s2 )
	SV* c_func
	double d0
	int i1
	short s2
PREINIT:
	float(*func)(double, int, short);
CODE:
	func   = INT2PTR(float(*)(double, int, short), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, s2);
OUTPUT:
	RETVAL

char *
nci_tdis( c_func, d0, i1, s2 )
	SV* c_func
	double d0
	int i1
	short s2
PREINIT:
	char *(*func)(double, int, short);
CODE:
	func   = INT2PTR(char *(*)(double, int, short), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, s2);
OUTPUT:
	RETVAL

int
nci_idis( c_func, d0, i1, s2 )
	SV* c_func
	double d0
	int i1
	short s2
PREINIT:
	int(*func)(double, int, short);
CODE:
	func   = INT2PTR(int(*)(double, int, short), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, s2);
OUTPUT:
	RETVAL

void *
nci_psis( c_func, s0, i1, s2 )
	SV* c_func
	short s0
	int i1
	short s2
PREINIT:
	void *(*func)(short, int, short);
CODE:
	func   = INT2PTR(void *(*)(short, int, short), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, s2);
OUTPUT:
	RETVAL

void
nci_vsis( c_func, s0, i1, s2 )
	SV* c_func
	short s0
	int i1
	short s2
PREINIT:
	void(*func)(short, int, short);
CODE:
	func   = INT2PTR(void(*)(short, int, short), SvIV(c_func) );
	(*func)(s0, i1, s2);

double
nci_dsis( c_func, s0, i1, s2 )
	SV* c_func
	short s0
	int i1
	short s2
PREINIT:
	double(*func)(short, int, short);
CODE:
	func   = INT2PTR(double(*)(short, int, short), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, s2);
OUTPUT:
	RETVAL

short
nci_ssis( c_func, s0, i1, s2 )
	SV* c_func
	short s0
	int i1
	short s2
PREINIT:
	short(*func)(short, int, short);
CODE:
	func   = INT2PTR(short(*)(short, int, short), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, s2);
OUTPUT:
	RETVAL

float
nci_fsis( c_func, s0, i1, s2 )
	SV* c_func
	short s0
	int i1
	short s2
PREINIT:
	float(*func)(short, int, short);
CODE:
	func   = INT2PTR(float(*)(short, int, short), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, s2);
OUTPUT:
	RETVAL

char *
nci_tsis( c_func, s0, i1, s2 )
	SV* c_func
	short s0
	int i1
	short s2
PREINIT:
	char *(*func)(short, int, short);
CODE:
	func   = INT2PTR(char *(*)(short, int, short), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, s2);
OUTPUT:
	RETVAL

int
nci_isis( c_func, s0, i1, s2 )
	SV* c_func
	short s0
	int i1
	short s2
PREINIT:
	int(*func)(short, int, short);
CODE:
	func   = INT2PTR(int(*)(short, int, short), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, s2);
OUTPUT:
	RETVAL

void *
nci_pfis( c_func, f0, i1, s2 )
	SV* c_func
	float f0
	int i1
	short s2
PREINIT:
	void *(*func)(float, int, short);
CODE:
	func   = INT2PTR(void *(*)(float, int, short), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, s2);
OUTPUT:
	RETVAL

void
nci_vfis( c_func, f0, i1, s2 )
	SV* c_func
	float f0
	int i1
	short s2
PREINIT:
	void(*func)(float, int, short);
CODE:
	func   = INT2PTR(void(*)(float, int, short), SvIV(c_func) );
	(*func)(f0, i1, s2);

double
nci_dfis( c_func, f0, i1, s2 )
	SV* c_func
	float f0
	int i1
	short s2
PREINIT:
	double(*func)(float, int, short);
CODE:
	func   = INT2PTR(double(*)(float, int, short), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, s2);
OUTPUT:
	RETVAL

short
nci_sfis( c_func, f0, i1, s2 )
	SV* c_func
	float f0
	int i1
	short s2
PREINIT:
	short(*func)(float, int, short);
CODE:
	func   = INT2PTR(short(*)(float, int, short), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, s2);
OUTPUT:
	RETVAL

float
nci_ffis( c_func, f0, i1, s2 )
	SV* c_func
	float f0
	int i1
	short s2
PREINIT:
	float(*func)(float, int, short);
CODE:
	func   = INT2PTR(float(*)(float, int, short), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, s2);
OUTPUT:
	RETVAL

char *
nci_tfis( c_func, f0, i1, s2 )
	SV* c_func
	float f0
	int i1
	short s2
PREINIT:
	char *(*func)(float, int, short);
CODE:
	func   = INT2PTR(char *(*)(float, int, short), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, s2);
OUTPUT:
	RETVAL

int
nci_ifis( c_func, f0, i1, s2 )
	SV* c_func
	float f0
	int i1
	short s2
PREINIT:
	int(*func)(float, int, short);
CODE:
	func   = INT2PTR(int(*)(float, int, short), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, s2);
OUTPUT:
	RETVAL

void *
nci_ptis( c_func, t0, i1, s2 )
	SV* c_func
	char * t0
	int i1
	short s2
PREINIT:
	void *(*func)(char *, int, short);
CODE:
	func   = INT2PTR(void *(*)(char *, int, short), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, s2);
OUTPUT:
	RETVAL

void
nci_vtis( c_func, t0, i1, s2 )
	SV* c_func
	char * t0
	int i1
	short s2
PREINIT:
	void(*func)(char *, int, short);
CODE:
	func   = INT2PTR(void(*)(char *, int, short), SvIV(c_func) );
	(*func)(t0, i1, s2);

double
nci_dtis( c_func, t0, i1, s2 )
	SV* c_func
	char * t0
	int i1
	short s2
PREINIT:
	double(*func)(char *, int, short);
CODE:
	func   = INT2PTR(double(*)(char *, int, short), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, s2);
OUTPUT:
	RETVAL

short
nci_stis( c_func, t0, i1, s2 )
	SV* c_func
	char * t0
	int i1
	short s2
PREINIT:
	short(*func)(char *, int, short);
CODE:
	func   = INT2PTR(short(*)(char *, int, short), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, s2);
OUTPUT:
	RETVAL

float
nci_ftis( c_func, t0, i1, s2 )
	SV* c_func
	char * t0
	int i1
	short s2
PREINIT:
	float(*func)(char *, int, short);
CODE:
	func   = INT2PTR(float(*)(char *, int, short), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, s2);
OUTPUT:
	RETVAL

char *
nci_ttis( c_func, t0, i1, s2 )
	SV* c_func
	char * t0
	int i1
	short s2
PREINIT:
	char *(*func)(char *, int, short);
CODE:
	func   = INT2PTR(char *(*)(char *, int, short), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, s2);
OUTPUT:
	RETVAL

int
nci_itis( c_func, t0, i1, s2 )
	SV* c_func
	char * t0
	int i1
	short s2
PREINIT:
	int(*func)(char *, int, short);
CODE:
	func   = INT2PTR(int(*)(char *, int, short), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, s2);
OUTPUT:
	RETVAL

void *
nci_piis( c_func, i0, i1, s2 )
	SV* c_func
	int i0
	int i1
	short s2
PREINIT:
	void *(*func)(int, int, short);
CODE:
	func   = INT2PTR(void *(*)(int, int, short), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, s2);
OUTPUT:
	RETVAL

void
nci_viis( c_func, i0, i1, s2 )
	SV* c_func
	int i0
	int i1
	short s2
PREINIT:
	void(*func)(int, int, short);
CODE:
	func   = INT2PTR(void(*)(int, int, short), SvIV(c_func) );
	(*func)(i0, i1, s2);

double
nci_diis( c_func, i0, i1, s2 )
	SV* c_func
	int i0
	int i1
	short s2
PREINIT:
	double(*func)(int, int, short);
CODE:
	func   = INT2PTR(double(*)(int, int, short), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, s2);
OUTPUT:
	RETVAL

short
nci_siis( c_func, i0, i1, s2 )
	SV* c_func
	int i0
	int i1
	short s2
PREINIT:
	short(*func)(int, int, short);
CODE:
	func   = INT2PTR(short(*)(int, int, short), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, s2);
OUTPUT:
	RETVAL

float
nci_fiis( c_func, i0, i1, s2 )
	SV* c_func
	int i0
	int i1
	short s2
PREINIT:
	float(*func)(int, int, short);
CODE:
	func   = INT2PTR(float(*)(int, int, short), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, s2);
OUTPUT:
	RETVAL

char *
nci_tiis( c_func, i0, i1, s2 )
	SV* c_func
	int i0
	int i1
	short s2
PREINIT:
	char *(*func)(int, int, short);
CODE:
	func   = INT2PTR(char *(*)(int, int, short), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, s2);
OUTPUT:
	RETVAL

int
nci_iiis( c_func, i0, i1, s2 )
	SV* c_func
	int i0
	int i1
	short s2
PREINIT:
	int(*func)(int, int, short);
CODE:
	func   = INT2PTR(int(*)(int, int, short), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, s2);
OUTPUT:
	RETVAL

void *
nci_pppf( c_func, p0, p1, f2 )
	SV* c_func
	void * p0
	void * p1
	float f2
PREINIT:
	void *(*func)(void *, void *, float);
CODE:
	func   = INT2PTR(void *(*)(void *, void *, float), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, f2);
OUTPUT:
	RETVAL

void
nci_vppf( c_func, p0, p1, f2 )
	SV* c_func
	void * p0
	void * p1
	float f2
PREINIT:
	void(*func)(void *, void *, float);
CODE:
	func   = INT2PTR(void(*)(void *, void *, float), SvIV(c_func) );
	(*func)(p0, p1, f2);

double
nci_dppf( c_func, p0, p1, f2 )
	SV* c_func
	void * p0
	void * p1
	float f2
PREINIT:
	double(*func)(void *, void *, float);
CODE:
	func   = INT2PTR(double(*)(void *, void *, float), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, f2);
OUTPUT:
	RETVAL

short
nci_sppf( c_func, p0, p1, f2 )
	SV* c_func
	void * p0
	void * p1
	float f2
PREINIT:
	short(*func)(void *, void *, float);
CODE:
	func   = INT2PTR(short(*)(void *, void *, float), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, f2);
OUTPUT:
	RETVAL

float
nci_fppf( c_func, p0, p1, f2 )
	SV* c_func
	void * p0
	void * p1
	float f2
PREINIT:
	float(*func)(void *, void *, float);
CODE:
	func   = INT2PTR(float(*)(void *, void *, float), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, f2);
OUTPUT:
	RETVAL

char *
nci_tppf( c_func, p0, p1, f2 )
	SV* c_func
	void * p0
	void * p1
	float f2
PREINIT:
	char *(*func)(void *, void *, float);
CODE:
	func   = INT2PTR(char *(*)(void *, void *, float), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, f2);
OUTPUT:
	RETVAL

int
nci_ippf( c_func, p0, p1, f2 )
	SV* c_func
	void * p0
	void * p1
	float f2
PREINIT:
	int(*func)(void *, void *, float);
CODE:
	func   = INT2PTR(int(*)(void *, void *, float), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, f2);
OUTPUT:
	RETVAL

void *
nci_pvpf( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvpf( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvpf( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svpf( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvpf( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvpf( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivpf( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdpf( c_func, d0, p1, f2 )
	SV* c_func
	double d0
	void * p1
	float f2
PREINIT:
	void *(*func)(double, void *, float);
CODE:
	func   = INT2PTR(void *(*)(double, void *, float), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, f2);
OUTPUT:
	RETVAL

void
nci_vdpf( c_func, d0, p1, f2 )
	SV* c_func
	double d0
	void * p1
	float f2
PREINIT:
	void(*func)(double, void *, float);
CODE:
	func   = INT2PTR(void(*)(double, void *, float), SvIV(c_func) );
	(*func)(d0, p1, f2);

double
nci_ddpf( c_func, d0, p1, f2 )
	SV* c_func
	double d0
	void * p1
	float f2
PREINIT:
	double(*func)(double, void *, float);
CODE:
	func   = INT2PTR(double(*)(double, void *, float), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, f2);
OUTPUT:
	RETVAL

short
nci_sdpf( c_func, d0, p1, f2 )
	SV* c_func
	double d0
	void * p1
	float f2
PREINIT:
	short(*func)(double, void *, float);
CODE:
	func   = INT2PTR(short(*)(double, void *, float), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, f2);
OUTPUT:
	RETVAL

float
nci_fdpf( c_func, d0, p1, f2 )
	SV* c_func
	double d0
	void * p1
	float f2
PREINIT:
	float(*func)(double, void *, float);
CODE:
	func   = INT2PTR(float(*)(double, void *, float), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, f2);
OUTPUT:
	RETVAL

char *
nci_tdpf( c_func, d0, p1, f2 )
	SV* c_func
	double d0
	void * p1
	float f2
PREINIT:
	char *(*func)(double, void *, float);
CODE:
	func   = INT2PTR(char *(*)(double, void *, float), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, f2);
OUTPUT:
	RETVAL

int
nci_idpf( c_func, d0, p1, f2 )
	SV* c_func
	double d0
	void * p1
	float f2
PREINIT:
	int(*func)(double, void *, float);
CODE:
	func   = INT2PTR(int(*)(double, void *, float), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, f2);
OUTPUT:
	RETVAL

void *
nci_pspf( c_func, s0, p1, f2 )
	SV* c_func
	short s0
	void * p1
	float f2
PREINIT:
	void *(*func)(short, void *, float);
CODE:
	func   = INT2PTR(void *(*)(short, void *, float), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, f2);
OUTPUT:
	RETVAL

void
nci_vspf( c_func, s0, p1, f2 )
	SV* c_func
	short s0
	void * p1
	float f2
PREINIT:
	void(*func)(short, void *, float);
CODE:
	func   = INT2PTR(void(*)(short, void *, float), SvIV(c_func) );
	(*func)(s0, p1, f2);

double
nci_dspf( c_func, s0, p1, f2 )
	SV* c_func
	short s0
	void * p1
	float f2
PREINIT:
	double(*func)(short, void *, float);
CODE:
	func   = INT2PTR(double(*)(short, void *, float), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, f2);
OUTPUT:
	RETVAL

short
nci_sspf( c_func, s0, p1, f2 )
	SV* c_func
	short s0
	void * p1
	float f2
PREINIT:
	short(*func)(short, void *, float);
CODE:
	func   = INT2PTR(short(*)(short, void *, float), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, f2);
OUTPUT:
	RETVAL

float
nci_fspf( c_func, s0, p1, f2 )
	SV* c_func
	short s0
	void * p1
	float f2
PREINIT:
	float(*func)(short, void *, float);
CODE:
	func   = INT2PTR(float(*)(short, void *, float), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, f2);
OUTPUT:
	RETVAL

char *
nci_tspf( c_func, s0, p1, f2 )
	SV* c_func
	short s0
	void * p1
	float f2
PREINIT:
	char *(*func)(short, void *, float);
CODE:
	func   = INT2PTR(char *(*)(short, void *, float), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, f2);
OUTPUT:
	RETVAL

int
nci_ispf( c_func, s0, p1, f2 )
	SV* c_func
	short s0
	void * p1
	float f2
PREINIT:
	int(*func)(short, void *, float);
CODE:
	func   = INT2PTR(int(*)(short, void *, float), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, f2);
OUTPUT:
	RETVAL

void *
nci_pfpf( c_func, f0, p1, f2 )
	SV* c_func
	float f0
	void * p1
	float f2
PREINIT:
	void *(*func)(float, void *, float);
CODE:
	func   = INT2PTR(void *(*)(float, void *, float), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, f2);
OUTPUT:
	RETVAL

void
nci_vfpf( c_func, f0, p1, f2 )
	SV* c_func
	float f0
	void * p1
	float f2
PREINIT:
	void(*func)(float, void *, float);
CODE:
	func   = INT2PTR(void(*)(float, void *, float), SvIV(c_func) );
	(*func)(f0, p1, f2);

double
nci_dfpf( c_func, f0, p1, f2 )
	SV* c_func
	float f0
	void * p1
	float f2
PREINIT:
	double(*func)(float, void *, float);
CODE:
	func   = INT2PTR(double(*)(float, void *, float), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, f2);
OUTPUT:
	RETVAL

short
nci_sfpf( c_func, f0, p1, f2 )
	SV* c_func
	float f0
	void * p1
	float f2
PREINIT:
	short(*func)(float, void *, float);
CODE:
	func   = INT2PTR(short(*)(float, void *, float), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, f2);
OUTPUT:
	RETVAL

float
nci_ffpf( c_func, f0, p1, f2 )
	SV* c_func
	float f0
	void * p1
	float f2
PREINIT:
	float(*func)(float, void *, float);
CODE:
	func   = INT2PTR(float(*)(float, void *, float), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, f2);
OUTPUT:
	RETVAL

char *
nci_tfpf( c_func, f0, p1, f2 )
	SV* c_func
	float f0
	void * p1
	float f2
PREINIT:
	char *(*func)(float, void *, float);
CODE:
	func   = INT2PTR(char *(*)(float, void *, float), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, f2);
OUTPUT:
	RETVAL

int
nci_ifpf( c_func, f0, p1, f2 )
	SV* c_func
	float f0
	void * p1
	float f2
PREINIT:
	int(*func)(float, void *, float);
CODE:
	func   = INT2PTR(int(*)(float, void *, float), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, f2);
OUTPUT:
	RETVAL

void *
nci_ptpf( c_func, t0, p1, f2 )
	SV* c_func
	char * t0
	void * p1
	float f2
PREINIT:
	void *(*func)(char *, void *, float);
CODE:
	func   = INT2PTR(void *(*)(char *, void *, float), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, f2);
OUTPUT:
	RETVAL

void
nci_vtpf( c_func, t0, p1, f2 )
	SV* c_func
	char * t0
	void * p1
	float f2
PREINIT:
	void(*func)(char *, void *, float);
CODE:
	func   = INT2PTR(void(*)(char *, void *, float), SvIV(c_func) );
	(*func)(t0, p1, f2);

double
nci_dtpf( c_func, t0, p1, f2 )
	SV* c_func
	char * t0
	void * p1
	float f2
PREINIT:
	double(*func)(char *, void *, float);
CODE:
	func   = INT2PTR(double(*)(char *, void *, float), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, f2);
OUTPUT:
	RETVAL

short
nci_stpf( c_func, t0, p1, f2 )
	SV* c_func
	char * t0
	void * p1
	float f2
PREINIT:
	short(*func)(char *, void *, float);
CODE:
	func   = INT2PTR(short(*)(char *, void *, float), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, f2);
OUTPUT:
	RETVAL

float
nci_ftpf( c_func, t0, p1, f2 )
	SV* c_func
	char * t0
	void * p1
	float f2
PREINIT:
	float(*func)(char *, void *, float);
CODE:
	func   = INT2PTR(float(*)(char *, void *, float), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, f2);
OUTPUT:
	RETVAL

char *
nci_ttpf( c_func, t0, p1, f2 )
	SV* c_func
	char * t0
	void * p1
	float f2
PREINIT:
	char *(*func)(char *, void *, float);
CODE:
	func   = INT2PTR(char *(*)(char *, void *, float), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, f2);
OUTPUT:
	RETVAL

int
nci_itpf( c_func, t0, p1, f2 )
	SV* c_func
	char * t0
	void * p1
	float f2
PREINIT:
	int(*func)(char *, void *, float);
CODE:
	func   = INT2PTR(int(*)(char *, void *, float), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, f2);
OUTPUT:
	RETVAL

void *
nci_pipf( c_func, i0, p1, f2 )
	SV* c_func
	int i0
	void * p1
	float f2
PREINIT:
	void *(*func)(int, void *, float);
CODE:
	func   = INT2PTR(void *(*)(int, void *, float), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, f2);
OUTPUT:
	RETVAL

void
nci_vipf( c_func, i0, p1, f2 )
	SV* c_func
	int i0
	void * p1
	float f2
PREINIT:
	void(*func)(int, void *, float);
CODE:
	func   = INT2PTR(void(*)(int, void *, float), SvIV(c_func) );
	(*func)(i0, p1, f2);

double
nci_dipf( c_func, i0, p1, f2 )
	SV* c_func
	int i0
	void * p1
	float f2
PREINIT:
	double(*func)(int, void *, float);
CODE:
	func   = INT2PTR(double(*)(int, void *, float), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, f2);
OUTPUT:
	RETVAL

short
nci_sipf( c_func, i0, p1, f2 )
	SV* c_func
	int i0
	void * p1
	float f2
PREINIT:
	short(*func)(int, void *, float);
CODE:
	func   = INT2PTR(short(*)(int, void *, float), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, f2);
OUTPUT:
	RETVAL

float
nci_fipf( c_func, i0, p1, f2 )
	SV* c_func
	int i0
	void * p1
	float f2
PREINIT:
	float(*func)(int, void *, float);
CODE:
	func   = INT2PTR(float(*)(int, void *, float), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, f2);
OUTPUT:
	RETVAL

char *
nci_tipf( c_func, i0, p1, f2 )
	SV* c_func
	int i0
	void * p1
	float f2
PREINIT:
	char *(*func)(int, void *, float);
CODE:
	func   = INT2PTR(char *(*)(int, void *, float), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, f2);
OUTPUT:
	RETVAL

int
nci_iipf( c_func, i0, p1, f2 )
	SV* c_func
	int i0
	void * p1
	float f2
PREINIT:
	int(*func)(int, void *, float);
CODE:
	func   = INT2PTR(int(*)(int, void *, float), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, f2);
OUTPUT:
	RETVAL

void *
nci_ppdf( c_func, p0, d1, f2 )
	SV* c_func
	void * p0
	double d1
	float f2
PREINIT:
	void *(*func)(void *, double, float);
CODE:
	func   = INT2PTR(void *(*)(void *, double, float), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, f2);
OUTPUT:
	RETVAL

void
nci_vpdf( c_func, p0, d1, f2 )
	SV* c_func
	void * p0
	double d1
	float f2
PREINIT:
	void(*func)(void *, double, float);
CODE:
	func   = INT2PTR(void(*)(void *, double, float), SvIV(c_func) );
	(*func)(p0, d1, f2);

double
nci_dpdf( c_func, p0, d1, f2 )
	SV* c_func
	void * p0
	double d1
	float f2
PREINIT:
	double(*func)(void *, double, float);
CODE:
	func   = INT2PTR(double(*)(void *, double, float), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, f2);
OUTPUT:
	RETVAL

short
nci_spdf( c_func, p0, d1, f2 )
	SV* c_func
	void * p0
	double d1
	float f2
PREINIT:
	short(*func)(void *, double, float);
CODE:
	func   = INT2PTR(short(*)(void *, double, float), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, f2);
OUTPUT:
	RETVAL

float
nci_fpdf( c_func, p0, d1, f2 )
	SV* c_func
	void * p0
	double d1
	float f2
PREINIT:
	float(*func)(void *, double, float);
CODE:
	func   = INT2PTR(float(*)(void *, double, float), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, f2);
OUTPUT:
	RETVAL

char *
nci_tpdf( c_func, p0, d1, f2 )
	SV* c_func
	void * p0
	double d1
	float f2
PREINIT:
	char *(*func)(void *, double, float);
CODE:
	func   = INT2PTR(char *(*)(void *, double, float), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, f2);
OUTPUT:
	RETVAL

int
nci_ipdf( c_func, p0, d1, f2 )
	SV* c_func
	void * p0
	double d1
	float f2
PREINIT:
	int(*func)(void *, double, float);
CODE:
	func   = INT2PTR(int(*)(void *, double, float), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, f2);
OUTPUT:
	RETVAL

void *
nci_pvdf( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvdf( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvdf( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svdf( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvdf( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvdf( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivdf( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pddf( c_func, d0, d1, f2 )
	SV* c_func
	double d0
	double d1
	float f2
PREINIT:
	void *(*func)(double, double, float);
CODE:
	func   = INT2PTR(void *(*)(double, double, float), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, f2);
OUTPUT:
	RETVAL

void
nci_vddf( c_func, d0, d1, f2 )
	SV* c_func
	double d0
	double d1
	float f2
PREINIT:
	void(*func)(double, double, float);
CODE:
	func   = INT2PTR(void(*)(double, double, float), SvIV(c_func) );
	(*func)(d0, d1, f2);

double
nci_dddf( c_func, d0, d1, f2 )
	SV* c_func
	double d0
	double d1
	float f2
PREINIT:
	double(*func)(double, double, float);
CODE:
	func   = INT2PTR(double(*)(double, double, float), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, f2);
OUTPUT:
	RETVAL

short
nci_sddf( c_func, d0, d1, f2 )
	SV* c_func
	double d0
	double d1
	float f2
PREINIT:
	short(*func)(double, double, float);
CODE:
	func   = INT2PTR(short(*)(double, double, float), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, f2);
OUTPUT:
	RETVAL

float
nci_fddf( c_func, d0, d1, f2 )
	SV* c_func
	double d0
	double d1
	float f2
PREINIT:
	float(*func)(double, double, float);
CODE:
	func   = INT2PTR(float(*)(double, double, float), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, f2);
OUTPUT:
	RETVAL

char *
nci_tddf( c_func, d0, d1, f2 )
	SV* c_func
	double d0
	double d1
	float f2
PREINIT:
	char *(*func)(double, double, float);
CODE:
	func   = INT2PTR(char *(*)(double, double, float), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, f2);
OUTPUT:
	RETVAL

int
nci_iddf( c_func, d0, d1, f2 )
	SV* c_func
	double d0
	double d1
	float f2
PREINIT:
	int(*func)(double, double, float);
CODE:
	func   = INT2PTR(int(*)(double, double, float), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, f2);
OUTPUT:
	RETVAL

void *
nci_psdf( c_func, s0, d1, f2 )
	SV* c_func
	short s0
	double d1
	float f2
PREINIT:
	void *(*func)(short, double, float);
CODE:
	func   = INT2PTR(void *(*)(short, double, float), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, f2);
OUTPUT:
	RETVAL

void
nci_vsdf( c_func, s0, d1, f2 )
	SV* c_func
	short s0
	double d1
	float f2
PREINIT:
	void(*func)(short, double, float);
CODE:
	func   = INT2PTR(void(*)(short, double, float), SvIV(c_func) );
	(*func)(s0, d1, f2);

double
nci_dsdf( c_func, s0, d1, f2 )
	SV* c_func
	short s0
	double d1
	float f2
PREINIT:
	double(*func)(short, double, float);
CODE:
	func   = INT2PTR(double(*)(short, double, float), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, f2);
OUTPUT:
	RETVAL

short
nci_ssdf( c_func, s0, d1, f2 )
	SV* c_func
	short s0
	double d1
	float f2
PREINIT:
	short(*func)(short, double, float);
CODE:
	func   = INT2PTR(short(*)(short, double, float), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, f2);
OUTPUT:
	RETVAL

float
nci_fsdf( c_func, s0, d1, f2 )
	SV* c_func
	short s0
	double d1
	float f2
PREINIT:
	float(*func)(short, double, float);
CODE:
	func   = INT2PTR(float(*)(short, double, float), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, f2);
OUTPUT:
	RETVAL

char *
nci_tsdf( c_func, s0, d1, f2 )
	SV* c_func
	short s0
	double d1
	float f2
PREINIT:
	char *(*func)(short, double, float);
CODE:
	func   = INT2PTR(char *(*)(short, double, float), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, f2);
OUTPUT:
	RETVAL

int
nci_isdf( c_func, s0, d1, f2 )
	SV* c_func
	short s0
	double d1
	float f2
PREINIT:
	int(*func)(short, double, float);
CODE:
	func   = INT2PTR(int(*)(short, double, float), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, f2);
OUTPUT:
	RETVAL

void *
nci_pfdf( c_func, f0, d1, f2 )
	SV* c_func
	float f0
	double d1
	float f2
PREINIT:
	void *(*func)(float, double, float);
CODE:
	func   = INT2PTR(void *(*)(float, double, float), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, f2);
OUTPUT:
	RETVAL

void
nci_vfdf( c_func, f0, d1, f2 )
	SV* c_func
	float f0
	double d1
	float f2
PREINIT:
	void(*func)(float, double, float);
CODE:
	func   = INT2PTR(void(*)(float, double, float), SvIV(c_func) );
	(*func)(f0, d1, f2);

double
nci_dfdf( c_func, f0, d1, f2 )
	SV* c_func
	float f0
	double d1
	float f2
PREINIT:
	double(*func)(float, double, float);
CODE:
	func   = INT2PTR(double(*)(float, double, float), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, f2);
OUTPUT:
	RETVAL

short
nci_sfdf( c_func, f0, d1, f2 )
	SV* c_func
	float f0
	double d1
	float f2
PREINIT:
	short(*func)(float, double, float);
CODE:
	func   = INT2PTR(short(*)(float, double, float), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, f2);
OUTPUT:
	RETVAL

float
nci_ffdf( c_func, f0, d1, f2 )
	SV* c_func
	float f0
	double d1
	float f2
PREINIT:
	float(*func)(float, double, float);
CODE:
	func   = INT2PTR(float(*)(float, double, float), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, f2);
OUTPUT:
	RETVAL

char *
nci_tfdf( c_func, f0, d1, f2 )
	SV* c_func
	float f0
	double d1
	float f2
PREINIT:
	char *(*func)(float, double, float);
CODE:
	func   = INT2PTR(char *(*)(float, double, float), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, f2);
OUTPUT:
	RETVAL

int
nci_ifdf( c_func, f0, d1, f2 )
	SV* c_func
	float f0
	double d1
	float f2
PREINIT:
	int(*func)(float, double, float);
CODE:
	func   = INT2PTR(int(*)(float, double, float), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, f2);
OUTPUT:
	RETVAL

void *
nci_ptdf( c_func, t0, d1, f2 )
	SV* c_func
	char * t0
	double d1
	float f2
PREINIT:
	void *(*func)(char *, double, float);
CODE:
	func   = INT2PTR(void *(*)(char *, double, float), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, f2);
OUTPUT:
	RETVAL

void
nci_vtdf( c_func, t0, d1, f2 )
	SV* c_func
	char * t0
	double d1
	float f2
PREINIT:
	void(*func)(char *, double, float);
CODE:
	func   = INT2PTR(void(*)(char *, double, float), SvIV(c_func) );
	(*func)(t0, d1, f2);

double
nci_dtdf( c_func, t0, d1, f2 )
	SV* c_func
	char * t0
	double d1
	float f2
PREINIT:
	double(*func)(char *, double, float);
CODE:
	func   = INT2PTR(double(*)(char *, double, float), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, f2);
OUTPUT:
	RETVAL

short
nci_stdf( c_func, t0, d1, f2 )
	SV* c_func
	char * t0
	double d1
	float f2
PREINIT:
	short(*func)(char *, double, float);
CODE:
	func   = INT2PTR(short(*)(char *, double, float), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, f2);
OUTPUT:
	RETVAL

float
nci_ftdf( c_func, t0, d1, f2 )
	SV* c_func
	char * t0
	double d1
	float f2
PREINIT:
	float(*func)(char *, double, float);
CODE:
	func   = INT2PTR(float(*)(char *, double, float), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, f2);
OUTPUT:
	RETVAL

char *
nci_ttdf( c_func, t0, d1, f2 )
	SV* c_func
	char * t0
	double d1
	float f2
PREINIT:
	char *(*func)(char *, double, float);
CODE:
	func   = INT2PTR(char *(*)(char *, double, float), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, f2);
OUTPUT:
	RETVAL

int
nci_itdf( c_func, t0, d1, f2 )
	SV* c_func
	char * t0
	double d1
	float f2
PREINIT:
	int(*func)(char *, double, float);
CODE:
	func   = INT2PTR(int(*)(char *, double, float), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, f2);
OUTPUT:
	RETVAL

void *
nci_pidf( c_func, i0, d1, f2 )
	SV* c_func
	int i0
	double d1
	float f2
PREINIT:
	void *(*func)(int, double, float);
CODE:
	func   = INT2PTR(void *(*)(int, double, float), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, f2);
OUTPUT:
	RETVAL

void
nci_vidf( c_func, i0, d1, f2 )
	SV* c_func
	int i0
	double d1
	float f2
PREINIT:
	void(*func)(int, double, float);
CODE:
	func   = INT2PTR(void(*)(int, double, float), SvIV(c_func) );
	(*func)(i0, d1, f2);

double
nci_didf( c_func, i0, d1, f2 )
	SV* c_func
	int i0
	double d1
	float f2
PREINIT:
	double(*func)(int, double, float);
CODE:
	func   = INT2PTR(double(*)(int, double, float), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, f2);
OUTPUT:
	RETVAL

short
nci_sidf( c_func, i0, d1, f2 )
	SV* c_func
	int i0
	double d1
	float f2
PREINIT:
	short(*func)(int, double, float);
CODE:
	func   = INT2PTR(short(*)(int, double, float), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, f2);
OUTPUT:
	RETVAL

float
nci_fidf( c_func, i0, d1, f2 )
	SV* c_func
	int i0
	double d1
	float f2
PREINIT:
	float(*func)(int, double, float);
CODE:
	func   = INT2PTR(float(*)(int, double, float), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, f2);
OUTPUT:
	RETVAL

char *
nci_tidf( c_func, i0, d1, f2 )
	SV* c_func
	int i0
	double d1
	float f2
PREINIT:
	char *(*func)(int, double, float);
CODE:
	func   = INT2PTR(char *(*)(int, double, float), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, f2);
OUTPUT:
	RETVAL

int
nci_iidf( c_func, i0, d1, f2 )
	SV* c_func
	int i0
	double d1
	float f2
PREINIT:
	int(*func)(int, double, float);
CODE:
	func   = INT2PTR(int(*)(int, double, float), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, f2);
OUTPUT:
	RETVAL

void *
nci_ppsf( c_func, p0, s1, f2 )
	SV* c_func
	void * p0
	short s1
	float f2
PREINIT:
	void *(*func)(void *, short, float);
CODE:
	func   = INT2PTR(void *(*)(void *, short, float), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, f2);
OUTPUT:
	RETVAL

void
nci_vpsf( c_func, p0, s1, f2 )
	SV* c_func
	void * p0
	short s1
	float f2
PREINIT:
	void(*func)(void *, short, float);
CODE:
	func   = INT2PTR(void(*)(void *, short, float), SvIV(c_func) );
	(*func)(p0, s1, f2);

double
nci_dpsf( c_func, p0, s1, f2 )
	SV* c_func
	void * p0
	short s1
	float f2
PREINIT:
	double(*func)(void *, short, float);
CODE:
	func   = INT2PTR(double(*)(void *, short, float), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, f2);
OUTPUT:
	RETVAL

short
nci_spsf( c_func, p0, s1, f2 )
	SV* c_func
	void * p0
	short s1
	float f2
PREINIT:
	short(*func)(void *, short, float);
CODE:
	func   = INT2PTR(short(*)(void *, short, float), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, f2);
OUTPUT:
	RETVAL

float
nci_fpsf( c_func, p0, s1, f2 )
	SV* c_func
	void * p0
	short s1
	float f2
PREINIT:
	float(*func)(void *, short, float);
CODE:
	func   = INT2PTR(float(*)(void *, short, float), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, f2);
OUTPUT:
	RETVAL

char *
nci_tpsf( c_func, p0, s1, f2 )
	SV* c_func
	void * p0
	short s1
	float f2
PREINIT:
	char *(*func)(void *, short, float);
CODE:
	func   = INT2PTR(char *(*)(void *, short, float), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, f2);
OUTPUT:
	RETVAL

int
nci_ipsf( c_func, p0, s1, f2 )
	SV* c_func
	void * p0
	short s1
	float f2
PREINIT:
	int(*func)(void *, short, float);
CODE:
	func   = INT2PTR(int(*)(void *, short, float), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, f2);
OUTPUT:
	RETVAL

void *
nci_pvsf( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvsf( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvsf( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svsf( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvsf( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvsf( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivsf( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdsf( c_func, d0, s1, f2 )
	SV* c_func
	double d0
	short s1
	float f2
PREINIT:
	void *(*func)(double, short, float);
CODE:
	func   = INT2PTR(void *(*)(double, short, float), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, f2);
OUTPUT:
	RETVAL

void
nci_vdsf( c_func, d0, s1, f2 )
	SV* c_func
	double d0
	short s1
	float f2
PREINIT:
	void(*func)(double, short, float);
CODE:
	func   = INT2PTR(void(*)(double, short, float), SvIV(c_func) );
	(*func)(d0, s1, f2);

double
nci_ddsf( c_func, d0, s1, f2 )
	SV* c_func
	double d0
	short s1
	float f2
PREINIT:
	double(*func)(double, short, float);
CODE:
	func   = INT2PTR(double(*)(double, short, float), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, f2);
OUTPUT:
	RETVAL

short
nci_sdsf( c_func, d0, s1, f2 )
	SV* c_func
	double d0
	short s1
	float f2
PREINIT:
	short(*func)(double, short, float);
CODE:
	func   = INT2PTR(short(*)(double, short, float), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, f2);
OUTPUT:
	RETVAL

float
nci_fdsf( c_func, d0, s1, f2 )
	SV* c_func
	double d0
	short s1
	float f2
PREINIT:
	float(*func)(double, short, float);
CODE:
	func   = INT2PTR(float(*)(double, short, float), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, f2);
OUTPUT:
	RETVAL

char *
nci_tdsf( c_func, d0, s1, f2 )
	SV* c_func
	double d0
	short s1
	float f2
PREINIT:
	char *(*func)(double, short, float);
CODE:
	func   = INT2PTR(char *(*)(double, short, float), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, f2);
OUTPUT:
	RETVAL

int
nci_idsf( c_func, d0, s1, f2 )
	SV* c_func
	double d0
	short s1
	float f2
PREINIT:
	int(*func)(double, short, float);
CODE:
	func   = INT2PTR(int(*)(double, short, float), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, f2);
OUTPUT:
	RETVAL

void *
nci_pssf( c_func, s0, s1, f2 )
	SV* c_func
	short s0
	short s1
	float f2
PREINIT:
	void *(*func)(short, short, float);
CODE:
	func   = INT2PTR(void *(*)(short, short, float), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, f2);
OUTPUT:
	RETVAL

void
nci_vssf( c_func, s0, s1, f2 )
	SV* c_func
	short s0
	short s1
	float f2
PREINIT:
	void(*func)(short, short, float);
CODE:
	func   = INT2PTR(void(*)(short, short, float), SvIV(c_func) );
	(*func)(s0, s1, f2);

double
nci_dssf( c_func, s0, s1, f2 )
	SV* c_func
	short s0
	short s1
	float f2
PREINIT:
	double(*func)(short, short, float);
CODE:
	func   = INT2PTR(double(*)(short, short, float), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, f2);
OUTPUT:
	RETVAL

short
nci_sssf( c_func, s0, s1, f2 )
	SV* c_func
	short s0
	short s1
	float f2
PREINIT:
	short(*func)(short, short, float);
CODE:
	func   = INT2PTR(short(*)(short, short, float), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, f2);
OUTPUT:
	RETVAL

float
nci_fssf( c_func, s0, s1, f2 )
	SV* c_func
	short s0
	short s1
	float f2
PREINIT:
	float(*func)(short, short, float);
CODE:
	func   = INT2PTR(float(*)(short, short, float), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, f2);
OUTPUT:
	RETVAL

char *
nci_tssf( c_func, s0, s1, f2 )
	SV* c_func
	short s0
	short s1
	float f2
PREINIT:
	char *(*func)(short, short, float);
CODE:
	func   = INT2PTR(char *(*)(short, short, float), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, f2);
OUTPUT:
	RETVAL

int
nci_issf( c_func, s0, s1, f2 )
	SV* c_func
	short s0
	short s1
	float f2
PREINIT:
	int(*func)(short, short, float);
CODE:
	func   = INT2PTR(int(*)(short, short, float), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, f2);
OUTPUT:
	RETVAL

void *
nci_pfsf( c_func, f0, s1, f2 )
	SV* c_func
	float f0
	short s1
	float f2
PREINIT:
	void *(*func)(float, short, float);
CODE:
	func   = INT2PTR(void *(*)(float, short, float), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, f2);
OUTPUT:
	RETVAL

void
nci_vfsf( c_func, f0, s1, f2 )
	SV* c_func
	float f0
	short s1
	float f2
PREINIT:
	void(*func)(float, short, float);
CODE:
	func   = INT2PTR(void(*)(float, short, float), SvIV(c_func) );
	(*func)(f0, s1, f2);

double
nci_dfsf( c_func, f0, s1, f2 )
	SV* c_func
	float f0
	short s1
	float f2
PREINIT:
	double(*func)(float, short, float);
CODE:
	func   = INT2PTR(double(*)(float, short, float), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, f2);
OUTPUT:
	RETVAL

short
nci_sfsf( c_func, f0, s1, f2 )
	SV* c_func
	float f0
	short s1
	float f2
PREINIT:
	short(*func)(float, short, float);
CODE:
	func   = INT2PTR(short(*)(float, short, float), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, f2);
OUTPUT:
	RETVAL

float
nci_ffsf( c_func, f0, s1, f2 )
	SV* c_func
	float f0
	short s1
	float f2
PREINIT:
	float(*func)(float, short, float);
CODE:
	func   = INT2PTR(float(*)(float, short, float), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, f2);
OUTPUT:
	RETVAL

char *
nci_tfsf( c_func, f0, s1, f2 )
	SV* c_func
	float f0
	short s1
	float f2
PREINIT:
	char *(*func)(float, short, float);
CODE:
	func   = INT2PTR(char *(*)(float, short, float), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, f2);
OUTPUT:
	RETVAL

int
nci_ifsf( c_func, f0, s1, f2 )
	SV* c_func
	float f0
	short s1
	float f2
PREINIT:
	int(*func)(float, short, float);
CODE:
	func   = INT2PTR(int(*)(float, short, float), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, f2);
OUTPUT:
	RETVAL

void *
nci_ptsf( c_func, t0, s1, f2 )
	SV* c_func
	char * t0
	short s1
	float f2
PREINIT:
	void *(*func)(char *, short, float);
CODE:
	func   = INT2PTR(void *(*)(char *, short, float), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, f2);
OUTPUT:
	RETVAL

void
nci_vtsf( c_func, t0, s1, f2 )
	SV* c_func
	char * t0
	short s1
	float f2
PREINIT:
	void(*func)(char *, short, float);
CODE:
	func   = INT2PTR(void(*)(char *, short, float), SvIV(c_func) );
	(*func)(t0, s1, f2);

double
nci_dtsf( c_func, t0, s1, f2 )
	SV* c_func
	char * t0
	short s1
	float f2
PREINIT:
	double(*func)(char *, short, float);
CODE:
	func   = INT2PTR(double(*)(char *, short, float), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, f2);
OUTPUT:
	RETVAL

short
nci_stsf( c_func, t0, s1, f2 )
	SV* c_func
	char * t0
	short s1
	float f2
PREINIT:
	short(*func)(char *, short, float);
CODE:
	func   = INT2PTR(short(*)(char *, short, float), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, f2);
OUTPUT:
	RETVAL

float
nci_ftsf( c_func, t0, s1, f2 )
	SV* c_func
	char * t0
	short s1
	float f2
PREINIT:
	float(*func)(char *, short, float);
CODE:
	func   = INT2PTR(float(*)(char *, short, float), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, f2);
OUTPUT:
	RETVAL

char *
nci_ttsf( c_func, t0, s1, f2 )
	SV* c_func
	char * t0
	short s1
	float f2
PREINIT:
	char *(*func)(char *, short, float);
CODE:
	func   = INT2PTR(char *(*)(char *, short, float), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, f2);
OUTPUT:
	RETVAL

int
nci_itsf( c_func, t0, s1, f2 )
	SV* c_func
	char * t0
	short s1
	float f2
PREINIT:
	int(*func)(char *, short, float);
CODE:
	func   = INT2PTR(int(*)(char *, short, float), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, f2);
OUTPUT:
	RETVAL

void *
nci_pisf( c_func, i0, s1, f2 )
	SV* c_func
	int i0
	short s1
	float f2
PREINIT:
	void *(*func)(int, short, float);
CODE:
	func   = INT2PTR(void *(*)(int, short, float), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, f2);
OUTPUT:
	RETVAL

void
nci_visf( c_func, i0, s1, f2 )
	SV* c_func
	int i0
	short s1
	float f2
PREINIT:
	void(*func)(int, short, float);
CODE:
	func   = INT2PTR(void(*)(int, short, float), SvIV(c_func) );
	(*func)(i0, s1, f2);

double
nci_disf( c_func, i0, s1, f2 )
	SV* c_func
	int i0
	short s1
	float f2
PREINIT:
	double(*func)(int, short, float);
CODE:
	func   = INT2PTR(double(*)(int, short, float), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, f2);
OUTPUT:
	RETVAL

short
nci_sisf( c_func, i0, s1, f2 )
	SV* c_func
	int i0
	short s1
	float f2
PREINIT:
	short(*func)(int, short, float);
CODE:
	func   = INT2PTR(short(*)(int, short, float), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, f2);
OUTPUT:
	RETVAL

float
nci_fisf( c_func, i0, s1, f2 )
	SV* c_func
	int i0
	short s1
	float f2
PREINIT:
	float(*func)(int, short, float);
CODE:
	func   = INT2PTR(float(*)(int, short, float), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, f2);
OUTPUT:
	RETVAL

char *
nci_tisf( c_func, i0, s1, f2 )
	SV* c_func
	int i0
	short s1
	float f2
PREINIT:
	char *(*func)(int, short, float);
CODE:
	func   = INT2PTR(char *(*)(int, short, float), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, f2);
OUTPUT:
	RETVAL

int
nci_iisf( c_func, i0, s1, f2 )
	SV* c_func
	int i0
	short s1
	float f2
PREINIT:
	int(*func)(int, short, float);
CODE:
	func   = INT2PTR(int(*)(int, short, float), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, f2);
OUTPUT:
	RETVAL

void *
nci_ppff( c_func, p0, f1, f2 )
	SV* c_func
	void * p0
	float f1
	float f2
PREINIT:
	void *(*func)(void *, float, float);
CODE:
	func   = INT2PTR(void *(*)(void *, float, float), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, f2);
OUTPUT:
	RETVAL

void
nci_vpff( c_func, p0, f1, f2 )
	SV* c_func
	void * p0
	float f1
	float f2
PREINIT:
	void(*func)(void *, float, float);
CODE:
	func   = INT2PTR(void(*)(void *, float, float), SvIV(c_func) );
	(*func)(p0, f1, f2);

double
nci_dpff( c_func, p0, f1, f2 )
	SV* c_func
	void * p0
	float f1
	float f2
PREINIT:
	double(*func)(void *, float, float);
CODE:
	func   = INT2PTR(double(*)(void *, float, float), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, f2);
OUTPUT:
	RETVAL

short
nci_spff( c_func, p0, f1, f2 )
	SV* c_func
	void * p0
	float f1
	float f2
PREINIT:
	short(*func)(void *, float, float);
CODE:
	func   = INT2PTR(short(*)(void *, float, float), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, f2);
OUTPUT:
	RETVAL

float
nci_fpff( c_func, p0, f1, f2 )
	SV* c_func
	void * p0
	float f1
	float f2
PREINIT:
	float(*func)(void *, float, float);
CODE:
	func   = INT2PTR(float(*)(void *, float, float), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, f2);
OUTPUT:
	RETVAL

char *
nci_tpff( c_func, p0, f1, f2 )
	SV* c_func
	void * p0
	float f1
	float f2
PREINIT:
	char *(*func)(void *, float, float);
CODE:
	func   = INT2PTR(char *(*)(void *, float, float), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, f2);
OUTPUT:
	RETVAL

int
nci_ipff( c_func, p0, f1, f2 )
	SV* c_func
	void * p0
	float f1
	float f2
PREINIT:
	int(*func)(void *, float, float);
CODE:
	func   = INT2PTR(int(*)(void *, float, float), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, f2);
OUTPUT:
	RETVAL

void *
nci_pvff( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvff( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvff( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svff( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvff( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvff( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivff( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdff( c_func, d0, f1, f2 )
	SV* c_func
	double d0
	float f1
	float f2
PREINIT:
	void *(*func)(double, float, float);
CODE:
	func   = INT2PTR(void *(*)(double, float, float), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, f2);
OUTPUT:
	RETVAL

void
nci_vdff( c_func, d0, f1, f2 )
	SV* c_func
	double d0
	float f1
	float f2
PREINIT:
	void(*func)(double, float, float);
CODE:
	func   = INT2PTR(void(*)(double, float, float), SvIV(c_func) );
	(*func)(d0, f1, f2);

double
nci_ddff( c_func, d0, f1, f2 )
	SV* c_func
	double d0
	float f1
	float f2
PREINIT:
	double(*func)(double, float, float);
CODE:
	func   = INT2PTR(double(*)(double, float, float), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, f2);
OUTPUT:
	RETVAL

short
nci_sdff( c_func, d0, f1, f2 )
	SV* c_func
	double d0
	float f1
	float f2
PREINIT:
	short(*func)(double, float, float);
CODE:
	func   = INT2PTR(short(*)(double, float, float), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, f2);
OUTPUT:
	RETVAL

float
nci_fdff( c_func, d0, f1, f2 )
	SV* c_func
	double d0
	float f1
	float f2
PREINIT:
	float(*func)(double, float, float);
CODE:
	func   = INT2PTR(float(*)(double, float, float), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, f2);
OUTPUT:
	RETVAL

char *
nci_tdff( c_func, d0, f1, f2 )
	SV* c_func
	double d0
	float f1
	float f2
PREINIT:
	char *(*func)(double, float, float);
CODE:
	func   = INT2PTR(char *(*)(double, float, float), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, f2);
OUTPUT:
	RETVAL

int
nci_idff( c_func, d0, f1, f2 )
	SV* c_func
	double d0
	float f1
	float f2
PREINIT:
	int(*func)(double, float, float);
CODE:
	func   = INT2PTR(int(*)(double, float, float), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, f2);
OUTPUT:
	RETVAL

void *
nci_psff( c_func, s0, f1, f2 )
	SV* c_func
	short s0
	float f1
	float f2
PREINIT:
	void *(*func)(short, float, float);
CODE:
	func   = INT2PTR(void *(*)(short, float, float), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, f2);
OUTPUT:
	RETVAL

void
nci_vsff( c_func, s0, f1, f2 )
	SV* c_func
	short s0
	float f1
	float f2
PREINIT:
	void(*func)(short, float, float);
CODE:
	func   = INT2PTR(void(*)(short, float, float), SvIV(c_func) );
	(*func)(s0, f1, f2);

double
nci_dsff( c_func, s0, f1, f2 )
	SV* c_func
	short s0
	float f1
	float f2
PREINIT:
	double(*func)(short, float, float);
CODE:
	func   = INT2PTR(double(*)(short, float, float), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, f2);
OUTPUT:
	RETVAL

short
nci_ssff( c_func, s0, f1, f2 )
	SV* c_func
	short s0
	float f1
	float f2
PREINIT:
	short(*func)(short, float, float);
CODE:
	func   = INT2PTR(short(*)(short, float, float), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, f2);
OUTPUT:
	RETVAL

float
nci_fsff( c_func, s0, f1, f2 )
	SV* c_func
	short s0
	float f1
	float f2
PREINIT:
	float(*func)(short, float, float);
CODE:
	func   = INT2PTR(float(*)(short, float, float), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, f2);
OUTPUT:
	RETVAL

char *
nci_tsff( c_func, s0, f1, f2 )
	SV* c_func
	short s0
	float f1
	float f2
PREINIT:
	char *(*func)(short, float, float);
CODE:
	func   = INT2PTR(char *(*)(short, float, float), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, f2);
OUTPUT:
	RETVAL

int
nci_isff( c_func, s0, f1, f2 )
	SV* c_func
	short s0
	float f1
	float f2
PREINIT:
	int(*func)(short, float, float);
CODE:
	func   = INT2PTR(int(*)(short, float, float), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, f2);
OUTPUT:
	RETVAL

void *
nci_pfff( c_func, f0, f1, f2 )
	SV* c_func
	float f0
	float f1
	float f2
PREINIT:
	void *(*func)(float, float, float);
CODE:
	func   = INT2PTR(void *(*)(float, float, float), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, f2);
OUTPUT:
	RETVAL

void
nci_vfff( c_func, f0, f1, f2 )
	SV* c_func
	float f0
	float f1
	float f2
PREINIT:
	void(*func)(float, float, float);
CODE:
	func   = INT2PTR(void(*)(float, float, float), SvIV(c_func) );
	(*func)(f0, f1, f2);

double
nci_dfff( c_func, f0, f1, f2 )
	SV* c_func
	float f0
	float f1
	float f2
PREINIT:
	double(*func)(float, float, float);
CODE:
	func   = INT2PTR(double(*)(float, float, float), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, f2);
OUTPUT:
	RETVAL

short
nci_sfff( c_func, f0, f1, f2 )
	SV* c_func
	float f0
	float f1
	float f2
PREINIT:
	short(*func)(float, float, float);
CODE:
	func   = INT2PTR(short(*)(float, float, float), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, f2);
OUTPUT:
	RETVAL

float
nci_ffff( c_func, f0, f1, f2 )
	SV* c_func
	float f0
	float f1
	float f2
PREINIT:
	float(*func)(float, float, float);
CODE:
	func   = INT2PTR(float(*)(float, float, float), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, f2);
OUTPUT:
	RETVAL

char *
nci_tfff( c_func, f0, f1, f2 )
	SV* c_func
	float f0
	float f1
	float f2
PREINIT:
	char *(*func)(float, float, float);
CODE:
	func   = INT2PTR(char *(*)(float, float, float), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, f2);
OUTPUT:
	RETVAL

int
nci_ifff( c_func, f0, f1, f2 )
	SV* c_func
	float f0
	float f1
	float f2
PREINIT:
	int(*func)(float, float, float);
CODE:
	func   = INT2PTR(int(*)(float, float, float), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, f2);
OUTPUT:
	RETVAL

void *
nci_ptff( c_func, t0, f1, f2 )
	SV* c_func
	char * t0
	float f1
	float f2
PREINIT:
	void *(*func)(char *, float, float);
CODE:
	func   = INT2PTR(void *(*)(char *, float, float), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, f2);
OUTPUT:
	RETVAL

void
nci_vtff( c_func, t0, f1, f2 )
	SV* c_func
	char * t0
	float f1
	float f2
PREINIT:
	void(*func)(char *, float, float);
CODE:
	func   = INT2PTR(void(*)(char *, float, float), SvIV(c_func) );
	(*func)(t0, f1, f2);

double
nci_dtff( c_func, t0, f1, f2 )
	SV* c_func
	char * t0
	float f1
	float f2
PREINIT:
	double(*func)(char *, float, float);
CODE:
	func   = INT2PTR(double(*)(char *, float, float), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, f2);
OUTPUT:
	RETVAL

short
nci_stff( c_func, t0, f1, f2 )
	SV* c_func
	char * t0
	float f1
	float f2
PREINIT:
	short(*func)(char *, float, float);
CODE:
	func   = INT2PTR(short(*)(char *, float, float), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, f2);
OUTPUT:
	RETVAL

float
nci_ftff( c_func, t0, f1, f2 )
	SV* c_func
	char * t0
	float f1
	float f2
PREINIT:
	float(*func)(char *, float, float);
CODE:
	func   = INT2PTR(float(*)(char *, float, float), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, f2);
OUTPUT:
	RETVAL

char *
nci_ttff( c_func, t0, f1, f2 )
	SV* c_func
	char * t0
	float f1
	float f2
PREINIT:
	char *(*func)(char *, float, float);
CODE:
	func   = INT2PTR(char *(*)(char *, float, float), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, f2);
OUTPUT:
	RETVAL

int
nci_itff( c_func, t0, f1, f2 )
	SV* c_func
	char * t0
	float f1
	float f2
PREINIT:
	int(*func)(char *, float, float);
CODE:
	func   = INT2PTR(int(*)(char *, float, float), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, f2);
OUTPUT:
	RETVAL

void *
nci_piff( c_func, i0, f1, f2 )
	SV* c_func
	int i0
	float f1
	float f2
PREINIT:
	void *(*func)(int, float, float);
CODE:
	func   = INT2PTR(void *(*)(int, float, float), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, f2);
OUTPUT:
	RETVAL

void
nci_viff( c_func, i0, f1, f2 )
	SV* c_func
	int i0
	float f1
	float f2
PREINIT:
	void(*func)(int, float, float);
CODE:
	func   = INT2PTR(void(*)(int, float, float), SvIV(c_func) );
	(*func)(i0, f1, f2);

double
nci_diff( c_func, i0, f1, f2 )
	SV* c_func
	int i0
	float f1
	float f2
PREINIT:
	double(*func)(int, float, float);
CODE:
	func   = INT2PTR(double(*)(int, float, float), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, f2);
OUTPUT:
	RETVAL

short
nci_siff( c_func, i0, f1, f2 )
	SV* c_func
	int i0
	float f1
	float f2
PREINIT:
	short(*func)(int, float, float);
CODE:
	func   = INT2PTR(short(*)(int, float, float), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, f2);
OUTPUT:
	RETVAL

float
nci_fiff( c_func, i0, f1, f2 )
	SV* c_func
	int i0
	float f1
	float f2
PREINIT:
	float(*func)(int, float, float);
CODE:
	func   = INT2PTR(float(*)(int, float, float), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, f2);
OUTPUT:
	RETVAL

char *
nci_tiff( c_func, i0, f1, f2 )
	SV* c_func
	int i0
	float f1
	float f2
PREINIT:
	char *(*func)(int, float, float);
CODE:
	func   = INT2PTR(char *(*)(int, float, float), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, f2);
OUTPUT:
	RETVAL

int
nci_iiff( c_func, i0, f1, f2 )
	SV* c_func
	int i0
	float f1
	float f2
PREINIT:
	int(*func)(int, float, float);
CODE:
	func   = INT2PTR(int(*)(int, float, float), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, f2);
OUTPUT:
	RETVAL

void *
nci_pptf( c_func, p0, t1, f2 )
	SV* c_func
	void * p0
	char * t1
	float f2
PREINIT:
	void *(*func)(void *, char *, float);
CODE:
	func   = INT2PTR(void *(*)(void *, char *, float), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, f2);
OUTPUT:
	RETVAL

void
nci_vptf( c_func, p0, t1, f2 )
	SV* c_func
	void * p0
	char * t1
	float f2
PREINIT:
	void(*func)(void *, char *, float);
CODE:
	func   = INT2PTR(void(*)(void *, char *, float), SvIV(c_func) );
	(*func)(p0, t1, f2);

double
nci_dptf( c_func, p0, t1, f2 )
	SV* c_func
	void * p0
	char * t1
	float f2
PREINIT:
	double(*func)(void *, char *, float);
CODE:
	func   = INT2PTR(double(*)(void *, char *, float), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, f2);
OUTPUT:
	RETVAL

short
nci_sptf( c_func, p0, t1, f2 )
	SV* c_func
	void * p0
	char * t1
	float f2
PREINIT:
	short(*func)(void *, char *, float);
CODE:
	func   = INT2PTR(short(*)(void *, char *, float), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, f2);
OUTPUT:
	RETVAL

float
nci_fptf( c_func, p0, t1, f2 )
	SV* c_func
	void * p0
	char * t1
	float f2
PREINIT:
	float(*func)(void *, char *, float);
CODE:
	func   = INT2PTR(float(*)(void *, char *, float), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, f2);
OUTPUT:
	RETVAL

char *
nci_tptf( c_func, p0, t1, f2 )
	SV* c_func
	void * p0
	char * t1
	float f2
PREINIT:
	char *(*func)(void *, char *, float);
CODE:
	func   = INT2PTR(char *(*)(void *, char *, float), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, f2);
OUTPUT:
	RETVAL

int
nci_iptf( c_func, p0, t1, f2 )
	SV* c_func
	void * p0
	char * t1
	float f2
PREINIT:
	int(*func)(void *, char *, float);
CODE:
	func   = INT2PTR(int(*)(void *, char *, float), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, f2);
OUTPUT:
	RETVAL

void *
nci_pvtf( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvtf( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvtf( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svtf( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvtf( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvtf( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivtf( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdtf( c_func, d0, t1, f2 )
	SV* c_func
	double d0
	char * t1
	float f2
PREINIT:
	void *(*func)(double, char *, float);
CODE:
	func   = INT2PTR(void *(*)(double, char *, float), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, f2);
OUTPUT:
	RETVAL

void
nci_vdtf( c_func, d0, t1, f2 )
	SV* c_func
	double d0
	char * t1
	float f2
PREINIT:
	void(*func)(double, char *, float);
CODE:
	func   = INT2PTR(void(*)(double, char *, float), SvIV(c_func) );
	(*func)(d0, t1, f2);

double
nci_ddtf( c_func, d0, t1, f2 )
	SV* c_func
	double d0
	char * t1
	float f2
PREINIT:
	double(*func)(double, char *, float);
CODE:
	func   = INT2PTR(double(*)(double, char *, float), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, f2);
OUTPUT:
	RETVAL

short
nci_sdtf( c_func, d0, t1, f2 )
	SV* c_func
	double d0
	char * t1
	float f2
PREINIT:
	short(*func)(double, char *, float);
CODE:
	func   = INT2PTR(short(*)(double, char *, float), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, f2);
OUTPUT:
	RETVAL

float
nci_fdtf( c_func, d0, t1, f2 )
	SV* c_func
	double d0
	char * t1
	float f2
PREINIT:
	float(*func)(double, char *, float);
CODE:
	func   = INT2PTR(float(*)(double, char *, float), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, f2);
OUTPUT:
	RETVAL

char *
nci_tdtf( c_func, d0, t1, f2 )
	SV* c_func
	double d0
	char * t1
	float f2
PREINIT:
	char *(*func)(double, char *, float);
CODE:
	func   = INT2PTR(char *(*)(double, char *, float), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, f2);
OUTPUT:
	RETVAL

int
nci_idtf( c_func, d0, t1, f2 )
	SV* c_func
	double d0
	char * t1
	float f2
PREINIT:
	int(*func)(double, char *, float);
CODE:
	func   = INT2PTR(int(*)(double, char *, float), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, f2);
OUTPUT:
	RETVAL

void *
nci_pstf( c_func, s0, t1, f2 )
	SV* c_func
	short s0
	char * t1
	float f2
PREINIT:
	void *(*func)(short, char *, float);
CODE:
	func   = INT2PTR(void *(*)(short, char *, float), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, f2);
OUTPUT:
	RETVAL

void
nci_vstf( c_func, s0, t1, f2 )
	SV* c_func
	short s0
	char * t1
	float f2
PREINIT:
	void(*func)(short, char *, float);
CODE:
	func   = INT2PTR(void(*)(short, char *, float), SvIV(c_func) );
	(*func)(s0, t1, f2);

double
nci_dstf( c_func, s0, t1, f2 )
	SV* c_func
	short s0
	char * t1
	float f2
PREINIT:
	double(*func)(short, char *, float);
CODE:
	func   = INT2PTR(double(*)(short, char *, float), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, f2);
OUTPUT:
	RETVAL

short
nci_sstf( c_func, s0, t1, f2 )
	SV* c_func
	short s0
	char * t1
	float f2
PREINIT:
	short(*func)(short, char *, float);
CODE:
	func   = INT2PTR(short(*)(short, char *, float), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, f2);
OUTPUT:
	RETVAL

float
nci_fstf( c_func, s0, t1, f2 )
	SV* c_func
	short s0
	char * t1
	float f2
PREINIT:
	float(*func)(short, char *, float);
CODE:
	func   = INT2PTR(float(*)(short, char *, float), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, f2);
OUTPUT:
	RETVAL

char *
nci_tstf( c_func, s0, t1, f2 )
	SV* c_func
	short s0
	char * t1
	float f2
PREINIT:
	char *(*func)(short, char *, float);
CODE:
	func   = INT2PTR(char *(*)(short, char *, float), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, f2);
OUTPUT:
	RETVAL

int
nci_istf( c_func, s0, t1, f2 )
	SV* c_func
	short s0
	char * t1
	float f2
PREINIT:
	int(*func)(short, char *, float);
CODE:
	func   = INT2PTR(int(*)(short, char *, float), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, f2);
OUTPUT:
	RETVAL

void *
nci_pftf( c_func, f0, t1, f2 )
	SV* c_func
	float f0
	char * t1
	float f2
PREINIT:
	void *(*func)(float, char *, float);
CODE:
	func   = INT2PTR(void *(*)(float, char *, float), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, f2);
OUTPUT:
	RETVAL

void
nci_vftf( c_func, f0, t1, f2 )
	SV* c_func
	float f0
	char * t1
	float f2
PREINIT:
	void(*func)(float, char *, float);
CODE:
	func   = INT2PTR(void(*)(float, char *, float), SvIV(c_func) );
	(*func)(f0, t1, f2);

double
nci_dftf( c_func, f0, t1, f2 )
	SV* c_func
	float f0
	char * t1
	float f2
PREINIT:
	double(*func)(float, char *, float);
CODE:
	func   = INT2PTR(double(*)(float, char *, float), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, f2);
OUTPUT:
	RETVAL

short
nci_sftf( c_func, f0, t1, f2 )
	SV* c_func
	float f0
	char * t1
	float f2
PREINIT:
	short(*func)(float, char *, float);
CODE:
	func   = INT2PTR(short(*)(float, char *, float), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, f2);
OUTPUT:
	RETVAL

float
nci_fftf( c_func, f0, t1, f2 )
	SV* c_func
	float f0
	char * t1
	float f2
PREINIT:
	float(*func)(float, char *, float);
CODE:
	func   = INT2PTR(float(*)(float, char *, float), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, f2);
OUTPUT:
	RETVAL

char *
nci_tftf( c_func, f0, t1, f2 )
	SV* c_func
	float f0
	char * t1
	float f2
PREINIT:
	char *(*func)(float, char *, float);
CODE:
	func   = INT2PTR(char *(*)(float, char *, float), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, f2);
OUTPUT:
	RETVAL

int
nci_iftf( c_func, f0, t1, f2 )
	SV* c_func
	float f0
	char * t1
	float f2
PREINIT:
	int(*func)(float, char *, float);
CODE:
	func   = INT2PTR(int(*)(float, char *, float), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, f2);
OUTPUT:
	RETVAL

void *
nci_pttf( c_func, t0, t1, f2 )
	SV* c_func
	char * t0
	char * t1
	float f2
PREINIT:
	void *(*func)(char *, char *, float);
CODE:
	func   = INT2PTR(void *(*)(char *, char *, float), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, f2);
OUTPUT:
	RETVAL

void
nci_vttf( c_func, t0, t1, f2 )
	SV* c_func
	char * t0
	char * t1
	float f2
PREINIT:
	void(*func)(char *, char *, float);
CODE:
	func   = INT2PTR(void(*)(char *, char *, float), SvIV(c_func) );
	(*func)(t0, t1, f2);

double
nci_dttf( c_func, t0, t1, f2 )
	SV* c_func
	char * t0
	char * t1
	float f2
PREINIT:
	double(*func)(char *, char *, float);
CODE:
	func   = INT2PTR(double(*)(char *, char *, float), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, f2);
OUTPUT:
	RETVAL

short
nci_sttf( c_func, t0, t1, f2 )
	SV* c_func
	char * t0
	char * t1
	float f2
PREINIT:
	short(*func)(char *, char *, float);
CODE:
	func   = INT2PTR(short(*)(char *, char *, float), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, f2);
OUTPUT:
	RETVAL

float
nci_fttf( c_func, t0, t1, f2 )
	SV* c_func
	char * t0
	char * t1
	float f2
PREINIT:
	float(*func)(char *, char *, float);
CODE:
	func   = INT2PTR(float(*)(char *, char *, float), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, f2);
OUTPUT:
	RETVAL

char *
nci_tttf( c_func, t0, t1, f2 )
	SV* c_func
	char * t0
	char * t1
	float f2
PREINIT:
	char *(*func)(char *, char *, float);
CODE:
	func   = INT2PTR(char *(*)(char *, char *, float), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, f2);
OUTPUT:
	RETVAL

int
nci_ittf( c_func, t0, t1, f2 )
	SV* c_func
	char * t0
	char * t1
	float f2
PREINIT:
	int(*func)(char *, char *, float);
CODE:
	func   = INT2PTR(int(*)(char *, char *, float), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, f2);
OUTPUT:
	RETVAL

void *
nci_pitf( c_func, i0, t1, f2 )
	SV* c_func
	int i0
	char * t1
	float f2
PREINIT:
	void *(*func)(int, char *, float);
CODE:
	func   = INT2PTR(void *(*)(int, char *, float), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, f2);
OUTPUT:
	RETVAL

void
nci_vitf( c_func, i0, t1, f2 )
	SV* c_func
	int i0
	char * t1
	float f2
PREINIT:
	void(*func)(int, char *, float);
CODE:
	func   = INT2PTR(void(*)(int, char *, float), SvIV(c_func) );
	(*func)(i0, t1, f2);

double
nci_ditf( c_func, i0, t1, f2 )
	SV* c_func
	int i0
	char * t1
	float f2
PREINIT:
	double(*func)(int, char *, float);
CODE:
	func   = INT2PTR(double(*)(int, char *, float), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, f2);
OUTPUT:
	RETVAL

short
nci_sitf( c_func, i0, t1, f2 )
	SV* c_func
	int i0
	char * t1
	float f2
PREINIT:
	short(*func)(int, char *, float);
CODE:
	func   = INT2PTR(short(*)(int, char *, float), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, f2);
OUTPUT:
	RETVAL

float
nci_fitf( c_func, i0, t1, f2 )
	SV* c_func
	int i0
	char * t1
	float f2
PREINIT:
	float(*func)(int, char *, float);
CODE:
	func   = INT2PTR(float(*)(int, char *, float), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, f2);
OUTPUT:
	RETVAL

char *
nci_titf( c_func, i0, t1, f2 )
	SV* c_func
	int i0
	char * t1
	float f2
PREINIT:
	char *(*func)(int, char *, float);
CODE:
	func   = INT2PTR(char *(*)(int, char *, float), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, f2);
OUTPUT:
	RETVAL

int
nci_iitf( c_func, i0, t1, f2 )
	SV* c_func
	int i0
	char * t1
	float f2
PREINIT:
	int(*func)(int, char *, float);
CODE:
	func   = INT2PTR(int(*)(int, char *, float), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, f2);
OUTPUT:
	RETVAL

void *
nci_ppif( c_func, p0, i1, f2 )
	SV* c_func
	void * p0
	int i1
	float f2
PREINIT:
	void *(*func)(void *, int, float);
CODE:
	func   = INT2PTR(void *(*)(void *, int, float), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, f2);
OUTPUT:
	RETVAL

void
nci_vpif( c_func, p0, i1, f2 )
	SV* c_func
	void * p0
	int i1
	float f2
PREINIT:
	void(*func)(void *, int, float);
CODE:
	func   = INT2PTR(void(*)(void *, int, float), SvIV(c_func) );
	(*func)(p0, i1, f2);

double
nci_dpif( c_func, p0, i1, f2 )
	SV* c_func
	void * p0
	int i1
	float f2
PREINIT:
	double(*func)(void *, int, float);
CODE:
	func   = INT2PTR(double(*)(void *, int, float), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, f2);
OUTPUT:
	RETVAL

short
nci_spif( c_func, p0, i1, f2 )
	SV* c_func
	void * p0
	int i1
	float f2
PREINIT:
	short(*func)(void *, int, float);
CODE:
	func   = INT2PTR(short(*)(void *, int, float), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, f2);
OUTPUT:
	RETVAL

float
nci_fpif( c_func, p0, i1, f2 )
	SV* c_func
	void * p0
	int i1
	float f2
PREINIT:
	float(*func)(void *, int, float);
CODE:
	func   = INT2PTR(float(*)(void *, int, float), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, f2);
OUTPUT:
	RETVAL

char *
nci_tpif( c_func, p0, i1, f2 )
	SV* c_func
	void * p0
	int i1
	float f2
PREINIT:
	char *(*func)(void *, int, float);
CODE:
	func   = INT2PTR(char *(*)(void *, int, float), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, f2);
OUTPUT:
	RETVAL

int
nci_ipif( c_func, p0, i1, f2 )
	SV* c_func
	void * p0
	int i1
	float f2
PREINIT:
	int(*func)(void *, int, float);
CODE:
	func   = INT2PTR(int(*)(void *, int, float), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, f2);
OUTPUT:
	RETVAL

void *
nci_pvif( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvif( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvif( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svif( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvif( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvif( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivif( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdif( c_func, d0, i1, f2 )
	SV* c_func
	double d0
	int i1
	float f2
PREINIT:
	void *(*func)(double, int, float);
CODE:
	func   = INT2PTR(void *(*)(double, int, float), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, f2);
OUTPUT:
	RETVAL

void
nci_vdif( c_func, d0, i1, f2 )
	SV* c_func
	double d0
	int i1
	float f2
PREINIT:
	void(*func)(double, int, float);
CODE:
	func   = INT2PTR(void(*)(double, int, float), SvIV(c_func) );
	(*func)(d0, i1, f2);

double
nci_ddif( c_func, d0, i1, f2 )
	SV* c_func
	double d0
	int i1
	float f2
PREINIT:
	double(*func)(double, int, float);
CODE:
	func   = INT2PTR(double(*)(double, int, float), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, f2);
OUTPUT:
	RETVAL

short
nci_sdif( c_func, d0, i1, f2 )
	SV* c_func
	double d0
	int i1
	float f2
PREINIT:
	short(*func)(double, int, float);
CODE:
	func   = INT2PTR(short(*)(double, int, float), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, f2);
OUTPUT:
	RETVAL

float
nci_fdif( c_func, d0, i1, f2 )
	SV* c_func
	double d0
	int i1
	float f2
PREINIT:
	float(*func)(double, int, float);
CODE:
	func   = INT2PTR(float(*)(double, int, float), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, f2);
OUTPUT:
	RETVAL

char *
nci_tdif( c_func, d0, i1, f2 )
	SV* c_func
	double d0
	int i1
	float f2
PREINIT:
	char *(*func)(double, int, float);
CODE:
	func   = INT2PTR(char *(*)(double, int, float), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, f2);
OUTPUT:
	RETVAL

int
nci_idif( c_func, d0, i1, f2 )
	SV* c_func
	double d0
	int i1
	float f2
PREINIT:
	int(*func)(double, int, float);
CODE:
	func   = INT2PTR(int(*)(double, int, float), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, f2);
OUTPUT:
	RETVAL

void *
nci_psif( c_func, s0, i1, f2 )
	SV* c_func
	short s0
	int i1
	float f2
PREINIT:
	void *(*func)(short, int, float);
CODE:
	func   = INT2PTR(void *(*)(short, int, float), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, f2);
OUTPUT:
	RETVAL

void
nci_vsif( c_func, s0, i1, f2 )
	SV* c_func
	short s0
	int i1
	float f2
PREINIT:
	void(*func)(short, int, float);
CODE:
	func   = INT2PTR(void(*)(short, int, float), SvIV(c_func) );
	(*func)(s0, i1, f2);

double
nci_dsif( c_func, s0, i1, f2 )
	SV* c_func
	short s0
	int i1
	float f2
PREINIT:
	double(*func)(short, int, float);
CODE:
	func   = INT2PTR(double(*)(short, int, float), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, f2);
OUTPUT:
	RETVAL

short
nci_ssif( c_func, s0, i1, f2 )
	SV* c_func
	short s0
	int i1
	float f2
PREINIT:
	short(*func)(short, int, float);
CODE:
	func   = INT2PTR(short(*)(short, int, float), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, f2);
OUTPUT:
	RETVAL

float
nci_fsif( c_func, s0, i1, f2 )
	SV* c_func
	short s0
	int i1
	float f2
PREINIT:
	float(*func)(short, int, float);
CODE:
	func   = INT2PTR(float(*)(short, int, float), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, f2);
OUTPUT:
	RETVAL

char *
nci_tsif( c_func, s0, i1, f2 )
	SV* c_func
	short s0
	int i1
	float f2
PREINIT:
	char *(*func)(short, int, float);
CODE:
	func   = INT2PTR(char *(*)(short, int, float), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, f2);
OUTPUT:
	RETVAL

int
nci_isif( c_func, s0, i1, f2 )
	SV* c_func
	short s0
	int i1
	float f2
PREINIT:
	int(*func)(short, int, float);
CODE:
	func   = INT2PTR(int(*)(short, int, float), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, f2);
OUTPUT:
	RETVAL

void *
nci_pfif( c_func, f0, i1, f2 )
	SV* c_func
	float f0
	int i1
	float f2
PREINIT:
	void *(*func)(float, int, float);
CODE:
	func   = INT2PTR(void *(*)(float, int, float), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, f2);
OUTPUT:
	RETVAL

void
nci_vfif( c_func, f0, i1, f2 )
	SV* c_func
	float f0
	int i1
	float f2
PREINIT:
	void(*func)(float, int, float);
CODE:
	func   = INT2PTR(void(*)(float, int, float), SvIV(c_func) );
	(*func)(f0, i1, f2);

double
nci_dfif( c_func, f0, i1, f2 )
	SV* c_func
	float f0
	int i1
	float f2
PREINIT:
	double(*func)(float, int, float);
CODE:
	func   = INT2PTR(double(*)(float, int, float), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, f2);
OUTPUT:
	RETVAL

short
nci_sfif( c_func, f0, i1, f2 )
	SV* c_func
	float f0
	int i1
	float f2
PREINIT:
	short(*func)(float, int, float);
CODE:
	func   = INT2PTR(short(*)(float, int, float), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, f2);
OUTPUT:
	RETVAL

float
nci_ffif( c_func, f0, i1, f2 )
	SV* c_func
	float f0
	int i1
	float f2
PREINIT:
	float(*func)(float, int, float);
CODE:
	func   = INT2PTR(float(*)(float, int, float), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, f2);
OUTPUT:
	RETVAL

char *
nci_tfif( c_func, f0, i1, f2 )
	SV* c_func
	float f0
	int i1
	float f2
PREINIT:
	char *(*func)(float, int, float);
CODE:
	func   = INT2PTR(char *(*)(float, int, float), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, f2);
OUTPUT:
	RETVAL

int
nci_ifif( c_func, f0, i1, f2 )
	SV* c_func
	float f0
	int i1
	float f2
PREINIT:
	int(*func)(float, int, float);
CODE:
	func   = INT2PTR(int(*)(float, int, float), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, f2);
OUTPUT:
	RETVAL

void *
nci_ptif( c_func, t0, i1, f2 )
	SV* c_func
	char * t0
	int i1
	float f2
PREINIT:
	void *(*func)(char *, int, float);
CODE:
	func   = INT2PTR(void *(*)(char *, int, float), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, f2);
OUTPUT:
	RETVAL

void
nci_vtif( c_func, t0, i1, f2 )
	SV* c_func
	char * t0
	int i1
	float f2
PREINIT:
	void(*func)(char *, int, float);
CODE:
	func   = INT2PTR(void(*)(char *, int, float), SvIV(c_func) );
	(*func)(t0, i1, f2);

double
nci_dtif( c_func, t0, i1, f2 )
	SV* c_func
	char * t0
	int i1
	float f2
PREINIT:
	double(*func)(char *, int, float);
CODE:
	func   = INT2PTR(double(*)(char *, int, float), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, f2);
OUTPUT:
	RETVAL

short
nci_stif( c_func, t0, i1, f2 )
	SV* c_func
	char * t0
	int i1
	float f2
PREINIT:
	short(*func)(char *, int, float);
CODE:
	func   = INT2PTR(short(*)(char *, int, float), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, f2);
OUTPUT:
	RETVAL

float
nci_ftif( c_func, t0, i1, f2 )
	SV* c_func
	char * t0
	int i1
	float f2
PREINIT:
	float(*func)(char *, int, float);
CODE:
	func   = INT2PTR(float(*)(char *, int, float), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, f2);
OUTPUT:
	RETVAL

char *
nci_ttif( c_func, t0, i1, f2 )
	SV* c_func
	char * t0
	int i1
	float f2
PREINIT:
	char *(*func)(char *, int, float);
CODE:
	func   = INT2PTR(char *(*)(char *, int, float), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, f2);
OUTPUT:
	RETVAL

int
nci_itif( c_func, t0, i1, f2 )
	SV* c_func
	char * t0
	int i1
	float f2
PREINIT:
	int(*func)(char *, int, float);
CODE:
	func   = INT2PTR(int(*)(char *, int, float), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, f2);
OUTPUT:
	RETVAL

void *
nci_piif( c_func, i0, i1, f2 )
	SV* c_func
	int i0
	int i1
	float f2
PREINIT:
	void *(*func)(int, int, float);
CODE:
	func   = INT2PTR(void *(*)(int, int, float), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, f2);
OUTPUT:
	RETVAL

void
nci_viif( c_func, i0, i1, f2 )
	SV* c_func
	int i0
	int i1
	float f2
PREINIT:
	void(*func)(int, int, float);
CODE:
	func   = INT2PTR(void(*)(int, int, float), SvIV(c_func) );
	(*func)(i0, i1, f2);

double
nci_diif( c_func, i0, i1, f2 )
	SV* c_func
	int i0
	int i1
	float f2
PREINIT:
	double(*func)(int, int, float);
CODE:
	func   = INT2PTR(double(*)(int, int, float), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, f2);
OUTPUT:
	RETVAL

short
nci_siif( c_func, i0, i1, f2 )
	SV* c_func
	int i0
	int i1
	float f2
PREINIT:
	short(*func)(int, int, float);
CODE:
	func   = INT2PTR(short(*)(int, int, float), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, f2);
OUTPUT:
	RETVAL

float
nci_fiif( c_func, i0, i1, f2 )
	SV* c_func
	int i0
	int i1
	float f2
PREINIT:
	float(*func)(int, int, float);
CODE:
	func   = INT2PTR(float(*)(int, int, float), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, f2);
OUTPUT:
	RETVAL

char *
nci_tiif( c_func, i0, i1, f2 )
	SV* c_func
	int i0
	int i1
	float f2
PREINIT:
	char *(*func)(int, int, float);
CODE:
	func   = INT2PTR(char *(*)(int, int, float), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, f2);
OUTPUT:
	RETVAL

int
nci_iiif( c_func, i0, i1, f2 )
	SV* c_func
	int i0
	int i1
	float f2
PREINIT:
	int(*func)(int, int, float);
CODE:
	func   = INT2PTR(int(*)(int, int, float), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, f2);
OUTPUT:
	RETVAL

void *
nci_pppt( c_func, p0, p1, t2 )
	SV* c_func
	void * p0
	void * p1
	char * t2
PREINIT:
	void *(*func)(void *, void *, char *);
CODE:
	func   = INT2PTR(void *(*)(void *, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, t2);
OUTPUT:
	RETVAL

void
nci_vppt( c_func, p0, p1, t2 )
	SV* c_func
	void * p0
	void * p1
	char * t2
PREINIT:
	void(*func)(void *, void *, char *);
CODE:
	func   = INT2PTR(void(*)(void *, void *, char *), SvIV(c_func) );
	(*func)(p0, p1, t2);

double
nci_dppt( c_func, p0, p1, t2 )
	SV* c_func
	void * p0
	void * p1
	char * t2
PREINIT:
	double(*func)(void *, void *, char *);
CODE:
	func   = INT2PTR(double(*)(void *, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, t2);
OUTPUT:
	RETVAL

short
nci_sppt( c_func, p0, p1, t2 )
	SV* c_func
	void * p0
	void * p1
	char * t2
PREINIT:
	short(*func)(void *, void *, char *);
CODE:
	func   = INT2PTR(short(*)(void *, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, t2);
OUTPUT:
	RETVAL

float
nci_fppt( c_func, p0, p1, t2 )
	SV* c_func
	void * p0
	void * p1
	char * t2
PREINIT:
	float(*func)(void *, void *, char *);
CODE:
	func   = INT2PTR(float(*)(void *, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, t2);
OUTPUT:
	RETVAL

char *
nci_tppt( c_func, p0, p1, t2 )
	SV* c_func
	void * p0
	void * p1
	char * t2
PREINIT:
	char *(*func)(void *, void *, char *);
CODE:
	func   = INT2PTR(char *(*)(void *, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, t2);
OUTPUT:
	RETVAL

int
nci_ippt( c_func, p0, p1, t2 )
	SV* c_func
	void * p0
	void * p1
	char * t2
PREINIT:
	int(*func)(void *, void *, char *);
CODE:
	func   = INT2PTR(int(*)(void *, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, t2);
OUTPUT:
	RETVAL

void *
nci_pvpt( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvpt( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvpt( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svpt( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvpt( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvpt( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivpt( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdpt( c_func, d0, p1, t2 )
	SV* c_func
	double d0
	void * p1
	char * t2
PREINIT:
	void *(*func)(double, void *, char *);
CODE:
	func   = INT2PTR(void *(*)(double, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, t2);
OUTPUT:
	RETVAL

void
nci_vdpt( c_func, d0, p1, t2 )
	SV* c_func
	double d0
	void * p1
	char * t2
PREINIT:
	void(*func)(double, void *, char *);
CODE:
	func   = INT2PTR(void(*)(double, void *, char *), SvIV(c_func) );
	(*func)(d0, p1, t2);

double
nci_ddpt( c_func, d0, p1, t2 )
	SV* c_func
	double d0
	void * p1
	char * t2
PREINIT:
	double(*func)(double, void *, char *);
CODE:
	func   = INT2PTR(double(*)(double, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, t2);
OUTPUT:
	RETVAL

short
nci_sdpt( c_func, d0, p1, t2 )
	SV* c_func
	double d0
	void * p1
	char * t2
PREINIT:
	short(*func)(double, void *, char *);
CODE:
	func   = INT2PTR(short(*)(double, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, t2);
OUTPUT:
	RETVAL

float
nci_fdpt( c_func, d0, p1, t2 )
	SV* c_func
	double d0
	void * p1
	char * t2
PREINIT:
	float(*func)(double, void *, char *);
CODE:
	func   = INT2PTR(float(*)(double, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, t2);
OUTPUT:
	RETVAL

char *
nci_tdpt( c_func, d0, p1, t2 )
	SV* c_func
	double d0
	void * p1
	char * t2
PREINIT:
	char *(*func)(double, void *, char *);
CODE:
	func   = INT2PTR(char *(*)(double, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, t2);
OUTPUT:
	RETVAL

int
nci_idpt( c_func, d0, p1, t2 )
	SV* c_func
	double d0
	void * p1
	char * t2
PREINIT:
	int(*func)(double, void *, char *);
CODE:
	func   = INT2PTR(int(*)(double, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, t2);
OUTPUT:
	RETVAL

void *
nci_pspt( c_func, s0, p1, t2 )
	SV* c_func
	short s0
	void * p1
	char * t2
PREINIT:
	void *(*func)(short, void *, char *);
CODE:
	func   = INT2PTR(void *(*)(short, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, t2);
OUTPUT:
	RETVAL

void
nci_vspt( c_func, s0, p1, t2 )
	SV* c_func
	short s0
	void * p1
	char * t2
PREINIT:
	void(*func)(short, void *, char *);
CODE:
	func   = INT2PTR(void(*)(short, void *, char *), SvIV(c_func) );
	(*func)(s0, p1, t2);

double
nci_dspt( c_func, s0, p1, t2 )
	SV* c_func
	short s0
	void * p1
	char * t2
PREINIT:
	double(*func)(short, void *, char *);
CODE:
	func   = INT2PTR(double(*)(short, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, t2);
OUTPUT:
	RETVAL

short
nci_sspt( c_func, s0, p1, t2 )
	SV* c_func
	short s0
	void * p1
	char * t2
PREINIT:
	short(*func)(short, void *, char *);
CODE:
	func   = INT2PTR(short(*)(short, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, t2);
OUTPUT:
	RETVAL

float
nci_fspt( c_func, s0, p1, t2 )
	SV* c_func
	short s0
	void * p1
	char * t2
PREINIT:
	float(*func)(short, void *, char *);
CODE:
	func   = INT2PTR(float(*)(short, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, t2);
OUTPUT:
	RETVAL

char *
nci_tspt( c_func, s0, p1, t2 )
	SV* c_func
	short s0
	void * p1
	char * t2
PREINIT:
	char *(*func)(short, void *, char *);
CODE:
	func   = INT2PTR(char *(*)(short, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, t2);
OUTPUT:
	RETVAL

int
nci_ispt( c_func, s0, p1, t2 )
	SV* c_func
	short s0
	void * p1
	char * t2
PREINIT:
	int(*func)(short, void *, char *);
CODE:
	func   = INT2PTR(int(*)(short, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, t2);
OUTPUT:
	RETVAL

void *
nci_pfpt( c_func, f0, p1, t2 )
	SV* c_func
	float f0
	void * p1
	char * t2
PREINIT:
	void *(*func)(float, void *, char *);
CODE:
	func   = INT2PTR(void *(*)(float, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, t2);
OUTPUT:
	RETVAL

void
nci_vfpt( c_func, f0, p1, t2 )
	SV* c_func
	float f0
	void * p1
	char * t2
PREINIT:
	void(*func)(float, void *, char *);
CODE:
	func   = INT2PTR(void(*)(float, void *, char *), SvIV(c_func) );
	(*func)(f0, p1, t2);

double
nci_dfpt( c_func, f0, p1, t2 )
	SV* c_func
	float f0
	void * p1
	char * t2
PREINIT:
	double(*func)(float, void *, char *);
CODE:
	func   = INT2PTR(double(*)(float, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, t2);
OUTPUT:
	RETVAL

short
nci_sfpt( c_func, f0, p1, t2 )
	SV* c_func
	float f0
	void * p1
	char * t2
PREINIT:
	short(*func)(float, void *, char *);
CODE:
	func   = INT2PTR(short(*)(float, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, t2);
OUTPUT:
	RETVAL

float
nci_ffpt( c_func, f0, p1, t2 )
	SV* c_func
	float f0
	void * p1
	char * t2
PREINIT:
	float(*func)(float, void *, char *);
CODE:
	func   = INT2PTR(float(*)(float, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, t2);
OUTPUT:
	RETVAL

char *
nci_tfpt( c_func, f0, p1, t2 )
	SV* c_func
	float f0
	void * p1
	char * t2
PREINIT:
	char *(*func)(float, void *, char *);
CODE:
	func   = INT2PTR(char *(*)(float, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, t2);
OUTPUT:
	RETVAL

int
nci_ifpt( c_func, f0, p1, t2 )
	SV* c_func
	float f0
	void * p1
	char * t2
PREINIT:
	int(*func)(float, void *, char *);
CODE:
	func   = INT2PTR(int(*)(float, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, t2);
OUTPUT:
	RETVAL

void *
nci_ptpt( c_func, t0, p1, t2 )
	SV* c_func
	char * t0
	void * p1
	char * t2
PREINIT:
	void *(*func)(char *, void *, char *);
CODE:
	func   = INT2PTR(void *(*)(char *, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, t2);
OUTPUT:
	RETVAL

void
nci_vtpt( c_func, t0, p1, t2 )
	SV* c_func
	char * t0
	void * p1
	char * t2
PREINIT:
	void(*func)(char *, void *, char *);
CODE:
	func   = INT2PTR(void(*)(char *, void *, char *), SvIV(c_func) );
	(*func)(t0, p1, t2);

double
nci_dtpt( c_func, t0, p1, t2 )
	SV* c_func
	char * t0
	void * p1
	char * t2
PREINIT:
	double(*func)(char *, void *, char *);
CODE:
	func   = INT2PTR(double(*)(char *, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, t2);
OUTPUT:
	RETVAL

short
nci_stpt( c_func, t0, p1, t2 )
	SV* c_func
	char * t0
	void * p1
	char * t2
PREINIT:
	short(*func)(char *, void *, char *);
CODE:
	func   = INT2PTR(short(*)(char *, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, t2);
OUTPUT:
	RETVAL

float
nci_ftpt( c_func, t0, p1, t2 )
	SV* c_func
	char * t0
	void * p1
	char * t2
PREINIT:
	float(*func)(char *, void *, char *);
CODE:
	func   = INT2PTR(float(*)(char *, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, t2);
OUTPUT:
	RETVAL

char *
nci_ttpt( c_func, t0, p1, t2 )
	SV* c_func
	char * t0
	void * p1
	char * t2
PREINIT:
	char *(*func)(char *, void *, char *);
CODE:
	func   = INT2PTR(char *(*)(char *, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, t2);
OUTPUT:
	RETVAL

int
nci_itpt( c_func, t0, p1, t2 )
	SV* c_func
	char * t0
	void * p1
	char * t2
PREINIT:
	int(*func)(char *, void *, char *);
CODE:
	func   = INT2PTR(int(*)(char *, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, t2);
OUTPUT:
	RETVAL

void *
nci_pipt( c_func, i0, p1, t2 )
	SV* c_func
	int i0
	void * p1
	char * t2
PREINIT:
	void *(*func)(int, void *, char *);
CODE:
	func   = INT2PTR(void *(*)(int, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, t2);
OUTPUT:
	RETVAL

void
nci_vipt( c_func, i0, p1, t2 )
	SV* c_func
	int i0
	void * p1
	char * t2
PREINIT:
	void(*func)(int, void *, char *);
CODE:
	func   = INT2PTR(void(*)(int, void *, char *), SvIV(c_func) );
	(*func)(i0, p1, t2);

double
nci_dipt( c_func, i0, p1, t2 )
	SV* c_func
	int i0
	void * p1
	char * t2
PREINIT:
	double(*func)(int, void *, char *);
CODE:
	func   = INT2PTR(double(*)(int, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, t2);
OUTPUT:
	RETVAL

short
nci_sipt( c_func, i0, p1, t2 )
	SV* c_func
	int i0
	void * p1
	char * t2
PREINIT:
	short(*func)(int, void *, char *);
CODE:
	func   = INT2PTR(short(*)(int, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, t2);
OUTPUT:
	RETVAL

float
nci_fipt( c_func, i0, p1, t2 )
	SV* c_func
	int i0
	void * p1
	char * t2
PREINIT:
	float(*func)(int, void *, char *);
CODE:
	func   = INT2PTR(float(*)(int, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, t2);
OUTPUT:
	RETVAL

char *
nci_tipt( c_func, i0, p1, t2 )
	SV* c_func
	int i0
	void * p1
	char * t2
PREINIT:
	char *(*func)(int, void *, char *);
CODE:
	func   = INT2PTR(char *(*)(int, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, t2);
OUTPUT:
	RETVAL

int
nci_iipt( c_func, i0, p1, t2 )
	SV* c_func
	int i0
	void * p1
	char * t2
PREINIT:
	int(*func)(int, void *, char *);
CODE:
	func   = INT2PTR(int(*)(int, void *, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, t2);
OUTPUT:
	RETVAL

void *
nci_ppdt( c_func, p0, d1, t2 )
	SV* c_func
	void * p0
	double d1
	char * t2
PREINIT:
	void *(*func)(void *, double, char *);
CODE:
	func   = INT2PTR(void *(*)(void *, double, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, t2);
OUTPUT:
	RETVAL

void
nci_vpdt( c_func, p0, d1, t2 )
	SV* c_func
	void * p0
	double d1
	char * t2
PREINIT:
	void(*func)(void *, double, char *);
CODE:
	func   = INT2PTR(void(*)(void *, double, char *), SvIV(c_func) );
	(*func)(p0, d1, t2);

double
nci_dpdt( c_func, p0, d1, t2 )
	SV* c_func
	void * p0
	double d1
	char * t2
PREINIT:
	double(*func)(void *, double, char *);
CODE:
	func   = INT2PTR(double(*)(void *, double, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, t2);
OUTPUT:
	RETVAL

short
nci_spdt( c_func, p0, d1, t2 )
	SV* c_func
	void * p0
	double d1
	char * t2
PREINIT:
	short(*func)(void *, double, char *);
CODE:
	func   = INT2PTR(short(*)(void *, double, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, t2);
OUTPUT:
	RETVAL

float
nci_fpdt( c_func, p0, d1, t2 )
	SV* c_func
	void * p0
	double d1
	char * t2
PREINIT:
	float(*func)(void *, double, char *);
CODE:
	func   = INT2PTR(float(*)(void *, double, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, t2);
OUTPUT:
	RETVAL

char *
nci_tpdt( c_func, p0, d1, t2 )
	SV* c_func
	void * p0
	double d1
	char * t2
PREINIT:
	char *(*func)(void *, double, char *);
CODE:
	func   = INT2PTR(char *(*)(void *, double, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, t2);
OUTPUT:
	RETVAL

int
nci_ipdt( c_func, p0, d1, t2 )
	SV* c_func
	void * p0
	double d1
	char * t2
PREINIT:
	int(*func)(void *, double, char *);
CODE:
	func   = INT2PTR(int(*)(void *, double, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, t2);
OUTPUT:
	RETVAL

void *
nci_pvdt( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvdt( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvdt( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svdt( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvdt( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvdt( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivdt( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pddt( c_func, d0, d1, t2 )
	SV* c_func
	double d0
	double d1
	char * t2
PREINIT:
	void *(*func)(double, double, char *);
CODE:
	func   = INT2PTR(void *(*)(double, double, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, t2);
OUTPUT:
	RETVAL

void
nci_vddt( c_func, d0, d1, t2 )
	SV* c_func
	double d0
	double d1
	char * t2
PREINIT:
	void(*func)(double, double, char *);
CODE:
	func   = INT2PTR(void(*)(double, double, char *), SvIV(c_func) );
	(*func)(d0, d1, t2);

double
nci_dddt( c_func, d0, d1, t2 )
	SV* c_func
	double d0
	double d1
	char * t2
PREINIT:
	double(*func)(double, double, char *);
CODE:
	func   = INT2PTR(double(*)(double, double, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, t2);
OUTPUT:
	RETVAL

short
nci_sddt( c_func, d0, d1, t2 )
	SV* c_func
	double d0
	double d1
	char * t2
PREINIT:
	short(*func)(double, double, char *);
CODE:
	func   = INT2PTR(short(*)(double, double, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, t2);
OUTPUT:
	RETVAL

float
nci_fddt( c_func, d0, d1, t2 )
	SV* c_func
	double d0
	double d1
	char * t2
PREINIT:
	float(*func)(double, double, char *);
CODE:
	func   = INT2PTR(float(*)(double, double, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, t2);
OUTPUT:
	RETVAL

char *
nci_tddt( c_func, d0, d1, t2 )
	SV* c_func
	double d0
	double d1
	char * t2
PREINIT:
	char *(*func)(double, double, char *);
CODE:
	func   = INT2PTR(char *(*)(double, double, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, t2);
OUTPUT:
	RETVAL

int
nci_iddt( c_func, d0, d1, t2 )
	SV* c_func
	double d0
	double d1
	char * t2
PREINIT:
	int(*func)(double, double, char *);
CODE:
	func   = INT2PTR(int(*)(double, double, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, t2);
OUTPUT:
	RETVAL

void *
nci_psdt( c_func, s0, d1, t2 )
	SV* c_func
	short s0
	double d1
	char * t2
PREINIT:
	void *(*func)(short, double, char *);
CODE:
	func   = INT2PTR(void *(*)(short, double, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, t2);
OUTPUT:
	RETVAL

void
nci_vsdt( c_func, s0, d1, t2 )
	SV* c_func
	short s0
	double d1
	char * t2
PREINIT:
	void(*func)(short, double, char *);
CODE:
	func   = INT2PTR(void(*)(short, double, char *), SvIV(c_func) );
	(*func)(s0, d1, t2);

double
nci_dsdt( c_func, s0, d1, t2 )
	SV* c_func
	short s0
	double d1
	char * t2
PREINIT:
	double(*func)(short, double, char *);
CODE:
	func   = INT2PTR(double(*)(short, double, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, t2);
OUTPUT:
	RETVAL

short
nci_ssdt( c_func, s0, d1, t2 )
	SV* c_func
	short s0
	double d1
	char * t2
PREINIT:
	short(*func)(short, double, char *);
CODE:
	func   = INT2PTR(short(*)(short, double, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, t2);
OUTPUT:
	RETVAL

float
nci_fsdt( c_func, s0, d1, t2 )
	SV* c_func
	short s0
	double d1
	char * t2
PREINIT:
	float(*func)(short, double, char *);
CODE:
	func   = INT2PTR(float(*)(short, double, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, t2);
OUTPUT:
	RETVAL

char *
nci_tsdt( c_func, s0, d1, t2 )
	SV* c_func
	short s0
	double d1
	char * t2
PREINIT:
	char *(*func)(short, double, char *);
CODE:
	func   = INT2PTR(char *(*)(short, double, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, t2);
OUTPUT:
	RETVAL

int
nci_isdt( c_func, s0, d1, t2 )
	SV* c_func
	short s0
	double d1
	char * t2
PREINIT:
	int(*func)(short, double, char *);
CODE:
	func   = INT2PTR(int(*)(short, double, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, t2);
OUTPUT:
	RETVAL

void *
nci_pfdt( c_func, f0, d1, t2 )
	SV* c_func
	float f0
	double d1
	char * t2
PREINIT:
	void *(*func)(float, double, char *);
CODE:
	func   = INT2PTR(void *(*)(float, double, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, t2);
OUTPUT:
	RETVAL

void
nci_vfdt( c_func, f0, d1, t2 )
	SV* c_func
	float f0
	double d1
	char * t2
PREINIT:
	void(*func)(float, double, char *);
CODE:
	func   = INT2PTR(void(*)(float, double, char *), SvIV(c_func) );
	(*func)(f0, d1, t2);

double
nci_dfdt( c_func, f0, d1, t2 )
	SV* c_func
	float f0
	double d1
	char * t2
PREINIT:
	double(*func)(float, double, char *);
CODE:
	func   = INT2PTR(double(*)(float, double, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, t2);
OUTPUT:
	RETVAL

short
nci_sfdt( c_func, f0, d1, t2 )
	SV* c_func
	float f0
	double d1
	char * t2
PREINIT:
	short(*func)(float, double, char *);
CODE:
	func   = INT2PTR(short(*)(float, double, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, t2);
OUTPUT:
	RETVAL

float
nci_ffdt( c_func, f0, d1, t2 )
	SV* c_func
	float f0
	double d1
	char * t2
PREINIT:
	float(*func)(float, double, char *);
CODE:
	func   = INT2PTR(float(*)(float, double, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, t2);
OUTPUT:
	RETVAL

char *
nci_tfdt( c_func, f0, d1, t2 )
	SV* c_func
	float f0
	double d1
	char * t2
PREINIT:
	char *(*func)(float, double, char *);
CODE:
	func   = INT2PTR(char *(*)(float, double, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, t2);
OUTPUT:
	RETVAL

int
nci_ifdt( c_func, f0, d1, t2 )
	SV* c_func
	float f0
	double d1
	char * t2
PREINIT:
	int(*func)(float, double, char *);
CODE:
	func   = INT2PTR(int(*)(float, double, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, t2);
OUTPUT:
	RETVAL

void *
nci_ptdt( c_func, t0, d1, t2 )
	SV* c_func
	char * t0
	double d1
	char * t2
PREINIT:
	void *(*func)(char *, double, char *);
CODE:
	func   = INT2PTR(void *(*)(char *, double, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, t2);
OUTPUT:
	RETVAL

void
nci_vtdt( c_func, t0, d1, t2 )
	SV* c_func
	char * t0
	double d1
	char * t2
PREINIT:
	void(*func)(char *, double, char *);
CODE:
	func   = INT2PTR(void(*)(char *, double, char *), SvIV(c_func) );
	(*func)(t0, d1, t2);

double
nci_dtdt( c_func, t0, d1, t2 )
	SV* c_func
	char * t0
	double d1
	char * t2
PREINIT:
	double(*func)(char *, double, char *);
CODE:
	func   = INT2PTR(double(*)(char *, double, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, t2);
OUTPUT:
	RETVAL

short
nci_stdt( c_func, t0, d1, t2 )
	SV* c_func
	char * t0
	double d1
	char * t2
PREINIT:
	short(*func)(char *, double, char *);
CODE:
	func   = INT2PTR(short(*)(char *, double, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, t2);
OUTPUT:
	RETVAL

float
nci_ftdt( c_func, t0, d1, t2 )
	SV* c_func
	char * t0
	double d1
	char * t2
PREINIT:
	float(*func)(char *, double, char *);
CODE:
	func   = INT2PTR(float(*)(char *, double, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, t2);
OUTPUT:
	RETVAL

char *
nci_ttdt( c_func, t0, d1, t2 )
	SV* c_func
	char * t0
	double d1
	char * t2
PREINIT:
	char *(*func)(char *, double, char *);
CODE:
	func   = INT2PTR(char *(*)(char *, double, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, t2);
OUTPUT:
	RETVAL

int
nci_itdt( c_func, t0, d1, t2 )
	SV* c_func
	char * t0
	double d1
	char * t2
PREINIT:
	int(*func)(char *, double, char *);
CODE:
	func   = INT2PTR(int(*)(char *, double, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, t2);
OUTPUT:
	RETVAL

void *
nci_pidt( c_func, i0, d1, t2 )
	SV* c_func
	int i0
	double d1
	char * t2
PREINIT:
	void *(*func)(int, double, char *);
CODE:
	func   = INT2PTR(void *(*)(int, double, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, t2);
OUTPUT:
	RETVAL

void
nci_vidt( c_func, i0, d1, t2 )
	SV* c_func
	int i0
	double d1
	char * t2
PREINIT:
	void(*func)(int, double, char *);
CODE:
	func   = INT2PTR(void(*)(int, double, char *), SvIV(c_func) );
	(*func)(i0, d1, t2);

double
nci_didt( c_func, i0, d1, t2 )
	SV* c_func
	int i0
	double d1
	char * t2
PREINIT:
	double(*func)(int, double, char *);
CODE:
	func   = INT2PTR(double(*)(int, double, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, t2);
OUTPUT:
	RETVAL

short
nci_sidt( c_func, i0, d1, t2 )
	SV* c_func
	int i0
	double d1
	char * t2
PREINIT:
	short(*func)(int, double, char *);
CODE:
	func   = INT2PTR(short(*)(int, double, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, t2);
OUTPUT:
	RETVAL

float
nci_fidt( c_func, i0, d1, t2 )
	SV* c_func
	int i0
	double d1
	char * t2
PREINIT:
	float(*func)(int, double, char *);
CODE:
	func   = INT2PTR(float(*)(int, double, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, t2);
OUTPUT:
	RETVAL

char *
nci_tidt( c_func, i0, d1, t2 )
	SV* c_func
	int i0
	double d1
	char * t2
PREINIT:
	char *(*func)(int, double, char *);
CODE:
	func   = INT2PTR(char *(*)(int, double, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, t2);
OUTPUT:
	RETVAL

int
nci_iidt( c_func, i0, d1, t2 )
	SV* c_func
	int i0
	double d1
	char * t2
PREINIT:
	int(*func)(int, double, char *);
CODE:
	func   = INT2PTR(int(*)(int, double, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, t2);
OUTPUT:
	RETVAL

void *
nci_ppst( c_func, p0, s1, t2 )
	SV* c_func
	void * p0
	short s1
	char * t2
PREINIT:
	void *(*func)(void *, short, char *);
CODE:
	func   = INT2PTR(void *(*)(void *, short, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, t2);
OUTPUT:
	RETVAL

void
nci_vpst( c_func, p0, s1, t2 )
	SV* c_func
	void * p0
	short s1
	char * t2
PREINIT:
	void(*func)(void *, short, char *);
CODE:
	func   = INT2PTR(void(*)(void *, short, char *), SvIV(c_func) );
	(*func)(p0, s1, t2);

double
nci_dpst( c_func, p0, s1, t2 )
	SV* c_func
	void * p0
	short s1
	char * t2
PREINIT:
	double(*func)(void *, short, char *);
CODE:
	func   = INT2PTR(double(*)(void *, short, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, t2);
OUTPUT:
	RETVAL

short
nci_spst( c_func, p0, s1, t2 )
	SV* c_func
	void * p0
	short s1
	char * t2
PREINIT:
	short(*func)(void *, short, char *);
CODE:
	func   = INT2PTR(short(*)(void *, short, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, t2);
OUTPUT:
	RETVAL

float
nci_fpst( c_func, p0, s1, t2 )
	SV* c_func
	void * p0
	short s1
	char * t2
PREINIT:
	float(*func)(void *, short, char *);
CODE:
	func   = INT2PTR(float(*)(void *, short, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, t2);
OUTPUT:
	RETVAL

char *
nci_tpst( c_func, p0, s1, t2 )
	SV* c_func
	void * p0
	short s1
	char * t2
PREINIT:
	char *(*func)(void *, short, char *);
CODE:
	func   = INT2PTR(char *(*)(void *, short, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, t2);
OUTPUT:
	RETVAL

int
nci_ipst( c_func, p0, s1, t2 )
	SV* c_func
	void * p0
	short s1
	char * t2
PREINIT:
	int(*func)(void *, short, char *);
CODE:
	func   = INT2PTR(int(*)(void *, short, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, t2);
OUTPUT:
	RETVAL

void *
nci_pvst( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvst( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvst( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svst( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvst( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvst( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivst( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdst( c_func, d0, s1, t2 )
	SV* c_func
	double d0
	short s1
	char * t2
PREINIT:
	void *(*func)(double, short, char *);
CODE:
	func   = INT2PTR(void *(*)(double, short, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, t2);
OUTPUT:
	RETVAL

void
nci_vdst( c_func, d0, s1, t2 )
	SV* c_func
	double d0
	short s1
	char * t2
PREINIT:
	void(*func)(double, short, char *);
CODE:
	func   = INT2PTR(void(*)(double, short, char *), SvIV(c_func) );
	(*func)(d0, s1, t2);

double
nci_ddst( c_func, d0, s1, t2 )
	SV* c_func
	double d0
	short s1
	char * t2
PREINIT:
	double(*func)(double, short, char *);
CODE:
	func   = INT2PTR(double(*)(double, short, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, t2);
OUTPUT:
	RETVAL

short
nci_sdst( c_func, d0, s1, t2 )
	SV* c_func
	double d0
	short s1
	char * t2
PREINIT:
	short(*func)(double, short, char *);
CODE:
	func   = INT2PTR(short(*)(double, short, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, t2);
OUTPUT:
	RETVAL

float
nci_fdst( c_func, d0, s1, t2 )
	SV* c_func
	double d0
	short s1
	char * t2
PREINIT:
	float(*func)(double, short, char *);
CODE:
	func   = INT2PTR(float(*)(double, short, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, t2);
OUTPUT:
	RETVAL

char *
nci_tdst( c_func, d0, s1, t2 )
	SV* c_func
	double d0
	short s1
	char * t2
PREINIT:
	char *(*func)(double, short, char *);
CODE:
	func   = INT2PTR(char *(*)(double, short, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, t2);
OUTPUT:
	RETVAL

int
nci_idst( c_func, d0, s1, t2 )
	SV* c_func
	double d0
	short s1
	char * t2
PREINIT:
	int(*func)(double, short, char *);
CODE:
	func   = INT2PTR(int(*)(double, short, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, t2);
OUTPUT:
	RETVAL

void *
nci_psst( c_func, s0, s1, t2 )
	SV* c_func
	short s0
	short s1
	char * t2
PREINIT:
	void *(*func)(short, short, char *);
CODE:
	func   = INT2PTR(void *(*)(short, short, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, t2);
OUTPUT:
	RETVAL

void
nci_vsst( c_func, s0, s1, t2 )
	SV* c_func
	short s0
	short s1
	char * t2
PREINIT:
	void(*func)(short, short, char *);
CODE:
	func   = INT2PTR(void(*)(short, short, char *), SvIV(c_func) );
	(*func)(s0, s1, t2);

double
nci_dsst( c_func, s0, s1, t2 )
	SV* c_func
	short s0
	short s1
	char * t2
PREINIT:
	double(*func)(short, short, char *);
CODE:
	func   = INT2PTR(double(*)(short, short, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, t2);
OUTPUT:
	RETVAL

short
nci_ssst( c_func, s0, s1, t2 )
	SV* c_func
	short s0
	short s1
	char * t2
PREINIT:
	short(*func)(short, short, char *);
CODE:
	func   = INT2PTR(short(*)(short, short, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, t2);
OUTPUT:
	RETVAL

float
nci_fsst( c_func, s0, s1, t2 )
	SV* c_func
	short s0
	short s1
	char * t2
PREINIT:
	float(*func)(short, short, char *);
CODE:
	func   = INT2PTR(float(*)(short, short, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, t2);
OUTPUT:
	RETVAL

char *
nci_tsst( c_func, s0, s1, t2 )
	SV* c_func
	short s0
	short s1
	char * t2
PREINIT:
	char *(*func)(short, short, char *);
CODE:
	func   = INT2PTR(char *(*)(short, short, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, t2);
OUTPUT:
	RETVAL

int
nci_isst( c_func, s0, s1, t2 )
	SV* c_func
	short s0
	short s1
	char * t2
PREINIT:
	int(*func)(short, short, char *);
CODE:
	func   = INT2PTR(int(*)(short, short, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, t2);
OUTPUT:
	RETVAL

void *
nci_pfst( c_func, f0, s1, t2 )
	SV* c_func
	float f0
	short s1
	char * t2
PREINIT:
	void *(*func)(float, short, char *);
CODE:
	func   = INT2PTR(void *(*)(float, short, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, t2);
OUTPUT:
	RETVAL

void
nci_vfst( c_func, f0, s1, t2 )
	SV* c_func
	float f0
	short s1
	char * t2
PREINIT:
	void(*func)(float, short, char *);
CODE:
	func   = INT2PTR(void(*)(float, short, char *), SvIV(c_func) );
	(*func)(f0, s1, t2);

double
nci_dfst( c_func, f0, s1, t2 )
	SV* c_func
	float f0
	short s1
	char * t2
PREINIT:
	double(*func)(float, short, char *);
CODE:
	func   = INT2PTR(double(*)(float, short, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, t2);
OUTPUT:
	RETVAL

short
nci_sfst( c_func, f0, s1, t2 )
	SV* c_func
	float f0
	short s1
	char * t2
PREINIT:
	short(*func)(float, short, char *);
CODE:
	func   = INT2PTR(short(*)(float, short, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, t2);
OUTPUT:
	RETVAL

float
nci_ffst( c_func, f0, s1, t2 )
	SV* c_func
	float f0
	short s1
	char * t2
PREINIT:
	float(*func)(float, short, char *);
CODE:
	func   = INT2PTR(float(*)(float, short, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, t2);
OUTPUT:
	RETVAL

char *
nci_tfst( c_func, f0, s1, t2 )
	SV* c_func
	float f0
	short s1
	char * t2
PREINIT:
	char *(*func)(float, short, char *);
CODE:
	func   = INT2PTR(char *(*)(float, short, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, t2);
OUTPUT:
	RETVAL

int
nci_ifst( c_func, f0, s1, t2 )
	SV* c_func
	float f0
	short s1
	char * t2
PREINIT:
	int(*func)(float, short, char *);
CODE:
	func   = INT2PTR(int(*)(float, short, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, t2);
OUTPUT:
	RETVAL

void *
nci_ptst( c_func, t0, s1, t2 )
	SV* c_func
	char * t0
	short s1
	char * t2
PREINIT:
	void *(*func)(char *, short, char *);
CODE:
	func   = INT2PTR(void *(*)(char *, short, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, t2);
OUTPUT:
	RETVAL

void
nci_vtst( c_func, t0, s1, t2 )
	SV* c_func
	char * t0
	short s1
	char * t2
PREINIT:
	void(*func)(char *, short, char *);
CODE:
	func   = INT2PTR(void(*)(char *, short, char *), SvIV(c_func) );
	(*func)(t0, s1, t2);

double
nci_dtst( c_func, t0, s1, t2 )
	SV* c_func
	char * t0
	short s1
	char * t2
PREINIT:
	double(*func)(char *, short, char *);
CODE:
	func   = INT2PTR(double(*)(char *, short, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, t2);
OUTPUT:
	RETVAL

short
nci_stst( c_func, t0, s1, t2 )
	SV* c_func
	char * t0
	short s1
	char * t2
PREINIT:
	short(*func)(char *, short, char *);
CODE:
	func   = INT2PTR(short(*)(char *, short, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, t2);
OUTPUT:
	RETVAL

float
nci_ftst( c_func, t0, s1, t2 )
	SV* c_func
	char * t0
	short s1
	char * t2
PREINIT:
	float(*func)(char *, short, char *);
CODE:
	func   = INT2PTR(float(*)(char *, short, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, t2);
OUTPUT:
	RETVAL

char *
nci_ttst( c_func, t0, s1, t2 )
	SV* c_func
	char * t0
	short s1
	char * t2
PREINIT:
	char *(*func)(char *, short, char *);
CODE:
	func   = INT2PTR(char *(*)(char *, short, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, t2);
OUTPUT:
	RETVAL

int
nci_itst( c_func, t0, s1, t2 )
	SV* c_func
	char * t0
	short s1
	char * t2
PREINIT:
	int(*func)(char *, short, char *);
CODE:
	func   = INT2PTR(int(*)(char *, short, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, t2);
OUTPUT:
	RETVAL

void *
nci_pist( c_func, i0, s1, t2 )
	SV* c_func
	int i0
	short s1
	char * t2
PREINIT:
	void *(*func)(int, short, char *);
CODE:
	func   = INT2PTR(void *(*)(int, short, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, t2);
OUTPUT:
	RETVAL

void
nci_vist( c_func, i0, s1, t2 )
	SV* c_func
	int i0
	short s1
	char * t2
PREINIT:
	void(*func)(int, short, char *);
CODE:
	func   = INT2PTR(void(*)(int, short, char *), SvIV(c_func) );
	(*func)(i0, s1, t2);

double
nci_dist( c_func, i0, s1, t2 )
	SV* c_func
	int i0
	short s1
	char * t2
PREINIT:
	double(*func)(int, short, char *);
CODE:
	func   = INT2PTR(double(*)(int, short, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, t2);
OUTPUT:
	RETVAL

short
nci_sist( c_func, i0, s1, t2 )
	SV* c_func
	int i0
	short s1
	char * t2
PREINIT:
	short(*func)(int, short, char *);
CODE:
	func   = INT2PTR(short(*)(int, short, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, t2);
OUTPUT:
	RETVAL

float
nci_fist( c_func, i0, s1, t2 )
	SV* c_func
	int i0
	short s1
	char * t2
PREINIT:
	float(*func)(int, short, char *);
CODE:
	func   = INT2PTR(float(*)(int, short, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, t2);
OUTPUT:
	RETVAL

char *
nci_tist( c_func, i0, s1, t2 )
	SV* c_func
	int i0
	short s1
	char * t2
PREINIT:
	char *(*func)(int, short, char *);
CODE:
	func   = INT2PTR(char *(*)(int, short, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, t2);
OUTPUT:
	RETVAL

int
nci_iist( c_func, i0, s1, t2 )
	SV* c_func
	int i0
	short s1
	char * t2
PREINIT:
	int(*func)(int, short, char *);
CODE:
	func   = INT2PTR(int(*)(int, short, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, t2);
OUTPUT:
	RETVAL

void *
nci_ppft( c_func, p0, f1, t2 )
	SV* c_func
	void * p0
	float f1
	char * t2
PREINIT:
	void *(*func)(void *, float, char *);
CODE:
	func   = INT2PTR(void *(*)(void *, float, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, t2);
OUTPUT:
	RETVAL

void
nci_vpft( c_func, p0, f1, t2 )
	SV* c_func
	void * p0
	float f1
	char * t2
PREINIT:
	void(*func)(void *, float, char *);
CODE:
	func   = INT2PTR(void(*)(void *, float, char *), SvIV(c_func) );
	(*func)(p0, f1, t2);

double
nci_dpft( c_func, p0, f1, t2 )
	SV* c_func
	void * p0
	float f1
	char * t2
PREINIT:
	double(*func)(void *, float, char *);
CODE:
	func   = INT2PTR(double(*)(void *, float, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, t2);
OUTPUT:
	RETVAL

short
nci_spft( c_func, p0, f1, t2 )
	SV* c_func
	void * p0
	float f1
	char * t2
PREINIT:
	short(*func)(void *, float, char *);
CODE:
	func   = INT2PTR(short(*)(void *, float, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, t2);
OUTPUT:
	RETVAL

float
nci_fpft( c_func, p0, f1, t2 )
	SV* c_func
	void * p0
	float f1
	char * t2
PREINIT:
	float(*func)(void *, float, char *);
CODE:
	func   = INT2PTR(float(*)(void *, float, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, t2);
OUTPUT:
	RETVAL

char *
nci_tpft( c_func, p0, f1, t2 )
	SV* c_func
	void * p0
	float f1
	char * t2
PREINIT:
	char *(*func)(void *, float, char *);
CODE:
	func   = INT2PTR(char *(*)(void *, float, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, t2);
OUTPUT:
	RETVAL

int
nci_ipft( c_func, p0, f1, t2 )
	SV* c_func
	void * p0
	float f1
	char * t2
PREINIT:
	int(*func)(void *, float, char *);
CODE:
	func   = INT2PTR(int(*)(void *, float, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, t2);
OUTPUT:
	RETVAL

void *
nci_pvft( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvft( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvft( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svft( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvft( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvft( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivft( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdft( c_func, d0, f1, t2 )
	SV* c_func
	double d0
	float f1
	char * t2
PREINIT:
	void *(*func)(double, float, char *);
CODE:
	func   = INT2PTR(void *(*)(double, float, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, t2);
OUTPUT:
	RETVAL

void
nci_vdft( c_func, d0, f1, t2 )
	SV* c_func
	double d0
	float f1
	char * t2
PREINIT:
	void(*func)(double, float, char *);
CODE:
	func   = INT2PTR(void(*)(double, float, char *), SvIV(c_func) );
	(*func)(d0, f1, t2);

double
nci_ddft( c_func, d0, f1, t2 )
	SV* c_func
	double d0
	float f1
	char * t2
PREINIT:
	double(*func)(double, float, char *);
CODE:
	func   = INT2PTR(double(*)(double, float, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, t2);
OUTPUT:
	RETVAL

short
nci_sdft( c_func, d0, f1, t2 )
	SV* c_func
	double d0
	float f1
	char * t2
PREINIT:
	short(*func)(double, float, char *);
CODE:
	func   = INT2PTR(short(*)(double, float, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, t2);
OUTPUT:
	RETVAL

float
nci_fdft( c_func, d0, f1, t2 )
	SV* c_func
	double d0
	float f1
	char * t2
PREINIT:
	float(*func)(double, float, char *);
CODE:
	func   = INT2PTR(float(*)(double, float, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, t2);
OUTPUT:
	RETVAL

char *
nci_tdft( c_func, d0, f1, t2 )
	SV* c_func
	double d0
	float f1
	char * t2
PREINIT:
	char *(*func)(double, float, char *);
CODE:
	func   = INT2PTR(char *(*)(double, float, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, t2);
OUTPUT:
	RETVAL

int
nci_idft( c_func, d0, f1, t2 )
	SV* c_func
	double d0
	float f1
	char * t2
PREINIT:
	int(*func)(double, float, char *);
CODE:
	func   = INT2PTR(int(*)(double, float, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, t2);
OUTPUT:
	RETVAL

void *
nci_psft( c_func, s0, f1, t2 )
	SV* c_func
	short s0
	float f1
	char * t2
PREINIT:
	void *(*func)(short, float, char *);
CODE:
	func   = INT2PTR(void *(*)(short, float, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, t2);
OUTPUT:
	RETVAL

void
nci_vsft( c_func, s0, f1, t2 )
	SV* c_func
	short s0
	float f1
	char * t2
PREINIT:
	void(*func)(short, float, char *);
CODE:
	func   = INT2PTR(void(*)(short, float, char *), SvIV(c_func) );
	(*func)(s0, f1, t2);

double
nci_dsft( c_func, s0, f1, t2 )
	SV* c_func
	short s0
	float f1
	char * t2
PREINIT:
	double(*func)(short, float, char *);
CODE:
	func   = INT2PTR(double(*)(short, float, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, t2);
OUTPUT:
	RETVAL

short
nci_ssft( c_func, s0, f1, t2 )
	SV* c_func
	short s0
	float f1
	char * t2
PREINIT:
	short(*func)(short, float, char *);
CODE:
	func   = INT2PTR(short(*)(short, float, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, t2);
OUTPUT:
	RETVAL

float
nci_fsft( c_func, s0, f1, t2 )
	SV* c_func
	short s0
	float f1
	char * t2
PREINIT:
	float(*func)(short, float, char *);
CODE:
	func   = INT2PTR(float(*)(short, float, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, t2);
OUTPUT:
	RETVAL

char *
nci_tsft( c_func, s0, f1, t2 )
	SV* c_func
	short s0
	float f1
	char * t2
PREINIT:
	char *(*func)(short, float, char *);
CODE:
	func   = INT2PTR(char *(*)(short, float, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, t2);
OUTPUT:
	RETVAL

int
nci_isft( c_func, s0, f1, t2 )
	SV* c_func
	short s0
	float f1
	char * t2
PREINIT:
	int(*func)(short, float, char *);
CODE:
	func   = INT2PTR(int(*)(short, float, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, t2);
OUTPUT:
	RETVAL

void *
nci_pfft( c_func, f0, f1, t2 )
	SV* c_func
	float f0
	float f1
	char * t2
PREINIT:
	void *(*func)(float, float, char *);
CODE:
	func   = INT2PTR(void *(*)(float, float, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, t2);
OUTPUT:
	RETVAL

void
nci_vfft( c_func, f0, f1, t2 )
	SV* c_func
	float f0
	float f1
	char * t2
PREINIT:
	void(*func)(float, float, char *);
CODE:
	func   = INT2PTR(void(*)(float, float, char *), SvIV(c_func) );
	(*func)(f0, f1, t2);

double
nci_dfft( c_func, f0, f1, t2 )
	SV* c_func
	float f0
	float f1
	char * t2
PREINIT:
	double(*func)(float, float, char *);
CODE:
	func   = INT2PTR(double(*)(float, float, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, t2);
OUTPUT:
	RETVAL

short
nci_sfft( c_func, f0, f1, t2 )
	SV* c_func
	float f0
	float f1
	char * t2
PREINIT:
	short(*func)(float, float, char *);
CODE:
	func   = INT2PTR(short(*)(float, float, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, t2);
OUTPUT:
	RETVAL

float
nci_ffft( c_func, f0, f1, t2 )
	SV* c_func
	float f0
	float f1
	char * t2
PREINIT:
	float(*func)(float, float, char *);
CODE:
	func   = INT2PTR(float(*)(float, float, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, t2);
OUTPUT:
	RETVAL

char *
nci_tfft( c_func, f0, f1, t2 )
	SV* c_func
	float f0
	float f1
	char * t2
PREINIT:
	char *(*func)(float, float, char *);
CODE:
	func   = INT2PTR(char *(*)(float, float, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, t2);
OUTPUT:
	RETVAL

int
nci_ifft( c_func, f0, f1, t2 )
	SV* c_func
	float f0
	float f1
	char * t2
PREINIT:
	int(*func)(float, float, char *);
CODE:
	func   = INT2PTR(int(*)(float, float, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, t2);
OUTPUT:
	RETVAL

void *
nci_ptft( c_func, t0, f1, t2 )
	SV* c_func
	char * t0
	float f1
	char * t2
PREINIT:
	void *(*func)(char *, float, char *);
CODE:
	func   = INT2PTR(void *(*)(char *, float, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, t2);
OUTPUT:
	RETVAL

void
nci_vtft( c_func, t0, f1, t2 )
	SV* c_func
	char * t0
	float f1
	char * t2
PREINIT:
	void(*func)(char *, float, char *);
CODE:
	func   = INT2PTR(void(*)(char *, float, char *), SvIV(c_func) );
	(*func)(t0, f1, t2);

double
nci_dtft( c_func, t0, f1, t2 )
	SV* c_func
	char * t0
	float f1
	char * t2
PREINIT:
	double(*func)(char *, float, char *);
CODE:
	func   = INT2PTR(double(*)(char *, float, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, t2);
OUTPUT:
	RETVAL

short
nci_stft( c_func, t0, f1, t2 )
	SV* c_func
	char * t0
	float f1
	char * t2
PREINIT:
	short(*func)(char *, float, char *);
CODE:
	func   = INT2PTR(short(*)(char *, float, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, t2);
OUTPUT:
	RETVAL

float
nci_ftft( c_func, t0, f1, t2 )
	SV* c_func
	char * t0
	float f1
	char * t2
PREINIT:
	float(*func)(char *, float, char *);
CODE:
	func   = INT2PTR(float(*)(char *, float, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, t2);
OUTPUT:
	RETVAL

char *
nci_ttft( c_func, t0, f1, t2 )
	SV* c_func
	char * t0
	float f1
	char * t2
PREINIT:
	char *(*func)(char *, float, char *);
CODE:
	func   = INT2PTR(char *(*)(char *, float, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, t2);
OUTPUT:
	RETVAL

int
nci_itft( c_func, t0, f1, t2 )
	SV* c_func
	char * t0
	float f1
	char * t2
PREINIT:
	int(*func)(char *, float, char *);
CODE:
	func   = INT2PTR(int(*)(char *, float, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, t2);
OUTPUT:
	RETVAL

void *
nci_pift( c_func, i0, f1, t2 )
	SV* c_func
	int i0
	float f1
	char * t2
PREINIT:
	void *(*func)(int, float, char *);
CODE:
	func   = INT2PTR(void *(*)(int, float, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, t2);
OUTPUT:
	RETVAL

void
nci_vift( c_func, i0, f1, t2 )
	SV* c_func
	int i0
	float f1
	char * t2
PREINIT:
	void(*func)(int, float, char *);
CODE:
	func   = INT2PTR(void(*)(int, float, char *), SvIV(c_func) );
	(*func)(i0, f1, t2);

double
nci_dift( c_func, i0, f1, t2 )
	SV* c_func
	int i0
	float f1
	char * t2
PREINIT:
	double(*func)(int, float, char *);
CODE:
	func   = INT2PTR(double(*)(int, float, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, t2);
OUTPUT:
	RETVAL

short
nci_sift( c_func, i0, f1, t2 )
	SV* c_func
	int i0
	float f1
	char * t2
PREINIT:
	short(*func)(int, float, char *);
CODE:
	func   = INT2PTR(short(*)(int, float, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, t2);
OUTPUT:
	RETVAL

float
nci_fift( c_func, i0, f1, t2 )
	SV* c_func
	int i0
	float f1
	char * t2
PREINIT:
	float(*func)(int, float, char *);
CODE:
	func   = INT2PTR(float(*)(int, float, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, t2);
OUTPUT:
	RETVAL

char *
nci_tift( c_func, i0, f1, t2 )
	SV* c_func
	int i0
	float f1
	char * t2
PREINIT:
	char *(*func)(int, float, char *);
CODE:
	func   = INT2PTR(char *(*)(int, float, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, t2);
OUTPUT:
	RETVAL

int
nci_iift( c_func, i0, f1, t2 )
	SV* c_func
	int i0
	float f1
	char * t2
PREINIT:
	int(*func)(int, float, char *);
CODE:
	func   = INT2PTR(int(*)(int, float, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, t2);
OUTPUT:
	RETVAL

void *
nci_pptt( c_func, p0, t1, t2 )
	SV* c_func
	void * p0
	char * t1
	char * t2
PREINIT:
	void *(*func)(void *, char *, char *);
CODE:
	func   = INT2PTR(void *(*)(void *, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, t2);
OUTPUT:
	RETVAL

void
nci_vptt( c_func, p0, t1, t2 )
	SV* c_func
	void * p0
	char * t1
	char * t2
PREINIT:
	void(*func)(void *, char *, char *);
CODE:
	func   = INT2PTR(void(*)(void *, char *, char *), SvIV(c_func) );
	(*func)(p0, t1, t2);

double
nci_dptt( c_func, p0, t1, t2 )
	SV* c_func
	void * p0
	char * t1
	char * t2
PREINIT:
	double(*func)(void *, char *, char *);
CODE:
	func   = INT2PTR(double(*)(void *, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, t2);
OUTPUT:
	RETVAL

short
nci_sptt( c_func, p0, t1, t2 )
	SV* c_func
	void * p0
	char * t1
	char * t2
PREINIT:
	short(*func)(void *, char *, char *);
CODE:
	func   = INT2PTR(short(*)(void *, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, t2);
OUTPUT:
	RETVAL

float
nci_fptt( c_func, p0, t1, t2 )
	SV* c_func
	void * p0
	char * t1
	char * t2
PREINIT:
	float(*func)(void *, char *, char *);
CODE:
	func   = INT2PTR(float(*)(void *, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, t2);
OUTPUT:
	RETVAL

char *
nci_tptt( c_func, p0, t1, t2 )
	SV* c_func
	void * p0
	char * t1
	char * t2
PREINIT:
	char *(*func)(void *, char *, char *);
CODE:
	func   = INT2PTR(char *(*)(void *, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, t2);
OUTPUT:
	RETVAL

int
nci_iptt( c_func, p0, t1, t2 )
	SV* c_func
	void * p0
	char * t1
	char * t2
PREINIT:
	int(*func)(void *, char *, char *);
CODE:
	func   = INT2PTR(int(*)(void *, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, t2);
OUTPUT:
	RETVAL

void *
nci_pvtt( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvtt( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvtt( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svtt( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvtt( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvtt( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivtt( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdtt( c_func, d0, t1, t2 )
	SV* c_func
	double d0
	char * t1
	char * t2
PREINIT:
	void *(*func)(double, char *, char *);
CODE:
	func   = INT2PTR(void *(*)(double, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, t2);
OUTPUT:
	RETVAL

void
nci_vdtt( c_func, d0, t1, t2 )
	SV* c_func
	double d0
	char * t1
	char * t2
PREINIT:
	void(*func)(double, char *, char *);
CODE:
	func   = INT2PTR(void(*)(double, char *, char *), SvIV(c_func) );
	(*func)(d0, t1, t2);

double
nci_ddtt( c_func, d0, t1, t2 )
	SV* c_func
	double d0
	char * t1
	char * t2
PREINIT:
	double(*func)(double, char *, char *);
CODE:
	func   = INT2PTR(double(*)(double, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, t2);
OUTPUT:
	RETVAL

short
nci_sdtt( c_func, d0, t1, t2 )
	SV* c_func
	double d0
	char * t1
	char * t2
PREINIT:
	short(*func)(double, char *, char *);
CODE:
	func   = INT2PTR(short(*)(double, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, t2);
OUTPUT:
	RETVAL

float
nci_fdtt( c_func, d0, t1, t2 )
	SV* c_func
	double d0
	char * t1
	char * t2
PREINIT:
	float(*func)(double, char *, char *);
CODE:
	func   = INT2PTR(float(*)(double, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, t2);
OUTPUT:
	RETVAL

char *
nci_tdtt( c_func, d0, t1, t2 )
	SV* c_func
	double d0
	char * t1
	char * t2
PREINIT:
	char *(*func)(double, char *, char *);
CODE:
	func   = INT2PTR(char *(*)(double, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, t2);
OUTPUT:
	RETVAL

int
nci_idtt( c_func, d0, t1, t2 )
	SV* c_func
	double d0
	char * t1
	char * t2
PREINIT:
	int(*func)(double, char *, char *);
CODE:
	func   = INT2PTR(int(*)(double, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, t2);
OUTPUT:
	RETVAL

void *
nci_pstt( c_func, s0, t1, t2 )
	SV* c_func
	short s0
	char * t1
	char * t2
PREINIT:
	void *(*func)(short, char *, char *);
CODE:
	func   = INT2PTR(void *(*)(short, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, t2);
OUTPUT:
	RETVAL

void
nci_vstt( c_func, s0, t1, t2 )
	SV* c_func
	short s0
	char * t1
	char * t2
PREINIT:
	void(*func)(short, char *, char *);
CODE:
	func   = INT2PTR(void(*)(short, char *, char *), SvIV(c_func) );
	(*func)(s0, t1, t2);

double
nci_dstt( c_func, s0, t1, t2 )
	SV* c_func
	short s0
	char * t1
	char * t2
PREINIT:
	double(*func)(short, char *, char *);
CODE:
	func   = INT2PTR(double(*)(short, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, t2);
OUTPUT:
	RETVAL

short
nci_sstt( c_func, s0, t1, t2 )
	SV* c_func
	short s0
	char * t1
	char * t2
PREINIT:
	short(*func)(short, char *, char *);
CODE:
	func   = INT2PTR(short(*)(short, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, t2);
OUTPUT:
	RETVAL

float
nci_fstt( c_func, s0, t1, t2 )
	SV* c_func
	short s0
	char * t1
	char * t2
PREINIT:
	float(*func)(short, char *, char *);
CODE:
	func   = INT2PTR(float(*)(short, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, t2);
OUTPUT:
	RETVAL

char *
nci_tstt( c_func, s0, t1, t2 )
	SV* c_func
	short s0
	char * t1
	char * t2
PREINIT:
	char *(*func)(short, char *, char *);
CODE:
	func   = INT2PTR(char *(*)(short, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, t2);
OUTPUT:
	RETVAL

int
nci_istt( c_func, s0, t1, t2 )
	SV* c_func
	short s0
	char * t1
	char * t2
PREINIT:
	int(*func)(short, char *, char *);
CODE:
	func   = INT2PTR(int(*)(short, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, t2);
OUTPUT:
	RETVAL

void *
nci_pftt( c_func, f0, t1, t2 )
	SV* c_func
	float f0
	char * t1
	char * t2
PREINIT:
	void *(*func)(float, char *, char *);
CODE:
	func   = INT2PTR(void *(*)(float, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, t2);
OUTPUT:
	RETVAL

void
nci_vftt( c_func, f0, t1, t2 )
	SV* c_func
	float f0
	char * t1
	char * t2
PREINIT:
	void(*func)(float, char *, char *);
CODE:
	func   = INT2PTR(void(*)(float, char *, char *), SvIV(c_func) );
	(*func)(f0, t1, t2);

double
nci_dftt( c_func, f0, t1, t2 )
	SV* c_func
	float f0
	char * t1
	char * t2
PREINIT:
	double(*func)(float, char *, char *);
CODE:
	func   = INT2PTR(double(*)(float, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, t2);
OUTPUT:
	RETVAL

short
nci_sftt( c_func, f0, t1, t2 )
	SV* c_func
	float f0
	char * t1
	char * t2
PREINIT:
	short(*func)(float, char *, char *);
CODE:
	func   = INT2PTR(short(*)(float, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, t2);
OUTPUT:
	RETVAL

float
nci_fftt( c_func, f0, t1, t2 )
	SV* c_func
	float f0
	char * t1
	char * t2
PREINIT:
	float(*func)(float, char *, char *);
CODE:
	func   = INT2PTR(float(*)(float, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, t2);
OUTPUT:
	RETVAL

char *
nci_tftt( c_func, f0, t1, t2 )
	SV* c_func
	float f0
	char * t1
	char * t2
PREINIT:
	char *(*func)(float, char *, char *);
CODE:
	func   = INT2PTR(char *(*)(float, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, t2);
OUTPUT:
	RETVAL

int
nci_iftt( c_func, f0, t1, t2 )
	SV* c_func
	float f0
	char * t1
	char * t2
PREINIT:
	int(*func)(float, char *, char *);
CODE:
	func   = INT2PTR(int(*)(float, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, t2);
OUTPUT:
	RETVAL

void *
nci_pttt( c_func, t0, t1, t2 )
	SV* c_func
	char * t0
	char * t1
	char * t2
PREINIT:
	void *(*func)(char *, char *, char *);
CODE:
	func   = INT2PTR(void *(*)(char *, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, t2);
OUTPUT:
	RETVAL

void
nci_vttt( c_func, t0, t1, t2 )
	SV* c_func
	char * t0
	char * t1
	char * t2
PREINIT:
	void(*func)(char *, char *, char *);
CODE:
	func   = INT2PTR(void(*)(char *, char *, char *), SvIV(c_func) );
	(*func)(t0, t1, t2);

double
nci_dttt( c_func, t0, t1, t2 )
	SV* c_func
	char * t0
	char * t1
	char * t2
PREINIT:
	double(*func)(char *, char *, char *);
CODE:
	func   = INT2PTR(double(*)(char *, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, t2);
OUTPUT:
	RETVAL

short
nci_sttt( c_func, t0, t1, t2 )
	SV* c_func
	char * t0
	char * t1
	char * t2
PREINIT:
	short(*func)(char *, char *, char *);
CODE:
	func   = INT2PTR(short(*)(char *, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, t2);
OUTPUT:
	RETVAL

float
nci_fttt( c_func, t0, t1, t2 )
	SV* c_func
	char * t0
	char * t1
	char * t2
PREINIT:
	float(*func)(char *, char *, char *);
CODE:
	func   = INT2PTR(float(*)(char *, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, t2);
OUTPUT:
	RETVAL

char *
nci_tttt( c_func, t0, t1, t2 )
	SV* c_func
	char * t0
	char * t1
	char * t2
PREINIT:
	char *(*func)(char *, char *, char *);
CODE:
	func   = INT2PTR(char *(*)(char *, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, t2);
OUTPUT:
	RETVAL

int
nci_ittt( c_func, t0, t1, t2 )
	SV* c_func
	char * t0
	char * t1
	char * t2
PREINIT:
	int(*func)(char *, char *, char *);
CODE:
	func   = INT2PTR(int(*)(char *, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, t2);
OUTPUT:
	RETVAL

void *
nci_pitt( c_func, i0, t1, t2 )
	SV* c_func
	int i0
	char * t1
	char * t2
PREINIT:
	void *(*func)(int, char *, char *);
CODE:
	func   = INT2PTR(void *(*)(int, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, t2);
OUTPUT:
	RETVAL

void
nci_vitt( c_func, i0, t1, t2 )
	SV* c_func
	int i0
	char * t1
	char * t2
PREINIT:
	void(*func)(int, char *, char *);
CODE:
	func   = INT2PTR(void(*)(int, char *, char *), SvIV(c_func) );
	(*func)(i0, t1, t2);

double
nci_ditt( c_func, i0, t1, t2 )
	SV* c_func
	int i0
	char * t1
	char * t2
PREINIT:
	double(*func)(int, char *, char *);
CODE:
	func   = INT2PTR(double(*)(int, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, t2);
OUTPUT:
	RETVAL

short
nci_sitt( c_func, i0, t1, t2 )
	SV* c_func
	int i0
	char * t1
	char * t2
PREINIT:
	short(*func)(int, char *, char *);
CODE:
	func   = INT2PTR(short(*)(int, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, t2);
OUTPUT:
	RETVAL

float
nci_fitt( c_func, i0, t1, t2 )
	SV* c_func
	int i0
	char * t1
	char * t2
PREINIT:
	float(*func)(int, char *, char *);
CODE:
	func   = INT2PTR(float(*)(int, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, t2);
OUTPUT:
	RETVAL

char *
nci_titt( c_func, i0, t1, t2 )
	SV* c_func
	int i0
	char * t1
	char * t2
PREINIT:
	char *(*func)(int, char *, char *);
CODE:
	func   = INT2PTR(char *(*)(int, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, t2);
OUTPUT:
	RETVAL

int
nci_iitt( c_func, i0, t1, t2 )
	SV* c_func
	int i0
	char * t1
	char * t2
PREINIT:
	int(*func)(int, char *, char *);
CODE:
	func   = INT2PTR(int(*)(int, char *, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, t2);
OUTPUT:
	RETVAL

void *
nci_ppit( c_func, p0, i1, t2 )
	SV* c_func
	void * p0
	int i1
	char * t2
PREINIT:
	void *(*func)(void *, int, char *);
CODE:
	func   = INT2PTR(void *(*)(void *, int, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, t2);
OUTPUT:
	RETVAL

void
nci_vpit( c_func, p0, i1, t2 )
	SV* c_func
	void * p0
	int i1
	char * t2
PREINIT:
	void(*func)(void *, int, char *);
CODE:
	func   = INT2PTR(void(*)(void *, int, char *), SvIV(c_func) );
	(*func)(p0, i1, t2);

double
nci_dpit( c_func, p0, i1, t2 )
	SV* c_func
	void * p0
	int i1
	char * t2
PREINIT:
	double(*func)(void *, int, char *);
CODE:
	func   = INT2PTR(double(*)(void *, int, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, t2);
OUTPUT:
	RETVAL

short
nci_spit( c_func, p0, i1, t2 )
	SV* c_func
	void * p0
	int i1
	char * t2
PREINIT:
	short(*func)(void *, int, char *);
CODE:
	func   = INT2PTR(short(*)(void *, int, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, t2);
OUTPUT:
	RETVAL

float
nci_fpit( c_func, p0, i1, t2 )
	SV* c_func
	void * p0
	int i1
	char * t2
PREINIT:
	float(*func)(void *, int, char *);
CODE:
	func   = INT2PTR(float(*)(void *, int, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, t2);
OUTPUT:
	RETVAL

char *
nci_tpit( c_func, p0, i1, t2 )
	SV* c_func
	void * p0
	int i1
	char * t2
PREINIT:
	char *(*func)(void *, int, char *);
CODE:
	func   = INT2PTR(char *(*)(void *, int, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, t2);
OUTPUT:
	RETVAL

int
nci_ipit( c_func, p0, i1, t2 )
	SV* c_func
	void * p0
	int i1
	char * t2
PREINIT:
	int(*func)(void *, int, char *);
CODE:
	func   = INT2PTR(int(*)(void *, int, char *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, t2);
OUTPUT:
	RETVAL

void *
nci_pvit( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvit( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvit( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svit( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvit( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvit( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivit( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdit( c_func, d0, i1, t2 )
	SV* c_func
	double d0
	int i1
	char * t2
PREINIT:
	void *(*func)(double, int, char *);
CODE:
	func   = INT2PTR(void *(*)(double, int, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, t2);
OUTPUT:
	RETVAL

void
nci_vdit( c_func, d0, i1, t2 )
	SV* c_func
	double d0
	int i1
	char * t2
PREINIT:
	void(*func)(double, int, char *);
CODE:
	func   = INT2PTR(void(*)(double, int, char *), SvIV(c_func) );
	(*func)(d0, i1, t2);

double
nci_ddit( c_func, d0, i1, t2 )
	SV* c_func
	double d0
	int i1
	char * t2
PREINIT:
	double(*func)(double, int, char *);
CODE:
	func   = INT2PTR(double(*)(double, int, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, t2);
OUTPUT:
	RETVAL

short
nci_sdit( c_func, d0, i1, t2 )
	SV* c_func
	double d0
	int i1
	char * t2
PREINIT:
	short(*func)(double, int, char *);
CODE:
	func   = INT2PTR(short(*)(double, int, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, t2);
OUTPUT:
	RETVAL

float
nci_fdit( c_func, d0, i1, t2 )
	SV* c_func
	double d0
	int i1
	char * t2
PREINIT:
	float(*func)(double, int, char *);
CODE:
	func   = INT2PTR(float(*)(double, int, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, t2);
OUTPUT:
	RETVAL

char *
nci_tdit( c_func, d0, i1, t2 )
	SV* c_func
	double d0
	int i1
	char * t2
PREINIT:
	char *(*func)(double, int, char *);
CODE:
	func   = INT2PTR(char *(*)(double, int, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, t2);
OUTPUT:
	RETVAL

int
nci_idit( c_func, d0, i1, t2 )
	SV* c_func
	double d0
	int i1
	char * t2
PREINIT:
	int(*func)(double, int, char *);
CODE:
	func   = INT2PTR(int(*)(double, int, char *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, t2);
OUTPUT:
	RETVAL

void *
nci_psit( c_func, s0, i1, t2 )
	SV* c_func
	short s0
	int i1
	char * t2
PREINIT:
	void *(*func)(short, int, char *);
CODE:
	func   = INT2PTR(void *(*)(short, int, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, t2);
OUTPUT:
	RETVAL

void
nci_vsit( c_func, s0, i1, t2 )
	SV* c_func
	short s0
	int i1
	char * t2
PREINIT:
	void(*func)(short, int, char *);
CODE:
	func   = INT2PTR(void(*)(short, int, char *), SvIV(c_func) );
	(*func)(s0, i1, t2);

double
nci_dsit( c_func, s0, i1, t2 )
	SV* c_func
	short s0
	int i1
	char * t2
PREINIT:
	double(*func)(short, int, char *);
CODE:
	func   = INT2PTR(double(*)(short, int, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, t2);
OUTPUT:
	RETVAL

short
nci_ssit( c_func, s0, i1, t2 )
	SV* c_func
	short s0
	int i1
	char * t2
PREINIT:
	short(*func)(short, int, char *);
CODE:
	func   = INT2PTR(short(*)(short, int, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, t2);
OUTPUT:
	RETVAL

float
nci_fsit( c_func, s0, i1, t2 )
	SV* c_func
	short s0
	int i1
	char * t2
PREINIT:
	float(*func)(short, int, char *);
CODE:
	func   = INT2PTR(float(*)(short, int, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, t2);
OUTPUT:
	RETVAL

char *
nci_tsit( c_func, s0, i1, t2 )
	SV* c_func
	short s0
	int i1
	char * t2
PREINIT:
	char *(*func)(short, int, char *);
CODE:
	func   = INT2PTR(char *(*)(short, int, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, t2);
OUTPUT:
	RETVAL

int
nci_isit( c_func, s0, i1, t2 )
	SV* c_func
	short s0
	int i1
	char * t2
PREINIT:
	int(*func)(short, int, char *);
CODE:
	func   = INT2PTR(int(*)(short, int, char *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, t2);
OUTPUT:
	RETVAL

void *
nci_pfit( c_func, f0, i1, t2 )
	SV* c_func
	float f0
	int i1
	char * t2
PREINIT:
	void *(*func)(float, int, char *);
CODE:
	func   = INT2PTR(void *(*)(float, int, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, t2);
OUTPUT:
	RETVAL

void
nci_vfit( c_func, f0, i1, t2 )
	SV* c_func
	float f0
	int i1
	char * t2
PREINIT:
	void(*func)(float, int, char *);
CODE:
	func   = INT2PTR(void(*)(float, int, char *), SvIV(c_func) );
	(*func)(f0, i1, t2);

double
nci_dfit( c_func, f0, i1, t2 )
	SV* c_func
	float f0
	int i1
	char * t2
PREINIT:
	double(*func)(float, int, char *);
CODE:
	func   = INT2PTR(double(*)(float, int, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, t2);
OUTPUT:
	RETVAL

short
nci_sfit( c_func, f0, i1, t2 )
	SV* c_func
	float f0
	int i1
	char * t2
PREINIT:
	short(*func)(float, int, char *);
CODE:
	func   = INT2PTR(short(*)(float, int, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, t2);
OUTPUT:
	RETVAL

float
nci_ffit( c_func, f0, i1, t2 )
	SV* c_func
	float f0
	int i1
	char * t2
PREINIT:
	float(*func)(float, int, char *);
CODE:
	func   = INT2PTR(float(*)(float, int, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, t2);
OUTPUT:
	RETVAL

char *
nci_tfit( c_func, f0, i1, t2 )
	SV* c_func
	float f0
	int i1
	char * t2
PREINIT:
	char *(*func)(float, int, char *);
CODE:
	func   = INT2PTR(char *(*)(float, int, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, t2);
OUTPUT:
	RETVAL

int
nci_ifit( c_func, f0, i1, t2 )
	SV* c_func
	float f0
	int i1
	char * t2
PREINIT:
	int(*func)(float, int, char *);
CODE:
	func   = INT2PTR(int(*)(float, int, char *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, t2);
OUTPUT:
	RETVAL

void *
nci_ptit( c_func, t0, i1, t2 )
	SV* c_func
	char * t0
	int i1
	char * t2
PREINIT:
	void *(*func)(char *, int, char *);
CODE:
	func   = INT2PTR(void *(*)(char *, int, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, t2);
OUTPUT:
	RETVAL

void
nci_vtit( c_func, t0, i1, t2 )
	SV* c_func
	char * t0
	int i1
	char * t2
PREINIT:
	void(*func)(char *, int, char *);
CODE:
	func   = INT2PTR(void(*)(char *, int, char *), SvIV(c_func) );
	(*func)(t0, i1, t2);

double
nci_dtit( c_func, t0, i1, t2 )
	SV* c_func
	char * t0
	int i1
	char * t2
PREINIT:
	double(*func)(char *, int, char *);
CODE:
	func   = INT2PTR(double(*)(char *, int, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, t2);
OUTPUT:
	RETVAL

short
nci_stit( c_func, t0, i1, t2 )
	SV* c_func
	char * t0
	int i1
	char * t2
PREINIT:
	short(*func)(char *, int, char *);
CODE:
	func   = INT2PTR(short(*)(char *, int, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, t2);
OUTPUT:
	RETVAL

float
nci_ftit( c_func, t0, i1, t2 )
	SV* c_func
	char * t0
	int i1
	char * t2
PREINIT:
	float(*func)(char *, int, char *);
CODE:
	func   = INT2PTR(float(*)(char *, int, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, t2);
OUTPUT:
	RETVAL

char *
nci_ttit( c_func, t0, i1, t2 )
	SV* c_func
	char * t0
	int i1
	char * t2
PREINIT:
	char *(*func)(char *, int, char *);
CODE:
	func   = INT2PTR(char *(*)(char *, int, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, t2);
OUTPUT:
	RETVAL

int
nci_itit( c_func, t0, i1, t2 )
	SV* c_func
	char * t0
	int i1
	char * t2
PREINIT:
	int(*func)(char *, int, char *);
CODE:
	func   = INT2PTR(int(*)(char *, int, char *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, t2);
OUTPUT:
	RETVAL

void *
nci_piit( c_func, i0, i1, t2 )
	SV* c_func
	int i0
	int i1
	char * t2
PREINIT:
	void *(*func)(int, int, char *);
CODE:
	func   = INT2PTR(void *(*)(int, int, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, t2);
OUTPUT:
	RETVAL

void
nci_viit( c_func, i0, i1, t2 )
	SV* c_func
	int i0
	int i1
	char * t2
PREINIT:
	void(*func)(int, int, char *);
CODE:
	func   = INT2PTR(void(*)(int, int, char *), SvIV(c_func) );
	(*func)(i0, i1, t2);

double
nci_diit( c_func, i0, i1, t2 )
	SV* c_func
	int i0
	int i1
	char * t2
PREINIT:
	double(*func)(int, int, char *);
CODE:
	func   = INT2PTR(double(*)(int, int, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, t2);
OUTPUT:
	RETVAL

short
nci_siit( c_func, i0, i1, t2 )
	SV* c_func
	int i0
	int i1
	char * t2
PREINIT:
	short(*func)(int, int, char *);
CODE:
	func   = INT2PTR(short(*)(int, int, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, t2);
OUTPUT:
	RETVAL

float
nci_fiit( c_func, i0, i1, t2 )
	SV* c_func
	int i0
	int i1
	char * t2
PREINIT:
	float(*func)(int, int, char *);
CODE:
	func   = INT2PTR(float(*)(int, int, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, t2);
OUTPUT:
	RETVAL

char *
nci_tiit( c_func, i0, i1, t2 )
	SV* c_func
	int i0
	int i1
	char * t2
PREINIT:
	char *(*func)(int, int, char *);
CODE:
	func   = INT2PTR(char *(*)(int, int, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, t2);
OUTPUT:
	RETVAL

int
nci_iiit( c_func, i0, i1, t2 )
	SV* c_func
	int i0
	int i1
	char * t2
PREINIT:
	int(*func)(int, int, char *);
CODE:
	func   = INT2PTR(int(*)(int, int, char *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, t2);
OUTPUT:
	RETVAL

void *
nci_pppi( c_func, p0, p1, i2 )
	SV* c_func
	void * p0
	void * p1
	int i2
PREINIT:
	void *(*func)(void *, void *, int);
CODE:
	func   = INT2PTR(void *(*)(void *, void *, int), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, i2);
OUTPUT:
	RETVAL

void
nci_vppi( c_func, p0, p1, i2 )
	SV* c_func
	void * p0
	void * p1
	int i2
PREINIT:
	void(*func)(void *, void *, int);
CODE:
	func   = INT2PTR(void(*)(void *, void *, int), SvIV(c_func) );
	(*func)(p0, p1, i2);

double
nci_dppi( c_func, p0, p1, i2 )
	SV* c_func
	void * p0
	void * p1
	int i2
PREINIT:
	double(*func)(void *, void *, int);
CODE:
	func   = INT2PTR(double(*)(void *, void *, int), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, i2);
OUTPUT:
	RETVAL

short
nci_sppi( c_func, p0, p1, i2 )
	SV* c_func
	void * p0
	void * p1
	int i2
PREINIT:
	short(*func)(void *, void *, int);
CODE:
	func   = INT2PTR(short(*)(void *, void *, int), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, i2);
OUTPUT:
	RETVAL

float
nci_fppi( c_func, p0, p1, i2 )
	SV* c_func
	void * p0
	void * p1
	int i2
PREINIT:
	float(*func)(void *, void *, int);
CODE:
	func   = INT2PTR(float(*)(void *, void *, int), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, i2);
OUTPUT:
	RETVAL

char *
nci_tppi( c_func, p0, p1, i2 )
	SV* c_func
	void * p0
	void * p1
	int i2
PREINIT:
	char *(*func)(void *, void *, int);
CODE:
	func   = INT2PTR(char *(*)(void *, void *, int), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, i2);
OUTPUT:
	RETVAL

int
nci_ippi( c_func, p0, p1, i2 )
	SV* c_func
	void * p0
	void * p1
	int i2
PREINIT:
	int(*func)(void *, void *, int);
CODE:
	func   = INT2PTR(int(*)(void *, void *, int), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, i2);
OUTPUT:
	RETVAL

void *
nci_pvpi( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvpi( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvpi( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svpi( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvpi( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvpi( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivpi( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdpi( c_func, d0, p1, i2 )
	SV* c_func
	double d0
	void * p1
	int i2
PREINIT:
	void *(*func)(double, void *, int);
CODE:
	func   = INT2PTR(void *(*)(double, void *, int), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, i2);
OUTPUT:
	RETVAL

void
nci_vdpi( c_func, d0, p1, i2 )
	SV* c_func
	double d0
	void * p1
	int i2
PREINIT:
	void(*func)(double, void *, int);
CODE:
	func   = INT2PTR(void(*)(double, void *, int), SvIV(c_func) );
	(*func)(d0, p1, i2);

double
nci_ddpi( c_func, d0, p1, i2 )
	SV* c_func
	double d0
	void * p1
	int i2
PREINIT:
	double(*func)(double, void *, int);
CODE:
	func   = INT2PTR(double(*)(double, void *, int), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, i2);
OUTPUT:
	RETVAL

short
nci_sdpi( c_func, d0, p1, i2 )
	SV* c_func
	double d0
	void * p1
	int i2
PREINIT:
	short(*func)(double, void *, int);
CODE:
	func   = INT2PTR(short(*)(double, void *, int), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, i2);
OUTPUT:
	RETVAL

float
nci_fdpi( c_func, d0, p1, i2 )
	SV* c_func
	double d0
	void * p1
	int i2
PREINIT:
	float(*func)(double, void *, int);
CODE:
	func   = INT2PTR(float(*)(double, void *, int), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, i2);
OUTPUT:
	RETVAL

char *
nci_tdpi( c_func, d0, p1, i2 )
	SV* c_func
	double d0
	void * p1
	int i2
PREINIT:
	char *(*func)(double, void *, int);
CODE:
	func   = INT2PTR(char *(*)(double, void *, int), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, i2);
OUTPUT:
	RETVAL

int
nci_idpi( c_func, d0, p1, i2 )
	SV* c_func
	double d0
	void * p1
	int i2
PREINIT:
	int(*func)(double, void *, int);
CODE:
	func   = INT2PTR(int(*)(double, void *, int), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, i2);
OUTPUT:
	RETVAL

void *
nci_pspi( c_func, s0, p1, i2 )
	SV* c_func
	short s0
	void * p1
	int i2
PREINIT:
	void *(*func)(short, void *, int);
CODE:
	func   = INT2PTR(void *(*)(short, void *, int), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, i2);
OUTPUT:
	RETVAL

void
nci_vspi( c_func, s0, p1, i2 )
	SV* c_func
	short s0
	void * p1
	int i2
PREINIT:
	void(*func)(short, void *, int);
CODE:
	func   = INT2PTR(void(*)(short, void *, int), SvIV(c_func) );
	(*func)(s0, p1, i2);

double
nci_dspi( c_func, s0, p1, i2 )
	SV* c_func
	short s0
	void * p1
	int i2
PREINIT:
	double(*func)(short, void *, int);
CODE:
	func   = INT2PTR(double(*)(short, void *, int), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, i2);
OUTPUT:
	RETVAL

short
nci_sspi( c_func, s0, p1, i2 )
	SV* c_func
	short s0
	void * p1
	int i2
PREINIT:
	short(*func)(short, void *, int);
CODE:
	func   = INT2PTR(short(*)(short, void *, int), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, i2);
OUTPUT:
	RETVAL

float
nci_fspi( c_func, s0, p1, i2 )
	SV* c_func
	short s0
	void * p1
	int i2
PREINIT:
	float(*func)(short, void *, int);
CODE:
	func   = INT2PTR(float(*)(short, void *, int), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, i2);
OUTPUT:
	RETVAL

char *
nci_tspi( c_func, s0, p1, i2 )
	SV* c_func
	short s0
	void * p1
	int i2
PREINIT:
	char *(*func)(short, void *, int);
CODE:
	func   = INT2PTR(char *(*)(short, void *, int), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, i2);
OUTPUT:
	RETVAL

int
nci_ispi( c_func, s0, p1, i2 )
	SV* c_func
	short s0
	void * p1
	int i2
PREINIT:
	int(*func)(short, void *, int);
CODE:
	func   = INT2PTR(int(*)(short, void *, int), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, i2);
OUTPUT:
	RETVAL

void *
nci_pfpi( c_func, f0, p1, i2 )
	SV* c_func
	float f0
	void * p1
	int i2
PREINIT:
	void *(*func)(float, void *, int);
CODE:
	func   = INT2PTR(void *(*)(float, void *, int), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, i2);
OUTPUT:
	RETVAL

void
nci_vfpi( c_func, f0, p1, i2 )
	SV* c_func
	float f0
	void * p1
	int i2
PREINIT:
	void(*func)(float, void *, int);
CODE:
	func   = INT2PTR(void(*)(float, void *, int), SvIV(c_func) );
	(*func)(f0, p1, i2);

double
nci_dfpi( c_func, f0, p1, i2 )
	SV* c_func
	float f0
	void * p1
	int i2
PREINIT:
	double(*func)(float, void *, int);
CODE:
	func   = INT2PTR(double(*)(float, void *, int), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, i2);
OUTPUT:
	RETVAL

short
nci_sfpi( c_func, f0, p1, i2 )
	SV* c_func
	float f0
	void * p1
	int i2
PREINIT:
	short(*func)(float, void *, int);
CODE:
	func   = INT2PTR(short(*)(float, void *, int), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, i2);
OUTPUT:
	RETVAL

float
nci_ffpi( c_func, f0, p1, i2 )
	SV* c_func
	float f0
	void * p1
	int i2
PREINIT:
	float(*func)(float, void *, int);
CODE:
	func   = INT2PTR(float(*)(float, void *, int), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, i2);
OUTPUT:
	RETVAL

char *
nci_tfpi( c_func, f0, p1, i2 )
	SV* c_func
	float f0
	void * p1
	int i2
PREINIT:
	char *(*func)(float, void *, int);
CODE:
	func   = INT2PTR(char *(*)(float, void *, int), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, i2);
OUTPUT:
	RETVAL

int
nci_ifpi( c_func, f0, p1, i2 )
	SV* c_func
	float f0
	void * p1
	int i2
PREINIT:
	int(*func)(float, void *, int);
CODE:
	func   = INT2PTR(int(*)(float, void *, int), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, i2);
OUTPUT:
	RETVAL

void *
nci_ptpi( c_func, t0, p1, i2 )
	SV* c_func
	char * t0
	void * p1
	int i2
PREINIT:
	void *(*func)(char *, void *, int);
CODE:
	func   = INT2PTR(void *(*)(char *, void *, int), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, i2);
OUTPUT:
	RETVAL

void
nci_vtpi( c_func, t0, p1, i2 )
	SV* c_func
	char * t0
	void * p1
	int i2
PREINIT:
	void(*func)(char *, void *, int);
CODE:
	func   = INT2PTR(void(*)(char *, void *, int), SvIV(c_func) );
	(*func)(t0, p1, i2);

double
nci_dtpi( c_func, t0, p1, i2 )
	SV* c_func
	char * t0
	void * p1
	int i2
PREINIT:
	double(*func)(char *, void *, int);
CODE:
	func   = INT2PTR(double(*)(char *, void *, int), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, i2);
OUTPUT:
	RETVAL

short
nci_stpi( c_func, t0, p1, i2 )
	SV* c_func
	char * t0
	void * p1
	int i2
PREINIT:
	short(*func)(char *, void *, int);
CODE:
	func   = INT2PTR(short(*)(char *, void *, int), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, i2);
OUTPUT:
	RETVAL

float
nci_ftpi( c_func, t0, p1, i2 )
	SV* c_func
	char * t0
	void * p1
	int i2
PREINIT:
	float(*func)(char *, void *, int);
CODE:
	func   = INT2PTR(float(*)(char *, void *, int), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, i2);
OUTPUT:
	RETVAL

char *
nci_ttpi( c_func, t0, p1, i2 )
	SV* c_func
	char * t0
	void * p1
	int i2
PREINIT:
	char *(*func)(char *, void *, int);
CODE:
	func   = INT2PTR(char *(*)(char *, void *, int), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, i2);
OUTPUT:
	RETVAL

int
nci_itpi( c_func, t0, p1, i2 )
	SV* c_func
	char * t0
	void * p1
	int i2
PREINIT:
	int(*func)(char *, void *, int);
CODE:
	func   = INT2PTR(int(*)(char *, void *, int), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, i2);
OUTPUT:
	RETVAL

void *
nci_pipi( c_func, i0, p1, i2 )
	SV* c_func
	int i0
	void * p1
	int i2
PREINIT:
	void *(*func)(int, void *, int);
CODE:
	func   = INT2PTR(void *(*)(int, void *, int), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, i2);
OUTPUT:
	RETVAL

void
nci_vipi( c_func, i0, p1, i2 )
	SV* c_func
	int i0
	void * p1
	int i2
PREINIT:
	void(*func)(int, void *, int);
CODE:
	func   = INT2PTR(void(*)(int, void *, int), SvIV(c_func) );
	(*func)(i0, p1, i2);

double
nci_dipi( c_func, i0, p1, i2 )
	SV* c_func
	int i0
	void * p1
	int i2
PREINIT:
	double(*func)(int, void *, int);
CODE:
	func   = INT2PTR(double(*)(int, void *, int), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, i2);
OUTPUT:
	RETVAL

short
nci_sipi( c_func, i0, p1, i2 )
	SV* c_func
	int i0
	void * p1
	int i2
PREINIT:
	short(*func)(int, void *, int);
CODE:
	func   = INT2PTR(short(*)(int, void *, int), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, i2);
OUTPUT:
	RETVAL

float
nci_fipi( c_func, i0, p1, i2 )
	SV* c_func
	int i0
	void * p1
	int i2
PREINIT:
	float(*func)(int, void *, int);
CODE:
	func   = INT2PTR(float(*)(int, void *, int), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, i2);
OUTPUT:
	RETVAL

char *
nci_tipi( c_func, i0, p1, i2 )
	SV* c_func
	int i0
	void * p1
	int i2
PREINIT:
	char *(*func)(int, void *, int);
CODE:
	func   = INT2PTR(char *(*)(int, void *, int), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, i2);
OUTPUT:
	RETVAL

int
nci_iipi( c_func, i0, p1, i2 )
	SV* c_func
	int i0
	void * p1
	int i2
PREINIT:
	int(*func)(int, void *, int);
CODE:
	func   = INT2PTR(int(*)(int, void *, int), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, i2);
OUTPUT:
	RETVAL

void *
nci_ppdi( c_func, p0, d1, i2 )
	SV* c_func
	void * p0
	double d1
	int i2
PREINIT:
	void *(*func)(void *, double, int);
CODE:
	func   = INT2PTR(void *(*)(void *, double, int), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, i2);
OUTPUT:
	RETVAL

void
nci_vpdi( c_func, p0, d1, i2 )
	SV* c_func
	void * p0
	double d1
	int i2
PREINIT:
	void(*func)(void *, double, int);
CODE:
	func   = INT2PTR(void(*)(void *, double, int), SvIV(c_func) );
	(*func)(p0, d1, i2);

double
nci_dpdi( c_func, p0, d1, i2 )
	SV* c_func
	void * p0
	double d1
	int i2
PREINIT:
	double(*func)(void *, double, int);
CODE:
	func   = INT2PTR(double(*)(void *, double, int), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, i2);
OUTPUT:
	RETVAL

short
nci_spdi( c_func, p0, d1, i2 )
	SV* c_func
	void * p0
	double d1
	int i2
PREINIT:
	short(*func)(void *, double, int);
CODE:
	func   = INT2PTR(short(*)(void *, double, int), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, i2);
OUTPUT:
	RETVAL

float
nci_fpdi( c_func, p0, d1, i2 )
	SV* c_func
	void * p0
	double d1
	int i2
PREINIT:
	float(*func)(void *, double, int);
CODE:
	func   = INT2PTR(float(*)(void *, double, int), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, i2);
OUTPUT:
	RETVAL

char *
nci_tpdi( c_func, p0, d1, i2 )
	SV* c_func
	void * p0
	double d1
	int i2
PREINIT:
	char *(*func)(void *, double, int);
CODE:
	func   = INT2PTR(char *(*)(void *, double, int), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, i2);
OUTPUT:
	RETVAL

int
nci_ipdi( c_func, p0, d1, i2 )
	SV* c_func
	void * p0
	double d1
	int i2
PREINIT:
	int(*func)(void *, double, int);
CODE:
	func   = INT2PTR(int(*)(void *, double, int), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, i2);
OUTPUT:
	RETVAL

void *
nci_pvdi( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvdi( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvdi( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svdi( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvdi( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvdi( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivdi( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pddi( c_func, d0, d1, i2 )
	SV* c_func
	double d0
	double d1
	int i2
PREINIT:
	void *(*func)(double, double, int);
CODE:
	func   = INT2PTR(void *(*)(double, double, int), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, i2);
OUTPUT:
	RETVAL

void
nci_vddi( c_func, d0, d1, i2 )
	SV* c_func
	double d0
	double d1
	int i2
PREINIT:
	void(*func)(double, double, int);
CODE:
	func   = INT2PTR(void(*)(double, double, int), SvIV(c_func) );
	(*func)(d0, d1, i2);

double
nci_dddi( c_func, d0, d1, i2 )
	SV* c_func
	double d0
	double d1
	int i2
PREINIT:
	double(*func)(double, double, int);
CODE:
	func   = INT2PTR(double(*)(double, double, int), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, i2);
OUTPUT:
	RETVAL

short
nci_sddi( c_func, d0, d1, i2 )
	SV* c_func
	double d0
	double d1
	int i2
PREINIT:
	short(*func)(double, double, int);
CODE:
	func   = INT2PTR(short(*)(double, double, int), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, i2);
OUTPUT:
	RETVAL

float
nci_fddi( c_func, d0, d1, i2 )
	SV* c_func
	double d0
	double d1
	int i2
PREINIT:
	float(*func)(double, double, int);
CODE:
	func   = INT2PTR(float(*)(double, double, int), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, i2);
OUTPUT:
	RETVAL

char *
nci_tddi( c_func, d0, d1, i2 )
	SV* c_func
	double d0
	double d1
	int i2
PREINIT:
	char *(*func)(double, double, int);
CODE:
	func   = INT2PTR(char *(*)(double, double, int), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, i2);
OUTPUT:
	RETVAL

int
nci_iddi( c_func, d0, d1, i2 )
	SV* c_func
	double d0
	double d1
	int i2
PREINIT:
	int(*func)(double, double, int);
CODE:
	func   = INT2PTR(int(*)(double, double, int), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, i2);
OUTPUT:
	RETVAL

void *
nci_psdi( c_func, s0, d1, i2 )
	SV* c_func
	short s0
	double d1
	int i2
PREINIT:
	void *(*func)(short, double, int);
CODE:
	func   = INT2PTR(void *(*)(short, double, int), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, i2);
OUTPUT:
	RETVAL

void
nci_vsdi( c_func, s0, d1, i2 )
	SV* c_func
	short s0
	double d1
	int i2
PREINIT:
	void(*func)(short, double, int);
CODE:
	func   = INT2PTR(void(*)(short, double, int), SvIV(c_func) );
	(*func)(s0, d1, i2);

double
nci_dsdi( c_func, s0, d1, i2 )
	SV* c_func
	short s0
	double d1
	int i2
PREINIT:
	double(*func)(short, double, int);
CODE:
	func   = INT2PTR(double(*)(short, double, int), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, i2);
OUTPUT:
	RETVAL

short
nci_ssdi( c_func, s0, d1, i2 )
	SV* c_func
	short s0
	double d1
	int i2
PREINIT:
	short(*func)(short, double, int);
CODE:
	func   = INT2PTR(short(*)(short, double, int), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, i2);
OUTPUT:
	RETVAL

float
nci_fsdi( c_func, s0, d1, i2 )
	SV* c_func
	short s0
	double d1
	int i2
PREINIT:
	float(*func)(short, double, int);
CODE:
	func   = INT2PTR(float(*)(short, double, int), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, i2);
OUTPUT:
	RETVAL

char *
nci_tsdi( c_func, s0, d1, i2 )
	SV* c_func
	short s0
	double d1
	int i2
PREINIT:
	char *(*func)(short, double, int);
CODE:
	func   = INT2PTR(char *(*)(short, double, int), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, i2);
OUTPUT:
	RETVAL

int
nci_isdi( c_func, s0, d1, i2 )
	SV* c_func
	short s0
	double d1
	int i2
PREINIT:
	int(*func)(short, double, int);
CODE:
	func   = INT2PTR(int(*)(short, double, int), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, i2);
OUTPUT:
	RETVAL

void *
nci_pfdi( c_func, f0, d1, i2 )
	SV* c_func
	float f0
	double d1
	int i2
PREINIT:
	void *(*func)(float, double, int);
CODE:
	func   = INT2PTR(void *(*)(float, double, int), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, i2);
OUTPUT:
	RETVAL

void
nci_vfdi( c_func, f0, d1, i2 )
	SV* c_func
	float f0
	double d1
	int i2
PREINIT:
	void(*func)(float, double, int);
CODE:
	func   = INT2PTR(void(*)(float, double, int), SvIV(c_func) );
	(*func)(f0, d1, i2);

double
nci_dfdi( c_func, f0, d1, i2 )
	SV* c_func
	float f0
	double d1
	int i2
PREINIT:
	double(*func)(float, double, int);
CODE:
	func   = INT2PTR(double(*)(float, double, int), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, i2);
OUTPUT:
	RETVAL

short
nci_sfdi( c_func, f0, d1, i2 )
	SV* c_func
	float f0
	double d1
	int i2
PREINIT:
	short(*func)(float, double, int);
CODE:
	func   = INT2PTR(short(*)(float, double, int), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, i2);
OUTPUT:
	RETVAL

float
nci_ffdi( c_func, f0, d1, i2 )
	SV* c_func
	float f0
	double d1
	int i2
PREINIT:
	float(*func)(float, double, int);
CODE:
	func   = INT2PTR(float(*)(float, double, int), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, i2);
OUTPUT:
	RETVAL

char *
nci_tfdi( c_func, f0, d1, i2 )
	SV* c_func
	float f0
	double d1
	int i2
PREINIT:
	char *(*func)(float, double, int);
CODE:
	func   = INT2PTR(char *(*)(float, double, int), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, i2);
OUTPUT:
	RETVAL

int
nci_ifdi( c_func, f0, d1, i2 )
	SV* c_func
	float f0
	double d1
	int i2
PREINIT:
	int(*func)(float, double, int);
CODE:
	func   = INT2PTR(int(*)(float, double, int), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, i2);
OUTPUT:
	RETVAL

void *
nci_ptdi( c_func, t0, d1, i2 )
	SV* c_func
	char * t0
	double d1
	int i2
PREINIT:
	void *(*func)(char *, double, int);
CODE:
	func   = INT2PTR(void *(*)(char *, double, int), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, i2);
OUTPUT:
	RETVAL

void
nci_vtdi( c_func, t0, d1, i2 )
	SV* c_func
	char * t0
	double d1
	int i2
PREINIT:
	void(*func)(char *, double, int);
CODE:
	func   = INT2PTR(void(*)(char *, double, int), SvIV(c_func) );
	(*func)(t0, d1, i2);

double
nci_dtdi( c_func, t0, d1, i2 )
	SV* c_func
	char * t0
	double d1
	int i2
PREINIT:
	double(*func)(char *, double, int);
CODE:
	func   = INT2PTR(double(*)(char *, double, int), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, i2);
OUTPUT:
	RETVAL

short
nci_stdi( c_func, t0, d1, i2 )
	SV* c_func
	char * t0
	double d1
	int i2
PREINIT:
	short(*func)(char *, double, int);
CODE:
	func   = INT2PTR(short(*)(char *, double, int), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, i2);
OUTPUT:
	RETVAL

float
nci_ftdi( c_func, t0, d1, i2 )
	SV* c_func
	char * t0
	double d1
	int i2
PREINIT:
	float(*func)(char *, double, int);
CODE:
	func   = INT2PTR(float(*)(char *, double, int), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, i2);
OUTPUT:
	RETVAL

char *
nci_ttdi( c_func, t0, d1, i2 )
	SV* c_func
	char * t0
	double d1
	int i2
PREINIT:
	char *(*func)(char *, double, int);
CODE:
	func   = INT2PTR(char *(*)(char *, double, int), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, i2);
OUTPUT:
	RETVAL

int
nci_itdi( c_func, t0, d1, i2 )
	SV* c_func
	char * t0
	double d1
	int i2
PREINIT:
	int(*func)(char *, double, int);
CODE:
	func   = INT2PTR(int(*)(char *, double, int), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, i2);
OUTPUT:
	RETVAL

void *
nci_pidi( c_func, i0, d1, i2 )
	SV* c_func
	int i0
	double d1
	int i2
PREINIT:
	void *(*func)(int, double, int);
CODE:
	func   = INT2PTR(void *(*)(int, double, int), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, i2);
OUTPUT:
	RETVAL

void
nci_vidi( c_func, i0, d1, i2 )
	SV* c_func
	int i0
	double d1
	int i2
PREINIT:
	void(*func)(int, double, int);
CODE:
	func   = INT2PTR(void(*)(int, double, int), SvIV(c_func) );
	(*func)(i0, d1, i2);

double
nci_didi( c_func, i0, d1, i2 )
	SV* c_func
	int i0
	double d1
	int i2
PREINIT:
	double(*func)(int, double, int);
CODE:
	func   = INT2PTR(double(*)(int, double, int), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, i2);
OUTPUT:
	RETVAL

short
nci_sidi( c_func, i0, d1, i2 )
	SV* c_func
	int i0
	double d1
	int i2
PREINIT:
	short(*func)(int, double, int);
CODE:
	func   = INT2PTR(short(*)(int, double, int), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, i2);
OUTPUT:
	RETVAL

float
nci_fidi( c_func, i0, d1, i2 )
	SV* c_func
	int i0
	double d1
	int i2
PREINIT:
	float(*func)(int, double, int);
CODE:
	func   = INT2PTR(float(*)(int, double, int), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, i2);
OUTPUT:
	RETVAL

char *
nci_tidi( c_func, i0, d1, i2 )
	SV* c_func
	int i0
	double d1
	int i2
PREINIT:
	char *(*func)(int, double, int);
CODE:
	func   = INT2PTR(char *(*)(int, double, int), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, i2);
OUTPUT:
	RETVAL

int
nci_iidi( c_func, i0, d1, i2 )
	SV* c_func
	int i0
	double d1
	int i2
PREINIT:
	int(*func)(int, double, int);
CODE:
	func   = INT2PTR(int(*)(int, double, int), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, i2);
OUTPUT:
	RETVAL

void *
nci_ppsi( c_func, p0, s1, i2 )
	SV* c_func
	void * p0
	short s1
	int i2
PREINIT:
	void *(*func)(void *, short, int);
CODE:
	func   = INT2PTR(void *(*)(void *, short, int), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, i2);
OUTPUT:
	RETVAL

void
nci_vpsi( c_func, p0, s1, i2 )
	SV* c_func
	void * p0
	short s1
	int i2
PREINIT:
	void(*func)(void *, short, int);
CODE:
	func   = INT2PTR(void(*)(void *, short, int), SvIV(c_func) );
	(*func)(p0, s1, i2);

double
nci_dpsi( c_func, p0, s1, i2 )
	SV* c_func
	void * p0
	short s1
	int i2
PREINIT:
	double(*func)(void *, short, int);
CODE:
	func   = INT2PTR(double(*)(void *, short, int), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, i2);
OUTPUT:
	RETVAL

short
nci_spsi( c_func, p0, s1, i2 )
	SV* c_func
	void * p0
	short s1
	int i2
PREINIT:
	short(*func)(void *, short, int);
CODE:
	func   = INT2PTR(short(*)(void *, short, int), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, i2);
OUTPUT:
	RETVAL

float
nci_fpsi( c_func, p0, s1, i2 )
	SV* c_func
	void * p0
	short s1
	int i2
PREINIT:
	float(*func)(void *, short, int);
CODE:
	func   = INT2PTR(float(*)(void *, short, int), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, i2);
OUTPUT:
	RETVAL

char *
nci_tpsi( c_func, p0, s1, i2 )
	SV* c_func
	void * p0
	short s1
	int i2
PREINIT:
	char *(*func)(void *, short, int);
CODE:
	func   = INT2PTR(char *(*)(void *, short, int), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, i2);
OUTPUT:
	RETVAL

int
nci_ipsi( c_func, p0, s1, i2 )
	SV* c_func
	void * p0
	short s1
	int i2
PREINIT:
	int(*func)(void *, short, int);
CODE:
	func   = INT2PTR(int(*)(void *, short, int), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, i2);
OUTPUT:
	RETVAL

void *
nci_pvsi( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvsi( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvsi( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svsi( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvsi( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvsi( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivsi( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdsi( c_func, d0, s1, i2 )
	SV* c_func
	double d0
	short s1
	int i2
PREINIT:
	void *(*func)(double, short, int);
CODE:
	func   = INT2PTR(void *(*)(double, short, int), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, i2);
OUTPUT:
	RETVAL

void
nci_vdsi( c_func, d0, s1, i2 )
	SV* c_func
	double d0
	short s1
	int i2
PREINIT:
	void(*func)(double, short, int);
CODE:
	func   = INT2PTR(void(*)(double, short, int), SvIV(c_func) );
	(*func)(d0, s1, i2);

double
nci_ddsi( c_func, d0, s1, i2 )
	SV* c_func
	double d0
	short s1
	int i2
PREINIT:
	double(*func)(double, short, int);
CODE:
	func   = INT2PTR(double(*)(double, short, int), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, i2);
OUTPUT:
	RETVAL

short
nci_sdsi( c_func, d0, s1, i2 )
	SV* c_func
	double d0
	short s1
	int i2
PREINIT:
	short(*func)(double, short, int);
CODE:
	func   = INT2PTR(short(*)(double, short, int), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, i2);
OUTPUT:
	RETVAL

float
nci_fdsi( c_func, d0, s1, i2 )
	SV* c_func
	double d0
	short s1
	int i2
PREINIT:
	float(*func)(double, short, int);
CODE:
	func   = INT2PTR(float(*)(double, short, int), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, i2);
OUTPUT:
	RETVAL

char *
nci_tdsi( c_func, d0, s1, i2 )
	SV* c_func
	double d0
	short s1
	int i2
PREINIT:
	char *(*func)(double, short, int);
CODE:
	func   = INT2PTR(char *(*)(double, short, int), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, i2);
OUTPUT:
	RETVAL

int
nci_idsi( c_func, d0, s1, i2 )
	SV* c_func
	double d0
	short s1
	int i2
PREINIT:
	int(*func)(double, short, int);
CODE:
	func   = INT2PTR(int(*)(double, short, int), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, i2);
OUTPUT:
	RETVAL

void *
nci_pssi( c_func, s0, s1, i2 )
	SV* c_func
	short s0
	short s1
	int i2
PREINIT:
	void *(*func)(short, short, int);
CODE:
	func   = INT2PTR(void *(*)(short, short, int), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, i2);
OUTPUT:
	RETVAL

void
nci_vssi( c_func, s0, s1, i2 )
	SV* c_func
	short s0
	short s1
	int i2
PREINIT:
	void(*func)(short, short, int);
CODE:
	func   = INT2PTR(void(*)(short, short, int), SvIV(c_func) );
	(*func)(s0, s1, i2);

double
nci_dssi( c_func, s0, s1, i2 )
	SV* c_func
	short s0
	short s1
	int i2
PREINIT:
	double(*func)(short, short, int);
CODE:
	func   = INT2PTR(double(*)(short, short, int), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, i2);
OUTPUT:
	RETVAL

short
nci_sssi( c_func, s0, s1, i2 )
	SV* c_func
	short s0
	short s1
	int i2
PREINIT:
	short(*func)(short, short, int);
CODE:
	func   = INT2PTR(short(*)(short, short, int), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, i2);
OUTPUT:
	RETVAL

float
nci_fssi( c_func, s0, s1, i2 )
	SV* c_func
	short s0
	short s1
	int i2
PREINIT:
	float(*func)(short, short, int);
CODE:
	func   = INT2PTR(float(*)(short, short, int), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, i2);
OUTPUT:
	RETVAL

char *
nci_tssi( c_func, s0, s1, i2 )
	SV* c_func
	short s0
	short s1
	int i2
PREINIT:
	char *(*func)(short, short, int);
CODE:
	func   = INT2PTR(char *(*)(short, short, int), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, i2);
OUTPUT:
	RETVAL

int
nci_issi( c_func, s0, s1, i2 )
	SV* c_func
	short s0
	short s1
	int i2
PREINIT:
	int(*func)(short, short, int);
CODE:
	func   = INT2PTR(int(*)(short, short, int), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, i2);
OUTPUT:
	RETVAL

void *
nci_pfsi( c_func, f0, s1, i2 )
	SV* c_func
	float f0
	short s1
	int i2
PREINIT:
	void *(*func)(float, short, int);
CODE:
	func   = INT2PTR(void *(*)(float, short, int), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, i2);
OUTPUT:
	RETVAL

void
nci_vfsi( c_func, f0, s1, i2 )
	SV* c_func
	float f0
	short s1
	int i2
PREINIT:
	void(*func)(float, short, int);
CODE:
	func   = INT2PTR(void(*)(float, short, int), SvIV(c_func) );
	(*func)(f0, s1, i2);

double
nci_dfsi( c_func, f0, s1, i2 )
	SV* c_func
	float f0
	short s1
	int i2
PREINIT:
	double(*func)(float, short, int);
CODE:
	func   = INT2PTR(double(*)(float, short, int), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, i2);
OUTPUT:
	RETVAL

short
nci_sfsi( c_func, f0, s1, i2 )
	SV* c_func
	float f0
	short s1
	int i2
PREINIT:
	short(*func)(float, short, int);
CODE:
	func   = INT2PTR(short(*)(float, short, int), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, i2);
OUTPUT:
	RETVAL

float
nci_ffsi( c_func, f0, s1, i2 )
	SV* c_func
	float f0
	short s1
	int i2
PREINIT:
	float(*func)(float, short, int);
CODE:
	func   = INT2PTR(float(*)(float, short, int), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, i2);
OUTPUT:
	RETVAL

char *
nci_tfsi( c_func, f0, s1, i2 )
	SV* c_func
	float f0
	short s1
	int i2
PREINIT:
	char *(*func)(float, short, int);
CODE:
	func   = INT2PTR(char *(*)(float, short, int), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, i2);
OUTPUT:
	RETVAL

int
nci_ifsi( c_func, f0, s1, i2 )
	SV* c_func
	float f0
	short s1
	int i2
PREINIT:
	int(*func)(float, short, int);
CODE:
	func   = INT2PTR(int(*)(float, short, int), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, i2);
OUTPUT:
	RETVAL

void *
nci_ptsi( c_func, t0, s1, i2 )
	SV* c_func
	char * t0
	short s1
	int i2
PREINIT:
	void *(*func)(char *, short, int);
CODE:
	func   = INT2PTR(void *(*)(char *, short, int), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, i2);
OUTPUT:
	RETVAL

void
nci_vtsi( c_func, t0, s1, i2 )
	SV* c_func
	char * t0
	short s1
	int i2
PREINIT:
	void(*func)(char *, short, int);
CODE:
	func   = INT2PTR(void(*)(char *, short, int), SvIV(c_func) );
	(*func)(t0, s1, i2);

double
nci_dtsi( c_func, t0, s1, i2 )
	SV* c_func
	char * t0
	short s1
	int i2
PREINIT:
	double(*func)(char *, short, int);
CODE:
	func   = INT2PTR(double(*)(char *, short, int), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, i2);
OUTPUT:
	RETVAL

short
nci_stsi( c_func, t0, s1, i2 )
	SV* c_func
	char * t0
	short s1
	int i2
PREINIT:
	short(*func)(char *, short, int);
CODE:
	func   = INT2PTR(short(*)(char *, short, int), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, i2);
OUTPUT:
	RETVAL

float
nci_ftsi( c_func, t0, s1, i2 )
	SV* c_func
	char * t0
	short s1
	int i2
PREINIT:
	float(*func)(char *, short, int);
CODE:
	func   = INT2PTR(float(*)(char *, short, int), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, i2);
OUTPUT:
	RETVAL

char *
nci_ttsi( c_func, t0, s1, i2 )
	SV* c_func
	char * t0
	short s1
	int i2
PREINIT:
	char *(*func)(char *, short, int);
CODE:
	func   = INT2PTR(char *(*)(char *, short, int), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, i2);
OUTPUT:
	RETVAL

int
nci_itsi( c_func, t0, s1, i2 )
	SV* c_func
	char * t0
	short s1
	int i2
PREINIT:
	int(*func)(char *, short, int);
CODE:
	func   = INT2PTR(int(*)(char *, short, int), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, i2);
OUTPUT:
	RETVAL

void *
nci_pisi( c_func, i0, s1, i2 )
	SV* c_func
	int i0
	short s1
	int i2
PREINIT:
	void *(*func)(int, short, int);
CODE:
	func   = INT2PTR(void *(*)(int, short, int), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, i2);
OUTPUT:
	RETVAL

void
nci_visi( c_func, i0, s1, i2 )
	SV* c_func
	int i0
	short s1
	int i2
PREINIT:
	void(*func)(int, short, int);
CODE:
	func   = INT2PTR(void(*)(int, short, int), SvIV(c_func) );
	(*func)(i0, s1, i2);

double
nci_disi( c_func, i0, s1, i2 )
	SV* c_func
	int i0
	short s1
	int i2
PREINIT:
	double(*func)(int, short, int);
CODE:
	func   = INT2PTR(double(*)(int, short, int), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, i2);
OUTPUT:
	RETVAL

short
nci_sisi( c_func, i0, s1, i2 )
	SV* c_func
	int i0
	short s1
	int i2
PREINIT:
	short(*func)(int, short, int);
CODE:
	func   = INT2PTR(short(*)(int, short, int), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, i2);
OUTPUT:
	RETVAL

float
nci_fisi( c_func, i0, s1, i2 )
	SV* c_func
	int i0
	short s1
	int i2
PREINIT:
	float(*func)(int, short, int);
CODE:
	func   = INT2PTR(float(*)(int, short, int), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, i2);
OUTPUT:
	RETVAL

char *
nci_tisi( c_func, i0, s1, i2 )
	SV* c_func
	int i0
	short s1
	int i2
PREINIT:
	char *(*func)(int, short, int);
CODE:
	func   = INT2PTR(char *(*)(int, short, int), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, i2);
OUTPUT:
	RETVAL

int
nci_iisi( c_func, i0, s1, i2 )
	SV* c_func
	int i0
	short s1
	int i2
PREINIT:
	int(*func)(int, short, int);
CODE:
	func   = INT2PTR(int(*)(int, short, int), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, i2);
OUTPUT:
	RETVAL

void *
nci_ppfi( c_func, p0, f1, i2 )
	SV* c_func
	void * p0
	float f1
	int i2
PREINIT:
	void *(*func)(void *, float, int);
CODE:
	func   = INT2PTR(void *(*)(void *, float, int), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, i2);
OUTPUT:
	RETVAL

void
nci_vpfi( c_func, p0, f1, i2 )
	SV* c_func
	void * p0
	float f1
	int i2
PREINIT:
	void(*func)(void *, float, int);
CODE:
	func   = INT2PTR(void(*)(void *, float, int), SvIV(c_func) );
	(*func)(p0, f1, i2);

double
nci_dpfi( c_func, p0, f1, i2 )
	SV* c_func
	void * p0
	float f1
	int i2
PREINIT:
	double(*func)(void *, float, int);
CODE:
	func   = INT2PTR(double(*)(void *, float, int), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, i2);
OUTPUT:
	RETVAL

short
nci_spfi( c_func, p0, f1, i2 )
	SV* c_func
	void * p0
	float f1
	int i2
PREINIT:
	short(*func)(void *, float, int);
CODE:
	func   = INT2PTR(short(*)(void *, float, int), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, i2);
OUTPUT:
	RETVAL

float
nci_fpfi( c_func, p0, f1, i2 )
	SV* c_func
	void * p0
	float f1
	int i2
PREINIT:
	float(*func)(void *, float, int);
CODE:
	func   = INT2PTR(float(*)(void *, float, int), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, i2);
OUTPUT:
	RETVAL

char *
nci_tpfi( c_func, p0, f1, i2 )
	SV* c_func
	void * p0
	float f1
	int i2
PREINIT:
	char *(*func)(void *, float, int);
CODE:
	func   = INT2PTR(char *(*)(void *, float, int), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, i2);
OUTPUT:
	RETVAL

int
nci_ipfi( c_func, p0, f1, i2 )
	SV* c_func
	void * p0
	float f1
	int i2
PREINIT:
	int(*func)(void *, float, int);
CODE:
	func   = INT2PTR(int(*)(void *, float, int), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, i2);
OUTPUT:
	RETVAL

void *
nci_pvfi( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvfi( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvfi( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svfi( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvfi( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvfi( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivfi( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdfi( c_func, d0, f1, i2 )
	SV* c_func
	double d0
	float f1
	int i2
PREINIT:
	void *(*func)(double, float, int);
CODE:
	func   = INT2PTR(void *(*)(double, float, int), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, i2);
OUTPUT:
	RETVAL

void
nci_vdfi( c_func, d0, f1, i2 )
	SV* c_func
	double d0
	float f1
	int i2
PREINIT:
	void(*func)(double, float, int);
CODE:
	func   = INT2PTR(void(*)(double, float, int), SvIV(c_func) );
	(*func)(d0, f1, i2);

double
nci_ddfi( c_func, d0, f1, i2 )
	SV* c_func
	double d0
	float f1
	int i2
PREINIT:
	double(*func)(double, float, int);
CODE:
	func   = INT2PTR(double(*)(double, float, int), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, i2);
OUTPUT:
	RETVAL

short
nci_sdfi( c_func, d0, f1, i2 )
	SV* c_func
	double d0
	float f1
	int i2
PREINIT:
	short(*func)(double, float, int);
CODE:
	func   = INT2PTR(short(*)(double, float, int), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, i2);
OUTPUT:
	RETVAL

float
nci_fdfi( c_func, d0, f1, i2 )
	SV* c_func
	double d0
	float f1
	int i2
PREINIT:
	float(*func)(double, float, int);
CODE:
	func   = INT2PTR(float(*)(double, float, int), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, i2);
OUTPUT:
	RETVAL

char *
nci_tdfi( c_func, d0, f1, i2 )
	SV* c_func
	double d0
	float f1
	int i2
PREINIT:
	char *(*func)(double, float, int);
CODE:
	func   = INT2PTR(char *(*)(double, float, int), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, i2);
OUTPUT:
	RETVAL

int
nci_idfi( c_func, d0, f1, i2 )
	SV* c_func
	double d0
	float f1
	int i2
PREINIT:
	int(*func)(double, float, int);
CODE:
	func   = INT2PTR(int(*)(double, float, int), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, i2);
OUTPUT:
	RETVAL

void *
nci_psfi( c_func, s0, f1, i2 )
	SV* c_func
	short s0
	float f1
	int i2
PREINIT:
	void *(*func)(short, float, int);
CODE:
	func   = INT2PTR(void *(*)(short, float, int), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, i2);
OUTPUT:
	RETVAL

void
nci_vsfi( c_func, s0, f1, i2 )
	SV* c_func
	short s0
	float f1
	int i2
PREINIT:
	void(*func)(short, float, int);
CODE:
	func   = INT2PTR(void(*)(short, float, int), SvIV(c_func) );
	(*func)(s0, f1, i2);

double
nci_dsfi( c_func, s0, f1, i2 )
	SV* c_func
	short s0
	float f1
	int i2
PREINIT:
	double(*func)(short, float, int);
CODE:
	func   = INT2PTR(double(*)(short, float, int), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, i2);
OUTPUT:
	RETVAL

short
nci_ssfi( c_func, s0, f1, i2 )
	SV* c_func
	short s0
	float f1
	int i2
PREINIT:
	short(*func)(short, float, int);
CODE:
	func   = INT2PTR(short(*)(short, float, int), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, i2);
OUTPUT:
	RETVAL

float
nci_fsfi( c_func, s0, f1, i2 )
	SV* c_func
	short s0
	float f1
	int i2
PREINIT:
	float(*func)(short, float, int);
CODE:
	func   = INT2PTR(float(*)(short, float, int), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, i2);
OUTPUT:
	RETVAL

char *
nci_tsfi( c_func, s0, f1, i2 )
	SV* c_func
	short s0
	float f1
	int i2
PREINIT:
	char *(*func)(short, float, int);
CODE:
	func   = INT2PTR(char *(*)(short, float, int), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, i2);
OUTPUT:
	RETVAL

int
nci_isfi( c_func, s0, f1, i2 )
	SV* c_func
	short s0
	float f1
	int i2
PREINIT:
	int(*func)(short, float, int);
CODE:
	func   = INT2PTR(int(*)(short, float, int), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, i2);
OUTPUT:
	RETVAL

void *
nci_pffi( c_func, f0, f1, i2 )
	SV* c_func
	float f0
	float f1
	int i2
PREINIT:
	void *(*func)(float, float, int);
CODE:
	func   = INT2PTR(void *(*)(float, float, int), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, i2);
OUTPUT:
	RETVAL

void
nci_vffi( c_func, f0, f1, i2 )
	SV* c_func
	float f0
	float f1
	int i2
PREINIT:
	void(*func)(float, float, int);
CODE:
	func   = INT2PTR(void(*)(float, float, int), SvIV(c_func) );
	(*func)(f0, f1, i2);

double
nci_dffi( c_func, f0, f1, i2 )
	SV* c_func
	float f0
	float f1
	int i2
PREINIT:
	double(*func)(float, float, int);
CODE:
	func   = INT2PTR(double(*)(float, float, int), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, i2);
OUTPUT:
	RETVAL

short
nci_sffi( c_func, f0, f1, i2 )
	SV* c_func
	float f0
	float f1
	int i2
PREINIT:
	short(*func)(float, float, int);
CODE:
	func   = INT2PTR(short(*)(float, float, int), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, i2);
OUTPUT:
	RETVAL

float
nci_fffi( c_func, f0, f1, i2 )
	SV* c_func
	float f0
	float f1
	int i2
PREINIT:
	float(*func)(float, float, int);
CODE:
	func   = INT2PTR(float(*)(float, float, int), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, i2);
OUTPUT:
	RETVAL

char *
nci_tffi( c_func, f0, f1, i2 )
	SV* c_func
	float f0
	float f1
	int i2
PREINIT:
	char *(*func)(float, float, int);
CODE:
	func   = INT2PTR(char *(*)(float, float, int), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, i2);
OUTPUT:
	RETVAL

int
nci_iffi( c_func, f0, f1, i2 )
	SV* c_func
	float f0
	float f1
	int i2
PREINIT:
	int(*func)(float, float, int);
CODE:
	func   = INT2PTR(int(*)(float, float, int), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, i2);
OUTPUT:
	RETVAL

void *
nci_ptfi( c_func, t0, f1, i2 )
	SV* c_func
	char * t0
	float f1
	int i2
PREINIT:
	void *(*func)(char *, float, int);
CODE:
	func   = INT2PTR(void *(*)(char *, float, int), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, i2);
OUTPUT:
	RETVAL

void
nci_vtfi( c_func, t0, f1, i2 )
	SV* c_func
	char * t0
	float f1
	int i2
PREINIT:
	void(*func)(char *, float, int);
CODE:
	func   = INT2PTR(void(*)(char *, float, int), SvIV(c_func) );
	(*func)(t0, f1, i2);

double
nci_dtfi( c_func, t0, f1, i2 )
	SV* c_func
	char * t0
	float f1
	int i2
PREINIT:
	double(*func)(char *, float, int);
CODE:
	func   = INT2PTR(double(*)(char *, float, int), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, i2);
OUTPUT:
	RETVAL

short
nci_stfi( c_func, t0, f1, i2 )
	SV* c_func
	char * t0
	float f1
	int i2
PREINIT:
	short(*func)(char *, float, int);
CODE:
	func   = INT2PTR(short(*)(char *, float, int), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, i2);
OUTPUT:
	RETVAL

float
nci_ftfi( c_func, t0, f1, i2 )
	SV* c_func
	char * t0
	float f1
	int i2
PREINIT:
	float(*func)(char *, float, int);
CODE:
	func   = INT2PTR(float(*)(char *, float, int), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, i2);
OUTPUT:
	RETVAL

char *
nci_ttfi( c_func, t0, f1, i2 )
	SV* c_func
	char * t0
	float f1
	int i2
PREINIT:
	char *(*func)(char *, float, int);
CODE:
	func   = INT2PTR(char *(*)(char *, float, int), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, i2);
OUTPUT:
	RETVAL

int
nci_itfi( c_func, t0, f1, i2 )
	SV* c_func
	char * t0
	float f1
	int i2
PREINIT:
	int(*func)(char *, float, int);
CODE:
	func   = INT2PTR(int(*)(char *, float, int), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, i2);
OUTPUT:
	RETVAL

void *
nci_pifi( c_func, i0, f1, i2 )
	SV* c_func
	int i0
	float f1
	int i2
PREINIT:
	void *(*func)(int, float, int);
CODE:
	func   = INT2PTR(void *(*)(int, float, int), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, i2);
OUTPUT:
	RETVAL

void
nci_vifi( c_func, i0, f1, i2 )
	SV* c_func
	int i0
	float f1
	int i2
PREINIT:
	void(*func)(int, float, int);
CODE:
	func   = INT2PTR(void(*)(int, float, int), SvIV(c_func) );
	(*func)(i0, f1, i2);

double
nci_difi( c_func, i0, f1, i2 )
	SV* c_func
	int i0
	float f1
	int i2
PREINIT:
	double(*func)(int, float, int);
CODE:
	func   = INT2PTR(double(*)(int, float, int), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, i2);
OUTPUT:
	RETVAL

short
nci_sifi( c_func, i0, f1, i2 )
	SV* c_func
	int i0
	float f1
	int i2
PREINIT:
	short(*func)(int, float, int);
CODE:
	func   = INT2PTR(short(*)(int, float, int), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, i2);
OUTPUT:
	RETVAL

float
nci_fifi( c_func, i0, f1, i2 )
	SV* c_func
	int i0
	float f1
	int i2
PREINIT:
	float(*func)(int, float, int);
CODE:
	func   = INT2PTR(float(*)(int, float, int), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, i2);
OUTPUT:
	RETVAL

char *
nci_tifi( c_func, i0, f1, i2 )
	SV* c_func
	int i0
	float f1
	int i2
PREINIT:
	char *(*func)(int, float, int);
CODE:
	func   = INT2PTR(char *(*)(int, float, int), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, i2);
OUTPUT:
	RETVAL

int
nci_iifi( c_func, i0, f1, i2 )
	SV* c_func
	int i0
	float f1
	int i2
PREINIT:
	int(*func)(int, float, int);
CODE:
	func   = INT2PTR(int(*)(int, float, int), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, i2);
OUTPUT:
	RETVAL

void *
nci_ppti( c_func, p0, t1, i2 )
	SV* c_func
	void * p0
	char * t1
	int i2
PREINIT:
	void *(*func)(void *, char *, int);
CODE:
	func   = INT2PTR(void *(*)(void *, char *, int), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, i2);
OUTPUT:
	RETVAL

void
nci_vpti( c_func, p0, t1, i2 )
	SV* c_func
	void * p0
	char * t1
	int i2
PREINIT:
	void(*func)(void *, char *, int);
CODE:
	func   = INT2PTR(void(*)(void *, char *, int), SvIV(c_func) );
	(*func)(p0, t1, i2);

double
nci_dpti( c_func, p0, t1, i2 )
	SV* c_func
	void * p0
	char * t1
	int i2
PREINIT:
	double(*func)(void *, char *, int);
CODE:
	func   = INT2PTR(double(*)(void *, char *, int), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, i2);
OUTPUT:
	RETVAL

short
nci_spti( c_func, p0, t1, i2 )
	SV* c_func
	void * p0
	char * t1
	int i2
PREINIT:
	short(*func)(void *, char *, int);
CODE:
	func   = INT2PTR(short(*)(void *, char *, int), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, i2);
OUTPUT:
	RETVAL

float
nci_fpti( c_func, p0, t1, i2 )
	SV* c_func
	void * p0
	char * t1
	int i2
PREINIT:
	float(*func)(void *, char *, int);
CODE:
	func   = INT2PTR(float(*)(void *, char *, int), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, i2);
OUTPUT:
	RETVAL

char *
nci_tpti( c_func, p0, t1, i2 )
	SV* c_func
	void * p0
	char * t1
	int i2
PREINIT:
	char *(*func)(void *, char *, int);
CODE:
	func   = INT2PTR(char *(*)(void *, char *, int), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, i2);
OUTPUT:
	RETVAL

int
nci_ipti( c_func, p0, t1, i2 )
	SV* c_func
	void * p0
	char * t1
	int i2
PREINIT:
	int(*func)(void *, char *, int);
CODE:
	func   = INT2PTR(int(*)(void *, char *, int), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, i2);
OUTPUT:
	RETVAL

void *
nci_pvti( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvti( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvti( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svti( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvti( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvti( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivti( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdti( c_func, d0, t1, i2 )
	SV* c_func
	double d0
	char * t1
	int i2
PREINIT:
	void *(*func)(double, char *, int);
CODE:
	func   = INT2PTR(void *(*)(double, char *, int), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, i2);
OUTPUT:
	RETVAL

void
nci_vdti( c_func, d0, t1, i2 )
	SV* c_func
	double d0
	char * t1
	int i2
PREINIT:
	void(*func)(double, char *, int);
CODE:
	func   = INT2PTR(void(*)(double, char *, int), SvIV(c_func) );
	(*func)(d0, t1, i2);

double
nci_ddti( c_func, d0, t1, i2 )
	SV* c_func
	double d0
	char * t1
	int i2
PREINIT:
	double(*func)(double, char *, int);
CODE:
	func   = INT2PTR(double(*)(double, char *, int), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, i2);
OUTPUT:
	RETVAL

short
nci_sdti( c_func, d0, t1, i2 )
	SV* c_func
	double d0
	char * t1
	int i2
PREINIT:
	short(*func)(double, char *, int);
CODE:
	func   = INT2PTR(short(*)(double, char *, int), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, i2);
OUTPUT:
	RETVAL

float
nci_fdti( c_func, d0, t1, i2 )
	SV* c_func
	double d0
	char * t1
	int i2
PREINIT:
	float(*func)(double, char *, int);
CODE:
	func   = INT2PTR(float(*)(double, char *, int), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, i2);
OUTPUT:
	RETVAL

char *
nci_tdti( c_func, d0, t1, i2 )
	SV* c_func
	double d0
	char * t1
	int i2
PREINIT:
	char *(*func)(double, char *, int);
CODE:
	func   = INT2PTR(char *(*)(double, char *, int), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, i2);
OUTPUT:
	RETVAL

int
nci_idti( c_func, d0, t1, i2 )
	SV* c_func
	double d0
	char * t1
	int i2
PREINIT:
	int(*func)(double, char *, int);
CODE:
	func   = INT2PTR(int(*)(double, char *, int), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, i2);
OUTPUT:
	RETVAL

void *
nci_psti( c_func, s0, t1, i2 )
	SV* c_func
	short s0
	char * t1
	int i2
PREINIT:
	void *(*func)(short, char *, int);
CODE:
	func   = INT2PTR(void *(*)(short, char *, int), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, i2);
OUTPUT:
	RETVAL

void
nci_vsti( c_func, s0, t1, i2 )
	SV* c_func
	short s0
	char * t1
	int i2
PREINIT:
	void(*func)(short, char *, int);
CODE:
	func   = INT2PTR(void(*)(short, char *, int), SvIV(c_func) );
	(*func)(s0, t1, i2);

double
nci_dsti( c_func, s0, t1, i2 )
	SV* c_func
	short s0
	char * t1
	int i2
PREINIT:
	double(*func)(short, char *, int);
CODE:
	func   = INT2PTR(double(*)(short, char *, int), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, i2);
OUTPUT:
	RETVAL

short
nci_ssti( c_func, s0, t1, i2 )
	SV* c_func
	short s0
	char * t1
	int i2
PREINIT:
	short(*func)(short, char *, int);
CODE:
	func   = INT2PTR(short(*)(short, char *, int), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, i2);
OUTPUT:
	RETVAL

float
nci_fsti( c_func, s0, t1, i2 )
	SV* c_func
	short s0
	char * t1
	int i2
PREINIT:
	float(*func)(short, char *, int);
CODE:
	func   = INT2PTR(float(*)(short, char *, int), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, i2);
OUTPUT:
	RETVAL

char *
nci_tsti( c_func, s0, t1, i2 )
	SV* c_func
	short s0
	char * t1
	int i2
PREINIT:
	char *(*func)(short, char *, int);
CODE:
	func   = INT2PTR(char *(*)(short, char *, int), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, i2);
OUTPUT:
	RETVAL

int
nci_isti( c_func, s0, t1, i2 )
	SV* c_func
	short s0
	char * t1
	int i2
PREINIT:
	int(*func)(short, char *, int);
CODE:
	func   = INT2PTR(int(*)(short, char *, int), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, i2);
OUTPUT:
	RETVAL

void *
nci_pfti( c_func, f0, t1, i2 )
	SV* c_func
	float f0
	char * t1
	int i2
PREINIT:
	void *(*func)(float, char *, int);
CODE:
	func   = INT2PTR(void *(*)(float, char *, int), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, i2);
OUTPUT:
	RETVAL

void
nci_vfti( c_func, f0, t1, i2 )
	SV* c_func
	float f0
	char * t1
	int i2
PREINIT:
	void(*func)(float, char *, int);
CODE:
	func   = INT2PTR(void(*)(float, char *, int), SvIV(c_func) );
	(*func)(f0, t1, i2);

double
nci_dfti( c_func, f0, t1, i2 )
	SV* c_func
	float f0
	char * t1
	int i2
PREINIT:
	double(*func)(float, char *, int);
CODE:
	func   = INT2PTR(double(*)(float, char *, int), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, i2);
OUTPUT:
	RETVAL

short
nci_sfti( c_func, f0, t1, i2 )
	SV* c_func
	float f0
	char * t1
	int i2
PREINIT:
	short(*func)(float, char *, int);
CODE:
	func   = INT2PTR(short(*)(float, char *, int), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, i2);
OUTPUT:
	RETVAL

float
nci_ffti( c_func, f0, t1, i2 )
	SV* c_func
	float f0
	char * t1
	int i2
PREINIT:
	float(*func)(float, char *, int);
CODE:
	func   = INT2PTR(float(*)(float, char *, int), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, i2);
OUTPUT:
	RETVAL

char *
nci_tfti( c_func, f0, t1, i2 )
	SV* c_func
	float f0
	char * t1
	int i2
PREINIT:
	char *(*func)(float, char *, int);
CODE:
	func   = INT2PTR(char *(*)(float, char *, int), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, i2);
OUTPUT:
	RETVAL

int
nci_ifti( c_func, f0, t1, i2 )
	SV* c_func
	float f0
	char * t1
	int i2
PREINIT:
	int(*func)(float, char *, int);
CODE:
	func   = INT2PTR(int(*)(float, char *, int), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, i2);
OUTPUT:
	RETVAL

void *
nci_ptti( c_func, t0, t1, i2 )
	SV* c_func
	char * t0
	char * t1
	int i2
PREINIT:
	void *(*func)(char *, char *, int);
CODE:
	func   = INT2PTR(void *(*)(char *, char *, int), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, i2);
OUTPUT:
	RETVAL

void
nci_vtti( c_func, t0, t1, i2 )
	SV* c_func
	char * t0
	char * t1
	int i2
PREINIT:
	void(*func)(char *, char *, int);
CODE:
	func   = INT2PTR(void(*)(char *, char *, int), SvIV(c_func) );
	(*func)(t0, t1, i2);

double
nci_dtti( c_func, t0, t1, i2 )
	SV* c_func
	char * t0
	char * t1
	int i2
PREINIT:
	double(*func)(char *, char *, int);
CODE:
	func   = INT2PTR(double(*)(char *, char *, int), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, i2);
OUTPUT:
	RETVAL

short
nci_stti( c_func, t0, t1, i2 )
	SV* c_func
	char * t0
	char * t1
	int i2
PREINIT:
	short(*func)(char *, char *, int);
CODE:
	func   = INT2PTR(short(*)(char *, char *, int), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, i2);
OUTPUT:
	RETVAL

float
nci_ftti( c_func, t0, t1, i2 )
	SV* c_func
	char * t0
	char * t1
	int i2
PREINIT:
	float(*func)(char *, char *, int);
CODE:
	func   = INT2PTR(float(*)(char *, char *, int), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, i2);
OUTPUT:
	RETVAL

char *
nci_ttti( c_func, t0, t1, i2 )
	SV* c_func
	char * t0
	char * t1
	int i2
PREINIT:
	char *(*func)(char *, char *, int);
CODE:
	func   = INT2PTR(char *(*)(char *, char *, int), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, i2);
OUTPUT:
	RETVAL

int
nci_itti( c_func, t0, t1, i2 )
	SV* c_func
	char * t0
	char * t1
	int i2
PREINIT:
	int(*func)(char *, char *, int);
CODE:
	func   = INT2PTR(int(*)(char *, char *, int), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, i2);
OUTPUT:
	RETVAL

void *
nci_piti( c_func, i0, t1, i2 )
	SV* c_func
	int i0
	char * t1
	int i2
PREINIT:
	void *(*func)(int, char *, int);
CODE:
	func   = INT2PTR(void *(*)(int, char *, int), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, i2);
OUTPUT:
	RETVAL

void
nci_viti( c_func, i0, t1, i2 )
	SV* c_func
	int i0
	char * t1
	int i2
PREINIT:
	void(*func)(int, char *, int);
CODE:
	func   = INT2PTR(void(*)(int, char *, int), SvIV(c_func) );
	(*func)(i0, t1, i2);

double
nci_diti( c_func, i0, t1, i2 )
	SV* c_func
	int i0
	char * t1
	int i2
PREINIT:
	double(*func)(int, char *, int);
CODE:
	func   = INT2PTR(double(*)(int, char *, int), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, i2);
OUTPUT:
	RETVAL

short
nci_siti( c_func, i0, t1, i2 )
	SV* c_func
	int i0
	char * t1
	int i2
PREINIT:
	short(*func)(int, char *, int);
CODE:
	func   = INT2PTR(short(*)(int, char *, int), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, i2);
OUTPUT:
	RETVAL

float
nci_fiti( c_func, i0, t1, i2 )
	SV* c_func
	int i0
	char * t1
	int i2
PREINIT:
	float(*func)(int, char *, int);
CODE:
	func   = INT2PTR(float(*)(int, char *, int), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, i2);
OUTPUT:
	RETVAL

char *
nci_titi( c_func, i0, t1, i2 )
	SV* c_func
	int i0
	char * t1
	int i2
PREINIT:
	char *(*func)(int, char *, int);
CODE:
	func   = INT2PTR(char *(*)(int, char *, int), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, i2);
OUTPUT:
	RETVAL

int
nci_iiti( c_func, i0, t1, i2 )
	SV* c_func
	int i0
	char * t1
	int i2
PREINIT:
	int(*func)(int, char *, int);
CODE:
	func   = INT2PTR(int(*)(int, char *, int), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, i2);
OUTPUT:
	RETVAL

void *
nci_ppii( c_func, p0, i1, i2 )
	SV* c_func
	void * p0
	int i1
	int i2
PREINIT:
	void *(*func)(void *, int, int);
CODE:
	func   = INT2PTR(void *(*)(void *, int, int), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, i2);
OUTPUT:
	RETVAL

void
nci_vpii( c_func, p0, i1, i2 )
	SV* c_func
	void * p0
	int i1
	int i2
PREINIT:
	void(*func)(void *, int, int);
CODE:
	func   = INT2PTR(void(*)(void *, int, int), SvIV(c_func) );
	(*func)(p0, i1, i2);

double
nci_dpii( c_func, p0, i1, i2 )
	SV* c_func
	void * p0
	int i1
	int i2
PREINIT:
	double(*func)(void *, int, int);
CODE:
	func   = INT2PTR(double(*)(void *, int, int), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, i2);
OUTPUT:
	RETVAL

short
nci_spii( c_func, p0, i1, i2 )
	SV* c_func
	void * p0
	int i1
	int i2
PREINIT:
	short(*func)(void *, int, int);
CODE:
	func   = INT2PTR(short(*)(void *, int, int), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, i2);
OUTPUT:
	RETVAL

float
nci_fpii( c_func, p0, i1, i2 )
	SV* c_func
	void * p0
	int i1
	int i2
PREINIT:
	float(*func)(void *, int, int);
CODE:
	func   = INT2PTR(float(*)(void *, int, int), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, i2);
OUTPUT:
	RETVAL

char *
nci_tpii( c_func, p0, i1, i2 )
	SV* c_func
	void * p0
	int i1
	int i2
PREINIT:
	char *(*func)(void *, int, int);
CODE:
	func   = INT2PTR(char *(*)(void *, int, int), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, i2);
OUTPUT:
	RETVAL

int
nci_ipii( c_func, p0, i1, i2 )
	SV* c_func
	void * p0
	int i1
	int i2
PREINIT:
	int(*func)(void *, int, int);
CODE:
	func   = INT2PTR(int(*)(void *, int, int), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, i2);
OUTPUT:
	RETVAL

void *
nci_pvii( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvii( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvii( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svii( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvii( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvii( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivii( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdii( c_func, d0, i1, i2 )
	SV* c_func
	double d0
	int i1
	int i2
PREINIT:
	void *(*func)(double, int, int);
CODE:
	func   = INT2PTR(void *(*)(double, int, int), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, i2);
OUTPUT:
	RETVAL

void
nci_vdii( c_func, d0, i1, i2 )
	SV* c_func
	double d0
	int i1
	int i2
PREINIT:
	void(*func)(double, int, int);
CODE:
	func   = INT2PTR(void(*)(double, int, int), SvIV(c_func) );
	(*func)(d0, i1, i2);

double
nci_ddii( c_func, d0, i1, i2 )
	SV* c_func
	double d0
	int i1
	int i2
PREINIT:
	double(*func)(double, int, int);
CODE:
	func   = INT2PTR(double(*)(double, int, int), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, i2);
OUTPUT:
	RETVAL

short
nci_sdii( c_func, d0, i1, i2 )
	SV* c_func
	double d0
	int i1
	int i2
PREINIT:
	short(*func)(double, int, int);
CODE:
	func   = INT2PTR(short(*)(double, int, int), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, i2);
OUTPUT:
	RETVAL

float
nci_fdii( c_func, d0, i1, i2 )
	SV* c_func
	double d0
	int i1
	int i2
PREINIT:
	float(*func)(double, int, int);
CODE:
	func   = INT2PTR(float(*)(double, int, int), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, i2);
OUTPUT:
	RETVAL

char *
nci_tdii( c_func, d0, i1, i2 )
	SV* c_func
	double d0
	int i1
	int i2
PREINIT:
	char *(*func)(double, int, int);
CODE:
	func   = INT2PTR(char *(*)(double, int, int), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, i2);
OUTPUT:
	RETVAL

int
nci_idii( c_func, d0, i1, i2 )
	SV* c_func
	double d0
	int i1
	int i2
PREINIT:
	int(*func)(double, int, int);
CODE:
	func   = INT2PTR(int(*)(double, int, int), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, i2);
OUTPUT:
	RETVAL

void *
nci_psii( c_func, s0, i1, i2 )
	SV* c_func
	short s0
	int i1
	int i2
PREINIT:
	void *(*func)(short, int, int);
CODE:
	func   = INT2PTR(void *(*)(short, int, int), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, i2);
OUTPUT:
	RETVAL

void
nci_vsii( c_func, s0, i1, i2 )
	SV* c_func
	short s0
	int i1
	int i2
PREINIT:
	void(*func)(short, int, int);
CODE:
	func   = INT2PTR(void(*)(short, int, int), SvIV(c_func) );
	(*func)(s0, i1, i2);

double
nci_dsii( c_func, s0, i1, i2 )
	SV* c_func
	short s0
	int i1
	int i2
PREINIT:
	double(*func)(short, int, int);
CODE:
	func   = INT2PTR(double(*)(short, int, int), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, i2);
OUTPUT:
	RETVAL

short
nci_ssii( c_func, s0, i1, i2 )
	SV* c_func
	short s0
	int i1
	int i2
PREINIT:
	short(*func)(short, int, int);
CODE:
	func   = INT2PTR(short(*)(short, int, int), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, i2);
OUTPUT:
	RETVAL

float
nci_fsii( c_func, s0, i1, i2 )
	SV* c_func
	short s0
	int i1
	int i2
PREINIT:
	float(*func)(short, int, int);
CODE:
	func   = INT2PTR(float(*)(short, int, int), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, i2);
OUTPUT:
	RETVAL

char *
nci_tsii( c_func, s0, i1, i2 )
	SV* c_func
	short s0
	int i1
	int i2
PREINIT:
	char *(*func)(short, int, int);
CODE:
	func   = INT2PTR(char *(*)(short, int, int), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, i2);
OUTPUT:
	RETVAL

int
nci_isii( c_func, s0, i1, i2 )
	SV* c_func
	short s0
	int i1
	int i2
PREINIT:
	int(*func)(short, int, int);
CODE:
	func   = INT2PTR(int(*)(short, int, int), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, i2);
OUTPUT:
	RETVAL

void *
nci_pfii( c_func, f0, i1, i2 )
	SV* c_func
	float f0
	int i1
	int i2
PREINIT:
	void *(*func)(float, int, int);
CODE:
	func   = INT2PTR(void *(*)(float, int, int), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, i2);
OUTPUT:
	RETVAL

void
nci_vfii( c_func, f0, i1, i2 )
	SV* c_func
	float f0
	int i1
	int i2
PREINIT:
	void(*func)(float, int, int);
CODE:
	func   = INT2PTR(void(*)(float, int, int), SvIV(c_func) );
	(*func)(f0, i1, i2);

double
nci_dfii( c_func, f0, i1, i2 )
	SV* c_func
	float f0
	int i1
	int i2
PREINIT:
	double(*func)(float, int, int);
CODE:
	func   = INT2PTR(double(*)(float, int, int), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, i2);
OUTPUT:
	RETVAL

short
nci_sfii( c_func, f0, i1, i2 )
	SV* c_func
	float f0
	int i1
	int i2
PREINIT:
	short(*func)(float, int, int);
CODE:
	func   = INT2PTR(short(*)(float, int, int), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, i2);
OUTPUT:
	RETVAL

float
nci_ffii( c_func, f0, i1, i2 )
	SV* c_func
	float f0
	int i1
	int i2
PREINIT:
	float(*func)(float, int, int);
CODE:
	func   = INT2PTR(float(*)(float, int, int), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, i2);
OUTPUT:
	RETVAL

char *
nci_tfii( c_func, f0, i1, i2 )
	SV* c_func
	float f0
	int i1
	int i2
PREINIT:
	char *(*func)(float, int, int);
CODE:
	func   = INT2PTR(char *(*)(float, int, int), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, i2);
OUTPUT:
	RETVAL

int
nci_ifii( c_func, f0, i1, i2 )
	SV* c_func
	float f0
	int i1
	int i2
PREINIT:
	int(*func)(float, int, int);
CODE:
	func   = INT2PTR(int(*)(float, int, int), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, i2);
OUTPUT:
	RETVAL

void *
nci_ptii( c_func, t0, i1, i2 )
	SV* c_func
	char * t0
	int i1
	int i2
PREINIT:
	void *(*func)(char *, int, int);
CODE:
	func   = INT2PTR(void *(*)(char *, int, int), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, i2);
OUTPUT:
	RETVAL

void
nci_vtii( c_func, t0, i1, i2 )
	SV* c_func
	char * t0
	int i1
	int i2
PREINIT:
	void(*func)(char *, int, int);
CODE:
	func   = INT2PTR(void(*)(char *, int, int), SvIV(c_func) );
	(*func)(t0, i1, i2);

double
nci_dtii( c_func, t0, i1, i2 )
	SV* c_func
	char * t0
	int i1
	int i2
PREINIT:
	double(*func)(char *, int, int);
CODE:
	func   = INT2PTR(double(*)(char *, int, int), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, i2);
OUTPUT:
	RETVAL

short
nci_stii( c_func, t0, i1, i2 )
	SV* c_func
	char * t0
	int i1
	int i2
PREINIT:
	short(*func)(char *, int, int);
CODE:
	func   = INT2PTR(short(*)(char *, int, int), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, i2);
OUTPUT:
	RETVAL

float
nci_ftii( c_func, t0, i1, i2 )
	SV* c_func
	char * t0
	int i1
	int i2
PREINIT:
	float(*func)(char *, int, int);
CODE:
	func   = INT2PTR(float(*)(char *, int, int), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, i2);
OUTPUT:
	RETVAL

char *
nci_ttii( c_func, t0, i1, i2 )
	SV* c_func
	char * t0
	int i1
	int i2
PREINIT:
	char *(*func)(char *, int, int);
CODE:
	func   = INT2PTR(char *(*)(char *, int, int), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, i2);
OUTPUT:
	RETVAL

int
nci_itii( c_func, t0, i1, i2 )
	SV* c_func
	char * t0
	int i1
	int i2
PREINIT:
	int(*func)(char *, int, int);
CODE:
	func   = INT2PTR(int(*)(char *, int, int), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, i2);
OUTPUT:
	RETVAL

void *
nci_piii( c_func, i0, i1, i2 )
	SV* c_func
	int i0
	int i1
	int i2
PREINIT:
	void *(*func)(int, int, int);
CODE:
	func   = INT2PTR(void *(*)(int, int, int), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, i2);
OUTPUT:
	RETVAL

void
nci_viii( c_func, i0, i1, i2 )
	SV* c_func
	int i0
	int i1
	int i2
PREINIT:
	void(*func)(int, int, int);
CODE:
	func   = INT2PTR(void(*)(int, int, int), SvIV(c_func) );
	(*func)(i0, i1, i2);

double
nci_diii( c_func, i0, i1, i2 )
	SV* c_func
	int i0
	int i1
	int i2
PREINIT:
	double(*func)(int, int, int);
CODE:
	func   = INT2PTR(double(*)(int, int, int), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, i2);
OUTPUT:
	RETVAL

short
nci_siii( c_func, i0, i1, i2 )
	SV* c_func
	int i0
	int i1
	int i2
PREINIT:
	short(*func)(int, int, int);
CODE:
	func   = INT2PTR(short(*)(int, int, int), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, i2);
OUTPUT:
	RETVAL

float
nci_fiii( c_func, i0, i1, i2 )
	SV* c_func
	int i0
	int i1
	int i2
PREINIT:
	float(*func)(int, int, int);
CODE:
	func   = INT2PTR(float(*)(int, int, int), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, i2);
OUTPUT:
	RETVAL

char *
nci_tiii( c_func, i0, i1, i2 )
	SV* c_func
	int i0
	int i1
	int i2
PREINIT:
	char *(*func)(int, int, int);
CODE:
	func   = INT2PTR(char *(*)(int, int, int), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, i2);
OUTPUT:
	RETVAL

int
nci_iiii( c_func, i0, i1, i2 )
	SV* c_func
	int i0
	int i1
	int i2
PREINIT:
	int(*func)(int, int, int);
CODE:
	func   = INT2PTR(int(*)(int, int, int), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, i2);
OUTPUT:
	RETVAL

void *
nci_ppppp( c_func, p0, p1, p2, p3 )
	SV* c_func
	void * p0
	void * p1
	void * p2
	void * p3
PREINIT:
	void *(*func)(void *, void *, void *, void *);
CODE:
	func   = INT2PTR(void *(*)(void *, void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, p2, p3);
OUTPUT:
	RETVAL

void
nci_vpppp( c_func, p0, p1, p2, p3 )
	SV* c_func
	void * p0
	void * p1
	void * p2
	void * p3
PREINIT:
	void(*func)(void *, void *, void *, void *);
CODE:
	func   = INT2PTR(void(*)(void *, void *, void *, void *), SvIV(c_func) );
	(*func)(p0, p1, p2, p3);

double
nci_dpppp( c_func, p0, p1, p2, p3 )
	SV* c_func
	void * p0
	void * p1
	void * p2
	void * p3
PREINIT:
	double(*func)(void *, void *, void *, void *);
CODE:
	func   = INT2PTR(double(*)(void *, void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, p2, p3);
OUTPUT:
	RETVAL

short
nci_spppp( c_func, p0, p1, p2, p3 )
	SV* c_func
	void * p0
	void * p1
	void * p2
	void * p3
PREINIT:
	short(*func)(void *, void *, void *, void *);
CODE:
	func   = INT2PTR(short(*)(void *, void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, p2, p3);
OUTPUT:
	RETVAL

float
nci_fpppp( c_func, p0, p1, p2, p3 )
	SV* c_func
	void * p0
	void * p1
	void * p2
	void * p3
PREINIT:
	float(*func)(void *, void *, void *, void *);
CODE:
	func   = INT2PTR(float(*)(void *, void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, p2, p3);
OUTPUT:
	RETVAL

char *
nci_tpppp( c_func, p0, p1, p2, p3 )
	SV* c_func
	void * p0
	void * p1
	void * p2
	void * p3
PREINIT:
	char *(*func)(void *, void *, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, p2, p3);
OUTPUT:
	RETVAL

int
nci_ipppp( c_func, p0, p1, p2, p3 )
	SV* c_func
	void * p0
	void * p1
	void * p2
	void * p3
PREINIT:
	int(*func)(void *, void *, void *, void *);
CODE:
	func   = INT2PTR(int(*)(void *, void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, p2, p3);
OUTPUT:
	RETVAL

void *
nci_pvppp( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvppp( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvppp( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svppp( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvppp( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvppp( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivppp( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdppp( c_func, d0, p1, p2, p3 )
	SV* c_func
	double d0
	void * p1
	void * p2
	void * p3
PREINIT:
	void *(*func)(double, void *, void *, void *);
CODE:
	func   = INT2PTR(void *(*)(double, void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, p2, p3);
OUTPUT:
	RETVAL

void
nci_vdppp( c_func, d0, p1, p2, p3 )
	SV* c_func
	double d0
	void * p1
	void * p2
	void * p3
PREINIT:
	void(*func)(double, void *, void *, void *);
CODE:
	func   = INT2PTR(void(*)(double, void *, void *, void *), SvIV(c_func) );
	(*func)(d0, p1, p2, p3);

double
nci_ddppp( c_func, d0, p1, p2, p3 )
	SV* c_func
	double d0
	void * p1
	void * p2
	void * p3
PREINIT:
	double(*func)(double, void *, void *, void *);
CODE:
	func   = INT2PTR(double(*)(double, void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, p2, p3);
OUTPUT:
	RETVAL

short
nci_sdppp( c_func, d0, p1, p2, p3 )
	SV* c_func
	double d0
	void * p1
	void * p2
	void * p3
PREINIT:
	short(*func)(double, void *, void *, void *);
CODE:
	func   = INT2PTR(short(*)(double, void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, p2, p3);
OUTPUT:
	RETVAL

float
nci_fdppp( c_func, d0, p1, p2, p3 )
	SV* c_func
	double d0
	void * p1
	void * p2
	void * p3
PREINIT:
	float(*func)(double, void *, void *, void *);
CODE:
	func   = INT2PTR(float(*)(double, void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, p2, p3);
OUTPUT:
	RETVAL

char *
nci_tdppp( c_func, d0, p1, p2, p3 )
	SV* c_func
	double d0
	void * p1
	void * p2
	void * p3
PREINIT:
	char *(*func)(double, void *, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(double, void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, p2, p3);
OUTPUT:
	RETVAL

int
nci_idppp( c_func, d0, p1, p2, p3 )
	SV* c_func
	double d0
	void * p1
	void * p2
	void * p3
PREINIT:
	int(*func)(double, void *, void *, void *);
CODE:
	func   = INT2PTR(int(*)(double, void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, p2, p3);
OUTPUT:
	RETVAL

void *
nci_psppp( c_func, s0, p1, p2, p3 )
	SV* c_func
	short s0
	void * p1
	void * p2
	void * p3
PREINIT:
	void *(*func)(short, void *, void *, void *);
CODE:
	func   = INT2PTR(void *(*)(short, void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, p2, p3);
OUTPUT:
	RETVAL

void
nci_vsppp( c_func, s0, p1, p2, p3 )
	SV* c_func
	short s0
	void * p1
	void * p2
	void * p3
PREINIT:
	void(*func)(short, void *, void *, void *);
CODE:
	func   = INT2PTR(void(*)(short, void *, void *, void *), SvIV(c_func) );
	(*func)(s0, p1, p2, p3);

double
nci_dsppp( c_func, s0, p1, p2, p3 )
	SV* c_func
	short s0
	void * p1
	void * p2
	void * p3
PREINIT:
	double(*func)(short, void *, void *, void *);
CODE:
	func   = INT2PTR(double(*)(short, void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, p2, p3);
OUTPUT:
	RETVAL

short
nci_ssppp( c_func, s0, p1, p2, p3 )
	SV* c_func
	short s0
	void * p1
	void * p2
	void * p3
PREINIT:
	short(*func)(short, void *, void *, void *);
CODE:
	func   = INT2PTR(short(*)(short, void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, p2, p3);
OUTPUT:
	RETVAL

float
nci_fsppp( c_func, s0, p1, p2, p3 )
	SV* c_func
	short s0
	void * p1
	void * p2
	void * p3
PREINIT:
	float(*func)(short, void *, void *, void *);
CODE:
	func   = INT2PTR(float(*)(short, void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, p2, p3);
OUTPUT:
	RETVAL

char *
nci_tsppp( c_func, s0, p1, p2, p3 )
	SV* c_func
	short s0
	void * p1
	void * p2
	void * p3
PREINIT:
	char *(*func)(short, void *, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(short, void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, p2, p3);
OUTPUT:
	RETVAL

int
nci_isppp( c_func, s0, p1, p2, p3 )
	SV* c_func
	short s0
	void * p1
	void * p2
	void * p3
PREINIT:
	int(*func)(short, void *, void *, void *);
CODE:
	func   = INT2PTR(int(*)(short, void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, p2, p3);
OUTPUT:
	RETVAL

void *
nci_pfppp( c_func, f0, p1, p2, p3 )
	SV* c_func
	float f0
	void * p1
	void * p2
	void * p3
PREINIT:
	void *(*func)(float, void *, void *, void *);
CODE:
	func   = INT2PTR(void *(*)(float, void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, p2, p3);
OUTPUT:
	RETVAL

void
nci_vfppp( c_func, f0, p1, p2, p3 )
	SV* c_func
	float f0
	void * p1
	void * p2
	void * p3
PREINIT:
	void(*func)(float, void *, void *, void *);
CODE:
	func   = INT2PTR(void(*)(float, void *, void *, void *), SvIV(c_func) );
	(*func)(f0, p1, p2, p3);

double
nci_dfppp( c_func, f0, p1, p2, p3 )
	SV* c_func
	float f0
	void * p1
	void * p2
	void * p3
PREINIT:
	double(*func)(float, void *, void *, void *);
CODE:
	func   = INT2PTR(double(*)(float, void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, p2, p3);
OUTPUT:
	RETVAL

short
nci_sfppp( c_func, f0, p1, p2, p3 )
	SV* c_func
	float f0
	void * p1
	void * p2
	void * p3
PREINIT:
	short(*func)(float, void *, void *, void *);
CODE:
	func   = INT2PTR(short(*)(float, void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, p2, p3);
OUTPUT:
	RETVAL

float
nci_ffppp( c_func, f0, p1, p2, p3 )
	SV* c_func
	float f0
	void * p1
	void * p2
	void * p3
PREINIT:
	float(*func)(float, void *, void *, void *);
CODE:
	func   = INT2PTR(float(*)(float, void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, p2, p3);
OUTPUT:
	RETVAL

char *
nci_tfppp( c_func, f0, p1, p2, p3 )
	SV* c_func
	float f0
	void * p1
	void * p2
	void * p3
PREINIT:
	char *(*func)(float, void *, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(float, void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, p2, p3);
OUTPUT:
	RETVAL

int
nci_ifppp( c_func, f0, p1, p2, p3 )
	SV* c_func
	float f0
	void * p1
	void * p2
	void * p3
PREINIT:
	int(*func)(float, void *, void *, void *);
CODE:
	func   = INT2PTR(int(*)(float, void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, p2, p3);
OUTPUT:
	RETVAL

void *
nci_ptppp( c_func, t0, p1, p2, p3 )
	SV* c_func
	char * t0
	void * p1
	void * p2
	void * p3
PREINIT:
	void *(*func)(char *, void *, void *, void *);
CODE:
	func   = INT2PTR(void *(*)(char *, void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, p2, p3);
OUTPUT:
	RETVAL

void
nci_vtppp( c_func, t0, p1, p2, p3 )
	SV* c_func
	char * t0
	void * p1
	void * p2
	void * p3
PREINIT:
	void(*func)(char *, void *, void *, void *);
CODE:
	func   = INT2PTR(void(*)(char *, void *, void *, void *), SvIV(c_func) );
	(*func)(t0, p1, p2, p3);

double
nci_dtppp( c_func, t0, p1, p2, p3 )
	SV* c_func
	char * t0
	void * p1
	void * p2
	void * p3
PREINIT:
	double(*func)(char *, void *, void *, void *);
CODE:
	func   = INT2PTR(double(*)(char *, void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, p2, p3);
OUTPUT:
	RETVAL

short
nci_stppp( c_func, t0, p1, p2, p3 )
	SV* c_func
	char * t0
	void * p1
	void * p2
	void * p3
PREINIT:
	short(*func)(char *, void *, void *, void *);
CODE:
	func   = INT2PTR(short(*)(char *, void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, p2, p3);
OUTPUT:
	RETVAL

float
nci_ftppp( c_func, t0, p1, p2, p3 )
	SV* c_func
	char * t0
	void * p1
	void * p2
	void * p3
PREINIT:
	float(*func)(char *, void *, void *, void *);
CODE:
	func   = INT2PTR(float(*)(char *, void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, p2, p3);
OUTPUT:
	RETVAL

char *
nci_ttppp( c_func, t0, p1, p2, p3 )
	SV* c_func
	char * t0
	void * p1
	void * p2
	void * p3
PREINIT:
	char *(*func)(char *, void *, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, p2, p3);
OUTPUT:
	RETVAL

int
nci_itppp( c_func, t0, p1, p2, p3 )
	SV* c_func
	char * t0
	void * p1
	void * p2
	void * p3
PREINIT:
	int(*func)(char *, void *, void *, void *);
CODE:
	func   = INT2PTR(int(*)(char *, void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, p2, p3);
OUTPUT:
	RETVAL

void *
nci_pippp( c_func, i0, p1, p2, p3 )
	SV* c_func
	int i0
	void * p1
	void * p2
	void * p3
PREINIT:
	void *(*func)(int, void *, void *, void *);
CODE:
	func   = INT2PTR(void *(*)(int, void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, p2, p3);
OUTPUT:
	RETVAL

void
nci_vippp( c_func, i0, p1, p2, p3 )
	SV* c_func
	int i0
	void * p1
	void * p2
	void * p3
PREINIT:
	void(*func)(int, void *, void *, void *);
CODE:
	func   = INT2PTR(void(*)(int, void *, void *, void *), SvIV(c_func) );
	(*func)(i0, p1, p2, p3);

double
nci_dippp( c_func, i0, p1, p2, p3 )
	SV* c_func
	int i0
	void * p1
	void * p2
	void * p3
PREINIT:
	double(*func)(int, void *, void *, void *);
CODE:
	func   = INT2PTR(double(*)(int, void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, p2, p3);
OUTPUT:
	RETVAL

short
nci_sippp( c_func, i0, p1, p2, p3 )
	SV* c_func
	int i0
	void * p1
	void * p2
	void * p3
PREINIT:
	short(*func)(int, void *, void *, void *);
CODE:
	func   = INT2PTR(short(*)(int, void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, p2, p3);
OUTPUT:
	RETVAL

float
nci_fippp( c_func, i0, p1, p2, p3 )
	SV* c_func
	int i0
	void * p1
	void * p2
	void * p3
PREINIT:
	float(*func)(int, void *, void *, void *);
CODE:
	func   = INT2PTR(float(*)(int, void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, p2, p3);
OUTPUT:
	RETVAL

char *
nci_tippp( c_func, i0, p1, p2, p3 )
	SV* c_func
	int i0
	void * p1
	void * p2
	void * p3
PREINIT:
	char *(*func)(int, void *, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(int, void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, p2, p3);
OUTPUT:
	RETVAL

int
nci_iippp( c_func, i0, p1, p2, p3 )
	SV* c_func
	int i0
	void * p1
	void * p2
	void * p3
PREINIT:
	int(*func)(int, void *, void *, void *);
CODE:
	func   = INT2PTR(int(*)(int, void *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, p2, p3);
OUTPUT:
	RETVAL

void *
nci_ppdpp( c_func, p0, d1, p2, p3 )
	SV* c_func
	void * p0
	double d1
	void * p2
	void * p3
PREINIT:
	void *(*func)(void *, double, void *, void *);
CODE:
	func   = INT2PTR(void *(*)(void *, double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, p2, p3);
OUTPUT:
	RETVAL

void
nci_vpdpp( c_func, p0, d1, p2, p3 )
	SV* c_func
	void * p0
	double d1
	void * p2
	void * p3
PREINIT:
	void(*func)(void *, double, void *, void *);
CODE:
	func   = INT2PTR(void(*)(void *, double, void *, void *), SvIV(c_func) );
	(*func)(p0, d1, p2, p3);

double
nci_dpdpp( c_func, p0, d1, p2, p3 )
	SV* c_func
	void * p0
	double d1
	void * p2
	void * p3
PREINIT:
	double(*func)(void *, double, void *, void *);
CODE:
	func   = INT2PTR(double(*)(void *, double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, p2, p3);
OUTPUT:
	RETVAL

short
nci_spdpp( c_func, p0, d1, p2, p3 )
	SV* c_func
	void * p0
	double d1
	void * p2
	void * p3
PREINIT:
	short(*func)(void *, double, void *, void *);
CODE:
	func   = INT2PTR(short(*)(void *, double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, p2, p3);
OUTPUT:
	RETVAL

float
nci_fpdpp( c_func, p0, d1, p2, p3 )
	SV* c_func
	void * p0
	double d1
	void * p2
	void * p3
PREINIT:
	float(*func)(void *, double, void *, void *);
CODE:
	func   = INT2PTR(float(*)(void *, double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, p2, p3);
OUTPUT:
	RETVAL

char *
nci_tpdpp( c_func, p0, d1, p2, p3 )
	SV* c_func
	void * p0
	double d1
	void * p2
	void * p3
PREINIT:
	char *(*func)(void *, double, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, p2, p3);
OUTPUT:
	RETVAL

int
nci_ipdpp( c_func, p0, d1, p2, p3 )
	SV* c_func
	void * p0
	double d1
	void * p2
	void * p3
PREINIT:
	int(*func)(void *, double, void *, void *);
CODE:
	func   = INT2PTR(int(*)(void *, double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, p2, p3);
OUTPUT:
	RETVAL

void *
nci_pvdpp( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvdpp( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvdpp( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svdpp( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvdpp( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvdpp( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivdpp( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pddpp( c_func, d0, d1, p2, p3 )
	SV* c_func
	double d0
	double d1
	void * p2
	void * p3
PREINIT:
	void *(*func)(double, double, void *, void *);
CODE:
	func   = INT2PTR(void *(*)(double, double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, p2, p3);
OUTPUT:
	RETVAL

void
nci_vddpp( c_func, d0, d1, p2, p3 )
	SV* c_func
	double d0
	double d1
	void * p2
	void * p3
PREINIT:
	void(*func)(double, double, void *, void *);
CODE:
	func   = INT2PTR(void(*)(double, double, void *, void *), SvIV(c_func) );
	(*func)(d0, d1, p2, p3);

double
nci_dddpp( c_func, d0, d1, p2, p3 )
	SV* c_func
	double d0
	double d1
	void * p2
	void * p3
PREINIT:
	double(*func)(double, double, void *, void *);
CODE:
	func   = INT2PTR(double(*)(double, double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, p2, p3);
OUTPUT:
	RETVAL

short
nci_sddpp( c_func, d0, d1, p2, p3 )
	SV* c_func
	double d0
	double d1
	void * p2
	void * p3
PREINIT:
	short(*func)(double, double, void *, void *);
CODE:
	func   = INT2PTR(short(*)(double, double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, p2, p3);
OUTPUT:
	RETVAL

float
nci_fddpp( c_func, d0, d1, p2, p3 )
	SV* c_func
	double d0
	double d1
	void * p2
	void * p3
PREINIT:
	float(*func)(double, double, void *, void *);
CODE:
	func   = INT2PTR(float(*)(double, double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, p2, p3);
OUTPUT:
	RETVAL

char *
nci_tddpp( c_func, d0, d1, p2, p3 )
	SV* c_func
	double d0
	double d1
	void * p2
	void * p3
PREINIT:
	char *(*func)(double, double, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(double, double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, p2, p3);
OUTPUT:
	RETVAL

int
nci_iddpp( c_func, d0, d1, p2, p3 )
	SV* c_func
	double d0
	double d1
	void * p2
	void * p3
PREINIT:
	int(*func)(double, double, void *, void *);
CODE:
	func   = INT2PTR(int(*)(double, double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, p2, p3);
OUTPUT:
	RETVAL

void *
nci_psdpp( c_func, s0, d1, p2, p3 )
	SV* c_func
	short s0
	double d1
	void * p2
	void * p3
PREINIT:
	void *(*func)(short, double, void *, void *);
CODE:
	func   = INT2PTR(void *(*)(short, double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, p2, p3);
OUTPUT:
	RETVAL

void
nci_vsdpp( c_func, s0, d1, p2, p3 )
	SV* c_func
	short s0
	double d1
	void * p2
	void * p3
PREINIT:
	void(*func)(short, double, void *, void *);
CODE:
	func   = INT2PTR(void(*)(short, double, void *, void *), SvIV(c_func) );
	(*func)(s0, d1, p2, p3);

double
nci_dsdpp( c_func, s0, d1, p2, p3 )
	SV* c_func
	short s0
	double d1
	void * p2
	void * p3
PREINIT:
	double(*func)(short, double, void *, void *);
CODE:
	func   = INT2PTR(double(*)(short, double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, p2, p3);
OUTPUT:
	RETVAL

short
nci_ssdpp( c_func, s0, d1, p2, p3 )
	SV* c_func
	short s0
	double d1
	void * p2
	void * p3
PREINIT:
	short(*func)(short, double, void *, void *);
CODE:
	func   = INT2PTR(short(*)(short, double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, p2, p3);
OUTPUT:
	RETVAL

float
nci_fsdpp( c_func, s0, d1, p2, p3 )
	SV* c_func
	short s0
	double d1
	void * p2
	void * p3
PREINIT:
	float(*func)(short, double, void *, void *);
CODE:
	func   = INT2PTR(float(*)(short, double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, p2, p3);
OUTPUT:
	RETVAL

char *
nci_tsdpp( c_func, s0, d1, p2, p3 )
	SV* c_func
	short s0
	double d1
	void * p2
	void * p3
PREINIT:
	char *(*func)(short, double, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(short, double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, p2, p3);
OUTPUT:
	RETVAL

int
nci_isdpp( c_func, s0, d1, p2, p3 )
	SV* c_func
	short s0
	double d1
	void * p2
	void * p3
PREINIT:
	int(*func)(short, double, void *, void *);
CODE:
	func   = INT2PTR(int(*)(short, double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, p2, p3);
OUTPUT:
	RETVAL

void *
nci_pfdpp( c_func, f0, d1, p2, p3 )
	SV* c_func
	float f0
	double d1
	void * p2
	void * p3
PREINIT:
	void *(*func)(float, double, void *, void *);
CODE:
	func   = INT2PTR(void *(*)(float, double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, p2, p3);
OUTPUT:
	RETVAL

void
nci_vfdpp( c_func, f0, d1, p2, p3 )
	SV* c_func
	float f0
	double d1
	void * p2
	void * p3
PREINIT:
	void(*func)(float, double, void *, void *);
CODE:
	func   = INT2PTR(void(*)(float, double, void *, void *), SvIV(c_func) );
	(*func)(f0, d1, p2, p3);

double
nci_dfdpp( c_func, f0, d1, p2, p3 )
	SV* c_func
	float f0
	double d1
	void * p2
	void * p3
PREINIT:
	double(*func)(float, double, void *, void *);
CODE:
	func   = INT2PTR(double(*)(float, double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, p2, p3);
OUTPUT:
	RETVAL

short
nci_sfdpp( c_func, f0, d1, p2, p3 )
	SV* c_func
	float f0
	double d1
	void * p2
	void * p3
PREINIT:
	short(*func)(float, double, void *, void *);
CODE:
	func   = INT2PTR(short(*)(float, double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, p2, p3);
OUTPUT:
	RETVAL

float
nci_ffdpp( c_func, f0, d1, p2, p3 )
	SV* c_func
	float f0
	double d1
	void * p2
	void * p3
PREINIT:
	float(*func)(float, double, void *, void *);
CODE:
	func   = INT2PTR(float(*)(float, double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, p2, p3);
OUTPUT:
	RETVAL

char *
nci_tfdpp( c_func, f0, d1, p2, p3 )
	SV* c_func
	float f0
	double d1
	void * p2
	void * p3
PREINIT:
	char *(*func)(float, double, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(float, double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, p2, p3);
OUTPUT:
	RETVAL

int
nci_ifdpp( c_func, f0, d1, p2, p3 )
	SV* c_func
	float f0
	double d1
	void * p2
	void * p3
PREINIT:
	int(*func)(float, double, void *, void *);
CODE:
	func   = INT2PTR(int(*)(float, double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, p2, p3);
OUTPUT:
	RETVAL

void *
nci_ptdpp( c_func, t0, d1, p2, p3 )
	SV* c_func
	char * t0
	double d1
	void * p2
	void * p3
PREINIT:
	void *(*func)(char *, double, void *, void *);
CODE:
	func   = INT2PTR(void *(*)(char *, double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, p2, p3);
OUTPUT:
	RETVAL

void
nci_vtdpp( c_func, t0, d1, p2, p3 )
	SV* c_func
	char * t0
	double d1
	void * p2
	void * p3
PREINIT:
	void(*func)(char *, double, void *, void *);
CODE:
	func   = INT2PTR(void(*)(char *, double, void *, void *), SvIV(c_func) );
	(*func)(t0, d1, p2, p3);

double
nci_dtdpp( c_func, t0, d1, p2, p3 )
	SV* c_func
	char * t0
	double d1
	void * p2
	void * p3
PREINIT:
	double(*func)(char *, double, void *, void *);
CODE:
	func   = INT2PTR(double(*)(char *, double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, p2, p3);
OUTPUT:
	RETVAL

short
nci_stdpp( c_func, t0, d1, p2, p3 )
	SV* c_func
	char * t0
	double d1
	void * p2
	void * p3
PREINIT:
	short(*func)(char *, double, void *, void *);
CODE:
	func   = INT2PTR(short(*)(char *, double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, p2, p3);
OUTPUT:
	RETVAL

float
nci_ftdpp( c_func, t0, d1, p2, p3 )
	SV* c_func
	char * t0
	double d1
	void * p2
	void * p3
PREINIT:
	float(*func)(char *, double, void *, void *);
CODE:
	func   = INT2PTR(float(*)(char *, double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, p2, p3);
OUTPUT:
	RETVAL

char *
nci_ttdpp( c_func, t0, d1, p2, p3 )
	SV* c_func
	char * t0
	double d1
	void * p2
	void * p3
PREINIT:
	char *(*func)(char *, double, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, p2, p3);
OUTPUT:
	RETVAL

int
nci_itdpp( c_func, t0, d1, p2, p3 )
	SV* c_func
	char * t0
	double d1
	void * p2
	void * p3
PREINIT:
	int(*func)(char *, double, void *, void *);
CODE:
	func   = INT2PTR(int(*)(char *, double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, p2, p3);
OUTPUT:
	RETVAL

void *
nci_pidpp( c_func, i0, d1, p2, p3 )
	SV* c_func
	int i0
	double d1
	void * p2
	void * p3
PREINIT:
	void *(*func)(int, double, void *, void *);
CODE:
	func   = INT2PTR(void *(*)(int, double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, p2, p3);
OUTPUT:
	RETVAL

void
nci_vidpp( c_func, i0, d1, p2, p3 )
	SV* c_func
	int i0
	double d1
	void * p2
	void * p3
PREINIT:
	void(*func)(int, double, void *, void *);
CODE:
	func   = INT2PTR(void(*)(int, double, void *, void *), SvIV(c_func) );
	(*func)(i0, d1, p2, p3);

double
nci_didpp( c_func, i0, d1, p2, p3 )
	SV* c_func
	int i0
	double d1
	void * p2
	void * p3
PREINIT:
	double(*func)(int, double, void *, void *);
CODE:
	func   = INT2PTR(double(*)(int, double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, p2, p3);
OUTPUT:
	RETVAL

short
nci_sidpp( c_func, i0, d1, p2, p3 )
	SV* c_func
	int i0
	double d1
	void * p2
	void * p3
PREINIT:
	short(*func)(int, double, void *, void *);
CODE:
	func   = INT2PTR(short(*)(int, double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, p2, p3);
OUTPUT:
	RETVAL

float
nci_fidpp( c_func, i0, d1, p2, p3 )
	SV* c_func
	int i0
	double d1
	void * p2
	void * p3
PREINIT:
	float(*func)(int, double, void *, void *);
CODE:
	func   = INT2PTR(float(*)(int, double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, p2, p3);
OUTPUT:
	RETVAL

char *
nci_tidpp( c_func, i0, d1, p2, p3 )
	SV* c_func
	int i0
	double d1
	void * p2
	void * p3
PREINIT:
	char *(*func)(int, double, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(int, double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, p2, p3);
OUTPUT:
	RETVAL

int
nci_iidpp( c_func, i0, d1, p2, p3 )
	SV* c_func
	int i0
	double d1
	void * p2
	void * p3
PREINIT:
	int(*func)(int, double, void *, void *);
CODE:
	func   = INT2PTR(int(*)(int, double, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, p2, p3);
OUTPUT:
	RETVAL

void *
nci_ppspp( c_func, p0, s1, p2, p3 )
	SV* c_func
	void * p0
	short s1
	void * p2
	void * p3
PREINIT:
	void *(*func)(void *, short, void *, void *);
CODE:
	func   = INT2PTR(void *(*)(void *, short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, p2, p3);
OUTPUT:
	RETVAL

void
nci_vpspp( c_func, p0, s1, p2, p3 )
	SV* c_func
	void * p0
	short s1
	void * p2
	void * p3
PREINIT:
	void(*func)(void *, short, void *, void *);
CODE:
	func   = INT2PTR(void(*)(void *, short, void *, void *), SvIV(c_func) );
	(*func)(p0, s1, p2, p3);

double
nci_dpspp( c_func, p0, s1, p2, p3 )
	SV* c_func
	void * p0
	short s1
	void * p2
	void * p3
PREINIT:
	double(*func)(void *, short, void *, void *);
CODE:
	func   = INT2PTR(double(*)(void *, short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, p2, p3);
OUTPUT:
	RETVAL

short
nci_spspp( c_func, p0, s1, p2, p3 )
	SV* c_func
	void * p0
	short s1
	void * p2
	void * p3
PREINIT:
	short(*func)(void *, short, void *, void *);
CODE:
	func   = INT2PTR(short(*)(void *, short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, p2, p3);
OUTPUT:
	RETVAL

float
nci_fpspp( c_func, p0, s1, p2, p3 )
	SV* c_func
	void * p0
	short s1
	void * p2
	void * p3
PREINIT:
	float(*func)(void *, short, void *, void *);
CODE:
	func   = INT2PTR(float(*)(void *, short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, p2, p3);
OUTPUT:
	RETVAL

char *
nci_tpspp( c_func, p0, s1, p2, p3 )
	SV* c_func
	void * p0
	short s1
	void * p2
	void * p3
PREINIT:
	char *(*func)(void *, short, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, p2, p3);
OUTPUT:
	RETVAL

int
nci_ipspp( c_func, p0, s1, p2, p3 )
	SV* c_func
	void * p0
	short s1
	void * p2
	void * p3
PREINIT:
	int(*func)(void *, short, void *, void *);
CODE:
	func   = INT2PTR(int(*)(void *, short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, p2, p3);
OUTPUT:
	RETVAL

void *
nci_pvspp( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvspp( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvspp( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svspp( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvspp( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvspp( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivspp( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdspp( c_func, d0, s1, p2, p3 )
	SV* c_func
	double d0
	short s1
	void * p2
	void * p3
PREINIT:
	void *(*func)(double, short, void *, void *);
CODE:
	func   = INT2PTR(void *(*)(double, short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, p2, p3);
OUTPUT:
	RETVAL

void
nci_vdspp( c_func, d0, s1, p2, p3 )
	SV* c_func
	double d0
	short s1
	void * p2
	void * p3
PREINIT:
	void(*func)(double, short, void *, void *);
CODE:
	func   = INT2PTR(void(*)(double, short, void *, void *), SvIV(c_func) );
	(*func)(d0, s1, p2, p3);

double
nci_ddspp( c_func, d0, s1, p2, p3 )
	SV* c_func
	double d0
	short s1
	void * p2
	void * p3
PREINIT:
	double(*func)(double, short, void *, void *);
CODE:
	func   = INT2PTR(double(*)(double, short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, p2, p3);
OUTPUT:
	RETVAL

short
nci_sdspp( c_func, d0, s1, p2, p3 )
	SV* c_func
	double d0
	short s1
	void * p2
	void * p3
PREINIT:
	short(*func)(double, short, void *, void *);
CODE:
	func   = INT2PTR(short(*)(double, short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, p2, p3);
OUTPUT:
	RETVAL

float
nci_fdspp( c_func, d0, s1, p2, p3 )
	SV* c_func
	double d0
	short s1
	void * p2
	void * p3
PREINIT:
	float(*func)(double, short, void *, void *);
CODE:
	func   = INT2PTR(float(*)(double, short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, p2, p3);
OUTPUT:
	RETVAL

char *
nci_tdspp( c_func, d0, s1, p2, p3 )
	SV* c_func
	double d0
	short s1
	void * p2
	void * p3
PREINIT:
	char *(*func)(double, short, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(double, short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, p2, p3);
OUTPUT:
	RETVAL

int
nci_idspp( c_func, d0, s1, p2, p3 )
	SV* c_func
	double d0
	short s1
	void * p2
	void * p3
PREINIT:
	int(*func)(double, short, void *, void *);
CODE:
	func   = INT2PTR(int(*)(double, short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, p2, p3);
OUTPUT:
	RETVAL

void *
nci_psspp( c_func, s0, s1, p2, p3 )
	SV* c_func
	short s0
	short s1
	void * p2
	void * p3
PREINIT:
	void *(*func)(short, short, void *, void *);
CODE:
	func   = INT2PTR(void *(*)(short, short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, p2, p3);
OUTPUT:
	RETVAL

void
nci_vsspp( c_func, s0, s1, p2, p3 )
	SV* c_func
	short s0
	short s1
	void * p2
	void * p3
PREINIT:
	void(*func)(short, short, void *, void *);
CODE:
	func   = INT2PTR(void(*)(short, short, void *, void *), SvIV(c_func) );
	(*func)(s0, s1, p2, p3);

double
nci_dsspp( c_func, s0, s1, p2, p3 )
	SV* c_func
	short s0
	short s1
	void * p2
	void * p3
PREINIT:
	double(*func)(short, short, void *, void *);
CODE:
	func   = INT2PTR(double(*)(short, short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, p2, p3);
OUTPUT:
	RETVAL

short
nci_ssspp( c_func, s0, s1, p2, p3 )
	SV* c_func
	short s0
	short s1
	void * p2
	void * p3
PREINIT:
	short(*func)(short, short, void *, void *);
CODE:
	func   = INT2PTR(short(*)(short, short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, p2, p3);
OUTPUT:
	RETVAL

float
nci_fsspp( c_func, s0, s1, p2, p3 )
	SV* c_func
	short s0
	short s1
	void * p2
	void * p3
PREINIT:
	float(*func)(short, short, void *, void *);
CODE:
	func   = INT2PTR(float(*)(short, short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, p2, p3);
OUTPUT:
	RETVAL

char *
nci_tsspp( c_func, s0, s1, p2, p3 )
	SV* c_func
	short s0
	short s1
	void * p2
	void * p3
PREINIT:
	char *(*func)(short, short, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(short, short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, p2, p3);
OUTPUT:
	RETVAL

int
nci_isspp( c_func, s0, s1, p2, p3 )
	SV* c_func
	short s0
	short s1
	void * p2
	void * p3
PREINIT:
	int(*func)(short, short, void *, void *);
CODE:
	func   = INT2PTR(int(*)(short, short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, p2, p3);
OUTPUT:
	RETVAL

void *
nci_pfspp( c_func, f0, s1, p2, p3 )
	SV* c_func
	float f0
	short s1
	void * p2
	void * p3
PREINIT:
	void *(*func)(float, short, void *, void *);
CODE:
	func   = INT2PTR(void *(*)(float, short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, p2, p3);
OUTPUT:
	RETVAL

void
nci_vfspp( c_func, f0, s1, p2, p3 )
	SV* c_func
	float f0
	short s1
	void * p2
	void * p3
PREINIT:
	void(*func)(float, short, void *, void *);
CODE:
	func   = INT2PTR(void(*)(float, short, void *, void *), SvIV(c_func) );
	(*func)(f0, s1, p2, p3);

double
nci_dfspp( c_func, f0, s1, p2, p3 )
	SV* c_func
	float f0
	short s1
	void * p2
	void * p3
PREINIT:
	double(*func)(float, short, void *, void *);
CODE:
	func   = INT2PTR(double(*)(float, short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, p2, p3);
OUTPUT:
	RETVAL

short
nci_sfspp( c_func, f0, s1, p2, p3 )
	SV* c_func
	float f0
	short s1
	void * p2
	void * p3
PREINIT:
	short(*func)(float, short, void *, void *);
CODE:
	func   = INT2PTR(short(*)(float, short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, p2, p3);
OUTPUT:
	RETVAL

float
nci_ffspp( c_func, f0, s1, p2, p3 )
	SV* c_func
	float f0
	short s1
	void * p2
	void * p3
PREINIT:
	float(*func)(float, short, void *, void *);
CODE:
	func   = INT2PTR(float(*)(float, short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, p2, p3);
OUTPUT:
	RETVAL

char *
nci_tfspp( c_func, f0, s1, p2, p3 )
	SV* c_func
	float f0
	short s1
	void * p2
	void * p3
PREINIT:
	char *(*func)(float, short, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(float, short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, p2, p3);
OUTPUT:
	RETVAL

int
nci_ifspp( c_func, f0, s1, p2, p3 )
	SV* c_func
	float f0
	short s1
	void * p2
	void * p3
PREINIT:
	int(*func)(float, short, void *, void *);
CODE:
	func   = INT2PTR(int(*)(float, short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, p2, p3);
OUTPUT:
	RETVAL

void *
nci_ptspp( c_func, t0, s1, p2, p3 )
	SV* c_func
	char * t0
	short s1
	void * p2
	void * p3
PREINIT:
	void *(*func)(char *, short, void *, void *);
CODE:
	func   = INT2PTR(void *(*)(char *, short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, p2, p3);
OUTPUT:
	RETVAL

void
nci_vtspp( c_func, t0, s1, p2, p3 )
	SV* c_func
	char * t0
	short s1
	void * p2
	void * p3
PREINIT:
	void(*func)(char *, short, void *, void *);
CODE:
	func   = INT2PTR(void(*)(char *, short, void *, void *), SvIV(c_func) );
	(*func)(t0, s1, p2, p3);

double
nci_dtspp( c_func, t0, s1, p2, p3 )
	SV* c_func
	char * t0
	short s1
	void * p2
	void * p3
PREINIT:
	double(*func)(char *, short, void *, void *);
CODE:
	func   = INT2PTR(double(*)(char *, short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, p2, p3);
OUTPUT:
	RETVAL

short
nci_stspp( c_func, t0, s1, p2, p3 )
	SV* c_func
	char * t0
	short s1
	void * p2
	void * p3
PREINIT:
	short(*func)(char *, short, void *, void *);
CODE:
	func   = INT2PTR(short(*)(char *, short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, p2, p3);
OUTPUT:
	RETVAL

float
nci_ftspp( c_func, t0, s1, p2, p3 )
	SV* c_func
	char * t0
	short s1
	void * p2
	void * p3
PREINIT:
	float(*func)(char *, short, void *, void *);
CODE:
	func   = INT2PTR(float(*)(char *, short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, p2, p3);
OUTPUT:
	RETVAL

char *
nci_ttspp( c_func, t0, s1, p2, p3 )
	SV* c_func
	char * t0
	short s1
	void * p2
	void * p3
PREINIT:
	char *(*func)(char *, short, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, p2, p3);
OUTPUT:
	RETVAL

int
nci_itspp( c_func, t0, s1, p2, p3 )
	SV* c_func
	char * t0
	short s1
	void * p2
	void * p3
PREINIT:
	int(*func)(char *, short, void *, void *);
CODE:
	func   = INT2PTR(int(*)(char *, short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, p2, p3);
OUTPUT:
	RETVAL

void *
nci_pispp( c_func, i0, s1, p2, p3 )
	SV* c_func
	int i0
	short s1
	void * p2
	void * p3
PREINIT:
	void *(*func)(int, short, void *, void *);
CODE:
	func   = INT2PTR(void *(*)(int, short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, p2, p3);
OUTPUT:
	RETVAL

void
nci_vispp( c_func, i0, s1, p2, p3 )
	SV* c_func
	int i0
	short s1
	void * p2
	void * p3
PREINIT:
	void(*func)(int, short, void *, void *);
CODE:
	func   = INT2PTR(void(*)(int, short, void *, void *), SvIV(c_func) );
	(*func)(i0, s1, p2, p3);

double
nci_dispp( c_func, i0, s1, p2, p3 )
	SV* c_func
	int i0
	short s1
	void * p2
	void * p3
PREINIT:
	double(*func)(int, short, void *, void *);
CODE:
	func   = INT2PTR(double(*)(int, short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, p2, p3);
OUTPUT:
	RETVAL

short
nci_sispp( c_func, i0, s1, p2, p3 )
	SV* c_func
	int i0
	short s1
	void * p2
	void * p3
PREINIT:
	short(*func)(int, short, void *, void *);
CODE:
	func   = INT2PTR(short(*)(int, short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, p2, p3);
OUTPUT:
	RETVAL

float
nci_fispp( c_func, i0, s1, p2, p3 )
	SV* c_func
	int i0
	short s1
	void * p2
	void * p3
PREINIT:
	float(*func)(int, short, void *, void *);
CODE:
	func   = INT2PTR(float(*)(int, short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, p2, p3);
OUTPUT:
	RETVAL

char *
nci_tispp( c_func, i0, s1, p2, p3 )
	SV* c_func
	int i0
	short s1
	void * p2
	void * p3
PREINIT:
	char *(*func)(int, short, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(int, short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, p2, p3);
OUTPUT:
	RETVAL

int
nci_iispp( c_func, i0, s1, p2, p3 )
	SV* c_func
	int i0
	short s1
	void * p2
	void * p3
PREINIT:
	int(*func)(int, short, void *, void *);
CODE:
	func   = INT2PTR(int(*)(int, short, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, p2, p3);
OUTPUT:
	RETVAL

void *
nci_ppfpp( c_func, p0, f1, p2, p3 )
	SV* c_func
	void * p0
	float f1
	void * p2
	void * p3
PREINIT:
	void *(*func)(void *, float, void *, void *);
CODE:
	func   = INT2PTR(void *(*)(void *, float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, p2, p3);
OUTPUT:
	RETVAL

void
nci_vpfpp( c_func, p0, f1, p2, p3 )
	SV* c_func
	void * p0
	float f1
	void * p2
	void * p3
PREINIT:
	void(*func)(void *, float, void *, void *);
CODE:
	func   = INT2PTR(void(*)(void *, float, void *, void *), SvIV(c_func) );
	(*func)(p0, f1, p2, p3);

double
nci_dpfpp( c_func, p0, f1, p2, p3 )
	SV* c_func
	void * p0
	float f1
	void * p2
	void * p3
PREINIT:
	double(*func)(void *, float, void *, void *);
CODE:
	func   = INT2PTR(double(*)(void *, float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, p2, p3);
OUTPUT:
	RETVAL

short
nci_spfpp( c_func, p0, f1, p2, p3 )
	SV* c_func
	void * p0
	float f1
	void * p2
	void * p3
PREINIT:
	short(*func)(void *, float, void *, void *);
CODE:
	func   = INT2PTR(short(*)(void *, float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, p2, p3);
OUTPUT:
	RETVAL

float
nci_fpfpp( c_func, p0, f1, p2, p3 )
	SV* c_func
	void * p0
	float f1
	void * p2
	void * p3
PREINIT:
	float(*func)(void *, float, void *, void *);
CODE:
	func   = INT2PTR(float(*)(void *, float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, p2, p3);
OUTPUT:
	RETVAL

char *
nci_tpfpp( c_func, p0, f1, p2, p3 )
	SV* c_func
	void * p0
	float f1
	void * p2
	void * p3
PREINIT:
	char *(*func)(void *, float, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, p2, p3);
OUTPUT:
	RETVAL

int
nci_ipfpp( c_func, p0, f1, p2, p3 )
	SV* c_func
	void * p0
	float f1
	void * p2
	void * p3
PREINIT:
	int(*func)(void *, float, void *, void *);
CODE:
	func   = INT2PTR(int(*)(void *, float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, p2, p3);
OUTPUT:
	RETVAL

void *
nci_pvfpp( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvfpp( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvfpp( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svfpp( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvfpp( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvfpp( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivfpp( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdfpp( c_func, d0, f1, p2, p3 )
	SV* c_func
	double d0
	float f1
	void * p2
	void * p3
PREINIT:
	void *(*func)(double, float, void *, void *);
CODE:
	func   = INT2PTR(void *(*)(double, float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, p2, p3);
OUTPUT:
	RETVAL

void
nci_vdfpp( c_func, d0, f1, p2, p3 )
	SV* c_func
	double d0
	float f1
	void * p2
	void * p3
PREINIT:
	void(*func)(double, float, void *, void *);
CODE:
	func   = INT2PTR(void(*)(double, float, void *, void *), SvIV(c_func) );
	(*func)(d0, f1, p2, p3);

double
nci_ddfpp( c_func, d0, f1, p2, p3 )
	SV* c_func
	double d0
	float f1
	void * p2
	void * p3
PREINIT:
	double(*func)(double, float, void *, void *);
CODE:
	func   = INT2PTR(double(*)(double, float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, p2, p3);
OUTPUT:
	RETVAL

short
nci_sdfpp( c_func, d0, f1, p2, p3 )
	SV* c_func
	double d0
	float f1
	void * p2
	void * p3
PREINIT:
	short(*func)(double, float, void *, void *);
CODE:
	func   = INT2PTR(short(*)(double, float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, p2, p3);
OUTPUT:
	RETVAL

float
nci_fdfpp( c_func, d0, f1, p2, p3 )
	SV* c_func
	double d0
	float f1
	void * p2
	void * p3
PREINIT:
	float(*func)(double, float, void *, void *);
CODE:
	func   = INT2PTR(float(*)(double, float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, p2, p3);
OUTPUT:
	RETVAL

char *
nci_tdfpp( c_func, d0, f1, p2, p3 )
	SV* c_func
	double d0
	float f1
	void * p2
	void * p3
PREINIT:
	char *(*func)(double, float, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(double, float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, p2, p3);
OUTPUT:
	RETVAL

int
nci_idfpp( c_func, d0, f1, p2, p3 )
	SV* c_func
	double d0
	float f1
	void * p2
	void * p3
PREINIT:
	int(*func)(double, float, void *, void *);
CODE:
	func   = INT2PTR(int(*)(double, float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, p2, p3);
OUTPUT:
	RETVAL

void *
nci_psfpp( c_func, s0, f1, p2, p3 )
	SV* c_func
	short s0
	float f1
	void * p2
	void * p3
PREINIT:
	void *(*func)(short, float, void *, void *);
CODE:
	func   = INT2PTR(void *(*)(short, float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, p2, p3);
OUTPUT:
	RETVAL

void
nci_vsfpp( c_func, s0, f1, p2, p3 )
	SV* c_func
	short s0
	float f1
	void * p2
	void * p3
PREINIT:
	void(*func)(short, float, void *, void *);
CODE:
	func   = INT2PTR(void(*)(short, float, void *, void *), SvIV(c_func) );
	(*func)(s0, f1, p2, p3);

double
nci_dsfpp( c_func, s0, f1, p2, p3 )
	SV* c_func
	short s0
	float f1
	void * p2
	void * p3
PREINIT:
	double(*func)(short, float, void *, void *);
CODE:
	func   = INT2PTR(double(*)(short, float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, p2, p3);
OUTPUT:
	RETVAL

short
nci_ssfpp( c_func, s0, f1, p2, p3 )
	SV* c_func
	short s0
	float f1
	void * p2
	void * p3
PREINIT:
	short(*func)(short, float, void *, void *);
CODE:
	func   = INT2PTR(short(*)(short, float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, p2, p3);
OUTPUT:
	RETVAL

float
nci_fsfpp( c_func, s0, f1, p2, p3 )
	SV* c_func
	short s0
	float f1
	void * p2
	void * p3
PREINIT:
	float(*func)(short, float, void *, void *);
CODE:
	func   = INT2PTR(float(*)(short, float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, p2, p3);
OUTPUT:
	RETVAL

char *
nci_tsfpp( c_func, s0, f1, p2, p3 )
	SV* c_func
	short s0
	float f1
	void * p2
	void * p3
PREINIT:
	char *(*func)(short, float, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(short, float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, p2, p3);
OUTPUT:
	RETVAL

int
nci_isfpp( c_func, s0, f1, p2, p3 )
	SV* c_func
	short s0
	float f1
	void * p2
	void * p3
PREINIT:
	int(*func)(short, float, void *, void *);
CODE:
	func   = INT2PTR(int(*)(short, float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, p2, p3);
OUTPUT:
	RETVAL

void *
nci_pffpp( c_func, f0, f1, p2, p3 )
	SV* c_func
	float f0
	float f1
	void * p2
	void * p3
PREINIT:
	void *(*func)(float, float, void *, void *);
CODE:
	func   = INT2PTR(void *(*)(float, float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, p2, p3);
OUTPUT:
	RETVAL

void
nci_vffpp( c_func, f0, f1, p2, p3 )
	SV* c_func
	float f0
	float f1
	void * p2
	void * p3
PREINIT:
	void(*func)(float, float, void *, void *);
CODE:
	func   = INT2PTR(void(*)(float, float, void *, void *), SvIV(c_func) );
	(*func)(f0, f1, p2, p3);

double
nci_dffpp( c_func, f0, f1, p2, p3 )
	SV* c_func
	float f0
	float f1
	void * p2
	void * p3
PREINIT:
	double(*func)(float, float, void *, void *);
CODE:
	func   = INT2PTR(double(*)(float, float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, p2, p3);
OUTPUT:
	RETVAL

short
nci_sffpp( c_func, f0, f1, p2, p3 )
	SV* c_func
	float f0
	float f1
	void * p2
	void * p3
PREINIT:
	short(*func)(float, float, void *, void *);
CODE:
	func   = INT2PTR(short(*)(float, float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, p2, p3);
OUTPUT:
	RETVAL

float
nci_fffpp( c_func, f0, f1, p2, p3 )
	SV* c_func
	float f0
	float f1
	void * p2
	void * p3
PREINIT:
	float(*func)(float, float, void *, void *);
CODE:
	func   = INT2PTR(float(*)(float, float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, p2, p3);
OUTPUT:
	RETVAL

char *
nci_tffpp( c_func, f0, f1, p2, p3 )
	SV* c_func
	float f0
	float f1
	void * p2
	void * p3
PREINIT:
	char *(*func)(float, float, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(float, float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, p2, p3);
OUTPUT:
	RETVAL

int
nci_iffpp( c_func, f0, f1, p2, p3 )
	SV* c_func
	float f0
	float f1
	void * p2
	void * p3
PREINIT:
	int(*func)(float, float, void *, void *);
CODE:
	func   = INT2PTR(int(*)(float, float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, p2, p3);
OUTPUT:
	RETVAL

void *
nci_ptfpp( c_func, t0, f1, p2, p3 )
	SV* c_func
	char * t0
	float f1
	void * p2
	void * p3
PREINIT:
	void *(*func)(char *, float, void *, void *);
CODE:
	func   = INT2PTR(void *(*)(char *, float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, p2, p3);
OUTPUT:
	RETVAL

void
nci_vtfpp( c_func, t0, f1, p2, p3 )
	SV* c_func
	char * t0
	float f1
	void * p2
	void * p3
PREINIT:
	void(*func)(char *, float, void *, void *);
CODE:
	func   = INT2PTR(void(*)(char *, float, void *, void *), SvIV(c_func) );
	(*func)(t0, f1, p2, p3);

double
nci_dtfpp( c_func, t0, f1, p2, p3 )
	SV* c_func
	char * t0
	float f1
	void * p2
	void * p3
PREINIT:
	double(*func)(char *, float, void *, void *);
CODE:
	func   = INT2PTR(double(*)(char *, float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, p2, p3);
OUTPUT:
	RETVAL

short
nci_stfpp( c_func, t0, f1, p2, p3 )
	SV* c_func
	char * t0
	float f1
	void * p2
	void * p3
PREINIT:
	short(*func)(char *, float, void *, void *);
CODE:
	func   = INT2PTR(short(*)(char *, float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, p2, p3);
OUTPUT:
	RETVAL

float
nci_ftfpp( c_func, t0, f1, p2, p3 )
	SV* c_func
	char * t0
	float f1
	void * p2
	void * p3
PREINIT:
	float(*func)(char *, float, void *, void *);
CODE:
	func   = INT2PTR(float(*)(char *, float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, p2, p3);
OUTPUT:
	RETVAL

char *
nci_ttfpp( c_func, t0, f1, p2, p3 )
	SV* c_func
	char * t0
	float f1
	void * p2
	void * p3
PREINIT:
	char *(*func)(char *, float, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, p2, p3);
OUTPUT:
	RETVAL

int
nci_itfpp( c_func, t0, f1, p2, p3 )
	SV* c_func
	char * t0
	float f1
	void * p2
	void * p3
PREINIT:
	int(*func)(char *, float, void *, void *);
CODE:
	func   = INT2PTR(int(*)(char *, float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, p2, p3);
OUTPUT:
	RETVAL

void *
nci_pifpp( c_func, i0, f1, p2, p3 )
	SV* c_func
	int i0
	float f1
	void * p2
	void * p3
PREINIT:
	void *(*func)(int, float, void *, void *);
CODE:
	func   = INT2PTR(void *(*)(int, float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, p2, p3);
OUTPUT:
	RETVAL

void
nci_vifpp( c_func, i0, f1, p2, p3 )
	SV* c_func
	int i0
	float f1
	void * p2
	void * p3
PREINIT:
	void(*func)(int, float, void *, void *);
CODE:
	func   = INT2PTR(void(*)(int, float, void *, void *), SvIV(c_func) );
	(*func)(i0, f1, p2, p3);

double
nci_difpp( c_func, i0, f1, p2, p3 )
	SV* c_func
	int i0
	float f1
	void * p2
	void * p3
PREINIT:
	double(*func)(int, float, void *, void *);
CODE:
	func   = INT2PTR(double(*)(int, float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, p2, p3);
OUTPUT:
	RETVAL

short
nci_sifpp( c_func, i0, f1, p2, p3 )
	SV* c_func
	int i0
	float f1
	void * p2
	void * p3
PREINIT:
	short(*func)(int, float, void *, void *);
CODE:
	func   = INT2PTR(short(*)(int, float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, p2, p3);
OUTPUT:
	RETVAL

float
nci_fifpp( c_func, i0, f1, p2, p3 )
	SV* c_func
	int i0
	float f1
	void * p2
	void * p3
PREINIT:
	float(*func)(int, float, void *, void *);
CODE:
	func   = INT2PTR(float(*)(int, float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, p2, p3);
OUTPUT:
	RETVAL

char *
nci_tifpp( c_func, i0, f1, p2, p3 )
	SV* c_func
	int i0
	float f1
	void * p2
	void * p3
PREINIT:
	char *(*func)(int, float, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(int, float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, p2, p3);
OUTPUT:
	RETVAL

int
nci_iifpp( c_func, i0, f1, p2, p3 )
	SV* c_func
	int i0
	float f1
	void * p2
	void * p3
PREINIT:
	int(*func)(int, float, void *, void *);
CODE:
	func   = INT2PTR(int(*)(int, float, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, p2, p3);
OUTPUT:
	RETVAL

void *
nci_pptpp( c_func, p0, t1, p2, p3 )
	SV* c_func
	void * p0
	char * t1
	void * p2
	void * p3
PREINIT:
	void *(*func)(void *, char *, void *, void *);
CODE:
	func   = INT2PTR(void *(*)(void *, char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, p2, p3);
OUTPUT:
	RETVAL

void
nci_vptpp( c_func, p0, t1, p2, p3 )
	SV* c_func
	void * p0
	char * t1
	void * p2
	void * p3
PREINIT:
	void(*func)(void *, char *, void *, void *);
CODE:
	func   = INT2PTR(void(*)(void *, char *, void *, void *), SvIV(c_func) );
	(*func)(p0, t1, p2, p3);

double
nci_dptpp( c_func, p0, t1, p2, p3 )
	SV* c_func
	void * p0
	char * t1
	void * p2
	void * p3
PREINIT:
	double(*func)(void *, char *, void *, void *);
CODE:
	func   = INT2PTR(double(*)(void *, char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, p2, p3);
OUTPUT:
	RETVAL

short
nci_sptpp( c_func, p0, t1, p2, p3 )
	SV* c_func
	void * p0
	char * t1
	void * p2
	void * p3
PREINIT:
	short(*func)(void *, char *, void *, void *);
CODE:
	func   = INT2PTR(short(*)(void *, char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, p2, p3);
OUTPUT:
	RETVAL

float
nci_fptpp( c_func, p0, t1, p2, p3 )
	SV* c_func
	void * p0
	char * t1
	void * p2
	void * p3
PREINIT:
	float(*func)(void *, char *, void *, void *);
CODE:
	func   = INT2PTR(float(*)(void *, char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, p2, p3);
OUTPUT:
	RETVAL

char *
nci_tptpp( c_func, p0, t1, p2, p3 )
	SV* c_func
	void * p0
	char * t1
	void * p2
	void * p3
PREINIT:
	char *(*func)(void *, char *, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, p2, p3);
OUTPUT:
	RETVAL

int
nci_iptpp( c_func, p0, t1, p2, p3 )
	SV* c_func
	void * p0
	char * t1
	void * p2
	void * p3
PREINIT:
	int(*func)(void *, char *, void *, void *);
CODE:
	func   = INT2PTR(int(*)(void *, char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, p2, p3);
OUTPUT:
	RETVAL

void *
nci_pvtpp( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvtpp( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvtpp( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svtpp( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvtpp( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvtpp( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivtpp( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdtpp( c_func, d0, t1, p2, p3 )
	SV* c_func
	double d0
	char * t1
	void * p2
	void * p3
PREINIT:
	void *(*func)(double, char *, void *, void *);
CODE:
	func   = INT2PTR(void *(*)(double, char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, p2, p3);
OUTPUT:
	RETVAL

void
nci_vdtpp( c_func, d0, t1, p2, p3 )
	SV* c_func
	double d0
	char * t1
	void * p2
	void * p3
PREINIT:
	void(*func)(double, char *, void *, void *);
CODE:
	func   = INT2PTR(void(*)(double, char *, void *, void *), SvIV(c_func) );
	(*func)(d0, t1, p2, p3);

double
nci_ddtpp( c_func, d0, t1, p2, p3 )
	SV* c_func
	double d0
	char * t1
	void * p2
	void * p3
PREINIT:
	double(*func)(double, char *, void *, void *);
CODE:
	func   = INT2PTR(double(*)(double, char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, p2, p3);
OUTPUT:
	RETVAL

short
nci_sdtpp( c_func, d0, t1, p2, p3 )
	SV* c_func
	double d0
	char * t1
	void * p2
	void * p3
PREINIT:
	short(*func)(double, char *, void *, void *);
CODE:
	func   = INT2PTR(short(*)(double, char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, p2, p3);
OUTPUT:
	RETVAL

float
nci_fdtpp( c_func, d0, t1, p2, p3 )
	SV* c_func
	double d0
	char * t1
	void * p2
	void * p3
PREINIT:
	float(*func)(double, char *, void *, void *);
CODE:
	func   = INT2PTR(float(*)(double, char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, p2, p3);
OUTPUT:
	RETVAL

char *
nci_tdtpp( c_func, d0, t1, p2, p3 )
	SV* c_func
	double d0
	char * t1
	void * p2
	void * p3
PREINIT:
	char *(*func)(double, char *, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(double, char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, p2, p3);
OUTPUT:
	RETVAL

int
nci_idtpp( c_func, d0, t1, p2, p3 )
	SV* c_func
	double d0
	char * t1
	void * p2
	void * p3
PREINIT:
	int(*func)(double, char *, void *, void *);
CODE:
	func   = INT2PTR(int(*)(double, char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, p2, p3);
OUTPUT:
	RETVAL

void *
nci_pstpp( c_func, s0, t1, p2, p3 )
	SV* c_func
	short s0
	char * t1
	void * p2
	void * p3
PREINIT:
	void *(*func)(short, char *, void *, void *);
CODE:
	func   = INT2PTR(void *(*)(short, char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, p2, p3);
OUTPUT:
	RETVAL

void
nci_vstpp( c_func, s0, t1, p2, p3 )
	SV* c_func
	short s0
	char * t1
	void * p2
	void * p3
PREINIT:
	void(*func)(short, char *, void *, void *);
CODE:
	func   = INT2PTR(void(*)(short, char *, void *, void *), SvIV(c_func) );
	(*func)(s0, t1, p2, p3);

double
nci_dstpp( c_func, s0, t1, p2, p3 )
	SV* c_func
	short s0
	char * t1
	void * p2
	void * p3
PREINIT:
	double(*func)(short, char *, void *, void *);
CODE:
	func   = INT2PTR(double(*)(short, char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, p2, p3);
OUTPUT:
	RETVAL

short
nci_sstpp( c_func, s0, t1, p2, p3 )
	SV* c_func
	short s0
	char * t1
	void * p2
	void * p3
PREINIT:
	short(*func)(short, char *, void *, void *);
CODE:
	func   = INT2PTR(short(*)(short, char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, p2, p3);
OUTPUT:
	RETVAL

float
nci_fstpp( c_func, s0, t1, p2, p3 )
	SV* c_func
	short s0
	char * t1
	void * p2
	void * p3
PREINIT:
	float(*func)(short, char *, void *, void *);
CODE:
	func   = INT2PTR(float(*)(short, char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, p2, p3);
OUTPUT:
	RETVAL

char *
nci_tstpp( c_func, s0, t1, p2, p3 )
	SV* c_func
	short s0
	char * t1
	void * p2
	void * p3
PREINIT:
	char *(*func)(short, char *, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(short, char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, p2, p3);
OUTPUT:
	RETVAL

int
nci_istpp( c_func, s0, t1, p2, p3 )
	SV* c_func
	short s0
	char * t1
	void * p2
	void * p3
PREINIT:
	int(*func)(short, char *, void *, void *);
CODE:
	func   = INT2PTR(int(*)(short, char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, p2, p3);
OUTPUT:
	RETVAL

void *
nci_pftpp( c_func, f0, t1, p2, p3 )
	SV* c_func
	float f0
	char * t1
	void * p2
	void * p3
PREINIT:
	void *(*func)(float, char *, void *, void *);
CODE:
	func   = INT2PTR(void *(*)(float, char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, p2, p3);
OUTPUT:
	RETVAL

void
nci_vftpp( c_func, f0, t1, p2, p3 )
	SV* c_func
	float f0
	char * t1
	void * p2
	void * p3
PREINIT:
	void(*func)(float, char *, void *, void *);
CODE:
	func   = INT2PTR(void(*)(float, char *, void *, void *), SvIV(c_func) );
	(*func)(f0, t1, p2, p3);

double
nci_dftpp( c_func, f0, t1, p2, p3 )
	SV* c_func
	float f0
	char * t1
	void * p2
	void * p3
PREINIT:
	double(*func)(float, char *, void *, void *);
CODE:
	func   = INT2PTR(double(*)(float, char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, p2, p3);
OUTPUT:
	RETVAL

short
nci_sftpp( c_func, f0, t1, p2, p3 )
	SV* c_func
	float f0
	char * t1
	void * p2
	void * p3
PREINIT:
	short(*func)(float, char *, void *, void *);
CODE:
	func   = INT2PTR(short(*)(float, char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, p2, p3);
OUTPUT:
	RETVAL

float
nci_fftpp( c_func, f0, t1, p2, p3 )
	SV* c_func
	float f0
	char * t1
	void * p2
	void * p3
PREINIT:
	float(*func)(float, char *, void *, void *);
CODE:
	func   = INT2PTR(float(*)(float, char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, p2, p3);
OUTPUT:
	RETVAL

char *
nci_tftpp( c_func, f0, t1, p2, p3 )
	SV* c_func
	float f0
	char * t1
	void * p2
	void * p3
PREINIT:
	char *(*func)(float, char *, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(float, char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, p2, p3);
OUTPUT:
	RETVAL

int
nci_iftpp( c_func, f0, t1, p2, p3 )
	SV* c_func
	float f0
	char * t1
	void * p2
	void * p3
PREINIT:
	int(*func)(float, char *, void *, void *);
CODE:
	func   = INT2PTR(int(*)(float, char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, p2, p3);
OUTPUT:
	RETVAL

void *
nci_pttpp( c_func, t0, t1, p2, p3 )
	SV* c_func
	char * t0
	char * t1
	void * p2
	void * p3
PREINIT:
	void *(*func)(char *, char *, void *, void *);
CODE:
	func   = INT2PTR(void *(*)(char *, char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, p2, p3);
OUTPUT:
	RETVAL

void
nci_vttpp( c_func, t0, t1, p2, p3 )
	SV* c_func
	char * t0
	char * t1
	void * p2
	void * p3
PREINIT:
	void(*func)(char *, char *, void *, void *);
CODE:
	func   = INT2PTR(void(*)(char *, char *, void *, void *), SvIV(c_func) );
	(*func)(t0, t1, p2, p3);

double
nci_dttpp( c_func, t0, t1, p2, p3 )
	SV* c_func
	char * t0
	char * t1
	void * p2
	void * p3
PREINIT:
	double(*func)(char *, char *, void *, void *);
CODE:
	func   = INT2PTR(double(*)(char *, char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, p2, p3);
OUTPUT:
	RETVAL

short
nci_sttpp( c_func, t0, t1, p2, p3 )
	SV* c_func
	char * t0
	char * t1
	void * p2
	void * p3
PREINIT:
	short(*func)(char *, char *, void *, void *);
CODE:
	func   = INT2PTR(short(*)(char *, char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, p2, p3);
OUTPUT:
	RETVAL

float
nci_fttpp( c_func, t0, t1, p2, p3 )
	SV* c_func
	char * t0
	char * t1
	void * p2
	void * p3
PREINIT:
	float(*func)(char *, char *, void *, void *);
CODE:
	func   = INT2PTR(float(*)(char *, char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, p2, p3);
OUTPUT:
	RETVAL

char *
nci_tttpp( c_func, t0, t1, p2, p3 )
	SV* c_func
	char * t0
	char * t1
	void * p2
	void * p3
PREINIT:
	char *(*func)(char *, char *, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, p2, p3);
OUTPUT:
	RETVAL

int
nci_ittpp( c_func, t0, t1, p2, p3 )
	SV* c_func
	char * t0
	char * t1
	void * p2
	void * p3
PREINIT:
	int(*func)(char *, char *, void *, void *);
CODE:
	func   = INT2PTR(int(*)(char *, char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, p2, p3);
OUTPUT:
	RETVAL

void *
nci_pitpp( c_func, i0, t1, p2, p3 )
	SV* c_func
	int i0
	char * t1
	void * p2
	void * p3
PREINIT:
	void *(*func)(int, char *, void *, void *);
CODE:
	func   = INT2PTR(void *(*)(int, char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, p2, p3);
OUTPUT:
	RETVAL

void
nci_vitpp( c_func, i0, t1, p2, p3 )
	SV* c_func
	int i0
	char * t1
	void * p2
	void * p3
PREINIT:
	void(*func)(int, char *, void *, void *);
CODE:
	func   = INT2PTR(void(*)(int, char *, void *, void *), SvIV(c_func) );
	(*func)(i0, t1, p2, p3);

double
nci_ditpp( c_func, i0, t1, p2, p3 )
	SV* c_func
	int i0
	char * t1
	void * p2
	void * p3
PREINIT:
	double(*func)(int, char *, void *, void *);
CODE:
	func   = INT2PTR(double(*)(int, char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, p2, p3);
OUTPUT:
	RETVAL

short
nci_sitpp( c_func, i0, t1, p2, p3 )
	SV* c_func
	int i0
	char * t1
	void * p2
	void * p3
PREINIT:
	short(*func)(int, char *, void *, void *);
CODE:
	func   = INT2PTR(short(*)(int, char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, p2, p3);
OUTPUT:
	RETVAL

float
nci_fitpp( c_func, i0, t1, p2, p3 )
	SV* c_func
	int i0
	char * t1
	void * p2
	void * p3
PREINIT:
	float(*func)(int, char *, void *, void *);
CODE:
	func   = INT2PTR(float(*)(int, char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, p2, p3);
OUTPUT:
	RETVAL

char *
nci_titpp( c_func, i0, t1, p2, p3 )
	SV* c_func
	int i0
	char * t1
	void * p2
	void * p3
PREINIT:
	char *(*func)(int, char *, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(int, char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, p2, p3);
OUTPUT:
	RETVAL

int
nci_iitpp( c_func, i0, t1, p2, p3 )
	SV* c_func
	int i0
	char * t1
	void * p2
	void * p3
PREINIT:
	int(*func)(int, char *, void *, void *);
CODE:
	func   = INT2PTR(int(*)(int, char *, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, p2, p3);
OUTPUT:
	RETVAL

void *
nci_ppipp( c_func, p0, i1, p2, p3 )
	SV* c_func
	void * p0
	int i1
	void * p2
	void * p3
PREINIT:
	void *(*func)(void *, int, void *, void *);
CODE:
	func   = INT2PTR(void *(*)(void *, int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, p2, p3);
OUTPUT:
	RETVAL

void
nci_vpipp( c_func, p0, i1, p2, p3 )
	SV* c_func
	void * p0
	int i1
	void * p2
	void * p3
PREINIT:
	void(*func)(void *, int, void *, void *);
CODE:
	func   = INT2PTR(void(*)(void *, int, void *, void *), SvIV(c_func) );
	(*func)(p0, i1, p2, p3);

double
nci_dpipp( c_func, p0, i1, p2, p3 )
	SV* c_func
	void * p0
	int i1
	void * p2
	void * p3
PREINIT:
	double(*func)(void *, int, void *, void *);
CODE:
	func   = INT2PTR(double(*)(void *, int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, p2, p3);
OUTPUT:
	RETVAL

short
nci_spipp( c_func, p0, i1, p2, p3 )
	SV* c_func
	void * p0
	int i1
	void * p2
	void * p3
PREINIT:
	short(*func)(void *, int, void *, void *);
CODE:
	func   = INT2PTR(short(*)(void *, int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, p2, p3);
OUTPUT:
	RETVAL

float
nci_fpipp( c_func, p0, i1, p2, p3 )
	SV* c_func
	void * p0
	int i1
	void * p2
	void * p3
PREINIT:
	float(*func)(void *, int, void *, void *);
CODE:
	func   = INT2PTR(float(*)(void *, int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, p2, p3);
OUTPUT:
	RETVAL

char *
nci_tpipp( c_func, p0, i1, p2, p3 )
	SV* c_func
	void * p0
	int i1
	void * p2
	void * p3
PREINIT:
	char *(*func)(void *, int, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, p2, p3);
OUTPUT:
	RETVAL

int
nci_ipipp( c_func, p0, i1, p2, p3 )
	SV* c_func
	void * p0
	int i1
	void * p2
	void * p3
PREINIT:
	int(*func)(void *, int, void *, void *);
CODE:
	func   = INT2PTR(int(*)(void *, int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, p2, p3);
OUTPUT:
	RETVAL

void *
nci_pvipp( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvipp( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvipp( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svipp( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvipp( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvipp( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivipp( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdipp( c_func, d0, i1, p2, p3 )
	SV* c_func
	double d0
	int i1
	void * p2
	void * p3
PREINIT:
	void *(*func)(double, int, void *, void *);
CODE:
	func   = INT2PTR(void *(*)(double, int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, p2, p3);
OUTPUT:
	RETVAL

void
nci_vdipp( c_func, d0, i1, p2, p3 )
	SV* c_func
	double d0
	int i1
	void * p2
	void * p3
PREINIT:
	void(*func)(double, int, void *, void *);
CODE:
	func   = INT2PTR(void(*)(double, int, void *, void *), SvIV(c_func) );
	(*func)(d0, i1, p2, p3);

double
nci_ddipp( c_func, d0, i1, p2, p3 )
	SV* c_func
	double d0
	int i1
	void * p2
	void * p3
PREINIT:
	double(*func)(double, int, void *, void *);
CODE:
	func   = INT2PTR(double(*)(double, int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, p2, p3);
OUTPUT:
	RETVAL

short
nci_sdipp( c_func, d0, i1, p2, p3 )
	SV* c_func
	double d0
	int i1
	void * p2
	void * p3
PREINIT:
	short(*func)(double, int, void *, void *);
CODE:
	func   = INT2PTR(short(*)(double, int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, p2, p3);
OUTPUT:
	RETVAL

float
nci_fdipp( c_func, d0, i1, p2, p3 )
	SV* c_func
	double d0
	int i1
	void * p2
	void * p3
PREINIT:
	float(*func)(double, int, void *, void *);
CODE:
	func   = INT2PTR(float(*)(double, int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, p2, p3);
OUTPUT:
	RETVAL

char *
nci_tdipp( c_func, d0, i1, p2, p3 )
	SV* c_func
	double d0
	int i1
	void * p2
	void * p3
PREINIT:
	char *(*func)(double, int, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(double, int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, p2, p3);
OUTPUT:
	RETVAL

int
nci_idipp( c_func, d0, i1, p2, p3 )
	SV* c_func
	double d0
	int i1
	void * p2
	void * p3
PREINIT:
	int(*func)(double, int, void *, void *);
CODE:
	func   = INT2PTR(int(*)(double, int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, p2, p3);
OUTPUT:
	RETVAL

void *
nci_psipp( c_func, s0, i1, p2, p3 )
	SV* c_func
	short s0
	int i1
	void * p2
	void * p3
PREINIT:
	void *(*func)(short, int, void *, void *);
CODE:
	func   = INT2PTR(void *(*)(short, int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, p2, p3);
OUTPUT:
	RETVAL

void
nci_vsipp( c_func, s0, i1, p2, p3 )
	SV* c_func
	short s0
	int i1
	void * p2
	void * p3
PREINIT:
	void(*func)(short, int, void *, void *);
CODE:
	func   = INT2PTR(void(*)(short, int, void *, void *), SvIV(c_func) );
	(*func)(s0, i1, p2, p3);

double
nci_dsipp( c_func, s0, i1, p2, p3 )
	SV* c_func
	short s0
	int i1
	void * p2
	void * p3
PREINIT:
	double(*func)(short, int, void *, void *);
CODE:
	func   = INT2PTR(double(*)(short, int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, p2, p3);
OUTPUT:
	RETVAL

short
nci_ssipp( c_func, s0, i1, p2, p3 )
	SV* c_func
	short s0
	int i1
	void * p2
	void * p3
PREINIT:
	short(*func)(short, int, void *, void *);
CODE:
	func   = INT2PTR(short(*)(short, int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, p2, p3);
OUTPUT:
	RETVAL

float
nci_fsipp( c_func, s0, i1, p2, p3 )
	SV* c_func
	short s0
	int i1
	void * p2
	void * p3
PREINIT:
	float(*func)(short, int, void *, void *);
CODE:
	func   = INT2PTR(float(*)(short, int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, p2, p3);
OUTPUT:
	RETVAL

char *
nci_tsipp( c_func, s0, i1, p2, p3 )
	SV* c_func
	short s0
	int i1
	void * p2
	void * p3
PREINIT:
	char *(*func)(short, int, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(short, int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, p2, p3);
OUTPUT:
	RETVAL

int
nci_isipp( c_func, s0, i1, p2, p3 )
	SV* c_func
	short s0
	int i1
	void * p2
	void * p3
PREINIT:
	int(*func)(short, int, void *, void *);
CODE:
	func   = INT2PTR(int(*)(short, int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, p2, p3);
OUTPUT:
	RETVAL

void *
nci_pfipp( c_func, f0, i1, p2, p3 )
	SV* c_func
	float f0
	int i1
	void * p2
	void * p3
PREINIT:
	void *(*func)(float, int, void *, void *);
CODE:
	func   = INT2PTR(void *(*)(float, int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, p2, p3);
OUTPUT:
	RETVAL

void
nci_vfipp( c_func, f0, i1, p2, p3 )
	SV* c_func
	float f0
	int i1
	void * p2
	void * p3
PREINIT:
	void(*func)(float, int, void *, void *);
CODE:
	func   = INT2PTR(void(*)(float, int, void *, void *), SvIV(c_func) );
	(*func)(f0, i1, p2, p3);

double
nci_dfipp( c_func, f0, i1, p2, p3 )
	SV* c_func
	float f0
	int i1
	void * p2
	void * p3
PREINIT:
	double(*func)(float, int, void *, void *);
CODE:
	func   = INT2PTR(double(*)(float, int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, p2, p3);
OUTPUT:
	RETVAL

short
nci_sfipp( c_func, f0, i1, p2, p3 )
	SV* c_func
	float f0
	int i1
	void * p2
	void * p3
PREINIT:
	short(*func)(float, int, void *, void *);
CODE:
	func   = INT2PTR(short(*)(float, int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, p2, p3);
OUTPUT:
	RETVAL

float
nci_ffipp( c_func, f0, i1, p2, p3 )
	SV* c_func
	float f0
	int i1
	void * p2
	void * p3
PREINIT:
	float(*func)(float, int, void *, void *);
CODE:
	func   = INT2PTR(float(*)(float, int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, p2, p3);
OUTPUT:
	RETVAL

char *
nci_tfipp( c_func, f0, i1, p2, p3 )
	SV* c_func
	float f0
	int i1
	void * p2
	void * p3
PREINIT:
	char *(*func)(float, int, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(float, int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, p2, p3);
OUTPUT:
	RETVAL

int
nci_ifipp( c_func, f0, i1, p2, p3 )
	SV* c_func
	float f0
	int i1
	void * p2
	void * p3
PREINIT:
	int(*func)(float, int, void *, void *);
CODE:
	func   = INT2PTR(int(*)(float, int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, p2, p3);
OUTPUT:
	RETVAL

void *
nci_ptipp( c_func, t0, i1, p2, p3 )
	SV* c_func
	char * t0
	int i1
	void * p2
	void * p3
PREINIT:
	void *(*func)(char *, int, void *, void *);
CODE:
	func   = INT2PTR(void *(*)(char *, int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, p2, p3);
OUTPUT:
	RETVAL

void
nci_vtipp( c_func, t0, i1, p2, p3 )
	SV* c_func
	char * t0
	int i1
	void * p2
	void * p3
PREINIT:
	void(*func)(char *, int, void *, void *);
CODE:
	func   = INT2PTR(void(*)(char *, int, void *, void *), SvIV(c_func) );
	(*func)(t0, i1, p2, p3);

double
nci_dtipp( c_func, t0, i1, p2, p3 )
	SV* c_func
	char * t0
	int i1
	void * p2
	void * p3
PREINIT:
	double(*func)(char *, int, void *, void *);
CODE:
	func   = INT2PTR(double(*)(char *, int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, p2, p3);
OUTPUT:
	RETVAL

short
nci_stipp( c_func, t0, i1, p2, p3 )
	SV* c_func
	char * t0
	int i1
	void * p2
	void * p3
PREINIT:
	short(*func)(char *, int, void *, void *);
CODE:
	func   = INT2PTR(short(*)(char *, int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, p2, p3);
OUTPUT:
	RETVAL

float
nci_ftipp( c_func, t0, i1, p2, p3 )
	SV* c_func
	char * t0
	int i1
	void * p2
	void * p3
PREINIT:
	float(*func)(char *, int, void *, void *);
CODE:
	func   = INT2PTR(float(*)(char *, int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, p2, p3);
OUTPUT:
	RETVAL

char *
nci_ttipp( c_func, t0, i1, p2, p3 )
	SV* c_func
	char * t0
	int i1
	void * p2
	void * p3
PREINIT:
	char *(*func)(char *, int, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, p2, p3);
OUTPUT:
	RETVAL

int
nci_itipp( c_func, t0, i1, p2, p3 )
	SV* c_func
	char * t0
	int i1
	void * p2
	void * p3
PREINIT:
	int(*func)(char *, int, void *, void *);
CODE:
	func   = INT2PTR(int(*)(char *, int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, p2, p3);
OUTPUT:
	RETVAL

void *
nci_piipp( c_func, i0, i1, p2, p3 )
	SV* c_func
	int i0
	int i1
	void * p2
	void * p3
PREINIT:
	void *(*func)(int, int, void *, void *);
CODE:
	func   = INT2PTR(void *(*)(int, int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, p2, p3);
OUTPUT:
	RETVAL

void
nci_viipp( c_func, i0, i1, p2, p3 )
	SV* c_func
	int i0
	int i1
	void * p2
	void * p3
PREINIT:
	void(*func)(int, int, void *, void *);
CODE:
	func   = INT2PTR(void(*)(int, int, void *, void *), SvIV(c_func) );
	(*func)(i0, i1, p2, p3);

double
nci_diipp( c_func, i0, i1, p2, p3 )
	SV* c_func
	int i0
	int i1
	void * p2
	void * p3
PREINIT:
	double(*func)(int, int, void *, void *);
CODE:
	func   = INT2PTR(double(*)(int, int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, p2, p3);
OUTPUT:
	RETVAL

short
nci_siipp( c_func, i0, i1, p2, p3 )
	SV* c_func
	int i0
	int i1
	void * p2
	void * p3
PREINIT:
	short(*func)(int, int, void *, void *);
CODE:
	func   = INT2PTR(short(*)(int, int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, p2, p3);
OUTPUT:
	RETVAL

float
nci_fiipp( c_func, i0, i1, p2, p3 )
	SV* c_func
	int i0
	int i1
	void * p2
	void * p3
PREINIT:
	float(*func)(int, int, void *, void *);
CODE:
	func   = INT2PTR(float(*)(int, int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, p2, p3);
OUTPUT:
	RETVAL

char *
nci_tiipp( c_func, i0, i1, p2, p3 )
	SV* c_func
	int i0
	int i1
	void * p2
	void * p3
PREINIT:
	char *(*func)(int, int, void *, void *);
CODE:
	func   = INT2PTR(char *(*)(int, int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, p2, p3);
OUTPUT:
	RETVAL

int
nci_iiipp( c_func, i0, i1, p2, p3 )
	SV* c_func
	int i0
	int i1
	void * p2
	void * p3
PREINIT:
	int(*func)(int, int, void *, void *);
CODE:
	func   = INT2PTR(int(*)(int, int, void *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, p2, p3);
OUTPUT:
	RETVAL

void *
nci_pppdp( c_func, p0, p1, d2, p3 )
	SV* c_func
	void * p0
	void * p1
	double d2
	void * p3
PREINIT:
	void *(*func)(void *, void *, double, void *);
CODE:
	func   = INT2PTR(void *(*)(void *, void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, d2, p3);
OUTPUT:
	RETVAL

void
nci_vppdp( c_func, p0, p1, d2, p3 )
	SV* c_func
	void * p0
	void * p1
	double d2
	void * p3
PREINIT:
	void(*func)(void *, void *, double, void *);
CODE:
	func   = INT2PTR(void(*)(void *, void *, double, void *), SvIV(c_func) );
	(*func)(p0, p1, d2, p3);

double
nci_dppdp( c_func, p0, p1, d2, p3 )
	SV* c_func
	void * p0
	void * p1
	double d2
	void * p3
PREINIT:
	double(*func)(void *, void *, double, void *);
CODE:
	func   = INT2PTR(double(*)(void *, void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, d2, p3);
OUTPUT:
	RETVAL

short
nci_sppdp( c_func, p0, p1, d2, p3 )
	SV* c_func
	void * p0
	void * p1
	double d2
	void * p3
PREINIT:
	short(*func)(void *, void *, double, void *);
CODE:
	func   = INT2PTR(short(*)(void *, void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, d2, p3);
OUTPUT:
	RETVAL

float
nci_fppdp( c_func, p0, p1, d2, p3 )
	SV* c_func
	void * p0
	void * p1
	double d2
	void * p3
PREINIT:
	float(*func)(void *, void *, double, void *);
CODE:
	func   = INT2PTR(float(*)(void *, void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, d2, p3);
OUTPUT:
	RETVAL

char *
nci_tppdp( c_func, p0, p1, d2, p3 )
	SV* c_func
	void * p0
	void * p1
	double d2
	void * p3
PREINIT:
	char *(*func)(void *, void *, double, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, d2, p3);
OUTPUT:
	RETVAL

int
nci_ippdp( c_func, p0, p1, d2, p3 )
	SV* c_func
	void * p0
	void * p1
	double d2
	void * p3
PREINIT:
	int(*func)(void *, void *, double, void *);
CODE:
	func   = INT2PTR(int(*)(void *, void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, d2, p3);
OUTPUT:
	RETVAL

void *
nci_pvpdp( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvpdp( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvpdp( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svpdp( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvpdp( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvpdp( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivpdp( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdpdp( c_func, d0, p1, d2, p3 )
	SV* c_func
	double d0
	void * p1
	double d2
	void * p3
PREINIT:
	void *(*func)(double, void *, double, void *);
CODE:
	func   = INT2PTR(void *(*)(double, void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, d2, p3);
OUTPUT:
	RETVAL

void
nci_vdpdp( c_func, d0, p1, d2, p3 )
	SV* c_func
	double d0
	void * p1
	double d2
	void * p3
PREINIT:
	void(*func)(double, void *, double, void *);
CODE:
	func   = INT2PTR(void(*)(double, void *, double, void *), SvIV(c_func) );
	(*func)(d0, p1, d2, p3);

double
nci_ddpdp( c_func, d0, p1, d2, p3 )
	SV* c_func
	double d0
	void * p1
	double d2
	void * p3
PREINIT:
	double(*func)(double, void *, double, void *);
CODE:
	func   = INT2PTR(double(*)(double, void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, d2, p3);
OUTPUT:
	RETVAL

short
nci_sdpdp( c_func, d0, p1, d2, p3 )
	SV* c_func
	double d0
	void * p1
	double d2
	void * p3
PREINIT:
	short(*func)(double, void *, double, void *);
CODE:
	func   = INT2PTR(short(*)(double, void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, d2, p3);
OUTPUT:
	RETVAL

float
nci_fdpdp( c_func, d0, p1, d2, p3 )
	SV* c_func
	double d0
	void * p1
	double d2
	void * p3
PREINIT:
	float(*func)(double, void *, double, void *);
CODE:
	func   = INT2PTR(float(*)(double, void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, d2, p3);
OUTPUT:
	RETVAL

char *
nci_tdpdp( c_func, d0, p1, d2, p3 )
	SV* c_func
	double d0
	void * p1
	double d2
	void * p3
PREINIT:
	char *(*func)(double, void *, double, void *);
CODE:
	func   = INT2PTR(char *(*)(double, void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, d2, p3);
OUTPUT:
	RETVAL

int
nci_idpdp( c_func, d0, p1, d2, p3 )
	SV* c_func
	double d0
	void * p1
	double d2
	void * p3
PREINIT:
	int(*func)(double, void *, double, void *);
CODE:
	func   = INT2PTR(int(*)(double, void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, d2, p3);
OUTPUT:
	RETVAL

void *
nci_pspdp( c_func, s0, p1, d2, p3 )
	SV* c_func
	short s0
	void * p1
	double d2
	void * p3
PREINIT:
	void *(*func)(short, void *, double, void *);
CODE:
	func   = INT2PTR(void *(*)(short, void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, d2, p3);
OUTPUT:
	RETVAL

void
nci_vspdp( c_func, s0, p1, d2, p3 )
	SV* c_func
	short s0
	void * p1
	double d2
	void * p3
PREINIT:
	void(*func)(short, void *, double, void *);
CODE:
	func   = INT2PTR(void(*)(short, void *, double, void *), SvIV(c_func) );
	(*func)(s0, p1, d2, p3);

double
nci_dspdp( c_func, s0, p1, d2, p3 )
	SV* c_func
	short s0
	void * p1
	double d2
	void * p3
PREINIT:
	double(*func)(short, void *, double, void *);
CODE:
	func   = INT2PTR(double(*)(short, void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, d2, p3);
OUTPUT:
	RETVAL

short
nci_sspdp( c_func, s0, p1, d2, p3 )
	SV* c_func
	short s0
	void * p1
	double d2
	void * p3
PREINIT:
	short(*func)(short, void *, double, void *);
CODE:
	func   = INT2PTR(short(*)(short, void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, d2, p3);
OUTPUT:
	RETVAL

float
nci_fspdp( c_func, s0, p1, d2, p3 )
	SV* c_func
	short s0
	void * p1
	double d2
	void * p3
PREINIT:
	float(*func)(short, void *, double, void *);
CODE:
	func   = INT2PTR(float(*)(short, void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, d2, p3);
OUTPUT:
	RETVAL

char *
nci_tspdp( c_func, s0, p1, d2, p3 )
	SV* c_func
	short s0
	void * p1
	double d2
	void * p3
PREINIT:
	char *(*func)(short, void *, double, void *);
CODE:
	func   = INT2PTR(char *(*)(short, void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, d2, p3);
OUTPUT:
	RETVAL

int
nci_ispdp( c_func, s0, p1, d2, p3 )
	SV* c_func
	short s0
	void * p1
	double d2
	void * p3
PREINIT:
	int(*func)(short, void *, double, void *);
CODE:
	func   = INT2PTR(int(*)(short, void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, d2, p3);
OUTPUT:
	RETVAL

void *
nci_pfpdp( c_func, f0, p1, d2, p3 )
	SV* c_func
	float f0
	void * p1
	double d2
	void * p3
PREINIT:
	void *(*func)(float, void *, double, void *);
CODE:
	func   = INT2PTR(void *(*)(float, void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, d2, p3);
OUTPUT:
	RETVAL

void
nci_vfpdp( c_func, f0, p1, d2, p3 )
	SV* c_func
	float f0
	void * p1
	double d2
	void * p3
PREINIT:
	void(*func)(float, void *, double, void *);
CODE:
	func   = INT2PTR(void(*)(float, void *, double, void *), SvIV(c_func) );
	(*func)(f0, p1, d2, p3);

double
nci_dfpdp( c_func, f0, p1, d2, p3 )
	SV* c_func
	float f0
	void * p1
	double d2
	void * p3
PREINIT:
	double(*func)(float, void *, double, void *);
CODE:
	func   = INT2PTR(double(*)(float, void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, d2, p3);
OUTPUT:
	RETVAL

short
nci_sfpdp( c_func, f0, p1, d2, p3 )
	SV* c_func
	float f0
	void * p1
	double d2
	void * p3
PREINIT:
	short(*func)(float, void *, double, void *);
CODE:
	func   = INT2PTR(short(*)(float, void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, d2, p3);
OUTPUT:
	RETVAL

float
nci_ffpdp( c_func, f0, p1, d2, p3 )
	SV* c_func
	float f0
	void * p1
	double d2
	void * p3
PREINIT:
	float(*func)(float, void *, double, void *);
CODE:
	func   = INT2PTR(float(*)(float, void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, d2, p3);
OUTPUT:
	RETVAL

char *
nci_tfpdp( c_func, f0, p1, d2, p3 )
	SV* c_func
	float f0
	void * p1
	double d2
	void * p3
PREINIT:
	char *(*func)(float, void *, double, void *);
CODE:
	func   = INT2PTR(char *(*)(float, void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, d2, p3);
OUTPUT:
	RETVAL

int
nci_ifpdp( c_func, f0, p1, d2, p3 )
	SV* c_func
	float f0
	void * p1
	double d2
	void * p3
PREINIT:
	int(*func)(float, void *, double, void *);
CODE:
	func   = INT2PTR(int(*)(float, void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, d2, p3);
OUTPUT:
	RETVAL

void *
nci_ptpdp( c_func, t0, p1, d2, p3 )
	SV* c_func
	char * t0
	void * p1
	double d2
	void * p3
PREINIT:
	void *(*func)(char *, void *, double, void *);
CODE:
	func   = INT2PTR(void *(*)(char *, void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, d2, p3);
OUTPUT:
	RETVAL

void
nci_vtpdp( c_func, t0, p1, d2, p3 )
	SV* c_func
	char * t0
	void * p1
	double d2
	void * p3
PREINIT:
	void(*func)(char *, void *, double, void *);
CODE:
	func   = INT2PTR(void(*)(char *, void *, double, void *), SvIV(c_func) );
	(*func)(t0, p1, d2, p3);

double
nci_dtpdp( c_func, t0, p1, d2, p3 )
	SV* c_func
	char * t0
	void * p1
	double d2
	void * p3
PREINIT:
	double(*func)(char *, void *, double, void *);
CODE:
	func   = INT2PTR(double(*)(char *, void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, d2, p3);
OUTPUT:
	RETVAL

short
nci_stpdp( c_func, t0, p1, d2, p3 )
	SV* c_func
	char * t0
	void * p1
	double d2
	void * p3
PREINIT:
	short(*func)(char *, void *, double, void *);
CODE:
	func   = INT2PTR(short(*)(char *, void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, d2, p3);
OUTPUT:
	RETVAL

float
nci_ftpdp( c_func, t0, p1, d2, p3 )
	SV* c_func
	char * t0
	void * p1
	double d2
	void * p3
PREINIT:
	float(*func)(char *, void *, double, void *);
CODE:
	func   = INT2PTR(float(*)(char *, void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, d2, p3);
OUTPUT:
	RETVAL

char *
nci_ttpdp( c_func, t0, p1, d2, p3 )
	SV* c_func
	char * t0
	void * p1
	double d2
	void * p3
PREINIT:
	char *(*func)(char *, void *, double, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, d2, p3);
OUTPUT:
	RETVAL

int
nci_itpdp( c_func, t0, p1, d2, p3 )
	SV* c_func
	char * t0
	void * p1
	double d2
	void * p3
PREINIT:
	int(*func)(char *, void *, double, void *);
CODE:
	func   = INT2PTR(int(*)(char *, void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, d2, p3);
OUTPUT:
	RETVAL

void *
nci_pipdp( c_func, i0, p1, d2, p3 )
	SV* c_func
	int i0
	void * p1
	double d2
	void * p3
PREINIT:
	void *(*func)(int, void *, double, void *);
CODE:
	func   = INT2PTR(void *(*)(int, void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, d2, p3);
OUTPUT:
	RETVAL

void
nci_vipdp( c_func, i0, p1, d2, p3 )
	SV* c_func
	int i0
	void * p1
	double d2
	void * p3
PREINIT:
	void(*func)(int, void *, double, void *);
CODE:
	func   = INT2PTR(void(*)(int, void *, double, void *), SvIV(c_func) );
	(*func)(i0, p1, d2, p3);

double
nci_dipdp( c_func, i0, p1, d2, p3 )
	SV* c_func
	int i0
	void * p1
	double d2
	void * p3
PREINIT:
	double(*func)(int, void *, double, void *);
CODE:
	func   = INT2PTR(double(*)(int, void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, d2, p3);
OUTPUT:
	RETVAL

short
nci_sipdp( c_func, i0, p1, d2, p3 )
	SV* c_func
	int i0
	void * p1
	double d2
	void * p3
PREINIT:
	short(*func)(int, void *, double, void *);
CODE:
	func   = INT2PTR(short(*)(int, void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, d2, p3);
OUTPUT:
	RETVAL

float
nci_fipdp( c_func, i0, p1, d2, p3 )
	SV* c_func
	int i0
	void * p1
	double d2
	void * p3
PREINIT:
	float(*func)(int, void *, double, void *);
CODE:
	func   = INT2PTR(float(*)(int, void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, d2, p3);
OUTPUT:
	RETVAL

char *
nci_tipdp( c_func, i0, p1, d2, p3 )
	SV* c_func
	int i0
	void * p1
	double d2
	void * p3
PREINIT:
	char *(*func)(int, void *, double, void *);
CODE:
	func   = INT2PTR(char *(*)(int, void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, d2, p3);
OUTPUT:
	RETVAL

int
nci_iipdp( c_func, i0, p1, d2, p3 )
	SV* c_func
	int i0
	void * p1
	double d2
	void * p3
PREINIT:
	int(*func)(int, void *, double, void *);
CODE:
	func   = INT2PTR(int(*)(int, void *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, d2, p3);
OUTPUT:
	RETVAL

void *
nci_ppddp( c_func, p0, d1, d2, p3 )
	SV* c_func
	void * p0
	double d1
	double d2
	void * p3
PREINIT:
	void *(*func)(void *, double, double, void *);
CODE:
	func   = INT2PTR(void *(*)(void *, double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, d2, p3);
OUTPUT:
	RETVAL

void
nci_vpddp( c_func, p0, d1, d2, p3 )
	SV* c_func
	void * p0
	double d1
	double d2
	void * p3
PREINIT:
	void(*func)(void *, double, double, void *);
CODE:
	func   = INT2PTR(void(*)(void *, double, double, void *), SvIV(c_func) );
	(*func)(p0, d1, d2, p3);

double
nci_dpddp( c_func, p0, d1, d2, p3 )
	SV* c_func
	void * p0
	double d1
	double d2
	void * p3
PREINIT:
	double(*func)(void *, double, double, void *);
CODE:
	func   = INT2PTR(double(*)(void *, double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, d2, p3);
OUTPUT:
	RETVAL

short
nci_spddp( c_func, p0, d1, d2, p3 )
	SV* c_func
	void * p0
	double d1
	double d2
	void * p3
PREINIT:
	short(*func)(void *, double, double, void *);
CODE:
	func   = INT2PTR(short(*)(void *, double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, d2, p3);
OUTPUT:
	RETVAL

float
nci_fpddp( c_func, p0, d1, d2, p3 )
	SV* c_func
	void * p0
	double d1
	double d2
	void * p3
PREINIT:
	float(*func)(void *, double, double, void *);
CODE:
	func   = INT2PTR(float(*)(void *, double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, d2, p3);
OUTPUT:
	RETVAL

char *
nci_tpddp( c_func, p0, d1, d2, p3 )
	SV* c_func
	void * p0
	double d1
	double d2
	void * p3
PREINIT:
	char *(*func)(void *, double, double, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, d2, p3);
OUTPUT:
	RETVAL

int
nci_ipddp( c_func, p0, d1, d2, p3 )
	SV* c_func
	void * p0
	double d1
	double d2
	void * p3
PREINIT:
	int(*func)(void *, double, double, void *);
CODE:
	func   = INT2PTR(int(*)(void *, double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, d2, p3);
OUTPUT:
	RETVAL

void *
nci_pvddp( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvddp( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvddp( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svddp( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvddp( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvddp( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivddp( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdddp( c_func, d0, d1, d2, p3 )
	SV* c_func
	double d0
	double d1
	double d2
	void * p3
PREINIT:
	void *(*func)(double, double, double, void *);
CODE:
	func   = INT2PTR(void *(*)(double, double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, d2, p3);
OUTPUT:
	RETVAL

void
nci_vdddp( c_func, d0, d1, d2, p3 )
	SV* c_func
	double d0
	double d1
	double d2
	void * p3
PREINIT:
	void(*func)(double, double, double, void *);
CODE:
	func   = INT2PTR(void(*)(double, double, double, void *), SvIV(c_func) );
	(*func)(d0, d1, d2, p3);

double
nci_ddddp( c_func, d0, d1, d2, p3 )
	SV* c_func
	double d0
	double d1
	double d2
	void * p3
PREINIT:
	double(*func)(double, double, double, void *);
CODE:
	func   = INT2PTR(double(*)(double, double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, d2, p3);
OUTPUT:
	RETVAL

short
nci_sdddp( c_func, d0, d1, d2, p3 )
	SV* c_func
	double d0
	double d1
	double d2
	void * p3
PREINIT:
	short(*func)(double, double, double, void *);
CODE:
	func   = INT2PTR(short(*)(double, double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, d2, p3);
OUTPUT:
	RETVAL

float
nci_fdddp( c_func, d0, d1, d2, p3 )
	SV* c_func
	double d0
	double d1
	double d2
	void * p3
PREINIT:
	float(*func)(double, double, double, void *);
CODE:
	func   = INT2PTR(float(*)(double, double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, d2, p3);
OUTPUT:
	RETVAL

char *
nci_tdddp( c_func, d0, d1, d2, p3 )
	SV* c_func
	double d0
	double d1
	double d2
	void * p3
PREINIT:
	char *(*func)(double, double, double, void *);
CODE:
	func   = INT2PTR(char *(*)(double, double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, d2, p3);
OUTPUT:
	RETVAL

int
nci_idddp( c_func, d0, d1, d2, p3 )
	SV* c_func
	double d0
	double d1
	double d2
	void * p3
PREINIT:
	int(*func)(double, double, double, void *);
CODE:
	func   = INT2PTR(int(*)(double, double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, d2, p3);
OUTPUT:
	RETVAL

void *
nci_psddp( c_func, s0, d1, d2, p3 )
	SV* c_func
	short s0
	double d1
	double d2
	void * p3
PREINIT:
	void *(*func)(short, double, double, void *);
CODE:
	func   = INT2PTR(void *(*)(short, double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, d2, p3);
OUTPUT:
	RETVAL

void
nci_vsddp( c_func, s0, d1, d2, p3 )
	SV* c_func
	short s0
	double d1
	double d2
	void * p3
PREINIT:
	void(*func)(short, double, double, void *);
CODE:
	func   = INT2PTR(void(*)(short, double, double, void *), SvIV(c_func) );
	(*func)(s0, d1, d2, p3);

double
nci_dsddp( c_func, s0, d1, d2, p3 )
	SV* c_func
	short s0
	double d1
	double d2
	void * p3
PREINIT:
	double(*func)(short, double, double, void *);
CODE:
	func   = INT2PTR(double(*)(short, double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, d2, p3);
OUTPUT:
	RETVAL

short
nci_ssddp( c_func, s0, d1, d2, p3 )
	SV* c_func
	short s0
	double d1
	double d2
	void * p3
PREINIT:
	short(*func)(short, double, double, void *);
CODE:
	func   = INT2PTR(short(*)(short, double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, d2, p3);
OUTPUT:
	RETVAL

float
nci_fsddp( c_func, s0, d1, d2, p3 )
	SV* c_func
	short s0
	double d1
	double d2
	void * p3
PREINIT:
	float(*func)(short, double, double, void *);
CODE:
	func   = INT2PTR(float(*)(short, double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, d2, p3);
OUTPUT:
	RETVAL

char *
nci_tsddp( c_func, s0, d1, d2, p3 )
	SV* c_func
	short s0
	double d1
	double d2
	void * p3
PREINIT:
	char *(*func)(short, double, double, void *);
CODE:
	func   = INT2PTR(char *(*)(short, double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, d2, p3);
OUTPUT:
	RETVAL

int
nci_isddp( c_func, s0, d1, d2, p3 )
	SV* c_func
	short s0
	double d1
	double d2
	void * p3
PREINIT:
	int(*func)(short, double, double, void *);
CODE:
	func   = INT2PTR(int(*)(short, double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, d2, p3);
OUTPUT:
	RETVAL

void *
nci_pfddp( c_func, f0, d1, d2, p3 )
	SV* c_func
	float f0
	double d1
	double d2
	void * p3
PREINIT:
	void *(*func)(float, double, double, void *);
CODE:
	func   = INT2PTR(void *(*)(float, double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, d2, p3);
OUTPUT:
	RETVAL

void
nci_vfddp( c_func, f0, d1, d2, p3 )
	SV* c_func
	float f0
	double d1
	double d2
	void * p3
PREINIT:
	void(*func)(float, double, double, void *);
CODE:
	func   = INT2PTR(void(*)(float, double, double, void *), SvIV(c_func) );
	(*func)(f0, d1, d2, p3);

double
nci_dfddp( c_func, f0, d1, d2, p3 )
	SV* c_func
	float f0
	double d1
	double d2
	void * p3
PREINIT:
	double(*func)(float, double, double, void *);
CODE:
	func   = INT2PTR(double(*)(float, double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, d2, p3);
OUTPUT:
	RETVAL

short
nci_sfddp( c_func, f0, d1, d2, p3 )
	SV* c_func
	float f0
	double d1
	double d2
	void * p3
PREINIT:
	short(*func)(float, double, double, void *);
CODE:
	func   = INT2PTR(short(*)(float, double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, d2, p3);
OUTPUT:
	RETVAL

float
nci_ffddp( c_func, f0, d1, d2, p3 )
	SV* c_func
	float f0
	double d1
	double d2
	void * p3
PREINIT:
	float(*func)(float, double, double, void *);
CODE:
	func   = INT2PTR(float(*)(float, double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, d2, p3);
OUTPUT:
	RETVAL

char *
nci_tfddp( c_func, f0, d1, d2, p3 )
	SV* c_func
	float f0
	double d1
	double d2
	void * p3
PREINIT:
	char *(*func)(float, double, double, void *);
CODE:
	func   = INT2PTR(char *(*)(float, double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, d2, p3);
OUTPUT:
	RETVAL

int
nci_ifddp( c_func, f0, d1, d2, p3 )
	SV* c_func
	float f0
	double d1
	double d2
	void * p3
PREINIT:
	int(*func)(float, double, double, void *);
CODE:
	func   = INT2PTR(int(*)(float, double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, d2, p3);
OUTPUT:
	RETVAL

void *
nci_ptddp( c_func, t0, d1, d2, p3 )
	SV* c_func
	char * t0
	double d1
	double d2
	void * p3
PREINIT:
	void *(*func)(char *, double, double, void *);
CODE:
	func   = INT2PTR(void *(*)(char *, double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, d2, p3);
OUTPUT:
	RETVAL

void
nci_vtddp( c_func, t0, d1, d2, p3 )
	SV* c_func
	char * t0
	double d1
	double d2
	void * p3
PREINIT:
	void(*func)(char *, double, double, void *);
CODE:
	func   = INT2PTR(void(*)(char *, double, double, void *), SvIV(c_func) );
	(*func)(t0, d1, d2, p3);

double
nci_dtddp( c_func, t0, d1, d2, p3 )
	SV* c_func
	char * t0
	double d1
	double d2
	void * p3
PREINIT:
	double(*func)(char *, double, double, void *);
CODE:
	func   = INT2PTR(double(*)(char *, double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, d2, p3);
OUTPUT:
	RETVAL

short
nci_stddp( c_func, t0, d1, d2, p3 )
	SV* c_func
	char * t0
	double d1
	double d2
	void * p3
PREINIT:
	short(*func)(char *, double, double, void *);
CODE:
	func   = INT2PTR(short(*)(char *, double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, d2, p3);
OUTPUT:
	RETVAL

float
nci_ftddp( c_func, t0, d1, d2, p3 )
	SV* c_func
	char * t0
	double d1
	double d2
	void * p3
PREINIT:
	float(*func)(char *, double, double, void *);
CODE:
	func   = INT2PTR(float(*)(char *, double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, d2, p3);
OUTPUT:
	RETVAL

char *
nci_ttddp( c_func, t0, d1, d2, p3 )
	SV* c_func
	char * t0
	double d1
	double d2
	void * p3
PREINIT:
	char *(*func)(char *, double, double, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, d2, p3);
OUTPUT:
	RETVAL

int
nci_itddp( c_func, t0, d1, d2, p3 )
	SV* c_func
	char * t0
	double d1
	double d2
	void * p3
PREINIT:
	int(*func)(char *, double, double, void *);
CODE:
	func   = INT2PTR(int(*)(char *, double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, d2, p3);
OUTPUT:
	RETVAL

void *
nci_piddp( c_func, i0, d1, d2, p3 )
	SV* c_func
	int i0
	double d1
	double d2
	void * p3
PREINIT:
	void *(*func)(int, double, double, void *);
CODE:
	func   = INT2PTR(void *(*)(int, double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, d2, p3);
OUTPUT:
	RETVAL

void
nci_viddp( c_func, i0, d1, d2, p3 )
	SV* c_func
	int i0
	double d1
	double d2
	void * p3
PREINIT:
	void(*func)(int, double, double, void *);
CODE:
	func   = INT2PTR(void(*)(int, double, double, void *), SvIV(c_func) );
	(*func)(i0, d1, d2, p3);

double
nci_diddp( c_func, i0, d1, d2, p3 )
	SV* c_func
	int i0
	double d1
	double d2
	void * p3
PREINIT:
	double(*func)(int, double, double, void *);
CODE:
	func   = INT2PTR(double(*)(int, double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, d2, p3);
OUTPUT:
	RETVAL

short
nci_siddp( c_func, i0, d1, d2, p3 )
	SV* c_func
	int i0
	double d1
	double d2
	void * p3
PREINIT:
	short(*func)(int, double, double, void *);
CODE:
	func   = INT2PTR(short(*)(int, double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, d2, p3);
OUTPUT:
	RETVAL

float
nci_fiddp( c_func, i0, d1, d2, p3 )
	SV* c_func
	int i0
	double d1
	double d2
	void * p3
PREINIT:
	float(*func)(int, double, double, void *);
CODE:
	func   = INT2PTR(float(*)(int, double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, d2, p3);
OUTPUT:
	RETVAL

char *
nci_tiddp( c_func, i0, d1, d2, p3 )
	SV* c_func
	int i0
	double d1
	double d2
	void * p3
PREINIT:
	char *(*func)(int, double, double, void *);
CODE:
	func   = INT2PTR(char *(*)(int, double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, d2, p3);
OUTPUT:
	RETVAL

int
nci_iiddp( c_func, i0, d1, d2, p3 )
	SV* c_func
	int i0
	double d1
	double d2
	void * p3
PREINIT:
	int(*func)(int, double, double, void *);
CODE:
	func   = INT2PTR(int(*)(int, double, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, d2, p3);
OUTPUT:
	RETVAL

void *
nci_ppsdp( c_func, p0, s1, d2, p3 )
	SV* c_func
	void * p0
	short s1
	double d2
	void * p3
PREINIT:
	void *(*func)(void *, short, double, void *);
CODE:
	func   = INT2PTR(void *(*)(void *, short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, d2, p3);
OUTPUT:
	RETVAL

void
nci_vpsdp( c_func, p0, s1, d2, p3 )
	SV* c_func
	void * p0
	short s1
	double d2
	void * p3
PREINIT:
	void(*func)(void *, short, double, void *);
CODE:
	func   = INT2PTR(void(*)(void *, short, double, void *), SvIV(c_func) );
	(*func)(p0, s1, d2, p3);

double
nci_dpsdp( c_func, p0, s1, d2, p3 )
	SV* c_func
	void * p0
	short s1
	double d2
	void * p3
PREINIT:
	double(*func)(void *, short, double, void *);
CODE:
	func   = INT2PTR(double(*)(void *, short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, d2, p3);
OUTPUT:
	RETVAL

short
nci_spsdp( c_func, p0, s1, d2, p3 )
	SV* c_func
	void * p0
	short s1
	double d2
	void * p3
PREINIT:
	short(*func)(void *, short, double, void *);
CODE:
	func   = INT2PTR(short(*)(void *, short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, d2, p3);
OUTPUT:
	RETVAL

float
nci_fpsdp( c_func, p0, s1, d2, p3 )
	SV* c_func
	void * p0
	short s1
	double d2
	void * p3
PREINIT:
	float(*func)(void *, short, double, void *);
CODE:
	func   = INT2PTR(float(*)(void *, short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, d2, p3);
OUTPUT:
	RETVAL

char *
nci_tpsdp( c_func, p0, s1, d2, p3 )
	SV* c_func
	void * p0
	short s1
	double d2
	void * p3
PREINIT:
	char *(*func)(void *, short, double, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, d2, p3);
OUTPUT:
	RETVAL

int
nci_ipsdp( c_func, p0, s1, d2, p3 )
	SV* c_func
	void * p0
	short s1
	double d2
	void * p3
PREINIT:
	int(*func)(void *, short, double, void *);
CODE:
	func   = INT2PTR(int(*)(void *, short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, d2, p3);
OUTPUT:
	RETVAL

void *
nci_pvsdp( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvsdp( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvsdp( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svsdp( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvsdp( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvsdp( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivsdp( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdsdp( c_func, d0, s1, d2, p3 )
	SV* c_func
	double d0
	short s1
	double d2
	void * p3
PREINIT:
	void *(*func)(double, short, double, void *);
CODE:
	func   = INT2PTR(void *(*)(double, short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, d2, p3);
OUTPUT:
	RETVAL

void
nci_vdsdp( c_func, d0, s1, d2, p3 )
	SV* c_func
	double d0
	short s1
	double d2
	void * p3
PREINIT:
	void(*func)(double, short, double, void *);
CODE:
	func   = INT2PTR(void(*)(double, short, double, void *), SvIV(c_func) );
	(*func)(d0, s1, d2, p3);

double
nci_ddsdp( c_func, d0, s1, d2, p3 )
	SV* c_func
	double d0
	short s1
	double d2
	void * p3
PREINIT:
	double(*func)(double, short, double, void *);
CODE:
	func   = INT2PTR(double(*)(double, short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, d2, p3);
OUTPUT:
	RETVAL

short
nci_sdsdp( c_func, d0, s1, d2, p3 )
	SV* c_func
	double d0
	short s1
	double d2
	void * p3
PREINIT:
	short(*func)(double, short, double, void *);
CODE:
	func   = INT2PTR(short(*)(double, short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, d2, p3);
OUTPUT:
	RETVAL

float
nci_fdsdp( c_func, d0, s1, d2, p3 )
	SV* c_func
	double d0
	short s1
	double d2
	void * p3
PREINIT:
	float(*func)(double, short, double, void *);
CODE:
	func   = INT2PTR(float(*)(double, short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, d2, p3);
OUTPUT:
	RETVAL

char *
nci_tdsdp( c_func, d0, s1, d2, p3 )
	SV* c_func
	double d0
	short s1
	double d2
	void * p3
PREINIT:
	char *(*func)(double, short, double, void *);
CODE:
	func   = INT2PTR(char *(*)(double, short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, d2, p3);
OUTPUT:
	RETVAL

int
nci_idsdp( c_func, d0, s1, d2, p3 )
	SV* c_func
	double d0
	short s1
	double d2
	void * p3
PREINIT:
	int(*func)(double, short, double, void *);
CODE:
	func   = INT2PTR(int(*)(double, short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, d2, p3);
OUTPUT:
	RETVAL

void *
nci_pssdp( c_func, s0, s1, d2, p3 )
	SV* c_func
	short s0
	short s1
	double d2
	void * p3
PREINIT:
	void *(*func)(short, short, double, void *);
CODE:
	func   = INT2PTR(void *(*)(short, short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, d2, p3);
OUTPUT:
	RETVAL

void
nci_vssdp( c_func, s0, s1, d2, p3 )
	SV* c_func
	short s0
	short s1
	double d2
	void * p3
PREINIT:
	void(*func)(short, short, double, void *);
CODE:
	func   = INT2PTR(void(*)(short, short, double, void *), SvIV(c_func) );
	(*func)(s0, s1, d2, p3);

double
nci_dssdp( c_func, s0, s1, d2, p3 )
	SV* c_func
	short s0
	short s1
	double d2
	void * p3
PREINIT:
	double(*func)(short, short, double, void *);
CODE:
	func   = INT2PTR(double(*)(short, short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, d2, p3);
OUTPUT:
	RETVAL

short
nci_sssdp( c_func, s0, s1, d2, p3 )
	SV* c_func
	short s0
	short s1
	double d2
	void * p3
PREINIT:
	short(*func)(short, short, double, void *);
CODE:
	func   = INT2PTR(short(*)(short, short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, d2, p3);
OUTPUT:
	RETVAL

float
nci_fssdp( c_func, s0, s1, d2, p3 )
	SV* c_func
	short s0
	short s1
	double d2
	void * p3
PREINIT:
	float(*func)(short, short, double, void *);
CODE:
	func   = INT2PTR(float(*)(short, short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, d2, p3);
OUTPUT:
	RETVAL

char *
nci_tssdp( c_func, s0, s1, d2, p3 )
	SV* c_func
	short s0
	short s1
	double d2
	void * p3
PREINIT:
	char *(*func)(short, short, double, void *);
CODE:
	func   = INT2PTR(char *(*)(short, short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, d2, p3);
OUTPUT:
	RETVAL

int
nci_issdp( c_func, s0, s1, d2, p3 )
	SV* c_func
	short s0
	short s1
	double d2
	void * p3
PREINIT:
	int(*func)(short, short, double, void *);
CODE:
	func   = INT2PTR(int(*)(short, short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, d2, p3);
OUTPUT:
	RETVAL

void *
nci_pfsdp( c_func, f0, s1, d2, p3 )
	SV* c_func
	float f0
	short s1
	double d2
	void * p3
PREINIT:
	void *(*func)(float, short, double, void *);
CODE:
	func   = INT2PTR(void *(*)(float, short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, d2, p3);
OUTPUT:
	RETVAL

void
nci_vfsdp( c_func, f0, s1, d2, p3 )
	SV* c_func
	float f0
	short s1
	double d2
	void * p3
PREINIT:
	void(*func)(float, short, double, void *);
CODE:
	func   = INT2PTR(void(*)(float, short, double, void *), SvIV(c_func) );
	(*func)(f0, s1, d2, p3);

double
nci_dfsdp( c_func, f0, s1, d2, p3 )
	SV* c_func
	float f0
	short s1
	double d2
	void * p3
PREINIT:
	double(*func)(float, short, double, void *);
CODE:
	func   = INT2PTR(double(*)(float, short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, d2, p3);
OUTPUT:
	RETVAL

short
nci_sfsdp( c_func, f0, s1, d2, p3 )
	SV* c_func
	float f0
	short s1
	double d2
	void * p3
PREINIT:
	short(*func)(float, short, double, void *);
CODE:
	func   = INT2PTR(short(*)(float, short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, d2, p3);
OUTPUT:
	RETVAL

float
nci_ffsdp( c_func, f0, s1, d2, p3 )
	SV* c_func
	float f0
	short s1
	double d2
	void * p3
PREINIT:
	float(*func)(float, short, double, void *);
CODE:
	func   = INT2PTR(float(*)(float, short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, d2, p3);
OUTPUT:
	RETVAL

char *
nci_tfsdp( c_func, f0, s1, d2, p3 )
	SV* c_func
	float f0
	short s1
	double d2
	void * p3
PREINIT:
	char *(*func)(float, short, double, void *);
CODE:
	func   = INT2PTR(char *(*)(float, short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, d2, p3);
OUTPUT:
	RETVAL

int
nci_ifsdp( c_func, f0, s1, d2, p3 )
	SV* c_func
	float f0
	short s1
	double d2
	void * p3
PREINIT:
	int(*func)(float, short, double, void *);
CODE:
	func   = INT2PTR(int(*)(float, short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, d2, p3);
OUTPUT:
	RETVAL

void *
nci_ptsdp( c_func, t0, s1, d2, p3 )
	SV* c_func
	char * t0
	short s1
	double d2
	void * p3
PREINIT:
	void *(*func)(char *, short, double, void *);
CODE:
	func   = INT2PTR(void *(*)(char *, short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, d2, p3);
OUTPUT:
	RETVAL

void
nci_vtsdp( c_func, t0, s1, d2, p3 )
	SV* c_func
	char * t0
	short s1
	double d2
	void * p3
PREINIT:
	void(*func)(char *, short, double, void *);
CODE:
	func   = INT2PTR(void(*)(char *, short, double, void *), SvIV(c_func) );
	(*func)(t0, s1, d2, p3);

double
nci_dtsdp( c_func, t0, s1, d2, p3 )
	SV* c_func
	char * t0
	short s1
	double d2
	void * p3
PREINIT:
	double(*func)(char *, short, double, void *);
CODE:
	func   = INT2PTR(double(*)(char *, short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, d2, p3);
OUTPUT:
	RETVAL

short
nci_stsdp( c_func, t0, s1, d2, p3 )
	SV* c_func
	char * t0
	short s1
	double d2
	void * p3
PREINIT:
	short(*func)(char *, short, double, void *);
CODE:
	func   = INT2PTR(short(*)(char *, short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, d2, p3);
OUTPUT:
	RETVAL

float
nci_ftsdp( c_func, t0, s1, d2, p3 )
	SV* c_func
	char * t0
	short s1
	double d2
	void * p3
PREINIT:
	float(*func)(char *, short, double, void *);
CODE:
	func   = INT2PTR(float(*)(char *, short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, d2, p3);
OUTPUT:
	RETVAL

char *
nci_ttsdp( c_func, t0, s1, d2, p3 )
	SV* c_func
	char * t0
	short s1
	double d2
	void * p3
PREINIT:
	char *(*func)(char *, short, double, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, d2, p3);
OUTPUT:
	RETVAL

int
nci_itsdp( c_func, t0, s1, d2, p3 )
	SV* c_func
	char * t0
	short s1
	double d2
	void * p3
PREINIT:
	int(*func)(char *, short, double, void *);
CODE:
	func   = INT2PTR(int(*)(char *, short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, d2, p3);
OUTPUT:
	RETVAL

void *
nci_pisdp( c_func, i0, s1, d2, p3 )
	SV* c_func
	int i0
	short s1
	double d2
	void * p3
PREINIT:
	void *(*func)(int, short, double, void *);
CODE:
	func   = INT2PTR(void *(*)(int, short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, d2, p3);
OUTPUT:
	RETVAL

void
nci_visdp( c_func, i0, s1, d2, p3 )
	SV* c_func
	int i0
	short s1
	double d2
	void * p3
PREINIT:
	void(*func)(int, short, double, void *);
CODE:
	func   = INT2PTR(void(*)(int, short, double, void *), SvIV(c_func) );
	(*func)(i0, s1, d2, p3);

double
nci_disdp( c_func, i0, s1, d2, p3 )
	SV* c_func
	int i0
	short s1
	double d2
	void * p3
PREINIT:
	double(*func)(int, short, double, void *);
CODE:
	func   = INT2PTR(double(*)(int, short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, d2, p3);
OUTPUT:
	RETVAL

short
nci_sisdp( c_func, i0, s1, d2, p3 )
	SV* c_func
	int i0
	short s1
	double d2
	void * p3
PREINIT:
	short(*func)(int, short, double, void *);
CODE:
	func   = INT2PTR(short(*)(int, short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, d2, p3);
OUTPUT:
	RETVAL

float
nci_fisdp( c_func, i0, s1, d2, p3 )
	SV* c_func
	int i0
	short s1
	double d2
	void * p3
PREINIT:
	float(*func)(int, short, double, void *);
CODE:
	func   = INT2PTR(float(*)(int, short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, d2, p3);
OUTPUT:
	RETVAL

char *
nci_tisdp( c_func, i0, s1, d2, p3 )
	SV* c_func
	int i0
	short s1
	double d2
	void * p3
PREINIT:
	char *(*func)(int, short, double, void *);
CODE:
	func   = INT2PTR(char *(*)(int, short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, d2, p3);
OUTPUT:
	RETVAL

int
nci_iisdp( c_func, i0, s1, d2, p3 )
	SV* c_func
	int i0
	short s1
	double d2
	void * p3
PREINIT:
	int(*func)(int, short, double, void *);
CODE:
	func   = INT2PTR(int(*)(int, short, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, d2, p3);
OUTPUT:
	RETVAL

void *
nci_ppfdp( c_func, p0, f1, d2, p3 )
	SV* c_func
	void * p0
	float f1
	double d2
	void * p3
PREINIT:
	void *(*func)(void *, float, double, void *);
CODE:
	func   = INT2PTR(void *(*)(void *, float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, d2, p3);
OUTPUT:
	RETVAL

void
nci_vpfdp( c_func, p0, f1, d2, p3 )
	SV* c_func
	void * p0
	float f1
	double d2
	void * p3
PREINIT:
	void(*func)(void *, float, double, void *);
CODE:
	func   = INT2PTR(void(*)(void *, float, double, void *), SvIV(c_func) );
	(*func)(p0, f1, d2, p3);

double
nci_dpfdp( c_func, p0, f1, d2, p3 )
	SV* c_func
	void * p0
	float f1
	double d2
	void * p3
PREINIT:
	double(*func)(void *, float, double, void *);
CODE:
	func   = INT2PTR(double(*)(void *, float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, d2, p3);
OUTPUT:
	RETVAL

short
nci_spfdp( c_func, p0, f1, d2, p3 )
	SV* c_func
	void * p0
	float f1
	double d2
	void * p3
PREINIT:
	short(*func)(void *, float, double, void *);
CODE:
	func   = INT2PTR(short(*)(void *, float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, d2, p3);
OUTPUT:
	RETVAL

float
nci_fpfdp( c_func, p0, f1, d2, p3 )
	SV* c_func
	void * p0
	float f1
	double d2
	void * p3
PREINIT:
	float(*func)(void *, float, double, void *);
CODE:
	func   = INT2PTR(float(*)(void *, float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, d2, p3);
OUTPUT:
	RETVAL

char *
nci_tpfdp( c_func, p0, f1, d2, p3 )
	SV* c_func
	void * p0
	float f1
	double d2
	void * p3
PREINIT:
	char *(*func)(void *, float, double, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, d2, p3);
OUTPUT:
	RETVAL

int
nci_ipfdp( c_func, p0, f1, d2, p3 )
	SV* c_func
	void * p0
	float f1
	double d2
	void * p3
PREINIT:
	int(*func)(void *, float, double, void *);
CODE:
	func   = INT2PTR(int(*)(void *, float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, d2, p3);
OUTPUT:
	RETVAL

void *
nci_pvfdp( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvfdp( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvfdp( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svfdp( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvfdp( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvfdp( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivfdp( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdfdp( c_func, d0, f1, d2, p3 )
	SV* c_func
	double d0
	float f1
	double d2
	void * p3
PREINIT:
	void *(*func)(double, float, double, void *);
CODE:
	func   = INT2PTR(void *(*)(double, float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, d2, p3);
OUTPUT:
	RETVAL

void
nci_vdfdp( c_func, d0, f1, d2, p3 )
	SV* c_func
	double d0
	float f1
	double d2
	void * p3
PREINIT:
	void(*func)(double, float, double, void *);
CODE:
	func   = INT2PTR(void(*)(double, float, double, void *), SvIV(c_func) );
	(*func)(d0, f1, d2, p3);

double
nci_ddfdp( c_func, d0, f1, d2, p3 )
	SV* c_func
	double d0
	float f1
	double d2
	void * p3
PREINIT:
	double(*func)(double, float, double, void *);
CODE:
	func   = INT2PTR(double(*)(double, float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, d2, p3);
OUTPUT:
	RETVAL

short
nci_sdfdp( c_func, d0, f1, d2, p3 )
	SV* c_func
	double d0
	float f1
	double d2
	void * p3
PREINIT:
	short(*func)(double, float, double, void *);
CODE:
	func   = INT2PTR(short(*)(double, float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, d2, p3);
OUTPUT:
	RETVAL

float
nci_fdfdp( c_func, d0, f1, d2, p3 )
	SV* c_func
	double d0
	float f1
	double d2
	void * p3
PREINIT:
	float(*func)(double, float, double, void *);
CODE:
	func   = INT2PTR(float(*)(double, float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, d2, p3);
OUTPUT:
	RETVAL

char *
nci_tdfdp( c_func, d0, f1, d2, p3 )
	SV* c_func
	double d0
	float f1
	double d2
	void * p3
PREINIT:
	char *(*func)(double, float, double, void *);
CODE:
	func   = INT2PTR(char *(*)(double, float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, d2, p3);
OUTPUT:
	RETVAL

int
nci_idfdp( c_func, d0, f1, d2, p3 )
	SV* c_func
	double d0
	float f1
	double d2
	void * p3
PREINIT:
	int(*func)(double, float, double, void *);
CODE:
	func   = INT2PTR(int(*)(double, float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, d2, p3);
OUTPUT:
	RETVAL

void *
nci_psfdp( c_func, s0, f1, d2, p3 )
	SV* c_func
	short s0
	float f1
	double d2
	void * p3
PREINIT:
	void *(*func)(short, float, double, void *);
CODE:
	func   = INT2PTR(void *(*)(short, float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, d2, p3);
OUTPUT:
	RETVAL

void
nci_vsfdp( c_func, s0, f1, d2, p3 )
	SV* c_func
	short s0
	float f1
	double d2
	void * p3
PREINIT:
	void(*func)(short, float, double, void *);
CODE:
	func   = INT2PTR(void(*)(short, float, double, void *), SvIV(c_func) );
	(*func)(s0, f1, d2, p3);

double
nci_dsfdp( c_func, s0, f1, d2, p3 )
	SV* c_func
	short s0
	float f1
	double d2
	void * p3
PREINIT:
	double(*func)(short, float, double, void *);
CODE:
	func   = INT2PTR(double(*)(short, float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, d2, p3);
OUTPUT:
	RETVAL

short
nci_ssfdp( c_func, s0, f1, d2, p3 )
	SV* c_func
	short s0
	float f1
	double d2
	void * p3
PREINIT:
	short(*func)(short, float, double, void *);
CODE:
	func   = INT2PTR(short(*)(short, float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, d2, p3);
OUTPUT:
	RETVAL

float
nci_fsfdp( c_func, s0, f1, d2, p3 )
	SV* c_func
	short s0
	float f1
	double d2
	void * p3
PREINIT:
	float(*func)(short, float, double, void *);
CODE:
	func   = INT2PTR(float(*)(short, float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, d2, p3);
OUTPUT:
	RETVAL

char *
nci_tsfdp( c_func, s0, f1, d2, p3 )
	SV* c_func
	short s0
	float f1
	double d2
	void * p3
PREINIT:
	char *(*func)(short, float, double, void *);
CODE:
	func   = INT2PTR(char *(*)(short, float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, d2, p3);
OUTPUT:
	RETVAL

int
nci_isfdp( c_func, s0, f1, d2, p3 )
	SV* c_func
	short s0
	float f1
	double d2
	void * p3
PREINIT:
	int(*func)(short, float, double, void *);
CODE:
	func   = INT2PTR(int(*)(short, float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, d2, p3);
OUTPUT:
	RETVAL

void *
nci_pffdp( c_func, f0, f1, d2, p3 )
	SV* c_func
	float f0
	float f1
	double d2
	void * p3
PREINIT:
	void *(*func)(float, float, double, void *);
CODE:
	func   = INT2PTR(void *(*)(float, float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, d2, p3);
OUTPUT:
	RETVAL

void
nci_vffdp( c_func, f0, f1, d2, p3 )
	SV* c_func
	float f0
	float f1
	double d2
	void * p3
PREINIT:
	void(*func)(float, float, double, void *);
CODE:
	func   = INT2PTR(void(*)(float, float, double, void *), SvIV(c_func) );
	(*func)(f0, f1, d2, p3);

double
nci_dffdp( c_func, f0, f1, d2, p3 )
	SV* c_func
	float f0
	float f1
	double d2
	void * p3
PREINIT:
	double(*func)(float, float, double, void *);
CODE:
	func   = INT2PTR(double(*)(float, float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, d2, p3);
OUTPUT:
	RETVAL

short
nci_sffdp( c_func, f0, f1, d2, p3 )
	SV* c_func
	float f0
	float f1
	double d2
	void * p3
PREINIT:
	short(*func)(float, float, double, void *);
CODE:
	func   = INT2PTR(short(*)(float, float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, d2, p3);
OUTPUT:
	RETVAL

float
nci_fffdp( c_func, f0, f1, d2, p3 )
	SV* c_func
	float f0
	float f1
	double d2
	void * p3
PREINIT:
	float(*func)(float, float, double, void *);
CODE:
	func   = INT2PTR(float(*)(float, float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, d2, p3);
OUTPUT:
	RETVAL

char *
nci_tffdp( c_func, f0, f1, d2, p3 )
	SV* c_func
	float f0
	float f1
	double d2
	void * p3
PREINIT:
	char *(*func)(float, float, double, void *);
CODE:
	func   = INT2PTR(char *(*)(float, float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, d2, p3);
OUTPUT:
	RETVAL

int
nci_iffdp( c_func, f0, f1, d2, p3 )
	SV* c_func
	float f0
	float f1
	double d2
	void * p3
PREINIT:
	int(*func)(float, float, double, void *);
CODE:
	func   = INT2PTR(int(*)(float, float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, d2, p3);
OUTPUT:
	RETVAL

void *
nci_ptfdp( c_func, t0, f1, d2, p3 )
	SV* c_func
	char * t0
	float f1
	double d2
	void * p3
PREINIT:
	void *(*func)(char *, float, double, void *);
CODE:
	func   = INT2PTR(void *(*)(char *, float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, d2, p3);
OUTPUT:
	RETVAL

void
nci_vtfdp( c_func, t0, f1, d2, p3 )
	SV* c_func
	char * t0
	float f1
	double d2
	void * p3
PREINIT:
	void(*func)(char *, float, double, void *);
CODE:
	func   = INT2PTR(void(*)(char *, float, double, void *), SvIV(c_func) );
	(*func)(t0, f1, d2, p3);

double
nci_dtfdp( c_func, t0, f1, d2, p3 )
	SV* c_func
	char * t0
	float f1
	double d2
	void * p3
PREINIT:
	double(*func)(char *, float, double, void *);
CODE:
	func   = INT2PTR(double(*)(char *, float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, d2, p3);
OUTPUT:
	RETVAL

short
nci_stfdp( c_func, t0, f1, d2, p3 )
	SV* c_func
	char * t0
	float f1
	double d2
	void * p3
PREINIT:
	short(*func)(char *, float, double, void *);
CODE:
	func   = INT2PTR(short(*)(char *, float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, d2, p3);
OUTPUT:
	RETVAL

float
nci_ftfdp( c_func, t0, f1, d2, p3 )
	SV* c_func
	char * t0
	float f1
	double d2
	void * p3
PREINIT:
	float(*func)(char *, float, double, void *);
CODE:
	func   = INT2PTR(float(*)(char *, float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, d2, p3);
OUTPUT:
	RETVAL

char *
nci_ttfdp( c_func, t0, f1, d2, p3 )
	SV* c_func
	char * t0
	float f1
	double d2
	void * p3
PREINIT:
	char *(*func)(char *, float, double, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, d2, p3);
OUTPUT:
	RETVAL

int
nci_itfdp( c_func, t0, f1, d2, p3 )
	SV* c_func
	char * t0
	float f1
	double d2
	void * p3
PREINIT:
	int(*func)(char *, float, double, void *);
CODE:
	func   = INT2PTR(int(*)(char *, float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, d2, p3);
OUTPUT:
	RETVAL

void *
nci_pifdp( c_func, i0, f1, d2, p3 )
	SV* c_func
	int i0
	float f1
	double d2
	void * p3
PREINIT:
	void *(*func)(int, float, double, void *);
CODE:
	func   = INT2PTR(void *(*)(int, float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, d2, p3);
OUTPUT:
	RETVAL

void
nci_vifdp( c_func, i0, f1, d2, p3 )
	SV* c_func
	int i0
	float f1
	double d2
	void * p3
PREINIT:
	void(*func)(int, float, double, void *);
CODE:
	func   = INT2PTR(void(*)(int, float, double, void *), SvIV(c_func) );
	(*func)(i0, f1, d2, p3);

double
nci_difdp( c_func, i0, f1, d2, p3 )
	SV* c_func
	int i0
	float f1
	double d2
	void * p3
PREINIT:
	double(*func)(int, float, double, void *);
CODE:
	func   = INT2PTR(double(*)(int, float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, d2, p3);
OUTPUT:
	RETVAL

short
nci_sifdp( c_func, i0, f1, d2, p3 )
	SV* c_func
	int i0
	float f1
	double d2
	void * p3
PREINIT:
	short(*func)(int, float, double, void *);
CODE:
	func   = INT2PTR(short(*)(int, float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, d2, p3);
OUTPUT:
	RETVAL

float
nci_fifdp( c_func, i0, f1, d2, p3 )
	SV* c_func
	int i0
	float f1
	double d2
	void * p3
PREINIT:
	float(*func)(int, float, double, void *);
CODE:
	func   = INT2PTR(float(*)(int, float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, d2, p3);
OUTPUT:
	RETVAL

char *
nci_tifdp( c_func, i0, f1, d2, p3 )
	SV* c_func
	int i0
	float f1
	double d2
	void * p3
PREINIT:
	char *(*func)(int, float, double, void *);
CODE:
	func   = INT2PTR(char *(*)(int, float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, d2, p3);
OUTPUT:
	RETVAL

int
nci_iifdp( c_func, i0, f1, d2, p3 )
	SV* c_func
	int i0
	float f1
	double d2
	void * p3
PREINIT:
	int(*func)(int, float, double, void *);
CODE:
	func   = INT2PTR(int(*)(int, float, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, d2, p3);
OUTPUT:
	RETVAL

void *
nci_pptdp( c_func, p0, t1, d2, p3 )
	SV* c_func
	void * p0
	char * t1
	double d2
	void * p3
PREINIT:
	void *(*func)(void *, char *, double, void *);
CODE:
	func   = INT2PTR(void *(*)(void *, char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, d2, p3);
OUTPUT:
	RETVAL

void
nci_vptdp( c_func, p0, t1, d2, p3 )
	SV* c_func
	void * p0
	char * t1
	double d2
	void * p3
PREINIT:
	void(*func)(void *, char *, double, void *);
CODE:
	func   = INT2PTR(void(*)(void *, char *, double, void *), SvIV(c_func) );
	(*func)(p0, t1, d2, p3);

double
nci_dptdp( c_func, p0, t1, d2, p3 )
	SV* c_func
	void * p0
	char * t1
	double d2
	void * p3
PREINIT:
	double(*func)(void *, char *, double, void *);
CODE:
	func   = INT2PTR(double(*)(void *, char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, d2, p3);
OUTPUT:
	RETVAL

short
nci_sptdp( c_func, p0, t1, d2, p3 )
	SV* c_func
	void * p0
	char * t1
	double d2
	void * p3
PREINIT:
	short(*func)(void *, char *, double, void *);
CODE:
	func   = INT2PTR(short(*)(void *, char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, d2, p3);
OUTPUT:
	RETVAL

float
nci_fptdp( c_func, p0, t1, d2, p3 )
	SV* c_func
	void * p0
	char * t1
	double d2
	void * p3
PREINIT:
	float(*func)(void *, char *, double, void *);
CODE:
	func   = INT2PTR(float(*)(void *, char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, d2, p3);
OUTPUT:
	RETVAL

char *
nci_tptdp( c_func, p0, t1, d2, p3 )
	SV* c_func
	void * p0
	char * t1
	double d2
	void * p3
PREINIT:
	char *(*func)(void *, char *, double, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, d2, p3);
OUTPUT:
	RETVAL

int
nci_iptdp( c_func, p0, t1, d2, p3 )
	SV* c_func
	void * p0
	char * t1
	double d2
	void * p3
PREINIT:
	int(*func)(void *, char *, double, void *);
CODE:
	func   = INT2PTR(int(*)(void *, char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, d2, p3);
OUTPUT:
	RETVAL

void *
nci_pvtdp( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvtdp( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvtdp( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svtdp( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvtdp( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvtdp( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivtdp( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdtdp( c_func, d0, t1, d2, p3 )
	SV* c_func
	double d0
	char * t1
	double d2
	void * p3
PREINIT:
	void *(*func)(double, char *, double, void *);
CODE:
	func   = INT2PTR(void *(*)(double, char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, d2, p3);
OUTPUT:
	RETVAL

void
nci_vdtdp( c_func, d0, t1, d2, p3 )
	SV* c_func
	double d0
	char * t1
	double d2
	void * p3
PREINIT:
	void(*func)(double, char *, double, void *);
CODE:
	func   = INT2PTR(void(*)(double, char *, double, void *), SvIV(c_func) );
	(*func)(d0, t1, d2, p3);

double
nci_ddtdp( c_func, d0, t1, d2, p3 )
	SV* c_func
	double d0
	char * t1
	double d2
	void * p3
PREINIT:
	double(*func)(double, char *, double, void *);
CODE:
	func   = INT2PTR(double(*)(double, char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, d2, p3);
OUTPUT:
	RETVAL

short
nci_sdtdp( c_func, d0, t1, d2, p3 )
	SV* c_func
	double d0
	char * t1
	double d2
	void * p3
PREINIT:
	short(*func)(double, char *, double, void *);
CODE:
	func   = INT2PTR(short(*)(double, char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, d2, p3);
OUTPUT:
	RETVAL

float
nci_fdtdp( c_func, d0, t1, d2, p3 )
	SV* c_func
	double d0
	char * t1
	double d2
	void * p3
PREINIT:
	float(*func)(double, char *, double, void *);
CODE:
	func   = INT2PTR(float(*)(double, char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, d2, p3);
OUTPUT:
	RETVAL

char *
nci_tdtdp( c_func, d0, t1, d2, p3 )
	SV* c_func
	double d0
	char * t1
	double d2
	void * p3
PREINIT:
	char *(*func)(double, char *, double, void *);
CODE:
	func   = INT2PTR(char *(*)(double, char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, d2, p3);
OUTPUT:
	RETVAL

int
nci_idtdp( c_func, d0, t1, d2, p3 )
	SV* c_func
	double d0
	char * t1
	double d2
	void * p3
PREINIT:
	int(*func)(double, char *, double, void *);
CODE:
	func   = INT2PTR(int(*)(double, char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, d2, p3);
OUTPUT:
	RETVAL

void *
nci_pstdp( c_func, s0, t1, d2, p3 )
	SV* c_func
	short s0
	char * t1
	double d2
	void * p3
PREINIT:
	void *(*func)(short, char *, double, void *);
CODE:
	func   = INT2PTR(void *(*)(short, char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, d2, p3);
OUTPUT:
	RETVAL

void
nci_vstdp( c_func, s0, t1, d2, p3 )
	SV* c_func
	short s0
	char * t1
	double d2
	void * p3
PREINIT:
	void(*func)(short, char *, double, void *);
CODE:
	func   = INT2PTR(void(*)(short, char *, double, void *), SvIV(c_func) );
	(*func)(s0, t1, d2, p3);

double
nci_dstdp( c_func, s0, t1, d2, p3 )
	SV* c_func
	short s0
	char * t1
	double d2
	void * p3
PREINIT:
	double(*func)(short, char *, double, void *);
CODE:
	func   = INT2PTR(double(*)(short, char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, d2, p3);
OUTPUT:
	RETVAL

short
nci_sstdp( c_func, s0, t1, d2, p3 )
	SV* c_func
	short s0
	char * t1
	double d2
	void * p3
PREINIT:
	short(*func)(short, char *, double, void *);
CODE:
	func   = INT2PTR(short(*)(short, char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, d2, p3);
OUTPUT:
	RETVAL

float
nci_fstdp( c_func, s0, t1, d2, p3 )
	SV* c_func
	short s0
	char * t1
	double d2
	void * p3
PREINIT:
	float(*func)(short, char *, double, void *);
CODE:
	func   = INT2PTR(float(*)(short, char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, d2, p3);
OUTPUT:
	RETVAL

char *
nci_tstdp( c_func, s0, t1, d2, p3 )
	SV* c_func
	short s0
	char * t1
	double d2
	void * p3
PREINIT:
	char *(*func)(short, char *, double, void *);
CODE:
	func   = INT2PTR(char *(*)(short, char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, d2, p3);
OUTPUT:
	RETVAL

int
nci_istdp( c_func, s0, t1, d2, p3 )
	SV* c_func
	short s0
	char * t1
	double d2
	void * p3
PREINIT:
	int(*func)(short, char *, double, void *);
CODE:
	func   = INT2PTR(int(*)(short, char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, d2, p3);
OUTPUT:
	RETVAL

void *
nci_pftdp( c_func, f0, t1, d2, p3 )
	SV* c_func
	float f0
	char * t1
	double d2
	void * p3
PREINIT:
	void *(*func)(float, char *, double, void *);
CODE:
	func   = INT2PTR(void *(*)(float, char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, d2, p3);
OUTPUT:
	RETVAL

void
nci_vftdp( c_func, f0, t1, d2, p3 )
	SV* c_func
	float f0
	char * t1
	double d2
	void * p3
PREINIT:
	void(*func)(float, char *, double, void *);
CODE:
	func   = INT2PTR(void(*)(float, char *, double, void *), SvIV(c_func) );
	(*func)(f0, t1, d2, p3);

double
nci_dftdp( c_func, f0, t1, d2, p3 )
	SV* c_func
	float f0
	char * t1
	double d2
	void * p3
PREINIT:
	double(*func)(float, char *, double, void *);
CODE:
	func   = INT2PTR(double(*)(float, char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, d2, p3);
OUTPUT:
	RETVAL

short
nci_sftdp( c_func, f0, t1, d2, p3 )
	SV* c_func
	float f0
	char * t1
	double d2
	void * p3
PREINIT:
	short(*func)(float, char *, double, void *);
CODE:
	func   = INT2PTR(short(*)(float, char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, d2, p3);
OUTPUT:
	RETVAL

float
nci_fftdp( c_func, f0, t1, d2, p3 )
	SV* c_func
	float f0
	char * t1
	double d2
	void * p3
PREINIT:
	float(*func)(float, char *, double, void *);
CODE:
	func   = INT2PTR(float(*)(float, char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, d2, p3);
OUTPUT:
	RETVAL

char *
nci_tftdp( c_func, f0, t1, d2, p3 )
	SV* c_func
	float f0
	char * t1
	double d2
	void * p3
PREINIT:
	char *(*func)(float, char *, double, void *);
CODE:
	func   = INT2PTR(char *(*)(float, char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, d2, p3);
OUTPUT:
	RETVAL

int
nci_iftdp( c_func, f0, t1, d2, p3 )
	SV* c_func
	float f0
	char * t1
	double d2
	void * p3
PREINIT:
	int(*func)(float, char *, double, void *);
CODE:
	func   = INT2PTR(int(*)(float, char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, d2, p3);
OUTPUT:
	RETVAL

void *
nci_pttdp( c_func, t0, t1, d2, p3 )
	SV* c_func
	char * t0
	char * t1
	double d2
	void * p3
PREINIT:
	void *(*func)(char *, char *, double, void *);
CODE:
	func   = INT2PTR(void *(*)(char *, char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, d2, p3);
OUTPUT:
	RETVAL

void
nci_vttdp( c_func, t0, t1, d2, p3 )
	SV* c_func
	char * t0
	char * t1
	double d2
	void * p3
PREINIT:
	void(*func)(char *, char *, double, void *);
CODE:
	func   = INT2PTR(void(*)(char *, char *, double, void *), SvIV(c_func) );
	(*func)(t0, t1, d2, p3);

double
nci_dttdp( c_func, t0, t1, d2, p3 )
	SV* c_func
	char * t0
	char * t1
	double d2
	void * p3
PREINIT:
	double(*func)(char *, char *, double, void *);
CODE:
	func   = INT2PTR(double(*)(char *, char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, d2, p3);
OUTPUT:
	RETVAL

short
nci_sttdp( c_func, t0, t1, d2, p3 )
	SV* c_func
	char * t0
	char * t1
	double d2
	void * p3
PREINIT:
	short(*func)(char *, char *, double, void *);
CODE:
	func   = INT2PTR(short(*)(char *, char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, d2, p3);
OUTPUT:
	RETVAL

float
nci_fttdp( c_func, t0, t1, d2, p3 )
	SV* c_func
	char * t0
	char * t1
	double d2
	void * p3
PREINIT:
	float(*func)(char *, char *, double, void *);
CODE:
	func   = INT2PTR(float(*)(char *, char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, d2, p3);
OUTPUT:
	RETVAL

char *
nci_tttdp( c_func, t0, t1, d2, p3 )
	SV* c_func
	char * t0
	char * t1
	double d2
	void * p3
PREINIT:
	char *(*func)(char *, char *, double, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, d2, p3);
OUTPUT:
	RETVAL

int
nci_ittdp( c_func, t0, t1, d2, p3 )
	SV* c_func
	char * t0
	char * t1
	double d2
	void * p3
PREINIT:
	int(*func)(char *, char *, double, void *);
CODE:
	func   = INT2PTR(int(*)(char *, char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, d2, p3);
OUTPUT:
	RETVAL

void *
nci_pitdp( c_func, i0, t1, d2, p3 )
	SV* c_func
	int i0
	char * t1
	double d2
	void * p3
PREINIT:
	void *(*func)(int, char *, double, void *);
CODE:
	func   = INT2PTR(void *(*)(int, char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, d2, p3);
OUTPUT:
	RETVAL

void
nci_vitdp( c_func, i0, t1, d2, p3 )
	SV* c_func
	int i0
	char * t1
	double d2
	void * p3
PREINIT:
	void(*func)(int, char *, double, void *);
CODE:
	func   = INT2PTR(void(*)(int, char *, double, void *), SvIV(c_func) );
	(*func)(i0, t1, d2, p3);

double
nci_ditdp( c_func, i0, t1, d2, p3 )
	SV* c_func
	int i0
	char * t1
	double d2
	void * p3
PREINIT:
	double(*func)(int, char *, double, void *);
CODE:
	func   = INT2PTR(double(*)(int, char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, d2, p3);
OUTPUT:
	RETVAL

short
nci_sitdp( c_func, i0, t1, d2, p3 )
	SV* c_func
	int i0
	char * t1
	double d2
	void * p3
PREINIT:
	short(*func)(int, char *, double, void *);
CODE:
	func   = INT2PTR(short(*)(int, char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, d2, p3);
OUTPUT:
	RETVAL

float
nci_fitdp( c_func, i0, t1, d2, p3 )
	SV* c_func
	int i0
	char * t1
	double d2
	void * p3
PREINIT:
	float(*func)(int, char *, double, void *);
CODE:
	func   = INT2PTR(float(*)(int, char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, d2, p3);
OUTPUT:
	RETVAL

char *
nci_titdp( c_func, i0, t1, d2, p3 )
	SV* c_func
	int i0
	char * t1
	double d2
	void * p3
PREINIT:
	char *(*func)(int, char *, double, void *);
CODE:
	func   = INT2PTR(char *(*)(int, char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, d2, p3);
OUTPUT:
	RETVAL

int
nci_iitdp( c_func, i0, t1, d2, p3 )
	SV* c_func
	int i0
	char * t1
	double d2
	void * p3
PREINIT:
	int(*func)(int, char *, double, void *);
CODE:
	func   = INT2PTR(int(*)(int, char *, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, d2, p3);
OUTPUT:
	RETVAL

void *
nci_ppidp( c_func, p0, i1, d2, p3 )
	SV* c_func
	void * p0
	int i1
	double d2
	void * p3
PREINIT:
	void *(*func)(void *, int, double, void *);
CODE:
	func   = INT2PTR(void *(*)(void *, int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, d2, p3);
OUTPUT:
	RETVAL

void
nci_vpidp( c_func, p0, i1, d2, p3 )
	SV* c_func
	void * p0
	int i1
	double d2
	void * p3
PREINIT:
	void(*func)(void *, int, double, void *);
CODE:
	func   = INT2PTR(void(*)(void *, int, double, void *), SvIV(c_func) );
	(*func)(p0, i1, d2, p3);

double
nci_dpidp( c_func, p0, i1, d2, p3 )
	SV* c_func
	void * p0
	int i1
	double d2
	void * p3
PREINIT:
	double(*func)(void *, int, double, void *);
CODE:
	func   = INT2PTR(double(*)(void *, int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, d2, p3);
OUTPUT:
	RETVAL

short
nci_spidp( c_func, p0, i1, d2, p3 )
	SV* c_func
	void * p0
	int i1
	double d2
	void * p3
PREINIT:
	short(*func)(void *, int, double, void *);
CODE:
	func   = INT2PTR(short(*)(void *, int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, d2, p3);
OUTPUT:
	RETVAL

float
nci_fpidp( c_func, p0, i1, d2, p3 )
	SV* c_func
	void * p0
	int i1
	double d2
	void * p3
PREINIT:
	float(*func)(void *, int, double, void *);
CODE:
	func   = INT2PTR(float(*)(void *, int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, d2, p3);
OUTPUT:
	RETVAL

char *
nci_tpidp( c_func, p0, i1, d2, p3 )
	SV* c_func
	void * p0
	int i1
	double d2
	void * p3
PREINIT:
	char *(*func)(void *, int, double, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, d2, p3);
OUTPUT:
	RETVAL

int
nci_ipidp( c_func, p0, i1, d2, p3 )
	SV* c_func
	void * p0
	int i1
	double d2
	void * p3
PREINIT:
	int(*func)(void *, int, double, void *);
CODE:
	func   = INT2PTR(int(*)(void *, int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, d2, p3);
OUTPUT:
	RETVAL

void *
nci_pvidp( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvidp( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvidp( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svidp( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvidp( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvidp( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ividp( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdidp( c_func, d0, i1, d2, p3 )
	SV* c_func
	double d0
	int i1
	double d2
	void * p3
PREINIT:
	void *(*func)(double, int, double, void *);
CODE:
	func   = INT2PTR(void *(*)(double, int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, d2, p3);
OUTPUT:
	RETVAL

void
nci_vdidp( c_func, d0, i1, d2, p3 )
	SV* c_func
	double d0
	int i1
	double d2
	void * p3
PREINIT:
	void(*func)(double, int, double, void *);
CODE:
	func   = INT2PTR(void(*)(double, int, double, void *), SvIV(c_func) );
	(*func)(d0, i1, d2, p3);

double
nci_ddidp( c_func, d0, i1, d2, p3 )
	SV* c_func
	double d0
	int i1
	double d2
	void * p3
PREINIT:
	double(*func)(double, int, double, void *);
CODE:
	func   = INT2PTR(double(*)(double, int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, d2, p3);
OUTPUT:
	RETVAL

short
nci_sdidp( c_func, d0, i1, d2, p3 )
	SV* c_func
	double d0
	int i1
	double d2
	void * p3
PREINIT:
	short(*func)(double, int, double, void *);
CODE:
	func   = INT2PTR(short(*)(double, int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, d2, p3);
OUTPUT:
	RETVAL

float
nci_fdidp( c_func, d0, i1, d2, p3 )
	SV* c_func
	double d0
	int i1
	double d2
	void * p3
PREINIT:
	float(*func)(double, int, double, void *);
CODE:
	func   = INT2PTR(float(*)(double, int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, d2, p3);
OUTPUT:
	RETVAL

char *
nci_tdidp( c_func, d0, i1, d2, p3 )
	SV* c_func
	double d0
	int i1
	double d2
	void * p3
PREINIT:
	char *(*func)(double, int, double, void *);
CODE:
	func   = INT2PTR(char *(*)(double, int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, d2, p3);
OUTPUT:
	RETVAL

int
nci_ididp( c_func, d0, i1, d2, p3 )
	SV* c_func
	double d0
	int i1
	double d2
	void * p3
PREINIT:
	int(*func)(double, int, double, void *);
CODE:
	func   = INT2PTR(int(*)(double, int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, d2, p3);
OUTPUT:
	RETVAL

void *
nci_psidp( c_func, s0, i1, d2, p3 )
	SV* c_func
	short s0
	int i1
	double d2
	void * p3
PREINIT:
	void *(*func)(short, int, double, void *);
CODE:
	func   = INT2PTR(void *(*)(short, int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, d2, p3);
OUTPUT:
	RETVAL

void
nci_vsidp( c_func, s0, i1, d2, p3 )
	SV* c_func
	short s0
	int i1
	double d2
	void * p3
PREINIT:
	void(*func)(short, int, double, void *);
CODE:
	func   = INT2PTR(void(*)(short, int, double, void *), SvIV(c_func) );
	(*func)(s0, i1, d2, p3);

double
nci_dsidp( c_func, s0, i1, d2, p3 )
	SV* c_func
	short s0
	int i1
	double d2
	void * p3
PREINIT:
	double(*func)(short, int, double, void *);
CODE:
	func   = INT2PTR(double(*)(short, int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, d2, p3);
OUTPUT:
	RETVAL

short
nci_ssidp( c_func, s0, i1, d2, p3 )
	SV* c_func
	short s0
	int i1
	double d2
	void * p3
PREINIT:
	short(*func)(short, int, double, void *);
CODE:
	func   = INT2PTR(short(*)(short, int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, d2, p3);
OUTPUT:
	RETVAL

float
nci_fsidp( c_func, s0, i1, d2, p3 )
	SV* c_func
	short s0
	int i1
	double d2
	void * p3
PREINIT:
	float(*func)(short, int, double, void *);
CODE:
	func   = INT2PTR(float(*)(short, int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, d2, p3);
OUTPUT:
	RETVAL

char *
nci_tsidp( c_func, s0, i1, d2, p3 )
	SV* c_func
	short s0
	int i1
	double d2
	void * p3
PREINIT:
	char *(*func)(short, int, double, void *);
CODE:
	func   = INT2PTR(char *(*)(short, int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, d2, p3);
OUTPUT:
	RETVAL

int
nci_isidp( c_func, s0, i1, d2, p3 )
	SV* c_func
	short s0
	int i1
	double d2
	void * p3
PREINIT:
	int(*func)(short, int, double, void *);
CODE:
	func   = INT2PTR(int(*)(short, int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, d2, p3);
OUTPUT:
	RETVAL

void *
nci_pfidp( c_func, f0, i1, d2, p3 )
	SV* c_func
	float f0
	int i1
	double d2
	void * p3
PREINIT:
	void *(*func)(float, int, double, void *);
CODE:
	func   = INT2PTR(void *(*)(float, int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, d2, p3);
OUTPUT:
	RETVAL

void
nci_vfidp( c_func, f0, i1, d2, p3 )
	SV* c_func
	float f0
	int i1
	double d2
	void * p3
PREINIT:
	void(*func)(float, int, double, void *);
CODE:
	func   = INT2PTR(void(*)(float, int, double, void *), SvIV(c_func) );
	(*func)(f0, i1, d2, p3);

double
nci_dfidp( c_func, f0, i1, d2, p3 )
	SV* c_func
	float f0
	int i1
	double d2
	void * p3
PREINIT:
	double(*func)(float, int, double, void *);
CODE:
	func   = INT2PTR(double(*)(float, int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, d2, p3);
OUTPUT:
	RETVAL

short
nci_sfidp( c_func, f0, i1, d2, p3 )
	SV* c_func
	float f0
	int i1
	double d2
	void * p3
PREINIT:
	short(*func)(float, int, double, void *);
CODE:
	func   = INT2PTR(short(*)(float, int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, d2, p3);
OUTPUT:
	RETVAL

float
nci_ffidp( c_func, f0, i1, d2, p3 )
	SV* c_func
	float f0
	int i1
	double d2
	void * p3
PREINIT:
	float(*func)(float, int, double, void *);
CODE:
	func   = INT2PTR(float(*)(float, int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, d2, p3);
OUTPUT:
	RETVAL

char *
nci_tfidp( c_func, f0, i1, d2, p3 )
	SV* c_func
	float f0
	int i1
	double d2
	void * p3
PREINIT:
	char *(*func)(float, int, double, void *);
CODE:
	func   = INT2PTR(char *(*)(float, int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, d2, p3);
OUTPUT:
	RETVAL

int
nci_ifidp( c_func, f0, i1, d2, p3 )
	SV* c_func
	float f0
	int i1
	double d2
	void * p3
PREINIT:
	int(*func)(float, int, double, void *);
CODE:
	func   = INT2PTR(int(*)(float, int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, d2, p3);
OUTPUT:
	RETVAL

void *
nci_ptidp( c_func, t0, i1, d2, p3 )
	SV* c_func
	char * t0
	int i1
	double d2
	void * p3
PREINIT:
	void *(*func)(char *, int, double, void *);
CODE:
	func   = INT2PTR(void *(*)(char *, int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, d2, p3);
OUTPUT:
	RETVAL

void
nci_vtidp( c_func, t0, i1, d2, p3 )
	SV* c_func
	char * t0
	int i1
	double d2
	void * p3
PREINIT:
	void(*func)(char *, int, double, void *);
CODE:
	func   = INT2PTR(void(*)(char *, int, double, void *), SvIV(c_func) );
	(*func)(t0, i1, d2, p3);

double
nci_dtidp( c_func, t0, i1, d2, p3 )
	SV* c_func
	char * t0
	int i1
	double d2
	void * p3
PREINIT:
	double(*func)(char *, int, double, void *);
CODE:
	func   = INT2PTR(double(*)(char *, int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, d2, p3);
OUTPUT:
	RETVAL

short
nci_stidp( c_func, t0, i1, d2, p3 )
	SV* c_func
	char * t0
	int i1
	double d2
	void * p3
PREINIT:
	short(*func)(char *, int, double, void *);
CODE:
	func   = INT2PTR(short(*)(char *, int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, d2, p3);
OUTPUT:
	RETVAL

float
nci_ftidp( c_func, t0, i1, d2, p3 )
	SV* c_func
	char * t0
	int i1
	double d2
	void * p3
PREINIT:
	float(*func)(char *, int, double, void *);
CODE:
	func   = INT2PTR(float(*)(char *, int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, d2, p3);
OUTPUT:
	RETVAL

char *
nci_ttidp( c_func, t0, i1, d2, p3 )
	SV* c_func
	char * t0
	int i1
	double d2
	void * p3
PREINIT:
	char *(*func)(char *, int, double, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, d2, p3);
OUTPUT:
	RETVAL

int
nci_itidp( c_func, t0, i1, d2, p3 )
	SV* c_func
	char * t0
	int i1
	double d2
	void * p3
PREINIT:
	int(*func)(char *, int, double, void *);
CODE:
	func   = INT2PTR(int(*)(char *, int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, d2, p3);
OUTPUT:
	RETVAL

void *
nci_piidp( c_func, i0, i1, d2, p3 )
	SV* c_func
	int i0
	int i1
	double d2
	void * p3
PREINIT:
	void *(*func)(int, int, double, void *);
CODE:
	func   = INT2PTR(void *(*)(int, int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, d2, p3);
OUTPUT:
	RETVAL

void
nci_viidp( c_func, i0, i1, d2, p3 )
	SV* c_func
	int i0
	int i1
	double d2
	void * p3
PREINIT:
	void(*func)(int, int, double, void *);
CODE:
	func   = INT2PTR(void(*)(int, int, double, void *), SvIV(c_func) );
	(*func)(i0, i1, d2, p3);

double
nci_diidp( c_func, i0, i1, d2, p3 )
	SV* c_func
	int i0
	int i1
	double d2
	void * p3
PREINIT:
	double(*func)(int, int, double, void *);
CODE:
	func   = INT2PTR(double(*)(int, int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, d2, p3);
OUTPUT:
	RETVAL

short
nci_siidp( c_func, i0, i1, d2, p3 )
	SV* c_func
	int i0
	int i1
	double d2
	void * p3
PREINIT:
	short(*func)(int, int, double, void *);
CODE:
	func   = INT2PTR(short(*)(int, int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, d2, p3);
OUTPUT:
	RETVAL

float
nci_fiidp( c_func, i0, i1, d2, p3 )
	SV* c_func
	int i0
	int i1
	double d2
	void * p3
PREINIT:
	float(*func)(int, int, double, void *);
CODE:
	func   = INT2PTR(float(*)(int, int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, d2, p3);
OUTPUT:
	RETVAL

char *
nci_tiidp( c_func, i0, i1, d2, p3 )
	SV* c_func
	int i0
	int i1
	double d2
	void * p3
PREINIT:
	char *(*func)(int, int, double, void *);
CODE:
	func   = INT2PTR(char *(*)(int, int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, d2, p3);
OUTPUT:
	RETVAL

int
nci_iiidp( c_func, i0, i1, d2, p3 )
	SV* c_func
	int i0
	int i1
	double d2
	void * p3
PREINIT:
	int(*func)(int, int, double, void *);
CODE:
	func   = INT2PTR(int(*)(int, int, double, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, d2, p3);
OUTPUT:
	RETVAL

void *
nci_pppsp( c_func, p0, p1, s2, p3 )
	SV* c_func
	void * p0
	void * p1
	short s2
	void * p3
PREINIT:
	void *(*func)(void *, void *, short, void *);
CODE:
	func   = INT2PTR(void *(*)(void *, void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, s2, p3);
OUTPUT:
	RETVAL

void
nci_vppsp( c_func, p0, p1, s2, p3 )
	SV* c_func
	void * p0
	void * p1
	short s2
	void * p3
PREINIT:
	void(*func)(void *, void *, short, void *);
CODE:
	func   = INT2PTR(void(*)(void *, void *, short, void *), SvIV(c_func) );
	(*func)(p0, p1, s2, p3);

double
nci_dppsp( c_func, p0, p1, s2, p3 )
	SV* c_func
	void * p0
	void * p1
	short s2
	void * p3
PREINIT:
	double(*func)(void *, void *, short, void *);
CODE:
	func   = INT2PTR(double(*)(void *, void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, s2, p3);
OUTPUT:
	RETVAL

short
nci_sppsp( c_func, p0, p1, s2, p3 )
	SV* c_func
	void * p0
	void * p1
	short s2
	void * p3
PREINIT:
	short(*func)(void *, void *, short, void *);
CODE:
	func   = INT2PTR(short(*)(void *, void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, s2, p3);
OUTPUT:
	RETVAL

float
nci_fppsp( c_func, p0, p1, s2, p3 )
	SV* c_func
	void * p0
	void * p1
	short s2
	void * p3
PREINIT:
	float(*func)(void *, void *, short, void *);
CODE:
	func   = INT2PTR(float(*)(void *, void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, s2, p3);
OUTPUT:
	RETVAL

char *
nci_tppsp( c_func, p0, p1, s2, p3 )
	SV* c_func
	void * p0
	void * p1
	short s2
	void * p3
PREINIT:
	char *(*func)(void *, void *, short, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, s2, p3);
OUTPUT:
	RETVAL

int
nci_ippsp( c_func, p0, p1, s2, p3 )
	SV* c_func
	void * p0
	void * p1
	short s2
	void * p3
PREINIT:
	int(*func)(void *, void *, short, void *);
CODE:
	func   = INT2PTR(int(*)(void *, void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, s2, p3);
OUTPUT:
	RETVAL

void *
nci_pvpsp( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvpsp( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvpsp( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svpsp( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvpsp( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvpsp( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivpsp( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdpsp( c_func, d0, p1, s2, p3 )
	SV* c_func
	double d0
	void * p1
	short s2
	void * p3
PREINIT:
	void *(*func)(double, void *, short, void *);
CODE:
	func   = INT2PTR(void *(*)(double, void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, s2, p3);
OUTPUT:
	RETVAL

void
nci_vdpsp( c_func, d0, p1, s2, p3 )
	SV* c_func
	double d0
	void * p1
	short s2
	void * p3
PREINIT:
	void(*func)(double, void *, short, void *);
CODE:
	func   = INT2PTR(void(*)(double, void *, short, void *), SvIV(c_func) );
	(*func)(d0, p1, s2, p3);

double
nci_ddpsp( c_func, d0, p1, s2, p3 )
	SV* c_func
	double d0
	void * p1
	short s2
	void * p3
PREINIT:
	double(*func)(double, void *, short, void *);
CODE:
	func   = INT2PTR(double(*)(double, void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, s2, p3);
OUTPUT:
	RETVAL

short
nci_sdpsp( c_func, d0, p1, s2, p3 )
	SV* c_func
	double d0
	void * p1
	short s2
	void * p3
PREINIT:
	short(*func)(double, void *, short, void *);
CODE:
	func   = INT2PTR(short(*)(double, void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, s2, p3);
OUTPUT:
	RETVAL

float
nci_fdpsp( c_func, d0, p1, s2, p3 )
	SV* c_func
	double d0
	void * p1
	short s2
	void * p3
PREINIT:
	float(*func)(double, void *, short, void *);
CODE:
	func   = INT2PTR(float(*)(double, void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, s2, p3);
OUTPUT:
	RETVAL

char *
nci_tdpsp( c_func, d0, p1, s2, p3 )
	SV* c_func
	double d0
	void * p1
	short s2
	void * p3
PREINIT:
	char *(*func)(double, void *, short, void *);
CODE:
	func   = INT2PTR(char *(*)(double, void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, s2, p3);
OUTPUT:
	RETVAL

int
nci_idpsp( c_func, d0, p1, s2, p3 )
	SV* c_func
	double d0
	void * p1
	short s2
	void * p3
PREINIT:
	int(*func)(double, void *, short, void *);
CODE:
	func   = INT2PTR(int(*)(double, void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, s2, p3);
OUTPUT:
	RETVAL

void *
nci_pspsp( c_func, s0, p1, s2, p3 )
	SV* c_func
	short s0
	void * p1
	short s2
	void * p3
PREINIT:
	void *(*func)(short, void *, short, void *);
CODE:
	func   = INT2PTR(void *(*)(short, void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, s2, p3);
OUTPUT:
	RETVAL

void
nci_vspsp( c_func, s0, p1, s2, p3 )
	SV* c_func
	short s0
	void * p1
	short s2
	void * p3
PREINIT:
	void(*func)(short, void *, short, void *);
CODE:
	func   = INT2PTR(void(*)(short, void *, short, void *), SvIV(c_func) );
	(*func)(s0, p1, s2, p3);

double
nci_dspsp( c_func, s0, p1, s2, p3 )
	SV* c_func
	short s0
	void * p1
	short s2
	void * p3
PREINIT:
	double(*func)(short, void *, short, void *);
CODE:
	func   = INT2PTR(double(*)(short, void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, s2, p3);
OUTPUT:
	RETVAL

short
nci_sspsp( c_func, s0, p1, s2, p3 )
	SV* c_func
	short s0
	void * p1
	short s2
	void * p3
PREINIT:
	short(*func)(short, void *, short, void *);
CODE:
	func   = INT2PTR(short(*)(short, void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, s2, p3);
OUTPUT:
	RETVAL

float
nci_fspsp( c_func, s0, p1, s2, p3 )
	SV* c_func
	short s0
	void * p1
	short s2
	void * p3
PREINIT:
	float(*func)(short, void *, short, void *);
CODE:
	func   = INT2PTR(float(*)(short, void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, s2, p3);
OUTPUT:
	RETVAL

char *
nci_tspsp( c_func, s0, p1, s2, p3 )
	SV* c_func
	short s0
	void * p1
	short s2
	void * p3
PREINIT:
	char *(*func)(short, void *, short, void *);
CODE:
	func   = INT2PTR(char *(*)(short, void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, s2, p3);
OUTPUT:
	RETVAL

int
nci_ispsp( c_func, s0, p1, s2, p3 )
	SV* c_func
	short s0
	void * p1
	short s2
	void * p3
PREINIT:
	int(*func)(short, void *, short, void *);
CODE:
	func   = INT2PTR(int(*)(short, void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, s2, p3);
OUTPUT:
	RETVAL

void *
nci_pfpsp( c_func, f0, p1, s2, p3 )
	SV* c_func
	float f0
	void * p1
	short s2
	void * p3
PREINIT:
	void *(*func)(float, void *, short, void *);
CODE:
	func   = INT2PTR(void *(*)(float, void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, s2, p3);
OUTPUT:
	RETVAL

void
nci_vfpsp( c_func, f0, p1, s2, p3 )
	SV* c_func
	float f0
	void * p1
	short s2
	void * p3
PREINIT:
	void(*func)(float, void *, short, void *);
CODE:
	func   = INT2PTR(void(*)(float, void *, short, void *), SvIV(c_func) );
	(*func)(f0, p1, s2, p3);

double
nci_dfpsp( c_func, f0, p1, s2, p3 )
	SV* c_func
	float f0
	void * p1
	short s2
	void * p3
PREINIT:
	double(*func)(float, void *, short, void *);
CODE:
	func   = INT2PTR(double(*)(float, void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, s2, p3);
OUTPUT:
	RETVAL

short
nci_sfpsp( c_func, f0, p1, s2, p3 )
	SV* c_func
	float f0
	void * p1
	short s2
	void * p3
PREINIT:
	short(*func)(float, void *, short, void *);
CODE:
	func   = INT2PTR(short(*)(float, void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, s2, p3);
OUTPUT:
	RETVAL

float
nci_ffpsp( c_func, f0, p1, s2, p3 )
	SV* c_func
	float f0
	void * p1
	short s2
	void * p3
PREINIT:
	float(*func)(float, void *, short, void *);
CODE:
	func   = INT2PTR(float(*)(float, void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, s2, p3);
OUTPUT:
	RETVAL

char *
nci_tfpsp( c_func, f0, p1, s2, p3 )
	SV* c_func
	float f0
	void * p1
	short s2
	void * p3
PREINIT:
	char *(*func)(float, void *, short, void *);
CODE:
	func   = INT2PTR(char *(*)(float, void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, s2, p3);
OUTPUT:
	RETVAL

int
nci_ifpsp( c_func, f0, p1, s2, p3 )
	SV* c_func
	float f0
	void * p1
	short s2
	void * p3
PREINIT:
	int(*func)(float, void *, short, void *);
CODE:
	func   = INT2PTR(int(*)(float, void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, s2, p3);
OUTPUT:
	RETVAL

void *
nci_ptpsp( c_func, t0, p1, s2, p3 )
	SV* c_func
	char * t0
	void * p1
	short s2
	void * p3
PREINIT:
	void *(*func)(char *, void *, short, void *);
CODE:
	func   = INT2PTR(void *(*)(char *, void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, s2, p3);
OUTPUT:
	RETVAL

void
nci_vtpsp( c_func, t0, p1, s2, p3 )
	SV* c_func
	char * t0
	void * p1
	short s2
	void * p3
PREINIT:
	void(*func)(char *, void *, short, void *);
CODE:
	func   = INT2PTR(void(*)(char *, void *, short, void *), SvIV(c_func) );
	(*func)(t0, p1, s2, p3);

double
nci_dtpsp( c_func, t0, p1, s2, p3 )
	SV* c_func
	char * t0
	void * p1
	short s2
	void * p3
PREINIT:
	double(*func)(char *, void *, short, void *);
CODE:
	func   = INT2PTR(double(*)(char *, void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, s2, p3);
OUTPUT:
	RETVAL

short
nci_stpsp( c_func, t0, p1, s2, p3 )
	SV* c_func
	char * t0
	void * p1
	short s2
	void * p3
PREINIT:
	short(*func)(char *, void *, short, void *);
CODE:
	func   = INT2PTR(short(*)(char *, void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, s2, p3);
OUTPUT:
	RETVAL

float
nci_ftpsp( c_func, t0, p1, s2, p3 )
	SV* c_func
	char * t0
	void * p1
	short s2
	void * p3
PREINIT:
	float(*func)(char *, void *, short, void *);
CODE:
	func   = INT2PTR(float(*)(char *, void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, s2, p3);
OUTPUT:
	RETVAL

char *
nci_ttpsp( c_func, t0, p1, s2, p3 )
	SV* c_func
	char * t0
	void * p1
	short s2
	void * p3
PREINIT:
	char *(*func)(char *, void *, short, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, s2, p3);
OUTPUT:
	RETVAL

int
nci_itpsp( c_func, t0, p1, s2, p3 )
	SV* c_func
	char * t0
	void * p1
	short s2
	void * p3
PREINIT:
	int(*func)(char *, void *, short, void *);
CODE:
	func   = INT2PTR(int(*)(char *, void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, s2, p3);
OUTPUT:
	RETVAL

void *
nci_pipsp( c_func, i0, p1, s2, p3 )
	SV* c_func
	int i0
	void * p1
	short s2
	void * p3
PREINIT:
	void *(*func)(int, void *, short, void *);
CODE:
	func   = INT2PTR(void *(*)(int, void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, s2, p3);
OUTPUT:
	RETVAL

void
nci_vipsp( c_func, i0, p1, s2, p3 )
	SV* c_func
	int i0
	void * p1
	short s2
	void * p3
PREINIT:
	void(*func)(int, void *, short, void *);
CODE:
	func   = INT2PTR(void(*)(int, void *, short, void *), SvIV(c_func) );
	(*func)(i0, p1, s2, p3);

double
nci_dipsp( c_func, i0, p1, s2, p3 )
	SV* c_func
	int i0
	void * p1
	short s2
	void * p3
PREINIT:
	double(*func)(int, void *, short, void *);
CODE:
	func   = INT2PTR(double(*)(int, void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, s2, p3);
OUTPUT:
	RETVAL

short
nci_sipsp( c_func, i0, p1, s2, p3 )
	SV* c_func
	int i0
	void * p1
	short s2
	void * p3
PREINIT:
	short(*func)(int, void *, short, void *);
CODE:
	func   = INT2PTR(short(*)(int, void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, s2, p3);
OUTPUT:
	RETVAL

float
nci_fipsp( c_func, i0, p1, s2, p3 )
	SV* c_func
	int i0
	void * p1
	short s2
	void * p3
PREINIT:
	float(*func)(int, void *, short, void *);
CODE:
	func   = INT2PTR(float(*)(int, void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, s2, p3);
OUTPUT:
	RETVAL

char *
nci_tipsp( c_func, i0, p1, s2, p3 )
	SV* c_func
	int i0
	void * p1
	short s2
	void * p3
PREINIT:
	char *(*func)(int, void *, short, void *);
CODE:
	func   = INT2PTR(char *(*)(int, void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, s2, p3);
OUTPUT:
	RETVAL

int
nci_iipsp( c_func, i0, p1, s2, p3 )
	SV* c_func
	int i0
	void * p1
	short s2
	void * p3
PREINIT:
	int(*func)(int, void *, short, void *);
CODE:
	func   = INT2PTR(int(*)(int, void *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, s2, p3);
OUTPUT:
	RETVAL

void *
nci_ppdsp( c_func, p0, d1, s2, p3 )
	SV* c_func
	void * p0
	double d1
	short s2
	void * p3
PREINIT:
	void *(*func)(void *, double, short, void *);
CODE:
	func   = INT2PTR(void *(*)(void *, double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, s2, p3);
OUTPUT:
	RETVAL

void
nci_vpdsp( c_func, p0, d1, s2, p3 )
	SV* c_func
	void * p0
	double d1
	short s2
	void * p3
PREINIT:
	void(*func)(void *, double, short, void *);
CODE:
	func   = INT2PTR(void(*)(void *, double, short, void *), SvIV(c_func) );
	(*func)(p0, d1, s2, p3);

double
nci_dpdsp( c_func, p0, d1, s2, p3 )
	SV* c_func
	void * p0
	double d1
	short s2
	void * p3
PREINIT:
	double(*func)(void *, double, short, void *);
CODE:
	func   = INT2PTR(double(*)(void *, double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, s2, p3);
OUTPUT:
	RETVAL

short
nci_spdsp( c_func, p0, d1, s2, p3 )
	SV* c_func
	void * p0
	double d1
	short s2
	void * p3
PREINIT:
	short(*func)(void *, double, short, void *);
CODE:
	func   = INT2PTR(short(*)(void *, double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, s2, p3);
OUTPUT:
	RETVAL

float
nci_fpdsp( c_func, p0, d1, s2, p3 )
	SV* c_func
	void * p0
	double d1
	short s2
	void * p3
PREINIT:
	float(*func)(void *, double, short, void *);
CODE:
	func   = INT2PTR(float(*)(void *, double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, s2, p3);
OUTPUT:
	RETVAL

char *
nci_tpdsp( c_func, p0, d1, s2, p3 )
	SV* c_func
	void * p0
	double d1
	short s2
	void * p3
PREINIT:
	char *(*func)(void *, double, short, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, s2, p3);
OUTPUT:
	RETVAL

int
nci_ipdsp( c_func, p0, d1, s2, p3 )
	SV* c_func
	void * p0
	double d1
	short s2
	void * p3
PREINIT:
	int(*func)(void *, double, short, void *);
CODE:
	func   = INT2PTR(int(*)(void *, double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, s2, p3);
OUTPUT:
	RETVAL

void *
nci_pvdsp( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvdsp( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvdsp( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svdsp( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvdsp( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvdsp( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivdsp( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pddsp( c_func, d0, d1, s2, p3 )
	SV* c_func
	double d0
	double d1
	short s2
	void * p3
PREINIT:
	void *(*func)(double, double, short, void *);
CODE:
	func   = INT2PTR(void *(*)(double, double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, s2, p3);
OUTPUT:
	RETVAL

void
nci_vddsp( c_func, d0, d1, s2, p3 )
	SV* c_func
	double d0
	double d1
	short s2
	void * p3
PREINIT:
	void(*func)(double, double, short, void *);
CODE:
	func   = INT2PTR(void(*)(double, double, short, void *), SvIV(c_func) );
	(*func)(d0, d1, s2, p3);

double
nci_dddsp( c_func, d0, d1, s2, p3 )
	SV* c_func
	double d0
	double d1
	short s2
	void * p3
PREINIT:
	double(*func)(double, double, short, void *);
CODE:
	func   = INT2PTR(double(*)(double, double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, s2, p3);
OUTPUT:
	RETVAL

short
nci_sddsp( c_func, d0, d1, s2, p3 )
	SV* c_func
	double d0
	double d1
	short s2
	void * p3
PREINIT:
	short(*func)(double, double, short, void *);
CODE:
	func   = INT2PTR(short(*)(double, double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, s2, p3);
OUTPUT:
	RETVAL

float
nci_fddsp( c_func, d0, d1, s2, p3 )
	SV* c_func
	double d0
	double d1
	short s2
	void * p3
PREINIT:
	float(*func)(double, double, short, void *);
CODE:
	func   = INT2PTR(float(*)(double, double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, s2, p3);
OUTPUT:
	RETVAL

char *
nci_tddsp( c_func, d0, d1, s2, p3 )
	SV* c_func
	double d0
	double d1
	short s2
	void * p3
PREINIT:
	char *(*func)(double, double, short, void *);
CODE:
	func   = INT2PTR(char *(*)(double, double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, s2, p3);
OUTPUT:
	RETVAL

int
nci_iddsp( c_func, d0, d1, s2, p3 )
	SV* c_func
	double d0
	double d1
	short s2
	void * p3
PREINIT:
	int(*func)(double, double, short, void *);
CODE:
	func   = INT2PTR(int(*)(double, double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, s2, p3);
OUTPUT:
	RETVAL

void *
nci_psdsp( c_func, s0, d1, s2, p3 )
	SV* c_func
	short s0
	double d1
	short s2
	void * p3
PREINIT:
	void *(*func)(short, double, short, void *);
CODE:
	func   = INT2PTR(void *(*)(short, double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, s2, p3);
OUTPUT:
	RETVAL

void
nci_vsdsp( c_func, s0, d1, s2, p3 )
	SV* c_func
	short s0
	double d1
	short s2
	void * p3
PREINIT:
	void(*func)(short, double, short, void *);
CODE:
	func   = INT2PTR(void(*)(short, double, short, void *), SvIV(c_func) );
	(*func)(s0, d1, s2, p3);

double
nci_dsdsp( c_func, s0, d1, s2, p3 )
	SV* c_func
	short s0
	double d1
	short s2
	void * p3
PREINIT:
	double(*func)(short, double, short, void *);
CODE:
	func   = INT2PTR(double(*)(short, double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, s2, p3);
OUTPUT:
	RETVAL

short
nci_ssdsp( c_func, s0, d1, s2, p3 )
	SV* c_func
	short s0
	double d1
	short s2
	void * p3
PREINIT:
	short(*func)(short, double, short, void *);
CODE:
	func   = INT2PTR(short(*)(short, double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, s2, p3);
OUTPUT:
	RETVAL

float
nci_fsdsp( c_func, s0, d1, s2, p3 )
	SV* c_func
	short s0
	double d1
	short s2
	void * p3
PREINIT:
	float(*func)(short, double, short, void *);
CODE:
	func   = INT2PTR(float(*)(short, double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, s2, p3);
OUTPUT:
	RETVAL

char *
nci_tsdsp( c_func, s0, d1, s2, p3 )
	SV* c_func
	short s0
	double d1
	short s2
	void * p3
PREINIT:
	char *(*func)(short, double, short, void *);
CODE:
	func   = INT2PTR(char *(*)(short, double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, s2, p3);
OUTPUT:
	RETVAL

int
nci_isdsp( c_func, s0, d1, s2, p3 )
	SV* c_func
	short s0
	double d1
	short s2
	void * p3
PREINIT:
	int(*func)(short, double, short, void *);
CODE:
	func   = INT2PTR(int(*)(short, double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, s2, p3);
OUTPUT:
	RETVAL

void *
nci_pfdsp( c_func, f0, d1, s2, p3 )
	SV* c_func
	float f0
	double d1
	short s2
	void * p3
PREINIT:
	void *(*func)(float, double, short, void *);
CODE:
	func   = INT2PTR(void *(*)(float, double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, s2, p3);
OUTPUT:
	RETVAL

void
nci_vfdsp( c_func, f0, d1, s2, p3 )
	SV* c_func
	float f0
	double d1
	short s2
	void * p3
PREINIT:
	void(*func)(float, double, short, void *);
CODE:
	func   = INT2PTR(void(*)(float, double, short, void *), SvIV(c_func) );
	(*func)(f0, d1, s2, p3);

double
nci_dfdsp( c_func, f0, d1, s2, p3 )
	SV* c_func
	float f0
	double d1
	short s2
	void * p3
PREINIT:
	double(*func)(float, double, short, void *);
CODE:
	func   = INT2PTR(double(*)(float, double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, s2, p3);
OUTPUT:
	RETVAL

short
nci_sfdsp( c_func, f0, d1, s2, p3 )
	SV* c_func
	float f0
	double d1
	short s2
	void * p3
PREINIT:
	short(*func)(float, double, short, void *);
CODE:
	func   = INT2PTR(short(*)(float, double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, s2, p3);
OUTPUT:
	RETVAL

float
nci_ffdsp( c_func, f0, d1, s2, p3 )
	SV* c_func
	float f0
	double d1
	short s2
	void * p3
PREINIT:
	float(*func)(float, double, short, void *);
CODE:
	func   = INT2PTR(float(*)(float, double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, s2, p3);
OUTPUT:
	RETVAL

char *
nci_tfdsp( c_func, f0, d1, s2, p3 )
	SV* c_func
	float f0
	double d1
	short s2
	void * p3
PREINIT:
	char *(*func)(float, double, short, void *);
CODE:
	func   = INT2PTR(char *(*)(float, double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, s2, p3);
OUTPUT:
	RETVAL

int
nci_ifdsp( c_func, f0, d1, s2, p3 )
	SV* c_func
	float f0
	double d1
	short s2
	void * p3
PREINIT:
	int(*func)(float, double, short, void *);
CODE:
	func   = INT2PTR(int(*)(float, double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, s2, p3);
OUTPUT:
	RETVAL

void *
nci_ptdsp( c_func, t0, d1, s2, p3 )
	SV* c_func
	char * t0
	double d1
	short s2
	void * p3
PREINIT:
	void *(*func)(char *, double, short, void *);
CODE:
	func   = INT2PTR(void *(*)(char *, double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, s2, p3);
OUTPUT:
	RETVAL

void
nci_vtdsp( c_func, t0, d1, s2, p3 )
	SV* c_func
	char * t0
	double d1
	short s2
	void * p3
PREINIT:
	void(*func)(char *, double, short, void *);
CODE:
	func   = INT2PTR(void(*)(char *, double, short, void *), SvIV(c_func) );
	(*func)(t0, d1, s2, p3);

double
nci_dtdsp( c_func, t0, d1, s2, p3 )
	SV* c_func
	char * t0
	double d1
	short s2
	void * p3
PREINIT:
	double(*func)(char *, double, short, void *);
CODE:
	func   = INT2PTR(double(*)(char *, double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, s2, p3);
OUTPUT:
	RETVAL

short
nci_stdsp( c_func, t0, d1, s2, p3 )
	SV* c_func
	char * t0
	double d1
	short s2
	void * p3
PREINIT:
	short(*func)(char *, double, short, void *);
CODE:
	func   = INT2PTR(short(*)(char *, double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, s2, p3);
OUTPUT:
	RETVAL

float
nci_ftdsp( c_func, t0, d1, s2, p3 )
	SV* c_func
	char * t0
	double d1
	short s2
	void * p3
PREINIT:
	float(*func)(char *, double, short, void *);
CODE:
	func   = INT2PTR(float(*)(char *, double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, s2, p3);
OUTPUT:
	RETVAL

char *
nci_ttdsp( c_func, t0, d1, s2, p3 )
	SV* c_func
	char * t0
	double d1
	short s2
	void * p3
PREINIT:
	char *(*func)(char *, double, short, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, s2, p3);
OUTPUT:
	RETVAL

int
nci_itdsp( c_func, t0, d1, s2, p3 )
	SV* c_func
	char * t0
	double d1
	short s2
	void * p3
PREINIT:
	int(*func)(char *, double, short, void *);
CODE:
	func   = INT2PTR(int(*)(char *, double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, s2, p3);
OUTPUT:
	RETVAL

void *
nci_pidsp( c_func, i0, d1, s2, p3 )
	SV* c_func
	int i0
	double d1
	short s2
	void * p3
PREINIT:
	void *(*func)(int, double, short, void *);
CODE:
	func   = INT2PTR(void *(*)(int, double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, s2, p3);
OUTPUT:
	RETVAL

void
nci_vidsp( c_func, i0, d1, s2, p3 )
	SV* c_func
	int i0
	double d1
	short s2
	void * p3
PREINIT:
	void(*func)(int, double, short, void *);
CODE:
	func   = INT2PTR(void(*)(int, double, short, void *), SvIV(c_func) );
	(*func)(i0, d1, s2, p3);

double
nci_didsp( c_func, i0, d1, s2, p3 )
	SV* c_func
	int i0
	double d1
	short s2
	void * p3
PREINIT:
	double(*func)(int, double, short, void *);
CODE:
	func   = INT2PTR(double(*)(int, double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, s2, p3);
OUTPUT:
	RETVAL

short
nci_sidsp( c_func, i0, d1, s2, p3 )
	SV* c_func
	int i0
	double d1
	short s2
	void * p3
PREINIT:
	short(*func)(int, double, short, void *);
CODE:
	func   = INT2PTR(short(*)(int, double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, s2, p3);
OUTPUT:
	RETVAL

float
nci_fidsp( c_func, i0, d1, s2, p3 )
	SV* c_func
	int i0
	double d1
	short s2
	void * p3
PREINIT:
	float(*func)(int, double, short, void *);
CODE:
	func   = INT2PTR(float(*)(int, double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, s2, p3);
OUTPUT:
	RETVAL

char *
nci_tidsp( c_func, i0, d1, s2, p3 )
	SV* c_func
	int i0
	double d1
	short s2
	void * p3
PREINIT:
	char *(*func)(int, double, short, void *);
CODE:
	func   = INT2PTR(char *(*)(int, double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, s2, p3);
OUTPUT:
	RETVAL

int
nci_iidsp( c_func, i0, d1, s2, p3 )
	SV* c_func
	int i0
	double d1
	short s2
	void * p3
PREINIT:
	int(*func)(int, double, short, void *);
CODE:
	func   = INT2PTR(int(*)(int, double, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, s2, p3);
OUTPUT:
	RETVAL

void *
nci_ppssp( c_func, p0, s1, s2, p3 )
	SV* c_func
	void * p0
	short s1
	short s2
	void * p3
PREINIT:
	void *(*func)(void *, short, short, void *);
CODE:
	func   = INT2PTR(void *(*)(void *, short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, s2, p3);
OUTPUT:
	RETVAL

void
nci_vpssp( c_func, p0, s1, s2, p3 )
	SV* c_func
	void * p0
	short s1
	short s2
	void * p3
PREINIT:
	void(*func)(void *, short, short, void *);
CODE:
	func   = INT2PTR(void(*)(void *, short, short, void *), SvIV(c_func) );
	(*func)(p0, s1, s2, p3);

double
nci_dpssp( c_func, p0, s1, s2, p3 )
	SV* c_func
	void * p0
	short s1
	short s2
	void * p3
PREINIT:
	double(*func)(void *, short, short, void *);
CODE:
	func   = INT2PTR(double(*)(void *, short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, s2, p3);
OUTPUT:
	RETVAL

short
nci_spssp( c_func, p0, s1, s2, p3 )
	SV* c_func
	void * p0
	short s1
	short s2
	void * p3
PREINIT:
	short(*func)(void *, short, short, void *);
CODE:
	func   = INT2PTR(short(*)(void *, short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, s2, p3);
OUTPUT:
	RETVAL

float
nci_fpssp( c_func, p0, s1, s2, p3 )
	SV* c_func
	void * p0
	short s1
	short s2
	void * p3
PREINIT:
	float(*func)(void *, short, short, void *);
CODE:
	func   = INT2PTR(float(*)(void *, short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, s2, p3);
OUTPUT:
	RETVAL

char *
nci_tpssp( c_func, p0, s1, s2, p3 )
	SV* c_func
	void * p0
	short s1
	short s2
	void * p3
PREINIT:
	char *(*func)(void *, short, short, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, s2, p3);
OUTPUT:
	RETVAL

int
nci_ipssp( c_func, p0, s1, s2, p3 )
	SV* c_func
	void * p0
	short s1
	short s2
	void * p3
PREINIT:
	int(*func)(void *, short, short, void *);
CODE:
	func   = INT2PTR(int(*)(void *, short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, s2, p3);
OUTPUT:
	RETVAL

void *
nci_pvssp( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvssp( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvssp( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svssp( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvssp( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvssp( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivssp( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdssp( c_func, d0, s1, s2, p3 )
	SV* c_func
	double d0
	short s1
	short s2
	void * p3
PREINIT:
	void *(*func)(double, short, short, void *);
CODE:
	func   = INT2PTR(void *(*)(double, short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, s2, p3);
OUTPUT:
	RETVAL

void
nci_vdssp( c_func, d0, s1, s2, p3 )
	SV* c_func
	double d0
	short s1
	short s2
	void * p3
PREINIT:
	void(*func)(double, short, short, void *);
CODE:
	func   = INT2PTR(void(*)(double, short, short, void *), SvIV(c_func) );
	(*func)(d0, s1, s2, p3);

double
nci_ddssp( c_func, d0, s1, s2, p3 )
	SV* c_func
	double d0
	short s1
	short s2
	void * p3
PREINIT:
	double(*func)(double, short, short, void *);
CODE:
	func   = INT2PTR(double(*)(double, short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, s2, p3);
OUTPUT:
	RETVAL

short
nci_sdssp( c_func, d0, s1, s2, p3 )
	SV* c_func
	double d0
	short s1
	short s2
	void * p3
PREINIT:
	short(*func)(double, short, short, void *);
CODE:
	func   = INT2PTR(short(*)(double, short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, s2, p3);
OUTPUT:
	RETVAL

float
nci_fdssp( c_func, d0, s1, s2, p3 )
	SV* c_func
	double d0
	short s1
	short s2
	void * p3
PREINIT:
	float(*func)(double, short, short, void *);
CODE:
	func   = INT2PTR(float(*)(double, short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, s2, p3);
OUTPUT:
	RETVAL

char *
nci_tdssp( c_func, d0, s1, s2, p3 )
	SV* c_func
	double d0
	short s1
	short s2
	void * p3
PREINIT:
	char *(*func)(double, short, short, void *);
CODE:
	func   = INT2PTR(char *(*)(double, short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, s2, p3);
OUTPUT:
	RETVAL

int
nci_idssp( c_func, d0, s1, s2, p3 )
	SV* c_func
	double d0
	short s1
	short s2
	void * p3
PREINIT:
	int(*func)(double, short, short, void *);
CODE:
	func   = INT2PTR(int(*)(double, short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, s2, p3);
OUTPUT:
	RETVAL

void *
nci_psssp( c_func, s0, s1, s2, p3 )
	SV* c_func
	short s0
	short s1
	short s2
	void * p3
PREINIT:
	void *(*func)(short, short, short, void *);
CODE:
	func   = INT2PTR(void *(*)(short, short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, s2, p3);
OUTPUT:
	RETVAL

void
nci_vsssp( c_func, s0, s1, s2, p3 )
	SV* c_func
	short s0
	short s1
	short s2
	void * p3
PREINIT:
	void(*func)(short, short, short, void *);
CODE:
	func   = INT2PTR(void(*)(short, short, short, void *), SvIV(c_func) );
	(*func)(s0, s1, s2, p3);

double
nci_dsssp( c_func, s0, s1, s2, p3 )
	SV* c_func
	short s0
	short s1
	short s2
	void * p3
PREINIT:
	double(*func)(short, short, short, void *);
CODE:
	func   = INT2PTR(double(*)(short, short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, s2, p3);
OUTPUT:
	RETVAL

short
nci_ssssp( c_func, s0, s1, s2, p3 )
	SV* c_func
	short s0
	short s1
	short s2
	void * p3
PREINIT:
	short(*func)(short, short, short, void *);
CODE:
	func   = INT2PTR(short(*)(short, short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, s2, p3);
OUTPUT:
	RETVAL

float
nci_fsssp( c_func, s0, s1, s2, p3 )
	SV* c_func
	short s0
	short s1
	short s2
	void * p3
PREINIT:
	float(*func)(short, short, short, void *);
CODE:
	func   = INT2PTR(float(*)(short, short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, s2, p3);
OUTPUT:
	RETVAL

char *
nci_tsssp( c_func, s0, s1, s2, p3 )
	SV* c_func
	short s0
	short s1
	short s2
	void * p3
PREINIT:
	char *(*func)(short, short, short, void *);
CODE:
	func   = INT2PTR(char *(*)(short, short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, s2, p3);
OUTPUT:
	RETVAL

int
nci_isssp( c_func, s0, s1, s2, p3 )
	SV* c_func
	short s0
	short s1
	short s2
	void * p3
PREINIT:
	int(*func)(short, short, short, void *);
CODE:
	func   = INT2PTR(int(*)(short, short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, s2, p3);
OUTPUT:
	RETVAL

void *
nci_pfssp( c_func, f0, s1, s2, p3 )
	SV* c_func
	float f0
	short s1
	short s2
	void * p3
PREINIT:
	void *(*func)(float, short, short, void *);
CODE:
	func   = INT2PTR(void *(*)(float, short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, s2, p3);
OUTPUT:
	RETVAL

void
nci_vfssp( c_func, f0, s1, s2, p3 )
	SV* c_func
	float f0
	short s1
	short s2
	void * p3
PREINIT:
	void(*func)(float, short, short, void *);
CODE:
	func   = INT2PTR(void(*)(float, short, short, void *), SvIV(c_func) );
	(*func)(f0, s1, s2, p3);

double
nci_dfssp( c_func, f0, s1, s2, p3 )
	SV* c_func
	float f0
	short s1
	short s2
	void * p3
PREINIT:
	double(*func)(float, short, short, void *);
CODE:
	func   = INT2PTR(double(*)(float, short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, s2, p3);
OUTPUT:
	RETVAL

short
nci_sfssp( c_func, f0, s1, s2, p3 )
	SV* c_func
	float f0
	short s1
	short s2
	void * p3
PREINIT:
	short(*func)(float, short, short, void *);
CODE:
	func   = INT2PTR(short(*)(float, short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, s2, p3);
OUTPUT:
	RETVAL

float
nci_ffssp( c_func, f0, s1, s2, p3 )
	SV* c_func
	float f0
	short s1
	short s2
	void * p3
PREINIT:
	float(*func)(float, short, short, void *);
CODE:
	func   = INT2PTR(float(*)(float, short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, s2, p3);
OUTPUT:
	RETVAL

char *
nci_tfssp( c_func, f0, s1, s2, p3 )
	SV* c_func
	float f0
	short s1
	short s2
	void * p3
PREINIT:
	char *(*func)(float, short, short, void *);
CODE:
	func   = INT2PTR(char *(*)(float, short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, s2, p3);
OUTPUT:
	RETVAL

int
nci_ifssp( c_func, f0, s1, s2, p3 )
	SV* c_func
	float f0
	short s1
	short s2
	void * p3
PREINIT:
	int(*func)(float, short, short, void *);
CODE:
	func   = INT2PTR(int(*)(float, short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, s2, p3);
OUTPUT:
	RETVAL

void *
nci_ptssp( c_func, t0, s1, s2, p3 )
	SV* c_func
	char * t0
	short s1
	short s2
	void * p3
PREINIT:
	void *(*func)(char *, short, short, void *);
CODE:
	func   = INT2PTR(void *(*)(char *, short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, s2, p3);
OUTPUT:
	RETVAL

void
nci_vtssp( c_func, t0, s1, s2, p3 )
	SV* c_func
	char * t0
	short s1
	short s2
	void * p3
PREINIT:
	void(*func)(char *, short, short, void *);
CODE:
	func   = INT2PTR(void(*)(char *, short, short, void *), SvIV(c_func) );
	(*func)(t0, s1, s2, p3);

double
nci_dtssp( c_func, t0, s1, s2, p3 )
	SV* c_func
	char * t0
	short s1
	short s2
	void * p3
PREINIT:
	double(*func)(char *, short, short, void *);
CODE:
	func   = INT2PTR(double(*)(char *, short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, s2, p3);
OUTPUT:
	RETVAL

short
nci_stssp( c_func, t0, s1, s2, p3 )
	SV* c_func
	char * t0
	short s1
	short s2
	void * p3
PREINIT:
	short(*func)(char *, short, short, void *);
CODE:
	func   = INT2PTR(short(*)(char *, short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, s2, p3);
OUTPUT:
	RETVAL

float
nci_ftssp( c_func, t0, s1, s2, p3 )
	SV* c_func
	char * t0
	short s1
	short s2
	void * p3
PREINIT:
	float(*func)(char *, short, short, void *);
CODE:
	func   = INT2PTR(float(*)(char *, short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, s2, p3);
OUTPUT:
	RETVAL

char *
nci_ttssp( c_func, t0, s1, s2, p3 )
	SV* c_func
	char * t0
	short s1
	short s2
	void * p3
PREINIT:
	char *(*func)(char *, short, short, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, s2, p3);
OUTPUT:
	RETVAL

int
nci_itssp( c_func, t0, s1, s2, p3 )
	SV* c_func
	char * t0
	short s1
	short s2
	void * p3
PREINIT:
	int(*func)(char *, short, short, void *);
CODE:
	func   = INT2PTR(int(*)(char *, short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, s2, p3);
OUTPUT:
	RETVAL

void *
nci_pissp( c_func, i0, s1, s2, p3 )
	SV* c_func
	int i0
	short s1
	short s2
	void * p3
PREINIT:
	void *(*func)(int, short, short, void *);
CODE:
	func   = INT2PTR(void *(*)(int, short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, s2, p3);
OUTPUT:
	RETVAL

void
nci_vissp( c_func, i0, s1, s2, p3 )
	SV* c_func
	int i0
	short s1
	short s2
	void * p3
PREINIT:
	void(*func)(int, short, short, void *);
CODE:
	func   = INT2PTR(void(*)(int, short, short, void *), SvIV(c_func) );
	(*func)(i0, s1, s2, p3);

double
nci_dissp( c_func, i0, s1, s2, p3 )
	SV* c_func
	int i0
	short s1
	short s2
	void * p3
PREINIT:
	double(*func)(int, short, short, void *);
CODE:
	func   = INT2PTR(double(*)(int, short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, s2, p3);
OUTPUT:
	RETVAL

short
nci_sissp( c_func, i0, s1, s2, p3 )
	SV* c_func
	int i0
	short s1
	short s2
	void * p3
PREINIT:
	short(*func)(int, short, short, void *);
CODE:
	func   = INT2PTR(short(*)(int, short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, s2, p3);
OUTPUT:
	RETVAL

float
nci_fissp( c_func, i0, s1, s2, p3 )
	SV* c_func
	int i0
	short s1
	short s2
	void * p3
PREINIT:
	float(*func)(int, short, short, void *);
CODE:
	func   = INT2PTR(float(*)(int, short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, s2, p3);
OUTPUT:
	RETVAL

char *
nci_tissp( c_func, i0, s1, s2, p3 )
	SV* c_func
	int i0
	short s1
	short s2
	void * p3
PREINIT:
	char *(*func)(int, short, short, void *);
CODE:
	func   = INT2PTR(char *(*)(int, short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, s2, p3);
OUTPUT:
	RETVAL

int
nci_iissp( c_func, i0, s1, s2, p3 )
	SV* c_func
	int i0
	short s1
	short s2
	void * p3
PREINIT:
	int(*func)(int, short, short, void *);
CODE:
	func   = INT2PTR(int(*)(int, short, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, s2, p3);
OUTPUT:
	RETVAL

void *
nci_ppfsp( c_func, p0, f1, s2, p3 )
	SV* c_func
	void * p0
	float f1
	short s2
	void * p3
PREINIT:
	void *(*func)(void *, float, short, void *);
CODE:
	func   = INT2PTR(void *(*)(void *, float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, s2, p3);
OUTPUT:
	RETVAL

void
nci_vpfsp( c_func, p0, f1, s2, p3 )
	SV* c_func
	void * p0
	float f1
	short s2
	void * p3
PREINIT:
	void(*func)(void *, float, short, void *);
CODE:
	func   = INT2PTR(void(*)(void *, float, short, void *), SvIV(c_func) );
	(*func)(p0, f1, s2, p3);

double
nci_dpfsp( c_func, p0, f1, s2, p3 )
	SV* c_func
	void * p0
	float f1
	short s2
	void * p3
PREINIT:
	double(*func)(void *, float, short, void *);
CODE:
	func   = INT2PTR(double(*)(void *, float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, s2, p3);
OUTPUT:
	RETVAL

short
nci_spfsp( c_func, p0, f1, s2, p3 )
	SV* c_func
	void * p0
	float f1
	short s2
	void * p3
PREINIT:
	short(*func)(void *, float, short, void *);
CODE:
	func   = INT2PTR(short(*)(void *, float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, s2, p3);
OUTPUT:
	RETVAL

float
nci_fpfsp( c_func, p0, f1, s2, p3 )
	SV* c_func
	void * p0
	float f1
	short s2
	void * p3
PREINIT:
	float(*func)(void *, float, short, void *);
CODE:
	func   = INT2PTR(float(*)(void *, float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, s2, p3);
OUTPUT:
	RETVAL

char *
nci_tpfsp( c_func, p0, f1, s2, p3 )
	SV* c_func
	void * p0
	float f1
	short s2
	void * p3
PREINIT:
	char *(*func)(void *, float, short, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, s2, p3);
OUTPUT:
	RETVAL

int
nci_ipfsp( c_func, p0, f1, s2, p3 )
	SV* c_func
	void * p0
	float f1
	short s2
	void * p3
PREINIT:
	int(*func)(void *, float, short, void *);
CODE:
	func   = INT2PTR(int(*)(void *, float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, s2, p3);
OUTPUT:
	RETVAL

void *
nci_pvfsp( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvfsp( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvfsp( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svfsp( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvfsp( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvfsp( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivfsp( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdfsp( c_func, d0, f1, s2, p3 )
	SV* c_func
	double d0
	float f1
	short s2
	void * p3
PREINIT:
	void *(*func)(double, float, short, void *);
CODE:
	func   = INT2PTR(void *(*)(double, float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, s2, p3);
OUTPUT:
	RETVAL

void
nci_vdfsp( c_func, d0, f1, s2, p3 )
	SV* c_func
	double d0
	float f1
	short s2
	void * p3
PREINIT:
	void(*func)(double, float, short, void *);
CODE:
	func   = INT2PTR(void(*)(double, float, short, void *), SvIV(c_func) );
	(*func)(d0, f1, s2, p3);

double
nci_ddfsp( c_func, d0, f1, s2, p3 )
	SV* c_func
	double d0
	float f1
	short s2
	void * p3
PREINIT:
	double(*func)(double, float, short, void *);
CODE:
	func   = INT2PTR(double(*)(double, float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, s2, p3);
OUTPUT:
	RETVAL

short
nci_sdfsp( c_func, d0, f1, s2, p3 )
	SV* c_func
	double d0
	float f1
	short s2
	void * p3
PREINIT:
	short(*func)(double, float, short, void *);
CODE:
	func   = INT2PTR(short(*)(double, float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, s2, p3);
OUTPUT:
	RETVAL

float
nci_fdfsp( c_func, d0, f1, s2, p3 )
	SV* c_func
	double d0
	float f1
	short s2
	void * p3
PREINIT:
	float(*func)(double, float, short, void *);
CODE:
	func   = INT2PTR(float(*)(double, float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, s2, p3);
OUTPUT:
	RETVAL

char *
nci_tdfsp( c_func, d0, f1, s2, p3 )
	SV* c_func
	double d0
	float f1
	short s2
	void * p3
PREINIT:
	char *(*func)(double, float, short, void *);
CODE:
	func   = INT2PTR(char *(*)(double, float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, s2, p3);
OUTPUT:
	RETVAL

int
nci_idfsp( c_func, d0, f1, s2, p3 )
	SV* c_func
	double d0
	float f1
	short s2
	void * p3
PREINIT:
	int(*func)(double, float, short, void *);
CODE:
	func   = INT2PTR(int(*)(double, float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, s2, p3);
OUTPUT:
	RETVAL

void *
nci_psfsp( c_func, s0, f1, s2, p3 )
	SV* c_func
	short s0
	float f1
	short s2
	void * p3
PREINIT:
	void *(*func)(short, float, short, void *);
CODE:
	func   = INT2PTR(void *(*)(short, float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, s2, p3);
OUTPUT:
	RETVAL

void
nci_vsfsp( c_func, s0, f1, s2, p3 )
	SV* c_func
	short s0
	float f1
	short s2
	void * p3
PREINIT:
	void(*func)(short, float, short, void *);
CODE:
	func   = INT2PTR(void(*)(short, float, short, void *), SvIV(c_func) );
	(*func)(s0, f1, s2, p3);

double
nci_dsfsp( c_func, s0, f1, s2, p3 )
	SV* c_func
	short s0
	float f1
	short s2
	void * p3
PREINIT:
	double(*func)(short, float, short, void *);
CODE:
	func   = INT2PTR(double(*)(short, float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, s2, p3);
OUTPUT:
	RETVAL

short
nci_ssfsp( c_func, s0, f1, s2, p3 )
	SV* c_func
	short s0
	float f1
	short s2
	void * p3
PREINIT:
	short(*func)(short, float, short, void *);
CODE:
	func   = INT2PTR(short(*)(short, float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, s2, p3);
OUTPUT:
	RETVAL

float
nci_fsfsp( c_func, s0, f1, s2, p3 )
	SV* c_func
	short s0
	float f1
	short s2
	void * p3
PREINIT:
	float(*func)(short, float, short, void *);
CODE:
	func   = INT2PTR(float(*)(short, float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, s2, p3);
OUTPUT:
	RETVAL

char *
nci_tsfsp( c_func, s0, f1, s2, p3 )
	SV* c_func
	short s0
	float f1
	short s2
	void * p3
PREINIT:
	char *(*func)(short, float, short, void *);
CODE:
	func   = INT2PTR(char *(*)(short, float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, s2, p3);
OUTPUT:
	RETVAL

int
nci_isfsp( c_func, s0, f1, s2, p3 )
	SV* c_func
	short s0
	float f1
	short s2
	void * p3
PREINIT:
	int(*func)(short, float, short, void *);
CODE:
	func   = INT2PTR(int(*)(short, float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, s2, p3);
OUTPUT:
	RETVAL

void *
nci_pffsp( c_func, f0, f1, s2, p3 )
	SV* c_func
	float f0
	float f1
	short s2
	void * p3
PREINIT:
	void *(*func)(float, float, short, void *);
CODE:
	func   = INT2PTR(void *(*)(float, float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, s2, p3);
OUTPUT:
	RETVAL

void
nci_vffsp( c_func, f0, f1, s2, p3 )
	SV* c_func
	float f0
	float f1
	short s2
	void * p3
PREINIT:
	void(*func)(float, float, short, void *);
CODE:
	func   = INT2PTR(void(*)(float, float, short, void *), SvIV(c_func) );
	(*func)(f0, f1, s2, p3);

double
nci_dffsp( c_func, f0, f1, s2, p3 )
	SV* c_func
	float f0
	float f1
	short s2
	void * p3
PREINIT:
	double(*func)(float, float, short, void *);
CODE:
	func   = INT2PTR(double(*)(float, float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, s2, p3);
OUTPUT:
	RETVAL

short
nci_sffsp( c_func, f0, f1, s2, p3 )
	SV* c_func
	float f0
	float f1
	short s2
	void * p3
PREINIT:
	short(*func)(float, float, short, void *);
CODE:
	func   = INT2PTR(short(*)(float, float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, s2, p3);
OUTPUT:
	RETVAL

float
nci_fffsp( c_func, f0, f1, s2, p3 )
	SV* c_func
	float f0
	float f1
	short s2
	void * p3
PREINIT:
	float(*func)(float, float, short, void *);
CODE:
	func   = INT2PTR(float(*)(float, float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, s2, p3);
OUTPUT:
	RETVAL

char *
nci_tffsp( c_func, f0, f1, s2, p3 )
	SV* c_func
	float f0
	float f1
	short s2
	void * p3
PREINIT:
	char *(*func)(float, float, short, void *);
CODE:
	func   = INT2PTR(char *(*)(float, float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, s2, p3);
OUTPUT:
	RETVAL

int
nci_iffsp( c_func, f0, f1, s2, p3 )
	SV* c_func
	float f0
	float f1
	short s2
	void * p3
PREINIT:
	int(*func)(float, float, short, void *);
CODE:
	func   = INT2PTR(int(*)(float, float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, s2, p3);
OUTPUT:
	RETVAL

void *
nci_ptfsp( c_func, t0, f1, s2, p3 )
	SV* c_func
	char * t0
	float f1
	short s2
	void * p3
PREINIT:
	void *(*func)(char *, float, short, void *);
CODE:
	func   = INT2PTR(void *(*)(char *, float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, s2, p3);
OUTPUT:
	RETVAL

void
nci_vtfsp( c_func, t0, f1, s2, p3 )
	SV* c_func
	char * t0
	float f1
	short s2
	void * p3
PREINIT:
	void(*func)(char *, float, short, void *);
CODE:
	func   = INT2PTR(void(*)(char *, float, short, void *), SvIV(c_func) );
	(*func)(t0, f1, s2, p3);

double
nci_dtfsp( c_func, t0, f1, s2, p3 )
	SV* c_func
	char * t0
	float f1
	short s2
	void * p3
PREINIT:
	double(*func)(char *, float, short, void *);
CODE:
	func   = INT2PTR(double(*)(char *, float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, s2, p3);
OUTPUT:
	RETVAL

short
nci_stfsp( c_func, t0, f1, s2, p3 )
	SV* c_func
	char * t0
	float f1
	short s2
	void * p3
PREINIT:
	short(*func)(char *, float, short, void *);
CODE:
	func   = INT2PTR(short(*)(char *, float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, s2, p3);
OUTPUT:
	RETVAL

float
nci_ftfsp( c_func, t0, f1, s2, p3 )
	SV* c_func
	char * t0
	float f1
	short s2
	void * p3
PREINIT:
	float(*func)(char *, float, short, void *);
CODE:
	func   = INT2PTR(float(*)(char *, float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, s2, p3);
OUTPUT:
	RETVAL

char *
nci_ttfsp( c_func, t0, f1, s2, p3 )
	SV* c_func
	char * t0
	float f1
	short s2
	void * p3
PREINIT:
	char *(*func)(char *, float, short, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, s2, p3);
OUTPUT:
	RETVAL

int
nci_itfsp( c_func, t0, f1, s2, p3 )
	SV* c_func
	char * t0
	float f1
	short s2
	void * p3
PREINIT:
	int(*func)(char *, float, short, void *);
CODE:
	func   = INT2PTR(int(*)(char *, float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, s2, p3);
OUTPUT:
	RETVAL

void *
nci_pifsp( c_func, i0, f1, s2, p3 )
	SV* c_func
	int i0
	float f1
	short s2
	void * p3
PREINIT:
	void *(*func)(int, float, short, void *);
CODE:
	func   = INT2PTR(void *(*)(int, float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, s2, p3);
OUTPUT:
	RETVAL

void
nci_vifsp( c_func, i0, f1, s2, p3 )
	SV* c_func
	int i0
	float f1
	short s2
	void * p3
PREINIT:
	void(*func)(int, float, short, void *);
CODE:
	func   = INT2PTR(void(*)(int, float, short, void *), SvIV(c_func) );
	(*func)(i0, f1, s2, p3);

double
nci_difsp( c_func, i0, f1, s2, p3 )
	SV* c_func
	int i0
	float f1
	short s2
	void * p3
PREINIT:
	double(*func)(int, float, short, void *);
CODE:
	func   = INT2PTR(double(*)(int, float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, s2, p3);
OUTPUT:
	RETVAL

short
nci_sifsp( c_func, i0, f1, s2, p3 )
	SV* c_func
	int i0
	float f1
	short s2
	void * p3
PREINIT:
	short(*func)(int, float, short, void *);
CODE:
	func   = INT2PTR(short(*)(int, float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, s2, p3);
OUTPUT:
	RETVAL

float
nci_fifsp( c_func, i0, f1, s2, p3 )
	SV* c_func
	int i0
	float f1
	short s2
	void * p3
PREINIT:
	float(*func)(int, float, short, void *);
CODE:
	func   = INT2PTR(float(*)(int, float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, s2, p3);
OUTPUT:
	RETVAL

char *
nci_tifsp( c_func, i0, f1, s2, p3 )
	SV* c_func
	int i0
	float f1
	short s2
	void * p3
PREINIT:
	char *(*func)(int, float, short, void *);
CODE:
	func   = INT2PTR(char *(*)(int, float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, s2, p3);
OUTPUT:
	RETVAL

int
nci_iifsp( c_func, i0, f1, s2, p3 )
	SV* c_func
	int i0
	float f1
	short s2
	void * p3
PREINIT:
	int(*func)(int, float, short, void *);
CODE:
	func   = INT2PTR(int(*)(int, float, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, s2, p3);
OUTPUT:
	RETVAL

void *
nci_pptsp( c_func, p0, t1, s2, p3 )
	SV* c_func
	void * p0
	char * t1
	short s2
	void * p3
PREINIT:
	void *(*func)(void *, char *, short, void *);
CODE:
	func   = INT2PTR(void *(*)(void *, char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, s2, p3);
OUTPUT:
	RETVAL

void
nci_vptsp( c_func, p0, t1, s2, p3 )
	SV* c_func
	void * p0
	char * t1
	short s2
	void * p3
PREINIT:
	void(*func)(void *, char *, short, void *);
CODE:
	func   = INT2PTR(void(*)(void *, char *, short, void *), SvIV(c_func) );
	(*func)(p0, t1, s2, p3);

double
nci_dptsp( c_func, p0, t1, s2, p3 )
	SV* c_func
	void * p0
	char * t1
	short s2
	void * p3
PREINIT:
	double(*func)(void *, char *, short, void *);
CODE:
	func   = INT2PTR(double(*)(void *, char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, s2, p3);
OUTPUT:
	RETVAL

short
nci_sptsp( c_func, p0, t1, s2, p3 )
	SV* c_func
	void * p0
	char * t1
	short s2
	void * p3
PREINIT:
	short(*func)(void *, char *, short, void *);
CODE:
	func   = INT2PTR(short(*)(void *, char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, s2, p3);
OUTPUT:
	RETVAL

float
nci_fptsp( c_func, p0, t1, s2, p3 )
	SV* c_func
	void * p0
	char * t1
	short s2
	void * p3
PREINIT:
	float(*func)(void *, char *, short, void *);
CODE:
	func   = INT2PTR(float(*)(void *, char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, s2, p3);
OUTPUT:
	RETVAL

char *
nci_tptsp( c_func, p0, t1, s2, p3 )
	SV* c_func
	void * p0
	char * t1
	short s2
	void * p3
PREINIT:
	char *(*func)(void *, char *, short, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, s2, p3);
OUTPUT:
	RETVAL

int
nci_iptsp( c_func, p0, t1, s2, p3 )
	SV* c_func
	void * p0
	char * t1
	short s2
	void * p3
PREINIT:
	int(*func)(void *, char *, short, void *);
CODE:
	func   = INT2PTR(int(*)(void *, char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, s2, p3);
OUTPUT:
	RETVAL

void *
nci_pvtsp( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvtsp( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvtsp( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svtsp( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvtsp( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvtsp( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivtsp( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdtsp( c_func, d0, t1, s2, p3 )
	SV* c_func
	double d0
	char * t1
	short s2
	void * p3
PREINIT:
	void *(*func)(double, char *, short, void *);
CODE:
	func   = INT2PTR(void *(*)(double, char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, s2, p3);
OUTPUT:
	RETVAL

void
nci_vdtsp( c_func, d0, t1, s2, p3 )
	SV* c_func
	double d0
	char * t1
	short s2
	void * p3
PREINIT:
	void(*func)(double, char *, short, void *);
CODE:
	func   = INT2PTR(void(*)(double, char *, short, void *), SvIV(c_func) );
	(*func)(d0, t1, s2, p3);

double
nci_ddtsp( c_func, d0, t1, s2, p3 )
	SV* c_func
	double d0
	char * t1
	short s2
	void * p3
PREINIT:
	double(*func)(double, char *, short, void *);
CODE:
	func   = INT2PTR(double(*)(double, char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, s2, p3);
OUTPUT:
	RETVAL

short
nci_sdtsp( c_func, d0, t1, s2, p3 )
	SV* c_func
	double d0
	char * t1
	short s2
	void * p3
PREINIT:
	short(*func)(double, char *, short, void *);
CODE:
	func   = INT2PTR(short(*)(double, char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, s2, p3);
OUTPUT:
	RETVAL

float
nci_fdtsp( c_func, d0, t1, s2, p3 )
	SV* c_func
	double d0
	char * t1
	short s2
	void * p3
PREINIT:
	float(*func)(double, char *, short, void *);
CODE:
	func   = INT2PTR(float(*)(double, char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, s2, p3);
OUTPUT:
	RETVAL

char *
nci_tdtsp( c_func, d0, t1, s2, p3 )
	SV* c_func
	double d0
	char * t1
	short s2
	void * p3
PREINIT:
	char *(*func)(double, char *, short, void *);
CODE:
	func   = INT2PTR(char *(*)(double, char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, s2, p3);
OUTPUT:
	RETVAL

int
nci_idtsp( c_func, d0, t1, s2, p3 )
	SV* c_func
	double d0
	char * t1
	short s2
	void * p3
PREINIT:
	int(*func)(double, char *, short, void *);
CODE:
	func   = INT2PTR(int(*)(double, char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, s2, p3);
OUTPUT:
	RETVAL

void *
nci_pstsp( c_func, s0, t1, s2, p3 )
	SV* c_func
	short s0
	char * t1
	short s2
	void * p3
PREINIT:
	void *(*func)(short, char *, short, void *);
CODE:
	func   = INT2PTR(void *(*)(short, char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, s2, p3);
OUTPUT:
	RETVAL

void
nci_vstsp( c_func, s0, t1, s2, p3 )
	SV* c_func
	short s0
	char * t1
	short s2
	void * p3
PREINIT:
	void(*func)(short, char *, short, void *);
CODE:
	func   = INT2PTR(void(*)(short, char *, short, void *), SvIV(c_func) );
	(*func)(s0, t1, s2, p3);

double
nci_dstsp( c_func, s0, t1, s2, p3 )
	SV* c_func
	short s0
	char * t1
	short s2
	void * p3
PREINIT:
	double(*func)(short, char *, short, void *);
CODE:
	func   = INT2PTR(double(*)(short, char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, s2, p3);
OUTPUT:
	RETVAL

short
nci_sstsp( c_func, s0, t1, s2, p3 )
	SV* c_func
	short s0
	char * t1
	short s2
	void * p3
PREINIT:
	short(*func)(short, char *, short, void *);
CODE:
	func   = INT2PTR(short(*)(short, char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, s2, p3);
OUTPUT:
	RETVAL

float
nci_fstsp( c_func, s0, t1, s2, p3 )
	SV* c_func
	short s0
	char * t1
	short s2
	void * p3
PREINIT:
	float(*func)(short, char *, short, void *);
CODE:
	func   = INT2PTR(float(*)(short, char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, s2, p3);
OUTPUT:
	RETVAL

char *
nci_tstsp( c_func, s0, t1, s2, p3 )
	SV* c_func
	short s0
	char * t1
	short s2
	void * p3
PREINIT:
	char *(*func)(short, char *, short, void *);
CODE:
	func   = INT2PTR(char *(*)(short, char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, s2, p3);
OUTPUT:
	RETVAL

int
nci_istsp( c_func, s0, t1, s2, p3 )
	SV* c_func
	short s0
	char * t1
	short s2
	void * p3
PREINIT:
	int(*func)(short, char *, short, void *);
CODE:
	func   = INT2PTR(int(*)(short, char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, s2, p3);
OUTPUT:
	RETVAL

void *
nci_pftsp( c_func, f0, t1, s2, p3 )
	SV* c_func
	float f0
	char * t1
	short s2
	void * p3
PREINIT:
	void *(*func)(float, char *, short, void *);
CODE:
	func   = INT2PTR(void *(*)(float, char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, s2, p3);
OUTPUT:
	RETVAL

void
nci_vftsp( c_func, f0, t1, s2, p3 )
	SV* c_func
	float f0
	char * t1
	short s2
	void * p3
PREINIT:
	void(*func)(float, char *, short, void *);
CODE:
	func   = INT2PTR(void(*)(float, char *, short, void *), SvIV(c_func) );
	(*func)(f0, t1, s2, p3);

double
nci_dftsp( c_func, f0, t1, s2, p3 )
	SV* c_func
	float f0
	char * t1
	short s2
	void * p3
PREINIT:
	double(*func)(float, char *, short, void *);
CODE:
	func   = INT2PTR(double(*)(float, char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, s2, p3);
OUTPUT:
	RETVAL

short
nci_sftsp( c_func, f0, t1, s2, p3 )
	SV* c_func
	float f0
	char * t1
	short s2
	void * p3
PREINIT:
	short(*func)(float, char *, short, void *);
CODE:
	func   = INT2PTR(short(*)(float, char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, s2, p3);
OUTPUT:
	RETVAL

float
nci_fftsp( c_func, f0, t1, s2, p3 )
	SV* c_func
	float f0
	char * t1
	short s2
	void * p3
PREINIT:
	float(*func)(float, char *, short, void *);
CODE:
	func   = INT2PTR(float(*)(float, char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, s2, p3);
OUTPUT:
	RETVAL

char *
nci_tftsp( c_func, f0, t1, s2, p3 )
	SV* c_func
	float f0
	char * t1
	short s2
	void * p3
PREINIT:
	char *(*func)(float, char *, short, void *);
CODE:
	func   = INT2PTR(char *(*)(float, char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, s2, p3);
OUTPUT:
	RETVAL

int
nci_iftsp( c_func, f0, t1, s2, p3 )
	SV* c_func
	float f0
	char * t1
	short s2
	void * p3
PREINIT:
	int(*func)(float, char *, short, void *);
CODE:
	func   = INT2PTR(int(*)(float, char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, s2, p3);
OUTPUT:
	RETVAL

void *
nci_pttsp( c_func, t0, t1, s2, p3 )
	SV* c_func
	char * t0
	char * t1
	short s2
	void * p3
PREINIT:
	void *(*func)(char *, char *, short, void *);
CODE:
	func   = INT2PTR(void *(*)(char *, char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, s2, p3);
OUTPUT:
	RETVAL

void
nci_vttsp( c_func, t0, t1, s2, p3 )
	SV* c_func
	char * t0
	char * t1
	short s2
	void * p3
PREINIT:
	void(*func)(char *, char *, short, void *);
CODE:
	func   = INT2PTR(void(*)(char *, char *, short, void *), SvIV(c_func) );
	(*func)(t0, t1, s2, p3);

double
nci_dttsp( c_func, t0, t1, s2, p3 )
	SV* c_func
	char * t0
	char * t1
	short s2
	void * p3
PREINIT:
	double(*func)(char *, char *, short, void *);
CODE:
	func   = INT2PTR(double(*)(char *, char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, s2, p3);
OUTPUT:
	RETVAL

short
nci_sttsp( c_func, t0, t1, s2, p3 )
	SV* c_func
	char * t0
	char * t1
	short s2
	void * p3
PREINIT:
	short(*func)(char *, char *, short, void *);
CODE:
	func   = INT2PTR(short(*)(char *, char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, s2, p3);
OUTPUT:
	RETVAL

float
nci_fttsp( c_func, t0, t1, s2, p3 )
	SV* c_func
	char * t0
	char * t1
	short s2
	void * p3
PREINIT:
	float(*func)(char *, char *, short, void *);
CODE:
	func   = INT2PTR(float(*)(char *, char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, s2, p3);
OUTPUT:
	RETVAL

char *
nci_tttsp( c_func, t0, t1, s2, p3 )
	SV* c_func
	char * t0
	char * t1
	short s2
	void * p3
PREINIT:
	char *(*func)(char *, char *, short, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, s2, p3);
OUTPUT:
	RETVAL

int
nci_ittsp( c_func, t0, t1, s2, p3 )
	SV* c_func
	char * t0
	char * t1
	short s2
	void * p3
PREINIT:
	int(*func)(char *, char *, short, void *);
CODE:
	func   = INT2PTR(int(*)(char *, char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, s2, p3);
OUTPUT:
	RETVAL

void *
nci_pitsp( c_func, i0, t1, s2, p3 )
	SV* c_func
	int i0
	char * t1
	short s2
	void * p3
PREINIT:
	void *(*func)(int, char *, short, void *);
CODE:
	func   = INT2PTR(void *(*)(int, char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, s2, p3);
OUTPUT:
	RETVAL

void
nci_vitsp( c_func, i0, t1, s2, p3 )
	SV* c_func
	int i0
	char * t1
	short s2
	void * p3
PREINIT:
	void(*func)(int, char *, short, void *);
CODE:
	func   = INT2PTR(void(*)(int, char *, short, void *), SvIV(c_func) );
	(*func)(i0, t1, s2, p3);

double
nci_ditsp( c_func, i0, t1, s2, p3 )
	SV* c_func
	int i0
	char * t1
	short s2
	void * p3
PREINIT:
	double(*func)(int, char *, short, void *);
CODE:
	func   = INT2PTR(double(*)(int, char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, s2, p3);
OUTPUT:
	RETVAL

short
nci_sitsp( c_func, i0, t1, s2, p3 )
	SV* c_func
	int i0
	char * t1
	short s2
	void * p3
PREINIT:
	short(*func)(int, char *, short, void *);
CODE:
	func   = INT2PTR(short(*)(int, char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, s2, p3);
OUTPUT:
	RETVAL

float
nci_fitsp( c_func, i0, t1, s2, p3 )
	SV* c_func
	int i0
	char * t1
	short s2
	void * p3
PREINIT:
	float(*func)(int, char *, short, void *);
CODE:
	func   = INT2PTR(float(*)(int, char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, s2, p3);
OUTPUT:
	RETVAL

char *
nci_titsp( c_func, i0, t1, s2, p3 )
	SV* c_func
	int i0
	char * t1
	short s2
	void * p3
PREINIT:
	char *(*func)(int, char *, short, void *);
CODE:
	func   = INT2PTR(char *(*)(int, char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, s2, p3);
OUTPUT:
	RETVAL

int
nci_iitsp( c_func, i0, t1, s2, p3 )
	SV* c_func
	int i0
	char * t1
	short s2
	void * p3
PREINIT:
	int(*func)(int, char *, short, void *);
CODE:
	func   = INT2PTR(int(*)(int, char *, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, s2, p3);
OUTPUT:
	RETVAL

void *
nci_ppisp( c_func, p0, i1, s2, p3 )
	SV* c_func
	void * p0
	int i1
	short s2
	void * p3
PREINIT:
	void *(*func)(void *, int, short, void *);
CODE:
	func   = INT2PTR(void *(*)(void *, int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, s2, p3);
OUTPUT:
	RETVAL

void
nci_vpisp( c_func, p0, i1, s2, p3 )
	SV* c_func
	void * p0
	int i1
	short s2
	void * p3
PREINIT:
	void(*func)(void *, int, short, void *);
CODE:
	func   = INT2PTR(void(*)(void *, int, short, void *), SvIV(c_func) );
	(*func)(p0, i1, s2, p3);

double
nci_dpisp( c_func, p0, i1, s2, p3 )
	SV* c_func
	void * p0
	int i1
	short s2
	void * p3
PREINIT:
	double(*func)(void *, int, short, void *);
CODE:
	func   = INT2PTR(double(*)(void *, int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, s2, p3);
OUTPUT:
	RETVAL

short
nci_spisp( c_func, p0, i1, s2, p3 )
	SV* c_func
	void * p0
	int i1
	short s2
	void * p3
PREINIT:
	short(*func)(void *, int, short, void *);
CODE:
	func   = INT2PTR(short(*)(void *, int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, s2, p3);
OUTPUT:
	RETVAL

float
nci_fpisp( c_func, p0, i1, s2, p3 )
	SV* c_func
	void * p0
	int i1
	short s2
	void * p3
PREINIT:
	float(*func)(void *, int, short, void *);
CODE:
	func   = INT2PTR(float(*)(void *, int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, s2, p3);
OUTPUT:
	RETVAL

char *
nci_tpisp( c_func, p0, i1, s2, p3 )
	SV* c_func
	void * p0
	int i1
	short s2
	void * p3
PREINIT:
	char *(*func)(void *, int, short, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, s2, p3);
OUTPUT:
	RETVAL

int
nci_ipisp( c_func, p0, i1, s2, p3 )
	SV* c_func
	void * p0
	int i1
	short s2
	void * p3
PREINIT:
	int(*func)(void *, int, short, void *);
CODE:
	func   = INT2PTR(int(*)(void *, int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, s2, p3);
OUTPUT:
	RETVAL

void *
nci_pvisp( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvisp( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvisp( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svisp( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvisp( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvisp( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivisp( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdisp( c_func, d0, i1, s2, p3 )
	SV* c_func
	double d0
	int i1
	short s2
	void * p3
PREINIT:
	void *(*func)(double, int, short, void *);
CODE:
	func   = INT2PTR(void *(*)(double, int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, s2, p3);
OUTPUT:
	RETVAL

void
nci_vdisp( c_func, d0, i1, s2, p3 )
	SV* c_func
	double d0
	int i1
	short s2
	void * p3
PREINIT:
	void(*func)(double, int, short, void *);
CODE:
	func   = INT2PTR(void(*)(double, int, short, void *), SvIV(c_func) );
	(*func)(d0, i1, s2, p3);

double
nci_ddisp( c_func, d0, i1, s2, p3 )
	SV* c_func
	double d0
	int i1
	short s2
	void * p3
PREINIT:
	double(*func)(double, int, short, void *);
CODE:
	func   = INT2PTR(double(*)(double, int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, s2, p3);
OUTPUT:
	RETVAL

short
nci_sdisp( c_func, d0, i1, s2, p3 )
	SV* c_func
	double d0
	int i1
	short s2
	void * p3
PREINIT:
	short(*func)(double, int, short, void *);
CODE:
	func   = INT2PTR(short(*)(double, int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, s2, p3);
OUTPUT:
	RETVAL

float
nci_fdisp( c_func, d0, i1, s2, p3 )
	SV* c_func
	double d0
	int i1
	short s2
	void * p3
PREINIT:
	float(*func)(double, int, short, void *);
CODE:
	func   = INT2PTR(float(*)(double, int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, s2, p3);
OUTPUT:
	RETVAL

char *
nci_tdisp( c_func, d0, i1, s2, p3 )
	SV* c_func
	double d0
	int i1
	short s2
	void * p3
PREINIT:
	char *(*func)(double, int, short, void *);
CODE:
	func   = INT2PTR(char *(*)(double, int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, s2, p3);
OUTPUT:
	RETVAL

int
nci_idisp( c_func, d0, i1, s2, p3 )
	SV* c_func
	double d0
	int i1
	short s2
	void * p3
PREINIT:
	int(*func)(double, int, short, void *);
CODE:
	func   = INT2PTR(int(*)(double, int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, s2, p3);
OUTPUT:
	RETVAL

void *
nci_psisp( c_func, s0, i1, s2, p3 )
	SV* c_func
	short s0
	int i1
	short s2
	void * p3
PREINIT:
	void *(*func)(short, int, short, void *);
CODE:
	func   = INT2PTR(void *(*)(short, int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, s2, p3);
OUTPUT:
	RETVAL

void
nci_vsisp( c_func, s0, i1, s2, p3 )
	SV* c_func
	short s0
	int i1
	short s2
	void * p3
PREINIT:
	void(*func)(short, int, short, void *);
CODE:
	func   = INT2PTR(void(*)(short, int, short, void *), SvIV(c_func) );
	(*func)(s0, i1, s2, p3);

double
nci_dsisp( c_func, s0, i1, s2, p3 )
	SV* c_func
	short s0
	int i1
	short s2
	void * p3
PREINIT:
	double(*func)(short, int, short, void *);
CODE:
	func   = INT2PTR(double(*)(short, int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, s2, p3);
OUTPUT:
	RETVAL

short
nci_ssisp( c_func, s0, i1, s2, p3 )
	SV* c_func
	short s0
	int i1
	short s2
	void * p3
PREINIT:
	short(*func)(short, int, short, void *);
CODE:
	func   = INT2PTR(short(*)(short, int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, s2, p3);
OUTPUT:
	RETVAL

float
nci_fsisp( c_func, s0, i1, s2, p3 )
	SV* c_func
	short s0
	int i1
	short s2
	void * p3
PREINIT:
	float(*func)(short, int, short, void *);
CODE:
	func   = INT2PTR(float(*)(short, int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, s2, p3);
OUTPUT:
	RETVAL

char *
nci_tsisp( c_func, s0, i1, s2, p3 )
	SV* c_func
	short s0
	int i1
	short s2
	void * p3
PREINIT:
	char *(*func)(short, int, short, void *);
CODE:
	func   = INT2PTR(char *(*)(short, int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, s2, p3);
OUTPUT:
	RETVAL

int
nci_isisp( c_func, s0, i1, s2, p3 )
	SV* c_func
	short s0
	int i1
	short s2
	void * p3
PREINIT:
	int(*func)(short, int, short, void *);
CODE:
	func   = INT2PTR(int(*)(short, int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, s2, p3);
OUTPUT:
	RETVAL

void *
nci_pfisp( c_func, f0, i1, s2, p3 )
	SV* c_func
	float f0
	int i1
	short s2
	void * p3
PREINIT:
	void *(*func)(float, int, short, void *);
CODE:
	func   = INT2PTR(void *(*)(float, int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, s2, p3);
OUTPUT:
	RETVAL

void
nci_vfisp( c_func, f0, i1, s2, p3 )
	SV* c_func
	float f0
	int i1
	short s2
	void * p3
PREINIT:
	void(*func)(float, int, short, void *);
CODE:
	func   = INT2PTR(void(*)(float, int, short, void *), SvIV(c_func) );
	(*func)(f0, i1, s2, p3);

double
nci_dfisp( c_func, f0, i1, s2, p3 )
	SV* c_func
	float f0
	int i1
	short s2
	void * p3
PREINIT:
	double(*func)(float, int, short, void *);
CODE:
	func   = INT2PTR(double(*)(float, int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, s2, p3);
OUTPUT:
	RETVAL

short
nci_sfisp( c_func, f0, i1, s2, p3 )
	SV* c_func
	float f0
	int i1
	short s2
	void * p3
PREINIT:
	short(*func)(float, int, short, void *);
CODE:
	func   = INT2PTR(short(*)(float, int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, s2, p3);
OUTPUT:
	RETVAL

float
nci_ffisp( c_func, f0, i1, s2, p3 )
	SV* c_func
	float f0
	int i1
	short s2
	void * p3
PREINIT:
	float(*func)(float, int, short, void *);
CODE:
	func   = INT2PTR(float(*)(float, int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, s2, p3);
OUTPUT:
	RETVAL

char *
nci_tfisp( c_func, f0, i1, s2, p3 )
	SV* c_func
	float f0
	int i1
	short s2
	void * p3
PREINIT:
	char *(*func)(float, int, short, void *);
CODE:
	func   = INT2PTR(char *(*)(float, int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, s2, p3);
OUTPUT:
	RETVAL

int
nci_ifisp( c_func, f0, i1, s2, p3 )
	SV* c_func
	float f0
	int i1
	short s2
	void * p3
PREINIT:
	int(*func)(float, int, short, void *);
CODE:
	func   = INT2PTR(int(*)(float, int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, s2, p3);
OUTPUT:
	RETVAL

void *
nci_ptisp( c_func, t0, i1, s2, p3 )
	SV* c_func
	char * t0
	int i1
	short s2
	void * p3
PREINIT:
	void *(*func)(char *, int, short, void *);
CODE:
	func   = INT2PTR(void *(*)(char *, int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, s2, p3);
OUTPUT:
	RETVAL

void
nci_vtisp( c_func, t0, i1, s2, p3 )
	SV* c_func
	char * t0
	int i1
	short s2
	void * p3
PREINIT:
	void(*func)(char *, int, short, void *);
CODE:
	func   = INT2PTR(void(*)(char *, int, short, void *), SvIV(c_func) );
	(*func)(t0, i1, s2, p3);

double
nci_dtisp( c_func, t0, i1, s2, p3 )
	SV* c_func
	char * t0
	int i1
	short s2
	void * p3
PREINIT:
	double(*func)(char *, int, short, void *);
CODE:
	func   = INT2PTR(double(*)(char *, int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, s2, p3);
OUTPUT:
	RETVAL

short
nci_stisp( c_func, t0, i1, s2, p3 )
	SV* c_func
	char * t0
	int i1
	short s2
	void * p3
PREINIT:
	short(*func)(char *, int, short, void *);
CODE:
	func   = INT2PTR(short(*)(char *, int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, s2, p3);
OUTPUT:
	RETVAL

float
nci_ftisp( c_func, t0, i1, s2, p3 )
	SV* c_func
	char * t0
	int i1
	short s2
	void * p3
PREINIT:
	float(*func)(char *, int, short, void *);
CODE:
	func   = INT2PTR(float(*)(char *, int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, s2, p3);
OUTPUT:
	RETVAL

char *
nci_ttisp( c_func, t0, i1, s2, p3 )
	SV* c_func
	char * t0
	int i1
	short s2
	void * p3
PREINIT:
	char *(*func)(char *, int, short, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, s2, p3);
OUTPUT:
	RETVAL

int
nci_itisp( c_func, t0, i1, s2, p3 )
	SV* c_func
	char * t0
	int i1
	short s2
	void * p3
PREINIT:
	int(*func)(char *, int, short, void *);
CODE:
	func   = INT2PTR(int(*)(char *, int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, s2, p3);
OUTPUT:
	RETVAL

void *
nci_piisp( c_func, i0, i1, s2, p3 )
	SV* c_func
	int i0
	int i1
	short s2
	void * p3
PREINIT:
	void *(*func)(int, int, short, void *);
CODE:
	func   = INT2PTR(void *(*)(int, int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, s2, p3);
OUTPUT:
	RETVAL

void
nci_viisp( c_func, i0, i1, s2, p3 )
	SV* c_func
	int i0
	int i1
	short s2
	void * p3
PREINIT:
	void(*func)(int, int, short, void *);
CODE:
	func   = INT2PTR(void(*)(int, int, short, void *), SvIV(c_func) );
	(*func)(i0, i1, s2, p3);

double
nci_diisp( c_func, i0, i1, s2, p3 )
	SV* c_func
	int i0
	int i1
	short s2
	void * p3
PREINIT:
	double(*func)(int, int, short, void *);
CODE:
	func   = INT2PTR(double(*)(int, int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, s2, p3);
OUTPUT:
	RETVAL

short
nci_siisp( c_func, i0, i1, s2, p3 )
	SV* c_func
	int i0
	int i1
	short s2
	void * p3
PREINIT:
	short(*func)(int, int, short, void *);
CODE:
	func   = INT2PTR(short(*)(int, int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, s2, p3);
OUTPUT:
	RETVAL

float
nci_fiisp( c_func, i0, i1, s2, p3 )
	SV* c_func
	int i0
	int i1
	short s2
	void * p3
PREINIT:
	float(*func)(int, int, short, void *);
CODE:
	func   = INT2PTR(float(*)(int, int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, s2, p3);
OUTPUT:
	RETVAL

char *
nci_tiisp( c_func, i0, i1, s2, p3 )
	SV* c_func
	int i0
	int i1
	short s2
	void * p3
PREINIT:
	char *(*func)(int, int, short, void *);
CODE:
	func   = INT2PTR(char *(*)(int, int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, s2, p3);
OUTPUT:
	RETVAL

int
nci_iiisp( c_func, i0, i1, s2, p3 )
	SV* c_func
	int i0
	int i1
	short s2
	void * p3
PREINIT:
	int(*func)(int, int, short, void *);
CODE:
	func   = INT2PTR(int(*)(int, int, short, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, s2, p3);
OUTPUT:
	RETVAL

void *
nci_pppfp( c_func, p0, p1, f2, p3 )
	SV* c_func
	void * p0
	void * p1
	float f2
	void * p3
PREINIT:
	void *(*func)(void *, void *, float, void *);
CODE:
	func   = INT2PTR(void *(*)(void *, void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, f2, p3);
OUTPUT:
	RETVAL

void
nci_vppfp( c_func, p0, p1, f2, p3 )
	SV* c_func
	void * p0
	void * p1
	float f2
	void * p3
PREINIT:
	void(*func)(void *, void *, float, void *);
CODE:
	func   = INT2PTR(void(*)(void *, void *, float, void *), SvIV(c_func) );
	(*func)(p0, p1, f2, p3);

double
nci_dppfp( c_func, p0, p1, f2, p3 )
	SV* c_func
	void * p0
	void * p1
	float f2
	void * p3
PREINIT:
	double(*func)(void *, void *, float, void *);
CODE:
	func   = INT2PTR(double(*)(void *, void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, f2, p3);
OUTPUT:
	RETVAL

short
nci_sppfp( c_func, p0, p1, f2, p3 )
	SV* c_func
	void * p0
	void * p1
	float f2
	void * p3
PREINIT:
	short(*func)(void *, void *, float, void *);
CODE:
	func   = INT2PTR(short(*)(void *, void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, f2, p3);
OUTPUT:
	RETVAL

float
nci_fppfp( c_func, p0, p1, f2, p3 )
	SV* c_func
	void * p0
	void * p1
	float f2
	void * p3
PREINIT:
	float(*func)(void *, void *, float, void *);
CODE:
	func   = INT2PTR(float(*)(void *, void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, f2, p3);
OUTPUT:
	RETVAL

char *
nci_tppfp( c_func, p0, p1, f2, p3 )
	SV* c_func
	void * p0
	void * p1
	float f2
	void * p3
PREINIT:
	char *(*func)(void *, void *, float, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, f2, p3);
OUTPUT:
	RETVAL

int
nci_ippfp( c_func, p0, p1, f2, p3 )
	SV* c_func
	void * p0
	void * p1
	float f2
	void * p3
PREINIT:
	int(*func)(void *, void *, float, void *);
CODE:
	func   = INT2PTR(int(*)(void *, void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, f2, p3);
OUTPUT:
	RETVAL

void *
nci_pvpfp( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvpfp( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvpfp( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svpfp( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvpfp( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvpfp( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivpfp( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdpfp( c_func, d0, p1, f2, p3 )
	SV* c_func
	double d0
	void * p1
	float f2
	void * p3
PREINIT:
	void *(*func)(double, void *, float, void *);
CODE:
	func   = INT2PTR(void *(*)(double, void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, f2, p3);
OUTPUT:
	RETVAL

void
nci_vdpfp( c_func, d0, p1, f2, p3 )
	SV* c_func
	double d0
	void * p1
	float f2
	void * p3
PREINIT:
	void(*func)(double, void *, float, void *);
CODE:
	func   = INT2PTR(void(*)(double, void *, float, void *), SvIV(c_func) );
	(*func)(d0, p1, f2, p3);

double
nci_ddpfp( c_func, d0, p1, f2, p3 )
	SV* c_func
	double d0
	void * p1
	float f2
	void * p3
PREINIT:
	double(*func)(double, void *, float, void *);
CODE:
	func   = INT2PTR(double(*)(double, void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, f2, p3);
OUTPUT:
	RETVAL

short
nci_sdpfp( c_func, d0, p1, f2, p3 )
	SV* c_func
	double d0
	void * p1
	float f2
	void * p3
PREINIT:
	short(*func)(double, void *, float, void *);
CODE:
	func   = INT2PTR(short(*)(double, void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, f2, p3);
OUTPUT:
	RETVAL

float
nci_fdpfp( c_func, d0, p1, f2, p3 )
	SV* c_func
	double d0
	void * p1
	float f2
	void * p3
PREINIT:
	float(*func)(double, void *, float, void *);
CODE:
	func   = INT2PTR(float(*)(double, void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, f2, p3);
OUTPUT:
	RETVAL

char *
nci_tdpfp( c_func, d0, p1, f2, p3 )
	SV* c_func
	double d0
	void * p1
	float f2
	void * p3
PREINIT:
	char *(*func)(double, void *, float, void *);
CODE:
	func   = INT2PTR(char *(*)(double, void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, f2, p3);
OUTPUT:
	RETVAL

int
nci_idpfp( c_func, d0, p1, f2, p3 )
	SV* c_func
	double d0
	void * p1
	float f2
	void * p3
PREINIT:
	int(*func)(double, void *, float, void *);
CODE:
	func   = INT2PTR(int(*)(double, void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, f2, p3);
OUTPUT:
	RETVAL

void *
nci_pspfp( c_func, s0, p1, f2, p3 )
	SV* c_func
	short s0
	void * p1
	float f2
	void * p3
PREINIT:
	void *(*func)(short, void *, float, void *);
CODE:
	func   = INT2PTR(void *(*)(short, void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, f2, p3);
OUTPUT:
	RETVAL

void
nci_vspfp( c_func, s0, p1, f2, p3 )
	SV* c_func
	short s0
	void * p1
	float f2
	void * p3
PREINIT:
	void(*func)(short, void *, float, void *);
CODE:
	func   = INT2PTR(void(*)(short, void *, float, void *), SvIV(c_func) );
	(*func)(s0, p1, f2, p3);

double
nci_dspfp( c_func, s0, p1, f2, p3 )
	SV* c_func
	short s0
	void * p1
	float f2
	void * p3
PREINIT:
	double(*func)(short, void *, float, void *);
CODE:
	func   = INT2PTR(double(*)(short, void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, f2, p3);
OUTPUT:
	RETVAL

short
nci_sspfp( c_func, s0, p1, f2, p3 )
	SV* c_func
	short s0
	void * p1
	float f2
	void * p3
PREINIT:
	short(*func)(short, void *, float, void *);
CODE:
	func   = INT2PTR(short(*)(short, void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, f2, p3);
OUTPUT:
	RETVAL

float
nci_fspfp( c_func, s0, p1, f2, p3 )
	SV* c_func
	short s0
	void * p1
	float f2
	void * p3
PREINIT:
	float(*func)(short, void *, float, void *);
CODE:
	func   = INT2PTR(float(*)(short, void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, f2, p3);
OUTPUT:
	RETVAL

char *
nci_tspfp( c_func, s0, p1, f2, p3 )
	SV* c_func
	short s0
	void * p1
	float f2
	void * p3
PREINIT:
	char *(*func)(short, void *, float, void *);
CODE:
	func   = INT2PTR(char *(*)(short, void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, f2, p3);
OUTPUT:
	RETVAL

int
nci_ispfp( c_func, s0, p1, f2, p3 )
	SV* c_func
	short s0
	void * p1
	float f2
	void * p3
PREINIT:
	int(*func)(short, void *, float, void *);
CODE:
	func   = INT2PTR(int(*)(short, void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, f2, p3);
OUTPUT:
	RETVAL

void *
nci_pfpfp( c_func, f0, p1, f2, p3 )
	SV* c_func
	float f0
	void * p1
	float f2
	void * p3
PREINIT:
	void *(*func)(float, void *, float, void *);
CODE:
	func   = INT2PTR(void *(*)(float, void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, f2, p3);
OUTPUT:
	RETVAL

void
nci_vfpfp( c_func, f0, p1, f2, p3 )
	SV* c_func
	float f0
	void * p1
	float f2
	void * p3
PREINIT:
	void(*func)(float, void *, float, void *);
CODE:
	func   = INT2PTR(void(*)(float, void *, float, void *), SvIV(c_func) );
	(*func)(f0, p1, f2, p3);

double
nci_dfpfp( c_func, f0, p1, f2, p3 )
	SV* c_func
	float f0
	void * p1
	float f2
	void * p3
PREINIT:
	double(*func)(float, void *, float, void *);
CODE:
	func   = INT2PTR(double(*)(float, void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, f2, p3);
OUTPUT:
	RETVAL

short
nci_sfpfp( c_func, f0, p1, f2, p3 )
	SV* c_func
	float f0
	void * p1
	float f2
	void * p3
PREINIT:
	short(*func)(float, void *, float, void *);
CODE:
	func   = INT2PTR(short(*)(float, void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, f2, p3);
OUTPUT:
	RETVAL

float
nci_ffpfp( c_func, f0, p1, f2, p3 )
	SV* c_func
	float f0
	void * p1
	float f2
	void * p3
PREINIT:
	float(*func)(float, void *, float, void *);
CODE:
	func   = INT2PTR(float(*)(float, void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, f2, p3);
OUTPUT:
	RETVAL

char *
nci_tfpfp( c_func, f0, p1, f2, p3 )
	SV* c_func
	float f0
	void * p1
	float f2
	void * p3
PREINIT:
	char *(*func)(float, void *, float, void *);
CODE:
	func   = INT2PTR(char *(*)(float, void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, f2, p3);
OUTPUT:
	RETVAL

int
nci_ifpfp( c_func, f0, p1, f2, p3 )
	SV* c_func
	float f0
	void * p1
	float f2
	void * p3
PREINIT:
	int(*func)(float, void *, float, void *);
CODE:
	func   = INT2PTR(int(*)(float, void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, f2, p3);
OUTPUT:
	RETVAL

void *
nci_ptpfp( c_func, t0, p1, f2, p3 )
	SV* c_func
	char * t0
	void * p1
	float f2
	void * p3
PREINIT:
	void *(*func)(char *, void *, float, void *);
CODE:
	func   = INT2PTR(void *(*)(char *, void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, f2, p3);
OUTPUT:
	RETVAL

void
nci_vtpfp( c_func, t0, p1, f2, p3 )
	SV* c_func
	char * t0
	void * p1
	float f2
	void * p3
PREINIT:
	void(*func)(char *, void *, float, void *);
CODE:
	func   = INT2PTR(void(*)(char *, void *, float, void *), SvIV(c_func) );
	(*func)(t0, p1, f2, p3);

double
nci_dtpfp( c_func, t0, p1, f2, p3 )
	SV* c_func
	char * t0
	void * p1
	float f2
	void * p3
PREINIT:
	double(*func)(char *, void *, float, void *);
CODE:
	func   = INT2PTR(double(*)(char *, void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, f2, p3);
OUTPUT:
	RETVAL

short
nci_stpfp( c_func, t0, p1, f2, p3 )
	SV* c_func
	char * t0
	void * p1
	float f2
	void * p3
PREINIT:
	short(*func)(char *, void *, float, void *);
CODE:
	func   = INT2PTR(short(*)(char *, void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, f2, p3);
OUTPUT:
	RETVAL

float
nci_ftpfp( c_func, t0, p1, f2, p3 )
	SV* c_func
	char * t0
	void * p1
	float f2
	void * p3
PREINIT:
	float(*func)(char *, void *, float, void *);
CODE:
	func   = INT2PTR(float(*)(char *, void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, f2, p3);
OUTPUT:
	RETVAL

char *
nci_ttpfp( c_func, t0, p1, f2, p3 )
	SV* c_func
	char * t0
	void * p1
	float f2
	void * p3
PREINIT:
	char *(*func)(char *, void *, float, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, f2, p3);
OUTPUT:
	RETVAL

int
nci_itpfp( c_func, t0, p1, f2, p3 )
	SV* c_func
	char * t0
	void * p1
	float f2
	void * p3
PREINIT:
	int(*func)(char *, void *, float, void *);
CODE:
	func   = INT2PTR(int(*)(char *, void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, f2, p3);
OUTPUT:
	RETVAL

void *
nci_pipfp( c_func, i0, p1, f2, p3 )
	SV* c_func
	int i0
	void * p1
	float f2
	void * p3
PREINIT:
	void *(*func)(int, void *, float, void *);
CODE:
	func   = INT2PTR(void *(*)(int, void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, f2, p3);
OUTPUT:
	RETVAL

void
nci_vipfp( c_func, i0, p1, f2, p3 )
	SV* c_func
	int i0
	void * p1
	float f2
	void * p3
PREINIT:
	void(*func)(int, void *, float, void *);
CODE:
	func   = INT2PTR(void(*)(int, void *, float, void *), SvIV(c_func) );
	(*func)(i0, p1, f2, p3);

double
nci_dipfp( c_func, i0, p1, f2, p3 )
	SV* c_func
	int i0
	void * p1
	float f2
	void * p3
PREINIT:
	double(*func)(int, void *, float, void *);
CODE:
	func   = INT2PTR(double(*)(int, void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, f2, p3);
OUTPUT:
	RETVAL

short
nci_sipfp( c_func, i0, p1, f2, p3 )
	SV* c_func
	int i0
	void * p1
	float f2
	void * p3
PREINIT:
	short(*func)(int, void *, float, void *);
CODE:
	func   = INT2PTR(short(*)(int, void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, f2, p3);
OUTPUT:
	RETVAL

float
nci_fipfp( c_func, i0, p1, f2, p3 )
	SV* c_func
	int i0
	void * p1
	float f2
	void * p3
PREINIT:
	float(*func)(int, void *, float, void *);
CODE:
	func   = INT2PTR(float(*)(int, void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, f2, p3);
OUTPUT:
	RETVAL

char *
nci_tipfp( c_func, i0, p1, f2, p3 )
	SV* c_func
	int i0
	void * p1
	float f2
	void * p3
PREINIT:
	char *(*func)(int, void *, float, void *);
CODE:
	func   = INT2PTR(char *(*)(int, void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, f2, p3);
OUTPUT:
	RETVAL

int
nci_iipfp( c_func, i0, p1, f2, p3 )
	SV* c_func
	int i0
	void * p1
	float f2
	void * p3
PREINIT:
	int(*func)(int, void *, float, void *);
CODE:
	func   = INT2PTR(int(*)(int, void *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, f2, p3);
OUTPUT:
	RETVAL

void *
nci_ppdfp( c_func, p0, d1, f2, p3 )
	SV* c_func
	void * p0
	double d1
	float f2
	void * p3
PREINIT:
	void *(*func)(void *, double, float, void *);
CODE:
	func   = INT2PTR(void *(*)(void *, double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, f2, p3);
OUTPUT:
	RETVAL

void
nci_vpdfp( c_func, p0, d1, f2, p3 )
	SV* c_func
	void * p0
	double d1
	float f2
	void * p3
PREINIT:
	void(*func)(void *, double, float, void *);
CODE:
	func   = INT2PTR(void(*)(void *, double, float, void *), SvIV(c_func) );
	(*func)(p0, d1, f2, p3);

double
nci_dpdfp( c_func, p0, d1, f2, p3 )
	SV* c_func
	void * p0
	double d1
	float f2
	void * p3
PREINIT:
	double(*func)(void *, double, float, void *);
CODE:
	func   = INT2PTR(double(*)(void *, double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, f2, p3);
OUTPUT:
	RETVAL

short
nci_spdfp( c_func, p0, d1, f2, p3 )
	SV* c_func
	void * p0
	double d1
	float f2
	void * p3
PREINIT:
	short(*func)(void *, double, float, void *);
CODE:
	func   = INT2PTR(short(*)(void *, double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, f2, p3);
OUTPUT:
	RETVAL

float
nci_fpdfp( c_func, p0, d1, f2, p3 )
	SV* c_func
	void * p0
	double d1
	float f2
	void * p3
PREINIT:
	float(*func)(void *, double, float, void *);
CODE:
	func   = INT2PTR(float(*)(void *, double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, f2, p3);
OUTPUT:
	RETVAL

char *
nci_tpdfp( c_func, p0, d1, f2, p3 )
	SV* c_func
	void * p0
	double d1
	float f2
	void * p3
PREINIT:
	char *(*func)(void *, double, float, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, f2, p3);
OUTPUT:
	RETVAL

int
nci_ipdfp( c_func, p0, d1, f2, p3 )
	SV* c_func
	void * p0
	double d1
	float f2
	void * p3
PREINIT:
	int(*func)(void *, double, float, void *);
CODE:
	func   = INT2PTR(int(*)(void *, double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, f2, p3);
OUTPUT:
	RETVAL

void *
nci_pvdfp( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvdfp( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvdfp( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svdfp( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvdfp( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvdfp( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivdfp( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pddfp( c_func, d0, d1, f2, p3 )
	SV* c_func
	double d0
	double d1
	float f2
	void * p3
PREINIT:
	void *(*func)(double, double, float, void *);
CODE:
	func   = INT2PTR(void *(*)(double, double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, f2, p3);
OUTPUT:
	RETVAL

void
nci_vddfp( c_func, d0, d1, f2, p3 )
	SV* c_func
	double d0
	double d1
	float f2
	void * p3
PREINIT:
	void(*func)(double, double, float, void *);
CODE:
	func   = INT2PTR(void(*)(double, double, float, void *), SvIV(c_func) );
	(*func)(d0, d1, f2, p3);

double
nci_dddfp( c_func, d0, d1, f2, p3 )
	SV* c_func
	double d0
	double d1
	float f2
	void * p3
PREINIT:
	double(*func)(double, double, float, void *);
CODE:
	func   = INT2PTR(double(*)(double, double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, f2, p3);
OUTPUT:
	RETVAL

short
nci_sddfp( c_func, d0, d1, f2, p3 )
	SV* c_func
	double d0
	double d1
	float f2
	void * p3
PREINIT:
	short(*func)(double, double, float, void *);
CODE:
	func   = INT2PTR(short(*)(double, double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, f2, p3);
OUTPUT:
	RETVAL

float
nci_fddfp( c_func, d0, d1, f2, p3 )
	SV* c_func
	double d0
	double d1
	float f2
	void * p3
PREINIT:
	float(*func)(double, double, float, void *);
CODE:
	func   = INT2PTR(float(*)(double, double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, f2, p3);
OUTPUT:
	RETVAL

char *
nci_tddfp( c_func, d0, d1, f2, p3 )
	SV* c_func
	double d0
	double d1
	float f2
	void * p3
PREINIT:
	char *(*func)(double, double, float, void *);
CODE:
	func   = INT2PTR(char *(*)(double, double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, f2, p3);
OUTPUT:
	RETVAL

int
nci_iddfp( c_func, d0, d1, f2, p3 )
	SV* c_func
	double d0
	double d1
	float f2
	void * p3
PREINIT:
	int(*func)(double, double, float, void *);
CODE:
	func   = INT2PTR(int(*)(double, double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, f2, p3);
OUTPUT:
	RETVAL

void *
nci_psdfp( c_func, s0, d1, f2, p3 )
	SV* c_func
	short s0
	double d1
	float f2
	void * p3
PREINIT:
	void *(*func)(short, double, float, void *);
CODE:
	func   = INT2PTR(void *(*)(short, double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, f2, p3);
OUTPUT:
	RETVAL

void
nci_vsdfp( c_func, s0, d1, f2, p3 )
	SV* c_func
	short s0
	double d1
	float f2
	void * p3
PREINIT:
	void(*func)(short, double, float, void *);
CODE:
	func   = INT2PTR(void(*)(short, double, float, void *), SvIV(c_func) );
	(*func)(s0, d1, f2, p3);

double
nci_dsdfp( c_func, s0, d1, f2, p3 )
	SV* c_func
	short s0
	double d1
	float f2
	void * p3
PREINIT:
	double(*func)(short, double, float, void *);
CODE:
	func   = INT2PTR(double(*)(short, double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, f2, p3);
OUTPUT:
	RETVAL

short
nci_ssdfp( c_func, s0, d1, f2, p3 )
	SV* c_func
	short s0
	double d1
	float f2
	void * p3
PREINIT:
	short(*func)(short, double, float, void *);
CODE:
	func   = INT2PTR(short(*)(short, double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, f2, p3);
OUTPUT:
	RETVAL

float
nci_fsdfp( c_func, s0, d1, f2, p3 )
	SV* c_func
	short s0
	double d1
	float f2
	void * p3
PREINIT:
	float(*func)(short, double, float, void *);
CODE:
	func   = INT2PTR(float(*)(short, double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, f2, p3);
OUTPUT:
	RETVAL

char *
nci_tsdfp( c_func, s0, d1, f2, p3 )
	SV* c_func
	short s0
	double d1
	float f2
	void * p3
PREINIT:
	char *(*func)(short, double, float, void *);
CODE:
	func   = INT2PTR(char *(*)(short, double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, f2, p3);
OUTPUT:
	RETVAL

int
nci_isdfp( c_func, s0, d1, f2, p3 )
	SV* c_func
	short s0
	double d1
	float f2
	void * p3
PREINIT:
	int(*func)(short, double, float, void *);
CODE:
	func   = INT2PTR(int(*)(short, double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, f2, p3);
OUTPUT:
	RETVAL

void *
nci_pfdfp( c_func, f0, d1, f2, p3 )
	SV* c_func
	float f0
	double d1
	float f2
	void * p3
PREINIT:
	void *(*func)(float, double, float, void *);
CODE:
	func   = INT2PTR(void *(*)(float, double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, f2, p3);
OUTPUT:
	RETVAL

void
nci_vfdfp( c_func, f0, d1, f2, p3 )
	SV* c_func
	float f0
	double d1
	float f2
	void * p3
PREINIT:
	void(*func)(float, double, float, void *);
CODE:
	func   = INT2PTR(void(*)(float, double, float, void *), SvIV(c_func) );
	(*func)(f0, d1, f2, p3);

double
nci_dfdfp( c_func, f0, d1, f2, p3 )
	SV* c_func
	float f0
	double d1
	float f2
	void * p3
PREINIT:
	double(*func)(float, double, float, void *);
CODE:
	func   = INT2PTR(double(*)(float, double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, f2, p3);
OUTPUT:
	RETVAL

short
nci_sfdfp( c_func, f0, d1, f2, p3 )
	SV* c_func
	float f0
	double d1
	float f2
	void * p3
PREINIT:
	short(*func)(float, double, float, void *);
CODE:
	func   = INT2PTR(short(*)(float, double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, f2, p3);
OUTPUT:
	RETVAL

float
nci_ffdfp( c_func, f0, d1, f2, p3 )
	SV* c_func
	float f0
	double d1
	float f2
	void * p3
PREINIT:
	float(*func)(float, double, float, void *);
CODE:
	func   = INT2PTR(float(*)(float, double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, f2, p3);
OUTPUT:
	RETVAL

char *
nci_tfdfp( c_func, f0, d1, f2, p3 )
	SV* c_func
	float f0
	double d1
	float f2
	void * p3
PREINIT:
	char *(*func)(float, double, float, void *);
CODE:
	func   = INT2PTR(char *(*)(float, double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, f2, p3);
OUTPUT:
	RETVAL

int
nci_ifdfp( c_func, f0, d1, f2, p3 )
	SV* c_func
	float f0
	double d1
	float f2
	void * p3
PREINIT:
	int(*func)(float, double, float, void *);
CODE:
	func   = INT2PTR(int(*)(float, double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, f2, p3);
OUTPUT:
	RETVAL

void *
nci_ptdfp( c_func, t0, d1, f2, p3 )
	SV* c_func
	char * t0
	double d1
	float f2
	void * p3
PREINIT:
	void *(*func)(char *, double, float, void *);
CODE:
	func   = INT2PTR(void *(*)(char *, double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, f2, p3);
OUTPUT:
	RETVAL

void
nci_vtdfp( c_func, t0, d1, f2, p3 )
	SV* c_func
	char * t0
	double d1
	float f2
	void * p3
PREINIT:
	void(*func)(char *, double, float, void *);
CODE:
	func   = INT2PTR(void(*)(char *, double, float, void *), SvIV(c_func) );
	(*func)(t0, d1, f2, p3);

double
nci_dtdfp( c_func, t0, d1, f2, p3 )
	SV* c_func
	char * t0
	double d1
	float f2
	void * p3
PREINIT:
	double(*func)(char *, double, float, void *);
CODE:
	func   = INT2PTR(double(*)(char *, double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, f2, p3);
OUTPUT:
	RETVAL

short
nci_stdfp( c_func, t0, d1, f2, p3 )
	SV* c_func
	char * t0
	double d1
	float f2
	void * p3
PREINIT:
	short(*func)(char *, double, float, void *);
CODE:
	func   = INT2PTR(short(*)(char *, double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, f2, p3);
OUTPUT:
	RETVAL

float
nci_ftdfp( c_func, t0, d1, f2, p3 )
	SV* c_func
	char * t0
	double d1
	float f2
	void * p3
PREINIT:
	float(*func)(char *, double, float, void *);
CODE:
	func   = INT2PTR(float(*)(char *, double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, f2, p3);
OUTPUT:
	RETVAL

char *
nci_ttdfp( c_func, t0, d1, f2, p3 )
	SV* c_func
	char * t0
	double d1
	float f2
	void * p3
PREINIT:
	char *(*func)(char *, double, float, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, f2, p3);
OUTPUT:
	RETVAL

int
nci_itdfp( c_func, t0, d1, f2, p3 )
	SV* c_func
	char * t0
	double d1
	float f2
	void * p3
PREINIT:
	int(*func)(char *, double, float, void *);
CODE:
	func   = INT2PTR(int(*)(char *, double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, f2, p3);
OUTPUT:
	RETVAL

void *
nci_pidfp( c_func, i0, d1, f2, p3 )
	SV* c_func
	int i0
	double d1
	float f2
	void * p3
PREINIT:
	void *(*func)(int, double, float, void *);
CODE:
	func   = INT2PTR(void *(*)(int, double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, f2, p3);
OUTPUT:
	RETVAL

void
nci_vidfp( c_func, i0, d1, f2, p3 )
	SV* c_func
	int i0
	double d1
	float f2
	void * p3
PREINIT:
	void(*func)(int, double, float, void *);
CODE:
	func   = INT2PTR(void(*)(int, double, float, void *), SvIV(c_func) );
	(*func)(i0, d1, f2, p3);

double
nci_didfp( c_func, i0, d1, f2, p3 )
	SV* c_func
	int i0
	double d1
	float f2
	void * p3
PREINIT:
	double(*func)(int, double, float, void *);
CODE:
	func   = INT2PTR(double(*)(int, double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, f2, p3);
OUTPUT:
	RETVAL

short
nci_sidfp( c_func, i0, d1, f2, p3 )
	SV* c_func
	int i0
	double d1
	float f2
	void * p3
PREINIT:
	short(*func)(int, double, float, void *);
CODE:
	func   = INT2PTR(short(*)(int, double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, f2, p3);
OUTPUT:
	RETVAL

float
nci_fidfp( c_func, i0, d1, f2, p3 )
	SV* c_func
	int i0
	double d1
	float f2
	void * p3
PREINIT:
	float(*func)(int, double, float, void *);
CODE:
	func   = INT2PTR(float(*)(int, double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, f2, p3);
OUTPUT:
	RETVAL

char *
nci_tidfp( c_func, i0, d1, f2, p3 )
	SV* c_func
	int i0
	double d1
	float f2
	void * p3
PREINIT:
	char *(*func)(int, double, float, void *);
CODE:
	func   = INT2PTR(char *(*)(int, double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, f2, p3);
OUTPUT:
	RETVAL

int
nci_iidfp( c_func, i0, d1, f2, p3 )
	SV* c_func
	int i0
	double d1
	float f2
	void * p3
PREINIT:
	int(*func)(int, double, float, void *);
CODE:
	func   = INT2PTR(int(*)(int, double, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, f2, p3);
OUTPUT:
	RETVAL

void *
nci_ppsfp( c_func, p0, s1, f2, p3 )
	SV* c_func
	void * p0
	short s1
	float f2
	void * p3
PREINIT:
	void *(*func)(void *, short, float, void *);
CODE:
	func   = INT2PTR(void *(*)(void *, short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, f2, p3);
OUTPUT:
	RETVAL

void
nci_vpsfp( c_func, p0, s1, f2, p3 )
	SV* c_func
	void * p0
	short s1
	float f2
	void * p3
PREINIT:
	void(*func)(void *, short, float, void *);
CODE:
	func   = INT2PTR(void(*)(void *, short, float, void *), SvIV(c_func) );
	(*func)(p0, s1, f2, p3);

double
nci_dpsfp( c_func, p0, s1, f2, p3 )
	SV* c_func
	void * p0
	short s1
	float f2
	void * p3
PREINIT:
	double(*func)(void *, short, float, void *);
CODE:
	func   = INT2PTR(double(*)(void *, short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, f2, p3);
OUTPUT:
	RETVAL

short
nci_spsfp( c_func, p0, s1, f2, p3 )
	SV* c_func
	void * p0
	short s1
	float f2
	void * p3
PREINIT:
	short(*func)(void *, short, float, void *);
CODE:
	func   = INT2PTR(short(*)(void *, short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, f2, p3);
OUTPUT:
	RETVAL

float
nci_fpsfp( c_func, p0, s1, f2, p3 )
	SV* c_func
	void * p0
	short s1
	float f2
	void * p3
PREINIT:
	float(*func)(void *, short, float, void *);
CODE:
	func   = INT2PTR(float(*)(void *, short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, f2, p3);
OUTPUT:
	RETVAL

char *
nci_tpsfp( c_func, p0, s1, f2, p3 )
	SV* c_func
	void * p0
	short s1
	float f2
	void * p3
PREINIT:
	char *(*func)(void *, short, float, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, f2, p3);
OUTPUT:
	RETVAL

int
nci_ipsfp( c_func, p0, s1, f2, p3 )
	SV* c_func
	void * p0
	short s1
	float f2
	void * p3
PREINIT:
	int(*func)(void *, short, float, void *);
CODE:
	func   = INT2PTR(int(*)(void *, short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, f2, p3);
OUTPUT:
	RETVAL

void *
nci_pvsfp( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvsfp( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvsfp( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svsfp( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvsfp( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvsfp( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivsfp( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdsfp( c_func, d0, s1, f2, p3 )
	SV* c_func
	double d0
	short s1
	float f2
	void * p3
PREINIT:
	void *(*func)(double, short, float, void *);
CODE:
	func   = INT2PTR(void *(*)(double, short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, f2, p3);
OUTPUT:
	RETVAL

void
nci_vdsfp( c_func, d0, s1, f2, p3 )
	SV* c_func
	double d0
	short s1
	float f2
	void * p3
PREINIT:
	void(*func)(double, short, float, void *);
CODE:
	func   = INT2PTR(void(*)(double, short, float, void *), SvIV(c_func) );
	(*func)(d0, s1, f2, p3);

double
nci_ddsfp( c_func, d0, s1, f2, p3 )
	SV* c_func
	double d0
	short s1
	float f2
	void * p3
PREINIT:
	double(*func)(double, short, float, void *);
CODE:
	func   = INT2PTR(double(*)(double, short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, f2, p3);
OUTPUT:
	RETVAL

short
nci_sdsfp( c_func, d0, s1, f2, p3 )
	SV* c_func
	double d0
	short s1
	float f2
	void * p3
PREINIT:
	short(*func)(double, short, float, void *);
CODE:
	func   = INT2PTR(short(*)(double, short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, f2, p3);
OUTPUT:
	RETVAL

float
nci_fdsfp( c_func, d0, s1, f2, p3 )
	SV* c_func
	double d0
	short s1
	float f2
	void * p3
PREINIT:
	float(*func)(double, short, float, void *);
CODE:
	func   = INT2PTR(float(*)(double, short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, f2, p3);
OUTPUT:
	RETVAL

char *
nci_tdsfp( c_func, d0, s1, f2, p3 )
	SV* c_func
	double d0
	short s1
	float f2
	void * p3
PREINIT:
	char *(*func)(double, short, float, void *);
CODE:
	func   = INT2PTR(char *(*)(double, short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, f2, p3);
OUTPUT:
	RETVAL

int
nci_idsfp( c_func, d0, s1, f2, p3 )
	SV* c_func
	double d0
	short s1
	float f2
	void * p3
PREINIT:
	int(*func)(double, short, float, void *);
CODE:
	func   = INT2PTR(int(*)(double, short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, f2, p3);
OUTPUT:
	RETVAL

void *
nci_pssfp( c_func, s0, s1, f2, p3 )
	SV* c_func
	short s0
	short s1
	float f2
	void * p3
PREINIT:
	void *(*func)(short, short, float, void *);
CODE:
	func   = INT2PTR(void *(*)(short, short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, f2, p3);
OUTPUT:
	RETVAL

void
nci_vssfp( c_func, s0, s1, f2, p3 )
	SV* c_func
	short s0
	short s1
	float f2
	void * p3
PREINIT:
	void(*func)(short, short, float, void *);
CODE:
	func   = INT2PTR(void(*)(short, short, float, void *), SvIV(c_func) );
	(*func)(s0, s1, f2, p3);

double
nci_dssfp( c_func, s0, s1, f2, p3 )
	SV* c_func
	short s0
	short s1
	float f2
	void * p3
PREINIT:
	double(*func)(short, short, float, void *);
CODE:
	func   = INT2PTR(double(*)(short, short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, f2, p3);
OUTPUT:
	RETVAL

short
nci_sssfp( c_func, s0, s1, f2, p3 )
	SV* c_func
	short s0
	short s1
	float f2
	void * p3
PREINIT:
	short(*func)(short, short, float, void *);
CODE:
	func   = INT2PTR(short(*)(short, short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, f2, p3);
OUTPUT:
	RETVAL

float
nci_fssfp( c_func, s0, s1, f2, p3 )
	SV* c_func
	short s0
	short s1
	float f2
	void * p3
PREINIT:
	float(*func)(short, short, float, void *);
CODE:
	func   = INT2PTR(float(*)(short, short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, f2, p3);
OUTPUT:
	RETVAL

char *
nci_tssfp( c_func, s0, s1, f2, p3 )
	SV* c_func
	short s0
	short s1
	float f2
	void * p3
PREINIT:
	char *(*func)(short, short, float, void *);
CODE:
	func   = INT2PTR(char *(*)(short, short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, f2, p3);
OUTPUT:
	RETVAL

int
nci_issfp( c_func, s0, s1, f2, p3 )
	SV* c_func
	short s0
	short s1
	float f2
	void * p3
PREINIT:
	int(*func)(short, short, float, void *);
CODE:
	func   = INT2PTR(int(*)(short, short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, f2, p3);
OUTPUT:
	RETVAL

void *
nci_pfsfp( c_func, f0, s1, f2, p3 )
	SV* c_func
	float f0
	short s1
	float f2
	void * p3
PREINIT:
	void *(*func)(float, short, float, void *);
CODE:
	func   = INT2PTR(void *(*)(float, short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, f2, p3);
OUTPUT:
	RETVAL

void
nci_vfsfp( c_func, f0, s1, f2, p3 )
	SV* c_func
	float f0
	short s1
	float f2
	void * p3
PREINIT:
	void(*func)(float, short, float, void *);
CODE:
	func   = INT2PTR(void(*)(float, short, float, void *), SvIV(c_func) );
	(*func)(f0, s1, f2, p3);

double
nci_dfsfp( c_func, f0, s1, f2, p3 )
	SV* c_func
	float f0
	short s1
	float f2
	void * p3
PREINIT:
	double(*func)(float, short, float, void *);
CODE:
	func   = INT2PTR(double(*)(float, short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, f2, p3);
OUTPUT:
	RETVAL

short
nci_sfsfp( c_func, f0, s1, f2, p3 )
	SV* c_func
	float f0
	short s1
	float f2
	void * p3
PREINIT:
	short(*func)(float, short, float, void *);
CODE:
	func   = INT2PTR(short(*)(float, short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, f2, p3);
OUTPUT:
	RETVAL

float
nci_ffsfp( c_func, f0, s1, f2, p3 )
	SV* c_func
	float f0
	short s1
	float f2
	void * p3
PREINIT:
	float(*func)(float, short, float, void *);
CODE:
	func   = INT2PTR(float(*)(float, short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, f2, p3);
OUTPUT:
	RETVAL

char *
nci_tfsfp( c_func, f0, s1, f2, p3 )
	SV* c_func
	float f0
	short s1
	float f2
	void * p3
PREINIT:
	char *(*func)(float, short, float, void *);
CODE:
	func   = INT2PTR(char *(*)(float, short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, f2, p3);
OUTPUT:
	RETVAL

int
nci_ifsfp( c_func, f0, s1, f2, p3 )
	SV* c_func
	float f0
	short s1
	float f2
	void * p3
PREINIT:
	int(*func)(float, short, float, void *);
CODE:
	func   = INT2PTR(int(*)(float, short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, f2, p3);
OUTPUT:
	RETVAL

void *
nci_ptsfp( c_func, t0, s1, f2, p3 )
	SV* c_func
	char * t0
	short s1
	float f2
	void * p3
PREINIT:
	void *(*func)(char *, short, float, void *);
CODE:
	func   = INT2PTR(void *(*)(char *, short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, f2, p3);
OUTPUT:
	RETVAL

void
nci_vtsfp( c_func, t0, s1, f2, p3 )
	SV* c_func
	char * t0
	short s1
	float f2
	void * p3
PREINIT:
	void(*func)(char *, short, float, void *);
CODE:
	func   = INT2PTR(void(*)(char *, short, float, void *), SvIV(c_func) );
	(*func)(t0, s1, f2, p3);

double
nci_dtsfp( c_func, t0, s1, f2, p3 )
	SV* c_func
	char * t0
	short s1
	float f2
	void * p3
PREINIT:
	double(*func)(char *, short, float, void *);
CODE:
	func   = INT2PTR(double(*)(char *, short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, f2, p3);
OUTPUT:
	RETVAL

short
nci_stsfp( c_func, t0, s1, f2, p3 )
	SV* c_func
	char * t0
	short s1
	float f2
	void * p3
PREINIT:
	short(*func)(char *, short, float, void *);
CODE:
	func   = INT2PTR(short(*)(char *, short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, f2, p3);
OUTPUT:
	RETVAL

float
nci_ftsfp( c_func, t0, s1, f2, p3 )
	SV* c_func
	char * t0
	short s1
	float f2
	void * p3
PREINIT:
	float(*func)(char *, short, float, void *);
CODE:
	func   = INT2PTR(float(*)(char *, short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, f2, p3);
OUTPUT:
	RETVAL

char *
nci_ttsfp( c_func, t0, s1, f2, p3 )
	SV* c_func
	char * t0
	short s1
	float f2
	void * p3
PREINIT:
	char *(*func)(char *, short, float, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, f2, p3);
OUTPUT:
	RETVAL

int
nci_itsfp( c_func, t0, s1, f2, p3 )
	SV* c_func
	char * t0
	short s1
	float f2
	void * p3
PREINIT:
	int(*func)(char *, short, float, void *);
CODE:
	func   = INT2PTR(int(*)(char *, short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, f2, p3);
OUTPUT:
	RETVAL

void *
nci_pisfp( c_func, i0, s1, f2, p3 )
	SV* c_func
	int i0
	short s1
	float f2
	void * p3
PREINIT:
	void *(*func)(int, short, float, void *);
CODE:
	func   = INT2PTR(void *(*)(int, short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, f2, p3);
OUTPUT:
	RETVAL

void
nci_visfp( c_func, i0, s1, f2, p3 )
	SV* c_func
	int i0
	short s1
	float f2
	void * p3
PREINIT:
	void(*func)(int, short, float, void *);
CODE:
	func   = INT2PTR(void(*)(int, short, float, void *), SvIV(c_func) );
	(*func)(i0, s1, f2, p3);

double
nci_disfp( c_func, i0, s1, f2, p3 )
	SV* c_func
	int i0
	short s1
	float f2
	void * p3
PREINIT:
	double(*func)(int, short, float, void *);
CODE:
	func   = INT2PTR(double(*)(int, short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, f2, p3);
OUTPUT:
	RETVAL

short
nci_sisfp( c_func, i0, s1, f2, p3 )
	SV* c_func
	int i0
	short s1
	float f2
	void * p3
PREINIT:
	short(*func)(int, short, float, void *);
CODE:
	func   = INT2PTR(short(*)(int, short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, f2, p3);
OUTPUT:
	RETVAL

float
nci_fisfp( c_func, i0, s1, f2, p3 )
	SV* c_func
	int i0
	short s1
	float f2
	void * p3
PREINIT:
	float(*func)(int, short, float, void *);
CODE:
	func   = INT2PTR(float(*)(int, short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, f2, p3);
OUTPUT:
	RETVAL

char *
nci_tisfp( c_func, i0, s1, f2, p3 )
	SV* c_func
	int i0
	short s1
	float f2
	void * p3
PREINIT:
	char *(*func)(int, short, float, void *);
CODE:
	func   = INT2PTR(char *(*)(int, short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, f2, p3);
OUTPUT:
	RETVAL

int
nci_iisfp( c_func, i0, s1, f2, p3 )
	SV* c_func
	int i0
	short s1
	float f2
	void * p3
PREINIT:
	int(*func)(int, short, float, void *);
CODE:
	func   = INT2PTR(int(*)(int, short, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, f2, p3);
OUTPUT:
	RETVAL

void *
nci_ppffp( c_func, p0, f1, f2, p3 )
	SV* c_func
	void * p0
	float f1
	float f2
	void * p3
PREINIT:
	void *(*func)(void *, float, float, void *);
CODE:
	func   = INT2PTR(void *(*)(void *, float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, f2, p3);
OUTPUT:
	RETVAL

void
nci_vpffp( c_func, p0, f1, f2, p3 )
	SV* c_func
	void * p0
	float f1
	float f2
	void * p3
PREINIT:
	void(*func)(void *, float, float, void *);
CODE:
	func   = INT2PTR(void(*)(void *, float, float, void *), SvIV(c_func) );
	(*func)(p0, f1, f2, p3);

double
nci_dpffp( c_func, p0, f1, f2, p3 )
	SV* c_func
	void * p0
	float f1
	float f2
	void * p3
PREINIT:
	double(*func)(void *, float, float, void *);
CODE:
	func   = INT2PTR(double(*)(void *, float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, f2, p3);
OUTPUT:
	RETVAL

short
nci_spffp( c_func, p0, f1, f2, p3 )
	SV* c_func
	void * p0
	float f1
	float f2
	void * p3
PREINIT:
	short(*func)(void *, float, float, void *);
CODE:
	func   = INT2PTR(short(*)(void *, float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, f2, p3);
OUTPUT:
	RETVAL

float
nci_fpffp( c_func, p0, f1, f2, p3 )
	SV* c_func
	void * p0
	float f1
	float f2
	void * p3
PREINIT:
	float(*func)(void *, float, float, void *);
CODE:
	func   = INT2PTR(float(*)(void *, float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, f2, p3);
OUTPUT:
	RETVAL

char *
nci_tpffp( c_func, p0, f1, f2, p3 )
	SV* c_func
	void * p0
	float f1
	float f2
	void * p3
PREINIT:
	char *(*func)(void *, float, float, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, f2, p3);
OUTPUT:
	RETVAL

int
nci_ipffp( c_func, p0, f1, f2, p3 )
	SV* c_func
	void * p0
	float f1
	float f2
	void * p3
PREINIT:
	int(*func)(void *, float, float, void *);
CODE:
	func   = INT2PTR(int(*)(void *, float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, f2, p3);
OUTPUT:
	RETVAL

void *
nci_pvffp( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvffp( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvffp( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svffp( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvffp( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvffp( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivffp( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdffp( c_func, d0, f1, f2, p3 )
	SV* c_func
	double d0
	float f1
	float f2
	void * p3
PREINIT:
	void *(*func)(double, float, float, void *);
CODE:
	func   = INT2PTR(void *(*)(double, float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, f2, p3);
OUTPUT:
	RETVAL

void
nci_vdffp( c_func, d0, f1, f2, p3 )
	SV* c_func
	double d0
	float f1
	float f2
	void * p3
PREINIT:
	void(*func)(double, float, float, void *);
CODE:
	func   = INT2PTR(void(*)(double, float, float, void *), SvIV(c_func) );
	(*func)(d0, f1, f2, p3);

double
nci_ddffp( c_func, d0, f1, f2, p3 )
	SV* c_func
	double d0
	float f1
	float f2
	void * p3
PREINIT:
	double(*func)(double, float, float, void *);
CODE:
	func   = INT2PTR(double(*)(double, float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, f2, p3);
OUTPUT:
	RETVAL

short
nci_sdffp( c_func, d0, f1, f2, p3 )
	SV* c_func
	double d0
	float f1
	float f2
	void * p3
PREINIT:
	short(*func)(double, float, float, void *);
CODE:
	func   = INT2PTR(short(*)(double, float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, f2, p3);
OUTPUT:
	RETVAL

float
nci_fdffp( c_func, d0, f1, f2, p3 )
	SV* c_func
	double d0
	float f1
	float f2
	void * p3
PREINIT:
	float(*func)(double, float, float, void *);
CODE:
	func   = INT2PTR(float(*)(double, float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, f2, p3);
OUTPUT:
	RETVAL

char *
nci_tdffp( c_func, d0, f1, f2, p3 )
	SV* c_func
	double d0
	float f1
	float f2
	void * p3
PREINIT:
	char *(*func)(double, float, float, void *);
CODE:
	func   = INT2PTR(char *(*)(double, float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, f2, p3);
OUTPUT:
	RETVAL

int
nci_idffp( c_func, d0, f1, f2, p3 )
	SV* c_func
	double d0
	float f1
	float f2
	void * p3
PREINIT:
	int(*func)(double, float, float, void *);
CODE:
	func   = INT2PTR(int(*)(double, float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, f2, p3);
OUTPUT:
	RETVAL

void *
nci_psffp( c_func, s0, f1, f2, p3 )
	SV* c_func
	short s0
	float f1
	float f2
	void * p3
PREINIT:
	void *(*func)(short, float, float, void *);
CODE:
	func   = INT2PTR(void *(*)(short, float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, f2, p3);
OUTPUT:
	RETVAL

void
nci_vsffp( c_func, s0, f1, f2, p3 )
	SV* c_func
	short s0
	float f1
	float f2
	void * p3
PREINIT:
	void(*func)(short, float, float, void *);
CODE:
	func   = INT2PTR(void(*)(short, float, float, void *), SvIV(c_func) );
	(*func)(s0, f1, f2, p3);

double
nci_dsffp( c_func, s0, f1, f2, p3 )
	SV* c_func
	short s0
	float f1
	float f2
	void * p3
PREINIT:
	double(*func)(short, float, float, void *);
CODE:
	func   = INT2PTR(double(*)(short, float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, f2, p3);
OUTPUT:
	RETVAL

short
nci_ssffp( c_func, s0, f1, f2, p3 )
	SV* c_func
	short s0
	float f1
	float f2
	void * p3
PREINIT:
	short(*func)(short, float, float, void *);
CODE:
	func   = INT2PTR(short(*)(short, float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, f2, p3);
OUTPUT:
	RETVAL

float
nci_fsffp( c_func, s0, f1, f2, p3 )
	SV* c_func
	short s0
	float f1
	float f2
	void * p3
PREINIT:
	float(*func)(short, float, float, void *);
CODE:
	func   = INT2PTR(float(*)(short, float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, f2, p3);
OUTPUT:
	RETVAL

char *
nci_tsffp( c_func, s0, f1, f2, p3 )
	SV* c_func
	short s0
	float f1
	float f2
	void * p3
PREINIT:
	char *(*func)(short, float, float, void *);
CODE:
	func   = INT2PTR(char *(*)(short, float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, f2, p3);
OUTPUT:
	RETVAL

int
nci_isffp( c_func, s0, f1, f2, p3 )
	SV* c_func
	short s0
	float f1
	float f2
	void * p3
PREINIT:
	int(*func)(short, float, float, void *);
CODE:
	func   = INT2PTR(int(*)(short, float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, f2, p3);
OUTPUT:
	RETVAL

void *
nci_pfffp( c_func, f0, f1, f2, p3 )
	SV* c_func
	float f0
	float f1
	float f2
	void * p3
PREINIT:
	void *(*func)(float, float, float, void *);
CODE:
	func   = INT2PTR(void *(*)(float, float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, f2, p3);
OUTPUT:
	RETVAL

void
nci_vfffp( c_func, f0, f1, f2, p3 )
	SV* c_func
	float f0
	float f1
	float f2
	void * p3
PREINIT:
	void(*func)(float, float, float, void *);
CODE:
	func   = INT2PTR(void(*)(float, float, float, void *), SvIV(c_func) );
	(*func)(f0, f1, f2, p3);

double
nci_dfffp( c_func, f0, f1, f2, p3 )
	SV* c_func
	float f0
	float f1
	float f2
	void * p3
PREINIT:
	double(*func)(float, float, float, void *);
CODE:
	func   = INT2PTR(double(*)(float, float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, f2, p3);
OUTPUT:
	RETVAL

short
nci_sfffp( c_func, f0, f1, f2, p3 )
	SV* c_func
	float f0
	float f1
	float f2
	void * p3
PREINIT:
	short(*func)(float, float, float, void *);
CODE:
	func   = INT2PTR(short(*)(float, float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, f2, p3);
OUTPUT:
	RETVAL

float
nci_ffffp( c_func, f0, f1, f2, p3 )
	SV* c_func
	float f0
	float f1
	float f2
	void * p3
PREINIT:
	float(*func)(float, float, float, void *);
CODE:
	func   = INT2PTR(float(*)(float, float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, f2, p3);
OUTPUT:
	RETVAL

char *
nci_tfffp( c_func, f0, f1, f2, p3 )
	SV* c_func
	float f0
	float f1
	float f2
	void * p3
PREINIT:
	char *(*func)(float, float, float, void *);
CODE:
	func   = INT2PTR(char *(*)(float, float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, f2, p3);
OUTPUT:
	RETVAL

int
nci_ifffp( c_func, f0, f1, f2, p3 )
	SV* c_func
	float f0
	float f1
	float f2
	void * p3
PREINIT:
	int(*func)(float, float, float, void *);
CODE:
	func   = INT2PTR(int(*)(float, float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, f2, p3);
OUTPUT:
	RETVAL

void *
nci_ptffp( c_func, t0, f1, f2, p3 )
	SV* c_func
	char * t0
	float f1
	float f2
	void * p3
PREINIT:
	void *(*func)(char *, float, float, void *);
CODE:
	func   = INT2PTR(void *(*)(char *, float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, f2, p3);
OUTPUT:
	RETVAL

void
nci_vtffp( c_func, t0, f1, f2, p3 )
	SV* c_func
	char * t0
	float f1
	float f2
	void * p3
PREINIT:
	void(*func)(char *, float, float, void *);
CODE:
	func   = INT2PTR(void(*)(char *, float, float, void *), SvIV(c_func) );
	(*func)(t0, f1, f2, p3);

double
nci_dtffp( c_func, t0, f1, f2, p3 )
	SV* c_func
	char * t0
	float f1
	float f2
	void * p3
PREINIT:
	double(*func)(char *, float, float, void *);
CODE:
	func   = INT2PTR(double(*)(char *, float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, f2, p3);
OUTPUT:
	RETVAL

short
nci_stffp( c_func, t0, f1, f2, p3 )
	SV* c_func
	char * t0
	float f1
	float f2
	void * p3
PREINIT:
	short(*func)(char *, float, float, void *);
CODE:
	func   = INT2PTR(short(*)(char *, float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, f2, p3);
OUTPUT:
	RETVAL

float
nci_ftffp( c_func, t0, f1, f2, p3 )
	SV* c_func
	char * t0
	float f1
	float f2
	void * p3
PREINIT:
	float(*func)(char *, float, float, void *);
CODE:
	func   = INT2PTR(float(*)(char *, float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, f2, p3);
OUTPUT:
	RETVAL

char *
nci_ttffp( c_func, t0, f1, f2, p3 )
	SV* c_func
	char * t0
	float f1
	float f2
	void * p3
PREINIT:
	char *(*func)(char *, float, float, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, f2, p3);
OUTPUT:
	RETVAL

int
nci_itffp( c_func, t0, f1, f2, p3 )
	SV* c_func
	char * t0
	float f1
	float f2
	void * p3
PREINIT:
	int(*func)(char *, float, float, void *);
CODE:
	func   = INT2PTR(int(*)(char *, float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, f2, p3);
OUTPUT:
	RETVAL

void *
nci_piffp( c_func, i0, f1, f2, p3 )
	SV* c_func
	int i0
	float f1
	float f2
	void * p3
PREINIT:
	void *(*func)(int, float, float, void *);
CODE:
	func   = INT2PTR(void *(*)(int, float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, f2, p3);
OUTPUT:
	RETVAL

void
nci_viffp( c_func, i0, f1, f2, p3 )
	SV* c_func
	int i0
	float f1
	float f2
	void * p3
PREINIT:
	void(*func)(int, float, float, void *);
CODE:
	func   = INT2PTR(void(*)(int, float, float, void *), SvIV(c_func) );
	(*func)(i0, f1, f2, p3);

double
nci_diffp( c_func, i0, f1, f2, p3 )
	SV* c_func
	int i0
	float f1
	float f2
	void * p3
PREINIT:
	double(*func)(int, float, float, void *);
CODE:
	func   = INT2PTR(double(*)(int, float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, f2, p3);
OUTPUT:
	RETVAL

short
nci_siffp( c_func, i0, f1, f2, p3 )
	SV* c_func
	int i0
	float f1
	float f2
	void * p3
PREINIT:
	short(*func)(int, float, float, void *);
CODE:
	func   = INT2PTR(short(*)(int, float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, f2, p3);
OUTPUT:
	RETVAL

float
nci_fiffp( c_func, i0, f1, f2, p3 )
	SV* c_func
	int i0
	float f1
	float f2
	void * p3
PREINIT:
	float(*func)(int, float, float, void *);
CODE:
	func   = INT2PTR(float(*)(int, float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, f2, p3);
OUTPUT:
	RETVAL

char *
nci_tiffp( c_func, i0, f1, f2, p3 )
	SV* c_func
	int i0
	float f1
	float f2
	void * p3
PREINIT:
	char *(*func)(int, float, float, void *);
CODE:
	func   = INT2PTR(char *(*)(int, float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, f2, p3);
OUTPUT:
	RETVAL

int
nci_iiffp( c_func, i0, f1, f2, p3 )
	SV* c_func
	int i0
	float f1
	float f2
	void * p3
PREINIT:
	int(*func)(int, float, float, void *);
CODE:
	func   = INT2PTR(int(*)(int, float, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, f2, p3);
OUTPUT:
	RETVAL

void *
nci_pptfp( c_func, p0, t1, f2, p3 )
	SV* c_func
	void * p0
	char * t1
	float f2
	void * p3
PREINIT:
	void *(*func)(void *, char *, float, void *);
CODE:
	func   = INT2PTR(void *(*)(void *, char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, f2, p3);
OUTPUT:
	RETVAL

void
nci_vptfp( c_func, p0, t1, f2, p3 )
	SV* c_func
	void * p0
	char * t1
	float f2
	void * p3
PREINIT:
	void(*func)(void *, char *, float, void *);
CODE:
	func   = INT2PTR(void(*)(void *, char *, float, void *), SvIV(c_func) );
	(*func)(p0, t1, f2, p3);

double
nci_dptfp( c_func, p0, t1, f2, p3 )
	SV* c_func
	void * p0
	char * t1
	float f2
	void * p3
PREINIT:
	double(*func)(void *, char *, float, void *);
CODE:
	func   = INT2PTR(double(*)(void *, char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, f2, p3);
OUTPUT:
	RETVAL

short
nci_sptfp( c_func, p0, t1, f2, p3 )
	SV* c_func
	void * p0
	char * t1
	float f2
	void * p3
PREINIT:
	short(*func)(void *, char *, float, void *);
CODE:
	func   = INT2PTR(short(*)(void *, char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, f2, p3);
OUTPUT:
	RETVAL

float
nci_fptfp( c_func, p0, t1, f2, p3 )
	SV* c_func
	void * p0
	char * t1
	float f2
	void * p3
PREINIT:
	float(*func)(void *, char *, float, void *);
CODE:
	func   = INT2PTR(float(*)(void *, char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, f2, p3);
OUTPUT:
	RETVAL

char *
nci_tptfp( c_func, p0, t1, f2, p3 )
	SV* c_func
	void * p0
	char * t1
	float f2
	void * p3
PREINIT:
	char *(*func)(void *, char *, float, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, f2, p3);
OUTPUT:
	RETVAL

int
nci_iptfp( c_func, p0, t1, f2, p3 )
	SV* c_func
	void * p0
	char * t1
	float f2
	void * p3
PREINIT:
	int(*func)(void *, char *, float, void *);
CODE:
	func   = INT2PTR(int(*)(void *, char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, f2, p3);
OUTPUT:
	RETVAL

void *
nci_pvtfp( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvtfp( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvtfp( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svtfp( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvtfp( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvtfp( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivtfp( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdtfp( c_func, d0, t1, f2, p3 )
	SV* c_func
	double d0
	char * t1
	float f2
	void * p3
PREINIT:
	void *(*func)(double, char *, float, void *);
CODE:
	func   = INT2PTR(void *(*)(double, char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, f2, p3);
OUTPUT:
	RETVAL

void
nci_vdtfp( c_func, d0, t1, f2, p3 )
	SV* c_func
	double d0
	char * t1
	float f2
	void * p3
PREINIT:
	void(*func)(double, char *, float, void *);
CODE:
	func   = INT2PTR(void(*)(double, char *, float, void *), SvIV(c_func) );
	(*func)(d0, t1, f2, p3);

double
nci_ddtfp( c_func, d0, t1, f2, p3 )
	SV* c_func
	double d0
	char * t1
	float f2
	void * p3
PREINIT:
	double(*func)(double, char *, float, void *);
CODE:
	func   = INT2PTR(double(*)(double, char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, f2, p3);
OUTPUT:
	RETVAL

short
nci_sdtfp( c_func, d0, t1, f2, p3 )
	SV* c_func
	double d0
	char * t1
	float f2
	void * p3
PREINIT:
	short(*func)(double, char *, float, void *);
CODE:
	func   = INT2PTR(short(*)(double, char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, f2, p3);
OUTPUT:
	RETVAL

float
nci_fdtfp( c_func, d0, t1, f2, p3 )
	SV* c_func
	double d0
	char * t1
	float f2
	void * p3
PREINIT:
	float(*func)(double, char *, float, void *);
CODE:
	func   = INT2PTR(float(*)(double, char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, f2, p3);
OUTPUT:
	RETVAL

char *
nci_tdtfp( c_func, d0, t1, f2, p3 )
	SV* c_func
	double d0
	char * t1
	float f2
	void * p3
PREINIT:
	char *(*func)(double, char *, float, void *);
CODE:
	func   = INT2PTR(char *(*)(double, char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, f2, p3);
OUTPUT:
	RETVAL

int
nci_idtfp( c_func, d0, t1, f2, p3 )
	SV* c_func
	double d0
	char * t1
	float f2
	void * p3
PREINIT:
	int(*func)(double, char *, float, void *);
CODE:
	func   = INT2PTR(int(*)(double, char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, f2, p3);
OUTPUT:
	RETVAL

void *
nci_pstfp( c_func, s0, t1, f2, p3 )
	SV* c_func
	short s0
	char * t1
	float f2
	void * p3
PREINIT:
	void *(*func)(short, char *, float, void *);
CODE:
	func   = INT2PTR(void *(*)(short, char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, f2, p3);
OUTPUT:
	RETVAL

void
nci_vstfp( c_func, s0, t1, f2, p3 )
	SV* c_func
	short s0
	char * t1
	float f2
	void * p3
PREINIT:
	void(*func)(short, char *, float, void *);
CODE:
	func   = INT2PTR(void(*)(short, char *, float, void *), SvIV(c_func) );
	(*func)(s0, t1, f2, p3);

double
nci_dstfp( c_func, s0, t1, f2, p3 )
	SV* c_func
	short s0
	char * t1
	float f2
	void * p3
PREINIT:
	double(*func)(short, char *, float, void *);
CODE:
	func   = INT2PTR(double(*)(short, char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, f2, p3);
OUTPUT:
	RETVAL

short
nci_sstfp( c_func, s0, t1, f2, p3 )
	SV* c_func
	short s0
	char * t1
	float f2
	void * p3
PREINIT:
	short(*func)(short, char *, float, void *);
CODE:
	func   = INT2PTR(short(*)(short, char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, f2, p3);
OUTPUT:
	RETVAL

float
nci_fstfp( c_func, s0, t1, f2, p3 )
	SV* c_func
	short s0
	char * t1
	float f2
	void * p3
PREINIT:
	float(*func)(short, char *, float, void *);
CODE:
	func   = INT2PTR(float(*)(short, char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, f2, p3);
OUTPUT:
	RETVAL

char *
nci_tstfp( c_func, s0, t1, f2, p3 )
	SV* c_func
	short s0
	char * t1
	float f2
	void * p3
PREINIT:
	char *(*func)(short, char *, float, void *);
CODE:
	func   = INT2PTR(char *(*)(short, char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, f2, p3);
OUTPUT:
	RETVAL

int
nci_istfp( c_func, s0, t1, f2, p3 )
	SV* c_func
	short s0
	char * t1
	float f2
	void * p3
PREINIT:
	int(*func)(short, char *, float, void *);
CODE:
	func   = INT2PTR(int(*)(short, char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, f2, p3);
OUTPUT:
	RETVAL

void *
nci_pftfp( c_func, f0, t1, f2, p3 )
	SV* c_func
	float f0
	char * t1
	float f2
	void * p3
PREINIT:
	void *(*func)(float, char *, float, void *);
CODE:
	func   = INT2PTR(void *(*)(float, char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, f2, p3);
OUTPUT:
	RETVAL

void
nci_vftfp( c_func, f0, t1, f2, p3 )
	SV* c_func
	float f0
	char * t1
	float f2
	void * p3
PREINIT:
	void(*func)(float, char *, float, void *);
CODE:
	func   = INT2PTR(void(*)(float, char *, float, void *), SvIV(c_func) );
	(*func)(f0, t1, f2, p3);

double
nci_dftfp( c_func, f0, t1, f2, p3 )
	SV* c_func
	float f0
	char * t1
	float f2
	void * p3
PREINIT:
	double(*func)(float, char *, float, void *);
CODE:
	func   = INT2PTR(double(*)(float, char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, f2, p3);
OUTPUT:
	RETVAL

short
nci_sftfp( c_func, f0, t1, f2, p3 )
	SV* c_func
	float f0
	char * t1
	float f2
	void * p3
PREINIT:
	short(*func)(float, char *, float, void *);
CODE:
	func   = INT2PTR(short(*)(float, char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, f2, p3);
OUTPUT:
	RETVAL

float
nci_fftfp( c_func, f0, t1, f2, p3 )
	SV* c_func
	float f0
	char * t1
	float f2
	void * p3
PREINIT:
	float(*func)(float, char *, float, void *);
CODE:
	func   = INT2PTR(float(*)(float, char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, f2, p3);
OUTPUT:
	RETVAL

char *
nci_tftfp( c_func, f0, t1, f2, p3 )
	SV* c_func
	float f0
	char * t1
	float f2
	void * p3
PREINIT:
	char *(*func)(float, char *, float, void *);
CODE:
	func   = INT2PTR(char *(*)(float, char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, f2, p3);
OUTPUT:
	RETVAL

int
nci_iftfp( c_func, f0, t1, f2, p3 )
	SV* c_func
	float f0
	char * t1
	float f2
	void * p3
PREINIT:
	int(*func)(float, char *, float, void *);
CODE:
	func   = INT2PTR(int(*)(float, char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, f2, p3);
OUTPUT:
	RETVAL

void *
nci_pttfp( c_func, t0, t1, f2, p3 )
	SV* c_func
	char * t0
	char * t1
	float f2
	void * p3
PREINIT:
	void *(*func)(char *, char *, float, void *);
CODE:
	func   = INT2PTR(void *(*)(char *, char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, f2, p3);
OUTPUT:
	RETVAL

void
nci_vttfp( c_func, t0, t1, f2, p3 )
	SV* c_func
	char * t0
	char * t1
	float f2
	void * p3
PREINIT:
	void(*func)(char *, char *, float, void *);
CODE:
	func   = INT2PTR(void(*)(char *, char *, float, void *), SvIV(c_func) );
	(*func)(t0, t1, f2, p3);

double
nci_dttfp( c_func, t0, t1, f2, p3 )
	SV* c_func
	char * t0
	char * t1
	float f2
	void * p3
PREINIT:
	double(*func)(char *, char *, float, void *);
CODE:
	func   = INT2PTR(double(*)(char *, char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, f2, p3);
OUTPUT:
	RETVAL

short
nci_sttfp( c_func, t0, t1, f2, p3 )
	SV* c_func
	char * t0
	char * t1
	float f2
	void * p3
PREINIT:
	short(*func)(char *, char *, float, void *);
CODE:
	func   = INT2PTR(short(*)(char *, char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, f2, p3);
OUTPUT:
	RETVAL

float
nci_fttfp( c_func, t0, t1, f2, p3 )
	SV* c_func
	char * t0
	char * t1
	float f2
	void * p3
PREINIT:
	float(*func)(char *, char *, float, void *);
CODE:
	func   = INT2PTR(float(*)(char *, char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, f2, p3);
OUTPUT:
	RETVAL

char *
nci_tttfp( c_func, t0, t1, f2, p3 )
	SV* c_func
	char * t0
	char * t1
	float f2
	void * p3
PREINIT:
	char *(*func)(char *, char *, float, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, f2, p3);
OUTPUT:
	RETVAL

int
nci_ittfp( c_func, t0, t1, f2, p3 )
	SV* c_func
	char * t0
	char * t1
	float f2
	void * p3
PREINIT:
	int(*func)(char *, char *, float, void *);
CODE:
	func   = INT2PTR(int(*)(char *, char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, f2, p3);
OUTPUT:
	RETVAL

void *
nci_pitfp( c_func, i0, t1, f2, p3 )
	SV* c_func
	int i0
	char * t1
	float f2
	void * p3
PREINIT:
	void *(*func)(int, char *, float, void *);
CODE:
	func   = INT2PTR(void *(*)(int, char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, f2, p3);
OUTPUT:
	RETVAL

void
nci_vitfp( c_func, i0, t1, f2, p3 )
	SV* c_func
	int i0
	char * t1
	float f2
	void * p3
PREINIT:
	void(*func)(int, char *, float, void *);
CODE:
	func   = INT2PTR(void(*)(int, char *, float, void *), SvIV(c_func) );
	(*func)(i0, t1, f2, p3);

double
nci_ditfp( c_func, i0, t1, f2, p3 )
	SV* c_func
	int i0
	char * t1
	float f2
	void * p3
PREINIT:
	double(*func)(int, char *, float, void *);
CODE:
	func   = INT2PTR(double(*)(int, char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, f2, p3);
OUTPUT:
	RETVAL

short
nci_sitfp( c_func, i0, t1, f2, p3 )
	SV* c_func
	int i0
	char * t1
	float f2
	void * p3
PREINIT:
	short(*func)(int, char *, float, void *);
CODE:
	func   = INT2PTR(short(*)(int, char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, f2, p3);
OUTPUT:
	RETVAL

float
nci_fitfp( c_func, i0, t1, f2, p3 )
	SV* c_func
	int i0
	char * t1
	float f2
	void * p3
PREINIT:
	float(*func)(int, char *, float, void *);
CODE:
	func   = INT2PTR(float(*)(int, char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, f2, p3);
OUTPUT:
	RETVAL

char *
nci_titfp( c_func, i0, t1, f2, p3 )
	SV* c_func
	int i0
	char * t1
	float f2
	void * p3
PREINIT:
	char *(*func)(int, char *, float, void *);
CODE:
	func   = INT2PTR(char *(*)(int, char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, f2, p3);
OUTPUT:
	RETVAL

int
nci_iitfp( c_func, i0, t1, f2, p3 )
	SV* c_func
	int i0
	char * t1
	float f2
	void * p3
PREINIT:
	int(*func)(int, char *, float, void *);
CODE:
	func   = INT2PTR(int(*)(int, char *, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, f2, p3);
OUTPUT:
	RETVAL

void *
nci_ppifp( c_func, p0, i1, f2, p3 )
	SV* c_func
	void * p0
	int i1
	float f2
	void * p3
PREINIT:
	void *(*func)(void *, int, float, void *);
CODE:
	func   = INT2PTR(void *(*)(void *, int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, f2, p3);
OUTPUT:
	RETVAL

void
nci_vpifp( c_func, p0, i1, f2, p3 )
	SV* c_func
	void * p0
	int i1
	float f2
	void * p3
PREINIT:
	void(*func)(void *, int, float, void *);
CODE:
	func   = INT2PTR(void(*)(void *, int, float, void *), SvIV(c_func) );
	(*func)(p0, i1, f2, p3);

double
nci_dpifp( c_func, p0, i1, f2, p3 )
	SV* c_func
	void * p0
	int i1
	float f2
	void * p3
PREINIT:
	double(*func)(void *, int, float, void *);
CODE:
	func   = INT2PTR(double(*)(void *, int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, f2, p3);
OUTPUT:
	RETVAL

short
nci_spifp( c_func, p0, i1, f2, p3 )
	SV* c_func
	void * p0
	int i1
	float f2
	void * p3
PREINIT:
	short(*func)(void *, int, float, void *);
CODE:
	func   = INT2PTR(short(*)(void *, int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, f2, p3);
OUTPUT:
	RETVAL

float
nci_fpifp( c_func, p0, i1, f2, p3 )
	SV* c_func
	void * p0
	int i1
	float f2
	void * p3
PREINIT:
	float(*func)(void *, int, float, void *);
CODE:
	func   = INT2PTR(float(*)(void *, int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, f2, p3);
OUTPUT:
	RETVAL

char *
nci_tpifp( c_func, p0, i1, f2, p3 )
	SV* c_func
	void * p0
	int i1
	float f2
	void * p3
PREINIT:
	char *(*func)(void *, int, float, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, f2, p3);
OUTPUT:
	RETVAL

int
nci_ipifp( c_func, p0, i1, f2, p3 )
	SV* c_func
	void * p0
	int i1
	float f2
	void * p3
PREINIT:
	int(*func)(void *, int, float, void *);
CODE:
	func   = INT2PTR(int(*)(void *, int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, f2, p3);
OUTPUT:
	RETVAL

void *
nci_pvifp( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvifp( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvifp( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svifp( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvifp( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvifp( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivifp( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdifp( c_func, d0, i1, f2, p3 )
	SV* c_func
	double d0
	int i1
	float f2
	void * p3
PREINIT:
	void *(*func)(double, int, float, void *);
CODE:
	func   = INT2PTR(void *(*)(double, int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, f2, p3);
OUTPUT:
	RETVAL

void
nci_vdifp( c_func, d0, i1, f2, p3 )
	SV* c_func
	double d0
	int i1
	float f2
	void * p3
PREINIT:
	void(*func)(double, int, float, void *);
CODE:
	func   = INT2PTR(void(*)(double, int, float, void *), SvIV(c_func) );
	(*func)(d0, i1, f2, p3);

double
nci_ddifp( c_func, d0, i1, f2, p3 )
	SV* c_func
	double d0
	int i1
	float f2
	void * p3
PREINIT:
	double(*func)(double, int, float, void *);
CODE:
	func   = INT2PTR(double(*)(double, int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, f2, p3);
OUTPUT:
	RETVAL

short
nci_sdifp( c_func, d0, i1, f2, p3 )
	SV* c_func
	double d0
	int i1
	float f2
	void * p3
PREINIT:
	short(*func)(double, int, float, void *);
CODE:
	func   = INT2PTR(short(*)(double, int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, f2, p3);
OUTPUT:
	RETVAL

float
nci_fdifp( c_func, d0, i1, f2, p3 )
	SV* c_func
	double d0
	int i1
	float f2
	void * p3
PREINIT:
	float(*func)(double, int, float, void *);
CODE:
	func   = INT2PTR(float(*)(double, int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, f2, p3);
OUTPUT:
	RETVAL

char *
nci_tdifp( c_func, d0, i1, f2, p3 )
	SV* c_func
	double d0
	int i1
	float f2
	void * p3
PREINIT:
	char *(*func)(double, int, float, void *);
CODE:
	func   = INT2PTR(char *(*)(double, int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, f2, p3);
OUTPUT:
	RETVAL

int
nci_idifp( c_func, d0, i1, f2, p3 )
	SV* c_func
	double d0
	int i1
	float f2
	void * p3
PREINIT:
	int(*func)(double, int, float, void *);
CODE:
	func   = INT2PTR(int(*)(double, int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, f2, p3);
OUTPUT:
	RETVAL

void *
nci_psifp( c_func, s0, i1, f2, p3 )
	SV* c_func
	short s0
	int i1
	float f2
	void * p3
PREINIT:
	void *(*func)(short, int, float, void *);
CODE:
	func   = INT2PTR(void *(*)(short, int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, f2, p3);
OUTPUT:
	RETVAL

void
nci_vsifp( c_func, s0, i1, f2, p3 )
	SV* c_func
	short s0
	int i1
	float f2
	void * p3
PREINIT:
	void(*func)(short, int, float, void *);
CODE:
	func   = INT2PTR(void(*)(short, int, float, void *), SvIV(c_func) );
	(*func)(s0, i1, f2, p3);

double
nci_dsifp( c_func, s0, i1, f2, p3 )
	SV* c_func
	short s0
	int i1
	float f2
	void * p3
PREINIT:
	double(*func)(short, int, float, void *);
CODE:
	func   = INT2PTR(double(*)(short, int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, f2, p3);
OUTPUT:
	RETVAL

short
nci_ssifp( c_func, s0, i1, f2, p3 )
	SV* c_func
	short s0
	int i1
	float f2
	void * p3
PREINIT:
	short(*func)(short, int, float, void *);
CODE:
	func   = INT2PTR(short(*)(short, int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, f2, p3);
OUTPUT:
	RETVAL

float
nci_fsifp( c_func, s0, i1, f2, p3 )
	SV* c_func
	short s0
	int i1
	float f2
	void * p3
PREINIT:
	float(*func)(short, int, float, void *);
CODE:
	func   = INT2PTR(float(*)(short, int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, f2, p3);
OUTPUT:
	RETVAL

char *
nci_tsifp( c_func, s0, i1, f2, p3 )
	SV* c_func
	short s0
	int i1
	float f2
	void * p3
PREINIT:
	char *(*func)(short, int, float, void *);
CODE:
	func   = INT2PTR(char *(*)(short, int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, f2, p3);
OUTPUT:
	RETVAL

int
nci_isifp( c_func, s0, i1, f2, p3 )
	SV* c_func
	short s0
	int i1
	float f2
	void * p3
PREINIT:
	int(*func)(short, int, float, void *);
CODE:
	func   = INT2PTR(int(*)(short, int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, f2, p3);
OUTPUT:
	RETVAL

void *
nci_pfifp( c_func, f0, i1, f2, p3 )
	SV* c_func
	float f0
	int i1
	float f2
	void * p3
PREINIT:
	void *(*func)(float, int, float, void *);
CODE:
	func   = INT2PTR(void *(*)(float, int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, f2, p3);
OUTPUT:
	RETVAL

void
nci_vfifp( c_func, f0, i1, f2, p3 )
	SV* c_func
	float f0
	int i1
	float f2
	void * p3
PREINIT:
	void(*func)(float, int, float, void *);
CODE:
	func   = INT2PTR(void(*)(float, int, float, void *), SvIV(c_func) );
	(*func)(f0, i1, f2, p3);

double
nci_dfifp( c_func, f0, i1, f2, p3 )
	SV* c_func
	float f0
	int i1
	float f2
	void * p3
PREINIT:
	double(*func)(float, int, float, void *);
CODE:
	func   = INT2PTR(double(*)(float, int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, f2, p3);
OUTPUT:
	RETVAL

short
nci_sfifp( c_func, f0, i1, f2, p3 )
	SV* c_func
	float f0
	int i1
	float f2
	void * p3
PREINIT:
	short(*func)(float, int, float, void *);
CODE:
	func   = INT2PTR(short(*)(float, int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, f2, p3);
OUTPUT:
	RETVAL

float
nci_ffifp( c_func, f0, i1, f2, p3 )
	SV* c_func
	float f0
	int i1
	float f2
	void * p3
PREINIT:
	float(*func)(float, int, float, void *);
CODE:
	func   = INT2PTR(float(*)(float, int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, f2, p3);
OUTPUT:
	RETVAL

char *
nci_tfifp( c_func, f0, i1, f2, p3 )
	SV* c_func
	float f0
	int i1
	float f2
	void * p3
PREINIT:
	char *(*func)(float, int, float, void *);
CODE:
	func   = INT2PTR(char *(*)(float, int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, f2, p3);
OUTPUT:
	RETVAL

int
nci_ififp( c_func, f0, i1, f2, p3 )
	SV* c_func
	float f0
	int i1
	float f2
	void * p3
PREINIT:
	int(*func)(float, int, float, void *);
CODE:
	func   = INT2PTR(int(*)(float, int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, f2, p3);
OUTPUT:
	RETVAL

void *
nci_ptifp( c_func, t0, i1, f2, p3 )
	SV* c_func
	char * t0
	int i1
	float f2
	void * p3
PREINIT:
	void *(*func)(char *, int, float, void *);
CODE:
	func   = INT2PTR(void *(*)(char *, int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, f2, p3);
OUTPUT:
	RETVAL

void
nci_vtifp( c_func, t0, i1, f2, p3 )
	SV* c_func
	char * t0
	int i1
	float f2
	void * p3
PREINIT:
	void(*func)(char *, int, float, void *);
CODE:
	func   = INT2PTR(void(*)(char *, int, float, void *), SvIV(c_func) );
	(*func)(t0, i1, f2, p3);

double
nci_dtifp( c_func, t0, i1, f2, p3 )
	SV* c_func
	char * t0
	int i1
	float f2
	void * p3
PREINIT:
	double(*func)(char *, int, float, void *);
CODE:
	func   = INT2PTR(double(*)(char *, int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, f2, p3);
OUTPUT:
	RETVAL

short
nci_stifp( c_func, t0, i1, f2, p3 )
	SV* c_func
	char * t0
	int i1
	float f2
	void * p3
PREINIT:
	short(*func)(char *, int, float, void *);
CODE:
	func   = INT2PTR(short(*)(char *, int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, f2, p3);
OUTPUT:
	RETVAL

float
nci_ftifp( c_func, t0, i1, f2, p3 )
	SV* c_func
	char * t0
	int i1
	float f2
	void * p3
PREINIT:
	float(*func)(char *, int, float, void *);
CODE:
	func   = INT2PTR(float(*)(char *, int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, f2, p3);
OUTPUT:
	RETVAL

char *
nci_ttifp( c_func, t0, i1, f2, p3 )
	SV* c_func
	char * t0
	int i1
	float f2
	void * p3
PREINIT:
	char *(*func)(char *, int, float, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, f2, p3);
OUTPUT:
	RETVAL

int
nci_itifp( c_func, t0, i1, f2, p3 )
	SV* c_func
	char * t0
	int i1
	float f2
	void * p3
PREINIT:
	int(*func)(char *, int, float, void *);
CODE:
	func   = INT2PTR(int(*)(char *, int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, f2, p3);
OUTPUT:
	RETVAL

void *
nci_piifp( c_func, i0, i1, f2, p3 )
	SV* c_func
	int i0
	int i1
	float f2
	void * p3
PREINIT:
	void *(*func)(int, int, float, void *);
CODE:
	func   = INT2PTR(void *(*)(int, int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, f2, p3);
OUTPUT:
	RETVAL

void
nci_viifp( c_func, i0, i1, f2, p3 )
	SV* c_func
	int i0
	int i1
	float f2
	void * p3
PREINIT:
	void(*func)(int, int, float, void *);
CODE:
	func   = INT2PTR(void(*)(int, int, float, void *), SvIV(c_func) );
	(*func)(i0, i1, f2, p3);

double
nci_diifp( c_func, i0, i1, f2, p3 )
	SV* c_func
	int i0
	int i1
	float f2
	void * p3
PREINIT:
	double(*func)(int, int, float, void *);
CODE:
	func   = INT2PTR(double(*)(int, int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, f2, p3);
OUTPUT:
	RETVAL

short
nci_siifp( c_func, i0, i1, f2, p3 )
	SV* c_func
	int i0
	int i1
	float f2
	void * p3
PREINIT:
	short(*func)(int, int, float, void *);
CODE:
	func   = INT2PTR(short(*)(int, int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, f2, p3);
OUTPUT:
	RETVAL

float
nci_fiifp( c_func, i0, i1, f2, p3 )
	SV* c_func
	int i0
	int i1
	float f2
	void * p3
PREINIT:
	float(*func)(int, int, float, void *);
CODE:
	func   = INT2PTR(float(*)(int, int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, f2, p3);
OUTPUT:
	RETVAL

char *
nci_tiifp( c_func, i0, i1, f2, p3 )
	SV* c_func
	int i0
	int i1
	float f2
	void * p3
PREINIT:
	char *(*func)(int, int, float, void *);
CODE:
	func   = INT2PTR(char *(*)(int, int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, f2, p3);
OUTPUT:
	RETVAL

int
nci_iiifp( c_func, i0, i1, f2, p3 )
	SV* c_func
	int i0
	int i1
	float f2
	void * p3
PREINIT:
	int(*func)(int, int, float, void *);
CODE:
	func   = INT2PTR(int(*)(int, int, float, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, f2, p3);
OUTPUT:
	RETVAL

void *
nci_ppptp( c_func, p0, p1, t2, p3 )
	SV* c_func
	void * p0
	void * p1
	char * t2
	void * p3
PREINIT:
	void *(*func)(void *, void *, char *, void *);
CODE:
	func   = INT2PTR(void *(*)(void *, void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, t2, p3);
OUTPUT:
	RETVAL

void
nci_vpptp( c_func, p0, p1, t2, p3 )
	SV* c_func
	void * p0
	void * p1
	char * t2
	void * p3
PREINIT:
	void(*func)(void *, void *, char *, void *);
CODE:
	func   = INT2PTR(void(*)(void *, void *, char *, void *), SvIV(c_func) );
	(*func)(p0, p1, t2, p3);

double
nci_dpptp( c_func, p0, p1, t2, p3 )
	SV* c_func
	void * p0
	void * p1
	char * t2
	void * p3
PREINIT:
	double(*func)(void *, void *, char *, void *);
CODE:
	func   = INT2PTR(double(*)(void *, void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, t2, p3);
OUTPUT:
	RETVAL

short
nci_spptp( c_func, p0, p1, t2, p3 )
	SV* c_func
	void * p0
	void * p1
	char * t2
	void * p3
PREINIT:
	short(*func)(void *, void *, char *, void *);
CODE:
	func   = INT2PTR(short(*)(void *, void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, t2, p3);
OUTPUT:
	RETVAL

float
nci_fpptp( c_func, p0, p1, t2, p3 )
	SV* c_func
	void * p0
	void * p1
	char * t2
	void * p3
PREINIT:
	float(*func)(void *, void *, char *, void *);
CODE:
	func   = INT2PTR(float(*)(void *, void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, t2, p3);
OUTPUT:
	RETVAL

char *
nci_tpptp( c_func, p0, p1, t2, p3 )
	SV* c_func
	void * p0
	void * p1
	char * t2
	void * p3
PREINIT:
	char *(*func)(void *, void *, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, t2, p3);
OUTPUT:
	RETVAL

int
nci_ipptp( c_func, p0, p1, t2, p3 )
	SV* c_func
	void * p0
	void * p1
	char * t2
	void * p3
PREINIT:
	int(*func)(void *, void *, char *, void *);
CODE:
	func   = INT2PTR(int(*)(void *, void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, t2, p3);
OUTPUT:
	RETVAL

void *
nci_pvptp( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvptp( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvptp( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svptp( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvptp( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvptp( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivptp( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdptp( c_func, d0, p1, t2, p3 )
	SV* c_func
	double d0
	void * p1
	char * t2
	void * p3
PREINIT:
	void *(*func)(double, void *, char *, void *);
CODE:
	func   = INT2PTR(void *(*)(double, void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, t2, p3);
OUTPUT:
	RETVAL

void
nci_vdptp( c_func, d0, p1, t2, p3 )
	SV* c_func
	double d0
	void * p1
	char * t2
	void * p3
PREINIT:
	void(*func)(double, void *, char *, void *);
CODE:
	func   = INT2PTR(void(*)(double, void *, char *, void *), SvIV(c_func) );
	(*func)(d0, p1, t2, p3);

double
nci_ddptp( c_func, d0, p1, t2, p3 )
	SV* c_func
	double d0
	void * p1
	char * t2
	void * p3
PREINIT:
	double(*func)(double, void *, char *, void *);
CODE:
	func   = INT2PTR(double(*)(double, void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, t2, p3);
OUTPUT:
	RETVAL

short
nci_sdptp( c_func, d0, p1, t2, p3 )
	SV* c_func
	double d0
	void * p1
	char * t2
	void * p3
PREINIT:
	short(*func)(double, void *, char *, void *);
CODE:
	func   = INT2PTR(short(*)(double, void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, t2, p3);
OUTPUT:
	RETVAL

float
nci_fdptp( c_func, d0, p1, t2, p3 )
	SV* c_func
	double d0
	void * p1
	char * t2
	void * p3
PREINIT:
	float(*func)(double, void *, char *, void *);
CODE:
	func   = INT2PTR(float(*)(double, void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, t2, p3);
OUTPUT:
	RETVAL

char *
nci_tdptp( c_func, d0, p1, t2, p3 )
	SV* c_func
	double d0
	void * p1
	char * t2
	void * p3
PREINIT:
	char *(*func)(double, void *, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(double, void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, t2, p3);
OUTPUT:
	RETVAL

int
nci_idptp( c_func, d0, p1, t2, p3 )
	SV* c_func
	double d0
	void * p1
	char * t2
	void * p3
PREINIT:
	int(*func)(double, void *, char *, void *);
CODE:
	func   = INT2PTR(int(*)(double, void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, t2, p3);
OUTPUT:
	RETVAL

void *
nci_psptp( c_func, s0, p1, t2, p3 )
	SV* c_func
	short s0
	void * p1
	char * t2
	void * p3
PREINIT:
	void *(*func)(short, void *, char *, void *);
CODE:
	func   = INT2PTR(void *(*)(short, void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, t2, p3);
OUTPUT:
	RETVAL

void
nci_vsptp( c_func, s0, p1, t2, p3 )
	SV* c_func
	short s0
	void * p1
	char * t2
	void * p3
PREINIT:
	void(*func)(short, void *, char *, void *);
CODE:
	func   = INT2PTR(void(*)(short, void *, char *, void *), SvIV(c_func) );
	(*func)(s0, p1, t2, p3);

double
nci_dsptp( c_func, s0, p1, t2, p3 )
	SV* c_func
	short s0
	void * p1
	char * t2
	void * p3
PREINIT:
	double(*func)(short, void *, char *, void *);
CODE:
	func   = INT2PTR(double(*)(short, void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, t2, p3);
OUTPUT:
	RETVAL

short
nci_ssptp( c_func, s0, p1, t2, p3 )
	SV* c_func
	short s0
	void * p1
	char * t2
	void * p3
PREINIT:
	short(*func)(short, void *, char *, void *);
CODE:
	func   = INT2PTR(short(*)(short, void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, t2, p3);
OUTPUT:
	RETVAL

float
nci_fsptp( c_func, s0, p1, t2, p3 )
	SV* c_func
	short s0
	void * p1
	char * t2
	void * p3
PREINIT:
	float(*func)(short, void *, char *, void *);
CODE:
	func   = INT2PTR(float(*)(short, void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, t2, p3);
OUTPUT:
	RETVAL

char *
nci_tsptp( c_func, s0, p1, t2, p3 )
	SV* c_func
	short s0
	void * p1
	char * t2
	void * p3
PREINIT:
	char *(*func)(short, void *, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(short, void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, t2, p3);
OUTPUT:
	RETVAL

int
nci_isptp( c_func, s0, p1, t2, p3 )
	SV* c_func
	short s0
	void * p1
	char * t2
	void * p3
PREINIT:
	int(*func)(short, void *, char *, void *);
CODE:
	func   = INT2PTR(int(*)(short, void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, t2, p3);
OUTPUT:
	RETVAL

void *
nci_pfptp( c_func, f0, p1, t2, p3 )
	SV* c_func
	float f0
	void * p1
	char * t2
	void * p3
PREINIT:
	void *(*func)(float, void *, char *, void *);
CODE:
	func   = INT2PTR(void *(*)(float, void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, t2, p3);
OUTPUT:
	RETVAL

void
nci_vfptp( c_func, f0, p1, t2, p3 )
	SV* c_func
	float f0
	void * p1
	char * t2
	void * p3
PREINIT:
	void(*func)(float, void *, char *, void *);
CODE:
	func   = INT2PTR(void(*)(float, void *, char *, void *), SvIV(c_func) );
	(*func)(f0, p1, t2, p3);

double
nci_dfptp( c_func, f0, p1, t2, p3 )
	SV* c_func
	float f0
	void * p1
	char * t2
	void * p3
PREINIT:
	double(*func)(float, void *, char *, void *);
CODE:
	func   = INT2PTR(double(*)(float, void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, t2, p3);
OUTPUT:
	RETVAL

short
nci_sfptp( c_func, f0, p1, t2, p3 )
	SV* c_func
	float f0
	void * p1
	char * t2
	void * p3
PREINIT:
	short(*func)(float, void *, char *, void *);
CODE:
	func   = INT2PTR(short(*)(float, void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, t2, p3);
OUTPUT:
	RETVAL

float
nci_ffptp( c_func, f0, p1, t2, p3 )
	SV* c_func
	float f0
	void * p1
	char * t2
	void * p3
PREINIT:
	float(*func)(float, void *, char *, void *);
CODE:
	func   = INT2PTR(float(*)(float, void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, t2, p3);
OUTPUT:
	RETVAL

char *
nci_tfptp( c_func, f0, p1, t2, p3 )
	SV* c_func
	float f0
	void * p1
	char * t2
	void * p3
PREINIT:
	char *(*func)(float, void *, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(float, void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, t2, p3);
OUTPUT:
	RETVAL

int
nci_ifptp( c_func, f0, p1, t2, p3 )
	SV* c_func
	float f0
	void * p1
	char * t2
	void * p3
PREINIT:
	int(*func)(float, void *, char *, void *);
CODE:
	func   = INT2PTR(int(*)(float, void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, t2, p3);
OUTPUT:
	RETVAL

void *
nci_ptptp( c_func, t0, p1, t2, p3 )
	SV* c_func
	char * t0
	void * p1
	char * t2
	void * p3
PREINIT:
	void *(*func)(char *, void *, char *, void *);
CODE:
	func   = INT2PTR(void *(*)(char *, void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, t2, p3);
OUTPUT:
	RETVAL

void
nci_vtptp( c_func, t0, p1, t2, p3 )
	SV* c_func
	char * t0
	void * p1
	char * t2
	void * p3
PREINIT:
	void(*func)(char *, void *, char *, void *);
CODE:
	func   = INT2PTR(void(*)(char *, void *, char *, void *), SvIV(c_func) );
	(*func)(t0, p1, t2, p3);

double
nci_dtptp( c_func, t0, p1, t2, p3 )
	SV* c_func
	char * t0
	void * p1
	char * t2
	void * p3
PREINIT:
	double(*func)(char *, void *, char *, void *);
CODE:
	func   = INT2PTR(double(*)(char *, void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, t2, p3);
OUTPUT:
	RETVAL

short
nci_stptp( c_func, t0, p1, t2, p3 )
	SV* c_func
	char * t0
	void * p1
	char * t2
	void * p3
PREINIT:
	short(*func)(char *, void *, char *, void *);
CODE:
	func   = INT2PTR(short(*)(char *, void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, t2, p3);
OUTPUT:
	RETVAL

float
nci_ftptp( c_func, t0, p1, t2, p3 )
	SV* c_func
	char * t0
	void * p1
	char * t2
	void * p3
PREINIT:
	float(*func)(char *, void *, char *, void *);
CODE:
	func   = INT2PTR(float(*)(char *, void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, t2, p3);
OUTPUT:
	RETVAL

char *
nci_ttptp( c_func, t0, p1, t2, p3 )
	SV* c_func
	char * t0
	void * p1
	char * t2
	void * p3
PREINIT:
	char *(*func)(char *, void *, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, t2, p3);
OUTPUT:
	RETVAL

int
nci_itptp( c_func, t0, p1, t2, p3 )
	SV* c_func
	char * t0
	void * p1
	char * t2
	void * p3
PREINIT:
	int(*func)(char *, void *, char *, void *);
CODE:
	func   = INT2PTR(int(*)(char *, void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, t2, p3);
OUTPUT:
	RETVAL

void *
nci_piptp( c_func, i0, p1, t2, p3 )
	SV* c_func
	int i0
	void * p1
	char * t2
	void * p3
PREINIT:
	void *(*func)(int, void *, char *, void *);
CODE:
	func   = INT2PTR(void *(*)(int, void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, t2, p3);
OUTPUT:
	RETVAL

void
nci_viptp( c_func, i0, p1, t2, p3 )
	SV* c_func
	int i0
	void * p1
	char * t2
	void * p3
PREINIT:
	void(*func)(int, void *, char *, void *);
CODE:
	func   = INT2PTR(void(*)(int, void *, char *, void *), SvIV(c_func) );
	(*func)(i0, p1, t2, p3);

double
nci_diptp( c_func, i0, p1, t2, p3 )
	SV* c_func
	int i0
	void * p1
	char * t2
	void * p3
PREINIT:
	double(*func)(int, void *, char *, void *);
CODE:
	func   = INT2PTR(double(*)(int, void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, t2, p3);
OUTPUT:
	RETVAL

short
nci_siptp( c_func, i0, p1, t2, p3 )
	SV* c_func
	int i0
	void * p1
	char * t2
	void * p3
PREINIT:
	short(*func)(int, void *, char *, void *);
CODE:
	func   = INT2PTR(short(*)(int, void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, t2, p3);
OUTPUT:
	RETVAL

float
nci_fiptp( c_func, i0, p1, t2, p3 )
	SV* c_func
	int i0
	void * p1
	char * t2
	void * p3
PREINIT:
	float(*func)(int, void *, char *, void *);
CODE:
	func   = INT2PTR(float(*)(int, void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, t2, p3);
OUTPUT:
	RETVAL

char *
nci_tiptp( c_func, i0, p1, t2, p3 )
	SV* c_func
	int i0
	void * p1
	char * t2
	void * p3
PREINIT:
	char *(*func)(int, void *, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(int, void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, t2, p3);
OUTPUT:
	RETVAL

int
nci_iiptp( c_func, i0, p1, t2, p3 )
	SV* c_func
	int i0
	void * p1
	char * t2
	void * p3
PREINIT:
	int(*func)(int, void *, char *, void *);
CODE:
	func   = INT2PTR(int(*)(int, void *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, t2, p3);
OUTPUT:
	RETVAL

void *
nci_ppdtp( c_func, p0, d1, t2, p3 )
	SV* c_func
	void * p0
	double d1
	char * t2
	void * p3
PREINIT:
	void *(*func)(void *, double, char *, void *);
CODE:
	func   = INT2PTR(void *(*)(void *, double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, t2, p3);
OUTPUT:
	RETVAL

void
nci_vpdtp( c_func, p0, d1, t2, p3 )
	SV* c_func
	void * p0
	double d1
	char * t2
	void * p3
PREINIT:
	void(*func)(void *, double, char *, void *);
CODE:
	func   = INT2PTR(void(*)(void *, double, char *, void *), SvIV(c_func) );
	(*func)(p0, d1, t2, p3);

double
nci_dpdtp( c_func, p0, d1, t2, p3 )
	SV* c_func
	void * p0
	double d1
	char * t2
	void * p3
PREINIT:
	double(*func)(void *, double, char *, void *);
CODE:
	func   = INT2PTR(double(*)(void *, double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, t2, p3);
OUTPUT:
	RETVAL

short
nci_spdtp( c_func, p0, d1, t2, p3 )
	SV* c_func
	void * p0
	double d1
	char * t2
	void * p3
PREINIT:
	short(*func)(void *, double, char *, void *);
CODE:
	func   = INT2PTR(short(*)(void *, double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, t2, p3);
OUTPUT:
	RETVAL

float
nci_fpdtp( c_func, p0, d1, t2, p3 )
	SV* c_func
	void * p0
	double d1
	char * t2
	void * p3
PREINIT:
	float(*func)(void *, double, char *, void *);
CODE:
	func   = INT2PTR(float(*)(void *, double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, t2, p3);
OUTPUT:
	RETVAL

char *
nci_tpdtp( c_func, p0, d1, t2, p3 )
	SV* c_func
	void * p0
	double d1
	char * t2
	void * p3
PREINIT:
	char *(*func)(void *, double, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, t2, p3);
OUTPUT:
	RETVAL

int
nci_ipdtp( c_func, p0, d1, t2, p3 )
	SV* c_func
	void * p0
	double d1
	char * t2
	void * p3
PREINIT:
	int(*func)(void *, double, char *, void *);
CODE:
	func   = INT2PTR(int(*)(void *, double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, t2, p3);
OUTPUT:
	RETVAL

void *
nci_pvdtp( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvdtp( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvdtp( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svdtp( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvdtp( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvdtp( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivdtp( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pddtp( c_func, d0, d1, t2, p3 )
	SV* c_func
	double d0
	double d1
	char * t2
	void * p3
PREINIT:
	void *(*func)(double, double, char *, void *);
CODE:
	func   = INT2PTR(void *(*)(double, double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, t2, p3);
OUTPUT:
	RETVAL

void
nci_vddtp( c_func, d0, d1, t2, p3 )
	SV* c_func
	double d0
	double d1
	char * t2
	void * p3
PREINIT:
	void(*func)(double, double, char *, void *);
CODE:
	func   = INT2PTR(void(*)(double, double, char *, void *), SvIV(c_func) );
	(*func)(d0, d1, t2, p3);

double
nci_dddtp( c_func, d0, d1, t2, p3 )
	SV* c_func
	double d0
	double d1
	char * t2
	void * p3
PREINIT:
	double(*func)(double, double, char *, void *);
CODE:
	func   = INT2PTR(double(*)(double, double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, t2, p3);
OUTPUT:
	RETVAL

short
nci_sddtp( c_func, d0, d1, t2, p3 )
	SV* c_func
	double d0
	double d1
	char * t2
	void * p3
PREINIT:
	short(*func)(double, double, char *, void *);
CODE:
	func   = INT2PTR(short(*)(double, double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, t2, p3);
OUTPUT:
	RETVAL

float
nci_fddtp( c_func, d0, d1, t2, p3 )
	SV* c_func
	double d0
	double d1
	char * t2
	void * p3
PREINIT:
	float(*func)(double, double, char *, void *);
CODE:
	func   = INT2PTR(float(*)(double, double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, t2, p3);
OUTPUT:
	RETVAL

char *
nci_tddtp( c_func, d0, d1, t2, p3 )
	SV* c_func
	double d0
	double d1
	char * t2
	void * p3
PREINIT:
	char *(*func)(double, double, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(double, double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, t2, p3);
OUTPUT:
	RETVAL

int
nci_iddtp( c_func, d0, d1, t2, p3 )
	SV* c_func
	double d0
	double d1
	char * t2
	void * p3
PREINIT:
	int(*func)(double, double, char *, void *);
CODE:
	func   = INT2PTR(int(*)(double, double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, t2, p3);
OUTPUT:
	RETVAL

void *
nci_psdtp( c_func, s0, d1, t2, p3 )
	SV* c_func
	short s0
	double d1
	char * t2
	void * p3
PREINIT:
	void *(*func)(short, double, char *, void *);
CODE:
	func   = INT2PTR(void *(*)(short, double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, t2, p3);
OUTPUT:
	RETVAL

void
nci_vsdtp( c_func, s0, d1, t2, p3 )
	SV* c_func
	short s0
	double d1
	char * t2
	void * p3
PREINIT:
	void(*func)(short, double, char *, void *);
CODE:
	func   = INT2PTR(void(*)(short, double, char *, void *), SvIV(c_func) );
	(*func)(s0, d1, t2, p3);

double
nci_dsdtp( c_func, s0, d1, t2, p3 )
	SV* c_func
	short s0
	double d1
	char * t2
	void * p3
PREINIT:
	double(*func)(short, double, char *, void *);
CODE:
	func   = INT2PTR(double(*)(short, double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, t2, p3);
OUTPUT:
	RETVAL

short
nci_ssdtp( c_func, s0, d1, t2, p3 )
	SV* c_func
	short s0
	double d1
	char * t2
	void * p3
PREINIT:
	short(*func)(short, double, char *, void *);
CODE:
	func   = INT2PTR(short(*)(short, double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, t2, p3);
OUTPUT:
	RETVAL

float
nci_fsdtp( c_func, s0, d1, t2, p3 )
	SV* c_func
	short s0
	double d1
	char * t2
	void * p3
PREINIT:
	float(*func)(short, double, char *, void *);
CODE:
	func   = INT2PTR(float(*)(short, double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, t2, p3);
OUTPUT:
	RETVAL

char *
nci_tsdtp( c_func, s0, d1, t2, p3 )
	SV* c_func
	short s0
	double d1
	char * t2
	void * p3
PREINIT:
	char *(*func)(short, double, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(short, double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, t2, p3);
OUTPUT:
	RETVAL

int
nci_isdtp( c_func, s0, d1, t2, p3 )
	SV* c_func
	short s0
	double d1
	char * t2
	void * p3
PREINIT:
	int(*func)(short, double, char *, void *);
CODE:
	func   = INT2PTR(int(*)(short, double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, t2, p3);
OUTPUT:
	RETVAL

void *
nci_pfdtp( c_func, f0, d1, t2, p3 )
	SV* c_func
	float f0
	double d1
	char * t2
	void * p3
PREINIT:
	void *(*func)(float, double, char *, void *);
CODE:
	func   = INT2PTR(void *(*)(float, double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, t2, p3);
OUTPUT:
	RETVAL

void
nci_vfdtp( c_func, f0, d1, t2, p3 )
	SV* c_func
	float f0
	double d1
	char * t2
	void * p3
PREINIT:
	void(*func)(float, double, char *, void *);
CODE:
	func   = INT2PTR(void(*)(float, double, char *, void *), SvIV(c_func) );
	(*func)(f0, d1, t2, p3);

double
nci_dfdtp( c_func, f0, d1, t2, p3 )
	SV* c_func
	float f0
	double d1
	char * t2
	void * p3
PREINIT:
	double(*func)(float, double, char *, void *);
CODE:
	func   = INT2PTR(double(*)(float, double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, t2, p3);
OUTPUT:
	RETVAL

short
nci_sfdtp( c_func, f0, d1, t2, p3 )
	SV* c_func
	float f0
	double d1
	char * t2
	void * p3
PREINIT:
	short(*func)(float, double, char *, void *);
CODE:
	func   = INT2PTR(short(*)(float, double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, t2, p3);
OUTPUT:
	RETVAL

float
nci_ffdtp( c_func, f0, d1, t2, p3 )
	SV* c_func
	float f0
	double d1
	char * t2
	void * p3
PREINIT:
	float(*func)(float, double, char *, void *);
CODE:
	func   = INT2PTR(float(*)(float, double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, t2, p3);
OUTPUT:
	RETVAL

char *
nci_tfdtp( c_func, f0, d1, t2, p3 )
	SV* c_func
	float f0
	double d1
	char * t2
	void * p3
PREINIT:
	char *(*func)(float, double, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(float, double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, t2, p3);
OUTPUT:
	RETVAL

int
nci_ifdtp( c_func, f0, d1, t2, p3 )
	SV* c_func
	float f0
	double d1
	char * t2
	void * p3
PREINIT:
	int(*func)(float, double, char *, void *);
CODE:
	func   = INT2PTR(int(*)(float, double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, t2, p3);
OUTPUT:
	RETVAL

void *
nci_ptdtp( c_func, t0, d1, t2, p3 )
	SV* c_func
	char * t0
	double d1
	char * t2
	void * p3
PREINIT:
	void *(*func)(char *, double, char *, void *);
CODE:
	func   = INT2PTR(void *(*)(char *, double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, t2, p3);
OUTPUT:
	RETVAL

void
nci_vtdtp( c_func, t0, d1, t2, p3 )
	SV* c_func
	char * t0
	double d1
	char * t2
	void * p3
PREINIT:
	void(*func)(char *, double, char *, void *);
CODE:
	func   = INT2PTR(void(*)(char *, double, char *, void *), SvIV(c_func) );
	(*func)(t0, d1, t2, p3);

double
nci_dtdtp( c_func, t0, d1, t2, p3 )
	SV* c_func
	char * t0
	double d1
	char * t2
	void * p3
PREINIT:
	double(*func)(char *, double, char *, void *);
CODE:
	func   = INT2PTR(double(*)(char *, double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, t2, p3);
OUTPUT:
	RETVAL

short
nci_stdtp( c_func, t0, d1, t2, p3 )
	SV* c_func
	char * t0
	double d1
	char * t2
	void * p3
PREINIT:
	short(*func)(char *, double, char *, void *);
CODE:
	func   = INT2PTR(short(*)(char *, double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, t2, p3);
OUTPUT:
	RETVAL

float
nci_ftdtp( c_func, t0, d1, t2, p3 )
	SV* c_func
	char * t0
	double d1
	char * t2
	void * p3
PREINIT:
	float(*func)(char *, double, char *, void *);
CODE:
	func   = INT2PTR(float(*)(char *, double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, t2, p3);
OUTPUT:
	RETVAL

char *
nci_ttdtp( c_func, t0, d1, t2, p3 )
	SV* c_func
	char * t0
	double d1
	char * t2
	void * p3
PREINIT:
	char *(*func)(char *, double, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, t2, p3);
OUTPUT:
	RETVAL

int
nci_itdtp( c_func, t0, d1, t2, p3 )
	SV* c_func
	char * t0
	double d1
	char * t2
	void * p3
PREINIT:
	int(*func)(char *, double, char *, void *);
CODE:
	func   = INT2PTR(int(*)(char *, double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, t2, p3);
OUTPUT:
	RETVAL

void *
nci_pidtp( c_func, i0, d1, t2, p3 )
	SV* c_func
	int i0
	double d1
	char * t2
	void * p3
PREINIT:
	void *(*func)(int, double, char *, void *);
CODE:
	func   = INT2PTR(void *(*)(int, double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, t2, p3);
OUTPUT:
	RETVAL

void
nci_vidtp( c_func, i0, d1, t2, p3 )
	SV* c_func
	int i0
	double d1
	char * t2
	void * p3
PREINIT:
	void(*func)(int, double, char *, void *);
CODE:
	func   = INT2PTR(void(*)(int, double, char *, void *), SvIV(c_func) );
	(*func)(i0, d1, t2, p3);

double
nci_didtp( c_func, i0, d1, t2, p3 )
	SV* c_func
	int i0
	double d1
	char * t2
	void * p3
PREINIT:
	double(*func)(int, double, char *, void *);
CODE:
	func   = INT2PTR(double(*)(int, double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, t2, p3);
OUTPUT:
	RETVAL

short
nci_sidtp( c_func, i0, d1, t2, p3 )
	SV* c_func
	int i0
	double d1
	char * t2
	void * p3
PREINIT:
	short(*func)(int, double, char *, void *);
CODE:
	func   = INT2PTR(short(*)(int, double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, t2, p3);
OUTPUT:
	RETVAL

float
nci_fidtp( c_func, i0, d1, t2, p3 )
	SV* c_func
	int i0
	double d1
	char * t2
	void * p3
PREINIT:
	float(*func)(int, double, char *, void *);
CODE:
	func   = INT2PTR(float(*)(int, double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, t2, p3);
OUTPUT:
	RETVAL

char *
nci_tidtp( c_func, i0, d1, t2, p3 )
	SV* c_func
	int i0
	double d1
	char * t2
	void * p3
PREINIT:
	char *(*func)(int, double, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(int, double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, t2, p3);
OUTPUT:
	RETVAL

int
nci_iidtp( c_func, i0, d1, t2, p3 )
	SV* c_func
	int i0
	double d1
	char * t2
	void * p3
PREINIT:
	int(*func)(int, double, char *, void *);
CODE:
	func   = INT2PTR(int(*)(int, double, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, t2, p3);
OUTPUT:
	RETVAL

void *
nci_ppstp( c_func, p0, s1, t2, p3 )
	SV* c_func
	void * p0
	short s1
	char * t2
	void * p3
PREINIT:
	void *(*func)(void *, short, char *, void *);
CODE:
	func   = INT2PTR(void *(*)(void *, short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, t2, p3);
OUTPUT:
	RETVAL

void
nci_vpstp( c_func, p0, s1, t2, p3 )
	SV* c_func
	void * p0
	short s1
	char * t2
	void * p3
PREINIT:
	void(*func)(void *, short, char *, void *);
CODE:
	func   = INT2PTR(void(*)(void *, short, char *, void *), SvIV(c_func) );
	(*func)(p0, s1, t2, p3);

double
nci_dpstp( c_func, p0, s1, t2, p3 )
	SV* c_func
	void * p0
	short s1
	char * t2
	void * p3
PREINIT:
	double(*func)(void *, short, char *, void *);
CODE:
	func   = INT2PTR(double(*)(void *, short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, t2, p3);
OUTPUT:
	RETVAL

short
nci_spstp( c_func, p0, s1, t2, p3 )
	SV* c_func
	void * p0
	short s1
	char * t2
	void * p3
PREINIT:
	short(*func)(void *, short, char *, void *);
CODE:
	func   = INT2PTR(short(*)(void *, short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, t2, p3);
OUTPUT:
	RETVAL

float
nci_fpstp( c_func, p0, s1, t2, p3 )
	SV* c_func
	void * p0
	short s1
	char * t2
	void * p3
PREINIT:
	float(*func)(void *, short, char *, void *);
CODE:
	func   = INT2PTR(float(*)(void *, short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, t2, p3);
OUTPUT:
	RETVAL

char *
nci_tpstp( c_func, p0, s1, t2, p3 )
	SV* c_func
	void * p0
	short s1
	char * t2
	void * p3
PREINIT:
	char *(*func)(void *, short, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, t2, p3);
OUTPUT:
	RETVAL

int
nci_ipstp( c_func, p0, s1, t2, p3 )
	SV* c_func
	void * p0
	short s1
	char * t2
	void * p3
PREINIT:
	int(*func)(void *, short, char *, void *);
CODE:
	func   = INT2PTR(int(*)(void *, short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, t2, p3);
OUTPUT:
	RETVAL

void *
nci_pvstp( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvstp( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvstp( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svstp( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvstp( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvstp( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivstp( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdstp( c_func, d0, s1, t2, p3 )
	SV* c_func
	double d0
	short s1
	char * t2
	void * p3
PREINIT:
	void *(*func)(double, short, char *, void *);
CODE:
	func   = INT2PTR(void *(*)(double, short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, t2, p3);
OUTPUT:
	RETVAL

void
nci_vdstp( c_func, d0, s1, t2, p3 )
	SV* c_func
	double d0
	short s1
	char * t2
	void * p3
PREINIT:
	void(*func)(double, short, char *, void *);
CODE:
	func   = INT2PTR(void(*)(double, short, char *, void *), SvIV(c_func) );
	(*func)(d0, s1, t2, p3);

double
nci_ddstp( c_func, d0, s1, t2, p3 )
	SV* c_func
	double d0
	short s1
	char * t2
	void * p3
PREINIT:
	double(*func)(double, short, char *, void *);
CODE:
	func   = INT2PTR(double(*)(double, short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, t2, p3);
OUTPUT:
	RETVAL

short
nci_sdstp( c_func, d0, s1, t2, p3 )
	SV* c_func
	double d0
	short s1
	char * t2
	void * p3
PREINIT:
	short(*func)(double, short, char *, void *);
CODE:
	func   = INT2PTR(short(*)(double, short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, t2, p3);
OUTPUT:
	RETVAL

float
nci_fdstp( c_func, d0, s1, t2, p3 )
	SV* c_func
	double d0
	short s1
	char * t2
	void * p3
PREINIT:
	float(*func)(double, short, char *, void *);
CODE:
	func   = INT2PTR(float(*)(double, short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, t2, p3);
OUTPUT:
	RETVAL

char *
nci_tdstp( c_func, d0, s1, t2, p3 )
	SV* c_func
	double d0
	short s1
	char * t2
	void * p3
PREINIT:
	char *(*func)(double, short, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(double, short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, t2, p3);
OUTPUT:
	RETVAL

int
nci_idstp( c_func, d0, s1, t2, p3 )
	SV* c_func
	double d0
	short s1
	char * t2
	void * p3
PREINIT:
	int(*func)(double, short, char *, void *);
CODE:
	func   = INT2PTR(int(*)(double, short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, t2, p3);
OUTPUT:
	RETVAL

void *
nci_psstp( c_func, s0, s1, t2, p3 )
	SV* c_func
	short s0
	short s1
	char * t2
	void * p3
PREINIT:
	void *(*func)(short, short, char *, void *);
CODE:
	func   = INT2PTR(void *(*)(short, short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, t2, p3);
OUTPUT:
	RETVAL

void
nci_vsstp( c_func, s0, s1, t2, p3 )
	SV* c_func
	short s0
	short s1
	char * t2
	void * p3
PREINIT:
	void(*func)(short, short, char *, void *);
CODE:
	func   = INT2PTR(void(*)(short, short, char *, void *), SvIV(c_func) );
	(*func)(s0, s1, t2, p3);

double
nci_dsstp( c_func, s0, s1, t2, p3 )
	SV* c_func
	short s0
	short s1
	char * t2
	void * p3
PREINIT:
	double(*func)(short, short, char *, void *);
CODE:
	func   = INT2PTR(double(*)(short, short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, t2, p3);
OUTPUT:
	RETVAL

short
nci_ssstp( c_func, s0, s1, t2, p3 )
	SV* c_func
	short s0
	short s1
	char * t2
	void * p3
PREINIT:
	short(*func)(short, short, char *, void *);
CODE:
	func   = INT2PTR(short(*)(short, short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, t2, p3);
OUTPUT:
	RETVAL

float
nci_fsstp( c_func, s0, s1, t2, p3 )
	SV* c_func
	short s0
	short s1
	char * t2
	void * p3
PREINIT:
	float(*func)(short, short, char *, void *);
CODE:
	func   = INT2PTR(float(*)(short, short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, t2, p3);
OUTPUT:
	RETVAL

char *
nci_tsstp( c_func, s0, s1, t2, p3 )
	SV* c_func
	short s0
	short s1
	char * t2
	void * p3
PREINIT:
	char *(*func)(short, short, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(short, short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, t2, p3);
OUTPUT:
	RETVAL

int
nci_isstp( c_func, s0, s1, t2, p3 )
	SV* c_func
	short s0
	short s1
	char * t2
	void * p3
PREINIT:
	int(*func)(short, short, char *, void *);
CODE:
	func   = INT2PTR(int(*)(short, short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, t2, p3);
OUTPUT:
	RETVAL

void *
nci_pfstp( c_func, f0, s1, t2, p3 )
	SV* c_func
	float f0
	short s1
	char * t2
	void * p3
PREINIT:
	void *(*func)(float, short, char *, void *);
CODE:
	func   = INT2PTR(void *(*)(float, short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, t2, p3);
OUTPUT:
	RETVAL

void
nci_vfstp( c_func, f0, s1, t2, p3 )
	SV* c_func
	float f0
	short s1
	char * t2
	void * p3
PREINIT:
	void(*func)(float, short, char *, void *);
CODE:
	func   = INT2PTR(void(*)(float, short, char *, void *), SvIV(c_func) );
	(*func)(f0, s1, t2, p3);

double
nci_dfstp( c_func, f0, s1, t2, p3 )
	SV* c_func
	float f0
	short s1
	char * t2
	void * p3
PREINIT:
	double(*func)(float, short, char *, void *);
CODE:
	func   = INT2PTR(double(*)(float, short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, t2, p3);
OUTPUT:
	RETVAL

short
nci_sfstp( c_func, f0, s1, t2, p3 )
	SV* c_func
	float f0
	short s1
	char * t2
	void * p3
PREINIT:
	short(*func)(float, short, char *, void *);
CODE:
	func   = INT2PTR(short(*)(float, short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, t2, p3);
OUTPUT:
	RETVAL

float
nci_ffstp( c_func, f0, s1, t2, p3 )
	SV* c_func
	float f0
	short s1
	char * t2
	void * p3
PREINIT:
	float(*func)(float, short, char *, void *);
CODE:
	func   = INT2PTR(float(*)(float, short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, t2, p3);
OUTPUT:
	RETVAL

char *
nci_tfstp( c_func, f0, s1, t2, p3 )
	SV* c_func
	float f0
	short s1
	char * t2
	void * p3
PREINIT:
	char *(*func)(float, short, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(float, short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, t2, p3);
OUTPUT:
	RETVAL

int
nci_ifstp( c_func, f0, s1, t2, p3 )
	SV* c_func
	float f0
	short s1
	char * t2
	void * p3
PREINIT:
	int(*func)(float, short, char *, void *);
CODE:
	func   = INT2PTR(int(*)(float, short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, t2, p3);
OUTPUT:
	RETVAL

void *
nci_ptstp( c_func, t0, s1, t2, p3 )
	SV* c_func
	char * t0
	short s1
	char * t2
	void * p3
PREINIT:
	void *(*func)(char *, short, char *, void *);
CODE:
	func   = INT2PTR(void *(*)(char *, short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, t2, p3);
OUTPUT:
	RETVAL

void
nci_vtstp( c_func, t0, s1, t2, p3 )
	SV* c_func
	char * t0
	short s1
	char * t2
	void * p3
PREINIT:
	void(*func)(char *, short, char *, void *);
CODE:
	func   = INT2PTR(void(*)(char *, short, char *, void *), SvIV(c_func) );
	(*func)(t0, s1, t2, p3);

double
nci_dtstp( c_func, t0, s1, t2, p3 )
	SV* c_func
	char * t0
	short s1
	char * t2
	void * p3
PREINIT:
	double(*func)(char *, short, char *, void *);
CODE:
	func   = INT2PTR(double(*)(char *, short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, t2, p3);
OUTPUT:
	RETVAL

short
nci_ststp( c_func, t0, s1, t2, p3 )
	SV* c_func
	char * t0
	short s1
	char * t2
	void * p3
PREINIT:
	short(*func)(char *, short, char *, void *);
CODE:
	func   = INT2PTR(short(*)(char *, short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, t2, p3);
OUTPUT:
	RETVAL

float
nci_ftstp( c_func, t0, s1, t2, p3 )
	SV* c_func
	char * t0
	short s1
	char * t2
	void * p3
PREINIT:
	float(*func)(char *, short, char *, void *);
CODE:
	func   = INT2PTR(float(*)(char *, short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, t2, p3);
OUTPUT:
	RETVAL

char *
nci_ttstp( c_func, t0, s1, t2, p3 )
	SV* c_func
	char * t0
	short s1
	char * t2
	void * p3
PREINIT:
	char *(*func)(char *, short, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, t2, p3);
OUTPUT:
	RETVAL

int
nci_itstp( c_func, t0, s1, t2, p3 )
	SV* c_func
	char * t0
	short s1
	char * t2
	void * p3
PREINIT:
	int(*func)(char *, short, char *, void *);
CODE:
	func   = INT2PTR(int(*)(char *, short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, t2, p3);
OUTPUT:
	RETVAL

void *
nci_pistp( c_func, i0, s1, t2, p3 )
	SV* c_func
	int i0
	short s1
	char * t2
	void * p3
PREINIT:
	void *(*func)(int, short, char *, void *);
CODE:
	func   = INT2PTR(void *(*)(int, short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, t2, p3);
OUTPUT:
	RETVAL

void
nci_vistp( c_func, i0, s1, t2, p3 )
	SV* c_func
	int i0
	short s1
	char * t2
	void * p3
PREINIT:
	void(*func)(int, short, char *, void *);
CODE:
	func   = INT2PTR(void(*)(int, short, char *, void *), SvIV(c_func) );
	(*func)(i0, s1, t2, p3);

double
nci_distp( c_func, i0, s1, t2, p3 )
	SV* c_func
	int i0
	short s1
	char * t2
	void * p3
PREINIT:
	double(*func)(int, short, char *, void *);
CODE:
	func   = INT2PTR(double(*)(int, short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, t2, p3);
OUTPUT:
	RETVAL

short
nci_sistp( c_func, i0, s1, t2, p3 )
	SV* c_func
	int i0
	short s1
	char * t2
	void * p3
PREINIT:
	short(*func)(int, short, char *, void *);
CODE:
	func   = INT2PTR(short(*)(int, short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, t2, p3);
OUTPUT:
	RETVAL

float
nci_fistp( c_func, i0, s1, t2, p3 )
	SV* c_func
	int i0
	short s1
	char * t2
	void * p3
PREINIT:
	float(*func)(int, short, char *, void *);
CODE:
	func   = INT2PTR(float(*)(int, short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, t2, p3);
OUTPUT:
	RETVAL

char *
nci_tistp( c_func, i0, s1, t2, p3 )
	SV* c_func
	int i0
	short s1
	char * t2
	void * p3
PREINIT:
	char *(*func)(int, short, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(int, short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, t2, p3);
OUTPUT:
	RETVAL

int
nci_iistp( c_func, i0, s1, t2, p3 )
	SV* c_func
	int i0
	short s1
	char * t2
	void * p3
PREINIT:
	int(*func)(int, short, char *, void *);
CODE:
	func   = INT2PTR(int(*)(int, short, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, t2, p3);
OUTPUT:
	RETVAL

void *
nci_ppftp( c_func, p0, f1, t2, p3 )
	SV* c_func
	void * p0
	float f1
	char * t2
	void * p3
PREINIT:
	void *(*func)(void *, float, char *, void *);
CODE:
	func   = INT2PTR(void *(*)(void *, float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, t2, p3);
OUTPUT:
	RETVAL

void
nci_vpftp( c_func, p0, f1, t2, p3 )
	SV* c_func
	void * p0
	float f1
	char * t2
	void * p3
PREINIT:
	void(*func)(void *, float, char *, void *);
CODE:
	func   = INT2PTR(void(*)(void *, float, char *, void *), SvIV(c_func) );
	(*func)(p0, f1, t2, p3);

double
nci_dpftp( c_func, p0, f1, t2, p3 )
	SV* c_func
	void * p0
	float f1
	char * t2
	void * p3
PREINIT:
	double(*func)(void *, float, char *, void *);
CODE:
	func   = INT2PTR(double(*)(void *, float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, t2, p3);
OUTPUT:
	RETVAL

short
nci_spftp( c_func, p0, f1, t2, p3 )
	SV* c_func
	void * p0
	float f1
	char * t2
	void * p3
PREINIT:
	short(*func)(void *, float, char *, void *);
CODE:
	func   = INT2PTR(short(*)(void *, float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, t2, p3);
OUTPUT:
	RETVAL

float
nci_fpftp( c_func, p0, f1, t2, p3 )
	SV* c_func
	void * p0
	float f1
	char * t2
	void * p3
PREINIT:
	float(*func)(void *, float, char *, void *);
CODE:
	func   = INT2PTR(float(*)(void *, float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, t2, p3);
OUTPUT:
	RETVAL

char *
nci_tpftp( c_func, p0, f1, t2, p3 )
	SV* c_func
	void * p0
	float f1
	char * t2
	void * p3
PREINIT:
	char *(*func)(void *, float, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, t2, p3);
OUTPUT:
	RETVAL

int
nci_ipftp( c_func, p0, f1, t2, p3 )
	SV* c_func
	void * p0
	float f1
	char * t2
	void * p3
PREINIT:
	int(*func)(void *, float, char *, void *);
CODE:
	func   = INT2PTR(int(*)(void *, float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, t2, p3);
OUTPUT:
	RETVAL

void *
nci_pvftp( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvftp( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvftp( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svftp( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvftp( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvftp( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivftp( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdftp( c_func, d0, f1, t2, p3 )
	SV* c_func
	double d0
	float f1
	char * t2
	void * p3
PREINIT:
	void *(*func)(double, float, char *, void *);
CODE:
	func   = INT2PTR(void *(*)(double, float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, t2, p3);
OUTPUT:
	RETVAL

void
nci_vdftp( c_func, d0, f1, t2, p3 )
	SV* c_func
	double d0
	float f1
	char * t2
	void * p3
PREINIT:
	void(*func)(double, float, char *, void *);
CODE:
	func   = INT2PTR(void(*)(double, float, char *, void *), SvIV(c_func) );
	(*func)(d0, f1, t2, p3);

double
nci_ddftp( c_func, d0, f1, t2, p3 )
	SV* c_func
	double d0
	float f1
	char * t2
	void * p3
PREINIT:
	double(*func)(double, float, char *, void *);
CODE:
	func   = INT2PTR(double(*)(double, float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, t2, p3);
OUTPUT:
	RETVAL

short
nci_sdftp( c_func, d0, f1, t2, p3 )
	SV* c_func
	double d0
	float f1
	char * t2
	void * p3
PREINIT:
	short(*func)(double, float, char *, void *);
CODE:
	func   = INT2PTR(short(*)(double, float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, t2, p3);
OUTPUT:
	RETVAL

float
nci_fdftp( c_func, d0, f1, t2, p3 )
	SV* c_func
	double d0
	float f1
	char * t2
	void * p3
PREINIT:
	float(*func)(double, float, char *, void *);
CODE:
	func   = INT2PTR(float(*)(double, float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, t2, p3);
OUTPUT:
	RETVAL

char *
nci_tdftp( c_func, d0, f1, t2, p3 )
	SV* c_func
	double d0
	float f1
	char * t2
	void * p3
PREINIT:
	char *(*func)(double, float, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(double, float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, t2, p3);
OUTPUT:
	RETVAL

int
nci_idftp( c_func, d0, f1, t2, p3 )
	SV* c_func
	double d0
	float f1
	char * t2
	void * p3
PREINIT:
	int(*func)(double, float, char *, void *);
CODE:
	func   = INT2PTR(int(*)(double, float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, t2, p3);
OUTPUT:
	RETVAL

void *
nci_psftp( c_func, s0, f1, t2, p3 )
	SV* c_func
	short s0
	float f1
	char * t2
	void * p3
PREINIT:
	void *(*func)(short, float, char *, void *);
CODE:
	func   = INT2PTR(void *(*)(short, float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, t2, p3);
OUTPUT:
	RETVAL

void
nci_vsftp( c_func, s0, f1, t2, p3 )
	SV* c_func
	short s0
	float f1
	char * t2
	void * p3
PREINIT:
	void(*func)(short, float, char *, void *);
CODE:
	func   = INT2PTR(void(*)(short, float, char *, void *), SvIV(c_func) );
	(*func)(s0, f1, t2, p3);

double
nci_dsftp( c_func, s0, f1, t2, p3 )
	SV* c_func
	short s0
	float f1
	char * t2
	void * p3
PREINIT:
	double(*func)(short, float, char *, void *);
CODE:
	func   = INT2PTR(double(*)(short, float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, t2, p3);
OUTPUT:
	RETVAL

short
nci_ssftp( c_func, s0, f1, t2, p3 )
	SV* c_func
	short s0
	float f1
	char * t2
	void * p3
PREINIT:
	short(*func)(short, float, char *, void *);
CODE:
	func   = INT2PTR(short(*)(short, float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, t2, p3);
OUTPUT:
	RETVAL

float
nci_fsftp( c_func, s0, f1, t2, p3 )
	SV* c_func
	short s0
	float f1
	char * t2
	void * p3
PREINIT:
	float(*func)(short, float, char *, void *);
CODE:
	func   = INT2PTR(float(*)(short, float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, t2, p3);
OUTPUT:
	RETVAL

char *
nci_tsftp( c_func, s0, f1, t2, p3 )
	SV* c_func
	short s0
	float f1
	char * t2
	void * p3
PREINIT:
	char *(*func)(short, float, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(short, float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, t2, p3);
OUTPUT:
	RETVAL

int
nci_isftp( c_func, s0, f1, t2, p3 )
	SV* c_func
	short s0
	float f1
	char * t2
	void * p3
PREINIT:
	int(*func)(short, float, char *, void *);
CODE:
	func   = INT2PTR(int(*)(short, float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, t2, p3);
OUTPUT:
	RETVAL

void *
nci_pfftp( c_func, f0, f1, t2, p3 )
	SV* c_func
	float f0
	float f1
	char * t2
	void * p3
PREINIT:
	void *(*func)(float, float, char *, void *);
CODE:
	func   = INT2PTR(void *(*)(float, float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, t2, p3);
OUTPUT:
	RETVAL

void
nci_vfftp( c_func, f0, f1, t2, p3 )
	SV* c_func
	float f0
	float f1
	char * t2
	void * p3
PREINIT:
	void(*func)(float, float, char *, void *);
CODE:
	func   = INT2PTR(void(*)(float, float, char *, void *), SvIV(c_func) );
	(*func)(f0, f1, t2, p3);

double
nci_dfftp( c_func, f0, f1, t2, p3 )
	SV* c_func
	float f0
	float f1
	char * t2
	void * p3
PREINIT:
	double(*func)(float, float, char *, void *);
CODE:
	func   = INT2PTR(double(*)(float, float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, t2, p3);
OUTPUT:
	RETVAL

short
nci_sfftp( c_func, f0, f1, t2, p3 )
	SV* c_func
	float f0
	float f1
	char * t2
	void * p3
PREINIT:
	short(*func)(float, float, char *, void *);
CODE:
	func   = INT2PTR(short(*)(float, float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, t2, p3);
OUTPUT:
	RETVAL

float
nci_ffftp( c_func, f0, f1, t2, p3 )
	SV* c_func
	float f0
	float f1
	char * t2
	void * p3
PREINIT:
	float(*func)(float, float, char *, void *);
CODE:
	func   = INT2PTR(float(*)(float, float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, t2, p3);
OUTPUT:
	RETVAL

char *
nci_tfftp( c_func, f0, f1, t2, p3 )
	SV* c_func
	float f0
	float f1
	char * t2
	void * p3
PREINIT:
	char *(*func)(float, float, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(float, float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, t2, p3);
OUTPUT:
	RETVAL

int
nci_ifftp( c_func, f0, f1, t2, p3 )
	SV* c_func
	float f0
	float f1
	char * t2
	void * p3
PREINIT:
	int(*func)(float, float, char *, void *);
CODE:
	func   = INT2PTR(int(*)(float, float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, t2, p3);
OUTPUT:
	RETVAL

void *
nci_ptftp( c_func, t0, f1, t2, p3 )
	SV* c_func
	char * t0
	float f1
	char * t2
	void * p3
PREINIT:
	void *(*func)(char *, float, char *, void *);
CODE:
	func   = INT2PTR(void *(*)(char *, float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, t2, p3);
OUTPUT:
	RETVAL

void
nci_vtftp( c_func, t0, f1, t2, p3 )
	SV* c_func
	char * t0
	float f1
	char * t2
	void * p3
PREINIT:
	void(*func)(char *, float, char *, void *);
CODE:
	func   = INT2PTR(void(*)(char *, float, char *, void *), SvIV(c_func) );
	(*func)(t0, f1, t2, p3);

double
nci_dtftp( c_func, t0, f1, t2, p3 )
	SV* c_func
	char * t0
	float f1
	char * t2
	void * p3
PREINIT:
	double(*func)(char *, float, char *, void *);
CODE:
	func   = INT2PTR(double(*)(char *, float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, t2, p3);
OUTPUT:
	RETVAL

short
nci_stftp( c_func, t0, f1, t2, p3 )
	SV* c_func
	char * t0
	float f1
	char * t2
	void * p3
PREINIT:
	short(*func)(char *, float, char *, void *);
CODE:
	func   = INT2PTR(short(*)(char *, float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, t2, p3);
OUTPUT:
	RETVAL

float
nci_ftftp( c_func, t0, f1, t2, p3 )
	SV* c_func
	char * t0
	float f1
	char * t2
	void * p3
PREINIT:
	float(*func)(char *, float, char *, void *);
CODE:
	func   = INT2PTR(float(*)(char *, float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, t2, p3);
OUTPUT:
	RETVAL

char *
nci_ttftp( c_func, t0, f1, t2, p3 )
	SV* c_func
	char * t0
	float f1
	char * t2
	void * p3
PREINIT:
	char *(*func)(char *, float, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, t2, p3);
OUTPUT:
	RETVAL

int
nci_itftp( c_func, t0, f1, t2, p3 )
	SV* c_func
	char * t0
	float f1
	char * t2
	void * p3
PREINIT:
	int(*func)(char *, float, char *, void *);
CODE:
	func   = INT2PTR(int(*)(char *, float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, t2, p3);
OUTPUT:
	RETVAL

void *
nci_piftp( c_func, i0, f1, t2, p3 )
	SV* c_func
	int i0
	float f1
	char * t2
	void * p3
PREINIT:
	void *(*func)(int, float, char *, void *);
CODE:
	func   = INT2PTR(void *(*)(int, float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, t2, p3);
OUTPUT:
	RETVAL

void
nci_viftp( c_func, i0, f1, t2, p3 )
	SV* c_func
	int i0
	float f1
	char * t2
	void * p3
PREINIT:
	void(*func)(int, float, char *, void *);
CODE:
	func   = INT2PTR(void(*)(int, float, char *, void *), SvIV(c_func) );
	(*func)(i0, f1, t2, p3);

double
nci_diftp( c_func, i0, f1, t2, p3 )
	SV* c_func
	int i0
	float f1
	char * t2
	void * p3
PREINIT:
	double(*func)(int, float, char *, void *);
CODE:
	func   = INT2PTR(double(*)(int, float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, t2, p3);
OUTPUT:
	RETVAL

short
nci_siftp( c_func, i0, f1, t2, p3 )
	SV* c_func
	int i0
	float f1
	char * t2
	void * p3
PREINIT:
	short(*func)(int, float, char *, void *);
CODE:
	func   = INT2PTR(short(*)(int, float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, t2, p3);
OUTPUT:
	RETVAL

float
nci_fiftp( c_func, i0, f1, t2, p3 )
	SV* c_func
	int i0
	float f1
	char * t2
	void * p3
PREINIT:
	float(*func)(int, float, char *, void *);
CODE:
	func   = INT2PTR(float(*)(int, float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, t2, p3);
OUTPUT:
	RETVAL

char *
nci_tiftp( c_func, i0, f1, t2, p3 )
	SV* c_func
	int i0
	float f1
	char * t2
	void * p3
PREINIT:
	char *(*func)(int, float, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(int, float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, t2, p3);
OUTPUT:
	RETVAL

int
nci_iiftp( c_func, i0, f1, t2, p3 )
	SV* c_func
	int i0
	float f1
	char * t2
	void * p3
PREINIT:
	int(*func)(int, float, char *, void *);
CODE:
	func   = INT2PTR(int(*)(int, float, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, t2, p3);
OUTPUT:
	RETVAL

void *
nci_ppttp( c_func, p0, t1, t2, p3 )
	SV* c_func
	void * p0
	char * t1
	char * t2
	void * p3
PREINIT:
	void *(*func)(void *, char *, char *, void *);
CODE:
	func   = INT2PTR(void *(*)(void *, char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, t2, p3);
OUTPUT:
	RETVAL

void
nci_vpttp( c_func, p0, t1, t2, p3 )
	SV* c_func
	void * p0
	char * t1
	char * t2
	void * p3
PREINIT:
	void(*func)(void *, char *, char *, void *);
CODE:
	func   = INT2PTR(void(*)(void *, char *, char *, void *), SvIV(c_func) );
	(*func)(p0, t1, t2, p3);

double
nci_dpttp( c_func, p0, t1, t2, p3 )
	SV* c_func
	void * p0
	char * t1
	char * t2
	void * p3
PREINIT:
	double(*func)(void *, char *, char *, void *);
CODE:
	func   = INT2PTR(double(*)(void *, char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, t2, p3);
OUTPUT:
	RETVAL

short
nci_spttp( c_func, p0, t1, t2, p3 )
	SV* c_func
	void * p0
	char * t1
	char * t2
	void * p3
PREINIT:
	short(*func)(void *, char *, char *, void *);
CODE:
	func   = INT2PTR(short(*)(void *, char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, t2, p3);
OUTPUT:
	RETVAL

float
nci_fpttp( c_func, p0, t1, t2, p3 )
	SV* c_func
	void * p0
	char * t1
	char * t2
	void * p3
PREINIT:
	float(*func)(void *, char *, char *, void *);
CODE:
	func   = INT2PTR(float(*)(void *, char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, t2, p3);
OUTPUT:
	RETVAL

char *
nci_tpttp( c_func, p0, t1, t2, p3 )
	SV* c_func
	void * p0
	char * t1
	char * t2
	void * p3
PREINIT:
	char *(*func)(void *, char *, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, t2, p3);
OUTPUT:
	RETVAL

int
nci_ipttp( c_func, p0, t1, t2, p3 )
	SV* c_func
	void * p0
	char * t1
	char * t2
	void * p3
PREINIT:
	int(*func)(void *, char *, char *, void *);
CODE:
	func   = INT2PTR(int(*)(void *, char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, t2, p3);
OUTPUT:
	RETVAL

void *
nci_pvttp( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvttp( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvttp( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svttp( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvttp( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvttp( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivttp( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdttp( c_func, d0, t1, t2, p3 )
	SV* c_func
	double d0
	char * t1
	char * t2
	void * p3
PREINIT:
	void *(*func)(double, char *, char *, void *);
CODE:
	func   = INT2PTR(void *(*)(double, char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, t2, p3);
OUTPUT:
	RETVAL

void
nci_vdttp( c_func, d0, t1, t2, p3 )
	SV* c_func
	double d0
	char * t1
	char * t2
	void * p3
PREINIT:
	void(*func)(double, char *, char *, void *);
CODE:
	func   = INT2PTR(void(*)(double, char *, char *, void *), SvIV(c_func) );
	(*func)(d0, t1, t2, p3);

double
nci_ddttp( c_func, d0, t1, t2, p3 )
	SV* c_func
	double d0
	char * t1
	char * t2
	void * p3
PREINIT:
	double(*func)(double, char *, char *, void *);
CODE:
	func   = INT2PTR(double(*)(double, char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, t2, p3);
OUTPUT:
	RETVAL

short
nci_sdttp( c_func, d0, t1, t2, p3 )
	SV* c_func
	double d0
	char * t1
	char * t2
	void * p3
PREINIT:
	short(*func)(double, char *, char *, void *);
CODE:
	func   = INT2PTR(short(*)(double, char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, t2, p3);
OUTPUT:
	RETVAL

float
nci_fdttp( c_func, d0, t1, t2, p3 )
	SV* c_func
	double d0
	char * t1
	char * t2
	void * p3
PREINIT:
	float(*func)(double, char *, char *, void *);
CODE:
	func   = INT2PTR(float(*)(double, char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, t2, p3);
OUTPUT:
	RETVAL

char *
nci_tdttp( c_func, d0, t1, t2, p3 )
	SV* c_func
	double d0
	char * t1
	char * t2
	void * p3
PREINIT:
	char *(*func)(double, char *, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(double, char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, t2, p3);
OUTPUT:
	RETVAL

int
nci_idttp( c_func, d0, t1, t2, p3 )
	SV* c_func
	double d0
	char * t1
	char * t2
	void * p3
PREINIT:
	int(*func)(double, char *, char *, void *);
CODE:
	func   = INT2PTR(int(*)(double, char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, t2, p3);
OUTPUT:
	RETVAL

void *
nci_psttp( c_func, s0, t1, t2, p3 )
	SV* c_func
	short s0
	char * t1
	char * t2
	void * p3
PREINIT:
	void *(*func)(short, char *, char *, void *);
CODE:
	func   = INT2PTR(void *(*)(short, char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, t2, p3);
OUTPUT:
	RETVAL

void
nci_vsttp( c_func, s0, t1, t2, p3 )
	SV* c_func
	short s0
	char * t1
	char * t2
	void * p3
PREINIT:
	void(*func)(short, char *, char *, void *);
CODE:
	func   = INT2PTR(void(*)(short, char *, char *, void *), SvIV(c_func) );
	(*func)(s0, t1, t2, p3);

double
nci_dsttp( c_func, s0, t1, t2, p3 )
	SV* c_func
	short s0
	char * t1
	char * t2
	void * p3
PREINIT:
	double(*func)(short, char *, char *, void *);
CODE:
	func   = INT2PTR(double(*)(short, char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, t2, p3);
OUTPUT:
	RETVAL

short
nci_ssttp( c_func, s0, t1, t2, p3 )
	SV* c_func
	short s0
	char * t1
	char * t2
	void * p3
PREINIT:
	short(*func)(short, char *, char *, void *);
CODE:
	func   = INT2PTR(short(*)(short, char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, t2, p3);
OUTPUT:
	RETVAL

float
nci_fsttp( c_func, s0, t1, t2, p3 )
	SV* c_func
	short s0
	char * t1
	char * t2
	void * p3
PREINIT:
	float(*func)(short, char *, char *, void *);
CODE:
	func   = INT2PTR(float(*)(short, char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, t2, p3);
OUTPUT:
	RETVAL

char *
nci_tsttp( c_func, s0, t1, t2, p3 )
	SV* c_func
	short s0
	char * t1
	char * t2
	void * p3
PREINIT:
	char *(*func)(short, char *, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(short, char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, t2, p3);
OUTPUT:
	RETVAL

int
nci_isttp( c_func, s0, t1, t2, p3 )
	SV* c_func
	short s0
	char * t1
	char * t2
	void * p3
PREINIT:
	int(*func)(short, char *, char *, void *);
CODE:
	func   = INT2PTR(int(*)(short, char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, t2, p3);
OUTPUT:
	RETVAL

void *
nci_pfttp( c_func, f0, t1, t2, p3 )
	SV* c_func
	float f0
	char * t1
	char * t2
	void * p3
PREINIT:
	void *(*func)(float, char *, char *, void *);
CODE:
	func   = INT2PTR(void *(*)(float, char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, t2, p3);
OUTPUT:
	RETVAL

void
nci_vfttp( c_func, f0, t1, t2, p3 )
	SV* c_func
	float f0
	char * t1
	char * t2
	void * p3
PREINIT:
	void(*func)(float, char *, char *, void *);
CODE:
	func   = INT2PTR(void(*)(float, char *, char *, void *), SvIV(c_func) );
	(*func)(f0, t1, t2, p3);

double
nci_dfttp( c_func, f0, t1, t2, p3 )
	SV* c_func
	float f0
	char * t1
	char * t2
	void * p3
PREINIT:
	double(*func)(float, char *, char *, void *);
CODE:
	func   = INT2PTR(double(*)(float, char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, t2, p3);
OUTPUT:
	RETVAL

short
nci_sfttp( c_func, f0, t1, t2, p3 )
	SV* c_func
	float f0
	char * t1
	char * t2
	void * p3
PREINIT:
	short(*func)(float, char *, char *, void *);
CODE:
	func   = INT2PTR(short(*)(float, char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, t2, p3);
OUTPUT:
	RETVAL

float
nci_ffttp( c_func, f0, t1, t2, p3 )
	SV* c_func
	float f0
	char * t1
	char * t2
	void * p3
PREINIT:
	float(*func)(float, char *, char *, void *);
CODE:
	func   = INT2PTR(float(*)(float, char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, t2, p3);
OUTPUT:
	RETVAL

char *
nci_tfttp( c_func, f0, t1, t2, p3 )
	SV* c_func
	float f0
	char * t1
	char * t2
	void * p3
PREINIT:
	char *(*func)(float, char *, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(float, char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, t2, p3);
OUTPUT:
	RETVAL

int
nci_ifttp( c_func, f0, t1, t2, p3 )
	SV* c_func
	float f0
	char * t1
	char * t2
	void * p3
PREINIT:
	int(*func)(float, char *, char *, void *);
CODE:
	func   = INT2PTR(int(*)(float, char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, t2, p3);
OUTPUT:
	RETVAL

void *
nci_ptttp( c_func, t0, t1, t2, p3 )
	SV* c_func
	char * t0
	char * t1
	char * t2
	void * p3
PREINIT:
	void *(*func)(char *, char *, char *, void *);
CODE:
	func   = INT2PTR(void *(*)(char *, char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, t2, p3);
OUTPUT:
	RETVAL

void
nci_vtttp( c_func, t0, t1, t2, p3 )
	SV* c_func
	char * t0
	char * t1
	char * t2
	void * p3
PREINIT:
	void(*func)(char *, char *, char *, void *);
CODE:
	func   = INT2PTR(void(*)(char *, char *, char *, void *), SvIV(c_func) );
	(*func)(t0, t1, t2, p3);

double
nci_dtttp( c_func, t0, t1, t2, p3 )
	SV* c_func
	char * t0
	char * t1
	char * t2
	void * p3
PREINIT:
	double(*func)(char *, char *, char *, void *);
CODE:
	func   = INT2PTR(double(*)(char *, char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, t2, p3);
OUTPUT:
	RETVAL

short
nci_stttp( c_func, t0, t1, t2, p3 )
	SV* c_func
	char * t0
	char * t1
	char * t2
	void * p3
PREINIT:
	short(*func)(char *, char *, char *, void *);
CODE:
	func   = INT2PTR(short(*)(char *, char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, t2, p3);
OUTPUT:
	RETVAL

float
nci_ftttp( c_func, t0, t1, t2, p3 )
	SV* c_func
	char * t0
	char * t1
	char * t2
	void * p3
PREINIT:
	float(*func)(char *, char *, char *, void *);
CODE:
	func   = INT2PTR(float(*)(char *, char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, t2, p3);
OUTPUT:
	RETVAL

char *
nci_ttttp( c_func, t0, t1, t2, p3 )
	SV* c_func
	char * t0
	char * t1
	char * t2
	void * p3
PREINIT:
	char *(*func)(char *, char *, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, t2, p3);
OUTPUT:
	RETVAL

int
nci_itttp( c_func, t0, t1, t2, p3 )
	SV* c_func
	char * t0
	char * t1
	char * t2
	void * p3
PREINIT:
	int(*func)(char *, char *, char *, void *);
CODE:
	func   = INT2PTR(int(*)(char *, char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, t2, p3);
OUTPUT:
	RETVAL

void *
nci_pittp( c_func, i0, t1, t2, p3 )
	SV* c_func
	int i0
	char * t1
	char * t2
	void * p3
PREINIT:
	void *(*func)(int, char *, char *, void *);
CODE:
	func   = INT2PTR(void *(*)(int, char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, t2, p3);
OUTPUT:
	RETVAL

void
nci_vittp( c_func, i0, t1, t2, p3 )
	SV* c_func
	int i0
	char * t1
	char * t2
	void * p3
PREINIT:
	void(*func)(int, char *, char *, void *);
CODE:
	func   = INT2PTR(void(*)(int, char *, char *, void *), SvIV(c_func) );
	(*func)(i0, t1, t2, p3);

double
nci_dittp( c_func, i0, t1, t2, p3 )
	SV* c_func
	int i0
	char * t1
	char * t2
	void * p3
PREINIT:
	double(*func)(int, char *, char *, void *);
CODE:
	func   = INT2PTR(double(*)(int, char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, t2, p3);
OUTPUT:
	RETVAL

short
nci_sittp( c_func, i0, t1, t2, p3 )
	SV* c_func
	int i0
	char * t1
	char * t2
	void * p3
PREINIT:
	short(*func)(int, char *, char *, void *);
CODE:
	func   = INT2PTR(short(*)(int, char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, t2, p3);
OUTPUT:
	RETVAL

float
nci_fittp( c_func, i0, t1, t2, p3 )
	SV* c_func
	int i0
	char * t1
	char * t2
	void * p3
PREINIT:
	float(*func)(int, char *, char *, void *);
CODE:
	func   = INT2PTR(float(*)(int, char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, t2, p3);
OUTPUT:
	RETVAL

char *
nci_tittp( c_func, i0, t1, t2, p3 )
	SV* c_func
	int i0
	char * t1
	char * t2
	void * p3
PREINIT:
	char *(*func)(int, char *, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(int, char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, t2, p3);
OUTPUT:
	RETVAL

int
nci_iittp( c_func, i0, t1, t2, p3 )
	SV* c_func
	int i0
	char * t1
	char * t2
	void * p3
PREINIT:
	int(*func)(int, char *, char *, void *);
CODE:
	func   = INT2PTR(int(*)(int, char *, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, t2, p3);
OUTPUT:
	RETVAL

void *
nci_ppitp( c_func, p0, i1, t2, p3 )
	SV* c_func
	void * p0
	int i1
	char * t2
	void * p3
PREINIT:
	void *(*func)(void *, int, char *, void *);
CODE:
	func   = INT2PTR(void *(*)(void *, int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, t2, p3);
OUTPUT:
	RETVAL

void
nci_vpitp( c_func, p0, i1, t2, p3 )
	SV* c_func
	void * p0
	int i1
	char * t2
	void * p3
PREINIT:
	void(*func)(void *, int, char *, void *);
CODE:
	func   = INT2PTR(void(*)(void *, int, char *, void *), SvIV(c_func) );
	(*func)(p0, i1, t2, p3);

double
nci_dpitp( c_func, p0, i1, t2, p3 )
	SV* c_func
	void * p0
	int i1
	char * t2
	void * p3
PREINIT:
	double(*func)(void *, int, char *, void *);
CODE:
	func   = INT2PTR(double(*)(void *, int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, t2, p3);
OUTPUT:
	RETVAL

short
nci_spitp( c_func, p0, i1, t2, p3 )
	SV* c_func
	void * p0
	int i1
	char * t2
	void * p3
PREINIT:
	short(*func)(void *, int, char *, void *);
CODE:
	func   = INT2PTR(short(*)(void *, int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, t2, p3);
OUTPUT:
	RETVAL

float
nci_fpitp( c_func, p0, i1, t2, p3 )
	SV* c_func
	void * p0
	int i1
	char * t2
	void * p3
PREINIT:
	float(*func)(void *, int, char *, void *);
CODE:
	func   = INT2PTR(float(*)(void *, int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, t2, p3);
OUTPUT:
	RETVAL

char *
nci_tpitp( c_func, p0, i1, t2, p3 )
	SV* c_func
	void * p0
	int i1
	char * t2
	void * p3
PREINIT:
	char *(*func)(void *, int, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, t2, p3);
OUTPUT:
	RETVAL

int
nci_ipitp( c_func, p0, i1, t2, p3 )
	SV* c_func
	void * p0
	int i1
	char * t2
	void * p3
PREINIT:
	int(*func)(void *, int, char *, void *);
CODE:
	func   = INT2PTR(int(*)(void *, int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, t2, p3);
OUTPUT:
	RETVAL

void *
nci_pvitp( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvitp( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvitp( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svitp( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvitp( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvitp( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivitp( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pditp( c_func, d0, i1, t2, p3 )
	SV* c_func
	double d0
	int i1
	char * t2
	void * p3
PREINIT:
	void *(*func)(double, int, char *, void *);
CODE:
	func   = INT2PTR(void *(*)(double, int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, t2, p3);
OUTPUT:
	RETVAL

void
nci_vditp( c_func, d0, i1, t2, p3 )
	SV* c_func
	double d0
	int i1
	char * t2
	void * p3
PREINIT:
	void(*func)(double, int, char *, void *);
CODE:
	func   = INT2PTR(void(*)(double, int, char *, void *), SvIV(c_func) );
	(*func)(d0, i1, t2, p3);

double
nci_dditp( c_func, d0, i1, t2, p3 )
	SV* c_func
	double d0
	int i1
	char * t2
	void * p3
PREINIT:
	double(*func)(double, int, char *, void *);
CODE:
	func   = INT2PTR(double(*)(double, int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, t2, p3);
OUTPUT:
	RETVAL

short
nci_sditp( c_func, d0, i1, t2, p3 )
	SV* c_func
	double d0
	int i1
	char * t2
	void * p3
PREINIT:
	short(*func)(double, int, char *, void *);
CODE:
	func   = INT2PTR(short(*)(double, int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, t2, p3);
OUTPUT:
	RETVAL

float
nci_fditp( c_func, d0, i1, t2, p3 )
	SV* c_func
	double d0
	int i1
	char * t2
	void * p3
PREINIT:
	float(*func)(double, int, char *, void *);
CODE:
	func   = INT2PTR(float(*)(double, int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, t2, p3);
OUTPUT:
	RETVAL

char *
nci_tditp( c_func, d0, i1, t2, p3 )
	SV* c_func
	double d0
	int i1
	char * t2
	void * p3
PREINIT:
	char *(*func)(double, int, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(double, int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, t2, p3);
OUTPUT:
	RETVAL

int
nci_iditp( c_func, d0, i1, t2, p3 )
	SV* c_func
	double d0
	int i1
	char * t2
	void * p3
PREINIT:
	int(*func)(double, int, char *, void *);
CODE:
	func   = INT2PTR(int(*)(double, int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, t2, p3);
OUTPUT:
	RETVAL

void *
nci_psitp( c_func, s0, i1, t2, p3 )
	SV* c_func
	short s0
	int i1
	char * t2
	void * p3
PREINIT:
	void *(*func)(short, int, char *, void *);
CODE:
	func   = INT2PTR(void *(*)(short, int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, t2, p3);
OUTPUT:
	RETVAL

void
nci_vsitp( c_func, s0, i1, t2, p3 )
	SV* c_func
	short s0
	int i1
	char * t2
	void * p3
PREINIT:
	void(*func)(short, int, char *, void *);
CODE:
	func   = INT2PTR(void(*)(short, int, char *, void *), SvIV(c_func) );
	(*func)(s0, i1, t2, p3);

double
nci_dsitp( c_func, s0, i1, t2, p3 )
	SV* c_func
	short s0
	int i1
	char * t2
	void * p3
PREINIT:
	double(*func)(short, int, char *, void *);
CODE:
	func   = INT2PTR(double(*)(short, int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, t2, p3);
OUTPUT:
	RETVAL

short
nci_ssitp( c_func, s0, i1, t2, p3 )
	SV* c_func
	short s0
	int i1
	char * t2
	void * p3
PREINIT:
	short(*func)(short, int, char *, void *);
CODE:
	func   = INT2PTR(short(*)(short, int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, t2, p3);
OUTPUT:
	RETVAL

float
nci_fsitp( c_func, s0, i1, t2, p3 )
	SV* c_func
	short s0
	int i1
	char * t2
	void * p3
PREINIT:
	float(*func)(short, int, char *, void *);
CODE:
	func   = INT2PTR(float(*)(short, int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, t2, p3);
OUTPUT:
	RETVAL

char *
nci_tsitp( c_func, s0, i1, t2, p3 )
	SV* c_func
	short s0
	int i1
	char * t2
	void * p3
PREINIT:
	char *(*func)(short, int, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(short, int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, t2, p3);
OUTPUT:
	RETVAL

int
nci_isitp( c_func, s0, i1, t2, p3 )
	SV* c_func
	short s0
	int i1
	char * t2
	void * p3
PREINIT:
	int(*func)(short, int, char *, void *);
CODE:
	func   = INT2PTR(int(*)(short, int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, t2, p3);
OUTPUT:
	RETVAL

void *
nci_pfitp( c_func, f0, i1, t2, p3 )
	SV* c_func
	float f0
	int i1
	char * t2
	void * p3
PREINIT:
	void *(*func)(float, int, char *, void *);
CODE:
	func   = INT2PTR(void *(*)(float, int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, t2, p3);
OUTPUT:
	RETVAL

void
nci_vfitp( c_func, f0, i1, t2, p3 )
	SV* c_func
	float f0
	int i1
	char * t2
	void * p3
PREINIT:
	void(*func)(float, int, char *, void *);
CODE:
	func   = INT2PTR(void(*)(float, int, char *, void *), SvIV(c_func) );
	(*func)(f0, i1, t2, p3);

double
nci_dfitp( c_func, f0, i1, t2, p3 )
	SV* c_func
	float f0
	int i1
	char * t2
	void * p3
PREINIT:
	double(*func)(float, int, char *, void *);
CODE:
	func   = INT2PTR(double(*)(float, int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, t2, p3);
OUTPUT:
	RETVAL

short
nci_sfitp( c_func, f0, i1, t2, p3 )
	SV* c_func
	float f0
	int i1
	char * t2
	void * p3
PREINIT:
	short(*func)(float, int, char *, void *);
CODE:
	func   = INT2PTR(short(*)(float, int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, t2, p3);
OUTPUT:
	RETVAL

float
nci_ffitp( c_func, f0, i1, t2, p3 )
	SV* c_func
	float f0
	int i1
	char * t2
	void * p3
PREINIT:
	float(*func)(float, int, char *, void *);
CODE:
	func   = INT2PTR(float(*)(float, int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, t2, p3);
OUTPUT:
	RETVAL

char *
nci_tfitp( c_func, f0, i1, t2, p3 )
	SV* c_func
	float f0
	int i1
	char * t2
	void * p3
PREINIT:
	char *(*func)(float, int, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(float, int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, t2, p3);
OUTPUT:
	RETVAL

int
nci_ifitp( c_func, f0, i1, t2, p3 )
	SV* c_func
	float f0
	int i1
	char * t2
	void * p3
PREINIT:
	int(*func)(float, int, char *, void *);
CODE:
	func   = INT2PTR(int(*)(float, int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, t2, p3);
OUTPUT:
	RETVAL

void *
nci_ptitp( c_func, t0, i1, t2, p3 )
	SV* c_func
	char * t0
	int i1
	char * t2
	void * p3
PREINIT:
	void *(*func)(char *, int, char *, void *);
CODE:
	func   = INT2PTR(void *(*)(char *, int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, t2, p3);
OUTPUT:
	RETVAL

void
nci_vtitp( c_func, t0, i1, t2, p3 )
	SV* c_func
	char * t0
	int i1
	char * t2
	void * p3
PREINIT:
	void(*func)(char *, int, char *, void *);
CODE:
	func   = INT2PTR(void(*)(char *, int, char *, void *), SvIV(c_func) );
	(*func)(t0, i1, t2, p3);

double
nci_dtitp( c_func, t0, i1, t2, p3 )
	SV* c_func
	char * t0
	int i1
	char * t2
	void * p3
PREINIT:
	double(*func)(char *, int, char *, void *);
CODE:
	func   = INT2PTR(double(*)(char *, int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, t2, p3);
OUTPUT:
	RETVAL

short
nci_stitp( c_func, t0, i1, t2, p3 )
	SV* c_func
	char * t0
	int i1
	char * t2
	void * p3
PREINIT:
	short(*func)(char *, int, char *, void *);
CODE:
	func   = INT2PTR(short(*)(char *, int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, t2, p3);
OUTPUT:
	RETVAL

float
nci_ftitp( c_func, t0, i1, t2, p3 )
	SV* c_func
	char * t0
	int i1
	char * t2
	void * p3
PREINIT:
	float(*func)(char *, int, char *, void *);
CODE:
	func   = INT2PTR(float(*)(char *, int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, t2, p3);
OUTPUT:
	RETVAL

char *
nci_ttitp( c_func, t0, i1, t2, p3 )
	SV* c_func
	char * t0
	int i1
	char * t2
	void * p3
PREINIT:
	char *(*func)(char *, int, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, t2, p3);
OUTPUT:
	RETVAL

int
nci_ititp( c_func, t0, i1, t2, p3 )
	SV* c_func
	char * t0
	int i1
	char * t2
	void * p3
PREINIT:
	int(*func)(char *, int, char *, void *);
CODE:
	func   = INT2PTR(int(*)(char *, int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, t2, p3);
OUTPUT:
	RETVAL

void *
nci_piitp( c_func, i0, i1, t2, p3 )
	SV* c_func
	int i0
	int i1
	char * t2
	void * p3
PREINIT:
	void *(*func)(int, int, char *, void *);
CODE:
	func   = INT2PTR(void *(*)(int, int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, t2, p3);
OUTPUT:
	RETVAL

void
nci_viitp( c_func, i0, i1, t2, p3 )
	SV* c_func
	int i0
	int i1
	char * t2
	void * p3
PREINIT:
	void(*func)(int, int, char *, void *);
CODE:
	func   = INT2PTR(void(*)(int, int, char *, void *), SvIV(c_func) );
	(*func)(i0, i1, t2, p3);

double
nci_diitp( c_func, i0, i1, t2, p3 )
	SV* c_func
	int i0
	int i1
	char * t2
	void * p3
PREINIT:
	double(*func)(int, int, char *, void *);
CODE:
	func   = INT2PTR(double(*)(int, int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, t2, p3);
OUTPUT:
	RETVAL

short
nci_siitp( c_func, i0, i1, t2, p3 )
	SV* c_func
	int i0
	int i1
	char * t2
	void * p3
PREINIT:
	short(*func)(int, int, char *, void *);
CODE:
	func   = INT2PTR(short(*)(int, int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, t2, p3);
OUTPUT:
	RETVAL

float
nci_fiitp( c_func, i0, i1, t2, p3 )
	SV* c_func
	int i0
	int i1
	char * t2
	void * p3
PREINIT:
	float(*func)(int, int, char *, void *);
CODE:
	func   = INT2PTR(float(*)(int, int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, t2, p3);
OUTPUT:
	RETVAL

char *
nci_tiitp( c_func, i0, i1, t2, p3 )
	SV* c_func
	int i0
	int i1
	char * t2
	void * p3
PREINIT:
	char *(*func)(int, int, char *, void *);
CODE:
	func   = INT2PTR(char *(*)(int, int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, t2, p3);
OUTPUT:
	RETVAL

int
nci_iiitp( c_func, i0, i1, t2, p3 )
	SV* c_func
	int i0
	int i1
	char * t2
	void * p3
PREINIT:
	int(*func)(int, int, char *, void *);
CODE:
	func   = INT2PTR(int(*)(int, int, char *, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, t2, p3);
OUTPUT:
	RETVAL

void *
nci_pppip( c_func, p0, p1, i2, p3 )
	SV* c_func
	void * p0
	void * p1
	int i2
	void * p3
PREINIT:
	void *(*func)(void *, void *, int, void *);
CODE:
	func   = INT2PTR(void *(*)(void *, void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, i2, p3);
OUTPUT:
	RETVAL

void
nci_vppip( c_func, p0, p1, i2, p3 )
	SV* c_func
	void * p0
	void * p1
	int i2
	void * p3
PREINIT:
	void(*func)(void *, void *, int, void *);
CODE:
	func   = INT2PTR(void(*)(void *, void *, int, void *), SvIV(c_func) );
	(*func)(p0, p1, i2, p3);

double
nci_dppip( c_func, p0, p1, i2, p3 )
	SV* c_func
	void * p0
	void * p1
	int i2
	void * p3
PREINIT:
	double(*func)(void *, void *, int, void *);
CODE:
	func   = INT2PTR(double(*)(void *, void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, i2, p3);
OUTPUT:
	RETVAL

short
nci_sppip( c_func, p0, p1, i2, p3 )
	SV* c_func
	void * p0
	void * p1
	int i2
	void * p3
PREINIT:
	short(*func)(void *, void *, int, void *);
CODE:
	func   = INT2PTR(short(*)(void *, void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, i2, p3);
OUTPUT:
	RETVAL

float
nci_fppip( c_func, p0, p1, i2, p3 )
	SV* c_func
	void * p0
	void * p1
	int i2
	void * p3
PREINIT:
	float(*func)(void *, void *, int, void *);
CODE:
	func   = INT2PTR(float(*)(void *, void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, i2, p3);
OUTPUT:
	RETVAL

char *
nci_tppip( c_func, p0, p1, i2, p3 )
	SV* c_func
	void * p0
	void * p1
	int i2
	void * p3
PREINIT:
	char *(*func)(void *, void *, int, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, i2, p3);
OUTPUT:
	RETVAL

int
nci_ippip( c_func, p0, p1, i2, p3 )
	SV* c_func
	void * p0
	void * p1
	int i2
	void * p3
PREINIT:
	int(*func)(void *, void *, int, void *);
CODE:
	func   = INT2PTR(int(*)(void *, void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, i2, p3);
OUTPUT:
	RETVAL

void *
nci_pvpip( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvpip( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvpip( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svpip( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvpip( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvpip( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivpip( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdpip( c_func, d0, p1, i2, p3 )
	SV* c_func
	double d0
	void * p1
	int i2
	void * p3
PREINIT:
	void *(*func)(double, void *, int, void *);
CODE:
	func   = INT2PTR(void *(*)(double, void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, i2, p3);
OUTPUT:
	RETVAL

void
nci_vdpip( c_func, d0, p1, i2, p3 )
	SV* c_func
	double d0
	void * p1
	int i2
	void * p3
PREINIT:
	void(*func)(double, void *, int, void *);
CODE:
	func   = INT2PTR(void(*)(double, void *, int, void *), SvIV(c_func) );
	(*func)(d0, p1, i2, p3);

double
nci_ddpip( c_func, d0, p1, i2, p3 )
	SV* c_func
	double d0
	void * p1
	int i2
	void * p3
PREINIT:
	double(*func)(double, void *, int, void *);
CODE:
	func   = INT2PTR(double(*)(double, void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, i2, p3);
OUTPUT:
	RETVAL

short
nci_sdpip( c_func, d0, p1, i2, p3 )
	SV* c_func
	double d0
	void * p1
	int i2
	void * p3
PREINIT:
	short(*func)(double, void *, int, void *);
CODE:
	func   = INT2PTR(short(*)(double, void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, i2, p3);
OUTPUT:
	RETVAL

float
nci_fdpip( c_func, d0, p1, i2, p3 )
	SV* c_func
	double d0
	void * p1
	int i2
	void * p3
PREINIT:
	float(*func)(double, void *, int, void *);
CODE:
	func   = INT2PTR(float(*)(double, void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, i2, p3);
OUTPUT:
	RETVAL

char *
nci_tdpip( c_func, d0, p1, i2, p3 )
	SV* c_func
	double d0
	void * p1
	int i2
	void * p3
PREINIT:
	char *(*func)(double, void *, int, void *);
CODE:
	func   = INT2PTR(char *(*)(double, void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, i2, p3);
OUTPUT:
	RETVAL

int
nci_idpip( c_func, d0, p1, i2, p3 )
	SV* c_func
	double d0
	void * p1
	int i2
	void * p3
PREINIT:
	int(*func)(double, void *, int, void *);
CODE:
	func   = INT2PTR(int(*)(double, void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, i2, p3);
OUTPUT:
	RETVAL

void *
nci_pspip( c_func, s0, p1, i2, p3 )
	SV* c_func
	short s0
	void * p1
	int i2
	void * p3
PREINIT:
	void *(*func)(short, void *, int, void *);
CODE:
	func   = INT2PTR(void *(*)(short, void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, i2, p3);
OUTPUT:
	RETVAL

void
nci_vspip( c_func, s0, p1, i2, p3 )
	SV* c_func
	short s0
	void * p1
	int i2
	void * p3
PREINIT:
	void(*func)(short, void *, int, void *);
CODE:
	func   = INT2PTR(void(*)(short, void *, int, void *), SvIV(c_func) );
	(*func)(s0, p1, i2, p3);

double
nci_dspip( c_func, s0, p1, i2, p3 )
	SV* c_func
	short s0
	void * p1
	int i2
	void * p3
PREINIT:
	double(*func)(short, void *, int, void *);
CODE:
	func   = INT2PTR(double(*)(short, void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, i2, p3);
OUTPUT:
	RETVAL

short
nci_sspip( c_func, s0, p1, i2, p3 )
	SV* c_func
	short s0
	void * p1
	int i2
	void * p3
PREINIT:
	short(*func)(short, void *, int, void *);
CODE:
	func   = INT2PTR(short(*)(short, void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, i2, p3);
OUTPUT:
	RETVAL

float
nci_fspip( c_func, s0, p1, i2, p3 )
	SV* c_func
	short s0
	void * p1
	int i2
	void * p3
PREINIT:
	float(*func)(short, void *, int, void *);
CODE:
	func   = INT2PTR(float(*)(short, void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, i2, p3);
OUTPUT:
	RETVAL

char *
nci_tspip( c_func, s0, p1, i2, p3 )
	SV* c_func
	short s0
	void * p1
	int i2
	void * p3
PREINIT:
	char *(*func)(short, void *, int, void *);
CODE:
	func   = INT2PTR(char *(*)(short, void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, i2, p3);
OUTPUT:
	RETVAL

int
nci_ispip( c_func, s0, p1, i2, p3 )
	SV* c_func
	short s0
	void * p1
	int i2
	void * p3
PREINIT:
	int(*func)(short, void *, int, void *);
CODE:
	func   = INT2PTR(int(*)(short, void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, i2, p3);
OUTPUT:
	RETVAL

void *
nci_pfpip( c_func, f0, p1, i2, p3 )
	SV* c_func
	float f0
	void * p1
	int i2
	void * p3
PREINIT:
	void *(*func)(float, void *, int, void *);
CODE:
	func   = INT2PTR(void *(*)(float, void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, i2, p3);
OUTPUT:
	RETVAL

void
nci_vfpip( c_func, f0, p1, i2, p3 )
	SV* c_func
	float f0
	void * p1
	int i2
	void * p3
PREINIT:
	void(*func)(float, void *, int, void *);
CODE:
	func   = INT2PTR(void(*)(float, void *, int, void *), SvIV(c_func) );
	(*func)(f0, p1, i2, p3);

double
nci_dfpip( c_func, f0, p1, i2, p3 )
	SV* c_func
	float f0
	void * p1
	int i2
	void * p3
PREINIT:
	double(*func)(float, void *, int, void *);
CODE:
	func   = INT2PTR(double(*)(float, void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, i2, p3);
OUTPUT:
	RETVAL

short
nci_sfpip( c_func, f0, p1, i2, p3 )
	SV* c_func
	float f0
	void * p1
	int i2
	void * p3
PREINIT:
	short(*func)(float, void *, int, void *);
CODE:
	func   = INT2PTR(short(*)(float, void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, i2, p3);
OUTPUT:
	RETVAL

float
nci_ffpip( c_func, f0, p1, i2, p3 )
	SV* c_func
	float f0
	void * p1
	int i2
	void * p3
PREINIT:
	float(*func)(float, void *, int, void *);
CODE:
	func   = INT2PTR(float(*)(float, void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, i2, p3);
OUTPUT:
	RETVAL

char *
nci_tfpip( c_func, f0, p1, i2, p3 )
	SV* c_func
	float f0
	void * p1
	int i2
	void * p3
PREINIT:
	char *(*func)(float, void *, int, void *);
CODE:
	func   = INT2PTR(char *(*)(float, void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, i2, p3);
OUTPUT:
	RETVAL

int
nci_ifpip( c_func, f0, p1, i2, p3 )
	SV* c_func
	float f0
	void * p1
	int i2
	void * p3
PREINIT:
	int(*func)(float, void *, int, void *);
CODE:
	func   = INT2PTR(int(*)(float, void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, i2, p3);
OUTPUT:
	RETVAL

void *
nci_ptpip( c_func, t0, p1, i2, p3 )
	SV* c_func
	char * t0
	void * p1
	int i2
	void * p3
PREINIT:
	void *(*func)(char *, void *, int, void *);
CODE:
	func   = INT2PTR(void *(*)(char *, void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, i2, p3);
OUTPUT:
	RETVAL

void
nci_vtpip( c_func, t0, p1, i2, p3 )
	SV* c_func
	char * t0
	void * p1
	int i2
	void * p3
PREINIT:
	void(*func)(char *, void *, int, void *);
CODE:
	func   = INT2PTR(void(*)(char *, void *, int, void *), SvIV(c_func) );
	(*func)(t0, p1, i2, p3);

double
nci_dtpip( c_func, t0, p1, i2, p3 )
	SV* c_func
	char * t0
	void * p1
	int i2
	void * p3
PREINIT:
	double(*func)(char *, void *, int, void *);
CODE:
	func   = INT2PTR(double(*)(char *, void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, i2, p3);
OUTPUT:
	RETVAL

short
nci_stpip( c_func, t0, p1, i2, p3 )
	SV* c_func
	char * t0
	void * p1
	int i2
	void * p3
PREINIT:
	short(*func)(char *, void *, int, void *);
CODE:
	func   = INT2PTR(short(*)(char *, void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, i2, p3);
OUTPUT:
	RETVAL

float
nci_ftpip( c_func, t0, p1, i2, p3 )
	SV* c_func
	char * t0
	void * p1
	int i2
	void * p3
PREINIT:
	float(*func)(char *, void *, int, void *);
CODE:
	func   = INT2PTR(float(*)(char *, void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, i2, p3);
OUTPUT:
	RETVAL

char *
nci_ttpip( c_func, t0, p1, i2, p3 )
	SV* c_func
	char * t0
	void * p1
	int i2
	void * p3
PREINIT:
	char *(*func)(char *, void *, int, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, i2, p3);
OUTPUT:
	RETVAL

int
nci_itpip( c_func, t0, p1, i2, p3 )
	SV* c_func
	char * t0
	void * p1
	int i2
	void * p3
PREINIT:
	int(*func)(char *, void *, int, void *);
CODE:
	func   = INT2PTR(int(*)(char *, void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, i2, p3);
OUTPUT:
	RETVAL

void *
nci_pipip( c_func, i0, p1, i2, p3 )
	SV* c_func
	int i0
	void * p1
	int i2
	void * p3
PREINIT:
	void *(*func)(int, void *, int, void *);
CODE:
	func   = INT2PTR(void *(*)(int, void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, i2, p3);
OUTPUT:
	RETVAL

void
nci_vipip( c_func, i0, p1, i2, p3 )
	SV* c_func
	int i0
	void * p1
	int i2
	void * p3
PREINIT:
	void(*func)(int, void *, int, void *);
CODE:
	func   = INT2PTR(void(*)(int, void *, int, void *), SvIV(c_func) );
	(*func)(i0, p1, i2, p3);

double
nci_dipip( c_func, i0, p1, i2, p3 )
	SV* c_func
	int i0
	void * p1
	int i2
	void * p3
PREINIT:
	double(*func)(int, void *, int, void *);
CODE:
	func   = INT2PTR(double(*)(int, void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, i2, p3);
OUTPUT:
	RETVAL

short
nci_sipip( c_func, i0, p1, i2, p3 )
	SV* c_func
	int i0
	void * p1
	int i2
	void * p3
PREINIT:
	short(*func)(int, void *, int, void *);
CODE:
	func   = INT2PTR(short(*)(int, void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, i2, p3);
OUTPUT:
	RETVAL

float
nci_fipip( c_func, i0, p1, i2, p3 )
	SV* c_func
	int i0
	void * p1
	int i2
	void * p3
PREINIT:
	float(*func)(int, void *, int, void *);
CODE:
	func   = INT2PTR(float(*)(int, void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, i2, p3);
OUTPUT:
	RETVAL

char *
nci_tipip( c_func, i0, p1, i2, p3 )
	SV* c_func
	int i0
	void * p1
	int i2
	void * p3
PREINIT:
	char *(*func)(int, void *, int, void *);
CODE:
	func   = INT2PTR(char *(*)(int, void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, i2, p3);
OUTPUT:
	RETVAL

int
nci_iipip( c_func, i0, p1, i2, p3 )
	SV* c_func
	int i0
	void * p1
	int i2
	void * p3
PREINIT:
	int(*func)(int, void *, int, void *);
CODE:
	func   = INT2PTR(int(*)(int, void *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, i2, p3);
OUTPUT:
	RETVAL

void *
nci_ppdip( c_func, p0, d1, i2, p3 )
	SV* c_func
	void * p0
	double d1
	int i2
	void * p3
PREINIT:
	void *(*func)(void *, double, int, void *);
CODE:
	func   = INT2PTR(void *(*)(void *, double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, i2, p3);
OUTPUT:
	RETVAL

void
nci_vpdip( c_func, p0, d1, i2, p3 )
	SV* c_func
	void * p0
	double d1
	int i2
	void * p3
PREINIT:
	void(*func)(void *, double, int, void *);
CODE:
	func   = INT2PTR(void(*)(void *, double, int, void *), SvIV(c_func) );
	(*func)(p0, d1, i2, p3);

double
nci_dpdip( c_func, p0, d1, i2, p3 )
	SV* c_func
	void * p0
	double d1
	int i2
	void * p3
PREINIT:
	double(*func)(void *, double, int, void *);
CODE:
	func   = INT2PTR(double(*)(void *, double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, i2, p3);
OUTPUT:
	RETVAL

short
nci_spdip( c_func, p0, d1, i2, p3 )
	SV* c_func
	void * p0
	double d1
	int i2
	void * p3
PREINIT:
	short(*func)(void *, double, int, void *);
CODE:
	func   = INT2PTR(short(*)(void *, double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, i2, p3);
OUTPUT:
	RETVAL

float
nci_fpdip( c_func, p0, d1, i2, p3 )
	SV* c_func
	void * p0
	double d1
	int i2
	void * p3
PREINIT:
	float(*func)(void *, double, int, void *);
CODE:
	func   = INT2PTR(float(*)(void *, double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, i2, p3);
OUTPUT:
	RETVAL

char *
nci_tpdip( c_func, p0, d1, i2, p3 )
	SV* c_func
	void * p0
	double d1
	int i2
	void * p3
PREINIT:
	char *(*func)(void *, double, int, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, i2, p3);
OUTPUT:
	RETVAL

int
nci_ipdip( c_func, p0, d1, i2, p3 )
	SV* c_func
	void * p0
	double d1
	int i2
	void * p3
PREINIT:
	int(*func)(void *, double, int, void *);
CODE:
	func   = INT2PTR(int(*)(void *, double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, i2, p3);
OUTPUT:
	RETVAL

void *
nci_pvdip( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvdip( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvdip( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svdip( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvdip( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvdip( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivdip( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pddip( c_func, d0, d1, i2, p3 )
	SV* c_func
	double d0
	double d1
	int i2
	void * p3
PREINIT:
	void *(*func)(double, double, int, void *);
CODE:
	func   = INT2PTR(void *(*)(double, double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, i2, p3);
OUTPUT:
	RETVAL

void
nci_vddip( c_func, d0, d1, i2, p3 )
	SV* c_func
	double d0
	double d1
	int i2
	void * p3
PREINIT:
	void(*func)(double, double, int, void *);
CODE:
	func   = INT2PTR(void(*)(double, double, int, void *), SvIV(c_func) );
	(*func)(d0, d1, i2, p3);

double
nci_dddip( c_func, d0, d1, i2, p3 )
	SV* c_func
	double d0
	double d1
	int i2
	void * p3
PREINIT:
	double(*func)(double, double, int, void *);
CODE:
	func   = INT2PTR(double(*)(double, double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, i2, p3);
OUTPUT:
	RETVAL

short
nci_sddip( c_func, d0, d1, i2, p3 )
	SV* c_func
	double d0
	double d1
	int i2
	void * p3
PREINIT:
	short(*func)(double, double, int, void *);
CODE:
	func   = INT2PTR(short(*)(double, double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, i2, p3);
OUTPUT:
	RETVAL

float
nci_fddip( c_func, d0, d1, i2, p3 )
	SV* c_func
	double d0
	double d1
	int i2
	void * p3
PREINIT:
	float(*func)(double, double, int, void *);
CODE:
	func   = INT2PTR(float(*)(double, double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, i2, p3);
OUTPUT:
	RETVAL

char *
nci_tddip( c_func, d0, d1, i2, p3 )
	SV* c_func
	double d0
	double d1
	int i2
	void * p3
PREINIT:
	char *(*func)(double, double, int, void *);
CODE:
	func   = INT2PTR(char *(*)(double, double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, i2, p3);
OUTPUT:
	RETVAL

int
nci_iddip( c_func, d0, d1, i2, p3 )
	SV* c_func
	double d0
	double d1
	int i2
	void * p3
PREINIT:
	int(*func)(double, double, int, void *);
CODE:
	func   = INT2PTR(int(*)(double, double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, i2, p3);
OUTPUT:
	RETVAL

void *
nci_psdip( c_func, s0, d1, i2, p3 )
	SV* c_func
	short s0
	double d1
	int i2
	void * p3
PREINIT:
	void *(*func)(short, double, int, void *);
CODE:
	func   = INT2PTR(void *(*)(short, double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, i2, p3);
OUTPUT:
	RETVAL

void
nci_vsdip( c_func, s0, d1, i2, p3 )
	SV* c_func
	short s0
	double d1
	int i2
	void * p3
PREINIT:
	void(*func)(short, double, int, void *);
CODE:
	func   = INT2PTR(void(*)(short, double, int, void *), SvIV(c_func) );
	(*func)(s0, d1, i2, p3);

double
nci_dsdip( c_func, s0, d1, i2, p3 )
	SV* c_func
	short s0
	double d1
	int i2
	void * p3
PREINIT:
	double(*func)(short, double, int, void *);
CODE:
	func   = INT2PTR(double(*)(short, double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, i2, p3);
OUTPUT:
	RETVAL

short
nci_ssdip( c_func, s0, d1, i2, p3 )
	SV* c_func
	short s0
	double d1
	int i2
	void * p3
PREINIT:
	short(*func)(short, double, int, void *);
CODE:
	func   = INT2PTR(short(*)(short, double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, i2, p3);
OUTPUT:
	RETVAL

float
nci_fsdip( c_func, s0, d1, i2, p3 )
	SV* c_func
	short s0
	double d1
	int i2
	void * p3
PREINIT:
	float(*func)(short, double, int, void *);
CODE:
	func   = INT2PTR(float(*)(short, double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, i2, p3);
OUTPUT:
	RETVAL

char *
nci_tsdip( c_func, s0, d1, i2, p3 )
	SV* c_func
	short s0
	double d1
	int i2
	void * p3
PREINIT:
	char *(*func)(short, double, int, void *);
CODE:
	func   = INT2PTR(char *(*)(short, double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, i2, p3);
OUTPUT:
	RETVAL

int
nci_isdip( c_func, s0, d1, i2, p3 )
	SV* c_func
	short s0
	double d1
	int i2
	void * p3
PREINIT:
	int(*func)(short, double, int, void *);
CODE:
	func   = INT2PTR(int(*)(short, double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, i2, p3);
OUTPUT:
	RETVAL

void *
nci_pfdip( c_func, f0, d1, i2, p3 )
	SV* c_func
	float f0
	double d1
	int i2
	void * p3
PREINIT:
	void *(*func)(float, double, int, void *);
CODE:
	func   = INT2PTR(void *(*)(float, double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, i2, p3);
OUTPUT:
	RETVAL

void
nci_vfdip( c_func, f0, d1, i2, p3 )
	SV* c_func
	float f0
	double d1
	int i2
	void * p3
PREINIT:
	void(*func)(float, double, int, void *);
CODE:
	func   = INT2PTR(void(*)(float, double, int, void *), SvIV(c_func) );
	(*func)(f0, d1, i2, p3);

double
nci_dfdip( c_func, f0, d1, i2, p3 )
	SV* c_func
	float f0
	double d1
	int i2
	void * p3
PREINIT:
	double(*func)(float, double, int, void *);
CODE:
	func   = INT2PTR(double(*)(float, double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, i2, p3);
OUTPUT:
	RETVAL

short
nci_sfdip( c_func, f0, d1, i2, p3 )
	SV* c_func
	float f0
	double d1
	int i2
	void * p3
PREINIT:
	short(*func)(float, double, int, void *);
CODE:
	func   = INT2PTR(short(*)(float, double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, i2, p3);
OUTPUT:
	RETVAL

float
nci_ffdip( c_func, f0, d1, i2, p3 )
	SV* c_func
	float f0
	double d1
	int i2
	void * p3
PREINIT:
	float(*func)(float, double, int, void *);
CODE:
	func   = INT2PTR(float(*)(float, double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, i2, p3);
OUTPUT:
	RETVAL

char *
nci_tfdip( c_func, f0, d1, i2, p3 )
	SV* c_func
	float f0
	double d1
	int i2
	void * p3
PREINIT:
	char *(*func)(float, double, int, void *);
CODE:
	func   = INT2PTR(char *(*)(float, double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, i2, p3);
OUTPUT:
	RETVAL

int
nci_ifdip( c_func, f0, d1, i2, p3 )
	SV* c_func
	float f0
	double d1
	int i2
	void * p3
PREINIT:
	int(*func)(float, double, int, void *);
CODE:
	func   = INT2PTR(int(*)(float, double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, i2, p3);
OUTPUT:
	RETVAL

void *
nci_ptdip( c_func, t0, d1, i2, p3 )
	SV* c_func
	char * t0
	double d1
	int i2
	void * p3
PREINIT:
	void *(*func)(char *, double, int, void *);
CODE:
	func   = INT2PTR(void *(*)(char *, double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, i2, p3);
OUTPUT:
	RETVAL

void
nci_vtdip( c_func, t0, d1, i2, p3 )
	SV* c_func
	char * t0
	double d1
	int i2
	void * p3
PREINIT:
	void(*func)(char *, double, int, void *);
CODE:
	func   = INT2PTR(void(*)(char *, double, int, void *), SvIV(c_func) );
	(*func)(t0, d1, i2, p3);

double
nci_dtdip( c_func, t0, d1, i2, p3 )
	SV* c_func
	char * t0
	double d1
	int i2
	void * p3
PREINIT:
	double(*func)(char *, double, int, void *);
CODE:
	func   = INT2PTR(double(*)(char *, double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, i2, p3);
OUTPUT:
	RETVAL

short
nci_stdip( c_func, t0, d1, i2, p3 )
	SV* c_func
	char * t0
	double d1
	int i2
	void * p3
PREINIT:
	short(*func)(char *, double, int, void *);
CODE:
	func   = INT2PTR(short(*)(char *, double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, i2, p3);
OUTPUT:
	RETVAL

float
nci_ftdip( c_func, t0, d1, i2, p3 )
	SV* c_func
	char * t0
	double d1
	int i2
	void * p3
PREINIT:
	float(*func)(char *, double, int, void *);
CODE:
	func   = INT2PTR(float(*)(char *, double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, i2, p3);
OUTPUT:
	RETVAL

char *
nci_ttdip( c_func, t0, d1, i2, p3 )
	SV* c_func
	char * t0
	double d1
	int i2
	void * p3
PREINIT:
	char *(*func)(char *, double, int, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, i2, p3);
OUTPUT:
	RETVAL

int
nci_itdip( c_func, t0, d1, i2, p3 )
	SV* c_func
	char * t0
	double d1
	int i2
	void * p3
PREINIT:
	int(*func)(char *, double, int, void *);
CODE:
	func   = INT2PTR(int(*)(char *, double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, i2, p3);
OUTPUT:
	RETVAL

void *
nci_pidip( c_func, i0, d1, i2, p3 )
	SV* c_func
	int i0
	double d1
	int i2
	void * p3
PREINIT:
	void *(*func)(int, double, int, void *);
CODE:
	func   = INT2PTR(void *(*)(int, double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, i2, p3);
OUTPUT:
	RETVAL

void
nci_vidip( c_func, i0, d1, i2, p3 )
	SV* c_func
	int i0
	double d1
	int i2
	void * p3
PREINIT:
	void(*func)(int, double, int, void *);
CODE:
	func   = INT2PTR(void(*)(int, double, int, void *), SvIV(c_func) );
	(*func)(i0, d1, i2, p3);

double
nci_didip( c_func, i0, d1, i2, p3 )
	SV* c_func
	int i0
	double d1
	int i2
	void * p3
PREINIT:
	double(*func)(int, double, int, void *);
CODE:
	func   = INT2PTR(double(*)(int, double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, i2, p3);
OUTPUT:
	RETVAL

short
nci_sidip( c_func, i0, d1, i2, p3 )
	SV* c_func
	int i0
	double d1
	int i2
	void * p3
PREINIT:
	short(*func)(int, double, int, void *);
CODE:
	func   = INT2PTR(short(*)(int, double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, i2, p3);
OUTPUT:
	RETVAL

float
nci_fidip( c_func, i0, d1, i2, p3 )
	SV* c_func
	int i0
	double d1
	int i2
	void * p3
PREINIT:
	float(*func)(int, double, int, void *);
CODE:
	func   = INT2PTR(float(*)(int, double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, i2, p3);
OUTPUT:
	RETVAL

char *
nci_tidip( c_func, i0, d1, i2, p3 )
	SV* c_func
	int i0
	double d1
	int i2
	void * p3
PREINIT:
	char *(*func)(int, double, int, void *);
CODE:
	func   = INT2PTR(char *(*)(int, double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, i2, p3);
OUTPUT:
	RETVAL

int
nci_iidip( c_func, i0, d1, i2, p3 )
	SV* c_func
	int i0
	double d1
	int i2
	void * p3
PREINIT:
	int(*func)(int, double, int, void *);
CODE:
	func   = INT2PTR(int(*)(int, double, int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, i2, p3);
OUTPUT:
	RETVAL

void *
nci_ppsip( c_func, p0, s1, i2, p3 )
	SV* c_func
	void * p0
	short s1
	int i2
	void * p3
PREINIT:
	void *(*func)(void *, short, int, void *);
CODE:
	func   = INT2PTR(void *(*)(void *, short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, i2, p3);
OUTPUT:
	RETVAL

void
nci_vpsip( c_func, p0, s1, i2, p3 )
	SV* c_func
	void * p0
	short s1
	int i2
	void * p3
PREINIT:
	void(*func)(void *, short, int, void *);
CODE:
	func   = INT2PTR(void(*)(void *, short, int, void *), SvIV(c_func) );
	(*func)(p0, s1, i2, p3);

double
nci_dpsip( c_func, p0, s1, i2, p3 )
	SV* c_func
	void * p0
	short s1
	int i2
	void * p3
PREINIT:
	double(*func)(void *, short, int, void *);
CODE:
	func   = INT2PTR(double(*)(void *, short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, i2, p3);
OUTPUT:
	RETVAL

short
nci_spsip( c_func, p0, s1, i2, p3 )
	SV* c_func
	void * p0
	short s1
	int i2
	void * p3
PREINIT:
	short(*func)(void *, short, int, void *);
CODE:
	func   = INT2PTR(short(*)(void *, short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, i2, p3);
OUTPUT:
	RETVAL

float
nci_fpsip( c_func, p0, s1, i2, p3 )
	SV* c_func
	void * p0
	short s1
	int i2
	void * p3
PREINIT:
	float(*func)(void *, short, int, void *);
CODE:
	func   = INT2PTR(float(*)(void *, short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, i2, p3);
OUTPUT:
	RETVAL

char *
nci_tpsip( c_func, p0, s1, i2, p3 )
	SV* c_func
	void * p0
	short s1
	int i2
	void * p3
PREINIT:
	char *(*func)(void *, short, int, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, i2, p3);
OUTPUT:
	RETVAL

int
nci_ipsip( c_func, p0, s1, i2, p3 )
	SV* c_func
	void * p0
	short s1
	int i2
	void * p3
PREINIT:
	int(*func)(void *, short, int, void *);
CODE:
	func   = INT2PTR(int(*)(void *, short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, i2, p3);
OUTPUT:
	RETVAL

void *
nci_pvsip( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvsip( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvsip( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svsip( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvsip( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvsip( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivsip( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdsip( c_func, d0, s1, i2, p3 )
	SV* c_func
	double d0
	short s1
	int i2
	void * p3
PREINIT:
	void *(*func)(double, short, int, void *);
CODE:
	func   = INT2PTR(void *(*)(double, short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, i2, p3);
OUTPUT:
	RETVAL

void
nci_vdsip( c_func, d0, s1, i2, p3 )
	SV* c_func
	double d0
	short s1
	int i2
	void * p3
PREINIT:
	void(*func)(double, short, int, void *);
CODE:
	func   = INT2PTR(void(*)(double, short, int, void *), SvIV(c_func) );
	(*func)(d0, s1, i2, p3);

double
nci_ddsip( c_func, d0, s1, i2, p3 )
	SV* c_func
	double d0
	short s1
	int i2
	void * p3
PREINIT:
	double(*func)(double, short, int, void *);
CODE:
	func   = INT2PTR(double(*)(double, short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, i2, p3);
OUTPUT:
	RETVAL

short
nci_sdsip( c_func, d0, s1, i2, p3 )
	SV* c_func
	double d0
	short s1
	int i2
	void * p3
PREINIT:
	short(*func)(double, short, int, void *);
CODE:
	func   = INT2PTR(short(*)(double, short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, i2, p3);
OUTPUT:
	RETVAL

float
nci_fdsip( c_func, d0, s1, i2, p3 )
	SV* c_func
	double d0
	short s1
	int i2
	void * p3
PREINIT:
	float(*func)(double, short, int, void *);
CODE:
	func   = INT2PTR(float(*)(double, short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, i2, p3);
OUTPUT:
	RETVAL

char *
nci_tdsip( c_func, d0, s1, i2, p3 )
	SV* c_func
	double d0
	short s1
	int i2
	void * p3
PREINIT:
	char *(*func)(double, short, int, void *);
CODE:
	func   = INT2PTR(char *(*)(double, short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, i2, p3);
OUTPUT:
	RETVAL

int
nci_idsip( c_func, d0, s1, i2, p3 )
	SV* c_func
	double d0
	short s1
	int i2
	void * p3
PREINIT:
	int(*func)(double, short, int, void *);
CODE:
	func   = INT2PTR(int(*)(double, short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, i2, p3);
OUTPUT:
	RETVAL

void *
nci_pssip( c_func, s0, s1, i2, p3 )
	SV* c_func
	short s0
	short s1
	int i2
	void * p3
PREINIT:
	void *(*func)(short, short, int, void *);
CODE:
	func   = INT2PTR(void *(*)(short, short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, i2, p3);
OUTPUT:
	RETVAL

void
nci_vssip( c_func, s0, s1, i2, p3 )
	SV* c_func
	short s0
	short s1
	int i2
	void * p3
PREINIT:
	void(*func)(short, short, int, void *);
CODE:
	func   = INT2PTR(void(*)(short, short, int, void *), SvIV(c_func) );
	(*func)(s0, s1, i2, p3);

double
nci_dssip( c_func, s0, s1, i2, p3 )
	SV* c_func
	short s0
	short s1
	int i2
	void * p3
PREINIT:
	double(*func)(short, short, int, void *);
CODE:
	func   = INT2PTR(double(*)(short, short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, i2, p3);
OUTPUT:
	RETVAL

short
nci_sssip( c_func, s0, s1, i2, p3 )
	SV* c_func
	short s0
	short s1
	int i2
	void * p3
PREINIT:
	short(*func)(short, short, int, void *);
CODE:
	func   = INT2PTR(short(*)(short, short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, i2, p3);
OUTPUT:
	RETVAL

float
nci_fssip( c_func, s0, s1, i2, p3 )
	SV* c_func
	short s0
	short s1
	int i2
	void * p3
PREINIT:
	float(*func)(short, short, int, void *);
CODE:
	func   = INT2PTR(float(*)(short, short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, i2, p3);
OUTPUT:
	RETVAL

char *
nci_tssip( c_func, s0, s1, i2, p3 )
	SV* c_func
	short s0
	short s1
	int i2
	void * p3
PREINIT:
	char *(*func)(short, short, int, void *);
CODE:
	func   = INT2PTR(char *(*)(short, short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, i2, p3);
OUTPUT:
	RETVAL

int
nci_issip( c_func, s0, s1, i2, p3 )
	SV* c_func
	short s0
	short s1
	int i2
	void * p3
PREINIT:
	int(*func)(short, short, int, void *);
CODE:
	func   = INT2PTR(int(*)(short, short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, i2, p3);
OUTPUT:
	RETVAL

void *
nci_pfsip( c_func, f0, s1, i2, p3 )
	SV* c_func
	float f0
	short s1
	int i2
	void * p3
PREINIT:
	void *(*func)(float, short, int, void *);
CODE:
	func   = INT2PTR(void *(*)(float, short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, i2, p3);
OUTPUT:
	RETVAL

void
nci_vfsip( c_func, f0, s1, i2, p3 )
	SV* c_func
	float f0
	short s1
	int i2
	void * p3
PREINIT:
	void(*func)(float, short, int, void *);
CODE:
	func   = INT2PTR(void(*)(float, short, int, void *), SvIV(c_func) );
	(*func)(f0, s1, i2, p3);

double
nci_dfsip( c_func, f0, s1, i2, p3 )
	SV* c_func
	float f0
	short s1
	int i2
	void * p3
PREINIT:
	double(*func)(float, short, int, void *);
CODE:
	func   = INT2PTR(double(*)(float, short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, i2, p3);
OUTPUT:
	RETVAL

short
nci_sfsip( c_func, f0, s1, i2, p3 )
	SV* c_func
	float f0
	short s1
	int i2
	void * p3
PREINIT:
	short(*func)(float, short, int, void *);
CODE:
	func   = INT2PTR(short(*)(float, short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, i2, p3);
OUTPUT:
	RETVAL

float
nci_ffsip( c_func, f0, s1, i2, p3 )
	SV* c_func
	float f0
	short s1
	int i2
	void * p3
PREINIT:
	float(*func)(float, short, int, void *);
CODE:
	func   = INT2PTR(float(*)(float, short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, i2, p3);
OUTPUT:
	RETVAL

char *
nci_tfsip( c_func, f0, s1, i2, p3 )
	SV* c_func
	float f0
	short s1
	int i2
	void * p3
PREINIT:
	char *(*func)(float, short, int, void *);
CODE:
	func   = INT2PTR(char *(*)(float, short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, i2, p3);
OUTPUT:
	RETVAL

int
nci_ifsip( c_func, f0, s1, i2, p3 )
	SV* c_func
	float f0
	short s1
	int i2
	void * p3
PREINIT:
	int(*func)(float, short, int, void *);
CODE:
	func   = INT2PTR(int(*)(float, short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, i2, p3);
OUTPUT:
	RETVAL

void *
nci_ptsip( c_func, t0, s1, i2, p3 )
	SV* c_func
	char * t0
	short s1
	int i2
	void * p3
PREINIT:
	void *(*func)(char *, short, int, void *);
CODE:
	func   = INT2PTR(void *(*)(char *, short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, i2, p3);
OUTPUT:
	RETVAL

void
nci_vtsip( c_func, t0, s1, i2, p3 )
	SV* c_func
	char * t0
	short s1
	int i2
	void * p3
PREINIT:
	void(*func)(char *, short, int, void *);
CODE:
	func   = INT2PTR(void(*)(char *, short, int, void *), SvIV(c_func) );
	(*func)(t0, s1, i2, p3);

double
nci_dtsip( c_func, t0, s1, i2, p3 )
	SV* c_func
	char * t0
	short s1
	int i2
	void * p3
PREINIT:
	double(*func)(char *, short, int, void *);
CODE:
	func   = INT2PTR(double(*)(char *, short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, i2, p3);
OUTPUT:
	RETVAL

short
nci_stsip( c_func, t0, s1, i2, p3 )
	SV* c_func
	char * t0
	short s1
	int i2
	void * p3
PREINIT:
	short(*func)(char *, short, int, void *);
CODE:
	func   = INT2PTR(short(*)(char *, short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, i2, p3);
OUTPUT:
	RETVAL

float
nci_ftsip( c_func, t0, s1, i2, p3 )
	SV* c_func
	char * t0
	short s1
	int i2
	void * p3
PREINIT:
	float(*func)(char *, short, int, void *);
CODE:
	func   = INT2PTR(float(*)(char *, short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, i2, p3);
OUTPUT:
	RETVAL

char *
nci_ttsip( c_func, t0, s1, i2, p3 )
	SV* c_func
	char * t0
	short s1
	int i2
	void * p3
PREINIT:
	char *(*func)(char *, short, int, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, i2, p3);
OUTPUT:
	RETVAL

int
nci_itsip( c_func, t0, s1, i2, p3 )
	SV* c_func
	char * t0
	short s1
	int i2
	void * p3
PREINIT:
	int(*func)(char *, short, int, void *);
CODE:
	func   = INT2PTR(int(*)(char *, short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, i2, p3);
OUTPUT:
	RETVAL

void *
nci_pisip( c_func, i0, s1, i2, p3 )
	SV* c_func
	int i0
	short s1
	int i2
	void * p3
PREINIT:
	void *(*func)(int, short, int, void *);
CODE:
	func   = INT2PTR(void *(*)(int, short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, i2, p3);
OUTPUT:
	RETVAL

void
nci_visip( c_func, i0, s1, i2, p3 )
	SV* c_func
	int i0
	short s1
	int i2
	void * p3
PREINIT:
	void(*func)(int, short, int, void *);
CODE:
	func   = INT2PTR(void(*)(int, short, int, void *), SvIV(c_func) );
	(*func)(i0, s1, i2, p3);

double
nci_disip( c_func, i0, s1, i2, p3 )
	SV* c_func
	int i0
	short s1
	int i2
	void * p3
PREINIT:
	double(*func)(int, short, int, void *);
CODE:
	func   = INT2PTR(double(*)(int, short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, i2, p3);
OUTPUT:
	RETVAL

short
nci_sisip( c_func, i0, s1, i2, p3 )
	SV* c_func
	int i0
	short s1
	int i2
	void * p3
PREINIT:
	short(*func)(int, short, int, void *);
CODE:
	func   = INT2PTR(short(*)(int, short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, i2, p3);
OUTPUT:
	RETVAL

float
nci_fisip( c_func, i0, s1, i2, p3 )
	SV* c_func
	int i0
	short s1
	int i2
	void * p3
PREINIT:
	float(*func)(int, short, int, void *);
CODE:
	func   = INT2PTR(float(*)(int, short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, i2, p3);
OUTPUT:
	RETVAL

char *
nci_tisip( c_func, i0, s1, i2, p3 )
	SV* c_func
	int i0
	short s1
	int i2
	void * p3
PREINIT:
	char *(*func)(int, short, int, void *);
CODE:
	func   = INT2PTR(char *(*)(int, short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, i2, p3);
OUTPUT:
	RETVAL

int
nci_iisip( c_func, i0, s1, i2, p3 )
	SV* c_func
	int i0
	short s1
	int i2
	void * p3
PREINIT:
	int(*func)(int, short, int, void *);
CODE:
	func   = INT2PTR(int(*)(int, short, int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, i2, p3);
OUTPUT:
	RETVAL

void *
nci_ppfip( c_func, p0, f1, i2, p3 )
	SV* c_func
	void * p0
	float f1
	int i2
	void * p3
PREINIT:
	void *(*func)(void *, float, int, void *);
CODE:
	func   = INT2PTR(void *(*)(void *, float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, i2, p3);
OUTPUT:
	RETVAL

void
nci_vpfip( c_func, p0, f1, i2, p3 )
	SV* c_func
	void * p0
	float f1
	int i2
	void * p3
PREINIT:
	void(*func)(void *, float, int, void *);
CODE:
	func   = INT2PTR(void(*)(void *, float, int, void *), SvIV(c_func) );
	(*func)(p0, f1, i2, p3);

double
nci_dpfip( c_func, p0, f1, i2, p3 )
	SV* c_func
	void * p0
	float f1
	int i2
	void * p3
PREINIT:
	double(*func)(void *, float, int, void *);
CODE:
	func   = INT2PTR(double(*)(void *, float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, i2, p3);
OUTPUT:
	RETVAL

short
nci_spfip( c_func, p0, f1, i2, p3 )
	SV* c_func
	void * p0
	float f1
	int i2
	void * p3
PREINIT:
	short(*func)(void *, float, int, void *);
CODE:
	func   = INT2PTR(short(*)(void *, float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, i2, p3);
OUTPUT:
	RETVAL

float
nci_fpfip( c_func, p0, f1, i2, p3 )
	SV* c_func
	void * p0
	float f1
	int i2
	void * p3
PREINIT:
	float(*func)(void *, float, int, void *);
CODE:
	func   = INT2PTR(float(*)(void *, float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, i2, p3);
OUTPUT:
	RETVAL

char *
nci_tpfip( c_func, p0, f1, i2, p3 )
	SV* c_func
	void * p0
	float f1
	int i2
	void * p3
PREINIT:
	char *(*func)(void *, float, int, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, i2, p3);
OUTPUT:
	RETVAL

int
nci_ipfip( c_func, p0, f1, i2, p3 )
	SV* c_func
	void * p0
	float f1
	int i2
	void * p3
PREINIT:
	int(*func)(void *, float, int, void *);
CODE:
	func   = INT2PTR(int(*)(void *, float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, i2, p3);
OUTPUT:
	RETVAL

void *
nci_pvfip( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvfip( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvfip( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svfip( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvfip( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvfip( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivfip( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdfip( c_func, d0, f1, i2, p3 )
	SV* c_func
	double d0
	float f1
	int i2
	void * p3
PREINIT:
	void *(*func)(double, float, int, void *);
CODE:
	func   = INT2PTR(void *(*)(double, float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, i2, p3);
OUTPUT:
	RETVAL

void
nci_vdfip( c_func, d0, f1, i2, p3 )
	SV* c_func
	double d0
	float f1
	int i2
	void * p3
PREINIT:
	void(*func)(double, float, int, void *);
CODE:
	func   = INT2PTR(void(*)(double, float, int, void *), SvIV(c_func) );
	(*func)(d0, f1, i2, p3);

double
nci_ddfip( c_func, d0, f1, i2, p3 )
	SV* c_func
	double d0
	float f1
	int i2
	void * p3
PREINIT:
	double(*func)(double, float, int, void *);
CODE:
	func   = INT2PTR(double(*)(double, float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, i2, p3);
OUTPUT:
	RETVAL

short
nci_sdfip( c_func, d0, f1, i2, p3 )
	SV* c_func
	double d0
	float f1
	int i2
	void * p3
PREINIT:
	short(*func)(double, float, int, void *);
CODE:
	func   = INT2PTR(short(*)(double, float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, i2, p3);
OUTPUT:
	RETVAL

float
nci_fdfip( c_func, d0, f1, i2, p3 )
	SV* c_func
	double d0
	float f1
	int i2
	void * p3
PREINIT:
	float(*func)(double, float, int, void *);
CODE:
	func   = INT2PTR(float(*)(double, float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, i2, p3);
OUTPUT:
	RETVAL

char *
nci_tdfip( c_func, d0, f1, i2, p3 )
	SV* c_func
	double d0
	float f1
	int i2
	void * p3
PREINIT:
	char *(*func)(double, float, int, void *);
CODE:
	func   = INT2PTR(char *(*)(double, float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, i2, p3);
OUTPUT:
	RETVAL

int
nci_idfip( c_func, d0, f1, i2, p3 )
	SV* c_func
	double d0
	float f1
	int i2
	void * p3
PREINIT:
	int(*func)(double, float, int, void *);
CODE:
	func   = INT2PTR(int(*)(double, float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, i2, p3);
OUTPUT:
	RETVAL

void *
nci_psfip( c_func, s0, f1, i2, p3 )
	SV* c_func
	short s0
	float f1
	int i2
	void * p3
PREINIT:
	void *(*func)(short, float, int, void *);
CODE:
	func   = INT2PTR(void *(*)(short, float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, i2, p3);
OUTPUT:
	RETVAL

void
nci_vsfip( c_func, s0, f1, i2, p3 )
	SV* c_func
	short s0
	float f1
	int i2
	void * p3
PREINIT:
	void(*func)(short, float, int, void *);
CODE:
	func   = INT2PTR(void(*)(short, float, int, void *), SvIV(c_func) );
	(*func)(s0, f1, i2, p3);

double
nci_dsfip( c_func, s0, f1, i2, p3 )
	SV* c_func
	short s0
	float f1
	int i2
	void * p3
PREINIT:
	double(*func)(short, float, int, void *);
CODE:
	func   = INT2PTR(double(*)(short, float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, i2, p3);
OUTPUT:
	RETVAL

short
nci_ssfip( c_func, s0, f1, i2, p3 )
	SV* c_func
	short s0
	float f1
	int i2
	void * p3
PREINIT:
	short(*func)(short, float, int, void *);
CODE:
	func   = INT2PTR(short(*)(short, float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, i2, p3);
OUTPUT:
	RETVAL

float
nci_fsfip( c_func, s0, f1, i2, p3 )
	SV* c_func
	short s0
	float f1
	int i2
	void * p3
PREINIT:
	float(*func)(short, float, int, void *);
CODE:
	func   = INT2PTR(float(*)(short, float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, i2, p3);
OUTPUT:
	RETVAL

char *
nci_tsfip( c_func, s0, f1, i2, p3 )
	SV* c_func
	short s0
	float f1
	int i2
	void * p3
PREINIT:
	char *(*func)(short, float, int, void *);
CODE:
	func   = INT2PTR(char *(*)(short, float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, i2, p3);
OUTPUT:
	RETVAL

int
nci_isfip( c_func, s0, f1, i2, p3 )
	SV* c_func
	short s0
	float f1
	int i2
	void * p3
PREINIT:
	int(*func)(short, float, int, void *);
CODE:
	func   = INT2PTR(int(*)(short, float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, i2, p3);
OUTPUT:
	RETVAL

void *
nci_pffip( c_func, f0, f1, i2, p3 )
	SV* c_func
	float f0
	float f1
	int i2
	void * p3
PREINIT:
	void *(*func)(float, float, int, void *);
CODE:
	func   = INT2PTR(void *(*)(float, float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, i2, p3);
OUTPUT:
	RETVAL

void
nci_vffip( c_func, f0, f1, i2, p3 )
	SV* c_func
	float f0
	float f1
	int i2
	void * p3
PREINIT:
	void(*func)(float, float, int, void *);
CODE:
	func   = INT2PTR(void(*)(float, float, int, void *), SvIV(c_func) );
	(*func)(f0, f1, i2, p3);

double
nci_dffip( c_func, f0, f1, i2, p3 )
	SV* c_func
	float f0
	float f1
	int i2
	void * p3
PREINIT:
	double(*func)(float, float, int, void *);
CODE:
	func   = INT2PTR(double(*)(float, float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, i2, p3);
OUTPUT:
	RETVAL

short
nci_sffip( c_func, f0, f1, i2, p3 )
	SV* c_func
	float f0
	float f1
	int i2
	void * p3
PREINIT:
	short(*func)(float, float, int, void *);
CODE:
	func   = INT2PTR(short(*)(float, float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, i2, p3);
OUTPUT:
	RETVAL

float
nci_fffip( c_func, f0, f1, i2, p3 )
	SV* c_func
	float f0
	float f1
	int i2
	void * p3
PREINIT:
	float(*func)(float, float, int, void *);
CODE:
	func   = INT2PTR(float(*)(float, float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, i2, p3);
OUTPUT:
	RETVAL

char *
nci_tffip( c_func, f0, f1, i2, p3 )
	SV* c_func
	float f0
	float f1
	int i2
	void * p3
PREINIT:
	char *(*func)(float, float, int, void *);
CODE:
	func   = INT2PTR(char *(*)(float, float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, i2, p3);
OUTPUT:
	RETVAL

int
nci_iffip( c_func, f0, f1, i2, p3 )
	SV* c_func
	float f0
	float f1
	int i2
	void * p3
PREINIT:
	int(*func)(float, float, int, void *);
CODE:
	func   = INT2PTR(int(*)(float, float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, i2, p3);
OUTPUT:
	RETVAL

void *
nci_ptfip( c_func, t0, f1, i2, p3 )
	SV* c_func
	char * t0
	float f1
	int i2
	void * p3
PREINIT:
	void *(*func)(char *, float, int, void *);
CODE:
	func   = INT2PTR(void *(*)(char *, float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, i2, p3);
OUTPUT:
	RETVAL

void
nci_vtfip( c_func, t0, f1, i2, p3 )
	SV* c_func
	char * t0
	float f1
	int i2
	void * p3
PREINIT:
	void(*func)(char *, float, int, void *);
CODE:
	func   = INT2PTR(void(*)(char *, float, int, void *), SvIV(c_func) );
	(*func)(t0, f1, i2, p3);

double
nci_dtfip( c_func, t0, f1, i2, p3 )
	SV* c_func
	char * t0
	float f1
	int i2
	void * p3
PREINIT:
	double(*func)(char *, float, int, void *);
CODE:
	func   = INT2PTR(double(*)(char *, float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, i2, p3);
OUTPUT:
	RETVAL

short
nci_stfip( c_func, t0, f1, i2, p3 )
	SV* c_func
	char * t0
	float f1
	int i2
	void * p3
PREINIT:
	short(*func)(char *, float, int, void *);
CODE:
	func   = INT2PTR(short(*)(char *, float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, i2, p3);
OUTPUT:
	RETVAL

float
nci_ftfip( c_func, t0, f1, i2, p3 )
	SV* c_func
	char * t0
	float f1
	int i2
	void * p3
PREINIT:
	float(*func)(char *, float, int, void *);
CODE:
	func   = INT2PTR(float(*)(char *, float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, i2, p3);
OUTPUT:
	RETVAL

char *
nci_ttfip( c_func, t0, f1, i2, p3 )
	SV* c_func
	char * t0
	float f1
	int i2
	void * p3
PREINIT:
	char *(*func)(char *, float, int, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, i2, p3);
OUTPUT:
	RETVAL

int
nci_itfip( c_func, t0, f1, i2, p3 )
	SV* c_func
	char * t0
	float f1
	int i2
	void * p3
PREINIT:
	int(*func)(char *, float, int, void *);
CODE:
	func   = INT2PTR(int(*)(char *, float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, i2, p3);
OUTPUT:
	RETVAL

void *
nci_pifip( c_func, i0, f1, i2, p3 )
	SV* c_func
	int i0
	float f1
	int i2
	void * p3
PREINIT:
	void *(*func)(int, float, int, void *);
CODE:
	func   = INT2PTR(void *(*)(int, float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, i2, p3);
OUTPUT:
	RETVAL

void
nci_vifip( c_func, i0, f1, i2, p3 )
	SV* c_func
	int i0
	float f1
	int i2
	void * p3
PREINIT:
	void(*func)(int, float, int, void *);
CODE:
	func   = INT2PTR(void(*)(int, float, int, void *), SvIV(c_func) );
	(*func)(i0, f1, i2, p3);

double
nci_difip( c_func, i0, f1, i2, p3 )
	SV* c_func
	int i0
	float f1
	int i2
	void * p3
PREINIT:
	double(*func)(int, float, int, void *);
CODE:
	func   = INT2PTR(double(*)(int, float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, i2, p3);
OUTPUT:
	RETVAL

short
nci_sifip( c_func, i0, f1, i2, p3 )
	SV* c_func
	int i0
	float f1
	int i2
	void * p3
PREINIT:
	short(*func)(int, float, int, void *);
CODE:
	func   = INT2PTR(short(*)(int, float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, i2, p3);
OUTPUT:
	RETVAL

float
nci_fifip( c_func, i0, f1, i2, p3 )
	SV* c_func
	int i0
	float f1
	int i2
	void * p3
PREINIT:
	float(*func)(int, float, int, void *);
CODE:
	func   = INT2PTR(float(*)(int, float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, i2, p3);
OUTPUT:
	RETVAL

char *
nci_tifip( c_func, i0, f1, i2, p3 )
	SV* c_func
	int i0
	float f1
	int i2
	void * p3
PREINIT:
	char *(*func)(int, float, int, void *);
CODE:
	func   = INT2PTR(char *(*)(int, float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, i2, p3);
OUTPUT:
	RETVAL

int
nci_iifip( c_func, i0, f1, i2, p3 )
	SV* c_func
	int i0
	float f1
	int i2
	void * p3
PREINIT:
	int(*func)(int, float, int, void *);
CODE:
	func   = INT2PTR(int(*)(int, float, int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, i2, p3);
OUTPUT:
	RETVAL

void *
nci_pptip( c_func, p0, t1, i2, p3 )
	SV* c_func
	void * p0
	char * t1
	int i2
	void * p3
PREINIT:
	void *(*func)(void *, char *, int, void *);
CODE:
	func   = INT2PTR(void *(*)(void *, char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, i2, p3);
OUTPUT:
	RETVAL

void
nci_vptip( c_func, p0, t1, i2, p3 )
	SV* c_func
	void * p0
	char * t1
	int i2
	void * p3
PREINIT:
	void(*func)(void *, char *, int, void *);
CODE:
	func   = INT2PTR(void(*)(void *, char *, int, void *), SvIV(c_func) );
	(*func)(p0, t1, i2, p3);

double
nci_dptip( c_func, p0, t1, i2, p3 )
	SV* c_func
	void * p0
	char * t1
	int i2
	void * p3
PREINIT:
	double(*func)(void *, char *, int, void *);
CODE:
	func   = INT2PTR(double(*)(void *, char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, i2, p3);
OUTPUT:
	RETVAL

short
nci_sptip( c_func, p0, t1, i2, p3 )
	SV* c_func
	void * p0
	char * t1
	int i2
	void * p3
PREINIT:
	short(*func)(void *, char *, int, void *);
CODE:
	func   = INT2PTR(short(*)(void *, char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, i2, p3);
OUTPUT:
	RETVAL

float
nci_fptip( c_func, p0, t1, i2, p3 )
	SV* c_func
	void * p0
	char * t1
	int i2
	void * p3
PREINIT:
	float(*func)(void *, char *, int, void *);
CODE:
	func   = INT2PTR(float(*)(void *, char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, i2, p3);
OUTPUT:
	RETVAL

char *
nci_tptip( c_func, p0, t1, i2, p3 )
	SV* c_func
	void * p0
	char * t1
	int i2
	void * p3
PREINIT:
	char *(*func)(void *, char *, int, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, i2, p3);
OUTPUT:
	RETVAL

int
nci_iptip( c_func, p0, t1, i2, p3 )
	SV* c_func
	void * p0
	char * t1
	int i2
	void * p3
PREINIT:
	int(*func)(void *, char *, int, void *);
CODE:
	func   = INT2PTR(int(*)(void *, char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, i2, p3);
OUTPUT:
	RETVAL

void *
nci_pvtip( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvtip( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvtip( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svtip( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvtip( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvtip( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivtip( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdtip( c_func, d0, t1, i2, p3 )
	SV* c_func
	double d0
	char * t1
	int i2
	void * p3
PREINIT:
	void *(*func)(double, char *, int, void *);
CODE:
	func   = INT2PTR(void *(*)(double, char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, i2, p3);
OUTPUT:
	RETVAL

void
nci_vdtip( c_func, d0, t1, i2, p3 )
	SV* c_func
	double d0
	char * t1
	int i2
	void * p3
PREINIT:
	void(*func)(double, char *, int, void *);
CODE:
	func   = INT2PTR(void(*)(double, char *, int, void *), SvIV(c_func) );
	(*func)(d0, t1, i2, p3);

double
nci_ddtip( c_func, d0, t1, i2, p3 )
	SV* c_func
	double d0
	char * t1
	int i2
	void * p3
PREINIT:
	double(*func)(double, char *, int, void *);
CODE:
	func   = INT2PTR(double(*)(double, char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, i2, p3);
OUTPUT:
	RETVAL

short
nci_sdtip( c_func, d0, t1, i2, p3 )
	SV* c_func
	double d0
	char * t1
	int i2
	void * p3
PREINIT:
	short(*func)(double, char *, int, void *);
CODE:
	func   = INT2PTR(short(*)(double, char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, i2, p3);
OUTPUT:
	RETVAL

float
nci_fdtip( c_func, d0, t1, i2, p3 )
	SV* c_func
	double d0
	char * t1
	int i2
	void * p3
PREINIT:
	float(*func)(double, char *, int, void *);
CODE:
	func   = INT2PTR(float(*)(double, char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, i2, p3);
OUTPUT:
	RETVAL

char *
nci_tdtip( c_func, d0, t1, i2, p3 )
	SV* c_func
	double d0
	char * t1
	int i2
	void * p3
PREINIT:
	char *(*func)(double, char *, int, void *);
CODE:
	func   = INT2PTR(char *(*)(double, char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, i2, p3);
OUTPUT:
	RETVAL

int
nci_idtip( c_func, d0, t1, i2, p3 )
	SV* c_func
	double d0
	char * t1
	int i2
	void * p3
PREINIT:
	int(*func)(double, char *, int, void *);
CODE:
	func   = INT2PTR(int(*)(double, char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, i2, p3);
OUTPUT:
	RETVAL

void *
nci_pstip( c_func, s0, t1, i2, p3 )
	SV* c_func
	short s0
	char * t1
	int i2
	void * p3
PREINIT:
	void *(*func)(short, char *, int, void *);
CODE:
	func   = INT2PTR(void *(*)(short, char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, i2, p3);
OUTPUT:
	RETVAL

void
nci_vstip( c_func, s0, t1, i2, p3 )
	SV* c_func
	short s0
	char * t1
	int i2
	void * p3
PREINIT:
	void(*func)(short, char *, int, void *);
CODE:
	func   = INT2PTR(void(*)(short, char *, int, void *), SvIV(c_func) );
	(*func)(s0, t1, i2, p3);

double
nci_dstip( c_func, s0, t1, i2, p3 )
	SV* c_func
	short s0
	char * t1
	int i2
	void * p3
PREINIT:
	double(*func)(short, char *, int, void *);
CODE:
	func   = INT2PTR(double(*)(short, char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, i2, p3);
OUTPUT:
	RETVAL

short
nci_sstip( c_func, s0, t1, i2, p3 )
	SV* c_func
	short s0
	char * t1
	int i2
	void * p3
PREINIT:
	short(*func)(short, char *, int, void *);
CODE:
	func   = INT2PTR(short(*)(short, char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, i2, p3);
OUTPUT:
	RETVAL

float
nci_fstip( c_func, s0, t1, i2, p3 )
	SV* c_func
	short s0
	char * t1
	int i2
	void * p3
PREINIT:
	float(*func)(short, char *, int, void *);
CODE:
	func   = INT2PTR(float(*)(short, char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, i2, p3);
OUTPUT:
	RETVAL

char *
nci_tstip( c_func, s0, t1, i2, p3 )
	SV* c_func
	short s0
	char * t1
	int i2
	void * p3
PREINIT:
	char *(*func)(short, char *, int, void *);
CODE:
	func   = INT2PTR(char *(*)(short, char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, i2, p3);
OUTPUT:
	RETVAL

int
nci_istip( c_func, s0, t1, i2, p3 )
	SV* c_func
	short s0
	char * t1
	int i2
	void * p3
PREINIT:
	int(*func)(short, char *, int, void *);
CODE:
	func   = INT2PTR(int(*)(short, char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, i2, p3);
OUTPUT:
	RETVAL

void *
nci_pftip( c_func, f0, t1, i2, p3 )
	SV* c_func
	float f0
	char * t1
	int i2
	void * p3
PREINIT:
	void *(*func)(float, char *, int, void *);
CODE:
	func   = INT2PTR(void *(*)(float, char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, i2, p3);
OUTPUT:
	RETVAL

void
nci_vftip( c_func, f0, t1, i2, p3 )
	SV* c_func
	float f0
	char * t1
	int i2
	void * p3
PREINIT:
	void(*func)(float, char *, int, void *);
CODE:
	func   = INT2PTR(void(*)(float, char *, int, void *), SvIV(c_func) );
	(*func)(f0, t1, i2, p3);

double
nci_dftip( c_func, f0, t1, i2, p3 )
	SV* c_func
	float f0
	char * t1
	int i2
	void * p3
PREINIT:
	double(*func)(float, char *, int, void *);
CODE:
	func   = INT2PTR(double(*)(float, char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, i2, p3);
OUTPUT:
	RETVAL

short
nci_sftip( c_func, f0, t1, i2, p3 )
	SV* c_func
	float f0
	char * t1
	int i2
	void * p3
PREINIT:
	short(*func)(float, char *, int, void *);
CODE:
	func   = INT2PTR(short(*)(float, char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, i2, p3);
OUTPUT:
	RETVAL

float
nci_fftip( c_func, f0, t1, i2, p3 )
	SV* c_func
	float f0
	char * t1
	int i2
	void * p3
PREINIT:
	float(*func)(float, char *, int, void *);
CODE:
	func   = INT2PTR(float(*)(float, char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, i2, p3);
OUTPUT:
	RETVAL

char *
nci_tftip( c_func, f0, t1, i2, p3 )
	SV* c_func
	float f0
	char * t1
	int i2
	void * p3
PREINIT:
	char *(*func)(float, char *, int, void *);
CODE:
	func   = INT2PTR(char *(*)(float, char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, i2, p3);
OUTPUT:
	RETVAL

int
nci_iftip( c_func, f0, t1, i2, p3 )
	SV* c_func
	float f0
	char * t1
	int i2
	void * p3
PREINIT:
	int(*func)(float, char *, int, void *);
CODE:
	func   = INT2PTR(int(*)(float, char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, i2, p3);
OUTPUT:
	RETVAL

void *
nci_pttip( c_func, t0, t1, i2, p3 )
	SV* c_func
	char * t0
	char * t1
	int i2
	void * p3
PREINIT:
	void *(*func)(char *, char *, int, void *);
CODE:
	func   = INT2PTR(void *(*)(char *, char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, i2, p3);
OUTPUT:
	RETVAL

void
nci_vttip( c_func, t0, t1, i2, p3 )
	SV* c_func
	char * t0
	char * t1
	int i2
	void * p3
PREINIT:
	void(*func)(char *, char *, int, void *);
CODE:
	func   = INT2PTR(void(*)(char *, char *, int, void *), SvIV(c_func) );
	(*func)(t0, t1, i2, p3);

double
nci_dttip( c_func, t0, t1, i2, p3 )
	SV* c_func
	char * t0
	char * t1
	int i2
	void * p3
PREINIT:
	double(*func)(char *, char *, int, void *);
CODE:
	func   = INT2PTR(double(*)(char *, char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, i2, p3);
OUTPUT:
	RETVAL

short
nci_sttip( c_func, t0, t1, i2, p3 )
	SV* c_func
	char * t0
	char * t1
	int i2
	void * p3
PREINIT:
	short(*func)(char *, char *, int, void *);
CODE:
	func   = INT2PTR(short(*)(char *, char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, i2, p3);
OUTPUT:
	RETVAL

float
nci_fttip( c_func, t0, t1, i2, p3 )
	SV* c_func
	char * t0
	char * t1
	int i2
	void * p3
PREINIT:
	float(*func)(char *, char *, int, void *);
CODE:
	func   = INT2PTR(float(*)(char *, char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, i2, p3);
OUTPUT:
	RETVAL

char *
nci_tttip( c_func, t0, t1, i2, p3 )
	SV* c_func
	char * t0
	char * t1
	int i2
	void * p3
PREINIT:
	char *(*func)(char *, char *, int, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, i2, p3);
OUTPUT:
	RETVAL

int
nci_ittip( c_func, t0, t1, i2, p3 )
	SV* c_func
	char * t0
	char * t1
	int i2
	void * p3
PREINIT:
	int(*func)(char *, char *, int, void *);
CODE:
	func   = INT2PTR(int(*)(char *, char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, i2, p3);
OUTPUT:
	RETVAL

void *
nci_pitip( c_func, i0, t1, i2, p3 )
	SV* c_func
	int i0
	char * t1
	int i2
	void * p3
PREINIT:
	void *(*func)(int, char *, int, void *);
CODE:
	func   = INT2PTR(void *(*)(int, char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, i2, p3);
OUTPUT:
	RETVAL

void
nci_vitip( c_func, i0, t1, i2, p3 )
	SV* c_func
	int i0
	char * t1
	int i2
	void * p3
PREINIT:
	void(*func)(int, char *, int, void *);
CODE:
	func   = INT2PTR(void(*)(int, char *, int, void *), SvIV(c_func) );
	(*func)(i0, t1, i2, p3);

double
nci_ditip( c_func, i0, t1, i2, p3 )
	SV* c_func
	int i0
	char * t1
	int i2
	void * p3
PREINIT:
	double(*func)(int, char *, int, void *);
CODE:
	func   = INT2PTR(double(*)(int, char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, i2, p3);
OUTPUT:
	RETVAL

short
nci_sitip( c_func, i0, t1, i2, p3 )
	SV* c_func
	int i0
	char * t1
	int i2
	void * p3
PREINIT:
	short(*func)(int, char *, int, void *);
CODE:
	func   = INT2PTR(short(*)(int, char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, i2, p3);
OUTPUT:
	RETVAL

float
nci_fitip( c_func, i0, t1, i2, p3 )
	SV* c_func
	int i0
	char * t1
	int i2
	void * p3
PREINIT:
	float(*func)(int, char *, int, void *);
CODE:
	func   = INT2PTR(float(*)(int, char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, i2, p3);
OUTPUT:
	RETVAL

char *
nci_titip( c_func, i0, t1, i2, p3 )
	SV* c_func
	int i0
	char * t1
	int i2
	void * p3
PREINIT:
	char *(*func)(int, char *, int, void *);
CODE:
	func   = INT2PTR(char *(*)(int, char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, i2, p3);
OUTPUT:
	RETVAL

int
nci_iitip( c_func, i0, t1, i2, p3 )
	SV* c_func
	int i0
	char * t1
	int i2
	void * p3
PREINIT:
	int(*func)(int, char *, int, void *);
CODE:
	func   = INT2PTR(int(*)(int, char *, int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, i2, p3);
OUTPUT:
	RETVAL

void *
nci_ppiip( c_func, p0, i1, i2, p3 )
	SV* c_func
	void * p0
	int i1
	int i2
	void * p3
PREINIT:
	void *(*func)(void *, int, int, void *);
CODE:
	func   = INT2PTR(void *(*)(void *, int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, i2, p3);
OUTPUT:
	RETVAL

void
nci_vpiip( c_func, p0, i1, i2, p3 )
	SV* c_func
	void * p0
	int i1
	int i2
	void * p3
PREINIT:
	void(*func)(void *, int, int, void *);
CODE:
	func   = INT2PTR(void(*)(void *, int, int, void *), SvIV(c_func) );
	(*func)(p0, i1, i2, p3);

double
nci_dpiip( c_func, p0, i1, i2, p3 )
	SV* c_func
	void * p0
	int i1
	int i2
	void * p3
PREINIT:
	double(*func)(void *, int, int, void *);
CODE:
	func   = INT2PTR(double(*)(void *, int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, i2, p3);
OUTPUT:
	RETVAL

short
nci_spiip( c_func, p0, i1, i2, p3 )
	SV* c_func
	void * p0
	int i1
	int i2
	void * p3
PREINIT:
	short(*func)(void *, int, int, void *);
CODE:
	func   = INT2PTR(short(*)(void *, int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, i2, p3);
OUTPUT:
	RETVAL

float
nci_fpiip( c_func, p0, i1, i2, p3 )
	SV* c_func
	void * p0
	int i1
	int i2
	void * p3
PREINIT:
	float(*func)(void *, int, int, void *);
CODE:
	func   = INT2PTR(float(*)(void *, int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, i2, p3);
OUTPUT:
	RETVAL

char *
nci_tpiip( c_func, p0, i1, i2, p3 )
	SV* c_func
	void * p0
	int i1
	int i2
	void * p3
PREINIT:
	char *(*func)(void *, int, int, void *);
CODE:
	func   = INT2PTR(char *(*)(void *, int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, i2, p3);
OUTPUT:
	RETVAL

int
nci_ipiip( c_func, p0, i1, i2, p3 )
	SV* c_func
	void * p0
	int i1
	int i2
	void * p3
PREINIT:
	int(*func)(void *, int, int, void *);
CODE:
	func   = INT2PTR(int(*)(void *, int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, i2, p3);
OUTPUT:
	RETVAL

void *
nci_pviip( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vviip( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dviip( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_sviip( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fviip( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tviip( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_iviip( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdiip( c_func, d0, i1, i2, p3 )
	SV* c_func
	double d0
	int i1
	int i2
	void * p3
PREINIT:
	void *(*func)(double, int, int, void *);
CODE:
	func   = INT2PTR(void *(*)(double, int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, i2, p3);
OUTPUT:
	RETVAL

void
nci_vdiip( c_func, d0, i1, i2, p3 )
	SV* c_func
	double d0
	int i1
	int i2
	void * p3
PREINIT:
	void(*func)(double, int, int, void *);
CODE:
	func   = INT2PTR(void(*)(double, int, int, void *), SvIV(c_func) );
	(*func)(d0, i1, i2, p3);

double
nci_ddiip( c_func, d0, i1, i2, p3 )
	SV* c_func
	double d0
	int i1
	int i2
	void * p3
PREINIT:
	double(*func)(double, int, int, void *);
CODE:
	func   = INT2PTR(double(*)(double, int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, i2, p3);
OUTPUT:
	RETVAL

short
nci_sdiip( c_func, d0, i1, i2, p3 )
	SV* c_func
	double d0
	int i1
	int i2
	void * p3
PREINIT:
	short(*func)(double, int, int, void *);
CODE:
	func   = INT2PTR(short(*)(double, int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, i2, p3);
OUTPUT:
	RETVAL

float
nci_fdiip( c_func, d0, i1, i2, p3 )
	SV* c_func
	double d0
	int i1
	int i2
	void * p3
PREINIT:
	float(*func)(double, int, int, void *);
CODE:
	func   = INT2PTR(float(*)(double, int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, i2, p3);
OUTPUT:
	RETVAL

char *
nci_tdiip( c_func, d0, i1, i2, p3 )
	SV* c_func
	double d0
	int i1
	int i2
	void * p3
PREINIT:
	char *(*func)(double, int, int, void *);
CODE:
	func   = INT2PTR(char *(*)(double, int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, i2, p3);
OUTPUT:
	RETVAL

int
nci_idiip( c_func, d0, i1, i2, p3 )
	SV* c_func
	double d0
	int i1
	int i2
	void * p3
PREINIT:
	int(*func)(double, int, int, void *);
CODE:
	func   = INT2PTR(int(*)(double, int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, i2, p3);
OUTPUT:
	RETVAL

void *
nci_psiip( c_func, s0, i1, i2, p3 )
	SV* c_func
	short s0
	int i1
	int i2
	void * p3
PREINIT:
	void *(*func)(short, int, int, void *);
CODE:
	func   = INT2PTR(void *(*)(short, int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, i2, p3);
OUTPUT:
	RETVAL

void
nci_vsiip( c_func, s0, i1, i2, p3 )
	SV* c_func
	short s0
	int i1
	int i2
	void * p3
PREINIT:
	void(*func)(short, int, int, void *);
CODE:
	func   = INT2PTR(void(*)(short, int, int, void *), SvIV(c_func) );
	(*func)(s0, i1, i2, p3);

double
nci_dsiip( c_func, s0, i1, i2, p3 )
	SV* c_func
	short s0
	int i1
	int i2
	void * p3
PREINIT:
	double(*func)(short, int, int, void *);
CODE:
	func   = INT2PTR(double(*)(short, int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, i2, p3);
OUTPUT:
	RETVAL

short
nci_ssiip( c_func, s0, i1, i2, p3 )
	SV* c_func
	short s0
	int i1
	int i2
	void * p3
PREINIT:
	short(*func)(short, int, int, void *);
CODE:
	func   = INT2PTR(short(*)(short, int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, i2, p3);
OUTPUT:
	RETVAL

float
nci_fsiip( c_func, s0, i1, i2, p3 )
	SV* c_func
	short s0
	int i1
	int i2
	void * p3
PREINIT:
	float(*func)(short, int, int, void *);
CODE:
	func   = INT2PTR(float(*)(short, int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, i2, p3);
OUTPUT:
	RETVAL

char *
nci_tsiip( c_func, s0, i1, i2, p3 )
	SV* c_func
	short s0
	int i1
	int i2
	void * p3
PREINIT:
	char *(*func)(short, int, int, void *);
CODE:
	func   = INT2PTR(char *(*)(short, int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, i2, p3);
OUTPUT:
	RETVAL

int
nci_isiip( c_func, s0, i1, i2, p3 )
	SV* c_func
	short s0
	int i1
	int i2
	void * p3
PREINIT:
	int(*func)(short, int, int, void *);
CODE:
	func   = INT2PTR(int(*)(short, int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, i2, p3);
OUTPUT:
	RETVAL

void *
nci_pfiip( c_func, f0, i1, i2, p3 )
	SV* c_func
	float f0
	int i1
	int i2
	void * p3
PREINIT:
	void *(*func)(float, int, int, void *);
CODE:
	func   = INT2PTR(void *(*)(float, int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, i2, p3);
OUTPUT:
	RETVAL

void
nci_vfiip( c_func, f0, i1, i2, p3 )
	SV* c_func
	float f0
	int i1
	int i2
	void * p3
PREINIT:
	void(*func)(float, int, int, void *);
CODE:
	func   = INT2PTR(void(*)(float, int, int, void *), SvIV(c_func) );
	(*func)(f0, i1, i2, p3);

double
nci_dfiip( c_func, f0, i1, i2, p3 )
	SV* c_func
	float f0
	int i1
	int i2
	void * p3
PREINIT:
	double(*func)(float, int, int, void *);
CODE:
	func   = INT2PTR(double(*)(float, int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, i2, p3);
OUTPUT:
	RETVAL

short
nci_sfiip( c_func, f0, i1, i2, p3 )
	SV* c_func
	float f0
	int i1
	int i2
	void * p3
PREINIT:
	short(*func)(float, int, int, void *);
CODE:
	func   = INT2PTR(short(*)(float, int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, i2, p3);
OUTPUT:
	RETVAL

float
nci_ffiip( c_func, f0, i1, i2, p3 )
	SV* c_func
	float f0
	int i1
	int i2
	void * p3
PREINIT:
	float(*func)(float, int, int, void *);
CODE:
	func   = INT2PTR(float(*)(float, int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, i2, p3);
OUTPUT:
	RETVAL

char *
nci_tfiip( c_func, f0, i1, i2, p3 )
	SV* c_func
	float f0
	int i1
	int i2
	void * p3
PREINIT:
	char *(*func)(float, int, int, void *);
CODE:
	func   = INT2PTR(char *(*)(float, int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, i2, p3);
OUTPUT:
	RETVAL

int
nci_ifiip( c_func, f0, i1, i2, p3 )
	SV* c_func
	float f0
	int i1
	int i2
	void * p3
PREINIT:
	int(*func)(float, int, int, void *);
CODE:
	func   = INT2PTR(int(*)(float, int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, i2, p3);
OUTPUT:
	RETVAL

void *
nci_ptiip( c_func, t0, i1, i2, p3 )
	SV* c_func
	char * t0
	int i1
	int i2
	void * p3
PREINIT:
	void *(*func)(char *, int, int, void *);
CODE:
	func   = INT2PTR(void *(*)(char *, int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, i2, p3);
OUTPUT:
	RETVAL

void
nci_vtiip( c_func, t0, i1, i2, p3 )
	SV* c_func
	char * t0
	int i1
	int i2
	void * p3
PREINIT:
	void(*func)(char *, int, int, void *);
CODE:
	func   = INT2PTR(void(*)(char *, int, int, void *), SvIV(c_func) );
	(*func)(t0, i1, i2, p3);

double
nci_dtiip( c_func, t0, i1, i2, p3 )
	SV* c_func
	char * t0
	int i1
	int i2
	void * p3
PREINIT:
	double(*func)(char *, int, int, void *);
CODE:
	func   = INT2PTR(double(*)(char *, int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, i2, p3);
OUTPUT:
	RETVAL

short
nci_stiip( c_func, t0, i1, i2, p3 )
	SV* c_func
	char * t0
	int i1
	int i2
	void * p3
PREINIT:
	short(*func)(char *, int, int, void *);
CODE:
	func   = INT2PTR(short(*)(char *, int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, i2, p3);
OUTPUT:
	RETVAL

float
nci_ftiip( c_func, t0, i1, i2, p3 )
	SV* c_func
	char * t0
	int i1
	int i2
	void * p3
PREINIT:
	float(*func)(char *, int, int, void *);
CODE:
	func   = INT2PTR(float(*)(char *, int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, i2, p3);
OUTPUT:
	RETVAL

char *
nci_ttiip( c_func, t0, i1, i2, p3 )
	SV* c_func
	char * t0
	int i1
	int i2
	void * p3
PREINIT:
	char *(*func)(char *, int, int, void *);
CODE:
	func   = INT2PTR(char *(*)(char *, int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, i2, p3);
OUTPUT:
	RETVAL

int
nci_itiip( c_func, t0, i1, i2, p3 )
	SV* c_func
	char * t0
	int i1
	int i2
	void * p3
PREINIT:
	int(*func)(char *, int, int, void *);
CODE:
	func   = INT2PTR(int(*)(char *, int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, i2, p3);
OUTPUT:
	RETVAL

void *
nci_piiip( c_func, i0, i1, i2, p3 )
	SV* c_func
	int i0
	int i1
	int i2
	void * p3
PREINIT:
	void *(*func)(int, int, int, void *);
CODE:
	func   = INT2PTR(void *(*)(int, int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, i2, p3);
OUTPUT:
	RETVAL

void
nci_viiip( c_func, i0, i1, i2, p3 )
	SV* c_func
	int i0
	int i1
	int i2
	void * p3
PREINIT:
	void(*func)(int, int, int, void *);
CODE:
	func   = INT2PTR(void(*)(int, int, int, void *), SvIV(c_func) );
	(*func)(i0, i1, i2, p3);

double
nci_diiip( c_func, i0, i1, i2, p3 )
	SV* c_func
	int i0
	int i1
	int i2
	void * p3
PREINIT:
	double(*func)(int, int, int, void *);
CODE:
	func   = INT2PTR(double(*)(int, int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, i2, p3);
OUTPUT:
	RETVAL

short
nci_siiip( c_func, i0, i1, i2, p3 )
	SV* c_func
	int i0
	int i1
	int i2
	void * p3
PREINIT:
	short(*func)(int, int, int, void *);
CODE:
	func   = INT2PTR(short(*)(int, int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, i2, p3);
OUTPUT:
	RETVAL

float
nci_fiiip( c_func, i0, i1, i2, p3 )
	SV* c_func
	int i0
	int i1
	int i2
	void * p3
PREINIT:
	float(*func)(int, int, int, void *);
CODE:
	func   = INT2PTR(float(*)(int, int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, i2, p3);
OUTPUT:
	RETVAL

char *
nci_tiiip( c_func, i0, i1, i2, p3 )
	SV* c_func
	int i0
	int i1
	int i2
	void * p3
PREINIT:
	char *(*func)(int, int, int, void *);
CODE:
	func   = INT2PTR(char *(*)(int, int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, i2, p3);
OUTPUT:
	RETVAL

int
nci_iiiip( c_func, i0, i1, i2, p3 )
	SV* c_func
	int i0
	int i1
	int i2
	void * p3
PREINIT:
	int(*func)(int, int, int, void *);
CODE:
	func   = INT2PTR(int(*)(int, int, int, void *), SvIV(c_func) );
	RETVAL = (*func)(i0, i1, i2, p3);
OUTPUT:
	RETVAL

void *
nci_ppppd( c_func, p0, p1, p2, d3 )
	SV* c_func
	void * p0
	void * p1
	void * p2
	double d3
PREINIT:
	void *(*func)(void *, void *, void *, double);
CODE:
	func   = INT2PTR(void *(*)(void *, void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, p2, d3);
OUTPUT:
	RETVAL

void
nci_vpppd( c_func, p0, p1, p2, d3 )
	SV* c_func
	void * p0
	void * p1
	void * p2
	double d3
PREINIT:
	void(*func)(void *, void *, void *, double);
CODE:
	func   = INT2PTR(void(*)(void *, void *, void *, double), SvIV(c_func) );
	(*func)(p0, p1, p2, d3);

double
nci_dpppd( c_func, p0, p1, p2, d3 )
	SV* c_func
	void * p0
	void * p1
	void * p2
	double d3
PREINIT:
	double(*func)(void *, void *, void *, double);
CODE:
	func   = INT2PTR(double(*)(void *, void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, p2, d3);
OUTPUT:
	RETVAL

short
nci_spppd( c_func, p0, p1, p2, d3 )
	SV* c_func
	void * p0
	void * p1
	void * p2
	double d3
PREINIT:
	short(*func)(void *, void *, void *, double);
CODE:
	func   = INT2PTR(short(*)(void *, void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, p2, d3);
OUTPUT:
	RETVAL

float
nci_fpppd( c_func, p0, p1, p2, d3 )
	SV* c_func
	void * p0
	void * p1
	void * p2
	double d3
PREINIT:
	float(*func)(void *, void *, void *, double);
CODE:
	func   = INT2PTR(float(*)(void *, void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, p2, d3);
OUTPUT:
	RETVAL

char *
nci_tpppd( c_func, p0, p1, p2, d3 )
	SV* c_func
	void * p0
	void * p1
	void * p2
	double d3
PREINIT:
	char *(*func)(void *, void *, void *, double);
CODE:
	func   = INT2PTR(char *(*)(void *, void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, p2, d3);
OUTPUT:
	RETVAL

int
nci_ipppd( c_func, p0, p1, p2, d3 )
	SV* c_func
	void * p0
	void * p1
	void * p2
	double d3
PREINIT:
	int(*func)(void *, void *, void *, double);
CODE:
	func   = INT2PTR(int(*)(void *, void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, p1, p2, d3);
OUTPUT:
	RETVAL

void *
nci_pvppd( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvppd( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvppd( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svppd( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvppd( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvppd( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivppd( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdppd( c_func, d0, p1, p2, d3 )
	SV* c_func
	double d0
	void * p1
	void * p2
	double d3
PREINIT:
	void *(*func)(double, void *, void *, double);
CODE:
	func   = INT2PTR(void *(*)(double, void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, p2, d3);
OUTPUT:
	RETVAL

void
nci_vdppd( c_func, d0, p1, p2, d3 )
	SV* c_func
	double d0
	void * p1
	void * p2
	double d3
PREINIT:
	void(*func)(double, void *, void *, double);
CODE:
	func   = INT2PTR(void(*)(double, void *, void *, double), SvIV(c_func) );
	(*func)(d0, p1, p2, d3);

double
nci_ddppd( c_func, d0, p1, p2, d3 )
	SV* c_func
	double d0
	void * p1
	void * p2
	double d3
PREINIT:
	double(*func)(double, void *, void *, double);
CODE:
	func   = INT2PTR(double(*)(double, void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, p2, d3);
OUTPUT:
	RETVAL

short
nci_sdppd( c_func, d0, p1, p2, d3 )
	SV* c_func
	double d0
	void * p1
	void * p2
	double d3
PREINIT:
	short(*func)(double, void *, void *, double);
CODE:
	func   = INT2PTR(short(*)(double, void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, p2, d3);
OUTPUT:
	RETVAL

float
nci_fdppd( c_func, d0, p1, p2, d3 )
	SV* c_func
	double d0
	void * p1
	void * p2
	double d3
PREINIT:
	float(*func)(double, void *, void *, double);
CODE:
	func   = INT2PTR(float(*)(double, void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, p2, d3);
OUTPUT:
	RETVAL

char *
nci_tdppd( c_func, d0, p1, p2, d3 )
	SV* c_func
	double d0
	void * p1
	void * p2
	double d3
PREINIT:
	char *(*func)(double, void *, void *, double);
CODE:
	func   = INT2PTR(char *(*)(double, void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, p2, d3);
OUTPUT:
	RETVAL

int
nci_idppd( c_func, d0, p1, p2, d3 )
	SV* c_func
	double d0
	void * p1
	void * p2
	double d3
PREINIT:
	int(*func)(double, void *, void *, double);
CODE:
	func   = INT2PTR(int(*)(double, void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, p1, p2, d3);
OUTPUT:
	RETVAL

void *
nci_psppd( c_func, s0, p1, p2, d3 )
	SV* c_func
	short s0
	void * p1
	void * p2
	double d3
PREINIT:
	void *(*func)(short, void *, void *, double);
CODE:
	func   = INT2PTR(void *(*)(short, void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, p2, d3);
OUTPUT:
	RETVAL

void
nci_vsppd( c_func, s0, p1, p2, d3 )
	SV* c_func
	short s0
	void * p1
	void * p2
	double d3
PREINIT:
	void(*func)(short, void *, void *, double);
CODE:
	func   = INT2PTR(void(*)(short, void *, void *, double), SvIV(c_func) );
	(*func)(s0, p1, p2, d3);

double
nci_dsppd( c_func, s0, p1, p2, d3 )
	SV* c_func
	short s0
	void * p1
	void * p2
	double d3
PREINIT:
	double(*func)(short, void *, void *, double);
CODE:
	func   = INT2PTR(double(*)(short, void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, p2, d3);
OUTPUT:
	RETVAL

short
nci_ssppd( c_func, s0, p1, p2, d3 )
	SV* c_func
	short s0
	void * p1
	void * p2
	double d3
PREINIT:
	short(*func)(short, void *, void *, double);
CODE:
	func   = INT2PTR(short(*)(short, void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, p2, d3);
OUTPUT:
	RETVAL

float
nci_fsppd( c_func, s0, p1, p2, d3 )
	SV* c_func
	short s0
	void * p1
	void * p2
	double d3
PREINIT:
	float(*func)(short, void *, void *, double);
CODE:
	func   = INT2PTR(float(*)(short, void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, p2, d3);
OUTPUT:
	RETVAL

char *
nci_tsppd( c_func, s0, p1, p2, d3 )
	SV* c_func
	short s0
	void * p1
	void * p2
	double d3
PREINIT:
	char *(*func)(short, void *, void *, double);
CODE:
	func   = INT2PTR(char *(*)(short, void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, p2, d3);
OUTPUT:
	RETVAL

int
nci_isppd( c_func, s0, p1, p2, d3 )
	SV* c_func
	short s0
	void * p1
	void * p2
	double d3
PREINIT:
	int(*func)(short, void *, void *, double);
CODE:
	func   = INT2PTR(int(*)(short, void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, p1, p2, d3);
OUTPUT:
	RETVAL

void *
nci_pfppd( c_func, f0, p1, p2, d3 )
	SV* c_func
	float f0
	void * p1
	void * p2
	double d3
PREINIT:
	void *(*func)(float, void *, void *, double);
CODE:
	func   = INT2PTR(void *(*)(float, void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, p2, d3);
OUTPUT:
	RETVAL

void
nci_vfppd( c_func, f0, p1, p2, d3 )
	SV* c_func
	float f0
	void * p1
	void * p2
	double d3
PREINIT:
	void(*func)(float, void *, void *, double);
CODE:
	func   = INT2PTR(void(*)(float, void *, void *, double), SvIV(c_func) );
	(*func)(f0, p1, p2, d3);

double
nci_dfppd( c_func, f0, p1, p2, d3 )
	SV* c_func
	float f0
	void * p1
	void * p2
	double d3
PREINIT:
	double(*func)(float, void *, void *, double);
CODE:
	func   = INT2PTR(double(*)(float, void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, p2, d3);
OUTPUT:
	RETVAL

short
nci_sfppd( c_func, f0, p1, p2, d3 )
	SV* c_func
	float f0
	void * p1
	void * p2
	double d3
PREINIT:
	short(*func)(float, void *, void *, double);
CODE:
	func   = INT2PTR(short(*)(float, void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, p2, d3);
OUTPUT:
	RETVAL

float
nci_ffppd( c_func, f0, p1, p2, d3 )
	SV* c_func
	float f0
	void * p1
	void * p2
	double d3
PREINIT:
	float(*func)(float, void *, void *, double);
CODE:
	func   = INT2PTR(float(*)(float, void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, p2, d3);
OUTPUT:
	RETVAL

char *
nci_tfppd( c_func, f0, p1, p2, d3 )
	SV* c_func
	float f0
	void * p1
	void * p2
	double d3
PREINIT:
	char *(*func)(float, void *, void *, double);
CODE:
	func   = INT2PTR(char *(*)(float, void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, p2, d3);
OUTPUT:
	RETVAL

int
nci_ifppd( c_func, f0, p1, p2, d3 )
	SV* c_func
	float f0
	void * p1
	void * p2
	double d3
PREINIT:
	int(*func)(float, void *, void *, double);
CODE:
	func   = INT2PTR(int(*)(float, void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, p1, p2, d3);
OUTPUT:
	RETVAL

void *
nci_ptppd( c_func, t0, p1, p2, d3 )
	SV* c_func
	char * t0
	void * p1
	void * p2
	double d3
PREINIT:
	void *(*func)(char *, void *, void *, double);
CODE:
	func   = INT2PTR(void *(*)(char *, void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, p2, d3);
OUTPUT:
	RETVAL

void
nci_vtppd( c_func, t0, p1, p2, d3 )
	SV* c_func
	char * t0
	void * p1
	void * p2
	double d3
PREINIT:
	void(*func)(char *, void *, void *, double);
CODE:
	func   = INT2PTR(void(*)(char *, void *, void *, double), SvIV(c_func) );
	(*func)(t0, p1, p2, d3);

double
nci_dtppd( c_func, t0, p1, p2, d3 )
	SV* c_func
	char * t0
	void * p1
	void * p2
	double d3
PREINIT:
	double(*func)(char *, void *, void *, double);
CODE:
	func   = INT2PTR(double(*)(char *, void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, p2, d3);
OUTPUT:
	RETVAL

short
nci_stppd( c_func, t0, p1, p2, d3 )
	SV* c_func
	char * t0
	void * p1
	void * p2
	double d3
PREINIT:
	short(*func)(char *, void *, void *, double);
CODE:
	func   = INT2PTR(short(*)(char *, void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, p2, d3);
OUTPUT:
	RETVAL

float
nci_ftppd( c_func, t0, p1, p2, d3 )
	SV* c_func
	char * t0
	void * p1
	void * p2
	double d3
PREINIT:
	float(*func)(char *, void *, void *, double);
CODE:
	func   = INT2PTR(float(*)(char *, void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, p2, d3);
OUTPUT:
	RETVAL

char *
nci_ttppd( c_func, t0, p1, p2, d3 )
	SV* c_func
	char * t0
	void * p1
	void * p2
	double d3
PREINIT:
	char *(*func)(char *, void *, void *, double);
CODE:
	func   = INT2PTR(char *(*)(char *, void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, p2, d3);
OUTPUT:
	RETVAL

int
nci_itppd( c_func, t0, p1, p2, d3 )
	SV* c_func
	char * t0
	void * p1
	void * p2
	double d3
PREINIT:
	int(*func)(char *, void *, void *, double);
CODE:
	func   = INT2PTR(int(*)(char *, void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, p1, p2, d3);
OUTPUT:
	RETVAL

void *
nci_pippd( c_func, i0, p1, p2, d3 )
	SV* c_func
	int i0
	void * p1
	void * p2
	double d3
PREINIT:
	void *(*func)(int, void *, void *, double);
CODE:
	func   = INT2PTR(void *(*)(int, void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, p2, d3);
OUTPUT:
	RETVAL

void
nci_vippd( c_func, i0, p1, p2, d3 )
	SV* c_func
	int i0
	void * p1
	void * p2
	double d3
PREINIT:
	void(*func)(int, void *, void *, double);
CODE:
	func   = INT2PTR(void(*)(int, void *, void *, double), SvIV(c_func) );
	(*func)(i0, p1, p2, d3);

double
nci_dippd( c_func, i0, p1, p2, d3 )
	SV* c_func
	int i0
	void * p1
	void * p2
	double d3
PREINIT:
	double(*func)(int, void *, void *, double);
CODE:
	func   = INT2PTR(double(*)(int, void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, p2, d3);
OUTPUT:
	RETVAL

short
nci_sippd( c_func, i0, p1, p2, d3 )
	SV* c_func
	int i0
	void * p1
	void * p2
	double d3
PREINIT:
	short(*func)(int, void *, void *, double);
CODE:
	func   = INT2PTR(short(*)(int, void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, p2, d3);
OUTPUT:
	RETVAL

float
nci_fippd( c_func, i0, p1, p2, d3 )
	SV* c_func
	int i0
	void * p1
	void * p2
	double d3
PREINIT:
	float(*func)(int, void *, void *, double);
CODE:
	func   = INT2PTR(float(*)(int, void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, p2, d3);
OUTPUT:
	RETVAL

char *
nci_tippd( c_func, i0, p1, p2, d3 )
	SV* c_func
	int i0
	void * p1
	void * p2
	double d3
PREINIT:
	char *(*func)(int, void *, void *, double);
CODE:
	func   = INT2PTR(char *(*)(int, void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, p2, d3);
OUTPUT:
	RETVAL

int
nci_iippd( c_func, i0, p1, p2, d3 )
	SV* c_func
	int i0
	void * p1
	void * p2
	double d3
PREINIT:
	int(*func)(int, void *, void *, double);
CODE:
	func   = INT2PTR(int(*)(int, void *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, p1, p2, d3);
OUTPUT:
	RETVAL

void *
nci_ppdpd( c_func, p0, d1, p2, d3 )
	SV* c_func
	void * p0
	double d1
	void * p2
	double d3
PREINIT:
	void *(*func)(void *, double, void *, double);
CODE:
	func   = INT2PTR(void *(*)(void *, double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, p2, d3);
OUTPUT:
	RETVAL

void
nci_vpdpd( c_func, p0, d1, p2, d3 )
	SV* c_func
	void * p0
	double d1
	void * p2
	double d3
PREINIT:
	void(*func)(void *, double, void *, double);
CODE:
	func   = INT2PTR(void(*)(void *, double, void *, double), SvIV(c_func) );
	(*func)(p0, d1, p2, d3);

double
nci_dpdpd( c_func, p0, d1, p2, d3 )
	SV* c_func
	void * p0
	double d1
	void * p2
	double d3
PREINIT:
	double(*func)(void *, double, void *, double);
CODE:
	func   = INT2PTR(double(*)(void *, double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, p2, d3);
OUTPUT:
	RETVAL

short
nci_spdpd( c_func, p0, d1, p2, d3 )
	SV* c_func
	void * p0
	double d1
	void * p2
	double d3
PREINIT:
	short(*func)(void *, double, void *, double);
CODE:
	func   = INT2PTR(short(*)(void *, double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, p2, d3);
OUTPUT:
	RETVAL

float
nci_fpdpd( c_func, p0, d1, p2, d3 )
	SV* c_func
	void * p0
	double d1
	void * p2
	double d3
PREINIT:
	float(*func)(void *, double, void *, double);
CODE:
	func   = INT2PTR(float(*)(void *, double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, p2, d3);
OUTPUT:
	RETVAL

char *
nci_tpdpd( c_func, p0, d1, p2, d3 )
	SV* c_func
	void * p0
	double d1
	void * p2
	double d3
PREINIT:
	char *(*func)(void *, double, void *, double);
CODE:
	func   = INT2PTR(char *(*)(void *, double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, p2, d3);
OUTPUT:
	RETVAL

int
nci_ipdpd( c_func, p0, d1, p2, d3 )
	SV* c_func
	void * p0
	double d1
	void * p2
	double d3
PREINIT:
	int(*func)(void *, double, void *, double);
CODE:
	func   = INT2PTR(int(*)(void *, double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, d1, p2, d3);
OUTPUT:
	RETVAL

void *
nci_pvdpd( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvdpd( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvdpd( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svdpd( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvdpd( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvdpd( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivdpd( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pddpd( c_func, d0, d1, p2, d3 )
	SV* c_func
	double d0
	double d1
	void * p2
	double d3
PREINIT:
	void *(*func)(double, double, void *, double);
CODE:
	func   = INT2PTR(void *(*)(double, double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, p2, d3);
OUTPUT:
	RETVAL

void
nci_vddpd( c_func, d0, d1, p2, d3 )
	SV* c_func
	double d0
	double d1
	void * p2
	double d3
PREINIT:
	void(*func)(double, double, void *, double);
CODE:
	func   = INT2PTR(void(*)(double, double, void *, double), SvIV(c_func) );
	(*func)(d0, d1, p2, d3);

double
nci_dddpd( c_func, d0, d1, p2, d3 )
	SV* c_func
	double d0
	double d1
	void * p2
	double d3
PREINIT:
	double(*func)(double, double, void *, double);
CODE:
	func   = INT2PTR(double(*)(double, double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, p2, d3);
OUTPUT:
	RETVAL

short
nci_sddpd( c_func, d0, d1, p2, d3 )
	SV* c_func
	double d0
	double d1
	void * p2
	double d3
PREINIT:
	short(*func)(double, double, void *, double);
CODE:
	func   = INT2PTR(short(*)(double, double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, p2, d3);
OUTPUT:
	RETVAL

float
nci_fddpd( c_func, d0, d1, p2, d3 )
	SV* c_func
	double d0
	double d1
	void * p2
	double d3
PREINIT:
	float(*func)(double, double, void *, double);
CODE:
	func   = INT2PTR(float(*)(double, double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, p2, d3);
OUTPUT:
	RETVAL

char *
nci_tddpd( c_func, d0, d1, p2, d3 )
	SV* c_func
	double d0
	double d1
	void * p2
	double d3
PREINIT:
	char *(*func)(double, double, void *, double);
CODE:
	func   = INT2PTR(char *(*)(double, double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, p2, d3);
OUTPUT:
	RETVAL

int
nci_iddpd( c_func, d0, d1, p2, d3 )
	SV* c_func
	double d0
	double d1
	void * p2
	double d3
PREINIT:
	int(*func)(double, double, void *, double);
CODE:
	func   = INT2PTR(int(*)(double, double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, d1, p2, d3);
OUTPUT:
	RETVAL

void *
nci_psdpd( c_func, s0, d1, p2, d3 )
	SV* c_func
	short s0
	double d1
	void * p2
	double d3
PREINIT:
	void *(*func)(short, double, void *, double);
CODE:
	func   = INT2PTR(void *(*)(short, double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, p2, d3);
OUTPUT:
	RETVAL

void
nci_vsdpd( c_func, s0, d1, p2, d3 )
	SV* c_func
	short s0
	double d1
	void * p2
	double d3
PREINIT:
	void(*func)(short, double, void *, double);
CODE:
	func   = INT2PTR(void(*)(short, double, void *, double), SvIV(c_func) );
	(*func)(s0, d1, p2, d3);

double
nci_dsdpd( c_func, s0, d1, p2, d3 )
	SV* c_func
	short s0
	double d1
	void * p2
	double d3
PREINIT:
	double(*func)(short, double, void *, double);
CODE:
	func   = INT2PTR(double(*)(short, double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, p2, d3);
OUTPUT:
	RETVAL

short
nci_ssdpd( c_func, s0, d1, p2, d3 )
	SV* c_func
	short s0
	double d1
	void * p2
	double d3
PREINIT:
	short(*func)(short, double, void *, double);
CODE:
	func   = INT2PTR(short(*)(short, double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, p2, d3);
OUTPUT:
	RETVAL

float
nci_fsdpd( c_func, s0, d1, p2, d3 )
	SV* c_func
	short s0
	double d1
	void * p2
	double d3
PREINIT:
	float(*func)(short, double, void *, double);
CODE:
	func   = INT2PTR(float(*)(short, double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, p2, d3);
OUTPUT:
	RETVAL

char *
nci_tsdpd( c_func, s0, d1, p2, d3 )
	SV* c_func
	short s0
	double d1
	void * p2
	double d3
PREINIT:
	char *(*func)(short, double, void *, double);
CODE:
	func   = INT2PTR(char *(*)(short, double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, p2, d3);
OUTPUT:
	RETVAL

int
nci_isdpd( c_func, s0, d1, p2, d3 )
	SV* c_func
	short s0
	double d1
	void * p2
	double d3
PREINIT:
	int(*func)(short, double, void *, double);
CODE:
	func   = INT2PTR(int(*)(short, double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, d1, p2, d3);
OUTPUT:
	RETVAL

void *
nci_pfdpd( c_func, f0, d1, p2, d3 )
	SV* c_func
	float f0
	double d1
	void * p2
	double d3
PREINIT:
	void *(*func)(float, double, void *, double);
CODE:
	func   = INT2PTR(void *(*)(float, double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, p2, d3);
OUTPUT:
	RETVAL

void
nci_vfdpd( c_func, f0, d1, p2, d3 )
	SV* c_func
	float f0
	double d1
	void * p2
	double d3
PREINIT:
	void(*func)(float, double, void *, double);
CODE:
	func   = INT2PTR(void(*)(float, double, void *, double), SvIV(c_func) );
	(*func)(f0, d1, p2, d3);

double
nci_dfdpd( c_func, f0, d1, p2, d3 )
	SV* c_func
	float f0
	double d1
	void * p2
	double d3
PREINIT:
	double(*func)(float, double, void *, double);
CODE:
	func   = INT2PTR(double(*)(float, double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, p2, d3);
OUTPUT:
	RETVAL

short
nci_sfdpd( c_func, f0, d1, p2, d3 )
	SV* c_func
	float f0
	double d1
	void * p2
	double d3
PREINIT:
	short(*func)(float, double, void *, double);
CODE:
	func   = INT2PTR(short(*)(float, double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, p2, d3);
OUTPUT:
	RETVAL

float
nci_ffdpd( c_func, f0, d1, p2, d3 )
	SV* c_func
	float f0
	double d1
	void * p2
	double d3
PREINIT:
	float(*func)(float, double, void *, double);
CODE:
	func   = INT2PTR(float(*)(float, double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, p2, d3);
OUTPUT:
	RETVAL

char *
nci_tfdpd( c_func, f0, d1, p2, d3 )
	SV* c_func
	float f0
	double d1
	void * p2
	double d3
PREINIT:
	char *(*func)(float, double, void *, double);
CODE:
	func   = INT2PTR(char *(*)(float, double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, p2, d3);
OUTPUT:
	RETVAL

int
nci_ifdpd( c_func, f0, d1, p2, d3 )
	SV* c_func
	float f0
	double d1
	void * p2
	double d3
PREINIT:
	int(*func)(float, double, void *, double);
CODE:
	func   = INT2PTR(int(*)(float, double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, d1, p2, d3);
OUTPUT:
	RETVAL

void *
nci_ptdpd( c_func, t0, d1, p2, d3 )
	SV* c_func
	char * t0
	double d1
	void * p2
	double d3
PREINIT:
	void *(*func)(char *, double, void *, double);
CODE:
	func   = INT2PTR(void *(*)(char *, double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, p2, d3);
OUTPUT:
	RETVAL

void
nci_vtdpd( c_func, t0, d1, p2, d3 )
	SV* c_func
	char * t0
	double d1
	void * p2
	double d3
PREINIT:
	void(*func)(char *, double, void *, double);
CODE:
	func   = INT2PTR(void(*)(char *, double, void *, double), SvIV(c_func) );
	(*func)(t0, d1, p2, d3);

double
nci_dtdpd( c_func, t0, d1, p2, d3 )
	SV* c_func
	char * t0
	double d1
	void * p2
	double d3
PREINIT:
	double(*func)(char *, double, void *, double);
CODE:
	func   = INT2PTR(double(*)(char *, double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, p2, d3);
OUTPUT:
	RETVAL

short
nci_stdpd( c_func, t0, d1, p2, d3 )
	SV* c_func
	char * t0
	double d1
	void * p2
	double d3
PREINIT:
	short(*func)(char *, double, void *, double);
CODE:
	func   = INT2PTR(short(*)(char *, double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, p2, d3);
OUTPUT:
	RETVAL

float
nci_ftdpd( c_func, t0, d1, p2, d3 )
	SV* c_func
	char * t0
	double d1
	void * p2
	double d3
PREINIT:
	float(*func)(char *, double, void *, double);
CODE:
	func   = INT2PTR(float(*)(char *, double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, p2, d3);
OUTPUT:
	RETVAL

char *
nci_ttdpd( c_func, t0, d1, p2, d3 )
	SV* c_func
	char * t0
	double d1
	void * p2
	double d3
PREINIT:
	char *(*func)(char *, double, void *, double);
CODE:
	func   = INT2PTR(char *(*)(char *, double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, p2, d3);
OUTPUT:
	RETVAL

int
nci_itdpd( c_func, t0, d1, p2, d3 )
	SV* c_func
	char * t0
	double d1
	void * p2
	double d3
PREINIT:
	int(*func)(char *, double, void *, double);
CODE:
	func   = INT2PTR(int(*)(char *, double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, d1, p2, d3);
OUTPUT:
	RETVAL

void *
nci_pidpd( c_func, i0, d1, p2, d3 )
	SV* c_func
	int i0
	double d1
	void * p2
	double d3
PREINIT:
	void *(*func)(int, double, void *, double);
CODE:
	func   = INT2PTR(void *(*)(int, double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, p2, d3);
OUTPUT:
	RETVAL

void
nci_vidpd( c_func, i0, d1, p2, d3 )
	SV* c_func
	int i0
	double d1
	void * p2
	double d3
PREINIT:
	void(*func)(int, double, void *, double);
CODE:
	func   = INT2PTR(void(*)(int, double, void *, double), SvIV(c_func) );
	(*func)(i0, d1, p2, d3);

double
nci_didpd( c_func, i0, d1, p2, d3 )
	SV* c_func
	int i0
	double d1
	void * p2
	double d3
PREINIT:
	double(*func)(int, double, void *, double);
CODE:
	func   = INT2PTR(double(*)(int, double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, p2, d3);
OUTPUT:
	RETVAL

short
nci_sidpd( c_func, i0, d1, p2, d3 )
	SV* c_func
	int i0
	double d1
	void * p2
	double d3
PREINIT:
	short(*func)(int, double, void *, double);
CODE:
	func   = INT2PTR(short(*)(int, double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, p2, d3);
OUTPUT:
	RETVAL

float
nci_fidpd( c_func, i0, d1, p2, d3 )
	SV* c_func
	int i0
	double d1
	void * p2
	double d3
PREINIT:
	float(*func)(int, double, void *, double);
CODE:
	func   = INT2PTR(float(*)(int, double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, p2, d3);
OUTPUT:
	RETVAL

char *
nci_tidpd( c_func, i0, d1, p2, d3 )
	SV* c_func
	int i0
	double d1
	void * p2
	double d3
PREINIT:
	char *(*func)(int, double, void *, double);
CODE:
	func   = INT2PTR(char *(*)(int, double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, p2, d3);
OUTPUT:
	RETVAL

int
nci_iidpd( c_func, i0, d1, p2, d3 )
	SV* c_func
	int i0
	double d1
	void * p2
	double d3
PREINIT:
	int(*func)(int, double, void *, double);
CODE:
	func   = INT2PTR(int(*)(int, double, void *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, d1, p2, d3);
OUTPUT:
	RETVAL

void *
nci_ppspd( c_func, p0, s1, p2, d3 )
	SV* c_func
	void * p0
	short s1
	void * p2
	double d3
PREINIT:
	void *(*func)(void *, short, void *, double);
CODE:
	func   = INT2PTR(void *(*)(void *, short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, p2, d3);
OUTPUT:
	RETVAL

void
nci_vpspd( c_func, p0, s1, p2, d3 )
	SV* c_func
	void * p0
	short s1
	void * p2
	double d3
PREINIT:
	void(*func)(void *, short, void *, double);
CODE:
	func   = INT2PTR(void(*)(void *, short, void *, double), SvIV(c_func) );
	(*func)(p0, s1, p2, d3);

double
nci_dpspd( c_func, p0, s1, p2, d3 )
	SV* c_func
	void * p0
	short s1
	void * p2
	double d3
PREINIT:
	double(*func)(void *, short, void *, double);
CODE:
	func   = INT2PTR(double(*)(void *, short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, p2, d3);
OUTPUT:
	RETVAL

short
nci_spspd( c_func, p0, s1, p2, d3 )
	SV* c_func
	void * p0
	short s1
	void * p2
	double d3
PREINIT:
	short(*func)(void *, short, void *, double);
CODE:
	func   = INT2PTR(short(*)(void *, short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, p2, d3);
OUTPUT:
	RETVAL

float
nci_fpspd( c_func, p0, s1, p2, d3 )
	SV* c_func
	void * p0
	short s1
	void * p2
	double d3
PREINIT:
	float(*func)(void *, short, void *, double);
CODE:
	func   = INT2PTR(float(*)(void *, short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, p2, d3);
OUTPUT:
	RETVAL

char *
nci_tpspd( c_func, p0, s1, p2, d3 )
	SV* c_func
	void * p0
	short s1
	void * p2
	double d3
PREINIT:
	char *(*func)(void *, short, void *, double);
CODE:
	func   = INT2PTR(char *(*)(void *, short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, p2, d3);
OUTPUT:
	RETVAL

int
nci_ipspd( c_func, p0, s1, p2, d3 )
	SV* c_func
	void * p0
	short s1
	void * p2
	double d3
PREINIT:
	int(*func)(void *, short, void *, double);
CODE:
	func   = INT2PTR(int(*)(void *, short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, s1, p2, d3);
OUTPUT:
	RETVAL

void *
nci_pvspd( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvspd( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvspd( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svspd( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvspd( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvspd( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivspd( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdspd( c_func, d0, s1, p2, d3 )
	SV* c_func
	double d0
	short s1
	void * p2
	double d3
PREINIT:
	void *(*func)(double, short, void *, double);
CODE:
	func   = INT2PTR(void *(*)(double, short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, p2, d3);
OUTPUT:
	RETVAL

void
nci_vdspd( c_func, d0, s1, p2, d3 )
	SV* c_func
	double d0
	short s1
	void * p2
	double d3
PREINIT:
	void(*func)(double, short, void *, double);
CODE:
	func   = INT2PTR(void(*)(double, short, void *, double), SvIV(c_func) );
	(*func)(d0, s1, p2, d3);

double
nci_ddspd( c_func, d0, s1, p2, d3 )
	SV* c_func
	double d0
	short s1
	void * p2
	double d3
PREINIT:
	double(*func)(double, short, void *, double);
CODE:
	func   = INT2PTR(double(*)(double, short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, p2, d3);
OUTPUT:
	RETVAL

short
nci_sdspd( c_func, d0, s1, p2, d3 )
	SV* c_func
	double d0
	short s1
	void * p2
	double d3
PREINIT:
	short(*func)(double, short, void *, double);
CODE:
	func   = INT2PTR(short(*)(double, short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, p2, d3);
OUTPUT:
	RETVAL

float
nci_fdspd( c_func, d0, s1, p2, d3 )
	SV* c_func
	double d0
	short s1
	void * p2
	double d3
PREINIT:
	float(*func)(double, short, void *, double);
CODE:
	func   = INT2PTR(float(*)(double, short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, p2, d3);
OUTPUT:
	RETVAL

char *
nci_tdspd( c_func, d0, s1, p2, d3 )
	SV* c_func
	double d0
	short s1
	void * p2
	double d3
PREINIT:
	char *(*func)(double, short, void *, double);
CODE:
	func   = INT2PTR(char *(*)(double, short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, p2, d3);
OUTPUT:
	RETVAL

int
nci_idspd( c_func, d0, s1, p2, d3 )
	SV* c_func
	double d0
	short s1
	void * p2
	double d3
PREINIT:
	int(*func)(double, short, void *, double);
CODE:
	func   = INT2PTR(int(*)(double, short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, s1, p2, d3);
OUTPUT:
	RETVAL

void *
nci_psspd( c_func, s0, s1, p2, d3 )
	SV* c_func
	short s0
	short s1
	void * p2
	double d3
PREINIT:
	void *(*func)(short, short, void *, double);
CODE:
	func   = INT2PTR(void *(*)(short, short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, p2, d3);
OUTPUT:
	RETVAL

void
nci_vsspd( c_func, s0, s1, p2, d3 )
	SV* c_func
	short s0
	short s1
	void * p2
	double d3
PREINIT:
	void(*func)(short, short, void *, double);
CODE:
	func   = INT2PTR(void(*)(short, short, void *, double), SvIV(c_func) );
	(*func)(s0, s1, p2, d3);

double
nci_dsspd( c_func, s0, s1, p2, d3 )
	SV* c_func
	short s0
	short s1
	void * p2
	double d3
PREINIT:
	double(*func)(short, short, void *, double);
CODE:
	func   = INT2PTR(double(*)(short, short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, p2, d3);
OUTPUT:
	RETVAL

short
nci_ssspd( c_func, s0, s1, p2, d3 )
	SV* c_func
	short s0
	short s1
	void * p2
	double d3
PREINIT:
	short(*func)(short, short, void *, double);
CODE:
	func   = INT2PTR(short(*)(short, short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, p2, d3);
OUTPUT:
	RETVAL

float
nci_fsspd( c_func, s0, s1, p2, d3 )
	SV* c_func
	short s0
	short s1
	void * p2
	double d3
PREINIT:
	float(*func)(short, short, void *, double);
CODE:
	func   = INT2PTR(float(*)(short, short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, p2, d3);
OUTPUT:
	RETVAL

char *
nci_tsspd( c_func, s0, s1, p2, d3 )
	SV* c_func
	short s0
	short s1
	void * p2
	double d3
PREINIT:
	char *(*func)(short, short, void *, double);
CODE:
	func   = INT2PTR(char *(*)(short, short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, p2, d3);
OUTPUT:
	RETVAL

int
nci_isspd( c_func, s0, s1, p2, d3 )
	SV* c_func
	short s0
	short s1
	void * p2
	double d3
PREINIT:
	int(*func)(short, short, void *, double);
CODE:
	func   = INT2PTR(int(*)(short, short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, s1, p2, d3);
OUTPUT:
	RETVAL

void *
nci_pfspd( c_func, f0, s1, p2, d3 )
	SV* c_func
	float f0
	short s1
	void * p2
	double d3
PREINIT:
	void *(*func)(float, short, void *, double);
CODE:
	func   = INT2PTR(void *(*)(float, short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, p2, d3);
OUTPUT:
	RETVAL

void
nci_vfspd( c_func, f0, s1, p2, d3 )
	SV* c_func
	float f0
	short s1
	void * p2
	double d3
PREINIT:
	void(*func)(float, short, void *, double);
CODE:
	func   = INT2PTR(void(*)(float, short, void *, double), SvIV(c_func) );
	(*func)(f0, s1, p2, d3);

double
nci_dfspd( c_func, f0, s1, p2, d3 )
	SV* c_func
	float f0
	short s1
	void * p2
	double d3
PREINIT:
	double(*func)(float, short, void *, double);
CODE:
	func   = INT2PTR(double(*)(float, short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, p2, d3);
OUTPUT:
	RETVAL

short
nci_sfspd( c_func, f0, s1, p2, d3 )
	SV* c_func
	float f0
	short s1
	void * p2
	double d3
PREINIT:
	short(*func)(float, short, void *, double);
CODE:
	func   = INT2PTR(short(*)(float, short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, p2, d3);
OUTPUT:
	RETVAL

float
nci_ffspd( c_func, f0, s1, p2, d3 )
	SV* c_func
	float f0
	short s1
	void * p2
	double d3
PREINIT:
	float(*func)(float, short, void *, double);
CODE:
	func   = INT2PTR(float(*)(float, short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, p2, d3);
OUTPUT:
	RETVAL

char *
nci_tfspd( c_func, f0, s1, p2, d3 )
	SV* c_func
	float f0
	short s1
	void * p2
	double d3
PREINIT:
	char *(*func)(float, short, void *, double);
CODE:
	func   = INT2PTR(char *(*)(float, short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, p2, d3);
OUTPUT:
	RETVAL

int
nci_ifspd( c_func, f0, s1, p2, d3 )
	SV* c_func
	float f0
	short s1
	void * p2
	double d3
PREINIT:
	int(*func)(float, short, void *, double);
CODE:
	func   = INT2PTR(int(*)(float, short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, s1, p2, d3);
OUTPUT:
	RETVAL

void *
nci_ptspd( c_func, t0, s1, p2, d3 )
	SV* c_func
	char * t0
	short s1
	void * p2
	double d3
PREINIT:
	void *(*func)(char *, short, void *, double);
CODE:
	func   = INT2PTR(void *(*)(char *, short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, p2, d3);
OUTPUT:
	RETVAL

void
nci_vtspd( c_func, t0, s1, p2, d3 )
	SV* c_func
	char * t0
	short s1
	void * p2
	double d3
PREINIT:
	void(*func)(char *, short, void *, double);
CODE:
	func   = INT2PTR(void(*)(char *, short, void *, double), SvIV(c_func) );
	(*func)(t0, s1, p2, d3);

double
nci_dtspd( c_func, t0, s1, p2, d3 )
	SV* c_func
	char * t0
	short s1
	void * p2
	double d3
PREINIT:
	double(*func)(char *, short, void *, double);
CODE:
	func   = INT2PTR(double(*)(char *, short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, p2, d3);
OUTPUT:
	RETVAL

short
nci_stspd( c_func, t0, s1, p2, d3 )
	SV* c_func
	char * t0
	short s1
	void * p2
	double d3
PREINIT:
	short(*func)(char *, short, void *, double);
CODE:
	func   = INT2PTR(short(*)(char *, short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, p2, d3);
OUTPUT:
	RETVAL

float
nci_ftspd( c_func, t0, s1, p2, d3 )
	SV* c_func
	char * t0
	short s1
	void * p2
	double d3
PREINIT:
	float(*func)(char *, short, void *, double);
CODE:
	func   = INT2PTR(float(*)(char *, short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, p2, d3);
OUTPUT:
	RETVAL

char *
nci_ttspd( c_func, t0, s1, p2, d3 )
	SV* c_func
	char * t0
	short s1
	void * p2
	double d3
PREINIT:
	char *(*func)(char *, short, void *, double);
CODE:
	func   = INT2PTR(char *(*)(char *, short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, p2, d3);
OUTPUT:
	RETVAL

int
nci_itspd( c_func, t0, s1, p2, d3 )
	SV* c_func
	char * t0
	short s1
	void * p2
	double d3
PREINIT:
	int(*func)(char *, short, void *, double);
CODE:
	func   = INT2PTR(int(*)(char *, short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, s1, p2, d3);
OUTPUT:
	RETVAL

void *
nci_pispd( c_func, i0, s1, p2, d3 )
	SV* c_func
	int i0
	short s1
	void * p2
	double d3
PREINIT:
	void *(*func)(int, short, void *, double);
CODE:
	func   = INT2PTR(void *(*)(int, short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, p2, d3);
OUTPUT:
	RETVAL

void
nci_vispd( c_func, i0, s1, p2, d3 )
	SV* c_func
	int i0
	short s1
	void * p2
	double d3
PREINIT:
	void(*func)(int, short, void *, double);
CODE:
	func   = INT2PTR(void(*)(int, short, void *, double), SvIV(c_func) );
	(*func)(i0, s1, p2, d3);

double
nci_dispd( c_func, i0, s1, p2, d3 )
	SV* c_func
	int i0
	short s1
	void * p2
	double d3
PREINIT:
	double(*func)(int, short, void *, double);
CODE:
	func   = INT2PTR(double(*)(int, short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, p2, d3);
OUTPUT:
	RETVAL

short
nci_sispd( c_func, i0, s1, p2, d3 )
	SV* c_func
	int i0
	short s1
	void * p2
	double d3
PREINIT:
	short(*func)(int, short, void *, double);
CODE:
	func   = INT2PTR(short(*)(int, short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, p2, d3);
OUTPUT:
	RETVAL

float
nci_fispd( c_func, i0, s1, p2, d3 )
	SV* c_func
	int i0
	short s1
	void * p2
	double d3
PREINIT:
	float(*func)(int, short, void *, double);
CODE:
	func   = INT2PTR(float(*)(int, short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, p2, d3);
OUTPUT:
	RETVAL

char *
nci_tispd( c_func, i0, s1, p2, d3 )
	SV* c_func
	int i0
	short s1
	void * p2
	double d3
PREINIT:
	char *(*func)(int, short, void *, double);
CODE:
	func   = INT2PTR(char *(*)(int, short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, p2, d3);
OUTPUT:
	RETVAL

int
nci_iispd( c_func, i0, s1, p2, d3 )
	SV* c_func
	int i0
	short s1
	void * p2
	double d3
PREINIT:
	int(*func)(int, short, void *, double);
CODE:
	func   = INT2PTR(int(*)(int, short, void *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, s1, p2, d3);
OUTPUT:
	RETVAL

void *
nci_ppfpd( c_func, p0, f1, p2, d3 )
	SV* c_func
	void * p0
	float f1
	void * p2
	double d3
PREINIT:
	void *(*func)(void *, float, void *, double);
CODE:
	func   = INT2PTR(void *(*)(void *, float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, p2, d3);
OUTPUT:
	RETVAL

void
nci_vpfpd( c_func, p0, f1, p2, d3 )
	SV* c_func
	void * p0
	float f1
	void * p2
	double d3
PREINIT:
	void(*func)(void *, float, void *, double);
CODE:
	func   = INT2PTR(void(*)(void *, float, void *, double), SvIV(c_func) );
	(*func)(p0, f1, p2, d3);

double
nci_dpfpd( c_func, p0, f1, p2, d3 )
	SV* c_func
	void * p0
	float f1
	void * p2
	double d3
PREINIT:
	double(*func)(void *, float, void *, double);
CODE:
	func   = INT2PTR(double(*)(void *, float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, p2, d3);
OUTPUT:
	RETVAL

short
nci_spfpd( c_func, p0, f1, p2, d3 )
	SV* c_func
	void * p0
	float f1
	void * p2
	double d3
PREINIT:
	short(*func)(void *, float, void *, double);
CODE:
	func   = INT2PTR(short(*)(void *, float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, p2, d3);
OUTPUT:
	RETVAL

float
nci_fpfpd( c_func, p0, f1, p2, d3 )
	SV* c_func
	void * p0
	float f1
	void * p2
	double d3
PREINIT:
	float(*func)(void *, float, void *, double);
CODE:
	func   = INT2PTR(float(*)(void *, float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, p2, d3);
OUTPUT:
	RETVAL

char *
nci_tpfpd( c_func, p0, f1, p2, d3 )
	SV* c_func
	void * p0
	float f1
	void * p2
	double d3
PREINIT:
	char *(*func)(void *, float, void *, double);
CODE:
	func   = INT2PTR(char *(*)(void *, float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, p2, d3);
OUTPUT:
	RETVAL

int
nci_ipfpd( c_func, p0, f1, p2, d3 )
	SV* c_func
	void * p0
	float f1
	void * p2
	double d3
PREINIT:
	int(*func)(void *, float, void *, double);
CODE:
	func   = INT2PTR(int(*)(void *, float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, f1, p2, d3);
OUTPUT:
	RETVAL

void *
nci_pvfpd( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvfpd( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvfpd( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svfpd( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvfpd( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvfpd( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivfpd( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdfpd( c_func, d0, f1, p2, d3 )
	SV* c_func
	double d0
	float f1
	void * p2
	double d3
PREINIT:
	void *(*func)(double, float, void *, double);
CODE:
	func   = INT2PTR(void *(*)(double, float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, p2, d3);
OUTPUT:
	RETVAL

void
nci_vdfpd( c_func, d0, f1, p2, d3 )
	SV* c_func
	double d0
	float f1
	void * p2
	double d3
PREINIT:
	void(*func)(double, float, void *, double);
CODE:
	func   = INT2PTR(void(*)(double, float, void *, double), SvIV(c_func) );
	(*func)(d0, f1, p2, d3);

double
nci_ddfpd( c_func, d0, f1, p2, d3 )
	SV* c_func
	double d0
	float f1
	void * p2
	double d3
PREINIT:
	double(*func)(double, float, void *, double);
CODE:
	func   = INT2PTR(double(*)(double, float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, p2, d3);
OUTPUT:
	RETVAL

short
nci_sdfpd( c_func, d0, f1, p2, d3 )
	SV* c_func
	double d0
	float f1
	void * p2
	double d3
PREINIT:
	short(*func)(double, float, void *, double);
CODE:
	func   = INT2PTR(short(*)(double, float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, p2, d3);
OUTPUT:
	RETVAL

float
nci_fdfpd( c_func, d0, f1, p2, d3 )
	SV* c_func
	double d0
	float f1
	void * p2
	double d3
PREINIT:
	float(*func)(double, float, void *, double);
CODE:
	func   = INT2PTR(float(*)(double, float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, p2, d3);
OUTPUT:
	RETVAL

char *
nci_tdfpd( c_func, d0, f1, p2, d3 )
	SV* c_func
	double d0
	float f1
	void * p2
	double d3
PREINIT:
	char *(*func)(double, float, void *, double);
CODE:
	func   = INT2PTR(char *(*)(double, float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, p2, d3);
OUTPUT:
	RETVAL

int
nci_idfpd( c_func, d0, f1, p2, d3 )
	SV* c_func
	double d0
	float f1
	void * p2
	double d3
PREINIT:
	int(*func)(double, float, void *, double);
CODE:
	func   = INT2PTR(int(*)(double, float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, f1, p2, d3);
OUTPUT:
	RETVAL

void *
nci_psfpd( c_func, s0, f1, p2, d3 )
	SV* c_func
	short s0
	float f1
	void * p2
	double d3
PREINIT:
	void *(*func)(short, float, void *, double);
CODE:
	func   = INT2PTR(void *(*)(short, float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, p2, d3);
OUTPUT:
	RETVAL

void
nci_vsfpd( c_func, s0, f1, p2, d3 )
	SV* c_func
	short s0
	float f1
	void * p2
	double d3
PREINIT:
	void(*func)(short, float, void *, double);
CODE:
	func   = INT2PTR(void(*)(short, float, void *, double), SvIV(c_func) );
	(*func)(s0, f1, p2, d3);

double
nci_dsfpd( c_func, s0, f1, p2, d3 )
	SV* c_func
	short s0
	float f1
	void * p2
	double d3
PREINIT:
	double(*func)(short, float, void *, double);
CODE:
	func   = INT2PTR(double(*)(short, float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, p2, d3);
OUTPUT:
	RETVAL

short
nci_ssfpd( c_func, s0, f1, p2, d3 )
	SV* c_func
	short s0
	float f1
	void * p2
	double d3
PREINIT:
	short(*func)(short, float, void *, double);
CODE:
	func   = INT2PTR(short(*)(short, float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, p2, d3);
OUTPUT:
	RETVAL

float
nci_fsfpd( c_func, s0, f1, p2, d3 )
	SV* c_func
	short s0
	float f1
	void * p2
	double d3
PREINIT:
	float(*func)(short, float, void *, double);
CODE:
	func   = INT2PTR(float(*)(short, float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, p2, d3);
OUTPUT:
	RETVAL

char *
nci_tsfpd( c_func, s0, f1, p2, d3 )
	SV* c_func
	short s0
	float f1
	void * p2
	double d3
PREINIT:
	char *(*func)(short, float, void *, double);
CODE:
	func   = INT2PTR(char *(*)(short, float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, p2, d3);
OUTPUT:
	RETVAL

int
nci_isfpd( c_func, s0, f1, p2, d3 )
	SV* c_func
	short s0
	float f1
	void * p2
	double d3
PREINIT:
	int(*func)(short, float, void *, double);
CODE:
	func   = INT2PTR(int(*)(short, float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, f1, p2, d3);
OUTPUT:
	RETVAL

void *
nci_pffpd( c_func, f0, f1, p2, d3 )
	SV* c_func
	float f0
	float f1
	void * p2
	double d3
PREINIT:
	void *(*func)(float, float, void *, double);
CODE:
	func   = INT2PTR(void *(*)(float, float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, p2, d3);
OUTPUT:
	RETVAL

void
nci_vffpd( c_func, f0, f1, p2, d3 )
	SV* c_func
	float f0
	float f1
	void * p2
	double d3
PREINIT:
	void(*func)(float, float, void *, double);
CODE:
	func   = INT2PTR(void(*)(float, float, void *, double), SvIV(c_func) );
	(*func)(f0, f1, p2, d3);

double
nci_dffpd( c_func, f0, f1, p2, d3 )
	SV* c_func
	float f0
	float f1
	void * p2
	double d3
PREINIT:
	double(*func)(float, float, void *, double);
CODE:
	func   = INT2PTR(double(*)(float, float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, p2, d3);
OUTPUT:
	RETVAL

short
nci_sffpd( c_func, f0, f1, p2, d3 )
	SV* c_func
	float f0
	float f1
	void * p2
	double d3
PREINIT:
	short(*func)(float, float, void *, double);
CODE:
	func   = INT2PTR(short(*)(float, float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, p2, d3);
OUTPUT:
	RETVAL

float
nci_fffpd( c_func, f0, f1, p2, d3 )
	SV* c_func
	float f0
	float f1
	void * p2
	double d3
PREINIT:
	float(*func)(float, float, void *, double);
CODE:
	func   = INT2PTR(float(*)(float, float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, p2, d3);
OUTPUT:
	RETVAL

char *
nci_tffpd( c_func, f0, f1, p2, d3 )
	SV* c_func
	float f0
	float f1
	void * p2
	double d3
PREINIT:
	char *(*func)(float, float, void *, double);
CODE:
	func   = INT2PTR(char *(*)(float, float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, p2, d3);
OUTPUT:
	RETVAL

int
nci_iffpd( c_func, f0, f1, p2, d3 )
	SV* c_func
	float f0
	float f1
	void * p2
	double d3
PREINIT:
	int(*func)(float, float, void *, double);
CODE:
	func   = INT2PTR(int(*)(float, float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, f1, p2, d3);
OUTPUT:
	RETVAL

void *
nci_ptfpd( c_func, t0, f1, p2, d3 )
	SV* c_func
	char * t0
	float f1
	void * p2
	double d3
PREINIT:
	void *(*func)(char *, float, void *, double);
CODE:
	func   = INT2PTR(void *(*)(char *, float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, p2, d3);
OUTPUT:
	RETVAL

void
nci_vtfpd( c_func, t0, f1, p2, d3 )
	SV* c_func
	char * t0
	float f1
	void * p2
	double d3
PREINIT:
	void(*func)(char *, float, void *, double);
CODE:
	func   = INT2PTR(void(*)(char *, float, void *, double), SvIV(c_func) );
	(*func)(t0, f1, p2, d3);

double
nci_dtfpd( c_func, t0, f1, p2, d3 )
	SV* c_func
	char * t0
	float f1
	void * p2
	double d3
PREINIT:
	double(*func)(char *, float, void *, double);
CODE:
	func   = INT2PTR(double(*)(char *, float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, p2, d3);
OUTPUT:
	RETVAL

short
nci_stfpd( c_func, t0, f1, p2, d3 )
	SV* c_func
	char * t0
	float f1
	void * p2
	double d3
PREINIT:
	short(*func)(char *, float, void *, double);
CODE:
	func   = INT2PTR(short(*)(char *, float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, p2, d3);
OUTPUT:
	RETVAL

float
nci_ftfpd( c_func, t0, f1, p2, d3 )
	SV* c_func
	char * t0
	float f1
	void * p2
	double d3
PREINIT:
	float(*func)(char *, float, void *, double);
CODE:
	func   = INT2PTR(float(*)(char *, float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, p2, d3);
OUTPUT:
	RETVAL

char *
nci_ttfpd( c_func, t0, f1, p2, d3 )
	SV* c_func
	char * t0
	float f1
	void * p2
	double d3
PREINIT:
	char *(*func)(char *, float, void *, double);
CODE:
	func   = INT2PTR(char *(*)(char *, float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, p2, d3);
OUTPUT:
	RETVAL

int
nci_itfpd( c_func, t0, f1, p2, d3 )
	SV* c_func
	char * t0
	float f1
	void * p2
	double d3
PREINIT:
	int(*func)(char *, float, void *, double);
CODE:
	func   = INT2PTR(int(*)(char *, float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, f1, p2, d3);
OUTPUT:
	RETVAL

void *
nci_pifpd( c_func, i0, f1, p2, d3 )
	SV* c_func
	int i0
	float f1
	void * p2
	double d3
PREINIT:
	void *(*func)(int, float, void *, double);
CODE:
	func   = INT2PTR(void *(*)(int, float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, p2, d3);
OUTPUT:
	RETVAL

void
nci_vifpd( c_func, i0, f1, p2, d3 )
	SV* c_func
	int i0
	float f1
	void * p2
	double d3
PREINIT:
	void(*func)(int, float, void *, double);
CODE:
	func   = INT2PTR(void(*)(int, float, void *, double), SvIV(c_func) );
	(*func)(i0, f1, p2, d3);

double
nci_difpd( c_func, i0, f1, p2, d3 )
	SV* c_func
	int i0
	float f1
	void * p2
	double d3
PREINIT:
	double(*func)(int, float, void *, double);
CODE:
	func   = INT2PTR(double(*)(int, float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, p2, d3);
OUTPUT:
	RETVAL

short
nci_sifpd( c_func, i0, f1, p2, d3 )
	SV* c_func
	int i0
	float f1
	void * p2
	double d3
PREINIT:
	short(*func)(int, float, void *, double);
CODE:
	func   = INT2PTR(short(*)(int, float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, p2, d3);
OUTPUT:
	RETVAL

float
nci_fifpd( c_func, i0, f1, p2, d3 )
	SV* c_func
	int i0
	float f1
	void * p2
	double d3
PREINIT:
	float(*func)(int, float, void *, double);
CODE:
	func   = INT2PTR(float(*)(int, float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, p2, d3);
OUTPUT:
	RETVAL

char *
nci_tifpd( c_func, i0, f1, p2, d3 )
	SV* c_func
	int i0
	float f1
	void * p2
	double d3
PREINIT:
	char *(*func)(int, float, void *, double);
CODE:
	func   = INT2PTR(char *(*)(int, float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, p2, d3);
OUTPUT:
	RETVAL

int
nci_iifpd( c_func, i0, f1, p2, d3 )
	SV* c_func
	int i0
	float f1
	void * p2
	double d3
PREINIT:
	int(*func)(int, float, void *, double);
CODE:
	func   = INT2PTR(int(*)(int, float, void *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, f1, p2, d3);
OUTPUT:
	RETVAL

void *
nci_pptpd( c_func, p0, t1, p2, d3 )
	SV* c_func
	void * p0
	char * t1
	void * p2
	double d3
PREINIT:
	void *(*func)(void *, char *, void *, double);
CODE:
	func   = INT2PTR(void *(*)(void *, char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, p2, d3);
OUTPUT:
	RETVAL

void
nci_vptpd( c_func, p0, t1, p2, d3 )
	SV* c_func
	void * p0
	char * t1
	void * p2
	double d3
PREINIT:
	void(*func)(void *, char *, void *, double);
CODE:
	func   = INT2PTR(void(*)(void *, char *, void *, double), SvIV(c_func) );
	(*func)(p0, t1, p2, d3);

double
nci_dptpd( c_func, p0, t1, p2, d3 )
	SV* c_func
	void * p0
	char * t1
	void * p2
	double d3
PREINIT:
	double(*func)(void *, char *, void *, double);
CODE:
	func   = INT2PTR(double(*)(void *, char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, p2, d3);
OUTPUT:
	RETVAL

short
nci_sptpd( c_func, p0, t1, p2, d3 )
	SV* c_func
	void * p0
	char * t1
	void * p2
	double d3
PREINIT:
	short(*func)(void *, char *, void *, double);
CODE:
	func   = INT2PTR(short(*)(void *, char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, p2, d3);
OUTPUT:
	RETVAL

float
nci_fptpd( c_func, p0, t1, p2, d3 )
	SV* c_func
	void * p0
	char * t1
	void * p2
	double d3
PREINIT:
	float(*func)(void *, char *, void *, double);
CODE:
	func   = INT2PTR(float(*)(void *, char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, p2, d3);
OUTPUT:
	RETVAL

char *
nci_tptpd( c_func, p0, t1, p2, d3 )
	SV* c_func
	void * p0
	char * t1
	void * p2
	double d3
PREINIT:
	char *(*func)(void *, char *, void *, double);
CODE:
	func   = INT2PTR(char *(*)(void *, char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, p2, d3);
OUTPUT:
	RETVAL

int
nci_iptpd( c_func, p0, t1, p2, d3 )
	SV* c_func
	void * p0
	char * t1
	void * p2
	double d3
PREINIT:
	int(*func)(void *, char *, void *, double);
CODE:
	func   = INT2PTR(int(*)(void *, char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, t1, p2, d3);
OUTPUT:
	RETVAL

void *
nci_pvtpd( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvtpd( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvtpd( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svtpd( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvtpd( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvtpd( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivtpd( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdtpd( c_func, d0, t1, p2, d3 )
	SV* c_func
	double d0
	char * t1
	void * p2
	double d3
PREINIT:
	void *(*func)(double, char *, void *, double);
CODE:
	func   = INT2PTR(void *(*)(double, char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, p2, d3);
OUTPUT:
	RETVAL

void
nci_vdtpd( c_func, d0, t1, p2, d3 )
	SV* c_func
	double d0
	char * t1
	void * p2
	double d3
PREINIT:
	void(*func)(double, char *, void *, double);
CODE:
	func   = INT2PTR(void(*)(double, char *, void *, double), SvIV(c_func) );
	(*func)(d0, t1, p2, d3);

double
nci_ddtpd( c_func, d0, t1, p2, d3 )
	SV* c_func
	double d0
	char * t1
	void * p2
	double d3
PREINIT:
	double(*func)(double, char *, void *, double);
CODE:
	func   = INT2PTR(double(*)(double, char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, p2, d3);
OUTPUT:
	RETVAL

short
nci_sdtpd( c_func, d0, t1, p2, d3 )
	SV* c_func
	double d0
	char * t1
	void * p2
	double d3
PREINIT:
	short(*func)(double, char *, void *, double);
CODE:
	func   = INT2PTR(short(*)(double, char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, p2, d3);
OUTPUT:
	RETVAL

float
nci_fdtpd( c_func, d0, t1, p2, d3 )
	SV* c_func
	double d0
	char * t1
	void * p2
	double d3
PREINIT:
	float(*func)(double, char *, void *, double);
CODE:
	func   = INT2PTR(float(*)(double, char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, p2, d3);
OUTPUT:
	RETVAL

char *
nci_tdtpd( c_func, d0, t1, p2, d3 )
	SV* c_func
	double d0
	char * t1
	void * p2
	double d3
PREINIT:
	char *(*func)(double, char *, void *, double);
CODE:
	func   = INT2PTR(char *(*)(double, char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, p2, d3);
OUTPUT:
	RETVAL

int
nci_idtpd( c_func, d0, t1, p2, d3 )
	SV* c_func
	double d0
	char * t1
	void * p2
	double d3
PREINIT:
	int(*func)(double, char *, void *, double);
CODE:
	func   = INT2PTR(int(*)(double, char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, t1, p2, d3);
OUTPUT:
	RETVAL

void *
nci_pstpd( c_func, s0, t1, p2, d3 )
	SV* c_func
	short s0
	char * t1
	void * p2
	double d3
PREINIT:
	void *(*func)(short, char *, void *, double);
CODE:
	func   = INT2PTR(void *(*)(short, char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, p2, d3);
OUTPUT:
	RETVAL

void
nci_vstpd( c_func, s0, t1, p2, d3 )
	SV* c_func
	short s0
	char * t1
	void * p2
	double d3
PREINIT:
	void(*func)(short, char *, void *, double);
CODE:
	func   = INT2PTR(void(*)(short, char *, void *, double), SvIV(c_func) );
	(*func)(s0, t1, p2, d3);

double
nci_dstpd( c_func, s0, t1, p2, d3 )
	SV* c_func
	short s0
	char * t1
	void * p2
	double d3
PREINIT:
	double(*func)(short, char *, void *, double);
CODE:
	func   = INT2PTR(double(*)(short, char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, p2, d3);
OUTPUT:
	RETVAL

short
nci_sstpd( c_func, s0, t1, p2, d3 )
	SV* c_func
	short s0
	char * t1
	void * p2
	double d3
PREINIT:
	short(*func)(short, char *, void *, double);
CODE:
	func   = INT2PTR(short(*)(short, char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, p2, d3);
OUTPUT:
	RETVAL

float
nci_fstpd( c_func, s0, t1, p2, d3 )
	SV* c_func
	short s0
	char * t1
	void * p2
	double d3
PREINIT:
	float(*func)(short, char *, void *, double);
CODE:
	func   = INT2PTR(float(*)(short, char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, p2, d3);
OUTPUT:
	RETVAL

char *
nci_tstpd( c_func, s0, t1, p2, d3 )
	SV* c_func
	short s0
	char * t1
	void * p2
	double d3
PREINIT:
	char *(*func)(short, char *, void *, double);
CODE:
	func   = INT2PTR(char *(*)(short, char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, p2, d3);
OUTPUT:
	RETVAL

int
nci_istpd( c_func, s0, t1, p2, d3 )
	SV* c_func
	short s0
	char * t1
	void * p2
	double d3
PREINIT:
	int(*func)(short, char *, void *, double);
CODE:
	func   = INT2PTR(int(*)(short, char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, t1, p2, d3);
OUTPUT:
	RETVAL

void *
nci_pftpd( c_func, f0, t1, p2, d3 )
	SV* c_func
	float f0
	char * t1
	void * p2
	double d3
PREINIT:
	void *(*func)(float, char *, void *, double);
CODE:
	func   = INT2PTR(void *(*)(float, char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, p2, d3);
OUTPUT:
	RETVAL

void
nci_vftpd( c_func, f0, t1, p2, d3 )
	SV* c_func
	float f0
	char * t1
	void * p2
	double d3
PREINIT:
	void(*func)(float, char *, void *, double);
CODE:
	func   = INT2PTR(void(*)(float, char *, void *, double), SvIV(c_func) );
	(*func)(f0, t1, p2, d3);

double
nci_dftpd( c_func, f0, t1, p2, d3 )
	SV* c_func
	float f0
	char * t1
	void * p2
	double d3
PREINIT:
	double(*func)(float, char *, void *, double);
CODE:
	func   = INT2PTR(double(*)(float, char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, p2, d3);
OUTPUT:
	RETVAL

short
nci_sftpd( c_func, f0, t1, p2, d3 )
	SV* c_func
	float f0
	char * t1
	void * p2
	double d3
PREINIT:
	short(*func)(float, char *, void *, double);
CODE:
	func   = INT2PTR(short(*)(float, char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, p2, d3);
OUTPUT:
	RETVAL

float
nci_fftpd( c_func, f0, t1, p2, d3 )
	SV* c_func
	float f0
	char * t1
	void * p2
	double d3
PREINIT:
	float(*func)(float, char *, void *, double);
CODE:
	func   = INT2PTR(float(*)(float, char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, p2, d3);
OUTPUT:
	RETVAL

char *
nci_tftpd( c_func, f0, t1, p2, d3 )
	SV* c_func
	float f0
	char * t1
	void * p2
	double d3
PREINIT:
	char *(*func)(float, char *, void *, double);
CODE:
	func   = INT2PTR(char *(*)(float, char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, p2, d3);
OUTPUT:
	RETVAL

int
nci_iftpd( c_func, f0, t1, p2, d3 )
	SV* c_func
	float f0
	char * t1
	void * p2
	double d3
PREINIT:
	int(*func)(float, char *, void *, double);
CODE:
	func   = INT2PTR(int(*)(float, char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, t1, p2, d3);
OUTPUT:
	RETVAL

void *
nci_pttpd( c_func, t0, t1, p2, d3 )
	SV* c_func
	char * t0
	char * t1
	void * p2
	double d3
PREINIT:
	void *(*func)(char *, char *, void *, double);
CODE:
	func   = INT2PTR(void *(*)(char *, char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, p2, d3);
OUTPUT:
	RETVAL

void
nci_vttpd( c_func, t0, t1, p2, d3 )
	SV* c_func
	char * t0
	char * t1
	void * p2
	double d3
PREINIT:
	void(*func)(char *, char *, void *, double);
CODE:
	func   = INT2PTR(void(*)(char *, char *, void *, double), SvIV(c_func) );
	(*func)(t0, t1, p2, d3);

double
nci_dttpd( c_func, t0, t1, p2, d3 )
	SV* c_func
	char * t0
	char * t1
	void * p2
	double d3
PREINIT:
	double(*func)(char *, char *, void *, double);
CODE:
	func   = INT2PTR(double(*)(char *, char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, p2, d3);
OUTPUT:
	RETVAL

short
nci_sttpd( c_func, t0, t1, p2, d3 )
	SV* c_func
	char * t0
	char * t1
	void * p2
	double d3
PREINIT:
	short(*func)(char *, char *, void *, double);
CODE:
	func   = INT2PTR(short(*)(char *, char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, p2, d3);
OUTPUT:
	RETVAL

float
nci_fttpd( c_func, t0, t1, p2, d3 )
	SV* c_func
	char * t0
	char * t1
	void * p2
	double d3
PREINIT:
	float(*func)(char *, char *, void *, double);
CODE:
	func   = INT2PTR(float(*)(char *, char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, p2, d3);
OUTPUT:
	RETVAL

char *
nci_tttpd( c_func, t0, t1, p2, d3 )
	SV* c_func
	char * t0
	char * t1
	void * p2
	double d3
PREINIT:
	char *(*func)(char *, char *, void *, double);
CODE:
	func   = INT2PTR(char *(*)(char *, char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, p2, d3);
OUTPUT:
	RETVAL

int
nci_ittpd( c_func, t0, t1, p2, d3 )
	SV* c_func
	char * t0
	char * t1
	void * p2
	double d3
PREINIT:
	int(*func)(char *, char *, void *, double);
CODE:
	func   = INT2PTR(int(*)(char *, char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, t1, p2, d3);
OUTPUT:
	RETVAL

void *
nci_pitpd( c_func, i0, t1, p2, d3 )
	SV* c_func
	int i0
	char * t1
	void * p2
	double d3
PREINIT:
	void *(*func)(int, char *, void *, double);
CODE:
	func   = INT2PTR(void *(*)(int, char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, p2, d3);
OUTPUT:
	RETVAL

void
nci_vitpd( c_func, i0, t1, p2, d3 )
	SV* c_func
	int i0
	char * t1
	void * p2
	double d3
PREINIT:
	void(*func)(int, char *, void *, double);
CODE:
	func   = INT2PTR(void(*)(int, char *, void *, double), SvIV(c_func) );
	(*func)(i0, t1, p2, d3);

double
nci_ditpd( c_func, i0, t1, p2, d3 )
	SV* c_func
	int i0
	char * t1
	void * p2
	double d3
PREINIT:
	double(*func)(int, char *, void *, double);
CODE:
	func   = INT2PTR(double(*)(int, char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, p2, d3);
OUTPUT:
	RETVAL

short
nci_sitpd( c_func, i0, t1, p2, d3 )
	SV* c_func
	int i0
	char * t1
	void * p2
	double d3
PREINIT:
	short(*func)(int, char *, void *, double);
CODE:
	func   = INT2PTR(short(*)(int, char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, p2, d3);
OUTPUT:
	RETVAL

float
nci_fitpd( c_func, i0, t1, p2, d3 )
	SV* c_func
	int i0
	char * t1
	void * p2
	double d3
PREINIT:
	float(*func)(int, char *, void *, double);
CODE:
	func   = INT2PTR(float(*)(int, char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, p2, d3);
OUTPUT:
	RETVAL

char *
nci_titpd( c_func, i0, t1, p2, d3 )
	SV* c_func
	int i0
	char * t1
	void * p2
	double d3
PREINIT:
	char *(*func)(int, char *, void *, double);
CODE:
	func   = INT2PTR(char *(*)(int, char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, p2, d3);
OUTPUT:
	RETVAL

int
nci_iitpd( c_func, i0, t1, p2, d3 )
	SV* c_func
	int i0
	char * t1
	void * p2
	double d3
PREINIT:
	int(*func)(int, char *, void *, double);
CODE:
	func   = INT2PTR(int(*)(int, char *, void *, double), SvIV(c_func) );
	RETVAL = (*func)(i0, t1, p2, d3);
OUTPUT:
	RETVAL

void *
nci_ppipd( c_func, p0, i1, p2, d3 )
	SV* c_func
	void * p0
	int i1
	void * p2
	double d3
PREINIT:
	void *(*func)(void *, int, void *, double);
CODE:
	func   = INT2PTR(void *(*)(void *, int, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, p2, d3);
OUTPUT:
	RETVAL

void
nci_vpipd( c_func, p0, i1, p2, d3 )
	SV* c_func
	void * p0
	int i1
	void * p2
	double d3
PREINIT:
	void(*func)(void *, int, void *, double);
CODE:
	func   = INT2PTR(void(*)(void *, int, void *, double), SvIV(c_func) );
	(*func)(p0, i1, p2, d3);

double
nci_dpipd( c_func, p0, i1, p2, d3 )
	SV* c_func
	void * p0
	int i1
	void * p2
	double d3
PREINIT:
	double(*func)(void *, int, void *, double);
CODE:
	func   = INT2PTR(double(*)(void *, int, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, p2, d3);
OUTPUT:
	RETVAL

short
nci_spipd( c_func, p0, i1, p2, d3 )
	SV* c_func
	void * p0
	int i1
	void * p2
	double d3
PREINIT:
	short(*func)(void *, int, void *, double);
CODE:
	func   = INT2PTR(short(*)(void *, int, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, p2, d3);
OUTPUT:
	RETVAL

float
nci_fpipd( c_func, p0, i1, p2, d3 )
	SV* c_func
	void * p0
	int i1
	void * p2
	double d3
PREINIT:
	float(*func)(void *, int, void *, double);
CODE:
	func   = INT2PTR(float(*)(void *, int, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, p2, d3);
OUTPUT:
	RETVAL

char *
nci_tpipd( c_func, p0, i1, p2, d3 )
	SV* c_func
	void * p0
	int i1
	void * p2
	double d3
PREINIT:
	char *(*func)(void *, int, void *, double);
CODE:
	func   = INT2PTR(char *(*)(void *, int, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, p2, d3);
OUTPUT:
	RETVAL

int
nci_ipipd( c_func, p0, i1, p2, d3 )
	SV* c_func
	void * p0
	int i1
	void * p2
	double d3
PREINIT:
	int(*func)(void *, int, void *, double);
CODE:
	func   = INT2PTR(int(*)(void *, int, void *, double), SvIV(c_func) );
	RETVAL = (*func)(p0, i1, p2, d3);
OUTPUT:
	RETVAL

void *
nci_pvipd( c_func )
	SV* c_func
PREINIT:
	void *(*func)( );
CODE:
	func   = INT2PTR(void *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void
nci_vvipd( c_func )
	SV* c_func
PREINIT:
	void(*func)( );
CODE:
	func   = INT2PTR(void(*)( ), SvIV(c_func) );
	(*func)();

double
nci_dvipd( c_func )
	SV* c_func
PREINIT:
	double(*func)( );
CODE:
	func   = INT2PTR(double(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

short
nci_svipd( c_func )
	SV* c_func
PREINIT:
	short(*func)( );
CODE:
	func   = INT2PTR(short(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

float
nci_fvipd( c_func )
	SV* c_func
PREINIT:
	float(*func)( );
CODE:
	func   = INT2PTR(float(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

char *
nci_tvipd( c_func )
	SV* c_func
PREINIT:
	char *(*func)( );
CODE:
	func   = INT2PTR(char *(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

int
nci_ivipd( c_func )
	SV* c_func
PREINIT:
	int(*func)( );
CODE:
	func   = INT2PTR(int(*)( ), SvIV(c_func) );
	RETVAL = (*func)();
OUTPUT:
	RETVAL

void *
nci_pdipd( c_func, d0, i1, p2, d3 )
	SV* c_func
	double d0
	int i1
	void * p2
	double d3
PREINIT:
	void *(*func)(double, int, void *, double);
CODE:
	func   = INT2PTR(void *(*)(double, int, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, p2, d3);
OUTPUT:
	RETVAL

void
nci_vdipd( c_func, d0, i1, p2, d3 )
	SV* c_func
	double d0
	int i1
	void * p2
	double d3
PREINIT:
	void(*func)(double, int, void *, double);
CODE:
	func   = INT2PTR(void(*)(double, int, void *, double), SvIV(c_func) );
	(*func)(d0, i1, p2, d3);

double
nci_ddipd( c_func, d0, i1, p2, d3 )
	SV* c_func
	double d0
	int i1
	void * p2
	double d3
PREINIT:
	double(*func)(double, int, void *, double);
CODE:
	func   = INT2PTR(double(*)(double, int, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, p2, d3);
OUTPUT:
	RETVAL

short
nci_sdipd( c_func, d0, i1, p2, d3 )
	SV* c_func
	double d0
	int i1
	void * p2
	double d3
PREINIT:
	short(*func)(double, int, void *, double);
CODE:
	func   = INT2PTR(short(*)(double, int, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, p2, d3);
OUTPUT:
	RETVAL

float
nci_fdipd( c_func, d0, i1, p2, d3 )
	SV* c_func
	double d0
	int i1
	void * p2
	double d3
PREINIT:
	float(*func)(double, int, void *, double);
CODE:
	func   = INT2PTR(float(*)(double, int, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, p2, d3);
OUTPUT:
	RETVAL

char *
nci_tdipd( c_func, d0, i1, p2, d3 )
	SV* c_func
	double d0
	int i1
	void * p2
	double d3
PREINIT:
	char *(*func)(double, int, void *, double);
CODE:
	func   = INT2PTR(char *(*)(double, int, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, p2, d3);
OUTPUT:
	RETVAL

int
nci_idipd( c_func, d0, i1, p2, d3 )
	SV* c_func
	double d0
	int i1
	void * p2
	double d3
PREINIT:
	int(*func)(double, int, void *, double);
CODE:
	func   = INT2PTR(int(*)(double, int, void *, double), SvIV(c_func) );
	RETVAL = (*func)(d0, i1, p2, d3);
OUTPUT:
	RETVAL

void *
nci_psipd( c_func, s0, i1, p2, d3 )
	SV* c_func
	short s0
	int i1
	void * p2
	double d3
PREINIT:
	void *(*func)(short, int, void *, double);
CODE:
	func   = INT2PTR(void *(*)(short, int, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, p2, d3);
OUTPUT:
	RETVAL

void
nci_vsipd( c_func, s0, i1, p2, d3 )
	SV* c_func
	short s0
	int i1
	void * p2
	double d3
PREINIT:
	void(*func)(short, int, void *, double);
CODE:
	func   = INT2PTR(void(*)(short, int, void *, double), SvIV(c_func) );
	(*func)(s0, i1, p2, d3);

double
nci_dsipd( c_func, s0, i1, p2, d3 )
	SV* c_func
	short s0
	int i1
	void * p2
	double d3
PREINIT:
	double(*func)(short, int, void *, double);
CODE:
	func   = INT2PTR(double(*)(short, int, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, p2, d3);
OUTPUT:
	RETVAL

short
nci_ssipd( c_func, s0, i1, p2, d3 )
	SV* c_func
	short s0
	int i1
	void * p2
	double d3
PREINIT:
	short(*func)(short, int, void *, double);
CODE:
	func   = INT2PTR(short(*)(short, int, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, p2, d3);
OUTPUT:
	RETVAL

float
nci_fsipd( c_func, s0, i1, p2, d3 )
	SV* c_func
	short s0
	int i1
	void * p2
	double d3
PREINIT:
	float(*func)(short, int, void *, double);
CODE:
	func   = INT2PTR(float(*)(short, int, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, p2, d3);
OUTPUT:
	RETVAL

char *
nci_tsipd( c_func, s0, i1, p2, d3 )
	SV* c_func
	short s0
	int i1
	void * p2
	double d3
PREINIT:
	char *(*func)(short, int, void *, double);
CODE:
	func   = INT2PTR(char *(*)(short, int, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, p2, d3);
OUTPUT:
	RETVAL

int
nci_isipd( c_func, s0, i1, p2, d3 )
	SV* c_func
	short s0
	int i1
	void * p2
	double d3
PREINIT:
	int(*func)(short, int, void *, double);
CODE:
	func   = INT2PTR(int(*)(short, int, void *, double), SvIV(c_func) );
	RETVAL = (*func)(s0, i1, p2, d3);
OUTPUT:
	RETVAL

void *
nci_pfipd( c_func, f0, i1, p2, d3 )
	SV* c_func
	float f0
	int i1
	void * p2
	double d3
PREINIT:
	void *(*func)(float, int, void *, double);
CODE:
	func   = INT2PTR(void *(*)(float, int, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, p2, d3);
OUTPUT:
	RETVAL

void
nci_vfipd( c_func, f0, i1, p2, d3 )
	SV* c_func
	float f0
	int i1
	void * p2
	double d3
PREINIT:
	void(*func)(float, int, void *, double);
CODE:
	func   = INT2PTR(void(*)(float, int, void *, double), SvIV(c_func) );
	(*func)(f0, i1, p2, d3);

double
nci_dfipd( c_func, f0, i1, p2, d3 )
	SV* c_func
	float f0
	int i1
	void * p2
	double d3
PREINIT:
	double(*func)(float, int, void *, double);
CODE:
	func   = INT2PTR(double(*)(float, int, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, p2, d3);
OUTPUT:
	RETVAL

short
nci_sfipd( c_func, f0, i1, p2, d3 )
	SV* c_func
	float f0
	int i1
	void * p2
	double d3
PREINIT:
	short(*func)(float, int, void *, double);
CODE:
	func   = INT2PTR(short(*)(float, int, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, p2, d3);
OUTPUT:
	RETVAL

float
nci_ffipd( c_func, f0, i1, p2, d3 )
	SV* c_func
	float f0
	int i1
	void * p2
	double d3
PREINIT:
	float(*func)(float, int, void *, double);
CODE:
	func   = INT2PTR(float(*)(float, int, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, p2, d3);
OUTPUT:
	RETVAL

char *
nci_tfipd( c_func, f0, i1, p2, d3 )
	SV* c_func
	float f0
	int i1
	void * p2
	double d3
PREINIT:
	char *(*func)(float, int, void *, double);
CODE:
	func   = INT2PTR(char *(*)(float, int, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, p2, d3);
OUTPUT:
	RETVAL

int
nci_ifipd( c_func, f0, i1, p2, d3 )
	SV* c_func
	float f0
	int i1
	void * p2
	double d3
PREINIT:
	int(*func)(float, int, void *, double);
CODE:
	func   = INT2PTR(int(*)(float, int, void *, double), SvIV(c_func) );
	RETVAL = (*func)(f0, i1, p2, d3);
OUTPUT:
	RETVAL

void *
nci_ptipd( c_func, t0, i1, p2, d3 )
	SV* c_func
	char * t0
	int i1
	void * p2
	double d3
PREINIT:
	void *(*func)(char *, int, void *, double);
CODE:
	func   = INT2PTR(void *(*)(char *, int, void *, double), SvIV(c_func) );
	RETVAL = (*func)(t0, i1, p2, d3);
OUTPUT:
	RETVAL

void
nci_vtipd( c_