## no critic
# $Id: zh_tw.pm 1416 2006-09-15 03:45:35Z claco $
package Handel::L10N::zh_tw;
use strict;
use warnings;
use utf8;
use vars qw/%Lexicon/;

BEGIN {
    use base qw/Handel::L10N/;
};

%Lexicon = (
    "Language" =>
        "????",

    ## Base exceptions
    "An unspecified error has occurred" =>
        "?????????",

    "The supplied field(s) failed database constraints" =>
        "???????????????????",

    "The argument supplied is invalid or of the wrong type" =>
        "??????????????",

    "Required modules not found" =>
        "????????",

    "The quantity requested ([_1]) is greater than the maximum quantity allowed ([_2])" =>
        "???????[_1]????????[_2]?",

    "An error occurred while while creating or validating the current order" =>
        "??????????????????",

    "An error occurred during the checkout process" =>
        "??????????",

    ## param 1 violations
    "Param 1 is not a HASH reference" =>
        "???????????",

    "Cart reference is not a HASH reference or Handel::Cart" =>
        "?????????????? Handel::Cart ??",

    "Param 1 is not a HASH reference or Handel::Cart::Item" =>
        "????????????? Handel::Cart::Item ??",

    "Param 1 is not a HASH reference, Handel::Order::Item or Handel::Cart::Item" =>
        "????????????Handel::Order::Item ????? Handel::Cart::Item ??",

    "Unknown restore mode" =>
        "???????",

    "Currency code '[_1]' is invalid or malformed" =>
        "???? '[_1]' ???????",

    "Param 1 is not a a valid CHECKOUT_PHASE_* value" =>
        "???????????? CHECKOUT_PHASE_* ?",

    "Param 1 is not a CODE reference" =>
        "???????????",

    "Param 1 is not an ARRAY reference" =>
        "???????????",

    "Param 1 is not an ARRAY reference or string" =>
        "??????????????",

    "Param 1 is not a HASH reference, Handel::Order object, or order id" =>
        "????????????Handel::Object ?????????",

    "Param 1 is not a Handel::Checkout::Message object or text message" =>
        "??????? Handel::Checkout::Message ????????",

    ## Taglib exceptions
    "Tag '[_1]' not valid inside of other Handel tags" =>
        "? Handel ?????'[_1]' ???????",

    "Tag '[_1]' not valid here" =>
        "????? '[_1]' ???",

    ## naughty bits
    "has invalid value" =>
        "????",

    "[_1] value already exists" =>
        "[_1] ?????",

    ## Order exceptions
    "Could not find a cart matching the supplid search criteria" =>
        "?????????????????????",

    "Could not create a new order because the supplied cart is empty" =>
        "???????????????????",

    ## Checkout exception
    "No order is assocated with this checkout process" =>
        "?????????????",
);

1;
__END__

=head1 NAME

Handel::L10N::zh_tw - Handel Language Pack: Traditional Chinese

=head1 AUTHOR

    Kang-min Liu
    CPAN ID: GUGOD
    gugod@gugod.org
    http://gugod.org
    http://gugod.blogspot.com

