use 5.16.0;
use strict;
use warnings;

our $VERSION = '0.2208'; # VERSION

package #
    Map::Metro::Standard::Moops {

    use base 'Moops';
    use List::Util 1.33 ();
    use Map::Metro::Types();
    use Eponymous::Hash();
    use List::Compare();
    use MooseX::SetOnce();
    use MooseX::AttributeDocumented();

    sub import {
        my $class = shift;
        my %opts = @_;

        push @{ $opts{'imports'} ||= [] } => (
            'List::Util'        => [qw/any none sum/],
            'Eponymous::Hash'   => ['eh'],
            'String::Trim'      => ['trim'],
            'feature'           => [qw/:5.16/],
            'Map::Metro::Types' => [{ replace => 1 }, '-types'],
            'List::Compare'     => [],
            'MooseX::SetOnce'   => [],
            'MooseX::AttributeDocumented' => [],
        );

        $class->SUPER::import(%opts);
    }
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Map::Metro::Standard::Moops

=head1 VERSION

Version 0.2208, released 2015-10-27.

=head1 SOURCE

L<https://github.com/Csson/p5-Map-Metro>

=head1 HOMEPAGE

L<https://metacpan.org/release/Map-Metro>

=head1 AUTHOR

Erik Carlsson <info@code301.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Erik Carlsson <info@code301.com>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
