use 5.14.0;

package Map::Metro::Plugin::Map::Copenhagen;

our $VERSION = '0.2004'; # VERSION
# ABSTRACT: Map::Metro map for Copenhagen

use Moose;
with 'Map::Metro::Plugin::Map';

has '+mapfile' => (
    default => 'map-copenhagen.metro',
);
sub map_version {
    return $VERSION;
}
sub map_package {
    return __PACKAGE__;
}

1;


1;

__END__

=pod

=encoding utf-8

=head1 NAME

Map::Metro::Plugin::Map::Copenhagen - Map::Metro map for Copenhagen

=head1 VERSION

Version 0.2004, released 2015-01-10.

=head1 SYNOPSIS

    use Map::Metro;
    my $graph = Map::Metro->new('Copenhagen')->parse;

=head1 DESCRIPTION

See L<Map::Metro> for usage information.

=head1 Status

This map includes:

=over 4

=item *

Both lines of the Copenhagen metro (L<wikipedia|https://en.wikipedia.org/wiki/Copenhagen_metro>)

=back

=for HTML <p><a href="https://raw.githubusercontent.com/Csson/p5-Map-Metro-Copenhagen/master/static/images/copenhagen.png"><img src="https://raw.githubusercontent.com/Csson/p5-Map-Metro-Copenhagen/master/static/images/copenhagen.png" style="max-width: 600px" /></a></p>

=head1 SOURCE

L<https://github.com/Csson/p5-Map-Metro-Copenhagen>

=head1 HOMEPAGE

L<https://metacpan.org/release/Map-Metro-Plugin-Map-Copenhagen>

=head1 AUTHOR

Erik Carlsson <info@code301.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Erik Carlsson.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
