#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for all tag names
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    12/31/2004  - P. Harvey Created
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.01';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo);

#
# Note: the tables below are generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

my @tableList = (
    'Image::ExifTool::Canon::CameraSettings',
    'Image::ExifTool::Canon::Canon1DSettings',
    'Image::ExifTool::Canon::Main',
    'Image::ExifTool::Canon::PictureInfo',
    'Image::ExifTool::Canon::PreviewImageInfo',
    'Image::ExifTool::Canon::ShotInfo',
    'Image::ExifTool::CanonCustom::Functions',
    'Image::ExifTool::CanonCustom::Functions10D',
    'Image::ExifTool::CanonCustom::Functions1D',
    'Image::ExifTool::CanonCustom::Functions20D',
    'Image::ExifTool::CanonRaw::DateData',
    'Image::ExifTool::CanonRaw::ImageSize',
    'Image::ExifTool::CanonRaw::Main',
    'Image::ExifTool::CanonRaw::MakeModel',
    'Image::ExifTool::CanonRaw::Rotation',
    'Image::ExifTool::CanonRaw::WhiteBalance',
    'Image::ExifTool::Casio::MakerNote1',
    'Image::ExifTool::Casio::MakerNote2',
    'Image::ExifTool::Exif::Main',
    'Image::ExifTool::FujiFilm::Main',
    'Image::ExifTool::GPS::Main',
    'Image::ExifTool::GeoTiff::Main',
    'Image::ExifTool::ICC_Profile::Chromaticity',
    'Image::ExifTool::ICC_Profile::ColorantTable',
    'Image::ExifTool::ICC_Profile::Header',
    'Image::ExifTool::ICC_Profile::Main',
    'Image::ExifTool::ICC_Profile::Measurement',
    'Image::ExifTool::ICC_Profile::ViewingConditions',
    'Image::ExifTool::IPTC::ApplicationRecord',
    'Image::ExifTool::IPTC::EnvelopeRecord',
    'Image::ExifTool::IPTC::Main',
    'Image::ExifTool::IPTC::NewsPhoto',
    'Image::ExifTool::IPTC::ObjectData',
    'Image::ExifTool::IPTC::PostObjectData',
    'Image::ExifTool::IPTC::PreObjectData',
    'Image::ExifTool::Minolta::CameraSettings',
    'Image::ExifTool::Minolta::Main',
    'Image::ExifTool::Nikon::ColorBalanceD100',
    'Image::ExifTool::Nikon::ColorBalanceD2H',
    'Image::ExifTool::Nikon::ColorBalanceD70',
    'Image::ExifTool::Nikon::Main',
    'Image::ExifTool::Nikon::NikonCaptureOffsets',
    'Image::ExifTool::Nikon::PreviewImage',
    'Image::ExifTool::Olympus::Main',
    'Image::ExifTool::Panasonic::Main',
    'Image::ExifTool::Pentax::Main',
    'Image::ExifTool::Photoshop::JPEG_Quality',
    'Image::ExifTool::Photoshop::Main',
    'Image::ExifTool::PrintIM::Main',
    'Image::ExifTool::Sanyo::Main',
    'Image::ExifTool::Sigma::Main',
    'Image::ExifTool::Sony::Main',
    'Image::ExifTool::Unknown::Main',
    'Image::ExifTool::XMP::Main',
    'Image::ExifTool::compositeTags',
    'Image::ExifTool::extraTags',
);

my %tagLookup = (
    'actionadvised' => { 28 => 0x2a },
    'addoriginaldecisiondata' => { 9 => 0x11 },
    'adjustmentmode' => { 50 => 0x15 },
    'advisory' => { 53 => 'Advisory' },
    'aebbracketvalue' => { 5 => 0x11 },
    'aebsequence' => { 6 => 0x7, 7 => 0x9, 8 => 0x9, 9 => 0x8 },
    'afassist' => { 6 => 0x5, 7 => 0x5 },
    'afassistbeam' => { 9 => 0x4 },
    'afmode' => { 50 => 0x5 },
    'afpoint' => { 0 => 0x13, 40 => 0x88 },
    'afpointactivationarea' => { 8 => 0x11 },
    'afpointillumination' => { 8 => 0xa },
    'afpointregistration' => { 7 => 0x7 },
    'afpointselection' => { 8 => 0xb },
    'afpointselectionmethod' => { 9 => 0xc },
    'afpointspotmetering' => { 8 => 0xd },
    'afpointsused' => { 3 => 0x16 },
    'aiservotrackingsensitivity' => { 8 => 0x14 },
    'aliaslayermetadata' => { 18 => 0xc660 },
    'alphachannelsnames' => { 47 => 0x3ee },
    'analogbalance' => { 18 => 0xc627 },
    'annotations' => { 18 => 0xc44f },
    'antialiasstrength' => { 18 => 0xc632 },
    'aperture' => { 54 => 'Aperture' },
    'aperturevalue' => { 18 => 0x9202, 53 => 'ApertureValue' },
    'applicationnotes' => { 18 => 0x2bc },
    'applicationrecordversion' => { 28 => 0x0 },
    'armidentifier' => { 29 => 0x78 },
    'armversion' => { 29 => 0x7a },
    'artist' => { 18 => 0x13b, 53 => 'Artist' },
    'asshotneutral' => { 18 => 0xc628 },
    'asshotwhitexy' => { 18 => 0xc629 },
    'assistbuttonfunction' => { 7 => 0xd },
    'atob0' => { 25 => 'A2B0' },
    'atob1' => { 25 => 'A2B1' },
    'atob2' => { 25 => 'A2B2' },
    'audio' => { 44 => 0x20 },
    'audioduration' => { 28 => 0x99 },
    'audiooutcue' => { 28 => 0x9a },
    'audiosamplingrate' => { 28 => 0x97 },
    'audiosamplingresolution' => { 28 => 0x98 },
    'audiotype' => { 28 => 0x96 },
    'author' => { 53 => 'Author' },
    'authorsposition' => { 53 => 'AuthorsPosition' },
    'autobracket' => { 50 => 0x19 },
    'autobracketing' => { 19 => 0x1100 },
    'autoexposurebracketing' => { 5 => 0x10 },
    'auxiliarylens' => { 40 => 0x82 },
    'badfaxlines' => { 18 => 0x146 },
    'baselineexposure' => { 18 => 0xc62a },
    'baselinenoise' => { 18 => 0xc62b },
    'baselinesharpness' => { 18 => 0xc62c },
    'baseurl' => { 53 => 'BaseURL' },
    'batterylevel' => { 18 => 0x828f },
    'bayergreensplit' => { 18 => 0xc62d },
    'bestqualityscale' => { 18 => 0xc65c },
    'bestshotmode' => { 17 => 0x3007 },
    'bitspercomponent' => { 31 => 0x87 },
    'bitspersample' => { 18 => 0x102, 53 => 'BitsPerSample' },
    'blacklevel' => { 18 => 0xc61a },
    'blackleveldeltah' => { 18 => 0xc61b },
    'blackleveldeltav' => { 18 => 0xc61c },
    'blacklevelrepeatdim' => { 18 => 0xc619 },
    'bluebalance' => { 37 => 0x1, 38 => 0x1, 39 => 0x1, 43 => 0x1018 },
    'bluebalanceauto' => { 15 => 0x1 },
    'bluebalanceb&w' => { 15 => 0xf },
    'bluebalancecloudy' => { 15 => 0x5 },
    'bluebalancecustom' => { 15 => 0xd },
    'bluebalancedaylight' => { 15 => 0x3 },
    'bluebalanceflash' => { 15 => 0xb },
    'bluebalancefluorescent' => { 15 => 0x9 },
    'bluebalanceshade' => { 15 => 0x11 },
    'bluebalancetungsten' => { 15 => 0x7 },
    'bluehue' => { 53 => 'BlueHue' },
    'bluematrixcolumn' => { 25 => 'bXYZ' },
    'bluesaturation' => { 53 => 'BlueSaturation' },
    'bluetrc' => { 25 => 'bTRC' },
    'blurwarning' => { 19 => 0x1300 },
    'bracketstep' => { 35 => 0xe },
    'brightness' => { 35 => 0x2c, 53 => 'Brightness' },
    'brightnessvalue' => { 18 => 0x9203, 53 => 'BrightnessValue' },
    'btoa0' => { 25 => 'B2A0' },
    'btoa1' => { 25 => 'B2A1' },
    'btoa2' => { 25 => 'B2A2' },
    'bulbduration' => { 5 => 0x18 },
    'bwfilter' => { 35 => 0x2a },
    'by-line' => { 28 => 0x50 },
    'by-linetitle' => { 28 => 0x55 },
    'calibrationdatetime' => { 25 => 'calt' },
    'calibrationilluminant1' => { 18 => 0xc65a },
    'calibrationilluminant2' => { 18 => 0xc65b },
    'cameracalibration1' => { 18 => 0xc623 },
    'cameracalibration2' => { 18 => 0xc624 },
    'cameraid' => { 43 => 0x209, 49 => 0x209 },
    'cameraiso' => { 0 => 0x10 },
    'canon1dsettings' => { 2 => 0xa },
    'canona0tag' => { 2 => 0xa0 },
    'canoncamerasettings' => { 2 => 0x1, 12 => 0x102d },
    'canoncolorinfo1' => { 12 => 0x32 },
    'canoncolorinfo2' => { 12 => 0x102c },
    'canoncustomfunctions' => { 2 => 0xf },
    'canoncustomfunctions10d' => { 2 => 0xf, 12 => 0x1033 },
    'canoncustomfunctions1d' => { 2 => 0x90 },
    'canoncustomfunctions20d' => { 2 => 0xf },
    'canonexposuremode' => { 0 => 0x14 },
    'canonfiledescription' => { 12 => 0x805 },
    'canonfilelength' => { 2 => 0xe },
    'canonfiletype' => { 12 => 0x815 },
    'canonfirmwareversion' => { 2 => 0x7, 12 => 0x80b },
    'canonflashmode' => { 0 => 0x4 },
    'canonimageheight' => { 3 => 0x3 },
    'canonimageheightasshot' => { 3 => 0x5 },
    'canonimagesize' => { 0 => 0xa },
    'canonimagetype' => { 2 => 0x6 },
    'canonimagewidth' => { 3 => 0x2 },
    'canonimagewidthasshot' => { 3 => 0x4 },
    'canonpictureinfo' => { 2 => 0x12, 12 => 0x1038 },
    'canonrawdatedata' => { 12 => 0x180e },
    'canonrawmakemodel' => { 12 => 0x80a },
    'canonrawrotation' => { 12 => 0x1810 },
    'canonshotinfo' => { 2 => 0x4, 12 => 0x102a },
    'caption-abstract' => { 28 => 0x78 },
    'captionwriter' => { 53 => 'CaptionWriter' },
    'casioimagesize' => { 17 => 0x9 },
    'casiopreviewlength' => { 17 => 0x3 },
    'casiopreviewstart' => { 17 => 0x4 },
    'category' => { 28 => 0xf, 53 => 'Category' },
    'ccdisosensitivity' => { 17 => 0x3014 },
    'ccdsensitivity' => { 16 => 0x14 },
    'celllength' => { 18 => 0x109 },
    'cellwidth' => { 18 => 0x108 },
    'certificate' => { 53 => 'Certificate' },
    'cfalayout' => { 18 => 0xc617 },
    'cfapattern' => { 18 => 0xa302, 53 => 'CFAPattern' },
    'cfapattern2' => { 18 => 0x828e },
    'cfapatterncolumns' => { 53 => 'CFAPatternColumns' },
    'cfapatternrows' => { 53 => 'CFAPatternRows' },
    'cfapatternvalues' => { 53 => 'CFAPatternValues' },
    'cfaplanecolor' => { 18 => 0xc616 },
    'cfarepeatpatterndim' => { 18 => 0x828d },
    'chartarget' => { 25 => 'targ' },
    'chromablurradius' => { 18 => 0xc631 },
    'chromaticaberrationb' => { 53 => 'ChromaticAberrationB' },
    'chromaticaberrationr' => { 53 => 'ChromaticAberrationR' },
    'chromaticadaptation' => { 25 => 'chad' },
    'chromaticity' => { 25 => 'chrm' },
    'chromaticitychannel1' => { 22 => 0xc },
    'chromaticitychannel2' => { 22 => 0x14 },
    'chromaticitychannel3' => { 22 => 0x1c },
    'chromaticitychannel4' => { 22 => 0x24 },
    'chromaticitychannels' => { 22 => 0x8 },
    'chromaticitycolorant' => { 22 => 0xa },
    'city' => { 28 => 0x5a, 53 => 'City' },
    'cleanfaxdata' => { 18 => 0x147 },
    'clippath' => { 18 => 0x157 },
    'cmmflags' => { 24 => 0x2c },
    'codedcharacterset' => { 29 => 0x5a },
    'codingmethods' => { 18 => 0x193 },
    'coloradjustment' => { 50 => 0x14 },
    'coloradjustmentmode' => { 49 => 0x210 },
    'colorant1coordinates' => { 23 => 0x2c },
    'colorant1name' => { 23 => 0xc },
    'colorant2coordinates' => { 23 => 0x52 },
    'colorant2name' => { 23 => 0x32 },
    'colorant3coordinates' => { 23 => 0x78 },
    'colorant3name' => { 23 => 0x58 },
    'colorantcount' => { 23 => 0x8 },
    'colorantorder' => { 25 => 'clro' },
    'coloranttable' => { 25 => 'clrt' },
    'colorbalance1' => { 40 => 0xc },
    'colorbalance2dh' => { 40 => 0x97 },
    'colorbalanceblue' => { 35 => 0x1e },
    'colorbalanced100' => { 40 => 0x97 },
    'colorbalanced70' => { 40 => 0x97 },
    'colorbalancegreen' => { 35 => 0x1d },
    'colorbalancered' => { 35 => 0x1c },
    'colorbalanceunknown' => { 40 => 0x97 },
    'coloreffect' => { 44 => 0x28 },
    'colorfilter' => { 35 => 0x29 },
    'colorhue' => { 40 => 0x8d },
    'colormap' => { 18 => 0x140 },
    'colormatrix' => { 1 => 0xa },
    'colormatrix1' => { 18 => 0xc621 },
    'colormatrix2' => { 18 => 0xc622 },
    'colormode' => { 17 => 0x3015, 35 => 0x28, 36 => 0x101, 40 => 0x3 },
    'colornoisereduction' => { 53 => 'ColorNoiseReduction' },
    'colorrepresentation' => { 31 => 0x3c },
    'colorsequence' => { 31 => 0x41 },
    'colorspace' => { 12 => 0x10b4, 18 => 0xa001, 50 => 0xb, 53 => 'ColorSpace' },
    'colorspacedata' => { 24 => 0x10 },
    'colortemperature' => { 1 => 0x9 },
    'colortone' => { 0 => 0x2a },
    'comment' => { 55 => 'Comment' },
    'componentsconfiguration' => { 18 => 0x9101, 53 => 'ComponentsConfiguration' },
    'compressedbitsperpixel' => { 18 => 0x9102, 53 => 'CompressedBitsPerPixel' },
    'compressedimagesize' => { 36 => 0x40 },
    'compression' => { 18 => 0x103, 42 => 0x103, 53 => 'Compression' },
    'conditionalfec' => { 54 => 'ConditionalFEC' },
    'confirmedobjectsize' => { 33 => 0xa },
    'consecutivebadfaxlines' => { 18 => 0x148 },
    'contact' => { 28 => 0x76 },
    'contentlocationcode' => { 28 => 0x1a },
    'contentlocationname' => { 28 => 0x1b },
    'continuousdrive' => { 0 => 0x5 },
    'contrast' => { 0 => 0xd, 16 => 0xc, 17 => 0x20, 18 => 0xa408, 19 => 0x1004, 35 => 0x20, 44 => 0x2c, 45 => 0x20, 50 => 0xd, 53 => 'Contrast' },
    'contributor' => { 53 => 'Contributor' },
    'copyright' => { 18 => 0x8298, 25 => 'cprt', 53 => 'Copyright' },
    'copyrightnotice' => { 28 => 0x74 },
    'country' => { 53 => 'Country' },
    'country-primarylocationcode' => { 28 => 0x64 },
    'country-primarylocationname' => { 28 => 0x65 },
    'coverage' => { 53 => 'Coverage' },
    'crdinfo' => { 25 => 'crdi' },
    'createdate' => { 18 => 0x9004, 53 => 'CreateDate' },
    'creationdate' => { 53 => 'CreationDate' },
    'creator' => { 53 => 'Creator' },
    'creatortool' => { 53 => 'CreatorTool' },
    'credit' => { 28 => 0x6e, 53 => 'Credit' },
    'customrendered' => { 18 => 0xa401, 53 => 'CustomRendered' },
    'datacompressionmethod' => { 31 => 0x6e },
    'datadump' => { 40 => 0x10, 43 => 0xf00, 44 => 0x21, 49 => 0xf00 },
    'date' => { 53 => 'Date' },
    'datecreated' => { 28 => 0x37, 53 => 'DateCreated' },
    'datesent' => { 29 => 0x46 },
    'datetime' => { 53 => 'DateTime' },
    'datetimecreated' => { 54 => 'DateTimeCreated' },
    'datetimedigitized' => { 53 => 'DateTimeDigitized' },
    'datetimeoriginal' => { 10 => 0x0, 18 => 0x9003, 53 => 'DateTimeOriginal', 54 => 'DateTimeOriginal' },
    'decode' => { 18 => 0x1b1 },
    'decodertable' => { 12 => 0x1835 },
    'decposition' => { 35 => 0x32 },
    'defaultcroporigin' => { 18 => 0xc61f },
    'defaultcropsize' => { 18 => 0xc620 },
    'defaultimagecolor' => { 18 => 0x1b2 },
    'defaultscale' => { 18 => 0xc61e },
    'derivedfrom' => { 53 => 'DerivedFrom' },
    'derivedfromdocumentid' => { 53 => 'DerivedFromDocumentID' },
    'derivedfrominstanceid' => { 53 => 'DerivedFromInstanceID' },
    'derivedfrommanager' => { 53 => 'DerivedFromManager' },
    'derivedfrommanagervariant' => { 53 => 'DerivedFromManagerVariant' },
    'derivedfrommanageto' => { 53 => 'DerivedFromManageTo' },
    'derivedfrommanageui' => { 53 => 'DerivedFromManageUI' },
    'derivedfromrenditionclass' => { 53 => 'DerivedFromRenditionClass' },
    'derivedfromrenditionparams' => { 53 => 'DerivedFromRenditionParams' },
    'derivedfromversionid' => { 53 => 'DerivedFromVersionID' },
    'description' => { 53 => 'Description' },
    'destination' => { 29 => 0x5 },
    'deviceattributes' => { 24 => 0x38 },
    'devicemanufacturer' => { 24 => 0x30 },
    'devicemfgdesc' => { 25 => 'dmnd' },
    'devicemodel' => { 24 => 0x34 },
    'devicemodeldesc' => { 25 => 'dmdd' },
    'devicesettingdescription' => { 18 => 0xa40b, 53 => 'DeviceSettingDescription' },
    'devicesettingdescriptioncolumns' => { 53 => 'DeviceSettingDescriptionColumns' },
    'devicesettingdescriptionrows' => { 53 => 'DeviceSettingDescriptionRows' },
    'devicesettingdescriptionsettings' => { 53 => 'DeviceSettingDescriptionSettings' },
    'devicesettings' => { 25 => 'devs' },
    'digitalcreationdate' => { 28 => 0x3e },
    'digitalcreationtime' => { 28 => 0x3f },
    'digitalzoom' => { 0 => 0xc, 16 => 0xa, 35 => 0xc, 40 => 0x86, 43 => 0x204, 45 => 0x1e, 49 => 0x204 },
    'digitalzoomon' => { 49 => 0x21b },
    'digitalzoomratio' => { 18 => 0xa404, 53 => 'DigitalZoomRatio' },
    'dngbackwardversion' => { 18 => 0xc613 },
    'dngcameraserialnumber' => { 18 => 0xc62f },
    'dnglensinfo' => { 18 => 0xc630 },
    'dngprivatedata' => { 18 => 0xc634 },
    'dngversion' => { 18 => 0xc612 },
    'documentid' => { 53 => 'DocumentID' },
    'documentname' => { 18 => 0x10d },
    'dotrange' => { 18 => 0x150 },
    'drivemode' => { 35 => 0x6, 50 => 0x3, 54 => 'DriveMode' },
    'easymode' => { 0 => 0xb },
    'editorialupdate' => { 28 => 0x8 },
    'editstatus' => { 28 => 0x7 },
    'endpoints' => { 31 => 0x7d },
    'enhancement' => { 17 => 0x3016 },
    'envelopenumber' => { 29 => 0x28 },
    'envelopepriority' => { 29 => 0x3c },
    'enveloperecordversion' => { 29 => 0x0 },
    'epsonimageheight' => { 43 => 0x20c },
    'epsonimagewidth' => { 43 => 0x20b },
    'epsonsoftware' => { 43 => 0x20d },
    'error' => { 55 => 'Error' },
    'ettlii' => { 9 => 0xd },
    'excursiontolerance' => { 31 => 0x82 },
    'exifdata' => { 55 => 'ExifData' },
    'exifimageheight' => { 53 => 'PixelYDimension' },
    'exifimagelength' => { 18 => 0xa003 },
    'exifimagewidth' => { 18 => 0xa002, 53 => 'PixelXDimension' },
    'exifoffset' => { 18 => 0x8769 },
    'exiftoolversion' => { 55 => 'ExifToolVersion' },
    'exifversion' => { 18 => 0x9000, 53 => 'ExifVersion' },
    'expirationdate' => { 28 => 0x25 },
    'expirationtime' => { 28 => 0x26 },
    'exposure' => { 53 => 'Exposure' },
    'exposurebracketvalue' => { 40 => 0x19 },
    'exposurecompensation' => { 5 => 0x6, 18 => 0x9204, 35 => 0xd, 50 => 0xc, 53 => 'ExposureBiasValue' },
    'exposureindex' => { 18 => [0x9215,0xa215], 53 => 'ExposureIndex' },
    'exposurelevelincrements' => { 6 => 0x4, 7 => 0x6, 8 => 0x6, 9 => 0x5 },
    'exposuremode' => { 18 => 0xa402, 35 => 0x1, 50 => 0x8, 53 => 'ExposureMode' },
    'exposureprogram' => { 18 => 0x8822, 53 => 'ExposureProgram' },
    'exposuretime' => { 5 => 0x16, 18 => 0x829a, 53 => 'ExposureTime' },
    'exposurewarning' => { 19 => 0x1302 },
    'extrasamples' => { 18 => 0x152 },
    'faxprofile' => { 18 => 0x192 },
    'fileformat' => { 29 => 0x14 },
    'filename' => { 55 => 'FileName' },
    'filenumber' => { 2 => 0x8, 12 => 0x5817 },
    'filenumbermemory' => { 35 => 0x1a },
    'filesize' => { 55 => 'FileSize' },
    'filesource' => { 18 => 0xa300, 53 => 'FileSource' },
    'filesystemversion' => { 40 => 0x1 },
    'filetype' => { 55 => 'FileType' },
    'fileversion' => { 29 => 0x16 },
    'fillflashautoreduction' => { 6 => 0xa, 7 => 0xe, 8 => 0xe },
    'fillorder' => { 18 => 0x10a },
    'filter' => { 17 => 0x3017 },
    'finderdisplayduringexposure' => { 8 => 0x1 },
    'firmware' => { 50 => 0x17 },
    'firmwareversion' => { 44 => 0x2 },
    'fixtureidentifier' => { 28 => 0x16 },
    'flash' => { 18 => 0x9209, 53 => 'Flash' },
    'flashactivity' => { 0 => 0x1c },
    'flashbias' => { 44 => 0x24 },
    'flashbits' => { 0 => 0x1d },
    'flashdistance' => { 17 => 0x2034 },
    'flashenergy' => { 18 => [0x920b,0xa20b], 53 => 'FlashEnergy' },
    'flashexposurebracketvalue' => { 40 => 0x18 },
    'flashexposurecomp' => { 5 => 0xf, 35 => 0x23, 40 => 0x12 },
    'flashfired' => { 35 => 0x14, 53 => 'FlashFired' },
    'flashfiring' => { 9 => 0x6 },
    'flashfunction' => { 53 => 'FlashFunction' },
    'flashintensity' => { 16 => 0x5 },
    'flashmode' => { 16 => 0x4, 35 => 0x2, 40 => 0x87, 49 => 0x225, 53 => 'FlashMode' },
    'flashon' => { 54 => 'FlashOn' },
    'flashpixversion' => { 18 => 0xa000, 53 => 'FlashpixVersion' },
    'flashredeyemode' => { 53 => 'FlashRedEyeMode' },
    'flashreturn' => { 53 => 'FlashReturn' },
    'flashsetting' => { 40 => 0x8 },
    'flashstrength' => { 19 => 0x1011 },
    'flashsyncspeedav' => { 6 => 0x6, 7 => 0x3, 9 => 0x2 },
    'flashtype' => { 40 => 0x9, 54 => 'FlashType' },
    'flickerreduce' => { 49 => 0x218 },
    'fnumber' => { 5 => 0x15, 18 => 0x829d, 53 => 'FNumber' },
    'focallength' => { 12 => 0x5029, 17 => 0x1d, 18 => 0x920a, 35 => 0x12, 45 => 0x1d, 53 => 'FocalLength' },
    'focallength35efl' => { 54 => 'FocalLength35efl' },
    'focallengthin35mmformat' => { 18 => 0xa405, 53 => 'FocalLengthIn35mmFilm' },
    'focalplaneresolutionunit' => { 18 => [0x9210,0xa210], 53 => 'FocalPlaneResolutionUnit' },
    'focalplanexresolution' => { 18 => [0x920e,0xa20e], 53 => 'FocalPlaneXResolution' },
    'focalplaneyresolution' => { 18 => [0x920f,0xa20f], 53 => 'FocalPlaneYResolution' },
    'focalunits' => { 0 => 0x19 },
    'focusarea' => { 35 => 0x31 },
    'focuscontinuous' => { 0 => 0x20 },
    'focusdistance' => { 35 => 0x13 },
    'focusdistancelower' => { 5 => 0x14 },
    'focusdistanceupper' => { 5 => 0x13 },
    'focusingscreen' => { 8 => 0x0 },
    'focusmode' => { 0 => 0x7, 16 => 0x3, 17 => [0x3003,0xd], 19 => 0x1021, 35 => 0x30, 40 => 0x7, 44 => 0x7, 45 => 0xd },
    'focussetting' => { 50 => 0x6 },
    'focustype' => { 0 => 0x12 },
    'focuswarning' => { 19 => 0x1301 },
    'foldername' => { 35 => 0x27 },
    'format' => { 53 => 'Format' },
    'freebytecounts' => { 18 => 0x121 },
    'freeoffsets' => { 18 => 0x120 },
    'fujiflashmode' => { 19 => 0x1010 },
    'gaincontrol' => { 18 => 0xa407, 53 => 'GainControl' },
    'gamut' => { 25 => 'gamt' },
    'gdalmetadata' => { 18 => 0xa480 },
    'gdalnodata' => { 18 => 0xa481 },
    'geogangularunits' => { 21 => 0x806 },
    'geogangularunitsize' => { 21 => 0x807 },
    'geogazimuthunits' => { 21 => 0x80c },
    'geogcitation' => { 21 => 0x801 },
    'geogellipsoid' => { 21 => 0x808 },
    'geoggeodeticdatum' => { 21 => 0x802 },
    'geoginvflattening' => { 21 => 0x80b },
    'geoglinearunits' => { 21 => 0x804 },
    'geoglinearunitsize' => { 21 => 0x805 },
    'geogprimemeridian' => { 21 => 0x803 },
    'geogprimemeridianlong' => { 21 => 0x80d },
    'geographictype' => { 21 => 0x800 },
    'geogsemimajoraxis' => { 21 => 0x809 },
    'geogsemiminoraxis' => { 21 => 0x80a },
    'geotiffasciiparams' => { 18 => 0x87b1 },
    'geotiffdirectory' => { 18 => 0x87af },
    'geotiffdoubleparams' => { 18 => 0x87b0 },
    'geotiffversion' => { 21 => 0x1 },
    'globalparametersifd' => { 18 => 0x190 },
    'gpsaltitude' => { 20 => 0x6, 53 => 'GPSAltitude' },
    'gpsaltituderef' => { 20 => 0x5, 53 => 'GPSAltitudeRef' },
    'gpsareainformation' => { 20 => 0x1c, 53 => 'GPSAreaInformation' },
    'gpsdatestamp' => { 20 => 0x1d },
    'gpsdatetime' => { 54 => 'GPSDateTime' },
    'gpsdestbearing' => { 20 => 0x18, 53 => 'GPSDestBearing' },
    'gpsdestbearingref' => { 20 => 0x17, 53 => 'GPSDestBearingRef' },
    'gpsdestdistance' => { 20 => 0x1a, 53 => 'GPSDestDistance' },
    'gpsdestdistanceref' => { 20 => 0x19, 53 => 'GPSDestDistanceRef' },
    'gpsdestlatitude' => { 20 => 0x14, 53 => 'GPSDestLatitude' },
    'gpsdestlatituderef' => { 20 => 0x13 },
    'gpsdestlongitude' => { 20 => 0x16, 53 => 'GPSDestLongitude' },
    'gpsdestlongituderef' => { 20 => 0x15 },
    'gpsdifferential' => { 20 => 0x1e, 53 => 'GPSDifferential' },
    'gpsdop' => { 20 => 0xb },
    'gpsimgdirection' => { 20 => 0x11, 53 => 'GPSImgDirection' },
    'gpsimgdirectionref' => { 20 => 0x10, 53 => 'GPSImgDirectionRef' },
    'gpsinfo' => { 18 => 0x8825 },
    'gpslatitude' => { 20 => 0x2, 53 => 'GPSLatitude' },
    'gpslatituderef' => { 20 => 0x1 },
    'gpslongitude' => { 20 => 0x4, 53 => 'GPSLongitude' },
    'gpslongituderef' => { 20 => 0x3 },
    'gpsmapdatum' => { 20 => 0x12, 53 => 'GPSMapDatum' },
    'gpsmeasuremode' => { 20 => 0xa },
    'gpsprocessingmethod' => { 20 => 0x1b, 53 => 'GPSProcessingMethod' },
    'gpssatellites' => { 20 => 0x8, 53 => 'GPSSatellites' },
    'gpsspeed' => { 20 => 0xd, 53 => 'GPSSpeed' },
    'gpsspeedref' => { 20 => 0xc, 53 => 'GPSSpeedRef' },
    'gpsstatus' => { 20 => 0x9, 53 => 'GPSStatus' },
    'gpstimestamp' => { 20 => 0x7, 53 => 'GPSTimeStamp' },
    'gpstrack' => { 20 => 0xf, 53 => 'GPSTrack' },
    'gpstrackref' => { 20 => 0xe, 53 => 'GPSTrackRef' },
    'gpsversionid' => { 20 => 0x0, 53 => 'GPSVersionID' },
    'grayresponsecurve' => { 18 => 0x123 },
    'grayresponseunit' => { 18 => 0x122 },
    'graytrc' => { 25 => 'kTRC' },
    'greenhue' => { 53 => 'GreenHue' },
    'greenmatrixcolumn' => { 25 => 'gXYZ' },
    'greensaturation' => { 53 => 'GreenSaturation' },
    'greentrc' => { 25 => 'gTRC' },
    'gtcitation' => { 21 => 0x402 },
    'gtmodeltype' => { 21 => 0x400 },
    'gtrastertype' => { 21 => 0x401 },
    'halftonehints' => { 18 => 0x141 },
    'headline' => { 28 => 0x69, 53 => 'Headline' },
    'highlight' => { 50 => 0xf },
    'history' => { 53 => 'History' },
    'historyaction' => { 53 => 'HistoryAction' },
    'historyinstanceid' => { 53 => 'HistoryInstanceID' },
    'historyparameters' => { 53 => 'HistoryParameters' },
    'historysoftwareagent' => { 53 => 'HistorySoftwareAgent' },
    'historywhen' => { 53 => 'HistoryWhen' },
    'hostcomputer' => { 18 => 0x13c },
    'hueadjustment' => { 40 => 0x92 },
    'icc_profile' => { 18 => 0x8773 },
    'identifier' => { 53 => 'Identifier' },
    'ifd0_offset' => { 41 => 0x1 },
    'imageadjustment' => { 40 => 0x80 },
    'imageboundry' => { 40 => 0x16 },
    'imagedescription' => { 18 => 0x10e, 53 => 'ImageDescription' },
    'imageheight' => { 11 => 0x2, 18 => 0x101, 53 => 'ImageLength', 55 => 'ImageHeight' },
    'imagehistory' => { 18 => [0x9213,0xa213] },
    'imageid' => { 18 => 0x800d },
    'imagelayer' => { 18 => 0x87ac },
    'imagenumber' => { 18 => [0x9211,0xa211] },
    'imageoptimization' => { 40 => 0xa9 },
    'imageorientation' => { 28 => 0x83 },
    'imagequality' => { 44 => 0x1 },
    'imagesize' => { 54 => 'ImageSize' },
    'imagesourcedata' => { 18 => 0x935c },
    'imagestabilization' => { 36 => 0x18 },
    'imagestabilizer' => { 44 => 0x1a },
    'imagetype' => { 28 => 0x82 },
    'imageuniqueid' => { 18 => 0xa420, 53 => 'ImageUniqueID' },
    'imagewidth' => { 11 => 0x1, 18 => 0x100, 53 => 'ImageWidth', 55 => 'ImageWidth' },
    'indexed' => { 18 => 0x15a },
    'inknames' => { 18 => 0x14d },
    'inkset' => { 18 => 0x14c },
    'instructions' => { 53 => 'Instructions' },
    'interchangecolorspace' => { 31 => 0x40 },
    'intergraphflagregisters' => { 18 => 0x847f },
    'intergraphmatrix' => { 18 => 0x8480 },
    'intergraphpacketdata' => { 18 => 0x8474 },
    'interlace' => { 18 => 0x8829 },
    'internalflash' => { 35 => 0x2b },
    'interopindex' => { 18 => 0x1 },
    'interopoffset' => { 18 => 0xa005 },
    'interopversion' => { 18 => 0x2 },
    'intervallength' => { 35 => 0x10 },
    'intervalmode' => { 35 => 0x26 },
    'intervalnumber' => { 35 => 0x11 },
    'iptc-naa' => { 18 => 0x83bb },
    'iptc-naa2' => { 18 => 0x8568 },
    'iptcapplication' => { 30 => 0x2 },
    'iptcbitspersample' => { 31 => 0x56 },
    'iptcdata' => { 47 => 0x404 },
    'iptcenvelope' => { 30 => 0x1 },
    'iptcimageheight' => { 31 => 0x1e },
    'iptcimagerotation' => { 31 => 0x66 },
    'iptcimagewidth' => { 31 => 0x14 },
    'iptcnewsphoto' => { 30 => 0x3 },
    'iptcobjectdata' => { 30 => 0x8 },
    'iptcpicturenumber' => { 31 => 0xa },
    'iptcpixelheight' => { 31 => 0x32 },
    'iptcpixelwidth' => { 31 => 0x28 },
    'iptcpostobjectdata' => { 30 => 0x9 },
    'iptcpreobjectdata' => { 30 => 0x7 },
    'iso' => { 5 => 0x2, 18 => 0x8827, 53 => 'ISOSpeedRatings' },
    'isoexpansion' => { 9 => 0x7 },
    'isoselection' => { 40 => 0xf },
    'isosetting' => { 17 => 0x14, 35 => 0x24, 40 => 0x13 },
    'isospeedexpansion' => { 8 => 0x3 },
    'isoused' => { 40 => 0x2 },
    'ixusafpoint' => { 5 => 0xe },
    'jobref' => { 53 => 'JobRef' },
    'jobrefid' => { 53 => 'JobRefId' },
    'jobrefname' => { 53 => 'JobRefName' },
    'jobrefurl' => { 53 => 'JobRefUrl' },
    'jpeg_quality' => { 47 => 0x406 },
    'jpegactables' => { 18 => 0x209 },
    'jpegdctables' => { 18 => 0x208 },
    'jpeglosslesspredictors' => { 18 => 0x205 },
    'jpegpointtransforms' => { 18 => 0x206 },
    'jpegproc' => { 18 => 0x200 },
    'jpegqtables' => { 18 => 0x207 },
    'jpegrestartinterval' => { 18 => 0x203 },
    'jpegtables' => { 18 => 0x15b },
    'jpgfromraw' => { 12 => 0x2007, 54 => 'JpgFromRaw' },
    'jpgfromrawlength' => { 18 => 0x202 },
    'jpgfromrawstart' => { 18 => 0x201 },
    'keywords' => { 28 => 0x19, 53 => 'Keywords' },
    'language' => { 53 => 'Language' },
    'languageidentifier' => { 28 => 0x87 },
    'lastfilenumber' => { 35 => 0x1b },
    'lasturl' => { 53 => 'LastURL' },
    'lcdpanels' => { 8 => 0x8 },
    'lens' => { 40 => 0x84, 50 => 0xa, 53 => 'Lens', 54 => 'Lens' },
    'lens35efl' => { 54 => 'Lens35efl' },
    'lensafstopbutton' => { 6 => 0x9, 7 => 0x11, 8 => 0x13, 9 => 0x10 },
    'lenstype' => { 40 => 0x83, 45 => 0x3f },
    'lightsource' => { 18 => 0x9208, 40 => 0x90, 53 => 'LightSource' },
    'lightsourcespecial' => { 49 => 0x21d },
    'linearizationtable' => { 18 => 0xc618 },
    'linearresponselimit' => { 18 => 0xc62e },
    'localizedcameramodel' => { 18 => 0xc615 },
    'longexposurenoisereduction' => { 6 => 0x1, 9 => 0x1 },
    'longfocal' => { 0 => 0x17 },
    'luminance' => { 25 => 'lumi' },
    'luminancesmoothing' => { 53 => 'LuminanceSmoothing' },
    'macro' => { 19 => 0x1020, 43 => 0x202, 49 => 0x202 },
    'macromode' => { 0 => 0x1, 35 => 0xb, 44 => 0x1c },
    'make' => { 13 => 0x0, 18 => 0x10f, 53 => 'Make' },
    'makeandmodel' => { 25 => 'mmod' },
    'makernote' => { 53 => 'MakerNote' },
    'makernotecanon' => { 18 => 0x927c },
    'makernotecasio' => { 18 => 0x927c },
    'makernotecasio2' => { 18 => 0x927c },
    'makernotefujifilm' => { 18 => 0x927c },
    'makernoteleica' => { 18 => 0x927c },
    'makernoteminolta' => { 18 => 0x927c },
    'makernotenikon' => { 18 => 0x927c },
    'makernoteoffset' => { 49 => 0xff },
    'makernoteolympus' => { 18 => 0x927c },
    'makernotepanasonic' => { 18 => 0x927c },
    'makernotepentax' => { 18 => 0x927c },
    'makernotesafety' => { 18 => 0xc635 },
    'makernotesanyo' => { 18 => 0x927c },
    'makernotesigma' => { 18 => 0x927c },
    'makernotesony' => { 18 => 0x927c },
    'makernoteunknown' => { 18 => 0x927c },
    'makernoteversion' => { 36 => 0x0 },
    'managedfrom' => { 53 => 'ManagedFrom' },
    'managedfromdocumentid' => { 53 => 'ManagedFromDocumentID' },
    'managedfrominstanceid' => { 53 => 'ManagedFromInstanceID' },
    'managedfrommanager' => { 53 => 'ManagedFromManager' },
    'managedfrommanagervariant' => { 53 => 'ManagedFromManagerVariant' },
    'managedfrommanageto' => { 53 => 'ManagedFromManageTo' },
    'managedfrommanageui' => { 53 => 'ManagedFromManageUI' },
    'managedfromrenditionclass' => { 53 => 'ManagedFromRenditionClass' },
    'managedfromrenditionparams' => { 53 => 'ManagedFromRenditionParams' },
    'managedfromversionid' => { 53 => 'ManagedFromVersionID' },
    'manager' => { 53 => 'Manager' },
    'managervariant' => { 53 => 'ManagerVariant' },
    'manageto' => { 53 => 'ManageTo' },
    'manageui' => { 53 => 'ManageUI' },
    'manualfocusdistance' => { 40 => 0x85, 49 => 0x223 },
    'manualtv' => { 8 => 0x5 },
    'marked' => { 53 => 'Marked' },
    'maxaperture' => { 35 => 0x17 },
    'maxaperturevalue' => { 18 => 0x9205, 53 => 'MaxApertureValue' },
    'maximumobjectsize' => { 34 => 0x5f },
    'maxsamplevalue' => { 18 => 0x119 },
    'maxsubfilesize' => { 34 => 0x14 },
    'measurement' => { 25 => 'meas' },
    'measurementbacking' => { 26 => 0xc },
    'measurementflare' => { 26 => 0x1c },
    'measurementgeometry' => { 26 => 0x18 },
    'measurementilluminant' => { 26 => 0x20 },
    'measurementobserver' => { 26 => 0x8 },
    'mediablackpoint' => { 25 => 'bkpt' },
    'mediawhitepoint' => { 25 => 'wtpt' },
    'menubuttondisplayposition' => { 7 => 0xb, 9 => 0xa },
    'menubuttonreturn' => { 6 => 0xb },
    'metadatadate' => { 53 => 'MetadataDate' },
    'meteringmode' => { 0 => 0x11, 18 => 0x9207, 35 => 0x7, 45 => 0x17, 50 => 0x9, 53 => 'MeteringMode' },
    'minoltaaperture' => { 35 => 0xa },
    'minoltacamerasettings' => { 36 => 0x3 },
    'minoltacamerasettings2' => { 36 => 0xf00 },
    'minoltacamerasettingsold' => { 36 => 0x1 },
    'minoltadate' => { 35 => 0x15 },
    'minoltaimagesize' => { 35 => 0x4 },
    'minoltaiso' => { 35 => 0x8 },
    'minoltamodel' => { 35 => 0x25 },
    'minoltaquality' => { 35 => 0x5, 36 => [0x102,0x103] },
    'minoltashutterspeed' => { 35 => 0x9 },
    'minoltatime' => { 35 => 0x16 },
    'minsamplevalue' => { 18 => 0x118 },
    'mirrorlockup' => { 6 => 0x3, 7 => 0xc, 8 => 0xc, 9 => 0xb },
    'moddate' => { 53 => 'ModDate' },
    'model' => { 13 => 0x6, 18 => 0x110, 53 => 'Model' },
    'model2' => { 18 => 0x827d },
    'modeltiepoint' => { 18 => 0x8482 },
    'modeltransform' => { 18 => 0x85d8 },
    'modenumber' => { 18 => 0x195 },
    'modifydate' => { 18 => 0x132, 53 => 'ModifyDate' },
    'namedcolor' => { 25 => 'ncol' },
    'namedcolor2' => { 25 => 'ncl2' },
    'nativedisplayinfo' => { 25 => 'ndin' },
    'nefcurve1' => { 40 => 0x8c },
    'nefcurve2' => { 40 => 0x96 },
    'nefthumbnailsize' => { 40 => 0x99 },
    'newsphotoversion' => { 31 => 0x0 },
    'nickname' => { 53 => 'Nickname' },
    'nikoncaptureoffsets' => { 40 => 0xe0e },
    'nikonpreview' => { 40 => 0x11 },
    'noise' => { 18 => [0x920d,0xa20d] },
    'noisereduction' => { 40 => 0x95, 44 => 0x2d },
    'numberofinks' => { 18 => 0x14e },
    'numindexentries' => { 31 => 0x54 },
    'objectattributereference' => { 28 => 0x4 },
    'objectcycle' => { 28 => 0x4b },
    'objectdistance' => { 16 => 0x6, 17 => 0x2022 },
    'objectname' => { 28 => 0x5 },
    'objectpreviewdata' => { 28 => 0xca },
    'objectpreviewfileformat' => { 28 => 0xc8 },
    'objectpreviewfileversion' => { 28 => 0xc9 },
    'objectsizeannounced' => { 34 => 0x5a },
    'objecttypereference' => { 28 => 0x3 },
    'oceapplicationselector' => { 18 => 0xc428 },
    'oceidnumber' => { 18 => 0xc429 },
    'oceimagelogic' => { 18 => 0xc42a },
    'ocescanjobdesc' => { 18 => 0xc427 },
    'oecfcolumns' => { 53 => 'OECFColumns' },
    'oecfnames' => { 53 => 'OECFNames' },
    'oecfrows' => { 53 => 'OECFRows' },
    'oecfvalues' => { 53 => 'OECFValues' },
    'oldsubfiletype' => { 18 => 0xff },
    'opiproxy' => { 18 => 0x15f },
    'opticalzoomon' => { 49 => 0x219 },
    'opto-electricconvfactor' => { 18 => 0x8828, 53 => 'OECF' },
    'orientation' => { 18 => 0x112, 53 => 'Orientation' },
    'originalfilename' => { 12 => 0x816 },
    'originaltransmissionreference' => { 28 => 0x67 },
    'originatingprogram' => { 28 => 0x41 },
    'outputresponse' => { 25 => 'resp' },
    'owner' => { 53 => 'Owner' },
    'ownername' => { 2 => 0x9, 12 => 0x810 },
    'pagename' => { 18 => 0x11d },
    'pagenumber' => { 18 => 0x129 },
    'pcscitation' => { 21 => 0xc01 },
    'pdfversion' => { 53 => 'PDFVersion' },
    'pentaximagesize' => { 45 => 0x9 },
    'pentaxiso' => { 45 => 0x14 },
    'pentaxmode' => { 45 => 0x1 },
    'photometricinterpretation' => { 18 => 0x106, 53 => 'PhotometricInterpretation' },
    'photoshopformat' => { 46 => 0x1 },
    'photoshopquality' => { 46 => 0x0 },
    'photoshopsettings' => { 18 => 0x8649 },
    'photoshopthumbnail' => { 47 => 0x40c },
    'pictinfo' => { 43 => 0x208, 49 => 0x208 },
    'picturemode' => { 19 => 0x1031, 45 => 0xb },
    'pixelscale' => { 18 => 0x830e },
    'planarconfiguration' => { 18 => 0x11c, 53 => 'PlanarConfiguration' },
    'postscript2crd0' => { 25 => 'psd0' },
    'postscript2crd1' => { 25 => 'psd1' },
    'postscript2crd2' => { 25 => 'psd2' },
    'postscript2csa' => { 25 => 'ps2s' },
    'predictor' => { 18 => 0x13d },
    'preview0' => { 25 => 'pre0' },
    'preview1' => { 25 => 'pre1' },
    'preview2' => { 25 => 'pre2' },
    'previewfocalplanexresolution' => { 4 => 0x6 },
    'previewfocalplaneyresolution' => { 4 => 0x8 },
    'previewifd_offset' => { 41 => 0x2 },
    'previewimage' => { 17 => 0x2000, 54 => 'PreviewImage', 55 => 'PreviewImage' },
    'previewimagedata' => { 36 => 0x81 },
    'previewimageheight' => { 4 => 0x4 },
    'previewimageinfo' => { 2 => 0xb6 },
    'previewimagelength' => { 4 => 0x2, 18 => 0x202, 36 => 0x89, 42 => 0x202, 45 => 0x3 },
    'previewimagesize' => { 17 => 0x2, 45 => 0x2, 54 => 'PreviewImageSize' },
    'previewimagestart' => { 4 => 0x5, 18 => 0x201, 36 => 0x88, 42 => 0x201, 45 => 0x4 },
    'previewimagewidth' => { 4 => 0x3 },
    'primarychromaticities' => { 18 => 0x13f, 53 => 'PrimaryChromaticities' },
    'primaryplatform' => { 24 => 0x28 },
    'printim' => { 17 => 0xe00, 18 => 0xc4a5, 36 => 0xe00, 40 => 0xe00, 44 => 0xe00, 45 => 0xe00, 49 => 0xe00, 51 => 0xe00, 52 => 0xe00 },
    'processgeotiffdirectory' => { 54 => 'ProcessGeoTiffDirectory' },
    'producer' => { 53 => 'Producer' },
    'productid' => { 29 => 0x32 },
    'profileclass' => { 24 => 0xc },
    'profilecmmtype' => { 24 => 0x4 },
    'profileconnectionspace' => { 24 => [0x14,0x44] },
    'profilecreator' => { 24 => 0x50 },
    'profiledatetime' => { 24 => 0x18 },
    'profiledescription' => { 25 => 'desc' },
    'profiledescriptionml' => { 25 => 'dscm' },
    'profilefilesignature' => { 24 => 0x24 },
    'profileheader' => { 25 => 'Header' },
    'profileid' => { 24 => 0x54 },
    'profilesequencedesc' => { 25 => 'pseq' },
    'profiletype' => { 18 => 0x191 },
    'profileversion' => { 24 => 0x8 },
    'programversion' => { 28 => 0x46 },
    'progressivescans' => { 46 => 0x2 },
    'projazimuthangle' => { 21 => 0xc16 },
    'projcentereasting' => { 21 => 0xc12 },
    'projcenterlat' => { 21 => 0xc11 },
    'projcenterlong' => { 21 => 0xc10 },
    'projcenternorthing' => { 21 => 0xc13 },
    'projcoordtrans' => { 21 => 0xc03 },
    'projectedcstype' => { 21 => 0xc00 },
    'projection' => { 21 => 0xc02 },
    'projfalseeasting' => { 21 => 0xc0a },
    'projfalsenorthing' => { 21 => 0xc0b },
    'projfalseorigineasting' => { 21 => 0xc0e },
    'projfalseoriginlat' => { 21 => 0xc0d },
    'projfalseoriginlong' => { 21 => 0xc0c },
    'projfalseoriginnorthing' => { 21 => 0xc0f },
    'projlinearunits' => { 21 => 0xc04 },
    'projlinearunitsize' => { 21 => 0xc05 },
    'projnatoriginlat' => { 21 => 0xc09 },
    'projnatoriginlong' => { 21 => 0xc08 },
    'projrectifiedgridangle' => { 21 => 0xc18 },
    'projscaleatcenter' => { 21 => 0xc15 },
    'projscaleatnatorigin' => { 21 => 0xc14 },
    'projstdparallel1' => { 21 => 0xc06 },
    'projstdparallel2' => { 21 => 0xc07 },
    'projstraightvertpolelong' => { 21 => 0xc17 },
    'province-state' => { 28 => 0x5f },
    'ps2crdvmsize' => { 25 => 'psvm' },
    'ps2renteringintent' => { 25 => 'ps2i' },
    'publisher' => { 53 => 'Publisher' },
    'quality' => { 0 => 0x3, 16 => 0x2, 17 => 0x3002, 19 => 0x1000, 40 => 0x4, 43 => 0x201, 45 => 0x8, 50 => 0x16 },
    'qualitymode' => { 17 => 0x8 },
    'quantizationmethod' => { 31 => 0x78 },
    'quickshot' => { 49 => 0x213 },
    'rasterizedcaption' => { 28 => 0x7d },
    'rawandjpgrecording' => { 7 => 0x8 },
    'rawdata' => { 12 => 0x2005 },
    'rawfilename' => { 53 => 'RawFileName' },
    'rawimagesize' => { 12 => 0x1031, 45 => 0x39 },
    'recordingmode' => { 16 => 0x1 },
    'recordmode' => { 17 => 0x3000 },
    'recordshutterrelease' => { 49 => 0x217 },
    'redbalance' => { 37 => 0x0, 38 => 0x0, 39 => 0x0, 43 => 0x1017 },
    'redbalanceauto' => { 15 => 0x0 },
    'redbalanceb&w' => { 15 => 0xe },
    'redbalancecloudy' => { 15 => 0x4 },
    'redbalancecustom' => { 15 => 0xc },
    'redbalancedaylight' => { 15 => 0x2 },
    'redbalanceflash' => { 15 => 0xa },
    'redbalancefluorescent' => { 15 => 0x8 },
    'redbalanceshade' => { 15 => 0x10 },
    'redbalancetungsten' => { 15 => 0x6 },
    'redeyereduction' => { 54 => 'RedEyeReduction' },
    'redhue' => { 53 => 'RedHue' },
    'redmatrixcolumn' => { 25 => 'rXYZ' },
    'redsaturation' => { 53 => 'RedSaturation' },
    'redtrc' => { 25 => 'rTRC' },
    'reductionmatrix1' => { 18 => 0xc625 },
    'reductionmatrix2' => { 18 => 0xc626 },
    'referenceblackwhite' => { 18 => 0x214, 53 => 'ReferenceBlackWhite' },
    'referencedate' => { 28 => 0x2f },
    'referencenumber' => { 28 => 0x32 },
    'referenceservice' => { 28 => 0x2d },
    'relatedimagefileformat' => { 18 => 0x1000 },
    'relatedimagelength' => { 18 => 0x1002 },
    'relatedimagewidth' => { 18 => 0x1001 },
    'relatedsoundfile' => { 18 => 0xa004, 53 => 'RelatedSoundFile' },
    'relation' => { 53 => 'Relation' },
    'releasedate' => { 28 => 0x1e },
    'releasetime' => { 28 => 0x23 },
    'renderingintent' => { 24 => 0x40 },
    'renditionclass' => { 53 => 'RenditionClass' },
    'renditionof' => { 53 => 'RenditionOf' },
    'renditionofdocumentid' => { 53 => 'RenditionOfDocumentID' },
    'renditionofinstanceid' => { 53 => 'RenditionOfInstanceID' },
    'renditionofmanager' => { 53 => 'RenditionOfManager' },
    'renditionofmanagervariant' => { 53 => 'RenditionOfManagerVariant' },
    'renditionofmanageto' => { 53 => 'RenditionOfManageTo' },
    'renditionofmanageui' => { 53 => 'RenditionOfManageUI' },
    'renditionofrenditionclass' => { 53 => 'RenditionOfRenditionClass' },
    'renditionofrenditionparams' => { 53 => 'RenditionOfRenditionParams' },
    'renditionofversionid' => { 53 => 'RenditionOfVersionID' },
    'renditionparams' => { 53 => 'RenditionParams' },
    'resaved' => { 49 => 0x21e },
    'resolutionmode' => { 50 => 0x4 },
    'resolutionunit' => { 18 => 0x128, 42 => 0x128, 53 => 'ResolutionUnit' },
    'rights' => { 53 => 'Rights' },
    'rotation' => { 14 => 0x6 },
    'rowsperstrip' => { 18 => 0x116 },
    'safetyshiftinavortv' => { 7 => 0x10, 8 => 0x10, 9 => 0xf },
    'sampleformat' => { 18 => 0x153 },
    'samplesperpixel' => { 18 => 0x115, 53 => 'SamplesPerPixel' },
    'samplestructure' => { 31 => 0x5a },
    'sanyoquality' => { 49 => 0x201 },
    'sanyothumbnail' => { 49 => 0x100 },
    'saturation' => { 0 => 0xe, 16 => 0xd, 17 => 0x1f, 18 => 0xa409, 19 => 0x1003, 35 => 0x1f, 40 => [0x94,0xaa], 45 => 0x1f, 50 => 0x10, 53 => 'Saturation' },
    'saveid' => { 53 => 'SaveID' },
    'scalefactor35efl' => { 54 => 'ScaleFactor35efl' },
    'scanningdirection' => { 31 => 0x64 },
    'scenecapturetype' => { 18 => 0xa406, 53 => 'SceneCaptureType' },
    'scenemode' => { 40 => 0x8f },
    'sceneselect' => { 49 => 0x21f },
    'scenetype' => { 18 => 0xa301, 53 => 'SceneType' },
    'screening' => { 25 => 'scrn' },
    'screeningdesc' => { 25 => 'scrd' },
    'securityclassification' => { 18 => [0x9212,0xa212] },
    'self-timer' => { 0 => 0x2 },
    'self-timer2' => { 5 => 0x1d },
    'selftimer' => { 17 => 0x3001, 49 => 0x214 },
    'selftimermode' => { 18 => 0x882b },
    'sensingmethod' => { 18 => [0x9217,0xa217], 53 => 'SensingMethod' },
    'sensorcleaning' => { 6 => 0xd },
    'sequencenumber' => { 5 => 0x9 },
    'sequenceshotinterval' => { 49 => 0x224 },
    'sequentialshot' => { 49 => 0x20e },
    'serialnumber' => { 2 => 0xc, 12 => 0x580b, 40 => 0xa0, 44 => 0x25, 50 => 0x2, 53 => 'SerialNumber' },
    'serviceidentifier' => { 29 => 0x1e },
    'setbuttonfunction' => { 6 => 0xc, 7 => 0x1 },
    'setfunctionwhenshooting' => { 9 => 0x0 },
    'shadow' => { 50 => 0xe },
    'shadows' => { 53 => 'Shadows' },
    'shadowscale' => { 18 => 0xc633 },
    'shadowtint' => { 53 => 'ShadowTint' },
    'sharpness' => { 0 => 0xf, 16 => 0xb, 17 => 0x21, 18 => 0xa40a, 19 => 0x1001, 35 => 0x21, 40 => 0x6, 45 => 0x21, 50 => 0x11, 53 => 'Sharpness' },
    'shootingmode' => { 40 => 0x89, 44 => 0x1f, 54 => 'ShootingMode' },
    'shortfocal' => { 0 => 0x18 },
    'shutter-aelock' => { 6 => 0x2, 7 => 0x4, 9 => 0x3 },
    'shutteraelbutton' => { 8 => 0x4 },
    'shuttercount' => { 40 => 0xa7 },
    'shuttercurtainhack' => { 54 => 'ShutterCurtainHack' },
    'shuttercurtainsync' => { 6 => 0x8, 7 => 0xf, 8 => 0xf, 9 => 0xe },
    'shutterreleasenocfcard' => { 6 => 0xf, 7 => 0x2, 8 => 0x2 },
    'shutterspeed' => { 54 => 'ShutterSpeed' },
    'shutterspeedvalue' => { 18 => 0x9201, 53 => 'ShutterSpeedValue' },
    'sizemode' => { 34 => 0xa },
    'slowsync' => { 19 => 0x1030 },
    'smaxsamplevalue' => { 18 => 0x155 },
    'sminsamplevalue' => { 18 => 0x154 },
    'software' => { 18 => 0x131, 50 => 0x18, 53 => 'Software' },
    'softwarerelease' => { 43 => 0x207 },
    'softwareversion' => { 49 => 0x207 },
    'source' => { 28 => 0x73, 53 => 'Source' },
    'spatialfrequencyresponse' => { 18 => [0x920c,0xa20c], 53 => 'SpatialFrequencyResponse' },
    'spatialfrequencyresponsecolumns' => { 53 => 'SpatialFrequencyResponseColumns' },
    'spatialfrequencyresponsenames' => { 53 => 'SpatialFrequencyResponseNames' },
    'spatialfrequencyresponserows' => { 53 => 'SpatialFrequencyResponseRows' },
    'spatialfrequencyresponsevalues' => { 53 => 'SpatialFrequencyResponseValues' },
    'specialinstructions' => { 28 => 0x28 },
    'specialmode' => { 43 => 0x200, 49 => 0x200 },
    'spectralsensitivity' => { 18 => 0x8824, 53 => 'SpectralSensitivity' },
    'spotfocuspointx' => { 35 => 0x2d },
    'spotfocuspointy' => { 35 => 0x2e },
    'spotmode' => { 44 => 0xf },
    'state' => { 53 => 'State' },
    'stripbytecounts' => { 18 => 0x117 },
    'stripoffsets' => { 18 => 0x111 },
    'striprowcounts' => { 18 => 0x22f },
    'sub-location' => { 28 => 0x5c },
    'subfile' => { 32 => 0xa },
    'subfiletype' => { 18 => 0xfe },
    'subifd' => { 18 => 0x14a },
    'subifd_offset' => { 41 => 0x3 },
    'subject' => { 53 => 'Subject' },
    'subjectarea' => { 53 => 'SubjectArea' },
    'subjectdistance' => { 18 => 0x9206, 53 => 'SubjectDistance' },
    'subjectdistancerange' => { 18 => 0xa40c, 53 => 'SubjectDistanceRange' },
    'subjectlocation' => { 18 => [0x9214,0xa214], 53 => 'SubjectLocation' },
    'subjectprogram' => { 35 => 0x22 },
    'subjectreference' => { 28 => 0xc },
    'subsectime' => { 18 => 0x9290 },
    'subsectimedigitized' => { 18 => 0x9292 },
    'subsectimeoriginal' => { 18 => 0x9291 },
    'superimposeddisplay' => { 6 => 0xe, 7 => 0xa, 9 => 0x9 },
    'supplementalcategories' => { 28 => 0x14, 53 => 'SupplementalCategories' },
    'supplementaltype' => { 31 => 0x37 },
    'switchtoregisteredafpoint' => { 8 => 0x12 },
    't4options' => { 18 => 0x124 },
    't6options' => { 18 => 0x125 },
    'targetprinter' => { 18 => 0x151 },
    'technology' => { 25 => 'tech' },
    'thresholding' => { 18 => 0x107 },
    'thumbnailfilename' => { 12 => 0x817 },
    'thumbnailimage' => { 54 => 'ThumbnailImage' },
    'thumbnaillength' => { 18 => 0x202 },
    'thumbnailoffset' => { 18 => 0x201 },
    'thumbnails' => { 53 => 'Thumbnails' },
    'thumbnailsformat' => { 53 => 'ThumbnailsFormat' },
    'thumbnailsheight' => { 53 => 'ThumbnailsHeight' },
    'thumbnailsimage' => { 53 => 'ThumbnailsImage' },
    'thumbnailswidth' => { 53 => 'ThumbnailsWidth' },
    'tiff-epstandardid' => { 18 => [0x9216,0xa216] },
    'tilebytecounts' => { 18 => 0x145 },
    'tilelength' => { 18 => 0x143 },
    'tileoffsets' => { 18 => 0x144 },
    'tilewidth' => { 18 => 0x142 },
    'timecreated' => { 28 => 0x3c },
    'timesent' => { 29 => 0x50 },
    'timezone' => { 17 => 0x3006 },
    'timezoneoffset' => { 18 => 0x882a },
    'title' => { 53 => 'Title' },
    'tonecomp' => { 40 => 0x81 },
    'transferfunction' => { 18 => 0x12d, 53 => 'TransferFunction' },
    'transferrange' => { 18 => 0x156 },
    'transmissionreference' => { 53 => 'TransmissionReference' },
    'type' => { 53 => 'Type' },
    'ucrbg' => { 25 => 'bfd ' },
    'uniquecameramodel' => { 18 => 0xc614 },
    'uniqueobjectname' => { 29 => 0x64 },
    'urgency' => { 28 => 0xa, 53 => 'Urgency' },
    'url' => { 47 => 0x40b },
    'usageterms' => { 53 => 'UsageTerms' },
    'usercomment' => { 18 => 0x9286, 53 => 'UserComment' },
    'usmlenselectronicmf' => { 8 => 0x7 },
    'variprogram' => { 40 => 0xab },
    'version' => { 19 => 0x0, 53 => 'Version' },
    'versionid' => { 53 => 'VersionID' },
    'versions' => { 53 => 'Versions' },
    'versionscomments' => { 53 => 'VersionsComments' },
    'versionsevent' => { 53 => 'VersionsEvent' },
    'versionseventaction' => { 53 => 'VersionsEventAction' },
    'versionseventinstanceid' => { 53 => 'VersionsEventInstanceID' },
    'versionseventparameters' => { 53 => 'VersionsEventParameters' },
    'versionseventsoftwareagent' => { 53 => 'VersionsEventSoftwareAgent' },
    'versionseventwhen' => { 53 => 'VersionsEventWhen' },
    'versionsmodifier' => { 53 => 'VersionsModifier' },
    'versionsmodifydate' => { 53 => 'VersionsModifyDate' },
    'versionsversion' => { 53 => 'VersionsVersion' },
    'versionyear' => { 18 => 0x194 },
    'verticalcitation' => { 21 => 0x1001 },
    'verticalcstype' => { 21 => 0x1000 },
    'verticaldatum' => { 21 => 0x1002 },
    'verticalunits' => { 21 => 0x1003 },
    'videocardgamma' => { 25 => 'vcgt' },
    'viewingconddesc' => { 25 => 'vued' },
    'viewingcondilluminant' => { 27 => 0x8 },
    'viewingcondilluminanttype' => { 27 => 0x20 },
    'viewingconditions' => { 25 => 'view' },
    'viewingcondsurround' => { 27 => 0x14 },
    'vignetteamount' => { 53 => 'VignetteAmount' },
    'vignettemidpoint' => { 53 => 'VignetteMidpoint' },
    'voicememo' => { 49 => 0x216 },
    'wangannotation' => { 18 => 0x80a4 },
    'warning' => { 55 => 'Warning' },
    'webstatement' => { 53 => 'WebStatement' },
    'whitebalance' => { 5 => 0x7, 16 => 0x7, 17 => [0x19,0x2012], 18 => 0xa403, 19 => 0x1002, 35 => 0x3, 40 => 0x5, 44 => 0x3, 45 => 0x19, 50 => 0x7, 53 => 'WhiteBalance' },
    'whitebalancebias' => { 17 => 0x2011, 44 => 0x23 },
    'whitebalancefinetune' => { 40 => 0xb },
    'whitebalancetable' => { 12 => 0x10a9 },
    'whitelevel' => { 18 => 0xc61d },
    'whitepoint' => { 18 => 0x13e, 53 => 'WhitePoint' },
    'widefocuszone' => { 35 => 0x2f },
    'widerange' => { 49 => 0x20f },
    'writer-editor' => { 28 => 0x7a },
    'x3filllight' => { 50 => 0x12 },
    'xclippathunits' => { 18 => 0x158 },
    'xpauthor' => { 18 => 0x9c9d },
    'xpcomment' => { 18 => 0x9c9c },
    'xpkeywords' => { 18 => 0x9c9e },
    'xposition' => { 18 => 0x11e },
    'xpsubject' => { 18 => 0x9c9f },
    'xptitle' => { 18 => 0x9c9b },
    'xresolution' => { 18 => 0x11a, 42 => 0x11a, 53 => 'XResolution' },
    'ycbcrcoefficients' => { 18 => 0x211, 53 => 'YCbCrCoefficients' },
    'ycbcrpositioning' => { 18 => 0x213, 42 => 0x213 },
    'ycbcrsubsampling' => { 18 => 0x212, 53 => 'YCbCrSubSampling' },
    'yclippathunits' => { 18 => 0x159 },
    'yposition' => { 18 => 0x11f },
    'yresolution' => { 18 => 0x11b, 42 => 0x11b, 53 => 'YResolution' },
    'zoomedresolution' => { 0 => 0x24 },
    'zoomedresolutionbase' => { 0 => 0x25 },
);

#++++ End automatically generated code ++++


#------------------------------------------------------------------------------
# find information for tag (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList);
    my $lookup = $tagLookup{$lcTag};
    if ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $tagID = $$lookup{$tableNum};
            my @tagIDs;
            if (ref $tagID eq 'ARRAY') {
                @tagIDs = @$tagID;
            } else {
                push @tagIDs, $tagID;
            }
            foreach $tagID (@tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for all tag names

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2005, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool|Image::ExifTool>

=cut
