use v6.d;

# CompUnit::RepositoryRegistray is built-in,
# no need to "use" it.

sub EXPORT
(
    Bool()  :$resolve   = False,
    Bool()  :$verbose   = False
    --> Map
)
{
    use FileSystem::Parent;

    my %fixed   =
    (
        append      => 'lib',
        filter      => 'dir',
        skip-root   => True
    );

    my @found   
    = scan-up( :$resolve, :$verbose, |%fixed ).reverse;

    for @found 
    -> $dir
    {
        note "# Add: '$dir'"
        if $verbose;

        for CompUnit::Repository::FileSystem.new( prefix => $dir ) 
        -> $lib
        {
            CompUnit::RepositoryRegistry.use-repository($lib);
        }
    }

    # caller can look up what's there.

   %( '@FindBin-libs-installed-dirs' => @found )
}

unit module FindBin::libs:ver<0.1.0>:auth<CPAN:lembark>;
