use Test::More 'no_plan';
use Math::GSL qw/:all/;
use Math::GSL::Errno qw/:all/;
use Math::GSL::CDF qw/:all/;
use Math::GSL::Machine qw/:all/;
use Math::GSL::SF qw/:all/;
use Data::Dumper;
use strict;
use warnings;

BEGIN{ gsl_set_error_handler_off(); }

my $TOL0 = 2.0*$GSL_DBL_EPSILON;
my $TOL1 = 16.0*$GSL_DBL_EPSILON;
my $TOL2 = 256.0*$GSL_DBL_EPSILON;
my $TOL3 = 2048.0*$GSL_DBL_EPSILON;
my $TOL4 = 16384.0*$GSL_DBL_EPSILON;
my $TOL5 = 131072.0*$GSL_DBL_EPSILON;
my $TOL6 = 1048576.0*$GSL_DBL_EPSILON;

{
    my $results = { 
                    'gsl_cdf_ugaussian_P(2.0)'                      => [  0.977250, 1e-5 ],
                    'gsl_cdf_ugaussian_Q(2.0)'                      => [  0.022750, 1e-5 ],
                    'gsl_cdf_ugaussian_Pinv(0.977250)'              => [  2.000000, 1e-5 ],
                    'gsl_cdf_ugaussian_Qinv(0.022750)'              => [  2.000000, 1e-5 ],
                    'gsl_cdf_ugaussian_P (0.0)'	                    => [ 0.5, $TOL0 ],
                    'gsl_cdf_ugaussian_P (1e-32)'	                => [ 0.5, $TOL0 ],
                    'gsl_cdf_ugaussian_P (1e-16)'	                => [ 0.5000000000000000398942280401, $TOL0 ],
                    'gsl_cdf_ugaussian_P (1e-8)'	                => [ 0.5000000039894228040143267129, $TOL0 ],
                    'gsl_cdf_ugaussian_P (0.5)'	                    => [ 0.6914624612740131036377046105, $TOL0 ],
                    'gsl_cdf_ugaussian_P (0.7)'	                    => [ 0.7580363477769269852506495717, $TOL0 ],
                    'gsl_cdf_ugaussian_P (5.0)'	                    => [ 0.9999997133484281208060883262, $TOL0 ],
                    'gsl_cdf_ugaussian_P (10.0)'	                => [ 0.9999999999999999999999923801, $TOL0 ],
                    'gsl_cdf_ugaussian_P (30.0)'	                => [ 1.000000000000000000000000000, $TOL0 ],
                    'gsl_cdf_ugaussian_P (40.0)'	                => [ 1.000000000000000000000000000, $TOL0 ],
                    'gsl_cdf_ugaussian_P (1e10)'	                => [ 1.000000000000000000000000000, $TOL0 ],
                    'gsl_cdf_ugaussian_P (-1e-32)'	                => [ 0.5, $TOL6 ],
                    'gsl_cdf_ugaussian_P (-1e-16)'	                => [ 0.4999999999999999601057719598, $TOL0 ],
                    'gsl_cdf_ugaussian_P (-1e-8)'	                => [ 0.4999999960105771959856732870, $TOL0 ],
                    'gsl_cdf_ugaussian_P (-0.5)'	                => [ 0.3085375387259868963622953894, $TOL0 ],
                    'gsl_cdf_ugaussian_P (-0.7)'	                => [ 0.2419636522230730147493504282, $TOL0 ],
                    'gsl_cdf_ugaussian_P (-5.0)'	                => [ 0.0000002866515718791939116737523329, $TOL1 ],
                    'gsl_cdf_ugaussian_P (-10.0)'	                => [ 7.619853024160526065973343257e-24, $TOL3 ],
                    'gsl_cdf_ugaussian_P (-30.0)'	                => [ 4.906713927148187059533809288e-198, $TOL3 ],
                    'gsl_cdf_ugaussian_P (-1e10)'	                => [ 0.0, 0.0 ],
                    'gsl_cdf_ugaussian_Q (0.0)'	                    => [ 0.5, $TOL0 ],
                    'gsl_cdf_ugaussian_Q (1e-32)'	                => [ 0.5, $TOL0 ],
                    'gsl_cdf_ugaussian_Q (1e-16)'	                => [ 0.4999999999999999601057719598, $TOL0 ],
                    'gsl_cdf_ugaussian_Q (1e-8)'	                => [ 0.4999999960105771959856732870, $TOL0 ],
                    'gsl_cdf_ugaussian_Q (0.5)'	                    => [ 0.3085375387259868963622953894, $TOL0 ],
                    'gsl_cdf_ugaussian_Q (0.7)'	                    => [ 0.2419636522230730147493504282, $TOL0 ],
                    'gsl_cdf_ugaussian_Q (5.0)'	                    => [ 0.0000002866515718791939116737523329, $TOL3 ],
                    'gsl_cdf_ugaussian_Q (10.0)'	                => [ 7.619853024160526065973343257e-24, $TOL3 ],
                    'gsl_cdf_ugaussian_Q (30.0)'	                => [ 4.906713927148187059533809288e-198, $TOL3 ],
                    'gsl_cdf_ugaussian_Q (1e10)'	                => [ 0.0, 0.0 ],
                    'gsl_cdf_ugaussian_Q (-1e-32)'	                => [ 0.5, $TOL0 ],
                    'gsl_cdf_ugaussian_Q (-1e-16)'	                => [ 0.5000000000000000398942280401, $TOL0 ],
                    'gsl_cdf_ugaussian_Q (-1e-8)'	                => [ 0.5000000039894228040143267129, $TOL0 ],
                    'gsl_cdf_ugaussian_Q (-0.5)'	                => [ 0.6914624612740131036377046105, $TOL0 ],
                    'gsl_cdf_ugaussian_Q (-0.7)'	                => [ 0.7580363477769269852506495717, $TOL0 ],
                    'gsl_cdf_ugaussian_Q (-5.0)'	                => [ 0.9999997133484281208060883262, $TOL0 ],
                    'gsl_cdf_ugaussian_Q (-10.0)'	                => [ 0.9999999999999999999999923801, $TOL0 ],
                    'gsl_cdf_ugaussian_Q (-30.0)'	                => [ 1.000000000000000000000000000,  $TOL0 ],
                    'gsl_cdf_ugaussian_Q (-40.0)'	                => [ 1.000000000000000000000000000,  $TOL0 ],
                    'gsl_cdf_ugaussian_Q (-1e10)'	                => [ 1.000000000000000000000000000,  $TOL0 ],
                    'gsl_cdf_ugaussian_Pinv (0.9999997133)'	        => [ 5.0, 1e-4 ],
                    'gsl_cdf_ugaussian_Pinv (0.9999683288)'	        => [ 4.0, 1e-6 ],
                    'gsl_cdf_ugaussian_Pinv (0.9986501020)'	        => [ 3.0, 1e-8 ],
                    'gsl_cdf_ugaussian_Pinv (0.977249868051821)'	=> [ 2.0, 1e-14 ],
                    'gsl_cdf_ugaussian_Pinv (0.841344746068543)'	=> [ 1.0, $TOL3 ],
                    'gsl_cdf_ugaussian_Pinv (0.617911422188953)'	=> [ 0.3, $TOL1 ],
                    'gsl_cdf_ugaussian_Pinv (0.579259709439103)'	=> [ 0.2, $TOL1 ],
                    'gsl_cdf_ugaussian_Pinv (0.539827837277029)'	=> [ 0.1, $TOL1 ],
                    'gsl_cdf_ugaussian_Pinv (0.5)'	                => [ 0.0, 0.0 ],
                    'gsl_cdf_ugaussian_Pinv (4.60172162722971e-1)'	=> [ -0.1, $TOL1 ],
                    'gsl_cdf_ugaussian_Pinv (4.20740290560897e-1)'	=> [ -0.2, $TOL1 ],
                    'gsl_cdf_ugaussian_Pinv (3.82088577811047e-1)'	=> [ -0.3, $TOL1 ],
                    'gsl_cdf_ugaussian_Pinv (3.44578258389676e-1)'	=> [ -0.4, $TOL1 ],
                    'gsl_cdf_ugaussian_Pinv (3.08537538725987e-1)'	=> [ -0.5, $TOL2 ],
                    'gsl_cdf_ugaussian_Pinv (1.58655253931457e-1)'	=> [ -1.0, $TOL3 ],
                    'gsl_cdf_ugaussian_Pinv (2.2750131948179e-2)'	=> [ -2.0, 1e-14 ],
                    'gsl_cdf_ugaussian_Pinv (1.349898e-3)'	        => [ -3.0, 1e-8 ],
                    'gsl_cdf_ugaussian_Pinv (3.16712e-5)'	        => [ -4.0, 1e-6 ],
                    'gsl_cdf_ugaussian_Pinv (2.86648e-7)'	        => [ -5.0, 1e-4 ],
                    'gsl_cdf_ugaussian_Pinv (7.61985302416052e-24)'	=> [ -10.0, 1e-4 ],
                    'gsl_cdf_ugaussian_Qinv (7.61985302416052e-24)'	=> [ 10.0, 1e-4 ],
                    'gsl_cdf_ugaussian_Qinv (2.86648e-7)'	        => [ 5.0, 1e-4 ],
                    'gsl_cdf_ugaussian_Qinv (3.16712e-5)'	        => [ 4.0, 1e-6 ],
                    'gsl_cdf_ugaussian_Qinv (1.349898e-3)'	        => [ 3.0, 1e-8 ],
                    'gsl_cdf_ugaussian_Qinv (2.2750131948179e-2)'	=> [ 2.0, 1e-14 ],
                    'gsl_cdf_ugaussian_Qinv (1.58655253931457e-1)'	=> [ 1.0, $TOL3 ],
                    'gsl_cdf_ugaussian_Qinv (3.08537538725987e-1)'	=> [ 0.5, $TOL2 ],
                    'gsl_cdf_ugaussian_Qinv (3.44578258389676e-1)'	=> [ 0.4, $TOL1 ],
                    'gsl_cdf_ugaussian_Qinv (3.82088577811047e-1)'	=> [ 0.3, $TOL1 ],
                    'gsl_cdf_ugaussian_Qinv (4.20740290560897e-1)'	=> [ 0.2, $TOL1 ],
                    'gsl_cdf_ugaussian_Qinv (4.60172162722971e-1)'	=> [ 0.1, $TOL1 ],
                    'gsl_cdf_ugaussian_Qinv (0.5)'	                => [ 0.0, 0.0 ],
                    'gsl_cdf_ugaussian_Qinv (0.539827837277029)'	=> [ -0.1, $TOL1 ],
                    'gsl_cdf_ugaussian_Qinv (0.579259709439103)'	=> [ -0.2, $TOL1 ],
                    'gsl_cdf_ugaussian_Qinv (0.617911422188953)'	=> [ -0.3, $TOL1 ],
                    'gsl_cdf_ugaussian_Qinv (0.655421741610324)'	=> [ -0.4, $TOL1 ],
                    'gsl_cdf_ugaussian_Qinv (0.691462461274013)'	=> [ -0.5, $TOL2 ],
                    'gsl_cdf_ugaussian_Qinv (0.841344746068543)'	=> [ -1.0, $TOL3 ],
                    'gsl_cdf_ugaussian_Qinv (0.977249868051821)'	=> [ -2.0, 1e-14 ],
                    'gsl_cdf_ugaussian_Qinv (0.9986501020)'	        => [ -3.0, 1e-8 ],
                    'gsl_cdf_ugaussian_Qinv (0.9999683288)'	        => [ -4.0, 1e-6 ],
                    'gsl_cdf_ugaussian_Qinv (0.9999997133)'	        => [ -5.0, 1e-4 ],
                    'gsl_cdf_exponential_P (0.1, 0.7)'	            => [ 1.33122100249818372e-1, $TOL0 ],
                    'gsl_cdf_exponential_P (1e-32, 0.7)'	        => [ 1.42857142857142857e-32, $TOL0 ],
                    'gsl_cdf_exponential_P (1000.0, 0.7)'	        => [ 1.0, $TOL6 ],
                    'gsl_cdf_exponential_Q (0.1, 0.7)'	            => [ 8.66877899750181628e-1, $TOL0 ],
                    'gsl_cdf_exponential_Q (1e-32, 0.7)'	        => [ 1.0, $TOL0 ],
                    'gsl_cdf_exponential_Q (1000.0, 0.7)'	        => [ 0.0, $TOL6 ],
                    'gsl_cdf_exponential_Pinv (0.13, 0.7)'	        => [ 9.74834471334553546e-2, $TOL0 ],
                    'gsl_cdf_exponential_Pinv (1.42e-32, 0.7)'	    => [ 9.94000000000000000e-33, $TOL0 ],
                    'gsl_cdf_exponential_Qinv (0.86, 0.7)'	        => [ 1.05576022814208545e-1, $TOL0 ],
                    'gsl_cdf_exponential_Qinv (0.99999, 0.7)'	    => [ 7.00003500023333508e-6, $TOL6 ],
                    'gsl_cdf_exppow_P (-1000.0, 0.7, 1.8)'	        => [ 0.0, 0.0 ],
                    'gsl_cdf_exppow_P (-0.1, 0.7, 1.8)'	            => [ 0.4205349082867515493458053850, $TOL6 ],
                    'gsl_cdf_exppow_P (-1e-32, 0.7, 1.8)'	        => [ 0.4999999999999999999999999999, $TOL0 ],
                    'gsl_cdf_exppow_P (0.1, 0.7, 1.8)'	            => [ 0.5794650917132484506541946149, $TOL0 ],
                    'gsl_cdf_exppow_P (1e-32, 0.7, 1.8)'	        => [ 0.5, $TOL0 ],
                    'gsl_cdf_exppow_P (1000.0, 0.7, 1.8)'	        => [ 0.9999999999999999999999956212, $TOL6 ],
                    'gsl_cdf_exppow_Q (-1000.0, 0.7, 1.8)'	        => [ 0.9999999999999999999999956212, $TOL6 ],
                    'gsl_cdf_exppow_Q (-0.1, 0.7, 1.8)'	            => [ 0.5794650917132484506541946149, $TOL0 ],
                    'gsl_cdf_exppow_Q (-1e-32, 0.7, 1.8)'	        => [ 0.5, $TOL0 ],
                    'gsl_cdf_exppow_Q (0.1, 0.7, 1.8)'	            => [ 0.4205349082867515493458053850, $TOL0 ],
                    'gsl_cdf_exppow_Q (1e-32, 0.7, 1.8)'	        => [ 0.4999999999999999999999999999, $TOL0 ],
                    'gsl_cdf_exppow_Q (1000.0, 0.7, 1.8)'	        => [ 0.0, $TOL6 ],
                    'gsl_cdf_tdist_P (0.0, 1.0)'	=> [ 0.5, $TOL6 ],
                    'gsl_cdf_tdist_P (1e-100, 1.0)'	=> [ 0.5, $TOL6 ],
                    'gsl_cdf_tdist_P (0.001, 1.0)'	=> [ 5.00318309780080559e-1, $TOL6 ],
                    'gsl_cdf_tdist_P (0.01, 1.0)'	=> [ 5.03182992764908255e-1, $TOL6 ],
                    'gsl_cdf_tdist_P (0.1, 1.0)'	=> [ 5.31725517430553569e-1, $TOL6 ],
                    'gsl_cdf_tdist_P (0.325, 1.0)'	=> [ 6.00023120032852123e-1, $TOL6 ],
                    'gsl_cdf_tdist_P (1.0, 1.0)'	=> [ 0.75000000000000000e0, $TOL6 ],
                    'gsl_cdf_tdist_P (1.5, 1.0)'	=> [ 8.12832958189001183e-1, $TOL6 ],
                    'gsl_cdf_tdist_P (2.0, 1.0)'	=> [ 8.52416382349566726e-1, $TOL6 ],
                    'gsl_cdf_tdist_P (10.0, 1.0)'	=> [ 9.68274482569446430e-1, $TOL6 ],
                    'gsl_cdf_tdist_P (20.0, 1.0)'	=> [ 9.84097748743823625e-1, $TOL6 ],
                    'gsl_cdf_tdist_P (100.0, 1.0)'	=> [ 9.96817007235091745e-1, $TOL6 ],
                    'gsl_cdf_tdist_P (1000.0, 1.0)'	=> [ 9.99681690219919441e-1, $TOL6 ],
                    'gsl_cdf_tdist_P (10000.0, 1.0)'	=> [ 9.99968169011487724e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (0.0, 1.0)'	=> [ 0.5, $TOL6 ],
                    'gsl_cdf_tdist_Q (1e-100, 1.0)'	=> [ 0.5, $TOL6 ],
                    'gsl_cdf_tdist_Q (0.001, 1.0)'	=> [ 4.99681690219919441e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (0.01, 1.0)'	=> [ 4.96817007235091745e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (0.1, 1.0)'	=> [ 4.68274482569446430e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (0.325, 1.0)'	=> [ 3.99976879967147876e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (1.0, 1.0)'	=> [ 2.5e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (1.5, 1.0)'	=> [ 1.87167041810998816e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (2.0, 1.0)'	=> [ 1.47583617650433274e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (10.0, 1.0)'	=> [ 3.17255174305535695e-2, $TOL6 ],
                    'gsl_cdf_tdist_Q (20.0, 1.0)'	=> [ 1.59022512561763752e-2, $TOL6 ],
                    'gsl_cdf_tdist_Q (100.0, 1.0)'	=> [ 3.18299276490825515e-3, $TOL6 ],
                    'gsl_cdf_tdist_Q (1000.0, 1.0)'	=> [ 3.18309780080558939e-4, $TOL6 ],
                    'gsl_cdf_tdist_Q (10000.0, 1.0)'	=> [ 3.18309885122757724e-5, $TOL6 ],
                    'gsl_cdf_tdist_P (-1e-100, 1.0)'	=> [ 0.5, $TOL6 ],
                    'gsl_cdf_tdist_P (-0.001, 1.0)'	=> [ 4.99681690219919441e-1, $TOL6 ],
                    'gsl_cdf_tdist_P (-0.01, 1.0)'	=> [ 4.96817007235091744e-1, $TOL6 ],
                    'gsl_cdf_tdist_P (-0.1, 1.0)'	=> [ 4.68274482569446430e-1, $TOL6 ],
                    'gsl_cdf_tdist_P (-0.325, 1.0)'	=> [ 3.99976879967147876e-1, $TOL6 ],
                    'gsl_cdf_tdist_P (-1.0, 1.0)'	=> [ 0.25, $TOL6 ],
                    'gsl_cdf_tdist_P (-1.5, 1.0)'	=> [ 1.87167041810998816e-1, $TOL6 ],
                    'gsl_cdf_tdist_P (-2.0, 1.0)'	=> [ 1.47583617650433274e-1, $TOL6 ],
                    'gsl_cdf_tdist_P (-10.0, 1.0)'	=> [ 3.17255174305535695e-2, $TOL6 ],
                    'gsl_cdf_tdist_P (-20.0, 1.0)'	=> [ 1.59022512561763751e-2, $TOL6 ],
                    'gsl_cdf_tdist_P (-100.0, 1.0)'	=> [ 3.18299276490825514e-3, $TOL6 ],
                    'gsl_cdf_tdist_P (-1000.0, 1.0)'	=> [ 3.18309780080558938e-4, $TOL6 ],
                    'gsl_cdf_tdist_P (-10000.0, 1.0)'	=> [ 3.18309885122757724e-5, $TOL6 ],
                    'gsl_cdf_tdist_Q (-1e-100, 1.0)'	=> [ 0.5, $TOL6 ],
                    'gsl_cdf_tdist_Q (-0.001, 1.0)'	=> [ 5.00318309780080559e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (-0.01, 1.0)'	=> [ 5.03182992764908255e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (-0.1, 1.0)'	=> [ 5.31725517430553570e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (-0.325, 1.0)'	=> [ 6.00023120032852124e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (-1.0, 1.0)'	=> [ 7.5e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (-1.5, 1.0)'	=> [ 8.12832958189001184e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (-2.0, 1.0)'	=> [ 8.52416382349566726e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (-10.0, 1.0)'	=> [ 9.68274482569446430e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (-20.0, 1.0)'	=> [ 9.84097748743823625e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (-100.0, 1.0)'	=> [ 9.96817007235091745e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (-1000.0, 1.0)'	=> [ 9.99681690219919441e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (-10000.0, 1.0)'	=> [ 9.99968169011487724e-1, $TOL6 ],
                    'gsl_cdf_tdist_P (0.0, 2.0)'	=> [ 5.00000000000000000e-01, $TOL6 ],
                    'gsl_cdf_tdist_P (1e-100, 2.0)'	=> [ 5.00000000000000000e-01, $TOL6 ],
                    'gsl_cdf_tdist_P (0.001, 2.0)'	=> [ 5.00353553302204959e-01, $TOL6 ],
                    'gsl_cdf_tdist_P (0.01, 2.0)'	=> [ 5.03535445520899514e-01, $TOL6 ],
                    'gsl_cdf_tdist_P (0.1, 2.0)'	=> [ 5.35267280792929913e-01, $TOL6 ],
                    'gsl_cdf_tdist_P (0.325, 2.0)'	=> [ 6.11985772746873767e-01, $TOL6 ],
                    'gsl_cdf_tdist_P (1.0, 2.0)'	=> [ 7.88675134594812882e-01, $TOL6 ],
                    'gsl_cdf_tdist_P (1.5, 2.0)'	=> [ 8.63803437554499460e-01, $TOL6 ],
                    'gsl_cdf_tdist_P (2.0, 2.0)'	=> [ 9.08248290463863016e-01, $TOL6 ],
                    'gsl_cdf_tdist_P (10.0, 2.0)'	=> [ 9.95073771488337154e-01, $TOL6 ],
                    'gsl_cdf_tdist_P (20.0, 2.0)'	=> [ 9.98754668053816452e-01, $TOL6 ],
                    'gsl_cdf_tdist_P (100.0, 2.0)'	=> [ 9.99950007498750219e-01, $TOL6 ],
                    'gsl_cdf_tdist_P (1000.0, 2.0)'	=> [ 9.99999500000749945e-01, $TOL6 ],
                    'gsl_cdf_tdist_P (10000.0, 2.0)'	=> [ 9.999999950000000739e-01, $TOL6 ],
                    'gsl_cdf_tdist_Q (0.0, 2.0)'	=> [ 5.00000000000000000e-01, $TOL6 ],
                    'gsl_cdf_tdist_Q (1e-100, 2.0)'	=> [ 5.00000000000000000e-01, $TOL6 ],
                    'gsl_cdf_tdist_Q (0.001, 2.0)'	=> [ 4.99646446697795041e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (0.01, 2.0)'	=> [ 4.96464554479100486e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (0.1, 2.0)'	=> [ 4.64732719207070087e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (0.325, 2.0)'	=> [ 3.88014227253126233e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (1.0, 2.0)'	=> [ 2.11324865405187118e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (1.5, 2.0)'	=> [ 1.36196562445500540e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (2.0, 2.0)'	=> [ 9.17517095361369836e-2, $TOL6 ],
                    'gsl_cdf_tdist_Q (10.0, 2.0)'	=> [ 4.92622851166284542e-3, $TOL6 ],
                    'gsl_cdf_tdist_Q (20.0, 2.0)'	=> [ 1.24533194618354849e-3, $TOL6 ],
                    'gsl_cdf_tdist_Q (100.0, 2.0)'	=> [ 4.99925012497812894e-5, $TOL6 ],
                    'gsl_cdf_tdist_Q (1000.0, 2.0)'	=> [ 4.99999250001249998e-7, $TOL6 ],
                    'gsl_cdf_tdist_Q (10000.0, 2.0)'	=> [ 4.99999992500000125e-9, $TOL6 ],
                    'gsl_cdf_tdist_P (-1e-100, 2.0)'	=> [ 5.00000000000000000e-01, $TOL6 ],
                    'gsl_cdf_tdist_P (-0.001, 2.0)'	=> [ 4.99646446697795041e-01, $TOL6 ],
                    'gsl_cdf_tdist_P (-0.01, 2.0)'	=> [ 4.96464554479100486e-01, $TOL6 ],
                    'gsl_cdf_tdist_P (-0.1, 2.0)'	=> [ 4.64732719207070087e-01, $TOL6 ],
                    'gsl_cdf_tdist_P (-0.325, 2.0)'	=> [ 3.88014227253126233e-01, $TOL6 ],
                    'gsl_cdf_tdist_P (-1.0, 2.0)'	=> [ 2.11324865405187118e-01, $TOL6 ],
                    'gsl_cdf_tdist_P (-1.5, 2.0)'	=> [ 1.36196562445500540e-01, $TOL6 ],
                    'gsl_cdf_tdist_P (-2.0, 2.0)'	=> [ 9.17517095361369836e-02, $TOL6 ],
                    'gsl_cdf_tdist_P (-10.0, 2.0)'	=> [ 4.92622851166284542e-03, $TOL6 ],
                    'gsl_cdf_tdist_P (-20.0, 2.0)'	=> [ 1.24533194618354849e-03, $TOL6 ],
                    'gsl_cdf_tdist_P (-100.0, 2.0)'	=> [ 4.99925012497812894e-05, $TOL6 ],
                    'gsl_cdf_tdist_P (-1000.0, 2.0)'	=> [ 4.99999250001249998e-07, $TOL6 ],
                    'gsl_cdf_tdist_P (-10000.0, 2.0)'	=> [ 4.99999992500000125e-09, $TOL6 ],
                    'gsl_cdf_tdist_Q (-1e-100, 2.0)'	=> [ 5.00000000000000000e-01, $TOL6 ],
                    'gsl_cdf_tdist_Q (-0.001, 2.0)'	=> [ 5.00353553302204959e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (-0.01, 2.0)'	=> [ 5.03535445520899514e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (-0.1, 2.0)'	=> [ 5.35267280792929913e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (-0.325, 2.0)'	=> [ 6.11985772746873767e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (-1.0, 2.0)'	=> [ 7.88675134594812882e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (-1.5, 2.0)'	=> [ 8.63803437554499460e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (-2.0, 2.0)'	=> [ 9.08248290463863016e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (-10.0, 2.0)'	=> [ 9.95073771488337155e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (-20.0, 2.0)'	=> [ 9.98754668053816452e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (-100.0, 2.0)'	=> [ 9.99950007498750219e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (-1000.0, 2.0)'	=> [ 9.99999500000749999e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (-10000.0, 2.0)'	=> [ 9.99999995000000075e-1, $TOL6 ],
                    'gsl_cdf_tdist_P (0.0, 300.0)'	=> [ 5.00000000000000000e-01, $TOL6 ],
                    'gsl_cdf_tdist_P (1e-100, 300.0)'	=> [ 5.00000000000000000e-01, $TOL6 ],
                    'gsl_cdf_tdist_P (0.001, 300.0)'	=> [ 5.00398609900942949e-01, $TOL6 ],
                    'gsl_cdf_tdist_P (0.01, 300.0)'	=> [ 5.03986033020559088e-01, $TOL6 ],
                    'gsl_cdf_tdist_P (0.1, 300.0)'	=> [ 5.39794441177768194e-01, $TOL6 ],
                    'gsl_cdf_tdist_P (0.325, 300.0)'	=> [ 6.27296201542523812e-01, $TOL6 ],
                    'gsl_cdf_tdist_P (1.0, 300.0)'	=> [ 8.40941797784686861e-01, $TOL6 ],
                    'gsl_cdf_tdist_P (1.5, 300.0)'	=> [ 9.32666983425369137e-01, $TOL6 ],
                    'gsl_cdf_tdist_P (2.0, 300.0)'	=> [ 9.76799239508425455e-01, $TOL6 ],
                    'gsl_cdf_tdist_P (10.0, 300.0)'	=> [ 1.00000000000000000e+00, $TOL6 ],
                    'gsl_cdf_tdist_P (20.0, 300.0)'	=> [ 1.00000000000000000e+00, $TOL6 ],
                    'gsl_cdf_tdist_P (100.0, 300.0)'	=> [ 1.00000000000000000e+00, $TOL6 ],
                    'gsl_cdf_tdist_P (1000.0, 300.0)'	=> [ 1.00000000000000000e+00, $TOL6 ],
                    'gsl_cdf_tdist_P (10000.0, 300.0)'	=> [ 1.00000000000000000e+00, $TOL6 ],
                    'gsl_cdf_tdist_Q (0.0, 300.0)'	=> [ 5.00000000000000000e-01, $TOL6 ],
                    'gsl_cdf_tdist_Q (1e-100, 300.0)'	=> [ 5.00000000000000000e-01, $TOL6 ],
                    'gsl_cdf_tdist_Q (0.001, 300.0)'	=> [ 4.99601390099057051e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (0.01, 300.0)'	=> [ 4.96013966979440912e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (0.1, 300.0)'	=> [ 4.60205558822231806e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (0.325, 300.0)'	=> [ 3.72703798457476188e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (1.0, 300.0)'	=> [ 1.59058202215313138e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (1.5, 300.0)'	=> [ 6.73330165746308628e-2, $TOL6 ],
                    'gsl_cdf_tdist_Q (2.0, 300.0)'	=> [ 2.32007604915745452e-2, $TOL6 ],
                    'gsl_cdf_tdist_Q (10.0, 300.0)'	=> [ 8.279313677e-21, $TOL6 ],
                    'gsl_cdf_tdist_Q (20.0, 300.0)'	=> [ 1.93159812815803978e-57, $TOL6 ],
                    'gsl_cdf_tdist_Q (100.0, 300.0)'	=> [ 1.02557519997736154e-232, $TOL6 ],
                    'gsl_cdf_tdist_Q (1000.0, 300.0)'	=> [ 0.00000000000000000e+00, $TOL6 ],
                    'gsl_cdf_tdist_Q (10000.0, 300.0)'	=> [ 0.00000000000000000e+00, $TOL6 ],
                    'gsl_cdf_tdist_P (-1e-100, 300.0)'	=> [ 5.00000000000000000e-01, $TOL6 ],
                    'gsl_cdf_tdist_P (-0.001, 300.0)'	=> [ 4.99601390099057051e-01, $TOL6 ],
                    'gsl_cdf_tdist_P (-0.01, 300.0)'	=> [ 4.96013966979440912e-01, $TOL6 ],
                    'gsl_cdf_tdist_P (-0.1, 300.0)'	=> [ 4.60205558822231806e-01, $TOL6 ],
                    'gsl_cdf_tdist_P (-0.325, 300.0)'	=> [ 3.72703798457476188e-01, $TOL6 ],
                    'gsl_cdf_tdist_P (-1.0, 300.0)'	=> [ 1.59058202215313138e-01, $TOL6 ],
                    'gsl_cdf_tdist_P (-1.5, 300.0)'	=> [ 6.73330165746308628e-02, $TOL6 ],
                    'gsl_cdf_tdist_P (-2.0, 300.0)'	=> [ 2.32007604915745452e-02, $TOL6 ],
                    'gsl_cdf_tdist_P (-10.0, 300.0)'	=> [ 8.279313675556272534e-21, $TOL6 ],
                    'gsl_cdf_tdist_P (-20.0, 300.0)'	=> [ 1.93159812815803978e-57, $TOL6 ],
                    'gsl_cdf_tdist_P (-100.0, 300.0)'	=> [ 1.02557519997736154e-232, $TOL6 ],
                    'gsl_cdf_tdist_P (-1000.0, 300.0)'	=> [ 0.0, $TOL6 ],
                    'gsl_cdf_tdist_P (-10000.0, 300.0)'	=> [ 0.0, $TOL6 ],
                    'gsl_cdf_tdist_Q (-1e-100, 300.0)'	=> [ 5.00000000000000000e-01, $TOL6 ],
                    'gsl_cdf_tdist_Q (-0.001, 300.0)'	=> [ 5.00398609900942949e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (-0.01, 300.0)'	=> [ 5.03986033020559088e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (-0.1, 300.0)'	=> [ 5.39794441177768194e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (-0.325, 300.0)'	=> [ 6.27296201542523812e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (-1.0, 300.0)'	=> [ 8.40941797784686862e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (-1.5, 300.0)'	=> [ 9.32666983425369137e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (-2.0, 300.0)'	=> [ 9.76799239508425455e-1, $TOL6 ],
                    'gsl_cdf_tdist_Q (-10.0, 300.0)'	=> [ 1.000000000000000000e0, $TOL6 ],
                    'gsl_cdf_tdist_Q (-20.0, 300.0)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_tdist_Q (-100.0, 300.0)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_tdist_Q (-1000.0, 300.0)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_tdist_Q (-10000.0, 300.0)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_fdist_P (0.0, 1.2, 1.3)'	=> [ 0.0, $TOL6 ],
                    'gsl_cdf_fdist_P (1e-100, 1.2, 1.3)'	=> [ 6.98194275525039002e-61, $TOL6 ],
                    'gsl_cdf_fdist_P (0.001, 1.2, 1.3)'	=> [ 1.10608485860238564e-2, $TOL6 ],
                    'gsl_cdf_fdist_P (0.01, 1.2, 1.3)'	=> [ 4.38636757068313850e-2, $TOL6 ],
                    'gsl_cdf_fdist_P (0.1, 1.2, 1.3)'	=> [ 1.68242392712840734e-1, $TOL6 ],
                    'gsl_cdf_fdist_P (0.325, 1.2, 1.3)'	=> [ 3.14130045246195449e-1, $TOL6 ],
                    'gsl_cdf_fdist_P (1.0, 1.2, 1.3)'	=> [ 5.09630779074755253e-01, $TOL6 ],
                    'gsl_cdf_fdist_P (1.5, 1.2, 1.3)'	=> [ 5.83998640641553852e-1, $TOL6 ],
                    'gsl_cdf_fdist_P (2.0, 1.2, 1.3)'	=> [ 6.34733581351938787e-1, $TOL6 ],
                    'gsl_cdf_fdist_P (10.0, 1.2, 1.3)'	=> [ 8.48446237879200975e-1, $TOL6 ],
                    'gsl_cdf_fdist_P (20.0, 1.2, 1.3)'	=> [ 9.00987726336875039e-1, $TOL6 ],
                    'gsl_cdf_fdist_P (100.0, 1.2, 1.3)'	=> [ 9.64489127047688435e-1, $TOL6 ],
                    'gsl_cdf_fdist_P (1000.0, 1.2, 1.3)'	=> [ 9.92012051694116388e-1, $TOL6 ],
                    'gsl_cdf_fdist_P (10000.0, 1.2, 1.3)'	=> [ 9.98210862808842585e-1, $TOL6 ],
                    'gsl_cdf_fdist_Q (0.0, 1.2, 1.3)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_fdist_Q (1e-100, 1.2, 1.3)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_fdist_Q (0.001, 1.2, 1.3)'	=> [ 9.88939151413976144e-1, $TOL6 ],
                    'gsl_cdf_fdist_Q (0.01, 1.2, 1.3)'	=> [ 9.56136324293168615e-1, $TOL6 ],
                    'gsl_cdf_fdist_Q (0.1, 1.2, 1.3)'	=> [ 8.31757607287159265e-1, $TOL6 ],
                    'gsl_cdf_fdist_Q (0.325, 1.2, 1.3)'	=> [ 6.85869954753804551e-1, $TOL6 ],
                    'gsl_cdf_fdist_Q (1.0, 1.2, 1.3)'	=> [ 4.90369220925244747e-1, $TOL6 ],
                    'gsl_cdf_fdist_Q (1.5, 1.2, 1.3)'	=> [ 4.16001359358446148e-1, $TOL6 ],
                    'gsl_cdf_fdist_Q (2.0, 1.2, 1.3)'	=> [ 3.65266418648061213e-1, $TOL6 ],
                    'gsl_cdf_fdist_Q (10.0, 1.2, 1.3)'	=> [ 1.51553762120799025e-1, $TOL6 ],
                    'gsl_cdf_fdist_Q (20.0, 1.2, 1.3)'	=> [ 9.90122736631249612e-2, $TOL6 ],
                    'gsl_cdf_fdist_Q (100.0, 1.2, 1.3)'	=> [ 3.55108729523115643e-2, $TOL6 ],
                    'gsl_cdf_fdist_Q (1000.0, 1.2, 1.3)'	=> [ 7.98794830588361109e-3, $TOL6 ],
                    'gsl_cdf_fdist_Q (10000.0, 1.2, 1.3)'	=> [ 1.7891371911574145e-3, $TOL6 ],
                    'gsl_cdf_fdist_P (3.479082213465832574, 1, 4040712)'	=> [ 0.93785072763723411967, $TOL6 ],
                    'gsl_cdf_fdist_P (3.002774644786533109, 1, 4040712)'	=> [ 0.91687787379476055771, $TOL6 ],
                    'gsl_cdf_fdist_P (3.000854441173130827, 1, 4040712)'	=> [ 0.91677930719813578619, $TOL6 ],
                    'gsl_cdf_fdist_P (3.000064021622133037, 1, 4040712)'	=> [ 0.9167386972447996480399, $TOL6 ],
                    'gsl_cdf_fdist_P (0.0, 500.0, 1.3)'	=> [ 0.0, $TOL6 ],
                    'gsl_cdf_fdist_P (1e-100, 500.0, 1.3)'	=> [ 0.0, $TOL6 ],
                    'gsl_cdf_fdist_P (0.001, 500.0, 1.3)'	=> [ 9.83434460393304765e-141, $TOL6 ],
                    'gsl_cdf_fdist_P (0.01, 500.0, 1.3)'	=> [ 1.45915624888550014e-26, $TOL6 ],
                    'gsl_cdf_fdist_P (0.1, 500.0, 1.3)'	=> [ 5.89976509619688165e-4, $TOL6 ],
                    'gsl_cdf_fdist_P (0.325, 500.0, 1.3)'	=> [ 6.86110486051542533e-2, $TOL6 ],
                    'gsl_cdf_fdist_P (1.0, 500.0, 1.3)'	=> [ 3.38475053806404615e-1, $TOL6 ],
                    'gsl_cdf_fdist_P (1.5, 500.0, 1.3)'	=> [ 4.52016245247457422e-1, $TOL6 ],
                    'gsl_cdf_fdist_P (2.0, 500.0, 1.3)'	=> [ 5.27339068937388798e-1, $TOL6 ],
                    'gsl_cdf_fdist_P (10.0, 500.0, 1.3)'	=> [ 8.16839628578413905e-1, $TOL6 ],
                    'gsl_cdf_fdist_P (20.0, 500.0, 1.3)'	=> [ 8.81784623056911406e-1, $TOL6 ],
                    'gsl_cdf_fdist_P (100.0, 500.0, 1.3)'	=> [ 9.58045057204221295e-1, $TOL6 ],
                    'gsl_cdf_fdist_P (1000.0, 500.0, 1.3)'	=> [ 9.90585749380655275e-1, $TOL6 ],
                    'gsl_cdf_fdist_P (10000.0, 500.0, 1.3)'	=> [ 9.97891924831461387e-1, $TOL6 ],
                    'gsl_cdf_fdist_Q (0.0, 500.0, 1.3)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_fdist_Q (1e-100, 500.0, 1.3)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_fdist_Q (0.001, 500.0, 1.3)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_fdist_Q (0.01, 500.0, 1.3)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_fdist_Q (0.1, 500.0, 1.3)'	=> [ 9.99410023490380312e-1, $TOL6 ],
                    'gsl_cdf_fdist_Q (0.325, 500.0, 1.3)'	=> [ 9.31388951394845747e-1, $TOL6 ],
                    'gsl_cdf_fdist_Q (1.0, 500.0, 1.3)'	=> [ 6.61524946193595385e-1, $TOL6 ],
                    'gsl_cdf_fdist_Q (1.5, 500.0, 1.3)'	=> [ 5.47983754752542572e-1, $TOL6 ],
                    'gsl_cdf_fdist_Q (2.0, 500.0, 1.3)'	=> [ 4.72660931062611202e-1, $TOL6 ],
                    'gsl_cdf_fdist_Q (10.0, 500.0, 1.3)'	=> [ 1.83160371421586096e-1, $TOL6 ],
                    'gsl_cdf_fdist_Q (20.0, 500.0, 1.3)'	=> [ 1.18215376943088595e-1, $TOL6 ],
                    'gsl_cdf_fdist_Q (100.0, 500.0, 1.3)'	=> [ 4.19549427957787016e-2, $TOL6 ],
                    'gsl_cdf_fdist_Q (1000.0, 500.0, 1.3)'	=> [ 9.41425061934473424e-3, $TOL6 ],
                    'gsl_cdf_fdist_Q (10000.0, 500.0, 1.3)'	=> [ 2.10807516853862603e-3, $TOL6 ],
                    'gsl_cdf_fdist_P (0.0, 1.2, 500.0)'	=> [ 0.0, $TOL6 ],
                    'gsl_cdf_fdist_P (1e-100, 1.2, 500.0)'	=> [ 8.23342055585482999e-61, $TOL6 ],
                    'gsl_cdf_fdist_P (0.001, 1.2, 500.0)'	=> [ 1.30461496441289529e-2, $TOL6 ],
                    'gsl_cdf_fdist_P (0.01, 1.2, 500.0)'	=> [ 5.18324224608033294e-2, $TOL6 ],
                    'gsl_cdf_fdist_P (0.1, 1.2, 500.0)'	=> [ 2.02235101716076289e-1, $TOL6 ],
                    'gsl_cdf_fdist_P (0.325, 1.2, 500.0)'	=> [ 3.90502983219393749e-1, $TOL6 ],
                    'gsl_cdf_fdist_P (1.0, 1.2, 500.0)'	=> [ 6.67656191574653619e-1, $TOL6 ],
                    'gsl_cdf_fdist_P (1.5, 1.2, 500.0)'	=> [ 7.75539230271467054e-1, $TOL6 ],
                    'gsl_cdf_fdist_P (2.0, 1.2, 500.0)'	=> [ 8.45209114904613705e-1, $TOL6 ],
                    'gsl_cdf_fdist_P (10.0, 1.2, 500.0)'	=> [ 9.99168017659120988e-1, $TOL6 ],
                    'gsl_cdf_fdist_P (20.0, 1.2, 500.0)'	=> [ 9.99998005738371669e-1, $TOL6 ],
                    'gsl_cdf_fdist_P (100.0, 1.2, 500.0)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_fdist_P (1000.0, 1.2, 500.0)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_fdist_P (10000.0, 1.2, 500.0)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_fdist_Q (0.0, 1.2, 500.0)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_fdist_Q (1e-100, 1.2, 500.0)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_fdist_Q (0.001, 1.2, 500.0)'	=> [ 9.86953850355871047e-1, $TOL6 ],
                    'gsl_cdf_fdist_Q (0.01, 1.2, 500.0)'	=> [ 9.48167577539196671e-1, $TOL6 ],
                    'gsl_cdf_fdist_Q (0.1, 1.2, 500.0)'	=> [ 7.97764898283923711e-1, $TOL6 ],
                    'gsl_cdf_fdist_Q (0.325, 1.2, 500.0)'	=> [ 6.09497016780606251e-1, $TOL6 ],
                    'gsl_cdf_fdist_Q (1.0, 1.2, 500.0)'	=> [ 3.32343808425346381e-1, $TOL6 ],
                    'gsl_cdf_fdist_Q (1.5, 1.2, 500.0)'	=> [ 2.24460769728532946e-1, $TOL6 ],
                    'gsl_cdf_fdist_Q (2.0, 1.2, 500.0)'	=> [ 1.54790885095386295e-1, $TOL6 ],
                    'gsl_cdf_fdist_Q (10.0, 1.2, 500.0)'	=> [ 8.3198234087901168e-4, $TOL6 ],
                    'gsl_cdf_fdist_Q (20.0, 1.2, 500.0)'	=> [ 1.99426162833131e-6, $TOL6 ],
                    'gsl_cdf_fdist_Q (100.0, 1.2, 500.0)'	=> [ 6.23302662288217117e-25, $TOL6 ],
                    'gsl_cdf_fdist_Q (1000.0, 1.2, 500.0)'	=> [ 1.14328577259666930e-134, $TOL6 ],
                    'gsl_cdf_fdist_Q (10000.0, 1.2, 500.0)'	=> [ 0.0, $TOL6 ],
                    'gsl_cdf_fdist_P (0.0, 200.0, 500.0)'	=> [ 0.0, $TOL6 ],
                    'gsl_cdf_fdist_P (1e-100, 200.0, 500.0)'	=> [ 0.0, $TOL6 ],
                    'gsl_cdf_fdist_P (0.001, 200.0, 500.0)'	=> [ 4.09325080403669893e-251, $TOL6 ],
                    'gsl_cdf_fdist_P (0.01, 200.0, 500.0)'	=> [ 1.17894325419628688e-151, $TOL6 ],
                    'gsl_cdf_fdist_P (0.1, 200.0, 500.0)'	=> [ 5.92430940796861258e-57, $TOL6 ],
                    'gsl_cdf_fdist_P (0.325, 200.0, 500.0)'	=> [ 3.18220452357263554e-18, $TOL6 ],
                    'gsl_cdf_fdist_P (1.0, 200.0, 500.0)'	=> [ 5.06746326121168266e-1, $TOL6 ],
                    'gsl_cdf_fdist_P (1.5, 200.0, 500.0)'	=> [ 9.99794175718712438e-1, $TOL6 ],
                    'gsl_cdf_fdist_P (2.0, 200.0, 500.0)'	=> [ 9.99999999528236152e-1, $TOL6 ],
                    'gsl_cdf_fdist_P (10.0, 200.0, 500.0)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_fdist_P (20.0, 200.0, 500.0)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_fdist_P (100.0, 200.0, 500.0)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_fdist_P (1000.0, 200.0, 500.0)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_fdist_P (10000.0, 200.0, 500.0)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_fdist_Q (0.0, 200.0, 500.0)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_fdist_Q (1e-100, 200.0, 500.0)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_fdist_Q (0.001, 200.0, 500.0)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_fdist_Q (0.01, 200.0, 500.0)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_fdist_Q (0.1, 200.0, 500.0)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_fdist_Q (0.325, 200.0, 500.0)'	=> [ 9.99999999999999997e-1, $TOL6 ],
                    'gsl_cdf_fdist_Q (1.0, 200.0, 500.0)'	=> [ 4.93253673878831734e-1, $TOL6 ],
                    'gsl_cdf_fdist_Q (1.5, 200.0, 500.0)'	=> [ 2.05824281287561795e-4, $TOL6 ],
                    'gsl_cdf_fdist_Q (2.0, 200.0, 500.0)'	=> [ 4.71763848371410786e-10, $TOL6 ],
                    'gsl_cdf_fdist_Q (10.0, 200.0, 500.0)'	=> [ 5.98048337181948436e-96, $TOL6 ],
                    'gsl_cdf_fdist_Q (20.0, 200.0, 500.0)'	=> [ 2.92099265879979502e-155, $TOL6 ],
                    'gsl_cdf_fdist_Q (1000.0, 200.0, 500.0)'	=> [ 0.0, $TOL6 ],
                    'gsl_cdf_fdist_Q (10000.0, 200.0, 500.0)'	=> [ 0.0, $TOL6 ],
                    'gsl_cdf_fdist_Pinv (0.0, 1.2, 1.3)'	=> [ 0.0, $TOL6 ],
                    'gsl_cdf_fdist_Pinv ( 6.98194275525039002e-61, 1.2, 1.3)'	=> [ 1e-100, $TOL6 ],
                    'gsl_cdf_fdist_Pinv ( 1.10608485860238564e-2, 1.2, 1.3)'	=> [ 0.001, $TOL6 ],
                    'gsl_cdf_fdist_Pinv ( 4.38636757068313850e-2, 1.2, 1.3)'	=> [ 0.01, $TOL6 ],
                    'gsl_cdf_fdist_Pinv ( 1.68242392712840734e-1, 1.2, 1.3)'	=> [ 0.1, $TOL6 ],
                    'gsl_cdf_fdist_Pinv ( 3.14130045246195449e-1, 1.2, 1.3)'	=> [ 0.325, $TOL6 ],
                    'gsl_cdf_fdist_Pinv ( 5.09630779074755253e-01, 1.2, 1.3)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_fdist_Pinv ( 5.83998640641553852e-1, 1.2, 1.3)'	=> [ 1.5, $TOL6 ],
                    'gsl_cdf_fdist_Pinv ( 6.34733581351938787e-1, 1.2, 1.3)'	=> [ 2.0, $TOL6 ],
                    'gsl_cdf_fdist_Pinv ( 8.48446237879200975e-1, 1.2, 1.3)'	=> [ 10.0, $TOL6 ],
                    'gsl_cdf_fdist_Pinv ( 9.00987726336875039e-1, 1.2, 1.3)'	=> [ 20.0, $TOL6 ],
                    'gsl_cdf_fdist_Pinv ( 9.64489127047688435e-1, 1.2, 1.3)'	=> [ 100.0, $TOL6 ],
                    'gsl_cdf_fdist_Pinv ( 9.92012051694116388e-1, 1.2, 1.3)'	=> [ 1000.0, $TOL6 ],
                    'gsl_cdf_fdist_Pinv ( 9.98210862808842585e-1, 1.2, 1.3)'	=> [ 10000.0, 100*$TOL6 ],
                    'gsl_cdf_fdist_Qinv ( 1.0, 1.2, 1.3)'	                    => [ 0.0, $TOL6 ],
                    'gsl_cdf_fdist_Qinv ( 9.88939151413976144e-1, 1.2, 1.3)'	=> [ 0.001, $TOL6 ],
                    'gsl_cdf_fdist_Qinv ( 9.56136324293168615e-1, 1.2, 1.3)'	=> [ 0.01, $TOL6 ],
                    'gsl_cdf_fdist_Qinv ( 8.31757607287159265e-1, 1.2, 1.3)'	=> [ 0.1, $TOL6 ],
                    'gsl_cdf_fdist_Qinv ( 6.85869954753804551e-1, 1.2, 1.3)'	=> [ 0.325, $TOL6 ],
                    'gsl_cdf_fdist_Qinv ( 4.90369220925244747e-1, 1.2, 1.3)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_fdist_Qinv ( 4.16001359358446148e-1, 1.2, 1.3)'	=> [ 1.5, $TOL6 ],
                    'gsl_cdf_fdist_Qinv ( 3.65266418648061213e-1, 1.2, 1.3)'	=> [ 2.0, $TOL6 ],
                    'gsl_cdf_fdist_Qinv ( 1.51553762120799025e-1, 1.2, 1.3)'	=> [ 10.0, $TOL6 ],
                    'gsl_cdf_fdist_Qinv ( 9.90122736631249612e-2, 1.2, 1.3)'	=> [ 20.0, $TOL6 ],
                    'gsl_cdf_fdist_Qinv ( 3.55108729523115643e-2, 1.2, 1.3)'	=> [ 100.0, $TOL6 ],
                    'gsl_cdf_fdist_Qinv ( 7.98794830588361109e-3, 1.2, 1.3)'	=> [ 1000.0, $TOL6 ],
                    'gsl_cdf_fdist_Qinv ( 1.7891371911574145e-3, 1.2, 1.3)'	    => [ 10000.0, $TOL6 ],
                    'gsl_cdf_fdist_Pinv ( 0.0, 500.0, 1.3)'	                    => [ 0.0, $TOL6 ],
                    'gsl_cdf_fdist_Pinv ( 9.83434460393304765e-141, 500.0, 1.3)'=> [ 0.001, $TOL6 ],
                    'gsl_cdf_fdist_Pinv ( 1.45915624888550014e-26, 500.0, 1.3)'	=> [ 0.01, $TOL6 ],
                    'gsl_cdf_fdist_Pinv ( 5.89976509619688165e-4, 500.0, 1.3)'	=> [ 0.1, $TOL6 ],
                    'gsl_cdf_fdist_Pinv ( 6.86110486051542533e-2, 500.0, 1.3)'	=> [ 0.325, $TOL6 ],
                    'gsl_cdf_fdist_Pinv ( 3.38475053806404615e-1, 500.0, 1.3)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_fdist_Pinv ( 4.52016245247457422e-1, 500.0, 1.3)'	=> [ 1.5, $TOL6 ],
                    'gsl_cdf_fdist_Pinv ( 5.27339068937388798e-1, 500.0, 1.3)'	=> [ 2.0, $TOL6 ],
                    'gsl_cdf_fdist_Pinv ( 8.16839628578413905e-1, 500.0, 1.3)'	=> [ 10.0, $TOL6 ],
                    'gsl_cdf_fdist_Pinv ( 8.81784623056911406e-1, 500.0, 1.3)'	=> [ 20.0, $TOL6 ],
                    'gsl_cdf_fdist_Pinv ( 9.58045057204221295e-1, 500.0, 1.3)'	=> [ 100.0, $TOL6 ],
                    'gsl_cdf_fdist_Pinv ( 9.90585749380655275e-1, 500.0, 1.3)'	=> [ 1000.0, $TOL6 ],
                    'gsl_cdf_fdist_Pinv ( 9.97891924831461387e-1, 500.0, 1.3)'	=> [ 10000.0, $TOL6 ],
                    'gsl_cdf_fdist_Qinv ( 1.0, 500.0, 1.3)'	                    => [ 0.0, $TOL6 ],
                    'gsl_cdf_fdist_Qinv ( 9.99410023490380312e-1, 500.0, 1.3)'	=> [ 0.1, $TOL6 ],
                    'gsl_cdf_fdist_Qinv ( 9.31388951394845747e-1, 500.0, 1.3)'	=> [ 0.325, $TOL6 ],
                    'gsl_cdf_fdist_Qinv ( 6.61524946193595385e-1, 500.0, 1.3)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_fdist_Qinv ( 5.47983754752542572e-1, 500.0, 1.3)'	=> [ 1.5, $TOL6 ],
                    'gsl_cdf_fdist_Qinv ( 4.72660931062611202e-1, 500.0, 1.3)'	=> [ 2.0, $TOL6 ],
                    'gsl_cdf_fdist_Qinv ( 1.83160371421586096e-1, 500.0, 1.3)'	=> [ 10.0, $TOL6 ],
                    'gsl_cdf_fdist_Qinv ( 1.18215376943088595e-1, 500.0, 1.3)'	=> [ 20.0, $TOL6 ],
                    'gsl_cdf_fdist_Qinv ( 4.19549427957787016e-2, 500.0, 1.3)'	=> [ 100.0, $TOL6 ],
                    'gsl_cdf_fdist_Qinv ( 9.41425061934473424e-3, 500.0, 1.3)'	=> [ 1000.0, $TOL6 ],
                    'gsl_cdf_fdist_Qinv ( 2.10807516853862603e-3, 500.0, 1.3)'	=> [ 10000.0, $TOL6 ],
                    'gsl_cdf_fdist_Pinv ( 0.0, 1.2, 500.0)'	                    => [ 0.0, 0.0 ],
                    'gsl_cdf_fdist_Pinv ( 8.23342055585482999e-61, 1.2, 500.0)'	=> [ 1e-100, $TOL6 ],
                    'gsl_cdf_fdist_Pinv ( 1.30461496441289529e-2, 1.2, 500.0)'	=> [ 0.001, $TOL6 ],
                    'gsl_cdf_fdist_Pinv ( 5.18324224608033294e-2, 1.2, 500.0)'	=> [ 0.01, $TOL6 ],
                    'gsl_cdf_fdist_Pinv ( 2.02235101716076289e-1, 1.2, 500.0)'	=> [ 0.1, $TOL6 ],
                    'gsl_cdf_fdist_Pinv ( 3.90502983219393749e-1, 1.2, 500.0)'	=> [ 0.325, $TOL6 ],
                    'gsl_cdf_fdist_Pinv ( 6.67656191574653619e-1, 1.2, 500.0)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_fdist_Pinv ( 7.75539230271467054e-1, 1.2, 500.0)'	=> [ 1.5, $TOL6 ],
                    'gsl_cdf_fdist_Pinv ( 8.45209114904613705e-1, 1.2, 500.0)'	=> [ 2.0, $TOL6 ],
                    'gsl_cdf_fdist_Pinv ( 9.99168017659120988e-1, 1.2, 500.0)'	=> [ 10.0, $TOL6 ],
                    'gsl_cdf_fdist_Pinv ( 9.99998005738371669e-1, 1.2, 500.0)'	=> [ 20.0, $TOL6 ],
                    q{gsl_cdf_fdist_Pinv ( 1.0, 1.2, 500.0)}	=> [  q{inf}, $TOL6 ],
                    q{gsl_cdf_fdist_Pinv ( 1.0, 1.2, 500.0)}	=> [  q{inf}, $TOL6 ],
                    q{gsl_cdf_fdist_Pinv ( 1.0, 1.2, 500.0)}	=> [  q{inf}, $TOL6 ],
                    'gsl_cdf_fdist_Qinv ( 1.0, 1.2, 500.0)'	=> [ 0.0, $TOL6 ],
                    'gsl_cdf_fdist_Qinv ( 9.86953850355871047e-1, 1.2, 500.0)'	=> [ 0.001, $TOL6 ],
                    'gsl_cdf_fdist_Qinv ( 9.48167577539196671e-1, 1.2, 500.0)'	=> [ 0.01, $TOL6 ],
                    'gsl_cdf_fdist_Qinv ( 7.97764898283923711e-1, 1.2, 500.0)'	=> [ 0.1, $TOL6 ],
                    'gsl_cdf_fdist_Qinv ( 6.09497016780606251e-1, 1.2, 500.0)'	=> [ 0.325, $TOL6 ],
                    'gsl_cdf_fdist_Qinv ( 3.32343808425346381e-1, 1.2, 500.0)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_fdist_Qinv ( 2.24460769728532946e-1, 1.2, 500.0)'	=> [ 1.5, $TOL6 ],
                    'gsl_cdf_fdist_Qinv ( 1.54790885095386295e-1, 1.2, 500.0)'	=> [ 2.0, $TOL6 ],
                    'gsl_cdf_fdist_Qinv ( 8.3198234087901168e-4, 1.2, 500.0)'	=> [ 10.0, $TOL6 ],
                    'gsl_cdf_fdist_Qinv ( 1.99426162833131e-6, 1.2, 500.0)'	=> [ 20.0, $TOL6 ],
                    'gsl_cdf_fdist_Qinv ( 6.23302662288217117e-25, 1.2, 500.0)'	=> [ 100.0, $TOL6 ],
                    'gsl_cdf_fdist_Qinv ( 1.14328577259666930e-134, 1.2, 500.0)'	=> [ 1000.0, $TOL6 ],
                    q{gsl_cdf_fdist_Qinv ( 0.0, 1.2, 500.0)}	=> [  q{inf}, $TOL6 ],
                    'gsl_cdf_fdist_Pinv ( 0.0, 200.0, 500.0)'	=> [ 0.0, $TOL6 ],
                    'gsl_cdf_fdist_Pinv ( 4.09325080403669893e-251, 200.0, 500.0)'	=> [ 0.001, $TOL6 ],
                    'gsl_cdf_fdist_Pinv ( 1.17894325419628688e-151, 200.0, 500.0)'	=> [ 0.01, $TOL6 ],
                    'gsl_cdf_fdist_Pinv ( 5.92430940796861258e-57, 200.0, 500.0)'	=> [ 0.1, $TOL6 ],
                    'gsl_cdf_fdist_Pinv ( 3.18220452357263554e-18, 200.0, 500.0)'	=> [ 0.325, $TOL6 ],
                    'gsl_cdf_fdist_Pinv ( 5.06746326121168266e-1, 200.0, 500.0)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_fdist_Pinv ( 9.99794175718712438e-1, 200.0, 500.0)'	=> [ 1.5, $TOL6 ],
                    q{gsl_cdf_fdist_Pinv ( 1.0, 200.0, 500.0)}	=> [  q{inf}, $TOL6 ],
                    'gsl_cdf_fdist_Qinv ( 1.0, 200.0, 500.0)'	=> [ 0.0, $TOL6 ],
                    'gsl_cdf_fdist_Qinv ( 4.93253673878831734e-1, 200.0, 500.0)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_fdist_Qinv ( 2.05824281287561795e-4, 200.0, 500.0)'	=> [ 1.5, $TOL6 ],
                    'gsl_cdf_fdist_Qinv ( 4.71763848371410786e-10, 200.0, 500.0)'	=> [ 2.0, $TOL6 ],
                    'gsl_cdf_fdist_Qinv ( 5.98048337181948436e-96, 200.0, 500.0)'	=> [ 10.0, $TOL6 ],
                    'gsl_cdf_fdist_Qinv ( 2.92099265879979502e-155, 200.0, 500.0)'	=> [ 20.0, $TOL6 ],
                    q{gsl_cdf_fdist_Qinv ( 0.0, 200.0, 500.0)}	=> [  q{inf}, $TOL6 ],
                    'gsl_cdf_fdist_Pinv (0.95,1.0,261.0)'	=> [ 3.8773340322508720313e+00, $TOL6 ],
                    'gsl_cdf_gamma_P (0.0, 1.0, 1.0)'	=> [ 0.0, $TOL6 ],
                    'gsl_cdf_gamma_P (1e-100, 1.0, 1.0)'	=> [ 1e-100, $TOL6 ],
                    'gsl_cdf_gamma_P (0.001, 1.0, 1.0)'	=> [ 9.99500166625008332e-4, $TOL6 ],
                    'gsl_cdf_gamma_P (0.01, 1.0, 1.0)'	=> [ 9.95016625083194643e-3, $TOL6 ],
                    'gsl_cdf_gamma_P (0.1, 1.0, 1.0)'	=> [ 9.51625819640404268e-2, $TOL6 ],
                    'gsl_cdf_gamma_P (0.325, 1.0, 1.0)'	=> [ 2.77472646357927811e-1, $TOL6 ],
                    'gsl_cdf_gamma_P (1.0, 1.0, 1.0)'	=> [ 6.32120558828557678e-1, $TOL6 ],
                    'gsl_cdf_gamma_P (1.5, 1.0, 1.0)'	=> [ 7.76869839851570171e-1, $TOL6 ],
                    'gsl_cdf_gamma_P (2.0, 1.0, 1.0)'	=> [ 8.64664716763387308e-1, $TOL6 ],
                    'gsl_cdf_gamma_P (10.0, 1.0, 1.0)'	=> [ 9.99954600070237515e-1, $TOL6 ],
                    'gsl_cdf_gamma_P (20.0, 1.0, 1.0)'	=> [ 9.99999997938846378e-1, $TOL6 ],
                    'gsl_cdf_gamma_P (100.0, 1.0, 1.0)'	=> [ 1e0, $TOL6 ],
                    'gsl_cdf_gamma_P (1000.0, 1.0, 1.0)'	=> [ 1e0, $TOL6 ],
                    'gsl_cdf_gamma_P (10000.0, 1.0, 1.0)'	=> [ 1e0, $TOL6 ],
                    'gsl_cdf_gamma_Q (0.0, 1.0, 1.0)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_gamma_Q (1e-100, 1.0, 1.0)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_gamma_Q (0.001, 1.0, 1.0)'	=> [ 9.99000499833374992e-1, $TOL6 ],
                    'gsl_cdf_gamma_Q (0.01, 1.0, 1.0)'	=> [ 9.90049833749168054e-1, $TOL6 ],
                    'gsl_cdf_gamma_Q (0.1, 1.0, 1.0)'	=> [ 9.04837418035959573e-1, $TOL6 ],
                    'gsl_cdf_gamma_Q (0.325, 1.0, 1.0)'	=> [ 7.22527353642072189e-1, $TOL6 ],
                    'gsl_cdf_gamma_Q (1.0, 1.0, 1.0)'	=> [ 3.67879441171442322e-1, $TOL6 ],
                    'gsl_cdf_gamma_Q (1.5, 1.0, 1.0)'	=> [ 2.23130160148429829e-1, $TOL6 ],
                    'gsl_cdf_gamma_Q (2.0, 1.0, 1.0)'	=> [ 1.35335283236612692e-1, $TOL6 ],
                    'gsl_cdf_gamma_Q (10.0, 1.0, 1.0)'	=> [ 4.53999297624848515e-5, $TOL6 ],
                    'gsl_cdf_gamma_Q (20.0, 1.0, 1.0)'	=> [ 2.06115362243855783e-9, $TOL6 ],
                    'gsl_cdf_gamma_Q (100.0, 1.0, 1.0)'	=> [ 3.72007597602083596e-44, $TOL6 ],
                    'gsl_cdf_gamma_Q (1000.0, 1.0, 1.0)'	=> [ 0.0, $TOL6 ],
                    'gsl_cdf_gamma_Q (10000.0, 1.0, 1.0)'	=> [ 0.0, $TOL6 ],
                    'gsl_cdf_gamma_P (0.0, 1.0, 10.0)'	=> [ 0.0, $TOL6 ],
                    'gsl_cdf_gamma_P (1e-100, 1.0, 10.0)'	=> [ 1e-101, $TOL6 ],
                    'gsl_cdf_gamma_P (0.001, 1.0, 10.0)'	=> [ 9.99950001666625001e-5, $TOL6 ],
                    'gsl_cdf_gamma_P (0.01, 1.0, 10.0)'	=> [ 9.99500166625008332e-4, $TOL6 ],
                    'gsl_cdf_gamma_P (0.1, 1.0, 10.0)'	=> [ 9.95016625083194643e-3, $TOL6 ],
                    'gsl_cdf_gamma_P (0.325, 1.0, 10.0)'	=> [ 3.19775501686939529e-2, $TOL6 ],
                    'gsl_cdf_gamma_P (1.0, 1.0, 10.0)'	=> [ 9.51625819640404268e-2, $TOL6 ],
                    'gsl_cdf_gamma_P (1.5, 1.0, 10.0)'	=> [ 1.39292023574942193e-1, $TOL6 ],
                    'gsl_cdf_gamma_P (2.0, 1.0, 10.0)'	=> [ 1.81269246922018141e-1, $TOL6 ],
                    'gsl_cdf_gamma_P (10.0, 1.0, 10.0)'	=> [ 6.32120558828557678e-1, $TOL6 ],
                    'gsl_cdf_gamma_P (20.0, 1.0, 10.0)'	=> [ 8.64664716763387308e-1, $TOL6 ],
                    'gsl_cdf_gamma_P (100.0, 1.0, 10.0)'	=> [ 9.99954600070237515e-1, $TOL6 ],
                    'gsl_cdf_gamma_P (1000.0, 1.0, 10.0)'	=> [ 1e0, $TOL6 ],
                    'gsl_cdf_gamma_P (10000.0, 1.0, 10.0)'	=> [ 1e0, $TOL6 ],
                    'gsl_cdf_gamma_Q (0.0, 1.0, 10.0)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_gamma_Q (1e-100, 1.0, 10.0)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_gamma_Q (0.001, 1.0, 10.0)'	=> [ 9.99900004999833337e-1, $TOL6 ],
                    'gsl_cdf_gamma_Q (0.01, 1.0, 10.0)'	=> [ 9.99000499833374992e-1, $TOL6 ],
                    'gsl_cdf_gamma_Q (0.1, 1.0, 10.0)'	=> [ 9.90049833749168054e-1, $TOL6 ],
                    'gsl_cdf_gamma_Q (0.325, 1.0, 10.0)'	=> [ 9.68022449831306047e-1, $TOL6 ],
                    'gsl_cdf_gamma_Q (1.0, 1.0, 10.0)'	=> [ 9.04837418035959573e-1, $TOL6 ],
                    'gsl_cdf_gamma_Q (1.5, 1.0, 10.0)'	=> [ 8.60707976425057807e-1, $TOL6 ],
                    'gsl_cdf_gamma_Q (2.0, 1.0, 10.0)'	=> [ 8.18730753077981859e-1, $TOL6 ],
                    'gsl_cdf_gamma_Q (10.0, 1.0, 10.0)'	=> [ 3.67879441171442322e-1, $TOL6 ],
                    'gsl_cdf_gamma_Q (20.0, 1.0, 10.0)'	=> [ 1.35335283236612692e-1, $TOL6 ],
                    'gsl_cdf_gamma_Q (100.0, 1.0, 10.0)'	=> [ 4.53999297624848515e-5, $TOL6 ],
                    'gsl_cdf_gamma_Q (1000.0, 1.0, 10.0)'	=> [ 3.72007597602083596e-44, $TOL6 ],
                    'gsl_cdf_gamma_Q (10000.0, 1.0, 10.0)'	=> [ 0.0, $TOL6 ],
                    'gsl_cdf_gamma_P (0.0, 17.0, 10.0)'	=> [ 0e0, $TOL6 ],
                    'gsl_cdf_gamma_P (1e-100, 17.0, 10.0)'	=> [ 0e0, $TOL6 ],
                    'gsl_cdf_gamma_P (0.001, 17.0, 10.0)'	=> [ 2.81119174040422844e-83, $TOL6 ],
                    'gsl_cdf_gamma_P (0.01, 17.0, 10.0)'	=> [ 2.80880324651985887e-66, $TOL6 ],
                    'gsl_cdf_gamma_P (0.1, 17.0, 10.0)'	=> [ 2.78502998087492130e-49, $TOL6 ],
                    'gsl_cdf_gamma_P (0.325, 17.0, 10.0)'	=> [ 1.37283653245125844e-40, $TOL6 ],
                    'gsl_cdf_gamma_P (1.0, 17.0, 10.0)'	=> [ 2.55811932292544243e-32, $TOL6 ],
                    'gsl_cdf_gamma_P (1.5, 17.0, 10.0)'	=> [ 2.40420441175422372e-29, $TOL6 ],
                    'gsl_cdf_gamma_P (2.0, 17.0, 10.0)'	=> [ 3.05092926217898577e-27, $TOL6 ],
                    'gsl_cdf_gamma_P (10.0, 17.0, 10.0)'	=> [ 1.094920130378183e-15, $TOL6 ],
                    'gsl_cdf_gamma_P (20.0, 17.0, 10.0)'	=> [ 5.60605096173161688e-11, $TOL6 ],
                    'gsl_cdf_gamma_P (100.0, 17.0, 10.0)'	=> [ 2.70416097848011280e-2, $TOL6 ],
                    'gsl_cdf_gamma_P (1000.0, 17.0, 10.0)'	=> [ 1.000000000000000000e0, $TOL6 ],
                    'gsl_cdf_gamma_P (10000.0, 17.0, 10.0)'	=> [ 1.000000000000000000e0, $TOL6 ],
                    'gsl_cdf_gamma_Q (0.0, 17.0, 10.0)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_gamma_Q (1e-100, 17.0, 10.0)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_gamma_Q (0.001, 17.0, 10.0)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_gamma_Q (0.01, 17.0, 10.0)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_gamma_Q (0.1, 17.0, 10.0)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_gamma_Q (0.325, 17.0, 10.0)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_gamma_Q (1.0, 17.0, 10.0)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_gamma_Q (1.5, 17.0, 10.0)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_gamma_Q (2.0, 17.0, 10.0)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_gamma_Q (10.0, 17.0, 10.0)'	=> [ 9.99999999999998905e-1, $TOL6 ],
                    'gsl_cdf_gamma_Q (20.0, 17.0, 10.0)'	=> [ 9.99999999943939490e-1, $TOL6 ],
                    'gsl_cdf_gamma_Q (100.0, 17.0, 10.0)'	=> [ 9.72958390215198872e-1, $TOL6 ],
                    'gsl_cdf_gamma_Q (1000.0, 17.0, 10.0)'	=> [ 2.11200951633948570e-25, $TOL6 ],
                    'gsl_cdf_gamma_Q (10000.0, 17.0, 10.0)'	=> [ 0.0, $TOL6 ],
                    'gsl_cdf_chisq_P (0.0, 13.0)'	=> [ 0.0, $TOL6 ],
                    'gsl_cdf_chisq_P (1e-100, 13.0)'	=> [ 0.0, $TOL6 ],
                    'gsl_cdf_chisq_P (0.001, 13.0)'	=> [ 1.86631102655845996e-25, $TOL6 ],
                    'gsl_cdf_chisq_P (0.01, 13.0)'	=> [ 5.87882248504529790e-19, $TOL6 ],
                    'gsl_cdf_chisq_P (0.1, 13.0)'	=> [ 1.78796983358555410e-12, $TOL6 ],
                    'gsl_cdf_chisq_P (0.325, 13.0)'	=> [ 3.44611313779905183e-9, $TOL6 ],
                    'gsl_cdf_chisq_P (1.0, 13.0)'	=> [ 3.83473473513595154e-6, $TOL6 ],
                    'gsl_cdf_chisq_P (1.5, 13.0)'	=> [ 4.31718389201041932e-5, $TOL6 ],
                    'gsl_cdf_chisq_P (2.0, 13.0)'	=> [ 2.26250084656047180e-4, $TOL6 ],
                    'gsl_cdf_chisq_P (10.0, 13.0)'	=> [ 3.06065632019251110e-1, $TOL6 ],
                    'gsl_cdf_chisq_P (20.0, 13.0)'	=> [ 9.04789743921908487e-1, $TOL6 ],
                    'gsl_cdf_chisq_P (100.0, 13.0)'	=> [ 9.99999999999998341e-1, $TOL6 ],
                    'gsl_cdf_chisq_P (1000.0, 13.0)'	=> [ 1e0, $TOL6 ],
                    'gsl_cdf_chisq_P (10000.0, 13.0)'	=> [ 1e0, $TOL6 ],
                    'gsl_cdf_chisq_Q (0.0, 13.0)'	=> [ 1e0, $TOL6 ],
                    'gsl_cdf_chisq_Q (1e-100, 13.0)'	=> [ 1e0, $TOL6 ],
                    'gsl_cdf_chisq_Q (0.001, 13.0)'	=> [ 1e0, $TOL6 ],
                    'gsl_cdf_chisq_Q (0.01, 13.0)'	=> [ 9.99999999999999999e-1, $TOL6 ],
                    'gsl_cdf_chisq_Q (0.1, 13.0)'	=> [ 9.99999999998212030e-1, $TOL6 ],
                    'gsl_cdf_chisq_Q (0.325, 13.0)'	=> [ 9.99999996553886862e-1, $TOL6 ],
                    'gsl_cdf_chisq_Q (1.0, 13.0)'	=> [ 9.99996165265264864e-1, $TOL6 ],
                    'gsl_cdf_chisq_Q (1.5, 13.0)'	=> [ 9.99956828161079896e-1, $TOL6 ],
                    'gsl_cdf_chisq_Q (2.0, 13.0)'	=> [ 9.99773749915343953e-1, $TOL6 ],
                    'gsl_cdf_chisq_Q (10.0, 13.0)'	=> [ 6.93934367980748890e-1, $TOL6 ],
                    'gsl_cdf_chisq_Q (20.0, 13.0)'	=> [ 9.52102560780915127e-2, $TOL6 ],
                    'gsl_cdf_chisq_Q (100.0, 13.0)'	=> [ 1.65902608070858809e-15, $TOL6 ],
                    'gsl_cdf_chisq_Q (1000.0, 13.0)'	=> [ 1.74851191544860225e-205, $TOL6 ],
                    'gsl_cdf_chisq_Q (10000.0, 13.0)'	=> [ 0.0, $TOL6 ],
                    'gsl_cdf_beta_P (0.0, 1.2, 1.3)'	=> [ 0.0, $TOL6 ],
                    'gsl_cdf_beta_P (1e-100, 1.2, 1.3)'	=> [ 1.34434944656489596e-120, $TOL6 ],
                    'gsl_cdf_beta_P (0.001, 1.2, 1.3)'	=> [ 3.37630042504535813e-4, $TOL6 ],
                    'gsl_cdf_beta_P (0.01, 1.2, 1.3)'	=> [ 5.34317264038929473e-3, $TOL6 ],
                    'gsl_cdf_beta_P (0.1, 1.2, 1.3)'	=> [ 8.33997828306748346e-2, $TOL6 ],
                    'gsl_cdf_beta_P (0.325, 1.2, 1.3)'	=> [ 3.28698654180583916e-1, $TOL6 ],
                    'gsl_cdf_beta_P (0.5, 1.2, 1.3)'	=> [ 5.29781429451299081e-1, $TOL6 ],
                    'gsl_cdf_beta_P (0.9, 1.2, 1.3)'	=> [ 9.38529397224430659e-1, $TOL6 ],
                    'gsl_cdf_beta_P (0.99, 1.2, 1.3)'	=> [ 9.96886438341254380e-1, $TOL6 ],
                    'gsl_cdf_beta_P (0.999, 1.2, 1.3)'	=> [ 9.99843792833067634e-1, $TOL6 ],
                    'gsl_cdf_beta_P (1.0, 1.2, 1.3)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_beta_Q (0.0, 1.2, 1.3)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_beta_Q (1e-100, 1.2, 1.3)'	=> [ 1e0, $TOL6 ],
                    'gsl_cdf_beta_Q (0.001, 1.2, 1.3)'	=> [ 9.99662369957495464e-1, $TOL6 ],
                    'gsl_cdf_beta_Q (0.01, 1.2, 1.3)'	=> [ 9.94656827359610705e-1, $TOL6 ],
                    'gsl_cdf_beta_Q (0.1, 1.2, 1.3)'	=> [ 9.16600217169325165e-1, $TOL6 ],
                    'gsl_cdf_beta_Q (0.325, 1.2, 1.3)'	=> [ 6.71301345819416084e-1, $TOL6 ],
                    'gsl_cdf_beta_Q (0.5, 1.2, 1.3)'	=> [ 4.70218570548700919e-1, $TOL6 ],
                    'gsl_cdf_beta_Q (0.9, 1.2, 1.3)'	=> [ 6.14706027755693408e-2, $TOL6 ],
                    'gsl_cdf_beta_Q (0.99, 1.2, 1.3)'	=> [ 3.11356165874561958e-3, $TOL6 ],
                    'gsl_cdf_beta_Q (0.999, 1.2, 1.3)'	=> [ 1.56207166932365759e-4, $TOL6 ],
                    'gsl_cdf_beta_Q (1.0, 1.2, 1.3)'	=> [ 0.0, 0.0 ],
                    'gsl_cdf_beta_Pinv (0.0, 1.2, 1.3)'	=> [ 0.0, 0.0],
                    'gsl_cdf_beta_Pinv ( 1.34434944656489596e-120, 1.2, 1.3)'	=> [ 1e-100, $TOL6 ],
                    'gsl_cdf_beta_Pinv ( 3.37630042504535813e-4, 1.2, 1.3)'	=> [ 0.001, $TOL6 ],
                    'gsl_cdf_beta_Pinv ( 5.34317264038929473e-3, 1.2, 1.3)'	=> [ 0.01, $TOL6 ],
                    'gsl_cdf_beta_Pinv ( 8.33997828306748346e-2, 1.2, 1.3)'	=> [ 0.1, $TOL6 ],
                    'gsl_cdf_beta_Pinv ( 3.28698654180583916e-1, 1.2, 1.3)'	=> [ 0.325, $TOL6 ],
                    'gsl_cdf_beta_Pinv ( 5.29781429451299081e-1, 1.2, 1.3)'	=> [ 0.5, $TOL6 ],
                    'gsl_cdf_beta_Pinv ( 9.38529397224430659e-1, 1.2, 1.3)'	=> [ 0.9, $TOL6 ],
                    'gsl_cdf_beta_Pinv ( 9.96886438341254380e-1, 1.2, 1.3)'	=> [ 0.99, $TOL6 ],
                    'gsl_cdf_beta_Pinv ( 9.99843792833067634e-1, 1.2, 1.3)'	=> [ 0.999, $TOL6 ],
                    'gsl_cdf_beta_Pinv ( 1.0, 1.2, 1.3)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_beta_Qinv ( 1.0, 1.2, 1.3)'	=> [ 0.0, $TOL0 ],
                    'gsl_cdf_beta_Qinv ( 1e0, 1.2, 1.3)'	=> [ 0.0, $TOL0 ],
                    'gsl_cdf_beta_Qinv ( 9.99662369957495464e-1, 1.2, 1.3)'	=> [ 0.001, $TOL6 ],
                    'gsl_cdf_beta_Qinv ( 9.94656827359610705e-1, 1.2, 1.3)'	=> [ 0.01, $TOL6 ],
                    'gsl_cdf_beta_Qinv ( 9.16600217169325165e-1, 1.2, 1.3)'	=> [ 0.1, $TOL6 ],
                    'gsl_cdf_beta_Qinv ( 6.71301345819416084e-1, 1.2, 1.3)'	=> [ 0.325, $TOL6 ],
                    'gsl_cdf_beta_Qinv ( 4.70218570548700919e-1, 1.2, 1.3)'	=> [ 0.5, $TOL6 ],
                    'gsl_cdf_beta_Qinv ( 6.14706027755693408e-2, 1.2, 1.3)'	=> [ 0.9, $TOL6 ],
                    'gsl_cdf_beta_Qinv ( 3.11356165874561958e-3, 1.2, 1.3)'	=> [ 0.99, $TOL6 ],
                    'gsl_cdf_beta_Qinv ( 1.56207166932365759e-4, 1.2, 1.3)'	=> [ 0.999, $TOL6 ],
                    'gsl_cdf_beta_Qinv ( 0.0, 1.2, 1.3)'	=> [ 1.0, 0.0 ],
                    'gsl_cdf_beta_Pinv ( 0.025, 2133.0, 7868.0)'	=> [  0.20530562929915865457928654, $TOL6 ],
                    'gsl_cdf_gamma_Pinv (0.0, 1.0, 1.0)'	=> [ 0.0, 0.0 ],
                    'gsl_cdf_gamma_Pinv (1e-100, 1.0, 1.0)'	=> [ 1e-100, $TOL6 ],
                    'gsl_cdf_gamma_Pinv (9.99500166625008332e-4, 1.0, 1.0)'	=> [ 0.001, $TOL6 ],
                    'gsl_cdf_gamma_Pinv (9.95016625083194643e-3, 1.0, 1.0)'	=> [ 0.01, $TOL6 ],
                    'gsl_cdf_gamma_Pinv (9.51625819640404268e-2, 1.0, 1.0)'	=> [ 0.1, $TOL6 ],
                    'gsl_cdf_gamma_Pinv (2.77472646357927811e-1, 1.0, 1.0)'	=> [ 0.325, $TOL6 ],
                    'gsl_cdf_gamma_Pinv (6.32120558828557678e-1, 1.0, 1.0)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_gamma_Pinv (7.76869839851570171e-1, 1.0, 1.0)'	=> [ 1.5, $TOL6 ],
                    'gsl_cdf_gamma_Pinv (8.64664716763387308e-1, 1.0, 1.0)'	=> [ 2.0, $TOL6 ],
                    'gsl_cdf_gamma_Pinv (9.99954600070237515e-1, 1.0, 1.0)'	=> [ 10.0, $TOL6 ],
                    'gsl_cdf_gamma_Pinv (9.99999997938846378e-1, 1.0, 1.0)'	=> [ 20.0, 100*$TOL6 ],
                    q{gsl_cdf_gamma_Pinv (1.0, 1.0, 1.0)}	=> [  q{inf}, $TOL6 ],
                    'gsl_cdf_gamma_Pinv (0.1, 11.887411491530846,1.0)'	=> [ 7.73788447848618e+00, $TOL6 ],
                    q{gsl_cdf_gamma_Qinv (0.0, 1.0, 1.0)}	=> [  q{inf}, $TOL6 ],
                    'gsl_cdf_gamma_Qinv (2.06115362243855783e-9, 1.0, 1.0)'	=> [ 20.0, $TOL6 ],
                    'gsl_cdf_gamma_Qinv (4.53999297624848515e-5, 1.0, 1.0)'	=> [ 10.0, $TOL6 ],
                    'gsl_cdf_gamma_Qinv (1.35335283236612692e-1, 1.0, 1.0)'	=> [ 2.0, $TOL6 ],
                    'gsl_cdf_gamma_Qinv (2.23130160148429829e-1, 1.0, 1.0)'	=> [ 1.5, $TOL6 ],
                    'gsl_cdf_gamma_Qinv (3.67879441171442322e-1, 1.0, 1.0)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_gamma_Qinv (7.22527353642072189e-1, 1.0, 1.0)'	=> [ 0.325, $TOL6 ],
                    'gsl_cdf_gamma_Qinv (9.04837418035959573e-1, 1.0, 1.0)'	=> [ 0.1, $TOL6 ],
                    'gsl_cdf_gamma_Qinv (9.90049833749168054e-1, 1.0, 1.0)'	=> [ 0.01, $TOL6 ],
                    'gsl_cdf_gamma_Qinv (9.99000499833374992e-1, 1.0, 1.0)'	=> [ 0.001, $TOL6 ],
                    'gsl_cdf_gamma_Qinv (1.0, 1.0, 1.0)'	=> [ 0.0, $TOL6 ],
                    'gsl_cdf_chisq_Pinv (0.0, 13.0)'	=> [ 0.0, $TOL6 ],
                    'gsl_cdf_chisq_Pinv (1.86631102655845996e-25, 13.0)'	=> [ 0.001, $TOL6 ],
                    'gsl_cdf_chisq_Pinv (5.87882248504529790e-19, 13.0)'	=> [ 0.01, $TOL6 ],
                    'gsl_cdf_chisq_Pinv (1.78796983358555410e-12, 13.0)'	=> [ 0.1, $TOL6 ],
                    'gsl_cdf_chisq_Pinv (3.44611313779905183e-9, 13.0)'	=> [ 0.325, $TOL6 ],
                    'gsl_cdf_chisq_Pinv (3.83473473513595154e-6, 13.0)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_chisq_Pinv (4.31718389201041932e-5, 13.0)'	=> [ 1.5, $TOL6 ],
                    'gsl_cdf_chisq_Pinv (2.26250084656047180e-4, 13.0)'	=> [ 2.0, $TOL6 ],
                    'gsl_cdf_chisq_Pinv (3.06065632019251110e-1, 13.0)'	=> [ 10.0, $TOL6 ],
                    'gsl_cdf_chisq_Pinv (9.04789743921908487e-1, 13.0)'	=> [ 20.0, $TOL6 ],
                    'gsl_cdf_chisq_Pinv (9.99999999999998341e-1, 13.0)'	=> [ 100.0, 0.1 ],
                    q{gsl_cdf_chisq_Pinv (1e0, 13.0)}	                => [  q{inf}, $TOL6 ],
                    q{gsl_cdf_chisq_Qinv (0.0, 13.0)}	                => [  q{inf}, $TOL6 ],
                    'gsl_cdf_chisq_Qinv (1.65902608070858809e-15, 13.0)'=> [ 100.0, $TOL6 ],
                    'gsl_cdf_chisq_Qinv (9.52102560780915127e-2, 13.0)'	=> [ 20.0, $TOL6 ],
                    'gsl_cdf_chisq_Qinv (6.93934367980748892e-1, 13.0)'	=> [ 10.0, $TOL6 ],
                    'gsl_cdf_chisq_Qinv (9.99773749915343954e-1, 13.0)'	=> [ 2.0, $TOL6 ],
                    'gsl_cdf_chisq_Qinv (9.99956828161079894e-1, 13.0)'	=> [ 1.5, $TOL6 ],
                    'gsl_cdf_chisq_Qinv (9.99996165265264863e-1, 13.0)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_chisq_Qinv (9.99999996553886862e-1, 13.0)'	=> [ 0.325, 1e-6 ],
                    'gsl_cdf_chisq_Qinv (9.99999999998212031e-1, 13.0)'	=> [ 0.1, 1e-5 ],
                    'gsl_cdf_chisq_Qinv (1.0, 13.0)'	                => [ 0.0, 0.0],
                    'gsl_cdf_tdist_Pinv (0.5, 1.0)'	                    => [ 0.0, 0.0 ],
                    'gsl_cdf_tdist_Pinv (5.00318309780080559e-1, 1.0)'	=> [ 0.001, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (5.03182992764908255e-1, 1.0)'	=> [ 0.01, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (5.31725517430553569e-1, 1.0)'	=> [ 0.1, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (6.00023120032852123e-1, 1.0)'	=> [ 0.325, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (0.75000000000000000e0, 1.0)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (8.12832958189001183e-1, 1.0)'	=> [ 1.5, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (8.52416382349566726e-1, 1.0)'	=> [ 2.0, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (9.68274482569446430e-1, 1.0)'	=> [ 10.0, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (9.84097748743823625e-1, 1.0)'	=> [ 20.0, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (9.96817007235091745e-1, 1.0)'	=> [ 100.0, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (9.99681690219919441e-1, 1.0)'	=> [ 1000.0, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (9.99968169011487724e-1, 1.0)'	=> [ 10000.0, 100*$TOL6 ],
                    'gsl_cdf_tdist_Pinv (4.99681690219919441e-1, 1.0)'	=> [ -0.001, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (4.96817007235091744e-1, 1.0)'	=> [ -0.01, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (4.68274482569446430e-1, 1.0)'	=> [ -0.1, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (3.99976879967147876e-1, 1.0)'	=> [ -0.325, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (0.25, 1.0)'	                => [ -1.0, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (1.87167041810998816e-1, 1.0)'	=> [ -1.5, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (1.47583617650433274e-1, 1.0)'	=> [ -2.0, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (3.17255174305535695e-2, 1.0)'	=> [ -10.0, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (1.59022512561763751e-2, 1.0)'	=> [ -20.0, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (3.18299276490825514e-3, 1.0)'	=> [ -100.0, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (3.18309780080558938e-4, 1.0)'	=> [ -1000.0, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (3.18309885122757724e-5, 1.0)'	=> [ -10000.0, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (0.5, 1.0)'	                    => [ 0.0, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (4.99681690219919441e-1, 1.0)'	=> [ 0.001, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (4.96817007235091745e-1, 1.0)'	=> [ 0.01, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (4.68274482569446430e-1, 1.0)'	=> [ 0.1, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (3.99976879967147876e-1, 1.0)'	=> [ 0.325, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (2.5e-1, 1.0)'	                => [ 1.0, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (1.87167041810998816e-1, 1.0)'	=> [ 1.5, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (1.47583617650433274e-1, 1.0)'	=> [ 2.0, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (3.17255174305535695e-2, 1.0)'	=> [ 10.0, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (1.59022512561763752e-2, 1.0)'	=> [ 20.0, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (3.18299276490825515e-3, 1.0)'	=> [ 100.0, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (3.18309780080558939e-4, 1.0)'	=> [ 1000.0, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (3.18309885122757724e-5, 1.0)'	=> [ 10000.0, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (4.99681690219919441e-1, 1.0)'	=> [ -0.001, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (4.96817007235091744e-1, 1.0)'	=> [ -0.01, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (4.68274482569446430e-1, 1.0)'	=> [ -0.1, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (3.99976879967147876e-1, 1.0)'	=> [ -0.325, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (0.25, 1.0)'	                => [ -1.0, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (1.87167041810998816e-1, 1.0)'	=> [ -1.5, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (1.47583617650433274e-1, 1.0)'	=> [ -2.0, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (3.17255174305535695e-2, 1.0)'	=> [ -10.0, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (1.59022512561763751e-2, 1.0)'	=> [ -20.0, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (3.18299276490825514e-3, 1.0)'	=> [ -100.0, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (3.18309780080558938e-4, 1.0)'	=> [ -1000.0, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (3.18309885122757724e-5, 1.0)'	=> [ -10000.0, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (5.00318309780080559e-1, 1.0)'	=> [ -0.001, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (5.03182992764908255e-1, 1.0)'	=> [ -0.01, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (5.31725517430553570e-1, 1.0)'	=> [ -0.1, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (6.00023120032852124e-1, 1.0)'	=> [ -0.325, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (7.5e-1, 1.0)'	                => [ -1.0, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (8.12832958189001184e-1, 1.0)'	=> [ -1.5, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (8.52416382349566726e-1, 1.0)'	=> [ -2.0, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (9.68274482569446430e-1, 1.0)'	=> [ -10.0, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (9.84097748743823625e-1, 1.0)'	=> [ -20.0, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (9.96817007235091745e-1, 1.0)'	=> [ -100.0, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (9.99681690219919441e-1, 1.0)'	=> [ -1000.0, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (9.99968169011487724e-1, 1.0)'	=> [ -10000.0, 100*$TOL6 ],
                    'gsl_cdf_tdist_Pinv (4.99646446697795041e-01, 2.0)'	=> [ -0.001, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (4.96464554479100486e-01, 2.0)'	=> [ -0.01, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (4.64732719207070087e-01, 2.0)'	=> [ -0.1, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (3.88014227253126233e-01, 2.0)'	=> [ -0.325, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (2.11324865405187118e-01, 2.0)'	=> [ -1.0, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (1.36196562445500540e-01, 2.0)'	=> [ -1.5, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (9.17517095361369836e-02, 2.0)'	=> [ -2.0, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (4.92622851166284542e-03, 2.0)'	=> [ -10.0, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (1.24533194618354849e-03, 2.0)'	=> [ -20.0, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (4.99925012497812894e-05, 2.0)'	=> [ -100.0, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (4.99999250001249998e-07, 2.0)'	=> [ -1000.0, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (4.99999992500000125e-09, 2.0)'	=> [ -10000.0, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (5.00353553302204959e-1, 2.0)'	=> [ -0.001, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (5.03535445520899514e-1, 2.0)'	=> [ -0.01, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (5.35267280792929913e-1, 2.0)'	=> [ -0.1, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (6.11985772746873767e-1, 2.0)'	=> [ -0.325, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (7.88675134594812882e-1, 2.0)'	=> [ -1.0, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (8.63803437554499460e-1, 2.0)'	=> [ -1.5, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (9.08248290463863016e-1, 2.0)'	=> [ -2.0, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (9.95073771488337155e-1, 2.0)'	=> [ -10.0, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (9.98754668053816452e-1, 2.0)'	=> [ -20.0, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (9.99950007498750219e-1, 2.0)'	=> [ -100.0, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (9.99999500000749999e-1, 2.0)'	=> [ -1000.0, 100*$TOL6 ],
                    'gsl_cdf_tdist_Qinv (9.99999995000000075e-1, 2.0)'	=> [ -10000.0, 1e-4 ],
                    'gsl_cdf_tdist_Pinv (5.00000000000000000e-01, 300.0)'	=> [ 0.0, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (5.00398609900942949e-01, 300.0)'	=> [ 0.001, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (5.03986033020559088e-01, 300.0)'	=> [ 0.01, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (5.39794441177768194e-01, 300.0)'	=> [ 0.1, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (6.27296201542523812e-01, 300.0)'	=> [ 0.325, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (8.40941797784686861e-01, 300.0)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (9.32666983425369137e-01, 300.0)'	=> [ 1.5, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (9.76799239508425455e-01, 300.0)'	=> [ 2.0, $TOL6 ],
                    q{gsl_cdf_tdist_Pinv (1.00000000000000000e+00, 300.0)}	=> [  q{inf}, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (5.00000000000000000e-01, 300.0)'	=> [ 0.0, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (4.99601390099057051e-1, 300.0)'	=> [ 0.001, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (4.96013966979440912e-1, 300.0)'	=> [ 0.01, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (4.60205558822231806e-1, 300.0)'	=> [ 0.1, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (3.72703798457476188e-1, 300.0)'	=> [ 0.325, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (1.59058202215313138e-1, 300.0)'	=> [ 1.0, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (6.73330165746308628e-2, 300.0)'	=> [ 1.5, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (2.32007604915745452e-2, 300.0)'	=> [ 2.0, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (8.279313677e-21, 300.0)'	        => [ 10.0, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (1.93159812815803978e-57, 300.0)'	=> [ 20.0, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (1.02557519997736154e-232, 300.0)'	=> [ 100.0, $TOL6 ],
                    q{gsl_cdf_tdist_Qinv (0.00000000000000000e+00, 300.0)}	=> [  q{inf}, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (4.99601390099057051e-01, 300.0)'	=> [ -0.001, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (4.96013966979440912e-01, 300.0)'	=> [ -0.01, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (4.60205558822231806e-01, 300.0)'	=> [ -0.1, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (3.72703798457476188e-01, 300.0)'	=> [ -0.325, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (1.59058202215313138e-01, 300.0)'	=> [ -1.0, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (6.73330165746308628e-02, 300.0)'	=> [ -1.5, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (2.32007604915745452e-02, 300.0)'	=> [ -2.0, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (8.279313675556272534e-21, 300.0)'	=> [ -10.0, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (1.93159812815803978e-57, 300.0)'	=> [ -20.0, $TOL6 ],
                    'gsl_cdf_tdist_Pinv (1.02557519997736154e-232, 300.0)'	=> [ -100.0, $TOL6 ],
                    q{gsl_cdf_tdist_Pinv (0.0, 300.0)}	                    => [  q{-inf}, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (5.00398609900942949e-1, 300.0)'	=> [ -0.001, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (5.03986033020559088e-1, 300.0)'	=> [ -0.01, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (5.39794441177768194e-1, 300.0)'	=> [ -0.1, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (6.27296201542523812e-1, 300.0)'	=> [ -0.325, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (8.40941797784686862e-1, 300.0)'	=> [ -1.0, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (9.32666983425369137e-1, 300.0)'	=> [ -1.5, $TOL6 ],
                    'gsl_cdf_tdist_Qinv (9.76799239508425455e-1, 300.0)'	=> [ -2.0, $TOL6 ],
                    q{gsl_cdf_tdist_Qinv (1.000000000000000000e0, 300.0)}	=> [  q{-inf}, $TOL6 ],
                };
    verify($results, 'Math::GSL::CDF');
}
