use Test;
BEGIN {
	plan(tests => 44); 
};
use Algorithm::CheckDigits;

my $iban = CheckDigits('iban');

#
ok($iban->is_valid("AD12 0001 2030 2003 5910 0100"));
ok($iban->is_valid("BE68 5390 0754 7034"));
ok($iban->is_valid("BA39 1290 0794 0102 8494"));
ok($iban->is_valid("BG80 BNBG 9661 1020 3456 78"));
ok($iban->is_valid("DK50 0040 0440 1162 43"));
ok($iban->is_valid("DE89 3704 0044 0532 0130 00"));
ok($iban->is_valid("EE38 2200 2210 2014 5685"));
ok($iban->is_valid("FI21 1234 5600 0007 85"));
ok($iban->is_valid("FO97 5432 0388 8999 44"));
ok($iban->is_valid("FR14 2004 1010 0505 0001 3M02 606"));
ok($iban->is_valid("GI75 NWBK 0000 0000 7099 453"));
ok($iban->is_valid("GR16 0110 1250 0000 0001 2300 695"));
ok($iban->is_valid("GL56 0444 9876 5432 10 "));
ok($iban->is_valid("GB29 NWBK 6016 1331 9268 19"));
ok($iban->is_valid("IE29 AIBK 9311 5212 3456 78"));
ok($iban->is_valid("IS14 0159 2600 7654 5510 7303 39"));
ok($iban->is_valid("IT60 X054 2811 1010 0000 0123 456"));
ok($iban->is_valid("HR12 1001 0051 8630 0016 0"));
ok($iban->is_valid("LV80 BANK 0000 4351 9500 1"));
ok($iban->is_valid("LT12 1000 0111 0100 1000"));
ok($iban->is_valid("LI21 0881 0000 2324 013A A"));
ok($iban->is_valid("LU28 0019 4006 4475 0000"));
ok($iban->is_valid("MK07 3000 0000 0042 425"));
ok($iban->is_valid("MT84 MALT 0110 0001 2345 MTLC AST0 01S"));
ok($iban->is_valid("MU56 BOMM 0101 1234 5678 9101 0000 00"));
ok($iban->is_valid("MC93 2005 2222 1001 1223 3M44 555"));
ok($iban->is_valid("NL91 ABNA 0417 1643 00"));
ok($iban->is_valid("NO93 8601 1117 947"));
ok($iban->is_valid("AT61 1904 3002 3457 3201"));
ok($iban->is_valid("PL27 1140 2004 0000 3002 0135 5387"));
ok($iban->is_valid("PT50 0002 0123 1234 5678 9015 4"));
ok($iban->is_valid("RO49 AAAA 1B31 0075 9384 0000"));
ok($iban->is_valid("SM62 Y054 3219 8760 0444 5333 222"));
ok($iban->is_valid("CS73 2600 0560 1001 6113 79"));
ok($iban->is_valid("SE35 5000 0000 0549 1000 0003"));
ok($iban->is_valid("CH93 0076 2011 6238 5295 7"));
ok($iban->is_valid("SK31 1200 0000 1987 4263 7541"));
ok($iban->is_valid("SI56 1910 0000 0123 438"));
ok($iban->is_valid("ES91 2100 0418 4502 0005 1332"));
ok($iban->is_valid("CZ65 0800 0000 1920 0014 5399"));
ok($iban->is_valid("TN59 1420 7207 1007 0712 9648"));
ok($iban->is_valid("TR33 0006 1005 1978 6457 8413 26 "));
ok($iban->is_valid("HU42 1177 3016 1111 1018 0000 0000"));
ok($iban->is_valid("CY17 0020 0128 0000 0012 0052 7600"));
