use strict;
use warnings;
use lib 't/lib';
use Test::Bif;
use Test::Fatal;
use Test::More;

run_in_tempdir {

    isa_ok exception { bif(qw/show timesheet/) },
      'Bif::Error::UserRepoNotFound';

    bif(qw/init/);

    isa_ok exception { bif(qw/show timesheet junk/) },
      'Bif::Error::InvalidDate';

    isa_ok bif(qw/show timesheet/),            'Bif::OK::ShowTimesheet';
    isa_ok bif(qw/show timesheet 2014-01-01/), 'Bif::OK::ShowTimesheet';
    isa_ok bif(qw/show timesheet -d/),         'Bif::OK::ShowTimesheetDay';
    isa_ok bif(qw/show timesheet -w/),         'Bif::OK::ShowTimesheetWeek';
    isa_ok bif(qw/show timesheet -m/),         'Bif::OK::ShowTimesheetMonth';
    isa_ok bif(qw/show timesheet -y/),         'Bif::OK::ShowTimesheetYear';
};

done_testing();
