package App::bif::list::functions;
use strict;
use warnings;
use Bif::Mo;
use DBIx::ThinSQL qw/case count sum/;

our $VERSION = '0.1.5_7';
extends 'App::bif';

sub run {
    my $self = shift;
    my $opts = $self->opts;
    my $db   = $self->db;

    my $data = $db->xarrayrefs(
        select   => [ 'sm.name AS name', ],
        from     => 'sqlite_master sm',
        where    => { 'sm.tbl_name LIKE' => 'func%', 'sm.type' => 'table', },
        order_by => 'sm.name',
    );

    $self->start_pager( scalar @$data );

    print $self->render_table( ' l ', [qw/Function/], $data );

    return $self->ok('ListFunctions');
}

1;
__END__

=head1 NAME

=for bif-doc #devadmin

bif-list-functions - list functions present in database

=head1 VERSION

0.1.5_7 (2015-11-25)

=head1 SYNOPSIS

    bif list functions

=head1 DESCRIPTION

The B<bif-list-functions> command lists the functions present in the
database, along with their index and trigger counts.

=head1 SEE ALSO

L<bif>(1)

=head1 AUTHOR

Mark Lawrence E<lt>nomad@null.netE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright 2015 Mark Lawrence <nomad@null.net>

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 3 of the License, or (at your
option) any later version.

