package App::bif::show;
use strict;
use warnings;
use Bif::Mo;
use OptArgs 'class_optargs';

our $VERSION = '0.1.5_7';
extends 'App::bif';

sub run {
    my $self = shift;
    my $opts = $self->opts;
    my $info = $self->get_node( $self->uuid2id( $opts->{id} ) );

    my ( $class, $newopts ) =
      class_optargs( 'App::bif', 'show', $info->{kind}, $info->{id},
        { $opts->{log} ? ( log => undef ) : (), } );

    return $self->dispatch( $class, opts => $newopts );
}

1;
__END__

=head1 NAME

=for bif-doc #show

bif-show - display a node's current status

=head1 VERSION

0.1.5_7 (2015-11-25)

=head1 SYNOPSIS

    bif show ID [OPTIONS...]

=head1 DESCRIPTION

The B<bif-show> command displays a summary of a node's current status.
This command doesn't actually implement anything on its own. It simply
looks up the type of node and calls the appropriate B<bif-show-*> sub
command.

=head2 Arguments & Options

=over

=item ID

A node ID or a project PATH. Required.

=item --full, -f

Display a more verbose version of the current status.

=item --log, -l

Run the appropriate bif-log-* command after producing the summary to
get the current status and the history all together.

=item --uuid, -U

Lookup the node using ID as a UUID string instead of a node integer.

=back

=head1 SEE ALSO

L<bif>, L<bif-show-change>, L<bif-show-entity>, L<bif-show-hub>,...

=head1 AUTHOR

Mark Lawrence E<lt>nomad@null.netE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright 2013-2015 Mark Lawrence <nomad@null.net>

This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 3 of the License, or (at your
option) any later version.

