CREATE TABLE func_import_begin_change(
    parent_uuid VARCHAR(40),
    author VARCHAR(255),
    author_contact VARCHAR(255),
    author_contact_method VARCHAR(255),
    author_shortname VARCHAR(255),
    lang VARCHAR(8) NOT NULL,
    mtime INTEGER NOT NULL,
    mtimef INTEGER NOT NULL,
    mtimetz INTEGER NOT NULL
);


CREATE TRIGGER
    func_import_begin_change_bi_1
BEFORE INSERT ON
    func_import_begin_change
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.parent_uuid,
        NEW.author,
        NEW.author_contact,
        NEW.author_contact_method,
        NEW.author_shortname,
        NEW.mtime,
        NEW.mtimef,
        NEW.mtimetz,
        NEW.lang
    );

    INSERT INTO
        func_begin_change(
            id,
            parent_id,
            author,
            author_contact,
            author_contact_method,
            author_shortname,
            mtime,
            mtimef,
            mtimetz,
            lang
        )
    SELECT
        nextval('changes'),
        p.id,
        NEW.author,
        NEW.author_contact,
        NEW.author_contact_method,
        NEW.author_shortname,
        NEW.mtime,
        NEW.mtimef,
        NEW.mtimetz,
        NEW.lang
    FROM
        (SELECT 1)
    LEFT JOIN
        changes p
    ON
        p.uuid = NEW.parent_uuid
    ;

    SELECT RAISE(IGNORE);
END;
