CREATE TABLE entity_contact_method_deltas (
    id INTEGER NOT NULL PRIMARY KEY,
    change_id INTEGER NOT NULL,
    entity_contact_method_id INTEGER NOT NULL,
    new INTEGER,
    method VARCHAR,
    mvalue VARCHAR,
    UNIQUE(change_id,entity_contact_method_id), -- one change per change
    FOREIGN KEY(id) REFERENCES deltas(id),
    FOREIGN KEY(change_id) REFERENCES changes(id) ON DELETE CASCADE
    FOREIGN KEY(entity_contact_method_id) REFERENCES entity_contact_methods(id)
        ON DELETE CASCADE
);

CREATE TRIGGER
    entity_contact_method_deltas_ai_1
AFTER INSERT ON
    entity_contact_method_deltas
FOR EACH ROW
BEGIN

    SELECT debug(
        NEW.id,
        NEW.change_id,
        NEW.entity_contact_method_id,
        NEW.method,
        NEW.mvalue
    );

    UPDATE
        changes
    SET
        ucount = ucount + 1
    WHERE
        id = NEW.change_id
    ;


    INSERT OR IGNORE INTO
        entity_contact_methods_tomerge(entity_contact_method_id)
    VALUES
        (NEW.entity_contact_method_id)
    ;


    INSERT INTO
        entity_related_changes(
            change_id,
            entity_id
        )
    SELECT
        NEW.change_id,
        id.id
    FROM
        entity_contact_methods ecm
    INNER JOIN
        identities id
    ON
        id.id = ecm.entity_id
    WHERE
        ecm.id = NEW.entity_contact_method_id
    ;

    UPDATE
        entity_contact_methods_tomerge
    SET
        method = method + (NEW.method IS NOT NULL),
        mvalue = mvalue + (NEW.mvalue IS NOT NULL)
    WHERE
        entity_contact_method_id = NEW.entity_contact_method_id
    ;
END;


CREATE TRIGGER
    entity_contact_method_deltas_ad_1
AFTER DELETE ON
    entity_contact_method_deltas
FOR EACH ROW
BEGIN

    SELECT debug(
        OLD.change_id,
        OLD.entity_contact_method_id,
        OLD.method,
        OLD.mvalue
    );

    INSERT OR IGNORE INTO
        entity_contact_methods_tomerge(entity_contact_method_id)
    VALUES
        (OLD.entity_contact_method_id)
    ;

    UPDATE
        entity_contact_methods_tomerge
    SET
        method = method + (OLD.method IS NOT NULL),
        mvalue = mvalue + (OLD.mvalue IS NOT NULL)
    WHERE
        entity_contact_method_id = OLD.entity_contact_method_id
    ;

END;

