unit        class Async::Command::Multi:ver<0.0.2>:auth<Mark Devine (mark@markdevine.com)>;

use         Async::Command;

has         %.command is required;
has Promise @!promises;
has Int     $.timeout;
has         %!result;
has Promise $!master-promise;

constant    MULTI-FACTOR    = 16;

method sow () {
    $!master-promise = start {
        for %!command.keys -> $unique-id {
            push @!promises, start Async::Command.new(:command(|%!command{$unique-id}), :$!timeout, :$unique-id).run;
            if @!promises == MULTI-FACTOR {
                my @reorg-promises;
                await Promise.anyof(@!promises);
                for @!promises -> $promise {
                    if $promise.status ~~ /^Kept$/ {
                        %!result{$promise.result.unique-id} = $promise.result;
                    }
                    else {
                        @reorg-promises.append: $promise;
                    }
                }
                @!promises = @reorg-promises;
            }
        }
        my @results = await @!promises;
        for @results -> $result {
            %!result{$result.unique-id} = $result;
        }
    }
    self;
}

method reap () {
    await $!master-promise;
    return %!result;
}

=finish
