use 5.006;

use Config;
use ExtUtils::MakeMaker;

unless (-e "libev/ev_epoll.c") {
   print <<EOF;

***
*** ERROR: libev is missing or damaged. If you used a CVS check-out of EV,
*** you also have to check-out the "libev" module from the same CVS
*** repository into the EV dir (i.e. EV/libev from outside).
***

EOF
   exit 1;
}

print <<EOF;

*** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** ***


Welcome to EV configuration. If you are in a hurry, just press return here
and hope for the best. The defaults should usually do.

EOF

if (prompt ("Skip further questions and use defaults (y/n)?", "y") =~ /[yY]/) {
   $ENV{PERL_MM_USE_DEFAULT} = 1;
}

print <<EOF;

*** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** ***


POSIX optionally offers support for a monotonic clock source. EV
can take advantage of this clock source to detect time jumps
reliably. Unfortunately, some systems are bound to be broken, so you can
disable this here: you can completely disable the detection and use of
the monotonic clock by answering 'n' here. Support for this clock type
will otherwise be autodetected at both compile- and runtime.

EOF

$DEFINE .= " -DEV_USE_MONOTONIC=" . (0 + (prompt ("Enable optional support for CLOCK_MONOTONIC (y/n)?", "y") =~ /[yY]/));

print <<EOF;

*** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** ***


POSIX optionally offers support for a (potentially) high-resolution
realtime clock interface. In a good implementation, using it is faster
than the normal method of using gettimeofday. Unfortunately, this option
is also bound to be broken on some systems, so you can disable use and
probing of this feature altogether here. Otherwise support for this clock
type will be autodetected at compiletime.

EOF

$DEFINE .= " -DEV_USE_REALTIME=" . (0 + (prompt ("Prefer clock_gettime (CLOCK_REALTIME) over gettimeofday (y/n)?", "y") =~ /[yY]/));

print <<EOF;

*** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** ***


EV can use various backends with various portability issue. The select
backend is the most portable and makes for a good fallback, but it can be
limited to a low number of file descriptors and/or might not compile. If
you have problems with compiling ev_select.c, you might try to play around
with disabling it here, or forcing it to use the fd_set provided by your
OS, via the next question. I highly recommend keeping it in.

EOF

if (prompt ("Enable select backend (y/n)?", "y") =~ /[yY]/) {
   $DEFINE .= " -DEV_USE_SELECT=1";

   print <<EOF;

*** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** ***


The select backend can operate in two modes. One uses the system-provided
fd_set and is usually limited to 1024 file descriptors (64 on windows),
the other requires your header files to define NFDBITS and declare a
suitable fd_mask type. If you run into problems compiling ev_select.c, you
can try forcing the use of the system fd_set here.

EOF

   if (prompt ("Force use of system fd_set for select backend (y/n)?", "n") =~ /[yY]/) {
      $DEFINE .= " -DEV_SELECT_USE_FD_SET";
   } 
} else {
   $DEFINE .= " -DEV_USE_SELECT=0";
} 

print <<EOF;

*** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** ***


The second very portable backend is poll(2). It does not exist on windows
and various versions of Mac OS X (and on the other versions it simply
doesn't work), but works basically everywhere else. It is recommended to use
the default here unless you run into compile problems in ev_poll.c.

EOF

$DEFINE .= " -DEV_USE_POLL=" . (0 + (prompt ("Enable poll backend (y/n)?", (-e "/usr/include/poll.h") ? "y" : "n") =~ /[yY]/));

print <<EOF;

*** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** ***


Select and poll make it hard to write efficient servers, especially if the
number of active connections is much lower than the watched ones. GNU/Linux
systems have a more scalable method called "epoll", which EV can use. For
this to work, both your kernel and glibc have to support epoll, but if you
can compile it, the detection will be done at runtime, and EV will safely
fall back to using select when epoll isn't available. If unsure, accept
the default.

EOF

$DEFINE .= " -DEV_USE_EPOLL=" . (0 + (prompt ("Enable epoll backend (y/n)?", (-e "/usr/include/sys/epoll.h") ? "y" : "n") =~ /[yY]/));

print <<EOF;

*** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** ***


Similarly to the epoll backend above, EV can take advantage of kqueue on
many BSD systems. Support for kqueue will be detected at runtime, with a
safe fallback to other methods when it cannot be used.

Note that kqueue is broken on most operating systems, so it defaults to
'n' on everything but netbsd. Here is what we know:

NetBSD:  working in at least 3.1. Yeah! :)
FreeBSD: broken on at least 6.2-STABLE,
         sockets and pipes *might* work, ptys definitely don't.
OpenBSD: reports indicate that it likely doesn't work
         (similar problems as on FreeBSD).
OS X:    completely, utterly broken on at least <= 10.5.

EOF

my $can_kqueue = $^O =~ /netbsd/i && -e "/usr/include/sys/event.h";

$DEFINE .= " -DEV_USE_KQUEUE=" . (0 + (prompt ("Enable kqueue backend (y/n)?", $can_kqueue ? "y" : "n") =~ /[yY]/));

print <<EOF;

*** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** ***


Similarly to the kqueue backend above, EV can take advantage of the
solaris 10 event port interface. Support for event ports will be detected
at runtime, with a safe fallback to other methods when it cannot be used.

EOF

$DEFINE .= " -DEV_USE_PORT=" . (0 + (prompt ("Enable event port backend (y/n)?", (-e "/usr/include/sys/port.h") ? "y" : "n") =~ /[yY]/));

print <<EOF;

*** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** ***


EV needs the functions pthread_atfork and clock_gettime. On most systems
you need some special libraries for this (such as -lrt and -lpthread). You
can specify additional libraries to provide these calls (and any other
required by EV) now, or accept the default.

EOF

$SOLARIS_LIBS = $^O =~ /solaris/ ? " -lsocket -lnsl" : "";

$LIBS = prompt "Extra libraries for pthread_atfork and clock_gettime?", "-lpthread -lrt$SOLARIS_LIBS";


print <<EOF;

*** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** ***


A backend of a different kind is the Linux inotify(7) interface, which can
be used to speed up (and reduce resource consumption) of stat watchers. If
you have it, it is usually a good idea to enable it.

EOF

my $can_inotify = -e "/usr/include/sys/inotify.h";

$DEFINE .= " -DEV_USE_INOTIFY=" . (0 + (prompt ("Enable inotify support (y/n)?", $can_inotify ? "y" : "n") =~ /[yY]/));

print <<EOF;

*** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** *** ***


EOF

my @anyevent = eval { require AnyEvent; $AnyEvent::VERSION < 2.6 } ? (AnyEvent => 2.6) : ();

WriteMakefile(
    dist	=> {
	            PREOP	=> 'pod2text EV.pm | tee README >$(DISTVNAME)/README; chmod -R u=rwX,go=rX . ;',
	            COMPRESS	=> 'gzip -9v',
	            SUFFIX	=> '.gz',
	           },
    depend => {
       "EV.c" => "EV/EVAPI.h "
               . "libev/ev.c libev/ev.h libev/ev_epoll.c libev/ev_select.c libev/ev_kqueue.c libev/ev_poll.c "
               . "libev/event.h libev/event.c libev/ev_vars.h libev/ev_wrap.h",
    },
    INC       => "-Ilibev",
    DEFINE    => "$DEFINE",
    NAME => "EV",
    LIBS => [$LIBS],
    PREREQ_PM => {
       @anyevent,
    },
    VERSION_FROM => "EV.pm",
    PM           => {
    		    'EV.pm'		=> '$(INST_LIBDIR)/EV.pm',
    		    'EV/EVAPI.h'	=> '$(INST_LIBDIR)/EV/EVAPI.h',
    		    'EV/MakeMaker.pm'	=> '$(INST_LIBDIR)/EV/MakeMaker.pm',
    		    'libev/ev.h'	=> '$(INST_LIBDIR)/EV/ev.h',
                 },
);


