(MODULE XWS5)
(INCLUDE "xlibTYPES.sch")
(DEFINE-C-EXTERNAL
  (XCREATECOLORMAP* POINTER UNSIGNED POINTER INT)
  UNSIGNED
  "XCreateColormap")
(DEFINE
  (XCREATECOLORMAP DPY W VISUAL ALLOC)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (W W)
      (VISUAL (CHK-VISUALP VISUAL))
      (ALLOC ALLOC)
      (RETURN-VALUE (XCREATECOLORMAP* DPY W VISUAL ALLOC)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL
  (XCOPYCOLORMAPANDFREE* POINTER UNSIGNED)
  UNSIGNED
  "XCopyColormapAndFree")
(DEFINE
  (XCOPYCOLORMAPANDFREE DPY SRC_CMAP)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (SRC_CMAP SRC_CMAP)
      (RETURN-VALUE (XCOPYCOLORMAPANDFREE* DPY SRC_CMAP)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL
  (XSETWINDOWCOLORMAP* POINTER UNSIGNED UNSIGNED)
  VOID
  "XSetWindowColormap")
(DEFINE
  (XSETWINDOWCOLORMAP DPY W COLORMAP)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (W W)
      (COLORMAP COLORMAP)
      (RETURN-VALUE (BEGIN (XSETWINDOWCOLORMAP* DPY W COLORMAP) #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL (XFREECOLORMAP* POINTER UNSIGNED) VOID "XFreeColormap")
(DEFINE
  (XFREECOLORMAP DPY CMAP)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (CMAP CMAP)
      (RETURN-VALUE (BEGIN (XFREECOLORMAP* DPY CMAP) #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL (XALLOCCOLOR* POINTER UNSIGNED POINTER) INT "XAllocColor")
(DEFINE
  (XALLOCCOLOR DPY CMAP DEF)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (CMAP CMAP)
      (DEF (CHK-XCOLORP DEF))
      (RETURN-VALUE (XALLOCCOLOR* DPY CMAP DEF)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL
  (XALLOCNAMEDCOLOR* POINTER UNSIGNED POINTER POINTER POINTER)
  INT
  "XAllocNamedColor")
(DEFINE
  (XALLOCNAMEDCOLOR DPY CMAP COLORNAME)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (CMAP CMAP)
      (COLORNAME
        (IF
          (STRING? COLORNAME)
          COLORNAME
          (ERROR 'CHK-STRING "Argument is incorrect type: ~s" COLORNAME)))
      (HARD_DEF (MAKE-STRING 12))
      (EXACT_DEF (MAKE-STRING 12))
      (RETURN-VALUE (XALLOCNAMEDCOLOR* DPY CMAP COLORNAME HARD_DEF EXACT_DEF)))
    (LIST
      RETURN-VALUE
      (CONS 'XCOLORP HARD_DEF)
      (CONS 'XCOLORP EXACT_DEF))))
(DEFINE-C-EXTERNAL
  (XLOOKUPCOLOR* POINTER UNSIGNED POINTER POINTER POINTER)
  INT
  "XLookupColor")
(DEFINE
  (XLOOKUPCOLOR DPY CMAP SPEC)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (CMAP CMAP)
      (SPEC
        (IF
          (STRING? SPEC)
          SPEC
          (ERROR 'CHK-STRING "Argument is incorrect type: ~s" SPEC)))
      (DEF (MAKE-STRING 12))
      (SCR (MAKE-STRING 12))
      (RETURN-VALUE (XLOOKUPCOLOR* DPY CMAP SPEC DEF SCR)))
    (LIST RETURN-VALUE (CONS 'XCOLORP DEF) (CONS 'XCOLORP SCR))))
(DEFINE-C-EXTERNAL
  (XALLOCCOLORCELLS* POINTER UNSIGNED INT POINTER UNSIGNED POINTER UNSIGNED)
  INT
  "XAllocColorCells")
(DEFINE
  (XALLOCCOLORCELLS DPY CMAP CONTIG MASKS NPLANES PIXELS NCOLORS)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (CMAP CMAP)
      (CONTIG CONTIG)
      (MASKS (CHK-UNSIGNEDAP MASKS))
      (NPLANES NPLANES)
      (PIXELS (CHK-UNSIGNEDAP PIXELS))
      (NCOLORS NCOLORS)
      (RETURN-VALUE
        (XALLOCCOLORCELLS* DPY CMAP CONTIG MASKS NPLANES PIXELS NCOLORS)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL
  (XALLOCCOLORPLANES*
    POINTER
    UNSIGNED
    INT
    POINTER
    INT
    INT
    INT
    INT
    POINTER
    POINTER
    POINTER)
  INT
  "XAllocColorPlanes")
(DEFINE
  (XALLOCCOLORPLANES DPY CMAP CONTIG PIXELS NCOLORS NREDS NGREENS NBLUES)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (CMAP CMAP)
      (CONTIG CONTIG)
      (PIXELS (CHK-UNSIGNEDAP PIXELS))
      (NCOLORS NCOLORS)
      (NREDS NREDS)
      (NGREENS NGREENS)
      (NBLUES NBLUES)
      (RMASK (MAKE-STRING 4))
      (GMASK (MAKE-STRING 4))
      (BMASK (MAKE-STRING 4))
      (RETURN-VALUE
        (XALLOCCOLORPLANES*
          DPY
          CMAP
          CONTIG
          PIXELS
          NCOLORS
          NREDS
          NGREENS
          NBLUES
          RMASK
          GMASK
          BMASK)))
    (LIST
      RETURN-VALUE
      (C-UNSIGNED-REF RMASK 0)
      (C-UNSIGNED-REF GMASK 0)
      (C-UNSIGNED-REF BMASK 0))))
(DEFINE-C-EXTERNAL
  (XSTORECOLORS* POINTER UNSIGNED POINTER INT)
  VOID
  "XStoreColors")
(DEFINE
  (XSTORECOLORS DPY CMAP DEFS NCOLORS)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (CMAP CMAP)
      (DEFS (CHK-XCOLORAP DEFS))
      (NCOLORS NCOLORS)
      (RETURN-VALUE (BEGIN (XSTORECOLORS* DPY CMAP DEFS NCOLORS) #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL (XSTORECOLOR* POINTER UNSIGNED POINTER) VOID "XStoreColor")
(DEFINE
  (XSTORECOLOR DPY CMAP DEF)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (CMAP CMAP)
      (DEF (CHK-XCOLORP DEF))
      (RETURN-VALUE (BEGIN (XSTORECOLOR* DPY CMAP DEF) #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL
  (XSTORENAMEDCOLOR* POINTER UNSIGNED POINTER UNSIGNED INT)
  VOID
  "XStoreNamedColor")
(DEFINE
  (XSTORENAMEDCOLOR DPY CMAP NAME PIXEL FLAGS)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (CMAP CMAP)
      (NAME
        (IF
          (STRING? NAME)
          NAME
          (ERROR 'CHK-STRING "Argument is incorrect type: ~s" NAME)))
      (PIXEL PIXEL)
      (FLAGS FLAGS)
      (RETURN-VALUE (BEGIN (XSTORENAMEDCOLOR* DPY CMAP NAME PIXEL FLAGS) #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL
  (XFREECOLORS* POINTER UNSIGNED POINTER INT UNSIGNED)
  VOID
  "XFreeColors")
(DEFINE
  (XFREECOLORS DPY CMAP PIXELS NPIXELS PLANES)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (CMAP CMAP)
      (PIXELS (CHK-UNSIGNEDAP PIXELS))
      (NPIXELS NPIXELS)
      (PLANES PLANES)
      (RETURN-VALUE (BEGIN (XFREECOLORS* DPY CMAP PIXELS NPIXELS PLANES) #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL (XQUERYCOLOR* POINTER UNSIGNED POINTER) VOID "XQueryColor")
(DEFINE
  (XQUERYCOLOR DPY CMAP DEF)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (CMAP CMAP)
      (DEF (CHK-XCOLORP DEF))
      (RETURN-VALUE (BEGIN (XQUERYCOLOR* DPY CMAP DEF) #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL
  (XQUERYCOLORS* POINTER UNSIGNED POINTER INT)
  VOID
  "XQueryColors")
(DEFINE
  (XQUERYCOLORS DPY CMAP DEFS NCOLORS)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (CMAP CMAP)
      (DEFS (CHK-XCOLORAP DEFS))
      (NCOLORS NCOLORS)
      (RETURN-VALUE (BEGIN (XQUERYCOLORS* DPY CMAP DEFS NCOLORS) #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL
  (XCREATEPIXMAP* POINTER UNSIGNED UNSIGNED UNSIGNED UNSIGNED)
  UNSIGNED
  "XCreatePixmap")
(DEFINE
  (XCREATEPIXMAP DPY D WIDTH HEIGHT DEPTH)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (D D)
      (WIDTH WIDTH)
      (HEIGHT HEIGHT)
      (DEPTH DEPTH)
      (RETURN-VALUE (XCREATEPIXMAP* DPY D WIDTH HEIGHT DEPTH)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL (XFREEPIXMAP* POINTER UNSIGNED) VOID "XFreePixmap")
(DEFINE
  (XFREEPIXMAP DPY PIXMAP)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (PIXMAP PIXMAP)
      (RETURN-VALUE (BEGIN (XFREEPIXMAP* DPY PIXMAP) #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL
  (XCREATEGC* POINTER UNSIGNED UNSIGNED POINTER)
  POINTER
  "XCreateGC")
(DEFINE
  (XCREATEGC DPY D VALUEMASK VALUES)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (D D)
      (VALUEMASK VALUEMASK)
      (VALUES (CHK-XGCVALUESP VALUES))
      (RETURN-VALUE (CONS 'GC (XCREATEGC* DPY D VALUEMASK VALUES))))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL (XCOPYGC* POINTER POINTER UNSIGNED POINTER) VOID "XCopyGC")
(DEFINE
  (XCOPYGC DPY SRCGC MASK DESTGC)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (SRCGC (CHK-GC SRCGC))
      (MASK MASK)
      (DESTGC (CHK-GC DESTGC))
      (RETURN-VALUE (BEGIN (XCOPYGC* DPY SRCGC MASK DESTGC) #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL
  (XCHANGEGC* POINTER POINTER UNSIGNED POINTER)
  VOID
  "XChangeGC")
(DEFINE
  (XCHANGEGC DPY GC VALUEMASK VALUES)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (GC (CHK-GC GC))
      (VALUEMASK VALUEMASK)
      (VALUES (CHK-XGCVALUESP VALUES))
      (RETURN-VALUE (BEGIN (XCHANGEGC* DPY GC VALUEMASK VALUES) #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL (XFREEGC* POINTER POINTER) VOID "XFreeGC")
(DEFINE
  (XFREEGC DPY GC)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (GC (CHK-GC GC))
      (RETURN-VALUE (BEGIN (XFREEGC* DPY GC) #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL (XGCONTEXTFROMGC* POINTER) UNSIGNED "XGContextFromGC")
(DEFINE
  (XGCONTEXTFROMGC GC)
  (LET* ((GC (CHK-GC GC)) (RETURN-VALUE (XGCONTEXTFROMGC* GC))) RETURN-VALUE))
(DEFINE-C-EXTERNAL
  (XSETSTATE* POINTER POINTER UNSIGNED UNSIGNED INT UNSIGNED)
  VOID
  "XSetState")
(DEFINE
  (XSETSTATE DPY GC FOREGROUND BACKGROUND FUNCTION PLANEMASK)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (GC (CHK-GC GC))
      (FOREGROUND FOREGROUND)
      (BACKGROUND BACKGROUND)
      (FUNCTION FUNCTION)
      (PLANEMASK PLANEMASK)
      (RETURN-VALUE
        (BEGIN (XSETSTATE* DPY GC FOREGROUND BACKGROUND FUNCTION PLANEMASK) #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL
  (XSETFOREGROUND* POINTER POINTER UNSIGNED)
  VOID
  "XSetForeground")
(DEFINE
  (XSETFOREGROUND DPY GC FOREGROUND)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (GC (CHK-GC GC))
      (FOREGROUND FOREGROUND)
      (RETURN-VALUE (BEGIN (XSETFOREGROUND* DPY GC FOREGROUND) #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL
  (XSETBACKGROUND* POINTER POINTER UNSIGNED)
  VOID
  "XSetBackground")
(DEFINE
  (XSETBACKGROUND DPY GC BACKGROUND)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (GC (CHK-GC GC))
      (BACKGROUND BACKGROUND)
      (RETURN-VALUE (BEGIN (XSETBACKGROUND* DPY GC BACKGROUND) #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL (XSETFUNCTION* POINTER POINTER INT) VOID "XSetFunction")
(DEFINE
  (XSETFUNCTION DPY GC FUNCTION)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (GC (CHK-GC GC))
      (FUNCTION FUNCTION)
      (RETURN-VALUE (BEGIN (XSETFUNCTION* DPY GC FUNCTION) #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL
  (XSETPLANEMASK* POINTER POINTER UNSIGNED)
  VOID
  "XSetPlaneMask")
(DEFINE
  (XSETPLANEMASK DPY GC PLANEMASK)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (GC (CHK-GC GC))
      (PLANEMASK PLANEMASK)
      (RETURN-VALUE (BEGIN (XSETPLANEMASK* DPY GC PLANEMASK) #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL
  (XSETLINEATTRIBUTES* POINTER POINTER UNSIGNED INT INT INT)
  VOID
  "XSetLineAttributes")
(DEFINE
  (XSETLINEATTRIBUTES DPY GC LINEWIDTH LINESTYLE CAPSTYLE JOINSTYLE)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (GC (CHK-GC GC))
      (LINEWIDTH LINEWIDTH)
      (LINESTYLE LINESTYLE)
      (CAPSTYLE CAPSTYLE)
      (JOINSTYLE JOINSTYLE)
      (RETURN-VALUE
        (BEGIN
          (XSETLINEATTRIBUTES* DPY GC LINEWIDTH LINESTYLE CAPSTYLE JOINSTYLE)
          #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL
  (XSETDASHES* POINTER POINTER INT POINTER INT)
  VOID
  "XSetDashes")
(DEFINE
  (XSETDASHES DPY GC DASH_OFFSET LIST N)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (GC (CHK-GC GC))
      (DASH_OFFSET DASH_OFFSET)
      (LIST (CHK-CHARAP LIST))
      (N N)
      (RETURN-VALUE (BEGIN (XSETDASHES* DPY GC DASH_OFFSET LIST N) #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL (XSETFILLSTYLE* POINTER POINTER INT) VOID "XSetFillStyle")
(DEFINE
  (XSETFILLSTYLE DPY GC FILL_STYLE)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (GC (CHK-GC GC))
      (FILL_STYLE FILL_STYLE)
      (RETURN-VALUE (BEGIN (XSETFILLSTYLE* DPY GC FILL_STYLE) #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL (XSETFILLRULE* POINTER POINTER INT) VOID "XSetFillRule")
(DEFINE
  (XSETFILLRULE DPY GC FILL_RULE)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (GC (CHK-GC GC))
      (FILL_RULE FILL_RULE)
      (RETURN-VALUE (BEGIN (XSETFILLRULE* DPY GC FILL_RULE) #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL
  (XQUERYBESTSIZE* POINTER INT UNSIGNED UNSIGNED UNSIGNED POINTER POINTER)
  INT
  "XQueryBestSize")
(DEFINE
  (XQUERYBESTSIZE DPY CLASS DRAWABLE WIDTH HEIGHT)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (CLASS CLASS)
      (DRAWABLE DRAWABLE)
      (WIDTH WIDTH)
      (HEIGHT HEIGHT)
      (RET_WIDTH (MAKE-STRING 4))
      (RET_HEIGHT (MAKE-STRING 4))
      (RETURN-VALUE
        (XQUERYBESTSIZE* DPY CLASS DRAWABLE WIDTH HEIGHT RET_WIDTH RET_HEIGHT)))
    (LIST
      RETURN-VALUE
      (C-UNSIGNED-REF RET_WIDTH 0)
      (C-UNSIGNED-REF RET_HEIGHT 0))))
(DEFINE-C-EXTERNAL
  (XQUERYBESTTILE* POINTER UNSIGNED UNSIGNED UNSIGNED POINTER POINTER)
  INT
  "XQueryBestTile")
(DEFINE
  (XQUERYBESTTILE DPY DRAWABLE WIDTH HEIGHT)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (DRAWABLE DRAWABLE)
      (WIDTH WIDTH)
      (HEIGHT HEIGHT)
      (RET_WIDTH (MAKE-STRING 4))
      (RET_HEIGHT (MAKE-STRING 4))
      (RETURN-VALUE
        (XQUERYBESTTILE* DPY DRAWABLE WIDTH HEIGHT RET_WIDTH RET_HEIGHT)))
    (LIST
      RETURN-VALUE
      (C-UNSIGNED-REF RET_WIDTH 0)
      (C-UNSIGNED-REF RET_HEIGHT 0))))
(DEFINE-C-EXTERNAL
  (XQUERYBESTSTIPPLE* POINTER UNSIGNED UNSIGNED UNSIGNED POINTER POINTER)
  INT
  "XQueryBestStipple")
(DEFINE
  (XQUERYBESTSTIPPLE DPY DRAWABLE WIDTH HEIGHT)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (DRAWABLE DRAWABLE)
      (WIDTH WIDTH)
      (HEIGHT HEIGHT)
      (RET_WIDTH (MAKE-STRING 4))
      (RET_HEIGHT (MAKE-STRING 4))
      (RETURN-VALUE
        (XQUERYBESTSTIPPLE* DPY DRAWABLE WIDTH HEIGHT RET_WIDTH RET_HEIGHT)))
    (LIST
      RETURN-VALUE
      (C-UNSIGNED-REF RET_WIDTH 0)
      (C-UNSIGNED-REF RET_HEIGHT 0))))
(DEFINE-C-EXTERNAL (XSETTILE* POINTER POINTER UNSIGNED) VOID "XSetTile")
(DEFINE
  (XSETTILE DPY GC TILE)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (GC (CHK-GC GC))
      (TILE TILE)
      (RETURN-VALUE (BEGIN (XSETTILE* DPY GC TILE) #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL (XSETSTIPPLE* POINTER POINTER UNSIGNED) VOID "XSetStipple")
(DEFINE
  (XSETSTIPPLE DPY GC STIPPLE)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (GC (CHK-GC GC))
      (STIPPLE STIPPLE)
      (RETURN-VALUE (BEGIN (XSETSTIPPLE* DPY GC STIPPLE) #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL (XSETTSORIGIN* POINTER POINTER INT INT) VOID "XSetTSOrigin")
(DEFINE
  (XSETTSORIGIN DPY GC X Y)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (GC (CHK-GC GC))
      (X X)
      (Y Y)
      (RETURN-VALUE (BEGIN (XSETTSORIGIN* DPY GC X Y) #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL (XSETFONT* POINTER POINTER UNSIGNED) VOID "XSetFont")
(DEFINE
  (XSETFONT DPY GC FONT)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (GC (CHK-GC GC))
      (FONT FONT)
      (RETURN-VALUE (BEGIN (XSETFONT* DPY GC FONT) #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL
  (XSETCLIPORIGIN* POINTER POINTER INT INT)
  VOID
  "XSetClipOrigin")
(DEFINE
  (XSETCLIPORIGIN DPY GC XORIG YORIG)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (GC (CHK-GC GC))
      (XORIG XORIG)
      (YORIG YORIG)
      (RETURN-VALUE (BEGIN (XSETCLIPORIGIN* DPY GC XORIG YORIG) #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL (XSETCLIPMASK* POINTER POINTER UNSIGNED) VOID "XSetClipMask")
(DEFINE
  (XSETCLIPMASK DPY GC MASK)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (GC (CHK-GC GC))
      (MASK MASK)
      (RETURN-VALUE (BEGIN (XSETCLIPMASK* DPY GC MASK) #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL
  (XSETCLIPRECTANGLES* POINTER POINTER INT INT POINTER INT INT)
  VOID
  "XSetClipRectangles")
(DEFINE
  (XSETCLIPRECTANGLES DPY GC CLIP_X_ORIGIN CLIP_Y_ORIGIN RECTANGLES N ORDERING)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (GC (CHK-GC GC))
      (CLIP_X_ORIGIN CLIP_X_ORIGIN)
      (CLIP_Y_ORIGIN CLIP_Y_ORIGIN)
      (RECTANGLES (CHK-XRECTANGLEAP RECTANGLES))
      (N N)
      (ORDERING ORDERING)
      (RETURN-VALUE
        (BEGIN
          (XSETCLIPRECTANGLES*
            DPY
            GC
            CLIP_X_ORIGIN
            CLIP_Y_ORIGIN
            RECTANGLES
            N
            ORDERING)
          #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL (XSETARCMODE* POINTER POINTER INT) VOID "XSetArcMode")
(DEFINE
  (XSETARCMODE DPY GC ARC_MODE)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (GC (CHK-GC GC))
      (ARC_MODE ARC_MODE)
      (RETURN-VALUE (BEGIN (XSETARCMODE* DPY GC ARC_MODE) #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL
  (XSETSUBWINDOWMODE* POINTER POINTER INT)
  VOID
  "XSetSubwindowMode")
(DEFINE
  (XSETSUBWINDOWMODE DPY GC SUBWINDOW_MODE)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (GC (CHK-GC GC))
      (SUBWINDOW_MODE SUBWINDOW_MODE)
      (RETURN-VALUE (BEGIN (XSETSUBWINDOWMODE* DPY GC SUBWINDOW_MODE) #F)))
    RETURN-VALUE))
(DEFINE-C-EXTERNAL
  (XSETGRAPHICSEXPOSURES* POINTER POINTER INT)
  VOID
  "XSetGraphicsExposures")
(DEFINE
  (XSETGRAPHICSEXPOSURES DPY GC GRAPHICS_EXPOSURES)
  (LET*
    ((DPY (CHK-DISPLAYP DPY))
      (GC (CHK-GC GC))
      (GRAPHICS_EXPOSURES GRAPHICS_EXPOSURES)
      (RETURN-VALUE
        (BEGIN (XSETGRAPHICSEXPOSURES* DPY GC GRAPHICS_EXPOSURES) #F)))
    RETURN-VALUE))
