'\" -*- tcl -*- doctools manpage
'\"
'\" Generated from ../tcllib/modules/textutil/expander.man by mpexpand with fmt.nroff
'\"
.so man.macros
.TH "expander" n 1.0.1 textutil "Text expansion and template processing"
.BS
.SH NAME
expander \- Procedures to process templates and expand text.
.SH "SYNOPSIS"
package require \fBTcl 8.2\fR
.sp
package require \fBtextutil::expander ?1.0.1?\fR
.sp
\fB::textutil::expander\fR \fIexpanderName\fR\fR
.sp
\fIexpanderName\fR \fBcappend\fR \fItext\fR\fR
.sp
\fIexpanderName\fR \fBcget\fR \fIvarname\fR\fR
.sp
\fIexpanderName\fR \fBcis\fR \fIcname\fR\fR
.sp
\fIexpanderName\fR \fBcname\fR\fR
.sp
\fIexpanderName\fR \fBcpop\fR \fIcname\fR\fR
.sp
\fIexpanderName\fR \fBcpush\fR \fIcname\fR\fR
.sp
\fIexpanderName\fR \fBcset\fR \fIvarname\fR \fIvalue\fR\fR
.sp
\fIexpanderName\fR \fBcvar\fR \fIvarname\fR\fR
.sp
\fIexpanderName\fR \fBerrmode\fR \fInewErrmode\fR\fR
.sp
\fIexpanderName\fR \fBevalcmd\fR ?\fInewEvalCmd\fR?\fR
.sp
\fIexpanderName\fR \fBexpand\fR \fIstring\fR ?\fIbrackets\fR?\fR
.sp
\fIexpanderName\fR \fBlb\fR ?\fInewbracket\fR?\fR
.sp
\fIexpanderName\fR \fBrb\fR ?\fInewbracket\fR?\fR
.sp
\fIexpanderName\fR \fBreset\fR\fR
.sp
\fIexpanderName\fR \fBsetbrackets\fR \fIlbrack rbrack\fR\fR
.sp
\fIexpanderName\fR \fBtextcmd\fR ?\fInewTextCmd\fR?\fR
.sp
.BE
.SH "DESCRIPTION"
'\" .IP \(bu <== bullet
.PP
The Tcl \fBsubst\fR command is often used to support a kind of
template processing. Given a string with embedded variables or
function calls, \fBsubst\fR will interpolate the variable and function
values, returning the new string:
.PP
.nf
 % set greeting "Howdy"
 Howdy
 % proc place {} {return "World"}
 % subst {$greeting, [place]!}
 Howdy, World!
 %
.fi
.PP
By defining a suitable set of Tcl commands, \fBsubst\fR can be used to
implement a markup language similar to HTML.
.PP
The \fBsubst\fR command is efficient, but it has three drawbacks for
this kind of template processing:
.IP \(bu
There's no way to identify and process the plain text between two
embedded Tcl commands; that makes it difficult to handle plain text in
a context-sensitive way.
.IP \(bu
Embedded commands are necessarily bracketed by \fB[\fR and
\fB]\fR; it's convenient to be able to choose different brackets
in special cases.  Someone producing web pages that include a large
quantity of Tcl code examples might easily prefer to use \fB<<\fR
and \fB>>\fR as the embedded code delimiters instead.
.IP \(bu
There's no easy way to handle incremental input, as one might wish to
do when reading data from a socket.
.PP
At present, expander solves the first two problems; eventually it will
solve the third problem as well.
.PP
The following section describes the command API to the expander; this
is followed by tutorial section.
.SH "EXPANDER API"
.PP
The \fBtextutil::expander\fR package provides only one command,
described below. The rest of the section is taken by a description of
the methods for the exapnder objects created by this command.
.TP
\fB::textutil::expander\fR \fIexpanderName\fR\fR
The command creates a new expander object with an associated Tcl
command whose name is \fIexpanderName\fR. This command may be used to
invoke various operations on the graph. If the \fIexpanderName\fR is
not fully qualified it is interpreted as relative to the current
namespace.  The command has the following general form:
.nf
 \fIexpanderName\fR option ?\fIarg arg ...\fR?
.fi
\fIOption\fR and the \fIarg\fRs determine the exact behavior of the
command.
.PP
The following commands are possible for expander objects:
.TP
\fIexpanderName\fR \fBcappend\fR \fItext\fR\fR
Appends a string to the output in the current context.  This command
should rarely be used by macros or application code.
.TP
\fIexpanderName\fR \fBcget\fR \fIvarname\fR\fR
Retrieves the value of variable \fIvarname\fR, defined in the current
context.
.TP
\fIexpanderName\fR \fBcis\fR \fIcname\fR\fR
Determines whether or not the name of the current context is
\fIcname\fR.
.TP
\fIexpanderName\fR \fBcname\fR\fR
Returns the name of the current context.
.TP
\fIexpanderName\fR \fBcpop\fR \fIcname\fR\fR
Pops a context from the context stack, returning all accumulated
output in that context.  The context must be named \fIcname\fR, or an
error results.
.TP
\fIexpanderName\fR \fBcpush\fR \fIcname\fR\fR
Pushes a context named \fIcname\fR onto the context stack.  The
context must be popped by \fBcpop\fR before expansion ends or an
error results.
.TP
\fIexpanderName\fR \fBcset\fR \fIvarname\fR \fIvalue\fR\fR
Sets variable \fIvarname\fR to \fIvalue\fR in the current context.
.TP
\fIexpanderName\fR \fBcvar\fR \fIvarname\fR\fR
Retrieves the internal variable name of context variable
\fIvarname\fR; this allows the variable to be passed to commands like
\fBlappend\fR.
.TP
\fIexpanderName\fR \fBerrmode\fR \fInewErrmode\fR\fR
Sets the macro expansion error mode to one of \fBnothing\fR,
\fBmacro\fR, \fBerror\fR, or \fBfail\fR; the default value is
\fBfail\fR.  The value determines what the expander does if an
error is detected during expansion of a macro.
.RS
.IP \(bu
If the error mode is \fBfail\fR, the error propagates normally and
can be caught or ignored by the application.
.IP \(bu
If the error mode is \fBerror\fR, the macro expands into a detailed
error message, and expansion continues.
.IP \(bu
If the error mode is \fBmacro\fR, the macro expands to itself; that
is, it is passed along to the output unchanged.
.IP \(bu
If the error mode is \fBnothing\fR, the macro expands to the empty
string, and is effectively ignored.
.RE
.TP
\fIexpanderName\fR \fBevalcmd\fR ?\fInewEvalCmd\fR?\fR
Returns the current evaluation command, which defaults to
\fBuplevel #0\fR.  If specified, \fInewEvalCmd\fR will be saved for
future use and then returned; it must be a Tcl command expecting one
additional argument: the macro to evaluate.
.TP
\fIexpanderName\fR \fBexpand\fR \fIstring\fR ?\fIbrackets\fR?\fR
Expands the input string, replacing embedded macros with their
expanded values, and returns the expanded string.
.sp
If \fIbrackets\fR is given, it must be a list of two strings; the
items will be used as the left and right macro expansion bracket
sequences for this expansion only.
.TP
\fIexpanderName\fR \fBlb\fR ?\fInewbracket\fR?\fR
Returns the current value of the right macro expansion bracket; this
is for use as or within a macro, when the bracket needs to be included
in the output text.  If \fInewbracket\fR is specified, it becomes the
new bracket, and is returned.
.TP
\fIexpanderName\fR \fBrb\fR ?\fInewbracket\fR?\fR
Returns the current value of the right macro expansion bracket; this
is for use as or within a macro, when the bracket needs to be included
in the output text.  If \fInewbracket\fR is specified, it becomes the
new bracket, and is returned.
.TP
\fIexpanderName\fR \fBreset\fR\fR
Resets all expander settings to their initial values.  Unusual results
are likely if this command is called from within a call to
\fBexpand\fR.
.TP
\fIexpanderName\fR \fBsetbrackets\fR \fIlbrack rbrack\fR\fR
Sets the left and right macro expansion brackets.  This command is for
use as or within a macro, or to permanently change the bracket
definitions.  By default, the brackets are \fB[\fR and
\fB]\fR, but any non-empty string can be used; for example,
\fB<\fR and \fB>\fR or \fB(*\fR and \fB*)\fR or even
\fBHello,\fR and \fBWorld!\fR.
.TP
\fIexpanderName\fR \fBtextcmd\fR ?\fInewTextCmd\fR?\fR
Returns the current command for processing polain text, which defaults
to the empty string, meaning \fIidentity\fR. If specified,
\fInewTextCmd\fR will be saved for future use and then returned; it
must be a Tcl command expecting one additional argument: the text to
process. The expander object will this command for all plain text it
encounters, giving the user of the object the ability to process all
plain text in some standard way before writing it to the output. The
object expects that the command returns the processed plain text.
.sp
\fBNote\fR that the combination of "\fBtextcmd\fR \fIplaintext\fR"
is run through the \fIevalcmd\fR for the actual evaluation. In other
words, the \fItextcmd\fR is treated as a special macro implicitly
surrounding all plain text in the template.
.SH "TUTORIAL"
.PP
To begin, create an expander object:
.PP
.nf
 % package require expander
 1.0
 % ::expander::expander myexp
 ::myexp
 %
.fi
.PP
The created \fB::myexp\fR object can be used to expand text strings
containing embedded Tcl commands.  By default, embedded commands are
delimited by square brackets.  Note that expander doesn't attempt to
interpolate variables, since variables can be referenced by embedded
commands:
.PP
.nf
 % set greeting "Howdy"
 Howdy
 % proc place {} {return "World"}
 % ::myexp expand {[set greeting], [place]!}
 Howdy, World!
 %
.fi
.PP
\fBEmbedding Macros\fR
.PP
An expander macro is simply a Tcl script embedded within a text
string.  Expander evaluates the script in the global context, and
replaces it with its result string.  For example,
.PP
.nf
 % set greetings {Howdy Hi "What's up"}
 Howdy Hi "What's up"
 % ::myexp expand {There are many ways to say "Hello, World!":
 [set result {}
 foreach greeting $greetings {
    append result "$greeting, World!\\n"
 }
 set result]
 And that's just a small sample!}
 There are many ways to say "Hello, World!":
 Howdy, World!
 Hi, World!
 What's up, World!

 And that's just a small sample!
 %
.fi
.PP
\fBWriting Macro Commands\fR
.PP
More typically, \fBmacro commands\fR are used to create a markup
language.  A macro command is just a Tcl command that returns an
output string.  For example, expand can be used to implement a generic
document markup language that can be retargeted to HTML or any other
output format:
.PP
.nf
 % proc bold {} {return "<b>"}
 % proc /bold {} {return "</b>"}
 % ::myexp expand {Some of this text is in [bold]boldface[/bold]}
 Some of this text is in <b>boldface</b>
 %
.fi
.PP
The above definitions of \fBbold\fR and \fB/bold\fR returns HTML, but
such commands can be as complicated as needed; they could, for
example, decide what to return based on the desired output format.
.PP
\fBChanging the Expansion Brackets\fR
.PP
By default, embedded macros are enclosed in square brackets,
\fB[\fR and \fB]\fR.  If square brackets need to be
included in the output, the input can contain the \fBlb\fR and
\fBrb\fR commands.  Alternatively, or if square brackets are
objectionable for some other reason, the macro expansion brackets can
be changed to any pair of non-empty strings.
.PP
The \fBsetbrackets\fR command changes the brackets permanently.
For example, you can write pseudo-html by change them to \fB<\fR
and \fB>\fR:
.PP
.nf
 % ::myexp setbrackets < >
 % ::myexp expand {<bold>This is boldface</bold>}
 <b>This is boldface</b>
.fi
.PP
Alternatively, you can change the expansion brackets temporarily by
passing the desired brackets to the \fBexpand\fR command:
.PP
.nf
 % ::myexp setbrackets "\\[" "\\]"
 % ::myexp expand {<bold>This is boldface</bold>} {< >}
 <b>This is boldface</b>
 %
.fi
.PP
\fBCustomized Macro Expansion\fR
.PP
By default, macros are evaluated using the Tcl \fBuplevel #0\fR
command, so that the embedded code executes in the global context.
The application can provide a different evaluation command using
\fBevalcmd\fR; this allows the application to use a safe
interpreter, for example, or even to evaluated something other than
Tcl code.  There is one caveat: to be recognized as valid, a macro
must return 1 when passed to Tcl's "info complete" command.
.PP
For example, the following code "evaluates" each macro by returning
the macro text itself.
.PP
.nf
    proc identity {macro} {return $macro}
    ::myexp evalcmd identity
.fi
.PP
\fBUsing the Context Stack\fR
.PP
Often it's desirable to define a pair of macros which operate in some
way on the plain text between them.  Consider a set of macros for
adding footnotes to a web page: one could have implement something
like this:
.PP
.nf
    Dr. Pangloss, however, thinks that this is the best of all
    possible worlds.[footnote "See Candide, by Voltaire"]
.fi
.PP
The \fBfootnote\fR macro would, presumably, assign a number to this
footnote and save the text to be formatted later on.  However, this
solution is ugly if the footnote text is long or should contain
additional markup.  Consider the following instead:
.PP
.nf
    Dr. Pangloss, however, thinks that this is the best of all
    possible worlds.[footnote]See [bookTitle "Candide"], by
    [authorsName "Voltaire"], for more information.[/footnote]
.fi
.PP
Here the footnote text is contained between \fBfootnote\fR and
\fB/footnote\fR macros, continues onto a second line, and contains
several macros of its own.  This is both clearer and more flexible;
however, with the features presented so far there's no easy way to do
it.  That's the purpose of the context stack.
.PP
All macro expansion takes place in a particular context.  Here, the
\fBfootnote\fR macro pushes a new context onto the context stack.
Then, all expanded text gets placed in that new context.
\fB/footnote\fR retrieves it by popping the context.  Here's a
skeleton implementation of these two macros:
.PP
.nf
    proc footnote {} {
        ::myexp cpush footnote
    }

    proc /footnote {} {
        set footnoteText [::myexp cpop footnote]

        # Save the footnote text, and return an appropriate footnote
        # number and link.
    }
.fi
.PP
The \fBcpush\fR command pushes a new context onto the stack; the
argument is the context's name.  It can be any string, but would
typically be the name of the macro itself.  Then, \fBcpop\fR
verifies that the current context has the expected name, pops it off
of the stack, and returns the accumulated text.
.PP
Expand provides several other tools related to the context stack.
Suppose the first macro in a context pair takes arguments or computes
values which the second macro in the pair needs.  After calling
\fBcpush\fR, the first macro can define one or more context
variables; the second macro can retrieve their values any time before
calling \fBcpop\fR.  For example, suppose the document must specify
the footnote number explicitly:
.PP
.nf
    proc footnote {footnoteNumber} {
        ::myexp cpush footnote
        ::myexp csave num $footnoteNumber
        # Return an appropriate link
    }

    proc /footnote {} {
        set footnoteNumber [::myexp cget num]
        set footnoteText [::myexp cpop footnote]

        # Save the footnote text and its footnoteNumber for future
        # output.
    }
.fi
.PP
At times, it might be desirable to define macros that are valid only
within a particular context pair; such macros should verify that they
are only called within the correct context using either \fBcis\fR
or \fBcname\fR.
.SH "HISTORY"
\fBexpander\fR was written by William H. Duquette; it is a repackaging
of the central algorithm of the expand macro processing tool.
.SH "SEE ALSO"
regexp, split, string, \fIhttp://www.wjduquette.com/expand\fR
.SH "KEYWORDS"
string, template processing, text expansion
