# This is not meant to run standalone.  It is meant to be sourced from
# menuedit.tcl.

proc getName {{filter "*.mui"}} {
    global menued_parms
    
    set menued_parms(menufilename) [fileselect "File" $menued_parms(menufilename) "" $filter]
    return $menued_parms(menufilename)
}

proc getDelta {l {widget {}} {type {.}}} {
    global menued_parms
    set result {}
    if {$widget == ""} {
	set widget "."
    }
    set idx 0
    while {$idx < [llength $l]} {
	set i [lindex $l $idx]
	if {[llength $i] > 2} {
	    set default [lindex [lindex $menued_parms(default[winfo class $widget]) $idx] 4]
	    if {[set defaultdb [option get . [lindex $i 1] widgetDefault]] != ""} {
		set default $defaultdb
	    }
	    if {![string match {} [lindex $i 4]] && [string compare $default [lindex $i 4]]} {
		# Also compare against the resource database.
		append result " [lindex $i 0] [list [lindex $i 4]]"
	    }
	}
	incr idx
    }
    set result [string range $result 1 900]
    return $result
}

proc menued_accel {key} {
    # Assume we're getting things like <^-m> <S-m> etc.
    regexp {<(.*)>} $key dummy key
    regexp {([^\-]*)$} $key dummy keystroke
    set keymapping "\[menued_menu_accel $keystroke"
    set mods {}
    if {[regexp {\^\-} $key]} {
	append mods " Control"
    }
    if {[regexp {S\-} $key]} {
	append mods " Shift"
    }
    if {[regexp {M\-} $key]} {
	append mods " Meta"
    }
    if {[regexp {A\-} $key]} {
	append mods " Alt"
    }
    if {[regexp {CLck\-} $key]} {
	append mods " CapsLock"
    }
    return "$keymapping $mods\]"
}

proc menued_saveMenuState {cm} {
    global menued_parms
    set resultString {}
    if {$cm != {}} {
	regexp "\^$menued_parms(base)\\\.f\(\.\*\)" $cm match title
	append resultString "\nMenu $title"
	if {[$cm type 0] == "tearoff"} {
	    append resultString " -tearoff 1"
	} else {
	    append resultString " -tearoff 0"
	}
	set lim [$cm index last]
	if {$lim != "none"} {
	    set menustodo {}
	    for {set j 0} {$j <= $lim} {incr j} {
		if {[$cm type $j] != "tearoff"} {
		    append resultString "\nMenuitem $title [$cm type $j]"
		    foreach {x y} [getDelta [$cm entryconfig $j] $cm [$cm type $j]] {
			if {[string first {-menu} $x] != -1} {
			    set menutitle {}
			    regexp "\^$menued_parms(base)\\\.f\(\.\*\)" $y match menutitle
			    append resultString " $x [list $menutitle]"
			} else {
			    append resultString " $x [list $y]"
			}
		    }
		    if {[regexp {\-menu} [$cm entryconfig $j]] != 0} {
			if {[$cm entryconfig $j -menu] != {}} {
			    append menustodo " [$cm entrycget $j -menu]"
			}
		    }
		}
	    }
	    foreach i $menustodo {
		append resultString [menued_saveMenuState $i]
	    }
	}
    }
    return $resultString
}

proc menued_saveState {} {
    global menued_parms
    set a "$menued_parms(base).f"
    set nmb $menued_parms(menuButtons)
    set cmb $menued_parms(curMenuButton)
    set cmbn $menued_parms(mb$cmb)    
    set cm [lindex $menued_parms(curMenuItem) 0]

    set resultString {}
    set menustodo {}
    append resultString "Menubar .f"
    for {set i 0} {$i <= $nmb} {incr i} {
	regexp "\^$menued_parms(base)\\\.f\(\.\*\)" $a.$menued_parms(mb$i) match title
	append resultString "\nMenubutton $title"
	if {$i < $menued_parms(lrsplit)} {
	    append resultString " -side left"
	} else {
	    append resultString " -side right"
	}
	foreach {x y} [getDelta [$a.$menued_parms(mb$i) config] $a.$menued_parms(mb$i)] {
	    if {[string first {-menu} $x] == -1} {
		append resultString " $x [list $y]"
	    } else {
		regexp "\^$menued_parms(base)\\\.f\(\.\*\)" $y match title
		append resultString " $x [list $title]"
	    }
	}
	set cm [$a.$menued_parms(mb$i) cget -menu]
	if {$cm != {}} {
	    append menustodo " $cm"
	}
    }
    foreach i $menustodo {
	append resultString [menued_saveMenuState $i]
    }
    return $resultString
}

proc menued_doSave {{name "untitled.mui"}} {
    global menued_parms
    set a "$menued_parms(base).f"
    set nmb $menued_parms(menuButtons)
    set cmb $menued_parms(curMenuButton)
    set cmbn $menued_parms(mb$cmb)    
    set cm [lindex $menued_parms(curMenuItem) 0]
    set oldmb $menued_parms(postedMb)

    if {$name == {}} {
	if {[getName] == {}} {
	    return
	}
    }
    
    wm title $menued_parms(base) "Menuedit: $menued_parms(menufilename)"
    wm title $menued_parms(base).menus "Menuedit: $menued_parms(menufilename)"
    if {[file exists $menued_parms(menufilename)]} {
	if {[file writable $menued_parms(menufilename)]} {
	    if {[tk_dialog .menuediterror "Warning" "Do you want to overwrite the file '$menued_parms(menufilename)'?" question 1 "Overwrite!" "Don't Overwrite!"] == 0} {
		# Allow this to go through.
	    } else {
		# Do nothing
		return
	    }
	} else {
	    tk_dialog .menuediterror "File Error" "That file is not writable." warning 0 "Rats!"
	    return
	}
    }

    menued_unhighlight
    menued_unhighlightall
    menuedMenuUnpost $a.$cmbn.m
    set menued_parms(outfile) [open $menued_parms(menufilename) "w"]
    if {$menued_parms(outfile) != {}} {
	set resultString [menued_saveState]
	puts $menued_parms(outfile) $resultString
	close $menued_parms(outfile)
    } else {
	tk_dialog .menuediterror "Warning" \
           "Couldn't open '$menued_parms(menufilename)' for writing." \
	   error 0 "Rats!"
    }
    
    menued_thisMenuButton $oldmb
}

proc Menubar {name args} {
    global menued_parms
    
    if {[winfo exists $menued_parms(base).f$name]} {
	foreach i [winfo children $menued_parms(base).f$name] {
	    destroy $i
	}
#	destroy $menued_parms(base)$name
    } else {
	frame $menued_parms(base).f$name -relief raised -bd 2
	pack $menued_parms(base).f$name -side top -fill x
    }
}

proc Menubutton {name args} {
    global menued_parms
    set side "left"
    incr menued_parms(menuButtons)
    
    if {[winfo exists $menued_parms(base).f$name]} {
	destroy $menued_parms(base).f$name
    }
    menubutton $menued_parms(base).f$name
    regexp {.*\.([^\.]*)} $menued_parms(base).f$name match bname
    regexp {.*\#([0-9]*)} $bname match thisidx
    if {[expr $thisidx+1] > $menued_parms(highidx)} {
	set menued_parms(highidx) [expr $thisidx+1]
    }
    set menued_parms(mb$menued_parms(menuButtons)) $bname
    bindtags $menued_parms(base).f$name [concat meMbResponder meMenubutton [bindtags $menued_parms(base).f$name]]
    foreach {x y} $args {
	if {$x == "-menu"} {
	    set y $menued_parms(base).f$y
	}
	if {[catch {$menued_parms(base).f$name config $x $y} msg] > 0} {
	    if {$x == "-side"} {
		set side $y
		if {$y != "left" && $menued_parms(lrsplit) == 900} {
		    set menued_parms(lrsplit) $menued_parms(menuButtons)
		}
	    } else {
		puts "Menubutton '$x $y', got error '$msg'"
	    }
	}
    }
    pack $menued_parms(base).f$name -side $side
}

proc Menu {name args} {
    global menued_parms
    
    if {[winfo exists $menued_parms(base).f$name]} {
	destroy $menued_parms(base).f$name
    }
    menu $menued_parms(base).f$name
    bindtags $menued_parms(base).f$name [concat meMenu [bindtags $menued_parms(base).f$name]]
    foreach {x y} $args {
	if {[catch {$menued_parms(base).f$name config $x $y} msg] > 0} {
	    if {$} {
	    } else {
		puts "Menu '$x $y', got error '$msg'"
	    }
	}
    }
}

proc Menuitem {name type args} {
    global menued_parms
    set idx [$menued_parms(base).f$name index last]
    if {$idx == "none"} {
	 set idx -1
    }
    incr idx
    $menued_parms(base).f$name add $type
    foreach {x y} $args {
	if {$x == "-menu"} {
	    set y $menued_parms(base).f$y
	}
	if {[catch {$menued_parms(base).f$name entryconfig $idx $x $y} msg] > 0} {
	    puts "Menuitem '$x $y', got error '$msg'"
	}
    }
}

proc menued_restoreMenuState {is} {
    global menued_parms
    set idx 0
    
    menued_eraseMenus
    foreach i [split $is "\n"] {
	incr idx
	eval $i
    }
}

proc menued_doOpen {{filename {}}} {
    global menued_parms
    
    menued_unhighlight
    menuedMenuUnpost {}
    if {$filename == {}} {
	if {[getName] == {}} {
	    return
	}
    }
    
    wm title $menued_parms(base) "Menuedit: $menued_parms(menufilename)"
    wm title $menued_parms(base).menus "Menuedit: $menued_parms(menufilename)"

    if {[file exists $menued_parms(menufilename)]} {
	if {[file readable $menued_parms(menufilename)]} {
	    set menued_parms(outfile) [open $menued_parms(menufilename) "r"]
	    if {$menued_parms(outfile) != {}} {
		set inputString [read $menued_parms(outfile)]
		menued_restoreMenuState $inputString
		update idletasks
	    } else {
		tk_dialog .menuediterror "Warning" \
                "Got an error while trying to open the file '$menued_parms(menufilename)'." \
	        error 0 "Rats!"
	    }
	} else {
	    tk_dialog .menuediterror "Warning" \
           "Couldn't open '$menued_parms(menufilename)' for reading." \
	   error 0 "Rats!"
	}
    } else {
	tk_dialog .menuediterror "Warning" \
           "The file '$menued_parms(menufilename)' doesn't exist." \
	   error 0 "Rats!"
    }
    
    menuedMbPost $menued_parms(base).f.$menued_parms(mb0)
    menued_highlight
}

proc doClose {} {
}

proc Compile_Menubar {name args} {
}

proc Compile_Menubutton {name args} {
    global menued_parms
    set oldargs {}
    set newargs {}
    set oldresult {}
    set newresult {}
    regexp {\.(.*)} $name dummy name
    regexp {.*\#([0-9])} $name dummy index
    append menued_parms(oldmenubuttons) "        menubutton \${base}.$name\n        \$menupaths($name) config "
    append menued_parms(oldmenubuttonspaths) "$name \${base}.$name "
    append menued_parms(newmenubuttons) "        \${topbase}.menubar add cascade "
    append menued_parms(newmenubuttonspaths) "$name \${base}.menubar "

     foreach {i j} $args {
	 switch -- $i {
	     "-side" {
		 set side $j
	     }
	     "-menu" {
		 append menued_parms(oldmenubuttons) "$i \$menupaths($name).${index}m "
		 append menued_parms(newmenubuttons) "$i \$menupaths($name).${index}m "
	     }
	     "-text" {
		 append menued_parms(oldmenubuttons) "$i [list $j] "
		 append menued_parms(newmenubuttons) "-label [list $j] "
	     }
	     "-padx" {
		 append menued_parms(oldmenubuttons) "$i [list $j] "
	     }
	     "-pady" {
		 append menued_parms(oldmenubuttons) "$i [list $j] "
	     }
	     "-cursor" {
		 append menued_parms(oldmenubuttons) "$i [list $j] "
	     }
	     default {
		 append menued_parms(oldmenubuttons) "$i [list $j] "
		 append menued_parms(newmenubuttons) "$i [list $j] "
	     }
	 }
     }
    append menued_parms(oldmenubuttons) "\n        pack \$menupaths($name) -side $side\n"
    append menued_parms(newmenubuttons) "\n"
    return ""
}

proc Compile_Menu {name args} {
    set result {}
    set tail {}
    if {![regexp {\.(.*)\.m(\..*)} $name dummy name tail]} {
	regexp {\.(.*)\.m} $name dummy name
    }
    regexp {.*\#([0-9]*)} $name dummy index
    append result "menu \$menupaths($name).${index}m${tail} "
    set tempresult {}
    foreach {i j} $args {
	append tempresult "$i [list $j] "
    }
    return "$result$tempresult\n"
}

proc Compile_Menuitem {name type args} {
    global menued_parms
    set tail {}
    if {![regexp {\.(.*)\.m(\..*)} $name dummy name tail]} {
	regexp {\.(.*)\.m} $name dummy name
    }
    regexp {.*\#([0-9]*)} $name dummy index
    append result "\$menupaths($name).${index}m${tail} add $type "
    set tempresult {}
    set bindingresult {}
    set bindingflag 0
    foreach {i j} $args {
	if {$i == "-menu"} {
	    set castail {}
	    if {![regexp {\.(.*)\.m(\..*)} $j dummy j castail]} {
		regexp {\.(.*)\.m} $j dummy j
	    }
	    regexp {.*\#([0-9]*)} $j dummy index
	    append tempresult "$i \$menupaths($j).${index}m${castail} "
	} elseif {$i == "-state"} {
	    # Don't output.
	} elseif {$i == "-underline" && $j == -1} {
	    # Don't output.
	} elseif {$i == "-accelerator"} {
	    append tempresult "$i [menued_accel $j] "
	} else {
	    if {$menued_parms(createBindings) && $i == "-accelerator"} {
		incr bindingflag
		append bindingresult "bind all $j "
		regsub {\^\-} $bindingresult "Control-" bindingresult
		regsub {S\-} $bindingresult "Shift-" bindingresult
		regsub {CLck\-} $bindingresult "CapsLock-" bindingresult
		regsub {M\-} $bindingresult "Meta-" bindingresult
		regsub {AltG\-} $bindingresult "AltGraphics-" bindingresult
		regsub {NumL\-} $bindingresult "NumLock-" bindingresult
		regsub {A\-} $bindingresult "Alt-" bindingresult
	    } elseif {$menued_parms(createBindings) && $i == "-command"} {
		incr bindingflag
		append bindingresult "\{$j\}\n"
	    }
	    append tempresult "$i [list $j] "
	}
    }
    if {$bindingflag < 2} {
	return "$result$tempresult\n"
    } else {
	return "$result$tempresult\n    $bindingresult"
    }
}

proc menued_compile_tcl_tostring {{menus {}}} {

    global menued_parms
    set idx 0
    set oldmb $menued_parms(postedMb)
    
    menued_unhighlight
    menuedMenuUnpost {}
    
    if {$menus == {} } {
	set menus [menued_saveState]
    }
    set menued_parms(oldmenubuttons) {}
    set menued_parms(newmenubuttons) {}
    set menued_parms(oldmenubuttonspaths) {}
    set menued_parms(newmenubuttonspaths) {}
    
    if {$menued_parms(menufilename) == {}} {
	set menued_parms(menufilename) "untitled.mui"
    }
    regexp {(.*)\.mui} [file tail $menued_parms(menufilename)] match procname
    set result "# This application created with menuedit version $menued_parms(version),\na SpecTcl plugin and a standalone application to create menus for Tcl/Tk.\n\n"
    set result {}
    append result "proc ${procname}_mui \{root args\} \{\n\n"
    append result "    # This treats \'.\' as a special case.\n"
    append result "    if \{\$root == \".\"\} \{set base \"\"\} else \{set base \$root\}\n\n"
    append result "    set toproot \[winfo toplevel \$root\]\n"
    append result "    if \{\$toproot == \".\"\} \{set topbase \"\"\} else \{set topbase \$toproot\}\n"
    append result "
    proc menued_menu_accel {key args} {
	global tcl_platform
	set shift \[regexp {\[sS]hift} \$args]
	set control \[regexp {\[cC]ontrol} \$args]
	set meta \[regexp {\[mM]eta} \$args]
	set alt \[regexp {\[aA]lt} \$args]
	switch \$tcl_platform(platform) {
	    unix {
		array set mods {prefix \"<\" suffix \">\" \
				    shift0 \"\" shift1 \"Shift-\" \
				    control0 \"\" control1 \"^-\" \
				    meta0 \"\" meta1 \"Meta-\" \
				    alt0 \"\" alt1 \"Alt-\"}
	    }
	    macintosh {
		set key \[string toupper \$key]
		array set mods {prefix \"\" suffix \"\" \
				    shift0 \"\" shift1 \"Shift\" \
				    control0 \"\" control1 \"Command-\" \
				    meta0 \"\" meta1 \"\\240\" \
				    alt0 \"\" alt1 \"Option\"}
	    }
	    windows {
		array set mods {prefix \"\" suffix \"\" \
				    shift0 \"\" shift1 \"Shft+\" \
				    control0 \"\" control1 \"Ctrl+\" \
				    meta0 \"\" meta1 \"Meta+\" \
				    alt0 \"\" alt1 \"Alt+\"}
	    }
	    default {
		return \"\$key\"
	    }
	}
	return \"\$mods(prefix)\$mods(shift\$shift)\$mods(control\$control)\$mods(meta\$meta)\$mods(alt\$alt)\$key\$mods(suffix)\"
    }
"
    append result "    if \{\[catch \{\$toproot config -menu \$\{topbase\}.menubar\} msg\]\} \{"

    set didbuttons 0
    set donewithbuttons 0
    foreach i [split $menus "\n"] {
	incr idx
	if {!$didbuttons && [regexp {^Menubutton} $i]} {
	    set didbuttons 1
	}
	if {$didbuttons && !$donewithbuttons && ![regexp {^Menubutton} $i]} {
	    set donewithbuttons 1
	    append result "
        array set menupaths \"$menued_parms(oldmenubuttonspaths)\"
$menued_parms(oldmenubuttons)    \} else \{
        if \{\[winfo toplevel \$root\] == \".\"\} \{set base \"\"\} else \{set base \[winfo toplevel \$root\]\}
        array set menupaths \"$menued_parms(newmenubuttonspaths)\"
        menu \$\{topbase\}.menubar
$menued_parms(newmenubuttons)    \}\n"
	}
	set temp [eval Compile_$i]
	if {$temp != ""} {
	    append result "    [eval Compile_$i]\n"
	}
    }
    append result "    rename menued_menu_accel {}\n\}\n\n"
    menuedMbPost $oldmb
    menued_highlight

    return $result
}

proc menued_compile_tcl {{menus {}}} {
    global menued_parms
    $menued_parms(base).menus.controls.status config -text "Finding output file."
    
    if {[array names menued_parms menuoutputfilename] == {}} {
	set menued_parms(menuoutputfilename) $menued_parms(menufilename).tcl
    }
    if {$menued_parms(menuoutputfilename) == {}} {
	set menued_parms(menuoutputfilename) "$menued_parms(menufilename).tcl"
    }
    if {[file exists $menued_parms(menuoutputfilename)]} {
	if {![file writable $menued_parms(menuoutputfilename)]} {
	    tk_dialog .menuediterror "Error" \
           "The file '$menued_parms(menuoutputfilename)' is not writeable." \
	   error 0 "Rats!"
	    return
	}
    }
    
    $menued_parms(base).menus.controls.status config -text "Opening output file."
    
    set f [open $menued_parms(menuoutputfilename) "w"]
    if {$f == {}} {
	tk_dialog .menuediterror "Error" \
           "Couldn't open the file '$menued_parms(menuoutputfilename)' for writing." \
	   error 0 "Rats!"
	    return
    }
    $menued_parms(base).menus.controls.status config -text "Compiling to output file."
    
    puts $f [menued_compile_tcl_tostring]
    close $f
    $menued_parms(base).menus.controls.status config -text "Done compiling."
    
}

proc menued_compile_java {{menus {}}} {
    global menued_parms
    
    tk_dialog .menuediterror "Joke" \
           "You've got to be kidding me...this was a joke." \
	   error 0 "Rats!"
}
