#
# log.tcl
#	This maintains a log of user actions.
#	Useful for debugging and later for undo.
#

proc Log {win args} {
    if ![winfo exists $win.log] {
	if [catch {toplevel $win.log -class Log} f] {
	    return
	}

	set menubar [frame $f.menubar]
	button $menubar.quit -text Dismiss -command "wm withdraw $f"
	button $menubar.save -text Save -command "LogSave $f.text"
	button $menubar.trunc -text Truncate -command "$f.text delete 1.0 end"
	pack $menubar.quit $menubar.save $menubar.trunc -side right
	pack $menubar -side top -fill x

	set t [text $f.text -width 80 -height 24 \
		-yscrollcommand "$f.scroll set"]
	$t tag configure Log -spacing3 .1c -lmargin2 1c
	scrollbar $f.scroll -orient vertical -command "$f.text yview"
	pack $f.scroll $f.text -side right 
	pack $f.text -expand true -fill both
	pack $f.scroll -fill y
	wm withdraw $f
    } else {
	set t $win.log.text
    }
    regsub -all "\n" $args {\n} args
    $t insert end $args\n Log
    $t see end
}
proc LogBegin {win args} {
    Log $win >>>>
    if {[llength $args]} {
	eval {Log $win} $args
    }
}
proc LogEnd {win args} {
    if {[llength $args]} {
	eval {Log $win} $args
    }
    Log $win <<<<
}
proc LogCont {win args} {
    set t $win.log.text
    $t insert end "$args " Log
    $t see end
}
proc LogShow {win} {
    Log $win ****show****
    wm deiconify $win.log
}
proc LogSave {t} {
    $t insert end "\nSaving to /tmp/webtk.log\n"
    set out [open /tmp/webtk.log w]
    puts $out [$t get 1.0 end]
    close $out
}
