/* 
 * tkStubs.c --
 *
 *	This file contains the wrapper functions for the platform independent
 *	public Tk API.
 *
 * Copyright (c) 1998-1999 by Scriptics Corporation.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * RCS: @(#) $Id: tkStubs.c,v 1.2.2.1 1999/03/10 07:13:46 stanton Exp $
 */

#include "tk.h"

/*
 * Undefine function macros that will interfere with the defintions below.
 */


/*
 * WARNING: This file is automatically generated by the tools/genStubs.tcl
 * script.  Any modifications to the function declarations below should be made
 * in the generic/tk.decls script.
 */

/* !BEGIN!: Do not edit below this line. */

/*
 * Exported stub functions:
 */

/* Slot 0 */
void
Tk_MainLoop()
{
    (tkStubsPtr->tk_MainLoop)();
}

/* Slot 1 */
XColor *
Tk_3DBorderColor(border)
    Tk_3DBorder border;
{
    return (tkStubsPtr->tk_3DBorderColor)(border);
}

/* Slot 2 */
GC
Tk_3DBorderGC(tkwin, border, which)
    Tk_Window tkwin;
    Tk_3DBorder border;
    int which;
{
    return (tkStubsPtr->tk_3DBorderGC)(tkwin, border, which);
}

/* Slot 3 */
void
Tk_3DHorizontalBevel(tkwin, drawable, border, x, y, width, height, leftIn, rightIn, topBevel, relief)
    Tk_Window tkwin;
    Drawable drawable;
    Tk_3DBorder border;
    int x;
    int y;
    int width;
    int height;
    int leftIn;
    int rightIn;
    int topBevel;
    int relief;
{
    (tkStubsPtr->tk_3DHorizontalBevel)(tkwin, drawable, border, x, y, width, height, leftIn, rightIn, topBevel, relief);
}

/* Slot 4 */
void
Tk_3DVerticalBevel(tkwin, drawable, border, x, y, width, height, leftBevel, relief)
    Tk_Window tkwin;
    Drawable drawable;
    Tk_3DBorder border;
    int x;
    int y;
    int width;
    int height;
    int leftBevel;
    int relief;
{
    (tkStubsPtr->tk_3DVerticalBevel)(tkwin, drawable, border, x, y, width, height, leftBevel, relief);
}

/* Slot 5 */
void
Tk_AddOption(tkwin, name, value, priority)
    Tk_Window tkwin;
    char * name;
    char * value;
    int priority;
{
    (tkStubsPtr->tk_AddOption)(tkwin, name, value, priority);
}

/* Slot 6 */
void
Tk_BindEvent(bindingTable, eventPtr, tkwin, numObjects, objectPtr)
    Tk_BindingTable bindingTable;
    XEvent * eventPtr;
    Tk_Window tkwin;
    int numObjects;
    ClientData * objectPtr;
{
    (tkStubsPtr->tk_BindEvent)(bindingTable, eventPtr, tkwin, numObjects, objectPtr);
}

/* Slot 7 */
void
Tk_CanvasDrawableCoords(canvas, x, y, drawableXPtr, drawableYPtr)
    Tk_Canvas canvas;
    double x;
    double y;
    short * drawableXPtr;
    short * drawableYPtr;
{
    (tkStubsPtr->tk_CanvasDrawableCoords)(canvas, x, y, drawableXPtr, drawableYPtr);
}

/* Slot 8 */
void
Tk_CanvasEventuallyRedraw(canvas, x1, y1, x2, y2)
    Tk_Canvas canvas;
    int x1;
    int y1;
    int x2;
    int y2;
{
    (tkStubsPtr->tk_CanvasEventuallyRedraw)(canvas, x1, y1, x2, y2);
}

/* Slot 9 */
int
Tk_CanvasGetCoord(interp, canvas, string, doublePtr)
    Tcl_Interp * interp;
    Tk_Canvas canvas;
    char * string;
    double * doublePtr;
{
    return (tkStubsPtr->tk_CanvasGetCoord)(interp, canvas, string, doublePtr);
}

/* Slot 10 */
Tk_CanvasTextInfo *
Tk_CanvasGetTextInfo(canvas)
    Tk_Canvas canvas;
{
    return (tkStubsPtr->tk_CanvasGetTextInfo)(canvas);
}

/* Slot 11 */
int
Tk_CanvasPsBitmap(interp, canvas, bitmap, x, y, width, height)
    Tcl_Interp * interp;
    Tk_Canvas canvas;
    Pixmap bitmap;
    int x;
    int y;
    int width;
    int height;
{
    return (tkStubsPtr->tk_CanvasPsBitmap)(interp, canvas, bitmap, x, y, width, height);
}

/* Slot 12 */
int
Tk_CanvasPsColor(interp, canvas, colorPtr)
    Tcl_Interp * interp;
    Tk_Canvas canvas;
    XColor * colorPtr;
{
    return (tkStubsPtr->tk_CanvasPsColor)(interp, canvas, colorPtr);
}

/* Slot 13 */
int
Tk_CanvasPsFont(interp, canvas, font)
    Tcl_Interp * interp;
    Tk_Canvas canvas;
    Tk_Font font;
{
    return (tkStubsPtr->tk_CanvasPsFont)(interp, canvas, font);
}

/* Slot 14 */
void
Tk_CanvasPsPath(interp, canvas, coordPtr, numPoints)
    Tcl_Interp * interp;
    Tk_Canvas canvas;
    double * coordPtr;
    int numPoints;
{
    (tkStubsPtr->tk_CanvasPsPath)(interp, canvas, coordPtr, numPoints);
}

/* Slot 15 */
int
Tk_CanvasPsStipple(interp, canvas, bitmap)
    Tcl_Interp * interp;
    Tk_Canvas canvas;
    Pixmap bitmap;
{
    return (tkStubsPtr->tk_CanvasPsStipple)(interp, canvas, bitmap);
}

/* Slot 16 */
double
Tk_CanvasPsY(canvas, y)
    Tk_Canvas canvas;
    double y;
{
    return (tkStubsPtr->tk_CanvasPsY)(canvas, y);
}

/* Slot 17 */
void
Tk_CanvasSetStippleOrigin(canvas, gc)
    Tk_Canvas canvas;
    GC gc;
{
    (tkStubsPtr->tk_CanvasSetStippleOrigin)(canvas, gc);
}

/* Slot 18 */
int
Tk_CanvasTagsParseProc(clientData, interp, tkwin, value, widgRec, offset)
    ClientData clientData;
    Tcl_Interp * interp;
    Tk_Window tkwin;
    char * value;
    char * widgRec;
    int offset;
{
    return (tkStubsPtr->tk_CanvasTagsParseProc)(clientData, interp, tkwin, value, widgRec, offset);
}

/* Slot 19 */
char *
Tk_CanvasTagsPrintProc(clientData, tkwin, widgRec, offset, freeProcPtr)
    ClientData clientData;
    Tk_Window tkwin;
    char * widgRec;
    int offset;
    Tcl_FreeProc ** freeProcPtr;
{
    return (tkStubsPtr->tk_CanvasTagsPrintProc)(clientData, tkwin, widgRec, offset, freeProcPtr);
}

/* Slot 20 */
Tk_Window
Tk_CanvasTkwin(canvas)
    Tk_Canvas canvas;
{
    return (tkStubsPtr->tk_CanvasTkwin)(canvas);
}

/* Slot 21 */
void
Tk_CanvasWindowCoords(canvas, x, y, screenXPtr, screenYPtr)
    Tk_Canvas canvas;
    double x;
    double y;
    short * screenXPtr;
    short * screenYPtr;
{
    (tkStubsPtr->tk_CanvasWindowCoords)(canvas, x, y, screenXPtr, screenYPtr);
}

/* Slot 22 */
void
Tk_ChangeWindowAttributes(tkwin, valueMask, attsPtr)
    Tk_Window tkwin;
    unsigned long valueMask;
    XSetWindowAttributes * attsPtr;
{
    (tkStubsPtr->tk_ChangeWindowAttributes)(tkwin, valueMask, attsPtr);
}

/* Slot 23 */
int
Tk_CharBbox(layout, index, xPtr, yPtr, widthPtr, heightPtr)
    Tk_TextLayout layout;
    int index;
    int * xPtr;
    int * yPtr;
    int * widthPtr;
    int * heightPtr;
{
    return (tkStubsPtr->tk_CharBbox)(layout, index, xPtr, yPtr, widthPtr, heightPtr);
}

/* Slot 24 */
void
Tk_ClearSelection(tkwin, selection)
    Tk_Window tkwin;
    Atom selection;
{
    (tkStubsPtr->tk_ClearSelection)(tkwin, selection);
}

/* Slot 25 */
int
Tk_ClipboardAppend(interp, tkwin, target, format, buffer)
    Tcl_Interp * interp;
    Tk_Window tkwin;
    Atom target;
    Atom format;
    char* buffer;
{
    return (tkStubsPtr->tk_ClipboardAppend)(interp, tkwin, target, format, buffer);
}

/* Slot 26 */
int
Tk_ClipboardClear(interp, tkwin)
    Tcl_Interp * interp;
    Tk_Window tkwin;
{
    return (tkStubsPtr->tk_ClipboardClear)(interp, tkwin);
}

/* Slot 27 */
int
Tk_ConfigureInfo(interp, tkwin, specs, widgRec, argvName, flags)
    Tcl_Interp * interp;
    Tk_Window tkwin;
    Tk_ConfigSpec * specs;
    char * widgRec;
    char * argvName;
    int flags;
{
    return (tkStubsPtr->tk_ConfigureInfo)(interp, tkwin, specs, widgRec, argvName, flags);
}

/* Slot 28 */
int
Tk_ConfigureValue(interp, tkwin, specs, widgRec, argvName, flags)
    Tcl_Interp * interp;
    Tk_Window tkwin;
    Tk_ConfigSpec * specs;
    char * widgRec;
    char * argvName;
    int flags;
{
    return (tkStubsPtr->tk_ConfigureValue)(interp, tkwin, specs, widgRec, argvName, flags);
}

/* Slot 29 */
int
Tk_ConfigureWidget(interp, tkwin, specs, argc, argv, widgRec, flags)
    Tcl_Interp * interp;
    Tk_Window tkwin;
    Tk_ConfigSpec * specs;
    int argc;
    char ** argv;
    char * widgRec;
    int flags;
{
    return (tkStubsPtr->tk_ConfigureWidget)(interp, tkwin, specs, argc, argv, widgRec, flags);
}

/* Slot 30 */
void
Tk_ConfigureWindow(tkwin, valueMask, valuePtr)
    Tk_Window tkwin;
    unsigned int valueMask;
    XWindowChanges * valuePtr;
{
    (tkStubsPtr->tk_ConfigureWindow)(tkwin, valueMask, valuePtr);
}

/* Slot 31 */
Tk_TextLayout
Tk_ComputeTextLayout(font, string, numChars, wrapLength, justify, flags, widthPtr, heightPtr)
    Tk_Font font;
    CONST char * string;
    int numChars;
    int wrapLength;
    Tk_Justify justify;
    int flags;
    int * widthPtr;
    int * heightPtr;
{
    return (tkStubsPtr->tk_ComputeTextLayout)(font, string, numChars, wrapLength, justify, flags, widthPtr, heightPtr);
}

/* Slot 32 */
Tk_Window
Tk_CoordsToWindow(rootX, rootY, tkwin)
    int rootX;
    int rootY;
    Tk_Window tkwin;
{
    return (tkStubsPtr->tk_CoordsToWindow)(rootX, rootY, tkwin);
}

/* Slot 33 */
unsigned long
Tk_CreateBinding(interp, bindingTable, object, eventString, command, append)
    Tcl_Interp * interp;
    Tk_BindingTable bindingTable;
    ClientData object;
    char * eventString;
    char * command;
    int append;
{
    return (tkStubsPtr->tk_CreateBinding)(interp, bindingTable, object, eventString, command, append);
}

/* Slot 34 */
Tk_BindingTable
Tk_CreateBindingTable(interp)
    Tcl_Interp * interp;
{
    return (tkStubsPtr->tk_CreateBindingTable)(interp);
}

/* Slot 35 */
Tk_ErrorHandler
Tk_CreateErrorHandler(display, errNum, request, minorCode, errorProc, clientData)
    Display * display;
    int errNum;
    int request;
    int minorCode;
    Tk_ErrorProc * errorProc;
    ClientData clientData;
{
    return (tkStubsPtr->tk_CreateErrorHandler)(display, errNum, request, minorCode, errorProc, clientData);
}

/* Slot 36 */
void
Tk_CreateEventHandler(token, mask, proc, clientData)
    Tk_Window token;
    unsigned long mask;
    Tk_EventProc * proc;
    ClientData clientData;
{
    (tkStubsPtr->tk_CreateEventHandler)(token, mask, proc, clientData);
}

/* Slot 37 */
void
Tk_CreateGenericHandler(proc, clientData)
    Tk_GenericProc * proc;
    ClientData clientData;
{
    (tkStubsPtr->tk_CreateGenericHandler)(proc, clientData);
}

/* Slot 38 */
void
Tk_CreateImageType(typePtr)
    Tk_ImageType * typePtr;
{
    (tkStubsPtr->tk_CreateImageType)(typePtr);
}

/* Slot 39 */
void
Tk_CreateItemType(typePtr)
    Tk_ItemType * typePtr;
{
    (tkStubsPtr->tk_CreateItemType)(typePtr);
}

/* Slot 40 */
void
Tk_CreatePhotoImageFormat(formatPtr)
    Tk_PhotoImageFormat * formatPtr;
{
    (tkStubsPtr->tk_CreatePhotoImageFormat)(formatPtr);
}

/* Slot 41 */
void
Tk_CreateSelHandler(tkwin, selection, target, proc, clientData, format)
    Tk_Window tkwin;
    Atom selection;
    Atom target;
    Tk_SelectionProc * proc;
    ClientData clientData;
    Atom format;
{
    (tkStubsPtr->tk_CreateSelHandler)(tkwin, selection, target, proc, clientData, format);
}

/* Slot 42 */
Tk_Window
Tk_CreateWindow(interp, parent, name, screenName)
    Tcl_Interp * interp;
    Tk_Window parent;
    char * name;
    char * screenName;
{
    return (tkStubsPtr->tk_CreateWindow)(interp, parent, name, screenName);
}

/* Slot 43 */
Tk_Window
Tk_CreateWindowFromPath(interp, tkwin, pathName, screenName)
    Tcl_Interp * interp;
    Tk_Window tkwin;
    char * pathName;
    char * screenName;
{
    return (tkStubsPtr->tk_CreateWindowFromPath)(interp, tkwin, pathName, screenName);
}

/* Slot 44 */
int
Tk_DefineBitmap(interp, name, source, width, height)
    Tcl_Interp * interp;
    Tk_Uid name;
    char * source;
    int width;
    int height;
{
    return (tkStubsPtr->tk_DefineBitmap)(interp, name, source, width, height);
}

/* Slot 45 */
void
Tk_DefineCursor(window, cursor)
    Tk_Window window;
    Tk_Cursor cursor;
{
    (tkStubsPtr->tk_DefineCursor)(window, cursor);
}

/* Slot 46 */
void
Tk_DeleteAllBindings(bindingTable, object)
    Tk_BindingTable bindingTable;
    ClientData object;
{
    (tkStubsPtr->tk_DeleteAllBindings)(bindingTable, object);
}

/* Slot 47 */
int
Tk_DeleteBinding(interp, bindingTable, object, eventString)
    Tcl_Interp * interp;
    Tk_BindingTable bindingTable;
    ClientData object;
    char * eventString;
{
    return (tkStubsPtr->tk_DeleteBinding)(interp, bindingTable, object, eventString);
}

/* Slot 48 */
void
Tk_DeleteBindingTable(bindingTable)
    Tk_BindingTable bindingTable;
{
    (tkStubsPtr->tk_DeleteBindingTable)(bindingTable);
}

/* Slot 49 */
void
Tk_DeleteErrorHandler(handler)
    Tk_ErrorHandler handler;
{
    (tkStubsPtr->tk_DeleteErrorHandler)(handler);
}

/* Slot 50 */
void
Tk_DeleteEventHandler(token, mask, proc, clientData)
    Tk_Window token;
    unsigned long mask;
    Tk_EventProc * proc;
    ClientData clientData;
{
    (tkStubsPtr->tk_DeleteEventHandler)(token, mask, proc, clientData);
}

/* Slot 51 */
void
Tk_DeleteGenericHandler(proc, clientData)
    Tk_GenericProc * proc;
    ClientData clientData;
{
    (tkStubsPtr->tk_DeleteGenericHandler)(proc, clientData);
}

/* Slot 52 */
void
Tk_DeleteImage(interp, name)
    Tcl_Interp * interp;
    char * name;
{
    (tkStubsPtr->tk_DeleteImage)(interp, name);
}

/* Slot 53 */
void
Tk_DeleteSelHandler(tkwin, selection, target)
    Tk_Window tkwin;
    Atom selection;
    Atom target;
{
    (tkStubsPtr->tk_DeleteSelHandler)(tkwin, selection, target);
}

/* Slot 54 */
void
Tk_DestroyWindow(tkwin)
    Tk_Window tkwin;
{
    (tkStubsPtr->tk_DestroyWindow)(tkwin);
}

/* Slot 55 */
char *
Tk_DisplayName(tkwin)
    Tk_Window tkwin;
{
    return (tkStubsPtr->tk_DisplayName)(tkwin);
}

/* Slot 56 */
int
Tk_DistanceToTextLayout(layout, x, y)
    Tk_TextLayout layout;
    int x;
    int y;
{
    return (tkStubsPtr->tk_DistanceToTextLayout)(layout, x, y);
}

/* Slot 57 */
void
Tk_Draw3DPolygon(tkwin, drawable, border, pointPtr, numPoints, borderWidth, leftRelief)
    Tk_Window tkwin;
    Drawable drawable;
    Tk_3DBorder border;
    XPoint * pointPtr;
    int numPoints;
    int borderWidth;
    int leftRelief;
{
    (tkStubsPtr->tk_Draw3DPolygon)(tkwin, drawable, border, pointPtr, numPoints, borderWidth, leftRelief);
}

/* Slot 58 */
void
Tk_Draw3DRectangle(tkwin, drawable, border, x, y, width, height, borderWidth, relief)
    Tk_Window tkwin;
    Drawable drawable;
    Tk_3DBorder border;
    int x;
    int y;
    int width;
    int height;
    int borderWidth;
    int relief;
{
    (tkStubsPtr->tk_Draw3DRectangle)(tkwin, drawable, border, x, y, width, height, borderWidth, relief);
}

/* Slot 59 */
void
Tk_DrawChars(display, drawable, gc, tkfont, source, numChars, x, y)
    Display * display;
    Drawable drawable;
    GC gc;
    Tk_Font tkfont;
    CONST char * source;
    int numChars;
    int x;
    int y;
{
    (tkStubsPtr->tk_DrawChars)(display, drawable, gc, tkfont, source, numChars, x, y);
}

/* Slot 60 */
void
Tk_DrawFocusHighlight(tkwin, gc, width, drawable)
    Tk_Window tkwin;
    GC gc;
    int width;
    Drawable drawable;
{
    (tkStubsPtr->tk_DrawFocusHighlight)(tkwin, gc, width, drawable);
}

/* Slot 61 */
void
Tk_DrawTextLayout(display, drawable, gc, layout, x, y, firstChar, lastChar)
    Display * display;
    Drawable drawable;
    GC gc;
    Tk_TextLayout layout;
    int x;
    int y;
    int firstChar;
    int lastChar;
{
    (tkStubsPtr->tk_DrawTextLayout)(display, drawable, gc, layout, x, y, firstChar, lastChar);
}

/* Slot 62 */
void
Tk_Fill3DPolygon(tkwin, drawable, border, pointPtr, numPoints, borderWidth, leftRelief)
    Tk_Window tkwin;
    Drawable drawable;
    Tk_3DBorder border;
    XPoint * pointPtr;
    int numPoints;
    int borderWidth;
    int leftRelief;
{
    (tkStubsPtr->tk_Fill3DPolygon)(tkwin, drawable, border, pointPtr, numPoints, borderWidth, leftRelief);
}

/* Slot 63 */
void
Tk_Fill3DRectangle(tkwin, drawable, border, x, y, width, height, borderWidth, relief)
    Tk_Window tkwin;
    Drawable drawable;
    Tk_3DBorder border;
    int x;
    int y;
    int width;
    int height;
    int borderWidth;
    int relief;
{
    (tkStubsPtr->tk_Fill3DRectangle)(tkwin, drawable, border, x, y, width, height, borderWidth, relief);
}

/* Slot 64 */
Tk_PhotoHandle
Tk_FindPhoto(interp, imageName)
    Tcl_Interp * interp;
    char * imageName;
{
    return (tkStubsPtr->tk_FindPhoto)(interp, imageName);
}

/* Slot 65 */
Font
Tk_FontId(font)
    Tk_Font font;
{
    return (tkStubsPtr->tk_FontId)(font);
}

/* Slot 66 */
void
Tk_Free3DBorder(border)
    Tk_3DBorder border;
{
    (tkStubsPtr->tk_Free3DBorder)(border);
}

/* Slot 67 */
void
Tk_FreeBitmap(display, bitmap)
    Display * display;
    Pixmap bitmap;
{
    (tkStubsPtr->tk_FreeBitmap)(display, bitmap);
}

/* Slot 68 */
void
Tk_FreeColor(colorPtr)
    XColor * colorPtr;
{
    (tkStubsPtr->tk_FreeColor)(colorPtr);
}

/* Slot 69 */
void
Tk_FreeColormap(display, colormap)
    Display * display;
    Colormap colormap;
{
    (tkStubsPtr->tk_FreeColormap)(display, colormap);
}

/* Slot 70 */
void
Tk_FreeCursor(display, cursor)
    Display * display;
    Tk_Cursor cursor;
{
    (tkStubsPtr->tk_FreeCursor)(display, cursor);
}

/* Slot 71 */
void
Tk_FreeFont(f)
    Tk_Font f;
{
    (tkStubsPtr->tk_FreeFont)(f);
}

/* Slot 72 */
void
Tk_FreeGC(display, gc)
    Display * display;
    GC gc;
{
    (tkStubsPtr->tk_FreeGC)(display, gc);
}

/* Slot 73 */
void
Tk_FreeImage(image)
    Tk_Image image;
{
    (tkStubsPtr->tk_FreeImage)(image);
}

/* Slot 74 */
void
Tk_FreeOptions(specs, widgRec, display, needFlags)
    Tk_ConfigSpec * specs;
    char * widgRec;
    Display * display;
    int needFlags;
{
    (tkStubsPtr->tk_FreeOptions)(specs, widgRec, display, needFlags);
}

/* Slot 75 */
void
Tk_FreePixmap(display, pixmap)
    Display * display;
    Pixmap pixmap;
{
    (tkStubsPtr->tk_FreePixmap)(display, pixmap);
}

/* Slot 76 */
void
Tk_FreeTextLayout(textLayout)
    Tk_TextLayout textLayout;
{
    (tkStubsPtr->tk_FreeTextLayout)(textLayout);
}

/* Slot 77 */
void
Tk_FreeXId(display, xid)
    Display * display;
    XID xid;
{
    (tkStubsPtr->tk_FreeXId)(display, xid);
}

/* Slot 78 */
GC
Tk_GCForColor(colorPtr, drawable)
    XColor * colorPtr;
    Drawable drawable;
{
    return (tkStubsPtr->tk_GCForColor)(colorPtr, drawable);
}

/* Slot 79 */
void
Tk_GeometryRequest(tkwin, reqWidth, reqHeight)
    Tk_Window tkwin;
    int reqWidth;
    int reqHeight;
{
    (tkStubsPtr->tk_GeometryRequest)(tkwin, reqWidth, reqHeight);
}

/* Slot 80 */
Tk_3DBorder
Tk_Get3DBorder(interp, tkwin, colorName)
    Tcl_Interp * interp;
    Tk_Window tkwin;
    Tk_Uid colorName;
{
    return (tkStubsPtr->tk_Get3DBorder)(interp, tkwin, colorName);
}

/* Slot 81 */
void
Tk_GetAllBindings(interp, bindingTable, object)
    Tcl_Interp * interp;
    Tk_BindingTable bindingTable;
    ClientData object;
{
    (tkStubsPtr->tk_GetAllBindings)(interp, bindingTable, object);
}

/* Slot 82 */
int
Tk_GetAnchor(interp, string, anchorPtr)
    Tcl_Interp * interp;
    char * string;
    Tk_Anchor * anchorPtr;
{
    return (tkStubsPtr->tk_GetAnchor)(interp, string, anchorPtr);
}

/* Slot 83 */
char *
Tk_GetAtomName(tkwin, atom)
    Tk_Window tkwin;
    Atom atom;
{
    return (tkStubsPtr->tk_GetAtomName)(tkwin, atom);
}

/* Slot 84 */
char *
Tk_GetBinding(interp, bindingTable, object, eventString)
    Tcl_Interp * interp;
    Tk_BindingTable bindingTable;
    ClientData object;
    char * eventString;
{
    return (tkStubsPtr->tk_GetBinding)(interp, bindingTable, object, eventString);
}

/* Slot 85 */
Pixmap
Tk_GetBitmap(interp, tkwin, string)
    Tcl_Interp * interp;
    Tk_Window tkwin;
    Tk_Uid string;
{
    return (tkStubsPtr->tk_GetBitmap)(interp, tkwin, string);
}

/* Slot 86 */
Pixmap
Tk_GetBitmapFromData(interp, tkwin, source, width, height)
    Tcl_Interp * interp;
    Tk_Window tkwin;
    char * source;
    int width;
    int height;
{
    return (tkStubsPtr->tk_GetBitmapFromData)(interp, tkwin, source, width, height);
}

/* Slot 87 */
int
Tk_GetCapStyle(interp, string, capPtr)
    Tcl_Interp * interp;
    char * string;
    int * capPtr;
{
    return (tkStubsPtr->tk_GetCapStyle)(interp, string, capPtr);
}

/* Slot 88 */
XColor *
Tk_GetColor(interp, tkwin, name)
    Tcl_Interp * interp;
    Tk_Window tkwin;
    Tk_Uid name;
{
    return (tkStubsPtr->tk_GetColor)(interp, tkwin, name);
}

/* Slot 89 */
XColor *
Tk_GetColorByValue(tkwin, colorPtr)
    Tk_Window tkwin;
    XColor * colorPtr;
{
    return (tkStubsPtr->tk_GetColorByValue)(tkwin, colorPtr);
}

/* Slot 90 */
Colormap
Tk_GetColormap(interp, tkwin, string)
    Tcl_Interp * interp;
    Tk_Window tkwin;
    char * string;
{
    return (tkStubsPtr->tk_GetColormap)(interp, tkwin, string);
}

/* Slot 91 */
Tk_Cursor
Tk_GetCursor(interp, tkwin, string)
    Tcl_Interp * interp;
    Tk_Window tkwin;
    Tk_Uid string;
{
    return (tkStubsPtr->tk_GetCursor)(interp, tkwin, string);
}

/* Slot 92 */
Tk_Cursor
Tk_GetCursorFromData(interp, tkwin, source, mask, width, height, xHot, yHot, fg, bg)
    Tcl_Interp * interp;
    Tk_Window tkwin;
    char * source;
    char * mask;
    int width;
    int height;
    int xHot;
    int yHot;
    Tk_Uid fg;
    Tk_Uid bg;
{
    return (tkStubsPtr->tk_GetCursorFromData)(interp, tkwin, source, mask, width, height, xHot, yHot, fg, bg);
}

/* Slot 93 */
Tk_Font
Tk_GetFont(interp, tkwin, string)
    Tcl_Interp * interp;
    Tk_Window tkwin;
    CONST char * string;
{
    return (tkStubsPtr->tk_GetFont)(interp, tkwin, string);
}

/* Slot 94 */
Tk_Font
Tk_GetFontFromObj(tkwin, objPtr)
    Tk_Window tkwin;
    Tcl_Obj * objPtr;
{
    return (tkStubsPtr->tk_GetFontFromObj)(tkwin, objPtr);
}

/* Slot 95 */
void
Tk_GetFontMetrics(font, fmPtr)
    Tk_Font font;
    Tk_FontMetrics * fmPtr;
{
    (tkStubsPtr->tk_GetFontMetrics)(font, fmPtr);
}

/* Slot 96 */
GC
Tk_GetGC(tkwin, valueMask, valuePtr)
    Tk_Window tkwin;
    unsigned long valueMask;
    XGCValues * valuePtr;
{
    return (tkStubsPtr->tk_GetGC)(tkwin, valueMask, valuePtr);
}

/* Slot 97 */
Tk_Image
Tk_GetImage(interp, tkwin, name, changeProc, clientData)
    Tcl_Interp * interp;
    Tk_Window tkwin;
    char * name;
    Tk_ImageChangedProc * changeProc;
    ClientData clientData;
{
    return (tkStubsPtr->tk_GetImage)(interp, tkwin, name, changeProc, clientData);
}

/* Slot 98 */
ClientData
Tk_GetImageMasterData(interp, name, typePtrPtr)
    Tcl_Interp * interp;
    char * name;
    Tk_ImageType ** typePtrPtr;
{
    return (tkStubsPtr->tk_GetImageMasterData)(interp, name, typePtrPtr);
}

/* Slot 99 */
Tk_ItemType *
Tk_GetItemTypes()
{
    return (tkStubsPtr->tk_GetItemTypes)();
}

/* Slot 100 */
int
Tk_GetJoinStyle(interp, string, joinPtr)
    Tcl_Interp * interp;
    char * string;
    int * joinPtr;
{
    return (tkStubsPtr->tk_GetJoinStyle)(interp, string, joinPtr);
}

/* Slot 101 */
int
Tk_GetJustify(interp, string, justifyPtr)
    Tcl_Interp * interp;
    char * string;
    Tk_Justify * justifyPtr;
{
    return (tkStubsPtr->tk_GetJustify)(interp, string, justifyPtr);
}

/* Slot 102 */
int
Tk_GetNumMainWindows()
{
    return (tkStubsPtr->tk_GetNumMainWindows)();
}

/* Slot 103 */
Tk_Uid
Tk_GetOption(tkwin, name, className)
    Tk_Window tkwin;
    char * name;
    char * className;
{
    return (tkStubsPtr->tk_GetOption)(tkwin, name, className);
}

/* Slot 104 */
int
Tk_GetPixels(interp, tkwin, string, intPtr)
    Tcl_Interp * interp;
    Tk_Window tkwin;
    char * string;
    int * intPtr;
{
    return (tkStubsPtr->tk_GetPixels)(interp, tkwin, string, intPtr);
}

/* Slot 105 */
Pixmap
Tk_GetPixmap(display, d, width, height, depth)
    Display * display;
    Drawable d;
    int width;
    int height;
    int depth;
{
    return (tkStubsPtr->tk_GetPixmap)(display, d, width, height, depth);
}

/* Slot 106 */
int
Tk_GetRelief(interp, name, reliefPtr)
    Tcl_Interp * interp;
    char * name;
    int * reliefPtr;
{
    return (tkStubsPtr->tk_GetRelief)(interp, name, reliefPtr);
}

/* Slot 107 */
void
Tk_GetRootCoords(tkwin, xPtr, yPtr)
    Tk_Window tkwin;
    int * xPtr;
    int * yPtr;
{
    (tkStubsPtr->tk_GetRootCoords)(tkwin, xPtr, yPtr);
}

/* Slot 108 */
int
Tk_GetScrollInfo(interp, argc, argv, dblPtr, intPtr)
    Tcl_Interp * interp;
    int argc;
    char ** argv;
    double * dblPtr;
    int * intPtr;
{
    return (tkStubsPtr->tk_GetScrollInfo)(interp, argc, argv, dblPtr, intPtr);
}

/* Slot 109 */
int
Tk_GetScreenMM(interp, tkwin, string, doublePtr)
    Tcl_Interp * interp;
    Tk_Window tkwin;
    char * string;
    double * doublePtr;
{
    return (tkStubsPtr->tk_GetScreenMM)(interp, tkwin, string, doublePtr);
}

/* Slot 110 */
int
Tk_GetSelection(interp, tkwin, selection, target, proc, clientData)
    Tcl_Interp * interp;
    Tk_Window tkwin;
    Atom selection;
    Atom target;
    Tk_GetSelProc * proc;
    ClientData clientData;
{
    return (tkStubsPtr->tk_GetSelection)(interp, tkwin, selection, target, proc, clientData);
}

/* Slot 111 */
Tk_Uid
Tk_GetUid(string)
    CONST char * string;
{
    return (tkStubsPtr->tk_GetUid)(string);
}

/* Slot 112 */
Visual *
Tk_GetVisual(interp, tkwin, string, depthPtr, colormapPtr)
    Tcl_Interp * interp;
    Tk_Window tkwin;
    char * string;
    int * depthPtr;
    Colormap * colormapPtr;
{
    return (tkStubsPtr->tk_GetVisual)(interp, tkwin, string, depthPtr, colormapPtr);
}

/* Slot 113 */
void
Tk_GetVRootGeometry(tkwin, xPtr, yPtr, widthPtr, heightPtr)
    Tk_Window tkwin;
    int * xPtr;
    int * yPtr;
    int * widthPtr;
    int * heightPtr;
{
    (tkStubsPtr->tk_GetVRootGeometry)(tkwin, xPtr, yPtr, widthPtr, heightPtr);
}

/* Slot 114 */
int
Tk_Grab(interp, tkwin, grabGlobal)
    Tcl_Interp * interp;
    Tk_Window tkwin;
    int grabGlobal;
{
    return (tkStubsPtr->tk_Grab)(interp, tkwin, grabGlobal);
}

/* Slot 115 */
void
Tk_HandleEvent(eventPtr)
    XEvent * eventPtr;
{
    (tkStubsPtr->tk_HandleEvent)(eventPtr);
}

/* Slot 116 */
Tk_Window
Tk_IdToWindow(display, window)
    Display * display;
    Window window;
{
    return (tkStubsPtr->tk_IdToWindow)(display, window);
}

/* Slot 117 */
void
Tk_ImageChanged(master, x, y, width, height, imageWidth, imageHeight)
    Tk_ImageMaster master;
    int x;
    int y;
    int width;
    int height;
    int imageWidth;
    int imageHeight;
{
    (tkStubsPtr->tk_ImageChanged)(master, x, y, width, height, imageWidth, imageHeight);
}

/* Slot 118 */
int
Tk_Init(interp)
    Tcl_Interp * interp;
{
    return (tkStubsPtr->tk_Init)(interp);
}

/* Slot 119 */
Atom
Tk_InternAtom(tkwin, name)
    Tk_Window tkwin;
    char * name;
{
    return (tkStubsPtr->tk_InternAtom)(tkwin, name);
}

/* Slot 120 */
int
Tk_IntersectTextLayout(layout, x, y, width, height)
    Tk_TextLayout layout;
    int x;
    int y;
    int width;
    int height;
{
    return (tkStubsPtr->tk_IntersectTextLayout)(layout, x, y, width, height);
}

/* Slot 121 */
void
Tk_MaintainGeometry(slave, master, x, y, width, height)
    Tk_Window slave;
    Tk_Window master;
    int x;
    int y;
    int width;
    int height;
{
    (tkStubsPtr->tk_MaintainGeometry)(slave, master, x, y, width, height);
}

/* Slot 122 */
Tk_Window
Tk_MainWindow(interp)
    Tcl_Interp * interp;
{
    return (tkStubsPtr->tk_MainWindow)(interp);
}

/* Slot 123 */
void
Tk_MakeWindowExist(tkwin)
    Tk_Window tkwin;
{
    (tkStubsPtr->tk_MakeWindowExist)(tkwin);
}

/* Slot 124 */
void
Tk_ManageGeometry(tkwin, mgrPtr, clientData)
    Tk_Window tkwin;
    Tk_GeomMgr * mgrPtr;
    ClientData clientData;
{
    (tkStubsPtr->tk_ManageGeometry)(tkwin, mgrPtr, clientData);
}

/* Slot 125 */
void
Tk_MapWindow(tkwin)
    Tk_Window tkwin;
{
    (tkStubsPtr->tk_MapWindow)(tkwin);
}

/* Slot 126 */
int
Tk_MeasureChars(tkfont, source, maxChars, maxPixels, flags, lengthPtr)
    Tk_Font tkfont;
    CONST char * source;
    int maxChars;
    int maxPixels;
    int flags;
    int * lengthPtr;
{
    return (tkStubsPtr->tk_MeasureChars)(tkfont, source, maxChars, maxPixels, flags, lengthPtr);
}

/* Slot 127 */
void
Tk_MoveResizeWindow(tkwin, x, y, width, height)
    Tk_Window tkwin;
    int x;
    int y;
    int width;
    int height;
{
    (tkStubsPtr->tk_MoveResizeWindow)(tkwin, x, y, width, height);
}

/* Slot 128 */
void
Tk_MoveWindow(tkwin, x, y)
    Tk_Window tkwin;
    int x;
    int y;
{
    (tkStubsPtr->tk_MoveWindow)(tkwin, x, y);
}

/* Slot 129 */
void
Tk_MoveToplevelWindow(tkwin, x, y)
    Tk_Window tkwin;
    int x;
    int y;
{
    (tkStubsPtr->tk_MoveToplevelWindow)(tkwin, x, y);
}

/* Slot 130 */
char *
Tk_NameOf3DBorder(border)
    Tk_3DBorder border;
{
    return (tkStubsPtr->tk_NameOf3DBorder)(border);
}

/* Slot 131 */
char *
Tk_NameOfAnchor(anchor)
    Tk_Anchor anchor;
{
    return (tkStubsPtr->tk_NameOfAnchor)(anchor);
}

/* Slot 132 */
char *
Tk_NameOfBitmap(display, bitmap)
    Display * display;
    Pixmap bitmap;
{
    return (tkStubsPtr->tk_NameOfBitmap)(display, bitmap);
}

/* Slot 133 */
char *
Tk_NameOfCapStyle(cap)
    int cap;
{
    return (tkStubsPtr->tk_NameOfCapStyle)(cap);
}

/* Slot 134 */
char *
Tk_NameOfColor(colorPtr)
    XColor * colorPtr;
{
    return (tkStubsPtr->tk_NameOfColor)(colorPtr);
}

/* Slot 135 */
char *
Tk_NameOfCursor(display, cursor)
    Display * display;
    Tk_Cursor cursor;
{
    return (tkStubsPtr->tk_NameOfCursor)(display, cursor);
}

/* Slot 136 */
char *
Tk_NameOfFont(font)
    Tk_Font font;
{
    return (tkStubsPtr->tk_NameOfFont)(font);
}

/* Slot 137 */
char *
Tk_NameOfImage(imageMaster)
    Tk_ImageMaster imageMaster;
{
    return (tkStubsPtr->tk_NameOfImage)(imageMaster);
}

/* Slot 138 */
char *
Tk_NameOfJoinStyle(join)
    int join;
{
    return (tkStubsPtr->tk_NameOfJoinStyle)(join);
}

/* Slot 139 */
char *
Tk_NameOfJustify(justify)
    Tk_Justify justify;
{
    return (tkStubsPtr->tk_NameOfJustify)(justify);
}

/* Slot 140 */
char *
Tk_NameOfRelief(relief)
    int relief;
{
    return (tkStubsPtr->tk_NameOfRelief)(relief);
}

/* Slot 141 */
Tk_Window
Tk_NameToWindow(interp, pathName, tkwin)
    Tcl_Interp * interp;
    char * pathName;
    Tk_Window tkwin;
{
    return (tkStubsPtr->tk_NameToWindow)(interp, pathName, tkwin);
}

/* Slot 142 */
void
Tk_OwnSelection(tkwin, selection, proc, clientData)
    Tk_Window tkwin;
    Atom selection;
    Tk_LostSelProc * proc;
    ClientData clientData;
{
    (tkStubsPtr->tk_OwnSelection)(tkwin, selection, proc, clientData);
}

/* Slot 143 */
int
Tk_ParseArgv(interp, tkwin, argcPtr, argv, argTable, flags)
    Tcl_Interp * interp;
    Tk_Window tkwin;
    int * argcPtr;
    char ** argv;
    Tk_ArgvInfo * argTable;
    int flags;
{
    return (tkStubsPtr->tk_ParseArgv)(interp, tkwin, argcPtr, argv, argTable, flags);
}

/* Slot 144 */
void
Tk_PhotoPutBlock(handle, blockPtr, x, y, width, height)
    Tk_PhotoHandle handle;
    Tk_PhotoImageBlock * blockPtr;
    int x;
    int y;
    int width;
    int height;
{
    (tkStubsPtr->tk_PhotoPutBlock)(handle, blockPtr, x, y, width, height);
}

/* Slot 145 */
void
Tk_PhotoPutZoomedBlock(handle, blockPtr, x, y, width, height, zoomX, zoomY, subsampleX, subsampleY)
    Tk_PhotoHandle handle;
    Tk_PhotoImageBlock * blockPtr;
    int x;
    int y;
    int width;
    int height;
    int zoomX;
    int zoomY;
    int subsampleX;
    int subsampleY;
{
    (tkStubsPtr->tk_PhotoPutZoomedBlock)(handle, blockPtr, x, y, width, height, zoomX, zoomY, subsampleX, subsampleY);
}

/* Slot 146 */
int
Tk_PhotoGetImage(handle, blockPtr)
    Tk_PhotoHandle handle;
    Tk_PhotoImageBlock * blockPtr;
{
    return (tkStubsPtr->tk_PhotoGetImage)(handle, blockPtr);
}

/* Slot 147 */
void
Tk_PhotoBlank(handle)
    Tk_PhotoHandle handle;
{
    (tkStubsPtr->tk_PhotoBlank)(handle);
}

/* Slot 148 */
void
Tk_PhotoExpand(handle, width, height)
    Tk_PhotoHandle handle;
    int width;
    int height;
{
    (tkStubsPtr->tk_PhotoExpand)(handle, width, height);
}

/* Slot 149 */
void
Tk_PhotoGetSize(handle, widthPtr, heightPtr)
    Tk_PhotoHandle handle;
    int * widthPtr;
    int * heightPtr;
{
    (tkStubsPtr->tk_PhotoGetSize)(handle, widthPtr, heightPtr);
}

/* Slot 150 */
void
Tk_PhotoSetSize(handle, width, height)
    Tk_PhotoHandle handle;
    int width;
    int height;
{
    (tkStubsPtr->tk_PhotoSetSize)(handle, width, height);
}

/* Slot 151 */
int
Tk_PointToChar(layout, x, y)
    Tk_TextLayout layout;
    int x;
    int y;
{
    return (tkStubsPtr->tk_PointToChar)(layout, x, y);
}

/* Slot 152 */
int
Tk_PostscriptFontName(tkfont, dsPtr)
    Tk_Font tkfont;
    Tcl_DString * dsPtr;
{
    return (tkStubsPtr->tk_PostscriptFontName)(tkfont, dsPtr);
}

/* Slot 153 */
void
Tk_PreserveColormap(display, colormap)
    Display * display;
    Colormap colormap;
{
    (tkStubsPtr->tk_PreserveColormap)(display, colormap);
}

/* Slot 154 */
void
Tk_QueueWindowEvent(eventPtr, position)
    XEvent * eventPtr;
    Tcl_QueuePosition position;
{
    (tkStubsPtr->tk_QueueWindowEvent)(eventPtr, position);
}

/* Slot 155 */
void
Tk_RedrawImage(image, imageX, imageY, width, height, drawable, drawableX, drawableY)
    Tk_Image image;
    int imageX;
    int imageY;
    int width;
    int height;
    Drawable drawable;
    int drawableX;
    int drawableY;
{
    (tkStubsPtr->tk_RedrawImage)(image, imageX, imageY, width, height, drawable, drawableX, drawableY);
}

/* Slot 156 */
void
Tk_ResizeWindow(tkwin, width, height)
    Tk_Window tkwin;
    int width;
    int height;
{
    (tkStubsPtr->tk_ResizeWindow)(tkwin, width, height);
}

/* Slot 157 */
int
Tk_RestackWindow(tkwin, aboveBelow, other)
    Tk_Window tkwin;
    int aboveBelow;
    Tk_Window other;
{
    return (tkStubsPtr->tk_RestackWindow)(tkwin, aboveBelow, other);
}

/* Slot 158 */
Tk_RestrictProc *
Tk_RestrictEvents(proc, arg, prevArgPtr)
    Tk_RestrictProc * proc;
    ClientData arg;
    ClientData * prevArgPtr;
{
    return (tkStubsPtr->tk_RestrictEvents)(proc, arg, prevArgPtr);
}

/* Slot 159 */
int
Tk_SafeInit(interp)
    Tcl_Interp * interp;
{
    return (tkStubsPtr->tk_SafeInit)(interp);
}

/* Slot 160 */
char *
Tk_SetAppName(tkwin, name)
    Tk_Window tkwin;
    char * name;
{
    return (tkStubsPtr->tk_SetAppName)(tkwin, name);
}

/* Slot 161 */
void
Tk_SetBackgroundFromBorder(tkwin, border)
    Tk_Window tkwin;
    Tk_3DBorder border;
{
    (tkStubsPtr->tk_SetBackgroundFromBorder)(tkwin, border);
}

/* Slot 162 */
void
Tk_SetClass(tkwin, className)
    Tk_Window tkwin;
    char * className;
{
    (tkStubsPtr->tk_SetClass)(tkwin, className);
}

/* Slot 163 */
void
Tk_SetGrid(tkwin, reqWidth, reqHeight, gridWidth, gridHeight)
    Tk_Window tkwin;
    int reqWidth;
    int reqHeight;
    int gridWidth;
    int gridHeight;
{
    (tkStubsPtr->tk_SetGrid)(tkwin, reqWidth, reqHeight, gridWidth, gridHeight);
}

/* Slot 164 */
void
Tk_SetInternalBorder(tkwin, width)
    Tk_Window tkwin;
    int width;
{
    (tkStubsPtr->tk_SetInternalBorder)(tkwin, width);
}

/* Slot 165 */
void
Tk_SetWindowBackground(tkwin, pixel)
    Tk_Window tkwin;
    unsigned long pixel;
{
    (tkStubsPtr->tk_SetWindowBackground)(tkwin, pixel);
}

/* Slot 166 */
void
Tk_SetWindowBackgroundPixmap(tkwin, pixmap)
    Tk_Window tkwin;
    Pixmap pixmap;
{
    (tkStubsPtr->tk_SetWindowBackgroundPixmap)(tkwin, pixmap);
}

/* Slot 167 */
void
Tk_SetWindowBorder(tkwin, pixel)
    Tk_Window tkwin;
    unsigned long pixel;
{
    (tkStubsPtr->tk_SetWindowBorder)(tkwin, pixel);
}

/* Slot 168 */
void
Tk_SetWindowBorderWidth(tkwin, width)
    Tk_Window tkwin;
    int width;
{
    (tkStubsPtr->tk_SetWindowBorderWidth)(tkwin, width);
}

/* Slot 169 */
void
Tk_SetWindowBorderPixmap(tkwin, pixmap)
    Tk_Window tkwin;
    Pixmap pixmap;
{
    (tkStubsPtr->tk_SetWindowBorderPixmap)(tkwin, pixmap);
}

/* Slot 170 */
void
Tk_SetWindowColormap(tkwin, colormap)
    Tk_Window tkwin;
    Colormap colormap;
{
    (tkStubsPtr->tk_SetWindowColormap)(tkwin, colormap);
}

/* Slot 171 */
int
Tk_SetWindowVisual(tkwin, visual, depth, colormap)
    Tk_Window tkwin;
    Visual * visual;
    int depth;
    Colormap colormap;
{
    return (tkStubsPtr->tk_SetWindowVisual)(tkwin, visual, depth, colormap);
}

/* Slot 172 */
void
Tk_SizeOfBitmap(display, bitmap, widthPtr, heightPtr)
    Display * display;
    Pixmap bitmap;
    int * widthPtr;
    int * heightPtr;
{
    (tkStubsPtr->tk_SizeOfBitmap)(display, bitmap, widthPtr, heightPtr);
}

/* Slot 173 */
void
Tk_SizeOfImage(image, widthPtr, heightPtr)
    Tk_Image image;
    int * widthPtr;
    int * heightPtr;
{
    (tkStubsPtr->tk_SizeOfImage)(image, widthPtr, heightPtr);
}

/* Slot 174 */
int
Tk_StrictMotif(tkwin)
    Tk_Window tkwin;
{
    return (tkStubsPtr->tk_StrictMotif)(tkwin);
}

/* Slot 175 */
void
Tk_TextLayoutToPostscript(interp, layout)
    Tcl_Interp * interp;
    Tk_TextLayout layout;
{
    (tkStubsPtr->tk_TextLayoutToPostscript)(interp, layout);
}

/* Slot 176 */
int
Tk_TextWidth(font, string, numChars)
    Tk_Font font;
    CONST char * string;
    int numChars;
{
    return (tkStubsPtr->tk_TextWidth)(font, string, numChars);
}

/* Slot 177 */
void
Tk_UndefineCursor(window)
    Tk_Window window;
{
    (tkStubsPtr->tk_UndefineCursor)(window);
}

/* Slot 178 */
void
Tk_UnderlineChars(display, drawable, gc, tkfont, source, x, y, firstChar, lastChar)
    Display * display;
    Drawable drawable;
    GC gc;
    Tk_Font tkfont;
    CONST char * source;
    int x;
    int y;
    int firstChar;
    int lastChar;
{
    (tkStubsPtr->tk_UnderlineChars)(display, drawable, gc, tkfont, source, x, y, firstChar, lastChar);
}

/* Slot 179 */
void
Tk_UnderlineTextLayout(display, drawable, gc, layout, x, y, underline)
    Display * display;
    Drawable drawable;
    GC gc;
    Tk_TextLayout layout;
    int x;
    int y;
    int underline;
{
    (tkStubsPtr->tk_UnderlineTextLayout)(display, drawable, gc, layout, x, y, underline);
}

/* Slot 180 */
void
Tk_Ungrab(tkwin)
    Tk_Window tkwin;
{
    (tkStubsPtr->tk_Ungrab)(tkwin);
}

/* Slot 181 */
void
Tk_UnmaintainGeometry(slave, master)
    Tk_Window slave;
    Tk_Window master;
{
    (tkStubsPtr->tk_UnmaintainGeometry)(slave, master);
}

/* Slot 182 */
void
Tk_UnmapWindow(tkwin)
    Tk_Window tkwin;
{
    (tkStubsPtr->tk_UnmapWindow)(tkwin);
}

/* Slot 183 */
void
Tk_UnsetGrid(tkwin)
    Tk_Window tkwin;
{
    (tkStubsPtr->tk_UnsetGrid)(tkwin);
}

/* Slot 184 */
void
Tk_UpdatePointer(tkwin, x, y, state)
    Tk_Window tkwin;
    int x;
    int y;
    int state;
{
    (tkStubsPtr->tk_UpdatePointer)(tkwin, x, y, state);
}

/* Slot 185 */
Pixmap
Tk_AllocBitmapFromObj(interp, tkwin, objPtr)
    Tcl_Interp * interp;
    Tk_Window tkwin;
    Tcl_Obj * objPtr;
{
    return (tkStubsPtr->tk_AllocBitmapFromObj)(interp, tkwin, objPtr);
}

/* Slot 186 */
Tk_3DBorder
Tk_Alloc3DBorderFromObj(interp, tkwin, objPtr)
    Tcl_Interp * interp;
    Tk_Window tkwin;
    Tcl_Obj * objPtr;
{
    return (tkStubsPtr->tk_Alloc3DBorderFromObj)(interp, tkwin, objPtr);
}

/* Slot 187 */
XColor *
Tk_AllocColorFromObj(interp, tkwin, objPtr)
    Tcl_Interp * interp;
    Tk_Window tkwin;
    Tcl_Obj * objPtr;
{
    return (tkStubsPtr->tk_AllocColorFromObj)(interp, tkwin, objPtr);
}

/* Slot 188 */
Tk_Cursor
Tk_AllocCursorFromObj(interp, tkwin, objPtr)
    Tcl_Interp * interp;
    Tk_Window tkwin;
    Tcl_Obj * objPtr;
{
    return (tkStubsPtr->tk_AllocCursorFromObj)(interp, tkwin, objPtr);
}

/* Slot 189 */
Tk_Font
Tk_AllocFontFromObj(interp, tkwin, objPtr)
    Tcl_Interp * interp;
    Tk_Window tkwin;
    Tcl_Obj * objPtr;
{
    return (tkStubsPtr->tk_AllocFontFromObj)(interp, tkwin, objPtr);
}

/* Slot 190 */
Tk_OptionTable
Tk_CreateOptionTable(interp, templatePtr)
    Tcl_Interp * interp;
    CONST Tk_OptionSpec * templatePtr;
{
    return (tkStubsPtr->tk_CreateOptionTable)(interp, templatePtr);
}

/* Slot 191 */
void
Tk_DeleteOptionTable(optionTable)
    Tk_OptionTable optionTable;
{
    (tkStubsPtr->tk_DeleteOptionTable)(optionTable);
}

/* Slot 192 */
void
Tk_Free3DBorderFromObj(tkwin, objPtr)
    Tk_Window tkwin;
    Tcl_Obj * objPtr;
{
    (tkStubsPtr->tk_Free3DBorderFromObj)(tkwin, objPtr);
}

/* Slot 193 */
void
Tk_FreeBitmapFromObj(tkwin, objPtr)
    Tk_Window tkwin;
    Tcl_Obj * objPtr;
{
    (tkStubsPtr->tk_FreeBitmapFromObj)(tkwin, objPtr);
}

/* Slot 194 */
void
Tk_FreeColorFromObj(tkwin, objPtr)
    Tk_Window tkwin;
    Tcl_Obj * objPtr;
{
    (tkStubsPtr->tk_FreeColorFromObj)(tkwin, objPtr);
}

/* Slot 195 */
void
Tk_FreeConfigOptions(recordPtr, optionToken, tkwin)
    char * recordPtr;
    Tk_OptionTable optionToken;
    Tk_Window tkwin;
{
    (tkStubsPtr->tk_FreeConfigOptions)(recordPtr, optionToken, tkwin);
}

/* Slot 196 */
void
Tk_FreeSavedOptions(savePtr)
    Tk_SavedOptions * savePtr;
{
    (tkStubsPtr->tk_FreeSavedOptions)(savePtr);
}

/* Slot 197 */
void
Tk_FreeCursorFromObj(tkwin, objPtr)
    Tk_Window tkwin;
    Tcl_Obj * objPtr;
{
    (tkStubsPtr->tk_FreeCursorFromObj)(tkwin, objPtr);
}

/* Slot 198 */
void
Tk_FreeFontFromObj(tkwin, objPtr)
    Tk_Window tkwin;
    Tcl_Obj * objPtr;
{
    (tkStubsPtr->tk_FreeFontFromObj)(tkwin, objPtr);
}

/* Slot 199 */
Tk_3DBorder
Tk_Get3DBorderFromObj(tkwin, objPtr)
    Tk_Window tkwin;
    Tcl_Obj * objPtr;
{
    return (tkStubsPtr->tk_Get3DBorderFromObj)(tkwin, objPtr);
}

/* Slot 200 */
int
Tk_GetAnchorFromObj(interp, objPtr, anchorPtr)
    Tcl_Interp * interp;
    Tcl_Obj * objPtr;
    Tk_Anchor * anchorPtr;
{
    return (tkStubsPtr->tk_GetAnchorFromObj)(interp, objPtr, anchorPtr);
}

/* Slot 201 */
Pixmap
Tk_GetBitmapFromObj(tkwin, objPtr)
    Tk_Window tkwin;
    Tcl_Obj * objPtr;
{
    return (tkStubsPtr->tk_GetBitmapFromObj)(tkwin, objPtr);
}

/* Slot 202 */
XColor *
Tk_GetColorFromObj(tkwin, objPtr)
    Tk_Window tkwin;
    Tcl_Obj * objPtr;
{
    return (tkStubsPtr->tk_GetColorFromObj)(tkwin, objPtr);
}

/* Slot 203 */
Tk_Cursor
Tk_GetCursorFromObj(tkwin, objPtr)
    Tk_Window tkwin;
    Tcl_Obj * objPtr;
{
    return (tkStubsPtr->tk_GetCursorFromObj)(tkwin, objPtr);
}

/* Slot 204 */
Tcl_Obj *
Tk_GetOptionInfo(interp, recordPtr, optionTable, namePtr, tkwin)
    Tcl_Interp * interp;
    char * recordPtr;
    Tk_OptionTable optionTable;
    Tcl_Obj * namePtr;
    Tk_Window tkwin;
{
    return (tkStubsPtr->tk_GetOptionInfo)(interp, recordPtr, optionTable, namePtr, tkwin);
}

/* Slot 205 */
Tcl_Obj *
Tk_GetOptionValue(interp, recordPtr, optionTable, namePtr, tkwin)
    Tcl_Interp * interp;
    char * recordPtr;
    Tk_OptionTable optionTable;
    Tcl_Obj * namePtr;
    Tk_Window tkwin;
{
    return (tkStubsPtr->tk_GetOptionValue)(interp, recordPtr, optionTable, namePtr, tkwin);
}

/* Slot 206 */
int
Tk_GetJustifyFromObj(interp, objPtr, justifyPtr)
    Tcl_Interp * interp;
    Tcl_Obj * objPtr;
    Tk_Justify * justifyPtr;
{
    return (tkStubsPtr->tk_GetJustifyFromObj)(interp, objPtr, justifyPtr);
}

/* Slot 207 */
int
Tk_GetMMFromObj(interp, tkwin, objPtr, doublePtr)
    Tcl_Interp * interp;
    Tk_Window tkwin;
    Tcl_Obj * objPtr;
    double * doublePtr;
{
    return (tkStubsPtr->tk_GetMMFromObj)(interp, tkwin, objPtr, doublePtr);
}

/* Slot 208 */
int
Tk_GetPixelsFromObj(interp, tkwin, objPtr, intPtr)
    Tcl_Interp * interp;
    Tk_Window tkwin;
    Tcl_Obj * objPtr;
    int * intPtr;
{
    return (tkStubsPtr->tk_GetPixelsFromObj)(interp, tkwin, objPtr, intPtr);
}

/* Slot 209 */
int
Tk_GetReliefFromObj(interp, objPtr, resultPtr)
    Tcl_Interp * interp;
    Tcl_Obj * objPtr;
    int * resultPtr;
{
    return (tkStubsPtr->tk_GetReliefFromObj)(interp, objPtr, resultPtr);
}

/* Slot 210 */
int
Tk_GetScrollInfoObj(interp, objc, objv, dblPtr, intPtr)
    Tcl_Interp * interp;
    int objc;
    Tcl_Obj *CONST objv[];
    double * dblPtr;
    int * intPtr;
{
    return (tkStubsPtr->tk_GetScrollInfoObj)(interp, objc, objv, dblPtr, intPtr);
}

/* Slot 211 */
int
Tk_InitOptions(interp, recordPtr, optionToken, tkwin)
    Tcl_Interp * interp;
    char * recordPtr;
    Tk_OptionTable optionToken;
    Tk_Window tkwin;
{
    return (tkStubsPtr->tk_InitOptions)(interp, recordPtr, optionToken, tkwin);
}

/* Slot 212 */
void
Tk_MainEx(argc, argv, appInitProc, interp)
    int argc;
    char ** argv;
    Tcl_AppInitProc * appInitProc;
    Tcl_Interp * interp;
{
    (tkStubsPtr->tk_MainEx)(argc, argv, appInitProc, interp);
}

/* Slot 213 */
void
Tk_RestoreSavedOptions(savePtr)
    Tk_SavedOptions * savePtr;
{
    (tkStubsPtr->tk_RestoreSavedOptions)(savePtr);
}

/* Slot 214 */
int
Tk_SetOptions(interp, recordPtr, optionTable, objc, objv, tkwin, savePtr, maskPtr)
    Tcl_Interp * interp;
    char * recordPtr;
    Tk_OptionTable optionTable;
    int objc;
    Tcl_Obj *CONST objv[];
    Tk_Window tkwin;
    Tk_SavedOptions * savePtr;
    int * maskPtr;
{
    return (tkStubsPtr->tk_SetOptions)(interp, recordPtr, optionTable, objc, objv, tkwin, savePtr, maskPtr);
}


/* !END!: Do not edit above this line. */
