'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) $Id: glob.n,v 1.8 2000/09/07 14:27:48 poenitz Exp $
'\" 
.so man.macros
.TH glob n 8.3 Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
glob \- Return names of files that match patterns
.SH SYNOPSIS
\fBglob \fR?\fIswitches\fR? \fIpattern \fR?\fIpattern ...\fR?
.BE

.SH DESCRIPTION
.PP
This command performs file name ``globbing'' in a fashion similar to
the csh shell.  It returns a list of the files whose names match any
of the \fIpattern\fR arguments.
.LP
If the initial arguments to \fBglob\fR start with \fB\-\fR then
they are treated as switches.  The following switches are
currently supported:
.VS 8.3
.TP
\fB\-directory\fR \fIdirectory\fR
Search for files which match the given patterns starting in the given
\fIdirectory\fR.  This allows searching of directories whose name
contains glob-sensitive characters without the need to quote such
characters explicitly.  This option may not be used in conjunction with
\fB\-path\fR.
.TP
\fB\-join\fR
The remaining pattern arguments are treated as a single pattern
obtained by joining the arguments with directory separators.
.VE 8.3
.TP
\fB\-nocomplain\fR
Allows an empty list to be returned without error;  without this
switch an error is returned if the result list would be empty.
.VS 8.3
.TP
\fB\-path\fR \fIpathPrefix\fR
Search for files with the given \fIpathPrefix\fR where the rest of the name
matches the given patterns.  This allows searching for files with names
similar to a given file even when the names contain glob-sensitive
characters.  This option may not be used in conjunction with
\fB\-directory\fR.
.TP
\fB\-types\fR \fItypeList\fR
Only list files or directories which match \fItypeList\fR, where the items
in the list have two forms.  The first form is like the \-type option of
the Unix find command:
\fIb\fR (block special file),
\fIc\fR (character special file),
\fId\fR (directory),
\fIf\fR (plain file),
\fIl\fR (symbolic link),
\fIp\fR (named pipe),
or \fIs\fR (socket), where multiple types may be specified in the list.
\fBGlob\fR will return all files which match at least one of the types given.
.RS
.PP
The second form specifies types where all the types given must match.
These are \fIr\fR, \fIw\fR, \fIx\fR as file permissions, and
\fIreadonly\fR, \fIhidden\fR as special permission cases.  On the
Macintosh, MacOS types and creators are also supported, where any item
which is four characters long is assumed to be a MacOS type
(e.g. \fBTEXT\fR).  Items which are of the form \fI{macintosh type XXXX}\fR
or \fI{macintosh creator XXXX}\fR will match types or creators
respectively.  Unrecognised types, or specifications of multiple MacOS
types/creators will signal an error.
.PP
The two forms may be mixed, so \fB\-types {d f r w}\fR will find all
regular files OR directories that have both read AND write permissions.
The following are equivalent:
.RS
.CS
\fBglob \-type d *\fR
\fBglob */\fR
.CE
.RE
except that the first case doesn't return the trailing ``/'' and
is more platform independent.
.RE
.VE 8.3
.TP
\fB\-\|\-\fR
Marks the end of switches.  The argument following this one will
be treated as a \fIpattern\fR even if it starts with a \fB\-\fR.
.PP
The \fIpattern\fR arguments may contain any of the following
special characters:
.TP 10
\fB?\fR
Matches any single character.
.TP 10
\fB*\fR
Matches any sequence of zero or more characters.
.TP 10
\fB[\fIchars\fB]\fR
Matches any single character in \fIchars\fR.  If \fIchars\fR
contains a sequence of the form \fIa\fB\-\fIb\fR then any
character between \fIa\fR and \fIb\fR (inclusive) will match.
.TP 10
\fB\e\fIx\fR
Matches the character \fIx\fR.
.TP 10
\fB{\fIa\fB,\fIb\fB,\fI...\fR}
Matches any of the strings \fIa\fR, \fIb\fR, etc.
.LP
As with csh, a  ``.'' at the beginning of a file's name or just
after a ``/'' must be matched explicitly or with a {} construct.
In addition, all ``/'' characters must be matched explicitly.
.LP
If the first character in a \fIpattern\fR is ``~'' then it refers
to the home directory for the user whose name follows the ``~''.
If the ``~'' is followed immediately by ``/'' then the value of
the HOME environment variable is used.
.LP
The \fBglob\fR command differs from csh globbing in two ways.
First, it does not sort its result list (use the \fBlsort\fR
command if you want the list sorted).
Second, \fBglob\fR only returns the names of files that actually
exist;  in csh no check for existence is made unless a pattern
contains a ?, *, or [] construct.

.SH "PORTABILITY ISSUES"
.PP
Unlike other Tcl commands that will accept both network and native
style names (see the \fBfilename\fR manual entry for details on how
native and network names are specified), the \fBglob\fR command only
accepts native names.  
.TP
\fBWindows\fR
.
For Windows UNC names, the servername and sharename components of the path
may not contain ?, *, or [] constructs.  On Windows NT, if \fIpattern\fR is
of the form ``\fB~\fIusername\fB@\fIdomain\fR'' it refers to the home
directory of the user whose account information resides on the specified NT
domain server.  Otherwise, user account information is obtained from
the local computer.  On Windows 95 and 98, \fBglob\fR accepts patterns
like ``.../'' and ``..../'' for successively higher up parent directories.
.TP 
\fBMacintosh\fR 
. 
When using the options, \fB\-dir\fR, \fB\-join\fR or \fB\-path\fR, glob
assumes the directory separator for the entire pattern is the standard
``:''.  When not using these options, glob examines each pattern argument
and uses ``/'' unless the pattern contains a ``:''.

.SH "SEE ALSO"
file(n)

.SH KEYWORDS
exist, file, glob, pattern
