proc audiocmd {char} {
    global AudioPipe
    puts -nonewline $AudioPipe $char ;# Record
    flush $AudioPipe
}

proc dorecord {widget} {
    $widget configure -command "dosuspend $widget" -text Suspend
    audiocmd r
}
proc dosuspend {widget} {
    global AudioPipe
    $widget configure -command "dorecord $widget" -text Record
    audiocmd s
}


proc updatesize {filename} {
  catch {
    set size [format "%10d" [file size $filename]]

    catch {expr $size/8000}  seconds
    catch {expr $seconds/60} minutes

    if ![catch {.recorder.size configure -text "Messagesize $size" }] {
       set timestr [format "%2d:%02d" $minutes $seconds]
       catch {.recorder.time configure -text "Time             $timestr" }

       after 2000 updatesize $filename
    }  ;#else destroyed
  }
}

proc newaupipe {} {
    global AudioPipe
    set tmpfile "/tmp/[pid].au"
    catch {exec rm -f $tmpfile}
    set result [catch {open "|mic | sox -t ub - -t ul - >$tmpfile" w} AudioPipe]
    return $result
}

proc doplay {} {
    dosuspend .recorder.startstop
    update
    after 500           ;# let it close
    catch {exec cp /tmp/[pid].au /dev/audio} err
}

proc auclear {} {
    dosuspend .recorder.startstop
    audiocmd q
    after 500
    catch {exec /true > /tmp/[pid].au}
    updatesize /tmp/[pid].au
    newaupipe
}

proc SeditInsertAudio { draft t } {
    global sedit
    global AudioPipe
    global recorddone

    set tmpfile "/tmp/[pid].au"
#   puts stderr $tmpfile

    if ![file exists /dev/audio/mic] {
       tk_dialog .d "Installation Problem" {Device "/dev/audio/mic" missing"} \
          warning -1 Dismiss
       return
    }
    if [newaupipe] {
       tk_dialog .d "Unexpected Problem" "Could not execute audio recorder $AudioPipe" \
          warning -1 Dismiss
       return
    }

    toplevel .recorder -class Dialog -relief raised -borderwidth 4
    frame  .recorder.deco -relief groove -borderwidth 4
    button .recorder.startstop -text Record -command {dorecord .recorder.startstop}
    button .recorder.abort     -text Abort  -command {audiocmd q; set   recorddone -1}
    button .recorder.clear     -text "  Clear  "  -command {auclear}
    button .recorder.ok        -text OK     -command {audiocmd q; set   recorddone +1}
    button .recorder.play      -text Play   -command {doplay}
    label  .recorder.size      -text {Messagesize 0}
    label  .recorder.time      -text {Time        0}

    pack .recorder.startstop .recorder.play .recorder.clear .recorder.abort .recorder.ok \
       -in .recorder.deco -padx 2m -pady 1m -fill x

    pack .recorder.deco .recorder.size .recorder.time -padx 2m -pady 1m -fill x

    updatesize $tmpfile
    set recorddone 0
    tkwait variable recorddone

    destroy .recorder
    close $AudioPipe

    if ([file size $tmpfile]<1000) {set recorddone -1}

    if $recorddone>0 {
       set options [list 1 base64 audio/basic voicemail]
       eval {SeditInsertFile $draft $t $tmpfile} $options
    }
    catch {exec rm $tmpfile}
}

