# mimeSun.tcl
# Support to frob X-sun-attachments into mime format
# There are just a couple checks in mime.tcl,
# and then these routines massage the header information

# This is called from Mime_Init
proc MimeSunInit {} {
    global mimeSunMap
    #
    # This map is generated by the ce.process script in the exmh misc directory
    # It looks at the Classing Engine database as output by the ce_db_build
    # program and makes some decisions about a MIME type.

    set mimeSunMap(binder-prog)        {application/x-sun-prog; prog=binder}
    set mimeSunMap(calctool-prog)      {application/x-sun-prog; prog=calctool}
    set mimeSunMap(ae-prog)            {application/x-sun-prog; prog=ae}
    set mimeSunMap(clock-prog)         {application/x-sun-prog; prog=clock}
    set mimeSunMap(cmdtool-prog)       {application/x-sun-prog; prog=cmdtool}
    set mimeSunMap(colorchooser)       application/x-colorchooser
    set mimeSunMap(dbxtool-prog)       {application/x-sun-prog; prog=dbxtool}
    set mimeSunMap(cm-prog)            {application/x-sun-prog; prog=cm}
    set mimeSunMap(experiment)         text/plain
    set mimeSunMap(filemgr-prog)       {application/x-sun-prog; prog=filemgr}
    set mimeSunMap(fontedit-prog)      {application/x-sun-prog; prog=fontedit}
    set mimeSunMap(iconedit-prog)      {application/x-sun-prog; prog=iconedit}
    set mimeSunMap(imagetool-prog)     {application/x-sun-prog; prog=imagetool}
    set mimeSunMap(mailtool-prog)      {application/x-sun-prog; prog=mailtool}
    set mimeSunMap(window-prog)        {application/x-sun-prog; prog=window}
    set mimeSunMap(perfmeter-prog)     {application/x-sun-prog; prog=perfmeter}
    set mimeSunMap(printtool-prog)     {application/x-sun-prog; prog=printtool}
    set mimeSunMap(shelltool-prog)     {application/x-sun-prog; prog=shelltool}
    set mimeSunMap(snapshot-prog)      {application/x-sun-prog; prog=snapshot}
    set mimeSunMap(sundraw-prog)       {application/x-sun-prog; prog=sundraw}
    set mimeSunMap(IslandDraw-prog)    {application/x-sun-prog; prog=IslandDraw}
    set mimeSunMap(sunpaint-prog)      {application/x-sun-prog; prog=sunpaint}
    set mimeSunMap(IslandPaint-prog)   {application/x-sun-prog; prog=IslandPaint}
    set mimeSunMap(sunwrite-prog)      {application/x-sun-prog; prog=sunwrite}
    set mimeSunMap(IslandWrite-prog)   {application/x-sun-prog; prog=IslandWrite}
    set mimeSunMap(tapetool-prog)      {application/x-sun-prog; prog=tapetool}
    set mimeSunMap(textedit-prog)      {application/x-sun-prog; prog=textedit}
    set mimeSunMap(X-prog)             {application/x-sun-prog; prog=X}
    set mimeSunMap(sun-raster)         image/x-sun-raster
    set mimeSunMap(sun-icon-image)     image/x-sun-icon
    set mimeSunMap(lotus-spreadsheet)  application/x-lotus-123
    set mimeSunMap(pict-file)          image/x-pict
    set mimeSunMap(ppm-file)           image/x-ppm
    set mimeSunMap(photocd-file)       image/x-photocd
    set mimeSunMap(pj-file)            image/x-pj
    set mimeSunMap(pgm-file)           image/x-pgm
    set mimeSunMap(pbm-file)           image/x-pbm
    set mimeSunMap(ilbm-file)          image/x-ilbm
    set mimeSunMap(pi1-file)           image/x-pi1
    set mimeSunMap(pcx-file)           image/x-pcx
    set mimeSunMap(tga-file)           image/x-tga
    set mimeSunMap(yuv-file)           image/x-yuv
    set mimeSunMap(xim-file)           image/x-xim
    set mimeSunMap(mtv-file)           image/x-mtv
    set mimeSunMap(qrt-file)           image/x-qrt
    set mimeSunMap(imgw-file)          image/x-imgw
    set mimeSunMap(sld-file)           image/x-sld
    set mimeSunMap(spc-file)           image/x-spc
    set mimeSunMap(spu-file)           image/x-spu
    set mimeSunMap(gould-file)         image/x-gould
    set mimeSunMap(raw-file)           image/x-raw
    set mimeSunMap(rgb3-file)          image/x-rgb3
    set mimeSunMap(fs-file)            image/x-fs
    set mimeSunMap(fits-file)          image/x-fits
    set mimeSunMap(lispm-file)         image/x-lispm
    set mimeSunMap(rawg-file)          image/x-rawg
    set mimeSunMap(hips-file)          image/x-hips
    set mimeSunMap(mac-file)           image/x-mac
    set mimeSunMap(atk-file)           image/x-atk
    set mimeSunMap(brush-file)         image/x-brush
    set mimeSunMap(cmu-file)           image/x-cmu
    set mimeSunMap(mgr-file)           image/x-mgr
    set mimeSunMap(g3-file)            image/x-g3
    set mimeSunMap(img-file)           image/x-img
    set mimeSunMap(pi3-file)           image/x-pi3
    set mimeSunMap(xbm-file)           image/x-xbm
    set mimeSunMap(ybm-file)           image/x-ybm
    set mimeSunMap(xwd-file)           image/x-xwd
    set mimeSunMap(msdos-executable)   application/x-dos
    set mimeSunMap(compress)           application/x-compress
    set mimeSunMap(framemaker-document) application/x-frame
    set mimeSunMap(mail-file)          message/rfc822
    set mimeSunMap(mail-message)       text/plain
    set mimeSunMap(gif-file)           image/gif
    set mimeSunMap(tiff-file)          image/x-tiff
    set mimeSunMap(jpeg-file)          image/jpeg
    set mimeSunMap(sunwrite-document)  application/x-sunwrite
    set mimeSunMap(IslandWrite-document) application/x-IslandWrite
    set mimeSunMap(font-file)          application/x-fontedit
    set mimeSunMap(sundraw-document)   application/x-sundraw
    set mimeSunMap(IslandDraw-document) application/x-IslandDraw
    set mimeSunMap(ae-file)            application/x-suncalendar
    set mimeSunMap(audio-file)         audio/x-sunaudio
    set mimeSunMap(audio-prog)         {application/x-sun-prog; prog=audio}
    set mimeSunMap(postscript-file)    application/postscript
    set mimeSunMap(xpm-file)           image/x-xpm
    set mimeSunMap(text)               text/plain
    set mimeSunMap(default)            text/plain
    set mimeSunMap(default-app)        application/x-default-app
    set mimeSunMap(default-doc)        text/plain
    set mimeSunMap(sun-executable)     application/x-sun-executable
    set mimeSunMap(shell-script)       application/x-shell-script
    set mimeSunMap(cshell-script)      application/x-shell-script
    set mimeSunMap(GUIDE-file)         application/x-guide
    set mimeSunMap(GUIDE-project-file) application/x-guide
    set mimeSunMap(Makefile)           application/x-makefile
    set mimeSunMap(compose-prog)       {application/x-sun-prog; prog=compose}
    set mimeSunMap(readme-file)        text/plain
    set mimeSunMap(AnswerBook)         application/x-answerbook
}

# This is called from MimeParseMulti
# to map the sun headers into mime-like headers
proc MimeMapSunHeaders { tkw part } {
    global mimeHdr mimeSunMap
    if ![catch {set mimeSunMap($mimeHdr($part,hdr,x-sun-data-type))} type] {
	set mimeHdr($part,hdr,content-type) $type
    }
    if ![catch {set mimeHdr($part,hdr,x-sun-data-name)} name] {
	set mimeHdr($part,hdr,content-description) $name
    }
    if ![catch {set mimeHdr($part,hdr,x-sun-charset)} charset] {
	set mimeHdr($part,param,charset) $charset
    }
    if ![catch {set mimeHdr($part,hdr,x-sun-encoding-info)} encoding] {
	set mimeHdr($part,hdr,content-transfer-encoding) $encoding
    }
}

proc Mime_ShowShellScript { tkw part } {
    global mimeHdr
    TextButton $tkw "Run attached shell script" [list exec sh $mimeHdr($part,file) &]
    $tkw insert insert \n\n
    TextButton $tkw "Save shell script" [list Mime_SavePiece $part $mimeHdr($part,type)]
    $tkw insert insert \n\n
    if ![info exists mimeHdr($part,showScript)] {
	set mimeHdr($part,showScript) 0
    }
    if {$mimeHdr($part,showScript)} {
	TextButton $tkw "Hide shell script" [list MimeSunHideScript $tkw $part]
	$tkw insert insert \n
	Mime_ShowText $tkw $part
    } else {
	TextButton $tkw "View shell script" [list MimeSunViewScript $tkw $part]
	$tkw insert insert \n

    }
}
proc MimeSunViewScript { tkw part } {
    global mimeHdr
    set mimeHdr($part,showScript) 1
    MimeRedisplayPart $tkw $part
}
proc MimeSunHideScript { tkw part } {
    global mimeHdr
    set mimeHdr($part,showScript) 0
    MimeRedisplayPart $tkw $part
}
proc Mime_ShowSunCalendar { tkw part } {
    global mimeHdr
    TextButton $tkw "Pass to Calendar Manager" [list MimeSunAppointment $tkw $part]
    $tkw insert insert \n
    Mime_ShowText $tkw $part
}
proc MimeSunAppointment { tkw part } {
    global mimeHdr
    if [catch {open $mimeHdr($part,file)} in] {
	Exmh_Status $in
	return
    }
    set stuff [read $in]
    close $in
    MimeSunAppInner $stuff
}
proc MimeSunAppSelection {} {
    if [catch {selection get} stuff] {
	if [catch {selection get -selection clipboard} stuff] {
	    Exmh_Status "No selection"
	    return
	}
    }
    MimeSunAppInner $stuff
}
proc MimeSunAppInner { stuff } {
    global field
    regsub -all {"} $stuff {} stuff
    regsub {\*\* Calendar Appointment \*\*} $stuff {} stuff

    set field(what) {}
    foreach line [split $stuff \n] {
	if [regexp {^[ 	]*([^:]+):(.+)$} $line x key value] {
	    set what [string tolower $key]
	    set field($what) $value\n
	} else {
	    append field(what) $line\n
	}
    }
    if ![info exists field(date)] {
	Exmh_Status "No date in calendar appointment"
	return
    }
    if {[info commands clock] == "clock"} {
	if [catch {clock format [clock scan $field(date)] -format %D} date] {
	    Exmh_Status $date
	    return
	}
    } else {
	set date [string trim $field(date) \ \t\n]
    }
    if ![info exists field(start)] {
	Exmh_Status "No start time in calendar appointment"
	return
    }
    if {[info exists field(stop)] && ![info exists field(end)]} {
	set field(end) $field(stop)
    }
    if ![info exists field(end)] {
	Exmh_Status "No end time in calendar appointment"
	return
    }
    regsub -all \[\ \t\n\.] $field(start) {} start
    regsub -all \[\ \t\n\.] $field(end) {} end

    Exmh_Status "cm_insert -d $date -s $start -e $end -w $field(what)"
    if [catch {exec cm_insert -d $date -s $start -e $end -w $field(what)} error] {
	Exmh_Status $error
    }
}
