/* 
 * example.h --
 *
 *	This file is an example of the header file for the publically exported 
 *      symbols in a Dynamically loadable Tcl extension.
 *
 * Copyright (c) 1996-7 by Sun Microsystems, Inc.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * SCCS: @(#) example.c 1.4 96/04/26 10:42:55
 */

#include <tcl.h>

/*
 * VC++ has an alternate entry point called DllMain, so we need to rename
 * our entry point.
 */

#if defined(__WIN32__)
#   define WIN32_LEAN_AND_MEAN
#   include <windows.h>
#   undef WIN32_LEAN_AND_MEAN
#   if defined(_MSC_VER)
#	define EXPORT(a,b) __declspec(dllexport) a b
#	define DllEntryPoint DllMain
#   else
#	if defined(__BORLANDC__)
#	    define EXPORT(a,b) a _export b
#	else
#	    define EXPORT(a,b) a b
#	endif
#   endif
#else
#   define EXPORT(a,b) a b
#endif


EXTERN EXPORT(int,Example_Init) _ANSI_ARGS_((Tcl_Interp *interp));
EXTERN EXPORT(int,Example_SafeInit) _ANSI_ARGS_((Tcl_Interp *interp));
