proc sj_mui {root args} {

    # This treats '.' as a special case.
    if {$root == "."} {set base ""} else {set base $root}
    
    set toproot [winfo toplevel $root]
    if {$toproot == "."} {set topbase ""} else {set topbase $toproot}
    if {[catch {$toproot config -menu ${topbase}.menubar} msg]} {
	array set menupaths "menubutton\#1 ${base}.menubutton\#1 menubutton\#2 ${base}.menubutton\#2 menubutton\#3 ${base}.menubutton\#3 menubutton\#4 ${base}.menubutton\#4 menubutton\#5 ${base}.menubutton\#5"
	
	menubutton $menupaths(menubutton\#1)
	$menupaths(menubutton\#1) config -menu $menupaths(menubutton\#1).1m -padx 5 -pady 4 -text File -underline 0 -background \#c0c0c0
	pack $menupaths(menubutton\#1) -side left
	menubutton $menupaths(menubutton\#2)
	$menupaths(menubutton\#2) config -cursor arrow -menu $menupaths(menubutton\#2).2m -padx 5 -pady 4 -text Edit -underline 0 -background \#c0c0c0
	pack $menupaths(menubutton\#2) -side left
	menubutton $menupaths(menubutton\#3)
	$menupaths(menubutton\#3) config -cursor arrow -menu $menupaths(menubutton\#3).3m -padx 5 -pady 4 -text Commands -underline 0 -background \#c0c0c0
	pack $menupaths(menubutton\#3) -side left
	menubutton $menupaths(menubutton\#4)
	$menupaths(menubutton\#4) config -menu $menupaths(menubutton\#4).4m -padx 5 -pady 4 -text Preferences -underline 0 -background \#c0c0c0
	pack $menupaths(menubutton\#4) -side left
	menubutton $menupaths(menubutton\#5)
	$menupaths(menubutton\#5) config -menu $menupaths(menubutton\#5).5m -padx 5 -pady 4 -text Help -underline 0 -background \#c0c0c0
	pack $menupaths(menubutton\#5) -side right
    } else {
	if {[winfo toplevel $root] == "."} {set base ""} else {set base [winfo toplevel $root]}
	array set menupaths "menubutton\\#1 $base.menubar menubutton\\#2 $base.menubar menubutton\\#3 $base.menubar menubutton\\#4 $base.menubar menubutton\\#5 $base.menubar"
	menu ${topbase}.menubar -background \#c0c0c0
	${topbase}.menubar add cascade -label "File" -underline 0 -background \#c0c0c0 -menu $menupaths(menubutton\#1).1m
	${topbase}.menubar add cascade -label "Edit"  -underline 0 -background \#c0c0c0 -menu $menupaths(menubutton\#2).2m
	${topbase}.menubar add cascade -label "Commands" -underline 0 -background \#c0c0c0 -menu $menupaths(menubutton\#3).3m
	${topbase}.menubar add cascade -label "Preferences" -underline 0 -background \#c0c0c0 -menu $menupaths(menubutton\#4).4m
	${topbase}.menubar add cascade -label "Help"  -underline 0 -background \#c0c0c0 -menu $menupaths(menubutton\#5).5m
    }
    proc sj_mui_accel {key args} {
	global tcl_platform
	set shift [regexp {[sS]hift} $args]
	set control [regexp {[cC]ontrol} $args]
	set meta [regexp {[mM]eta} $args]
	set alt [regexp {[aA]lt} $args]
	switch $tcl_platform(platform) {
	    unix {
		array set mods {prefix "<" suffix ">" \
				    shift0 "" shift1 "Shift-" \
				    control0 "" control1 "^-" \
				    meta0 "" meta1 "Meta-" \
				    alt0 "" alt1 "Alt-"}
	    }
	    macintosh {
		set key [string toupper $key]
		array set mods {prefix "" suffix "" \
				    shift0 "" shift1 "\377" \
				    control0 "" control1 "Command-" \
				    meta0 "" meta1 "\240" \
				    alt0 "" alt1 "\376"}
	    }
	    windows {
		array set mods {prefix "" suffix "" \
				    shift0 "" shift1 "Shft+" \
				    control0 "" control1 "Ctrl+" \
				    meta0 "" meta1 "Meta+" \
				    alt0 "" alt1 "Alt+"}
	    }
	    default {
		return "$key"
	    }
	}
	return "$mods(prefix)$mods(shift$shift)$mods(control$control)$mods(meta$meta)$mods(alt$alt)$key$mods(suffix)"
    }
    menu $menupaths(menubutton\#1).1m -tearoff 0 -background \#c0c0c0
    
    $menupaths(menubutton\#1).1m add command
    $menupaths(menubutton\#1).1m entryconfig last -accelerator [sj_mui_accel n control] -command clear_all -label New -background \#c0c0c0
    bind all <Control-n> {clear_all}
    
    $menupaths(menubutton\#1).1m add command
    $menupaths(menubutton\#1).1m entryconfig last -accelerator [sj_mui_accel o control] -command mainmenu_open -label Open... -background \#c0c0c0
    bind all <Control-o> {mainmenu_open}
    
    $menupaths(menubutton\#1).1m add command
    $menupaths(menubutton\#1).1m entryconfig last -accelerator [sj_mui_accel s control] -command mainmenu_save -label Save -background \#c0c0c0
    bind all <Control-s> {mainmenu_save}
    
    $menupaths(menubutton\#1).1m add command
    $menupaths(menubutton\#1).1m entryconfig last -command mainmenu_save_as -label {Save As...} -background \#c0c0c0
    
    $menupaths(menubutton\#1).1m add separator
    $menupaths(menubutton\#1).1m entryconfig last -background \#c0c0c0
    
    $menupaths(menubutton\#1).1m add command
    $menupaths(menubutton\#1).1m entryconfig last -accelerator [sj_mui_accel q control] -command quit -label Quit -background \#c0c0c0
    bind all <Control-q> {quit}
    
    menu $menupaths(menubutton\#2).2m -tearoff 0 -background \#c0c0c0
    
    $menupaths(menubutton\#2).2m add command
    $menupaths(menubutton\#2).2m entryconfig last -command mainmenu_edit_code -label {Edit code} -background \#c0c0c0
    
    $menupaths(menubutton\#2).2m add command
    $menupaths(menubutton\#2).2m entryconfig last -accelerator [sj_mui_accel w control] -command mainmenu_widget_options -label {Widget options...} -background \#c0c0c0
    bind all <Control-w> {mainmenu_widget_options}
    
    $menupaths(menubutton\#2).2m add command
    $menupaths(menubutton\#2).2m entryconfig last -accelerator [sj_mui_accel g control] -command mainmenu_generic_options -label {Generic options...} -background \#c0c0c0
    bind all <Control-g> {mainmenu_generic_options}
    
    $menupaths(menubutton\#2).2m add separator
    $menupaths(menubutton\#2).2m entryconfig last -background \#c0c0c0
    
    $menupaths(menubutton\#2).2m add command
    $menupaths(menubutton\#2).2m entryconfig last -accelerator [sj_mui_accel Delete] -command mainmenu_delete -label Delete -background \#c0c0c0
    bind all <Delete> {mainmenu_delete}
    
    $menupaths(menubutton\#2).2m add command
    $menupaths(menubutton\#2).2m entryconfig last -accelerator [sj_mui_accel Insert] -command mainmenu_insert -label Insert -background \#c0c0c0
    bind all <Insert> {mainmenu_insert}
    
    $menupaths(menubutton\#2).2m add command
    $menupaths(menubutton\#2).2m entryconfig last -accelerator [sj_mui_accel x control] -command mainmenu_cut -label Cut -background \#c0c0c0
    bind all <Control-x> {mainmenu_cut}
    
    $menupaths(menubutton\#2).2m add command
    $menupaths(menubutton\#2).2m entryconfig last -accelerator [sj_mui_accel c control] -command mainmenu_copy -label Copy -background \#c0c0c0
    bind all <Control-c> {mainmenu_copy}
    
    $menupaths(menubutton\#2).2m add command
    $menupaths(menubutton\#2).2m entryconfig last -accelerator [sj_mui_accel v control] -command mainmenu_paste -label Paste -background \#c0c0c0
    bind all <Control-v> {mainmenu_paste}
    
    menu $menupaths(menubutton\#3).3m -tearoff 0 -background \#c0c0c0
    
    $menupaths(menubutton\#3).3m add command
    $menupaths(menubutton\#3).3m entryconfig last -accelerator [sj_mui_accel t control] -command mainmenu_build_test -label {Build Test} -background \#c0c0c0
    bind all <Control-t> {mainmenu_build_test}
    
    $menupaths(menubutton\#3).3m add command
    $menupaths(menubutton\#3).3m entryconfig last -accelerator [sj_mui_accel k control] -command mainmenu_kill_test -label {Kill test} -background \#c0c0c0
    bind all <Control-k> {mainmenu_kill_test}
    
    $menupaths(menubutton\#3).3m add command
    $menupaths(menubutton\#3).3m entryconfig last -command mainmenu_load_project_into_frame -label {Load Project into frame...} -background \#c0c0c0
    
    $menupaths(menubutton\#3).3m add command
    $menupaths(menubutton\#3).3m entryconfig last -command mainmenu_attach_scrollbars -label {Attach scrollbars} -background \#c0c0c0
    
    $menupaths(menubutton\#3).3m add command
    $menupaths(menubutton\#3).3m entryconfig last -accelerator [sj_mui_accel r control] -command mainmenu_reapply_toolbar -label {Re-apply the toolbar} -background \#c0c0c0
bind all <Control-r> {mainmenu_reapply_toolbar}

    $menupaths(menubutton\#3).3m add cascade
    $menupaths(menubutton\#3).3m entryconfig last -command mainmenu_navigate -label Navigate -menu $menupaths(menubutton\#3).3m.6m -background \#c0c0c0

    $menupaths(menubutton\#3).3m add command
    $menupaths(menubutton\#3).3m entryconfig last -command mainmenu_showconsole -label {Show Console} -background \#c0c0c0

    $menupaths(menubutton\#3).3m add command
    $menupaths(menubutton\#3).3m entryconfig last -command mainmenu_hideconsole -label {Hide Console} -background \#c0c0c0

    menu $menupaths(menubutton\#3).3m.6m -tearoff 0 -background \#c0c0c0

    $menupaths(menubutton\#3).3m.6m add command
$menupaths(menubutton\#3).3m.6m entryconfig last -accelerator [sj_mui_accel Right shift] -command mainmenu_next_widget -label {Next Widget} -background \#c0c0c0
bind all <Shift-Right> {mainmenu_next_widget}

    $menupaths(menubutton\#3).3m.6m add command
$menupaths(menubutton\#3).3m.6m entryconfig last -accelerator [sj_mui_accel Left shift] -command mainmenu_previous_widget -label {Previous Widget} -background \#c0c0c0
bind all <Shift-Left> {mainmenu_previous_widget}

    $menupaths(menubutton\#3).3m.6m add command
$menupaths(menubutton\#3).3m.6m entryconfig last -accelerator [sj_mui_accel Down] -command mainmenu_enter_subgrid -label {Enter Subgrid} -background \#c0c0c0
bind all <Down> {mainmenu_enter_subgrid}

    $menupaths(menubutton\#3).3m.6m add command
$menupaths(menubutton\#3).3m.6m entryconfig last -accelerator [sj_mui_accel Up] -command mainmenu_leave_subgrid -label {Leave Subgrid} -background \#c0c0c0
bind all <Up> {mainmenu_leave_subgrid}

    menu $menupaths(menubutton\#4).4m -tearoff 0 -background \#c0c0c0

    $menupaths(menubutton\#4).4m add command
    $menupaths(menubutton\#4).4m entryconfig last -command mainmenu_options -label Options... -background \#c0c0c0

    $menupaths(menubutton\#4).4m add separator
    $menupaths(menubutton\#4).4m entryconfig last -background \#c0c0c0

    $menupaths(menubutton\#4).4m add command
    $menupaths(menubutton\#4).4m entryconfig last -command mainmenu_save_options -label {Save options} -background \#c0c0c0

    menu $menupaths(menubutton\#5).5m -tearoff 0 -background \#c0c0c0

    $menupaths(menubutton\#5).5m add command
    $menupaths(menubutton\#5).5m entryconfig last -command mainmenu_about -label About -background \#c0c0c0

    $menupaths(menubutton\#5).5m add separator
    $menupaths(menubutton\#5).5m entryconfig last -background \#c0c0c0

    $menupaths(menubutton\#5).5m add command
$menupaths(menubutton\#5).5m entryconfig last -accelerator [sj_mui_accel Help] -command mainmenu_getting_started -label {Getting Started} -background \#c0c0c0
bind all <Help> {mainmenu_getting_started}

    $menupaths(menubutton\#5).5m add command
    $menupaths(menubutton\#5).5m entryconfig last -command mainmenu_help -label Help -background \#c0c0c0


}


