#!wish
# Setup.tcl - set up the example sources
# Tkexample chapter
# Usage:
# 	wish -f Setup.tcl
#
message .title -aspect 1000 -text "Setup for the examples from
Practical Programing in Tcl and Tk,
by Brent B. Welch"
message .msg -aspect 1000 -text \
"Please enter the complete
pathname of the wish program.
Then enter the location of the
example scripts (the dir setting),
which is used in the browser application"
pack .title .msg -side top -padx 10 -pady 10

frame .f
label .f.label -textvariable prompt -width 6 -anchor w
set prompt "wish:"
entry .f.entry -textvariable path -width 32 -relief sunken
set path /usr/local/bin/wish
pack .f -side top -padx 10
pack .f.entry .f.label -side right -fill x

bind .f.entry <Return> {focus .g.entry}

frame .g
label .g.label -text "dir:" -width 6 -anchor w
entry .g.entry -textvariable pwd -width 32 -relief sunken
set pwd [pwd]
pack .g -side top -padx 10
pack .g.entry .g.label -side right -fill x

bind .g.entry <Return> OK

frame .buttons
button .buttons.ok -text OK -command OK
button .buttons.cancel -text Quit -command exit
pack .buttons.ok .buttons.cancel -side right -padx 10 -pady 5
pack .buttons -fill x

proc OK {} {
    global path
    set path [string trim [glob -nocomplain $path]]
    if {[string length $path] == 0} {
	.msg config -text \
"Please enter a complete pathname
for the wish program."
    } elseif {! [file exists $path]} {
	.msg config -text \
"The file you specified:
$path
Does not exist.  Please enter a complete
pathname for the wish program."
    } elseif {! [file executable $path]} {
	.msg config -text \
"The file you specified:
$path
Is not executable.  Please enter a complete
pathname for the wish program."
    } elseif {[string length $path] > 30} {
	.msg config -text \
"The pathname you specified:
$path
Is probably too long to work properly.
This is due to a limitation of the UNIX
exec system call that limits interpreter
names to less than 30 characters. I'm just
going to use /usr/local/bin/wish for
the pathname."
	set path /usr/local/bin/wish
    } else {
	.msg config -text \
"Patching stand-alone scripts..."
	update idletasks
	after 1 Patch
    }
}
proc Patch {} {
    global path pwd prompt
    set wish $path
    set prompt file:
    set sedfile /tmp/sed.[pid]
    set out [open $sedfile w]
    puts $out "1s,#!.*wish.*\$,#!$wish -f,"
    puts $out "s,^set browse(dir).*\$,set browse(dir) $pwd,"
    close $out

    foreach app {
	browse0 browse1 cursor cursor2 cursor3 eval evalServe execlog
	fontsel pingtool protoapp send sendSetup xload read
    } {
	if ![file exists $app.tcl.orig] {
	    exec mv $app.tcl $app.tcl.orig
	}
	set path $app.tcl ; update idletasks
	exec sed -f $sedfile < $app.tcl.orig > $app.tcl
	exec chmod a+x $app.tcl
    }
    .buttons.cancel config -text Quit
    .msg config -text "Done
Run the browser with this command:
./browse1.tcl &"
    set path $wish
    set prompt wish:
    button .buttons.browse -text Browse -command {exec ./browse1.tcl &}
    pack .buttons.browse -side right -padx 10 -pady 5
}
