;;; Example Settings for CIE (c++_in_emacs) package
;;; Put desirable ones in your default.el, or simply load this file.


;;; You should add the following settings to your .emacs,
;;; modified as appropriate (esp. if you use save-tags-completion-alist)
;
;(setq tags-file-name "~/project/TAGS")
;(setq hier-file-name "~/project/CLASS.hier")


;;;===== Goto-File
(global-set-key "\C-c\C-f" 'goto-file)
(autoload 'goto-file "goto-file" 
	  "Goto file (and line number or pattern) named at point." t)


;;;===== Hierarchy Mode (for .hier files created by hier++)

(autoload 'hier-mode          "hier-mode" "Mode for viewing hierarchies generated by hier++." t)

(setq auto-mode-alist (cons (cons "\\.hier$" 'hier-mode) auto-mode-alist))

;;; add these functions to C++-mode keys

(autoload 'class-hierarchy    "hier-mode" "Display the hierarchy for the given class."  t)
(autoload 'class-members      "hier-mode" "Display all members for the given class."    t)
(autoload 'class-data-members "hier-mode" "Display data members for the given class."   t)

(setq c++-mode-hook 
      '(lambda ()
	 (define-key c++-mode-map "\C-ch" 'class-hierarchy)
	 (define-key c++-mode-map "\C-cm" 'class-members)
	 (define-key c++-mode-map "\C-cd" 'class-data-members)))


;;;===== Minibuffer Yank (yank in the default)

(autoload 'minibuffer-yank "minibuffer-yank" "Utility to yank in defaults." t)

(define-key minibuffer-local-completion-map "\C-c\C-y" 'minibuffer-yank)
(define-key minibuffer-local-must-match-map "\C-c\C-y" 'minibuffer-yank)
