;; up-rules.el -- 
;; Author          : Bob Weiner
;; Created On      : 7-Jan-92 at 03:49:27
;; Last Modified By: Ulrich Pfeifer
;; Last Modified On: Wed May 11 15:38:13 1994
;; Update Count    : 100
;; Status          : Unknown, Use with caution!
;; $Locker: pfeifer $
;; $Log: up-rules.el,v $
;; Revision 1.1  1993/07/27  10:58:23  pfeifer
;; Sicherung vor Cleanup
;;

(defun mhg-refile-person-p (field email fullname)
  (let ((namereg (concat "\\<" email "@\\|" fullname)))
  (or (mhg-hdr-regexp
       field namereg)
      (mhg-hdr-regexp
       reply-to namereg))))

(fset 'up-file-mail 'mhg-user-refile-rules)

(defun mhg-user-refile-rules ()
  "Computes where to file current mail message based on personal rules."
  (interactive)
  (setq mhg-filed-to nil)
  (let (from bcc cc dcc date in-reply-to reply-to subject summary to field-txt)
    (save-excursion
      (save-restriction
	(goto-char (point-min))
	(if (search-forward "\n\n" nil t)
	    (narrow-to-region (point-min) (point)))
	(mapcar '(lambda (field)
		   (setq field-txt (mail-fetch-field field))
		   (set (intern (downcase field))
			(and field-txt
			     ;; Remove leading and trailing space.
			     (hypb:replace-match-string
			      "\\`[ \t\n\^M]+\\|[ \t\n\^M]+\\'"
			      field-txt ""))))
		'("From" "Subject" "To" "CC" "BCC"))
	))

    (catch 'finish
      (let ((case-fold-search t)
            (role-regexp
             (concat (regexp-quote (user-real-login-name))
                     "\\.\\([^@% \t\n\^M]+\\)\\([@%][^@% \t\n\^M]*"
                     (regexp-quote (substring hyperb:host-domain 1))
                     "[^ \t\n\^M]*\\)?\\([ \t\^M]\\|$\\)"))
            )

        ;; If addressed to an existing role box, just file there and exit.
        (let (hdr folder dir)
          (if (or (and (mhg-hdr-regexp to role-regexp) (setq hdr to))
                  (and (mhg-hdr-regexp cc role-regexp) (setq hdr cc))
                  (and (mhg-hdr-regexp bcc role-regexp) (setq hdr bcc)))
              (progn
                (setq folder (hypb:replace-match-string
                              "\\."
                              (substring hdr (match-beginning 1) (match-end 1))
                              "/")
                      dir (concat (or mhg-root-dir mh-user-path) folder))
                (if (file-exists-p dir)
                    (progn (mhg-file-to folder)
                           (throw 'finish nil))))))

        (cond ((mhg-refile-person-p from "MAILER-DAEMON" "Mail Delivery Subsystem")
               (mhg-file-to "today/MailerDaemon"))
              ((and 
                (mhg-hdr-regexp from "root")
                (mhg-hdr-regexp subject "Permissions"))
               (mhg-file-to "today/Permissions"))
              ((mhg-hdr-regexp subject "cron\\|mirror")
               (mhg-file-to "today/cron"))
              ((or
                (mhg-hdr-regexp subject "latex2html")
                (mhg-hdr-regexp from "N F Drakos"))
               (mhg-file-to "tools/latex2html"))
              ((or 
                (mhg-hdr-regexp subject "WWW Benutzung: Monats-Uebersicht")
                (mhg-hdr-regexp subject "cron.monthly"))
               (mhg-file-to "monthly/cron"))
              ((or
                (mhg-hdr-regexp
                 to "w3\\|www-announce\\|www-talk")
                (mhg-hdr-regexp
                 cc "w3\\|www-announce\\|www-talk"))
               (mhg-file-to "mailinglisten/WWW"))
              ((or
                (mhg-hdr-regexp
                 subject "WWW\\|HTTP"))
                (mhg-file-to "tools/WWW"))
              ((mhg-hdr-regexp
                to "nosferatu")
               (mhg-file-to "mailinglisten/Nosferatu"))
              ((mhg-hdr-regexp
                to "sug-info")
               (mhg-file-to "mailinglisten/sug-info"))
              ((mhg-hdr-regexp
                   from "SVSERV@dhdspr\\|SVJPS@dhdspri")
               (mhg-file-to "mailinglisten/springer"))
              ((mhg-hdr-regexp
                from "backup")
               (mhg-file-to "today/backup"))
              ((mhg-hdr-regexp
                subject "HRZ-INFO")
               (mhg-file-to "mailinglisten/HRZ"))
              ((mhg-hdr-regexp
                subject "rcsedit")
               (mhg-file-to "tools/perl"))
;;              ((and (mhg-hdr-regexp
;;                     from "stach\\|spielman\\|grossjoh\\|fuhr")
;;                   (mhg-hdr-regexp
;;                    subject "nosfe\\|noks\\|node"))
;;               (mhg-file-to "events/Tagungen/93/Regensburg"))
              ((and (mhg-hdr-regexp
                    from "root")
                   (mhg-hdr-regexp
                    subject "Calendar"))
               (mhg-file-to "today/Calendar"))
              ((or (mhg-hdr-regexp
                    subject "\\<\\(Bereichsbibliothek\\|TECHLIBplus\\|TECHLIB\\|bib\\|infcd\\|ubok\\)\\>")
                   (mhg-hdr-regexp
                    from "@bib")
                   (mhg-hdr-regexp
                    from "keller")
                   (mhg-hdr-regexp
                    to "@bib"))
               (mhg-file-to "aufgaben/bib"))
              ((mhg-hdr-regexp subject "Fragebogen")
               (mhg-file-to "aufgaben/bib/Fragebogen"))
              ((or (mhg-hdr-regexp
                    to "smart-people")
                   (mhg-hdr-regexp
                    cc "smart-people"))
               (mhg-file-to "mailinglisten/smart-people"))
              ((or (mhg-hdr-regexp
                    subject "smart")
                   (mhg-hdr-regexp
                    from "smart"))
               (mhg-file-to "tools/smart"))
              ((mhg-hdr-regexp
                subject "Soundex\\|Phonix\\|WAIS")
               (mhg-file-to "tools/wais"))
              ((mhg-hdr-regexp
                subject "SFgate")
               (mhg-file-to "tools/SFgate"))
              ((mhg-hdr-regexp
                subject "Tag der offenen Tuer\\|19.6")
               (mhg-file-to "events/TagDerOffenenTuer"))
              ((or
                (mhg-hdr-regexp
                 subject "\\<PG *233\\>")
                (mhg-hdr-regexp
                 from "\\<PG *233\\>"))
               (mhg-file-to "veranstaltungen/PG/pg233"))
              ((or
                (mhg-hdr-regexp to "wimis@fbi-mail")
                (mhg-hdr-regexp cc "wimis@fbi-mail"))
                (mhg-file-to "mailinglisten/wimis"))
              ((mhg-hdr-regexp
                from "uccvma")
               (mhg-file-to "mailinglisten/InformationRetrievalList"))
              ((mhg-hdr-regexp
                to "sunflash")
               (mhg-file-to "mailinglisten/SunFlash"))
              ((mhg-hdr-regexp
                subject "Diplomandenseminar\\|19.6")
               (mhg-file-to "veranstaltungen/DiplomandenSeminar")))
        (or mhg-filed-to (mhg-refile-persons from))
        (or mhg-filed-to (mhg-refile-persons reply-to))
        (or mhg-filed-to (mhg-refile-persons to))
        (or mhg-filed-to (if (mhg-hdr-regexp
                              subject "\\<PG\\>")
                             (mhg-file-to "veranstaltungen/PG/Allgemein")))
        (or mhg-filed-to (mhg-file-to "misc"))
        ))

    (if (interactive-p)
	(message "Auto file msg to: %s" mhg-filed-to)
      (princ subject) (terpri)
      (princ "  ") (princ mhg-filed-to)
      (terpri) (terpri)
      mhg-filed-to)
    ))

(defun mhg-refile-persons (field)
  (cond ((mhg-refile-person-p field "wmperry" "William M. Perry")
         (mhg-file-to "personen/misc/WilliamPerry"))
        ((mhg-refile-person-p field "chrisb" "Chris Buckley")
         (mhg-file-to "personen/misc/ChrisBuckley"))
        ((mhg-refile-person-p field "wr" "Wilfried Rupflin")
         (mhg-file-to "personen/fbi/irb/WilfriedRupflin"))
        ((mhg-refile-person-p field "mester" "Arnulf Mester")
         (mhg-file-to "personen/fbi/ls4/ArnulfMester"))
        ((mhg-refile-person-p field "rbo" "RalfBormann")
         (mhg-file-to "personen/fbi/irb/RalfBormann"))
        ((mhg-refile-person-p field "esch" "Eckard Schulte")
         (mhg-file-to "personen/fbi/irb/EckardSchulte"))
        ((mhg-refile-person-p field "ec" "Ewald Ceranski")
         (mhg-file-to "personen/fbi/irb/EwaldCeranski"))
        ((mhg-refile-person-p field "klute" "Rainer Klute")
         (mhg-file-to "personen/fbi/irb/RainerKlute"))
        ((mhg-refile-person-p field "ch" "Carsten Heyl")
         (mhg-file-to "personen/fbi/irb/CarstenHeyl"))
        ((mhg-refile-person-p field "sm" "Stefan Mintert")
         (mhg-file-to "personen/fbi/irb/StefanMintert"))
        ((mhg-refile-person-p field "peter" "Rudolf Peter")
         (mhg-file-to "personen/fbi/irb/RudolfPeter"))
        ((mhg-refile-person-p field "wache" "Holger Wache")
         (mhg-file-to "personen/privat/HolgerWache"))
        ((mhg-refile-person-p field "krause" "Juergen Krause")
         (mhg-file-to "personen/misc/JuergenKrause"))
        ((mhg-refile-person-p field "nr" "Nicole Radtke")
         (mhg-file-to "personen/fbi/irb/NicoleRadtke"))
        ((mhg-refile-person-p field "jr" "Juergen Rohde")
         (mhg-file-to "personen/fbi/irb/JuergenRohde"))
        ((mhg-refile-person-p field "ar" "Andreas Ritter")
         (mhg-file-to "personen/fbi/irb/AndreasRitter"))
        ((mhg-refile-person-p field "ks" "Kai A. Scharwacht")
         (mhg-file-to "personen/fbi/irb/KaiScharwacht"))
        ((mhg-refile-person-p field "kroha" "Petr Kroha")
         (mhg-file-to "personen/fbi/ls10/PeterKroha"))
        ((mhg-refile-person-p field "heitkoet" "Joerg Heitkoetter")
         (mhg-file-to "personen/fbi/ls11/JoergHeitkoetter"))
        ((mhg-refile-person-p field "wj" "Winfried Jansen")
         (mhg-file-to "personen/fbi/irb/WinfriedJansen"))
        ((mhg-refile-person-p field "sk" "Stefan Kirchberg")
         (mhg-file-to "personen/fbi/irb/StefanKirchberg"))
        ((mhg-refile-person-p field "CIGASC" "Gabriele Sch..?nfelde")
         (mhg-file-to "personen/zb/GabrieleSchoenfelder"))
        ((mhg-refile-person-p field "fuhr" "Norbert Fuhr")
         (mhg-file-to "personen/fbi/ls6/NorbertFuhr"))
        ((mhg-refile-person-p field "roelleke" "Thomas Roelleke")
         (mhg-file-to "personen/fbi/ls6/ThomasRoelleke"))
        ((mhg-refile-person-p field "hartmann" "Stephan Hartmann")
         (mhg-file-to "personen/privat/StephanHartmann"))
        ((mhg-refile-person-p field "schendel" "Manfred Schendel")
         (mhg-file-to "personen/privat/ManfredSchendel"))
        ((mhg-refile-person-p field "kostas" "Kostas Tzeras")
         (mhg-file-to "personen/privat/KostasTzeras"))
        ((mhg-refile-person-p field "herder" "Jens Herder")
         (mhg-file-to "personen/privat/JensHerder"))
        ((mhg-refile-person-p field "grossjoh\\|psue126" "Kai Grossjohan")
         (mhg-file-to "personen/fbi/ls6/KaiGrossjohann"))
        ((mhg-refile-person-p field "huynh1" "Huynh.*Tung")
         (mhg-file-to "personen/fbi/ls6/TungHuynh"))
        ((mhg-refile-person-p field "stach" "Oliver Stach")
         (mhg-file-to "personen/fbi/ls6/OliverStach"))
        ((mhg-refile-person-p field "spielmann" "Holger Spielmann")
         (mhg-file-to "personen/fbi/ls6/HolgerSpielmann"))
        ((mhg-refile-person-p field "gs" "Gerd Sokolies")
         (mhg-file-to "personen/fbi/irb/GerdSokolies"))
        ((mhg-refile-person-p field "dl" "Dirk Lethaus")
         (mhg-file-to "personen/fbi/irb/DirkLethaus"))
        ((mhg-refile-person-p field "sr" "Stefan Rapp")
         (mhg-file-to "personen/fbi/irb/StefanRapp"))
        ((mhg-refile-person-p field "krueger" "Guenter Krueger")
         (mhg-file-to "personen/fbi/dek/GuenterKrueger"))
        ((mhg-refile-person-p field "decker" "HansDecker")
         (mhg-file-to "personen/fbi/dek/HansDecker"))
        ((mhg-refile-person-p field "ruprecht" "Nick Ruprecht")
         (mhg-file-to "personen/fbi/ls7/NickRuprecht"))
        ((mhg-refile-person-p field "poersch" "Thomas Poersch")
         (mhg-file-to "personen/fbi/ls6/ThomasPoersch"))
        ((mhg-refile-person-p field "burghard" "Andreas Burghard")
         (mhg-file-to "personen/fbi/ls6/AndreasBurghard"))
        ((mhg-refile-person-p field "schmidt" "Michael Schmidt")
         (mhg-file-to "personen/fbi/ls6/MichaelSchmidt"))
        ((mhg-refile-person-p field "arnautu" "Bogdan Arnautu")
         (mhg-file-to "personen/fbi/ls6/BogdanArnautu"))
        ((mhg-refile-person-p field "pennekam" "Stefan Pennekamp")
         (mhg-file-to "personen/fbi/ls6/StefanPennekamp"))
        ((mhg-refile-person-p field "wr" "Wilfried Rupflin")
         (mhg-file-to "personen/fbi/irb/WilfriedRupflin"))
        ((mhg-refile-person-p field "fabio" "Fabio Crestani")
         (mhg-file-to "personen/misc/FabioCrestani"))
        ((mhg-refile-person-p field "womser" "Christa Womser")
         (mhg-file-to "personen/misc/ChristaWomser"))
        ((mhg-refile-person-p field "bremkamp" "Christoph Bremkamp")
         (mhg-file-to "personen/fbi/ls6/ChristophBremkamp"))
        ((mhg-refile-person-p field "dg8d" "Thomas Kletschka")
         (mhg-file-to "personen/privat/ThomasKletschka"))
        ((mhg-refile-person-p field "werner" "Werner Schmidt")
         (mhg-file-to "personen/privat/WernerSchmidt"))
        ((mhg-refile-person-p field "kuronen" "Timo Kuronen")
         (mhg-file-to "personen/misc/TimoKuronen"))
        ((mhg-refile-person-p field "maeter" "Juergen Maeter")
         (mhg-file-to "personen/fbi/ls4/JuergenMaeter"))
        ((mhg-refile-person-p field "joke" "Joerg Heitkoetter")
         (mhg-file-to "personen/fbi/ls11/JoergHeitkoetter"))
        ((mhg-refile-person-p field "bibadm" "bib-administrator")
         (mhg-file-to "personen/fbi/ls11/JoergHeitkoetter"))
        ((mhg-refile-person-p field "bob" "Thomas Biedassek")
         (mhg-file-to "personen/fbi/irb/ThomasBiedassek"))
        ((mhg-refile-person-p field "root" "Operator")
         (mhg-file-to "system/root"))
        ((mhg-refile-person-p field "hofmann" "Martin Hofmann")
         (mhg-file-to "personen/privat/MartinHofmann"))
        ((mhg-refile-person-p field "mv" "Markus Verch")
         (mhg-file-to "personen/fbi/irb/MarkusVerch"))
        ((mhg-refile-person-p field "msc0h" "Michael Schwantner")
         (mhg-file-to "personen/privat/MichaelSchwantner"))
        ((mhg-refile-person-p field "mkf" "Klaus Friedel")
         (mhg-file-to "personen/Jena/KlausFriedel"))
        ((mhg-refile-person-p field "dps" "Peter Schorch")
         (mhg-file-to "personen/Jena/PeterSchorch"))
        ((mhg-refile-person-p field "althoff\\spitczok" 
                              "Thomas Althoff\\|Jens Spitczok")
         (mhg-file-to "veranstaltungen/PG/pg233"))
        ((mhg-refile-person-p field "ckoester\\hkoester" 
                              "Cordula Koester\\|Heiko Koester")
         (mhg-file-to "personen/fbi/ls6/CordulaKoester"))
        ((mhg-refile-person-p field "fastenra" "Ulrich Fastenrath")
         (mhg-file-to "personen/fbi/ls6/UlrichFastenrath"))
        ((mhg-refile-person-p field "wolfer" "Guido Wolfering")
         (mhg-file-to "personen/fbi/ls6/GuidoWolfering"))
        ))