##
##  PM-LMTT.R  (Local Mime Translation Table)
##  Copyright (c) 1994, David Harris, All Rights Reserved.
##
##  This file can be used as a model for a local resource which
##  maps ISO character sets to the code pages in use on the PCs
##  at your site.
##
##  Character translation tables:
##  Each translation table maps the characters in a particular
##  ISO set to your codepage's character set: the table can be used
##  bidirectionally when composing or decoding quoted-printable or
##  8BIT messages. Only characters from 128-255 are included in
##  the table, and each table must end with an ASCII NUL (0).
##
##  The sample tables in this file are the ones Pegasus Mail uses
##  by default: they map ISO character sets to the standard IBM
##  code page 437. You may define as many character sets as you
##  wish and Pegasus Mail will use them to translate incoming mail
##  but for outgoing mail it will only use ISO character sets.
##
##  The last resource in the file must be a "charset_list"
##  structure which ties the character strings naming an ISO
##  character set to the resource which maps it.
##
##  To use this file, modify it as required, then compile it with
##  the Pegasus Mail system resource compiler, RESCOM, using the
##  command 'rescom PM-LMTT.R'. This will produce the file
##  PM-LMTT.RSC, which should be copied into the same directory
##  as PMAIL.EXE, or into your home mailbox.

##
##  The "charset_list" type is used to tie a particular name of
##  a character set to the table used to decode it.
##

typedef charset_list 25
   {
   repeat,
   string 20,     # Character set name
   integer        # resource ID of table to load.
   };

###  ISO-8859-1 is the only character set specifically defined
###  in RFC1341 (MIME) - the vast majority of messages will use
###  this character set for MIME encoding. It is the native
###  character set of Windows (where it is referred to as the
###  "ANSI" character set).

structure iso8859_1
   {
   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
   '', '', '', '', ' ', '', ' ', ' ', 
   ' ', ' ', '', '', '', ' ', ' ', ' ', 
   ' ', '', '', ' ', ' ', ' ', ' ', '', 
   ' ', ' ', '', '', '', '', ' ', '', 
   ' ', ' ', ' ', ' ', '', '', '', '', 
   ' ', '', ' ', ' ', ' ', ' ', ' ', ' ', 
   ' ', '', ' ', ' ', ' ', ' ', '', ' ', 
   ' ', ' ', ' ', ' ', '', ' ', ' ', '', 
   '', '', '', ' ', '', '', '', '', 
   '', '', '', '', '', '', '', '', 
   ' ', '', '', '', '', ' ', '', '', 
   ' ', '', '', '', '', ' ', ' ', '',
   0
   };

structure iso8859_2
   {
   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
   '', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
   ' ', ' ', ' ', ' ', '', ' ', ' ', '', 
   ' ', '', ' ', ' ', ' ', ' ', ' ', ' ', 
   ' ', ' ', ' ', ' ', ' ', ' ', '', ' ', 
   ' ', ' ', ' ', ' ', '', ' ', ' ', ' ', 
   ' ', '', '', ' ', '', ' ', ' ', '', 
   ' ', '', ' ', '', ' ', '', '', ' ', 
   ' ', ' ', ' ', '', '', ' ', '', '', 
   ' ', ' ', '', ' ', '', ' ', ' ', ' ',
   0
   };

structure iso8859_3
   {
   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
   '', ' ', ' ', '', ' ', ' ', ' ', ' ', 
   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
   ' ', ' ', '', ' ', ' ', ' ', ' ', '', 
   ' ', ' ', ' ', ' ', ' ', '', ' ', ' ', 
   ' ', ' ', ' ', ' ', '', ' ', ' ', '', 
   ' ', '', ' ', ' ', ' ', ' ', ' ', ' ', 
   ' ', '', ' ', ' ', ' ', ' ', '', ' ', 
   ' ', ' ', ' ', ' ', '', ' ', ' ', ' ', 
   '', '', '', ' ', '', ' ', ' ', '', 
   '', '', '', '', '', '', '', '', 
   ' ', '', '', '', '', ' ', '', '', 
   ' ', '', '', '', '', ' ', ' ', ' ',
   0
   };

structure iso8859_7
   {
   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
   '', ' ', ' ', '', ' ', ' ', ' ', ' ', 
   ' ', ' ', ' ', '', '', ' ', ' ', ' ', 
   ' ', '', '', ' ', ' ', ' ', ' ', '', 
   ' ', ' ', ' ', '', ' ', '', ' ', ' ', 
   ' ', ' ', ' ', '', ' ', ' ', ' ', ' ', 
   '', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
   ' ', ' ', ' ', '', ' ', ' ', '', ' ', 
   ' ', '', ' ', ' ', ' ', ' ', ' ', ' ', 
   ' ', '', '', ' ', '', '', ' ', ' ', 
   ' ', ' ', ' ', ' ', '', ' ', ' ', ' ', 
   '', ' ', ' ', '', '', ' ', ' ', ' ', 
   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
   0
   };

structure iso8859_9
   {
   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
   ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
   '', '', '', '', ' ', '', ' ', ' ', 
   ' ', ' ', '', '', '', ' ', ' ', ' ', 
   ' ', '', '', ' ', ' ', ' ', ' ', '', 
   ' ', ' ', '', '', '', '', ' ', '', 
   ' ', ' ', ' ', ' ', '', '', '', '', 
   ' ', '', ' ', ' ', ' ', ' ', ' ', ' ', 
   ' ', '', ' ', ' ', ' ', ' ', '', ' ', 
   ' ', ' ', ' ', ' ', '', ' ', ' ', ' ', 
   '', '', '', ' ', '', '', '', '', 
   '', '', ' ', '', ' ', '', '', ' ', 
   ' ', '', '', '', '', ' ', '', '', 
   ' ', '', '', '', '', ' ', ' ', '',
   0
   };

charset_list _mime_csets
   {
   "ISO-8859-1", iso8859_1,
   "ISO-8859-2", iso8859_2,
   "ISO-8859-3", iso8859_3,
   "ISO-8859-7", iso8859_7,
   "ISO-8859-9", iso8859_9,
   "", -1
   };

