//	Copyright (c) 1993, University of Kansas, All Rights Reserved
//
//	Class:		TURLWindow
//	Include File:	turlwind.h
//	Purpose:	Provide a window for a URL
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		12-27-93	created
//		02-09-94	Split all members into seperate files.
#define Uses_TProgram
#include"turlwind.h"

void TURLWindow::OwnerClose()	{
//	Purpose:	Pass a message to have the window closed.
//	Arguments:	void
//	Return Value:	void
//	Remarks/Portability/Dependencies/Restrictions:
//		Should only be done when view inside window is not valid.
//	Revision History:
//		01-30-94	created
//		03-31-94	A problem arises becuase the application
//				closes this window with no wait and then
//				the return of the closing code has no where
//				to actually return to since the window
//				has in effect been closed.
//				Look for a fix in TDosLynx::handleEvent.

	TEvent TE_close;

	//	Construct the event and send.
	TE_close.what = evCommand;
	TE_close.message.command = cmOwnerClose;
	TE_close.message.infoPtr = (void *)this;
	TProgram::application->putEvent(TE_close);
}
