#ifndef _h_event 
#define _h_event
#define LINK_FAIL   0
#define NODE_FAIL   1
#define JOIN        2
#define LEAVE       3
#define TRUE 1
#define FALSE 0
#define NEVER -1
#define EWEIGHT 1.0
#define N       5001 /* Max number of vertices + 1 */
#define Xmax 101
#define Ymax 101
#define MEMP 0.5
#define SRCP 0.1
#define LL  (sqrt((double)Xmax * Xmax + Ymax * Ymax))  /* 'L' in Waxman's formula */
#define DIST(i, j) \
  (sqrt((double)(point[i].x - point[j].x) * (point[i].x - point[j].x) \
                     +(point[i].y - point[j].y)*(point[i].y - point[j].y)))
long seq();
/* struct of the node failure event */
typedef struct{
  int id;
  int alive; /* To find out when does this node come back up, if ever */
} NODE_DEAD;

typedef NODE_DEAD *NODE_DEADPTR;

/*  Sturcture of link faliure event */
typedef struct{
  int start;
  int end;
  int alive; /* To find out when does this link come back up, if ever */
} LINK_DEAD;

typedef LINK_DEAD *LINK_DEADPTR;

/*  Structure of an event corresponding to a receiver joining event */
typedef struct{
  int id;
  int gid; /* The group it wants to join.  For later implementation. */
} RECEIVER_JOIN;

typedef RECEIVER_JOIN *RECEIVER_JOINPTR;

/* Structure of a receiver leaving event */
typedef struct{
  int id;
  int gid;
} RECEIVER_LEAVE;

typedef RECEIVER_LEAVE *RECEIVER_LEAVEPTR;

/*  Structure of an event */
struct event{
  long seq_no;  /* To identify each event */
  int type;   /* one of the typedefs above */
  union{
    NODE_DEADPTR node_dead;
    LINK_DEADPTR link_dead;
    RECEIVER_JOINPTR receiver_join;
    RECEIVER_LEAVEPTR receiver_leave;
  } effect;
  struct event* next;  /* To put the events in the queue */
  struct event* prev;
};

typedef struct event EVENT;
typedef EVENT *EVENTPTR;

/* Structure of an update sent to nodes */
struct update{
  long seq_no;  /* Sequence number of the event that caused this update*/
  int node;  /* node for which this is an update */
  long service_time;
  int* vector; /* Containing the update vector that will be used to */
               /* update the routing table entries in "node"        */
};

typedef struct update UPDATE;
typedef UPDATE *UPDATEPTR;

/* Queue to store the events in */
struct equeue{
  EVENTPTR head;
  EVENTPTR tail;
};

typedef struct equeue EQUEUE;
typedef EQUEUE *EQUEUEPTR;

/* Queue to store the updates in. This is a priority queue that inserts events corresponting
*  to the time that they are supposed to be serviced in. 
*/
struct uqueue{
  UPDATEPTR head;
  UPDATEPTR tail;
};

typedef struct uqueue UQUEUE;
typedef UQUEUE *UQUEUEPTR;

extern EVENTPTR create_event(int t, void* eff);
extern NODE_DEADPTR create_dead_node_event(int which, int comeback);
extern LINK_DEADPTR create_dead_link_event(int s, int e, int comeback);
extern delete_event(EVENTPTR e);
#endif
