#include <stdio.h>
#include <stdlib.h>
#include "event.h"

long sequence = -1;

/* Initializes the two queues that it gets.  Allocates memory to them */

int init_queues(EQUEUEPTR e, UQUEUEPTR u){
  e = (EQUEUEPTR) malloc(sizeof(EQUEUE));
  u = (UQUEUEPTR) malloc(sizeof(UQUEUE));
  if (e == NULL || u == NULL) return FALSE;
  e->head = e->tail = (EVENTPTR) 0;
  u->head = u->tail = (UPDATEPTR) 0;
  return TRUE;
}

/*
* Inserts the event into the event queue.
*/

int enq_event(EVENTPTR e, EQUEUEPTR p)
{
  EVENTPTR t;
  t = p->tail;
  p->tail = t->next = e;  /* Set the q's pointers */
  e->prev = t;            /* set the new node's pointers */
  e->next = (EVENTPTR) 0; /* ------------do ------------ */
  return TRUE;
}

/*  returns the event out of the head of the event q */

EVENTPTR deq_event(EQUEUEPTR p)
{
  EVENTPTR t;
  t = p->head;
  p->head = p->head->next;  /* Set up the queue pointers */
  p->head->prev = (EVENTPTR) 0; /* Set up the node pointers */
  return t;
}

/*  returns a pointer to an event to be inserted in the queue */
/*  Allocates memory to the event and the next and prev pointers */

EVENTPTR create_event(int t, void *eff){
  EVENTPTR new_event;
  new_event = (EVENTPTR) malloc(sizeof(EVENT));
  if (new_event == NULL) return (EVENTPTR) 0;
  new_event->seq_no = seq();
  new_event->type  = t;
  if (new_event->type == LINK_FAIL)
    new_event->effect.link_dead = (LINK_DEADPTR) eff;
  else if (new_event->type == NODE_FAIL) 
    new_event->effect.node_dead = (NODE_DEADPTR) eff;
  else if (new_event->type == JOIN) 
    new_event->effect.receiver_join = (RECEIVER_JOINPTR) eff;
  else if (new_event->type == LEAVE) 
    new_event->effect.receiver_leave = (RECEIVER_LEAVEPTR) eff;
  else{
    free(new_event);
    return (EVENTPTR) 0;
  }
  new_event->next = (EVENTPTR) 0;
  new_event->prev = (EVENTPTR) 0;
  return new_event;
}

/* 
* De-allocates the memory for the event that has been de-queued and
* served.
*/

delete_event(EVENTPTR e)
{
  if (e == NULL) return;
  if (e->type == LINK_FAIL)
    delete_dead_link_event(e->effect.link_dead);
  else if (e->type == NODE_FAIL)
    delete_dead_node_event(e->effect.node_dead);
  else if (e->type == JOIN)
    delete_receiver_join_event(e->effect.receiver_join);
  else if (e->type == LEAVE)
    delete_receiver_leave_event(e->effect.receiver_leave);
  free(e);
}
/*  
*  The next four functions create the specific events that will be used 
*  for insertion into the event queue.  Allocate memory in all cases.
*/

NODE_DEADPTR create_dead_node_event(int which, int comeback){
  NODE_DEADPTR new_event;
  new_event = (NODE_DEADPTR) malloc(sizeof(NODE_DEAD));
  if (new_event == NULL) return (NODE_DEADPTR) 0;
  new_event->id = which;
  new_event->alive = comeback;
  return new_event;
}

LINK_DEADPTR create_dead_link_event(int s, int e, int comeback){
  LINK_DEADPTR new_event;
  new_event = (LINK_DEADPTR) malloc(sizeof(LINK_DEAD));
  if (new_event == NULL) return (LINK_DEADPTR) 0;
  new_event->start = s;
  new_event->end = e;
  new_event->alive = comeback;
  return new_event;
}

RECEIVER_JOINPTR create_receiver_join_event(int which, int g){
  RECEIVER_JOINPTR new_event;
  new_event = (RECEIVER_JOINPTR) malloc(sizeof(RECEIVER_JOIN));
  if (new_event == NULL) return (RECEIVER_JOINPTR) 0;
  new_event->id = which;
  new_event->gid = g;
  return new_event;
}

RECEIVER_LEAVEPTR create_receiver_leave_event(int which, int g){       
  RECEIVER_LEAVEPTR new_event;
  new_event = (RECEIVER_LEAVEPTR) malloc(sizeof(RECEIVER_LEAVE));
  if (new_event == NULL) return (RECEIVER_LEAVEPTR) 0;
  new_event->id = which;
  new_event->gid = g;       
  return new_event;
} 

/*
*  Deletes the memory allocated to the events above
*/

delete_dead_node_event(NODE_DEADPTR e)
{
  free(e);
}

delete_dead_link_event(LINK_DEADPTR e)
{
  free(e);
}

delete_receiver_join_event(RECEIVER_JOINPTR e)
{
  free(e);
}


delete_receiver_leave_event(RECEIVER_LEAVEPTR e)
{
  free(e);
}

/* Gives a sequence of numbers for unique sequence numbers on the events
*/

long seq(){
  return ++sequence;
}
