/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomComment;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlApplet;
import com.gargoylesoftware.htmlunit.html.HtmlBody;
import com.gargoylesoftware.htmlunit.html.HtmlBreak;
import com.gargoylesoftware.htmlunit.html.HtmlCheckBoxInput;
import com.gargoylesoftware.htmlunit.html.HtmlHiddenInput;
import com.gargoylesoftware.htmlunit.html.HtmlInlineFrame;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlListItem;
import com.gargoylesoftware.htmlunit.html.HtmlNoFrames;
import com.gargoylesoftware.htmlunit.html.HtmlNoScript;
import com.gargoylesoftware.htmlunit.html.HtmlOption;
import com.gargoylesoftware.htmlunit.html.HtmlOrderedList;
import com.gargoylesoftware.htmlunit.html.HtmlPreformattedText;
import com.gargoylesoftware.htmlunit.html.HtmlRadioButtonInput;
import com.gargoylesoftware.htmlunit.html.HtmlResetInput;
import com.gargoylesoftware.htmlunit.html.HtmlScript;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.gargoylesoftware.htmlunit.html.HtmlStyle;
import com.gargoylesoftware.htmlunit.html.HtmlSubmitInput;
import com.gargoylesoftware.htmlunit.html.HtmlTable;
import com.gargoylesoftware.htmlunit.html.HtmlTableCell;
import com.gargoylesoftware.htmlunit.html.HtmlTableFooter;
import com.gargoylesoftware.htmlunit.html.HtmlTableHeader;
import com.gargoylesoftware.htmlunit.html.HtmlTableRow;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import com.gargoylesoftware.htmlunit.html.HtmlTitle;
import com.gargoylesoftware.htmlunit.html.HtmlUnorderedList;
import com.gargoylesoftware.htmlunit.html.TableRowGroup;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

class HtmlSerializer {
    private final StringBuilder builder_ = new StringBuilder();
    protected static final String AS_TEXT_BLOCK_SEPARATOR = "\u00a7bs\u00a7";
    private static final int AS_TEXT_BLOCK_SEPARATOR_LENGTH = "\u00a7bs\u00a7".length();
    protected static final String AS_TEXT_NEW_LINE = "\u00a7nl\u00a7";
    private static final int AS_TEXT_NEW_LINE_LENGTH = "\u00a7nl\u00a7".length();
    protected static final String AS_TEXT_BLANK = "\u00a7blank\u00a7";
    protected static final String AS_TEXT_TAB = "\u00a7tab\u00a7";
    private static final Pattern TEXT_AREA_PATTERN = Pattern.compile("\r?\n");
    private boolean appletEnabled_;
    private boolean ignoreMaskedElements_ = true;

    HtmlSerializer() {
    }

    public String asText(DomNode node) {
        this.appletEnabled_ = node.getPage().getWebClient().getOptions().isAppletEnabled();
        this.builder_.setLength(0);
        this.appendNode(node);
        String response = this.builder_.toString();
        this.builder_.setLength(0);
        return this.cleanUp(response);
    }

    protected String cleanUp(String text) {
        text = HtmlSerializer.reduceWhitespace(text);
        text = StringUtils.replace(text, AS_TEXT_BLANK, " ");
        String ls = System.lineSeparator();
        text = StringUtils.replace(text, AS_TEXT_NEW_LINE, ls);
        text = StringUtils.replace(text, AS_TEXT_BLOCK_SEPARATOR, ls);
        text = StringUtils.replace(text, AS_TEXT_TAB, "\t");
        return text;
    }

    private static String reduceWhitespace(String text) {
        text = HtmlSerializer.trim(text);
        text = HtmlSerializer.reduceWhiteSpaceAroundBlockSeparator(text);
        while (text.startsWith(AS_TEXT_BLOCK_SEPARATOR)) {
            text = text.substring(AS_TEXT_BLOCK_SEPARATOR_LENGTH);
        }
        while (text.endsWith(AS_TEXT_BLOCK_SEPARATOR)) {
            text = text.substring(0, text.length() - AS_TEXT_BLOCK_SEPARATOR_LENGTH);
        }
        text = HtmlSerializer.trim(text);
        StringBuilder builder = new StringBuilder(text.length());
        boolean whitespace = false;
        for (char ch : text.toCharArray()) {
            if (ch == '\u00a0') {
                builder.append(' ');
                whitespace = false;
                continue;
            }
            if (whitespace) {
                if (HtmlSerializer.isSpace(ch)) continue;
                builder.append(ch);
                whitespace = false;
                continue;
            }
            if (HtmlSerializer.isSpace(ch)) {
                whitespace = true;
                builder.append(' ');
                continue;
            }
            builder.append(ch);
        }
        return builder.toString();
    }

    private static boolean isSpace(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\n' || ch == '\f' || ch == '\r';
    }

    private static String trim(String string) {
        int start;
        int length = string.length();
        for (start = 0; start != length && HtmlSerializer.isSpace(string.charAt(start)); ++start) {
        }
        if (start != 0) {
            string = string.substring(start);
            length = string.length();
        }
        if (length != 0) {
            int end;
            for (end = length; end != 0 && HtmlSerializer.isSpace(string.charAt(end - 1)); --end) {
            }
            if (end != length) {
                string = string.substring(0, end);
            }
        }
        return string;
    }

    private static String reduceWhiteSpaceAroundBlockSeparator(String text) {
        int p0 = text.indexOf(AS_TEXT_BLOCK_SEPARATOR);
        if (p0 == -1) {
            return text;
        }
        int length = text.length();
        if (length <= AS_TEXT_BLOCK_SEPARATOR_LENGTH) {
            return text;
        }
        StringBuilder result = new StringBuilder(length);
        int start = 0;
        while (p0 != -1) {
            int p1 = p0 + AS_TEXT_BLOCK_SEPARATOR_LENGTH;
            while (p0 != start && HtmlSerializer.isSpace(text.charAt(p0 - 1))) {
                --p0;
            }
            if (p0 >= AS_TEXT_NEW_LINE_LENGTH && text.startsWith(AS_TEXT_NEW_LINE, p0 - AS_TEXT_NEW_LINE_LENGTH)) {
                p0 -= AS_TEXT_NEW_LINE_LENGTH;
            }
            result.append(text.substring(start, p0)).append(AS_TEXT_BLOCK_SEPARATOR);
            while (p1 < length && HtmlSerializer.isSpace(text.charAt(p1))) {
                ++p1;
            }
            start = p1;
            p0 = text.indexOf(AS_TEXT_BLOCK_SEPARATOR, start);
            while (p0 != -1 && p0 == start) {
                p0 = text.indexOf(AS_TEXT_BLOCK_SEPARATOR, start += AS_TEXT_BLOCK_SEPARATOR_LENGTH);
            }
        }
        if (start < length) {
            result.append(text.substring(start));
        }
        return result.toString();
    }

    protected void appendNode(DomNode node) {
        if (node instanceof DomText) {
            this.appendText((DomText)node);
        } else if (!(node instanceof DomComment || node instanceof HtmlApplet && this.appletEnabled_)) {
            if (node instanceof HtmlBreak) {
                this.doAppendNewLine();
            } else if (!(node instanceof HtmlHiddenInput || node instanceof HtmlScript || node instanceof HtmlStyle || node instanceof HtmlNoFrames)) {
                if (node instanceof HtmlTextArea) {
                    this.appendHtmlTextArea((HtmlTextArea)node);
                } else if (node instanceof HtmlTitle) {
                    this.appendHtmlTitle((HtmlTitle)node);
                } else if (node instanceof HtmlTableRow) {
                    this.appendHtmlTableRow((HtmlTableRow)node);
                } else if (node instanceof HtmlSelect) {
                    this.appendHtmlSelect((HtmlSelect)node);
                } else if (node instanceof HtmlSubmitInput) {
                    this.doAppend(((HtmlSubmitInput)node).asText());
                } else if (node instanceof HtmlResetInput) {
                    this.doAppend(((HtmlResetInput)node).asText());
                } else if (node instanceof HtmlCheckBoxInput) {
                    String str = ((HtmlCheckBoxInput)node).isChecked() ? "checked" : "unchecked";
                    this.doAppend(str);
                } else if (node instanceof HtmlRadioButtonInput) {
                    String str = ((HtmlRadioButtonInput)node).isChecked() ? "checked" : "unchecked";
                    this.doAppend(str);
                } else if (node instanceof HtmlInput) {
                    this.doAppend(((HtmlInput)node).getValueAttribute());
                } else if (node instanceof HtmlTable) {
                    this.appendHtmlTable((HtmlTable)node);
                } else if (node instanceof HtmlOrderedList) {
                    this.appendHtmlOrderedList((HtmlOrderedList)node);
                } else if (node instanceof HtmlUnorderedList) {
                    this.appendHtmlUnorderedList((HtmlUnorderedList)node);
                } else if (node instanceof HtmlPreformattedText) {
                    this.appendHtmlPreformattedText((HtmlPreformattedText)node);
                } else if (node instanceof HtmlInlineFrame) {
                    this.appendHtmlInlineFrame((HtmlInlineFrame)node);
                } else {
                    boolean block;
                    if (node instanceof HtmlNoScript && node.getPage().getWebClient().getOptions().isJavaScriptEnabled()) {
                        return;
                    }
                    Object scriptableObject = node.getScriptableObject();
                    if (node instanceof HtmlBody) {
                        block = false;
                    } else if (scriptableObject instanceof Element) {
                        Element element = (Element)scriptableObject;
                        String display = element.getWindow().getComputedStyle(element, null).getDisplay(true);
                        block = "block".equals(display);
                    } else {
                        block = false;
                    }
                    if (block) {
                        this.doAppendBlockSeparator();
                    }
                    this.appendChildren(node);
                    if (block) {
                        this.doAppendBlockSeparator();
                    }
                }
            }
        }
    }

    private void doAppendBlockSeparator() {
        this.builder_.append(AS_TEXT_BLOCK_SEPARATOR);
    }

    private void doAppend(String str) {
        this.builder_.append(str);
    }

    private void doAppendNewLine() {
        this.builder_.append(AS_TEXT_NEW_LINE);
    }

    private void doAppendTab() {
        this.builder_.append(AS_TEXT_TAB);
    }

    private void appendHtmlUnorderedList(HtmlUnorderedList htmlUnorderedList) {
        this.doAppendBlockSeparator();
        boolean first = true;
        for (DomNode item : htmlUnorderedList.getChildren()) {
            if (!first) {
                this.doAppendBlockSeparator();
            }
            first = false;
            this.appendNode(item);
        }
        this.doAppendBlockSeparator();
    }

    private void appendHtmlTitle(HtmlTitle htmlTitle) {
        DomNode child = htmlTitle.getFirstChild();
        if (child instanceof DomText) {
            this.doAppend(((DomText)child).getData());
            this.doAppendBlockSeparator();
            return;
        }
    }

    private void appendChildren(DomNode node) {
        for (DomNode child : node.getChildren()) {
            this.appendNode(child);
        }
    }

    private void appendHtmlTableRow(HtmlTableRow htmlTableRow) {
        boolean first = true;
        for (HtmlTableCell cell : htmlTableRow.getCells()) {
            if (!first) {
                this.doAppendTab();
            } else {
                first = false;
            }
            this.appendChildren(cell);
        }
    }

    private void appendHtmlTextArea(HtmlTextArea htmlTextArea) {
        if (this.isVisible(htmlTextArea)) {
            String text = htmlTextArea.getText();
            text = StringUtils.stripEnd(text, null);
            text = TEXT_AREA_PATTERN.matcher(text).replaceAll(AS_TEXT_NEW_LINE);
            text = StringUtils.replace(text, "\r", AS_TEXT_NEW_LINE);
            text = StringUtils.replace(text, " ", AS_TEXT_BLANK);
            this.doAppend(text);
        }
    }

    private void appendHtmlTable(HtmlTable htmlTable) {
        DomNode firstChild;
        this.doAppendBlockSeparator();
        String caption = htmlTable.getCaptionText();
        if (caption != null) {
            this.doAppend(caption);
            this.doAppendBlockSeparator();
        }
        boolean first = true;
        HtmlTableHeader tableHeader = htmlTable.getHeader();
        if (tableHeader != null) {
            first = this.appendHtmlTableRows(tableHeader.getRows(), true, null, null);
        }
        HtmlTableFooter tableFooter = htmlTable.getFooter();
        List<HtmlTableRow> tableRows = htmlTable.getRows();
        first = this.appendHtmlTableRows(tableRows, first, tableHeader, tableFooter);
        if (tableFooter != null) {
            first = this.appendHtmlTableRows(tableFooter.getRows(), first, null, null);
        } else if (tableRows.isEmpty() && (firstChild = htmlTable.getFirstChild()) != null) {
            this.appendNode(firstChild);
        }
        this.doAppendBlockSeparator();
    }

    private boolean appendHtmlTableRows(List<HtmlTableRow> rows, boolean first, TableRowGroup skipParent1, TableRowGroup skipParent2) {
        for (HtmlTableRow row : rows) {
            if (row.getParentNode() == skipParent1 || row.getParentNode() == skipParent2) continue;
            if (!first) {
                this.doAppendBlockSeparator();
            }
            first = false;
            this.appendHtmlTableRow(row);
        }
        return first;
    }

    private void appendHtmlSelect(HtmlSelect htmlSelect) {
        List<HtmlOption> options = htmlSelect.isMultipleSelectEnabled() ? htmlSelect.getOptions() : htmlSelect.getSelectedOptions();
        Iterator<HtmlOption> i = options.iterator();
        while (i.hasNext()) {
            HtmlOption currentOption = i.next();
            this.appendNode(currentOption);
            if (!i.hasNext()) continue;
            this.doAppendBlockSeparator();
        }
    }

    private void appendHtmlOrderedList(HtmlOrderedList htmlOrderedList) {
        this.doAppendBlockSeparator();
        boolean first = true;
        int i = 1;
        for (DomNode item : htmlOrderedList.getChildren()) {
            if (!first) {
                this.doAppendBlockSeparator();
            }
            first = false;
            if (item instanceof HtmlListItem) {
                this.doAppend(Integer.toString(i++));
                this.doAppend(". ");
                this.appendChildren(item);
                continue;
            }
            this.appendNode(item);
        }
        this.doAppendBlockSeparator();
    }

    private void appendHtmlPreformattedText(HtmlPreformattedText htmlPreformattedText) {
        if (this.isVisible(htmlPreformattedText)) {
            this.doAppendBlockSeparator();
            String text = htmlPreformattedText.getTextContent();
            text = StringUtils.replace(text, "\t", AS_TEXT_TAB);
            text = StringUtils.replace(text, " ", AS_TEXT_BLANK);
            text = TEXT_AREA_PATTERN.matcher(text).replaceAll(AS_TEXT_NEW_LINE);
            text = StringUtils.replace(text, "\r", AS_TEXT_NEW_LINE);
            this.doAppend(text);
            this.doAppendBlockSeparator();
        }
    }

    private void appendHtmlInlineFrame(HtmlInlineFrame htmlInlineFrame) {
        if (this.isVisible(htmlInlineFrame)) {
            this.doAppendBlockSeparator();
            Page page = htmlInlineFrame.getEnclosedPage();
            if (page instanceof SgmlPage) {
                this.doAppend(((SgmlPage)page).asText());
            }
            this.doAppendBlockSeparator();
        }
    }

    private void appendText(DomText domText) {
        DomNode parent = domText.getParentNode();
        if (parent == null || parent instanceof HtmlTitle || this.isVisible(parent)) {
            this.append(domText.getData());
        }
    }

    private boolean isVisible(DomNode node) {
        return !this.ignoreMaskedElements_ || node.isDisplayed();
    }

    public void setIgnoreMaskedElements(boolean ignore) {
        this.ignoreMaskedElements_ = ignore;
    }

    private void append(String text) {
        this.doAppend(text);
    }
}

