#!/usr/bin/perl -w

###############################################################################
#
# A test for Spreadsheet::WriteExcelXML.
#
# Tests cell comments.
#
# reverse(''), April 2005, John McNamara, jmcnamara@cpan.org
#


use strict;
use Spreadsheet::WriteExcelXML;
use Test::More tests => 8;



##############################################################################
#
# Create a new Excel XML file with row data set.
#
my $test_file  = "temp_test_file.xml";
my $workbook   = Spreadsheet::WriteExcelXML->new($test_file);
my $worksheet  = $workbook->add_worksheet();
my $format     = $workbook->add_format(fg_color => 'yellow', border => 6);

$worksheet->set_column('B:B', 18);

# Ordinary string
$worksheet->write            ('B2', 'Hello');

# Ordinary string (Html to be escaped)
$worksheet->write            ('B3', 'Some <B>bold</B>');

# Ordinary string with format (Html to be escaped)
$worksheet->write            ('B4', 'Some <B>bold</B>', $format);

# Html string
$worksheet->write_html_string('B5', 'Some <B>bold</B>');

# Html string with format
$worksheet->write_html_string('B6', 'Some <B>bold</B>', $format);

# Html string (undocumented extra parameter)
$worksheet->write            ('B7', 'Some <B>bold</B>', undef, 1);

# Html string (undocumented extra parameter)
$worksheet->write            ('B8', 'Some <B>bold</B>', $format, 1);



$workbook->close();


##############################################################################
#
# Re-open and reread the Excel file.
#
open XML, $test_file or die "Couldn't open $test_file: $!\n";
my @swex_data = extract_cells(*XML);
close XML;
unlink $test_file;


##############################################################################
#
# Read the data from the Excel file in the __DATA__ section
#
my @test_data = extract_cells(*DATA);


##############################################################################
#
# Check for the same number of elements.
#

is(@swex_data, @test_data, " \tCheck for data size");


##############################################################################
#
# Test that the SWEX elements and Excel are the same.
#

# Pad the SWEX data if necessary.
push @swex_data, ('') x (@test_data -@swex_data);

my $cell = "B2";

for my $i (0 .. @test_data -1) {
    is($swex_data[$i],$test_data[$i], " \tTesting Html strings: ".  $cell++);

}



##############################################################################
#
# Extract <Cell> elements from a given filehandle.
#
sub extract_cells {

    my $fh      = $_[0];
    my $in_cell = 0;
    my $cell    = '';
    my @cells;

    while (<$fh>) {
        s/^\s+([<| ])/$1/;
        s/\s+$//;

        if (m/<Cell/) {
            $in_cell = 1;
            $cell    = '';
        }

        $cell .= $_ if $in_cell;

        if (m[</Cell>]) {
            $in_cell  = 0;
            #$cell =~ s{>.*}{>};
            #$cell =~ s{/>$}{>};
            push @cells, $cell;
            $cell     = '';
        }
    }

    return @cells;
}



# The following data was generated by Excel.
__DATA__
<?xml version="1.0"?>
<?mso-application progid="Excel.Sheet"?>
<Workbook xmlns="urn:schemas-microsoft-com:office:spreadsheet"
 xmlns:o="urn:schemas-microsoft-com:office:office"
 xmlns:x="urn:schemas-microsoft-com:office:excel"
 xmlns:ss="urn:schemas-microsoft-com:office:spreadsheet"
 xmlns:html="http://www.w3.org/TR/REC-html40">
 <Styles>
  <Style ss:ID="Default" ss:Name="Normal">
   <Alignment ss:Vertical="Bottom"/>
   <Borders/>
   <Font/>
   <Interior/>
   <NumberFormat/>
   <Protection/>
  </Style>
  <Style ss:ID="s21">
   <Alignment ss:Vertical="Bottom"/>
   <Borders>
    <Border ss:Position="Bottom" ss:LineStyle="Double" ss:Weight="3"/>
    <Border ss:Position="Left" ss:LineStyle="Double" ss:Weight="3"/>
    <Border ss:Position="Right" ss:LineStyle="Double" ss:Weight="3"/>
    <Border ss:Position="Top" ss:LineStyle="Double" ss:Weight="3"/>
   </Borders>
   <Font/>
   <Interior ss:Color="#FFFF00" ss:Pattern="Solid"/>
   <NumberFormat/>
   <Protection/>
  </Style>
 </Styles>
 <Worksheet ss:Name="Sheet1">
  <Table ss:ExpandedColumnCount="2" ss:ExpandedRowCount="8" x:FullColumns="1"
   x:FullRows="1">
   <Column ss:Index="2" ss:AutoFitWidth="0" ss:Width="98.25"/>
   <Row ss:Index="2">
    <Cell ss:Index="2"><Data ss:Type="String">Hello</Data></Cell>
   </Row>
   <Row ss:Height="13.5">
    <Cell ss:Index="2"><Data ss:Type="String">Some &lt;B&gt;bold&lt;/B&gt;</Data></Cell>
   </Row>
   <Row ss:Height="14.25">
    <Cell ss:Index="2" ss:StyleID="s21"><Data ss:Type="String">Some &lt;B&gt;bold&lt;/B&gt;</Data></Cell>
   </Row>
   <Row ss:Height="14.25">
    <Cell ss:Index="2"><ss:Data ss:Type="String"
      xmlns="http://www.w3.org/TR/REC-html40">Some <B>bold</B></ss:Data></Cell>
   </Row>
   <Row ss:Height="14.25">
    <Cell ss:Index="2" ss:StyleID="s21"><ss:Data ss:Type="String"
      xmlns="http://www.w3.org/TR/REC-html40">Some <B>bold</B></ss:Data></Cell>
   </Row>
   <Row ss:Height="14.25">
    <Cell ss:Index="2"><ss:Data ss:Type="String"
      xmlns="http://www.w3.org/TR/REC-html40">Some <B>bold</B></ss:Data></Cell>
   </Row>
   <Row ss:Height="14.25">
    <Cell ss:Index="2" ss:StyleID="s21"><ss:Data ss:Type="String"
      xmlns="http://www.w3.org/TR/REC-html40">Some <B>bold</B></ss:Data></Cell>
   </Row>
  </Table>
  <WorksheetOptions xmlns="urn:schemas-microsoft-com:office:excel">
   <Selected/>
   <ProtectObjects>False</ProtectObjects>
   <ProtectScenarios>False</ProtectScenarios>
  </WorksheetOptions>
 </Worksheet>
</Workbook>

