/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.txt;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.tika.detect.EncodingDetector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.txt.CharsetDetector;
import org.apache.tika.parser.txt.CharsetMatch;
import org.apache.tika.utils.CharsetUtils;

public class Icu4jEncodingDetector
implements EncodingDetector {
    public Charset detect(InputStream input, Metadata metadata) throws IOException {
        String cleaned;
        MediaType mt;
        if (input == null) {
            return null;
        }
        CharsetDetector detector = new CharsetDetector();
        String incomingCharset = metadata.get("Content-Encoding");
        String incomingType = metadata.get("Content-Type");
        if (incomingCharset == null && incomingType != null && (mt = MediaType.parse(incomingType)) != null) {
            incomingCharset = mt.getParameters().get("charset");
        }
        if (incomingCharset != null && (cleaned = CharsetUtils.clean(incomingCharset)) != null) {
            detector.setDeclaredEncoding(cleaned);
        }
        detector.enableInputFilter(true);
        detector.setText(input);
        for (CharsetMatch match : detector.detectAll()) {
            try {
                return CharsetUtils.forName(match.getName());
            }
            catch (Exception e) {
            }
        }
        return null;
    }
}

