/*
 * Decompiled with CFR 0.152.
 */
package at.ac.tuwien.dbai.pdfwrap.operator;

import at.ac.tuwien.dbai.pdfwrap.pdfread.PDFObjectExtractor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectForm;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;
import org.apache.pdfbox.util.Matrix;
import org.apache.pdfbox.util.PDFOperator;
import org.apache.pdfbox.util.operator.OperatorProcessor;

public class Invoke
extends OperatorProcessor {
    public void process(PDFOperator operator, List arguments) throws IOException {
        PDFObjectExtractor drawer = (PDFObjectExtractor)this.context;
        PDPage page = drawer.getPage();
        Dimension pageSize = drawer.getPageSize();
        Graphics2D graphics = drawer.getGraphics();
        COSName objectName = (COSName)arguments.get(0);
        Map xobjects = drawer.getResources().getXObjects();
        PDXObject xobject = (PDXObject)xobjects.get(objectName.getName());
        if (xobject instanceof PDXObjectImage) {
            PDXObjectImage image = (PDXObjectImage)xobject;
            try {
                Matrix ctm = drawer.getGraphicsState().getCurrentTransformationMatrix();
                int width = image.getWidth();
                int height = image.getHeight();
                Matrix scalingParams = ctm.extractScaling();
                Matrix scalingMatrix = Matrix.getScaleInstance((float)(1.0f / (float)width), (float)(1.0f / (float)height));
                scalingParams = scalingParams.multiply(scalingMatrix);
                Matrix translationParams = ctm.extractTranslating();
                Matrix translationMatrix = null;
                translationParams.setValue(2, 1, -translationParams.getValue(2, 1));
                translationMatrix = Matrix.getTranslatingInstance((float)0.0f, (float)((float)pageSize.getHeight() - (float)height * scalingParams.getYScale()));
                translationParams = translationParams.multiply(translationMatrix);
                AffineTransform at = new AffineTransform(scalingParams.getValue(0, 0), 0.0f, 0.0f, scalingParams.getValue(1, 1), translationParams.getValue(2, 0), translationParams.getValue(2, 1));
                double scaleX = at.getScaleX();
                double scaleY = at.getScaleY();
                if (scaleX == 0.0) {
                    scaleX = 1.0;
                }
                if (scaleY == 0.0) {
                    scaleY = 1.0;
                }
                drawer.simpleDrawImage((float)at.getTranslateX(), (float)(at.getTranslateX() + (double)width * scaleX), (float)at.getTranslateY(), (float)(at.getTranslateY() + (double)height * scaleY));
                BufferedImage awtImage = image.getRGBImage();
                if (awtImage == null) {
                    return;
                }
                graphics.drawImage(awtImage, at, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            catch (Error err) {
                err.printStackTrace();
            }
        } else if (xobject instanceof PDXObjectForm) {
            PDXObjectForm form = (PDXObjectForm)xobject;
            COSStream invoke = (COSStream)form.getCOSObject();
            PDResources pdResources = form.getResources();
            if (pdResources == null) {
                pdResources = page.findResources();
            }
            this.getContext().processSubStream(page, pdResources, invoke);
        }
    }
}

