/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hemf.record;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hemf.record.AbstractHemfComment;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.Internal;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.RecordFormatException;

@Internal
public class HemfCommentPublic {
    private static final int MAX_RECORD_LENGTH = 1000000;

    public static class HemfMultiFormatsData {
        long signature;
        long version;
        byte[] data;

        public HemfMultiFormatsData(long signature, long version, byte[] data) {
            this.signature = signature;
            this.version = version;
            this.data = data;
        }

        public long getSignature() {
            return this.signature;
        }

        public long getVersion() {
            return this.version;
        }

        public byte[] getData() {
            return this.data;
        }
    }

    public static class WindowsMetafile
    extends AbstractHemfComment {
        private final byte[] wmfBytes;

        public WindowsMetafile(byte[] rawBytes) {
            super(rawBytes);
            int offset = 4;
            int version = LittleEndian.getUShort(rawBytes, offset);
            int reserved = LittleEndian.getUShort(rawBytes, offset += 2);
            offset += 2;
            offset += 4;
            long winMetafileSizeLong = LittleEndian.getUInt(rawBytes, offset += 4);
            offset += 4;
            if (winMetafileSizeLong == 0L) {
                this.wmfBytes = new byte[0];
                return;
            }
            this.wmfBytes = IOUtils.safelyAllocate(winMetafileSizeLong, 1000000);
            System.arraycopy(rawBytes, offset, this.wmfBytes, 0, this.wmfBytes.length);
        }

        public InputStream getWmfInputStream() {
            return new ByteArrayInputStream(this.wmfBytes);
        }
    }

    public static class MultiFormats
    extends AbstractHemfComment {
        public MultiFormats(byte[] rawBytes) {
            super(rawBytes);
        }

        public List<HemfMultiFormatsData> getData() {
            byte[] rawBytes = this.getRawBytes();
            int currentOffset = 20;
            long countFormats = LittleEndian.getUInt(rawBytes, currentOffset);
            currentOffset += 4;
            ArrayList<EmrFormat> emrFormatList = new ArrayList<EmrFormat>();
            for (long i = 0L; i < countFormats; ++i) {
                emrFormatList.add(new EmrFormat(rawBytes, currentOffset));
                currentOffset += 16;
            }
            ArrayList<HemfMultiFormatsData> list = new ArrayList<HemfMultiFormatsData>();
            for (EmrFormat emrFormat : emrFormatList) {
                byte[] data = IOUtils.safelyAllocate(emrFormat.size, 1000000);
                System.arraycopy(rawBytes, emrFormat.offset - 4, data, 0, emrFormat.size);
                list.add(new HemfMultiFormatsData(emrFormat.signature, emrFormat.version, data));
            }
            return list;
        }

        private static class EmrFormat {
            long signature;
            long version;
            int size;
            int offset;

            public EmrFormat(byte[] rawBytes, int currentOffset) {
                this.signature = LittleEndian.getUInt(rawBytes, currentOffset);
                this.version = LittleEndian.getUInt(rawBytes, currentOffset += 4);
                this.size = LittleEndian.getInt(rawBytes, currentOffset += 4);
                this.offset = LittleEndian.getInt(rawBytes, currentOffset += 4);
                currentOffset += 4;
                if (this.size < 0) {
                    throw new RecordFormatException("size for emrformat must be > 0");
                }
                if (this.offset < 0) {
                    throw new RecordFormatException("offset for emrformat must be > 0");
                }
            }
        }
    }

    public static class EndGroup
    extends AbstractHemfComment {
        public EndGroup(byte[] rawBytes) {
            super(rawBytes);
        }
    }

    public static class BeginGroup
    extends AbstractHemfComment {
        public BeginGroup(byte[] rawBytes) {
            super(rawBytes);
        }
    }
}

