/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.matrix;

import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.matrix.MismatchedMatrixSizeException;
import org.opengis.referencing.operation.Matrix;

public final class Matrix3
extends MatrixSIS {
    private static final long serialVersionUID = 8902061778871586611L;
    public static final int SIZE = 3;
    public double m00;
    public double m01;
    public double m02;
    public double m10;
    public double m11;
    public double m12;
    public double m20;
    public double m21;
    public double m22;

    public Matrix3() {
        this.m22 = 1.0;
        this.m11 = 1.0;
        this.m00 = 1.0;
    }

    Matrix3(boolean bl) {
    }

    public Matrix3(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        this.m00 = d;
        this.m01 = d2;
        this.m02 = d3;
        this.m10 = d4;
        this.m11 = d5;
        this.m12 = d6;
        this.m20 = d7;
        this.m21 = d8;
        this.m22 = d9;
    }

    public Matrix3(double[] dArray) throws IllegalArgumentException {
        this.setElements(dArray);
    }

    Matrix3(Matrix matrix) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.setElement(i, j, matrix.getElement(i, j));
            }
        }
    }

    public static Matrix3 castOrCopy(Matrix matrix) throws MismatchedMatrixSizeException {
        if (matrix == null || matrix instanceof Matrix3) {
            return (Matrix3)matrix;
        }
        Matrix3.ensureSizeMatch(3, 3, matrix);
        return new Matrix3(matrix);
    }

    @Override
    public final int getNumRow() {
        return 3;
    }

    @Override
    public final int getNumCol() {
        return 3;
    }

    @Override
    public final double getElement(int n, int n2) {
        if (n >= 0 && n < 3 && n2 >= 0 && n2 < 3) {
            switch (n * 3 + n2) {
                case 0: {
                    return this.m00;
                }
                case 1: {
                    return this.m01;
                }
                case 2: {
                    return this.m02;
                }
                case 3: {
                    return this.m10;
                }
                case 4: {
                    return this.m11;
                }
                case 5: {
                    return this.m12;
                }
                case 6: {
                    return this.m20;
                }
                case 7: {
                    return this.m21;
                }
                case 8: {
                    return this.m22;
                }
            }
        }
        throw Matrix3.indexOutOfBounds(n, n2);
    }

    @Override
    public final void setElement(int n, int n2, double d) {
        if (n >= 0 && n < 3 && n2 >= 0 && n2 < 3) {
            switch (n * 3 + n2) {
                case 0: {
                    this.m00 = d;
                    return;
                }
                case 1: {
                    this.m01 = d;
                    return;
                }
                case 2: {
                    this.m02 = d;
                    return;
                }
                case 3: {
                    this.m10 = d;
                    return;
                }
                case 4: {
                    this.m11 = d;
                    return;
                }
                case 5: {
                    this.m12 = d;
                    return;
                }
                case 6: {
                    this.m20 = d;
                    return;
                }
                case 7: {
                    this.m21 = d;
                    return;
                }
                case 8: {
                    this.m22 = d;
                    return;
                }
            }
        }
        throw Matrix3.indexOutOfBounds(n, n2);
    }

    @Override
    public final double[] getElements() {
        double[] dArray = new double[9];
        this.getElements(dArray);
        return dArray;
    }

    @Override
    final void getElements(double[] dArray) {
        dArray[0] = this.m00;
        dArray[1] = this.m01;
        dArray[2] = this.m02;
        dArray[3] = this.m10;
        dArray[4] = this.m11;
        dArray[5] = this.m12;
        dArray[6] = this.m20;
        dArray[7] = this.m21;
        dArray[8] = this.m22;
    }

    @Override
    public final void setElements(double[] dArray) {
        Matrix3.ensureLengthMatch(9, dArray);
        this.m00 = dArray[0];
        this.m01 = dArray[1];
        this.m02 = dArray[2];
        this.m10 = dArray[3];
        this.m11 = dArray[4];
        this.m12 = dArray[5];
        this.m20 = dArray[6];
        this.m21 = dArray[7];
        this.m22 = dArray[8];
    }

    @Override
    public final boolean isAffine() {
        return this.m20 == 0.0 && this.m21 == 0.0 && this.m22 == 1.0;
    }

    @Override
    public final boolean isIdentity() {
        return this.m00 == 1.0 && this.m01 == 0.0 && this.m02 == 0.0 && this.m10 == 0.0 && this.m11 == 1.0 && this.m12 == 0.0 && this.isAffine();
    }

    @Override
    public void transpose() {
        double d = this.m01;
        this.m01 = this.m10;
        this.m10 = d;
        d = this.m02;
        this.m02 = this.m20;
        this.m20 = d;
        d = this.m12;
        this.m12 = this.m21;
        this.m21 = d;
    }
}

