/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj;

import org.aopalliance.aop.Advice;
import org.springframework.aop.Pointcut;
import org.springframework.aop.PointcutAdvisor;
import org.springframework.aop.aspectj.AbstractAspectJAdvice;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class AspectJPointcutAdvisor
implements PointcutAdvisor,
Ordered {
    private final AbstractAspectJAdvice advice;
    private final Pointcut pointcut;
    private Integer order;

    public AspectJPointcutAdvisor(AbstractAspectJAdvice advice) {
        Assert.notNull(advice, "Advice must not be null");
        this.advice = advice;
        this.pointcut = advice.buildSafePointcut();
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public boolean isPerInstance() {
        return true;
    }

    public Advice getAdvice() {
        return this.advice;
    }

    public Pointcut getPointcut() {
        return this.pointcut;
    }

    public int getOrder() {
        if (this.order != null) {
            return this.order;
        }
        return this.advice.getOrder();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AspectJPointcutAdvisor)) {
            return false;
        }
        AspectJPointcutAdvisor otherAdvisor = (AspectJPointcutAdvisor)other;
        return ObjectUtils.nullSafeEquals(this.advice, otherAdvisor.advice);
    }

    public int hashCode() {
        return AspectJPointcutAdvisor.class.hashCode();
    }
}

