/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.net.URI;
import org.apache.sis.internal.storage.MetadataBuilder;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.io.IOUtilities;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.StorageConnector;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;

public abstract class URIDataStore
extends DataStore {
    protected final URI location;

    protected URIDataStore(DataStoreProvider dataStoreProvider, StorageConnector storageConnector) throws DataStoreException {
        super(dataStoreProvider, storageConnector);
        this.location = storageConnector.getStorageAs(URI.class);
    }

    @Override
    public ParameterValueGroup getOpenParameters() {
        return URIDataStore.parameters(this.provider, this.location);
    }

    public static ParameterValueGroup parameters(DataStoreProvider dataStoreProvider, URI uRI) {
        if (uRI == null || dataStoreProvider == null) {
            return null;
        }
        ParameterValueGroup parameterValueGroup = dataStoreProvider.getOpenParameters().createValue();
        parameterValueGroup.parameter("location").setValue(uRI);
        return parameterValueGroup;
    }

    protected final void addTitleOrIdentifier(MetadataBuilder metadataBuilder) {
        if (this.location != null) {
            metadataBuilder.addTitleOrIdentifier(IOUtilities.filenameWithoutExtension(super.getDisplayName()), MetadataBuilder.Scope.ALL);
        }
    }

    public static abstract class Provider
    extends DataStoreProvider {
        public static final ParameterDescriptor<URI> LOCATION_PARAM = ((ParameterBuilder)((ParameterBuilder)new ParameterBuilder().setDescription(Resources.formatInternational((short)31))).addName("location")).setRequired(true).create(URI.class, null);
        private volatile ParameterDescriptorGroup openDescriptor;

        protected Provider() {
        }

        @Override
        public final ParameterDescriptorGroup getOpenParameters() {
            ParameterDescriptorGroup parameterDescriptorGroup = this.openDescriptor;
            if (parameterDescriptorGroup == null) {
                this.openDescriptor = parameterDescriptorGroup = this.build((ParameterBuilder)new ParameterBuilder().addName(this.getShortName()));
            }
            return parameterDescriptorGroup;
        }

        protected ParameterDescriptorGroup build(ParameterBuilder parameterBuilder) {
            return parameterBuilder.createGroup(LOCATION_PARAM);
        }

        public static ParameterDescriptorGroup descriptor(String string) {
            return ((ParameterBuilder)new ParameterBuilder().addName(string)).createGroup(LOCATION_PARAM);
        }
    }
}

