/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.MetadataUtilities;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.cs.AffineCS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.ImageDatum;

@XmlType(name="ImageCRSType", propOrder={"cartesianCS", "affineCS", "datum"})
@XmlRootElement(name="ImageCRS")
public class DefaultImageCRS
extends AbstractCRS
implements ImageCRS {
    private static final long serialVersionUID = 7312452786096397847L;
    private ImageDatum datum;

    public DefaultImageCRS(Map<String, ?> map, ImageDatum imageDatum, AffineCS affineCS) {
        super(map, affineCS);
        ArgumentChecks.ensureNonNull("datum", imageDatum);
        this.datum = imageDatum;
    }

    protected DefaultImageCRS(ImageCRS imageCRS) {
        super(imageCRS);
        this.datum = imageCRS.getDatum();
    }

    public static DefaultImageCRS castOrCopy(ImageCRS imageCRS) {
        return imageCRS == null || imageCRS instanceof DefaultImageCRS ? (DefaultImageCRS)imageCRS : new DefaultImageCRS(imageCRS);
    }

    public Class<? extends ImageCRS> getInterface() {
        return ImageCRS.class;
    }

    @Override
    @XmlElement(name="imageDatum", required=true)
    public ImageDatum getDatum() {
        return this.datum;
    }

    @Override
    public AffineCS getCoordinateSystem() {
        return (AffineCS)super.getCoordinateSystem();
    }

    @Override
    public DefaultImageCRS forConvention(AxesConvention axesConvention) {
        return (DefaultImageCRS)super.forConvention(axesConvention);
    }

    @Override
    final AbstractCRS createSameType(Map<String, ?> map, CoordinateSystem coordinateSystem) {
        return new DefaultImageCRS(map, this.datum, (AffineCS)coordinateSystem);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        if (formatter.getConvention().majorVersion() == 1) {
            formatter.setInvalidWKT(this, null);
        }
        return "ImageCRS";
    }

    private DefaultImageCRS() {
    }

    private void setDatum(ImageDatum imageDatum) {
        if (this.datum == null) {
            this.datum = imageDatum;
        } else {
            MetadataUtilities.propertyAlreadySet(DefaultImageCRS.class, "setDatum", "imageDatum");
        }
    }

    @XmlElement(name="cartesianCS")
    private CartesianCS getCartesianCS() {
        return this.getCoordinateSystem(CartesianCS.class);
    }

    @XmlElement(name="affineCS")
    private AffineCS getAffineCS() {
        return this.getCoordinateSystem(AffineCS.class);
    }

    private void setCartesianCS(CartesianCS cartesianCS) {
        this.setCoordinateSystem("cartesianCS", cartesianCS);
    }

    private void setAffineCS(AffineCS affineCS) {
        this.setCoordinateSystem("affineCS", affineCS);
    }
}

