/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import net.sourceforge.plantuml.version.License;
import net.sourceforge.plantuml.version.PSystemVersion;
import net.sourceforge.plantuml.version.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LicenseWindow
extends JFrame {
    public LicenseWindow() {
        this.setIconImage(PSystemVersion.getPlantumlSmallIcon2());
        this.setTitle("Licence PlantUML (" + Version.versionString() + ")");
        this.getContentPane().add((Component)this.getNorthLabel(), "North");
        ArrayList<String> arrayList = new ArrayList<String>(License.getCurrent().getText());
        this.getContentPane().add((Component)this.getJComponent(arrayList), "Center");
        this.getContentPane().add((Component)this.getSouthLabel(), "South");
        this.setSize(800, 600);
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
        this.setDefaultCloseOperation(2);
    }

    private JComponent getNorthLabel() {
        JLabel jLabel = new JLabel("PlantUML (" + Version.versionString() + ")");
        Font font = jLabel.getFont().deriveFont(1, 20.0f);
        jLabel.setFont(font);
        JPanel jPanel = new JPanel();
        jPanel.add(jLabel);
        JLabel jLabel2 = new JLabel(new ImageIcon(PSystemVersion.getPlantumlImage()));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "Center");
        jPanel2.add((Component)jLabel2, "East");
        return jPanel2;
    }

    private JComponent getSouthLabel() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LicenseWindow.this.dispose();
            }
        });
        jPanel.add(jButton);
        return jPanel;
    }

    private JComponent getJComponent(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder("<html>");
        for (String object2 : list) {
            stringBuilder.append(object2 + "</b></i></u>");
            stringBuilder.append("<br>");
        }
        stringBuilder.append("</html>");
        JEditorPane jEditorPane = new JEditorPane("text/html", stringBuilder.toString());
        jEditorPane.setEditable(false);
        CompoundBorder compoundBorder2 = new CompoundBorder(BorderFactory.createEtchedBorder(0), BorderFactory.createEmptyBorder(5, 5, 5, 5));
        compoundBorder2 = new CompoundBorder(BorderFactory.createMatteBorder(5, 5, 5, 5, this.getBackground()), compoundBorder2);
        jEditorPane.setBorder(compoundBorder2);
        final JScrollPane jScrollPane = new JScrollPane(jEditorPane, 22, 32);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                jScrollPane.getVerticalScrollBar().setValue(0);
            }
        });
        return jScrollPane;
    }

    public static void main(String[] stringArray) {
        new LicenseWindow();
    }
}

